<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'moodle', language 'cs', version '5.1'.
 *
 * @package     moodle
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['abouttobeinstalled'] = 'připraveno k instalaci';
$string['accept'] = 'Přijmout';
$string['action'] = 'Akce';
$string['actionchoice'] = 'Co chcete dělat se souborem "{$a}"?';
$string['actions'] = 'Akce';
$string['actionsfor'] = 'Akce pro {$a}';
$string['actionsmenu'] = 'Nabídka akcí';
$string['active'] = 'Aktivní';
$string['activeusers'] = 'Aktivní uživatelé';
$string['activities'] = 'Činnosti';
$string['activities_help'] = 'Činnosti, jako jsou fóra, testy a wiki, umožňují vkládat do kurzu interaktivní obsah.';
$string['activity'] = 'Činnost';
$string['activityclipboard'] = 'Přesun činnosti: {$a}';
$string['activityheader'] = 'Nabídka aktivity';
$string['activityicon'] = 'ikona {$a}';
$string['activityiscurrentlyhidden'] = 'Bohužel, tato činnost je momentálně skrytá';
$string['activitymodule'] = 'Modul činnosti';
$string['activitymodules'] = 'Moduly činností';
$string['activitynotready'] = 'Aktivita ještě není připravena';
$string['activityorresource'] = 'Aktivita nebo zdroj';
$string['activityreport'] = 'Sestava o činnosti';
$string['activityreports'] = 'Sestavy o činnosti';
$string['activityselect'] = 'Vybrat tuto činnost k přesunu';
$string['activitysince'] = 'Výpis od {$a}';
$string['activitytypetitle'] = '{$a->activity} - {$a->type}';
$string['activityweighted'] = 'Výpis podle uživatele';
$string['add'] = 'Přidat';
$string['addactivity'] = 'Přidat činnost...';
$string['addactivitytosection'] = 'Přidat činnost do sekce "{$a}"';
$string['addadmin'] = 'Přidat správce';
$string['addblock'] = 'Přidat blok';
$string['addcomment'] = 'Přidat komentář...';
$string['addcondition'] = 'Přidat podmínku';
$string['addcontent'] = 'Přidat obsah';
$string['addcountertousername'] = 'Vytvořit uživatele a přidat číslo k uživatelskému jménu';
$string['addcreator'] = 'Přidat tvůrce kurzů';
$string['adddots'] = 'Přidat...';
$string['added'] = 'Přidána činnost ({$a})';
$string['addedtogroup'] = 'Přidán do skupiny {$a}';
$string['addedtogroupnot'] = 'Nepřidán do skupiny {$a}';
$string['addedtogroupnotenrolled'] = 'Nepřidán do skupiny {$a}, protože není zapsán do kurzu';
$string['addfilehere'] = 'Sem přetáhnout soubory a přidat je na konec této sekce';
$string['addfilesdrop'] = 'Soubory zde můžete nahrát přetažením nebo kliknutím vybrat.';
$string['addinganew'] = 'Nová ({$a})';
$string['addingdatatoexisting'] = 'Přidání údajů ke stávajícím';
$string['additionalcustomnav'] = 'Další vlastní navigace';
$string['additionalnames'] = 'Další jména';
$string['addlinkhere'] = 'Přidat odkaz';
$string['addnew'] = 'Přidat nový {$a}';
$string['addnewcategory'] = 'Přidat novou kategorii';
$string['addnewcourse'] = 'Přidat nový kurz';
$string['addnewuser'] = 'Přidat nového uživatele';
$string['addnousersrecip'] = 'Přidat na seznam příjemců uživatele, kteří si ještě neotevřeli toto {$a}';
$string['addpagehere'] = 'Přidat text';
$string['addresource'] = 'Přidat studijní materiál...';
$string['addresourceoractivity'] = 'Přidat činnost nebo studijní materiál';
$string['addresourcetosection'] = 'Přidat materiál do sekce "{$a}"';
$string['address'] = 'Adresa';
$string['addsections'] = 'Přidat sekce';
$string['addstudent'] = 'Přidat studenta';
$string['addsubcategory'] = 'Přidat podkategorii';
$string['addteacher'] = 'Přidat učitele';
$string['admin'] = 'Správa';
$string['adminhelpaddnewuser'] = 'Manuální vytvoření nového uživatelského účtu';
$string['adminhelpassignadmins'] = 'Správci mají kamkoliv přístup a mohou provádět nastavení systému';
$string['adminhelpassigncreators'] = 'Tvůrci mohou zakládat nové kurzy';
$string['adminhelpassignsiteroles'] = 'Aplikovat definované role pro website na konkrétní uživatele';
$string['adminhelpassignstudents'] = 'Vstupte do kurzu, v nabídce Správa vyberte položku Studenti a zapište je';
$string['adminhelpauthentication'] = 'Způsob vytváření a autorizace uživatelů';
$string['adminhelpbackup'] = 'Nastavení automatického zálohování a jeho časový plán';
$string['adminhelpconfiguration'] = 'Nastavte, jak budou stránky vypadat a pracovat';
$string['adminhelpconfigvariables'] = 'Obecné parametry ovlivňující funkci systému';
$string['adminhelpcourses'] = 'Seznam dostupných kurzů a kategorií, úprava kurzů čekajících na schválení';
$string['adminhelpeditorsettings'] = 'Základní nastavení HTML editoru';
$string['adminhelpedituser'] = 'Úpravy uživatelských účtů (seznam všech účtů)';
$string['adminhelpenvironment'] = 'Kontrola stávajících a budoucích požadavků na váš server';
$string['adminhelpfailurelogs'] = 'Zobrazit protokol o neúspěšných přihlášeních';
$string['adminhelplanguage'] = 'Kontrola a úpravy instalovaných lokalizací';
$string['adminhelplogs'] = 'Procházet protokol o činnosti na stránkách';
$string['adminhelpmanageblocks'] = 'Správa nainstalovaných bloků a jejich nastavení';
$string['adminhelpmanagedatabase'] = 'Přímý přístup do databáze (hlavně opatrně!)';
$string['adminhelpmanagefilters'] = 'Správa textových filtrů a jejich nastavení';
$string['adminhelpmanagemodules'] = 'Správa nainstalovaných modulů a jejich nastavení';
$string['adminhelpmanageroles'] = 'Vytvořit a definovat role, které lze aplikovat na uživatele.';
$string['adminhelpmymoodle'] = 'Nastavení uživatelských bloků Můj Moodle';
$string['adminhelpreports'] = 'Sestavy na úrovni celých stránek';
$string['adminhelpsitefiles'] = 'Obecně použitelné soubory a místo pro upload externích záloh';
$string['adminhelpsitesettings'] = 'Nastavení vzhledu titulní stránky';
$string['adminhelpstickyblocks'] = 'Nastavení povinných bloků';
$string['adminhelpthemes'] = 'Nastavení vzhledu stránek (barvy, fonty apod.)';
$string['adminhelpuploadusers'] = 'Import uživatelských účtů z textového souboru';
$string['adminhelpusers'] = 'Správa uživatelů a nastavení autentizace';
$string['adminhelpxmldbeditor'] = 'Rozhraní pro úpravu XMLDB souborů. Jen pro vývojáře.';
$string['administration'] = 'Správa';
$string['administrationsite'] = 'Správa stránek';
$string['administrator'] = 'Správce';
$string['administratordescription'] = 'Správci obvykle mohou na stránkách dělat cokoli a ve všech kurzech.';
$string['administrators'] = 'Správci';
$string['administratorsall'] = 'Všichni správci';
$string['administratorsandteachers'] = 'Správci a učitelé';
$string['advanced'] = 'Pokročilé';
$string['advancedfilter'] = 'Pokročilé hledání';
$string['advancedsettings'] = 'Pokročilá nastavení';
$string['afterresource'] = 'Za materiál  "{$a}"';
$string['aftersection'] = 'Za sekci  "{$a}"';
$string['again'] = 'znovu';
$string['agelocationverification'] = 'Ověření věku a polohy';
$string['ajaxuse'] = 'AJAX a Javascript';
$string['all'] = 'Vše';
$string['allactions'] = 'Všechny akce';
$string['allactivities'] = 'Všechny činnosti';
$string['allcategories'] = 'Všechny kategorie';
$string['allchanges'] = 'Všechny změny';
$string['alldays'] = 'Všechny dny';
$string['allfiles'] = 'Všechny soubory';
$string['allgroups'] = 'Všechny skupiny';
$string['alllogs'] = 'Všechny protokoly';
$string['allmods'] = 'Všechny {$a}';
$string['allow'] = 'Povolit';
$string['allowinternal'] = 'Povolit také interní metody';
$string['allownone'] = 'Nepovolit žádné';
$string['allownot'] = 'Nepovolit';
$string['allowstealthmodules'] = 'Povolte neviditelné činnosti';
$string['allowstealthmodules_help'] = 'Je-li tato volba povolena, mohou být činnosti zpřístupněny, ale nejsou zobrazeny ve viditelných částech stránky kurzu. Pokud to tak je, odkazy na neviditelné činnosti musí být poskytnuty z jiných zdrojů, například ze stránek materiálů. Skryté činnosti jsou nadále uvedeny v přehledu známek a dalších sestav.';
$string['allparticipants'] = 'Všichni účastníci';
$string['allteachers'] = 'Všichni učitelé';
$string['alphanumerical'] = 'Může obsahovat jen znaky abecedy, číslice, pomlčku (-) a tečku (.)';
$string['alreadyconfirmed'] = 'Registrace již byla potvrzena';
$string['alternatename'] = 'Alternativní jméno';
$string['always'] = 'Vždy';
$string['and'] = '{$a->one} a {$a->two}';
$string['answer'] = 'Odpověď';
$string['any'] = 'Jakýkoliv';
$string['appearance'] = 'Vzhled';
$string['apply'] = 'Aplikovat';
$string['applyfilters'] = 'Použít filtry';
$string['approve'] = 'Schválit';
$string['areyousure'] = 'Opravdu?';
$string['areyousuretorestorethis'] = 'Přejete si pokračovat?';
$string['areyousuretorestorethisinfo'] = 'Později v procesu obnovy kurzu se budete moci rozhodnout, zda chcete data ze zálohy přidat k již existujícímu kurzu, nebo z nich vytvořit nový kurz.';
$string['asc'] = 'Vzestupně';
$string['assessment'] = 'Hodnocení';
$string['assignadmins'] = 'Přiřadit správce';
$string['assigncreators'] = 'Přiřadit tvůrce kurzů';
$string['assignedrolecount'] = '{$a->role}: {$a->count}';
$string['assignsiteroles'] = 'Přiřadit role pro celou website';
$string['authenticateduser'] = 'Registrovaný uživatel';
$string['authenticateduserdescription'] = 'Všichni uživatelé, kteří mají účet';
$string['authentication'] = 'Metoda ověřování';
$string['authenticationplugins'] = 'Autentizační moduly';
$string['autosubscribe'] = 'Automatické odebírání příspěvků e-mailem';
$string['autosubscribeno'] = 'Ne: nenastavovat automaticky odebírání diskuse';
$string['autosubscribeyes'] = 'Ano: pokud pošlu příspěvek, chci diskuse fóra odebírat';
$string['availability'] = 'Dostupnost';
$string['availablecourses'] = 'Dostupné kurzy';
$string['back'] = 'Zpět';
$string['backto'] = 'Zpět k {$a}';
$string['backtocourselisting'] = 'Zpět na seznam kurzů';
$string['backtohome'] = 'Zpět na titulní stránku';
$string['backtopageyouwereon'] = 'Zpět na původní stránku';
$string['backup'] = 'Záloha';
$string['backupactivehelp'] = 'Zvolte, zda provádět automatické zálohování';
$string['backupadhocpending'] = 'Probíhá úloha adhoc zálohování kurzu';
$string['backupcancelled'] = 'Zálohování přerušeno';
$string['backupcoursefileshelp'] = 'Zahrnout do automatických záloh soubory z kurzů';
$string['backupdate'] = 'Datum zálohy';
$string['backupdatenew'] = '{$a->TAG} nyní je {$a->weekday}, {$a->mday} {$a->month} {$a->year}<br />';
$string['backupdateold'] = '{$a->TAG} bylo {$a->weekday}, {$a->mday} {$a->month} {$a->year}';
$string['backupdaterecordtype'] = '<br />{$a->recordtype} - {$a->recordname}<br />';
$string['backupdetails'] = 'Podrobnosti zálohy';
$string['backuperrorinvaliddestination'] = 'Složka pro zálohování neexistuje nebo není zapisovatelná.';
$string['backupexecuteathelp'] = 'Zvolte, v jakém čase se má provádět automatická záloha';
$string['backupfailed'] = 'Některé z kurzů nebyly uloženy.';
$string['backupfilename'] = 'zaloha';
$string['backupfinished'] = 'Záloha úspěšně ukončena';
$string['backupfromthissite'] = 'Záloha vytvořena na těchto stránkách?';
$string['backupgradebookhistoryhelp'] = 'Je-li povoleno, bude historie známek zahrnuta v automaticky vytvářených zálohách. Zkontrolujte si také, že nemáte historii známek zakázánu v nastavení serveru (proměnná  disablegradehistory).';
$string['backupincludemoduleshelp'] = 'Vyberte, zda chcete do automatických záloh zahrnout moduly kurzu, s daty uživatelů nebo bez nich';
$string['backupincludemoduleuserdatahelp'] = 'Zvolte, zda do automatických záloh chcete zahrnout data modulu';
$string['backupinfo'] = 'Vytvořte si kopii tohoto kurzu, včetně veškerého aktuálního obsahu a aktivit. Záložní soubor můžete použít k obnovení tohoto kurzu.';
$string['backuplogdetailed'] = 'Podrobný protokol';
$string['backuploglaststatus'] = 'Poslední protokol';
$string['backupmissinguserinfoperms'] = 'Poznámka: Tato záloha neobsahuje data uživatelů. Modul Workshop (a případně Cvičení) nebude do zálohy zahrnut, protože není s tímto typem zálohy kompatibilní.';
$string['backupnext'] = 'Příští záloha';
$string['backupnonisowarning'] = 'Upozornění: Tato záloha pochází z verze Moodlu, která ještě nepodporovala kódování Unicode (toto kódování je podporováno od verze 1.6). Pokud tato záloha obsahuje  znaky jiné než ISO-8859-1 (např. česká písmena), mohou být texty při obnově do Unicode verze Moodlu POŠKOZENY. Více informací o korektním způsobu obnovy takové zálohy najdete na stránce  <a href="https://docs.moodle.org/en/Backup_FAQ"> Časté dotazy týkající se zálohování </a>.';
$string['backupnotyetrun'] = 'Čekání na automatické zálohování';
$string['backuporiginalname'] = 'Název zálohy';
$string['backuproleassignments'] = 'Zálohovat přiřazení rolí pro tyto role';
$string['backupsavetohelp'] = 'Úplná cesta k adresáři, do něhož chcete ukládat soubory záloh';
$string['backupsitefileshelp'] = 'Je-li povoleno, budou soubory stránek použité v kurzech zahrnuty v zálohách kurzů';
$string['backuptakealook'] = 'Zkontrolujte prosím protokoly záloh: {$a}';
$string['backupuserfileshelp'] = 'Zahrnout do automatických záloh soubory uživatelů (např. jejich fotografie)';
$string['backupversion'] = 'Verze zálohy';
$string['badges'] = 'Odznaky';
$string['between'] = 'Mezi';
$string['block'] = 'Blok';
$string['blockconfiga'] = 'Konfigurace bloku {$a}';
$string['blockconfigbad'] = 'Tento blok nebyl korektně implementován a nemá proto  konfigurační rozhraní';
$string['blocks'] = 'Bloky';
$string['blocks_main'] = 'Bloky hlavního obsahu';
$string['blocks_supplementary'] = 'Doplňkové bloky';
$string['blocksaddedit'] = 'Přidat/Upravit bloky';
$string['blockseditoff'] = 'Vypnout úpravu bloků';
$string['blocksediton'] = 'Zapnout úpravu bloků';
$string['blocksetup'] = 'Nastavení bloků';
$string['blocksuccess'] = 'Tabulky bloku \'"{$a}" byly korektně nastaveny';
$string['brief'] = 'Stručný';
$string['bulkactions'] = 'Hromadné akce';
$string['bulkactionselect'] = '{$a} výběr hromadné operace';
$string['bulkcancel'] = 'Zavřít hromadné úpravy';
$string['bulkmovecoursessuccess'] = 'Úspěšně přesunuto {$a->courses} kurzů do {$a->category}';
$string['bulkselection'] = 'Vybráno: {$a}';
$string['bycourseorder'] = 'Pořadí v kurzu';
$string['byname'] = 'od {$a}';
$string['bypassed'] = 'Přeskočeno';
$string['cachecontrols'] = 'Řízení mezipaměti';
$string['calltofeedback'] = 'Tvůrci tohoto softwaru by chtěli vaši zpětnou vazbu.';
$string['calltofeedback_give'] = 'Poskytnout zpětnou vazbu o tomto softwaru';
$string['calltofeedback_remind'] = 'Připomenout později';
$string['cancel'] = 'Zrušit';
$string['cancelled'] = 'Zrušeno';
$string['categories'] = 'Kategorie kurzů';
$string['categoriesandcourses'] = 'Kategorie kurzů a kurzy';
$string['category'] = 'Kategorie';
$string['categoryadded'] = 'Kategorie "{$a}" byla přidána';
$string['categorybulkaction'] = 'Hromadné operace pro vybrané kategorie';
$string['categorycontents'] = 'Podkategorie a kurzy';
$string['categorycurrentcontents'] = 'Obsah kategorie {$a}';
$string['categorydeleted'] = 'Kategorie "{$a}" byla odstraněna';
$string['categoryduplicate'] = 'Kategorie "{$a}" již existuje!';
$string['categoryheader'] = 'Nabídka kategorie';
$string['categoryhidden'] = '(skryté)';
$string['categorymodifiedcancel'] = 'Kategorie byla změněna! Prosíme, zrušte momentální operaci a zkuste ji znovu.';
$string['categoryname'] = 'Název kategorie';
$string['categorypath'] = 'Cesta kategorie';
$string['categorysubcategoryof'] = '{$a->category} - podkategorie v {$a->parentcategory}';
$string['categoryupdated'] = 'Kategorie "{$a}" byla aktualizována';
$string['changedpassword'] = 'Heslo změněno';
$string['changepassword'] = 'Změnit heslo';
$string['changesmade'] = 'Provedené změny';
$string['changesmadereallygoaway'] = 'Provedli jste změny. Jste si jisti, že chcete odejít pryč a ztratit všechny změny?';
$string['changessaved'] = 'Změny uloženy';
$string['check'] = 'Prověřit';
$string['checkactual'] = 'Aktuální';
$string['checkall'] = 'Prověřit vše';
$string['checkerror'] = 'Chyba při získávání výsledku kontroly "{$a}". Další informace naleznete v konzole prohlížeče.';
$string['checkexpected'] = 'Očekávaný';
$string['checkingbackup'] = 'Prověřuji zálohu';
$string['checkingcourse'] = 'Prověřuji kurzy';
$string['checkingforbbexport'] = 'Prověřuji BlackBoard export';
$string['checkinginstances'] = 'Prověřuji instance';
$string['checkingsections'] = 'Prověřuji sekce';
$string['checklanguage'] = 'Prověřit jazyk';
$string['checkloading'] = 'Získání výsledku kontroly "{$a}"';
$string['checknone'] = 'Neprověřovat nic';
$string['checks'] = 'Kontroly';
$string['checksok'] = 'Všechny "{$a}" kontroly jsou v pořádku';
$string['childcoursenotfound'] = 'Asociovaný kurz nenalezen!';
$string['childcourses'] = 'Asociované kurzy';
$string['choose'] = 'Vybrat';
$string['choosecourse'] = 'Vyberte kurz';
$string['choosedots'] = 'Vyberte...';
$string['chooselivelogs'] = 'Online sledování probíhající činnosti';
$string['chooselogs'] = 'Zobrazení protokolu o činnosti';
$string['choosereportfilter'] = 'Vyberte filtr sestavy';
$string['choosetheme'] = 'Vyberte motiv';
$string['chooseuser'] = 'Vyberte uživatele';
$string['city'] = 'Město/obec';
$string['cleaningtempdata'] = 'Odstraňování dočasných údajů';
$string['clear'] = 'Vyčistit';
$string['clearall'] = 'Vymazat vše';
$string['clearfilterrow'] = 'Odstranit řádek filtru';
$string['clearfilters'] = 'Vymazat filtry';
$string['clearsearch'] = 'Vymazat vstup vyhledávání';
$string['clickhelpiconformoreinfo'] = '... pokračuje ... Klikněte na nápovědu pro více informací';
$string['clickhere'] = 'Klikněte zde...';
$string['clicktohideshow'] = 'Klikněte pro rozbalení nebo sbalení';
$string['closeblockdrawer'] = 'Zavřít panel  bloku';
$string['closebuttontitle'] = 'Zavřít';
$string['closecourseindex'] = 'Zavřít indexu kurzu';
$string['closedrawer'] = 'Zavřít lištu';
$string['closewindow'] = 'Zavřít toto okno';
$string['collapse'] = 'Sbalit';
$string['collapseall'] = 'Sbalit vše';
$string['collapsecategory'] = 'Sbalit {$a}';
$string['comebacklater'] = 'Vraťte se prosím později.';
$string['commentincontext'] = 'Najít tento komentář v kontextu';
$string['comments'] = 'Komentáře';
$string['commentscount'] = 'Komentáře ({$a})';
$string['commentsnotenabled'] = 'Komentáře nejsou povoleny';
$string['commentsrequirelogin'] = 'Pro zobrazení komentářů musíte být přihlášeni.';
$string['comparelanguage'] = 'Porovnat a upravit současný jazyk';
$string['complete'] = 'Splněno';
$string['completed'] = 'Dokončeno';
$string['completereport'] = 'Podrobná sestava';
$string['configuration'] = 'Nastavení';
$string['confirm'] = 'Potvrdit';
$string['confirmaccount'] = 'Potvrdit účet';
$string['confirmcheckfull'] = 'Jste si jisti, že chcete potvrdit {$a}?';
$string['confirmcoursemove'] = 'Jste si jisti, že chcete přesunout kurz ({$a->course}) do kategorie ({$a->category})?';
$string['confirmdeletesection'] = 'Jste si jisti, že chcete odstranit "{$a}" a také veškeré činnosti, které obsahuje?';
$string['confirmed'] = 'Vaše registrace byla potvrzena';
$string['confirmednot'] = 'Vaše registrace ještě nebyla potvrzena! Zkontrolujte potvrzovací e-mail v poštovní schránce.';
$string['considereddigitalminor'] = 'Jste příliš mladý/á, abyste na těchto stránkách vytvořili účet.';
$string['contactsbyrolelist'] = '{$a->role}: {$a->contacts}';
$string['content'] = 'Obsah';
$string['contentbank'] = 'Banka obsahu';
$string['contentexport_aboutthiscourse'] = 'Shrnutí kurzu';
$string['contentexport_coursesummary'] = 'Tento soubor je součástí obsahu staženého z  <a href="{$a->courselink}">{$a->coursename}</a>.';
$string['contentexport_footersummary'] = 'Tento soubor je součástí obsahu staženého z <a href="{$a->courselink}">{$a->coursename}</a> od {$a->userfullname} dne {$a->date}.';
$string['contentexport_modulesummary'] = 'Tento soubor je součástí obsahu staženého z <a href="{$a->courselink}">{$a->coursename}</a> od {$a->userfullname} dne {$a->date}. Všimněte si, že se obsah a některé soubory větší než {$a->maxfilesize}  nestáhnou.';
$string['contentexport_viewfilename'] = 'Zobrazit soubor {$a}';
$string['context'] = 'Kontext';
$string['contextlevel'] = 'Úroveň kontextu';
$string['contextname'] = 'Název kontextu';
$string['contextparent'] = 'Rodič';
$string['contexturl'] = 'Kontextová adresa URL';
$string['continue'] = 'Pokračovat';
$string['continuetocourse'] = 'Klikněte zde pro vstup do kurzu';
$string['convertingwikitomarkdown'] = 'Převádím formát Wiki na Markdown';
$string['cookiesenabled'] = 'Ve svém prohlížeči musíte povolit cookies';
$string['cookiesenabled_help'] = 'Tyto stránky používají dva soubory cookie.

Hlavním používaným souborem cookie je soubor relace, který se obvykle nazývá MoodleSession<. Tento soubor cookie je třeba povolit v prohlížeči,
zajišťuje kontinuitu vaší práce v systému a udržuje informace o vašem
přihlášení. Při odhlášení nebo ukončení prohlížeče je tento soubor cookie
zničen (ve vašem prohlížeči a na serveru).

Druhý soubor cookie pouze usnadňuje uživateli práci, obvykle se nazývá
MOODLEID nebo podobně. Jen si pamatuje vaše uživatelské jméno v prohlížeči.
To znamená, že při návratu na tyto stránky bude pole s uživatelským jménem na
stránce přihlášení již vyplněno. Tento soubor cookie je možné zakázat. Při
každém přihlášení však budete muset zadat své uživatelské jméno.';
$string['cookiesenabled_help_html'] = 'Na tomto webu se používají dva soubory cookie:<br/><br/>

Tím zásadním je soubor cookie relace, obvykle nazývaný MoodleSession. Tento soubor cookie musíte ve svém prohlížeči povolit, abyste zajistili kontinuitu a zůstali přihlášeni při procházení stránek. Když se odhlásíte nebo zavřete prohlížeč, tento soubor cookie bude zničen (ve vašem prohlížeči a na serveru).<br/><br/>

Další cookie je čistě pro pohodlí, obvykle se nazývá MOODLEID nebo podobně. Pamatuje si pouze vaše uživatelské jméno v prohlížeči. To znamená, že když se vrátíte na tuto stránku, pole uživatelského jména na přihlašovací stránce je již za vás vyplněno. Tento soubor cookie je bezpečné odmítnout – při každém přihlášení budete muset znovu zadat své uživatelské jméno.';
$string['cookiesenabledonlysession'] = 'Ve svém prohlížeči musíte povolit cookies';
$string['cookiesenabledonlysession_help'] = 'Tato stránka používá jeden cookie relace, obvykle nazvaný MoodleSession. Tento soubor cookie musíte ve svém prohlížeči povolit, zajistit kontinuitu a zůstat při procházení stránek přihlášen. Při odhlášení nebo zavření prohlížeče je tento soubor cookie zničen (ve vašem prohlížeči a na serveru).';
$string['cookiesnotenabled'] = 'Bohužel, ve vašem prohlížeči nejsou momentálně povolena cookies.';
$string['cookiesnotice'] = 'Upozornění na cookie';
$string['copy'] = 'kopírovat';
$string['copyasnoun'] = 'kopie';
$string['copycourse'] = 'Kopírovat kurz';
$string['copyingcoursefiles'] = 'Kopíruji soubory kurzu';
$string['copyingsitefiles'] = 'Kopírování souborů stránek použitých v kurzech';
$string['copyinguserfiles'] = 'Kopíruji soubory uživatele';
$string['copyingzipfile'] = 'Kopíruji soubor ZIP';
$string['copyrightnotice'] = 'Autorská práva';
$string['copytoclipboard'] = 'Zkopírovat do schránky';
$string['coresystem'] = 'Základní systém';
$string['cost'] = 'Cena';
$string['costdefault'] = 'Výchozí cena';
$string['count_of_total'] = '<strong>{$a->count}</strong> z {$a->total}';
$string['counteditems'] = '{$a->items}: {$a->count}';
$string['country'] = 'Země';
$string['course'] = 'Kurz';
$string['courseadministration'] = 'Správa kurzu';
$string['courseapprovedemail'] = 'Váš požadovaný kurz je schválen, <a href="{$a->url}">{$a->name}</a>, a vy jste {$a->teacher}.';
$string['courseapprovedemail2'] = 'Váš požadovaný kurz je schválen: <a href="{$a->url}">{$a->name}</a>.';
$string['courseapprovedfailed'] = 'Selhalo uložení kurzu jako schváleného!';
$string['courseapprovedsubject'] = 'Váš kurz byl schválen.';
$string['courseavailable'] = 'Tento kurz je studentům dostupný';
$string['courseavailablenot'] = 'Tento kurz není studentům dostupný';
$string['coursebackup'] = 'Zálohovat kurz';
$string['coursebulkaction'] = 'Hromadné operace pro vybrané kurzy';
$string['coursecategories'] = 'Kategorie kurzů';
$string['coursecategory'] = 'Kategorie kurzu';
$string['coursecategory_help'] = '<p>Správce těchto stránek může nastavit několik kategorií čili skupin
kurzů.</p>

<p>Například "Volitelné kurzy" nebo "Povinné kurzy" apod.</p>

<p>Vyberte nejvhodnější kategorii pro váš kurz. Tato volba ovlivňuje umístění
vašeho kurzu v seznamu kurzů a pomůže studentům váš kurz najít.</p>';
$string['coursecategorydeleted'] = 'Odstraněná kategorie kurzů {$a}';
$string['coursecatmanagement'] = 'Správa kurzů a kategorií';
$string['coursecompletion'] = 'Absolvování kurzu';
$string['coursecompletions'] = 'Absolvování kurzů';
$string['coursecreators'] = 'Tvůrce kurzu';
$string['coursecreatorsdescription'] = 'Tvůrci kurzu mohou zakládat nové kurzy.';
$string['coursedeleted'] = 'Odstraněný kurz {$a}';
$string['coursedetails'] = 'Podrobnosti kurzu';
$string['coursedisplay'] = 'Zobrazení sekcí';
$string['coursedisplay_help'] = 'Sekce kurzu lze zobrazit všechny na jedné stránce nebo rozdělit na několik stránek.';
$string['coursedisplay_multi'] = 'Zobrazit jedno téma na stránku';
$string['coursedisplay_single'] = 'Zobrazit všechna témata na stránku';
$string['courseduration'] = 'Délka kurzu';
$string['courseduration_desc'] = 'Doba trvání kurzu se používá k výpočtu data k výchozímu datu skončení kurzu. Datum skončení kurzu se používá k určení, zda má být kurz zařazen do seznamu kurzů uživatele. Může být použito také ve vlastních sestavách. Uživatelé mohou po datu ukončení v kurzu stále pokračovat.';
$string['courseenddateenabled'] = 'Datum ukončení kurzu je standardně povoleno';
$string['courseenddateenabled_desc'] = 'Toto nastavení určuje, zda bude výchozí nastavení kurzu zapnuto pro nové kurzy a nastaveno na datum vypočtené z trvání kurzu.';
$string['courseextendednamedisplay'] = '{$a->shortname} {$a->fullname}';
$string['coursefiles'] = 'Staré soubory kurzu';
$string['coursefilesedit'] = 'Upravit soubory kurzu';
$string['coursefileswarning'] = 'Soubory kurzu jsou zastaralé';
$string['coursefileswarning_help'] = 'Soubory kurzu byly ve verzi Moodle 2.0 nahrazeny systémem externích repozitářů. Prosím, používejte přednostně tento nový přístup.';
$string['courseformatdata'] = 'Formát dat kurzu';
$string['courseformatoptions'] = 'Volby formátování pro {$a}';
$string['courseformats'] = 'Uspořádání kurzu';
$string['courseformatudpate'] = 'Aktualizace formátu';
$string['coursegrades'] = 'Známky kurzu';
$string['courseheader'] = 'Nabídka kurzu';
$string['coursehelpcategory'] = 'Ovlivňuje umístění kurzu v seznamu všech kurzů a pomáhá studentům najít správný kurz.';
$string['coursehelpforce'] = 'Vnutit režim skup nastavený v kurzu pro všechny moduly činností';
$string['coursehelpformat'] = 'V tomto uspořádání se zobrazí hlavní stránka kurzu.';
$string['coursehelphiddensections'] = 'Jak se mají zobrazovat skryté sekce kurzu (např. témata či týdny) studentům.';
$string['coursehelpmaximumupload'] = 'Určuje maximální velikost souboru, který budou moci studenti vložit do tohoto kurzu. Velikost je limitována nastavením serveru.';
$string['coursehelpnewsitemsnumber'] = 'Počet posledních oznámení zobrazovaných na domovské stránce kurzu v postranním bloku posledních oznámení. Je-li nastavena nula,  blok se vůbec nezobrazí.';
$string['coursehelpnumberweeks'] = 'Počet sekcí kurzu (platí pouze pro některá uspořádání)';
$string['coursehelpshowgrades'] = 'Povolit zobrazení modulu klasifikace v nabídce Správa > Známky. Tímto se neovlivňuje zobrazování známek v rámci dílčích modulů činností.';
$string['coursehidden'] = 'Tento kurz není momentálně studentům dostupný.';
$string['courseinfo'] = 'Informace o kurzu';
$string['courselegacyfiles'] = 'Soubory kurzu';
$string['courselegacyfiles_help'] = 'Oblast Soubory kurzu poskytuje zpětnou kompatibilitu se správou souborů v Moodle 1.9 a dřívějších verzích. Všechny soubory v této oblasti jsou vždy dostupné všem účastníkům kurzu, ať už je někde v kurzu skutečně používáte či ne. Neexistuje způsob, jak zjistit, které z těchto souborů jsou používány.

Pokud se rozhodnete i nadále používat tento zastaralý způsob práce se soubory, vystavujete se řadě nebezpečí neoprávněného přístupu k osobním informacím a bezpečnostním rizikům. Můžete též zaznamenat chybějící soubory v zálohách kurzů, chyby při importu jiných kurzů a vůbec kdykoliv, kdy je obsah kurzu sdílen a/nebo kopírován. Je proto silně doporučováno tuto oblast nepoužívat, dokud si nejste zcela jisti, co děláte.';
$string['courselegacyfiles_link'] = 'coursefiles2';
$string['courselegacyfilesofcourse'] = 'Soubory kurzu: {$a}';
$string['coursenotaccessible'] = 'Tento kurz není veřejně přístupný';
$string['courseoverview'] = 'Přehled kurzů';
$string['courseoverviewfiles'] = 'Obrázek kurzu';
$string['courseoverviewfiles_help'] = 'Obrázek kurzu se zobrazí v části Moje kurzy a v seznamu dostupných kurzů na domovské stránce. Správci webu mohou povolit další typy souborů a použití více souborů. Pokud používáte více souborů, zobrazí se všechny v seznamu dostupných kurzů na domovské stránce.';
$string['courseoverviewfilesext'] = 'Přípony souborů obrázku kurzu';
$string['courseoverviewfileslimit'] = 'Limit počtu souborů obrázků kurzu';
$string['courseoverviewgraph'] = 'Graf přehledu kurzu';
$string['courseprofiles'] = 'Profily v kurzu';
$string['coursereasonforrejecting'] = 'Důvod pro zamítnutí této žádosti';
$string['coursereasonforrejectingemail'] = 'Bude odesláno e-mailem žadateli';
$string['coursereject'] = 'Zamítnout požadavek';
$string['courserejected'] = 'Kurz byl zamítnut a žadatel byl informován.';
$string['courserejectemail'] = 'Je mi líto, ale váš požadavek na založení kurzu byl zamítnut z následujících důvodů:

{$a}';
$string['courserejectreason'] = 'Uveďte důvody pro zamítnutí tohoto požadavku. Důvody budou odeslány na e-mail žadatele.<br />(Doporučujeme nepoužívat české znaky.)';
$string['courserejectsubject'] = 'Váš kurz byl zamítnut';
$string['coursereport'] = 'Sestava o kurzu';
$string['coursereports'] = 'Sestavy kurzu';
$string['courserequest'] = 'Žádost o založení kurzu';
$string['courserequestdetails'] = 'Podrobnosti o požadovaném kurzu';
$string['courserequestfailed'] = 'Z nějakého důvodu se nepodařilo uložit vaši žádost o založení kurzu.';
$string['courserequestintro'] = 'Pomocí tohoto formuláře požádejte o založení kurzu.<br />Uveďte prosím co nejvíce informací, tak aby správcům stránek bylo<br />zřejmé, jaké jsou vaše důvody pro založení tohoto kurzu.';
$string['courserequestreason'] = 'Důvody požadavku na založení kurzu';
$string['courserequestroleerror'] = 'Role tvůrců v konfiguraci nových kurzů je neplatná. Přečtěte si prosím <a href="{$a}">zásady pro uživatele</a>.';
$string['courserequestsuccess'] = 'Žádost o kurz odeslána.';
$string['courserequestsupport'] = 'Doplňující informace, které pomohou správcům posoudit vaši žádost';
$string['courserequestwarning'] = 'Uživatel požadující tento kurz bude automaticky zapsán s přiřazenou rolí "{$a}"';
$string['courserestore'] = 'Obnova kurzu';
$string['coursereuse'] = 'Opětovné použití kurzu';
$string['coursereusenavigationmenu'] = 'Navigace v nabídce opětovného použití kurzu';
$string['courses'] = 'Kurzy';
$string['coursesectionsummaries'] = 'Úvodní texty sekcí kurzu';
$string['coursesectiontitle'] = '{$a->sectionname}: {$a->sectiontitle} | {$a->course}';
$string['coursesectiontitlebulkediting'] = 'Hromadná úprava {$a->sectionname}: {$a->sectiontitle} | {$a->course}';
$string['coursesectiontitleediting'] = 'Upravit {$a->sectionname}: {$a->sectiontitle} | {$a->course}';
$string['coursesettings'] = 'Výchozí nastavení kurzu';
$string['coursesmovedout'] = 'Kurzy přesunuty z {$a}';
$string['coursespending'] = 'Kurzy čekající na schválení';
$string['coursestart'] = 'Začátek kurzu';
$string['coursesummary'] = 'Shrnutí kurzu';
$string['coursesummary_help'] = 'Krátký popis vašeho kurzu. Obsah, který sem přidáte, lze prohledávat.';
$string['coursetitle'] = 'Kurz: {$a->course}';
$string['coursetitlebulkediting'] = 'Hromadná úprava kurzu: {$a->course}';
$string['coursetitleediting'] = 'Upravit kurz: {$a->course}';
$string['courseupdates'] = 'Aktualizace kurzu';
$string['coursevisibility'] = 'Viditelnost kurzu';
$string['coursevisibility_help'] = '* Zobrazit: Kurz se objeví v seznamu kurzů a studenti k němu mají přístup.
* Skrýt: Přístup je omezen na učitele a další uživatele s možností zobrazit skryté kurzy.';
$string['create'] = 'Vytvořit';
$string['createaccount'] = 'Vytvořit můj nový účet';
$string['createcategory'] = 'Vytvořit kategorii';
$string['createfolder'] = 'Vytvořit složku v "{$a}"';
$string['createnew'] = 'Vytvořit novou';
$string['createnewcategory'] = 'Vytvořit novou kategorii';
$string['createnewcourse'] = 'Vytvořit nový kurz';
$string['createnewsubcategory'] = 'Vytvořit novou podkategorii';
$string['createsubcategoryof'] = 'Vytvořit podkategorii v {$a}';
$string['createuser'] = 'Vytvořit uživatele';
$string['createziparchive'] = 'Vytvořit ZIP archív';
$string['creatingblocks'] = 'Vytvářím bloky';
$string['creatingblocksroles'] = 'Přiřazení rolí a lokálních přenastavení na úrovni bloků';
$string['creatingblogsinfo'] = 'Vytvářím informace blogů';
$string['creatingcategoriesandquestions'] = 'Vytvářím kategorie a otázky';
$string['creatingcoursemodules'] = 'Vytvářím moduly kurzu';
$string['creatingcourseroles'] = 'Přiřazení rolí a lokálních přenastavení na úrovni kurzu';
$string['creatingevents'] = 'Vytvářím události';
$string['creatinggradebook'] = 'Vytvářím klasifikaci';
$string['creatinggroupings'] = 'Vytvářím seskupení';
$string['creatinggroupingsgroups'] = 'Přidávám skupiny do seskupení';
$string['creatinggroups'] = 'Vytvářím skupiny';
$string['creatinglogentries'] = 'Vytvářím položky protokolu';
$string['creatingmessagesinfo'] = 'Vytvářím informace o zprávách';
$string['creatingmodroles'] = 'Přiřazení rolí a lokálních přenastavení na úrovni modulu';
$string['creatingnewcourse'] = 'Vytvářím nový kurz';
$string['creatingrolesdefinitions'] = 'Vytvářím definice rolí';
$string['creatingscales'] = 'Vytvářím škály';
$string['creatingsections'] = 'Vytvářím sekce';
$string['creatingtemporarystructures'] = 'Vytvářím dočasné struktury';
$string['creatinguserroles'] = 'Přiřazení rolí a lokálních přenastavení na úrovni uživatele';
$string['creatingusers'] = 'Vytvářím uživatele';
$string['creatingxmlfile'] = 'Vytvářím XML soubor';
$string['currency'] = 'Měna';
$string['currentcourse'] = 'Aktuální kurz';
$string['currentcourseadding'] = 'Tento kurz, přidávám data do něj';
$string['currentcoursedeleting'] = 'Tento kurz, nejprve jej odstraňuji';
$string['currentlanguage'] = 'Současný jazyk';
$string['currentlocaltime'] = 'váš momentální místní čas';
$string['currentpicture'] = 'Stávající obrázek';
$string['currentrelease'] = 'Údaje o stávajícím vydání';
$string['currenttheme'] = 'Aktuální motiv';
$string['currentversion'] = 'Stávající verze';
$string['databasechecking'] = 'Aktualizuji databázi Moodle z verze {$a->oldversion} na {$a->newversion}';
$string['databaseperformance'] = 'Výkon databáze';
$string['databasesetup'] = 'Nastavování databáze';
$string['databasesuccess'] = 'Databáze úspěšně aktualizována';
$string['databaseupgradebackups'] = 'Verze zálohy je nyní {$a}';
$string['databaseupgradeblocks'] = 'Verze bloků je nyní {$a}';
$string['databaseupgradegroups'] = 'Verze skupin je teď {$a}';
$string['databaseupgradelocal'] = 'Verze místních úprav databáze je nyní {$a}';
$string['databaseupgrades'] = 'Aktualizuji databázi';
$string['dataformats'] = 'Datové formáty';
$string['date'] = 'Datum';
$string['datechanged'] = 'Datum změněno';
$string['datemostrecentfirst'] = 'Datum - nejnovější první';
$string['datemostrecentlast'] = 'Datum - nejnovější poslední';
$string['datetimefilterafter'] = '{$a->title} po';
$string['datetimefilterbefore'] = '{$a->title} předtím';
$string['day'] = 'den';
$string['days'] = 'dnů';
$string['decodinginternallinks'] = 'Dekódování interních odkazů';
$string['default'] = 'Výchozí';
$string['defaultcategoryname'] = 'Kategorie 1';
$string['defaultcompetencescale'] = 'Výchozí škála kompetence';
$string['defaultcompetencescaledesc'] = 'Binární škála, která neposkytuje další informace nad rámec splnění nebo nesplnění.';
$string['defaultcompetencescalenotproficient'] = 'Zatím není splněno';
$string['defaultcompetencescaleproficient'] = 'Splněno';
$string['defaultcoursestudent'] = 'Student';
$string['defaultcoursestudentdescription'] = 'Studenti obvykle v kurzu mají méně oprávnění.';
$string['defaultcoursestudents'] = 'Studenti';
$string['defaultcoursesummary'] = 'Napište stručný a zajímavý odstavec, který popisuje, o čem pojednává tento kurz.';
$string['defaultcourseteacher'] = 'Učitel';
$string['defaultcourseteacherdescription'] = 'Učitelé mohou v rámci kurzu dělat všechno, včetně změn aktivit a známkování studentů';
$string['defaultcourseteachers'] = 'Učitelé';
$string['defaulteditor'] = 'Výchozí editor';
$string['defaulthomepageuser'] = 'Úvodní stránka';
$string['defaulthomepageuser_help'] = 'Na kterou stránku byste měli být přesměrováni po přihlášení na stránky?';
$string['delete'] = 'Odstranit';
$string['deleteablock'] = 'Odstranit block';
$string['deleteall'] = 'Odstranit vše';
$string['deleteallcannotundo'] = 'Odstranit vše - nelze vzít zpět';
$string['deleteallcomments'] = 'Všechny komentáře';
$string['deleteallratings'] = 'Všechna hodnocení';
$string['deletecategory'] = 'Odstranit kategorii: {$a}';
$string['deletecategorycheck'] = 'Jste si úplně jisti, že chcete kompletně odstranit kategorii <b>"{$a}"</b>?<br />Kurzy budou přesunuty do nadřazené kategorie, případně do kategorie Různé.';
$string['deletecategorycheck2'] = 'Pokud odstraníte tuto kategorii , musíte se rozhodnout, co se má stát s kurzy a podkategoriemi, které obsahuje.';
$string['deletecategoryempty'] = 'Tato kategorie je prázdná';
$string['deletecheck'] = 'Odstranit {$a}?';
$string['deletecheckfiles'] = 'Jste si absolutně jisti, že chcete odstranit tyto soubory?';
$string['deletecheckfull'] = 'Opravdu chcete smazat uživatele {$a}, včetně dat, jako jsou podrobnosti profilu, registrace, členství ve skupinách a globálních skupinách a některá data o aktivitě uživatele?';
$string['deletechecktype'] = 'Jste si jisti, že chcete smazat {$a->type}?';
$string['deletechecktypename'] = 'Jste si jisti, že chcete smazat {$a->type} "{$a->name}"?';
$string['deletecheckwarning'] = 'Chystáte se odstranit tyto soubory';
$string['deletecommentbyon'] = 'Odstranit komentář zapsaný {$a->user} v {$a->time}';
$string['deletecompletely'] = 'Kompletně odstranit';
$string['deletecourse'] = 'Odstranit kurz';
$string['deletecoursecheck'] = 'Jste si absolutně jisti, že chcete kompletně odstranit tento kurz a všechna data, která obsahuje?';
$string['deleted'] = 'Odstraněno';
$string['deletedactivity'] = 'Odstraněno {$a}';
$string['deletedcourse'] = '{$a} byl kompletně odstraněn';
$string['deletednot'] = '{$a} nelze odstranit.';
$string['deletepicture'] = 'Odstranit';
$string['deletesection'] = 'Odstranit';
$string['deleteselected'] = 'Odstranit vybrané';
$string['deleteselectedkey'] = 'Odstranit vybraný klíč';
$string['deletingcourse'] = 'Odstraňuji {$a}';
$string['deletingexistingcoursedata'] = 'Odstraňování stávajících údajů v kurzu';
$string['deletingolddata'] = 'Odstraňování starých údajů';
$string['department'] = 'Oddělení';
$string['deprecatedeventname'] = '{$a} (není již v provozu)';
$string['desc'] = 'Sestupně';
$string['description'] = 'Popis';
$string['deselectall'] = 'Zrušit výběr';
$string['deselectnos'] = 'Zrušit výběr všech \'Ne\'';
$string['detailedless'] = 'Méně podrobností';
$string['detailedmore'] = 'Více podrobností';
$string['details'] = 'Podrobnosti';
$string['digitalminor'] = 'Nezletilý pro digitální souhlas';
$string['digitalminor_desc'] = 'Požádejte svého rodiče/opatrovníka, aby kontaktoval:';
$string['directory'] = 'Adresář';
$string['disable'] = 'Zakázat';
$string['disabledcomments'] = 'Komentáře jsou vypnuté';
$string['dismissnotification'] = 'Toto oznámení zrušit';
$string['displayingfirst'] = 'Zobrazeno je pouze prvních {$a->count} {$a->things}';
$string['displayingrecords'] = 'Zobrazení {$a} záznamů';
$string['displayingusers'] = 'Zobrazení uživatelů {$a->start} až {$a->end}';
$string['displayonpage'] = 'Zobrazit na stránce';
$string['dndcourse'] = 'Kurz můžete přetáhnout a změnit jeho řazení nebo přesunout do jiné kategorie.';
$string['dndenabled_inbox'] = 'Pro nahrání souborů z vašeho počítače je přetáhněte sem.';
$string['dndnotsupported'] = 'Přetahování souborů není podporováno';
$string['dndnotsupported_help'] = 'Váš prohlížeč nepodporuje funkci přetahování souborů. Tato funkce je dostupná ve všech posledních verzích prohlížečů Chrome, Firefox a Safari, stejně jako v Internet Exploreru verze 10 a vyšší.';
$string['dndnotsupported_insentence'] = 'přetahování souborů není podporováno';
$string['dnduploadwithoutcontent'] = 'Toto nahrávání nemá žádný obsah';
$string['dndworkingfile'] = 'Pro nahrání souborů je stačí přetáhnout do příslušné sekce kurzu';
$string['dndworkingfilelink'] = 'Pro nahrání souborů nebo odkazů je stačí přetáhnout do příslušné sekce kurzu';
$string['dndworkingfiletext'] = 'Pro nahrání souborů nebo textu je stačí přetáhnout do příslušné sekce kurzu';
$string['dndworkingfiletextlink'] = 'Pro nahrání souborů, textu nebo odkazů je stačí přetáhnout do příslušné sekce kurzu';
$string['dndworkinglink'] = 'Pro nahrání  odkazů je stačí přetáhnout do příslušné sekce kurzu';
$string['dndworkingtext'] = 'Pro nahrání  textu je stačí přetáhnout do příslušné sekce kurzu';
$string['dndworkingtextlink'] = 'Pro nahrání textu nebo odkazů je stačí přetáhnout do příslušné sekce kurzu';
$string['documentation'] = 'Dokumentace Moodlu';
$string['dontsortcategories'] = 'Neřadit kategorie';
$string['dontsortcourses'] = 'Neřadit kurzy';
$string['down'] = 'Dolů';
$string['download'] = 'Stáhnout';
$string['downloadall'] = 'Stáhnout vše';
$string['downloadexcel'] = 'Stáhnout ve formátu Excel';
$string['downloadfile'] = 'Stáhnout soubor';
$string['downloadods'] = 'Stáhnout ve formátu ODS';
$string['downloadtext'] = 'Stáhnout v textovém formátu';
$string['doyouagree'] = 'Přečetli jste si tyto podmínky a rozumíte jim?';
$string['droptoupload'] = 'Pro nahrání souborů je přitáhněte sem';
$string['duplicate'] = 'Duplikovat';
$string['duplicatedmodule'] = '{$a} (kopie)';
$string['duplicatedsection'] = '{$a} (kopie)';
$string['edhelpaspellpath'] = 'Chcete-li v editoru používat kontrolu pravopisu, MUSÍTE mit na serveru nainstalován <strong>aspell 0.50</strong> nebo vyšší a musíte správně nastavit cestu ke spustitelnému souboru aspell. V systémech Unix/Linux bývá tato cesta obvykle <strong>/usr/bin/aspell</strong>, ale nemusí to platit vždy.';
$string['edhelpbgcolor'] = 'Určete barvu pozadí editačního okna. Platné hodnoty jsou např. \'#ffffff\' nebo \'white\'.';
$string['edhelpcleanword'] = 'Zapnout filtrování formátu dokumentu Word';
$string['edhelpenablespelling'] = 'Zapnout kontrolu pravopisu. Vyžaduje, aby byl na serveru nainstalován <strong>aspell</strong>.<br />Druhý parametr určuje <strong>výchozí slovník</strong>. Tato hodnota se použije, pokud aspell nemá k dispozici slovník pro jazyk vybraný uživatelem.';
$string['edhelpfontfamily'] = 'Vlastnost font-family je seznam názvů skupin (rodin) fontů a/nebo obecných skupin. Názvy skupin musí být odděleny čárkou.';
$string['edhelpfontlist'] = 'Určete fonty nabízené v editoru v rozbalovacím seznamu';
$string['edhelpfontsize'] = 'Výchozí font-size definuje velikost fontu. Platné hodnoty jsou např. medium, large, smaller, larger, 10pt, 11px.';
$string['edit'] = 'Upravit';
$string['edita'] = 'Upravit {$a}';
$string['editcategorysettings'] = 'Upravit nastavení kategorie';
$string['editcategorythis'] = 'Upravit tuto kategorii';
$string['editcoursesettings'] = 'Upravit nastavení kurzu';
$string['editfiles'] = 'Upravit soubory';
$string['editgroupprofile'] = 'Upravit profil skupiny';
$string['editingteachershort'] = 'Editor';
$string['editlock'] = 'Tuto hodnotu nelze upravovat!';
$string['editmode'] = 'Režim úprav';
$string['editmyprofile'] = 'Upravit profil';
$string['editorbgcolor'] = 'Barva pozadí (background-color)';
$string['editorcleanonpaste'] = 'Vyčistit HTML při vložení z Wordu';
$string['editorcommonsettings'] = 'Společná nastavení';
$string['editordefaultfont'] = 'Výchozí font';
$string['editorenablespelling'] = 'Povolit kontrolu pravopisu';
$string['editorfontlist'] = 'Seznam fontů (font-family)';
$string['editorfontsize'] = 'Výchozí velikost font (font-size)';
$string['editorpreferences'] = 'Volba editoru';
$string['editorresettodefaults'] = 'Nastavit výchozí hodnoty';
$string['editorsettings'] = 'Nastavení editoru';
$string['editorshortcutkeys'] = 'Klávesové zkratky editoru';
$string['editsection'] = 'Upravit nastavení';
$string['editsectionname'] = 'Upravit název sekce';
$string['editsectionsettings'] = 'Upravit nastavení sekce';
$string['editsectiontitle'] = 'Upravit sekci: {$a}';
$string['editsettings'] = 'Upravit nastavení';
$string['editthisactivity'] = 'Upravit tuto činnost';
$string['editthiscategory'] = 'Upravit tuto kategorii';
$string['edittitle'] = 'Upravit název';
$string['edittitleinstructions'] = 'Pro zrušení zvolte Escape, pro dokončení Enter';
$string['edituser'] = 'Upravit uživatelské účty';
$string['edulevel'] = 'Všechny akce';
$string['edulevel_help'] = '* Výuka - akce prováděné učitelem, např. aktualizaci materiálu
* Účast - akce prováděné studentem, např. příspěvek do fóra
* Ostatní - akce prováděné uživatelem s jinou rolí než učitel nebo student';
$string['edulevelother'] = 'Ostatní';
$string['edulevelparticipating'] = 'Účast';
$string['edulevelteacher'] = 'Výuka';
$string['email'] = 'E-mailová adresa';
$string['emailactive'] = 'E-mail aktivován';
$string['emailagain'] = 'E-mail (znovu)';
$string['emailalreadysent'] = 'E-mail s obnovením hesla  byl odeslán. Zkontrolujte prosím svůj e-mail.';
$string['emailcharset'] = 'Znaková sada e-mailu';
$string['emailconfirm'] = 'Potvrďte váš účet';
$string['emailconfirmation'] = 'Zdravím {$a->firstname},

Na stránkách "{$a->sitename}"  byl zadán požadavek na zřízení nového uživatelského účtu s vaší e-mailovou adresou.

Chcete -li potvrdit svůj nový účet, přejděte na tuto webovou adresu:

{$a->link}

Ve většině e-mailových programů by se vám tato adresa měla zobrazit jako odkaz, na který stačí kliknout. Pokud tomu tak není, zkopírujte si adresu do schránky a vložte ji do adresního řádku ve svém webovém prohlížeči.

Potřebujete-li pomoc, spojte se se správcem stránek,
{$a->admin}';
$string['emailconfirmationresend'] = 'Odeslat potvrzovací e-mail';
$string['emailconfirmationsubject'] = '{$a}: potvrzeni uctu';
$string['emailconfirmsent'] = '<p>Na vaši adresu <b>{$a}</b> byl odeslán e-mail s jednoduchými pokyny k dokončení vaší registrace.</p><p>Narazíte-li na nějaké obtíže, spojte se se správcem těchto stránek.</p>';
$string['emailconfirmsentfailure'] = 'Nepodařilo se odeslat potvrzovací e-mail';
$string['emailconfirmsentsuccess'] = 'Potvrzovací e-mail byl úspěšně odeslán';
$string['emaildigest'] = 'Typ souhrnných e-mailů';
$string['emaildigest_help'] = 'Toto je denní souhrn nových příspěvků nastavených v diskusních fórech jako výchozí.

* Bez souhrnu - obdržíte e-mail při každém příspěvku;
* Souhrn -  kompletní příspěvky - obdržíte jeden souhrnný e-mail denně obsahující kompletní obsah každého příspěvku do fóra;
* Souhrn - pouze předměty - obdržíte  jeden souhrnný e-mail denně obsahující pouze předmět každého příspěvku do fóra.

Pokud si budete přát, můžete si v každém fóru vybrat jiné nastavení.';
$string['emaildigestcomplete'] = 'Kompletní (denně e-mail s plným textem příspěvků)';
$string['emaildigestoff'] = 'Nepoužívat souhrny (jeden e-mail na každý příspěvek)';
$string['emaildigestsubjects'] = 'Předměty (denně e-mail pouze s předměty příspěvků)';
$string['emaildisable'] = 'E-mailová adresa zakázána';
$string['emaildisableclick'] = 'Chcete-li zamezit odesílání e-mailů na tuto adresu, klikněte sem';
$string['emaildisplay'] = 'Viditelnost e-mailu';
$string['emaildisplay_help'] = '* Skryté – Vaši e-mailovou adresu mohou zobrazit pouze uživatelé s příslušnými oprávněními, jako jsou učitelé.
* Viditelné pro každého – Vaši e-mailovou adresu mohou zobrazit všichni uživatelé na webu.
* Viditelné pro účastníky kurzu – Vaši e-mailovou adresu mohou zobrazit pouze účastníci kurzů, do kterých jste zapsáni.';
$string['emaildisplaycourse'] = 'Viditelné pro účastníky kurzu';
$string['emaildisplaycoursemembersonly'] = '(Viditelné pro ostatní účastníky kurzu)';
$string['emaildisplayeveryone'] = '(Viditelné pro všechny)';
$string['emaildisplayhide'] = '(Skryto všem kromě uživatelů s příslušnými oprávněními)';
$string['emaildisplayno'] = 'Skryto';
$string['emaildisplayyes'] = 'Viditelné pro všechny';
$string['emailenable'] = 'E-mailová adresa povolena';
$string['emailenableclick'] = 'Chcete-li znovu povolit odesílání e-mailů na tuto adresu, klikněte sem';
$string['emailexists'] = 'Tato e-mailová adresa je již registrována.';
$string['emailexistshintlink'] = 'Obnovit zapomenuté uživatelské jméno nebo heslo';
$string['emailexistssignuphint'] = 'Možná jste vytvořili v minulosti účet? {$a}';
$string['emailformat'] = 'Formát e-mailu';
$string['emailmustbereal'] = 'Poznámka: zadávaná e-mailová adresa nesmí být fiktivní.';
$string['emailnotallowed'] = 'E-mailové adresy v těchto doménách nejsou povoleny ({$a})';
$string['emailnotfound'] = 'E-mailová adresa nebyla nalezena v databázi';
$string['emailonlyallowed'] = 'Tento e-mail nelze použít. Povolené e-mailové domény jsou: {$a}.';
$string['emailpasswordchangeinfo'] = 'Zdravím {$a->firstname},

Někdo (pravděpodobně vy) požaduje změnu hesla k vašemu účtu "{$a->username}" na stránkách  "{$a->sitename}".
Vaše heslo změníte na stránce:

{$a->link}

Ve většině e-mailových programů by se vám tato adresa měla zobrazit jako odkaz, na který stačí kliknout. Pokud tomu tak není, zkopírujte si adresu do schránky a vložte ji do adresního řádku ve svém webovém prohlížeči.

Pokud narazíte na problémy, obraťte se na správce těchto stránek:
{$a->admin}';
$string['emailpasswordchangeinfodisabled'] = 'Zdravím {$a->firstname},

Někdo (pravděpodobně vy) požaduje změnu hesla k vašemu účtu na stránkách  "{$a->sitename}".

Váš účet je ale bohužel na těchto stránkách zablokován a heslo nemůže být změněno. Spojte se se správcem {$a->admin}.';
$string['emailpasswordchangeinfofail'] = 'Zdravím {$a->firstname},

Někdo (pravděpodobně vy) požaduje změnu hesla k vašemu účtu na stránkách  "{$a->sitename}".

Na těchto stránkách bohužel nelze změnit heslo. Spojte se se správcem {$a->admin}.';
$string['emailpasswordchangeinfosubject'] = '{$a}: Informace o změně hesla';
$string['emailpasswordconfirmation'] = 'Zdravím {$a->firstname},

Někdo (pravděpodobně vy) požaduje změnu hesla k vašemu účtu na stránkách  "{$a->sitename}".

Přejete-li si tuto změnu potvrdit a získat nové heslo e-mailem, navštivte následující stránku:
{$a->link}

Ve většině e-mailových programů by se vám tato adresa měla zobrazit jako odkaz, na který stačí kliknout. Pokud tomu tak není, zkopírujte si adresu do schránky a vložte ji do adresního řádku ve svém webovém prohlížeči.

Pokud narazíte na problémy, obraťte se na správce těchto stránek:
{$a->admin}';
$string['emailpasswordconfirmationsubject'] = '{$a}: potvrzení změny hesla';
$string['emailpasswordconfirmmaybesent'] = '<p>Pokud jste zadali správné uživatelské jméno nebo adresu, byl vám odeslán email.</p>
<p>Obsahuje jednoduché instrukce k potvrzení a dokončení změny hesla. Pokud máte nadále potíže, kontaktujte správce těchto stránek.</p>';
$string['emailpasswordconfirmnoemail'] = '<p> Zadaný uživatelský účet nemá zadanou e-mailovou adresu. </p><p> Obraťte se na správce webu. </p>';
$string['emailpasswordconfirmnotsent'] = '<p> Detail uživatele, který jste zadali neoznačuje existující uživatelský účet. </p><p> Zkontrolujte prosím zadané údaje a zkuste to znovu. Pokud potíže přetrvávají, obraťte se na správce webu. </p>';
$string['emailpasswordconfirmsent'] = 'Na vaši adresu <b>{$a}</b> byl odeslán e-mail obsahující jednoduché pokyny k potvrzení a dokončení změny vašeho hesla. <br />Pokud narazíte na problémy, obraťte se na správce těchto stránek.';
$string['emailresetconfirmation'] = 'Zdravím  {$a->firstname},

U vašeho účtu "{$a->username}" na {$a->sitename} bylo požadováno vymazání hesla.

Pro potvrzení této žádosti a nastavení nového hesla k vašemu účtu, přejděte na stránku:
<a href="{$a->link}">{$a->link}</a>

(Tento odkaz je platný {$a->resetminutes} minut od okamžiku, kdy bylo poprvé vyžádáno vymazání.)

Jestliže požadavek na vymazání hesla nebyl od vás, neprovádějte žádnou akci.

Pokud potřebujete pomoc, obraťte se na správce webu,
{$a->admin}';
$string['emailresetconfirmationsubject'] = '{$a}: žádost o změnu hesla';
$string['emailresetconfirmsent'] = 'E-mail byl odeslán na vaši adresu  <b>{$a}.</b> <br /> Obsahuje jednoduché instrukce k potvrzení a dokončení změny hesla. Pokud potíže přetrvávají, obraťte se na správce webu.';
$string['emailstop'] = 'Zakázat oznámení';
$string['emailtoprivatefiles'] = 'Přílohy e-mailu zaslaného na adresu {$a} se uloží do vašich osobních souborů.';
$string['emailtoprivatefilesdenied'] = 'Správce vašeho Moodlu zakázal používání osobních souborů.';
$string['emailvia'] = '{$a->name} přes {$a->siteshortname}';
$string['emojicategoryactivities'] = 'Činnosti';
$string['emojicategoryanimalsnature'] = 'Zvířata & příroda';
$string['emojicategoryflags'] = 'Vlajky';
$string['emojicategoryfooddrink'] = 'Jídlo & pití';
$string['emojicategoryobjects'] = 'Objekty';
$string['emojicategorypeoplebody'] = 'Lidé a tělo';
$string['emojicategoryrecent'] = 'Nedávný';
$string['emojicategorysmileysemotion'] = 'Smajlíci a emoce';
$string['emojicategorysymbols'] = 'Symboly';
$string['emojicategorytravelplaces'] = 'Cestování & místa';
$string['emptycmids'] = 'ID prázdného modulu kurzu';
$string['emptydragdropregion'] = 'prázdná oblast';
$string['emptysectionids'] = 'ID Prázdné sekce';
$string['enable'] = 'Povolit';
$string['encryptedcode'] = 'Šifrovaný kód';
$string['enddate'] = 'Datum ukončení kurzu';
$string['enddate_help'] = 'Datum ukončení neomezuje přístup studentů do kurzu. Určuje, zda je kurz uveden jako Minulost v mých kurzech.';
$string['enddatewithtaskenabled'] = 'Datum ukončení kurzu';
$string['enddatewithtaskenabled_help'] = 'Datum, kdy se kurz pro studenty skryje a ti k němu již nemají přístup.';
$string['english'] = 'Angličtina';
$string['enrolmentmethods'] = 'Metody zápisu';
$string['entercourse'] = 'Klikněte pro vstup do kurzu';
$string['enteremail'] = 'Zadejte svou e-mailovou adresu';
$string['enteremailaddress'] = 'Zadejte svou e-mailovou adresu, na kterou vám bude zasláno nové heslo.';
$string['enterusername'] = 'Zadejte své uživatelské jméno';
$string['entries'] = 'Položky';
$string['error'] = 'Chyba';
$string['errorcreatingactivity'] = 'Nelze vytvořit instanci činnosti "{$a}"';
$string['errorfiletoobig'] = 'Soubor byl větší než nejvýše dovolených {$a} bytů';
$string['errornouploadrepo'] = 'Pro tuto stránku není povolen žádný repositář';
$string['errorwhenconfirming'] = 'Omlouváme se, ale objevila se chyba a vaše registrace nebyla dokončena. Pokud jste se na tuto stránku dostali po kliknutí na odkaz v e-mailové zprávě, zkontrolujte, zda řádek s HTTP odkazem není v e-mailu zalomen nebo zkrácen. V případě potřeby odkaz rekonstruujte pomocí obvyklých funkcí Kopírovat a Vložit.';
$string['eventcommentcreated'] = 'Vložen komentář';
$string['eventcommentdeleted'] = 'Komentář odstraněn';
$string['eventcommentsviewed'] = 'Komentář zobrazen';
$string['eventconfiglogcreated'] = 'Vytvořen protokol konfigurace';
$string['eventcontentviewed'] = 'Zobrazený obsah';
$string['eventcoursebackupcreated'] = 'Byla vytvořena záloha kurzu';
$string['eventcoursecategorycreated'] = 'Kategorie vytvořena';
$string['eventcoursecategorydeleted'] = 'Kategorie odstraněna';
$string['eventcoursecategoryupdated'] = 'Kategorie aktualizována';
$string['eventcoursecategoryviewed'] = 'Kategorie byla zobrazena';
$string['eventcoursecontentdeleted'] = 'Obsah kurzu odstraněn';
$string['eventcoursecreated'] = 'Kurz vytvořen';
$string['eventcoursedeleted'] = 'Kurz odstraněn';
$string['eventcourseended'] = 'Kurz skončil';
$string['eventcourseinformationviewed'] = 'Obsah kurzu byl zobrazen';
$string['eventcoursemodulecreated'] = 'Modul kurzu vytvořen';
$string['eventcoursemoduledeleted'] = 'Modul kurzu odstraněn';
$string['eventcoursemoduleinstancelistviewed'] = 'Zobrazen seznam instancí modulů kurzu';
$string['eventcoursemoduleupdated'] = 'Modul kurzu aktualizován';
$string['eventcoursemoduleviewed'] = 'Modul kurzu zobrazen';
$string['eventcourseoverviewviewed'] = 'Stránka s přehledem aktivit kurzu zobrazena';
$string['eventcourseresetended'] = 'Resetování kurzu ukončeno';
$string['eventcourseresetstarted'] = 'Zahájeno resetování kurzu';
$string['eventcourserestored'] = 'Kurz obnoven';
$string['eventcoursesectioncreated'] = 'Vytvořena sekce kurzu';
$string['eventcoursesectiondeleted'] = 'Sekce kurzu odstraněna';
$string['eventcoursesectionupdated'] = 'Sekce kurzu aktualizována';
$string['eventcoursessearched'] = 'Kurzy vyhledány';
$string['eventcoursestarted'] = 'Kurz zahájen';
$string['eventcourseupdated'] = 'Kurz aktualizován';
$string['eventcourseuserreportviewed'] = 'Sestava o uživateli kurzu prohlédnuta';
$string['eventcourseviewed'] = 'Kurz prohlédnut';
$string['eventdashboardreset'] = 'Reset Nástěnky';
$string['eventdashboardsreset'] = 'Reset Nástěnek';
$string['eventdashboardviewed'] = 'Zobrazena nástěnka';
$string['eventdatabasetextfieldcontentreplaced'] = 'Globální vyhledávání a nahrazování v databázi';
$string['eventemailfailed'] = 'E-mail se nepodařilo odeslat';
$string['eventmycoursesviewed'] = 'Moje kurzy zobrazeny';
$string['eventname'] = 'Název události';
$string['eventrecentactivityviewed'] = 'Zobrazeny nejnovější činnosti';
$string['eventsearchindexed'] = 'Hledaná data indexována';
$string['eventsearchresultsviewed'] = 'Zobrazeny výsledky hledání';
$string['eventsectionviewed'] = 'Sekce zobrazena';
$string['eventunknownlogged'] = 'Neznámá událost';
$string['eventurlblocked'] = 'Adresa URL byla zablokována';
$string['eventusercreated'] = 'Uživatel vytvořen';
$string['eventuserdeleted'] = 'Uživatel odstraněn';
$string['eventuserfeedbackgiven'] = 'Kliknuto na odkaz pro zpětnou vazbu';
$string['eventuserfeedbackremind'] = 'Připomenout později kliknout na odkaz na zpětnou vazbu';
$string['eventuserinfocategorycreated'] = 'Byla vytvořena kategorie pole profilu uživatele';
$string['eventuserinfocategorydeleted'] = 'Kategorie pole profilu uživatele byla odstraněna';
$string['eventuserinfocategoryupdated'] = 'Kategorie pole profilu uživatele bylo aktualizováno';
$string['eventuserinfofieldcreated'] = 'Bylo vytvořeno uživatelské pole profilu';
$string['eventuserinfofielddeleted'] = 'Uživatelské pole profilu bylo odstraněno';
$string['eventuserinfofieldupdated'] = 'Uživatelské pole profilu bylo aktualizováno';
$string['eventuserlistviewed'] = 'Zobrazen seznam uživatelů';
$string['eventuserloggedout'] = 'Uživatel odhlášen';
$string['eventuserpasswordpolicyfailed'] = 'Heslo uživatele nesplňuje zásada bezpečných hesel';
$string['eventuserpasswordupdated'] = 'Uživatelské heslo změněno';
$string['eventuserprofileviewed'] = 'Zobrazen uživatelský profil';
$string['eventuserupdated'] = 'Uživatel aktualizován';
$string['everybody'] = 'Všichni';
$string['executeat'] = 'Spustit v';
$string['existing'] = 'Stávající';
$string['existingadmins'] = 'Stávající správci';
$string['existingcourse'] = 'Existující kurz';
$string['existingcourseadding'] = 'Existující kurz, přidávám do něj údaje';
$string['existingcoursedeleting'] = 'Existující kurz, nejprve jej odstraňuji';
$string['existingcreators'] = 'Stávající tvůrci kurzů';
$string['existingstudents'] = 'Zapsaní studenti';
$string['existingteachers'] = 'Stávající učitelé';
$string['expand'] = 'Rozbalit';
$string['expandall'] = 'Rozbalit vše';
$string['expandcategory'] = 'Rozbalit {$a}';
$string['explanation'] = 'Vysvětlení';
$string['explanationdigitalminor'] = 'Tyto informace jsou nutné k určení, zda je váš věk nad věkovou hranicí pro digitální souhlas. Jedná se o věk, kdy může jednotlivec souhlasit s podmínkami a a jejich údaje jsou legálně uchovávány a zpracovávány.';
$string['extendperiod'] = 'Délka prodloužení';
$string['extendsession'] = 'Prodloužit relaci';
$string['failedloginattempts'] = '{$a->attempts} neúspěšných pokusů o přihlášení od posledního přihlášení';
$string['failedtaskbody'] = '<p>Zdravíme {$a->firstname},</p> <p>Úloha <b>{$a->taskname}</b> několikrát selhala a vyžaduje pozornost.</p> <p><a href="{$a->link}">Zobrazit úkol</a></p>';
$string['failedtaskcontexturlname'] = 'Zpráva o stavu';
$string['failedtasksubject'] = 'Úloha se nezdařila: {$a}';
$string['favourites'] = 'Označeno hvězdičkou';
$string['feedback'] = 'Komentář';
$string['file'] = 'Soubor';
$string['fileexists'] = 'Již zde existuje soubor se stejným názvem: {$a}';
$string['filemissing'] = '{$a} chybí';
$string['filereaderror'] = 'Soubor "{$a}" nelze přečíst. Zkontrolujte prosím, zda je to opravdu soubor a ne složka';
$string['files'] = 'Soubory';
$string['filesanduploads'] = 'Soubory a nahrávání';
$string['filesfolders'] = 'Soubory/složky';
$string['fileuploadwithcontent'] = 'Neočekávaný parametr "content" při nahrávání souboru.';
$string['filloutallfields'] = 'Vyplňte prosím všechna pole v tomto formuláři';
$string['filter'] = 'Filtr';
$string['filteroption'] = '{$a->criteria}: {$a->value}';
$string['filterrowlegend'] = 'Filtr {$a}';
$string['filters'] = 'Filtry';
$string['filtersetmatchdescription'] = 'Jak by se mělo kombinovat více filtrů';
$string['filtertype'] = 'Typ filtru';
$string['findmorecourses'] = 'Najít více kurzů...';
$string['first'] = 'První';
$string['firstaccess'] = 'První přihlášení';
$string['firstname'] = 'Křestní jméno';
$string['firstnamephonetic'] = 'Jméno - foneticky';
$string['firstpage'] = 'První stránka';
$string['firstsiteaccess'] = 'První přihlášení';
$string['firsttime'] = 'Jste tady poprvé?';
$string['folder'] = 'Složka';
$string['folderclosed'] = 'Zavřená složka';
$string['folderopened'] = 'Otevřená složka';
$string['followingoptional'] = 'Následující položky jsou volitelné';
$string['followingrequired'] = 'Následující položky jsou povinné';
$string['for'] = 'Pro';
$string['force'] = 'Vnucovat';
$string['forcelanguage'] = 'Vnutit jazyk';
$string['forceno'] = 'Nevnucovat';
$string['forcepasswordchange'] = 'Vnutit změnu hesla';
$string['forcepasswordchange_help'] = 'Pokud je zaškrtnuto, bude uživatel při příštím přihlášení vyzván ke změně hesla.';
$string['forcepasswordchangecheckfull'] = 'Jste si jistí, že chcete vynutit změnu hesla u {$a} ?';
$string['forcepasswordchangenot'] = 'Nelze vynutit změnu hesla u {$a}';
$string['forcepasswordchangenotice'] = 'Před pokračováním si musíte změnit heslo.';
$string['forcepasswordresetfailurenotice'] = 'Vaše aktuální heslo již neodpovídá nastaveným zásadám pro hesla. Požádejte o pomoc svého správce Moodle.
 {$a}';
$string['forcepasswordresetnotice'] = 'Vaše aktuální heslo již neodpovídá nastaveným zásadám pro hesla. K přihlášení musíte resetovat své heslo.
   {$a}';
$string['forcetheme'] = 'Vnutit motiv';
$string['forgotaccount'] = 'Zapomněli jste heslo?';
$string['forgotten'] = 'Zapomněli jste své uživatelské jméno či heslo?';
$string['forgottenduplicate'] = 'Tato emailová adresa je sdílena několika účty, prosím použijte uživatelské jméno';
$string['forgotteninvalidurl'] = 'Neplatné heslo - reset URL';
$string['format'] = 'Uspořádání';
$string['formathtml'] = 'Formát HTML';
$string['formatmarkdown'] = 'Formát Markdown';
$string['formatplain'] = 'Čistě textový formát';
$string['formattext'] = 'Moodle auto-formát';
$string['forumpreferences'] = 'Předvolby fóra';
$string['framesetinfo'] = 'Dokument v rámcích obsahuje:';
$string['fromdate'] = 'Od';
$string['fromsender'] = 'Od';
$string['frontpagecategorycombo'] = 'Kategorizovaný seznam kurzů';
$string['frontpagecategorynames'] = 'Seznam kategorií';
$string['frontpagecourselist'] = 'Seznam kurzů';
$string['frontpagecoursesearch'] = 'Pole pro vyhledávání kurzu';
$string['frontpagedescription'] = 'Popis titulní strany';
$string['frontpagedescriptionhelp'] = 'Tento popis lze zobrazit na titulní stránce pomocí bloku Popis kurzu/stránek.';
$string['frontpageenrolledcourselist'] = 'Zapsané kurzy';
$string['frontpageformat'] = 'Uspořádání titulní strany';
$string['frontpageformatloggedin'] = 'Uspořádání titulní strany po přihlášení';
$string['frontpagenews'] = 'Oznámení';
$string['frontpagesettings'] = 'Nastavení titulní stránky';
$string['fulllistofcourses'] = 'Všechny kurzy';
$string['fullname'] = 'Celý název';
$string['fullnamecourse'] = 'Celý název kurzu';
$string['fullnamecourse_help'] = 'Název zobrazený v části Moje kurzy a v seznamu dostupných kurzů na domovské stránce.';
$string['fullnamedisplay'] = '{$a->firstname} {$a->lastname}';
$string['fullnameuser'] = 'Celé jméno';
$string['fullprofile'] = 'Celý profil';
$string['fullsitename'] = 'Celý název stránek';
$string['functiondisabled'] = 'Tato funkce je momentálně vypnutá';
$string['general'] = 'Obecná nastavení';
$string['geolocation'] = 'zeměpisná šířka - délka';
$string['gettheselogs'] = 'Zobrazit protokol';
$string['go'] = 'Proveď';
$string['gobacktosite'] = 'Vrátit se na stránku';
$string['gpl'] = 'Copyright (C) 1999 a dále Martin Dougiamas  (https://moodle.com)

Tento program je volný software; můžete jej šířit a modifikovat podle ustanovení Obecné veřejné licence GNU, vydávané Free Software Foundation; a to buď podle verze 2 této licence anebo (podle vašeho uvážení) kterékoli pozdější verze.

Tento program je rozšiřován v naději, že bude užitečný, avšak BEZ JAKÉKOLI ZÁRUKY; neposkytují se ani odvozené záruky PRODEJNOSTI anebo VHODNOSTI PRO URČITÝ ÚČEL.

Další informace naleznete na stránce s informacemi o licenci Moodle: https://moodledev.io/general/license';
$string['gpl3'] = 'Copyright (C) 1999 a dále Martin Dougiamas (https://moodle.com)

Tento program je svobodný software: můžete jej šířit a upravovat
podle ustanovení Obecné veřejné licence GNU (GNU General
Public Licence), vydávané Free Software Foundation a to buď
podle 3. verze této Licence, nebo (podle vašeho uvážení)
kterékoli pozdější verze.

Tento program je rozšiřován v naději, že bude užitečný, avšak
BEZ JAKÉKOLIV ZÁRUKY. Neposkytují se ani odvozené záruky
PRODEJNOSTI anebo VHODNOSTI PRO URČITÝ ÚČEL.

Další informace naleznete na stránce s informacemi o licenci Moodle: https://moodledev.io/general/license';
$string['gpllicense'] = 'GPL licence';
$string['gradable'] = 'Hodnotitelné';
$string['gradenoun'] = 'Známka';
$string['grades'] = 'Známky';
$string['gradeverb'] = 'Známka';
$string['gravatarenabled'] = 'Pro tento web byl povolen <a href="https://www.gravatar.com/"> Gravatar </a>. Pokud neodešlete profilový obrázek, Moodle se pokusí načíst profilový obrázek z Gravataru.';
$string['group'] = 'Skupina';
$string['groupadd'] = 'Přidat novou skupinu';
$string['groupaddusers'] = 'Přidat vybrané do skupiny';
$string['groupfor'] = 'pro skupinu';
$string['groupinfo'] = 'Informace o vybrané skupině';
$string['groupinfoedit'] = 'Upravit nastavení skupiny';
$string['groupinfomembers'] = 'Informace o vybraných členech';
$string['groupinfopeople'] = 'Informace o vybraných lidech';
$string['groupmembers'] = 'Členové skupiny';
$string['groupmemberssee'] = 'Zobrazit seznam členů skupiny';
$string['groupmembersselected'] = 'Členové vybrané skupiny';
$string['groupmode'] = 'Režim skupin';
$string['groupmodeforce'] = 'Vnutit režim skupin';
$string['groupmy'] = 'Moje skupina';
$string['groupnonmembers'] = 'Lidé mimo skupinu';
$string['groupnotamember'] = 'Je mi líto, ale nejste členy této skupiny';
$string['grouprandomassign'] = 'Náhodně rozdělit do skupin';
$string['groupremove'] = 'Odstranit vybrané skupiny';
$string['groupremovemembers'] = 'Odstranit vybrané členy';
$string['groups'] = 'Skupiny';
$string['groupsnone'] = 'Žádné skupiny';
$string['groupsseparate'] = 'Oddělené skupiny';
$string['groupsvisible'] = 'Viditelné skupiny';
$string['guest'] = 'Host';
$string['guestdescription'] = 'Hosti mají minimální práva a obvykle nemohou nikam vkládat texty';
$string['guestskey'] = 'Povolit hostům s klíčem';
$string['guestsno'] = 'Zakázat hostům';
$string['guestsnotallowed'] = 'Je mi líto, "{$a}" neumožňuje vstup pro hosty.';
$string['guestsyes'] = 'Povolit hostům i bez klíče';
$string['guestuser'] = 'Nepřihlášený host';
$string['guestuserinfo'] = 'Tomuto zvláštnímu uživateli je umožněno vstupovat do některých kurzů s přístupovými právy čtenáře.';
$string['help'] = 'Nápověda';
$string['helpprefix2'] = 'Pomoc s  {$a}';
$string['helpwiththis'] = 'Pomoc s tímto';
$string['hiddenassign'] = 'Skryté přidělení rolí';
$string['hiddenfromstudents'] = 'Skryté před studenty';
$string['hiddenoncoursepage'] = 'Je dostupné, ale není zobrazeno na stránce kurzu';
$string['hiddensections'] = 'Skryté sekce';
$string['hiddensections_help'] = 'Skryté sekce mohou být studentům zobrazeny jako „nedostupné“ na stránce kurzu nebo mohou být zcela skryté.';
$string['hiddensectionscollapsed'] = 'Zobrazit pouze názvy sekcí';
$string['hiddensectionscollapsed_description'] = 'Názvy sekcí se studentům zobrazují, ale obsah sekcí je skrytý.';
$string['hiddensectionsinvisible'] = 'Úplně skrýt';
$string['hiddensectionsinvisible_description'] = 'Skryté sekce se studentům nezobrazují.';
$string['hiddenwithbrackets'] = '(skryté)';
$string['hide'] = 'Skrýt';
$string['hideadvancedsettings'] = 'Skrýt pokročilá nastavení';
$string['hidecategory'] = 'Skrýt kategorii?';
$string['hidecategorymany'] = 'Kategorie {$a->category} obsahuje {$a->coursecount} kurzů.
<br/>Pokud jej skryjete, uživatelé bez oprávnění k zobrazení skrytých kategorií již nebudou mít přístup ke kurzům.';
$string['hidecategoryone'] = 'Kategorie {$a->category} obsahuje 1 kurz.
<br/>Pokud jej skryjete, uživatelé bez oprávnění k zobrazení skrytých kategorií již nebudou mít přístup ke kurzu.';
$string['hidechartdata'] = 'Skrýt data grafu';
$string['hidefromstudents'] = 'Na stránce kurzu skrýt';
$string['hideoncoursepage'] = 'Zpřístupněno, ale není zobrazeno na stránce kurzu';
$string['hidepopoverwindow'] = 'Skrýt vyskakovací okno';
$string['hidesection'] = 'Skrýt sekci {$a}';
$string['hidesettings'] = 'Skrýt nastavení';
$string['hideshowblocks'] = 'Skrýt nebo ukázat postranní bloky';
$string['highlight'] = 'Zvýraznění';
$string['highlighted'] = 'Zvýrazněno';
$string['highlightoff'] = 'Odstranit zvýraznění';
$string['hits'] = 'Četnost přístupů';
$string['hitsoncourse'] = 'Četnost přístupů uživatele {$a->username} do kurzu {$a->coursename}';
$string['hitsoncoursetoday'] = 'Dnešní četnost přístupů uživatele {$a->username} do kurzu {$a->coursename}';
$string['home'] = 'Titulní stránka';
$string['homeheader'] = 'Hlavní nabídka';
$string['hour'] = 'hodina';
$string['hours'] = 'hodin';
$string['howtomakethemes'] = 'Jak vytvářet nové motivy';
$string['htmleditor'] = 'Použít HTML editor';
$string['htmleditoravailable'] = 'HTML editor je k dispozici';
$string['htmleditordisabled'] = 'Používání HTML editoru máte zakázáno ve svém uživatelském profilu.';
$string['htmleditordisabledadmin'] = 'Správce zakázal používání HTML editoru na těchto stránkách.';
$string['htmleditordisabledbrowser'] = 'HTML editor není k dispozici, protože nepoužíváte podporovaný prohlížeč.';
$string['htmlfilesonly'] = 'Pouze HTML soubory';
$string['htmlformat'] = 'Formát HTML';
$string['icon'] = 'Ikona';
$string['idnumber'] = 'ID';
$string['idnumbercourse'] = 'Identifikátor (ID) kurzu';
$string['idnumbercourse_help'] = 'Slouží pouze k propojení kurzu s externími systémy. Pokud nemáte oficiální ID kurzu, ponechte prázdné.';
$string['idnumbercoursecategory'] = 'Identifikátor kategorie';
$string['idnumbercoursecategory_help'] = 'Identifikátor kategorie kurzů slouží pro účely případné synchronizace s externími systémy a párování dat. Tento identifikátor se nikde nezobrazuje. Pokud nevíte, ponechte pole prázdné.';
$string['idnumbergroup'] = 'ID číslo skupiny';
$string['idnumbergroup_help'] = 'Tento identifikátor skupiny se používá pouze při komunikaci s externími systémy a není zobrazován nikde na těchto stránkách. Pokud má tato skupina nějaké jednoznačné kódové označení, můžete je sem vložit. Jinak ponechte pole prázdné.';
$string['idnumbergrouping'] = 'ID číslo seskupení';
$string['idnumbergrouping_help'] = 'Tento identifikátor seskupení se používá pouze při komunikaci s externími systémy a není zobrazován nikde na těchto stránkách. Pokud má toto seskupení nějaké jednoznačné kódové označení, můžete je sem vložit. Jinak ponechte pole prázdné.';
$string['idnumbermod'] = 'Identifikátor';
$string['idnumbermod_help'] = 'Nastavení ID identifikátoru  poskytuje způsob identifikace aktivity nebo zdroje pro účely, jako je výpočet známek nebo vlastní hlášení.  V opačném případě může být pole prázdné.

Pro hodnocené činnosti lze ID číslo také nastavit v třídní knize, ačkoli je možné je upravovat na stránce nastavení činnosti.';
$string['idnumbertaken'] = 'Tento identifikátor (ID) již někdo používá';
$string['imagealt'] = 'Popis obrázku';
$string['import'] = 'Import';
$string['importdata'] = 'Importovat data kurzu';
$string['importdataexported'] = 'Data úspěšně exportována z kurzu \'Z\'.<br />Pokračujte importem do vašeho kurzu \'DO\'.';
$string['importdatafinished'] = 'Import dokončen! Přejděte do vašeho kurzu';
$string['importdatafrom'] = 'Najděte kurz, z něhož chcete importovat data:';
$string['importinfo'] = 'Importovat položky z jiných kurzů, jako jsou aktivity, bloky nebo události kalendáře. Nebudou importována žádná uživatelská data.';
$string['inactive'] = 'Neaktivní';
$string['include'] = 'Zahrnout';
$string['includeallusers'] = 'Zahrnout všechny uživatele';
$string['includecoursefiles'] = 'Zahrnout soubory v kurzu';
$string['includecourseusers'] = 'Zahrnout uživatele v kurzu';
$string['included'] = 'Zahrnuto';
$string['includelogentries'] = 'Zahrnout protokoly';
$string['includemodules'] = 'Zahrnout moduly';
$string['includemoduleuserdata'] = 'Zahrnout uživatelská data modulu';
$string['includeneededusers'] = 'Zahrnout nezbytné uživatele';
$string['includenoneusers'] = 'Nezahrnout žádné uživatele';
$string['includeroleassignments'] = 'Zahrnout přiřazení rolí';
$string['includesitefiles'] = 'Zahrnout soubory stránek použité v tomto kurzu';
$string['includesubcategories'] = 'Včetně podkategorií';
$string['includeuserfiles'] = 'Zahrnout soubory uživatelů';
$string['increasesections'] = 'Zvýšit počet témat';
$string['indicator:accessesafterend'] = 'Přístupy po datu ukončení';
$string['indicator:accessesafterend_help'] = 'Tento ukazatel odráží přístup studentů do kurzu po ukončení kurzu.';
$string['indicator:accessesbeforestart'] = 'Přístupy před datem zahájení kurzu';
$string['indicator:accessesbeforestart_help'] = 'Tento ukazatel odráží přístup studentů do kurzu před začátkem kurzu.';
$string['indicator:activitiesdue'] = 'Činnosti s termínem';
$string['indicator:activitiesdue_help'] = 'Uživatel má činnosti s termínem';
$string['indicator:anycourseaccess'] = 'Libovolný přístup do kurzu';
$string['indicator:anycourseaccess_help'] = 'Tento indikátor odráží přístup k jakémukoli kurzu, do kterého je uživatel zapsán.';
$string['indicator:anywrite'] = 'Jakákoli akce zápisu';
$string['indicator:anywrite_help'] = 'Tento ukazatel představuje jakýkoli výstup (odevzdání, odeslání) studenta.';
$string['indicator:anywriteincourse'] = 'Jakýkoliv příspěvek v kurzu';
$string['indicator:anywriteincourse_help'] = 'Tento ukazatel představuje jakoukoli akci při zápisu (odeslání), kterou student realizoval v některé činnosti.';
$string['indicator:completeduserprofile'] = 'Uživatelský profil je dokončen';
$string['indicator:completeduserprofile_help'] = 'Tento ukazatel znamená, že student zkompletoval svůj uživatelský profil.';
$string['indicator:completeduserprofiledef'] = 'Uživatelský profil je dokončen';
$string['indicator:completeduserprofiledef_help'] = 'Zásady webu byly dohodnuty a uživatel vyplnil následující pole: Instituce, Oddělení, Adresa, Město, Země, URL.';
$string['indicator:completionenabled'] = 'Sledování plnění povoleno';
$string['indicator:completionenabled_help'] = 'Tento ukazatel představuje, že bylo v tomto kurzu povoleno sledování plnění.';
$string['indicator:nostudent'] = 'Zápisy studentů';
$string['indicator:nostudent_help'] = 'Tento ukazatel ukazuje dostupnost studentů v kurzu.';
$string['indicator:noteacher'] = 'Dostupnost učitelů';
$string['indicator:noteacher_help'] = 'Tento ukazatel odráží dostupnost učitelů v kurzu.';
$string['indicator:potentialcognitive'] = 'Potenciální kognitivní hloubka kurzu';
$string['indicator:potentialcognitive_help'] = 'Tento ukazatel je založen na potenciální kognitivní hloubce, kterou by student mohl dosáhnout účastí v této aktivitě kurzu.';
$string['indicator:potentialcognitivedef'] = 'Potenciální kognitivní hloubka kurzu';
$string['indicator:potentialcognitivedef_help'] = 'Míra, do jaké kurz nabízí „hluboké“ kognitivní zapojení, např. odevzdání práce pro zpětnou vazbu, možnost přezkoumat práci ostatních a příležitost revidovat a znovu odevzdat práci.';
$string['indicator:potentialcognitivedef_link'] = 'Learning_analytics_indicators#Cognitive_depth';
$string['indicator:potentialsocial'] = 'Potenciální sociální šířce kurzu';
$string['indicator:potentialsocial_help'] = 'Tento ukazatel je založen na potenciálním sociální šířce, kterou by student mohl dosáhnout účastí v této aktivitě kurzu.';
$string['indicator:potentialsocialdef'] = 'Potenciální sociální šíře kurzu';
$string['indicator:potentialsocialdef_help'] = 'Míra, v níž kurz nabízí „široké“ sociální angažování, interakce s ostatními účastníky a se společenstvím praxe mimo třídu.';
$string['indicator:potentialsocialdef_link'] = 'Learning_analytics_indicators#Social_breadth';
$string['indicator:readactions'] = 'Číst počet akcí';
$string['indicator:readactions_help'] = 'Tento ukazatel představuje počet čtených (zobrazených) akcí studentů.';
$string['indicator:userforumstracking'] = 'Uživatel sleduje fórum';
$string['indicator:userforumstracking_help'] = 'Tento ukazatel vyjadřuje, zda student ve fórech zapíná sledování nebo ne.';
$string['info'] = 'Informace';
$string['inprogress'] = 'Probíhá';
$string['insertcontentbefore'] = 'Vložit obsah před "{$a->activityname}"';
$string['insertcontentsection'] = 'Vložit obsah do sekce "{$a->sectionname}"';
$string['insertresourceoractivitybefore'] = 'Vložit aktivitu nebo zdroj před "{$a->activityname}"';
$string['institution'] = 'Instituce';
$string['instudentview'] = 'v pohledu studenta';
$string['interests'] = 'Zájmy';
$string['interestslist'] = 'Zájmy a koníčky';
$string['interestslist_help'] = 'Zadejte své zájmy, oddělené čárkami. Vaše zájmy budou zobrazeny na stránce vašeho profilu jako štítky.';
$string['invalidemail'] = 'Neplatná e-mailová adresa';
$string['invalidlogin'] = 'Neplatné přihlášení, zkuste znovu';
$string['invalidtaskclassname'] = 'Neplatná třída úlohy {$a}';
$string['invalidtaskid'] = 'Neplatné ID úlohy';
$string['invalidusername'] = 'Uživatelské jméno může obsahovat pouze malá písmena, číslice, podtržítko (_), pomlčku (-), tečku (.) nebo zavináč (@)';
$string['invalidusernameupload'] = 'Neplatné uživatelské jméno';
$string['ip_address'] = 'IP adresa';
$string['jump'] = 'Přejít';
$string['jumpto'] = 'Přejít na...';
$string['keep'] = 'Uchovat';
$string['labelvalue'] = '{$a->label}: {$a->value}';
$string['langltr'] = 'Psát zleva doprava';
$string['langrtl'] = 'Psát zprava doleva';
$string['language'] = 'Jazyk';
$string['languagegood'] = 'Tento jazykový balíček je aktuální.';
$string['languageselector'] = 'Volba jazyka';
$string['last'] = 'Poslední';
$string['lastaccess'] = 'Poslední přístup';
$string['lastcourseaccess'] = 'Poslední přístup do kurzu';
$string['lastedited'] = 'Naposledy upraveno';
$string['lastip'] = 'Poslední IP adresa';
$string['lastlogin'] = 'Poslední přihlášení';
$string['lastmodified'] = 'Naposledy změněno';
$string['lastname'] = 'Příjmení';
$string['lastnamephonetic'] = 'Příjmení - foneticky';
$string['lastpage'] = 'Poslední stránka';
$string['lastsiteaccess'] = 'Poslední přístup';
$string['lastyear'] = 'Poslední rok';
$string['latestlanguagepack'] = 'Zkontrolovat poslední verzi jazykového balíčku na moodle.org';
$string['layouttable'] = 'Uspořádání tabulky';
$string['leavetokeep'] = 'Ponechte prázdné, chcete-li zachovat dosavadní heslo.';
$string['legacylogginginuse'] = 'Tento web má aktuálně povolen zápis do zastaralého přehledu. Zápis do tohoto úložiště je odmítnut. Změňte zápis na podporované úložiště přehledu , jako je "standard" nebo "externí".';
$string['legacythemeinuse'] = 'Tyto stránky se vám zobrazují v režimu kompatibility, protože používáte zastaralý prohlížeč.';
$string['license'] = 'Licence';
$string['licenses'] = 'Licence';
$string['liketologin'] = 'Chcete se nyní přihlásit jako plnohodnotný uživatel?';
$string['list'] = 'Seznam';
$string['listfiles'] = 'Seznam souborů v {$a}';
$string['listofallpeople'] = 'Seznam všech osob';
$string['listofcourses'] = 'Seznam kurzů';
$string['loading'] = 'Nahrávání';
$string['loadinghelp'] = 'Nahrávám ...';
$string['local'] = 'Lokální';
$string['localplugins'] = 'Lokální moduly';
$string['localpluginsmanage'] = 'Správa lokálních modulů';
$string['location'] = 'Umístění';
$string['locktimeout'] = 'Při čekání na uzamčení vypršel časový limit operace.';
$string['log_excel_date_format'] = 'yyyy mmmm d h:mm';
$string['loggedinas'] = 'Jste přihlášeni jako {$a}';
$string['loggedinasguest'] = 'Momentálně na stránky přistupujete s právy hosta.';
$string['loggedinnot'] = 'Nejste přihlášeni';
$string['login'] = 'Přihlášení';
$string['login_failure_logs'] = 'Protokoly o neúspěšných pokusech o přihlášení';
$string['loginactivity'] = 'Přehled přihlášení';
$string['loginagain'] = 'Přihlaste se znovu';
$string['loginalready'] = 'Již jste přihlášeni jako';
$string['loginas'] = 'Přihlásit se jako';
$string['loginaspasswordexplain'] = '<p>Pro použití této funkce musíte zadat speciální heslo.<br />Pokud toto heslo neznáte, vyžádejte si jej od správce těchto stránek.</p>';
$string['loginguest'] = 'Přístup jako host';
$string['loginsite'] = 'Přihlásit se na stránky';
$string['loginsteps'] = 'K plnému přístupu na tyto stránky, musíte nejprve vytvořit účet.';
$string['loginstepsnone'] = '<p>Zdravím!</p>
<p>K plnému přístupu do kurzů si budete muset vytvořit uživatelský účet.</p>
<p>Stačí vám pouze vymyslet si uživatelské jméno a heslo a zadat jej do formuláře na této stránce!</p>
<p>Pokud vás někdo předběhl a vaše uživatelské jméno si již zaregistroval, budete to muset zkusit znovu s jiným jménem.</p>';
$string['loginto'] = 'Přihlášení do {$a}';
$string['logoof'] = 'Logo {$a}';
$string['logout'] = 'Odhlásit se';
$string['logoutconfirm'] = 'Opravdu se chcete odhlásit?';
$string['logs'] = 'Protokoly';
$string['logtoomanycourses'] = '[ <a href="{$a->url}">více</a> ]';
$string['logtoomanyusers'] = '[ <a href="{$a->url}">více</a> ]';
$string['lookback'] = 'Zpětně';
$string['mailadmins'] = 'Informuj správce';
$string['mailstudents'] = 'Informuj studenty';
$string['mailteachers'] = 'Informuj učitele';
$string['maincoursepage'] = 'Hlavní stránka kurzu';
$string['makeafolder'] = 'Vytvořit složku';
$string['makeavailable'] = 'Zpřístupnit';
$string['makeeditable'] = 'Nastavíte-li práva k "{$a}" tak, aby do něj mohl zapisovat proces webového serveru (např. apache), budete moci upravovat tento soubor přímo na této stránce.';
$string['makethismyhome'] = 'Z této stránky vytvořit moji domovskou stránku';
$string['makeunavailable'] = 'Vytvořit nepřístupné';
$string['manageblocks'] = 'Bloky';
$string['managecategories'] = 'Správa kategorií kurzů';
$string['managecategorythis'] = 'Spravovat tuto kategorii';
$string['managecombined'] = 'Správa kategorií kurzů a kurzů';
$string['managecontentbanktypes'] = 'Správa typů obsahu';
$string['managecourses'] = 'Správa kurzů';
$string['managedatabase'] = 'Správa databáze';
$string['managedataformats'] = 'Správa datových formátů';
$string['manageeditorfiles'] = 'Spravovat soubory používané editorem';
$string['managefilters'] = 'Filtry';
$string['managemodules'] = 'Moduly';
$string['manageroles'] = 'Role a oprávnění';
$string['markallread'] = 'Označit vše jako přečtené';
$string['match'] = 'Přiřadit';
$string['matchingsearchandrole'] = 'Odpovídá \'{$a->search}\' a {$a->role}';
$string['matchofthefollowing'] = 'z následujících:';
$string['maxareabytesreached'] = 'Velikost souboru (nebo celková velikost všech souborů) převyšuje nastavený limit pro tuto oblast.';
$string['maxfilesize'] = 'Maximální velikost nových souborů: {$a}';
$string['maxfilesreached'] = 'K této položce máto povoleno připojit maximálně {$a} souborů';
$string['maximumchars'] = 'Maximálně {$a} znaků';
$string['maximumgrade'] = 'Nejlepší známka';
$string['maximumgradex'] = 'Nejvyšší známka: {$a}';
$string['maximumshort'] = 'Max';
$string['maximumupload'] = 'Maximální velikost nahrávaných souborů';
$string['maximumupload_help'] = 'Maximální velikost souboru, který mohou do kurzu vložit studenti. Navíc můžete dále omezit maximální velikost nahrávání pro každou aktivitu.';
$string['maxlengthreached'] = 'Byl dosažen maximální počet znaků {$a}.';
$string['maxnumberweeks'] = 'Maximální počet sekcí (zastaralé)';
$string['maxnumberweeks_desc'] = 'Maximální hodnota v rozbalovací nabídce počtu sekcí (platí pouze pro určité formáty kurzů). Toto nastavení je zastaralé a bude v budoucí verzi Moodlu odstraněno. Použijte prosím místo toho nastavení formátu kurzu.';
$string['maxnumcoursesincombo'] = 'Zobrazit <a href="{$a->link}">seznam všech {$a->numberofcourses} kurzů</a>';
$string['maxsectionslimit'] = 'Nelze vytvořit novou sekci, protože by překročila maximální počet sekcí povolených pro tento kurz ({$a}).';
$string['maxsize'] = 'Maximální velikost: {$a}';
$string['maxsizeandareasize'] = 'Maximální velikost pro nové soubory: {$a->size}, celkový limit: {$a->areasize}';
$string['maxsizeandattachments'] = 'Maximální velikost souborů: {$a->size}, maximální počet souborů: {$a->attachments}';
$string['maxsizeandattachmentsandareasize'] = 'Maximální velikost pro soubory: {$a->size}, maximální počet příloh: {$a->attachments}, maximální celková velikost: {$a->areasize}';
$string['memberincourse'] = 'Lidé v kurzu';
$string['menu'] = 'Nabídka';
$string['message'] = 'Zpráva';
$string['messagebody'] = 'Tělo zprávy';
$string['messagedselectedusers'] = 'Zpráva byla odeslána vybraným uživatelům a seznam příjemců byl resetován.';
$string['messagedselectedusersfailed'] = 'Objevily se problémy při odesílání zprávy vybraným uživatelům. Někteří z nich mohou obdržet e-mail.';
$string['messageprovider:asyncbackupnotification'] = 'Oznámení o asynchronním zálohování / obnovení';
$string['messageprovider:availableupdate'] = 'Jsou dostupná oznámení o aktualizacích';
$string['messageprovider:backup'] = 'Zprávy o záloze';
$string['messageprovider:badgecreatornotice'] = 'Oznámení tvůrce Odznaku';
$string['messageprovider:badgerecipientnotice'] = 'Oznámení příjemce Odznaku';
$string['messageprovider:competencyplancomment'] = 'Komentář zveřejněný na studijním plánu';
$string['messageprovider:competencyusercompcomment'] = 'Komentář zveřejněné ke kompetenci';
$string['messageprovider:coursecompleted'] = 'Kurz dokončen';
$string['messageprovider:coursecontentupdated'] = 'Změny obsahu kurzu';
$string['messageprovider:courserequestapproved'] = 'Schválení žádosti o založení kurzu';
$string['messageprovider:courserequested'] = 'Nová žádost o založení kurzu';
$string['messageprovider:courserequestrejected'] = 'Zamítnutí žádosti o založení kurzu';
$string['messageprovider:enrolcoursewelcomemessage'] = 'Uvítací zpráva pro nové zápisy do kurzu';
$string['messageprovider:errors'] = 'Důležité chyby stránek';
$string['messageprovider:errors_help'] = 'Toto jsou důležité chyby, o kterých by měl vědět správce';
$string['messageprovider:failedtaskmaxdelay'] = 'Úloha dosáhne maximálního zpoždění při selhání';
$string['messageprovider:gradenotifications'] = 'Oznámení hodnocení';
$string['messageprovider:infected'] = 'Oznámení o selhání antiviru.';
$string['messageprovider:insights'] = 'Poznatky vygenerované modely předpovědí';
$string['messageprovider:instantmessage'] = 'Osobní vzkazy mezi uživateli';
$string['messageprovider:instantmessage_help'] = 'Tato sekce obsahuje nastavení toho, co se děje se zprávami, které Vám byly poslány jinými uživateli těchto stránek. ';
$string['messageprovider:messagecontactrequests'] = 'Zpráva žádosti o kontakt';
$string['messageprovider:newlogin'] = 'Nová oznámení na přihlášení';
$string['messageprovider:notices'] = 'Upozornění na menší problémy';
$string['messageprovider:notices_help'] = 'Toto jsou různá upozornění, která by mohla zajímat správce.';
$string['messageprovider:reportbuilderschedule'] = 'Naplánován generátor vlastních sestav';
$string['messageselect'] = 'Vybrat uživatele jako příjemce e-mailu';
$string['messageselectadd'] = 'Poslat zprávu';
$string['middlename'] = 'Druhé jméno';
$string['migratinggrades'] = 'Migrace známek';
$string['min'] = 'min.';
$string['mins'] = 'min.';
$string['minute'] = 'minuta';
$string['minutes'] = 'minut';
$string['miscellaneous'] = 'Různé';
$string['missingcategory'] = 'Musíte vybrat kategorii';
$string['missingdescription'] = 'Chybí popis';
$string['missingemail'] = 'Chybí e-mailová adresa';
$string['missingfirstname'] = 'Chybí křestní jméno';
$string['missingfromdisk'] = 'Chybí na disku';
$string['missingfullname'] = 'Chybí celý název';
$string['missinglastname'] = 'Chybí příjmení';
$string['missingname'] = 'Chybí název';
$string['missingnewpassword'] = 'Chybí nové heslo';
$string['missingpassword'] = 'Chybí heslo';
$string['missingrecaptchachallengefield'] = 'Chyba výzvy reCAPTCHA, zkuste to znovu.';
$string['missingreqreason'] = 'Chybí důvod';
$string['missingshortname'] = 'Chybí krátký název';
$string['missingshortsitename'] = 'Chybí krátký název stránek';
$string['missingsitedescription'] = 'Chybí popis stránek';
$string['missingsitename'] = 'Chybí název stránek';
$string['missingstrings'] = 'Najít nepřeložené texty';
$string['missingstudent'] = 'Musíte někoho vybrat';
$string['missingsummary'] = 'Chybí souhrn';
$string['missingteacher'] = 'Musíte někoho vybrat';
$string['missingurl'] = 'Chybí URL';
$string['missingusername'] = 'Chybí uživatelské jméno';
$string['moddoesnotsupporttype'] = 'Modul {$a->modname} nepodporuje nahrávání souboru typu {$a->type}';
$string['modhidden'] = 'Dostupnost';
$string['modhidden_help'] = '* Skrýt na stránce kurzu: Není k dispozici studentům. Tento modul nelze studentům zobrazit.';
$string['modhide'] = 'Skrýt';
$string['modified'] = 'Změněno';
$string['modshow'] = 'Ukázat';
$string['moduleintro'] = 'Popis';
$string['modulesetup'] = 'Nastavování tabulek modulů';
$string['modulesuccess'] = 'Tabulky modulu "{$a}" byly korektně nastaveny';
$string['modulesused'] = 'Použité moduly';
$string['modvisible'] = 'Dostupnost';
$string['modvisible_help'] = '* Zobrazit na stránce kurzu: Dostupné pro studenty (v závislosti na omezení přístupu, která mohou být nastavena).
* Skrýt na stránce kurzu: Není k dispozici studentům.';
$string['modvisiblehiddensection'] = 'Dostupnost';
$string['modvisiblehiddensection_help'] = '* Skrýt na stránce kurzu: Není k dispozici studentům.
* Zpřístupnit, ale nezobrazovat na stránce kurzu: Dostupné studentům, pokud poskytnete odkaz. Aktivity se budou i nadále zobrazovat v přehledu hodnocení a dalších přehledech.';
$string['modvisiblewithstealth'] = 'Dostupnost';
$string['modvisiblewithstealth_help'] = '* Zobrazit na stránce kurzu: Dostupné pro studenty (v závislosti na omezení přístupu, která mohou být nastavena).
* Skrýt na stránce kurzu: Není k dispozici studentům.
* Zpřístupnit, ale nezobrazovat na stránce kurzu: Dostupné studentům, pokud poskytnete odkaz. Aktivity se budou i nadále zobrazovat v přehledu hodnocení a dalších přehledech.';
$string['month'] = 'Měsíc';
$string['months'] = 'Měsíce';
$string['moodledocs'] = 'Dokumentace Moodle';
$string['moodledocslink'] = 'Dokumentace pro tuto stránku (anglicky)';
$string['moodlelogo'] = 'Moodle logo';
$string['moodlenet:cannotconnecttoserver'] = 'Nelze se připojit k serveru MoodleNet';
$string['moodlenet:columnname'] = 'Název';
$string['moodlenet:columnsenddate'] = 'Odeslat datum';
$string['moodlenet:columnsendstatus'] = 'Odeslat stav';
$string['moodlenet:columntype'] = 'Typ';
$string['moodlenet:configoauthservice'] = 'Vybrat službu MoodleNet OAuth 2 a povolit sdílení na této stránce MoodleNet. Pokud služba ještě neexistuje, budete ji muset <a href="{$a}">vytvořit</a>.';
$string['moodlenet:deletedactivity'] = 'Smazaná aktivita';
$string['moodlenet:deletedcourse'] = 'Smazaný kurz';
$string['moodlenet:eventresourceexported'] = 'Zdroj exportován';
$string['moodlenet:gotomoodlenet'] = 'Přejít na koncepty MoodleNet';
$string['moodlenet:issuerisnotauthorized'] = 'Vydavatel MoodleNet není autorizovaný';
$string['moodlenet:issuerisnotenabled'] = 'Vydavatel MoodleNet není povolen';
$string['moodlenet:issuerisnotset'] = 'Vydavatel MoodleNet není nastaven v administraci webu';
$string['moodlenet:nosharedresources'] = 'V tuto chvíli nejsou k dispozici žádné sdílené zdroje k zobrazení.';
$string['moodlenet:outboundsettings'] = 'Nastavení odchozí sítě MoodleNet';
$string['moodlenet:packagingandsending'] = 'Zabalení souboru a odeslání na MoodleNet...';
$string['moodlenet:sharefailtext'] = 'Při sdílení vašeho obsahu na MoodleNet došlo k chybě.<br>Zkuste to prosím znovu později.';
$string['moodlenet:sharefailtextwithsitesupport'] = 'Při sdílení vašeho obsahu na MoodleNet došlo k chybě.<br>Zkuste to znovu později nebo <a href="{$a}">kontaktujte podporu webu</a>.';
$string['moodlenet:sharefailtitle'] = 'Něco se pokazilo';
$string['moodlenet:sharefilesizelimitexceeded'] = 'Velikost sdíleného prostředku ({$a->filesize} bajtů) překračuje limit {$a->filesizelimit} bajtů.';
$string['moodlenet:sharenoticeactivity'] = 'Tato aktivita je sdílena s MoodleNet jako zdroj.';
$string['moodlenet:sharenoticecourse'] = 'Tento kurz je sdílen s MoodleNet jako zdroj.';
$string['moodlenet:sharenoticepartial'] = 'Vybrané aktivity jsou sdíleny s MoodleNet jako zdroj.';
$string['moodlenet:sharenoticepartialactivitynumber'] = 'Do kurzu bude zahrnuto {$a} aktivit.';
$string['moodlenet:shareprogress'] = 'Průběh sdílení na MoodleNet';
$string['moodlenet:shareprogressinfo'] = 'Seznam zobrazuje kurzy a aktivity, které jste sdíleli na MoodleNet.<br>Kliknutím na název zdroje zobrazíte v MoodleNet.';
$string['moodlenet:sharesuccesstext'] = 'Skoro hotovo! Navštivte své koncepty v MoodleNet a dokončete sdílení svého obsahu.';
$string['moodlenet:sharesuccesstitle'] = 'Uloženo do konceptů MoodleNet';
$string['moodlenet:sharetomoodlenet'] = 'Sdílet na MoodleNet';
$string['moodlenet:sharinglargefile'] = 'Velké soubory mohou chvíli trvat.';
$string['moodlenet:sharingstatus'] = 'Sdílení na MoodleNet';
$string['moodlenet:sharingto'] = 'Sdílení s:';
$string['moodlerelease'] = 'Verze Moodlu';
$string['moodleservicesandsupport'] = 'Služby a podpora';
$string['moodleversion'] = 'Verze Moodlu';
$string['more'] = 'více';
$string['moreactions'] = 'Další akce';
$string['morehelp'] = 'Oficiální dokumentace (anglicky)';
$string['morehelpaboutmodule'] = 'Další nápověda k činnosti {$a}';
$string['moreinfo'] = 'Více informací';
$string['moreinformation'] = 'Více informací o této chybě';
$string['moremenu'] = 'Další';
$string['morenavigationlinks'] = 'Více...';
$string['moreprofileinfoneeded'] = 'Prosíme, sdělte nám o sobě něco bližšího';
$string['mostrecently'] = 'nejnovější';
$string['move'] = 'Přesunout';
$string['movecategoriessuccess'] = 'Úspěšně přesunuty {$a->count} kategorie do kategorie  "{$a->to}"';
$string['movecategoriestotopsuccess'] = 'Úspěšně přesunuto {$a->count} kategorií do nejvyšší úrovně';
$string['movecategorycontentto'] = 'Přesunout do';
$string['movecategorysuccess'] = 'Kategorie "{$a->moved}" úspěšně přesunuta do kategorie "{$a->to}"';
$string['movecategoryto'] = 'Přesunout kategorii do:';
$string['movecategorytotopsuccess'] = 'Kategorie "{$a->moved}" úspěšně přesunuta do nejvyšší úrovně';
$string['movecontent'] = 'Přesun {$a}';
$string['movecontentafter'] = 'Po "{$a}"';
$string['movecontentstoanothercategory'] = 'Přesunout obsah do jiné kategorie';
$string['movecontenttothetop'] = 'Na začátek seznamu';
$string['movecoursemodule'] = 'Přesunout činnost';
$string['movecoursesection'] = 'Přesunout sekci';
$string['movecourseto'] = 'Přesunout kurz do:';
$string['movedown'] = 'Přesunout dolů';
$string['movefilestohere'] = 'Přesunout soubory sem';
$string['movefull'] = 'Přesunout {$a} do tohoto umístění';
$string['movehere'] = 'Přesunout sem';
$string['moveitemdown'] = 'Posunout {$a} dolů';
$string['moveitemup'] = 'Posunout {$a} nahoru';
$string['moveleft'] = 'Přesunout doleva';
$string['moveright'] = 'Přesunout doprava';
$string['movesection'] = 'Přesunout sekci {$a}';
$string['moveselectedcategoriesto'] = 'Přesun vybraných kategorií do';
$string['moveselectedcoursesto'] = 'Přesunout vybrané kurzy do...';
$string['movetoanotherfolder'] = 'Přesunout do jiné složky';
$string['moveup'] = 'Přesunout nahoru';
$string['multipleitemsfound'] = 'Nalezeno {$a} položek.';
$string['mustchangepassword'] = 'Nové heslo musí být jiné než stávající';
$string['mustconfirm'] = 'Musíte potvrdit svůj účet';
$string['mycourses'] = 'Moje kurzy';
$string['myfiles'] = 'Osobní soubory';
$string['myfilesmanage'] = 'Spravovat osobní soubory';
$string['myhome'] = 'Nástěnka';
$string['mymoodledashboard'] = 'Moje nástěnka';
$string['myprofile'] = 'Můj profil';
$string['name'] = 'Název';
$string['namedfiletoolarge'] = 'Soubor "{$a->filename}" je příliš velký a nelze nahrát';
$string['nameforlink'] = 'Jak chcete nazvat tento odkaz?';
$string['nameforpage'] = 'Název';
$string['navigation'] = 'Navigace';
$string['needed'] = 'Potřebné';
$string['networkdropped'] = 'Systém zjistil, že vaše připojení k Internetu je nespolehlivé nebo bylo přerušeno.<br />
Dokud nedojde ke zlepšení, změny nemohou být uloženy.';
$string['never'] = 'Nikdy';
$string['neverdeletelogs'] = 'Nikdy nemazat protokoly';
$string['new'] = 'Nový';
$string['newaccount'] = 'Nový účet';
$string['newactivityname'] = 'Nový název pro aktivitu {$a}';
$string['newcourse'] = 'Nový kurz';
$string['newloginnotificationbodyfull'] = '<p>Dobrý den, {$a->userfullname},</p>
 <p>Váš účet {$a->sitename} byl právě přihlášen z nového zařízení.</p>
<ul>
<li>Váš účet: {$a->username} {$a->useremail}</li>
<li>{$a->logintime}</li>
<li>Zařízení: {$a->logindevice}</li>
<li>IP: {$a->loginip}</li>
</ul>
<p>Pokud jste to byli vy, nemusíte dělat nic.</p>
<p>Pokud tuto aktivitu nepoznáváte, <a href="{$a->changepasswordlink}">změňte si heslo</a></p>';
$string['newloginnotificationbodysmall'] = 'Váš účet {$a} byl právě přihlášen z nového zařízení.';
$string['newloginnotificationtitle'] = 'Nové přihlášení k vašemu účtu {$a}';
$string['newpassword'] = 'Nové heslo';
$string['newpassword_help'] = 'Vložte nové heslo nebo ponechte prázdné pro zachování stávajícího';
$string['newpasswordfromlost'] = '<strong>Poznámka:</strong> Vaše <strong>stávající heslo</strong> vám bude zasláno v <strong>druhém</strong> ze dvou e-mailů zaslaných v rámci procesu obnovy zapomenutého hesla. Než budete pokračovat, ujistěte se, že jste obdrželi své náhradní heslo.';
$string['newpasswordtext'] = 'Zdravím, vy budete asi {$a->firstname}, že?

Vaše staré heslo na stránkách "{$a->sitename}" bylo vymazáno  a bylo vám přiděleno nové dočasné heslo.

Při přihlášení nyní zadejte
  uživatelské jméno: {$a->username}
  heslo: {$a->newpassword}
(Po prvním přihlášení si budete muset toto heslo změnit)

Přihlásit na stránky "{$a->sitename}" se můžete na adrese:
{$a->link}

Ve většině e-mailových programů by se vám tato adresa měla zobrazit jako odkaz, na který stačí kliknout. Pokud tomu tak není, zkopírujte si adresu do schránky a vložte ji do adresního řádku ve svém webovém prohlížeči.

Toto je automaticky generovaný e-mail. Není nutné na něj odpovídat jeho odesílateli. Potřebujete-li pomoc, spojte se se správcem stránek.

S pozdravem
{$a->signoff}
správce stránek "{$a->sitename}"';
$string['newpicture'] = 'Nový obrázek';
$string['newpicture_help'] = '<p>Zde můžete na svém počítači vybrat svoji fotografii a uložit ji na server.
Tato fotografie vás potom bude reprezentovat na různých místech těchto
stránek.</p>

<p>Z tohoto důvodu je nejlepší fotografie vašeho obličeje, ale můžete použít i
jiný obrázek.</p>

<p>Obrázek musí být ve formátu JPEG nebo PNG (nejčastěji tedy bude mít příponu
.jpg nebo .png).</p>

<p>Soubor s obrázkem lze získat různými způsoby:</p>

<ol>
  <li>Můžete použít digitální fotoaparát, ten již většinou ukládá fotografie v
  požadovaném formátu.</li>

  <li>Můžete si naskenovat svoji klasickou, papírovou fotografii. Výsledný
  obrázek uložte ve formátu JPEG nebo PNG.</li>

  <li>Obrázek můžete nakreslit v některém z grafických editorů.</li>

  <li>Poslední možností je vyhledat obrázky na webu. <a target="google" href=
  "http://images.google.com/">http://images.google.com</a> je skvělé místo, kde
  můžete obrázky vyhledávat. Pokud se vám některý zalíbí, klikněte na něj
  pravým tlačítkem myši a v nabídce zvolte "Uložit obrázek jako..." (různé
  prohlížeče se mohou v textu nabídky mírně lišit).</li>
</ol>

<p>Pro uložení obrázku na server klikněte na tlačítko "Procházet" na této
stránce a vyberte soubor s vaším obrázkem.</p>

<p>Poznámka: Ujistěte se, že soubor není větší než maximální dovolená velikost,
jinak nebude moci být na server uložen.</p>

<p>Poté klikněte na tlačítko "Aktualizovat profil". Váš obrázek bude oříznut na
čtvercový tvar a zmenšen na velikost 100 x 100 pixelů.</p>

<p>Až se vrátíte zpět na stránku s vaším profilem, možná budete muset kliknout
na tlačítko "Aktualizovat"/"Obnovit", aby prohlížeč znovu načetl stránku s
novou fotografií..</p>';
$string['newpictureusernotsetup'] = 'Profilový obrázek může být přidán pro všechny potřebné údaje profilu, aby byly uloženy najednou.';
$string['newsectionname'] = 'Nový název sekce {$a}';
$string['newsitem'] = 'novinka';
$string['newsitems'] = 'oznámení';
$string['newsitemsnumber'] = 'Kolik oznámení zobrazovat';
$string['newsitemsnumber_help'] = 'Oznámení fóra má ve výchozím nastaveno vynucený odběr. Přispívat do něj mohou pouze učitelé a další uživatelé s příslušným oprávněním.

Pokud nepotřebujete fórum pro oznámení, toto nastavte na nulu.

Toto nastavení také určuje, kolik posledních oznámení se objeví v bloku Poslední oznámení.';
$string['newuser'] = 'Nový uživatel';
$string['newusernewpasswordsubj'] = 'Nový uživatelský účet';
$string['newusernewpasswordtext'] = 'Zdravíme{$a->firstname},

Byl pro vás vytvořen účet na stránkách "{$a->sitename}".


  uživatelské jméno: {$a->username}
  heslo: {$a->newpassword}

(Při prvním přihlášení budete vyzváni ke změně hesla.)

Chcete-li začít používat {$a->sitename}", přihlaste se na {$a->link} "

Pokud potřebujete pomoc, můžete kontaktovat správce webu,
{$a->signoff}';
$string['newusers'] = 'Noví uživatelé';
$string['newwindow'] = 'Nové okno';
$string['next'] = 'Další';
$string['nextpage'] = 'Další stránka';
$string['nextsection'] = 'Další sekce';
$string['no'] = 'Ne';
$string['noblockstoaddhere'] = 'Neexistují bloky, které by mohly být přidány na tuto stránku.';
$string['nobody'] = 'Nikdo';
$string['nochange'] = 'Beze změny';
$string['nocomments'] = 'Bez komentářů';
$string['nocourses'] = 'Žádné kurzy';
$string['nocoursesfound'] = 'Nebyly nalezeny žádné kurzy obsahující "{$a}"';
$string['nocoursestarttime'] = 'Kurz nemá datum zahájení.';
$string['nocoursesyet'] = 'Žádný kurz v této kategorii';
$string['nodstpresets'] = 'Správce nepovolil podporu letního a zimního času (DST).';
$string['nofilesselected'] = 'Nebyly vybrány žádné soubory k obnově';
$string['nofilesyet'] = 'Do kurzu ještě nebyly vloženy žádné soubory.';
$string['nofiltersapplied'] = 'Nebyly použity žádné filtry';
$string['nograde'] = 'Bez známky';
$string['nohelpforactivityorresource'] = 'Pro tuto činnost nebo studijní materiál není k dispozici žádný popis.';
$string['noimagesyet'] = 'Do kurzu ještě nebyly vloženy žádné obrázky.';
$string['noitemsfound'] = 'Nebyly nalezeny žádné položky.';
$string['nologsfound'] = 'Nebyly nalezeny žádné protokoly';
$string['nomatchingusers'] = 'Žádní uživatelé neodpovídají "{$a}"';
$string['nomorecourses'] = 'Nebylo možno najít více odpovídajících kurzů.';
$string['nomoreidnumber'] = 'Z důvodu předcházení kolizí se již nepoužívá idnumber.';
$string['none'] = 'Žádný';
$string['noneditingteacher'] = 'Učitel bez práva upravovat';
$string['noneditingteacherdescription'] = 'Učitelé bez práva upravovat mohou učit v kurzech a známkovat studenty, nemohou však měnit činnosti.';
$string['nonstandard'] = 'Nestandardní';
$string['nopendingcourses'] = 'Žádné kurzy čekající na schválení';
$string['nopotentialadmins'] = 'Žádní správci k dispozici';
$string['nopotentialcreators'] = 'Žádní tvůrci kurzů k dispozici';
$string['nopotentialstudents'] = 'Žádní studenti k dispozici';
$string['nopotentialteachers'] = 'Žádní učitelé k dispozici';
$string['norecentactivity'] = 'Žádná nedávná činnost';
$string['noreplybouncemessage'] = 'Odpoveděli jste na adresu, na kterou nelze zasílat e-maily. Pokud jste se pokoušeli odpovídat na příspěvek v diskusním fóru, zašlete vaši odpověď přímo do příslušného diskusního fóra na stránkách "{$a}".

Následuje obsah vašeho e-mailu:';
$string['noreplybouncesubject'] = '{$a} - vrácený e-mail';
$string['noreplyname'] = 'Neodpovídejte na tento e-mail';
$string['noresetrecord'] = 'Neexistuje žádný záznam žádosti o obnovu hesla. Prosím, znovu zažádejte o resetování hesla.';
$string['noresults'] = 'Bez výsledků';
$string['noresultsfor'] = 'Žádné výsledky pro „{$a}“';
$string['noresultsfor_help'] = 'Zkontrolujte si pravopis nebo zkuste jiná slova.';
$string['normal'] = 'Normalní';
$string['normalfilter'] = 'Normální vyhledávání';
$string['nosite'] = 'Nelze najít kurzy na úrovni stránek';
$string['nostudentsfound'] = 'Nenalezeni žádní {$a}';
$string['nostudentsingroup'] = 'V této skupině dosud nejsou žádní studenti.';
$string['nostudentsyet'] = 'Do kurzu ještě nejsou zapsáni žádní studenti.';
$string['nosuchemail'] = 'Taková e-mailová adresa není registrována';
$string['notavailable'] = 'Není dostupné';
$string['notavailablecourse'] = '{$a} není dostupné';
$string['noteachersyet'] = 'V tomto kurzu ještě nejsou žádní učitelé.';
$string['noteachingupcomingcourses'] = 'Nadcházející kurzy nemají žádné učitele ani studenty';
$string['notenrolled'] = '{$a} není zapsán(a) do tohoto kurzu.';
$string['notenrolledprofile'] = 'Profil není dostupný, protože úživatel není zapsán v tomto kurzu';
$string['noteusercannotrolldatesoncontext'] = '<strong>Poznámka:</strong> Možnost posunu termínů při obnově této zálohy byla zakázána, protože nemáte potřebné oprávnění.';
$string['noteuserschangednonetocourse'] = '<strong>Poznámka:</strong> Pokud obnovujete uživatelské údaje, je nutné obnovit také uživatele kurzu. Toto nastavení bylo za vás změněno.';
$string['nothingnew'] = 'Žádná nedávná činnost';
$string['nothingtodisplay'] = 'Nic k zobrazení';
$string['notice'] = 'Poznámka';
$string['noticenewerbackup'] = 'Tato záloha byla vytvořena v Moodlu {$a->backuprelease} ({$a->backupversion}) a je novější, než vaše stávající instalace Moodlu {$a->serverrelease} ({$a->serverversion}). To může vést k nekonzistencím, protože u záloh nelze zaručit zpětnou kompatibilitu.';
$string['notifications'] = 'Informace';
$string['notifyloginfailuresmessage'] = '{$a->time}, IP: {$a->ip}, Uživatel: {$a->info}, Celé jméno: {$a->name}';
$string['notifyloginfailuresmessageend'] = 'Tyto protokoly si můžete prohlédnout zde: {$a}';
$string['notifyloginfailuresmessagestart'] = 'Zde je seznam neuspesnych pokusu o prihlaseni na {$a} od doby zaslani predchoziho upozorneni';
$string['notifyloginfailuressubject'] = '{$a} :: Upozorneni na neuspesna prihlaseni';
$string['notincluded'] = 'Nezahrnuto';
$string['notingroup'] = 'Je nám líto, ale musíte být součástí skupiny a zobrazit  tuto stránku.';
$string['notpublic'] = 'Neveřejné!';
$string['nousersfound'] = 'Nenalezeni žádní uživatelé';
$string['nousersmatching'] = 'Na dotaz "{$a}" nebyl nalezen žádný uživatel.';
$string['nousersyet'] = 'Ještě nejsou k dispozici žádní uživatelé.';
$string['novalidcourses'] = 'Žádné kurzy k zobrazení';
$string['now'] = 'nyní';
$string['numattempts'] = '{$a} neúspěšných pokusů o přihlášení';
$string['numberofcourses'] = 'Počet kurzů ';
$string['numberweeks'] = 'Počet sekcí';
$string['numday'] = '{$a} den';
$string['numdays'] = '{$a} dnech';
$string['numhours'] = '{$a} hodin';
$string['numletters'] = '{$a} znaků';
$string['numminutes'] = '{$a} minut';
$string['nummonth'] = '{$a} měsíc';
$string['nummonths'] = '{$a} měsíců';
$string['numseconds'] = '{$a} sekund';
$string['numviews'] = '{$a} zobrazení';
$string['numweek'] = '{$a} týden';
$string['numweeks'] = '{$a} týdnů';
$string['numwords'] = '{$a} slov';
$string['numyear'] = '{$a} rok';
$string['numyears'] = '{$a} roků';
$string['ok'] = 'OK';
$string['oldpassword'] = 'Stávající heslo';
$string['olduserdirectory'] = 'Toto je STARÝ adresář uživatelů, který již není používán. Můžete jej bezpečně odstranit. Soubory, které obsahoval, byly zkopírovány do NOVÉHO adresáře uživatelů.';
$string['oneitemfound'] = 'Nalezena 1 položka.';
$string['opendrawerblocks'] = 'Otevřít panel bloku';
$string['opendrawerindex'] = 'Otevřít indexu kurzu';
$string['opensinnewwindow'] = 'Otevře se v novém okně';
$string['opensinnewwindowbracketed'] = '(Otevřít v novém okně)';
$string['operator_and'] = 'a';
$string['operator_andnot'] = 'a';
$string['operator_or'] = 'nebo';
$string['optional'] = 'volitelné';
$string['options'] = 'možnosti';
$string['order'] = 'Pořadí';
$string['originalpath'] = 'Původní umístění';
$string['orphanedactivitiesinsectionno'] = 'Osiřelé činnosti (sekce {$a})';
$string['other'] = 'Jiný';
$string['outline'] = 'Stručný';
$string['outlinereport'] = 'Stručná sestava';
$string['page'] = 'Stránka';
$string['pagea'] = 'Stránka {$a}';
$string['pagedcontentnavigation'] = 'Navigace stránkování';
$string['pagedcontentnavigationactiveitem'] = 'Aktuální stránka, stránka {$a}';
$string['pagedcontentnavigationitem'] = 'Jdi na stránku {$a}';
$string['pagedcontentpagingbaritemsperpage'] = 'Zobrazit {$a} položek na stránku';
$string['pageheaderconfigablock'] = 'Konfigurace bloku v {$a->fullname}';
$string['pagepath'] = 'Cesta ke stránce';
$string['pageshouldredirect'] = 'Tato stránka by vás měla automaticky přesměrovat. Pokud se tak nestalo, použijte, prosím, následující odkaz.';
$string['parentcategory'] = 'Nadřazená kategorie';
$string['parentcoursenotfound'] = 'Nadřazený kurz nenalezen!';
$string['parentfolder'] = 'Nadřazená složka';
$string['participants'] = 'Účastníci';
$string['participantslist'] = 'Seznam účastníků';
$string['participationratio'] = 'Poměr participace';
$string['participationreport'] = 'Protokol participace';
$string['password'] = 'Heslo';
$string['passwordchanged'] = 'Heslo bylo změněno';
$string['passwordextlink'] = 'Pomocí následujícího odkazu můžete obnovit své zapomenuté heslo. Kliknutím na odkaz opustíte stránky Moodlu.';
$string['passwordforgotten'] = 'Zapomenuté heslo';
$string['passwordforgotteninstructions'] = 'Nejprve je potřeba vyhledat údaje o vašem účtu v databázi uživatelů. Prosím, zadejte <strong>buď</strong> své uživatelské jméno, <strong>nebo</strong> registrovaný e-mail. Není potřeba vyplňovat obě pole.';
$string['passwordforgotteninstructions2'] = 'Pro resetování hesla níže vložte své uživatelské jméno nebo emailovou adresu. Pokud se podaří Vás najít v databázi, bude na Vaší e-mailovou adresu odeslán mail s instrukcemi, jak znova získat přístup.';
$string['passwordpolicynomatch'] = 'Vaše aktuální heslo již neodpovídá nastaveným zásadám pro hesla.
   {$a}';
$string['passwordsdiffer'] = 'Tato hesla nejsou shodná.';
$string['passwordset'] = 'Vaše heslo bylo nastaveno.';
$string['path'] = 'Cesta';
$string['pathnotexists'] = 'Taková cesta na serveru neexistuje!!';
$string['pathslasherror'] = 'Cesta nesmí končit lomítkem.';
$string['paymentinstant'] = 'Pomocí tlačítka níže provedete platbu a zaregistrujete se během několika minut.';
$string['paymentpending'] = '(<small><strong><u>{$a}</u></strong> čeká</small>)';
$string['paymentrequired'] = 'Tento kurz je placený';
$string['payments'] = 'Platby';
$string['paymentsorry'] = 'Děkujeme za vaši platbu. Až bude zpracována, budete moci vstoupit do kurzu {$a->fullname}. Počkejte prosím a zkuste to znovu. Pokud potíže přetrvávají, kontaktujte {$a->teacher} nebo administrátora stránek.';
$string['paymentthanks'] = 'Děkujeme za vaši platbu. Nyní jste zapsáni do kurzu {$a}.';
$string['pendingrequests'] = 'Čekající žádosti';
$string['percents'] = '{$a} %';
$string['periodending'] = 'Období do ({$a})';
$string['perpage'] = 'Na stránku';
$string['perpagea'] = 'Na stránku: {$a}';
$string['personal'] = 'Osobní';
$string['personalprofile'] = 'Osobní profil';
$string['phone'] = 'Telefon';
$string['phone1'] = 'Telefon';
$string['phone2'] = 'Mobilní telefon';
$string['phpinfo'] = 'PHP info';
$string['picture'] = 'Obrázek';
$string['pictureof'] = 'Obrázek: {$a}';
$string['pictureofuser'] = 'Profilové foto';
$string['placeholdertypeorselect'] = 'Zadat nebo vyberat ...';
$string['pleaseclose'] = 'Prosím zavřete toto okno';
$string['pleasesearchmore'] = 'Prosím, hledejte dál';
$string['pleaseusesearch'] = 'Prosím, použijte vyhledávání';
$string['plugin'] = 'Modul';
$string['pluginarea'] = 'Pole';
$string['plugincheck'] = 'Kontrola zásuvných modulů';
$string['plugindeletefiles'] = 'Všechna data náležící modulu "{$a->name}" byla odstraněna z databáze. Nyní byste měli odstranit adresář "{$a->directory}" na vašem serveru a zabránit tak reinstalace tohoto modulu.';
$string['pluginitemid'] = 'ID položky';
$string['pluginmissingfromdisk'] = '{$a->name} (Chybí na disku)';
$string['pluginsetup'] = 'Nastavení tabulek zásuvných modulů';
$string['policyaccept'] = 'Rozumím a souhlasím';
$string['policyagree'] = 'Před dalším používáním těchto stránek musíte souhlasit s těmito pravidly. Souhlasíte s nimi?';
$string['policyagreement'] = 'Souhlas s pravidly používání stránek';
$string['policyagreementclick'] = 'Pravidla používání těchto stránek';
$string['popup'] = 'nové okno';
$string['popupwindow'] = 'Otevřít soubor v novém okně';
$string['popupwindowname'] = 'Nové okno';
$string['post'] = 'Příspěvek';
$string['posts'] = 'Příspěvky';
$string['potentialadmins'] = 'Správci k dispozici';
$string['potentialcreators'] = 'Tvůrci k dispozici';
$string['potentialstudents'] = 'Studenti k dispozici';
$string['potentialteachers'] = 'Učitelé k dispozici';
$string['poweredbymoodle'] = 'Používá <a href="https://moodle.com"> Moodle </a>';
$string['preferences'] = 'Předvolby';
$string['preferredlanguage'] = 'Upřednostňovaný jazyk';
$string['preferredtheme'] = 'Upřednostňovaný motiv';
$string['preprocessingbackupfile'] = 'Předpříprava souboru zálohy';
$string['prev'] = 'Předchozí';
$string['preview'] = 'Náhled';
$string['previeworchoose'] = 'Vybrat motiv';
$string['previewthemename'] = 'Náhled motivu "{$a}"';
$string['previous'] = 'Předchozí';
$string['previouslyselectedusers'] = 'Naposledy vyhledaní uživatelé, kteří neodpovídají "{$a}"';
$string['previouspage'] = 'Předchozí stránka';
$string['previoussection'] = 'Předchozí sekce';
$string['primaryadminsetup'] = 'Nastavení účtu správce';
$string['privacy:metadata:config_log'] = 'Záznam změn konfigurace.';
$string['privacy:metadata:config_log:name'] = 'Název nastavení změn.';
$string['privacy:metadata:config_log:oldvalue'] = 'Předchozí hodnota pro toto nastavení.';
$string['privacy:metadata:config_log:plugin'] = 'Doplněk byl změněn.';
$string['privacy:metadata:config_log:timemodified'] = 'Čas provedení změny.';
$string['privacy:metadata:config_log:userid'] = 'Uživatel, který změnu provedl.';
$string['privacy:metadata:config_log:value'] = 'Nová hodnota pro toto nastavení.';
$string['privacy:metadata:events_queue'] = 'Fronta událostí uživatele čekajících na zpracování.';
$string['privacy:metadata:events_queue:eventdata'] = 'Data uložená v dané události.';
$string['privacy:metadata:events_queue:stackdump'] = 'Jakékoliv stacktrace spojené s touto událostí.';
$string['privacy:metadata:events_queue:timecreated'] = 'Čas vytvoření události.';
$string['privacy:metadata:events_queue:userid'] = 'ID uživatele spojené s touto událostí';
$string['privacy:metadata:log'] = 'Sbírka minulých událostí';
$string['privacy:metadata:log:action'] = 'Popis akce';
$string['privacy:metadata:log:cmid'] = 'cmid';
$string['privacy:metadata:log:course'] = 'kurz';
$string['privacy:metadata:log:info'] = 'Dodatečné informace';
$string['privacy:metadata:log:ip'] = 'IP Adresa používaná v době události';
$string['privacy:metadata:log:module'] = 'modul';
$string['privacy:metadata:log:time'] = 'Čas uskutečnění akce';
$string['privacy:metadata:log:url'] = 'URL Adresa týkající se události';
$string['privacy:metadata:log:userid'] = 'ID uživatele, který danou akci provedl';
$string['privacy:metadata:moodlenet_share_progress'] = 'Podrobnosti o postupu sdílení MoodleNet';
$string['privacy:metadata:moodlenet_share_progress:cmid'] = 'ID přidruženého modulu kurzu';
$string['privacy:metadata:moodlenet_share_progress:courseid'] = 'ID přidruženého kurzu';
$string['privacy:metadata:moodlenet_share_progress:resourceurl'] = 'Vrácená adresa URL z MoodleNet po úspěšném sdílení';
$string['privacy:metadata:moodlenet_share_progress:status'] = 'Výsledný stav sdílení';
$string['privacy:metadata:moodlenet_share_progress:timecreated'] = 'Čas provedení sdílení';
$string['privacy:metadata:moodlenet_share_progress:type'] = 'Typ sdílené položky, která byla provedena';
$string['privacy:metadata:moodlenet_share_progress:userid'] = 'Uživatel, který provedl sdílení';
$string['privacy:metadata:oauth2_refresh_token'] = 'Obnovit token používaný v komunikaci OAuth 2.0';
$string['privacy:metadata:oauth2_refresh_token:issuerid'] = 'ID poskytovatele, kterému token odpovídá';
$string['privacy:metadata:oauth2_refresh_token:scopehash'] = 'ID uživatele, kterému token odpovídá';
$string['privacy:metadata:oauth2_refresh_token:timecreated'] = 'Čas, kdy byl token vytvořen';
$string['privacy:metadata:oauth2_refresh_token:timemodified'] = 'Čas, kdy byl token naposledy aktualizován';
$string['privacy:metadata:oauth2_refresh_token:token'] = 'Obnovovací token pro příslušné obory a uživatele';
$string['privacy:metadata:oauth2_refresh_token:userid'] = 'ID uživatele, kterému token odpovídá';
$string['privacy:metadata:shortlink'] = 'Podrobnosti krátkého odkazu URL';
$string['privacy:metadata:shortlink:component'] = 'Komponenta spojená s krátkým odkazem';
$string['privacy:metadata:shortlink:identifier'] = 'Jedinečný identifikátor spojený s krátkým odkazem';
$string['privacy:metadata:shortlink:linktype'] = 'Typ odkazu, kterým lze krátký odkaz identifikovat';
$string['privacy:metadata:shortlink:shortcode'] = 'Krátký kód, který se má použít pro krátký odkaz';
$string['privacy:metadata:shortlink:userid'] = 'ID uživatele spojeného s krátkým odkazem';
$string['privacy:metadata:task_adhoc'] = 'Stav adhoc úloh.';
$string['privacy:metadata:task_adhoc:component'] = 'Komponenta vlastního úlohy.';
$string['privacy:metadata:task_adhoc:nextruntime'] = 'Dřívější čas spuštění úlohy.';
$string['privacy:metadata:task_adhoc:userid'] = 'Uživatel spouštějící úlohy.';
$string['privacy:metadata:task_log'] = 'Výstup protokolu';
$string['privacy:metadata:task_log:component'] = 'Komponenta vlastnící úlohy.';
$string['privacy:metadata:task_log:userid'] = 'Uživatel, kterému úloha náleží.';
$string['privacy:metadata:upgrade_log'] = 'Aktualizační protokol.';
$string['privacy:metadata:upgrade_log:backtrace'] = 'Jakákoli backtrace spojená s tímto krokem aktualizace.';
$string['privacy:metadata:upgrade_log:details'] = 'Další informace týkající se aktualizace.';
$string['privacy:metadata:upgrade_log:info'] = 'Hlavní informace pro tento krok aktualizace.';
$string['privacy:metadata:upgrade_log:plugin'] = 'Modul, který byl aktualizován.';
$string['privacy:metadata:upgrade_log:targetversion'] = 'Nová verze ne kterou je aktualizace.';
$string['privacy:metadata:upgrade_log:timemodified'] = 'Čas provedení upgradu.';
$string['privacy:metadata:upgrade_log:type'] = 'Typ záznamu protokolu.';
$string['privacy:metadata:upgrade_log:userid'] = 'Uživatel, který spustil aktualizaci.';
$string['privacy:metadata:upgrade_log:version'] = 'Stará verze doplňku.';
$string['private_files_handler'] = 'Uložit přílohy z e-mailu do osobních souborů uživatele.';
$string['private_files_handler_name'] = 'E-mail do osobních souborů';
$string['privatefiles'] = 'Osobní soubory';
$string['privatefilesmanage'] = 'Spravovat osobní soubory';
$string['proceed'] = 'Pokračovat';
$string['profile'] = 'Profil';
$string['profilenotshown'] = 'Popis se nezobrazí, dokud nebude tento uživatel zapsán alespoň v jednom kurzu.';
$string['progress'] = 'Pokrok';
$string['publicprofile'] = 'Veřejný profil';
$string['publicsitefileswarning'] = 'Poznámka: sem umístěné soubory jsou přístupné komukoliv';
$string['publicsitefileswarning2'] = 'Poznámka: sem umístěné soubory jsou dostupné každému, kdo zná (nebo uhádne) jejich URL. Z bezpečnostních důvodů se doporučuje odstranit všechny soubory záloh ihned po jejich obnově.';
$string['publicsitefileswarning3'] = 'Poznámka: sem umístěné soubory jsou dostupné každému, kdo zná (nebo uhádne) jejich URL.<br />Z bezpečnostních důvodů by měly být soubory se zálohou ukládány pouze do složek backupdata, ke kterým mají přístup pouze oprávnění uživatelé.';
$string['question'] = 'Otázka';
$string['questionsinthequestionbank'] = 'Úlohy v bance úloh';
$string['queued'] = 'Ve frontě';
$string['quotausage'] = 'Právě jste použili {$a->used} z vašeho {$a->total} limitu.';
$string['readinginfofrombackup'] = 'Čtení informací ze zálohy';
$string['readme'] = 'README';
$string['recentactivity'] = 'Nedávná činnost';
$string['recentactivityreport'] = 'Úplná sestava o nedávné činnosti...';
$string['recipientslist'] = 'Seznam příjemců';
$string['recommended'] = 'Doporučeno';
$string['recreatedcategory'] = 'Přetvořená kategorie {$a}';
$string['redirect'] = 'Přesměrovat';
$string['reducesections'] = 'Snížit počet témat';
$string['refresh'] = 'Obnovit';
$string['refreshingevents'] = 'Obnovování událostí';
$string['registration'] = 'Registrace';
$string['registrationcontact'] = 'Kontakt';
$string['registrationcontactno'] = 'Ne, nechci být kontaktováni jinými lidmi';
$string['registrationcontactyes'] = 'Ano, chci poskytnout uživatelům Moodle kontaktní formulář, aby se na mě mohli obrátit.';
$string['registrationemail'] = 'Upozorňování e-mailem';
$string['registrationinfo'] = '<p>Zde si můžete zaregistrovat vaše stránky na moodle.org. Registrace je zdarma. Hlavní výhodou registrace je, že budete zařazeni do seznamu odběratelů občasných důležitých oznámení (upozornění týkající se bezpečnosti či informace o nových verzích Moodlu).<p>Poskytnuté informace jsou považovány za důvěrné a nebudou nikdy a nikomu prodány nebo předány. Jediným důvodem pro jejich shromažďování je snaha o podporu uživatelů, a lepší statistické zachycení komunity uživatelů Moodle jako celku.<p>Budete-li si to přát, mohou být název vaší stránky, země a URL umístěny na veřejný seznam stránek používajících Moodle.<p>Před umístěním na tento seznam je vaše nová registrace ručně ověřena. Jste-li jednou na seznam zařazeni, můžete jak registraci, tak i zveřejněné údaje kdykoliv sami aktualizovat prostým opětovným odesláním tohoto formuláře.';
$string['registrationinfotitle'] = 'Registrační informace';
$string['registrationsend'] = 'Odeslat údaje o registraci na moodle.org';
$string['registrationyes'] = 'Ano, upozorněte mě na nové verze Moodle, bezpečnostní upozornění a další důležité zprávy';
$string['reject'] = 'Odmítnout';
$string['rejectdots'] = 'Odmítnout...';
$string['relativedatesmode'] = 'Režim relativních dat';
$string['relativedatesmode_help'] = 'Zobrazit data kurzu nebo aktivity ve vztahu k datu zahájení kurzu uživatelem.

Datum zahájení kurzu uživatele bude datum zápisu, pokud není zapsán před začátkem kurzu. V takovém případě bude datum zahájení začátek kurzu.

VAROVÁNÍ: Toto je experimentální funkce a ne všechny aktivity ji mohou podporovat. Po vytvoření kurzu již toto nastavení kurzu již nelze změnit.';
$string['relativedatesmode_warning'] = '<strong> Upozornění: </strong> Režim relativních dat nelze po vytvoření kurzu změnit.';
$string['reload'] = 'Obnovit';
$string['remoteappuser'] = 'Vzdálený uživatel {$a}';
$string['remove'] = 'Odstranit';
$string['removeadmin'] = 'Odstranit správce';
$string['removecreator'] = 'Odstranit tvůrce kurzů';
$string['removed'] = 'Odstraněno {$a}';
$string['removestudent'] = 'Odstranit studenta';
$string['removeteacher'] = 'Odstranit učitele';
$string['rename'] = 'Přejmenovat';
$string['renamefileto'] = 'Přejmenovat <b>{$a}</b> na';
$string['report'] = 'Sestava';
$string['reports'] = 'Sestavy';
$string['reporttype'] = 'Typ sestavy';
$string['repositories'] = 'Repozitáře';
$string['requestcourse'] = 'Požádat o založení kurzu';
$string['requestedby'] = 'Žadatel';
$string['requestedcourses'] = 'Požadované kurzy';
$string['requestreason'] = 'Důvody pro založení';
$string['requests'] = 'Žádosti';
$string['required'] = 'Vyžadováno';
$string['requirespayment'] = 'Přístup do tohoto kurzu je placený';
$string['resendemail'] = 'Znovu odeslat potvrzovací e-mail';
$string['reset'] = 'Reset';
$string['resetcomponent'] = 'Komponenta';
$string['resetcourse'] = 'Resetovat kurz';
$string['resetcourseconfirm'] = 'Resetovat kurz?';
$string['resetcoursewarning'] = 'Opravdu chcete resetovat kurz "{$a}"? <br/><br/>
Tím se vymažou vybraná data a kurz se vrátí do původního stavu. Tuto akci nelze vrátit zpět.';
$string['resetinfo'] = 'Tato funkce umožňuje vymazat všechna uživatelská data a vrátit kurz do původního stavu. Aktivity a nastavení kurzu zůstanou nezměněny.';
$string['resetinfoselect'] = 'Vyberte data, která chcete smazat nebo resetovat, z kategorií níže:';
$string['resetnotimplemented'] = 'Reset není podporován';
$string['resetnotimplementedinfo'] = 'Tyto aktivity nelze resetovat:';
$string['resetrecordexpired'] = 'Použili jste odkaz na resetování hesla, který je více než {$a} minut starý a je již neplatný. Vytvořte prosím novou žádost o resetování hesla.';
$string['resetstartdate'] = 'Nastavit datum začátku na';
$string['resetstatus'] = 'Stav';
$string['resettable'] = 'Obnovit tabulku předvoleb';
$string['resettask'] = 'Reset';
$string['resettodefaults'] = 'Nastavit na výchozí hodnoty';
$string['resortcourses'] = 'Uspořádat kurzy';
$string['resortsubcategoriesby'] = 'Seřadit podkategorie podle {$a} (vzestupně)';
$string['resortsubcategoriesbyreverse'] = 'Seřadit podkategorie podle {$a} (sestupně)';
$string['resource'] = 'Studijní materiál';
$string['resource_type'] = 'Typ zdroje';
$string['resourcedisplayauto'] = 'Automaticky';
$string['resourcedisplaydownload'] = 'Vynutit stažení';
$string['resourcedisplayembed'] = 'Vsadit do stránky';
$string['resourcedisplayframe'] = 'V rámci';
$string['resourcedisplaynew'] = 'Nové okno';
$string['resourcedisplayopen'] = 'Otevřít';
$string['resourcedisplaypopup'] = 'Pop-up okno';
$string['resources'] = 'Studijní materiály';
$string['resources_help'] = 'Různé typy studijních materiálů umožňují vkládat do kurzu téměř jakýkoliv webový obsah.';
$string['restore'] = 'Obnovit';
$string['restorecancelled'] = 'Obnova přerušena';
$string['restorecannotassignroles'] = 'Pro obnovení této zálohy by bylo potřeba přiřadit uživatelské role, ale na to nemáte dostatečná oprávnění';
$string['restorecannotcreateorassignroles'] = 'Pro obnovení této zálohy by bylo potřeba vytvořit nebo přiřadit uživatelské role, ale na to nemáte dostatečná oprávnění';
$string['restorecannotcreateuser'] = 'Pro obnovení této zálohy by bylo potřeba vytvořit nového uživatele "{$a}", ale na to nemáte dostatečná oprávnění';
$string['restorecannotoverrideperms'] = 'Pro obnovení této zálohy by bylo potřeba lokálně přenastavit pravomoci rolí, ale na to nemáte dostatečná oprávnění';
$string['restorecoursenow'] = 'Obnovit tento kurz!';
$string['restoredaccount'] = 'Obnovený účet';
$string['restoredaccountinfo'] = 'Tento uživatelský účet byl importován z jiného serveru a je potřeba u něj znovu nastavit heslo. Pro nastavení nového hesla pomocí emailu zvolte "Pokračovat"';
$string['restorefinished'] = 'Obnova úspěšně dokončena';
$string['restoreinfo'] = 'Použít záložní soubor k obnovení předchozí verze kurzu nebo k vytvoření nového kurzu.';
$string['restoremnethostidmismatch'] = 'Mnet ID uživatele "{$a}" neodpovídá lokálnímu Mnet ID hostitele.';
$string['restoreto'] = 'Obnovit do';
$string['restoretositeadding'] = 'Upozornění: Obnova přidá data na vaši titulní stránku!';
$string['restoretositedeleting'] = 'Upozornění: Obnova odstraní stávající obsah z vaší titulní stránky a nahradí jej novým!';
$string['restoreuserconflict'] = 'Obnovení uživatele "{$a}" ze zálohy by vedlo ke konfliktu v seznamu uživatelů';
$string['restoreuserinfofailed'] = 'Proces obnovy byl přerušen, nemáte oprávnění obnovovat data uživatelů.';
$string['restoreusersprecheck'] = 'Kontrola uživatelských účtů';
$string['restoreusersprecheckerror'] = 'Při kontrole uživatelských účtů byly zjištěny problémy';
$string['restricted'] = 'Nedostupné';
$string['resultsfound'] = 'Bylo nalezeno {$a} výsledků';
$string['retry'] = 'Opakovat';
$string['returningtosite'] = 'Vracíte se na tyto stránky?';
$string['returntooriginaluser'] = 'Zpět k {$a}';
$string['revert'] = 'Vrátit změny';
$string['role'] = 'Role';
$string['roleassignments'] = 'Přiřazení rolí';
$string['rolemappings'] = 'Mapování rolí';
$string['rolerenaming'] = 'Přejmenování rolí';
$string['rolerenaming_help'] = 'Změnit zobrazované názvy rolí v tomto kurzu.';
$string['rolerenaming_success'] = 'Názvy rolí kurzů byly aktualizovány.';
$string['roles'] = 'Role';
$string['rss'] = 'RSS';
$string['rssarticles'] = 'Počet posledních RSS článků';
$string['rsserror'] = 'Chyba při čtení RSS údajů';
$string['rsserrorauth'] = 'Váš RSS odkaz neobsahuje platný autentizační řetězec.';
$string['rsserrorguest'] = 'K tomuto zdroji zpráv přistupujete jako anonymní hosté, ale ti nemají oprávnění číst zdrojová data. Navštivte stránku, na které se nachází tento RSS zdroj jako přihlášený uživatel a získejte nové URL pro tento zdroj.';
$string['rsskeyshelp'] = '<p>Z důvodu vyššího zabezpečení a ochrany osobních údajů obsahují URL adresy poskytovaných RSS zdrojů speciální řetězec, který identifikuje daného uživatele. Tím je ostatním uživatelům zabráněno v neoprávněném přístupu do těch oblastí Moodle, kam by neměli mít přístup přes RSS.</p>
<p> Tento autentizační řetězec je pro vás automaticky vytvořen v okamžiku, kdy poprvé navštívíte oblast Moodle, která produkuje RSS kanál. Máte-li podezření, že došlo k vyzrazení tohoto řetězce, můžete si nechat vygenerovat nový pomocí odkazu "Reset". Stávající adresy URL k daným RSS kanálům se tímto zneplatní.</p>';
$string['rsstype'] = 'RSS kanál pro tuto aktivitu';
$string['save'] = 'Uložit';
$string['saveandnext'] = 'Uložit a ukázat další';
$string['savechanges'] = 'Uložit změny';
$string['savechangesanddisplay'] = 'Uložit a zobrazit';
$string['savechangesandreturn'] = 'Uložit a vrátit se';
$string['savechangesandreturntocourse'] = 'Uložit a vrátit se do kurzu';
$string['savecomment'] = 'Uložit komentář';
$string['savedat'] = 'Uloženo jako';
$string['savepreferences'] = 'Uložit předvolby';
$string['saveto'] = 'Ukládat do';
$string['scale'] = 'Škála';
$string['scale_help'] = '<p>Učitelé mohou vytvářet pro hodnocení jednotlivých činností v kurzu vlastní
škály.</p>

<p>Názvem škály by mělo být slovní spojení, které ji jasně popisuje; název se
zobrazuje v seznamech pro výběr škály a rovněž na tlačítkách kontextové
nápovědy.</p>

<p>Škála sama o sobě je definována vzestupným žebříčkem hodnocení, v němž jsou
jednotlivé položky odděleny čárkami. Příklad:</p>

<blockquote>
  <i>Neuspokojivý, Dostatečný, Průměrný, Dobrý, Velmi dobrý, Vynikající</i>
</blockquote>

<p>Škály by měly obsahovat také popis jednotlivých stupňů hodnocení a jejich
užití v praxi. Tento popis se bude zobrazovat na stránkách nápovědy.</p>

<p>Vaše stránky mohou také mít jednu či více „standardních“ škál, které pro
celý systém definuje správce. Tyto škály budou k dispozici ve všech
kurzech.</p>';
$string['scale_link'] = 'grade/scale';
$string['scales'] = 'Škály';
$string['scalescustom'] = 'Vlastní škály';
$string['scalescustomcreate'] = 'Přidat novou škálu';
$string['scalescustomno'] = 'Zatím nebyly vytvořeny žádné škály';
$string['scalesstandard'] = 'Standardní škály';
$string['scalestandard'] = 'Standardní škála';
$string['scalestandard_help'] = '<p>Standardní škála je dostupná ve všech kurzech na tomto serveru.</p>';
$string['scalestandard_link'] = 'grade/scale';
$string['scalestip'] = 'K vytvoření vlastních škál použijte odkaz \'Škály\' v panelu Správa ve svém kurzu.';
$string['scalestip2'] = 'Chcete-li si vytvořit vlastní škálu, jděte na hlavní stránce kurzu do nabídky Správa > Známky a tam zvolte akci Upravit > Škály.';
$string['schedule'] = 'Časový plán';
$string['screenshot'] = 'Náhled';
$string['search'] = 'Hledat';
$string['search_help'] = 'Pro základní hledávání jednoho nebo více slov v textu pouze napište tato slova oddělená mezerami. K vyhledání jsou použita pouze slova delší než dva znaky.

Pro pokročilé hledání klikněte na tlačítko Hledat, aniž byste do textového boxu cokoliv psali, čímž se Vám zobrazí formulář pro pokročilé hledávání.   ';
$string['searchactivities'] = 'Hledat aktivity podle názvu nebo popisu';
$string['searchagain'] = 'Hledat znovu';
$string['searchbyemail'] = 'Vyhledat podle mailové adresy';
$string['searchbyusername'] = 'Vyhledat podle uživatelského jména';
$string['searchcoursecategories'] = 'Hledat kategorie';
$string['searchcourses'] = 'Vyhledat kurzy';
$string['searchgroups'] = 'Hledat skupiny';
$string['searchitems'] = 'Hledat položky';
$string['searchoptions'] = 'Možnosti hledání';
$string['searchresults'] = 'Výsledky hledání';
$string['searchusers'] = 'Hledat uživatele';
$string['sec'] = 'sek.';
$string['seconds'] = 'sekundy';
$string['secondsleft'] = '{$a} sekund';
$string['secondstotime172800'] = '2 dny';
$string['secondstotime259200'] = '3 dny';
$string['secondstotime345600'] = '4 dny';
$string['secondstotime432000'] = '5 dnů';
$string['secondstotime518400'] = '6 dnů';
$string['secondstotime604800'] = '1 týden';
$string['secondstotime86400'] = '1 den';
$string['secretalreadyused'] = 'Odkaz na potvrzení změny hesla již byl použit. Heslo nebylo změněno.';
$string['secs'] = 'sekund';
$string['section'] = 'Sekce';
$string['sectionactionnotsupported'] = 'Akce sekce "{$a}" zde nejsou podporovány';
$string['sectionname'] = 'Název sekce';
$string['sectionoutline'] = 'Osnova sekce';
$string['sections'] = 'Sekce';
$string['seealsostats'] = 'Viz také: statistiky';
$string['selctauser'] = 'Vyberte uživatele';
$string['select'] = 'Výběr';
$string['selectacategory'] = 'Vyberte kategorii';
$string['selectacountry'] = 'Vyberte zemi';
$string['selectacourse'] = 'Vyberte kurz';
$string['selectacoursesite'] = 'Vyberte kurz nebo stránky';
$string['selectagroup'] = 'Vyberte skupinu';
$string['selectall'] = 'Vybrat vše';
$string['selectallusersonpage'] = 'Vyberte všechny uživatele na této stránce';
$string['selectalluserswithcount'] = 'Vyberte všechny {$a} uživatele';
$string['selectamodule'] = 'Prosím, vyberte modul činnosti';
$string['selectanaction'] = 'Vyberte akci';
$string['selectanoptions'] = 'Vyberte možnost';
$string['selectaregion'] = 'Vyberte oblast';
$string['selectcategorysort'] = 'Které kategorie si přejete řadit?';
$string['selectcategorysortby'] = 'Vyberte, jak chcete seřadit kategorie';
$string['selectcoursesortby'] = 'Vyberte, jak chcete seřadit kurzy';
$string['selectdates'] = 'Vyberte data';
$string['selectdefault'] = 'Vyberte výchozí';
$string['selectedcategories'] = 'Vybrané kategorie';
$string['selectedfile'] = 'Vybraný soubor';
$string['selectednowmove'] = '{$a} souborů označeno k přesunu. Nyní přejděte do cílového umístění a stiskněte tlačítko "Přesunout soubory sem"';
$string['selectfiles'] = 'Vybrat soubory';
$string['selectfiltertype'] = 'Výběr';
$string['selectgroupsseparate'] = 'Vybrat samostatné skupiny';
$string['selectgroupsvisible'] = 'Vybrat viditelné skupiny';
$string['selectitem'] = 'Vybrat "{$a}"';
$string['selectmoduletoviewhelp'] = 'Vyberte modul činnosti či typ studijního materiálu z nabídky pro zobrazení jeho popisu a nápovědy.

Dvojím kliknutím na název činnosti či studijního materiálu jej můžete rychle přidat do kurzu.';
$string['selectnos'] = 'Vybrat všechna NE';
$string['selectperiod'] = 'Vybrat období';
$string['selecttheme'] = 'Vybrat motiv';
$string['selectthemename'] = 'Vybrat motiv "{$a}"';
$string['senddetails'] = 'Odeslat mé údaje e-mailem';
$string['sent'] = 'Odesláno';
$string['separate'] = 'Individuální';
$string['separateandconnected'] = 'Individuální a Kolektivní způsoby poznávání';
$string['separateandconnected1'] = 'Vykazuje zejména individuální poznávání';
$string['separateandconnected2'] = 'Rovnoměrně individuální i kolektivní';
$string['separateandconnected3'] = 'Vykazuje zejména kolektivní poznávání';
$string['separateandconnectedinfo'] = 'Tato škála je založena na teorii individuálního a vztahového poznávání a učení. Tato teorie popisuje dva rozdílné způsoby, jimiž lidé usuzují a učí se o věcech kolem sebe.
<ul>
<li>Lidé s převažujícím <strong>individuálním poznáváním</strong> zůstávají objektivní a do poznávání nezapojují pocity a emoce. Když diskutují s lidmi odlišných názorů, rádi obhajují svůj vlastní pohled na věc a snaží se v názorech svých oponentů najít logické mezery. Jsou kritičtí k novým myšlenkám, pokud to nejsou ověřená fakta z uznávaných zdrojů, jako jsou učebnice, respektovaní učitelé nebo jejich vlastní přímá zkušenost.</li>
<li>Lidé s převažujícím <strong>vztahovým poznáváním</strong>
jsou nadáni empatií a obvykle naslouchají a kladou otázky, dokud necítí, že jsou schopni se "napojit na myšlení druhých" a rozumět věcem z jejich pohledu. Učí se tak, že se snaží sdílet zkušenosti, které vedly k získání určité znalosti u ostatních lidí. V diskusi se vyhýbají střetům a jsou připraveni logickými argumenty podpořit návrhy ostatních.</li>
</ul>';
$string['servererror'] = 'V komunikace se serverem se vyskytla chyba';
$string['serverlocaltime'] = 'Místní čas serveru';
$string['sessionforceclean'] = 'V rámci této relace byly jako bezpečnostní opatření zakázány skripty generované uživatelem.';
$string['sessiontimeoutsoon'] = 'Vaše relace vyprší. Chcete pokračovat ve své aktuální relaci?';
$string['setcategorytheme'] = 'Nastavit motiv kategorie';
$string['setmode'] = 'Nastavit režim';
$string['setpassword'] = 'Nastavit heslo';
$string['setpasswordinstructions'] = 'Zadejte prosím nové heslo a uložte změny.';
$string['settings'] = 'Nastavení';
$string['share'] = 'Sdílení';
$string['shortname'] = 'Krátký název';
$string['shortnamecollisionwarning'] = '[*] = Tento krátký název je již používán pro jiný kurz a bude potřeba jej změnit okamžitě po schválení.';
$string['shortnamecourse'] = 'Krátký název kurzu';
$string['shortnamecourse_help'] = 'Název zobrazený v oblastech s omezeným prostorem. Musí to být jedinečné.';
$string['shortnametaken'] = 'Krátký název je již použit pro jiný kurz ({$a}).';
$string['shortnameuser'] = 'Krátké jméno uživatele';
$string['shortsitename'] = 'Krátký název stránek (např. jedno slovo)';
$string['show'] = 'Ukázat';
$string['showactions'] = 'Zobrazit akce';
$string['showactivitydates'] = 'Zobrazit data aktivity';
$string['showactivitydates_help'] = 'Zobrazit data aktivit na stránce kurzu.';
$string['showadvancededitor'] = 'Pokročilé';
$string['showadvancedsettings'] = 'Ukázat pokročilá nastavení';
$string['showall'] = 'Ukázat všechny {$a}';
$string['showallcourses'] = 'Ukázat všechny kurzy';
$string['showblockcourse'] = 'Ukázat blok s kurzy';
$string['showcategory'] = 'Zobrazit {$a}';
$string['showchartdata'] = 'Zobrazit data grafu';
$string['showcomments'] = 'Ukázat/schovat komentáře';
$string['showcommentsnonjs'] = 'Ukázat komentáře';
$string['showdescription'] = 'Zobrazit popis na titulní straně kurzu';
$string['showdescription_help'] = 'Zda se má výše vložený úvodní popis zobrazit v osnově kurzu pod názvem příslušné činnosti nebo studijního materiálu.';
$string['showgrades'] = 'Ukázat studentům známky';
$string['showgrades_help'] = 'Umožněte studentům zobrazit seznam všech svých známek kurzu.';
$string['showingacourses'] = 'Ukázat všechny {$a} kurzy';
$string['showingxofycourses'] = 'Ukázat kurzy od {$a->start} do {$a->end} z {$a->total} kurzů';
$string['showless'] = 'Zobrazit méně';
$string['showlistofcourses'] = 'Ukázat seznam kurzů';
$string['showmodulecourse'] = 'Ukázat seznam kurzů, obsahujících činnost';
$string['showmore'] = 'Zobrazit více';
$string['showoncoursepage'] = 'Zobrazeno na stránce kurzu';
$string['showonly'] = 'Zobrazit pouze';
$string['showperpage'] = 'Ukázat {$a} na stránce';
$string['showpopovermenu'] = 'Otevřít vyskakovací okno';
$string['showpopoverwindow'] = 'Zobrazit vyskakovací okno';
$string['showrecent'] = 'Ukázat nedávnou činnost';
$string['showreports'] = 'Ukázat sestavu o činnosti';
$string['showreports_help'] = 'Umožněte studentům prohlížet si vlastní zprávy o činnosti prostřednictvím své profilové stránky.';
$string['showsettings'] = 'Ukázat nastavení';
$string['showtheselogs'] = 'Ukázat tyto protokoly';
$string['showthishelpinlanguage'] = 'Zobrazit tuto nápovědu v jazyce: {$a}';
$string['sidepanel'] = 'Boční panel';
$string['signoutofotherservices'] = 'Odhlaste se ze všech webových aplikací';
$string['signoutofotherservices_help'] = 'Odhlaste se ze všech zařízení a systémů, které používají webové služby, jako je mobilní aplikace. Relace prohlížeče zůstanou aktivní.';
$string['since'] = 'Od';
$string['sincelast'] = 'Od posledního přihlášení';
$string['site'] = 'Stránky';
$string['sitedefault'] = 'Výchozí';
$string['sitedefaultspecified'] = 'Výchozí stránka ({$a})';
$string['siteerrors'] = 'Chyby na stránkách';
$string['sitefiles'] = 'Soubory stránek';
$string['sitefilesused'] = 'Soubory stránek použité v tomto kurzu';
$string['sitehome'] = 'Titulní stránka';
$string['sitelegacyfiles'] = 'Soubory stránek';
$string['sitelogs'] = 'Protokoly stránek';
$string['sitenews'] = 'Oznámení stránek';
$string['sitepages'] = 'Hlavní nabídka';
$string['sitepartlist'] = 'Nemáte oprávnění potřebná k prohlížení seznamu účastníků';
$string['sitepartlist0'] = 'Pro zobrazení seznamu uživatelů musíte mít přidělenu roli vyučujícího';
$string['sitepartlist1'] = 'Pro zobrazení seznamu uživatelů musíte mít přidělenu roli vyučujícího';
$string['sites'] = 'Stránky';
$string['sitesection'] = 'Přidat vlastní obsah';
$string['sitesettings'] = 'Nastavení stránek';
$string['siteteachers'] = 'Vyučující na hlavní stránce';
$string['size'] = 'Velikost';
$string['sizeb'] = 'bytů';
$string['sizegb'] = 'GB';
$string['sizekb'] = 'KB';
$string['sizemb'] = 'MB';
$string['sizepb'] = 'PB';
$string['sizetb'] = 'TB';
$string['skipped'] = 'Přeskočeno';
$string['skiptocategorylisting'] = 'Přejít na seznam kategorií';
$string['skiptocoursedetails'] = 'Přejít na podrobné informace o kurzu';
$string['skiptocourselisting'] = 'Přejít na seznam kurzů';
$string['someallowguest'] = 'Některé kurzy umožňují vstup pro hosty';
$string['someerrorswerefound'] = 'Některé informace chyběly nebo nebyly správné. Podrobnosti jsou uvedeny níže.';
$string['sort'] = 'Setřídit';
$string['sortby'] = 'Třídit podle';
$string['sortbyx'] = 'Třídit dle {$a} vzestupně';
$string['sortbyxreverse'] = 'Třídit dle {$a} sestupně';
$string['sorting'] = 'Řazení';
$string['sourcerole'] = 'Zdrojová role';
$string['specifyname'] = 'Musíte určit název';
$string['standard'] = 'Standardní';
$string['starpending'] = '([*] = kurz čeká na schválení)';
$string['startdate'] = 'Datum začátku kurzu';
$string['startdate_help'] = 'Toto datum určuje začátek prvního týdne pro kurz v týdenním formátu. Je to také počáteční datum pro protokoly aktivit kurzu.

Pokud kurz resetujete a změníte toto datum, všechna data v kurzu budou přesunuta vzhledem k novému datu zahájení.';
$string['startdatewithtaskenabled'] = 'Datum zahájení kurzu';
$string['startdatewithtaskenabled_help'] = 'Datum, kdy se kurz stane pro studenty viditelným. Před tímto datem nebudou mít přístup do kurzu.

Toto datum také určuje začátek prvního týdne pro kurz v týdenním formátu a je počátečním datem pro protokoly aktivit kurzu. Pokud resetujete kurz a změníte toto datum, všechna data v kurzu budou posunuta vzhledem k novému datu zahájení.';
$string['startingfrom'] = 'Začíná od';
$string['startsignup'] = 'Začněte nyní vytvořením nového účtu!';
$string['state'] = 'Stát/Kraj';
$string['statistics'] = 'Statistiky';
$string['statisticsgraph'] = 'Graf statistiky';
$string['stats'] = 'Statistiky';
$string['statslogins'] = 'Přihlášení';
$string['statsmodedetailed'] = 'Podrobný pohled';
$string['statsmodegeneral'] = 'Obecný pohled';
$string['statsnodata'] = 'Pro tento kurz nejsou v uvedeném období k dispozici žádná data.';
$string['statsnodatauser'] = 'Pro tento kurz a uživatele nejsou v uvedeném období k dispozici žádná data.';
$string['statsoff'] = 'Statistiky nejsou momentálně povoleny';
$string['statsreads'] = 'Pohledy';
$string['statsreport1'] = 'Přihlášení';
$string['statsreport10'] = 'Činnost uživatele';
$string['statsreport11'] = 'Kurzy s nejvyšší aktivitou';
$string['statsreport12'] = 'Kurzy s nejvyšší aktivitou (váženo)';
$string['statsreport13'] = 'Kurzy s nejvyšší participací (podle zapsaných uživatelů)';
$string['statsreport14'] = 'Kurzy s nejvyšší participací (podle poměru příspěvky/prohlížení)';
$string['statsreport2'] = 'Prohlížení (všechny role)';
$string['statsreport3'] = 'Příspěvky (všechny role)';
$string['statsreport4'] = 'Veškerá činnost (všechny role)';
$string['statsreport5'] = 'Veškerá činnost (prohlížení a příspěvky)';
$string['statsreport7'] = 'Činnost uživatelů (prohlížení a příspěvky)';
$string['statsreport8'] = 'Veškerá činnost uživatelů';
$string['statsreport9'] = 'Přihlášení (na stránky)';
$string['statsreportactivity'] = 'Veškerá činnost (všechny role)';
$string['statsreportactivitybyrole'] = 'Veškerá činnost  (prohlížení a příspěvky)';
$string['statsreportforuser'] = 'pro';
$string['statsreportlogins'] = 'Přihlášení';
$string['statsreportreads'] = 'Prohlížení (všechny role)';
$string['statsreporttype'] = 'Typ sestavy';
$string['statsreportwrites'] = 'Příspěvky (všechny role)';
$string['statsstudentactivity'] = 'Činnost studentů';
$string['statsstudentreads'] = 'Prohlížení studenty';
$string['statsstudentwrites'] = 'Příspěvky studentů';
$string['statsteacheractivity'] = 'Činnost učitelů';
$string['statsteacherreads'] = 'Prohlížení učiteli';
$string['statsteacherwrites'] = 'Příspěvky učitelů';
$string['statstimeperiod'] = 'Během posledních:';
$string['statsuniquelogins'] = 'Unikátních přihlášení';
$string['statsuseractivity'] = 'Veškerá činnost';
$string['statsuserlogins'] = 'Přihlášení';
$string['statsuserreads'] = 'Prohlížení';
$string['statsuserwrites'] = 'Příspěvky';
$string['statswrites'] = 'Příspěvky';
$string['status'] = 'Stav';
$string['statuschecks'] = 'Kontroly stavu';
$string['statuscritical'] = 'Kritický';
$string['statusdone'] = 'Hotovo';
$string['statuserror'] = 'Chyba';
$string['statusinfo'] = 'Informace';
$string['statusna'] = 'N/A';
$string['statusok'] = 'OK';
$string['statusunknown'] = 'Neznámé';
$string['statuswarning'] = 'Varování';
$string['stringsnotset'] = 'Následující texty nejsou přeloženy v {$a}';
$string['studentnotallowed'] = 'Je mi líto, ale do tohoto kurzu nemůžete vstoupit jako "{$a}".';
$string['students'] = 'Studenti';
$string['studentsandteachers'] = 'Studenti a učitelé';
$string['subcategories'] = 'Podkategorie';
$string['subcategory'] = 'Podkategorie';
$string['subcategoryof'] = 'Podkategorie v {$a}';
$string['subject'] = 'Předmět';
$string['submit'] = 'Odeslat';
$string['subsectionmoveerror'] = 'Tuto podsekci nelze přesunout do jiné podsekce';
$string['success'] = 'Úspěch';
$string['successduration'] = 'Úspěch ({$a} sekund)';
$string['summary'] = 'Souhrn';
$string['suspended'] = 'Pozastaveno';
$string['suspendedusers'] = 'Pozastavení uživatelé';
$string['switchdevicedefault'] = 'Přepnout do standardního motivu';
$string['switchdevicerecommended'] = 'Přepnout do motivu pro vaše zařízení';
$string['switchrolereturn'] = 'Vrátit se k mé obvyklé roli';
$string['switchroleto'] = 'Přepnout roli na...';
$string['switchroleto_help'] = 'Vyberte roli, abyste získali představu o tom, jak někdo s touto rolí tento kurz uvidí.

Upozorňujeme, že tento pohled nemusí být dokonalý  (<a href="https://docs.moodle.org/en/Switch_roles">Zobrazit podrobnosti a alternativy</a>).';
$string['tag'] = 'Štítek';
$string['tagalready'] = 'Tento štítek již existuje';
$string['tagmanagement'] = 'Přidat/odebrat štítky';
$string['tags'] = 'Štítky';
$string['targetrole'] = 'Cílová role';
$string['teacheronly'] = 'pouze pro {$a}';
$string['teacherroles'] = '{$a} rolí';
$string['teachers'] = 'Učitelé';
$string['textcopiedtoclipboard'] = 'Text zkopírován do schránky';
$string['textediting'] = 'Textový editor';
$string['textediting_help'] = 'Je-li vybrán HTML editor, jako je Atto či TinyMCE, vstupní pole textu bude mít panel nástrojů s tlačítky pro snadné přidávání obsahu.

Je-li zvolen formát "Prostý text ", pro zadávání textu, lze zvolit formát jako je HTML nebo Markdown.

Seznam dostupných textových editorů je určen správcem těchto stránek.';
$string['texteditor'] = 'Použít standardní webové formuláře';
$string['textellipsis'] = '{$a}...';
$string['textformat'] = 'Prostý neformátovaný text';
$string['thanks'] = 'Díky';
$string['theme'] = 'Motiv';
$string['themepreviewdescription'] = '{$a} popis motivu';
$string['themepreviewimage'] = '{$a} náhledový obrázek';
$string['themes'] = 'Motivy';
$string['themesaved'] = 'Nový motiv uložen';
$string['therearecourses'] = 'Existuje {$a} kurzů';
$string['thereareno'] = 'V tomto kurzu nejsou žádní {$a}';
$string['thiscategory'] = 'Tato kategorie';
$string['thiscategorycontains'] = 'Tato kategorie obsahuje';
$string['time'] = 'Čas';
$string['timecreated'] = 'Čas vytvoření';
$string['timecreatedcourse'] = 'Čas založení kurzu';
$string['timesplitting:deciles'] = 'Poslední desetina';
$string['timesplitting:deciles_help'] = 'Tento interval analýzy rozděluje kurz na desetiny (10 stejných částí), přičemž každá predikce je založena na údajích pouze poslední poslední desetiny.';
$string['timesplitting:decilesaccum'] = 'Všechny předchozí desetiny';
$string['timesplitting:decilesaccum_help'] = 'Tato intervalová analýza dělí kurz na desetiny (10 stejných částí), přičemž každá předpověď je založena na datech všech předchozích desetin.';
$string['timesplitting:nosplitting'] = 'Bez časového limitu';
$string['timesplitting:nosplitting_help'] = 'Pro tento model není definován žádný interval analýzy.';
$string['timesplitting:onemonthafterstart'] = 'Jeden měsíc po začátku';
$string['timesplitting:onemonthafterstart_help'] = 'Tento interval analýzy generuje predikci 1 měsíc po analyzovatelném začátku.';
$string['timesplitting:oneweekafterstart'] = 'Jeden týden po začátku';
$string['timesplitting:oneweekafterstart_help'] = 'Tento interval analýzy generuje predikci 1 týden po analyzovatelném začátku.';
$string['timesplitting:past3days'] = 'Poslední 3 dny';
$string['timesplitting:past3days_help'] = 'Tento interval analýzy generuje předpovědi každé 3 dny. Výpočty ukazatelů budou založeny na posledních 3 dnech.';
$string['timesplitting:pastmonth'] = 'Minulý měsíc';
$string['timesplitting:pastmonth_help'] = 'Tento interval analýzy generuje předpovědi každý měsíc. Výpočty ukazatelů budou založeny na minulém měsíci.';
$string['timesplitting:pastweek'] = 'Minulý týden';
$string['timesplitting:pastweek_help'] = 'Tento interval analýzy generuje předpovědi každý týden. Výpočty ukazatelů budou založeny na minulém týdnu.';
$string['timesplitting:quarters'] = 'Poslední čtvrtina';
$string['timesplitting:quarters_help'] = 'Tato intervalová analýza dělí kurz na čtvrtiny (4 stejné části), přičemž každá předpověď je založena na datech všech předchozích čtvrtin.';
$string['timesplitting:quartersaccum'] = 'Všechny předchozí čtvrtiny';
$string['timesplitting:quartersaccum_help'] = 'Tato intervalová analýza dělí kurz na čtvrtiny (4 stejné části), přičemž každá předpověď je založena na datech všech předchozích čtvrtin.';
$string['timesplitting:singlerange'] = 'Od začátku do konce';
$string['timesplitting:singlerange_help'] = 'Tato intervalová analýza považuje celý kurz za jediný rozsah.';
$string['timesplitting:tenpercentafterstart'] = '10% po startu';
$string['timesplitting:tenpercentafterstart_help'] = 'Tento interval analýzy generuje predikci po dokončení 10% kurzu.';
$string['timesplitting:upcoming3days'] = 'Nadcházející 3 dny';
$string['timesplitting:upcoming3days_help'] = 'Tato intervalová analýza generuje předpovědi každé 3 dny. Výpočty ukazatelů budou vycházet z následujících 3 dnů.';
$string['timesplitting:upcomingfortnight'] = 'Nadcházející čtrnáct dní';
$string['timesplitting:upcomingfortnight_help'] = 'Tato intervalová analýza generuje předpovědi každých 14 dní. Výpočty ukazatelů budou vycházet z nadcházejících čtrnácti dnů.';
$string['timesplitting:upcomingweek'] = 'Nadcházející týden';
$string['timesplitting:upcomingweek_help'] = 'Tato intervalová analýza generuje předpovědi každý týden. Výpočty ukazatelů budou vycházet z nadcházejícího týdne.';
$string['timezone'] = 'Časové pásmo';
$string['tocontent'] = 'Za položku "{$a}"';
$string['tocreatenewaccount'] = 'Přeskočit na vytvoření nového účtu';
$string['todate'] = 'Do';
$string['today'] = 'Dnes';
$string['todaylogs'] = 'Dnešní protokol';
$string['toeveryone'] = 'komukoliv';
$string['toggleemojipicker'] = 'Přepnout výběr emodži';
$string['togglesearch'] = 'Přepnout vyhledávání';
$string['toomanybounces'] = 'Z této adresy se vrátilo příliš mnoho e-mailů jako nedoručitelných. <strong>MUSÍTE</strong> si ji změnit, pokud chcete pokračovat.';
$string['toomanytags'] = 'Toto hledání obsahuje příliš mnoho štítků; některé byly ignorovány.';
$string['toomanytoshow'] = 'Příliš mnoho uživatelů k zobrazení';
$string['toomanyusersmatchsearch'] = 'Příliš mnoho uživatelů ({$a->count}) odpovídajících "{$a->search}"';
$string['toomanyuserstoshow'] = 'Příliš mnoho uživatelů ({$a}) pro zobrazení';
$string['toonly'] = 'pouze pro {$a}';
$string['top'] = 'Nahoru';
$string['topic'] = 'Téma';
$string['toplevelcategory'] = 'Nejvyšší úroveň kategorie';
$string['torecipient'] = 'Do';
$string['total'] = 'Celkem';
$string['totopofsection'] = 'Na začátek sekce "{$a}"';
$string['trackforums'] = 'Zvýraznění nepřečtených příspěvků';
$string['trackforumsno'] = 'Ne: nechci zvýrazňovat nepřečtené příspěvky';
$string['trackforumsyes'] = 'Ano: chci zvýrazňovat nepřečtené příspěvky';
$string['trysearching'] = 'Zkuste raději vyhledávání.';
$string['turneditingoff'] = 'Vypnout režim úprav';
$string['turneditingon'] = 'Zapnout režim úprav';
$string['unabletocopytoclipboard'] = 'Nelze zkopírovat text do schránky';
$string['unauthorisedlogin'] = 'Uživatelský účet "{$a}" není v tomto systému dostupný';
$string['undecided'] = 'Nerozhodnuto';
$string['unexistingcmid'] = 'ID modulu kurzu nebyl nalezen';
$string['unexistingsectionid'] = 'ID sekce kurzu nebyla nalezena';
$string['unfinished'] = 'Nedokončeno';
$string['unknowncategory'] = 'Neznámá kategorie';
$string['unknownerror'] = 'Neznámá chyba';
$string['unknownuser'] = 'Neznámý uživatel';
$string['unlimited'] = 'Neomezeno';
$string['unpacking'] = 'Rozbaluji {$a}';
$string['unsafepassword'] = 'Příliš snadné heslo -- zkuste nějaké jiné';
$string['untilcomplete'] = 'Dokud není hotovo';
$string['unusedaccounts'] = 'Účty nepoužité po dobu delší než {$a} dnů jsou automaticky vyškrtnuty.';
$string['unzip'] = 'Rozbalit';
$string['unzippingbackup'] = 'Rozbaluji zálohu';
$string['up'] = 'Nahoru';
$string['update'] = 'Aktualizovat';
$string['updated'] = 'Aktualizováno {$a}';
$string['updatemymoodleoff'] = 'Vypnout úpravy této stránky';
$string['updatemymoodleon'] = 'Upravit tuto stránku';
$string['updatemyprofile'] = 'Aktualizovat profil';
$string['updatesevery'] = 'Aktualizovat každých {$a} vteřin';
$string['updatethis'] = 'Upravit tuto činnost - {$a}';
$string['updatethiscourse'] = 'Aktualizovat tento kurz';
$string['upload'] = 'Vložit';
$string['uploadafile'] = 'Vložit soubor';
$string['uploadcantwrite'] = 'Selhal zápis souboru na disk';
$string['uploadedfile'] = 'Soubor byl úspěšně uložen';
$string['uploadedfileto'] = '{$a->file} uložen do {$a->directory}';
$string['uploadedfiletoobig'] = 'Je mi líto, ale tento soubor je příliš velký (limit je {$a} bytů).';
$string['uploadextension'] = 'Nahrávání souboru bylo zastaveno nějakým PHP rozšířením';
$string['uploadfailednotrecovering'] = 'Nahrávání souborů selhalo, protože se vyskytl problém s jedním ze souborů: {$a->name}.<br />Zde je protokol s popisem chyby:<br />{$a->problem}<br />Zotavení z chyby se neprovádí.';
$string['uploadfilelog'] = 'Protokol o nahrávání souboru {$a}';
$string['uploadformlimit'] = 'Nahrávaný soubor {$a} přesáhl nastavenou maximální možnou velikost.';
$string['uploadlabel'] = 'Název:';
$string['uploadlimitwithsize'] = 'Stejný limit jako pro: {$a->contextname} ({$a->displaysize})';
$string['uploadnewfile'] = 'Nahrát nový soubor';
$string['uploadnofilefound'] = 'Soubor nenalezen -- určitě jste vybrali soubor k vložení?';
$string['uploadnotallowed'] = 'Nahrávání souborů není povoleno.';
$string['uploadnotempdir'] = 'Chybí dočasná složka';
$string['uploadoldfilesdeleted'] = 'Staré soubory v nahrávací oblasti byly odstraněny.';
$string['uploadpartialfile'] = 'Soubor byl nahrán pouze částečně';
$string['uploadproblem'] = 'Objevily se neznámé problémy při vkládání souboru "{$a}" (možná je příliš velký nebo se v jeho názvu vyskytují nedovolené znaky).';
$string['uploadrenamedchars'] = 'Soubor byl přejmenován z {$a->oldname} na {$a->newname} kvůli neplatným znakům.';
$string['uploadrenamedcollision'] = 'Soubor byl přejmenován z {$a->oldname} na {$a->newname} kvůli konfliktu názvů.';
$string['uploadserverlimit'] = 'Nahrávaný soubor přesáhl maximální možnou velikost nastavenou serverem.';
$string['uploadthisfile'] = 'Vložit tento soubor';
$string['url'] = 'URL';
$string['used'] = 'Použito';
$string['usedinnplaces'] = 'Použito na {$a} místech';
$string['user'] = 'Uživatel';
$string['useraccount'] = 'Uživatelský účet';
$string['useractivity'] = 'Činnost';
$string['userconfirmed'] = 'Potvrzeno {$a}';
$string['userdata'] = 'Data uživatele';
$string['userdeleted'] = 'Uživatelský účet byl odstraněn';
$string['userdescription'] = 'Další podrobnosti o uživateli';
$string['userdescription_help'] = 'Údaje vložené do tohoto pole budou zobrazeny dalším uživatelům na stránce s vaším uživatelským profilem.';
$string['userdetails'] = 'Detaily uživatele';
$string['userfiles'] = 'Soubory uživatele';
$string['userlist'] = 'Seznam uživatelů';
$string['usermatchedon'] = 'Tento uživatel odpovídá vyhledávání pomocí následujícího pole';
$string['usermenu'] = 'Uživatelské menu';
$string['usermenugoback'] = 'Návrat do uživatelské nabídky';
$string['username'] = 'Uživatelské jméno';
$string['usernameemail'] = 'Uživatelské jméno nebo e-mail';
$string['usernameemailmatch'] = 'Uživatelské jméno a e-mailová adresa se nevztahují ke stejnému uživateli.';
$string['usernameexists'] = 'Toto uživatelské jméno již existuje, zvolte si jiné.';
$string['usernamelowercase'] = 'Jsou povolena pouze písmena malé abecedy';
$string['usernamenotfound'] = 'Uživatelské jméno nebylo nalezeno v databázi.';
$string['usernameoremail'] = 'Uživatelské jméno nebo emailová adresa';
$string['usernotconfirmed'] = 'Nelze potvrdit {$a}';
$string['userpic'] = 'Obrázek uživatele';
$string['userpreferences'] = 'Předvolby uživatele';
$string['users'] = 'Uživatelé';
$string['userselectorautoselectunique'] = 'Pokud je nalezen jediný uživatel, automaticky jej označit';
$string['userselectorpreserveselected'] = 'Ponechat označené uživatele, i když už neodpovídají masce';
$string['userselectorsearchanywhere'] = 'Kdekoliv';
$string['userselectorsearchexactmatchonly'] = 'pouze přesné shody';
$string['userselectorsearchfromstart'] = 'od začátku';
$string['userselectorsearchmatching'] = 'Shody:';
$string['usersnew'] = 'Noví uživatelé';
$string['usersnoaccesssince'] = 'Ukázat uživatele, kteří nebyli aktivní déle než';
$string['userswithfiles'] = 'Uživatelé se soubory';
$string['useruploadtype'] = 'Režim nahrávání uživatelů: {$a}';
$string['userzones'] = 'Časové pásmo uživatele';
$string['usetheme'] = 'Použít motiv';
$string['usingexistingcourse'] = 'Používám existující kurz';
$string['validatehtml'] = 'Validovat HTML';
$string['valuealreadyused'] = 'Tato hodnota je již použita';
$string['version'] = 'Verze';
$string['view'] = 'Zobrazit';
$string['viewallcourses'] = 'Zobrazit všechny kurzy';
$string['viewallcoursescategories'] = 'Zobrazit všechny kurzy a kategorie';
$string['viewallresults'] = 'Zobrazit všechny výsledky ({$a})';
$string['viewallsubcategories'] = 'Zobrazit všechny podkategorie';
$string['viewfileinpopup'] = 'Zobrazit soubor v novém okně';
$string['viewing'] = 'Přehled';
$string['viewmore'] = 'Zobrazit více';
$string['viewprofile'] = 'Zobrazit profil';
$string['views'] = 'Zobrazení';
$string['viewsolution'] = 'zobrazit řešení';
$string['visible'] = 'Viditelnost';
$string['visible_help'] = 'Tato volba určuje, zda se bude kurz objevovat v seznamu dostupných kurzů. Pouze správci serveru a učitelé v daném kurzu mohou vstoupit do takto skrytého kurzu.';
$string['visibletostudents'] = 'Viditelný pro {$a}';
$string['warning'] = 'Varování';
$string['warningdeleteresource'] = 'Upozornění: {$a} je odkazován ve studijním materiálu. Chcete tento studijní materiál aktualizovat?';
$string['wcagcheck'] = 'Kontrola pokynů pro přístupnost webového obsahu (WCAG).';
$string['webpage'] = 'Webová stránka';
$string['week'] = 'Týden';
$string['weeks'] = 'týdnů';
$string['welcomeback'] = 'Zdravíme, {$a->firstname}! 👋';
$string['welcometocourse'] = 'Vítejte v kurzu {$a}';
$string['welcometocoursetext'] = 'Vítejte v kurzu {$a->coursename}!

Pokud jste tak ještě neučinili, měli byste upravit stránku svého profilu, abychom se o vás mohli dozvědět více:

<a href="{$a->profileurl}">{$a->profileurl}<a>';
$string['welcometosite'] = 'Vítejte, {$a->firstname}! 👋';
$string['whatforlink'] = 'Co se má provést s tímto odkazem?';
$string['whatforpage'] = 'Co se má provést s tímto textem?';
$string['whatisyourage'] = 'Jaký je váš věk?';
$string['whattocallzip'] = 'Jak chcete pojmenovat nový soubor ZIP?';
$string['whattodo'] = 'Co udělat';
$string['wheredoyoulive'] = 'V jaké zemi žijete?';
$string['whyisthisrequired'] = 'Proč je to nutné?';
$string['windowclosing'] = 'Toto okno by se mělo samo zavřít. Pokud se tak nestalo, prosím, zavřete jej vy.';
$string['withchosenfiles'] = 'S vybranými soubory';
$string['withdisablednote'] = '{$a} (vypnuto)';
$string['withoutuserdata'] = 'bez dat uživatele';
$string['withselectedusers'] = 'S vybranými uživateli...';
$string['withuserdata'] = 's daty uživatele';
$string['wontrunfuturescheduledtask'] = 'Nespustí úlohu, která se nezdařila a je naplánováno spuštění v budoucnu';
$string['wordforstudent'] = 'Jak říkáte studentovi';
$string['wordforstudenteg'] = 'např. Student, Žák, Účastník atd.';
$string['wordforstudents'] = 'Jak říkáte studentům';
$string['wordforstudentseg'] = 'např. Studenti, Žáci, Účastníci atd.';
$string['wordforteacher'] = 'Jak říkáte učiteli';
$string['wordforteachereg'] = 'např. Školitel, Instruktor, Konzultant apod.';
$string['wordforteachers'] = 'Jak říkáte učitelům';
$string['wordforteacherseg'] = 'např. Školitelé, Instruktoři, Konzultanti apod.';
$string['writingblogsinfo'] = 'Zapisuji informace blogů';
$string['writingcategoriesandquestions'] = 'Zapisuji kategorie a otázky';
$string['writingcoursedata'] = 'Zapisuji údaje kurzu';
$string['writingeventsinfo'] = 'Zapisuji informace o událostech';
$string['writinggeneralinfo'] = 'Zapisuji obecné informace';
$string['writinggradebookinfo'] = 'Zapisuji informace o klasifikaci';
$string['writinggroupingsgroupsinfo'] = 'Zapisuji informace o seskupeních a skupinách';
$string['writinggroupingsinfo'] = 'Zapisuji informace o seskupeních';
$string['writinggroupsinfo'] = 'Zapisuji informace o skupinách';
$string['writingheader'] = 'Zapisuji hlavičky';
$string['writingloginfo'] = 'Zapisuji protokoly';
$string['writingmessagesinfo'] = 'Zapisuji informace o zprávách';
$string['writingmoduleinfo'] = 'Zapisuji informace o modulech';
$string['writingscalesinfo'] = 'Zapisuji informace o škálách';
$string['writinguserinfo'] = 'Zapisuji informace o uživatelích';
$string['wrongpassword'] = 'Špatné heslo k tomuto uživatelskému jménu';
$string['year'] = 'rok';
$string['years'] = 'roky';
$string['yes'] = 'Ano';
$string['youareabouttocreatezip'] = 'Chystáte se vytvořit soubor ZIP obsahující';
$string['youaregoingtorestorefrom'] = 'Chystáte se zahájit proces obnovy';
$string['youhaveupcomingactivitiesdue'] = 'Máte nadcházející činnosti s termínem';
$string['youhaveupcomingactivitiesdueinfo'] = 'Zdravím {$a},

<br/> <br/> Máte termín nadcházejících aktivit:';
$string['youneedtoenrol'] = 'K provedení této akce se musíte zapsat do kurzu';
$string['yourlastlogin'] = 'Vaše poslední přihlášení';
$string['yourself'] = 'vy';
$string['yourteacher'] = 'váš {$a}';
$string['yourwordforx'] = 'Vámi použivaný termín pro "{$a}"';
$string['zippingbackup'] = 'Komprimuji (ZIP) zálohu';
