<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'local_amos', language 'cs', version '5.1'.
 *
 * @package     local_amos
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['about'] = '<p>AMOS (Automated Manipulation Of Strings) je centrální repozitář textových řetězců Moodle a jejich historie. Systém sleduje přidávání nových anglických řetězců do kódu Moodle, shromažďuje překlady, obsluhuje běžné operace s přeloženými řetězci a generuje jazykové balíčky používané na serverech s Moodle.</p>
<p>Pro více informací se podívejte na <a href="https://docs.moodle.org/en/AMOS">dokumentaci AMOS</a>.</p>';
$string['amos'] = 'AMOS - nástroj pro překlad Moodle';
$string['amos:changecontriblang'] = 'Změnit jazyk přeložených řetězců';
$string['amos:commit'] = 'Odeslat přeložené řetězce do hlavního repositáře';
$string['amos:execute'] = 'Spouštět vložený AMOScript';
$string['amos:importfile'] = 'Importovat řetězce z nahraného souboru do překladiště';
$string['amos:importstrings'] = 'Importovat řetězce (včetně anglických originálů) přímo do hlavního repozitáře';
$string['amos:manage'] = 'Spravovat portál AMOS';
$string['amos:stage'] = 'Použít překladatelský nástroj AMOS a dočasně uložit řetězce v překladišti';
$string['amos:stash'] = 'Uložit přeložené řetězce do odkladiště';
$string['amos:usegoogle'] = 'Používat služby Google Translate';
$string['applangindexfile'] = 'Umístění souboru Moodle App LangIndex';
$string['applangindexfile_desc'] = 'Adresa URL, ze které se bude soubor pravidelně stahovat.';
$string['branchesall'] = 'Všechny známé verze Moodle';
$string['branchesall_desc'] = 'Čárkou oddělený seznam verzí Moodle, které bude AMOS zpracovávat.';
$string['branchsupported'] = 'Nejstarší podporovaná verze Moodle';
$string['branchsupported_desc'] = 'Číselný kód nejstarší verze Moodle, ve která bude ještě AMOS zaznamenávat změny v anglických řetězcích a pro kterou budou ještě generovány řetězce pro instalátor.';
$string['cachedef_lists'] = 'Seznam jazyků a komponent registrovaných v Moodle';
$string['commitbutton'] = 'Zapsat do jazykového balíčku';
$string['commitkeepstaged'] = 'Ponechat řetězce na překladišti';
$string['commitmessage'] = 'Průvodní zpráva';
$string['commitmessageempty'] = 'Vyplňte prosím průvodní zprávu';
$string['commitstage'] = 'Trvale zapsat přeložené řetězce';
$string['commitstage_help'] = 'Trvale uloží všechny aktuálně přeložené řetězce do repositáře AMOS. Aktuální stav překladiště je před svým odesláním automaticky pročištěn. Jsou uloženy pouze zeleně zvýrazněné řetězce. Obsah překladiště je po zapsání přeložených řetězců odstraněn.';
$string['committable'] = 'Máte oprávnění zapisovat do tohoto jazykového balíčku';
$string['committableall'] = 'všechny jazyky';
$string['committablenone'] = 'nejsou povoleny žádné jazyky - prosím kontaktujte správce AMOS';
$string['componentsall'] = 'Všechny';
$string['componentsapp'] = 'Moodle App';
$string['componentsnone'] = 'Žádný';
$string['componentsstandard'] = 'Standardní';
$string['confirmaction'] = 'Akci není možné vrátit zpět. Jste si jistí?';
$string['contribaccept'] = 'Přijmout';
$string['contribactions'] = 'Operace se zaslanými překlady';
$string['contribactions_help'] = 'V závislosti na vašich právech a momentálnímu stavu zaslaného překladu můžete mít k dispozici některé z následujících akcí:

* Použít - zkopíruje zaslané řetězce do vašeho překladiště, aniž by byly provedeny jakékoliv změny stavu zaslaného překladu
* Přiřadit mně - nastaví vás jako recenzenta zaslaného překladu. Recenzent je zodpovědný za kontrolu překladů a jejich integraci
* Rezignovat - odebere vám přiřazení recenzenta zaslaného překladu
* Začít recenzi - přiřadí vám zaslaný překlad k recenzi, nastaví jeho stav na "Recenzován" a zkopíruje zaslané řetězce do vašeho překladiště
* Přijmout - označí zaslaný překlad jako přijatý
* Odmítnout - označí překlad jako odmítnutý, v komentáři prosím zadejte důvod odmítnutí překladu

Přispěvatelé jsou informováni e-mailem o změnách stavu jimi zaslaných překladů.';
$string['contribactions_link'] = 'AMOS#Contributing_to_a_language_pack';
$string['contribapply'] = 'Použít';
$string['contribassignee'] = 'Recenzent';
$string['contribassigneenone'] = '-';
$string['contribassigntome'] = 'Přiřadit mně';
$string['contribauthor'] = 'Autor';
$string['contribclosedno'] = 'Skrýt vyřešené příspěvky';
$string['contribclosedyes'] = 'Zobrazit i vyřešené příspěvky';
$string['contribcomponents'] = 'Komponenty';
$string['contribid'] = 'ID';
$string['contribincomingnone'] = 'Žádné čekající příspěvky';
$string['contribincomingsome'] = 'Čekající příspěvky ({$a})';
$string['contriblanguage'] = 'Jazyk';
$string['contriblanguagebutton'] = 'Převést';
$string['contriblanguagechange'] = 'Opravuji jazyk zaslaného překladu';
$string['contriblanguagechange_help'] = 'Pokud byl příspěvek omylem odeslán do nesprávného jazykového balíčku, vyberte v rozevírací nabídce níže správný jazyk a klikněte na tlačítko Převést.';
$string['contriblanguagereport'] = 'Hlášení nesprávného jazyka příspěvku';
$string['contriblanguagewrong'] = 'Špatný jazyk?';
$string['contribnotif'] = '[AMOS] Oznámení o příspěvku (#{$a->id})';
$string['contribnotifaccepted'] = '{$a->fullname} přijal váš příspěvek překladu
#{$a->id} {$a->subject}

---------------------------------------------------------------------
Stránka příspěvku: {$a->contriburl}';
$string['contribnotifcommented'] = '{$a->fullname} komentoval příspěvek překladu
#{$a->id} {$a->subject}
---------------------------------------------------------------------

{$a->message}

---------------------------------------------------------------------
Stránka příspěvku: {$a->contriburl}';
$string['contribnotifrejected'] = '{$a->fullname} zamítl váš příspěvek překladu
#{$a->id} {$a->subject}

---------------------------------------------------------------------
Stránka příspěvku: {$a->contriburl}';
$string['contribnotifsubmitted'] = '{$a->fullname} uživatel odeslal nový příspěvek překladu #{$a->id} {$a->subject}
---------------------------------------------------------------------

{$a->message}

* Jazyk: {$a->language}
* Komponenty: {$a->components}
* Řetězce: {$a->strings}

---------------------------------------------------------------------
Stránka příspěvku: {$a->contriburl}';
$string['contribreject'] = 'Odmítnout';
$string['contribresign'] = 'Zrušit přiřazení';
$string['contribstaged'] = 'Příspěvek <a href="contrib.php?id={$a->id}">#{$a->id}</a> od {$a->author}';
$string['contribstagedinfo'] = 'Příspěvek k překladu';
$string['contribstagedinfo_help'] = 'Vaše překladiště obsahuje řetězce, které byly zaslány uvedeným přispěvatelem. Od správců jazykového balíčku se očekává, že provedou recenzi zaslaného překladu a poté jej buď přijmou nebo odmítnou.';
$string['contribstagedinfo_link'] = 'AMOS#Contributing_to_a_language_pack';
$string['contribstartreview'] = 'Začít recenzi';
$string['contribstatus'] = 'Stav';
$string['contribstatus0'] = 'Nový';
$string['contribstatus10'] = 'Recenzován';
$string['contribstatus20'] = 'Odmítnut';
$string['contribstatus30'] = 'Přijat';
$string['contribstatus_help'] = 'Každý zaslaný překlad se nachází v jednom z následujících stavů:

* Nový - přispěvatel zaslal svůj překlad, ale ten nebyl dosud recenzován
* Recenzován - zaslaný překlad byl přiřazen jednomu ze správců jazykového balíčku k recenzi a přeložené řetězce byly zkopírovány do překladiště daného správce
* Odmítnut - zaslaný překlad byl správcem jazykového balíčku odmítnut (pravděpodobně s vysvětlujícím komentářem)
* Přijat - zaslaný překlad by správcem jazykového balíčku schválen a (s případnými drobnými korekturami) uložen do repozitáře';
$string['contribstatus_link'] = 'AMOS#Contributing_to_a_language_pack';
$string['contribstrings'] = 'Řetězců';
$string['contribstringseq'] = '{$a->orig} nových';
$string['contribstringsnone'] = '{$a->orig} (všechny jsou již přeloženy)';
$string['contribstringssome'] = '{$a->orig} (pro {$a->same} z nich již existuje novější překlad)';
$string['contribsubject'] = 'Předmět';
$string['contribsubmittednone'] = 'Žádné příspěvky';
$string['contribsubmittedsome'] = 'Vámi odeslané příspěvky';
$string['contribtimemodified'] = 'Upraveno';
$string['contribute'] = 'Přispět';
$string['contributenow'] = 'Pomoci s překladem';
$string['contributestats'] = 'Členové Moodle komunity již přes AMOS zaslali <strong>{$a->count}</strong> přeložených textových řetězců.';
$string['contributethanks'] = 'Díky přispěvatelům {$a->listcontributors} za jejich nedávné příspěvky!';
$string['contributethankslist'] = '{$a->contributor1}, {$a->contributor2}, {$a->contributor3} a {$a->contributor4}';
$string['contributions'] = 'Příspěvky';
$string['creditscontact'] = 'Zaslat zprávu';
$string['creditscontributors'] = 'Další přispěvatelé';
$string['creditsmaintainedby'] = 'Správci jazykového balíčku';
$string['creditsnomaintainer'] = 'Tento jazyk momentálně nemá svého správce. <a href="{$a->url}">Staňte se jím!</a>';
$string['creditsthanks'] = 'Na této stránce bychom chtěli poděkovat všem, kteří přispěli k překladu Moodle. Jejich práce umožnila Moodlu rozšířit se po celém světě.';
$string['creditstitlelong'] = 'Správci a přispěvatelé jazykových balíčků';
$string['creditstitleshort'] = 'Správci a přispěvatelé';
$string['diff'] = 'Porovnat';
$string['diffstringmode'] = 'Přepnout režim zobrazení rozdílů';
$string['err_exception'] = 'Chyba: {$a}';
$string['err_invalidlangcode'] = 'Neplatný kód jazyka';
$string['err_parser'] = 'Chyba parsování: {$a}';
$string['filtercmp'] = 'Komponenty';
$string['filtercmp_desc'] = 'Zobrazit řetězce z těchto komponent';
$string['filtercmpnothingselected'] = 'Vyberte alespoň jednu komponentu';
$string['filterlng'] = 'Jazyky';
$string['filterlng_desc'] = 'Zobrazit překlad do těchto jazyků';
$string['filterlngnothingselected'] = 'Vyberte alespoň jeden jazyk';
$string['filtermis'] = 'Různé';
$string['filtermis_desc'] = 'Doplňující podmínky pro zobrazení řetězců';
$string['filtermisfapp'] = 'pouze řetězce používané v Moodle mobilní aplikaci';
$string['filtermisfapp_help'] = 'Tento řetězec je používán v Moodle mobilní aplikaci as {$a}';
$string['filtermisfhas'] = 'pouze přeložené řetězce';
$string['filtermisfhlp'] = 'pouze řetězce s nápovědou';
$string['filtermisfmis'] = 'pouze chybějící a zastaralé překlady';
$string['filtermisfout'] = 'pouze zastaralé řetězce';
$string['filtermisfstg'] = 'pouze řetězce z překladiště';
$string['filtersid'] = 'Identifikátor řetězce';
$string['filtersid_desc'] = 'Systémový klíč jednoznačně určující řetězce v rámci dané komponenty';
$string['filtersidpartial'] = 'částečná shoda';
$string['filtertxt'] = 'Podřetězec';
$string['filtertxt_desc'] = 'Řetězec musí obsahovat daný text';
$string['filtertxtcasesensitive'] = 'včetně shody velikosti písmen';
$string['filtertxteng'] = 'v anglickém originálu';
$string['filtertxtregex'] = 'regex';
$string['filtertxttra'] = 'v překladu';
$string['filterver'] = 'Verze';
$string['filterver_desc'] = 'Zobrazit řetězce platné pro tuto verzi Moodle';
$string['filtervernothingselected'] = 'Vyberte alespoň jednu verzi';
$string['foundmissing'] = '{$a} chybí';
$string['foundmissingonthispage'] = '{$a} na této stránce';
$string['foundtotal'] = '{$a} nalezeno';
$string['googletranslate'] = 'zeptat se google';
$string['importfile'] = 'Nahrát přeložené řetězce ze souboru';
$string['importfile_help'] = 'Řetězce můžete do překladiště nahrát ze souboru pomocí tohoto formuláře.

* Soubor musí být platný PHP kód definující pole řetězců tak, jako je tomu v adresáři "/lang/en" vaší instalace Moodle.
* Název souboru musí odpovídat tomu, v němž jsou definovány anglické originály řetězců - např. moodle.php, assignment.php nebo enrol_manual.php apod.

Všechny v souboru nalezené řetězce budou uloženy do vašeho překladiště.

Chcete-li zpracovat více PHP souborů najednou, vytvořte z nich ZIP archív.';
$string['importfile_link'] = 'local/amos/importfile';
$string['language'] = 'Jazyk';
$string['languages'] = 'Jazyky';
$string['languagesall'] = 'Všechny';
$string['languagesnone'] = 'Žádný';
$string['lastavailable'] = 'Poslední dostupná verze';
$string['lessfilteringoptions'] = 'Méně možností';
$string['log'] = 'Protokol';
$string['logfilterbranch'] = 'Verze';
$string['logfiltercommithash'] = 'git hash';
$string['logfiltercommitmsg'] = 'Průvodní zpráva (commit message) obsahuje';
$string['logfiltercommits'] = 'Filtr na základě zápisu do repozitáře';
$string['logfiltercommittedafter'] = 'Zapsáno do repozitáře po';
$string['logfiltercommittedbefore'] = 'Zapsáno do repozitáře před';
$string['logfiltercomponent'] = 'Komponenty';
$string['logfilterlang'] = 'Jazyky';
$string['logfiltershow'] = 'Zobrazit filtrované zápisy a řetězce';
$string['logfiltersource'] = 'Zdroj';
$string['logfiltersourceamos'] = 'amos (webové rozhraní pro překlad)';
$string['logfiltersourceautomerge'] = 'automerge (překlad zkopírován z jiné větve)';
$string['logfiltersourcebot'] = 'bot (hromadné operace prováděné skriptem)';
$string['logfiltersourcecommitscript'] = 'commitscript (AMOScript v těle průvodní zprávy)';
$string['logfiltersourcefixdrift'] = 'fixdrift (oprava rozdílu mezi AMOS a Git)';
$string['logfiltersourcegit'] = 'git (zdrojové kódy Moodle a balíčky verze 1.x)';
$string['logfiltersourceimport'] = 'import (importované řetězce z doplňku)';
$string['logfiltersourcerevclean'] = 'revclean (reverzní čištění balíčku)';
$string['logfilterstringid'] = 'Identifikátor řetězce';
$string['logfilterstrings'] = 'Filtr řetězců';
$string['logfilterusergrp'] = 'Autor zápisu do repozitáře';
$string['logfilterusergrpor'] = 'nebo';
$string['maintainers'] = 'Správci balíčků';
$string['markuptodate'] = 'Označuji překlad jako aktuální';
$string['markuptodatelabel'] = 'označit jako aktuální';
$string['morefilteringoptions'] = 'Více možností';
$string['newlanguage'] = 'Nový jazyk';
$string['nodiffs'] = 'Nenalezeny žádné rozdíly';
$string['nofiletoimport'] = 'Určete soubor k importu';
$string['nologsfound'] = 'Nenalezeny žádné řetězce, upravte nastavení filtru';
$string['nostringsfound'] = 'Nenalezeny žádné řetězce';
$string['nostringtoimport'] = 'V souboru nebyl nalezen žádný platný řetězec. Ujistěte se, že soubor má správný název a formát dat.';
$string['nothingtostage'] = 'Operace nevrátila žádný řetězec, který by bylo možné uložit do překladiště.';
$string['novalidzip'] = 'Nelze rozbalit ZIP soubor';
$string['numofcommitsabovelimit'] = 'Nalezeno {$a->found} zápisů do repozitáře, které odpovídají filtru, používám posledních {$a->limit}';
$string['numofcommitsunderlimit'] = 'Nalezeno {$a->found} zápisů do repozitáře';
$string['numofmatchingstrings'] = 'Z toho {$a->strings} změn řetězců v {$a->commits} zápisech do repozitáře odpovídá filtru řetězců.';
$string['outdatednotcommitted'] = 'Zastaralý řetězec';
$string['outdatednotcommitted_help'] = 'AMOS zjistil, že řetězec může být zastaralý, neboť anglický originál byl upraven poté, co byl přeložen. Prosím, zkontrolujte aktuálnost překladu.';
$string['outdatednotcommittedwarning'] = 'Zastaralý';
$string['ownstashactions'] = 'Operace s odloženými řetězci';
$string['ownstashes'] = 'Vaše odkladiště';
$string['ownstashes_help'] = 'Toto je seznam vašich odložených překladů';
$string['ownstashesnone'] = 'Žádné řetězce na vašem odkladišti';
$string['permalink'] = 'Trvalý odkaz';
$string['placeholder'] = 'Zástupné znaky';
$string['placeholderwarning'] = 'zástupné znaky';
$string['pluginclasscore'] = 'Jádrové subsystémy';
$string['pluginclassnonstandard'] = 'Nestandardní rozšíření';
$string['pluginclassstandard'] = 'Standardní moduly';
$string['pluginname'] = 'AMOS';
$string['presetcommitmessage'] = 'Contributed translation #{$a->id} by {$a->author}';
$string['presetcommitmessage2'] = 'Merged missing strings from {$a->source} to {$a->target} branch';
$string['presetcommitmessage3'] = 'Fixing differences between {$a->versiona} and {$a->versionb}';
$string['privacy:commitnumber'] = 'Potvrdit {$a}';
$string['privacy:contribnumber'] = 'Příspěvek {$a}';
$string['privacy:filterusage'] = 'Použít filtr';
$string['privacy:metadata:db:amosfilterusage:currentlang'] = 'Aktuální jazyk relace.';
$string['privacy:metadata:db:amosfilterusage:numofcomponents'] = 'Počet vybraných komponent';
$string['privacy:metadata:db:amosfilterusage:numoflanguages'] = 'Počet vybraných jazyků';
$string['privacy:metadata:db:amosfilterusage:numofversions'] = 'Počet vybraných verzí';
$string['privacy:metadata:db:amosfilterusage:showmissingonly'] = 'Měly by se zobrazit pouze chybějící a zastaralé řetězce?';
$string['privacy:metadata:db:amosstashes:name'] = 'Název nebo nadpis odkladiště';
$string['privacy:metadata:db:amosstashes:strings'] = 'Nadpis odkladiště';
$string['privacy:metadata:db:amosstashes:timecreated'] = 'Časové razítko, kdy bylo odkladiště vytvořeno';
$string['privacy:stashnumber'] = 'Odkladiště {$a}';
$string['privileges'] = 'Vaše oprávnění';
$string['privilegesnone'] = 'Máte pouze oprávnění číst veřejné dostupné informace';
$string['processing'] = 'Zpracovávám ...';
$string['quicklinks'] = 'Užitečné odkazy';
$string['quicklinks_amos'] = 'AMOS překladač';
$string['quicklinks_forum'] = 'Diskusní fórum pro překlady';
$string['quicklinks_manual'] = 'Uživatelská příručka';
$string['quicklinks_newcomers'] = 'Pomoc nově příchozím';
$string['requestactions'] = 'Akce';
$string['savefilter'] = 'Zobrazit řetězce';
$string['script'] = 'AMOScript';
$string['scriptexecute'] = 'Spustit skript a uložit výsledky do překladiště';
$string['sourceversion'] = 'Zdrojová verze';
$string['stage'] = 'Překladiště';
$string['stageactions'] = 'Operace s řetězci na překladišti';
$string['stagedownload'] = 'Stáhnout';
$string['stageedit'] = 'Upravit řetězce na překladišti';
$string['stageprune'] = 'Odebrat nezapsatelné';
$string['stagerebase'] = 'Přeskládání';
$string['stagestringsnocommit'] = 'Překladiště obsahuje {$a->staged} řetězců';
$string['stagestringsnone'] = 'Překladiště neobsahuje žádné řetězce';
$string['stagestringssome'] = 'Překladiště obsahuje {$a->staged} řetězců, {$a->committable} z nich může být trvale zapsáno do repozitáře';
$string['stagesubmit'] = 'Odeslat správcům jazykového balíčku';
$string['stagetoolopen'] = 'Zobrazit a uložit hotový překlad';
$string['stagetranslation'] = 'Překlad';
$string['stageunstageall'] = 'Odebrat vše';
$string['stashactions'] = 'Uložit pro sebe pracovní verzi překladu';
$string['stashapply'] = 'Použít';
$string['stashautosave'] = 'Automaticky uložený snímek překladiště';
$string['stashcomponents'] = '<span> Komponenty: </span> {$a}';
$string['stashdownload'] = 'Stáhnout';
$string['stashdrop'] = 'Zahodit';
$string['stashdropconfirm'] = 'Opravdu chcete trvale smazat uloženou položku <em>\'{$a}\'</em>?';
$string['stashes'] = 'Odložené  překlady';
$string['stashlanguages'] = '<span> Jazyky: </span> {$a}';
$string['stashpop'] = 'Použít';
$string['stashpush'] = 'Odložit řetězce v překladišti';
$string['stashstrings'] = '<span> Počet řetězců: </span> {$a}';
$string['stashsubmit'] = 'Odeslat správcům jazykového balíčku';
$string['stashsubmitmessage'] = 'Zpráva pro správce jazykového balíčku';
$string['stashsubmitsubject'] = 'Předmět';
$string['stashtitle'] = 'Název odloženého překladu';
$string['stashtitledefault'] = 'PRACOVNÍ VERZE - {$a->time}';
$string['stdvernotebetween'] = 'Standardní od {$a->from} do {$a->to}';
$string['stdvernotefrom'] = 'Standardní od {$a->from}';
$string['stdvernoteto'] = 'Standardní až do {$a->to}';
$string['stringhistory'] = 'historie';
$string['strings'] = 'Řetězce';
$string['stringversionnotlatest'] = 'nalezena novější verze';
$string['targetversion'] = 'Cílová verze';
$string['timeline'] = 'Časová osa řetězce';
$string['timelineheading'] = 'Časová osa řetězce: {$a->component} | {$a->strname}';
$string['translatortool'] = 'Editor řetězců';
$string['translatortoolopen'] = 'Přejít do nástroje pro překlad';
$string['translatortranslation'] = 'Překlad';
$string['typecontrib'] = 'Rozšiřující doplňky';
$string['typecontribbadge'] = 'Rozšíření';
$string['typecore'] = 'Jádrové subsystémy';
$string['typecorebadge'] = 'Jádro';
$string['typestandard'] = 'Standardní moduly';
$string['typestandardbadge'] = 'Standardní';
$string['unableenfixaddon'] = 'Opravy anglických řetězců jsou podporovány pouze pro standardní moduly';
$string['unableenfixcountries'] = 'Názvy zemí jsou kopírovány z ISO 3166-1';
$string['unablelangconfig'] = 'Bez oprávnění upravovat konfiguraci jazykového balíčku';
$string['unstage'] = 'odebrat';
$string['unstageconfirm'] = 'Potvrďte odebrání';
$string['unstageconfirmlong'] = '<p>Chystáte se odebrat pracovní verzi překladu řetězece <code>{$a->stringid}</code>, komponenta <code>{$a->component}</code>, jazykový balíček <code>{$a->language}</code>.</p><p>Jste si jistí?</p>';
$string['unstaging'] = 'Odebírám';
$string['untranslate'] = 'odstranit překlad';
$string['userdefaultreset'] = 'Načíst mé výchozí nastavení';
$string['userdefaultsave'] = 'Uložit jako mé výchozí nastavení';
$string['version'] = 'Verze';
