<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'cachestore_redis', language 'cs', version '5.1'.
 *
 * @package     cachestore_redis
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['ca_file'] = 'Cesta k souboru CA';
$string['ca_file_help'] = 'Umístění souboru certifikační autority v lokálním souborovém systému';
$string['clustermode'] = 'Clusterový režim';
$string['clustermode_help'] = 'Povolením režimu clusteru se spustí funkce Redis Cluster, která vašemu serveru umožní obsluhovat více serverů a zpracovávat souběžné požadavky současně.';
$string['clustermodeunavailable'] = 'Redis Cluster je momentálně nedostupný. Ujistěte se, že rozšíření PHP Redis podporuje funkci Redis Cluster.';
$string['compressor_none'] = 'Žádná komprese.';
$string['compressor_php_gzip'] = 'Použít kompresi gzip.';
$string['compressor_php_zstd'] = 'Použít kompresi Zstandard.';
$string['connectiontimeout'] = 'Vypršel časový limit připojení';
$string['connectiontimeout_help'] = 'Tím se nastaví časový limit při pokusu o připojení k serveru Redis.';
$string['encrypt_connection'] = 'Použít šifrování TLS.';
$string['encrypt_connection_help'] = 'Pro připojení k Redis použijte TLS. V názvu hostitele pro Redis nepoužívejte \'tls://\', místo toho použijte tuto možnost.';
$string['password'] = 'Heslo';
$string['password_help'] = 'To nastaví heslo serveru REDIS.';
$string['pluginname'] = 'Redis';
$string['prefix'] = 'Předpona klíče';
$string['prefix_help'] = 'Tato předpona se používá pro všechny klíčové názvy na serveru memcache. * Máte-li pouze jednu instanci Moodle používající tento server, můžete nechat tuto hodnotu na standardním nastavení. * Kvůli omezení délky klíče je na předponu povoleno maximálně 5 znaků.';
$string['prefixinvalid'] = 'Neplatná předpona. Můžete použít pouze a-z A-Z 0-9-_.';
$string['privacy:metadata:redis'] = 'Modul Redis cachestore ukládá data krátce jako součást své funkce ukládání do mezipaměti. Tato data jsou uložena na serveru Redis, kde jsou data pravidelně odstraňována.';
$string['privacy:metadata:redis:data'] = 'Různá data uložená v mezipaměti';
$string['serializer_igbinary'] = 'Serializátor igbinary';
$string['serializer_php'] = 'Výchozí PHP serializátor';
$string['server'] = 'Server/y';
$string['server_help'] = 'Server Redis k testování.

Některé příklady hodnot:

* testredis.abc.com – Pro připojení k serveru Redis podle názvu hostitele (ve výchozím nastavení Port 6379).
* testredis.abc.com:1234 - Pro připojení k serveru Redis podle názvu hostitele se specifickým portem.
* 1.2.3.4 - Pro připojení k serveru Redis pomocí IP adresy (výchozí port 6379).
* 1.2.3.4:1234 - Pro připojení k serveru Redis pomocí IP adresy se specifickým portem.
* unix:///var/redis.sock – Pro připojení k serveru Redis pomocí Unixového soketu.
* /var/redis.sock - Pro připojení k serveru Redis pomocí Unixového soketu (alternativní formát).

Pokud je povolen režim clusteru, zadejte prosím servery oddělené novým řádkem:<br>
172.23.0.11<br>
172.23.0.12<br>
172.23.0.13<br>


Další informace naleznete v článcích <a href="https://redis.io/docs/reference/clients/#accepting-client-connections">Přijímání klientských připojení</a> a <a href="https://redis .io/resources/clients/#php">Redis PHP klienti</a>.';
$string['task_ttl'] = 'Uvolnit paměť používanou prošlými položkami v mezipaměti Redis';
$string['test_clustermode'] = 'Clusterový režim';
$string['test_clustermode_desc'] = 'Povolit Test v režimu Redis Cluster.';
$string['test_password'] = 'Heslo testovacího serveru';
$string['test_password_desc'] = 'Heslo testovacího serveru REDIS.';
$string['test_serializer'] = 'Serializátor';
$string['test_serializer_desc'] = 'Serializátor použitý pro testování.';
$string['test_server'] = 'Testovací server';
$string['test_server_desc'] = 'REDIS server použitý pro testování.

Některé příklady hodnot:

* testredis.abc.com – Pro připojení k serveru Redis podle názvu hostitele (ve výchozím nastavení Port 6379).
* testredis.abc.com:1234 - Pro připojení k serveru Redis podle názvu hostitele se specifickým portem.
* 1.2.3.4 - Pro připojení k serveru Redis pomocí IP adresy (výchozí port 6379).
* 1.2.3.4:1234 - Pro připojení k serveru Redis pomocí IP adresy se specifickým portem.
* unix:///var/redis.sock – Pro připojení k serveru Redis pomocí Unixového soketu.
* /var/redis.sock - Pro připojení k serveru Redis pomocí Unixového soketu (alternativní formát).

Pokud je povolen režim clusteru, zadejte prosím servery oddělené novým řádkem:<br>
172.23.0.11<br>
172.23.0.12<br>
172.23.0.13<br>

Další informace naleznete v článcích <a href="https://redis.io/docs/reference/clients/#accepting-client-connections">Přijímání klientských připojení</a> a <a href="https://redis .io/resources/clients/#php">Redis PHP klienti</a>.';
$string['test_ttl'] = 'Testování TTL';
$string['test_ttl_desc'] = 'Spustit test výkonu využívající mezipaměti, která vyžaduje TTL (pomalejší sady).';
$string['usecompressor'] = 'Použít kompresor';
$string['usecompressor_help'] = 'Určuje kompresor, který se má použít po serializaci. Provádí se na úrovni rozhraní API mezipaměti Moodle, nikoli na úrovni php-redis.';
$string['useserializer'] = 'Použít serializátor';
$string['useserializer_help'] = 'Určuje serializátor použitý pro serializaci.
Platné serializátory jsou Redis :: SERIALIZER_PHP nebo Redis :: SERIALIZER_IGBINARY.
Druhý je podporován pouze při phpredis je nakonfigurován s volbou --enable-REDIS-igbinary a je načteno rozšíření igbinary.';
