<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'report_security', language 'af', version '5.1'.
 *
 * @package     report_security
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['check_configrw_details'] = '<p>Dit word aanbeveel dat die dokumenttoestemmings van <code>config.php</code> na installasie verander word, sodat die dokument nie deur die webbediener gewysig kan word nie. Let asseblief daarop dat hierdie maatreël nie sekuriteit van die bediener beduidend verbeter nie, alhoewel dit algemene uitbuiting kan vertraag of beperk.</p>';
$string['check_configrw_name'] = 'Skryfbare config.php';
$string['check_configrw_ok'] = 'config.php kan nie deur PHP-tekste gewysig word nie.';
$string['check_configrw_warning'] = 'PHP-tekste kan config.php wysig.';
$string['check_cookiesecure_details'] = '<p>As https-kommunikasie ontsper is, word dit aanbeveel om die stuur van veilige koekies te ontsper. Jy behoort permanente aanstuur van http na https te hê en verkieslik HSTS-opskrifte ook te hê.</p>';
$string['check_cookiesecure_error'] = 'Ontsper asseblief veilige koekies';
$string['check_cookiesecure_http'] = 'Jy moet https aansit om veilige koekies te gebruik';
$string['check_cookiesecure_name'] = 'Veilige koekies';
$string['check_cookiesecure_ok'] = 'Veilige koekies is ontsper.';
$string['check_crawlers_details'] = '<p>Die "Oop vir soekenjins-verstelling" stel soekenjins in staat om kursusse deur middel van gastetoegang binne te gaan. Dit dien geen doel om hierdie verstelling te onsper as gaste-intekening nie toegelaat word nie.</p>';
$string['check_crawlers_error'] = 'Soekenjintoegang word toegelaat, maar gastetoegang is versper.';
$string['check_crawlers_info'] = 'Soekenjins kan as gaste binnegaan.';
$string['check_crawlers_name'] = 'Maak vir soekenjins oop';
$string['check_crawlers_ok'] = 'Soekenjintoegang is nie ontsper nie';
$string['check_defaultuserrole_details'] = '<p>Alle ingetekende gebruikers verkry die vermoë van die verstekgebruikerrol. Verseker asseblief dat geen riskante vermoëns in hierdie rol toegelaat word nie.</p>
<p>Die enigste ondersteunde nalatenskaptipe vir die verstekgebruikerrol is <em>Geldigverklaarde gebruiker</em>. Die kursushersienvermoë moet nie ontsper word nie.</p>';
$string['check_defaultuserrole_error'] = 'Die verstekgebruikerrol "{$a}" is verkeerd gedefinieer!';
$string['check_defaultuserrole_name'] = 'Verstekrol vir alle gebruikers';
$string['check_defaultuserrole_notset'] = 'Verstekrol is nie gestel nie.';
$string['check_defaultuserrole_ok'] = 'Definisie van verstekrol vir alle gebruikers is reg.';
$string['check_dirindex_info'] = 'Gidsindeks behoort nie ontsper te word nie';
$string['check_displayerrors_details'] = '<p>Die ontsper van die PHP-verstelling <code>display_errors</code> word nie op produksiewerwe aanbeveel nie, omdat foutboodskappe sensitiewe inligting oor jou bediener kan onthul.</p>';
$string['check_displayerrors_error'] = 'Die PHP-verstelling om foute te vertoon is ontsper. Die aanbeveling is om dit te versper.';
$string['check_displayerrors_name'] = 'Alle PHP-foute word vertoon';
$string['check_displayerrors_ok'] = 'Die vertoon van PHP-foute is versper.';
$string['check_dotfiles_info'] = 'Geen dotfiles behalwe /.well-known/* behoort nie publiek te wees nie';
$string['check_emailchangeconfirmation_details'] = '<p>Die aanbeveling is dat \'n e-posbevestigingstap vereis word wanneer gebruikers hul e-posadres in hul profiel verander. Indien versper, kan spammers probeer om die bediener uit te buit om gemorspos te stuur.</p>
<p>E-posveld kan ook teen teen geldigheidsvasstelling-invoegtoepassing versper word; hierdie moontlikheid word nie hier oorweeg nie.</p>';
$string['check_emailchangeconfirmation_error'] = 'Gebruikers kan enige e-posadres inskryf.';
$string['check_emailchangeconfirmation_info'] = 'Gebruikers kan slegs e-posadresse van toegelate domeins invoer.';
$string['check_emailchangeconfirmation_name'] = 'E-posveranderingsbevestiging';
$string['check_emailchangeconfirmation_ok'] = 'Bevestiging van verandering van e-posadres in gebruikersprofiel.';
$string['check_embed_details'] = '<p>Onbeperkte inbedding is baie gevaarlik - enige geregistreerde gebruiker kan \'n XSS-aanval teen ander bedienergebruikers loods. Hierdie verstelling behoort op produksiebedieners versper te word.</p>';
$string['check_embed_error'] = 'Onbeperkte voorwerpinbedding ontsper - dit is baie gevaarlik vir die meerderheid bedieners.';
$string['check_embed_name'] = 'Laat EMBED en OBJECT toe';
$string['check_embed_ok'] = 'Onbeperkte voorwerpinbedding word nie toegelaat nie.';
$string['check_frontpagerole_details'] = '<p>Die verstek-voorbladrol word aan alle geregistreerde gebruikers vir voorbladaktiwiteite gegee. Verseker asseblief dat geen riskante vermoëns vir hierdie rol toegelaat word nie.</p>
<p>Dit word aanbeveel dat \'n spesiale rol vir hierdie doel geskep word en \'n nalatenskaptipe rol nie gebruik word nie.</p>';
$string['check_frontpagerole_error'] = 'Verkeerdelik gedefinieerde voorbladrol "{$a}" is opgemerk!';
$string['check_frontpagerole_name'] = 'Voorbladrol';
$string['check_frontpagerole_notset'] = 'Voorbladrol is nie gestel nie.';
$string['check_frontpagerole_ok'] = 'Voorbladroldefinisie is OK.';
$string['check_guestrole_details'] = '<p>Die gasterol word vir gaste gebruik, vir gebruikers wat nie ingeteken is nie en vir tydelike gastetoegang tot die kursus. Verseker asseblief dat geen riskante vermoëns in hierdie rol toegelaat word nie.</p>
<p>Die enigste ondersteunde nalatenskaptipe vir gasterol is <em>Guest</em>.</p>';
$string['check_guestrole_error'] = 'Die gasterol "{$a}" is verkeerd gedefinieer!';
$string['check_guestrole_name'] = 'Gasterol';
$string['check_guestrole_notset'] = 'Gasterol is nie gestel nie.';
$string['check_guestrole_ok'] = 'Gasteroldefinisie is OK.';
$string['check_nodemodules_details'] = '<p>Die gids <code>{$a->path}</code> bevat Node.js-modules en hul afhanklikes, tipies deur die NPM-utiliteit geïnstalleer. Hierdie modules kan vir lokale Moodle-ontwikkeling nodig wees, soos vir gebruik van die grunt-raamwerk. Hulle is nie nodig om \'n Moodle-werf in produksie te loop nie en kan potensieel gevaarlike kode bevat, wat jou werf aan afstandsaanvalle blootstel.</p><p>Dit word sterk aanbeveel dat die gids verwyder word as die werf via \'n publieke URL beskikbaar is, of om minstens webtoegang tot die gids in jou werfbediener se konfigurering te verhoed.</p>';
$string['check_nodemodules_info'] = 'Die node_modules-gids behoort nie op publieke werwe teenwoordig te wees nie.';
$string['check_nodemodules_name'] = 'Node.js modulegids';
$string['check_openprofiles_details'] = 'Oop gebruikersprofiele kan deur spammers misbruik word. Die aanbeveling is dat óf <code>Forseer gebruikers om in te teken vir profiele</code> óf <code>Forseer gebruikers om in te teken</code> ontsper word.';
$string['check_openprofiles_error'] = 'Enigiemand kan gebruikerprofiele besigtig sonder om in te teken.';
$string['check_openprofiles_name'] = 'Oop gebruikersprofiele';
$string['check_openprofiles_ok'] = 'Inteken word vereis voor gebruikersprofiele besigtig word.';
$string['check_passwordpolicy_details'] = '<p>Daar word aanbeveel dat \'n wagwoordbeleid ingestel word, aangesien die raai van wagwoorde dikwels die maklikste manier is om ongemagtigde toegang te verkry.
Moet egter nie die vereistes te streng maak nie, aangesien dit kan veroorsaak dat gebruikers nie hul wagwoorde kan onthou nie, en die wagwoord vergeet of neerskryf.</p>';
$string['check_passwordpolicy_error'] = 'Wagwoordbeleid is nie ingestel nie.';
$string['check_passwordpolicy_name'] = 'Wagwoordbeleid';
$string['check_passwordpolicy_ok'] = 'Wagwoordbeleid is ontsper';
$string['check_preventexecpath_details'] = '<p>Die toelaat van uitvoerbare paaie om via die Admin GUI gestel te word, is \'n vektor vir eskalering van vrywaring. Dit moet in config.php:</p><p><code>$CFG->preventexecpath = true;<code></p> geforseer word';
$string['check_preventexecpath_name'] = 'Uitvoerbare paaie';
$string['check_preventexecpath_ok'] = 'Uitvoerbare paaie slegs stelbaar in config.php.';
$string['check_preventexecpath_warning'] = 'Uitvoerbare paaie kan in die Admin GUI gestel word.';
$string['check_publicpaths_403'] = '(\'n 403 is teruggegee, dit behoort verkieslik 404 te wees)';
$string['check_publicpaths_generic'] = '{$a} dokumente behoort nie publiek te wees nie';
$string['check_publicpaths_name'] = 'Kontroleer alle publieke/private paaie';
$string['check_riskadmin_detailsok'] = '<p>Verifieer asseblief die volgende lys stelseladministrateurs:</p>{$a}';
$string['check_riskadmin_detailswarning'] = '<p>Verifieer asseblief die volgende lys stelseladministrateurs:</p>{$a->admins}
<p>Jy word aangeraai om administrateurrolle slegs in die stelselkonteks toe te ken. Die volgende gebruikers het (nie-ondersteunde) adminroltoewysings in ander kontekste:</p>{$a->unsupported}';
$string['check_riskadmin_name'] = 'Administrateurs';
$string['check_riskadmin_ok'] = 'Bedieneradministrateur(s) gevind {$a}.';
$string['check_riskadmin_unassign'] = '<a href="{$a->url}">{$a->fullname} ({$a->email}) hersien roltoewysing</a>';
$string['check_riskadmin_warning'] = 'Gevind {$a->admincount} bedieneradministrateurs en {$a->unsupcount} nie-ondersteunde adminroltoewysings.';
$string['check_riskbackup_details_overriddenroles'] = '<p>Hierdie aktiewe oorheersing gee aan gebruikers die vermoë om gebruikerdata in rugsteune in te sluit. Verseker asseblief dat hierdie toestemming nodig is.</p> {$a}';
$string['check_riskbackup_details_systemroles'] = '<p>Die volgende stelselrolle laat tans toe dat gebruikers gebruikerdata in rugsteune gebruik. Verseker asseblief dat hierdie toestemming nodig is.</p> {$a}';
$string['check_riskbackup_details_users'] = '<p>As gevolg van die bogemelde rolle of plaaslike oorheersings het die volgende gebruikerprofiele tans toestemming om rugsteune te maak met private data van enige gebruikers wat in hul kursus ingeskryf is. Verseker dat hulle (a) betroubaar en (b) deur sterk wagwoorde beskerm is:</p>{$a}';
$string['check_riskbackup_detailsok'] = 'Geen rolle laat die rugsteun van gebruikerdata uitdruklik toe nie. Let egter daarop dat admins met die "doenenigiets" vermoë dit waarskynlik steeds sal kan doen.';
$string['check_riskbackup_editoverride'] = '<a href="{$a->url}">{$a->name} in {$a->contextname}</a>';
$string['check_riskbackup_editrole'] = '<a href="{$a->url}">{$a->name}</a>';
$string['check_riskbackup_name'] = 'Rugsteun van gebruikerdata';
$string['check_riskbackup_ok'] = 'Geen rolle laat die rugsteun van gebruikerdata uitdruklik toe nie';
$string['check_riskbackup_unassign'] = '<a href="{$a->url}">{$a->fullname} ({$a->email}) in {$a->contextname}</a>';
$string['check_riskbackup_warning'] = '{$a->rolecount} rolle gevind, {$a->overridecount} oorheers en {$a->usercount} gebruikers met die vermoë om gebruikerdata te rugsteun.';
$string['check_riskxss_details'] = '<p>RISK_XSS dui alle gevaarlike vermoëns aan wat slegs deur betroubare gebruikers gebruik mag word.</p>
<p>Verifieer asseblief die volgende lys van gebruikers en verseker dat jy hulle ten volle op hierdie bediener vertrou:</p><p>{$a}</p>';
$string['check_riskxss_name'] = 'XSS betroubare gebruikers';
$string['check_riskxss_warning'] = 'RISK_XSS - het {$a} gebruikers gevind wat vertrou moet word.';
$string['check_unsecuredataroot_details'] = '<p>Die datastamgids mag nie via die web toeganklik wees nie. Die beste manier om te verseker dat die gids nie toeganklik is nie, is om van \'n gids buite die publieke webgids gebruik te maak.</p>
<p>As jy die gids skuif, moet jy die <code>$CFG->dataroot</code> verstelling in <code>config.php</code> dienooreenkomstig bywerk.</p>';
$string['check_unsecuredataroot_error'] = 'Jou datastamgids <code>{$a}</code> is op die verkeerde plek en is aan die web blootgestel!';
$string['check_unsecuredataroot_name'] = 'Onveilige datastam';
$string['check_unsecuredataroot_ok'] = 'Datastamgids moet nie via die web toeganklik wees nie.';
$string['check_unsecuredataroot_warning'] = 'Jou datastamgids <code>{$a}</code> is op die verkeerde plek en kan aan die web blootgestel wees.';
$string['check_vendordir_details'] = '<p>Die gids <code>{$a->path}</code> bevat verskeie derdepartybiblioteke en hul afhanklikes, wat gewoonlik deur die PHP-samesteller geïnstalleer word. Hierdie biblioteke kan nodig wees vir plaaslike Moodle-ontwikkeling, soos vir die installasie van die PHP-eenheidraamwerk. Dit is nie nodig om \'n Moodle-werf in produksie te loop nie en kan potensieel gevaarlike kode bevat, wat jou werf aan afstandsaanvalle blootstel.</p><p>Jy word ten sterkste aangeraai om die gids te verwyder as die werf via \'n publieke URL beskikbaar is, of om minstens webtoegang daartoe in jou webbediener se konfigurasie te verhoed.</p>';
$string['check_vendordir_info'] = 'Die verskaffergids behoort nie op publieke werwe teenwoordig te wees nie.';
$string['check_vendordir_name'] = 'Verskaffergids';
$string['check_webcron_details'] = '<p>Om die cron vanaf \'n webblaaier te loop, kan konfidensiële inligting aan anonieme gebruikers blootstel. Jy word aangeraai om slegs die cron uit die opdraglyn te loop, of \'n cron-wagwoord vir afstandstoegang te stel.</p>';
$string['check_webcron_name'] = 'Web cron';
$string['check_webcron_ok'] = 'Anonieme gebruikers kan nie toegang tot cron kry nie.';
$string['check_webcron_warning'] = 'Anonieme gebruikers kan toegang tot cron kry.';
$string['configuration'] = 'Konfigurering';
$string['description'] = 'Beskrywing';
$string['details'] = 'Besonderhede';
$string['eventreportviewed'] = 'Sekuriteitkontroleverslag is besigtig';
$string['issue'] = 'Probleem';
$string['pluginname'] = 'Sekuriteitoorsig';
$string['privacy:metadata'] = 'Die invoegtoepassing van Sekuriteitsoorsig berg geen persoonlike data nie.';
$string['security:view'] = 'Vertoon sekuriteitverslag';
$string['timewarning'] = 'Dataverwerking kan lank duur, wees asseblief geduldig ...';
