<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'quest', language 'af', version '5.1'.
 *
 * @package     quest
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['absent'] = 'Afwesig';
$string['accumulative'] = 'Akkumulatief';
$string['action'] = 'Aksie';
$string['actions'] = 'Aksies';
$string['addacomment'] = 'Voeg kommentaar by';
$string['addcomment'] = 'Voeg kommentaar by';
$string['addelement'] = 'Voeg element by';
$string['addsubmission'] = 'Voeg uitdaging by';
$string['adminlogs'] = 'Adminlogs';
$string['allowteams'] = 'Laat werkspanne toe';
$string['allowteams_help'] = '<P align="justify">Hierdie parameter bepaal dat elke student wat aan hierdie QUESTOURnament deelneem, aan \'n span moet behoort. In so \'n geval, wanneer \'n student vir die eerste keer toegang tot die QUESTOURnament kry, sal hy die naam van die span waaraan hy behoort, moet invoer.</P>
<P align="justify">Verder, in hierdie geval, bo en behalwe die individuele rangorde, word die span se rangorde ook vertoon.</P>
<P align="justify">Die aantal spanlede word deur die parameter <a href="help.php?component=quest&identifier=ncomponents"">Aantal lede</a> gestel en kan deur die onderwysers bestuur word gedurende die duur van die QUESTOURnament. As foute voorkom, kan dit reggestel word deur die opsie <a href="help.php?component=quest&identifier=changeteamteacher"">Bestuur Spanne</a> te gebruik, wat slegs aan onderwysers beskikbaar is.</P>';
$string['amendassessmentelements'] = 'Wysig assesseringelemente';
$string['answer'] = 'Antwoord';
$string['answer_not_found'] = 'Kan nie antwoordrekord met id {$a} kry nie';
$string['answercontent'] = 'Antwoordinhoud';
$string['answerexisty'] = '\'n Antwoord op hierdie uitdaging bestaan reeds';
$string['answername'] = 'Antwoord: {$a->title}';
$string['answernoauthorizedupdate'] = 'Jy is nie gemagtig om jou antwoord by te werk nie';
$string['answers'] = 'Antwoorde.';
$string['answersubmission'] = 'Antwoord op die uitdaging';
$string['answersubmission_help'] = '<P align="justify">Hierdie bladsy laat toe dat die uitdaging beantwoord word.</P>
<P align="justify">Die velde wat vertoon sal word, is:</P>
<ul>
  <li><strong>Titel</strong>: naam wat die antwoord wat ingedien moet word, identifiseer.</li>
  <li><strong>Beskrywing</strong>: dit is die liggaam van die antwoord wat ingedien word, wat al die items wat deur die assesseringsvorm van die uitdaging gespesifiseer is, moet dek.</li>
  <li><strong>Aanhegsels</strong>: as die aanstuur van aanhegsels toegelaat word, sal dit moontlik wees om dit aan die einde van die liggaam van die antwoord vir indiening by te voeg.</li>
</ul>';
$string['approve'] = 'Keur goed';
$string['approvesubmission'] = 'Keur goed/Verwerp Uitdaging/Vraag';
$string['approvesubmission_help'] = '<P align="justify">Hierdie bladsy laat die onderwyser toe om \'n uitdaging wat deur \'n student voorgestel is, goed te keur, te berg of uit te wis. Die beskikbare aksies word hieronder beskryf:</P>
<ul>
  <li><strong align="justify">Keur goed</strong>: al die data wat met die uitdaging verband hou, word saam met die veranderinge wat deur die onderwyser voorgestel is, geberg. Hierna sal die uitdaging aan die res van die studente beskikbaar wees, wat antwoorde sal kan indien sodra die uitdaging geopen word.</li>
  <li><strong align="justify">Berg</strong>: al die veranderinge aan die uitdaging, wat deur die onderwyser gemaak is, word geberg, maar sal steeds nie aan die res van die studente beskikbaar wees nie. Dit laat toe dat die outeur van die uitdaging die nodige veranderinge aanbring, sodat die onderwyser dit kan goedkeur.</li>
</ul>
<P align="justify">Wanneer enige van hierdie aksies plaasvind, word \'n boodskap aan die outeur van die uitdaging gestuur (intern of per e-pos, afhangend van die gebruikervoorkeure volgens sy profiel).</P>';
$string['assess'] = 'Assesseer';
$string['assessedon'] = 'Geassesseer op {$a}';
$string['assessment'] = 'Assessering';
$string['assessmentby'] = 'Assessering deur {$a}';
$string['assessmentcharacteristics'] = 'Eienskappe van die assessering';
$string['assessmentglobal'] = 'Globale assessering';
$string['assessmentgrade'] = 'Assesseringspunt: {$a}';
$string['assessmentof'] = 'Assessering van "{$a}"';
$string['assessmentofthissubmission'] = 'Assessering van hierdie uitdaging';
$string['assessments'] = 'Assesserings';
$string['assessmentsby'] = 'Assesserings deur {$a}';
$string['assessthisanswer'] = 'Assesseer hierdie antwoord';
$string['assessthissubmission'] = 'Assesseer hierdie uitdaging';
$string['assessthissubmission_help'] = '<P align="justify">Hierdie bladsy laat die onderwyser toe om die werk van die studente wat veranderinge in die QUESTOURnament voorstel, te assesseer. Die punt wat gegee word, sal afhang van beide die werk van die student as outeur van \'n uitdaging, en as evalueerder van die antwoorde wat ontvang is.</P>
<P align="justify">Ten einde die assessering van die taak te vergemaklik, sal \'n stel assesseringelemente gebruik word, wat elkeen \'n aspek om in die opdrag te assesseer, dek. Vir elke assesseringelement sal dit nodig wees om:
<div align="justify">
  <OL>
<LI>\'n Punt in te stel deur op die toepaslike radioknoppie te kliek, en \'n opsie te kies uit \'n kieslys wat aangebied word, ensovoorts, wat sal afhang van die maatstaf wat vir daardie assesseringelement gebruik word.
<LI>Gee \'n uiteensetting van waarom daardie punt toegeken is. As die rede as voor die hand liggend beskou word, kan hierdie veld leeg gelaat word. Dit moet egter in berekening gebring word dat die student wie se werk geassesseer word, \'n klagte oor die toegekende punt kan indien.
  </OL>
</div>
<P align="justify">Dit is ook moontlik om \'n algemene kommentaar oor die geassesseerde werk te lewer. Hierdie kommentaar moet eerbiedig en opbouend wees. Die punt en kommentaar daar rondom sal aan die outeur van die uitdaging beskikbaar gestel word. Die onderwyser sal die globale punt per hand kan wysig, in geval dit nodig is om die punt wat outomaties bereken is, aan te pas.
<P align="justify">Die maksimum moontlike punt vir die outeur van die uitdaging sal die maksimum punt wees wat deur die uitdaging, vir die duur daarvan, bereik word, wanneer ook al \'n korrekte antwoord ingedien is. Aan die ander kant, as geen korrekte antwoord ontvang woord voordat die uitdaging sluit nie, sal die Aanvanklike Punt ook as die maksimum punt beskou word.';
$string['assignmentnotinthecorrectphase'] = 'Assessering is nie in die korrekte fase nie';
$string['attachment'] = 'Aanhegsel';
$string['attachments'] = 'Aanhegsels';
$string['attachmentsnoauthorizedupdate'] = 'Jy is nie gemagtig om hierdie aanhegsels te wysig nie';
$string['authorofsubmission'] = 'Outeur van indiening';
$string['by'] = 'deur';
$string['bynameondate'] = 'deur {$a->name} - {$a->date}';
$string['calification'] = 'Punt';
$string['calification_provisional_msg'] = 'Assessering wat vertoon word, kan provisioneel wees';
$string['calificationautor'] = 'Assessering vir die outeur van die uitdaging';
$string['cantRespond_WARN'] = 'Het nie toestemming om te beantwoord nie.';
$string['cantRespond_WARN_notingroup_or_challengeended'] = 'Jy kan nie antwoord nie. Jy behoort nie aan hierdie groep nie, of die uitdaging is beëindig.';
$string['challengeend'] = 'Sluitingsdatum van die uitdaging';
$string['challengeend_help'] = '<P align="justify">Dit laat jou toe om die sluitingsdatum van \'n uitdaging te stel. Vanaf daardie datum sal dit nie moontlik wees om enige verdere antwoorde aan die uitdaging te stuur nie. Onderwysers kan egter voortgaan met assessering van die outeur van die uitdaging, beide vir die vraag wat gestel is en vir die werk wat as assesseerder gedoen is. Outeurs van die uitdagings kan ook aanhou om antwoorde, wat deur ander studente ingestuur word, te assesseer.</P>
<P align="justify">Wanneer die uitdaging sluit, sal alle deelnemers die antwoorde wat deur ander ingestuur is, kan sien, asook die assesserings en punte wat verkry is.</P>
<P align="justify">Hierdie datum kan nie later wees as die <a href="help.php?component=quest&identifier=dateend"">Sluitingsdatum</a> van die QUESTOURnament nie, en ook nie voor die a href="help.php?component=quest&identifier=submissionstart"">Aanvangsdatum van die Uitdaging</a> nie.</P>';
$string['challengestart'] = 'Begindatum van die uitdaging';
$string['challengestart_help'] = '<P align="justify">Dit laat jou toe om die aanvangsdatum van die uitdaging te stel. Hierdie parameter kan deur \'n onderwyser aangepas word.</P>
<P align="justify">As die uitdaging deur \'n student geskep word, word die skeppingsdatum as die aanvangsdatum van die uitdaging gebruik, maar die onderwysers kan hierdie waarde verander wanneer hulle die uitdaging goedkeur of wysig.</P>
<P align="justify">Vanaf hierdie dag kan studente die uitdaging besigtig en hul antwoorde stuur.</P>
<P align="justify">Hierdie datum moet voor die Sluitingsdatum van die uitdaging wees.</P>';
$string['change'] = 'Berg Veranderinge';
$string['changemanualcalification'] = 'Verander punt per hand';
$string['changeteam'] = 'Bestuur Spanne';
$string['changeteamteacher'] = 'Bestuur Spanne';
$string['changeteamteacher_help'] = '<P align="justify">Hierdie opsie laat bestuur van die spanne van die QUESTOURnament toe, of om \'n student uit een span na \'n ander te skuif, indien nodig.</P>
<P align="justify">As \'n student van een span na \'n ander geskuif word en die span sy laaste lid verloor, sal dit outomaties verdwyn.</P>';
$string['checkthat'] = 'Kontroleer dat';
$string['clasification'] = 'Lysrang';
$string['closebeforeopen'] = 'Die Sluitingsdatum van die QUESTOURnament moet later as die Begindatum wees';
$string['comment'] = 'Kommentaar';
$string['commentby'] = 'Kommentaar deur';
$string['commentsauthor'] = 'Algemene kommentaar deur die outeur';
$string['commentsforauthor'] = 'Kommentaar aan outeur';
$string['commentsforauthor_help'] = '<strong>Kommentaar aan outeur</strong>: in hierdie veld sal dit moontlik wees om aanbevelings of kommentaar in sluit wat die onderwyser teenoor die student wat die uitdaging voorgestel het, wil lewer, en wat ook aan die res van die onderwysers toeganklik sal wees.</li>';
$string['commentsforstudent'] = 'Kommentaar vir studente';
$string['commentsforstudent_help'] = '<strong>Kommentaar vir studente</strong>: hierdie veld bevat die kommentaar wat die onderwyser oor hierdie uitdaging aan die studente wil vertoon; hierdie kommetaar sal aan alle deelnemers van die QUESTOURnament beskikbaar wees.';
$string['commentsforteacher'] = 'Kommentaar vir die onderwyser';
$string['commentsteacher'] = 'Algemene kommentaar deur onderwyser';
$string['confirmchangeform'] = 'Dit sal die evaluasievorm verander. Is jy seker?';
$string['confirmdelete'] = 'Bevestig uitwissing';
$string['confirmdeletionofthisitem'] = 'Bevestig uitwis van hierdie item {$a}';
$string['correct'] = 'Korrek';
$string['currentphase'] = 'Huidige fase van QUESTOURnament';
$string['currentphaseanswer'] = 'Antwoordfase';
$string['currentphasesubmission'] = 'Indieningsfase';
$string['dateanswer'] = 'Datum';
$string['dateassess'] = 'Assesseringsdatum';
$string['dateend'] = 'Sluit op';
$string['dateend_help'] = '<P align="justify">Hierdie parameter stel die sluitingsdatum van hierdie QUESTOURnament. Ná hierdie sluitingsdatum sal studente wat toegang tot die QUESTOURnament het, nie enige van die gewone aksies kan uitvoer nie. Op hierdie stadium sal die klassifikasies van die QUESTOURnament finaal wees.</P>
<P align="justify">Sodra die kompetisie verby is, sal die inhoud steeds toeganklik wees vir studente en onderwysers van die kursus, wanneer dit ook al gedefinieer is toe die QUESTOURnament geskep is, wat beteken dat dit steeds moontlik sal wees om toegang tot uitdagings en antwoorde, wat deur ieder en elke deelnemer ingedien is, te verkry, asook tot hul klassifikasies.</P>';
$string['dateendevent'] = 'Einde van QUESTOURnament "{$a}"';
$string['dateendsubmissionevent'] = 'Einde van uitdaging "{$a}"';
$string['dateofend'] = 'Sluitingsdatum';
$string['dateofend_help'] = '<P align="justify">Hierdie parameter stel die sluitingsdatum van hierdie QUESTOURnament. Ná hierdie sluitingsdatum sal studente, wat toegang tot die QUESTOURnament het, nie enige van die gewone aksies kan uitvoer nie. Op hierdie punt sal die klassifikasies van die QUESTOURnament finaal wees.</P>
<P align="justify">Sodra die kompetisie verby is, sal die inhoud daarvan steeds toeganklik vir die studente en onderwysers van die kursus wees, wanneer dit ook al gedefinieer is toe die QUESTOURnament geskep is, wat beteken dat dit steeds moontlik sal wees om toegang tot uitdagings en antwoorde, wat deur ieder en elke deelnemer ingedien is, te verkry, asook tot hul klassifikasies.</P>';
$string['dateofstart'] = 'Begindatum';
$string['datestart'] = 'Begin op';
$string['datestart_help'] = '<P align="justify">Hierdie parameter stel die begindatum van hierdie QUESTOURnament. Ná hierdie datum sal studente van die kursus toegang tot die QUESTOURnament hê om \'n uitdaging by te voeg, \'n antwoord op \'n uitdaging in te dien, of enige ander gewone aksie te verrig.</P>
<P align="justify">Hierdie datum word gemerk wanneer \'n QUESTOURnament gedefinieer word, sodat dit, as dit ná die <a href="help.php?component=quest&identifier=dateend"">Sluitingsdatum</a> is, daar \'n foutboodskap vertoon word en die QUESTOURnament wat gedefinieer word, nie geskep sal word nie.</P>';
$string['datestartevent'] = 'Begin van QUESTOURnament "{$a}"';
$string['datestartsubmissionevent'] = 'Begin van uitdaging "{$a}"';
$string['datestr'] = '%m/%d/%y<br />%H:%M';
$string['datestrmodel'] = '%%m/%%d/%%y &nbsp;&nbsp;%%H:%%M';
$string['deadline'] = 'Spertyd';
$string['deadlineis'] = 'Spertyd is {$a}';
$string['delete'] = 'Wis uit';
$string['deletechallenge'] = 'Hierdie uitdaging is uitgewis';
$string['deleting'] = 'Word uitgewis';
$string['description'] = 'Beskrywing';
$string['detailsofassessment'] = 'Besonderhede van assessering';
$string['difficultyAttainable'] = 'Middelmatig';
$string['difficultyEasy'] = 'Maklik';
$string['difficultyHard'] = 'Moeilik';
$string['difficultyVeryHard'] = 'Baie moeilik';
$string['disagreewiththisassessment'] = 'Stem nie met hierdie assessering saam nie';
$string['displayoffinalgrades'] = 'Vertoon finale punte';
$string['dontshowgrades'] = 'Moet nie punte vertoon nie';
$string['doyouwantparticularform'] = 'Wil jy vir hierdie uitdaging \'n evaluasievorm anders as die een wat deur die QUESTOURnament-skepper gedefinieer is, gebruik?';
$string['edit'] = 'Wysig';
$string['editacomment'] = 'Wysig kommentaar';
$string['editelementsanswer'] = 'Wysig assesseringselemente vir antwoorde';
$string['editelementsautor'] = 'Wysig assesseringselemente vir outeurs';
$string['editingassessmentelements'] = 'Assesseringselemente word gewysig';
$string['editingassessmentelementsofautors'] = 'Assesseringselemente van outeurs word gewysig';
$string['element'] = 'Element';
$string['elements'] = 'Assesseringselemente';
$string['elements_help'] = '<P align="justify">Ten einde \'n antwoord wat aan \'n uitdaging ingedien is, te assesseer, sal \'n aantal &quot;Assesseringelemente&quot; gedefinieer word, wat elk \'n spesifieke aspek om in die antwoorde te assesseer, dek, met die getal afhanklik van die grootte en kompleksiteit van die uitdaging . Die elemente sal die volgende kenmerke hê:
<div align="justify">
  <OL>
      <li>BESKRYWING van die assesseringelement. Dit behoort duidelik te bepaal watter aspek van die opdrag geassesseer word. In die geval van \'n kwalitatiewe assessering sal dit nuttig wees om besonderhede te verskaf van wat as uitstekend, gemiddeld, ensovoorts beskou word.</li>
      <li>SKAAL van die assesseringelement. Daar is etlike vooraf bepaalde skale, van die eenvoudige JA/NEE-skaal tot \'n skaal van totale persentasie. Elke assesseringelement sal sy eie skaal gebruik, wat só gekies moet word dat dit kan aanpas by elke moontlike variasie van die element. Dit moet egter in berekening gehou word dat die skaal nie bepaal hoe belangrik \'n assesseringelement is wanneer die finale punt bereken word nie: byvoorbeeld, \'n element met \'n 2-punt skaal sal dieselfde &quot;invloed&quot; in die finale punt hê as \'n ander element wat \'n 100-punt skaal gebruik, wanneer die onderskeie elemente dieselfde <i>gewig</i> of oordenkingsfaktor het.</li>
      <li>GEWIG van die assesseringelement. By verstek het elke element dieselfde belangrikheid wanneer die finale punt van die opdrag bereken word. Hierdie feit kan egter verander word deur aan die belangriker elemente \'n gewig van meer as een te gee, en om aan die minder belangrike elemente \'n gewig van minder as een toe te ken. Dit moet ook in berekening gehou word dat die verandering van die gewig NIE die moontlike maksimum punt van \'n ingediende antwoord affekteer nie, omdat hierdie waarde bepaal word deur die <a href="help.php?component=quest&identifier=maxcalification"">Hoogste Punt</a> parameter wat vir die uitdaging gestel is, waaraan die antwoord ingedien word, asook die tyd wat dit ingedien is.
      </li>
  </OL>
<P align="justify">Die stelsel laat toe dat jy die stel assesseringelemente wat vir elke uitdaging gedefinieer is en by \'n QUESTOURnament bygevoeg word, doelmaak.
</div>';
$string['elementsautor'] = 'Assesseringselemente vir Outeurs';
$string['elementsautor_help'] = '<P align="justify">Ten einde \'n voorgestelde uitdaging te assesseer, sal \'n aantal &quot;Assesseringelemente&quot; gedefinieer word, wat elk \'n spesifieke aspek om in die voorgestelde uitdaging te assesseer, dek, met die getal afhanklik van die grootte en kompleksiteit van die voorgestelde uitdaging. Die elemente sal die volgende kenmerke hê:
<div align="justify">
  <OL>
      <li>BESKRYWING van die assesseringelement. Dit behoort duidelik te bepaal watter aspek van die opdrag geassesseer word. In die geval van \'n kwalitatiewe assessering sal dit nuttig wees om besonderhede te verskaf van wat as uitstekend, gemiddeld, ensovoortes beskou word.</li>
      <li>SKAAL van die assesseringelement. Daar is etlike vooraf bepaalde skale, vanaf die eenvoudige JA/NEE-skaal tot \'n skaal van totale persentasie. Elke assesseringelement sal sy eie skaal gebruik, wat só gekies moet word dat dit kan aanpas by elke moontlike variasie van die element. Dit moet egter in berekening gehou word dat die skaal nie bepaal hoe belangrik \'n assesseringelement is wanneer die finale punt bereken word nie: byvoorbeeld, \'n element met \'n 2-punt skaal sal dieselfde &quot;invloed&quot; in die finale punt hê as \'n ander element wat \'n 100-punt skaal gebruik, wanneer die onderskeie elemente dieselfde <i>gewig</i> of oordenkingsfaktor het.</li>
      <li>GEWIG van die assesseringelement. By verstek het elke element dieselfde gewig wanneer die finale punt van die opdrag bereken word. Hierdie feit kan egter verander word deur aan die belangriker elemente \'n gewig van meer as een te gee, en om aan die minder belangrike elemente \'n gewig minder as een toe te ken. Dit moet ook in berekening gehou word dat die verandering van die gewig NIE die moontlike maksimum punt van \'n ingediende Uitdaging affekteer nie, omdat hierdie waarde bepaal word deur die  <a href="help.php?component=quest&identifier=maxcalification"">Hoogste Punt</a> parameter wat vir die uitdaging gestel is, waaraan die antwoord ingedien word, asook die tyd wat dit ingedien is.
      </li>
  </OL>
</div>';
$string['elementweight'] = 'Elementgewig';
$string['emailaddsubmission'] = 'Hallo {$a->firstname}.

\'n Nuwe uitdaging is in
\'{$a->sitename} \' bediener bygevoeg, in die QUESTOURnament \'{$a->name} \'. Die naam daarvan is \'{$a->title} \'.

Om toegang tot hierdie nuwe uitdaging te verkry, kliek asseblief hier:

<a href="{$a->link}">{$a->link}</a>';
$string['emailaddsubmissionsubject'] = 'Moodle. Uitdaging is in module QUESTOURnament bygevoeg';
$string['emailansweradd'] = 'Hallo {$a->firstname}.

\'n Nuwe antwoord is in
\'{$a->sitename} \' werf ontvang, in die QUESTOURnament \'{$a->name} \', vir die uitdaging \'{$a->title} \'. Dit word \'{$a->secondname} \' genoem.

Om toegang tot hierdie antwoord te verkry, kliek asseblief hier:

<a href="{$a->link}">{$a->link}</a>';
$string['emailansweraddsubject'] = 'Moodle. Antwoord is in module QUESTOURnament bygevoeg';
$string['emailanswerdelete'] = 'Hallo {$a->firstname}.

\'n Antwoord is in
\'{$a->sitename} \' werf uitgewis, in die QUESTOURnament \'{$a->name} \', vir die uitdaging \'{$a->title} \'. Dit is \'{$a->secondname} \' genoem.

Om toegang tot hierdie uitdaging te verkry, kliek asseblief hier:

<a href="{$a->link}">{$a->link}</a>';
$string['emailanswerdeletesubject'] = 'Module. Antwoord uitgewis in QUESTOURnament module';
$string['emailapprobe'] = 'Hallo {$a->firstname}.

\'n Nuwe uitdaging is in
\'{$a->sitename} \' bediener bygevoeg, in die QUESTOURnament \'{$a->name} \'. Dit word \'{$a->title} \' genoem.

Om toegang tot hierdie nuwe uitdaging te verkry, kliek asseblief hier:

<a href="{$a->link}">{$a->link}</a>';
$string['emailapprobesubject'] = 'Moodle. Uitdaging in module QUESTOURnament bygevoeg';
$string['emailassessment'] = 'Hallo {$a->firstname}.

\'n Antwoord is in
\'{$a->sitename} \' werf geassesseer, in die QUESTOURnament \'{$a->name} \', van die uitdaging \'{$a->title} \', dit is \'{$a->secondname} \' genoem.

Om toegang tot hierdie antwoord te verkry, kliek asseblief hier:

<a href="{$a->link}">{$a->link}</a>';
$string['emailassessmentautor'] = 'Hallo {$a->firstname}.

\'n Uitdaging is in
\'{$a->sitename} \' werf geassesseer, in die QUESTOURnament \'{$a->name} \'. Dit word \'{$a->title} \' genoem.

Om toegang tot hierdie nuwe uitdaging te verkry, kliek asseblief hier:

<a href="{$a->link}">{$a->link}</a>';
$string['emailassessmentautorsubject'] = 'Moodle. Uitdaging is in module QUESTOURnament geassesseer';
$string['emailassessmentsubject'] = 'Moodle. Antwoord is in module QUESTOURnament geassesseer';
$string['emailchallenge_start'] = 'Hallo {$a->firstname}. Die uitdaging <b>\'{$a->title}\'</b> het in die
QUESTOURnament \'{$a->name}\' begin. (By \'{$a->sitename}\'.)
Om toegang tot die werf waarop die uitdaging is te verkry, kliek asseblief hier:
<a href="{$a->link}">{$a->link}</a>';
$string['emailchallenge_startsubject'] = 'Moodle. QUESTOURnament Uitdaging het begin';
$string['emailchallengeupdate'] = 'Hallo {$a->firstname}.

Uitdaging in
\'{$a->sitename} \' bediener gewysig, in die QUESTOURnament \'{$a->name} \'. Dit word \'{$a->title} \' genoem.

Om toegang tot die uitdaging te verkry, kliek asseblief hier:

<a href="{$a->link}">{$a->link}</a>';
$string['emailchallengeupdatesubject'] = 'Moodle. Uitdaging gewysig in module QUESTOURnament';
$string['emaildeletesubmission'] = 'Hallo {$a->firstname}.

\'n Uitdaging in
\'{$a->sitename} \' bediener is uitgewis, in die QUESTOURnament \'{$a->name} \'. Dit word \'{$a->title} \' genoem.

Om toegang tot die QUESTOURnament te verkry, kliek asseblief hier:

<a href="{$a->link}">{$a->link}</a>';
$string['emaildeletesubmissionsubject'] = 'Moodle. Uitdaging uitgewis in module QUESTOURnament';
$string['emailevaluatecomment'] = 'Hallo {$a->firstname}.
Klagtemeganisme is begin vir \'n assessering in
\'{$a->sitename} \' werf, in die QUESTOURnament \'{$a->name} \', van die uitdaging \'{$a->title} \', antwoord \'{$a->secondname} \'.

Om toegang tot hierdie antwoord te verkry, kliek asseblief hier:

<a href="{$a->link}">{$a->link}</a>';
$string['emailevaluatecommentsubject'] = 'Moodle. Assesseringsklag in module QUESTOURnament';
$string['emailmodifanswer'] = 'Hallo {$a->firstname}.

\'n Antwoord in
\'{$a->sitename} \' is gewysig, in die QUESTOURnament \'{$a->name} \', van die uitdaging \'{$a->title} \', dit was \'{$a->secondname} \' genoem.

Om toegang tot hierdie antwoord te verkry, kliek asseblief hier:

<a href="{$a->link}">{$a->link}</a>';
$string['emailmodifanswersubject'] = 'Moodle. Antwoordwysiging in module QUESTOURnament';
$string['emailsave'] = 'Hallo {$a->firstname}.

Uitdaging in
\'{$a->sitename} \' bediener gewysig, in die QUESTOURnament \'{$a->name} \'. Dit word \'{$a->title} \' genoem.

Om toegang te verkry tot die werf waarop die uitdaging is, kliek asseblief hier:

<a href="{$a->link}">{$a->link}</a>';
$string['emailsavesubject'] = 'Moodle. Veranderinge in uitdaging in module QUESTOURnament';
$string['emailtagline'] = 'Hierdie e-pos is \'n kopie van die boodskap wat jy op \\"{$a} \\" gestuur het';
$string['enterpassword'] = 'Voer wagwoord in:';
$string['enterteam'] = 'Voer Span in';
$string['evaluate'] = 'Evalueer';
$string['evaluation_pending'] = 'Nie geëvalueer nie';
$string['excellent'] = 'Uitstekend';
$string['exponential'] = 'Eksponensioneel';
$string['feedback'] = 'Terugvoer';
$string['feedback_help'] = 'Voer terugvoer oor hierdie deel van die assessering hier in.';
$string['feedbackgoeshere'] = 'Terugvoer moet hier wees';
$string['firstname'] = 'Voornaam';
$string['firstname_help'] = '';
$string['fullactivitylisting'] = 'Volledige aktiwiteitslys';
$string['generalcomment'] = 'Algemene kommentaar';
$string['generalcomment_help'] = '<P align="justify">Hierdie is terugvoer oor die werk wat geassesseer is. Hierdie kommentaar moet eervol en opbouend wees.';
$string['gettechnicallogs'] = 'Verkry tegniese logs';
$string['globalranking'] = 'Globale klassifikasie';
$string['globalranking_help'] = '<P ALIGN=CENTER><strong>Besigtig (Individuele) Rangorde</strong></P>
<P align="justify">Hierdie opsie toon die klassifikasie van die deelnemers in die QUESTOURnament.</P>
<P>Let asseblief daarop dat die onderwysers toegang het tot al die inligting wat hierbo gelys is, terwyl studente slegs die inligting kan sien as die onderwyser wat die QUESTOURnament gedefinieer het, die opsie "Vertoon Outeurbesonderhede aan die Studente in Klassifikasies" gekies het. In enige ander geval sal studente nie toegang hê tot hierdie gedeeltelike data wat verband hou met die veranderinge wat deur ander studente voorgestel is nie.</P>
  <P>By verstek word die rangorde volgens die individuele punt wat deur elke student verkry is, gesorteer, alhoewel hierdie volgorde verander kan word deur \'n ander sorteerparameter te kies en die naam te druk.</P>
  <P>Dit is ook moontlik om toegang tot die rangorde van spanne te verkry deur die opsie Besigtig Opsomming volgens Spanne te gebruik.</P>
</div>';
$string['good'] = 'Goed';
$string['grade'] = 'Punt';
$string['gradeassessment'] = 'Puntassessering';
$string['gradeautor'] = 'Outeur se Punt';
$string['graded'] = 'Gemerk';
$string['gradedbyteacher'] = 'Gemerk deur {$a}';
$string['gradeforassessments'] = 'Punt vir assesserings';
$string['gradeofsubmission'] = 'Punt van indiening: {$a}';
$string['grading'] = 'Assesseer Antwoord';
$string['grading_help'] = '<P align="justify">Hierdie bladsy laat toe dat \'n ingediende antwoord geassesseer word. Die punt wat gegee word, sal afhang van hoe die antwoord ooreenstem met dit wat in die ooreenstemmende uitdaging vereis word.</P>
<P align="justify">Om die assessering van die antwoord te vergemaklik, sal \'n stel assesseringelemente gebruik word, wat elk \'n aspek om in die antwoord te assesseer, dek. Vir elke assesseringelement sal dit nodig wees om:
<div align="justify">
  <OL>
<LI>\'n Punt daar te stel deur die toepaslike radioknoppie te kliek, \'n opsie in \'n kieslys wat verskaf word, te kies, ensovoorts, wat sal afhang van die skaal wat vir daardie assesseringelement gebruik word.
<LI>\'n Verduideliking te stel van waarom daardie punt toegeken is. As die rede daarvoor as voor die hand liggend beskou word, kan hierdie veld leeg gelaat word. Dit moet egter in gedagte gehou word dat die student wie se werk geassesseer word, \'n klagte oor die punt wat toegeken is, kan indien.
  </OL>
</div>
<P align="justify">Dit is ook moontlik om algemene kommentaar oor die geassesseerde werk te lewer. Hierdie kommentaar moet eerbiedig en opbouend wees. Die punt en kommentaar sal aan die outeur van die antwoord toeganklik gemaak word, asook aan elke student sodra die uitdaging gesluit word.
<P align="justify">Die onderwyser of outeur van die uitdaging sal die globale punt per hand kan wysig, in geval dit nodig is om die outomaties berekende punt aan te pas.
<P align="justify">Die maksimum moontlike punt vir die outeur van \'n korrekte antwoord sal die punt van die uitdaging wees ten tyde van die indiening van die antwoord.';
$string['gradingcharacteristics'] = 'Kenmerke van gradering';
$string['gradingstrategy'] = 'Merkstrategie';
$string['gradingstrategy_help'] = '<P align="justify">Die puntstrategie wat gebruik word om die antwoorde te assesseer wat op uitdagings in \'n QUESTOURnament ingedien is, is akkumulatief.

<P align="justify">Dit beteken dat met die merk van elke assessering \'n aantal elemente gebruik word, en elkeen moet \'n spesifieke aspek van die opdrag wat geassesseer word, dek. Die aantal assesseringelemente sal afhang van die grootte en kompleksiteit van die opdrag. Die assesseringelemente beskik oor die volgende eienskappe:

<div align="justify">
  <OL>
      <li>BESKRYWING van die assesseringelement. Dit behoort duidelik te bepaal watter aspek van die opdrag geassesseer word. In geval van \'n kwalitatiewe assessering sal dit nuttig wees om besonderhede te verskaf van wat as uitstekend, gemiddeld, ens. beskou word.</li>
      <li>SKAAL van die assesseringelement. Daar is etlike vooraf bepaalde skale, vanaf die eenvoudige JA/NEE-skaal tot \'n skaal van totale persentasie. Elke assesseringelement sal sy eie skaal gebruik, wat só gekies moet word dat dit by elke moontlike variasie van die element kan aanpas. Dit moet egter in berekening gehou word dat die skaal nie bepaal hoe belangrik \'n assesseringelement is wanneer die finale punt bereken word nie, byvoorbeeld: \'n element met \'n 2-punt skaal sal dieselfde &quot;invloed&quot; in die finale punt hê as \'n ander element wat \'n 100-punt skaal gebruik, wanneer die onderskeie elemente oor dieselfde <i>gewig</i> of oordenkingsfaktor beskik.</li>
      <li>GEWIG van die assesseringelement. By verstek het elke element dieselfde belangrikheid wanneer die finale punt van die opdrag bereken word. Hierdie feit kan egter verander word deur aan die belangriker elemente \'n swaarder gewig as een toe te ken, en aan die minder belangrike elemente \'n gewig ligter as een. Dit moet ook in gedagte gehou word dat die wysiging van die gewig NIE die moontlike maksimum punt van \'n ingediende antwoord affekteer nie, omdat hierdie waarde deur die <a href="help.php?component=quest&identifier=maxcalification"">Hoogste Punt</a> parameter bepaal word, wat vir die uitdaging gestel is waarvoor die antwoord ingedien word, asook die tyd wat dit ingedien is.
      </li>
  </OL>
</div>';
$string['gradingstrategyautor'] = 'Merkstrategie vir outeurs';
$string['gradingstrategyautor_help'] = '<P align="justify">Die puntstrategie wat gebruik word om die antwoorde te assesseer wat in \'n QUESTOURnament bygevoeg word, is akkumulatief.

<P align="justify">Dit beteken dat tydens die merk van elke assessering \'n aantal elemente gebruik word, en elkeen moet \'n spesifieke aspek van die opdrag wat geassesseer word, dek. Die aantal assesseringelemente sal afhang van die grootte en kompleksiteit van die opdrag. Die assesseringelemente sal oor die volgende eienskappe beskik:
<div align="justify">
  <OL>
      <li>BESKRYWING van die assesseringelement. Dit behoort duidelik te bepaal watter aspek van die opdrag geassesseer word. In die geval van \'n kwalitatiewe assessering sal dit nuttig wees om besonderhede te verskaf van wat as uitstekend, gemiddeld, ens. beskou word.</li>
      <li>SKAAL van die assesseringelement. Daar is etlike vooraf bepaalde skale, vanaf die eenvoudige JA/NEE-skaal tot \'n skaal van totale persentasie. Elke assesseringelement sal van sy eie skaal gebruik maak, wat só gekies word dat dit by elke moontlik variasie van die element kan aanpas. Dit moet egter in berekening gehou word dat die skaal nie bepaal hoe belangrik \'n assesseringelement is wanneer die finale punt bereken word nie, byvoorbeeld: \'n element met \'n 2-punt skaal sal dieselfde &quot;invloed&quot; in die finale punt hê as \'n ander element wat \'n 100-punt skaal gebruik, wanneer die onderskeie elemente oor dieselfde <i>gewig</i> of oordenkingsfaktor beskik.</li>
      <li>GEWIG van die assesseringelement. By verstek het elke element dieselfde belangrikheid wanneer die finale punt van die opdrag bereken word. Hierdie feit kan egter verander word deur aan die belangriker elemente \'n swaarder gewig as een toe te ken, en aan die minder belangrike elemente \'n gewig ligter as een. Dit moet ook in gedagte gehou word dat die wysiging van die gewig NIE die moontlike maksimum punt van \'n ingediende antwoord affekteer nie, omdat hierdie waarde deur die <a href="help.php?component=quest&identifier=maxcalification"">Hoogste Punt</a> parameter bepaal word, wat vir die uitdaging gestel is waarvoor die antwoord ingedien word, asook die tyd wat dit ingedien is.
      </li>
  </OL>
</div>';
$string['groupmode'] = 'Groepmodus';
$string['groupmode_help'] = '<P align="justify">Die groepmodus kan een van drie vlakke wees:</P>
<div align="justify">
  <ul>
    <li><strong>Geen groepe</strong>: Daar is geen subgroepe nie, elkeen is deel van een groot gemeenskap.</li>
      <li><strong>Aparte Groepe</strong>: Elke groep kan slegs sy eie groep sien, ander is onsigbaar.</li>
      <li><strong>Sigbare Groepe</strong>: Elke groep werk in hul eie groep, maar kan ook ander groepe sien.</li>
  </ul>
</div>

<P align="justify">Die groepmodus kan op twee vlakke gedefinieer word:</P>

<div align="justify">
  <ul>
    <li><strong>Kursusvlak</strong>: Die groepmodus wat op die kursusvlak gedefinieer is, is die verstek modus vir alle aktiwiteite wat binne daardie kursus gedefinieer is.</li>
      <li><strong>Aktiwiteitsvlak</strong>: Elke aktiwiteit wat groepe ondersteun, kan ook sy eie groeperingsmodus definieer. As die kursus op "<a href="help.php?module=moodle&amp;file=groupmodeforce"">forseer groepmodus</a>" gestel is, word die verstelling vir elke aktiwiteit geïgnoreer.</li>
  </ul>
</div>';
$string['incorrect'] = 'verkeerd';
$string['individualcalification'] = 'individuele punt';
$string['individualranking'] = 'Besigtig (Individuele) Rangorde';
$string['individualranking_help'] = '<P align="justify">Hierdie opsie toon die klassifikasie van die deelnemers in die QUESTOURnament wat aan dieselfde groep behoort.</P>
<P align="justify">Die volgende parameters word vertoon:</P>
<div align="justify">
  <ul>
    <li><strong>Prent</strong>: prent van die student wat hy self op sy profiel geplaas het.</li>
      <li><strong>Voornaam/Van</strong>: naam en van wat deur die student ingevoer is toe hy homself op die stelsel geregistreer het.</li>
      <li><strong>Antwoorde</strong>: aantal antwoorde wat deur \'n student in hierdie QUESTOURnament ingedien is.</li>
      <li><strong>Geassesseerde Antwoorde</strong>: aantal antwoorde wat in al dié wat deur hierdie student in die QUESTOURnament ingedien is, geassesseer is.</li>
      <li><strong>Aantal Uitdagings</strong>: aantal uitdagings wat deur \'n student in hierdie QUESTOURnament voorgestel is.</li>
      <li><strong>Geassesseerde Uitdagings</strong>: aantal uitdagings wat geassesseer word van al dié wat deur hierdie student in die QUESTOURnament voorgestel is.</li>
      <li><strong>Uitdagingspunt</strong>: total punt wat deur die student verkry is, wat ooreenstem met die assessering wat deur die onderwysers gedoen is van uitdagings wat deur die student voorgestel is.</li>
      <li><strong>Antwoordpunt</strong>: totale punt verkry deur die student, wat ooreenstem met die assessering van die antwoorde wat deur hom ingedien is.</li>
      <li><strong>Spanpunt</strong>: hierdie parameter word slegs vertoon wanneer die opsie <a href="help.php?component=quest&identifier=allowteams"">Laat Spanne toe</a> in die QUESTOURnament gekies is. Dit is die persentasie, gestel deur die opsie <a href="help.php?component=quest&identifier=teamporcent"">Persentasie Spanpunte</a>, van die totale punt wat deur die span, waaraan die student behoort, verkry is, wat by sy individuele punt gevoeg sal word.</li>
      <li><strong>Punt</strong>: Dit is die totale individuele punt van die student, wat sy uitdaging- en antwoordpunte inkorporeer, asook \'n persentasie van sy spanpunt, indien nodig.</li>
  </ul>
    <P>Dit moet beklemtoon word dat die onderwysers toegang het tot al die inligting wat hierbo gelys is, terwyl studente slegs daardie inligting kan sien as die onderwyser wat die QUESTOURnament gedefinieer het, die opsie <a href="help.php?component=quest&identifier=showauthoringdetails"">Vertoon Outeurbesonderhede aan Studente in Klassifikasies</a> gekies het. In enige ander geval sal studente nie toegang hê tot hierdie gedeeltelike data wat verband hou met die uitdagings wat deur ander studente voorgestel is nie.</P>
  <P>By verstek word die rangorde gerangskik volgens die totale individuele punt wat deur elke student verkry is, alhoewel hierdie volgorde verander kan word deur \'n ander sorteringsparameter te kies en die naam te druk.</P>
  <P>Dit is ook moontlik om toegang te verkry tot die rangorde volgens spanne deur die opsie <a href="help.php?component=quest&identifier=teams"">Besigtig Opsomming volgens Spanne</a> te kies.</P>
</div>';
$string['initialpoints'] = 'Aanvanklike punt';
$string['initialpoints_help'] = '<P align="justify">Hierdie parameter stel die aanvanklike punt van die uitdaging wat bygevoeg moet word.</P>
<P align="justify">Die onderwyser sal egter hierdie waarde kan wysig vanaf die minimum punt tot die maksimum punt wat vir die QUESTOURnament, waar die uitdaging bygevoeg moet word, gestel is. \'n Student kan ook hierdie aanvanklike punt wysig wanneer \'n uitdaging bygevoeg word, maar slegs met \'n gelyke of mindere waarde as wat deur die onderwyser as aanvanklike punt van die QUESTOURnament, waar die uitdaging bygevoeg gaan word, gestel is.
 </P>
<P align="justify">Ten laaste is dit belangrik om daarop klem te lê dat die waarde van hierdie parameter vir elke uitdaging in \'n QUESTOURnament anders kan wees.</P>';
$string['inserterror'] = 'Kon nie rekord in tabel {$a} in databasis invoeg nie.';
$string['introattachments'] = 'Addisionele dokumente';
$string['introattachments_help'] = 'Addisionele dokumente vir gebruik in die QUESTOURnament, soos antwoordtemplate, kan bygevoeg word. Aflaaiskakels vir die dokumente sal dan op die Quest-blad onder die beskrywing vertoon word.';
$string['introductiontothechallenge'] = 'Beskrywing van die uitdaging';
$string['invaliddates'] = 'Ongeldige datums. Moet tussen {$a->questdatestart} en {$a->questdateend} wees.';
$string['invalidtext'] = 'Teksveld is leeg';
$string['lastname'] = 'Van';
$string['lastname_help'] = '';
$string['legend'] = 'A (B) [C] {$a} <br>A: Antwoorde. B: Korrekte Antwoorde. <br>C: Ongeassesseerde Antwoorde. {$a} Deur my beantwoord.<br>';
$string['linear'] = 'Direk';
$string['maxcalification'] = 'Hoogste punt';
$string['maxcalification_help'] = '<P align="justify">Hierdie parameter stel die maksimum punt wat elke uitdaging van die QUESTOURnament sal kan bereik, wat beteken dat dit ook die maksimum punt is wat \'n ingediende antwoord sal kan verkry.</P>
<P align="justify">Hierdie waarde kan vir elke uitdaging anders wees, maar kan nie hoër wees as die maksimum punte wat vir die QUESTOURnament waaraan dit behoort, gestel is nie.</P>';
$string['maximumsize'] = 'Grootste grootte';
$string['mincalification'] = 'Laagste punt';
$string['mincalification_help'] = '<P align="justify">Hierdie parameter stel die minimum punt wat elke uitdaging van hierdie QUESTOURnament sal kan bereik, wat beteken dat dit ook die minimum punt is wat \'n ingediende antwoord sal kan verkry.</P>
<P align="justify">Hierdie waarde kan vir elke uitdaging anders wees, maar kan nie laer wees as die minimum punte wat vir die QUESTOURnament waaraan dit behoort, gestel is nie.</P>';
$string['modif'] = 'Wysig';
$string['modifanswersubmission'] = 'Wysig antwoord vir uitdaging {$a}';
$string['modified'] = 'gewysig';
$string['modifsubmission'] = 'Wysig uitdaging';
$string['modifsubmission_help'] = '<P align="justify">Hierdie bladsy laat toe dat die onderwyser \'n uitdaging wat deur \'n student voorgestel is, kan wysig. Die studente sal ook die uitdagings wat hulle voorgestel het, kan wysig, solank dit nog nie deur die onderwyser goedgekeur is nie.</P>

<P align="justify">Die inligting wat oor die uitdaging voorgestel word en wat gewysig kan word, is die volgende:</P>
<ul>
   <li><strong>Titel</strong>: naam van die uitdaging, dit behoort nie die naam van die outeur van die uitdaging in te sluit nie, om sodoende die anonimiteit
van die outeurskap te behou, andersins kan die uitdaging deur die onderwyser geweier of gewysig word.</li>
      <li><strong>Beskrywing</strong>: dit is die liggaam van die uitdaging, waar die probleem en die items wat in die antwoord ingesluit moet word, voorgestel word. Dit moet duidelik en volledig wees.</li>
      <li><strong>Maksimum Punt</strong>: dit is die maksimum punt wat die uitdaging sal kan bereik. Dit word beperk deur die <a href="help.php?component=quest&identifier=maxcalification"">Hoogste Punt</a> van die QUESTOURnament waaraan die uitdaging behoort.</li>
      <li><strong>Aanvanklike Punt</strong>: dit is die punt van die uitdaging wanneer dit oopgemaak word en wat gedurende die ontwikkeling van die toernooi sal verander.</li>
      <li><strong>Aanvangsdatum</strong>: dit stel die datum waarop die uitdaging geopen word; hierdie parameter kan slegs deur die onderwyser gestel word. Wanneer die uitdaging deur \'n student bygevoeg word, is die aanvangsdatum die tyd wanneer die uitdaging bygevoeg word.</li>
      <li><strong>Sluitingsdatum</strong>: dit stel die datum waarop die uitdaging gesluit word, ná hierdie datum sal dit nie moontlik wees om antwoorde in te dien nie, alhoewel die outeur van die uitdaging, of die onderwyser die antwoorde wat tydens die lewensduur van die uitdaging ingedien is, sal kan assesseer. Dit kan nie ná die <a href="help.php?component=quest&identifier=dateend"">Sluitingsdatum</a> wees wat vir die QUESTOURnament gestel is nie.</li>
      <li><strong>Aanhegsels</strong>: dit sal toelaat dat die aanhegsels gespesifiseer word, indien hierdie moontlikheid gestel is toe die QUESTOURnament gedefinieer is. Dit is dan ook moontlik om die aanhegsels wat tot dusver in die uitdaging ingesluit is, uit te wis.</li>
  <li><strong>Kommentaar aan Outeur</strong>: in hierdie veld sal dit moontlik wees om voorstelle of kommentaar in te sluit wat die onderwyser aan die student, wat die uitdaing voorgestel het, wil maak, wat ook aan die res van die onderwysers toeganklik sal wees.</li>
  <li><strong>Kommentaar aan Studente</strong>: in hierdie veld sal dit moontlik wees om kommentaar in te sluit wat die onderwyser aan die studente aangaande die uitdaging wil maak. Hierdie kommentaar sal aan al die deelnemers van die QUESTOURnament beskikbaar wees.</li>
</ul>';
$string['modulehiddenerror'] = 'Module is versteek.';
$string['modulename'] = 'QUESTOURnament';
$string['modulename_help'] = 'QUESTOURnament is \'n aktiwiteit wat toelaat dat kompetisies ontwikkel word. Studente kan aan \'n kompetisie deelneem om \'n stel uitdagings, waarvan die punte met verloop van tyd verander, te beantwoord. Die uitdaging se beloning vergroot as tyd verbygaan sonder enige geldige antwoord. Hierdie aktiwiteit laat toe dat \'n mate van druk en motivering op die kursus geplaas word. Die spel kan individueel of in spanne gespeel word. Die puntebord gee erkenning aan die beste deelnemers.';
$string['modulenameplural'] = 'QUESTOURnaments';
$string['myanswers'] = 'My Antwoorde';
$string['myanswers_help'] = '<strong>My Antwoorde</strong>: dit vertoon al die antwoorde wat deur die huidige gebruiker ingedien is. Vir elke antwoord word die datum van indiening, aksies wat gedoen kan word (Besigtig Assessering, ens.), die punt verkry en die titel vertoon. \'n Antwoord kan te eniger tyd deur die onderwyser gewysig of uitgewis word, terwyl die student slegs \'n antwoord sal kan wysig wat hyself ingedien het, totdat geassesseer is.';
$string['mychallenges'] = 'My Uitdagings';
$string['mychallenges_help'] = '<div align="justify"><strong>My Uitdagings</strong>: dit vertoon \'n lys met al die uitdagings wat deur die gebruiker, wat hierdie blad besigtig, bygevoeg is. Vir elke uitdaging word die huidige punt (maksimum punt wat deur \'n ingediende antwoord op hierdie tydstip verdien kan word), die fase of toestand waarin die uitdaging is, die aantal antwoorde wat ingedien is en die aantal daarvan wat korrek was, die aanvang- en sluitingsdatums, en die titel vertoon. Deur die titel te druk word toegang tot die volledige beskrywing van \'n uitdaging verkry. Die onderwyser sal te eniger tyd \'n uitdaging kan wysig of uitwis, terwyl die outeur, indien dit \'n student is, dit slegs sal kan doen totdat die uitdaging wat hy bygevoeg het, deur die onderwyser goedgekeur is.</div>';
$string['myplace'] = 'My Plek in hierdie QUESTOURnament';
$string['myplace_help'] = '<P align="justify">Hierdie bladsy vertoon die inligting wat met die aktiwiteit, wat deur elke deelnemer aan die QUESTOURnament ontwikkel is, ooreenstem.</P>';
$string['myranking'] = 'My Rangnommer';
$string['myranking_help'] = '<strong>My Rangnommer</strong>: dit vertoon die verskillende punte wat deur \'n student in die QUESTOURnament verkry is, beide die punte wat ooreenstem met die geassesseerde antwoorde en met die voorgestelde uitdagings. Hierdie afdeling sal nie vertoon word as die gebruiker wat hierdie bladsy besigtig, \'n onderwyser is nie.';
$string['myrankingteam'] = 'My Rangnommer volgens Spanne';
$string['myrankingteam_help'] = '<strong>My Rangnommer volgens Spanne</strong>: dit vertoon die punte wat deur die span, waaraan die student wat hierdie bladsy besigtig behoort, verkry is. Hierdie opsie sal slegs vertoon word as die QUESTOURnament die <a href="help.php?component=quest&identifier=allowteams"">Laat Spanne toe</a> opsie gekies het. Hierdie afdeling sal nie vertoon word as die gebruiker wat hierdie bladsy besigtig, \'n onderwyser is nie.';
$string['nanswers'] = 'Antwoorde';
$string['nanswers_help'] = '<strong>Antwoorde</strong>: die aantal antwoorde wat deur \'n student in hierdie QUESTOURnament ingedien is.';
$string['nanswersassessment'] = 'Geassesseerde Antwoorde';
$string['nanswersassessment_help'] = '<strong>Geassesseerde Antwoorde</strong>: die aantal geassesseerde antwoorde van al dié wat deur hierdie student in die QUESTOURnament ingedien is.';
$string['nanswerscorrect'] = 'Korrekte antwoorde';
$string['nanswerscorrectshort'] = 'Korrek';
$string['nanswersshort'] = 'Antwoorde';
$string['nanswerswhithoutassess'] = 'Nie geassesseer nie';
$string['ncomponents'] = 'Aantal lede';
$string['ncomponents_help'] = '<P align="justify">Hierdie parameter stel die maksimum aantal lede wat elke span sal hê.</P>
<P align="justify">As \'n student \'n lid van \'n span wat reeds vol is, probeer word, sal die stelsel hom hiervan inlig en die student sal by \'n ander span moet aansluit.</P>';
$string['ncomponentsteam'] = 'Maks. lede in span';
$string['need_to_be_editor'] = '(Jy moet \'n wysiger wees om uitdagings by te voeg. Vra jou onderwyser vir toestemming.)';
$string['nelements'] = 'Aantal Assesseringelemente';
$string['nelements_help'] = '<P align="justify">Hierdie parameter stel die aantal assesseringelemente wat gebruik sal word om die antwoorde wat vir die uitdagings ingedien is, te assesseer en sal afhang van die eienskappe (grootte, kompleksiteit ...) van daardie uitdagings. Dit sal ook moontlik wees om algemene terugvoer, deur middel van \'n toegewyde area, oor die assessering te lewer.</P>';
$string['nelementsautor'] = 'Aantal Assesseringelemente vir Outeurs';
$string['nelementsautor_help'] = '<P align="justify">Hierdie parameter stel die aantal assesseringelemente wat gebruik sal word om die opdrag wat deur die uitdagingouteurs ontwikkel is, te assesseer. Hierdie getal sal afhang van die eienskappe (grootte, kompleksiteit ...) van die opdrag. Dit sal ook moontlik wees om algemene terugvoer, deur middel van \'n toegewyde area, oor die assessering te lewer.</P>';
$string['newattachment'] = 'nuwe aanhegsel';
$string['newcalification'] = 'Nuwe punt';
$string['newteam'] = 'Nuwe span';
$string['nmaxanswers'] = 'Maksimum aantal korrekte antwoorde';
$string['nmaxanswers_help'] = '<P>Hierdie parameter stel die maksimum aantal korrekte antwoorde wat in \'n uitdaging toegelaat sal word voordat dit sluit.</P>
<P>Sodra hierdie getal bereik word, sal die uitdaging sluit en geen verdere antwoorde sal aanvaar word nie, ongeag die huidige punt van die uitdaging en of die <a href="help.php?component=quest&identifier=dateend"">Sluitingsdatum</a></P> bereik is, of nie.';
$string['noanswers'] = 'Geen antwoorde';
$string['noassessments'] = 'Geen Assesserings';
$string['noassessmentsdone'] = 'Geen assesserings';
$string['noattachments'] = 'Geen Aanhegsels';
$string['nocapabilityaddchallenge'] = 'Jy beskik nie oor genoeg toestemming om \'n uitdaging by te voeg nie';
$string['nograde'] = 'Geen Punt';
$string['nopermissionassessment'] = 'Jy beskik nie oor toestemming om hierdie assessering te besigtig nie. Jy moet \'n onderwyser of die outeur van die uitdaging wees.';
$string['notavailable'] = 'nie beskikbaar';
$string['noteonassessmentelements'] = 'Let daarop dat gradering verdeel word in \'n aantal \'Assesseringelemente\'.<br />
    Dit vergemaklik die gradering en maak dit meer konsekwent. As evalueerder moet jy hierdie<br />
    Elemente byvoeg voordat jy die QUESTOURnament aan studente beskikbaar stel. Dit word gedoen deur<br />
    op die QUESTOURnament in die kursus te kliek; indien geen elemente teenwoordig is nie, sal daar van jou versoek word<br />
    om elemente by te voeg. Jy kan die aantal elemente verander deur die Wysig Outeurassesseringskerm te gebruik,<br />
    die elemente self kan gewysig word op die &quot;Wysig Outeurassessering&quot; skerm.';
$string['notgraded'] = 'Nie Gemerk nie';
$string['notpermissionsubmission'] = 'Jy beskik nie oor toestemming om hierdie uitdaging te besigtig nie.';
$string['notsubmittedyet'] = 'Niks is tot dusver ingedien nie';
$string['nsubmissions'] = 'Aantal uitdagings';
$string['nsubmissions_help'] = '<strong>Aantal Uitdagings</strong>: aantal uitdagings voorgestel deur \'n student in hierdie QUESTOURnament.';
$string['nsubmissionsassessment'] = 'Geassesseerde uitdagings';
$string['nsubmissionsassessment_help'] = '<strong>Geassesseerde Uitdagings</strong>: aantal geassesseerde uitdagings uit al dié wat deur hierdie student in die QUESTOURnament voorgestel is.';
$string['numbermaxofanswers'] = 'Maks. aantal korrekte antwoorde';
$string['numberofattachments'] = 'Aantal Aanhegsels wat op Indienings verwag word';
$string['numberofattachments_help'] = '<P align="justify">Hierdie parameter stel hoeveel teksvelde vertoon sal word om die indiening van dokumente toe te laat wanneer \'n student of onderwyser \'n indiening maak. Die waarde van hierdie parameter moet tussen 0 en 5 wees. Dit is gewoonlik 0 of 1, maar in sekere gevalle kan dit nodig wees om die indiening van meer as een aanhegsel toe te laat. As die gespesifiseerde waarde 0 is, is dit ook die verstek waarde vir hierdie parameter; dit beteken dat die stuur van enige aanhegsel saam met \'n indiening nie toegelaat sal word nie.</P>
<P align="justify">As die gespesifiseerde getal bevoorbeeld 3 is en slegs 2 dokumente by die indiening aangeheg is, word daardie indiening gemaak sonder dat enige waarskuwingsboodskap vertoon word. Dit beteken dat, wanneer \'n indiening gemaak word, dit toelaatbaar is om enige aantal dokumente tot en met die maksimum wat deur die parameter gespesifiseer is, aan te heg.</P>';
$string['of'] = 'van';
$string['oldteam'] = 'Huidige span';
$string['password'] = 'Wagwoord';
$string['password_help'] = '<P align="justify">Hierdie teksveld laat toe dat \'n toegangswagwoord vir hierdie QUESTOURnament gestel word. Die wagwoord kan \'n maksimum lengte van 10 karakters hê en kan enige tyd gedurende die lewensduur van die QUESTOURnament gewysig word. Deur die opsie &quot; <a href="help.php?component=quest&identifier=usepassword"">Gebruik wagwoord</a>&quot; te kies, word daar verseker dat studente hierdie wagwoord moet invoer om toegang tot die QUESTOURnament te verkry.</P>';
$string['passwordprotectedquest'] = 'Wagwoordbeskermde QUESTOURnament';
$string['perceivedTeacherDifficultyLevel'] = 'Geskatte moeilikheidsgraad';
$string['perceivedTeacherDifficultyLevel_help'] = 'Geskatte moeilikheidsgraad van die uitdaging. Hierdie vlak word gebruik om die uitdagings te kategoriseer. Dit word vir opvoedkundige navorsing gebruik. Dit is \'n opsionele parameter.';
$string['perceiveddifficultyLevel'] = 'Moeilikheidsgraad';
$string['perceiveddifficultyLevelQuestion'] = 'Hoe moeilik het jy hierdie uitdaging ervaar?';
$string['permitsubmit'] = 'Laat herindiening toe';
$string['permitviewautors'] = 'Vertoon outeursbesonderhede aan studente van geslote uitdagings';
$string['permitviewautors_help'] = '<P align="justify">As hierdie opsie, wat by verstek nie-geselekteer is, gekies word, sal die inligting van die outeurs van die uitdagings van die QUESTOURnament vertoon word, sodra daardie uitdagings gesluit word en dit nie verder moontlik is om enige antwoorde in te dien nie.</P>
<P align="justify">As hierdie opsie nie-geselekteer word, sal studente nooit weet wie die outeurs van die uitdagings is nie, selfs nadat die uitdagings gesluit het.</P>';
$string['phase'] = 'Fase';
$string['phase1'] = 'Onaktiewe QUESTOURnament';
$string['phase1answer'] = 'Nie geassesseer nie';
$string['phase1quest'] = 'Begin hangende';
$string['phase1short'] = 'Stel op';
$string['phase1submission'] = 'Goedkeuring hangende';
$string['phase2'] = 'Oop QUESTOURnament';
$string['phase2answer'] = 'Geassesseer deur Outeur';
$string['phase2quest'] = 'In proses';
$string['phase2short'] = 'Indienings';
$string['phase2submission'] = 'Begin hangende';
$string['phase3'] = 'Geslote QUESTOURnament';
$string['phase3answer'] = 'Geassesseer deur Onderwyser';
$string['phase3quest'] = 'QUESTOURnament beëindig';
$string['phase3short'] = 'Beide';
$string['phase3submission'] = 'Uitdaging in proses';
$string['phase4'] = 'QUESTOURnament Gesluit.<br> Punte gepubliseer';
$string['phase4answer'] = 'Deur Outeur as korrek geassesseer';
$string['phase4short'] = 'Assesserings';
$string['phase4submission'] = 'Uitdaging gesluit';
$string['phase5'] = 'Finale puntberekening.';
$string['phase5answer'] = 'Deur Onderwyser as korrek geassesseer';
$string['phase5short'] = 'Bereken';
$string['phase5submission'] = 'Geassesseer. Goedkeuring hangende';
$string['phase6'] = 'Vertoon finale punt';
$string['phase6short'] = 'Vertoon finale punte';
$string['phase6submission'] = 'Geassesseer. Uitdaging in proses';
$string['phase7submission'] = 'Geassesseer. Uitdaging gesluit';
$string['phase8submission'] = 'Geassesseer. Begin hangende';
$string['picture'] = 'Prent';
$string['picture_help'] = '';
$string['pictureof'] = 'Prent van';
$string['pluginadministration'] = 'QUESTOURnament administrasie';
$string['pluginname'] = 'QUESTOURnament';
$string['points'] = 'Punt';
$string['points_help'] = '<strong>Punt</strong>: Dit is die totale individuele punt van die student (of span), met sy uitdagings en antwoordpunte ingesluit, asook \'n persentasie van sy spanpunt indien nodig.';
$string['pointsanswers'] = 'Antwoordpunt';
$string['pointsanswers_help'] = '<strong>Antwoordpunt</strong>: totale punt wat deur die student verkry is, wat ooreenstem met die assessering van die antwoorde wat deur hom ingedien is.';
$string['pointsmax'] = 'Maks. Punt';
$string['pointsmax_help'] = '<P align="justify">Hierdie parameter stel die maksimum punt wat hierdie uitdaging sal kan bereik.<P align="justify">Hierdie waarde kan vir elke uitdaging verskil, maar kan nie hoër wees as die maksimum punt wat vir die QUESTOURnament waaraan dit behoort, gestel is nie.</P>';
$string['pointsmaxsubmission'] = 'Maksimum punt bereik.';
$string['pointsmin'] = 'Min. Punt';
$string['pointsmin_help'] = '<P align="justify">Hierdie parameter stel die mimimum punt wat hierdie uitdaging sal kan bereik.<P align="justify">Hierdie waarde kan vir elke uitdaging verskil, maar kan nie laer wees as die minimum punt wat vir die QUESTOURnament waaraan dit behoort, gestel is nie.</P>';
$string['pointssubmission'] = 'Uitdagingpunt';
$string['pointssubmission_help'] = '<strong>Uitdagingpunt</strong>: totale punt wat deur die student verkry is, wat ooreenkom met die assessering wat deur die onderwysers van die uitdagings wat deur hom voorgestel is, gemaak is.';
$string['pointsteam'] = 'Spanpunt';
$string['pointsteam_help'] = '<strong>Spanpunt</strong>: hierdie parameter word slegs vertoon wanneer die opsie <a href="help.php?component=quest&identifier=allowteams"">Laat Spanne Toe</a> in die QUESTOURnament gekies is. Dit is die persentasie, gestel deur die opsie Persentasie Spanpunte, van die totale punt wat verkry is deur die span waaraan die student behoort, wat by sy individuele punt getel sal word.';
$string['poor'] = 'Swak';
$string['porcent'] = 'Persentasie';
$string['predictedDurationQuestion'] = 'Beraming van die tyd om hierdie vraag te beantwoord';
$string['predictedDurationQuestion_help'] = 'Beraming van die tyd om hierdie vraag te beantwoord. Hierdie vlak word gebruik om die uitdagings te kategoriseer. Dit word vir opvoedkundige navorsing gebruik. Dit is \'n opsionele parameter.';
$string['present'] = 'Teenwoordig';
$string['preview'] = 'Voorskou';
$string['processingquest'] = 'Verwerk {$a}';
$string['quest:addchallenge'] = 'Voeg \'n nuwe uitdaging by die toernooi';
$string['quest:addinstance'] = 'Voeg \'n nuwe instansie van \'n toernooi by (Verouderd)';
$string['quest:approvechallenge'] = 'Keur \'n voorgestelde uitdaging goed.';
$string['quest:approvegrade'] = 'Keur \'n hangende punt toe';
$string['quest:attempt'] = 'Stuur \'n antwoord vir \'n uitdaging';
$string['quest:deleteattempts'] = 'Wis eie en ander se antwoorde uit';
$string['quest:deletechallengeall'] = 'Wis eie en ander se uitdagings uit';
$string['quest:deletechallengemine'] = 'Wis eie uitdagings uit';
$string['quest:downloadlogs'] = 'Laai huidige QUESTOURnament se onverwerkte verslae af';
$string['quest:editattempt'] = 'Wysig enigiemand se ingediende antwoord';
$string['quest:editattemptmine'] = 'Wysig eie ingediende antwoord';
$string['quest:editchallengeall'] = 'Wysig enigiemand se ingediende uitdaging';
$string['quest:editchallengemine'] = 'Wysig eie ingediende uitdaging.';
$string['quest:emailconfirmchallenge'] = 'Ontvang e-posbevestiging van eie QUESTOURnament-uitdaging';
$string['quest:emailnotifychallenge'] = 'Ontvang e-poskennisgewing van ander mense se QUESTOURnament-uitdagings.';
$string['quest:generateActivityReport'] = 'Aktiwiteit';
$string['quest:generateCSVlogs'] = 'Genereer CSV-verslag vir:';
$string['quest:generateIPAccessesReport'] = 'Toegang tot IP-adresse';
$string['quest:generateLogsReport'] = 'Logs';
$string['quest:grade'] = 'Merk per hand en lewer kommentaar op studentpogings tot \'n vraag, en hermerk QUESTOURnaments';
$string['quest:gradeownchallenge'] = 'Merk eie uitdaging';
$string['quest:ignoretimelimits'] = 'Ignoreer tydsbeperkings';
$string['quest:manage'] = 'Wysig die QUESTOURnament-verstellings, voeg uitdagings by en verwyder uitdagings.';
$string['quest:manageownchallenge'] = 'Bestuur eie uitdaging';
$string['quest:notifyemptylogs'] = 'Laaste navraag met geen resultate. Kontroleer of argaïese log in hierdie bediener ontsper is.<br/>';
$string['quest:notifylocale'] = '<P>Vir jou area "<b>{$a->localelang}</b>" is die desimaalskeier "
<b>{$a->localeconfigdecimal}</b>".
Kontroleer dat jou Spreitabel hierdie karakter korrek interpreteer.</P>';
$string['quest:preview'] = 'Besigtig uitgebreide inligting en skakels van die verskillende dele van die QUESTOURnament.';
$string['quest:view'] = 'besigtig \'n toernooi';
$string['quest:viewotherattemptsowners'] = 'Besigtig eienaars van ander pogings';
$string['quest:viewreports'] = 'Besigtig die QUESTOURnament-verslae';
$string['questapprovesubmission'] = 'Uitdagings wat in QUESTOURnament goedgekeur is';
$string['questassessments'] = 'Assesserings in QUESTOURnament';
$string['questcomments'] = 'Kommentaar in QUESTOURnament';
$string['questgraphYlegend'] = 'Punt';
$string['questgraphtitle'] = 'Potensiële punte';
$string['quests'] = 'QUESTs';
$string['questsubmitanswer'] = 'Antwoorde aan QUESTOURnament ingedien';
$string['questsubmitsubmission'] = 'Uitdagings aan QUESTOURnament ingedien';
$string['recalificationall'] = 'Herassesseer alle antwoorde';
$string['reevaluate'] = 'Herassesseer';
$string['removeelement'] = 'Verwyder element';
$string['reply'] = 'Antwoord';
$string['resetchanges'] = 'Herstel veranderinge';
$string['resetquestallanswers'] = 'Wis alle antwoorde en punte uit.';
$string['responsetochallenge'] = 'Beantwoord die uitdaging';
$string['resume24hours'] = 'Opsomming van gebeure vir uitdagings wat in die QUESTOURnament {$a->name} gedurende die voorafgaande 24 uur bygevoeg of gewysig is';
$string['resumeindividual'] = 'Besigtig Individuele Opsomming';
$string['resumequest'] = 'Moodle. Aktiwiteitopsomming. QUESTOURnament {$a->name}';
$string['resumeteams'] = 'Besigtig Opsomming deur Spanne';
$string['returnto'] = 'Keer terug na';
$string['rubric'] = 'Rubriek';
$string['save'] = 'Berg';
$string['savedok'] = 'OK geberg';
$string['savemyassessment'] = 'Berg my Assessering';
$string['savemycomment'] = 'Berg my Kommentaar';
$string['savemygrading'] = 'Berg my Gradering';
$string['savemysubmission'] = 'Berg my Uitdaging';
$string['scale10'] = 'Punt uit 10';
$string['scale100'] = 'Punt uit 100';
$string['scale20'] = 'Punt uit 20';
$string['scalecorrect'] = '2-punt Korrek/Verkeerd-skaal';
$string['scaleexcellent4'] = '4-punt Uitstekend/Uiters Swak-skaal';
$string['scaleexcellent5'] = '5-punt Uitstekend/Uiters Swak-skaal';
$string['scaleexcellent7'] = '7-punt Uitstekend/Uiters Swak-skaal';
$string['scalegood3'] = '3-punt Goed/Swak-skaal';
$string['scalepresent'] = '2-punt Teenwoordig/Afwesig-skaal';
$string['scaleyes'] = '2-punt Ja/Nee-skaal';
$string['see'] = 'Besigtig';
$string['seeassessment'] = 'Besigtig Assessering';
$string['seeassessment_help'] = '<P align="justify">Hierdie bladsy vertoon die assessering van \'n ingediende antwoord, dus, as die student nie met die assessering saamstem nie, kan hy hersiening van die onderwyser of outeur van die uitdaging eis, indien dit moontlik is om die rede vir sy meningsverskil van die assessering te verduidelik.
<P align="justify">Behalwe die punt wat deur die outeur van die antwoord verkry is, word die maksimum moontlike punt vir daardie antwoord vertoon, d.w.s. die punt van die uitdaging wanneer die antwoord waarvoor \'n klagte gelê is, ingedien is.</P>
<P align="justify">Die onderwysers en outeurs van die uitdagings sal die gegewe punt per hand kan wysig om sodoende aspekte te oorweeg wat moontlik nie in die assesseringsvorm wat vir outomatiese assessering gebruik word, in berekening gebring is nie.</P>';
$string['seeassessmentautor'] = 'Besigtig assessering van uitdaging';
$string['seeassessmentautor_help'] = '<P align="justify">Hierdie bladsy vertoon die assessering van \'n bygevoegde uitdaging, dus, as die student nie met die assessering saamstem nie, kan hy hersiening van die onderwyser eis, indien dit moontlik is om die rede vir sy meningsverskil van die assessering te verduidelik. Behalwe die punt wat aan die outeur van die uitdaging gegee word, word die maksimum moontlike punt ook vertoon, d.w.s. die punt wat deur die uitdaging bereik is toe die eerste korrekte antwoord ingedien is, of indien die antwoord nog nie korrek beantwoord is nie, die aanvanklike punt.</P>
<P align="justify">Die onderwysers sal die gegewe punt per hand kan wysig om sodoende aspekte te oorweeg wat moontlik nie in die assesseringsvorm wat vir outomatiese assessering gebruik word, in berekening gebring is nie.</P>';
$string['seevaluate'] = 'Besigtig assessering';
$string['select'] = 'Kies';
$string['selfassessment'] = 'Selfassessering';
$string['shouldSelectDifficultyLevel'] = 'Kies asseblief \'n moeilikheidsgraad';
$string['showanswer'] = 'Vertoon antwoord';
$string['showanswers'] = 'Vertoon antwoorde';
$string['showanswersteam'] = 'Vertoon span se antwoorde';
$string['showanswersuser'] = 'Vertoon individuele antwoorde';
$string['showauthoringdetails'] = 'Vertoon outeursbesonderhede aan die studente in klassifikasies.';
$string['showauthoringdetails_help'] = '<P align="justify">As hierdie opsie gekies is, sal die ranglys die gedeeltelike data wat verband hou met die uitdagings wat deur elke student en span bygevoeg en geassesseer is, benewens die punt wat verkry is met die antwoorde wat aan die verskillende voorgestelde uitdagings ingedien is. Dit moet ook in gedagte gehou word dat dit kan beteken dat die anonimiteit van outeurs van die uitdagings nie gehou word nie, veral in klein groepies met \'n lae vlak van deelname.</P>';
$string['showcalification'] = 'Vertoon punte';
$string['showclasifindividual'] = 'Vertoon Individuele Klassifikasie';
$string['showclasifindividual_help'] = '<P align="justify">Hierdie opsie word by verstek gekies en laat toe dat beide die individuele rangposisie en span se rangposisie vertoon word, met laasgenoemde slegs in geval die opsie <a href="help.php?component=quest&identifier=allowteams"">Laat Spanne toe</a> gekies is.</P>
<P align="justify">As die opsie Laat Spanne toe nie gekies is nie, sal dit net sin maak om die verstek waarde van hierdie opsie te kies, wat die individuele rangposisie vertoon.</P>';
$string['showdescription'] = 'Vertoon QUESTOURnament-beskrywing';
$string['showgrades'] = 'Vertoon Punte';
$string['showresultssection'] = 'Inligting om aan studente te vertoon';
$string['showsubmission'] = 'Vertoon Indiening';
$string['showsubmissions'] = 'Vertoon Indienings';
$string['showsubmissionsteam'] = 'Vertoon Spanindienings';
$string['showsubmissionsuser'] = 'Vertoon Individuele Indienings';
$string['specimenanswer'] = 'Assesseringsvorm vir Antwoorde';
$string['specimenanswer_help'] = '<P align="justify">Hierdie bladsy vertoon die assesseringsvorm wat gebruik word om elk van die antwoorde wat op \'n uitdaging van hierdie QUESTOURnament ingedien is, te assesseer.</P>';
$string['specimenassessmentform'] = 'Voorbeeld van Assesseringsvorm';
$string['specimenassessmentformanswer'] = 'Voorbeeld van Assesseringsvorm vir antwoorde';
$string['specimenassessmentformsubmission'] = 'Voorbeeld van Assesseringsvorm vir uitdagings';
$string['specimensubmission'] = 'Assesseringsvorm vir Uitdagings';
$string['specimensubmission_help'] = '<P align="justify">Hierdie bladsy vertoon die assesseringsvorm wat gebruik word om die uitdagings wat deur studente in hierdie QUESTOURnament voorgestel is, te assesseer.</P>';
$string['studentassessments'] = '{$a} Assesserings';
$string['studentgrades'] = '{$a} Punte';
$string['studentsubmissions'] = '{$a} Indienings';
$string['studentsubmissionsforassessment'] = '{$a} Studentindienings vir Assessering';
$string['subject'] = 'Onderwerp:';
$string['submission'] = 'Uitdaging';
$string['submissionend'] = 'Sluitingsdatum van die Uitdaging';
$string['submissionend_help'] = '<P align="justify">Dit laat toe dat die datum waarop \'n uitdaging gesluit sal word, gestel word. Ná hierdie datum sal daar geen verdere antwoorde op die uitdaging ingedien kan word nie. Die onderwysers sal egter steeds die outeur van die uitdaging kan assesseer, met aandag geskenk aan beide die voorgestelde uitdaging en die assesserings wat gedoen is. Verder sal die outeurs van die uitdagings steeds die antwoorde wat aan hulle ingedien is, kan assesseer.</P>
<P align="justify">Wanneer \'n uitdaging gesluit is, sal al die deelnemers al die ingediende antwoorde kan sien, asook die assesserings wat gedoen is en die punte wat verkry is.</P>
<P align="justify">Hierdie datum mag nie ná die <a href="help.php?component=quest&identifier=dateend"">Sluitingsdatum</a> van die QUESTOURnament wees, of voor die <a href="help.php?component=quest&identifier=submissionstart"">Aanvangsdatum van die Uitdaging</a> wees nie.</P>';
$string['submissions'] = 'Uitdagings';
$string['submissionstart'] = 'Aanvangsdatum van die Uitdaging';
$string['submissionstart_help'] = '<P align="justify">Dit laat toe dat die datum waarop \'n uitdaging sal oopmaak, gestel word. Hierdie parameter kan slegs deur \'n onderwyser gestel word.</P>
<P align="justify">As \'n uitdaging deur \'n student bygevoeg word, sal die begindatum daarvan die tyd wees wat dit bygevoeg is, met die onderwysers wat hierdie waarde kan wysig wanneer die uitdaging goedgekeur of gewysig word.</P>
<P align="justify">Ná hierdie datum sal studente toegang tot die uitdaging kan verkry en hul antwoorde kan indien.</P>
<P align="justify">Hierdie datum moet voor die <a href="help.php?component=quest&identifier=submissionend"">Sluitingsdatum van die Uitdaging</a> wees.</P>';
$string['submitchallenge'] = 'Dien nuwe uitdaging in';
$string['submitchallengeassignment'] = 'Voeg uitdaging by';
$string['submitchallengeassignment_help'] = '<P>Om studente toe te laat om nuwe uitdagings in te dien, moet toestemming "mod/quest:addchallenge" verleen word.
	Jou platform beskik waarskynlik oor \'n rol met hierdie toestemming. Gebruik kieslysopsie "Plaaslik toegekende rolle" of "Toestemming" om die studente by te voeg wat outeure van uitdagings in hierdie QUESTOURnament mag wees.</P>';
$string['submitted'] = 'Uitdaging Ingedien';
$string['submittedanswer'] = 'Antwoord ingedien';
$string['submittedby'] = 'Ingedien deur';
$string['suggestedgrade'] = 'Aanbevole Punt';
$string['team'] = 'Span';
$string['team_help'] = '';
$string['teamcalification'] = 'Spanpunt';
$string['teamforquest'] = 'Werkspan vir QUESTOURnament {$a}';
$string['teamname'] = 'Spannaam';
$string['teamporcent'] = 'Persentasie van Spanpunte';
$string['teamporcent_help'] = '<P align="justify">Hierdie parameter stel die persentasie van die punt van \'n span, wat by die totale individuele punt van elk van sy lede gevoeg sal word, wat is wat die finale punt van \'n student in \'n QUESTOURnament bepaal.</P>
<P align="justify">Die doelwit is om spanwerk op só \'n manier te bevorder dat dit \'n impak op die finale punt en rangorde van elke student sal hê.</P>';
$string['teams'] = 'Spanklassifikasie';
$string['teams_help'] = '<P align="justify">Hierdie bladsy vertoon die punt wat deur elke span, wat aan dieselfde groep in \'n QUESTOURnament behoort, verkry is. \'n Persentasie van hierdie punt word bepaal deur die "<a href="help.php?component=quest&identifier=teamporcent"">Persentasie van Spanpunt</a>" parameter van die QUESTOURnament sal bydra tot die individuele punt van elke spanlid.</P>
  <P>By verstek word die rangorde gesorteer volgens die totale punt wat deur elke span verkry is, alhoewel hierdie volgorde gewysig kan word deur \'n ander parameter te kies en die naam daarvan te druk.</P>
  <P>Dit is ook moontlik om toegang tot die individuele rangorde te kry deur die opsie <a href="help.php?component=quest&identifier=global"">Besigtig Globale Klassifikasie</a>.</P>
</div>';
$string['thegradeis'] = 'Die punt is';
$string['timeassessment'] = 'Geassesseer op';
$string['timemaxoflife'] = 'Verstek tyd van lewensduur van nuwe uitdagings.';
$string['timemaxquestion'] = 'Maksimum Lewensduur';
$string['timemaxquestion_help'] = '<P align="justify">Hierdie parameter stel die duur (in dae) van die uitdagings wat by hierdie QUESTOURnament gevoeg is.</P>
<P align="justify">\'n Student kan nie die duur van \'n uitdaging wat hy by die QUESTOURnament voeg, wysig nie. Onderwysers kan egter die aanvang- en einddatums van elke uitdaging van die QUESTOURnament wysig, beide dié wat hulle self voorgestel het en dié wat deur die studente voorgestel is.</P>';
$string['tinitial'] = 'Aanvanklike tyd';
$string['tinitial_help'] = '<P align="justify">Hierdie parameter stel die duur van die tydperk, in dae, ná die aanvangsdatum van die uitdaging, waartydens die punt onveranderd sal bly, tensy \'n korrekte antwoord vir daardie uitdaging ingedien en geassesseer word, in welke geval die punt sal begin verminder.</P>
<P align="justify">Die oogmerk is dat die studente so gou as moontlik sal antwoord om sodoende die maksimum moontlike punt te verkry.</P>';
$string['title'] = 'Titel';
$string['today'] = 'Vandag';
$string['tothechallenge'] = 'na die uitdaging';
$string['typecalification'] = 'Soort gradering';
$string['typecalification_help'] = '<P align="justify">Hierdie parameter stel die manier waarop die punt van \'n uitdaging sal verskil. Elke voorgestelde uitdaging sal \'n aanvanklike punt hê wat deur die parameter <a href="help.php?component=quest&identifier=initialpoints"">Aanvanklike Punt</a> gestel word, \'n maksimum punt wat deur die parameter <a href="help.php?component=quest&identifier=maxcalification"">Hoogste Punt</a> gestel word en \'n <a href="help.php?component=quest&identifier=tinitial"">Aanvanklike Tyd</a> wat die tydperk, in dae, stel vanaf die datum waarop die uitdaging open, waartydens die punt van die uitdaging nie sal verander nie tensy \'n korrekte antwoord ingedien en geassesseer word nie. Wanneer die aanvanklike tyd verby is of wanneer \'n korrekte antwoord ingedien en geassesseer is, sal die punt van \'n uitdaging op twee moontlike verskillende maniere begin verander, volgens die waarde van hierdie parameter:</P>
<P align="justify">LINEÊR: die punt verander lineêr, en verhoog tot die sluitingsdatum van die uitdaging, wanneer dit op daardie tydstip die maksimum punt wat gestel is, bereik, of andersins totdat \'n korrekte antwoord ingedien en geassesseer word, waarna dit begin verminder totdat dit die nulwaarde bereik met die sluitingsdatum van die uitdaging, tensy die <a href="help.php?component=quest&identifier=nmaxanswers"">Maksimum Aantal Korrekte Antwoorde</a> wat toegelaat word, voor die sluitingsdatum ontvang en geassesseer is.</P>
<P align="justify">EKSPONENSIONEEL: die puntveranderinge volg dieselfde reëls as in die lineêre geval, maar met \'n eksponensioneel in plaas van \'n lineêre verandering, die rede waarom die mate van variasie mettertyd toeneem.</P>';
$string['typegrade'] = 'Verkry punte vanaf';
$string['typegrade_help'] = '<P align="justify">Hierdie parameter stel watter klassifikasie gebruik word om die finale punt van die studente te bereken.</P>
<P align="justify">Daar is twee moontlikhede:</P>
<div align="justify">
  <ul>
    <li><strong>Studente</strong>: die punt van elke student word uit die individuele rangorde geneem. As die opsie om in spanne te werk egter gekies is, sal die punt van die span waaraan die student behoort, bydra tot sy individuele punt.</li>
      <li><strong>Spanne</strong>: om die punte van elke student te bereken, word slegs die punte van die spanne gebruik. Op hierdie manier word die studente wat aan dieselfde span behoort, beloon met dieselfde punt. Vir hierdie moontlikheid om sin te maak, moet die opsie  <a href="help.php?component=quest&identifier=allowteams"">Laat Spanne toe</a> gekies wees.</li>
  </ul>
</div>';
$string['typeindividual'] = 'Studente';
$string['typeofscale'] = 'Tipe Skaal';
$string['typeteam'] = 'Span';
$string['unknownauthor'] = 'Onbekende outeur';
$string['unkownactionerror'] = 'Fatale fout: Onbekende aksie {$a}.';
$string['updatecomment'] = 'Kommentaar bygewerk';
$string['usepassword'] = 'Gebruik Wagwoord';
$string['usepassword_help'] = '<P align="justify">Hierdie opsie laat toe dat \'n toegangswagwoord vir hierdie QUESTOURnament gestel word. Dit kan nodig wees om \'n QUESTOURnament met \'n wagwoord te beskerm, byvoorbeeld wanneer die QUESTOURnament deur etlike groepe studente in \'n kursus gebruik word, en dit moet vir elke groep op \'n ander tydstip oopgemaak word, in welke geval die toegangswagwoord nie sal toelaat dat \'n groep studente die QUESTOURnament kan binnegaan wanneer dit vir \'n ander groep oopgemaak is, maar nog nie vir hulle nie.</P>';
$string['user'] = 'Gebruiker';
$string['validateassessment'] = 'Valideer Assesserings';
$string['validateassessment_help'] = '<P align="justify">As hierdie opsie gekies is, sal die onderwyser al die assesserings wat deur die studente, wat uitdagings voorstel, gemaak is moet assesseer om die punte wat deur hulle aan die antwoorde op daardie uitdagings van ander studente gegee is, te valideer.</P>
<P align="justify">Die punte van studente en die rangorde sal nie gewysig word totdat die onderwyser die punte wat deur die studente toegeken is, goedgekeur het nie. Die onderwyser sal daardie punte kan wysig, d.w.s. die punte wat deur die onderwysers toegeken is sal geldig wees indien dit verskil van dié wat deur die studente, wat die uitdagings voorgestel het, toegeken is.</P>
<P align="justify">As hierdie opsie nie gekies is nie, sal die onderwyser nie verplig wees om al die punte wat deur studente toegeken is, goed te keur nie, alhoewel hy dit steeds kan doen in geval hy dit nodig ag. As die onderwyser \'n punt wat deur \'n student toegeken is, wysig, sal die nuwe punt die een wees wat deel van die student se finale individuele punt is. Aan die ander kant, as die onderwyser nie die antwoord weer assesseer nie, sal die punt wat toegeken word die een wees wat deur die student, wat die uitdaging voorgestel het, gegee is.</P>';
$string['verypoor'] = 'Baie Swak';
$string['view'] = 'Besigtig';
$string['viewassessment'] = 'Besigtig Assessering';
$string['viewassessmentautor'] = 'Besigting Uitdagingassessering';
$string['viewclasification'] = 'Besigtig Rangorde';
$string['viewclasificationglobal'] = 'Besigtig Globale Klassifikasie';
$string['viewclasificationteams'] = 'Besigtig Spanklassifikasie';
$string['warningonamendingelements'] = 'WAARSKUWING: Daar is ingediende assesserings. <br />Moet NIE die aantal elemente, die skaaltipes of die elementgewigte verander nie.';
$string['weight'] = 'Gewig';
$string['weights'] = 'Gewigte';
$string['wrongpassword'] = 'Verkeerde wagwoord vir hierdie QUESTOURnament';
$string['yourfeedbackgoeshere'] = 'Jou Terugvoer hoort Hier';
