<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'auth_oauth2', language 'af', version '5.1'.
 *
 * @package     auth_oauth2
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['accountexists'] = '\'n Gebruiker met hierdie gebruikersnaam bestaan reeds op hierdie webwerf. Indien dit jou rekening is, teken in met jou gebruikersnaam en wagwoord en voeg dit as \'n geskakelde inteken by via jou voorkeur bladsy.';
$string['alreadylinked'] = 'Hierdie eksterne rekening is reeds aan \'n rekening op hierdie webwerf geskakel';
$string['auth_oauth2description'] = 'OAuth 2 standaard gebaseerde verikasie';
$string['auth_oauth2settings'] = 'OAuth 2 verifikasie instellings';
$string['confirmaccountemail'] = 'Haai {$a->fullname},

\'n Nuwe rekening is op \'{$a->sitename}\'
aangevra met gebruik van jou e-posadres.

Om jou nuwe rekening te bevestig, gaan asseblief na hierdie webadres:

{$a->link}

In die meeste e-pos-programme behoort hierdie as \'n blou skakel te vertoon
waarop jy slegs kan klik. Indien dit nie werk nie, sny en plak die adres in die adreslyn
aan die bokant van jou webblaaier venster.

Indien jy hulp benodig, kontak asseblief die webwerf administrateur,
{$a->admin}

As jy nie hierdie aangevra het nie, is dit moontlik dat iemand anders probeer om jou rekening toe te tree. Kontak asseblief dadelik die webwerf administrateur.';
$string['confirmaccountemailsubject'] = '{$a}: rekening bevestiging';
$string['confirmationinvalid'] = 'Die bevestigingskakel is of ongeldig of verval. Begin asseblief weer die inteken proses om \'n nuwe bevestigings-e-pos te ontvang.';
$string['confirmationpending'] = 'Hierdie rekening is hangend tot dit via e-pos bevestig iword.';
$string['confirmlinkedloginemail'] = 'Haai {$a->fullname},

\'n Navraag is gemaak om die {$a->issuername} inteken
{$a->linkedemail} met jou rekening by \'{$a->sitename}\' te skakel met gebruik van jou e-posadres.

Om hierdie aansoek te bevestig en hierdie intekeninge te skakel, gaan asseblief na die volgende webadres:

{$a->link}

In die meeste e-pos-programme behoort hierdie as \'n blou skakel te vertoon
waarop jy slegs kan klik. Indien dit nie werk nie, sny en plak die adres in die adreslyn
aan die bokant van jou webblaaier venster.

Indien jy hulp benodig, kontak asseblief die webwerf administrateur,
{$a->admin}

As jy nie hierdie aangevra het nie, is dit moontlik dat iemand anders probeer om jou rekening toe te tree. Kontak asseblief dadelik die webwerf administrateur.';
$string['confirmlinkedloginemailsubject'] = '{$a}: geskakelde inteken bevestiging';
$string['createaccountswarning'] = 'Hierdie verifikasie inprop laat gebruikers toe om rekeninge op jou webwerf te skep. Jy wil moontlik die instelling "authpreventaccountcreation" ontsper as jy hierdie inprop gebruik.';
$string['createnewlinkedlogin'] = 'Skakel \'n nuwe rekening ({$a})';
$string['emailconfirmlink'] = 'Skakel jou rekeninge';
$string['emailconfirmlinksent'] = '<p>\'n Bestaande rekening met hierdie e-posadres is gevind, maar dit is nog nie geskakel nie.</p>
   <p>Die rekeninge moet geskakel wees voordat jy kan inteken.</p>
   <p>Daar moes \'n e-pos na jou adres by <b>{$a}</b> gestuur geword het.</p>
   <p>Dit bevat maklike instruksies om jou rekeninge te skakel.</p>
   <p>Indien jy hulp benodig, kontak asseblief die webwerf administrateur,</p>';
$string['emailpasswordchangeinfo'] = 'Haai {$a->firstname},

Iemand (seker jy) het \'n nuwe wagwoord vir jou rekening op \'{$a->sitename}\' aangevra.

Jou wagwoord kan egter nie verander word nie, omdat jy jou rekening op \'n ander webwerf gebruik om in te teken.

Teken asseblief in soos vantevore, met gebruik van die skakel op die intekeningsbladsy.
{$a->admin}';
$string['emailpasswordchangeinfosubject'] = '{$a}: Verandering van wagwoord inligting';
$string['info'] = 'Eksterne rekening';
$string['issuer'] = 'OAuth 2 Diens';
$string['issuernologin'] = 'Hierdie uitgewer kan nie gebruik word om in te teken nie';
$string['linkedlogins'] = 'Geskakelde intekeninge';
$string['linkedloginshelp'] = 'Hulp met geskakelde intekeninge';
$string['loginerror_authenticationfailed'] = 'Die verifikasie proses het misluk.';
$string['loginerror_cannotcreateaccounts'] = '\'n Rekening met jou e-posadres kon nie gevind nie.';
$string['loginerror_invaliddomain'] = 'Die e-posadres word nie op hierdie webwerf toegelaat nie.';
$string['loginerror_nouserinfo'] = 'Geen gebruikersinligting het teruggekeer nie. Die OAuth 2 diens is moontlik nie korrek gekonfigureer nie.';
$string['loginerror_userincomplete'] = 'Die gebruikersinligting wat teruggekeer het, het nie \'n gebruikersnaam en \'n e-posadres bevat nie. Die OAuth 2 diens is moontlik nie korrek gekonfigureer nie.';
$string['noissuersavailable'] = 'Geen van die gekonfigureerde OAuth2 dienste laat jou toe om intekening rekeninge met mekaar te skakel nie';
$string['notenabled'] = 'Jammer, OAuth 2 verifikasie inprop is nie ontsper nie';
$string['notloggedindebug'] = 'Die inteken poging het misluk. Rede: {$a}';
$string['notwhileloggedinas'] = 'Geskakelde intekeninge kan nie bestuur word terwyl die gebruiker as \'n ander gebruiker ingeteken is nie.';
$string['oauth2:managelinkedlogins'] = 'Bestuur eie geskakelde intekening rekeninge';
$string['plugindescription'] = 'Hierdie verifikasie inprop vertoon \'n lys van die gekonfigureerde identiteitsverskaffers op die intekeningsbladsy. Deur \'n identiteitsverskaffer te kies kan gebruikers inteken met hul besonderhede vanaf \'n OAuth 2 verskaffer.';
$string['pluginname'] = 'OAuth 2';
$string['privacy:metadata:auth_oauth2'] = 'OAuth 2  verifikasie';
$string['privacy:metadata:auth_oauth2:authsubsystem'] = 'Hierdie inprop is aan die verifikasie substelsel gekonnekteer.';
$string['privacy:metadata:auth_oauth2:confirmtoken'] = 'Die bevestigingsteken.';
$string['privacy:metadata:auth_oauth2:confirmtokenexpires'] = 'Die tydstempel van wanneer die bevestigingsteken verval.';
$string['privacy:metadata:auth_oauth2:email'] = 'Die eksterne e-pos wat na hierdie rekening afbeeld.';
$string['privacy:metadata:auth_oauth2:issuerid'] = 'Die ID van die OAuth 2 uitgewer vir hierdie OAuth 2 intekening';
$string['privacy:metadata:auth_oauth2:tableexplanation'] = 'OAuth 2 rekeninge wat met \'n gebruiker se Moodle rekening geskakel is.';
$string['privacy:metadata:auth_oauth2:timecreated'] = 'Die tydstempel van wanneer die gebruiker se rekening met die OAuth 2 intekening geskakel is.';
$string['privacy:metadata:auth_oauth2:timemodified'] = 'Die tydstempel van wanneer hierdie rekord gewysig is.';
$string['privacy:metadata:auth_oauth2:userid'] = 'Die ID van die gebruikersrekening waarmee die OAuth 2 intekening geskakel is.';
$string['privacy:metadata:auth_oauth2:usermodified'] = 'Die ID van die gebruiker wat hierdie rekening gewysig het.';
$string['privacy:metadata:auth_oauth2:username'] = 'Die ekstene gebruikersnaam wat na hierdie rekening afbeeld.';
