<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'local_amos', language 'sv', version '5.0'.
 *
 * @package     local_amos
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['about'] = '<p>AMOS är ett centralt arkiv med Moodle-strängar och deras historik. Det spårar tillägg av engelska strängar i Moodle-koden, samlar in översättningar, hanterar vanliga översättningsuppgifter och genererar språkpaket som distribueras på Moodleservrar.</p>
<p>Se <a href="https://docs.moodle.org/dev/AMOS_manual">AMOS-dokumentationen</a> för mer information.</p>';
$string['amos'] = 'AMOS översättningsverktyg';
$string['amos:changecontriblang'] = 'Ändra språk för bidragna strängar';
$string['amos:commit'] = 'Spara de lagrade strängarna till huvudarkivet';
$string['amos:execute'] = 'Kör det angivna AMOS-skriptet';
$string['amos:importfile'] = 'Importera översättningar från uppladdade filer och mellanlagra dem';
$string['amos:importstrings'] = 'Importera strängar (inklusive de engelska) direkt till huvudarkivet';
$string['amos:manage'] = 'Hantera AMOS-portalen';
$string['amos:stage'] = 'Använda AMOS-översättningsverktyget och mellanlagra strängarna';
$string['amos:stash'] = 'Spara nuvarande mellanlager till den permanenta lagringsplatsen';
$string['amos:usegoogle'] = 'Använd översättningstjänster från Google';
$string['applangindexfile'] = 'Sökväg till Moodle-appens språkindexfil';
$string['applangindexfile_desc'] = 'Fullständig URL till vilken filen ska laddas ned. Detta görs av en cronaktivitet.';
$string['branchesall'] = 'Alla kända Moodleversioner';
$string['branchesall_desc'] = 'Kommaseparerad lista över Moodleversionskoder som stöds av AMOS. Denna används för att populera versionslistan i översättarfiltret och andra platser.';
$string['branchsupported'] = 'Äldsta Moodleversionen som stöds';
$string['branchsupported_desc'] = 'Kod för den äldsta Moodle-versionen som fortfarande ska spåras för ändringar i engelska strängar och för vilka installationsspråkpaketen fortfarande genereras. Använd <https://docs.moodle.org/dev/Releases#Version_support> för referens.';
$string['cachedef_lists'] = 'Lista över språk och komponenter som hanteras av AMOS';
$string['cachedef_stats'] = 'Statistik genereras av AMOS';
$string['commitbutton'] = 'Spara';
$string['commitkeepstaged'] = 'Behåll strängarna på mellanlagringsplatsen';
$string['commitmessage'] = 'Meddelande vid spara';
$string['commitmessageempty'] = 'Vänligen fyll i meddelandet som ska användas vid spara';
$string['commitstage'] = 'Spara mellanlagradecsträngar';
$string['commitstage_help'] = 'Lagra alla mellanlagrade översättningar permanent i AMOS-databasen. De mellanlagrade strängarna töms och flyttas automatiskt innan de görs permanenta i databasen. Endast strängar som är möjliga att lagra permanent lagras. Detta betyder att det endast är översättningar markerade med grönt som kommer att lagras. De mellanlagrade strängarna rensas efter att de gjorts permanenta i databasen.';
$string['committable'] = 'Du är behörig att spara till detta språkpaket';
$string['committableall'] = 'alla språk';
$string['committablenone'] = 'inga språk är tillåtna - kontakta AMOS-administratören';
$string['componentsall'] = 'Alla';
$string['componentsapp'] = 'Moodle-appen';
$string['componentsnone'] = 'Inga';
$string['componentsstandard'] = 'Standard';
$string['confirmaction'] = 'Detta kan inte ångras. Är du säker?';
$string['contribaccept'] = 'Acceptera';
$string['contribactions'] = 'Åtgärder för inskickade översättningar';
$string['contribactions_help'] = 'Beroende på dina rättigheter och arbetsflödet för bidrag kan några av följande åtgärder finnas tillgängliga:

* Ansök - kopiera den bidragna översättningen till din mellanlagringsyta, ändrar inte bidragsposten
* Tilldela mig - ställ in dig själv som bidragsmottagare, det vill säga den person som är ansvarig för bidragsgranskning och integration
* Ta bort tilldelning - ange "Ingen" som bidragsmottagare
* Börja granska - tilldela det nya bidraget till dig själv, ange dess status till "Granskas" och kopiera den inlämnade översättningen till din mellanlagringsyta.
* Acceptera - markera bidraget som accepterat
* Avvisa - markera bidraget som avvisat, beskriv skälen i en kommentar.

Bidragsgivaren informeras via e-post när statusen för hens bidrag ändras.';
$string['contribactions_link'] = 'AMOS#Contributing_to_a_language_pack';
$string['contribapply'] = 'Använd';
$string['contribassignee'] = 'Tilldelad';
$string['contribassigneenone'] = '-';
$string['contribassigntome'] = 'Tilldela till mig';
$string['contribauthor'] = 'Författare';
$string['contribclosedno'] = 'Dölj lösta bidrag';
$string['contribclosedyes'] = 'Visa hanterade bidrag';
$string['contribcomponents'] = 'Komponenter';
$string['contribid'] = 'ID';
$string['contribincomingnone'] = 'Inga inkommande bidrag';
$string['contribincomingsome'] = 'Inkommande bidrag ({$a})';
$string['contriblanguage'] = 'Språk';
$string['contriblanguagebutton'] = 'Konvertera';
$string['contriblanguagechange'] = 'Korrigerar felaktigt inlämningsspråk';
$string['contriblanguagechange_help'] = 'Om bidraget har skickats till fel språkpaket av misstag väljer du rätt språk i listrutan nedan och klickar sedan på knappen Konvertera.';
$string['contriblanguagereport'] = 'Rapporterar felaktigt inlämningsspråk';
$string['contriblanguagereport_help'] = 'Om detta bidrag har skickats till fel språkpaket av misstag, kopiera och klistra in bidragslänken i ett e-postmeddelande till "translation@moodle.org". Bidraget flyttas sedan till rätt språk.';
$string['contriblanguagewrong'] = 'Fel språk?';
$string['contribnotif'] = '[AMOS] Bidragsnotis (#{$a->id})';
$string['contribnotifaccepted'] = '{$a->fullname} har accepterat din översättning #{$a->id} {$a->subject}

---------------------------------------------------------------------
Länk till din inlämnade översättning: {$a->contriburl}';
$string['contribnotifcommented'] = '{$a->fullname} har kommenterat din inskickade översättning
#{$a->id} {$a->subject}
---------------------------------------------------------------------

{$a->message}

---------------------------------------------------------------------
Länk till din inlämnade översättning: {$a->contriburl}';
$string['contribnotifconverted'] = '{$a->fullname} har konverterat din bidragna översättning
#{$a->id} {$a->subject}

Tack för ditt bidrag. Det verkar dock som om det har lämnats in till fel
språkpaket av misstag. Ditt bidrag har därför avvisats från
språkpaketet och flyttats till rätt språkpaket för granskning av
språkpaketansvarig. Ingen åtgärd krävs från din sida.

I framtiden, dubbelkolla att du har valt ditt eget språk innan
du börjar översätta strängar.

---------------------------------------------------------------------
Ursprunglig bidragssida: {$a->contriborigurl}
Ny bidragssida: {$a->contribnewurl}';
$string['contribnotifpending'] = 'Det finns en väntande översättning som kräver din åtgärd
#{$a->id} {$a->subject}

Som språkpaketsansvarig ska du granska och så småningom
bekräfta alla inlämnade översättningar. När du är klar, markera dem som accepterade eller
avvisade.

Mer information finns här: {$a->docsurl}.
---------------------------------------------------------------------
Bidragssida: {$a->contriburl}';
$string['contribnotifrejected'] = '{$a->fullname} har avvisat den översättning du skickat in
#{$a->id} {$a->subject}

---------------------------------------------------------------------
Bidragssida: {$a->contriburl}';
$string['contribnotifsubmitted'] = '{$a->fullname} har skickat in en ny översättning
#{$a->id} {$a->subject}
---------------------------------------------------------------------

{$a->message}

* Språk: {$a->språk}
* Komponenter: {$a->components}
* Strängar: {$a->strängar}

---------------------------------------------------------------------
Bidragssida: {$a->contriburl}';
$string['contribreject'] = 'Neka';
$string['contribresign'] = 'Ta bort tilldelning';
$string['contribstaged'] = 'Mellanlagrat bidrag <a href="contrib.php?id={$a->id}">#{$a->id}</a> från {$a->author}';
$string['contribstagedinfo'] = 'Mellanlagrat bidrag';
$string['contribstagedinfo_help'] = 'Mellanlagret innehåller strängar som skickats in av en communitymedlem. Språkpaketsansvariga ska granska dem och sedan ange deras status till antingen Godkänd (om det har bekräftats) eller Avvisad (om de av någon anledning inte kan inkluderas i det officiella språkpaketet).';
$string['contribstagedinfo_link'] = 'AMOS#Contributing_to_a_language_pack';
$string['contribstartreview'] = 'Påbörja granskning';
$string['contribstatus'] = 'Status';
$string['contribstatus0'] = 'Ny';
$string['contribstatus10'] = 'Granskas';
$string['contribstatus20'] = 'Nekad';
$string['contribstatus30'] = 'Accepterad';
$string['contribstatus_help'] = 'Arbetsflödet för en inskickad översättning består av följande steg:

* Nytt - översättningen har lämnats in men den har inte granskats ännu
* Granskas - översättningen har tilldelats en språkpaketansvarig och har mellanlagrats för granskning
* Avvisad - språkpaketsansvarige har avvisat översättningen och förmodligen lämnat en förklaring i en kommentar
* Godkänt - översättningen har godkänts av språkpaketsansvarige';
$string['contribstatus_link'] = 'AMOS#Contributing_to_a_language_pack';
$string['contribstrings'] = 'Strängar';
$string['contribstringseq'] = '{$a->orig} nya';
$string['contribstringsnone'] = '{$a->orig} (alla av dessa är redan översatta i språkpaketet)';
$string['contribstringssome'] = '{$a->orig} (det finns redan en nyare översättning för {$a->same} av dem)';
$string['contribsubject'] = 'Ämne';
$string['contribsubmittednone'] = 'Inga inlämnade översättningar';
$string['contribsubmittedsome'] = 'Dina bidrag ({$a})';
$string['contribtimemodified'] = 'Ändrad';
$string['contribute'] = 'Bidra';
$string['contributenow'] = 'Bidra nu!';
$string['contributestats'] = 'Så här långt har totalt <strong>{$a->count}</strong> strängar översatts och skickats in till AMOS av medlemmarna.';
$string['contributethanks'] = 'Tack till {$a->listcontributors} för deras bidrag nyligen!';
$string['contributethankslist'] = '{$a->contributor1}, {$a->contributor2}, {$a->contributor3} and {$a->contributor4}';
$string['contributions'] = 'Bidrag';
$string['creditsaddcontributor'] = 'Lägg till bidragare';
$string['creditsaddmaintainer'] = 'Lägg till paketansvarig';
$string['creditscontact'] = 'Skicka meddelande';
$string['creditscontributors'] = 'Andra bidragsgivare';
$string['creditsdelcontributor'] = 'Ta bort bidragare';
$string['creditsdelmaintainer'] = 'Ta bort paketansvarig';
$string['creditsmaintainedby'] = 'Underhålls av';
$string['creditsnomaintainer'] = 'Det finns för närvarande ingen paketansvarig. <a href="{$a->url}">Vill du bli en?</a>';
$string['creditsthanks'] = 'På den här sidan vill vi tacka alla som har bidragit till Moodles översättningar. Deras arbete har gjort spridningen av Moodle över hela världen möjlig.';
$string['creditstitlelong'] = 'Språkpaketansvariga och översättare';
$string['creditstitleshort'] = 'Tack';
$string['diff'] = 'Jämför';
$string['err_exception'] = 'Fel: {$a}';
$string['err_invalidlangcode'] = 'Ogiltig språkkod';
$string['filtercmp'] = 'Komponenter';
$string['filtercmp_desc'] = 'Visa strängar för dessa komponenter';
$string['filtercmpnothingselected'] = 'Du måste välja minst en komponent';
$string['filterlng'] = 'Språk';
$string['filterlng_desc'] = 'Visa översättningar på dessa språk';
$string['filterlngnothingselected'] = 'Vänligen välj språk';
$string['filtermis'] = 'Övrigt';
$string['filtermis_desc'] = 'Ytterligare filtreringsalternativ';
$string['filtermisfapp'] = 'enbart strängar som används i Moodle-appen';
$string['filtermisfapp_help'] = 'Denna sträng används i Moodle-appen som {$a}';
$string['filtermisfhas'] = 'enbart översatta strängar';
$string['filtermisfhlp'] = 'endast hjälpsträngar';
$string['filtermisfmis'] = 'enbart saknade och föråldrade strängar';
$string['filtermisfout'] = 'enbart föråldrade strängar';
$string['filtermisfstg'] = 'endast mellanlagrade strängar';
$string['filtersid'] = 'Strängidentifierare';
$string['filtersid_desc'] = 'Nyckeln i stränguppsättningen';
$string['filtersidpartial'] = 'partiell matchning';
$string['filtertxt'] = 'Delsträng';
$string['filtertxt_desc'] = 'Strängen måste innehålla angiven text';
$string['filtertxtcasesensitive'] = 'skiftlägeskänslig';
$string['filtertxtregex'] = 'regex';
$string['filterver'] = 'Version';
$string['filterver_desc'] = 'Visa strängar för denna Moodleversion';
$string['filtervernothingselected'] = 'Vänligen välj version';
$string['foundmissing'] = '{$a} saknas';
$string['foundmissingonthispage'] = '{$a} på denna sida';
$string['foundtotal'] = '{$a} hittades';
$string['googletranslate'] = 'fråga Google';
$string['importfile'] = 'Importera översatta strängar från fil';
$string['importfile_link'] = 'local/amos/importfile';
$string['language'] = 'Språk';
$string['languages'] = 'Språk';
$string['languagesall'] = 'Slla';
$string['languagesnone'] = 'Inga';
$string['lastavailable'] = 'Senast tillgängliga version';
$string['lessfilteringoptions'] = 'Färre alternativ';
$string['log'] = 'Logg';
$string['logfilterbranch'] = 'Versioner';
$string['logfiltercommithash'] = 'git hash';
$string['logfiltercomponent'] = 'Komponenter';
$string['logfilterlang'] = 'Språk';
$string['logfiltersource'] = 'Källa';
$string['logfiltersourceamos'] = 'amos (webbaserad översättare)';
$string['logfiltersourcegit'] = 'git (git-spegling av Moodlekällkod och 1.x paket)';
$string['logfiltersourceimport'] = 'import (importerade strängar för en tilläggsmodul)';
$string['logfilterstringid'] = 'Strängidentifierare';
$string['logfilterstrings'] = 'Strängfilter';
$string['logfilterusergrp'] = 'Inskickare';
$string['logfilterusergrpor'] = 'eller';
$string['maintainers'] = 'Paketansvariga';
$string['manageamos'] = 'Hantera AMOS';
$string['markuptodate'] = 'Markerar översättningen som aktuell';
$string['markuptodatelabel'] = 'markera som aktuell';
$string['messageprovider:checker'] = 'Resultat från språkpaketkontrollant';
$string['messageprovider:contribution'] = 'Inskickade översättningar';
$string['morefilteringoptions'] = 'Fler alternativ';
$string['newlanguage'] = 'Nytt språk';
$string['nodiffs'] = 'Inga skillnader hittades';
$string['nofiletoimport'] = 'Vänligen ange en fil att importera från.';
$string['nologsfound'] = 'Hittade inga strängar. Vänligen ändra filtren';
$string['nostringsfound'] = 'Hittade inga strängar';
$string['nostringtoimport'] = 'Hittade ingen giltig sträng i filen. Säkerställ att filen är korrekt namngiven och i korrekt format.';
$string['nothingtostage'] = 'Denna operation returnerade inga filer som kunde mellanlagras.';
$string['novalidzip'] = 'Kunde inte extrahera ZIP-filen.';
$string['outdatednotcommitted'] = 'Föråldrad sträng';
$string['outdatednotcommitted_help'] = 'AMOS upptäckte att strängen kan vara föråldrad eftersom den engelska versionen ändrats efter att den översattes. Vänligen granska översättningen.';
$string['outdatednotcommittedwarning'] = 'Föråldrat';
$string['permalink'] = 'Permalänk';
$string['placeholder'] = 'Platshållare';
$string['placeholderwarning'] = 'platshållare';
$string['pluginclasscore'] = 'System';
$string['pluginclassnonstandard'] = 'Icke-standard pluginmoduler';
$string['pluginclassstandard'] = 'Standardpluginmoduler';
$string['pluginname'] = 'AMOS';
$string['plugintypelocations'] = 'Platser för plugintyper';
$string['plugintypelocations_desc'] = 'Tillåter att platser för tilläggsmoduler, så som under-pluginmodultyper tillhandahållna av standardpluginmoduler, eller äldre plugintyper.';
$string['presetcommitmessage'] = 'Översättningsbidrag #{$a->id} från {$a->author}';
$string['presetcommitmessage2'] = 'Sammanfogade saknade strängar från {$a->source} till {$a->target}-grenen';
$string['privacy:contribnumber'] = 'Bidrag {$a}';
$string['privacy:filterusage'] = 'Filteranvändning';
$string['privacy:metadata:db:amoscontributions:message'] = 'Ursprunglig beskrivning av inlämningen';
$string['privacy:metadata:db:amoscontributions:status'] = 'Arbetsflödesstatus för bidraget';
$string['privacy:metadata:db:amoscontributions:subject'] = 'Ämnet för det inskickade bidraget.';
$string['privacy:metadata:db:amoscontributions:timecreated'] = 'Tidstämpel för när bidraget skapades.';
$string['privacy:metadata:db:amoscontributions:timemodified'] = 'Tidstämpel för senaste ändring av bidraget.';
$string['privacy:metadata:db:amosfilterusage'] = 'Logg över AMOS-översättarens filteranvändning.';
$string['privacy:metadata:db:amosfilterusage:currentlang'] = 'Nuvarande sessionsspråk.';
$string['privacy:metadata:db:amosfilterusage:ismaintainer'] = 'Har användaren behörighet att skicka översatta strängar till AMOS-arkivet?';
$string['privacy:metadata:db:amosfilterusage:numofcomponents'] = 'Antal valda komponenter';
$string['privacy:metadata:db:amosfilterusage:numoflanguages'] = 'Antal valda språk';
$string['privacy:metadata:db:amosfilterusage:numofversions'] = 'Antal valda versioner';
$string['privacy:metadata:db:amosfilterusage:showexistingonly'] = 'Ska enbart befintliga översättningar visas?';
$string['privacy:metadata:db:amosfilterusage:showgreylistedonly'] = 'Ska endast grålistade strängar visas?';
$string['privacy:metadata:db:amosfilterusage:showhelpsonly'] = 'Ska endast grålistade hjälpsträngar visas?';
$string['privacy:metadata:db:amosfilterusage:showmissingonly'] = 'Ska endast föråldrade och saknade strängar visas?';
$string['privacy:metadata:db:amosfilterusage:showoutdatedonly'] = 'Ska endast föråldrade strängar visas?';
$string['privacy:metadata:db:amosfilterusage:showstagedonly'] = 'Ska endast undansparade strängar visas?';
$string['privacy:metadata:db:amosfilterusage:showwithoutgreylisted'] = 'Ska grålistade strängar undantas från resultaten?';
$string['privacy:metadata:db:amosfilterusage:stringidpartial'] = 'Är delvis matchning av sträng-id begärd?';
$string['privacy:metadata:db:amosfilterusage:substringcasesensitive'] = 'Ska delsträngen anses vara skiftlägeskänslig?';
$string['privacy:metadata:db:amosfilterusage:substringregex'] = 'Ska delsträngen anses vara ett reguljärt uttryck?';
$string['privacy:metadata:db:amosfilterusage:timesubmitted'] = 'Tidstämpel för när filterformuläret lämnades in';
$string['privacy:metadata:db:amosfilterusage:usercountry'] = 'Användarens språkkod så som valts i användarprofilen';
$string['privacy:metadata:db:amosfilterusage:userlang'] = 'Användarens föredragna språk i användarprofilen';
$string['privacy:metadata:db:amosfilterusage:usesdefaultlang'] = 'Valde användaren det förvalda språket?';
$string['privacy:metadata:db:amosfilterusage:usesdefaultversion'] = 'Valde användaren den förvalda versionen av formuläret?';
$string['privacy:metadata:db:amosfilterusage:withstringid'] = 'Angavs sträng-ID:t?';
$string['privacy:metadata:db:amosfilterusage:withsubstring'] = 'Angavs en delsträng att söka efter?';
$string['privacy:metadata:db:amosstashes:timemodified'] = 'Tidstämpel för då posten senast ändrades';
$string['privacy:metadata:db:amostranslators:lang'] = 'Språkkod som översättaren är behörig att översätta, eller asterisk för alla språk.';
$string['privileges'] = 'Dina rättigheter';
$string['processing'] = 'Bearbetar…';
$string['quicklinks'] = 'Snabblänkar';
$string['quicklinks_amos'] = 'AMOS översättare';
$string['quicklinks_forum'] = 'Översättarforum';
$string['quicklinks_manual'] = 'Användarmanual';
$string['quicklinks_newcomers'] = 'Hjälp för nya användare';
$string['requestactions'] = 'Åtgärd';
$string['savefilter'] = 'Visa strängar';
$string['script'] = 'AMOSkript';
$string['sourceversion'] = 'Källversion';
$string['stagedownload'] = 'Ladda ned';
$string['stageedit'] = 'Redigera mellanlagrade strängar';
$string['stageprune'] = 'Ta bort strängar som inte kan göras permanenta';
$string['stagerebase'] = 'Flytta';
$string['stagestringsnocommit'] = 'Det finns {$a->staged} väntande strängar';
$string['stagestringsnone'] = 'Det finns inga väntande strängar';
$string['stagestringssome'] = 'Det finns {$a->staged} väntande strängar, {$a->committable} av dem kan göras sparas';
$string['stagesubmit'] = 'Skicka till paketadministratören';
$string['stagetoolopen'] = 'Gå till sparade strängar';
$string['stagetranslation'] = 'Översättning';
$string['standardcomponents'] = 'Lista över standardkomponenter';
$string['stashactions'] = 'Spara pågående arbete';
$string['stashapply'] = 'Använd';
$string['stashcomponents'] = '<span>Komponenter:</span> {$a}';
$string['stashdownload'] = 'Ladda ned';
$string['stashdrop'] = 'Släng';
$string['stashlanguages'] = '<span>Språk:</span> {$a}';
$string['stashstrings'] = '<span>Antal strängar:</span> {$a}';
$string['stashsubmit'] = 'Skicka till paketansvariga';
$string['stashsubmitmessage'] = 'Meddelande';
$string['stashsubmitsubject'] = 'Ämne';
$string['stashtitledefault'] = 'Pågående arbete - {$a->time}';
$string['stdvernotebetween'] = 'Standard från {$a->from} till {$a->to}';
$string['stdvernotefrom'] = 'Standard från {$a->from}';
$string['stringhistory'] = 'historik';
$string['strings'] = 'Strängar';
$string['stringversionnotlatest'] = 'en nyare version finns';
$string['submitting'] = 'Skickar in ett bidrag';
$string['submitting_help'] = 'Detta skickar översatta strängar till de paketansvariga. De kommer att kunna överföra ditt arbete till sin arbetsyta, granska det och så småningom inkludera det i språkpaketet. Vänligen bifoga ett meddelande till dem som beskriver ditt arbete och varför du vill att ditt bidrag ska inkluderas.';
$string['targetversion'] = 'Målversion';
$string['timeline'] = 'Tidslinje';
$string['timelineheading'] = 'Tidslinje för: {$a->component} | {$a->strname}';
$string['translatortool'] = 'Översättare';
$string['translatortoolopen'] = 'Öppna AMOS översättare';
$string['translatortranslation'] = 'Översättning';
$string['translatortranslation_help'] = 'Klicka på cellen för att göra den redigerbar. Infoga översättningen och klicka utanför cellen för att applicera översättningen. Cellens bakgrundsfärg betyder:

* Grön - strängen är redan översatt, du kan ändra översättningen om du vill.
* Gul - strängen kan vara föråldrad. Det engelska originalet ändrades troligen efter att strängen hade översatts.
* Röd - strängen är ännu inte översatt.
* Blå - du har ändrat översättningen och den är nu undansparad.
* Grå - AMOS kan inte användas för att översätta den här strängen. Strängar för Moodle 1.9 får till exempel endast redigeras via den äldre CVS-åtkomsten.

Paketansvariga kan se en liten röd symbol i hörnet av de celler som de kan lägga till i språkpaketet.';
$string['typecontrib'] = 'Tilläggsmoduler';
$string['typecontribbadge'] = 'Tillägg';
$string['typecore'] = 'System';
$string['typecorebadge'] = 'System';
$string['typestandard'] = 'Standardmoduler';
$string['typestandardbadge'] = 'Standard';
$string['unableenfixaddon'] = 'Engelska korrigeringar tillåts endast för standardpluginmoduler';
$string['unableenfixcountries'] = 'Namn på länder kopieras från ISO 3166-1';
$string['unstageconfirmlong'] = '<p>Du är på väg att ta bort den mellanlagrade översättningen av strängen <code>{$a->stringid}</code>, komponent <code>{$a->component}</code>, språkpaket <code>{$a->language}</code>.</p><p>Är du säker?</p>';
$string['untranslate'] = 'ta bort översättning';
$string['untranslating'] = 'Tar bort översättning';
$string['userdefaultreset'] = 'Återställ till mina standardinställningar';
$string['userdefaultsave'] = 'Spara som mina standardinställningar';
$string['version'] = 'Version';
