<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'question', language 'sr_lt', version '5.0'.
 *
 * @package     question
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['action'] = 'Akcija';
$string['addanotherhint'] = 'Dodaj još jedan savet';
$string['addcategory'] = 'Dodaj kategoriju';
$string['addmorechoiceblanks'] = 'Dodaj prazna polja za još {no} odgovora';
$string['adminreport'] = 'Izveštaj o mogućim problemima u vašoj bazi podataka sa pitanjima';
$string['advancedsearchoptions'] = 'Opcije za pretragu';
$string['alltries'] = 'Svi pokušaji';
$string['alwayslatest'] = 'Uvek najnovija verzija';
$string['answer'] = 'Odgovor';
$string['answers'] = 'Odgovori';
$string['answersaved'] = 'Odgovor je sačuvan';
$string['answerx'] = 'Odgovor {$a}';
$string['attemptfinished'] = 'Pokušaj je završen';
$string['attemptfinishedsubmitting'] = 'Predaja završenih pokušaja: {$a}';
$string['attemptoptions'] = 'Opcije pokušaja';
$string['availableq'] = 'Dostupno?';
$string['badbase'] = 'Loša baza pre **: {$} **';
$string['banksincourse'] = 'Banke pitanja na ovom kursu';
$string['behaviour'] = 'Ponašanje';
$string['behaviourbeingused'] = 'ponašanje koje se koristi: {$a}';
$string['broken'] = 'Ovo je "prekinut link", pokazuje na nepostojeći fajl.';
$string['byandon'] = 'uredio/la <em>{$a->user}</em> (<em>{$a->time}</em>)';
$string['cannotcopybackup'] = 'Nije moguće kopirati datoteku rezervne kopije';
$string['cannotcreate'] = 'Nije moguće kreirati novi unos u tabeli  question_attempts';
$string['cannotcreatepath'] = 'Nije moguće kreirati putanju: {$a}';
$string['cannotdeletebehaviourinuse'] = 'Ne možete da obrišete ponašanje \'{$a}\'. Već postoje pokušaji rešavanja pitanja koje koristi ovo ponašanje.';
$string['cannotdeletecate'] = 'Ne možete da obrišete ovu kategoriju, pošto je u ovom kontekstu to podrazumevana kategorija.';
$string['cannotdeleteneededbehaviour'] = 'Nije moguće obrisati ponašanje pitanje \'{$a}\'. Postoje i druga instalirana ponašanja koja se oslanjaju na njega.';
$string['cannotdeleteqtypeinuse'] = 'Ne možete da obrišete tip pitanja \'{$a}\'. u banci pitanja postoje pitanja ovog tipa.';
$string['cannotdeleteqtypeneeded'] = 'Ne možete da obrišete tip pitanja \'{$a}\'. Postoje drugi tipovi pitanja koji su povezani sa ovim tipom.';
$string['cannotdeletetopcat'] = 'Vrhovne kategorije ne mogu da se brišu.';
$string['cannotedittopcat'] = 'Vrhovne kategorije ne mogu da se uređuju.';
$string['cannotenable'] = 'Tip pitanja {$a} ne može biti kreiran direktno.';
$string['cannotenablebehaviour'] = 'Ponašanje pitanja {$a} ne može da se koristi direktno. Ono služi samo za internu upotrebu.';
$string['cannotfindcate'] = 'Nije moguće pronaći zapis kategorije';
$string['cannotfindquestionfile'] = 'Nije moguće pronaći datoteku sa pitanjima u zip arhivi';
$string['cannotgetdsfordependent'] = 'Nije moguće preuzeti navedeni skup podataka za pitanje zavisno od skupa podataka! (pitanje: {$a->id}, stavka skupa podataka: {$a->item})';
$string['cannotgetdsforquestion'] = 'Nije moguće preuzeti navedeni skup podataka za računsko pitanje! (pitanje: {$a})';
$string['cannothidequestion'] = 'Nije bilo moguće sakriti pitanje';
$string['cannotimportformat'] = 'Nažalost, uvoz ovog formata još nije implementiran!';
$string['cannotinsertquestion'] = 'Nije moguće ubaciti novo pitanje!';
$string['cannotinsertquestioncatecontext'] = 'Nije moguće umetnuti novu kategoriju pitanja {$a->cat} ilegalni contextid {$a->ctx}';
$string['cannotloadquestion'] = 'Nije moguće učitati pitanje';
$string['cannotmovequestion'] = 'Ne možete da koristite ovaj skript za prebacivanje pitanja koja imaju pridružene datoteke iz različitih područja.';
$string['cannotopenforwriting'] = 'Nije moguće otvoriti za upisivanje: {$a}';
$string['cannotpreview'] = 'Ne možete da pregledate ova pitanja!';
$string['cannotread'] = 'Ne može se čitati uvozna datoteka (ili je prazna)';
$string['cannotregradedifferentqtype'] = 'Ne može se ponovo oceniti sa pitanjem drugog tipa.';
$string['cannotretrieveqcat'] = 'Nije moguće povratiti ovu kategoriju pitanja';
$string['cannotunhidequestion'] = 'Nije moguće povratiti kategoriju pitanja.';
$string['cannotunzip'] = 'Nije moguće raspakovati arhiviranu zip datoteku';
$string['cannotwriteto'] = 'Nije moguće upisati izvezena pitanja u {$a}';
$string['categories'] = 'Kategorije';
$string['category'] = 'Kategorija';
$string['categorycurrent'] = 'Trenutna kategorija';
$string['categorycurrentuse'] = 'Koristi ovu kategoriju';
$string['categorydoesnotexist'] = 'Ova kategorija ne postoji';
$string['categoryinfo'] = 'Informacije o kategoriji';
$string['categorymove'] = 'Kategorija \'{$a->name}\' sadrži {$a->count} pitanja (neka od njih mogu biti skrivena ili nasumično izabrana pitanja koja se i dalje koriste u testu). Molimo izaberite drugu kategoriju u koju ćete ih premestiti.';
$string['categorymoveto'] = 'Snimi u kategoriju';
$string['categorynamecantbeblank'] = 'Morate da upišete naziv kategorije';
$string['categorynamewithcount'] = '{$a->name} ({$a->questioncount})';
$string['categorynamewithidnumber'] = '{$a->name} [{$a->idnumber}]';
$string['categorynamewithidnumberandcount'] = '{$a->name} [{$a->idnumber}] ({$a->questioncount})';
$string['changeoptions'] = 'Promeni opcije';
$string['changepublishstatuscat'] = '<a href="{$a->caturl}">Kategoriji "{$a->name}"</a> će u okviru kursa "{$a->coursename}" biti promenjen status deljenja iz {$a->changefrom} u {$a->changeto}.';
$string['check'] = 'Proveri';
$string['chooseqtypetoadd'] = 'Izaberi tip pitanja za dodavanje';
$string['clearwrongparts'] = 'Obriši netačne odgovore';
$string['clickflag'] = 'Obeleži pitanje indikatorom (zastavicom)';
$string['clicktoflag'] = 'Obeleži ovo pitanje indikatorom (zastavicom)';
$string['clicktounflag'] = 'Ukloni indikator (zastavicu)';
$string['clickunflag'] = 'Ukloni indikator(zastavicu)';
$string['closepreview'] = 'Zatvori pregled';
$string['combinedfeedback'] = 'Kombinovane povratne informacije';
$string['comment'] = 'Komentar';
$string['commented'] = 'Komentarisao: {$}';
$string['commentormark'] = 'Komentarišite ili izmenite ocenu';
$string['comments'] = 'Komentari';
$string['commentx'] = 'Komentar: {$a}';
$string['complete'] = 'Završeno';
$string['contexterror'] = 'Ne biste smeli da budete ovde ukoliko niste premsetili kategoriju u drugi kontekst';
$string['copy'] = 'Kopiraj iz {$a} i promeni linkove.';
$string['correct'] = 'Tačno';
$string['correctfeedback'] = 'Za svaki tačan odgovor';
$string['correctfeedbackdefault'] = 'Vaš odgovor je tačan.';
$string['courserestore'] = 'Restauriranje kursa';
$string['created'] = 'Kreirano';
$string['createdby'] = 'Kreirao/la';
$string['createdefault'] = 'Kreirajte podrazumevanu banku pitanja';
$string['createdmodifiedheader'] = 'Kreirano / poslednje sačuvano';
$string['createnewquestion'] = 'Kreiraj novo pitanje';
$string['cwrqpfs'] = 'Nasumična pitanja se biraju iz potkategorija.';
$string['cwrqpfsinfo'] = '<p>Tokom nadogradnje na Moodle 1.9 verziju kategorije pitanja će biti podeljene u različite kontekste. Nekim pitanjima i kategorijama pitanja na vašem sajtu će morati da bude promenjen status deljenja. Ovo je neophodno u retkim slučajevima kada je jedno ili više ‘nasumičnih’ pitanja u nekom testu podešeno tako da se biraju iz mešavine deljenih i nedeljenih kategorija (kao što je to slučaj na ovom sajtu). Ovo se događa kada je podešeno da se ‘nasumično’ pitanje bira iz potkategorija, a pri tome jedna ili više potkategorija imaju različit status deljenja u odnosu na nadređenu kategoriju, u kojoj je ‘nasumično’ pitanje kreirano.</p>
<p>Sledećim kategorijama pitanja, iz kojih nadređene kategorije biraju ‘nasumična’ pitanja, status deljenja će biti promenjen u isti onaj status kakav važi za kategoriju sa ‘nasumičnim’ pitanjem prilikom nadogradnje na verziju Moodle 1.9. Sledećim katerijama će status deljenja biti promenjen. Pitanja na koja će ove izmene uticati nastaviće normalno da funkcionišu u svim postojećim testovima sve dok ih ne uklonite iz tih testova.</p>';
$string['cwrqpfsnoprob'] = 'Nijedna kategorija pitanja na vašem sajtu nije pogođena problemom \'Nasumična pitanja se biraju iz potkategorija\'.';
$string['decimalplacesingrades'] = 'Decimalna mesta u ocenama';
$string['defaultbank'] = 'Banka pitanja kursa {$a->coursename}';
$string['defaultcreated'] = 'Podrazumevana banka pitanja je kreirana';
$string['defaultfor'] = 'Podrazumevano za {$a}';
$string['defaultinfofor'] = 'Podrazumevana kategorija za pitanja deljena u kontekstu \'{$a}\'.';
$string['defaultmark'] = 'Podrazumevana ocena';
$string['defaultmarkmustbepositive'] = 'Podrazumevana ocena mora biti pozitivna.';
$string['deletecoursecategorywithquestions'] = 'Postoje pitanja u bazi pitanja pridruženoj ovoj kategoriji kurseva. Ako nastavite, ona će biti obrisana. Možda biste želeli da ih prvo premestite, koristeći interfejs za baze pitanja.';
$string['deletequestioncheck'] = 'Ovo će obrisati sledeće pitanje i sve njegove verzije:<br /><br />{$a}';
$string['deletequestionscheck'] = 'Ovo će obrisati sledeća pitanja i sve njihve verzije:<br /><br />{$a}';
$string['deletequestiontitle'] = 'Obrišite pitanje?';
$string['deletequestiontitle_plural'] = 'Obrišite pitanja?';
$string['deleteselectedquestioncheck'] = 'Ovo će obrisati izabrane verzije sledećeg pitanja:<br /><br />{$a}';
$string['deleteversiontitle'] = 'Obrišite izabranu verziju?';
$string['deleteversiontitle_plural'] = 'Obrišite izabrane verzije?';
$string['deletingbehaviour'] = 'Brisanje ponašanja pitanja \'{$a}\'';
$string['deletingqtype'] = 'Brisanje tipa pitanja \'{$a}\'';
$string['didnotmatchanyanswer'] = '[Ne poklapa se ni sa jednim odgovorom]';
$string['disabled'] = 'Onemogućeno';
$string['disabledbanks'] = 'Svi tipovi modula banke pitanja su onemogućeni.';
$string['displayoptions'] = 'Opcije prikaza';
$string['disterror'] = 'Distribucija {$a} je izazvala probleme';
$string['donothing'] = 'Nemojte kopirati/premeštati datoteke ili menjati linkove.';
$string['editcategories'] = 'Uredi kategorije';
$string['editcategories_help'] = 'Umesto da sva budu na jednom velikom spisku, pitanja mogu biti organizovana u kategorije i potkategorije.

Kategorije se koriste i za nasumično izabrana pitanja, budući da se ona biraju iz određenih kategorija.';
$string['editcategories_link'] = 'question/category';
$string['editcategory'] = 'Uredi kategoriju';
$string['editingcategory'] = 'Uređivanje kategorije';
$string['editingquestion'] = 'Uređivanje pitanja';
$string['editquestion'] = 'Uredi pitanje';
$string['editquestions'] = 'Uredi pitanja';
$string['editthiscategory'] = 'Uredi ovu kategoriju';
$string['emptyxml'] = 'Nepoznata greška - prazna imsmanifest.xml datoteka';
$string['enabled'] = 'Omogućeno';
$string['erroraccessingcontext'] = 'Ne može se pristupiti kontekstu';
$string['errordeletingquestionsfromcategory'] = 'Greška pri brisanju pitanja iz kategorije {$a}.';
$string['errorduringpost'] = 'Došlo je do greške u toku naknadne obrade!';
$string['errorduringpre'] = 'Došlo je do greške u toku prethodne obrade!';
$string['errorduringproc'] = 'Došlo je do greške u toku obrade!';
$string['errorduringregrade'] = 'Nije moguće ponovo oceniti pitanje {$a->qid}, prelazim na stanje {$a->stateid}.';
$string['errorfilecannotbecopied'] = 'Greška, ne može da se kopira datoteka {$a}.';
$string['errorfilecannotbemoved'] = 'Greška, ne može da se premesti datoteka {$a}.';
$string['errorfileschanged'] = 'Грешка: датотеке повезане са питањима су измењене од момента када је образац био приказан.';
$string['erroritemappearsmorethanoncewithdifferentweight'] = 'Pitanje ({$a}) se pojavljuje više nego jednom sa različitim ponderima na različitim mestima u testu. Statistički izveštaj to trenutno ne podržava te statistika za ovo pitanje može biti nepouzdana.';
$string['errormanualgradeoutofrange'] = 'Ocena {$a->grade} nije između 0 i {$a->maxgrade} za pitanje {$a->name}. Rezultat i komentar nisu sačuvani.';
$string['errormovingquestions'] = 'Greška pri premeštanju pitanja sa id vrednostima {$a}.';
$string['errorpostprocess'] = 'Došlo je do greške u toku naknadne obrade!';
$string['errorpreprocess'] = 'Došlo je do greške u toku prethodne obrade!';
$string['errorprocess'] = 'Došlo je do greške u toku obrade!';
$string['errorprocessingresponses'] = 'Došlo je do greške prilikom obrade vaših odgovora ({$a}). Kliknite na dugme \'Nastavi\' da biste se vratili na stranicu na kojoj ste bili i pokušajte ponovo.';
$string['errorsavingcomment'] = 'Greška prilikom pokušaja da se sačuva komentar za pitanje {$a->name} u bazi podataka.';
$string['errorsavingflags'] = 'Greška prilikom pokušaja da se sačuva status indikatora.';
$string['errorupdatingattempt'] = 'Greška prilikom ažuriranja pokušaja {$a->id} u bazi podataka.';
$string['eventqbankdisabled'] = 'Dodatak za banku pitanja je onemogućen';
$string['eventqbankenabled'] = 'Dodatak za banku pitanja je omogućen';
$string['eventquestioncategorycreated'] = 'Kategorija pitanja kreirana';
$string['eventquestioncategorydeleted'] = 'Kategorija pitanja obrisana';
$string['eventquestioncategorymoved'] = 'Kategorija pitanja premeštena';
$string['eventquestioncategoryupdated'] = 'Kategorija pitanja ažurirana';
$string['eventquestioncategoryviewed'] = 'Kategorija pitanja prikazana';
$string['eventquestioncreated'] = 'Pitanje kreirano';
$string['eventquestiondeleted'] = 'Pitanje obrisano';
$string['eventquestionmoved'] = 'Pitanje premešteno';
$string['eventquestionsexported'] = 'Pitanja izvezena';
$string['eventquestionsimported'] = 'Pitanja uvezena';
$string['eventquestionupdated'] = 'Pitanje ažurirano';
$string['eventquestionviewed'] = 'Pitanje prikazano';
$string['export'] = 'Izvoz';
$string['exportasxml'] = 'Izvezi kao Moodle XML';
$string['exportcategory'] = 'Izvezi kategoriju';
$string['exportcategory_help'] = 'Ovo podešavanje određuje kategoriju iz koje će biti preuzeta izvezena pitanja.

Određeni formati za uvoz pitanja, kao što su GIFT i Moodle XML, dozvoljavaju da u datoteku koja se izvozi budu uključeni i podaci o kategoriji i kontekstu, što ovim formatima daje mogućnost (opciono) da, prilikom uvoza pitanja, ponovo kreiraju kategoriju i kontekst. Ako je neophodno, treba označiti odgovarajuće polje za izbor.';
$string['exporterror'] = 'Pojavila se greška u toku eksportovanja!';
$string['exportfilename'] = 'test';
$string['exportnameformat'] = '%d.%m.%Y.-%H.%M';
$string['exportonequestion'] = 'Preuzmite ovo pitanje u Moodle XML formatu';
$string['exportquestions'] = 'Izvezi pitanja u datoteku';
$string['exportquestions_help'] = 'Ova funkcija omogućava izvoz kompletne kategorije pitanja (sa svim njenim potkategorijama) u tekstualnu datoteku. Molimo vas, imajte na umu da, zavisno od izabranog formata datoteka, neki podaci o pitanjima i određeni tipovi pitanja ne mogu da budu izvezeni.';
$string['exportquestions_link'] = 'question/export';
$string['feedback'] = 'Povratne informacije';
$string['fieldinquestion'] = '{$a->fieldname} {$a->questionindentifier}';
$string['fieldinquestionpre'] = '{$a->questionindentifier} {$a->fieldname}';
$string['filecantmovefrom'] = 'Datoteke sa pitanjima ne mogu biti premeštene zato što nemate ovlašćenja da uklanjate datoteke sa mesta sa kojeg pokušavate da izmestite pitanja.';
$string['filecantmoveto'] = 'Datoteke sa pitanjima ne mogu biti premeštene ili kopirane zato što nemate ovlašćenja da dodajete datoteke na mesto na koje pokušavate da premestite pitanja.';
$string['fileformat'] = 'Format datoteke';
$string['filesareacourse'] = 'prostor za datoteke kursa';
$string['filesareasite'] = 'prostor za datoteke sajta';
$string['filestomove'] = 'Premesti / kopiraj datoteke u {$a}?';
$string['fillincorrect'] = 'Unesi tačne odgovore';
$string['filterbytags'] = 'Filtriraj prema oznakama...';
$string['firsttry'] = 'Prvi pokušaj';
$string['flagged'] = 'Obeleženo';
$string['flagthisquestion'] = 'Obeleži ovo pitanje';
$string['formquestionnotinids'] = 'Obrazac sadrži pitanje koje nije u questionids';
$string['fractionsnomax'] = 'Jedan od odgovora bi trebao nositi 100% rezultata tako da je moguće dobiti maksimalan mogući broj bodova za ovo pitanje.';
$string['generalfeedback'] = 'Opšte povratne informacije';
$string['generalfeedback_help'] = 'Opšte povratne informacije se prikazuje polaznicima nakon što su završili pitanje. Za razliku od specifičnih povratnih informacija, koje zavise od tipa pitanja i odgovora koji je polaznik dao, isti tekst opštih povratnih informacija se prikazuje svim polaznicima.

Opšte povratne informacije možete koristiti  kako biste polaznicima dali potpuno tačan odgovor i, eventualno, link ka detaljnijim informacijama koje  mogu da koriste ukoliko nisu razumeli pitanja.';
$string['getcategoryfromfile'] = 'Preuzmi kategoriju iz datoteke';
$string['getcontextfromfile'] = 'Preuzmi kontekst iz datoteke';
$string['hintn'] = 'Savet {no}';
$string['hintnoptions'] = 'Savet {no} opcije';
$string['hinttext'] = 'Tekst saveta';
$string['howquestionsbehave'] = 'Kako se ponašaju pitanja';
$string['howquestionsbehave_help'] = 'Polaznici mogu da stupaju u brojne, različite interakcije sa pitanjima na testu. Na primer, možda ćete hteti da polaznici unesu odgovore za sva pitanja i onda predaju kompletan test, pre nego što budu ocenjeni ili pre nego što dobiju bilo kakve povratne informacije. Ovaj režim se zove \'Odložene povratne informacije\'.

Alternativno, možda ćete hteti da polaznici predaju svaki odgovor zasebno u toku rešavanja testa kako bi odmah dobili povratne informacije, a ako ih ne dobiju da mogu ponovo da pokušaju da daju novi odgovor za nižu ocenu. Ovaj režim se zove \'Interaktivno sa višestrukim pokušajima\'.

Ovo su verovatno dva najčešće korišćena režima ponašanja pitanja.';
$string['howquestionsbehave_link'] = 'question/behaviour';
$string['idnumber'] = 'ID broj';
$string['idnumber_help'] = 'Ako se koristi, ID broj mora biti jedinstven u svakoj kategoriji pitanja. On pruža još jedan način za identifikaciju pitanja koji je ponekad koristan, ali obično se može izostaviti.';
$string['ignorebroken'] = 'Ignoriši neispravne linkove';
$string['import'] = 'Uvoz';
$string['importcategory'] = 'Uvezi kategoriju';
$string['importcategory_help'] = 'Ovo podešavanje određuje kategoriju u koju će uvezena pitanja biti smeštena.

Određeni formati uvoza, kao što su GIFT i Moodle XML, mogu da uključe u uvoznu datoteku i informacije o kategoriji i kontekstu. Ako želite da koristite te podatke, umesto izabrane kategorije, potrebno je da označite odgovarajuća polja za izbor. Ako kategorije navedene u uvoznoj datoteci ne postoje, one će biti kreirane.';
$string['importerror'] = 'Došlo je do greške u toku obrade uvoza';
$string['importerrorquestion'] = 'Greška prilikom uvoza pitanja';
$string['importfromcoursefiles'] = '... ili izaberite datoteku kursa za uvoz';
$string['importfromupload'] = 'Izaberite datoteku za postavljanje';
$string['importingquestions'] = 'Uvoz {$a} pitanja iz datoteke';
$string['importparseerror'] = 'Pronađena je greška/e u toku parsiranja datoteke koja se uvozi. Da biste uvezli pitanja koja su dobra pokušajte ponovo tako što ćete podešavanje \'Zaustavi kada se pojavi greška\' podesiti na \'Ne\'';
$string['importquestions'] = 'Uvezi pitanja iz datoteke';
$string['importquestions_help'] = 'Ova funkcija omogućava da pitanja u različitim formatima budu uvezena putem tekstualne datoteke. Imajte u vidu da datoteka mora da koristi UTF-8 kodni raspored.';
$string['importquestions_link'] = 'question/import';
$string['importwrongfileencoding'] = 'Datoteka koju ste izabrali se ne koristi UTF-8 kodni raspored. {$a} datoteka/e mora/ju koristiti UTF-8.';
$string['importwrongfiletype'] = 'Tip datoteke koji ste izabrali ({$a->actualtype}) se ne poklapa sa tipom koji očekuje ovaj format uvoza ({$a->expectedtype}).';
$string['impossiblechar'] = 'Otkriven je nemogući znak {$a} kao znak za zagrade';
$string['includesubcategories'] = 'Prikaži, takođe, pitanja iz potkategorija';
$string['incorrect'] = 'Netačno';
$string['incorrectfeedback'] = 'Za svaki netačan odgovor';
$string['incorrectfeedbackdefault'] = 'Vaš odgovor je netačan.';
$string['information'] = 'Informacija';
$string['invalidanswer'] = 'Nepotpun odgovor';
$string['invalidarg'] = 'Nisu dostavljeni ispravni argumenti ili je pogrešna konfiguracija servera';
$string['invalidcategoryidforparent'] = 'Neispravan identifikator nadređene kategorije!';
$string['invalidcategoryidtomove'] = 'Neispravan identifikator kategorije koja se premešta!';
$string['invalidconfirm'] = 'Izraz za potvrdu je neispravan';
$string['invalidcontextinhasanyquestions'] = 'Neispravan kontekst prosleđen u question_context_has_any_questions.';
$string['invalidgrade'] = 'Ocene se ne poklapaju sa opcijama za ocenjivanje - pitanje je preskočeno';
$string['invalidgradequestion'] = 'Ocene ({$a->grades}) se ne poklapaju sa opcijama za ocenjivanje - pitanje {$a->question}\' je preskočeno.';
$string['invalidpenalty'] = 'Neispravna kazna';
$string['invalidquestiontype'] = 'Neispravan tip pitanja: {$a}';
$string['invalidwizardpage'] = 'Navedena stranica sa "čarobnjakom" (<i>wizard page</i>) je neispravna ili ne postoji!';
$string['lastmodifiedby'] = 'Poslednji put izmenio/la';
$string['lasttry'] = 'Poslednji pokušaj';
$string['linkedfiledoesntexist'] = 'Datoteka {$a} do koje vodi link ne postoji';
$string['makechildof'] = 'Napravi potomka od \'{$a}\'';
$string['makecopy'] = 'Napravi kopiju';
$string['maketoplevelitem'] = 'Pomeri na najviši nivo';
$string['manualgradeinvalidformat'] = 'To nije validan broj.';
$string['manualgradeoutofrange'] = 'Ova ocena je izvan važećeg opsega';
$string['manuallygraded'] = 'Ručno ocenjeno {$a->mark} sa komentarom: {$a->comment}';
$string['mark'] = 'Oceni';
$string['markedoutof'] = 'Maksimalna ocena';
$string['markedoutofmax'] = 'Maksimalna ocena {$a}';
$string['markoutofmax'] = 'Ocena {$a->mark} od {$a->max}';
$string['marks'] = 'Ocene';
$string['matchgrades'] = 'Upari ocene';
$string['matchgrades_help'] = 'Uvezene ocene moraju da se poklapaju sa fiksnim spiskom  validnih ocena - 100, 90, 80, 75, 70, 66.666, 60, 50, 40, 33.333, 30, 25, 20, 16.666, 14.2857, 12.5, 11.111, 10, 5, 0 (takođe i negativne vrednosti). Ako se ne poklapaju, postoje dve
mogućnosti:

* Greška ako ocena nije na spisku - ako pitanje sadrži bilo koju ocenu koja nije na spisku biće prikazana greška a to pitanje neće biti uvezeno
* Najbliža ocena ako ocena nije na spisku - ako se ocena ne poklapa ni sa jednom sa spiska, biće promenjena u najpribližniju vrednost';
$string['matchgradeserror'] = 'Greška ako ocena nije navedena';
$string['matchgradesnearest'] = 'Najbliža ocena ako ocena nije navedena';
$string['missingcourseorcmid'] = 'Print_question zahteva courseid ili cmid.';
$string['missingcourseorcmidtolink'] = 'Get_question_edit_link zahteva courseid ili cmid.';
$string['missingimportantcode'] = 'Ovom tipu pitanja nedostaje važan kôd: {$a}.';
$string['missingoption'] = 'Pitanju tipa Umetnuti odgovori {$a} nedostaju opcije';
$string['modified'] = 'Poslednja izmena';
$string['move'] = 'Premesti iz {$a} i promeni linkove.';
$string['movecategory'] = 'Premesti kategoriju';
$string['movedquestionsandcategories'] = 'Premeštena su pitanja i kategorije pitanja sa {$a->oldplace} na {$a->newplace}.';
$string['movelinksonly'] = 'Samo promenite destinacije linkova, nemojte premeštati niti kopirati datoteke.';
$string['moveq'] = 'Premesti pitanje(a)';
$string['moveqtoanothercontext'] = 'Premesti pitanje u drugi kontekst.';
$string['moveto'] = 'Premesti u';
$string['movingcategory'] = 'Premeštanje kategorije';
$string['movingcategoryandfiles'] = 'Da li ste sigurni da želite da premestite kategoriju {$a->name} i sve njoj podređene kategorije u kontekst za "{$a->contextto}"?<br /> Postoji {$a->urlcount} datoteka u vezi sa pitanjima u {$a->fromareaname}. Da li želite da je(ih) kopirate ili premestite u {$a->toareaname}?';
$string['movingcategorynofiles'] = 'Da li ste sigurni da želite da premestite kategoriju "{$a->name}" i sve podređene kategorije u kontekst za "{$a->contextto}"?';
$string['movingquestions'] = 'Premeštanje pitanja i svih datoteka';
$string['movingquestionsandfiles'] = 'Da li ste sigurni da želite da premestite pitanje(a) {$a->questions} u kontekst za <strong>"{$a->tocontext}"</strong>?<br /> Postoji <strong>{$a->urlcount} datoteka</strong> do koje(kojih) vode linkovi iz ovog(ovih) pitanja u {$a->fromareaname}. Da li želite da je(ih) kopirate ili premestite u {$a->toareaname}?';
$string['movingquestionsnofiles'] = 'Da li ste sigurni da želite da premestite pitanje(a) {$a->questions} u kontekst za <strong>"{$a->tocontext}"</strong>?<br /> <strong>Nema datoteka</strong> povezanih sa njim(a) u {$a->fromareaname}.';
$string['needtochoosecat'] = 'Morate odabrati kategoriju u koju želite da premestite ovo pitanje ili pritisnuti \'otkaži\'.';
$string['nobanks'] = 'Ovaj kurs još uvek nema nijednu banku pitanja.';
$string['nocate'] = 'Ne postoji kategorija {$a}!';
$string['noconditionspecified'] = 'Molimo vas, navedite uslov';
$string['nopermissionadd'] = 'Nemate odobrenje da dodate pitanje ovde.';
$string['nopermissionedit'] = 'Nemate ovlašćenje da uređujete pitanja odavde.';
$string['noprobs'] = 'Nije nađen ni jedan problem u vašoj bazi podataka sa pitanjima.';
$string['noquestionbanks'] = 'Nije pronađen dodatak za banku pitanja.';
$string['noquestions'] = 'Nije pronađeno nijedno pitanje koje bi moglo da se izveze. Proverite da li ste za izvoz izabrali kategoriju koja sadrži pitanja.';
$string['noquestionsinfile'] = 'Nema pitanja u datoteci odabranoj za uvoz';
$string['noresponse'] = '[Nema odgovora]';
$string['notagfiltersapplied'] = 'Nije primenjen filter po oznakama';
$string['notanswered'] = 'Nije odgovoreno';
$string['notchanged'] = 'Nije menjano od poslednjeg pokušaja';
$string['notenoughanswers'] = 'Ovaj tip pitanja zahteva najmanje {$} odgovora';
$string['notenoughdatatoeditaquestion'] = 'Nisu specificirani ni identifikator pitanja, ni identifikator kategorije sa tipom pitanja.';
$string['notenoughdatatomovequestions'] = 'Morate navecti identifikatore pitanja koja želite da premestite.';
$string['notgraded'] = 'Nije ocenjeno';
$string['notshown'] = 'Nije prikazano';
$string['notyetanswered'] = 'Još nije odgovoreno';
$string['notyourpreview'] = 'Ovaj pregled ne pripada vama';
$string['novirtualquestiontype'] = 'Ne postoji virtuelni tip pitanja za pitanje tipa {$a}';
$string['numqas'] = 'Broj pokušaja';
$string['numquestions'] = 'Broj pitanja';
$string['numquestionsandhidden'] = '{$a->numquestions} (+{$a->numhidden} skriveno +{$a->numdraft} radna verzija)';
$string['options'] = 'Opcije';
$string['otherbanks'] = 'Ostale aktivnosti sa pitanjima';
$string['otherbanksdesc'] = 'Pitanja u bankama pitanja ovih aktivnosti ne mogu se koristiti nigde drugde.';
$string['otherquestionbank'] = 'Sve banke pitanja';
$string['otherquestionbankstoomany'] = 'Više od {$a} rezultate, molimo vas da precizirajte pretragu.';
$string['page-question-category'] = 'Stranica kategorije pitanja';
$string['page-question-edit'] = 'Stranica za uređivanje pitanja';
$string['page-question-export'] = 'Stranica za izvoz pitanja';
$string['page-question-import'] = 'Stranica za uvoz pitanja';
$string['page-question-x'] = 'Bilo koja stranica pitanja';
$string['parent'] = 'Nadređeno';
$string['parentcategory'] = 'Nadređena kategorija';
$string['parentcategory_help'] = 'Nadređena kategorija je ona u koju će nova kategorija biti smeštena. "Top" znači  da se ta kategorija ne nalazi unutar bilo koje druge kategorije. Konteksti kategorije su prikazani podebljanim slovima. Mora da postoji bar jedna kategorija u svakom kontekstu.';
$string['parentcategory_link'] = 'question/category';
$string['parenthesisinproperclose'] = 'Zagrade pre ** nisu pravilno zatvorene u {$a}*';
$string['parenthesisinproperstart'] = 'zagrade pre ** nisu pravilno otvorene u {$a}*';
$string['parsingquestions'] = 'Parsiranje pitanja iz uvozne datoteke.';
$string['partiallycorrect'] = 'Delimično tačno';
$string['partiallycorrectfeedback'] = 'Za svaki delimično tačan odgovor';
$string['partiallycorrectfeedbackdefault'] = 'Vaš odgovor je delimično tačan.';
$string['penaltyfactor'] = 'Kazneni faktor';
$string['penaltyfactor_help'] = '<p>Možete odrediti koji deo postignutog rezultata bi treablo oduzeti za svaki pogrešan odgovor. Ovo je relevantno samo ukoliko je test podešen tako da koristi adaptivni mod koji omogućava polazniku da ponavljano odgovore na isto pitanje. Kaznenini faktor morao bi da bude broj između 0 i 1. Kazneni faktor koji ima vrednost 1 znači da polaznik mora da tačan odgovor iz prvog puta da bi uopšte dobio poen za pitanje. Kazneni faktor 0 znači da polaznik može da pokušava onoliko puta koliko želi i uvek će dobiti maksimalan broj poena.</p>';
$string['penaltyforeachincorrecttry'] = 'Kazneni bodovi za svaki netačan pokušaj';
$string['penaltyforeachincorrecttry_help'] = 'Kada u testu upotrebljavate pitanja koristeći režim \'Interaktivno sa višestrukim pokušajima\' ili \'Adaptivni režim\', tako da polaznik ima na raspolaganju veći broj pokušaja da tačno odgovori na pitanje, onda ova opcija kontroliše sa koliko bodova će biti kažnjen svaki netačan pokušaj.

Kazna predstavlja deo ukupne ocene za pitanje. Na primer ako pitanje nosi tri boda, a kazna je 0.3333333, onda će polaznik osvojiti 3 boda ukoliko iz prvog pokušaja tačno odgovori, 2 ako tačno odgovori iz drugog pokušaja i 1 ukoliko je odgovorio tačno u trećem pokušaju.

Za neka pitanja koja se sastoje iz više delova ova logika bodovanja primenjuje se odvojeno na svaki deo pitanja. Detalji zavise od tipa pitanja i mogu biti komplikovani, ali princip je da se polaznicima daju bodove za znanje koje su pokazali, što je moguće pravednije.';
$string['permissionedit'] = 'Uredite ovo pitanje';
$string['permissionmove'] = 'Premestite ovo pitanje';
$string['permissionsaveasnew'] = 'Sačuvaj ovo pitanje kao novo';
$string['permissionto'] = 'Imate dozvolu da:';
$string['previewbank'] = 'Pregled deljene banke pitanja';
$string['previewquestion'] = 'Pregledaj pitanje: {$a}';
$string['privacy:metadata:database:question'] = 'Detaljne informacije o konkretnom pitanju.';
$string['privacy:metadata:database:question:createdby'] = 'Osoba koja je kreirala pitanje.';
$string['privacy:metadata:database:question:generalfeedback'] = 'Opšte povratne informacacije za ovo pitanje.';
$string['privacy:metadata:database:question:modifiedby'] = 'Osoba koja je poslednje ažurirala pitanje.';
$string['privacy:metadata:database:question:name'] = 'Naziv pitanja.';
$string['privacy:metadata:database:question:questiontext'] = 'Tekst pitanja.';
$string['privacy:metadata:database:question:timecreated'] = 'Datum i vreme kada je ovo pitanje kreirano.';
$string['privacy:metadata:database:question:timemodified'] = 'Datum i vreme kada je ovo pitanje ažurirano.';
$string['privacy:metadata:database:question_attempt_step_data'] = 'Koraci za pokušaj odgovaranja na pitanje mogu imati dodatne podatke specifične za taj korak. Podaci se čuvaju u tabeli step_data.';
$string['privacy:metadata:database:question_attempt_step_data:name'] = 'Naziv stavke podataka.';
$string['privacy:metadata:database:question_attempt_step_data:value'] = 'Vrednost stavke podataka.';
$string['privacy:metadata:database:question_attempt_steps'] = 'Svaki pokušaj odgovora pitanja ima nekoliko koraka koji ukazuju na različite faze od početka preko završetka do ocenjivanja. Ova tabela čuva informacije za svaki od ovih koraka.';
$string['privacy:metadata:database:question_attempt_steps:fraction'] = 'Ocena koja je dodeljena ovom pokušaju odgovora na pitanje skalirana je prema vrednosti od 1.';
$string['privacy:metadata:database:question_attempt_steps:state'] = 'Status ovog pokušaja odgovora na pitanje na kraju tranzicije koraka.';
$string['privacy:metadata:database:question_attempt_steps:timecreated'] = 'Datum i vreme kada je ova tranzicija koraka započeta.';
$string['privacy:metadata:database:question_attempt_steps:userid'] = 'Korisnik koji je izvršio tranziciju koraka.';
$string['privacy:metadata:database:question_attempts'] = 'Informacije o pokušaju davanja odgovora na određeno pitanje.';
$string['privacy:metadata:database:question_attempts:flagged'] = 'Naznaka da je korisnik označio ovo pitanje unutar pokušaja.';
$string['privacy:metadata:database:question_attempts:responsesummary'] = 'Rezime odgovora na pitanje.';
$string['privacy:metadata:database:question_attempts:timemodified'] = 'Vreme kada je ažuriran pokušaj odgovora na pitanje.';
$string['privacy:metadata:database:question_bank_entries'] = 'Detaljnije informacije o konkretnom unosu u banku pitanja.';
$string['privacy:metadata:database:question_bank_entries:ownerid'] = 'Osoba koja je vlasnik unosa u banku pitanja.';
$string['privacy:metadata:link:qbehaviour'] = 'Podsistem Pitanje koristi tip dodatka Ponašanje pitanja.';
$string['privacy:metadata:link:qformat'] = 'Podsistem Pitanje koristi tip dodatka Formati pitanja u svrhu uvoza i izvoza pitanja u različitim formatima.';
$string['privacy:metadata:link:qtype'] = 'Podsistem Pitanje je u interakciji sa tipom dodatka Tip pitanja koji sadrži različite tipove pitanja.';
$string['published'] = 'objavljeno';
$string['qbanknotfound'] = 'Додатак за банку питања \'{$a}\' не постоји или није препознат.';
$string['qtypeveryshort'] = 'T';
$string['question_version'] = 'Верзија питања';
$string['question_versionshort'] = 'v{$a}';
$string['questionaffected'] = '<a href="{$a->qurl}">Pitanje "{$a->name}" ({$a->qtype})</a> je u ovoj kategoriji pitanja ali se koristi i u <a href="{$a->qurl}">testu "{$a->quizname}"</a> koji pripada drugom kursu "{$a->coursename}".';
$string['questionbank'] = 'Banka pitanja';
$string['questionbank_plural'] = 'Banke pitanja';
$string['questionbanknavigation'] = 'Банка питања - терцијарна навигација';
$string['questionbehaviouradminsetting'] = 'Podešavanja ponašanja pitanja';
$string['questionbehavioursdisabled'] = 'Ponašanja pitanja koje želite da onemogućite';
$string['questionbehavioursdisabledexplained'] = 'Unesite spisak ponašanja, odvojenih zarezima, koja ne želite da se pojavljuju u padajućem meniju.';
$string['questionbehavioursorder'] = 'Redosled ponašanja pitanja';
$string['questionbehavioursorderexplained'] = 'Unesite spisak ponašanja razdvojena zarezima onim redosledom kojim želite da se ona pojavljuju u padajućem meniju.';
$string['questioncategories'] = 'Kategorije pitanja';
$string['questioncategory'] = 'Kategorija pitanja';
$string['questioncatsfor'] = 'Kategorije pitanja za \'{$a}\'';
$string['questiondefaultssave'] = 'Sačuvajte opcije pitanja kao podrazumevana podešavanja korisnika';
$string['questiondefaultssave_desc'] = 'Da li opcije pitanja kao npr. \'Podrazumevana ocena\' ili \'Jedan ili više tačnih odgovora?\' itd. treba da budu sačuvane kao korisnička podešavanja kada se obrazac za uređivanje pitanja pošalje. Vrednost sačuvana u podešavanjima korisnika će se tada koristiti kao podrazumevana vrednost sledeći put kada se obrazac aktivira.';
$string['questiondoesnotexist'] = 'Ovo pitanje ne postoji';
$string['questionediting'] = 'Uređivanje pitanja';
$string['questionediting_desc'] = 'Ova podešavanja kontrolišu raѕzličite aspekte obrazaca za uređivanje pitanja';
$string['questionformtagheader'] = '{$a} oznaka';
$string['questionidmismatch'] = 'Nepoklapanje identifikacionih oznaka pitanja';
$string['questionloaderror'] = 'Nije moguće učitati opcije pitanja.';
$string['questionname'] = 'Naziv pitanja';
$string['questionnameandquestionversion'] = '{$a->name} v{$a->version}';
$string['questionnamecopy'] = '{$a} (kopija)';
$string['questionno'] = 'Pitanje {$a}';
$string['questionpreviewdefaults'] = 'Podrazumevana podešavanja za pregled pitanja';
$string['questionpreviewdefaults_desc'] = 'Ova podrazumevana podešavanja se koriste kada korisnik prvi put pregleda pitanje u banci pitanja. Kada korisnik pregleda pitanje njegova podešavanja će biti sačuvana kao korisnička podešavanja';
$string['questions'] = 'Pitanja';
$string['questionsaveerror'] = 'U toku pokušaja da se sačuva pitanje  ({$a}) pojavila se greška';
$string['questionsinuse'] = '* (Zvezdica) označava pitanja koja se ne mogu obrisati jer se koriste. Umesto toga, ona će biti sakrivena u banci pitanja, osim ako ne podesite opciju \'Prikaži sakrivena pitanja\' na \'Da\'.';
$string['questionsmovedto'] = 'Pitanje koje se još uvek koristi je premešteno u "{$a}" u okviru nadređene kategorije.';
$string['questionsrescuedfrom'] = 'Pitanje sačuvano iz konteksta {$a}.';
$string['questionsrescuedfrominfo'] = 'Ova pitanja (od kojih neka mogu biti skrivena) sačuvana su kada je kontekst {$a} bio obrisan, zato što se još uvek koriste u nekim testovima ili drugim aktivnostima.';
$string['questiontags'] = 'Oznake pitanja';
$string['questiontext'] = 'Tekst pitanja';
$string['questiontype'] = 'Tip pitanja';
$string['questionuse'] = 'Koristi pitanje u ovoj aktivnosti';
$string['questionvariant'] = 'Varijanta pitanja';
$string['questionx'] = 'Pitanje {$a}';
$string['quizquestionbank'] = 'Banka pitanja za ovaj test';
$string['recentlyviewedquestionbanks'] = 'Nedavno prikazane banke pitanja';
$string['requiresgrading'] = 'Zahteva ocenjivanje';
$string['responsehistory'] = 'Istorija odgovora';
$string['restart'] = 'Ponovo započni';
$string['restartwiththeseoptions'] = 'Sačuvajte opcije pregleda i počnite ponovo';
$string['restoremultipletopcats'] = 'Datoteka sa rezervnom kopijom sadrži više od jedne vrhovne kategorije pitanja za kontekst {$a}.';
$string['reviewresponse'] = 'Pregledaj odgovore';
$string['rightanswer'] = 'Tačan odgovor';
$string['rightanswer_help'] = 'Automatski generisani rezime tačnog odgovora. Ovo ima svoja ograničenja, pa ćete možda poželeti da razmotrite mogućnost da tačan odgovor detaljnije objasnite u opštim povratnim informacijama za pitanje, a ovu opciju isključite.';
$string['save'] = 'Sačuvaj';
$string['savechangesandcontinueediting'] = 'Sačuvaj promene i nastavi uređivanje';
$string['saved'] = 'Sačuvano: {$a}';
$string['saveflags'] = 'Sačuvaj stanje indikatora (zastavica)';
$string['selectacategory'] = 'Izaberi kategoriju';
$string['selectaqtypefordescription'] = 'Izaberi tip pitanja da bi video njegov opis';
$string['selectcategoryabove'] = 'Izaberite kategoriju od gore navedenih';
$string['selectquestionsforbulk'] = 'Izaberite pitanja za grupne akcije';
$string['settingsformultipletries'] = 'Višestruki pokušaji';
$string['shareincontext'] = 'Deli u kontekstu za {$a}';
$string['shortversioninfo'] = 'v{$a->version} (od {$a->latestversion})';
$string['shortversioninfolatest'] = 'v{$a->version} (najnovija)';
$string['showhidden'] = 'Prikaži sakrivena pitanja';
$string['showmarkandmax'] = 'Prikaži ocenu i maksimalnu ocenu';
$string['showmaxmarkonly'] = 'Prikaži samo maksimalnu ocenu';
$string['shown'] = 'Prikazano';
$string['shownumpartscorrect'] = 'Prikaži broj tačnih odgovora';
$string['shownumpartscorrectwhenfinished'] = 'Prikaži broj tačnih odgovora';
$string['showquestiontext'] = 'Želite li da prikažete tekst pitanja na spisku pitanja?';
$string['showquestiontext_full'] = 'Da, sa slikama i drugim multimedijalnim sadržajem';
$string['showquestiontext_off'] = 'Ne';
$string['showquestiontext_plain'] = 'Da, samo tekst';
$string['specificfeedback'] = 'Specifične povratne informacije';
$string['specificfeedback_help'] = 'Povratne informacija koja zavisi od odgovora koji je polaznik dao';
$string['started'] = 'Započeto';
$string['state'] = 'Stanje';
$string['step'] = 'Korak';
$string['steps'] = 'Koraci';
$string['stoponerror'] = 'Zaustavi kada se pojavi greška';
$string['stoponerror_help'] = 'Ovo podešavanje određuje da li se proces uvoza zaustavlja kada se otkrije greška, što će rezultirati time da nijedno pitanje neće biti uvezeno, ili se pitanja sa greškom ignorišu dok se sva ispravna pitanja uvoze.';
$string['submissionoutofsequence'] = 'Pristup van redosleda. Molimo vas, nemojte da klikćete na dugme \'Nazad\' kada odgovarate na pitanja sa testa.';
$string['submissionoutofsequencefriendlymessage'] = 'Uneli ste podatke van normalnog redosleda. To se može desiti ako koristite dugmad \'Nazad\'  (Back) ili \'Napred\' (Forward) u svom veb čitaču. Molimo vas da ih ne koristite tokom testa. Ovo se, takođe, može dogoditi ako kliknete na nešto dok se stranica učitava. Kako biste nastavili kliknite na <strong>Nastavi</strong>.';
$string['submit'] = 'Predaj';
$string['submitandfinish'] = 'Predaj i završi';
$string['submitted'] = 'Predaj: {$a}';
$string['switchbank'] = 'Promenite banku pitanja';
$string['systembank'] = 'Banka pitanja deljena na nivou sistema';
$string['systembankdescription'] = 'Ova banka pitanja se automatski kreira kada se sajt ažurira na noviju verziju.';
$string['tagarea_question'] = 'Pitanja';
$string['technicalinfo'] = 'Tehničke informacije';
$string['technicalinfo_help'] = 'Ove tehničke informacije korisne su verovatno samo programerima koji rade na razvoju novih tipova pitanja. Takođe, one mogu biti od koristi prilikom pokušaja da se dijagnostikuju problemi sa pitanjima.';
$string['technicalinfomaxfraction'] = 'Maksimalni udeo: {$a}';
$string['technicalinfominfraction'] = 'Minimalni udeo: {$a}';
$string['technicalinfoquestionsummary'] = 'Rezime pitanja: {$a}';
$string['technicalinforesponsesummary'] = 'Rezime odgovora: {$a}';
$string['technicalinforightsummary'] = 'Rezime tačnog odgovora: {$a}';
$string['technicalinfostate'] = 'Stanje pitanja: {$a}';
$string['technicalinfovariant'] = 'Varijanta pitanja: {$a}';
$string['tofilecategory'] = 'Upiši kategoriju u datoteku';
$string['tofilecontext'] = 'Upiši kontekst u datoteku';
$string['topfor'] = 'Vrhovna kategorija za {$a}';
$string['uninstallbehaviour'] = 'Deinstaliraj ovo ponašanje pitanja';
$string['uninstallqtype'] = 'Deinstaliraj ovaj tip pitanja';
$string['unknown'] = 'Nepoznato';
$string['unknownbehaviour'] = 'Nepoznato ponašanje: {$a}.';
$string['unknownorunhandledtype'] = 'Nepoznat ili nepodržan tip pitanja: {$a}';
$string['unknownquestion'] = 'Nepoznato pitanje: {$a}.';
$string['unknownquestioncatregory'] = 'Nepoznata kategorija pitanja: {$a}.';
$string['unknownquestiontype'] = 'Nepoznat tip pitanja: {$a}.';
$string['unknowntolerance'] = 'Nepoznata tip odstupanja {$}';
$string['unpublished'] = 'neobjavljeno';
$string['unusedcategorydeleted'] = 'Nakon brisanja kursa, ova kategorija je, takođe, obrisana, zbog toga što se pitanja iz ove kategorija ne koriste u testovima drugih kurseva.';
$string['updatedisplayoptions'] = 'Ažuriraj opcije prikaza';
$string['upgradeproblemcategoryloop'] = 'Otkriven je problem pri pokušaju ažuriranja kategorija pitanja. Postoji petlja u stablu kategorija. Pogođene su time kategorije sa id vrednostima {$a}.';
$string['upgradeproblemcouldnotupdatecategory'] = 'Nije moguće ažurirati kategoriju pitanja {$a->name} ({$a->id}).';
$string['upgradeproblemunknowncategory'] = 'Otkriven je problem pri pokušaju ažuriranja kategorija pitanja. Kategorija {$a->id} ukazuje na nadređenu kategoriju {$a->parent}, koja ne postoji. Promenjena je nadređena kategorija da bi se rešio problem.';
$string['version_selection'] = 'Verzija {$a->version}';
$string['versioninfo'] = 'Verzija {$a->version} (od {$a->latestversion})';
$string['versioninfolatest'] = 'Verzija {$a->version} (najnovija)';
$string['versioninfolatestshort'] = 'v{$a} (najnovija)';
$string['whethercorrect'] = 'Da li je odgovor tačan';
$string['whethercorrect_help'] = 'Ovo pokriva kako tekstualni opis tipa \'Tačno\', \'Delimično tačno\' ili \'Netačno\',  tako i svaki bojom istaknut tekst koji nosi istu informaciju.';
$string['whichtries'] = 'Koji pokušaj';
$string['withselected'] = 'Sa izabranima';
$string['wrongprefix'] = 'Pogrešno formatiran nameprefix {$a}';
$string['xoutofmax'] = '{$a->mark} od {$a->max}';
$string['yougotnright'] = 'Ispravno ste izabrali {$a->num}.';
$string['youmustselectaqtype'] = 'Morate da izaberete tip pitanja.';
$string['yourfileshoulddownload'] = 'Vaša datoteka za izvoz - trebalo bi da uskoro započne preuzimanje. U suprotnom, molimo <a href="{$a}">kliknite ovde</a>. Promenjena je nadređena kategorija da bi se rešio problem.';
