<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'enrol_arlo', language 'ro', version '5.0'.
 *
 * @package     enrol_arlo
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['accessed'] = 'Accesat';
$string['alert'] = 'Alertă';
$string['allowcompletedevents'] = 'Autorizează evenimentele finalizate';
$string['allowcompletedevents_help'] = 'Evenimentele finalizate vor putea fi selectate și corelate cu sesiunile de înscriere.';
$string['allowcompletedevents_text'] = 'Evenimentele finalizate pot fi corelate.';
$string['allowcompletedonlineactivities'] = 'Autorizează activitățile finalizate online';
$string['allowcompletedonlineactivities_help'] = 'Activitățile finalizate online vor putea fi selectate și corelate cu sesiunile de înscriere.';
$string['allowcompletedonlineactivities_text'] = 'Activitățile finalizate online pot fi corelate.';
$string['allowhiddencourses'] = 'Autorizează cursurile ascunse';
$string['allowhiddencourses_help'] = 'Observație: Va trebui să dezactivați mesajele de întâmpinare la curs și să le ajustați în consecință.';
$string['allowhiddencourses_text'] = 'Permiteți procesarea sesiunilor de înscriere la cursuri autorizate.';
$string['allowhiddencoursesdiabled'] = 'Autorizarea cursurilor este dezactivată la configurare site.';
$string['allowunenrolaccessedui'] = 'Permiteți accesul la retrageri';
$string['allowunenrolaccessedui_help'] = 'Adaugă un control la pagina de înscrieri nereușite pentru gestionarea solicitărilor de reunire a datelor de contact.';
$string['allowunenrolaccessedui_text'] = 'Autorizați abilitatea de a retrage utilizatorii care au accesat cursurile înregistrate la Arlo.';
$string['allowunenrolactiveenrolmentsui'] = 'Autorizați anularea înscrierilor active';
$string['allowunenrolactiveenrolmentsui_help'] = 'Adaugă simbolul acțiunii de retragere pe metoda de înscriere a utilizatorilor.';
$string['allowunenrolactiveenrolmentsui_text'] = 'Autorizează utilizatorul, care deține această capacitate, să retragă manual utilizatorii, fără a-i suspenda mai întâi.';
$string['apipassword'] = 'Parolă Arlo';
$string['apipassword_desc'] = 'Ați uitat parola? <a title="{$a->title}" href="{$a->url}" target="_blank">Aflați cum o puteți reseta.</a>';
$string['apirequests'] = 'Solicitări API';
$string['apistatusclienterror'] = 'Eroare la conectarea clientului!';
$string['apistatusok'] = 'OK, cea mai recentă solicitare a fost {$a}';
$string['apistatusservererror'] = 'Serviciu indisponibil momentan';
$string['apiusername'] = 'Nume utilizator Arlo';
$string['apiusername_desc'] = 'Important: Contul dumneavoastră Arlo de utilizator trebuie activat API , <a title="{$a->title}" href="{$a->url}" target="_blank">aflați mai multe.</a>';
$string['arlo:config'] = 'Configurați sesiunea Arlo de înscrieri';
$string['arlo:manage'] = 'Gestionează sesiunea de înscrieri Arlo';
$string['arlo:synchronizecore'] = 'Extindeți manual noile resurse de bază';
$string['arlo:synchronizeinstance'] = 'Extindeți manual noile înregistrări și transmiteți rezultatele noi pentru o sesiunea de înscrieri';
$string['arlo:unenrol'] = 'Retrage utilizatorii suspendați';
$string['arloconnection'] = 'Conexiune Arlo';
$string['arlocontact'] = 'Contact Arlo';
$string['arlocoursecode'] = 'Cod curs Arlo';
$string['arloenrolment'] = 'Înscriere Arlo';
$string['assignedgroup'] = 'Grup alocat';
$string['assignrole'] = 'Alocă rol';
$string['associatearlotemplate'] = 'Asociază șablon Arlo';
$string['associateduser'] = 'Utilizator asociat';
$string['associatetemplatedanger'] = '<div class="alert alert-danger" role="alert">
<strong>Important!</strong>
<p>Acesta va asocia fiecare eveniment sau activitate online în baza șablonului. Nu sunt incluse evenimentele sau activitățile online care au fost deja adăugate la alt curs .</p>
</div>';
$string['associatetemplatewithcourse'] = 'Asociază șablonul Arlo la cursul Moodle';
$string['backtoenrolmentmethods'] = 'Înapoi la metodele de înscriere';
$string['browseassociateduser'] = 'Răsfoiește contul de utilizator asociat';
$string['browseuserprofile'] = 'Răsfoiește profilul utilizatorului';
$string['changessaved'] = 'Modificări salvate';
$string['cleanup'] = 'Curățare';
$string['codeprimary'] = 'Cod primar';
$string['communications'] = 'Comunicări';
$string['completed'] = 'Finalizat';
$string['configuration'] = 'Configurare';
$string['contactmergefailurereport'] = 'Raportul privind reunirea datelor de contact';
$string['contactmergerequestfailure'] = 'Transmiterea solicitării de reunire a datelor de contact nu a reușit';
$string['contactmergerequestfailures'] = 'Eșecurile solicitării de reunire a datelor de contact';
$string['contactrecordinformation'] = 'Informații privind înregistrarea contactului';
$string['contactrecordmissing'] = 'Înregistrarea contactului lipsește.';
$string['contactresourcemissing'] = 'Resursa contactului lipsește din Înregistrări.';
$string['coretask'] = 'Sincronizarea informațiilor Arlo de bază';
$string['coursewelcome'] = 'Întâmpinare curs';
$string['creategroup'] = 'Crearea unui nou grup';
$string['customwelcomemessage'] = 'Mesaj de întâmpinare personalizat';
$string['customwelcomemessage_help'] = 'Mesajul de întâmpinare personalizat poate fi adăugat ca text simplu sau în format automat Moodle, incluzănd etichete HTML și multi-lang.

Următorii substituenți pot fi incluși în mesaj:

* Denumire curs {$a->coursename}
* Adresa URL a cursului {$a->courseurl}
* Prenumele utilizatorului {$a->firstname}
* Numele complet al utilizatorului {$a->fullname}
* Numele de utilizator {$a->username}
* Am uitat parola URL {$a->forgotpasswordurl}';
$string['defaultgroupnametext'] = '{$a->name} Grup Arlo';
$string['defaultperiod'] = 'Durata implicită a înscrierii';
$string['defaultperiod_desc'] = 'Intervalul implicit de timp în care înscrierea este validă. Dacă este setat la zero, durata înscrierii va fi implicit nelimitată.';
$string['defaultperiod_help'] = 'Intervalul implicit de timp în care înscrierea este validă, începând cu momentul în care utilizatorul este înscris. Dacă este dezactivată, durata înscrierii va fi implicit nelimitată.';
$string['defaultrole'] = 'Rol implicit';
$string['defaultrole_help'] = 'Poziția care trebuie alocată utilizatorilor pe durata înscrierii';
$string['delivered'] = 'Furnizat';
$string['destinationcontact'] = 'Contact destinație';
$string['disabled'] = 'Dezactivat';
$string['divertedto'] = 'Deviat spre {$a}';
$string['email'] = 'Email';
$string['enablewebhook'] = 'Activare webhook';
$string['enablewebhook_desc'] = 'Activare webhook pentru Arlo.';
$string['enrolment'] = 'Înscriere';
$string['enrolmentfailure'] = 'Înscrierea nu a reușit';
$string['enrolmentinstancedisabled'] = 'Sesiunea de înscriere a fost dezactivată.';
$string['enrolmentstask'] = 'Creează și actualizează înscrierile bazate pe informațiile privind înregistrările Arlo';
$string['enrolmentwillbeattemptedagain'] = 'Se va încerca din nou înscrierea prin intermediul sarcinii programate standard. De asemenea, puteți încerca să rezolvați, efectuând o sincronizare manuală.';
$string['enrolperiod'] = 'Durata înscrierii';
$string['enrolusers'] = 'Înscrie utilizatori';
$string['error_duplicateusers_full'] = 'Au fost identificați utilizatori duplicat în Moodle, în momentul în care au încercat să realizeze corespondența cu un contact Arlo.

Au fost identificate {$a->count} conturi Moodle, având următoarele detalii:
Prenume: {$a->firstname}
Nume:  {$a->lastname}
E-mail:      {$a->email}
Număr ID:   {$a->idnumber}

A fost creat un nou cont pentru acest utilizator .';
$string['error_duplicateusers_fullhtml'] = '<p>Au fost identificați utilizatori duplicat în Moodle, în momentul în care au încercat să realizeze corespondența cu un contact Arlo.</p>
<br>
<p>Au fost identificate {$a->count} conturi Moodle având următoarele detalii:</p>
<br>
<pre>
Prenume: {$a->firstname}
Nume:  {$a->lastname}
E-mail:      {$a->email}
Număr ID:   {$a->idnumber}
</pre>
<br>
<p>A fost creat un nou cont pentru acest utilizator.</p>';
$string['error_duplicateusers_smallmessage'] = 'Au fost identificați utilizatori duplicat în Moodle, în momentul în care au încercat să realizeze corespondența cu un contact Arlo';
$string['error_duplicateusers_subject'] = 'Au fost identificați utilizatori duplicat în Moodle, în momentul în care au încercat să realizeze corespondența cu un contact Arlo';
$string['errorselectevent'] = 'Este necesară selectarea unui eveniment';
$string['errorselectonlineactvity'] = 'Este necesară selectarea unei activități online';
$string['errorselecttemplate'] = 'Vă rugăm să selectați un șablon de evenimentEvent Template';
$string['errorselecttype'] = 'Este necesar să selectați un tip';
$string['event'] = 'Eveniment';
$string['eventcreated'] = 'Eveniment creat';
$string['eventresultpushingdisabled'] = 'Rezultatul evenimentului este dezactivat la configurarea site-ului.';
$string['events'] = 'Evenimente';
$string['eventupdated'] = 'Eveniment actualizat';
$string['expiredaction'] = 'Acțiune de expirare a înscrierii';
$string['expiredaction_help'] = 'Selectați acțiunea care trebuie întreprinsă, atunci când expiră înscrierea utilizatorului. Vă rugăm să observați că unele date și setări ale utilizatorului sunt șterse pe durata retragerii de la curs.';
$string['expirymessagesubject'] = 'Notificare privind expirarea înscrierii';
$string['expirymessagetext'] = 'Stimate {$a->user},

Aceasta este o notificare că înscrierea dumneavoastră la curs \'{$a->coursename}\' a expirat.';
$string['expirynotify'] = 'Notifică utilizatorul cu privire la expirarea înscrierii';
$string['expirynotify_help'] = 'Această setare determină dacă mesajele de notificare cu privire la expirarea înscrierii sunt transmise.';
$string['extra'] = 'Extra';
$string['fail'] = 'Nereușită';
$string['failed'] = 'Nu a reușit';
$string['failures'] = 'Nereușite';
$string['format'] = 'FORMAT';
$string['httpstatus:200'] = 'OK';
$string['httpstatus:201'] = 'Super';
$string['httpstatus:302'] = 'Găsit';
$string['httpstatus:400'] = 'Solicitare greșită';
$string['httpstatus:401'] = 'Neautorizată';
$string['httpstatus:403'] = 'Interzisă';
$string['httpstatus:404'] = 'Nu a fost găsită';
$string['httpstatus:406'] = 'Inacceptabilă';
$string['httpstatus:409'] = 'Conflict';
$string['httpstatus:415'] = 'Tip Media incompatibil';
$string['httpstatus:500'] = 'Eroare server intern';
$string['httpstatus:503'] = 'Serviciu indisponibil';
$string['inprogress'] = 'În desfășurare';
$string['instanceexists'] = 'Arlo este deja sincronizat cu poziția selectată';
$string['invalidcredentials_fullmessage'] = 'Moodle nu se poate conecta la Arlo API

Setările de conexiune nu sunt corecte. Vă rugăm să verificați dacă numele de utilizator și parola api sunt corecte.
Setările de conexiune Moodle Arlo: {$a->url}';
$string['invalidcredentials_fullmessagehtml'] = '<h3>Moodle nu se poate conecta la Arlo API</h3>
<br>
<p>Setările de conexiune nu sunt corecte. Vă rugăm să verificați dacă numele de utilizator și parola api sunt corecte.</p>
<p>Setările de conexiune Moodle Arlo: <a href="{$a->url}">{$a->url}</a></p>';
$string['invalidcredentials_smallmessage'] = 'Moodle nu se poate conecta la Arlo API. Vă rugăm să verificați setările de conexiune: {$a->url}';
$string['invalidcredentials_subject'] = 'Moodle nu se poate conecta la Arlo API';
$string['json'] = 'JSON';
$string['locktimeout'] = 'Operațiunea a expirat în timp ce așteptați blocarea';
$string['longtime'] = 'Acest proces poate dura mult timp';
$string['managearlo'] = 'Gestionează Arlo';
$string['manualsynchronisenotice'] = 'Acest proces poate dura mult timp. Nu închideți fereastra browser-ului. Veți fi redirecționat spre pagina metodelor de înscriere, odată ce procesul va fi finalizat.';
$string['matchbyarlocodeprimary'] = 'Cod primar contact Arlo';
$string['matchbyarlouserdetails'] = 'Prenume, nume și e-mail contact Arlo';
$string['matchbyauto'] = 'Prenume, nume și e-mail contact Arlo, apoi cod primar contact Arlo';
$string['matchuseraccountsby'] = 'Realizați corespondența dintre conturile utilizatorului și';
$string['matchuseraccountsby_help'] = '<p>
Înainte de a creea un nou cont Moodle, plugin-ul va încerca să realizeze corespondența cu o înregistrare de contact Arlo. Opțiunile de corespondență sunt următoarele:
</p>
<p>
<strong>Metoda 1</strong>
<br>
Prenume, nume și e-mail Arlo - Această opțiune va încerca să realizeze corespondența între grupul de câmpuri  (prenume, nume și e-mail contact Arlo) și (prenume, nume și e-mail Moodle).
</p>
<p>
<strong>Metoda 2</strong>
<br>
Arlo CodePrimary - Această opțiune va încerca să realizeze corespondența între câmpurile Cod primar contact Arlo și numărul ID al utilizatorului Moodle.
</p>
<p>
<strong>Metoda 3</strong>
<br>
Will try <strong>Metoda 1</strong> dacă nu se realizează nicio corespondență, atunci utilizați <strong>Metoda 2</strong>.
</p>
<p>
Dacă nu a fost identificată nicio corespondență utilizând oricare dintre metode, va fi creat un cont de utilizator Moodle pornind de la detaliile de contact Arlo.
</p>';
$string['messagenotsent'] = 'Mesajul nu a fost transmis';
$string['messageprovider:administratornotification'] = 'Notificarea administratorului cu privire la problemele de integrare';
$string['messagesent'] = 'Mesaj transmis';
$string['metadata:enrol_arlo_contact'] = 'Contact Arlo';
$string['metadata:enrol_arlo_emailqueue'] = 'Comunicații';
$string['metadata:enrol_arlo_registration'] = 'Înregistrare Arlo';
$string['moodleusern'] = 'Utilizator Moodle {$a}';
$string['morethanonematch'] = 'Au fost identificate mai multe corespondențe';
$string['morethanonemoodleuserfound'] = 'Au fost identificați mai mulți utilizatori Moodle cu aceleași detalii';
$string['newaccountdetails'] = 'Detalii cont nou';
$string['newaccountfullmessage'] = 'Bună {$a->firstname},

A fost creat un nou cont pentru dumneavoastră pe \'{$a->sitename}\'
și vi s-a emis o parolă temporară.

Informațiile dumneavoastră curente privind conectarea sunt:
   nume utilizator: {$a->username}
   parolă: {$a->newpassword}
             (va trebui să vă modificați parola
              în cursul primei conectări)

Pentru a putea utiliza \'{$a->sitename}\', conectați-vă la
   {$a->link}

În majoritatea programelor de e-mail, aceasta ar trebui să fie afișată sub forma unui link scris cu albastru, pe care trebuie doar să apăsați. Dacă acest lucru nu funcționează, atunci copiați și inserați adresa în spațiul destinat acesteia în partea superioară a browser-ului dumneavoastră web.

Salutări din partea administratorului \'{$a->sitename}\',
{$a->signoff}';
$string['newaccountsubject'] = 'Cont utilizator nou';
$string['newuserdefaultemail'] = 'E-mail-ul implicit al noului utilizator';
$string['newuserdefaultemail_help'] = 'E-mail-ul implicit al noului utilizator';
$string['noassociateduser'] = 'Nu există un cont utilizator Moodle asociat.';
$string['noeventsoractivitiesfound'] = 'Nu au fost identificate evenimente sau activități online "Active".';
$string['nomatchingenrolmentinstance'] = 'Nu există nicio sesiune de înscriere potrivită .';
$string['notifyexpiry'] = 'Notifică expirarea';
$string['notok'] = 'Nu este OK';
$string['notstarted'] = 'Nu a început';
$string['ok'] = 'OK';
$string['onlineactivities'] = 'Activități online';
$string['onlineactivity'] = 'Activitate online';
$string['onlineactivitycreated'] = 'Activitate online creată';
$string['onlineactivityresultpushingdisabled'] = 'Rezultatele activității online vor fi dezactivate la configurarea site-ului.';
$string['onlineactivityupdated'] = 'Actualizarea activității online';
$string['opennewtabtitle'] = 'Pentru a deschide o nouă pagină în Windows: CTRL + click pe Mac: comandă + click';
$string['outboundemaildelivery'] = 'Livrarea e-mailului';
$string['outcomepushingdisabled'] = 'Rezultatele vor fi dezactivate la configurarea site-ului.';
$string['outcomespushingdisabled'] = 'Rezultatele vor fi dezactivate';
$string['outcomestask'] = 'Transmiteți rezultatul și procesați informațiile privind înregistrarea Arlos';
$string['pass'] = 'Parolă';
$string['platform'] = 'Platforma URL Arlo';
$string['platform_desc'] = 'Adresa URL a platformei de gestionare Arlo  \'yourplatform.arlo.co\' (excluzând https:// and /). Nu există o platformă Arlo? <a title="{$a->title}" href="{$a->url}" target="_blank">Creați o probă gratuită.</a>';
$string['pleasecheckrequestlog'] = 'Vă rugăm să verificați <a href="{$a}">jurnalul de solicitări</a>';
$string['pluginname'] = 'Înscriere Arlo';
$string['pluginname_desc'] = '<p>Aceste înscrieri sunt gestionate de local_arlo</p>';
$string['pluginnotenabled'] = 'Plugin-ul nu este activat!';
$string['pluginstatus'] = 'Status';
$string['privacy:metadata:core_group'] = 'Plugin-ul poate crea un grup nou sau poate utiliza un grup existent, pentru a adăuga membrii din sesiunea de înscriere.';
$string['privacy:metadata:enrol_arlo_contact'] = 'Informații privind contactul Arlo asociat contului de utilizator Moodle.';
$string['privacy:metadata:enrol_arlo_contact:codeprimary'] = 'Codul primar al contactului Arlo.';
$string['privacy:metadata:enrol_arlo_contact:email'] = 'E-mail-ul contactului Arlo.';
$string['privacy:metadata:enrol_arlo_contact:firstname'] = 'Prenumele contactului Arlo.';
$string['privacy:metadata:enrol_arlo_contact:lastname'] = 'Numele contactului Arlo';
$string['privacy:metadata:enrol_arlo_contact:phonemobile'] = 'Numărul de telefon al contactului Arlo.';
$string['privacy:metadata:enrol_arlo_contact:phonework'] = 'Numărul de telefon de serviciu al contactului Arlo.';
$string['privacy:metadata:enrol_arlo_contact:sourceguid'] = 'GUID-ul contactului Arlo.';
$string['privacy:metadata:enrol_arlo_contact:sourceid'] = 'ID-ul contactului Arlo.';
$string['privacy:metadata:enrol_arlo_contact:userid'] = 'ID-ul utilizatorului Moodle asociat contactului Arlo.';
$string['privacy:metadata:enrol_arlo_emailqueue'] = 'Informații privind comunicările prin e-mail Arlo';
$string['privacy:metadata:enrol_arlo_emailqueue:area'] = 'Site sau înscriere.';
$string['privacy:metadata:enrol_arlo_emailqueue:extra'] = 'Orice informație necesară în conținutul e-mail-ului.';
$string['privacy:metadata:enrol_arlo_emailqueue:instanceid'] = 'Elementul de identificare al sesiunii.';
$string['privacy:metadata:enrol_arlo_emailqueue:status'] = 'Ordonat, transmis sau eșuat.';
$string['privacy:metadata:enrol_arlo_emailqueue:type'] = 'Întâmpinare utilizator nou sau curs.';
$string['privacy:metadata:enrol_arlo_emailqueue:userid'] = 'ID-ul utilizatorului Moodle asociat la contactul Arlo.';
$string['privacy:metadata:enrol_arlo_registration'] = 'Informații privind înregistrarea Arlo asociată înscrierii utilizatorului Moodle.';
$string['privacy:metadata:enrol_arlo_registration:enrolid'] = 'ID-ul sesiunii de înscriere asociate.';
$string['privacy:metadata:enrol_arlo_registration:grade'] = 'Nota asociată înregistrării Arlo.';
$string['privacy:metadata:enrol_arlo_registration:lastactivity'] = 'Perioadă în care a existat activitate într-un sistem extern asociat înregistrării Arlo.';
$string['privacy:metadata:enrol_arlo_registration:outcome'] = 'Rezultatul (promovat/ respins) asociat înregistrării Arlo.';
$string['privacy:metadata:enrol_arlo_registration:progresspercent'] = 'Valoare decimală reprezentând un progres asociat înregistrării Arlo.';
$string['privacy:metadata:enrol_arlo_registration:progressstatus'] = 'Status progres asociat înregistrării Arlo.';
$string['privacy:metadata:enrol_arlo_registration:sourcecontactguid'] = 'GUID-ul contactului Arlo.';
$string['privacy:metadata:enrol_arlo_registration:sourcecontactid'] = 'ID-ul contactului Arlo.';
$string['privacy:metadata:enrol_arlo_registration:sourceguid'] = 'GUID-ul înregistrării Arlo.';
$string['privacy:metadata:enrol_arlo_registration:sourceid'] = 'ID-ul înregistrării Arlo.';
$string['privacy:metadata:enrol_arlo_registration:userid'] = 'ID-ul utilizatorului Moodle asociat contactului Arlo.';
$string['privacy:metadata:field:usermodified'] = 'ID-ul utilizatorului care a modificat înregistrarea.';
$string['pusheventresults'] = 'Transmite rezultatele evenimentului';
$string['pusheventresults_help'] = 'Transmite informațiile privind rezultatele din sesiunile de înscriere cartografiate pe <strong>Events</strong> înapoi la Arlo';
$string['pushonlineactivityresults'] = 'Transmite rezultatele activității online';
$string['pushonlineactivityresults_help'] = 'Transmite informațiile privind rezultatele din sesiunile de înscriere cartografiate pe <strong>OnlineActivities</strong> înapoi la Arlo';
$string['queued'] = 'Ordonat';
$string['reattemptenrolment'] = 'Încearcă din nou înscrierea';
$string['reattemptenrolmentconfirm'] = 'Vă rugăm să vă asigurați că ați rezolvat toate problemele menționate în rapoartele de erori, înainte de a încerca din nou să efectuați înscrierea. În caz contrar, înscrierea va eșua din nou. Încercați din nou înscrierea?';
$string['regcreated'] = 'Înregistrare creată';
$string['registrationstatus'] = 'Status înregistrare';
$string['regupdated'] = 'Înregistrare actualizată';
$string['remove'] = 'Elimină';
$string['removeallarloenrolmentsquestion'] = 'Sunteți sigur că doriți să eliminați toate înscrierile Arlo asociate cu {$a}?';
$string['removetemplatedanger'] = '<div class="alert alert-danger" role="alert">
<strong>Important!</strong>
<p>Eliminarea șablonului asociat va duce la ștergerea tuturor persoanelor din curs, aflate în următoarele sesiuni de înscriere:</p>
{$a}
</div>';
$string['report'] = 'Raport';
$string['requestlogcleanup'] = 'Solicită curățarea jurnalului';
$string['requestlogcleanup_help'] = 'Eliminați intrările din jurnalul de intrări care sunt mai vechi decât momentul selectat.';
$string['resulting'] = 'Rezultat';
$string['returntounsucessfulenrolments'] = 'Revenire la înscrierile nereușite';
$string['savechanges'] = 'Salvează modificările';
$string['sendcoursewelcomemessage'] = 'Transmite mesajul de întâmpinare la curs';
$string['sendcoursewelcomemessage_help'] = 'Dacă este activat, utilizatorii vor primi un mesaj de întâmpinare prin e-mail, după ce vor fi înscriși la curs.';
$string['sourcecontact'] = 'Contact sursă';
$string['status'] = 'Activ';
$string['status_help'] = '';
$string['suspendeduser_fullmessage'] = 'Plugin-ul de înscrieri Arlo a suspendat contul unui utilizator pe durata soluționării unei cereri de reunire a contactelor.

Contul utilizatorului nu are înscrieri la curs și este asociat unui contact Arlo.

Vă rugăm să revizuiți profilul de utilizator {$a->profileurl}';
$string['suspendeduser_fullmessagehtml'] = '<p>Plugin-ul de înscrieri Arlo a suspendat contul unui utilizator pe durata soluționării unei cereri de reunire a contactelor.</p>
<br>
<p>Contul utilizatorului nu are înscrieri la curs și este asociat unui contact Arlo.</p>
<br>
<p>Vă rugăm să revizuiți profilul de utilizator <a href="{$a->profileurl}">{$a->profileurl}</a></p>';
$string['suspendeduser_smallmessage'] = 'Contul unui utilizator a fost suspendat. Vă rugăm să revizuiți profilul de utilizator {$a->profileurl}';
$string['suspendeduser_subject'] = 'Plugin-ul a suspendat contul unui utilizator';
$string['synchroniseinstancefor'] = 'Sincronizați manual înscrierile și rezultatele Arlo pentru {$a}';
$string['synchroniseoperationiscurrentlylocked'] = 'Operațiunea de sincronizare a înscrierilor Arlo este blocată în acest moment de un alt proces în desfășurare.';
$string['synchronize'] = 'Sincronizează';
$string['synchronizeinstance'] = 'Extrageți manual înregistrările noi și transmiteți înregistrările noi pentru o sesiune de înscriere';
$string['technicalcontact'] = 'Email de contact';
$string['template'] = 'Șablon';
$string['timelogged'] = 'Timp înregistrat';
$string['timemodified'] = 'Timp modificat';
$string['type'] = 'Tip';
$string['typeofevent'] = 'Tip eveniment';
$string['unenrolcontact'] = 'Anulați contactul';
$string['unenrolfromarlocourses'] = 'Retrageți de la cursurile asociate cu Arlo';
$string['unknown'] = 'Necunoscut';
$string['unlock'] = 'Deblocați';
$string['unsuccessfulenrolment'] = 'Înscriere nereușită';
$string['unsuccessfulenrolment_fullmessage'] = 'Înscrierea contactului Arlo nu a reușit din cauza duplicării conturilor de utilizator Moodle sau contul Moodle nu a putut fi creat datorită setărilor de configurare a site-ului.

Vă rugăm să verificați raportul {$a->report} pentru informații suplimentare.';
$string['unsuccessfulenrolment_fullmessagehtml'] = '<p>Înscrierea  contactului Arlo nu a reușit din cauza duplicării conturilor de utilizator Moodle sau contul Moodle nu a putut fi creat datorită setărilor de configurare a site-ului.</p>
<br>
<p>Vă rugăm să verificați raportul <a href="{$a->report}">{$a->report}</a> pentru informații suplimentare.</p>';
$string['unsuccessfulenrolment_smallmessage'] = 'Înscrierea contactului Arlo nu a reușit, vă rugăm să verificați raportul {$a->report}';
$string['unsuccessfulenrolment_subject'] = 'Înscrierea contactului Arlo nu a reușit';
$string['unsuccessfulenrolmentof'] = 'Înscrierea nereușită a {$a->fullname} în {$a->code}';
$string['unsuccessfulenrolments'] = 'Înscrieri nereușite';
$string['unsuccessfulenrolmentscount'] = 'Înscrieri nereușite: {$a}';
$string['updatecontactstask'] = 'Actualizează informațiile privind utilizatorul Moodle în baza informațiilor actualizate privind contactul Arlo';
$string['uri'] = 'URI';
$string['userassociationfailurereport'] = 'Raport privind asocierea utilizatorului';
$string['usercreation'] = 'Crearea utilizatorului';
$string['userrecordinformation'] = 'Informații privind înregistrarea utilizatorului';
$string['viewreport'] = 'Vizualizare raport';
$string['webhookdisabled'] = '<div class="alert alert-danger" role="alert">Webhook este dezactivat.</div>';
$string['webhookenabled'] = '<div class="alert alert-success" role="alert">Webhook este configurat și activ.</div>';
$string['webhookinactive'] = '<div class="alert alert-warning" role="alert">Webhook neconfigurat sau inactiv.</div>';
$string['welcometocourse'] = 'Bine ai venit la {$a}';
$string['welcometocoursetext'] = 'Bine ai venit la {$a->coursename}!

Numele de utilizator: {$a->username}

Ai uitat parola?

Poți reseta parola, utilizând următoarea adresă URL:

  {$a->forgotpasswordurl}

Poți accesa acest cursul pe următoarea adresă URL:

  {$a->courseurl}';
$string['xml'] = 'XML';
