<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'local_moodlemobileapp', language 'pl', version '5.0'.
 *
 * @package     local_moodlemobileapp
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['addon.block_myoverview.browseallcourses'] = 'Przeglądaj wszystkie kursy';
$string['addon.block_myoverview.nocoursesenrolled'] = 'Nie jesteś jeszcze zapisany na żadne kursy.';
$string['addon.block_myoverview.nocoursesenrolleddescription'] = 'Przejrzyj wszystkie dostępne kursy poniżej i rozpocznij naukę.';
$string['addon.block_myoverview.noresult'] = 'Twoje wyszukiwanie nie pasuje do żadnych kursów.';
$string['addon.block_myoverview.noresultdescription'] = 'Spróbuj dostosować filtry lub przejrzyj wszystkie kursy poniżej.';
$string['addon.blog.errorloadentries'] = 'Błąd ładowania wpisów blogu.';
$string['addon.blog.showonlyyourentries'] = 'Pokaż tylko swoje wpisy';
$string['addon.calendar.calendarevent'] = 'Wydarzenie w kalendarzu';
$string['addon.calendar.calendarevents'] = 'Wydarzenia w kalendarzu';
$string['addon.calendar.calendarreminders'] = 'Przypomnienia kalendarza';
$string['addon.calendar.currentmonth'] = 'Bieżący miesiąc';
$string['addon.calendar.defaultnotificationtime'] = 'Domyślny czas powiadomienia';
$string['addon.calendar.errorloadevent'] = 'Błąd ładowania wydarzenia.';
$string['addon.calendar.errorloadevents'] = 'Błąd ładowania wydarzeń.';
$string['addon.calendar.noevents'] = 'Brak wydarzeń';
$string['addon.calendar.reminders'] = 'Przypomnienia';
$string['addon.calendar.setnewreminder'] = 'Ustaw nowe przypomnienie';
$string['addon.competency.errornocompetenciesfound'] = 'Nie znaleziono kompetencji';
$string['addon.competency.nocompetencies'] = 'Brak kompetencji';
$string['addon.coursecompletion.complete'] = 'Ukończone';
$string['addon.coursecompletion.couldnotloadreport'] = 'Nie udało się pobrać raportu ukończenia kursu. Spróbuj ponownie później.';
$string['addon.messageoutput_airnotifier.processorsettingsdesc'] = 'Skonfiguruj urządzenia';
$string['addon.messageoutput_airnotifier.pushdisabledwarning'] = 'Twoi użytkownicy nie otrzymują żadnych powiadomień z tej witryny na swoich urządzeniach mobilnych. Włącz powiadomienia mobilne na stronie ustawień powiadomień.';
$string['addon.messages.contactlistempty'] = 'Lista kontaktów jest pusta';
$string['addon.messages.contactname'] = 'Nazwa kontaktu';
$string['addon.messages.deletemessage'] = 'Usuń wiadomość';
$string['addon.messages.deletemessageconfirmation'] = 'Czy na pewno chcesz usunąć tę wiadomość? Zostanie ona usunięta z Twojej historii wiadomości, ale będzie nadal widoczna dla użytkownika, który wysłał lub otrzymał tę wiadomość.';
$string['addon.messages.errordeletemessage'] = 'Błąd podczas usuwania wiadomości.';
$string['addon.messages.errorwhileretrievingcontacts'] = 'Błąd podczas pobierania kontaktów z serwera.';
$string['addon.messages.errorwhileretrievingdiscussions'] = 'Błąd podczas pobierania dyskusji z serwera.';
$string['addon.messages.errorwhileretrievingmessages'] = 'Błąd podczas pobierania wiadomości z serwera.';
$string['addon.messages.errorwhileretrievingusers'] = 'Błąd podczas pobierania użytkowników z serwera.';
$string['addon.messages.messagenotsent'] = 'Wiadomość nie została wysłana. Spróbuj ponownie później.';
$string['addon.messages.newmessages'] = 'Nowe wiadomości';
$string['addon.messages.nousersfound'] = 'Nie znaleziono użytkowników';
$string['addon.messages.showdeletemessages'] = 'Pokaż usunięte wiadomości';
$string['addon.messages.type_blocked'] = 'Zablokowane';
$string['addon.messages.type_offline'] = 'offline';
$string['addon.messages.type_online'] = 'online';
$string['addon.messages.type_search'] = 'Wyniki wyszukiwania';
$string['addon.messages.type_strangers'] = 'Inne';
$string['addon.messages.useentertosenddescdesktop'] = 'Jeśli wyłączone, możesz użyć Ctrl+Enter, aby wysłać wiadomość.';
$string['addon.messages.useentertosenddescmac'] = 'Jeśli wyłączone, możesz użyć Cmd+Enter, aby wysłać wiadomość.';
$string['addon.messages.warningconversationmessagenotsent'] = 'Nie udało się wysłać wiadomości do rozmowy {{conversation}}. {{error}}';
$string['addon.messages.warningmessagenotsent'] = 'Nie udało się wysłać wiadomości do użytkownika {{user}}. {{error}}';
$string['addon.mod_assign.acceptsubmissionstatement'] = 'Potwierdź przesłanie zadania';
$string['addon.mod_assign.cannoteditduetostatementsubmission'] = 'Nie można dodać ani edytować zadania w aplikacji, ponieważ nie udało się pobrać ze strony oświadczenia dot. wysyłanego zadania.';
$string['addon.mod_assign.cannotgradefromapp'] = 'Niektóre metody oceny nie są obsługiwane przez aplikację i nie mogą być zmienione.';
$string['addon.mod_assign.cannotsubmitduetostatementsubmission'] = 'Nie można wysłać zadania w aplikacji, ponieważ nie udało się pobrać ze strony oświadczenia dot. wysyłanego zadania.';
$string['addon.mod_assign.duedateno'] = 'Brak daty ważności';
$string['addon.mod_assign.erroreditpluginsnotsupported'] = 'Nie można dodać ani edytować zadania w aplikacji, ponieważ niektóre wtyczki nie obsługują jeszcze edycji.';
$string['addon.mod_assign.errorshowinginformation'] = 'Nie można wyświetlić informacji o zadaniu.';
$string['addon.mod_assign.feedbacknotsupported'] = 'Ta informacja zwrotna nie jest obsługiwana przez aplikację i może nie zawierać wszystkich informacji.';
$string['addon.mod_assign.gradenotsynced'] = 'Ocena niezsynchronizowana';
$string['addon.mod_assign.notallparticipantsareshown'] = 'Uczestnicy, którzy nie wysłali zadań nie są wyświetleni.';
$string['addon.mod_assign.numberofdraftsubmissionscountdescription'] = 'Istnieje {{count}} wersji roboczych.';
$string['addon.mod_assign.numberofparticipantscountdescription'] = 'Jest {{count}} uczestników.';
$string['addon.mod_assign.numberofsubmissionsneedgradingcountdescription'] = 'Jest {{count}} zgłoszeń, które wymagają oceny.';
$string['addon.mod_assign.numberofsubmittedassignmentscountdescription'] = 'Istnieje {{count}} przesłanych zadań.';
$string['addon.mod_assign.numberofteamscountdescription'] = 'Jest {{count}} zespołów.';
$string['addon.mod_assign.submissionnotsupported'] = 'To zadanie nie jest obsługiwane przez aplikację i może nie zawierać wszystkich informacji.';
$string['addon.mod_assign.syncblockedusercomponent'] = 'ocena użytkownika';
$string['addon.mod_assign.warningsubmissiongrademodified'] = 'Ocena zadania została zmieniona na stronie.';
$string['addon.mod_assign.warningsubmissionmodified'] = 'Zadanie użytkownika zostało zmienione na stronie.';
$string['addon.mod_chat.confirmloss'] = 'Jesteś pewny? Historia czatu może zostać utracona.';
$string['addon.mod_chat.errorwhileconnecting'] = 'Błąd podczas połączenia z czatem.';
$string['addon.mod_chat.errorwhilegettingchatdata'] = 'Błąd podczas pobierania danych czatu.';
$string['addon.mod_chat.errorwhilegettingchatusers'] = 'Błąd podczas pobierania użytkowników czatu.';
$string['addon.mod_chat.errorwhileretrievingmessages'] = 'Błąd podczas pobierania wiadomości z serwera.';
$string['addon.mod_chat.errorwhilesendingmessage'] = 'Błąd podczas wysyłania wiadomości.';
$string['addon.mod_chat.mustbeonlinetosendmessages'] = 'Musisz być online, aby wysyłać wiadomości.';
$string['addon.mod_chat.nosessionsfound'] = 'Nie znaleziono sesji';
$string['addon.mod_chat.showincompletesessions'] = 'Pokaż nieukończone sesje';
$string['addon.mod_choice.errorgetchoice'] = 'Błąd pobierania danych pytania wyboru.';
$string['addon.mod_choice.responsesresultgraphdescription'] = '{{number}}% użytkowników wybrało opcję: {{text}}.';
$string['addon.mod_choice.resultsnotsynced'] = 'Twoja ostatnia odpowiedź musi zostać zsynchronizowana, zanim zostanie uwzględniona w wynikach.';
$string['addon.mod_data.edittagsnotsupported'] = 'Przepraszamy, edycja tagów nie jest obsługiwana przez aplikację.';
$string['addon.mod_data.errorapproving'] = 'Błąd akceptacji lub odrzucenia wpisu.';
$string['addon.mod_data.errordeleting'] = 'Błąd podczas usuwania wpisu.';
$string['addon.mod_data.gettinglocation'] = 'Pobieranie lokalizacji';
$string['addon.mod_data.locationnotenabled'] = 'Lokalizacja jest wyłączona';
$string['addon.mod_data.locationpermissiondenied'] = 'Zezwolenie na dostęp do Twojej lokalizacji zostało odrzucone.';
$string['addon.mod_data.mylocation'] = 'Moja lokalizacja';
$string['addon.mod_data.searchbytagsnotsupported'] = 'Przepraszamy, wyszukiwanie po tagach nie jest obsługiwane przez aplikację.';
$string['addon.mod_feedback.captchaofflinewarning'] = 'Informacja zwrotna z CAPTCHA nie może być wypełniona offline, lub jeśli nie jest skonfigurowana, lub jeśli serwer jest wyłączony.';
$string['addon.mod_feedback.completedfeedbackscountdescription'] = 'Przesłano {{count}} odpowiedzi.';
$string['addon.mod_feedback.feedback_submitted_offline'] = 'Ta informacja zwrotna została zapisana do wysłania później.';
$string['addon.mod_feedback.questionscountdescription'] = 'Jest {{count}} pytań.';
$string['addon.mod_folder.emptyfilelist'] = 'Brak plików do wyświetlenia.';
$string['addon.mod_forum.errorgetforum'] = 'Błąd pobierania danych forum.';
$string['addon.mod_forum.errorgetgroups'] = 'Błąd pobierania ustawień grupy.';
$string['addon.mod_forum.errorloadingsortingorder'] = 'Forum niedostępne w tej kolejności sortowania';
$string['addon.mod_forum.errorloadingsortingorderdetails'] = 'Spróbuj zmienić kolejność sortowania lub przejść do trybu online, aby wyświetlić to forum.';
$string['addon.mod_forum.errorposttoallgroups'] = 'Nie udało się utworzyć nowej dyskusji we wszystkich grupach.';
$string['addon.mod_forum.forumnodiscussionsyet'] = 'Nie ma jeszcze żadnych dyskusji na tym forum.';
$string['addon.mod_forum.group'] = 'Grupa';
$string['addon.mod_forum.numdiscussions'] = '{{numdiscussions}} dyskusji';
$string['addon.mod_forum.numreplies'] = '{{numreplies}} odpowiedzi';
$string['addon.mod_forum.postingroup'] = 'Publikowanie w grupie „{{groupname}}”.';
$string['addon.mod_forum.refreshposts'] = 'Odśwież posty';
$string['addon.mod_glossary.browsemode'] = 'Przeglądaj wpisy';
$string['addon.mod_glossary.byalphabet'] = 'Alfabetycznie';
$string['addon.mod_glossary.byauthor'] = 'Grupuj wg autora';
$string['addon.mod_glossary.bycategory'] = 'Grupuj wg kategorii';
$string['addon.mod_glossary.bynewestfirst'] = 'Najnowsze pierwsze';
$string['addon.mod_glossary.byrecentlyupdated'] = 'Ostatnio zaktualizowane';
$string['addon.mod_glossary.bysearch'] = 'Szukaj';
$string['addon.mod_glossary.cannoteditentry'] = 'Nie można edytować wpisu';
$string['addon.mod_glossary.entriestobesynced'] = 'Wpisy do synchronizacji';
$string['addon.mod_glossary.entrypendingapproval'] = 'Ten wpis oczekuje na zatwierdzenie.';
$string['addon.mod_glossary.errorloadingentries'] = 'Wystąpił błąd podczas ładowania wpisów.';
$string['addon.mod_glossary.errorloadingentry'] = 'Wystąpił błąd podczas ładowania wpisu.';
$string['addon.mod_glossary.errorloadingglossary'] = 'Wystąpił błąd podczas ładowania słownika.';
$string['addon.mod_glossary.noentriesfound'] = 'Nie znaleziono wpisów.';
$string['addon.mod_glossary.searchquery'] = 'Wyszukaj';
$string['addon.mod_h5pactivity.downloadh5pfile'] = 'Pobierz plik H5P';
$string['addon.mod_h5pactivity.errorgetactivity'] = 'Błąd pobierania danych aktywności H5P.';
$string['addon.mod_h5pactivity.filestatenotdownloaded'] = 'Ten pakiet H5P nie jest pobrany. Musisz go pobrać, aby z niego skorzystać.';
$string['addon.mod_h5pactivity.filestateoutdated'] = 'Ten pakiet H5P został zmieniony od ostatniego pobrania. Musisz go pobrać ponownie, aby z niego skorzystać.';
$string['addon.mod_h5pactivity.offlinedisabledwarning'] = 'Musisz być online, aby wyświetlić ten pakiet H5P.';
$string['addon.mod_h5pactivity.viewattempt'] = 'Wyświetl próbę {{$a}}';
$string['addon.mod_imscp.showmoduledescription'] = 'Pokaż opis';
$string['addon.mod_lesson.errorprefetchrandombranch'] = 'Ta lekcja zawiera przejście do losowej strony. Nie można podjąć próby w aplikacji, dopóki nie zostanie rozpoczęta w przeglądarce internetowej.';
$string['addon.mod_lesson.errorreviewretakenotlast'] = 'Ta próba nie może być już przeglądana, ponieważ inna próba została ukończona.';
$string['addon.mod_lesson.finishretakeoffline'] = 'Próba została ukończona offline.';
$string['addon.mod_lesson.retakefinishedinsync'] = 'Próba offlina została zsynchronizowana. Czy chcesz ją przejrzeć?';
$string['addon.mod_lesson.warningretakefinished'] = 'Próba została ukończona na stronie.';
$string['addon.mod_lti.errorgetlti'] = 'Błąd pobierania danych modułu.';
$string['addon.mod_lti.errorinvalidlaunchurl'] = 'Adres URL do uruchomienia jest nieprawidłowy.';
$string['addon.mod_lti.launchactivity'] = 'Uruchom aktywność';
$string['addon.mod_page.errorwhileloadingthepage'] = 'Błąd podczas ładowania zawartości strony.';
$string['addon.mod_quiz.canattemptbutnotsubmit'] = 'Możesz podejść do tego testu w aplikacji, ale będziesz musiał przesłać podejście w przeglądarce z następujących powodów:';
$string['addon.mod_quiz.cannotsubmitquizdueto'] = 'Podejście do tego testu nie może być przesłane z następujących powodów:';
$string['addon.mod_quiz.confirmcontinueoffline'] = 'To podejście nie było synchronizowane od {{$a}}. Jeśli od tego czasu kontynuowałeś to podejście na innym urządzeniu, możesz utracić dane.';
$string['addon.mod_quiz.confirmleavequizonerror'] = 'Wystąpił błąd podczas zapisywania odpowiedzi. Czy na pewno chcesz wyjść z testu?';
$string['addon.mod_quiz.errorbehaviournotsupported'] = 'Nie możesz podejść do tego testu w aplikacji, ponieważ zachowanie pytań nie jest obsługiwane przez aplikację:';
$string['addon.mod_quiz.errordownloading'] = 'Błąd pobierania wymaganych danych.';
$string['addon.mod_quiz.errorgetattempt'] = 'Błąd pobierania danych podejścia.';
$string['addon.mod_quiz.errorgetquestions'] = 'Błąd pobierania pytań.';
$string['addon.mod_quiz.errorgetquiz'] = 'Błąd pobierania danych testu.';
$string['addon.mod_quiz.errorparsequestions'] = 'Wystąpił błąd podczas wczytywania pytań. Podejdź do tego testu w przeglądarce internetowej.';
$string['addon.mod_quiz.errorquestionsnotsupported'] = 'Nie możesz podejść do tego testu w aplikacji, ponieważ zawiera on wyłącznie pytania, które nie są obsługiwane przez aplikację:';
$string['addon.mod_quiz.errorrulesnotsupported'] = 'Nie możesz podejść do tego testu w aplikacji, ponieważ zawiera on reguły dostępu, które nie są obsługiwane przez aplikację:';
$string['addon.mod_quiz.errorsaveattempt'] = 'Wystąpił błąd podczas zapisywania danych podejścia.';
$string['addon.mod_quiz.finishnotsynced'] = 'Zakończony, ale niezsynchronizowany';
$string['addon.mod_quiz.opentoc'] = 'Otwórz okienko nawigacji';
$string['addon.mod_quiz.warningattemptfinished'] = 'Podejście offline odrzucone, ponieważ zostało zakończone na stronie lub nie zostało znalezione.';
$string['addon.mod_quiz.warningdatadiscarded'] = 'Niektóre odpowiedzi offline zostały odrzucone, ponieważ pytania zostały zmienione online.';
$string['addon.mod_quiz.warningdatadiscardedfromfinished'] = 'Podejście nieukończone, ponieważ niektóre odpowiedzi offline zostały odrzucone. Przejrzyj swoje odpowiedzi i ponownie prześlij podejście.';
$string['addon.mod_quiz.warningquestionsnotsupported'] = 'Ten test zawiera pytania, które nie są obsługiwane przez aplikację:';
$string['addon.mod_resource.errorwhileloadingthecontent'] = 'Błąd podczas ładowania zawartości.';
$string['addon.mod_resource.openthefile'] = 'Otwórz plik';
$string['addon.mod_resource.resourcestatusoutdated'] = 'Ten plik zmienił się od ostatniego otwarcia.';
$string['addon.mod_resource.resourcestatusoutdatedconfirm'] = 'Istnieje nowsza wersja tego pliku. Aby go zobaczyć, podłącz swoje urządzenie do internetu.';
$string['addon.mod_scorm.cannotcalculategrade'] = 'Nie udało się obliczyć oceny.';
$string['addon.mod_scorm.dataattemptshown'] = 'Te dane należą do próby nr {{number}}.';
$string['addon.mod_scorm.errorcreateofflineattempt'] = 'Wystąpił błąd podczas tworzenia nowej próby offline. Spróbuj ponownie.';
$string['addon.mod_scorm.errordownloadscorm'] = 'Błąd pobierania pakietu SCORM: "{{name}}".';
$string['addon.mod_scorm.errorgetscorm'] = 'Błąd pobierania danych pakietu SCORM.';
$string['addon.mod_scorm.errorinvalidversion'] = 'Niestety, aplikacja obsługuje tylko SCORM 1.2.';
$string['addon.mod_scorm.errornotdownloadable'] = 'Pobieranie pakietów SCORM jest wyłączone. Skontaktuj się z administratorem strony.';
$string['addon.mod_scorm.errornovalidsco'] = 'Ten pakiet SCORM nie ma widocznego obiektu SCO do załadowania.';
$string['addon.mod_scorm.errorpackagefile'] = 'Niestety, aplikacja obsługuje tylko pakiety ZIP.';
$string['addon.mod_scorm.errorsyncscorm'] = 'Wystąpił błąd podczas synchronizacji. Spróbuj ponownie.';
$string['addon.mod_scorm.offlineattemptnote'] = 'Ta próba zawiera dane, które nie zostały zsynchronizowane.';
$string['addon.mod_scorm.offlineattemptovermax'] = 'Nie można wysłać tej próby, ponieważ przekroczyłeś maksymalną liczbę prób.';
$string['addon.mod_scorm.scormstatusnotdownloaded'] = 'Ten pakiet SCORM nie jest pobrany. Zostanie on automatycznie pobrany, kiedy go otworzysz.';
$string['addon.mod_scorm.scormstatusoutdated'] = 'Ten pakiet SCORM został zmieniony od ostatniego pobrania. Zostanie on automatycznie pobrany, kiedy go otworzysz.';
$string['addon.mod_scorm.warningofflinedatadeleted'] = 'Niektóre dane offline z próby nr {{number}} zostały odrzucone, ponieważ nie mogła być ona zaliczona jako nowa próba.';
$string['addon.mod_scorm.warningsynconlineincomplete'] = 'Niektóre próby nie zostały zsynchronizowane ze stroną, ponieważ ostatnia próba online nie została jeszcze ukończona. Ukończ najpierw próbę online.';
$string['addon.mod_survey.cannotsubmitsurvey'] = 'Wystąpił problem podczas wysyłania ankiety. Spróbuj ponownie.';
$string['addon.mod_survey.errorgetsurvey'] = 'Błąd pobierania danych ankiety.';
$string['addon.mod_survey.results'] = 'Wyniki';
$string['addon.mod_url.accessurl'] = 'Przejdź do adresu URL';
$string['addon.mod_url.pointingtourl'] = 'Adres URL zasobu:';
$string['addon.mod_wiki.errorloadingpage'] = 'Wystąpił błąd podczas ładowania strony.';
$string['addon.mod_wiki.errornowikiavailable'] = 'Wiki nie ma jeszcze żadnej zawartości.';
$string['addon.mod_wiki.gowikihome'] = 'Przejdź do pierwszej strony wiki';
$string['addon.mod_wiki.titleshouldnotbeempty'] = 'Tytuł nie powinien być pusty';
$string['addon.mod_wiki.viewpage'] = 'Zobacz stronę';
$string['addon.mod_wiki.wikipage'] = 'Strona wiki';
$string['addon.mod_workshop.assessmentstrategynotsupported'] = 'Strategia oceniania {{$a}} nie jest obsługiwana';
$string['addon.mod_workshop.submissionrequiredtitle'] = 'Musisz podać tytuł.';
$string['addon.mod_workshop.warningassessmentmodified'] = 'Praca została zmieniona na stronie.';
$string['addon.mod_workshop.warningsubmissionmodified'] = 'Recenzja została zmieniona na stronie.';
$string['addon.notes.warningnotenotsent'] = 'Nie udało się dodać notatki do kursu {{course}}. {{error}}';
$string['addon.notifications.allownotifications'] = 'Zezwalaj na powiadomienia';
$string['addon.notifications.errorgetnotifications'] = 'Błąd pobierania powiadomień.';
$string['addon.notifications.notifications'] = 'Powiadomienia';
$string['addon.notifications.playsound'] = 'Odtwórz dźwięk';
$string['addon.notifications.therearentnotificationsyet'] = 'Brak powiadomień.';
$string['addon.notifications.typeofnotification'] = 'Rodzaj powiadomienia';
$string['addon.privatefiles.couldnotloadfiles'] = 'Nie można załadować listy plików.';
$string['addon.privatefiles.emptyfilelist'] = 'Brak plików do wyświetlenia.';
$string['addon.privatefiles.erroruploadnotworking'] = 'Niestety obecnie nie można przesyłać plików do Twojej witryny.';
$string['addon.storagemanager.confirmdeleteallsitedata'] = 'Usunąć wszystkie dane pobrane z witryny?';
$string['addon.storagemanager.confirmdeletecourses'] = 'Usunąć pobrane dane ze wszystkich kursów?';
$string['addon.storagemanager.confirmdeletedatafrom'] = 'Usunąć wszystkie pobrane dane z „{{name}}”?';
$string['addon.storagemanager.coursedownloads'] = 'Pliki kursu do pobrania';
$string['addon.storagemanager.courseinfo'] = 'Pobierz zawartość kursu, aby pracować w trybie offline. Twoja aktywność zostanie automatycznie zsynchronizowana, gdy urządzenie znów będzie online.';
$string['addon.storagemanager.deleteallsitedata'] = 'Usuń wszystkie dane pobrane z witryny';
$string['addon.storagemanager.deleteallsitedatainfo'] = 'Spowoduje to usunięcie wszystkich pobranych danych z „{{name}}”, w tym wszystkich pobranych kursów i danych, które umożliwiają pracę w trybie offline.';
$string['addon.storagemanager.deletecourses'] = 'Usuń dane kursów';
$string['addon.storagemanager.deletedata'] = 'Usuń pobrane dane';
$string['addon.storagemanager.deletedatafrom'] = 'Usuń dane z {{name}}';
$string['addon.storagemanager.downloadedcourses'] = 'Pobrane kursy';
$string['addon.storagemanager.downloads'] = 'Pliki do pobrania';
$string['addon.storagemanager.errordeletedownloadeddata'] = 'Podczas usuwania pobranych danych wystąpił błąd.';
$string['addon.storagemanager.managedownloads'] = 'Zarządzaj pobieraniem';
$string['addon.storagemanager.totaldownloads'] = 'Całkowita liczba pobrań';
$string['addon.storagemanager.totalspaceusage'] = 'Całkowita wykorzystana przestrzeń';
$string['appstoredescription'] = 'UWAGA: to jest oficjalna aplikacja mobilna Moodle, która współpracuje TYLKO z tymi stronami Moodle, których konfiguracja na to zezwala. Skontaktuj się z administratorem Twojej strony Moodle, jeśli masz problemy z połączeniem.

Jeśli Twoja strona Moodle jest skonfigurowana poprawnie, możesz korzystać z tej aplikacji, żeby:
* przeglądać zawartość Twoich kursów, nawet w trybie offline,
* otrzymywać natychmiastowe powiadomienia o wiadomościach i innych zdarzeniach,
* szybko znajdować i kontaktować się z innymi uczestnikami Twoich kursów,
* przesyłać obrazy, dźwięk, wideo i inne pliki z Twojego urządzenia mobilnego,
* przeglądać swoje oceny z kursów,
* i wiele więcej!

Odwiedź http://docs.moodle.org/en/Mobile_app w celu zapoznania się z aktualnościami.

Naprawdę doceniamy wszelkie dobre opinie o funkcjonalności
i Wasze sugestie, co aplikacja powinna jeszcze umożliwiać!

Aplikacja wymaga następujących uprawnień:
* nagrywanie dźwięku - w celu nagrywania dźwięku, który ma być przesłany do Moodle,
* odczytywanie i modyfikowanie zawartości karty SD - zawartość jest pobierana na kartę SD, tak abyś mógł przeglądać ją offline,
* dostęp do sieci - w celu połączenia z Twoją stroną Moodle,
* uruchamianie podczas włączania urządzenia - w celu otrzymywania powiadomień, nawet gdy aplikacja działa w tle,
* zapobieganie przejściu urządzenia w stan uśpienia - w celu otrzymywania powiadomień push o każdej porze.';
$string['assets.mimetypes.application/vnd.google-apps.audio'] = 'Dźwięk z Dysku Google';
$string['assets.mimetypes.application/vnd.google-apps.document'] = 'Dokumenty Google';
$string['assets.mimetypes.application/vnd.google-apps.drawing'] = 'Rysunek Google';
$string['assets.mimetypes.application/vnd.google-apps.file'] = 'Plik Dysku Google';
$string['assets.mimetypes.application/vnd.google-apps.folder'] = 'folder Dysku Google';
$string['assets.mimetypes.application/vnd.google-apps.form'] = 'Formularze Google';
$string['assets.mimetypes.application/vnd.google-apps.fusiontable'] = 'Google Fusion Tables';
$string['assets.mimetypes.application/vnd.google-apps.presentation'] = 'Prezentacje Google';
$string['assets.mimetypes.application/vnd.google-apps.script'] = 'Skrypty Aplikacji Google';
$string['assets.mimetypes.application/vnd.google-apps.site'] = 'Witryny Google';
$string['assets.mimetypes.application/vnd.google-apps.spreadsheet'] = 'Arkusze Google';
$string['assets.mimetypes.application/vnd.google-apps.video'] = 'Film z Dysku Google';
$string['core.ajaxendpointnotfound'] = 'Nie znaleziono punktu końcowego AJAX. Może się to zdarzyć, jeśli witryna Moodle jest zbyt stara lub blokuje dostęp do tego punktu końcowego. Aplikacja Moodle obsługuje tylko systemy Moodle od wersji {{$a}}.';
$string['core.browser'] = 'Przeglądarka';
$string['core.calculating'] = 'Obliczanie';
$string['core.cannotconnect'] = 'Nie można się połączyć';
$string['core.cannotdownloadfiles'] = 'Pobieranie plików jest wyłączone. Skontaktuj się z administratorem strony.';
$string['core.cannotinstallapk'] = 'Nie można zainstalować plików .apk';
$string['core.cannotinstallapkinfo'] = 'Ze względów bezpieczeństwa nie możesz instalować nieznanych aplikacji na swoim urządzeniu z tej aplikacji. Jeśli nadal chcesz kontynuować instalację, musisz otworzyć ją w przeglądarce.';
$string['core.cannotlogoutpageblocks'] = 'Zapisz lub odrzuć zmiany przed kontynuowaniem.';
$string['core.cannotopeninapp'] = 'Ten plik może nie działać na tym urządzeniu. Czy nadal chcesz go otworzyć?';
$string['core.cannotopeninappdownload'] = 'Ten plik może nie działać na tym urządzeniu. Czy nadal chcesz go pobrać?';
$string['core.captureaudio'] = 'Zapisz audio';
$string['core.capturedimage'] = 'Zrobione zdjęcie.';
$string['core.captureimage'] = 'Zrób zdjęcie';
$string['core.capturevideo'] = 'Nagraj wideo';
$string['core.certificaterror'] = 'Twoje urządzenie nie może zaufać certyfikatowi tej witryny: {{details}}';
$string['core.clearsearch'] = 'Wyczyść wyszukiwanie';
$string['core.clearstoreddata'] = 'Wyczyść pamięć {{$a}}';
$string['core.clicktoseefull'] = 'Kliknij, aby zobaczyć pełną zawartość.';
$string['core.comments.commentsnotworking'] = 'Nie można pobrać komentarzy';
$string['core.comments.warningcommentsnotsent'] = 'Nie udało się zsynchronizować komentarzy. {{error}}';
$string['core.confirmcanceledit'] = 'Czy na pewno chcesz opuścić tę stronę? Wszystkie zmiany zostaną utracone.';
$string['core.confirmleaveunknownchanges'] = 'Czy na pewno chcesz opuścić tę stronę? Jeśli nie zapisałeś zmian, zostaną one utracone.';
$string['core.confirmloss'] = 'Jesteś pewny? Wszystkie zmiany zostaną utracone.';
$string['core.confirmopeninbrowser'] = 'Czy chcesz to otworzyć w przeglądarce?';
$string['core.connectionlost'] = 'Utracono połączenie z witryną';
$string['core.contactsupport'] = 'Skontaktuj się z pomocą techniczną';
$string['core.contenteditingsynced'] = 'Zawartość, którą edytujesz została zsynchronizowana.';
$string['core.contentlinks.chooseaccount'] = 'Wybierz konto';
$string['core.contentlinks.chooseaccounttoopenlink'] = 'Wybierz konto, z którego otworzyć link.';
$string['core.contentlinks.confirmurlothersite'] = 'Ten link należy do innej strony. Czy chcesz go otworzyć?';
$string['core.contentlinks.errornoactions'] = 'Nie udało się znaleźć czynności do wykonania z tym linkiem.';
$string['core.contentlinks.errornosites'] = 'Nie znaleziono strony do obsługi tego linku.';
$string['core.contentlinks.errorredirectothersite'] = 'Adres URL przekierowania nie może wskazywać na inną stronę.';
$string['core.copiedtoclipboard'] = 'Tekst skopiowano do schowka';
$string['core.copytoclipboard'] = 'Kopiuj do schowka';
$string['core.course.activitydisabled'] = 'Twoja organizacja wyłączyła tę aktywność w aplikacji mobilnej.';
$string['core.course.activitynotyetviewableremoteaddon'] = 'Twoja organizacja zainstalowała plugin, który nie jest jeszcze obsługiwany.';
$string['core.course.allsections'] = 'Wszystkie sekcje';
$string['core.course.aria:sectionprogress'] = 'Postęp w sekcji:';
$string['core.course.availablespace'] = 'Obecnie masz około {{available}} wolnego miejsca.';
$string['core.course.cannotdeletewhiledownloading'] = 'Pliki nie mogą być usunięte podczas pobierania aktywności. Poczekaj na ukończenie pobierania.';
$string['core.course.confirmdownload'] = 'Zamierzasz pobrać {{size}}.{{availableSpace}} Czy chcesz kontynuować?';
$string['core.course.confirmdownloadunknownsize'] = 'Nie udało się obliczyć rozmiaru plików do pobrania.{{availableSpace}} Czy chcesz kontynuować?';
$string['core.course.confirmdownloadzerosize'] = 'Zamierzasz rozpocząć pobieranie.{{availableSpace}} Czy chcesz kontynuować?';
$string['core.course.confirmlimiteddownload'] = 'Nie jesteś obecnie połączony z Wi-Fi.';
$string['core.course.confirmpartialdownloadsize'] = 'Zamierzasz pobrać <strong>co najmniej</strong> {{size}}.{{availableSpace}} Czy chcesz kontynuować?';
$string['core.course.couldnotloadsectioncontent'] = 'Nie udało się załadować zawartości sekcji. Spróbuj ponownie później.';
$string['core.course.couldnotloadsections'] = 'Nie udało się załadować sekcji. Spróbuj ponownie później.';
$string['core.course.downloadcoursesprogressdescription'] = 'Pobieranie kursów: pobrano {{count}} z {{total}}.';
$string['core.course.downloadsectionprogressdescription'] = 'Sekcja pobierania: pobrano {{count}} z {{total}}.';
$string['core.course.errordownloadingcourse'] = 'Błąd pobierania kursu.';
$string['core.course.errordownloadingsection'] = 'Błąd pobierania sekcji.';
$string['core.course.errorgetmodule'] = 'Błąd pobierania danych aktywności.';
$string['core.course.insufficientavailablequota'] = 'Twoje urządzenie nie może przydzielić miejsca, aby zapisać zawartość do pobrania. Może rezerwować miejsce dla aplikacji lub aktualizacji systemu. Proszę najpierw zwolnić miejsce w pamięci.';
$string['core.course.insufficientavailablespace'] = 'Próbujesz pobrać {{size}}. Spowoduje to, że na Twoim urządzeniu zostanie ilość miejsca w pamięci niewystarczająca do prawidłowego działania. Proszę najpierw zwolnić miejsce w pamięci.';
$string['core.course.lastaccessedactivity'] = 'Ostatni dostęp do aktywności';
$string['core.course.manualcompletionnotsynced'] = 'Ręczne ukończenie niezsynchronizowane.';
$string['core.course.modulenotfound'] = 'Nie znaleziono zasobu lub działania. Upewnij się, że jesteś online i nadal jest dostępny.';
$string['core.course.nextactivity'] = 'Następna czynność';
$string['core.course.nextactivitynotfound'] = 'Nie znaleziono następnej aktywności. Możliwe, że została ukryta lub usunięta.';
$string['core.course.nocontentavailable'] = 'Aktualnie brak dostępnej zawartości.';
$string['core.course.previousactivity'] = 'Poprzednia aktywność';
$string['core.course.previousactivitynotfound'] = 'Nie znaleziono poprzedniej aktywności. Możliwe, że została ukryta lub usunięta.';
$string['core.course.refreshcourse'] = 'Odśwież kurs';
$string['core.course.useactivityonbrowser'] = 'Możesz nadal korzystać z tej aktywności w przeglądarce internetowej na Twoim urządzeniu.';
$string['core.course.warningmanualcompletionmodified'] = 'Ręczne ukończenie aktywności zostało zmienione na stronie.';
$string['core.course.warningofflinemanualcompletiondeleted'] = 'Niektóre ręczne ukończenia offline z kursu \'{{name}}\' zostały usunięte. {{error}}';
$string['core.coursenogroups'] = 'Nie jesteś członkiem żadnej grupy na tym kursie.';
$string['core.courses.browserenrolinstructions'] = 'Przeniesiemy Cię do przeglądarki Twojego urządzenia. Po zakończeniu rejestracji wróć do tej aplikacji.';
$string['core.courses.cannotretrievemorecategories'] = 'Nie można pobrać kategorii głębszych niż poziom {{$a}}.';
$string['core.courses.completeenrolmentbrowser'] = 'Dokończ rejestrację w przeglądarce';
$string['core.courses.downloadcourses'] = 'Pobierz kursy';
$string['core.courses.enrolme'] = 'Zapisz mnie';
$string['core.courses.errorloadcategories'] = 'Wystąpił błąd podczas ładowania kategorii.';
$string['core.courses.errorloadcourses'] = 'Wystąpił błąd podczas ładowania kursu.';
$string['core.courses.errorloadplugins'] = 'Wtyczki wymagane przez ten kurs nie zostały poprawnie załadowane. Uruchom ponownie aplikację, aby załadować ponownie wtyczki.';
$string['core.courses.errorsearching'] = 'Wystąpił błąd podczas wyszukiwania.';
$string['core.courses.filtermycourses'] = 'Filtruj moje kursy';
$string['core.courses.notenrollable'] = 'Nie możesz zapisać się samodzielnie na ten kurs.';
$string['core.courses.otherenrolments'] = 'Inne zapisy';
$string['core.courses.password'] = 'Klucz dostępu';
$string['core.courses.refreshcourses'] = 'Odśwież kursy';
$string['core.courses.searchcoursesadvice'] = 'Możesz użyć przycisku wyszukiwania, aby znaleźć kursy z dostępem jako gość lub zapisać się samodzielnie na kursy, które to umożliwiają.';
$string['core.courses.showonlyenrolled'] = 'Pokaż tylko moje kursy';
$string['core.courses.totalcoursesearchresults'] = 'Łącznie kursów: {{$a}}';
$string['core.currentdevice'] = 'Bieżące urządzenie';
$string['core.datastoredoffline'] = 'Dane zapisano na urządzeniu, ponieważ nie udało się ich wysłać. Zostaną wysłane automatycznie później.';
$string['core.deletedoffline'] = 'Usunięte offline';
$string['core.deleting'] = 'Usuwam';
$string['core.desktop'] = 'Pulpit';
$string['core.dfdaymonthyear'] = 'MM-DD-RRRR';
$string['core.discard'] = 'Odrzuć';
$string['core.dismiss'] = 'Odwołaj';
$string['core.dontshowagain'] = 'Nie pokazuj ponownie.';
$string['core.downloaded'] = 'Pobrane';
$string['core.downloading'] = 'Pobieram';
$string['core.editor.hidetoolbar'] = 'Ukryj pasek narzędzi';
$string['core.editor.toggle'] = 'Przełącz edytor';
$string['core.emptysplit'] = 'Ta strona pozostanie pusta, jeśli lewy panel jest pusty lub się ładuje.';
$string['core.endingtime'] = 'Godzina zakończenia: {{$a}}';
$string['core.errorchangecompletion'] = 'Wystąpił błąd podczas zmiany statusu ukończenia. Spróbuj ponownie.';
$string['core.errorcode'] = 'Kod błędu: {{errorCode}}';
$string['core.errordeletefile'] = 'Błąd usuwania pliku. Spróbuj ponownie.';
$string['core.errordetailshide'] = 'Ukryj szczegóły błędu';
$string['core.errordetailsshow'] = 'Pokaż szczegóły błędu';
$string['core.errordownloading'] = 'Błąd pobierania pliku.';
$string['core.errordownloadingsomefiles'] = 'Błąd podczas pobierania plików. Może brakować niektórych plików.';
$string['core.errorfileexistssamename'] = 'Plik o tej nazwie już istnieje.';
$string['core.errorinvalidform'] = 'Formularz zawiera błędne dane. Sprawdź czy wszystkie wymagane pola są wypełnione i czy dane są poprawne.';
$string['core.errorinvalidresponse'] = 'Otrzymano błędną odpowiedź. Skontaktuj się z administratorem strony, jeśli błąd się powtarza.';
$string['core.errorloadingcontent'] = 'Błąd ładowania zawartości.';
$string['core.errorofflinedisabled'] = 'Przeglądanie offline jest wyłączone na Twojej stronie. Musisz być połączony z Internetem, aby korzystać z aplikacji.';
$string['core.erroropenfiledownloading'] = 'Błąd podczas otwierania pliku: musisz poczekać na zakończenie pobierania.';
$string['core.erroropenfilenoapp'] = 'Błąd otwierania pliku: nie znaleziono aplikacji do otwarcia pliku tego typu.';
$string['core.erroropenfilenoextension'] = 'Błąd otwierania pliku: plik nie ma rozszerzenia.';
$string['core.erroropenpopup'] = 'Ta aktywność próbuje otworzyć wyskakujące okno (pop-up), które nie jest obsługiwane przez aplikację.';
$string['core.errorrenamefile'] = 'Błąd zmiany nazwy pliku. Spróbuj ponownie.';
$string['core.errorsitesupport'] = 'Jeśli problem będzie się powtarzał, skontaktuj się z pomocą techniczną witryny.';
$string['core.errorsomedatanotdownloaded'] = 'Jeśli pobrałeś tę aktywność, zwróć uwagę, że niektóre dane nie zostały pobrane z powodu wydajności i zużycia danych.';
$string['core.errorsomethingwrong'] = 'Coś poszło nie tak. Proszę spróbować ponownie.';
$string['core.errorsync'] = 'Wystąpił błąd podczas synchronizacji. Spróbuj ponownie.';
$string['core.errorsyncblocked'] = '{{$a}} nie może być obecnie sychronizowane z powodu procesu w toku. Spróbuj ponownie później. Jeśli problem się powtarza, uruchom ponownie aplikację.';
$string['core.errorurlschemeinvalidscheme'] = 'Ten adres URL jest przeznaczony do użycia w innej aplikacji: {{$a}}.';
$string['core.errorurlschemeinvalidsite'] = 'Nie można otworzyć adresu URL tej strony w tej aplikacji.';
$string['core.filenameexist'] = 'Nazwa pliku już istnieje: {{$a}}';
$string['core.fileuploader.audio'] = 'Dźwięk';
$string['core.fileuploader.camera'] = 'Aparat';
$string['core.fileuploader.confirmuploadfile'] = 'Zostanie przesłane {{size}}. Czy chcesz kontynuować?';
$string['core.fileuploader.confirmuploadunknownsize'] = 'Nie udało się obliczyć rozmiaru przesyłanych plików. Czy chcesz kontynuować?';
$string['core.fileuploader.discardrecording'] = 'Odrzuć nagranie';
$string['core.fileuploader.errorcapturingaudio'] = 'Błąd podczas nagrywania dźwięku.';
$string['core.fileuploader.errorcapturingimage'] = 'Błąd podczas wykonywania zdjęcia.';
$string['core.fileuploader.errorcapturingvideo'] = 'Błąd przechwytywania wideo.';
$string['core.fileuploader.errorgettingimagealbum'] = 'Błąd podczas pobierania zdjęcia z albumu.';
$string['core.fileuploader.errormustbeonlinetoupload'] = 'Musisz być online, aby przesłać pliki.';
$string['core.fileuploader.errornoapp'] = 'Nie zainstalowano aplikacji koniecznej do wykonania tej czynności.';
$string['core.fileuploader.errorreadingfile'] = 'Błąd odczytu pliku.';
$string['core.fileuploader.errorwhileuploading'] = 'Wystąpił błąd podczas przesyłania pliku.';
$string['core.fileuploader.file'] = 'Plik';
$string['core.fileuploader.fileuploaded'] = 'Plik został przesłany.';
$string['core.fileuploader.maxbytesfile'] = 'Plik {{$a.file}} jest zbyt duży. Maksymalny dozwolony rozmiar przesyłanego pliku to {{$a.size}}.';
$string['core.fileuploader.microphonepermissiondenied'] = 'Odmówiono dostępu do mikrofonu.';
$string['core.fileuploader.microphonepermissionrestricted'] = 'Dostęp do mikrofonu jest ograniczony.';
$string['core.fileuploader.pauserecording'] = 'Wstrzymaj nagrywanie';
$string['core.fileuploader.photoalbums'] = 'Galeria zdjęć';
$string['core.fileuploader.readingfile'] = 'Odczytywanie pliku';
$string['core.fileuploader.readingfileperc'] = 'Odczytywanie pliku: {{$a}}%';
$string['core.fileuploader.resumerecording'] = 'Wznów nagrywanie';
$string['core.fileuploader.selectafile'] = 'Wybierz plik';
$string['core.fileuploader.startrecordinginstructions'] = 'Stuknij, aby rozpocząć nagrywanie';
$string['core.fileuploader.uploadafile'] = 'Prześlij plik';
$string['core.fileuploader.uploading'] = 'Przesyłanie';
$string['core.fileuploader.uploadingperc'] = 'Przesyłanie: {{$a}}%';
$string['core.fileuploader.video'] = 'Wideo';
$string['core.goto'] = 'Przejdź do {{$a}}';
$string['core.h5p.errorgetemail'] = 'Wystąpił problem z uzyskaniem adresu e-mail użytkownika. Sprawdź swoje połączenie z Internetem i spróbuj ponownie.';
$string['core.h5p.offlinedisabled'] = 'Strona nie zezwala na pobieranie pakietów H5P.';
$string['core.h5p.play'] = 'Otwórz H5P';
$string['core.hasdatatosync'] = '{{$a}} zawiera dane offline do synchronizacji.';
$string['core.iframehelp'] = 'Czy ta zawartość nie działa?';
$string['core.image'] = 'Obraz';
$string['core.imageviewer'] = 'Przeglądarka obrazów';
$string['core.ioscookieshelp'] = 'Osadzone treści mogą wymagać plików cookie do działania. Przejdź do ustawień iOS aplikacji, włącz opcję „Zezwól na śledzenie w różnych witrynach” i spróbuj ponownie.';
$string['core.lastdownloaded'] = 'Ostatnio pobrane';
$string['core.lastsync'] = 'Ostatnia synchronizacja';
$string['core.loadmore'] = 'Wczytaj więcej';
$string['core.login.authenticating'] = 'Uwierzytelnianie';
$string['core.login.changepasswordbutton'] = 'Otwórz stronę zmiany hasła';
$string['core.login.changepasswordhelp'] = 'Jeśli masz problem ze zmianą hasła, skontaktuj się z administratorem strony. Są to osoby, które zarządzają Moodle w Twojej organizacji. Jeśli nie wiesz jak się z nimi skontaktować, zapytaj nauczyciela/prowadzącego.';
$string['core.login.changepasswordreconnectinstructions'] = 'Kliknij ten przycisk, aby połączyć się ponownie ze stroną. (Weź pod uwagę, że jeśli nie zmieniłeś hasła pomyślnie, wrócisz do poprzedniego ekranu).';
$string['core.login.changepasswordsupportsubject'] = 'Potrzebujesz pomocy przy zmianie hasła';
$string['core.login.confirmdeletesite'] = 'Czy na pewno chcesz usunąć stronę {{sitename}}?';
$string['core.login.connect'] = 'Połącz!';
$string['core.login.connecttomoodle'] = 'Połącz się z Moodle';
$string['core.login.connecttomoodleapp'] = 'Próbujesz się połączyć ze standardową stroną Moodle. Pobierz standardową aplikację Moodle, aby uzyskać dostęp do tej strony.';
$string['core.login.connecttoworkplaceapp'] = 'Próbujesz się połączyć ze stroną Moodle Workplace. Pobierz aplikację Moodle Workplace, aby uzyskać dostęp do tej strony.';
$string['core.login.credentialsdescription'] = 'Podaj nazwę użytkownika i hasło, aby się zalogować.';
$string['core.login.credentialshelp'] = 'Jeśli masz problemy z zalogowaniem się, spróbuj ponownie później lub skontaktuj się ze szkołą lub organizatorem szkoleń.';
$string['core.login.credentialssupportsubject'] = 'Potrzebujesz pomocy przy logowaniu';
$string['core.login.emailconfirmsentnoemail'] = '<p>Na Twój adres e-mail wysłano wiadomość.</p><p>Zawiera ona prostą instrukcję jak dokończyć rejestrację.</p><p>Jeśli pojawią się trudności, skontaktuj się z administratorem strony.</p>';
$string['core.login.emailnotmatch'] = 'Adresy e-mail się nie zgadzają';
$string['core.login.erroraccesscontrolalloworigin'] = 'Wywołanie cross-origin, które próbujesz wykonać, zostało odrzucone. Sprawdź: https://docs.moodle.org/dev/Moodle_Mobile_development_using_Chrome_or_Chromium';
$string['core.login.errordeletesite'] = 'Wystąpił błąd podczas usuwania strony. Spróbuj ponownie.';
$string['core.login.errorexampleurl'] = 'Adres URL: https://campus.example.edu to tylko przykład, to nie jest prawdziwa strona. <strong>Użyj adresu URL strony Twojej szkoły lub organizacji.</strong>';
$string['core.login.errorqrnoscheme'] = 'Ten adres URL nie jest poprawnym adresem URL logowania.';
$string['core.login.errorupdatesite'] = 'Wystąpił błąd podczas aktualizacji tokenu strony.';
$string['core.login.exceededloginattempts'] = 'Potrzebujesz pomocy przy logowaniu? Spróbuj {{recoverPassword}} lub skontaktuj się z obsługą witryny.';
$string['core.login.exceededloginattemptsrecoverpassword'] = 'odzyskanie hasła';
$string['core.login.exceededloginattemptssupportsubject'] = 'Nie mogę się zalogować';
$string['core.login.exceededloginattemptswithoutpassword'] = 'Potrzebujesz pomocy przy logowaniu? Spróbuj skontaktować się z obsługą witryny.';
$string['core.login.exceededloginattemptswithoutsupport'] = 'Potrzebujesz pomocy przy logowaniu? Spróbuj {{recoverPassword}}.';
$string['core.login.exceededpasswordresetattempts'] = 'Wygląda na to, że masz problemy z dostępem do konta. Możesz skontaktować się ze szkołą lub organizatorem szkolenia albo spróbować ponownie później.';
$string['core.login.exceededpasswordresetattemptssupportsubject'] = 'Nie mogę zresetować hasła';
$string['core.login.faqcannotfindmysiteanswer'] = 'Czy wpisałeś nazwę poprawnie? Możliwe, że Twoja strona nie znajduje się w naszym publicznym katalogu stron. Jeśli nadal nie możesz jej znaleźć, to zamiast nazwy, wpisz adres strony.';
$string['core.login.faqcannotfindmysitequestion'] = 'Nie mogę znaleźć mojej strony.';
$string['core.login.faqsetupsiteanswer'] = 'Odwiedź {{$link}} i sprawdź różne warianty jak założyć własną stronę Moodle.';
$string['core.login.faqsetupsitelinktitle'] = 'Rozpocznij';
$string['core.login.faqsetupsitequestion'] = 'Chcę założyć własną stronę Moodle.';
$string['core.login.faqtestappanswer'] = 'Aby przetestować aplikację na demonstracyjnej stronie Moodle, wpisz "teacher" lub "student" w polu "Twoja strona" i kliknij "Połącz się ze stroną".';
$string['core.login.faqtestappquestion'] = 'Chcę tylko przetestować aplikację. Co mam zrobić?';
$string['core.login.faqwhatisurlanswer'] = '<p>Każda organizacja ma unikalny adres URL dla strony Moodle. Aby znaleźć ten adres:</p><ol><li>Otwórz przeglądarkę internetową i wejdź na stronę logowania Twojej strony Moodle.</li><li>Na górze strony, w pasku adresu, znajdziesz adres URL Twojej strony Moodle, np. "campus.example.edu".<br>{{$image}}</li><li>Skopiuj ten adres (nie kopiuj /login i tego co dalej), wklej w aplikacji Moodle i kliknij "Połącz się ze stroną"</li><li>Następnie możesz się zalogować do strony, używając nazwy użytkownika i hasła.</li>';
$string['core.login.faqwhatisurlquestion'] = 'Jaki jest adres mojej strony? Jak znaleźć adres URL mojej strony?';
$string['core.login.faqwhereisqrcode'] = 'Gdzie znaleźć kod QR?';
$string['core.login.faqwhereisqrcodeanswer'] = '<p>Jeśli Twoja organizacja udostępnia kod QR, znajdziesz go na dole strony Twojego profilu.</p>{{$image}}';
$string['core.login.findyoursite'] = 'Znajdź swoją stronę';
$string['core.login.invalidaccount'] = 'Sprawdź szczegóły swoich danych do logowania lub poproś administratora Twojej strony o sprawdzenie konfiguracji strony.';
$string['core.login.invalidmoodleversion'] = '<p>Niewłaściwa wersja platformy Moodle. Aplikacja mobilna wspiera tylko platformę Moodle w wersji {{$a}} i późniejszych.</p>
<p>Możesz skontaktować się z administratorem i poprosić o aktualizację platformy Moodle.</p>
<p>Administratorzy są osobami, które zarządzają platformą Moodle w twojej organizacji. Jeśli nie wiesz jak się z nimi skontaktować, skontaktuj się ze swoim nauczycielem/wykładowcą/trenerem.</p>';
$string['core.login.invalidsite'] = 'Adres URL strony jest nieprawidłowy.';
$string['core.login.invalidtime'] = 'Niepoprawny czas';
$string['core.login.invalidvaluemax'] = 'Maksymalna wartość to {{$a}}';
$string['core.login.invalidvaluemin'] = 'Minimalna wartość to {{$a}}';
$string['core.login.loginbutton'] = 'Zaloguj się';
$string['core.login.mobileservicesnotenabled'] = 'Dostęp mobilny nie jest włączony na Twojej stronie. Skontaktuj się z administratorem strony, jeśli uważasz, że dostęp mobilny powinien być włączony.';
$string['core.login.notloggedin'] = 'Musisz być zalogowany.';
$string['core.login.onboardingcreatemanagecourses'] = 'Twórz i zarządzaj swoimi kursami';
$string['core.login.onboardingenrolmanagestudents'] = 'Zapisuj i zarządzaj swoimi studentami';
$string['core.login.onboardinggetstarted'] = 'Rozpocznij pracę z Moodle';
$string['core.login.onboardingialreadyhaveasite'] = 'Mam już stronę Moodle';
$string['core.login.onboardingimalearner'] = 'Jestem uczniem';
$string['core.login.onboardingimaneducator'] = 'Jestem nauczycielem';
$string['core.login.onboardingineedasite'] = 'Potrzebuję strony Moodle';
$string['core.login.onboardingprovidefeedback'] = 'Dostarczaj aktualną informację zwrotną';
$string['core.login.onboardingtoconnect'] = 'Aby połączyć się z aplikacją Moodle potrzebujesz strony Moodle';
$string['core.login.onboardingwelcome'] = 'Witaj w aplikacji Moodle!';
$string['core.login.or'] = 'LUB';
$string['core.login.passwordrequired'] = 'Hasło jest wymagane';
$string['core.login.policyacceptmandatory'] = 'Rozumiem i akceptuję obowiązkowe zasady witryny';
$string['core.login.recaptchachallengeimage'] = 'Obrazek zadania reCAPTCHA';
$string['core.login.recaptchaexpired'] = 'Weryfikacja wygasła. Odpowiedz ponownie na pytanie bezpieczeństwa.';
$string['core.login.recaptchaincorrect'] = 'Odpowiedź na pytanie bezpieczeństwa jest nieprawidłowa.';
$string['core.login.reconnect'] = 'Połącz ponownie';
$string['core.login.reconnecthelp'] = 'Jeśli masz problemy z ponownym połączeniem, spróbuj ponownie później lub skontaktuj się ze szkołą lub organizatorem szkolenia.';
$string['core.login.reconnectsupportsubject'] = 'Potrzebujesz pomocy w ponownym połączeniu';
$string['core.login.reconnecttosite'] = 'Połącz się ponownie z witryną';
$string['core.login.removeaccount'] = 'Usuń konto';
$string['core.login.searchby'] = 'Szukaj według:';
$string['core.login.selectsite'] = 'Wybierz Twoją stronę:';
$string['core.login.signupplugindisabled'] = '{{$a}} nie jest włączone.';
$string['core.login.signuprequiredfieldnotsupported'] = 'Formularz rejestracji zawiera wymagane pole, które nie jest obsługiwane przez aplikację. Załóż konto używając przegladarki internetowej.';
$string['core.login.siteaddress'] = 'Twoja strona';
$string['core.login.sitebadgedescription'] = 'Jest {{count}} nieprzeczytanych powiadomień.';
$string['core.login.sitehasredirect'] = 'Twoja strona zawiera co najmniej jedno przekierowanie HTTP. Aplikacja nie obsługuje przekierowań, co może być przyczyną uniemożliwiającą aplikacji połączenie się z Twoją stroną.';
$string['core.login.siteinmaintenance'] = 'Twoja strona jest w trakcie konserwacji';
$string['core.login.sitenotallowed'] = 'Ta witryna nie jest już dostępna.';
$string['core.login.sitepolicynotagreederror'] = 'Brak wyrażonej zgody na politykę strony.';
$string['core.login.siteurl'] = 'Adres URL strony';
$string['core.login.siteurlrequired'] = 'Wymagany adres URL strony, np.:  <i>http://www.twojastronamoodle.pl</i>';
$string['core.login.stillcantconnect'] = 'Nadal nie możesz się połączyć?';
$string['core.login.toggleremove'] = 'Edytuj listę kont';
$string['core.login.usernamerequired'] = 'Nazwa użytkownika jest wymagana';
$string['core.login.visitchangepassword'] = 'Czy chcesz przejść na stronę do zmiany hasła?';
$string['core.login.webservicesnotenabled'] = 'Serwer Twojej strony może nie mieć włączonych usług web service. Skontaktuj się z administratorem strony w celu uzyskania pomocy.';
$string['core.login.youcanstillconnectwithcredentials'] = 'Możesz nadal połączyć się ze stroną wprowadzając nazwę użytkownika i hasło.';
$string['core.login.yourenteredsite'] = 'Połącz się ze stroną';
$string['core.lostconnection'] = 'Twój token uwierzytelniania jest nieważny lub wygasł. Musisz połączyć się ponownie ze stroną.';
$string['core.mainmenu.switchaccount'] = 'Przełącz konto';
$string['core.mainmenu.usermenutourdescription'] = 'Miejsce, w którym możesz sprawdzić swoje oceny, zmienić preferencje lub zmienić konto.';
$string['core.mainmenu.usermenutourtitle'] = 'Poznaj swój osobisty obszar';
$string['core.needhelp'] = 'Potrzebujesz pomocy?';
$string['core.networkerroriframemsg'] = 'Ta treść nie jest dostępna w trybie offline. Połącz się z internetem i spróbuj ponownie.';
$string['core.networkerrormsg'] = 'Wystąpił problem z połączeniem ze stroną. Sprawdź swoje połączenie i spróbuj ponownie.';
$string['core.nooptionavailable'] = 'Brak dostępnej opcji';
$string['core.nopasswordchangeforced'] = 'Nie można kontynuować bez zmiany hasła.';
$string['core.nopermissionerror'] = 'Niestety, nie masz aktualnie uprawnień, aby wykonać tę czynność.';
$string['core.notapplicable'] = 'nd.';
$string['core.notsent'] = 'Niewysłane';
$string['core.nummore'] = '{{$a}} więcej';
$string['core.openfile'] = 'Otwórz plik';
$string['core.openfullimage'] = 'Kliknij tutaj, aby wyświetlić obraz w pełnym rozmiarze';
$string['core.openinbrowser'] = 'Otwórz w przeglądarce';
$string['core.openmodinbrowser'] = 'Otwórz {{$a}} w przeglądarce';
$string['core.opensecurityquestion'] = 'Otwórz pytanie bezpieczeństwa';
$string['core.opensettings'] = 'Otwórz ustawienia';
$string['core.openwith'] = 'Otwórz za pomocą...';
$string['core.play'] = 'Odtwórz';
$string['core.pulltorefresh'] = 'Przeciągnij, aby odświeżyć';
$string['core.qrscanner'] = 'Skaner kodów QR';
$string['core.question.cannotdeterminestatus'] = 'Nie można określić statusu';
$string['core.question.errorattachmentsnotsupportedinsite'] = 'Twoja strona nie obsługuje jeszcze dodawania plików do odpowiedzi.';
$string['core.question.errorembeddedfilesnotsupportedinsite'] = 'Twoja strona nie obsługuje jeszcze edycji osadzonych plików.';
$string['core.question.errorquestionnotsupported'] = 'Pytanie tego typu nie jest obsługiwane przez aplikację: {{$a}}.';
$string['core.question.howtodraganddrop'] = 'Dotknij, aby zaznaczyć, a następnie dotknij, aby upuścić.';
$string['core.question.questionmessage'] = 'Pytanie {{$a}}: {{$b}}';
$string['core.redirectingtosite'] = 'Zostaniesz przekierowany na stronę';
$string['core.reminders.atthetime'] = 'W czasie wydarzenia';
$string['core.reminders.customreminder'] = 'Niestandardowe przypomnienie';
$string['core.reminders.reminderset'] = 'Przypomnienie ustawione na {{$a}}';
$string['core.reminders.reminderunset'] = 'Przypomnienie zostało usunięte';
$string['core.reminders.setareminder'] = 'Ustaw przypomnienie';
$string['core.reminders.setareminderfor'] = 'Ustaw przypomnienie dla „{{title}}” ({{label}})';
$string['core.reminders.setreminder'] = 'Ustaw przypomnienie';
$string['core.reminders.timebefore'] = '{{wartość}} {{jednostki}} przed';
$string['core.reminders.value'] = 'Wartość';
$string['core.removefiles'] = 'Usuń pliki {{$a}}';
$string['core.reportbuilder.filtersapplied'] = 'Do tego widoku mogą być zastosowane filtry. Aby edytować filtry lub zmienić kolejność sortowania, <a href="{{$a}}">otwórz ten raport w przeglądarce.</a>';
$string['core.reportbuilder.hidecolumns'] = 'Ukryj kolumny';
$string['core.reportbuilder.showcolumns'] = 'Pokaż kolumny';
$string['core.requireduserdatamissing'] = 'Użytkownik nie ma niektórych wymaganych danych w profilu. Wprowadź dane na stronie i spróbuj ponownie.<br>{{$a}}';
$string['core.resume'] = 'Wznów';
$string['core.retry'] = 'Ponów próbę';
$string['core.scanqr'] = 'Zeskanuj kod QR';
$string['core.scrollbackward'] = 'Przewiń do tyłu';
$string['core.scrollforward'] = 'Przewiń do przodu';
$string['core.searching'] = 'Szukam';
$string['core.settings.about'] = 'O aplikacji';
$string['core.settings.appsettings'] = 'Ustawienia aplikacji';
$string['core.settings.appversion'] = 'Wersja aplikacji';
$string['core.settings.cannotsyncloggedout'] = 'Nie można zsynchronizować tej strony, ponieważ jesteś wylogowany. Spróbuj ponownie gdy będziesz zalogowany do tej strony.';
$string['core.settings.cannotsyncoffline'] = 'Nie można synchronizować w trybie offline.';
$string['core.settings.cannotsyncwithoutwifi'] = 'Synchronizacja jest niemożliwa, ponieważ aktualne ustawienia pozwalają na synchronizację tylko przy połączeniu Wi-Fi. Połącz się z Wi-Fi.';
$string['core.settings.changelanguage'] = 'Zmień na {{$a}}';
$string['core.settings.changelanguagealert'] = 'Zmiana języka spowoduje ponowne uruchomienie aplikacji.';
$string['core.settings.colorscheme'] = 'Schemat kolorów';
$string['core.settings.colorscheme-dark'] = 'Ciemny';
$string['core.settings.colorscheme-light'] = 'Jasny';
$string['core.settings.colorscheme-system'] = 'Domyślne ustawienie systemowe';
$string['core.settings.colorscheme-system-notice'] = 'Domyślny tryb systemu będzie zależał od obsługiwanego urządzenia.';
$string['core.settings.compilationinfo'] = 'Informacje o kompilacji';
$string['core.settings.connecttosync'] = 'Twoje urządzenie jest offline. Połącz się z Internetem, aby zsynchronizować witryny.';
$string['core.settings.connectwifitosync'] = 'Połącz się z siecią Wi-Fi lub wyłącz Oszczędzanie danych, aby zsynchronizować witryny.';
$string['core.settings.copyinfo'] = 'Skopiuj informacje o urządzeniu do schowka';
$string['core.settings.cordovadevicemodel'] = 'Model urządzenia Cordova';
$string['core.settings.cordovadeviceosversion'] = 'Wersja systemu operacyjnego urządzenia Cordova';
$string['core.settings.cordovadeviceplatform'] = 'Platforma urządzeń Cordova';
$string['core.settings.cordovadeviceuuid'] = 'Identyfikator UUID urządzenia Cordova';
$string['core.settings.cordovaversion'] = 'Wersja Cordova';
$string['core.settings.debugdisplaydescription'] = 'Jeśli włączone, okno komunikatu wyświetli więcej danych o błędzie.';
$string['core.settings.developeroptions'] = 'Opcje programistyczne';
$string['core.settings.deviceinfo'] = 'Informacje o urządzeniu';
$string['core.settings.deviceos'] = 'System operacyjny urządzenia';
$string['core.settings.displayformat'] = 'Format wyświetlania';
$string['core.settings.enabledownloadsection'] = 'Włącz sekcje pobierania';
$string['core.settings.enablerichtexteditor'] = 'Włącz edytor tekstu';
$string['core.settings.enablerichtexteditordescription'] = 'Jeśli włączone, edytor tekstu będzie dostępny przy wprowadzaniu treści.';
$string['core.settings.entriesincache'] = '{{$a}} wpisów w pamięci podręcznej';
$string['core.settings.estimatedfreespace'] = 'Szacunkowa ilość wolnego miejsca';
$string['core.settings.filesystemroot'] = 'Główny plik systemu';
$string['core.settings.fontsize'] = 'Rozmiar tekstu';
$string['core.settings.forcedsetting'] = 'To ustawienie zostało wymuszone przez konfigurację Twojej strony.';
$string['core.settings.helpusimprove'] = 'Pomóż nam ulepszyć tę aplikację';
$string['core.settings.ioscookies'] = 'Śledzenie w wielu witrynach';
$string['core.settings.ioscookiesdescription'] = 'Osadzone treści z witryny mogą wymagać do działania plików cookie między witrynami. Aby ją włączyć, przejdź do ustawień aplikacji iOS i włącz opcję „Zezwól na śledzenie w różnych witrynach”.';
$string['core.settings.localnotifavailable'] = 'Dostępne powiadomienia lokalne';
$string['core.settings.locationhref'] = 'Adres URL widoku internetowego';
$string['core.settings.logintosync'] = 'Zaloguj się, aby przeprowadzić synchronizację';
$string['core.settings.navigatorlanguage'] = 'Język nawigatora';
$string['core.settings.networkstatus'] = 'Status połączenia z Internetem';
$string['core.settings.opensourcelicenses'] = 'Licencje Open Source';
$string['core.settings.privacypolicy'] = 'Polityka prywatności';
$string['core.settings.publisher'] = 'Wydawca';
$string['core.settings.pushid'] = 'Identyfikator powiadomień push';
$string['core.settings.reportinbackground'] = 'Raportuj błędy automatycznie';
$string['core.settings.screen'] = 'Informacje o ekranie';
$string['core.settings.showdownloadoptions'] = 'Pokaż opcje pobierania';
$string['core.settings.siteinfo'] = 'Informacje o stronie';
$string['core.settings.sitesyncfailed'] = 'Synchronizacja witryny nie powiodła się';
$string['core.settings.spaceusage'] = 'Wykorzystanie pamięci';
$string['core.settings.syncdatasaver'] = 'Oszczędzanie danych: Synchronizuj tylko podczas połączenia Wi-Fi';
$string['core.settings.synchronization'] = 'Synchronizacja';
$string['core.settings.synchronizenow'] = 'Synchronizuj teraz';
$string['core.settings.synchronizenowhelp'] = 'Synchronizacja serwisów wyśle oczekujące zmiany, wszystkie aktywności offline przechowywane na urządzeniu i zsynchronizuje dane typu wiadomości i powiadomienia.';
$string['core.settings.syncsettings'] = 'Ustawienia synchronizacji';
$string['core.settings.wificonnection'] = 'Połączenie Wi-Fi';
$string['core.sharedfiles.chooseaccountstorefile'] = 'Wybierz konto do przechowywania pliku.';
$string['core.sharedfiles.chooseactionrepeatedfile'] = 'Plik o tej nazwie już istnieje. Czy chcesz zastąpić istniejący plik lub zmienić jego nazwę na "{{$a}}"?';
$string['core.sharedfiles.errorreceivefilenosites'] = 'Brak zapisanych stron. Dodaj stronę przed współdzieleniem pliku przez aplikację.';
$string['core.sharedfiles.nosharedfiles'] = 'Brak współdzielonych plików na tej stronie.';
$string['core.sharedfiles.nosharedfilestoupload'] = 'Nie masz plików do przesłania w tym miejscu. Jeśli chcesz przesłać plik z innej aplikacji, znajdź plik i kliknij przycisk "Otwórz w".';
$string['core.sharedfiles.rename'] = 'Zmień nazwę';
$string['core.sharedfiles.replace'] = 'Zastąp';
$string['core.sharedfiles.sharedfiles'] = 'Współdzielone pliki';
$string['core.sharedfiles.successstorefile'] = 'Plik został pomyślnie zapisany. Wybierz plik, który chcesz przesłać do swoich prywatnych plików lub użyć w wybranej aktywności.';
$string['core.sitenotfoundhelp'] = 'Nie możemy znaleźć podanej witryny. Sprawdź literówki lub spróbuj ponownie później. Jeśli nadal widzisz ten komunikat, skontaktuj się ze szkołą lub dostawcą usług edukacyjnych.';
$string['core.sorry'] = 'Przepraszam...';
$string['core.start'] = 'Start';
$string['core.storingfiles'] = 'Zapisuję pliki';
$string['core.swipenavigationtourdescription'] = 'Przesuń palcem w lewo i w prawo, aby się poruszać.';
$string['core.tablet'] = 'Tablet';
$string['core.tag.errorareanotsupported'] = 'Ten obszar tagów nie jest obsługiwany przez aplikację.';
$string['core.tag.warningareasnotsupported'] = 'Niektóre obszary tagów nie są wyświetlane, ponieważ nie są obsługiwane przez aplikację.';
$string['core.thereisdatatosync'] = 'Istnieje offline {{$a}} do synchronizacji.';
$string['core.toggledelete'] = 'Przełącz przyciski usuwania';
$string['core.tryagain'] = 'Spróbuj ponownie';
$string['core.uhoh'] = 'O nie!';
$string['core.unexpectederror'] = 'Wystąpił nieoczekiwany błąd. Zamknij i uruchom ponownie aplikację, a następnie ponów próbę.';
$string['core.unicodenotsupported'] = 'Niektóre emoji nie są obsługiwane na tej stronie. Zostaną one usunięte przy wysyłaniu wiadomości.';
$string['core.unicodenotsupportedcleanerror'] = 'Znaleziono pusty tekst podczas oczyszczania znaków Unicode.';
$string['core.unknown'] = 'Nieznane';
$string['core.unzipping'] = 'Rozpakowuję';
$string['core.updaterequired'] = 'Aplikacja wymaga aktualizacji';
$string['core.updaterequireddesc'] = 'Zaktualizuj aplikację do wersji {{$a}}';
$string['core.user.completeprofile'] = 'Pełny profil';
$string['core.user.completeprofilehelp'] = 'Jeśli masz problemy z uzupełnieniem profilu, spróbuj ponownie później lub skontaktuj się ze szkołą lub dostawcą usług edukacyjnych.';
$string['core.user.completeprofilenotice'] = 'Zanim przejdziesz dalej, wypełnij wymagane pola w swoim profilu użytkownika.';
$string['core.user.completeprofilereconnectinstructions'] = 'Jeśli nie uzupełniłeś swojego profilu poprawnie, zostaniesz poproszony o zrobienie tego ponownie.';
$string['core.user.completeprofilesupportsubject'] = 'Potrzebuję pomocy w uzupełnieniu mojego profilu';
$string['core.user.completeyourprofile'] = 'Uzupełnij swój profil';
$string['core.user.contact'] = 'Kontakt';
$string['core.user.detailsnotavailable'] = 'Szczegóły tego użytkownika są dla Ciebie niedostępne.';
$string['core.user.errorloaduser'] = 'Błąd wczytywania użytkownika.';
$string['core.user.sendemail'] = 'E-mail';
$string['core.user.support'] = 'Skontaktuj się z pomocą techniczną witryny';
$string['core.usernologin'] = 'Uwierzytelnianie dla tego konta zostało unieważnione';
$string['core.viewcode'] = 'Wyświetl kod';
$string['core.vieweditor'] = 'Wyświetl edytor';
$string['core.viewembeddedcontent'] = 'Wyświetl osadzoną zawartość';
$string['core.wanttochangesite'] = 'Chcesz zmienić strony lub się wylogować?';
$string['core.warningofflinedatadeleted'] = 'Dane offline z {{component}} \'{{name}}\' zostały usunięte. {{error}}';
$string['core.warningofflinedatadeletedreason'] = 'Nowsze zmiany w tym działaniu zostały wprowadzone z innego urządzenia.';
$string['core.whyisthishappening'] = 'Dlaczego tak się dzieje?';
$string['core.wsfunctionnotavailable'] = 'Funkcja web service jest niedostępna.';
$string['core.youreoffline'] = 'Jesteś offline';
$string['core.youreonline'] = 'Jesteś ponownie online';
$string['core.zoomin'] = 'Zbliżenie';
$string['core.zoomout'] = 'Oddal';
$string['freemium.biometriclogin'] = 'Logowanie biometryczne';
$string['freemium.biometriclogindescription'] = 'Połóż palec na czytniku linii papilarnych.';
$string['freemium.biometricloginenablefaceid'] = 'Włącz FaceID';
$string['freemium.biometricloginenabletouchid'] = 'Włącz TouchID';
$string['freemium.biometricloginloginwithfaceid'] = 'Zaloguj się za pomocą FaceID';
$string['freemium.biometricloginloginwithfingerprint'] = 'Zaloguj się za pomocą odcisku palca';
$string['freemium.biometricloginloginwithtouchid'] = 'Zaloguj się za pomocą TouchID';
$string['freemium.biometricloginskip'] = 'Pomiń to na razie';
$string['freemium.biometricloginturnoff'] = 'Możesz włączyć i wyłączyć tę funkcję w dowolnym momencie w ustawieniach.';
$string['freemium.biometriclogintypefaceid'] = 'FaceID';
$string['freemium.biometriclogintypetouchid'] = 'TouchID';
$string['freemium.biometricloginwithfingerorface'] = 'Użyj logowania biometrycznego za pomocą odcisku palca lub twarzy.';
$string['freemium.change'] = 'Zmiana';
$string['freemium.downloadmainapplicationrequired'] = 'Możesz połączyć się z tą witryną tylko za pomocą dedykowanej aplikacji.';
$string['freemium.downloadmainapplicationsuggestion'] = 'Witryna, z którą próbujesz się połączyć, ma dedykowaną aplikację, którą możesz wypróbować.';
$string['freemium.feature_biometriclogin'] = 'Logowanie biometryczne';
$string['freemium.feature_coursesdownload'] = 'Pobrane kursy';
$string['freemium.feature_multimediapushnotifications'] = 'Multimedialne powiadomienia push';
$string['freemium.feature_pushnotificationsdevices'] = 'Urządzenia powiadomień push';
$string['freemium.feature_qrlogin'] = 'Uwierzytelnij za pomocą kodu QR';
$string['freemium.feature_remotethemes'] = 'Zdalne motywy';
$string['freemium.feature_sitelogo'] = 'Logo witryny';
$string['freemium.notallowed'] = 'Niedozwolone';
$string['freemium.nottoday'] = 'Nie dzisiaj';
$string['freemium.qrloginexpiredkey'] = 'Kod QR wygasł. Odśwież stronę z kodem QR i zeskanuj ją ponownie.';
$string['freemium.ratetheapp'] = 'Czy podoba Ci się nasza aplikacja?';
$string['freemium.ratetheapp_feedbackko'] = 'Powiedz nam, co poszło nie tak';
$string['freemium.ratetheapp_feedbackmessage'] = 'Twoja opinia będzie anonimowa';
$string['freemium.ratetheapp_feedbackok'] = 'Wyślij opinię';
$string['freemium.ratetheapp_feedbackplaceholder'] = 'Napisz coś tutaj';
$string['freemium.ratetheapp_feedbacksent'] = 'Dzięki! Twoja opinia została pomyślnie wysłana.';
$string['freemium.ratetheapp_sendtostore'] = 'Czy możesz poświęcić chwilę, aby ocenić naszą aplikację? Pomoże nam to ulepszyć aplikację.';
$string['freemium.remindmelater'] = 'Przypomnij mi później';
$string['freemium.settingsoptionsfacial'] = 'Włącz logowanie za pomocą twarzy';
$string['freemium.settingsoptionsfingerprint'] = 'Włącz logowanie odciskiem palca';
$string['freemium.subscription'] = 'Subskrypcja witryny';
$string['freemium.subscriptiondetails'] = 'Szczegóły subskrypcji';
$string['freemium.subscriptionfeature_exceeded_remotethemes'] = 'Twój niestandardowy motyw nie jest stosowany';
$string['freemium.subscriptionfeature_exceeded_sitelogo'] = 'Twoje logo witryny nie jest stosowane';
$string['freemium.subscriptionfeature_unlimited'] = 'Nieograniczony';
$string['freemium.subscriptionplan'] = 'Abonament';
$string['freemium.subscriptionplan_expired'] = 'wygasły';
$string['freemium.subscriptionplan_free'] = 'Bezpłatny';
$string['freemium.subscriptionplan_upgrade'] = 'Ulepsz swój plan';
$string['freemium.subscriptionplandescription'] = 'Plany subskrypcji wskazują, jakie ograniczenia mają zastosowanie do tej witryny.';
$string['freemium.subscriptionplanlearnmore'] = 'Dowiedz się więcej';
$string['freemium.upsell_renewexpired'] = 'Twoja subskrypcja wygasła';
$string['freemium.upsell_renewtitle'] = 'Odnów subskrypcję';
$string['freemium.upsell_upgradefreeaccept'] = 'Ulepsz';
$string['freemium.upsell_upgradefreemessage'] = 'Obecnie korzystasz z bezpłatnego planu, ulepsz, aby odblokować więcej funkcji.';
$string['freemium.upsell_upgradefreepostpone'] = 'Później';
$string['freemium.upsell_upgradefreetitle'] = 'Ulepsz swój plan';
$string['pluginname'] = 'Tłumaczenia dla aplikacji mobilnej Moodle';
$string['privacy_metadata'] = 'Ta wtyczka nie przechowuje żadnych danych użytkownika.';
