<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'quiz', language 'zh_cn', version '5.0'.
 *
 * @package     quiz
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['accessnoticesheader'] = '您可以预览此测验，但如果想真正试答，您会被阻止，因为：';
$string['action'] = '操作';
$string['activityoverview'] = '您有到期的测验';
$string['adaptive'] = '自适应模式';
$string['adaptive_help'] = '如果启用，在同一次试答中，可以多次回答同一道题。例如，如果回答错误，学生可以马上再试。不过，根据“使用罚分”设置，每次错误的回答都会被罚分。';
$string['add'] = '添加';
$string['addaquestion'] = '一道题';
$string['addarandomquestion'] = '一道随机题';
$string['addarandomquestion_help'] = '添加随机题，会从类别中随机选出一道题插入到测验中。也就是说，不同学生可能会得到不同的试题。如果测验允许多次试答，那么每次试答都可能会得到不同的试题。';
$string['addarandomquestion_success'] = '添加了随机问题';
$string['addarandomselectedquestion'] = '添加一道随机选择题...';
$string['addasection'] = '一个新的小节标题';
$string['adddescriptionlabel'] = '添加描述项';
$string['addingquestion'] = '添加一道题';
$string['addingquestions'] = '<p>页面的一边用来管理题库。试题分门别类，以便管理。题库中的试题可用于您课程中的任何测验。如果您选择“公布”它们，则任何课程都可以使用这些试题。</p>
<p>您选择或创建试题类别后将能创建或编辑试题。您可以选择任何试题添加到另一边的测验中。</p>';
$string['addmoreoverallfeedbacks'] = '再添加{no}个反馈字段';
$string['addnewgroupoverride'] = '添加小组覆盖';
$string['addnewpagesafterselected'] = '在选定试题后添加新页面';
$string['addnewquestionsqbank'] = '添加试题到类别 {$a->catname}: {$a->link}';
$string['addnewuseroverride'] = '添加用户覆盖';
$string['addpagebreak'] = '添加分页符';
$string['addpagehere'] = '在此处添加页面';
$string['addquestion'] = '添加试题';
$string['addquestionfrombankatend'] = '从题库添加到末尾';
$string['addquestionfrombanktopage'] = '从题库添加到页面 {$a}';
$string['addquestions'] = '添加试题';
$string['addquestionstoquiz'] = '添加试题到当前测验';
$string['addrandom'] = '添加 {$a} 道随机题';
$string['addrandom1'] = '<< 添加';
$string['addrandom2'] = '随机题';
$string['addrandomfromcategory'] = '从类别添加随机题：';
$string['addrandomquestion'] = '添加随机题';
$string['addrandomquestionatend'] = '添加一道随机题到末尾';
$string['addrandomquestiontopage'] = '添加一道随机题到页面{$a}';
$string['addrandomquestiontoquiz'] = '添加一道随机题到测验{$a}';
$string['addselectedquestionstoquiz'] = '添加选定的试题到测验';
$string['addselectedtoquiz'] = '添加选定的到测验';
$string['addtoquiz'] = '添加到测验';
$string['affectedstudents'] = '影响 {$a}';
$string['aftereachquestion'] = '添加每道题后';
$string['afternquestions'] = '添加 {$a} 道题后';
$string['age'] = '年龄';
$string['allattempts'] = '所有试答';
$string['allinone'] = '无限制';
$string['allowreview'] = '允许回顾';
$string['alreadysubmitted'] = '您可能已经提交了此次试答';
$string['alternativeunits'] = '可选单位';
$string['alwaysavailable'] = '始终可用';
$string['alwayslatest'] = '总是最新的';
$string['analysisoptions'] = '分析选项';
$string['analysistitle'] = '项目分析表';
$string['answer'] = '答案';
$string['answered'] = '已作答';
$string['answerhowmany'] = '一个或多个答案？';
$string['answers'] = '答案';
$string['answersingleno'] = '允许多个答案';
$string['answersingleyes'] = '只有一个答案';
$string['answertoolong'] = '{$a}行后的答案过长（最多255个字符）';
$string['anytags'] = '任何标签';
$string['aon'] = 'AON 格式';
$string['areyousureremoveselected'] = '您确定要移除所有选定的试题吗?';
$string['asshownoneditscreen'] = '如编辑屏幕所示';
$string['attempt'] = '试答 {$a}';
$string['attemptalreadyclosed'] = '此次试答已经结束。';
$string['attemptclosed'] = '试答还未关闭';
$string['attemptduration'] = '考试时长';
$string['attemptedon'] = '试答于';
$string['attempterror'] = '您目前不能试答此测验，因为：{$a}';
$string['attempterrorcontentchange'] = '此测验预览不再存在。(当测验被编辑，任何进行中的预览都会被自动删除。)';
$string['attempterrorcontentchangeforuser'] = '此次试答不再存在。';
$string['attempterrorinvalid'] = '无效的试答 ID';
$string['attemptfirst'] = '首次试答';
$string['attemptgradeddelay'] = '尝试评分通知延迟';
$string['attemptgradeddelay_desc'] = '在发送尝试评分通知之前应用延迟，以便教师有时间编辑成绩。';
$string['attemptincomplete'] = '{$a}的试答还未完成。';
$string['attemptlast'] = '上次试答';
$string['attemptnumber'] = '试答';
$string['attemptquiz'] = '尝试测验';
$string['attemptquiznow'] = '现在试答';
$string['attemptreviewtitle'] = '{$a}：试答回顾';
$string['attemptreviewtitlepaged'] = '{$a->name}：试答回顾 (页 {$a->currentpage} /{$a->totalpages})';
$string['attempts'] = '试答';
$string['attempts_help'] = '允许试答的总次数(不是额外的试答次数)。';
$string['attemptsallowed'] = '允许试答';
$string['attemptsdeleted'] = '删除的试答';
$string['attemptselection'] = '选择分析每个用户的哪次试答：';
$string['attemptsexist'] = '您不能再添加或移除试题。';
$string['attemptsnum'] = '试答：{$a}';
$string['attemptsnumthisgroup'] = '试答：{$a->total}次（组内{$a->group}次）';
$string['attemptsnumyourgroups'] = '试答：{$a->total}次（您同组内{$a->group}次）';
$string['attemptsonly'] = '只显示已试答的学生';
$string['attemptstate'] = '状态';
$string['attemptstillinprogress'] = '仍在试答中';
$string['attemptsummarytitle'] = '{$a}：试答概要';
$string['attemptsunlimited'] = '不限制试答';
$string['attempttitle'] = '{$a}';
$string['attempttitlepaged'] = '{$a->name} (页 {$a->currentpage} /{$a->totalpages})';
$string['autosaveperiod'] = '自动保存间隔';
$string['autosaveperiod_desc'] = '在学生试答期间，每隔几分钟，答案就会自动保存。这涉及到一个平衡，保存答案会增加服务器的负担，但是不这样做就会造成学生丢失前面的答题成果。间隔时间设为0时，会关闭自动保存功能。';
$string['back'] = '返回预览试题';
$string['backtocourse'] = '返回课程';
$string['backtoquestionlist'] = '返回试题列表';
$string['backtoquiz'] = '返回编辑测验';
$string['bestgrade'] = '最好成绩';
$string['bothattempts'] = '显示已试答和未试答的学生';
$string['browsersecurity'] = '浏览器安全';
$string['browsersecurity_help'] = '如果选择了“全屏幕弹出窗口（JavaScript保障安全）”

* 只有学生使用启用了 JavaScript 的 web 浏览器时，测验才会启动
* 测验显示在一个全屏幕的弹出窗口中，覆盖所有其它窗口，没有导航控件
* 会尽可能地阻止学生使用拷贝/粘贴之类的功能';
$string['cachedef_overrides'] = '用户和组覆盖信息';
$string['calculated'] = '计算题';
$string['calculatedquestion'] = '系统不支持位于行 {$a} 处的计算题。该试题将被忽略';
$string['cannotcreatepath'] = '无法创建路径({$a})';
$string['cannoteditafterattempts'] = '您不能添加或移除试题，因为此测验已经有人试答了。({$a})';
$string['cannotfindprevattempt'] = '找不到先前的试答，无法在其基础上开始。';
$string['cannotfindquestionregard'] = '获取重评分试题失败！';
$string['cannotinsert'] = '无法插入试题';
$string['cannotinsertrandomquestion'] = '无法插入随机题!';
$string['cannotloadquestion'] = '无法载入试题选项';
$string['cannotloadtypeinfo'] = '无法载入试题类型特定的试题信息';
$string['cannotopen'] = '无法打开导出文件({$a})';
$string['cannotremoveallsectionslots'] = '您已经选择了“{$a}”小节标题下的所有试题。不允许移除小节标题下的所有试题。';
$string['cannotremoveslots'] = '不能移除试题';
$string['cannotrestore'] = '不能恢复试题会话';
$string['cannotreviewopen'] = '此次试答还未关闭，您不能回顾它。';
$string['cannotsavelayout'] = '不能保存布局';
$string['cannotsavenumberofquestion'] = '不能保存每页试题数';
$string['cannotsavequestion'] = '不能保存试题列表';
$string['cannotsetgrade'] = '不能设置此测验的新最高分';
$string['cannotsetsumgrades'] = '设置总分失败';
$string['cannotstartgradesmismatch'] = '此测验还不能开始试答。此测验的满分设置为{$a->grade}，但是测验中的试题都没有分数。在“编辑测验”页面可以修正此问题。';
$string['cannotstartmissingquestion'] = '此测验还不能开始试答。它包含了一道不存在的试题。';
$string['cannotstartnoquestions'] = '此测验还不能开始试答。它还没有设置好。还没有添加任何试题。';
$string['cannotwrite'] = '无法写入导出文件({$a})';
$string['canredoquestions'] = '允许在试答中重做';
$string['canredoquestions_desc'] = '如果启用，在做完一道题后，将显示一个“试试另一道这样的题”按钮。这样就可以再做一道类似的题（随机选择），或再做一遍同一道题，而不必提交整个试答并开始另一次试答。 这个选项对于练习测验很有用。

此设置只影响试题和行为(如即时反馈或交互式多次尝试)，在此情形下可以在试答提交之前完成一道题。';
$string['canredoquestions_help'] = '如果启用，在做完一道题后，将显示一个“试试另一道这样的题”按钮。这样就可以再做一道类似的题（随机选择），或再做一遍同一道题，而不必提交整个试答并开始另一次试答。 这个选项对于练习测验很有用。

此设置只影响试题和行为(如即时反馈或交互式多次尝试)，在此情形下可以在试答提交之前完成一道题。';
$string['canredoquestionsyes'] = '是的，提供尝试试题的其他选项';
$string['caseno'] = '不，大小写不重要';
$string['casesensitive'] = '区分大小写';
$string['caseyes'] = '是的，大小写必须匹配';
$string['categoryadded'] = '类别“{$a}”已添加';
$string['categorydeleted'] = '类别“{$a}”已删除';
$string['categorynoedit'] = '您没有类别“{$a}”的编辑权限。';
$string['categoryupdated'] = '类别更新成功';
$string['close'] = '关闭窗口';
$string['closebeforeopen'] = '截止日期必须在开启日期之后';
$string['closed'] = '关闭的';
$string['closepreview'] = '关闭预览';
$string['closereview'] = '关闭回顾';
$string['comment'] = '评论';
$string['commentorgrade'] = '发表评论或者覆盖成绩';
$string['comments'] = '评论';
$string['completedon'] = '完成';
$string['completionattemptsexhausted'] = '及格成绩或已完成所有可用的机会';
$string['completionattemptsexhausted_help'] = '当学生用尽所有的试答次数时，标记测验完成。';
$string['completiondetail:minattempts'] = '尝试：{$a}';
$string['completiondetail:passorexhaust'] = '获得及格分数或完成所有可用的尝试';
$string['completionminattempts'] = '最小尝试次数';
$string['completionminattemptsdesc'] = '所需的最小尝试次数：{$a}';
$string['completionminattemptserror'] = '最少试答次数必须小于或等于允许的试答次数。';
$string['completionpassorattemptsexhausteddesc'] = '学生必须取得及格成绩，或尽一切努力完成此活动';
$string['configadaptive'] = '如果您选择“是”，那么允许学生在同一次试答中多次回答一道题。';
$string['configattemptsallowed'] = '限制学生在测验中允许试答的次数';
$string['configdecimaldigits'] = '显示分数的小数位数';
$string['configdecimalplaces'] = '显示测验分数时小数点后的数字位数。';
$string['configdecimalplacesquestion'] = '显示单个问题的标记时，小数点后应显示的位数。';
$string['configdelay1'] = '如果您设置了时间间隔，那么学生必须在第一次试答后等待该时间才能再次试答。';
$string['configdelay1st2nd'] = '如果您在此处设置了时间间隔，那么学生必须在第一次试答后等待该时间才能开始第二次试答。';
$string['configdelay2'] = '如果您在此处设置了时间间隔，那么学生必须等待该时间才能开始第三次或更后面的试答。';
$string['configdelaylater'] = '如果您在此处设置了时间间隔，那么学生必须在上次试答后等待该时间才能开始第三次，第四次...尝试。';
$string['configeachattemptbuildsonthelast'] = '如果允许多次试答，那么每次新试答都会包含上一次试答的结果。';
$string['configgrademethod'] = '当允许多次试答时，应该使用哪种方法来计算学生测验的最终成绩。';
$string['configintro'] = '这里设置的值是您创建新测验时设置表单中的默认值。您还可以配置哪些测验设置是高级设置。';
$string['configmaximumgrade'] = '默认成绩，该测验成绩被调整为满分。';
$string['confignavmethod'] = '在自由模式下，所有试题可以通过导航控件自由切换答题顺序。在顺序模式下，则必须按指定顺序答题。';
$string['confignewpageevery'] = '添加试题到测验时，会根据您在这里选择的设置自动插入分页符。';
$string['configoutcomesadvanced'] = '如果打开此选项，则测验编辑表单上的成果是高级设置。';
$string['configpenaltyscheme'] = '在自适应模式下，每次错误回答都会导致罚分。';
$string['configpopup'] = '强制试答在弹出窗口中打开，并使用 JavaScript 技术尝试在试答期间限制复制和粘贴等。';
$string['configrequirepassword'] = '学生必须输入此密码才可以试答测验。';
$string['configrequiresubnet'] = '学生只能通过这些计算机试答测验。';
$string['configreviewoptions'] = '这些选项控制用户在回顾试答或查看测验报表时可以看到什么信息。';
$string['configshowblocks'] = '试答期间显示版块。';
$string['configshowuserpicture'] = '试答期间，在屏幕上显示用户头像。';
$string['configshufflewithin'] = '如果您启用此选项，且试题设置中也启用了此选项，那么学生每次开始试答时，构成试题的各个组件都会被随机排列。';
$string['configtimelimit'] = '测验默认的时间限制，以分钟为单位。0 表示没有时间限制。';
$string['configtimelimitsec'] = '测验默认的时间限制，以秒为单位。0 表示没有时间限制。';
$string['configurerandomquestion'] = '配置试题';
$string['confirmclose'] = '一旦提交，您将不能再更改答案。';
$string['confirmremovequestion'] = '您确定要移除试题{$a}吗?';
$string['confirmremovesectionheading'] = '您确定要移除小节标题“{$a}”吗?';
$string['confirmserverdelete'] = '您确定要从此列表中移除服务器<b>{$a}</b>吗?';
$string['connectionerror'] = '网络连接断开。（自动保存失败）。

请记下最近几分钟在本页面所输入的答案，然后尝试重新连接。

一旦重新连接，您的答案将会被保存，同时此消息将消失。';
$string['connectionok'] = '网络连接恢复。您可以继续安全使用。';
$string['containercategorycreated'] = '由于以下原因，已经创建了存储所有移动到站点级别的原始类别的类别。';
$string['continueattemptquiz'] = '继续你的试答';
$string['continuepreview'] = '继续上次预览';
$string['copyingfrom'] = '建立一份试题“{$a}”的拷贝';
$string['copyingquestion'] = '复制一道题';
$string['correct'] = '正确';
$string['correctanswer'] = '正确答案';
$string['correctanswerformula'] = '正确答案公式';
$string['correctansweris'] = '正确答案：{$a}';
$string['correctanswerlength'] = '有效数字';
$string['correctanswers'] = '正确答案';
$string['correctanswershows'] = '正确答案显示';
$string['corrresp'] = '正确回答';
$string['countdown'] = '倒计时';
$string['countdownfinished'] = '测验即将关闭，您现在应该提交答案了。';
$string['countdowntenminutes'] = '测验将于10分钟后关闭';
$string['coursetestmanager'] = '课程测试管理者格式';
$string['createcategoryandaddrandomquestion'] = '创建类别并添加随机题';
$string['createfirst'] = '您必须先建立一些填空题。';
$string['createmultiple'] = '添加几道随机题到测验';
$string['createnewquestion'] = '新建试题';
$string['createquestionandadd'] = '新建一道题并添加到测验。';
$string['custom'] = '自定义格式';
$string['dataitemneed'] = '您需要添加至少一组数据项才能得到一道有效的试题';
$string['datasetdefinitions'] = '类别{$a}的可重用数据集定义';
$string['datasetnumber'] = '数量';
$string['daysavailable'] = '可用天数';
$string['decimaldigits'] = '分数的小数位数';
$string['decimalplaces'] = '分数的小数位数';
$string['decimalplaces_help'] = '此设置指定在显示分数时小数点后显示的位数。它只影响分数的显示，而不影响数据库中存储的分数，也不影响内部计算，后两者会使用完整的精度。';
$string['decimalplacesquestion'] = '试题分数的小数位数';
$string['decimalplacesquestion_help'] = '显示单个问题的分数时，小数点后显示的位数。';
$string['decimalpoints'] = '小数位数';
$string['default'] = '默认';
$string['defaultgrade'] = '默认试题分数';
$string['defaultinfo'] = '试题的默认类别。';
$string['delay1'] = '第一次和第二次试答之间的时间间隔';
$string['delay1st2nd'] = '第一次和第二次试答之间的强制时间间隔';
$string['delay1st2nd_help'] = '如果启用，学生必须等待指定的时间后才能进行第二次试答。';
$string['delay2'] = '后续试答之间的时间间隔';
$string['delaylater'] = '后续试答之间的强制时间间隔';
$string['delaylater_help'] = '如果启用，学生必须等待指定的时间后才能进行第三次及随后的各次试答。';
$string['deleteattemptcheck'] = '您确定要完全删除这些试答吗?';
$string['deleteselected'] = '删除选定的';
$string['deletingquestionattempts'] = '删除试题尝试';
$string['description'] = '描述';
$string['disabled'] = '禁用';
$string['displayoptions'] = '显示选项';
$string['donotuseautosave'] = '不使用自动保存';
$string['download'] = '点击下载已导出的类别文件';
$string['downloadextra'] = '（文件也存储在课程文件/backupdata/quiz 文件夹内)';
$string['dragtoafter'] = '{$a}后';
$string['dragtostart'] = '从头开始';
$string['duplicateresponse'] = '此提交已被忽略，因为您之前提交了相同的答案。';
$string['eachattemptbuildsonthelast'] = '每次试答都建立在上次的基础上';
$string['eachattemptbuildsonthelast_help'] = '如果允许多次试答并启用此设置，则每次新的试答都将包含上次试答的结果。这允许测验可以通过几次试答来完成。';
$string['edit_slotdisplaynumber_hint'] = '编辑问题编号（最多 16 个字符）';
$string['edit_slotdisplaynumber_label'] = '{$a} 的新值';
$string['editcategories'] = '编辑类别';
$string['editcategory'] = '编辑类别';
$string['editcatquestions'] = '编辑类别试题';
$string['editingquestion'] = '编辑试题';
$string['editingquiz'] = '编辑测验';
$string['editingquiz_help'] = '创建测验的主要思路是：

* 测验可以在一个或多个页面中放置试题
* 题库中保存着所有试题副本，按类别组织
* 随机题 - 同一名学生的不同试答可能得到不同试题，不同学生也可能得到不同试题';
$string['editingquiz_link'] = 'mod/quiz/edit';
$string['editingquizx'] = '编辑测验：{$a}';
$string['editmaxmark'] = '编辑最高分';
$string['editoverride'] = '编辑覆盖';
$string['editqcats'] = '编辑试题类别';
$string['editquestion'] = '编辑试题';
$string['editquestions'] = '编辑试题';
$string['editquiz'] = '编辑测验';
$string['editquizquestions'] = '编辑测验题';
$string['emailconfirmautosubmitsmall'] = '感谢您提交对\'{$a->quizname}\'的回答';
$string['emailconfirmbody'] = '{$a->username}，您好！

感谢您在{$a->submissiontime}提交您的答案到课程“{$a->coursename}”中的“{$a->quizname}”。

此消息确认您的答案已被保存。 您能够在{$a->quizurl}访问该测验。';
$string['emailconfirmbodyautosubmit'] = 'Hi{$a->username}，

课程“{$a->coursename}”中的测验“{$a->quizname}”已过期。 您的答案已在{$a->submissiontime}自动提交。

此消息确认您的答案已保存。

您可以在 {$a->quizurl} 访问此测验。';
$string['emailconfirmsmall'] = '感谢您提交您的答案到“{$a->quizname}”';
$string['emailconfirmsubject'] = '提交确认：{$a->quizname}';
$string['emailmanualgradedbody'] = 'Hi{$a->studentname}，

您在{$a->attempttimefinish} 对课程 \'{$a->coursename}\'中 \'{$a->quizname}\'的回答已评分。

您将能够通过访问\'{$a->quizurl}\'并查看您的尝试来查看您的分数和反馈。';
$string['emailmanualgradedsubject'] = '您对 {$a->quizname} 的尝试已被评分';
$string['emailnotifybody'] = '{$a->username}，您好！

{$a->studentname}已经完成了课程“{$a->coursename}”中的测验“{$a->quizname}”({$a->quizurl})。

您能够在 {$a->quizreviewurl} 回顾此次试答。';
$string['emailnotifysmall'] = '{$a->studentname}已经完成测验{$a->quizname}。参见 {$a->quizreviewurl}';
$string['emailnotifysubject'] = '{$a->studentname}已经完成{$a->quizname}';
$string['emailoverduebody'] = '{$a->studentname}，您好！

您在课程“{$a->coursename}”中的测验“{$a->quizname}”开始了一次试答，但是您从未提交。它应该在{$a->attemptduedate}之前提交。

如果您还想提交这次试答，请去{$a->attemptsummaryurl} 并点击提交按钮。 您必须在{$a->attemptgraceend}之前完成此操作，否则您的此次试答将不计成绩。';
$string['emailoverduesmall'] = '您没有提交您在测验{$a->quizname}的试答。如果您还想提交的话，请在{$a->attemptgraceend}之前去{$a->attemptsummaryurl} 。';
$string['emailoverduesubject'] = '现在过期的试答：{$a->quizname}';
$string['empty'] = '空的';
$string['enabled'] = '启用';
$string['endtest'] = '结束试答…';
$string['erroraccessingreport'] = '您不能访问此报表';
$string['errorinquestion'] = '试题错误';
$string['errormissingquestion'] = '错误：系统丢失 ID 为 {$a} 的试题';
$string['errornotnumbers'] = '错误：答案必须是数值';
$string['errorunexpectedevent'] = '在试答 {$a->attemptid} 中发现试题{$a->questionid} 的意外事件代码 {$a->event} 。';
$string['essay'] = '简答题';
$string['essayquestions'] = '试题';
$string['eventattemptautosaved'] = '测验尝试自动保存';
$string['eventattemptdeleted'] = '试答已删除';
$string['eventattemptmanualgradingcomplete'] = '测验尝试手动评分完成';
$string['eventattemptpreviewstarted'] = '试答预览已开始';
$string['eventattemptquestionrestarted'] = '测验尝试问题重新开始';
$string['eventattemptreviewed'] = '试答已回顾';
$string['eventattemptsummaryviewed'] = '试答概要已查看';
$string['eventattemptupdated'] = '测验尝试已更新';
$string['eventattemptviewed'] = '试答已查看';
$string['eventeditpageviewed'] = '测验编辑页面已查看';
$string['eventoverridecreated'] = '测验覆盖已创建';
$string['eventoverridedeleted'] = '测验覆盖已删除';
$string['eventoverrideupdated'] = '测验覆盖已更新';
$string['eventpagebreakcreated'] = '已创建分页';
$string['eventpagebreakdeleted'] = '分页已删除';
$string['eventquestionmanuallygraded'] = '试题已手动评分';
$string['eventquizattemptabandoned'] = '试答已放弃';
$string['eventquizattemptregraded'] = '试答已重新评分';
$string['eventquizattemptreopened'] = '测验已重新打开';
$string['eventquizattemptstarted'] = '试答已开始';
$string['eventquizattemptsubmitted'] = '试答已提交';
$string['eventquizattempttimelimitexceeded'] = '试答时间限制已超出';
$string['eventquizgradeitemcreated'] = '已创建测验成绩项目';
$string['eventquizgradeitemdeleted'] = '已删除测验成绩项目';
$string['eventquizgradeitemorderchanged'] = '测验成绩项目顺序已更改';
$string['eventquizgradeitemupdated'] = '测验成绩项目已更新';
$string['eventquizgradeupdated'] = '测验成绩已更新';
$string['eventquizrepaginated'] = '测验重新分页';
$string['eventreportviewed'] = '测验报表已查看';
$string['eventsectionbreakcreated'] = '已创建分节';
$string['eventsectionbreakdeleted'] = '分节已删除';
$string['eventsectionshuffleupdated'] = '部分改组已更新';
$string['eventsectiontitleupdated'] = '章节标题已更新';
$string['eventslotcreated'] = '插槽已创建';
$string['eventslotdeleted'] = '插槽已删除';
$string['eventslotdisplayedquestionnumberupdated'] = '插槽显示的问题编号已更新';
$string['eventslotgradeitemupdated'] = '插槽成绩项目已更新';
$string['eventslotmarkupdated'] = '槽位标记已更新';
$string['eventslotmoved'] = '插槽已移动';
$string['eventslotrequirepreviousupdated'] = '插槽需要先前更新';
$string['everynquestions'] = '每{$a}道题';
$string['everyquestion'] = '每道题';
$string['everythingon'] = '全部启用';
$string['existingcategory'] = '现有的类别';
$string['exportcategory'] = '导出类别';
$string['exporterror'] = '导出过程中出现一个错误';
$string['exportingquestions'] = '试题已经导出到文件';
$string['exportname'] = '文件名';
$string['exportquestions'] = '导出试题到文件';
$string['extraattemptrestrictions'] = '试答的额外限制';
$string['false'] = '错';
$string['feedback'] = '反馈';
$string['feedbackerrorboundaryformat'] = '反馈成绩范围必须是百分比数或者数字。您输入范围{$a}的值无法识别。';
$string['feedbackerrorboundaryoutofrange'] = '反馈成绩范围必须在0%和100%之间。您输入范围{$a}的值超出了范围。';
$string['feedbackerrorjunkinboundary'] = '您必须填写反馈成绩范围框，不留下任何空白。';
$string['feedbackerrorjunkinfeedback'] = '您必须填写反馈框，不留下任何空白。';
$string['feedbackerrororder'] = '反馈成绩范围必须按从高到低的顺序排列。您输入范围{$a}的值顺序不对。';
$string['file'] = '文件';
$string['fileformat'] = '文件格式';
$string['fillcorrect'] = '填入正确答案';
$string['filloutnumericalanswer'] = '您至少提供一个可能的答案和容差。第一个匹配的答案将被用来确定分数和反馈。如果您在最后提供了一些没有答案的反馈，它将会显示给与任何答案都不匹配的学生。';
$string['filloutoneanswer'] = '您必须提供至少一个可能的答案。空白的答案会被忽略。“*”可以用作通配符来匹配任何字符。第一个匹配的答案将被用来确定分数和反馈。';
$string['filloutthreequestions'] = '您必须提供至少三个有匹配答案的试题。您可以通过给出空白试题的答案来提供额外的错误答案。试题和答案均为空白的条目将被忽略。';
$string['fillouttwochoices'] = '您必须至少填写两个选项。留空的选项将被忽略。';
$string['finishattemptdots'] = '结束试答…';
$string['finishreview'] = '结束回顾';
$string['forceregeneration'] = '强制重新生成';
$string['formatnotfound'] = '未找到导入/导出格式 {$a}';
$string['formulaerror'] = '公式错误！';
$string['fractionsaddwrong'] = '您选择的正分数加起来不等于100%<br />而是{$a}%<br />您想回去修正这个试题吗?';
$string['fractionsnomax'] = '答案中应该有一个是 100%， <br />这样这个试题才有可能得满分。 <br />您想回去修正这个试题吗？';
$string['fromfile'] = '来自文件：';
$string['functiondisabledbysecuremode'] = '该功能目前已禁用';
$string['generalfeedback'] = '通用反馈';
$string['generalfeedback_help'] = '通用反馈是一道题答完后显示的文本。不像特定的试题反馈取决于给出的回答，通用反馈总是相同的。';
$string['gobacktoquiz'] = '回去';
$string['graceperiod'] = '提交宽限期';
$string['graceperiod_desc'] = '如果将当时限终止时做什么设置为“有宽限期...”，则这是允许的默认的额外时间量。';
$string['graceperiod_help'] = '如果将当时限终止时做什么设置为“有宽限期...”，则这是允许的额外时间量。';
$string['graceperiodmin'] = '最后提交宽限期';
$string['graceperiodmin_desc'] = '测验结束时存在一个潜在问题：一方面，希望配合计时器和自动提交功能，让学生作答到最后一秒；另一方面，服务器可能会超载，反应较慢，而产生延时问题。所以我们需要根据测验时服务器的表现，制订一个合理的宽限时间，使得学生不会因为服务器问题而受到不良影响。';
$string['graceperiodtoosmall'] = '宽限期必须长于{$a}。';
$string['gradeall'] = '评分所有';
$string['gradeaverage'] = '平均分';
$string['gradeboundary'] = '成绩范围';
$string['gradeessays'] = '评分简答题';
$string['gradehighest'] = '最高分';
$string['gradeitemdefaultname'] = '新的成绩项目{$a}';
$string['gradeitemdelete'] = '删除成绩项目{$a}';
$string['gradeitemedit'] = '编辑成绩项目名{$a}';
$string['gradeitemmarkscheme'] = '分配成绩项目';
$string['gradeitemnewname'] = '成绩项目 {$a} 的新名称';
$string['gradeitemnoneselected'] = '[无]';
$string['gradeitemnoslots'] = '这个测验还没有问题。请先添加问题，然后返回此处设置成绩项目。';
$string['gradeitems'] = '成绩项';
$string['gradeitemsautosetup'] = '为每个部分设置分数';
$string['gradeitemsetup'] = '成绩项目设置';
$string['gradeitemsnoneyet'] = '在测验中创建成绩项目。为这些评分项目分配问题或测验部分，以将评分结果分配到不同的区域。';
$string['gradeitemsremoveall'] = '重置设置';
$string['gradeitemsremoveallconfirm'] = '重置成绩项目设置？';
$string['gradeitemsremoveallmessage'] = '这将删除所有成绩项目，并从中取消分配问题和节。<br><br>此操作不会影响问题和节本身，也不会影响测验中的现有尝试。';
$string['gradeitemsremovealltitle'] = '重置成绩项目设置';
$string['grademethod'] = '评分方法';
$string['grademethod_help'] = '当允许多次试答时，可以使用以下方法来计算最终测验成绩：

* 所有试答的最高分
* 所有试答的平均分
* 第一次试答(其他所有试答都被忽略)
* 最后一次试答(其他所有试答都被忽略)';
$string['gradesdeleted'] = '测验成绩已删除';
$string['gradesofar'] = '{$a->method}: {$a->mygrade} / {$a->quizgrade}。';
$string['gradetopassmustbeset'] = '及格成绩不能为 0，因为这个测验的完成方法需要及格成绩。请设置一个非零值。';
$string['gradetopassoutof'] = '及格分数: {$a->grade} / {$a->maxgrade}';
$string['gradingdetails'] = '此次提交的分数：{$a->raw}/{$a->max}。';
$string['gradingdetailsadjustment'] = '扣除先前的罚分，此次得分 <strong>{$a->cur}/{$a->max}</strong>。';
$string['gradingdetailspenalty'] = '此次提交被罚 {$a} 分';
$string['gradingdetailszeropenalty'] = '您此次提交没有被罚分。';
$string['gradingmethod'] = '评分方法：{$a}';
$string['groupoverrides'] = '小组覆盖';
$string['groupoverridesdeleted'] = '小组覆盖已删除';
$string['groupsnone'] = '您无法访问任何组。';
$string['guestsno'] = '对不起，访客不能看到或试答测验';
$string['hidebreaks'] = '隐藏分页符。';
$string['hidereordertool'] = '隐藏重新排序工具';
$string['history'] = '回答历史记录：';
$string['howquestionsbehave_desc'] = '测验中试题行为的默认设置。';
$string['imagedisplay'] = '要显示的图片';
$string['import_help'] = '您可以用此功能导入外部文本文件中的试题。

如果您的文件包含非 ascii 字符，那么它必须使用 UTF-8 编码。要特别小心 Microsoft Office 生成的文件，它们常常使用不能被正确处理的特殊编码。

导入和导出格式是插件式的。其它可选格式在模块和插件数据库中可以找到。';
$string['import_link'] = 'question/import';
$string['importcategory'] = '导入类别';
$string['importerror'] = '导入过程中发生错误';
$string['importfilearea'] = '从已有的课程文件中导入...';
$string['importfileupload'] = '从上传的文件导入…';
$string['importfromthisfile'] = '从该文件导入';
$string['importingquestions'] = '从文件导入 {$a} 道题';
$string['importmax10error'] = '此试题有一个错误。不能有超过10个答案。';
$string['importmaxerror'] = '此试题有一个错误。答案太多了。';
$string['importquestions'] = '从文件导入试题';
$string['inactiveoverridehelp'] = '* 此覆盖无效，用户对活动的访问受到限制。这可能是因为小组或角色分配、其他访问限制或活动被隐藏。';
$string['incorrect'] = '错误';
$string['indicator:cognitivedepth'] = '测验认知深度';
$string['indicator:cognitivedepth_help'] = '这个指标是基于学生在测验活动中所达到的认知深度。';
$string['indicator:cognitivedepthdef'] = '测验认知深度';
$string['indicator:cognitivedepthdef_help'] = '在此分析间隔内，参与人已经达到了测验活动所提供的认知参与度(水平=没有查看、查看、提交、查看反馈、评论反馈、查看反馈后重新提交)';
$string['indicator:cognitivedepthdef_link'] = 'Learning_analytics_indicators#Cognitive_depth';
$string['indicator:socialbreadth'] = '测验社会广度';
$string['indicator:socialbreadth_help'] = '这个指标是基于学生在测验活动中所达到的社会广度。';
$string['indicator:socialbreadthdef'] = '测验社会广度';
$string['indicator:socialbreadthdef_help'] = '在此分析间隔内，参与人已经达到了测验活动所提供的社会参与度(水平=没有参与，单独参与，和其他人一起参与)';
$string['indicator:socialbreadthdef_link'] = 'Learning_analytics_indicators#Social_breadth';
$string['indivresp'] = '个人对每个项目的回答';
$string['info'] = '信息';
$string['infoshort'] = '信息';
$string['initialnumfeedbacks'] = '总体反馈字段的初始数量';
$string['initialnumfeedbacks_desc'] = '建立一个新测验时，要提供几个空白的总体反馈框。测验一旦建立，就会生成测验所需的反馈数量的字段。该设置必须至少为1。';
$string['inprogress'] = '进行中';
$string['introduction'] = '描述';
$string['invalidattemptid'] = '不存在这样的试答 ID';
$string['invalidcategory'] = '类别 ID 无效';
$string['invalidoverrideid'] = '无效替代 ID';
$string['invalidquestionid'] = '无效的试题 ID';
$string['invalidquizid'] = '无效的测验 ID';
$string['invalidrandomslot'] = '无效的随机题 ID。';
$string['invalidsource'] = '不接受此源为有效。';
$string['invalidsourcetype'] = '无效的源类型';
$string['invalidstateid'] = '无效的状态 ID';
$string['lastanswer'] = '您最后的答案是';
$string['lastautosave'] = '最近保存{$a}';
$string['layout'] = '布局';
$string['layoutasshown'] = '页面布局如下所示。';
$string['layoutasshownwithpages'] = '页面布局如下所示。<small>（每 {$a} 道题自动开新页）</small>';
$string['layoutshuffledandpaged'] = '随机排列试题，每页 {$a} 道题。';
$string['layoutshuffledsinglepage'] = '随机排列试题，全部在一页中。';
$string['link'] = '链接';
$string['listitems'] = '测验项目清单';
$string['literal'] = '文字';
$string['loadingquestionsfailed'] = '载入试题失败：{$a}';
$string['makecopy'] = '另存为新试题';
$string['managetypes'] = '管理试题类型和服务器';
$string['manualgradequestion'] = '用户{$a->user}在{$a->quiz}的人工评分试题 {$a->question}';
$string['manualgrading'] = '评分';
$string['mark'] = '提交';
$string['markall'] = '提交页';
$string['marks'] = '分数';
$string['marks_help'] = '每个问题获得的分数和总尝试分数。仅当选择了“最高分数”时，才能选择“分数”。';
$string['match'] = '匹配题';
$string['matchanswer'] = '匹配答案';
$string['matchanswerno'] = '匹配答案 {$a}';
$string['max'] = '最高';
$string['maxmark'] = '最高分';
$string['maxmarks'] = '最高分';
$string['maxmarks_help'] = '每道题的最高分。';
$string['messageprovider:attempt_grading_complete'] = '通知您的尝试已评分';
$string['messageprovider:attempt_overdue'] = '当您的试答将要过期时进行警告';
$string['messageprovider:confirmation'] = '确认您自己的测验提交';
$string['messageprovider:quiz_open_soon'] = '测验即将开始';
$string['messageprovider:submission'] = '学生提交测验的通知';
$string['min'] = '最低';
$string['minutes'] = '分钟';
$string['missingcorrectanswer'] = '必须指定正确答案';
$string['missingitemtypename'] = '缺少名称';
$string['missingquestion'] = '这道题似乎不再不存在';
$string['modulename'] = '测验';
$string['modulename_help'] = '教师可以在测验模块中设计选择、填空、匹配、数字、判断、简答等多种类型的试题。

教师可以允许测验可多次试答，并使用从题库随机抽题，试题顺序随机排列、选择题或匹配题选项随机排列等方式，以减少作弊的可能性。

教师也可以设置测验开启日期，或每次试答的时间限制(有倒计时)。 除了简答题外，每次试答都会自动批改，成绩会保存到成绩册上。 教师可以选择何时以及是否向学生显示提示、反馈和正确答案。

测验可用于：

* 课程的正式考试
* 每单元的单元测验
* 使用以往的旧题目做练习性测验
* 对学习效果提供即时反馈
* 进行自我评价';
$string['modulename_link'] = 'mod/quiz/view';
$string['modulenameplural'] = '测验';
$string['moveselectedonpage'] = '移动选定的试题到页：{$a}';
$string['multichoice'] = '选择题';
$string['multipleanswers'] = '至少选择一个答案。';
$string['mustbesubmittedby'] = '此试答必须在 {$a} 之前提交。';
$string['name'] = '名称';
$string['navigatenext'] = '下一页';
$string['navigateprevious'] = '上一页';
$string['navmethod'] = '导航方式';
$string['navmethod_free'] = '自由模式';
$string['navmethod_help'] = '使用顺序模式时，学生必须按顺序完成测验，既不能返回到先前的页面，也不能跳到后面的页面。';
$string['navmethod_seq'] = '顺序模式';
$string['navnojswarning'] = '警告：这些链接不会保存您的答案。请使用页面底部的下一页按钮。';
$string['neverallononepage'] = '不，所有试题在一个页面上';
$string['newattemptfail'] = '错误：此测验无法开始新的试答。';
$string['newcategory'] = '新类别';
$string['newpage'] = '新页面';
$string['newpage_help'] = '对于试题较多的测验，通过限制每页试题的数量来将测验延长几页是有意义的。当向测验添加试题时，分页符将根据此设置自动插入。当然，分页符稍后也可以在编辑页面上手动移动。';
$string['newpageevery'] = '自动开始一个新页面';
$string['newsectionheading'] = '新标题';
$string['noanswers'] = '没有选择答案!';
$string['noattempts'] = '此测验还没有人试答';
$string['noattemptsfound'] = '找不到试答。';
$string['noattemptstoshow'] = '没有试答可显示。';
$string['nocategory'] = '指定的类别不正确或没有';
$string['noclose'] = '没有关闭日期';
$string['nocommentsyet'] = '还没有评论。';
$string['noconnection'] = '当前没有连接到可以处理此试题的Web服务。请与您的管理员联系';
$string['nodataset'] = '什么也没有 - 这不是通配符';
$string['nodatasubmitted'] = '没有提交任何数据。';
$string['noessayquestionsfound'] = '没有找到人工评分的试题';
$string['nogradewarning'] = '此测验还没有评分，所以您不能根据不同的成绩设置总体反馈。';
$string['nomoreattempts'] = '不再允许试答';
$string['none'] = '没有';
$string['noopen'] = '没有开启日期';
$string['nooverridedata'] = '您必须至少覆盖一项测验设置。';
$string['nopossibledatasets'] = '没有合适的数据集';
$string['noquestionintext'] = '此题干不包含任何嵌入的试题。';
$string['noquestions'] = '还没有添加试题';
$string['noquestionsfound'] = '找不到试题';
$string['noquestionsinquiz'] = '该测验中没有试题。';
$string['noquestionsnotinuse'] = '此随机题没有使用，因为其类别为空。';
$string['noquestionsonpage'] = '空白页';
$string['noresponse'] = '无回答';
$string['noreview'] = '您不能回顾此测验';
$string['noreviewattempt'] = '您不能回顾此试答。';
$string['noreviewshort'] = '不允许';
$string['noreviewuntil'] = '您在 {$a} 之前不能回顾此测验';
$string['noreviewuntilshort'] = '可用的 {$a}';
$string['noscript'] = '继续前必须启用 JavaScript！';
$string['notavailabletostudents'] = '注意：此测验现在对您的学生不可用';
$string['notenoughrandomquestions'] = '类别 {$a->category}中没有足够的试题来创建试题 {$a->name} ({$a->id})。';
$string['notenoughsubquestions'] = '没有定义足够的小题！<br />您想回去修正这个试题吗?';
$string['notifyattemptsgradedtask'] = '发送测验尝试评分通知';
$string['notimedependentitems'] = '测验模块当前不支持与时间有关的项目。解决方法是，为整个测验设置一个时间限制。您要选择其他项目（还是仍然使用当前项目）？';
$string['notyetgraded'] = '还未评分';
$string['notyetviewed'] = '还未查看';
$string['notyourattempt'] = '这不是您的试答！';
$string['noview'] = '已登录用户不允许查看此测验';
$string['numattempts'] = '{$a->studentnum} {$a->studentstring} 已进行{$a->attemptnum}次试答';
$string['numberabbr'] = '#';
$string['numerical'] = '数字题';
$string['numquestionsx'] = '试题：{$a}';
$string['oneminute'] = '1分钟';
$string['onlyteachersexport'] = '只有教师能导出试题';
$string['onlyteachersimport'] = '只有具有编辑权限的教师能导出试题';
$string['onthispage'] = '此页';
$string['open'] = '未回答';
$string['openafterclose'] = '无法更新测验。您在关闭日期之后指定了一个开启日期。';
$string['openclosedatesupdated'] = '开启和关闭日期';
$string['optional'] = '可选';
$string['orderandpaging'] = '顺序与分页';
$string['orderandpaging_help'] = '每道试题后面的10、20、30这样的数字表明试题的顺序。数字以10为步长递增，是为了给后面添加试题留空间。要改变试题顺序，请修改数字，然后点击“重新排序试题”按钮。

要在指定试题后添加分页符，请勾选试题旁边的复选框，再点击“在所选试题后添加新页面”按钮。

要将试题排列在多个页面上，请点击重新分页按钮，然后选择每页所需的试题数量。';
$string['orderingquiz'] = '顺序与分页';
$string['orderingquizx'] = '顺序与分页：{$a}';
$string['outcomesadvanced'] = '成果是高级设置';
$string['outof'] = '{$a->grade}/{$a->maxgrade}';
$string['outofpercent'] = '{$a->grade}/{$a->maxgrade} ({$a->percent}%）';
$string['outofshort'] = '{$a->grade}/{$a->maxgrade}';
$string['overallfeedback'] = '总体反馈';
$string['overallfeedback_help'] = '总体反馈是试答后显示的文本。如果额外指定了成绩范围（可以是百分比或数字），会根据学生的成绩显示不同的文本。';
$string['overdue'] = '过期';
$string['overduehandling'] = '当时限终止时';
$string['overduehandling_desc'] = '如果学生没有在时限终止前提交测验，默认情况下会发生什么?';
$string['overduehandling_help'] = '这个设置控制了如果学生在测验时限终止之前没有提交他们的试答会发生什么。如果学生当时正在积极地作答，那么倒计时计时器将总是自动为他们提交试答，但是如果他们已经退出，那么此设置会控制怎么做。';
$string['overduehandling_link'] = 'mod/quiz/timing';
$string['overduehandlingautoabandon'] = '试答必须在时限终止之前提交，否则不计成绩';
$string['overduehandlingautosubmit'] = '自动提交打开的试答';
$string['overduehandlinggraceperiod'] = '在宽限期内，打开的试答可以提交，但不能再作答了';
$string['overduemustbesubmittedby'] = '此试答现已过期。它应该早已提交。如果您想要此测验被评分，您必须在{$a}之前提交它。如果您那时未提交，此试答将不会计分。';
$string['override'] = '覆盖';
$string['overridecannotchange'] = '创建覆盖后，不能更改用户或组。';
$string['overridecannotsetbothgroupanduser'] = '组和用户不能同时设置。';
$string['overridedeletegroupsure'] = '您确定要删除小组 {$a} 的覆盖？';
$string['overridedeleteusersure'] = '您确定要删除用户 {$a} 的覆盖？';
$string['overridegroup'] = '覆盖小组';
$string['overridegroupeventname'] = '{$a->quiz} - {$a->group}';
$string['overrideinvalidattempts'] = '“尝试次数”值必须大于零。';
$string['overrideinvalidquiz'] = '测验ID设置不存在。';
$string['overrideinvalidtimelimit'] = '时间限制必须大于零。';
$string['overridemustsetuserorgroup'] = '必须设置用户或组。';
$string['overrides'] = '覆盖';
$string['overridesforquiz'] = '设置覆盖：{$a}';
$string['overridesnoneforgroups'] = '尚未为此测验创建任何组设置覆盖。';
$string['overridesnoneforusers'] = '尚未为此测验创建任何用户设置覆盖。';
$string['overridessummary'] = '设置覆盖存在（{$a}）';
$string['overridessummarygroup'] = '组：{$a}';
$string['overridessummarythisgroup'] = '此组存在设置覆盖（{$a}）';
$string['overridessummaryuser'] = '用户：{$a}';
$string['overridessummaryyourgroups'] = '您的组存在设置覆盖（{$a}）';
$string['overrideuser'] = '覆盖用户';
$string['overrideusereventname'] = '{$a->quiz} - 覆盖';
$string['page-mod-quiz-attempt'] = '试答测验页面';
$string['page-mod-quiz-edit'] = '编辑测验页面';
$string['page-mod-quiz-report'] = '任意测验报表页面';
$string['page-mod-quiz-review'] = '回顾试答页面';
$string['page-mod-quiz-summary'] = '试答概要页面';
$string['page-mod-quiz-view'] = '测验信息页面';
$string['page-mod-quiz-x'] = '任意测验模块页面';
$string['pageshort'] = '页';
$string['pagesize'] = '页面大小';
$string['parent'] = '父';
$string['parentcategory'] = '父类别';
$string['parsingquestions'] = '解析导入文件中的试题。';
$string['partiallycorrect'] = '部分正确';
$string['penalty'] = '罚分';
$string['penaltyscheme'] = '使用罚分';
$string['penaltyscheme_help'] = '如果启用，每次错误回答都会导致从最终分数中扣除一定的罚分。罚分的总数可以在试题设置中设定。此设置仅在启用自适应模式时有效。';
$string['percentcorrect'] = '正确率';
$string['pleaseclose'] = '您的请求已经处理。现在可以关闭此窗口';
$string['pluginadministration'] = '测验管理';
$string['pluginname'] = '测验';
$string['popup'] = '在“安全”窗口中显示测验';
$string['popupblockerwarning'] = '测试的这一部分处于安全模式，这意味着您需要在一个安全窗口中进行测验。请关闭您的弹出窗口拦截器。谢谢您！';
$string['popupnotice'] = '学生们将在一个安全窗口中看到这个测验';
$string['preprocesserror'] = '在预处理期间发生错误！';
$string['preview'] = '预览';
$string['previewquestion'] = '预览试题';
$string['previewquiz'] = '预览 {$a}';
$string['previewquiznow'] = '现在预览测验';
$string['previewquizstart'] = '预览测验';
$string['previous'] = '先前的状态';
$string['privacy:metadata:core_question'] = '测验活动将试题使用信息存储在核心_试题子系统中。';
$string['privacy:metadata:quiz'] = '测验活动使用测验报表。';
$string['privacy:metadata:quiz_attempts'] = '测验中每次试答的详情。';
$string['privacy:metadata:quiz_attempts:attempt'] = '试答数量。';
$string['privacy:metadata:quiz_attempts:currentpage'] = '用户当前所在的页面。';
$string['privacy:metadata:quiz_attempts:gradednotificationsenttime'] = '通知用户手动评分尝试已完成的时间';
$string['privacy:metadata:quiz_attempts:preview'] = '这是否是测验的预览。';
$string['privacy:metadata:quiz_attempts:state'] = '试答的当前状态。';
$string['privacy:metadata:quiz_attempts:sumgrades'] = '试答成绩的总和。';
$string['privacy:metadata:quiz_attempts:timecheckstate'] = '检查状态的时间。';
$string['privacy:metadata:quiz_attempts:timefinish'] = '试答完成的时间。';
$string['privacy:metadata:quiz_attempts:timemodified'] = '试答更新的时间。';
$string['privacy:metadata:quiz_attempts:timemodifiedoffline'] = '通过离线更新更新试答的时间。';
$string['privacy:metadata:quiz_attempts:timestart'] = '试答开始的时间。';
$string['privacy:metadata:quiz_grades'] = '此测验总体成绩的详情。';
$string['privacy:metadata:quiz_grades:grade'] = '此测验的总体成绩。';
$string['privacy:metadata:quiz_grades:quiz'] = '已评分的测验。';
$string['privacy:metadata:quiz_grades:timemodified'] = '成绩修改的时间。';
$string['privacy:metadata:quiz_grades:userid'] = '被评分的用户。';
$string['privacy:metadata:quiz_overrides'] = '关于此测验覆盖的详情';
$string['privacy:metadata:quiz_overrides:quiz'] = '具有覆盖信息的测验';
$string['privacy:metadata:quiz_overrides:timeclose'] = '测验新的关闭时间';
$string['privacy:metadata:quiz_overrides:timelimit'] = '测验新的时间限制。';
$string['privacy:metadata:quiz_overrides:timeopen'] = '测验新的开启时间。';
$string['privacy:metadata:quiz_overrides:userid'] = '被覆盖的用户';
$string['privacy:metadata:quizaccess'] = '测验活动使用测验访问规则。';
$string['publish'] = '公布';
$string['publishedit'] = '您必须具有公布课程的权限才能添加或编辑此类别中的试题';
$string['qbrief'] = '题. {$a}';
$string['qname'] = '名称';
$string['qti'] = 'IMS QTI 格式';
$string['qtypename'] = '类型，名称';
$string['question'] = '试题';
$string['questionbank'] = '从题库';
$string['questionbankmanagement'] = '题库管理';
$string['questionbehaviour'] = '试题行为';
$string['questioncats'] = '试题类别';
$string['questiondeleted'] = '此试题已经被删除。请联系您的老师。';
$string['questiondependencyadd'] = '试题{$a->thisq}可以作答，没有限制。点击更改';
$string['questiondependencyfree'] = '这道题没有限制';
$string['questiondependencyremove'] = '试题{$a->thisq}在上一道题{$a->previousq}完成之前不能作答。点击更改';
$string['questiondependsonprevious'] = '在上一道题完成之前，不能作答这道题。';
$string['questiondraftonly'] = '问题{$a}处于草稿状态。要在测试中使用它，请进入题库并将状态更改为准备。';
$string['questiondraftwillnotwork'] = '这个问题处于草案状态。要在测试中使用它，请进入题库并将状态更改为准备。';
$string['questioninuse'] = '试题“{$a->questionname}”正被用于: <br />{$a->quiznames}<br />此试题不会从测验中删除，只会从类别列表中删除。';
$string['questionmissing'] = '此会话的试题丢失';
$string['questionname'] = '试题名称';
$string['questionnonav'] = '<span class="accesshide">试题</span> {$a->number}<span class="accesshide"> {$a->attributes}</span>';
$string['questionnonavinfo'] = '<span class="accesshide">信息</span> {$a->number}<span class="accesshide"> {$a->attributes}</span>';
$string['questionnotloaded'] = '试题 {$a} 还没有从数据库加载';
$string['questionorder'] = '试题排序';
$string['questionposition'] = '试题{$a}的新位置';
$string['questions'] = '试题';
$string['questionsetpreview'] = '试题设置预览';
$string['questionsinclhidden'] = '试题（包括隐藏的）';
$string['questionsinthisquiz'] = '该测验中的试题';
$string['questionsmatchingfilter'] = '匹配该过滤器的试题： {$a}';
$string['questionsperpage'] = '每页试题数';
$string['questionsperpageselected'] = '已经设置了每页试题数，所以分页现在是固定的，分页控件被禁用。您可以在这里更改 {$a}。';
$string['questionsperpagex'] = '每页试题数 : {$a}';
$string['questiontext'] = '题干';
$string['questiontextisempty'] = '[空题干]';
$string['questiontype'] = '试题类型 {$a}';
$string['questiontypesetupoptions'] = '试题类型的设置选项：';
$string['questionversionlatest'] = 'v{$a}（最新）';
$string['quiz:addinstance'] = '添加新测验';
$string['quiz:attempt'] = '试答测验';
$string['quiz:deleteattempts'] = '删除试答';
$string['quiz:emailconfirmsubmission'] = '接收您自己提交的测验确认信息';
$string['quiz:emailnotifyattemptgraded'] = '你的尝试被评分时会收到通知';
$string['quiz:emailnotifysubmission'] = '接收学生测验提交的通知';
$string['quiz:emailwarnoverdue'] = '当您的测验尝试过期时收到警告';
$string['quiz:grade'] = '手动评分测验';
$string['quiz:ignoretimelimits'] = '忽略测验时间限制';
$string['quiz:manage'] = '管理测验';
$string['quiz:manageoverrides'] = '管理测验覆盖设置';
$string['quiz:preview'] = '预览测验';
$string['quiz:regrade'] = '重新评分试答';
$string['quiz:reopenattempts'] = '重新打开从未提交的测验尝试';
$string['quiz:reviewmyattempts'] = '回顾您自己的试答';
$string['quiz:view'] = '查看测验信息';
$string['quiz:viewoverrides'] = '查看测验设置覆盖';
$string['quiz:viewreports'] = '查看测验报表';
$string['quizavailable'] = '此测验可用，直到：{$a}';
$string['quizclose'] = '关闭测验';
$string['quizclosed'] = '此测验关闭于 {$a}';
$string['quizcloses'] = '测验关闭';
$string['quizcloseson'] = '此测验将关闭于{$a}。';
$string['quizeventcloses'] = '{$a} 关闭';
$string['quizeventopens'] = '{$a} 开启';
$string['quizisclosed'] = '此测验已关闭';
$string['quizisclosedwillopen'] = '测验已关闭（{$a}开启）';
$string['quizisopen'] = '此测验已开启';
$string['quizisopenwillclose'] = '测验开启 ( {$a}关闭)';
$string['quiznavigation'] = '测验导航';
$string['quizopen'] = '开启测验';
$string['quizopenclose'] = '开启和关闭日期';
$string['quizopenclose_help'] = '学生只能在开启时间之后开始试答，并且必须在关闭时间之前完成试答。';
$string['quizopenclose_link'] = 'mod/quiz/timing';
$string['quizopendatesoonhtml'] = '<p>嗨 {$a->firstname},</p>
<p>课程 {$a->coursename}的测验 <strong>{$a->quizname}</strong> 即将开始.
<p><strong>开始时间: {$a->timeopen}</strong></p>
<p><strong>结束时间: {$a->timeclose}</strong></p>
<p><a href="{$a->url}">进入测验</a></p>';
$string['quizopendatesoonsubject'] = '将于 {$a->timeopen}开始: {$a->quizname}';
$string['quizopened'] = '此测验已开启。';
$string['quizopenedon'] = '此测验开启于{$a}';
$string['quizopens'] = '测验开启';
$string['quizopenwillclose'] = '此测验已开启，将于{$a}关闭';
$string['quizordernotrandom'] = '测验顺序没有打乱';
$string['quizorderrandom'] = '*测验顺序已打乱';
$string['quizreport'] = '测验报表';
$string['quizsettings'] = '测验设置';
$string['quizsetupnavigation'] = '测验设置导航';
$string['quiztimer'] = '测验计时器';
$string['quizwillopen'] = '此测验将开启{$a}';
$string['random'] = '随机题';
$string['randomcatwithsubcat'] = '{$a}和子类别';
$string['randomcoursecatwithsubcat'] = '课程类别{$a}内的任何类别';
$string['randomcoursewithsubcat'] = '这门课的任何类别';
$string['randomcreate'] = '创建随机题';
$string['randomediting'] = '编辑随机题';
$string['randomfaultynosubcat'] = '错误的问题';
$string['randomfromcategory'] = '随机题来自类别：';
$string['randomfromexistingcategory'] = '随机题来自已有类别';
$string['randomfromunavailabletag'] = '{$a} (不可用)';
$string['randommodulewithsubcat'] = '这个测验的任何类别';
$string['randomnosubcat'] = '试题只来自此类别，不是它的子类别。';
$string['randomnumber'] = '随机题数量';
$string['randomqname'] = '基于过滤条件的随机问题';
$string['randomqnamecat'] = '基于筛选条件的随机 ({$a->category})';
$string['randomqnamecattags'] = '带标签: {$a->tags}的基于筛选条件的随机 ({$a->category})';
$string['randomqnametags'] = '带标签：{$a}的基于筛选条件的随机问题';
$string['randomquestion'] = '随机题';
$string['randomquestion_help'] = '随机题是将随机选择的试题从指定类别或通过指定标签插入到活动中的一种方式。';
$string['randomquestiontags'] = '标签';
$string['randomquestiontags_help'] = '您可以通过在这里指定一些试题标签来进一步限制选择条件。

“随机”题将从所有具有这些标签的试题中选择。';
$string['randomquestionusinganewcategory'] = '随机题使用一个新类别';
$string['randomsystemwithsubcat'] = '任何系统级类别';
$string['randomwithsubcat'] = '试题来自这个类别及其子类别。';
$string['readytosend'] = '您即将发送整个测验去评分。您确定要继续吗？';
$string['reattemptquiz'] = '重新试答测验';
$string['recentlyaddedquestion'] = '最新试题！';
$string['recurse'] = '也包括子类别中的试题';
$string['redoesofthisquestion'] = '此处试答的其他试题：{$a}';
$string['redoquestion'] = '重作试题';
$string['regrade'] = '重新评分所有试答';
$string['regradecomplete'] = '所有试答已重新评分';
$string['regradecount'] = '{$a->changed}/{$a->attempt} 成绩已更改';
$string['regradedisplayexplanation'] = '在重新评分期间更改的试答将显示为指向试题回顾窗口的超链接';
$string['regradenotallowed'] = '您没有重新评分此测验的权限';
$string['regradingquestion'] = '重新评分 "{$a}"。';
$string['regradingquiz'] = '重新评分测验"{$a}"';
$string['remove'] = '移除';
$string['removeallgroupoverrides'] = '所有小组覆盖';
$string['removeallquizattempts'] = '所有试答';
$string['removealluseroverrides'] = '所有用户覆盖';
$string['removeemptypage'] = '移除空白页面';
$string['removepagebreak'] = '移除分页符';
$string['removeselected'] = '移除选定的';
$string['rename'] = '重命名';
$string['renderingserverconnectfailed'] = '服务器 {$a} 处理 RQP 请求失败。请检查 URL 是否正确。';
$string['reopenattempt'] = '重新打开';
$string['reopenattemptareyousuremessage'] = '这将通过{$a->attemptuser}重新打开尝试{$a->attemptnumber}。';
$string['reopenattemptareyousuretitle'] = '重新尝试吗?';
$string['reopenattemptwrongstate'] = '尝试{$a->attemptid}处于错误的状态 ({$a->state}) 需要重新打开。';
$string['reopenedattemptwillbeinprogress'] = '尝试将保持开放，并可以继续。';
$string['reopenedattemptwillbeinprogressuntil'] = '尝试将保持打开状态，并可以继续进行，直到测试在{$a}上结束。';
$string['reopenedattemptwillbesubmitted'] = '该尝试将立即提交给评分。';
$string['reorderquestions'] = '重新排序试题';
$string['reordertool'] = '显示重新排序工具';
$string['repaginate'] = '按每页{$a}道题重新分页';
$string['repaginatecommand'] = '重新分页';
$string['repaginatenow'] = '现在重新分页';
$string['replace'] = '替换';
$string['replacementoptions'] = '替换选项';
$string['report'] = '报表';
$string['reportanalysis'] = '单项分析';
$string['reportattemptsfrom'] = '试答来自';
$string['reportattemptsthatare'] = '试答状态';
$string['reportdisplayoptions'] = '显示选项';
$string['reportfullstat'] = '详细统计';
$string['reportmulti_percent'] = '多-百分比';
$string['reportmulti_q_x_student'] = '多-学生选择';
$string['reportmulti_resp'] = '个人回答';
$string['reportmustselectstate'] = '您必须至少选择一个状态。';
$string['reportnotfound'] = '‎未知报表‎ ({$a})';
$string['reportoverview'] = '概览';
$string['reportregrade'] = '重新评分试答';
$string['reportresponses'] = '详细的回答';
$string['reports'] = '报表';
$string['reportshowonly'] = '只显示试答';
$string['reportshowonlyfinished'] = '每个用户最多显示一次已结束的试答 ({$a})';
$string['reportsimplestat'] = '简单统计';
$string['reportusersall'] = '所有试答过测验的用户';
$string['reportuserswith'] = '已试答此测验的选课用户';
$string['reportuserswithorwithout'] = '已试答或未试答此测验的选课用户';
$string['reportuserswithout'] = '未试答此测验的选课用户';
$string['reportwhattoinclude'] = '报表中包括什么';
$string['requirepassword'] = '需要密码';
$string['requirepassword_help'] = '如果设置了密码，学生必须输入密码才能试答此测验。';
$string['requiresubnet'] = '限制网络地址';
$string['requiresubnet_help'] = '可以只允许局域网或Internet的某个子网访问测验。只需用逗号分隔若干个完整或不完整的IP地址。有监考的测验可以使用此功能来确保只有在指定地点的人可以访问测验。';
$string['response'] = '回答';
$string['responses'] = '回答';
$string['results'] = '结果';
$string['returnattempt'] = '返回试答';
$string['reuseifpossible'] = '重用先前移除的';
$string['reverttodefaults'] = '恢复测验默认值';
$string['review'] = '回顾';
$string['reviewafter'] = '允许在测验关闭后回顾';
$string['reviewalways'] = '允许在任意时间回顾';
$string['reviewattempt'] = '回顾试答';
$string['reviewbefore'] = '允许在测验开启时回顾';
$string['reviewclosed'] = '测验关闭后';
$string['reviewduring'] = '试答期间';
$string['reviewimmediately'] = '试答后马上';
$string['reviewnever'] = '不允许回顾';
$string['reviewofquestion'] = '回顾用户{$a->user}在{$a->quiz}中的试题 {$a->question}';
$string['reviewopen'] = '稍后，当测验仍然开启时';
$string['reviewoptions'] = '学生可以回顾';
$string['reviewoptionsheading'] = '回顾选项';
$string['reviewoptionsheading_help'] = '这些选项控制学生在回顾试答或查看测验报表时可以看到什么信息。

**试答期间**此设置仅与某些行为相关，例如“交互式多次尝试”，可以在试答期间显示反馈。

**试答后马上**此设置适用于点击“提交所有并结束”后的前两分钟。

**稍后，当测验仍然开启时**此设置适用于在此之后和测验关闭日期之前。

**测验关闭后**此设置适用于测验关闭日期过去之后。如果测验没有关闭日期，则永远不会达到此状态。';
$string['reviewoverallfeedback'] = '总体反馈';
$string['reviewoverallfeedback_help'] = '试答结束时给出的反馈，取决于学生的总分。';
$string['reviewresponse'] = '回顾回答';
$string['reviewresponsetoq'] = '回顾回答（试题：{$a}）';
$string['reviewthisattempt'] = '回顾您对此次试答的回答';
$string['rqp'] = '远程试题';
$string['rqps'] = '远程试题';
$string['sameasoverall'] = '与总体成绩相同';
$string['save'] = '保存';
$string['saveandedit'] = '保存更改并编辑试题';
$string['saveattemptfailed'] = '保存当前试答失败。';
$string['savedfromdeletedcourse'] = '从已删除的课程“{$a}”中保存';
$string['savegrades'] = '保存成绩';
$string['savemyanswers'] = '保存我的答案';
$string['savenosubmit'] = '保存但不提交';
$string['saveoverrideandstay'] = '保存并输入另一个覆盖';
$string['savequiz'] = '保存整个测验';
$string['saving'] = '保存中';
$string['savingnewgradeforquestion'] = '为试题（ID {$a}） 保存新分数。';
$string['savingnewmaximumgrade'] = '保存新的最高分。';
$string['score'] = '原始分数';
$string['scores'] = '分数';
$string['search:activity'] = '测验 - 活动信息';
$string['sectionheadingedit'] = '编辑标题“{$a}”';
$string['sectionheadingremove'] = '移除标题“{$a}”';
$string['sectionnoname'] = '无标题部分';
$string['seequestions'] = '(参见试题)';
$string['select'] = '选择';
$string['selectall'] = '全选';
$string['selectattempt'] = '选择试答';
$string['selectcategory'] = '选择类别';
$string['selectedattempts'] = '选择的试答…';
$string['selectmultipleitems'] = '选择多个项目';
$string['selectmultipletoolbar'] = '选择多个工具条';
$string['selectnone'] = '取消全选';
$string['selectquestionslot'] = '选择问题 {$a}';
$string['selectquestiontype'] = '-- 选择试题类型 --';
$string['sendnotificationopendatesoon'] = '通知用户测验开放日期即将到来';
$string['serveradded'] = '已添加服务器';
$string['serveridentifier'] = '标识符';
$string['serverinfo'] = '服务器信息';
$string['servers'] = '服务器';
$string['serverurl'] = '服务器 URL';
$string['shortanswer'] = '填空题';
$string['show'] = '显示';
$string['showall'] = '在一页上显示所有试题';
$string['showblocks'] = '试答期间显示版块';
$string['showblocks_help'] = '如果设置为是，那么在试答期间将显示常见的版块';
$string['showbreaks'] = '显示分页符';
$string['showcategorycontents'] = '显示类别内容{$a->arrow}';
$string['showcorrectanswer'] = '在反馈中显示正确答案吗？';
$string['showdetailedmarks'] = '显示分数详情';
$string['showeachpage'] = '一次显示一页';
$string['showfeedback'] = '回答后显示反馈吗？';
$string['showinsecurepopup'] = '使用“安全”弹出窗口进行试答';
$string['showlargeimage'] = '大图片';
$string['shownoattempts'] = '显示未试答的学生';
$string['shownoattemptsonly'] = '只显示未试答的学生';
$string['shownoimage'] = '没有图片';
$string['showreport'] = '显示报表';
$string['showsmallimage'] = '小图片';
$string['showteacherattempts'] = '显示教师试答';
$string['showuserpicture'] = '显示用户的图片';
$string['showuserpicture_help'] = '如果启用，在试答和回顾界面会显示学生的姓名和头像，这样在有监考的考试中，就能清楚地检查学生是否是以自己的身份登录的。';
$string['shuffle'] = '随机排列';
$string['shuffleanswers'] = '随机排列答案';
$string['shuffledrandomly'] = '随机排序';
$string['shufflequestions'] = '随机排列';
$string['shufflequestions_help'] = '如果启用，每次试答测验时，此部分试题的顺序将被随机排列为不同的随机顺序。

这会使学生们更难分享答案（防止作弊），但也会使学生们更难与教师讨论某个特定的试题。';
$string['shufflewithin'] = '试题内随机排列';
$string['shufflewithin_help'] = '如果启用，且试题设置中也启用了该选项，那么每当学生试答测验时，试题内的选项将被随机排列。此设置仅适用于具有多个选项的试题，比如选择题或匹配题。';
$string['singleanswer'] = '选择一个答案。';
$string['sortage'] = '按年龄排序';
$string['sortalpha'] = '按名称排序';
$string['sortquestionsbyx'] = '按{$a}排序试题';
$string['sortsubmit'] = '试题排序';
$string['sorttypealpha'] = '按类型、名称排序';
$string['specificapathnotonquestion'] = '指定的文件路径不在指定的试题上';
$string['specificquestionnotonquiz'] = '指定的试题不在指定的测验中';
$string['startagain'] = '重新开始';
$string['startattempt'] = '开始试答';
$string['startedon'] = '开始于';
$string['startnewpreview'] = '开始一个新预览';
$string['stateabandoned'] = '从未提交';
$string['statefinished'] = '已结束';
$string['statefinisheddetails'] = '已提交 {$a}';
$string['stateinprogress'] = '进行中';
$string['statenotloaded'] = '试题 {$a} 的状态还没有从数据库加载';
$string['stateoverdue'] = '过期';
$string['stateoverduedetails'] = '必须在 {$a} 之前提交';
$string['status'] = '状态';
$string['stoponerror'] = '出错停止';
$string['submission_confirmation'] = '提交你所有的答案并完成？';
$string['submission_confirmation_unanswered'] = '没有回答的问题：{$a}';
$string['submitallandfinish'] = '全部提交并结束';
$string['subneterror'] = '很抱歉，本测验被锁定为只能从特定地点登录。目前，您的计算机不在允许的范围内。';
$string['subnetnotice'] = '很抱歉，本测验被锁定为只能从特定地点登录。目前，您的计算机不在允许的子网范围内。但作为教师，您可以预览测验。';
$string['subplugintype_quiz'] = '报表';
$string['subplugintype_quiz_plural'] = '报表';
$string['subplugintype_quizaccess'] = '访问规则';
$string['subplugintype_quizaccess_plural'] = '访问规则';
$string['substitutedby'] = '将被替换为';
$string['summaryofattempt'] = '试答概要';
$string['summaryofattempts'] = '您先前试答的概要';
$string['temporaryblocked'] = '您暂时不可以重新试答测验。<br />您将可以再次试答：';
$string['theattempt'] = '此次试答';
$string['theattempt_help'] = '学生是否可以回顾所有试答。';
$string['time'] = '时间';
$string['timecompleted'] = '完成';
$string['timedelay'] = '不允许进行测验，因为您还没有通过试答时间间隔。';
$string['timeleft'] = '剩余时间';
$string['timelimit'] = '时间限制';
$string['timelimit_help'] = '如果启用，时间限制将在测验的初始页面上显示，并在测验导航版块中显示倒计时。';
$string['timelimit_link'] = 'mod/quiz/timing';
$string['timelimitexeeded'] = '很抱歉！测验时间限制已到！';
$string['timestr'] = '%y 年 %m 月 %d 日的 %H:%M:%S';
$string['timesup'] = '时间到！';
$string['timing'] = '定时';
$string['tofile'] = '到文件';
$string['tolerance'] = '容差';
$string['toomanyrandom'] = '所需的随机题数量超过了该类别中可用的数量！';
$string['top'] = '顶层';
$string['totalmarks'] = '总分';
$string['totalmarksx'] = '总分：{$a}';
$string['totalquestionsinrandomqcategory'] = '类别中共有{$a}道试题。';
$string['true'] = '对';
$string['truefalse'] = '判断题';
$string['type'] = '题型';
$string['unfinished'] = '开启';
$string['ungraded'] = '未评分';
$string['unit'] = '单位';
$string['unknowntype'] = '不支持行{$a}处的试题类型。该试题将被忽略';
$string['updatefilterconditon'] = '更新筛选条件';
$string['updatefilterconditon_success'] = '成功更新过滤条件';
$string['updateoverdueattemptstask'] = '更新过期的试答';
$string['updatequizslotswithrandomxofy'] = '使用“随机”题数据({$a->done}/{$a->total})更新测验';
$string['updatesettings'] = '更新测验设置';
$string['updatingatttemptgrades'] = '更新试答成绩。';
$string['updatingfinalgrades'] = '更新最终成绩。';
$string['updatingthegradebook'] = '更新成绩册。';
$string['upgradesure'] = '<div>‎特别是，测验模块将执行测验表的大量更改，并且此升级尚未经过充分测试。 强烈建议您在继续之前备份数据库表。‎</div>';
$string['upgradingquizattempts'] = '升级试答：测验 {$a->done}/{$a->outof} (测验 ID {$a->info})';
$string['upgradingveryoldquizattempts'] = '升级非常旧的试答：{$a->done}/{$a->outof}';
$string['url'] = '网页地址';
$string['usedcategorymoved'] = '该类别已保存并移至站点级别，因为它是已公布的类别，其他课程仍在使用。';
$string['useroverrides'] = '用户覆盖';
$string['useroverridesdeleted'] = '用户覆盖已删除';
$string['usersnone'] = '‎没有学生可以访问此测验 ‎';
$string['validate'] = '验证';
$string['viewallanswers'] = '查看{$a}次试答';
$string['viewallreports'] = '查看{$a}试答的报表';
$string['viewed'] = '已查看';
$string['warningmissingtype'] = '<b>此试题是一个还没有安装在您的Moodle上的题型。<br />请通知您的Moodle管理员。</b>';
$string['wheregrade'] = '我的成绩在哪里？';
$string['wildcard'] = '通配符';
$string['windowclosing'] = '此窗口稍后会关闭。';
$string['withsummary'] = '概览统计';
$string['wronguse'] = '您不能这样使用此页';
$string['xhtml'] = 'XHTML';
$string['youneedtoenrol'] = '在您试答这个测验之前，您需要加入此课程';
$string['yourfinalgradeis'] = '您此测验的最终成绩是{$a}。';
