<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'forum', language 'eu', version '5.0'.
 *
 * @package     forum
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['actionsforgraderinterface'] = 'Kalifikatzaile-interfazerako ekintzak';
$string['actionsforpost'] = 'Mezuarentzako ekintzak';
$string['activitydate:due'] = 'Entregatze-data:';
$string['activityoverview'] = 'Mezu berriak daude foroan';
$string['addanewdiscussion'] = 'Gehitu eztabaidagaia';
$string['addanewquestion'] = 'Gehitu galdera berria';
$string['addanewtopic'] = 'Gehitu eztabaidagai berria';
$string['addreply'] = 'Gehitu erantzuna';
$string['addtofavourites'] = 'Nabarmendu eztabaida hau';
$string['advancedsearch'] = 'Bilaketa aurreratua';
$string['alldiscussions'] = 'Eztabaida guztiak';
$string['allforums'] = 'Foro guztiak';
$string['allowdiscussions'] = '{$a} batek foro honetan idatz dezake?';
$string['allowsallsubscribe'] = 'Foro honetan bakoitzak erabakitzen du harpidetu ala ez.';
$string['allowsdiscussions'] = 'Foro honek partaide bakoitzari eztabaidagai bat hasteko aukera ematen dio.';
$string['allsubscribe'] = 'Harpidetu foro guztietara';
$string['allunsubscribe'] = 'Kendu foro guztietako harpidetza';
$string['allusers'] = 'Erabiltzaile guztiak';
$string['alreadyfirstpost'] = 'Dagoeneko hau da eztabaidako lehen mezua.';
$string['announcementsettings'] = 'Lehenetsitako Albisteak foroaren ezarpenak';
$string['announcementsettings_help'] = 'Ezarpen hauek Albisteak foro guztietarako lehenetsitako balioak zehazten dituzte.';
$string['anyfile'] = 'Edozein fitxategi';
$string['areaattachment'] = 'Eranskinak';
$string['areapost'] = 'Mezuak';
$string['attachment'] = 'Eranskina';
$string['attachment_help'] = 'Nahi izanez gero, foroetako mezu batean fitxategi bat baino gehiago erantsi ahal duzu. Eranskina irudia baldin bada, mezuaren amaieran erakutsiko da.';
$string['attachmentname'] = 'Eranskina {$a}';
$string['attachmentnameandfilesize'] = '{$a->name} ({$a->size})';
$string['attachmentnopost'] = 'Mezu id-rik gabe ezin duzu eranskinik esportatu';
$string['attachments'] = 'Eranskinak';
$string['attachmentswordcount'] = 'Eranskinak eta hitz-kontagailua';
$string['authorreplyingprivatelytoauthor'] = '{$a->respondant}(e)k modu pribatuan {$a->author}(e)ri erantzunez';
$string['authorreplyingtoauthor'] = '{$a->respondant}(e)k {$a->author}(e)ri erantzunez';
$string['availability'] = 'Eskuragarritasuna';
$string['blockafter'] = 'Blokeoa eragiteko mezu-kopurua';
$string['blockafter_help'] = 'Ezarpen honek zehazten du emandako denbora-tartean gehienez zenbat mezu bidal dezakeen erabiltzaileak. mod/forum:postwithoutthrottling gaitasuna duten erabiltzaileek ez dute mezu-mugarik izango.';
$string['blockperiod'] = 'Blokeoa eragiteko gutxieneko denbora-tartea';
$string['blockperiod_help'] = 'Ikasleei blokeatu egin ahal zaie denbora-tarte baterako ezarritako mezu-kopurua baino gehiago bidaltzeko aukera. mod/forum:postwithoutthrottling gaitasuna duten erabiltzaileek ez dute mezu-mugarik izango.';
$string['blockperioddisabled'] = 'Ez blokeatu';
$string['blogforum'] = 'Blog-formatuan azaltzen den foro estandarra';
$string['bynameondate'] = '{$a->name} - {$a->date}';
$string['cachedef_forum_count_discussions'] = 'Foroko eztabaida kopurua';
$string['cachedef_forum_is_tracked'] = 'Erabiltzailearentzako foroetako jarraipenaren egoera';
$string['calendardue'] = '{$a}(r)en amaiera-data';
$string['cancelreply'] = 'Baztertu erantzuna';
$string['cannotadd'] = 'Ezin da eztabaidarik gehitu foro honetan';
$string['cannotadddiscussion'] = 'Foro honetan eztabaidak gehitzeko talde bateko kide izan behar da';
$string['cannotadddiscussionall'] = 'Ez duzu baimenik partaide guztientzako eztabaidagai berriak gehitzeko.';
$string['cannotadddiscussiongroup'] = 'Ezin duzu eztabaida sortu ez zarelako ezein taldetako kide.';
$string['cannotaddsubscriber'] = 'Ezin da {$a} id-a duen harpideduna gehitu foro honetan!';
$string['cannotaddteacherforumto'] = 'Ezin izan da irakasleen foroa jarri ikastaroaren 0 atalean';
$string['cannotcreatediscussion'] = 'Ezin da eztabaida sortu';
$string['cannotcreateinstanceforteacher'] = 'Ezin izan da sortu  erregistro berririk irakasleen foroarentzat course_module taulan';
$string['cannotdeletepost'] = 'Ezin duzu mezu hau ezabatu!';
$string['cannoteditposts'] = 'Ezin duzu beste pertsonen mezurik editatu!';
$string['cannotexportforum'] = 'Ezin duzu foro hau esportatu';
$string['cannotfavourite'] = 'Sentitzen dugu, baina ez duzu eztabaidak nabarmentzeko baimenik.';
$string['cannotfinddiscussion'] = 'Ezin duzu eztabaidarik aurkitu foro honetan';
$string['cannotfindfirstpost'] = 'Ezin da lehenbiziko mezua aurkitu foro honetan';
$string['cannotfindorcreateforum'] = 'Ezin da gune honetako albisteen foro nagusia aurkitu edo sortu';
$string['cannotfindparentpost'] = 'Ezin da {$a} mezuaren goragoko kategoria aurkitu';
$string['cannotmovefromsingleforum'] = 'Ezin da eztabaida mugitu eztabaida bakarra motako foro batetik';
$string['cannotmovenotvisible'] = 'Foroa ez dago ikusgai';
$string['cannotmovetonotexist'] = 'Ezin duzu foro honetara mugitu - ez du esistitzen!';
$string['cannotmovetonotfound'] = 'Helburu-foroa ez da ikastaro honetan aurkitu.';
$string['cannotmovetosingleforum'] = 'Ezin da eztabaida mugitu eztabaida bakarra motako foro batera';
$string['cannotpindiscussions'] = 'Sentitzen dugu, baina ez duzu eztabaidak finkatzeko baimenik.';
$string['cannotpurgecachedrss'] = 'Ezin izan da jatorrizko edota helmugako foroaren RSS jarioaren cache-a ezabatu - aztertu zure permissionforums fitxategia';
$string['cannotremovesubscriber'] = 'Ezin da {$a} id-a duen harpideduna kendu foro honetatik!';
$string['cannotreply'] = 'Ezin diozu mezu honi erantzun';
$string['cannotsplit'] = 'Foro honetako eztabaidak ezin dira bereizi';
$string['cannotsubscribe'] = 'Sentitzen dugu, baina taldekidea izan behar duzu harpidetzeko';
$string['cannottrack'] = 'Ezin zaio foro honi jarraitzeari utzi';
$string['cannotunsubscribe'] = 'Ezin duzu foro honetatik harpidetza kendu';
$string['cannotupdatepost'] = 'Ezin duzu mezu hau eguneratu';
$string['cannotuseseperategroupsandsingletopic'] = 'Taldeek ezin elkar ikusi modua ezin da eztabaida bakarra motako foroetan erabili';
$string['cannotusesingletopicandseperategroups'] = 'Eztabaida bakarra motako foroetan ezin da taldeek ezin elkar ikusi modua erabili';
$string['cannotviewpostyet'] = 'Ezin duzu eztabaida honetan beste ikasleek idatzitako mezurik irakurri oraindik ez baituzu mezurik bidali.';
$string['cannotviewusersposts'] = 'Ez dago ikus dezakezun erabiltzaile honen mezurik.';
$string['cleanreadtime'] = 'Mezu zaharrak irakurritzat markatzeko ordua';
$string['clicktofavourite'] = 'Eztabaida hau ez dago nabarmenduta. Egin klik nabarmentzeko.';
$string['clicktolockdiscussion'] = 'Egin klik eztabaida hau blokeatzeko';
$string['clicktosubscribe'] = 'Ez zaude eztabaida honetara harpidetuta. Egin klik harpidetzeko.';
$string['clicktounfavourite'] = 'Eztabaida hau nabarmendu duzu. Egin klik ez nabarmentzeko.';
$string['clicktounlockdiscussion'] = 'Egin klik eztabaida desblokeatzeko';
$string['clicktounsubscribe'] = 'Eztabaida honetara harpidetuta zaude. Egin klik harpidetza kentzeko.';
$string['close'] = 'Itxi';
$string['closegrader'] = 'Itxi kalifikatzailea';
$string['completiondetail:discussions'] = 'Eztabaidak hastea: {$a}';
$string['completiondetail:posts'] = 'Foroetako mezuak idaztea: {$a}';
$string['completiondetail:replies'] = 'Erantzunak idaztea: {$a}';
$string['completiondiscussions'] = 'Eztabaidak sortzea';
$string['completiondiscussionsdesc'] = 'Erabiltzaileak gutxienez {$a} elkarrizketa sortu behar ditu';
$string['completionposts'] = 'Eztabaidak sortzea edo erantzunak bidaltzea';
$string['completionpostsdesc'] = 'Erabiltzaileak gutxienez {$a} elkarrizketa edo erantzun idatzi behar ditu';
$string['completionpostshelp'] = 'Osatzeko eztabaidak edo erantzunak behar ditu';
$string['completionpostsinforums'] = 'Mezuak foroetan';
$string['completionreplies'] = 'Erantzunak bidaltzea';
$string['completionrepliesdesc'] = 'Erabiltzaileak gutxienez {$a} erantzun idatzi behar ditu';
$string['configcleanreadtime'] = 'Irakurketa-taulako mezu zaharrak garbitzeko ordua';
$string['configdigestmailtime'] = 'Posta elektroniko bidezko jakinarazpenak laburpen gisa jasotzea aukeratzen dutenei egunean laburpen-mezu bakarra bidaliko zaie. Ezarpen honek e-maila eguneko zer ordutan bidaliko den zehazten du (aukeratutako orduaren ondorengo lehenengo cronaren bitartez).';
$string['configdisplaymode'] = 'Besterik adierazi ezean, eztabaida honela ikusiko da';
$string['configenablerssfeeds'] = 'Honek RSS jarioetarako aukera gaitzen du foro guztietarako. Ondoren foro bakoitzeko ezarpenetan gaitu beharko dituzu jarioak.';
$string['configenabletimedposts'] = 'Aukeratu \'bai\' foroan beste eztabaida bat erakusteko denbora tarteen ezarpenak egiten uzteko.';
$string['configlongpost'] = 'Luzera hau gainditzen duen mezua (HTML kodea albo batera utzirik) luzeegitzat jotzen da. Gunearen hasiera-orrian, foro-formatua duten ikastaroetako orrietan edo erabiltzaile-profiletan erakutsitako mezuak laburtuko dira forum_shortpost eta forum_longpost arteko tamaina natural bateraino. Luzera hau gainditzen duen mezua (HTML kodea albo batera utzirik) luzeegitzat jotzen da.';
$string['configmanydiscussions'] = 'Orrialde bakoitzean gehienez zenbat mezu edo eztabaida erakutsi behar diren';
$string['configmaxattachments'] = 'Lehenetsitako gehieneko eranskin kopurua mezuko.';
$string['configmaxbytes'] = 'Gune honetan foroetako mezuen eranskinek izan dezaketen gehieneko tamaina, besterik adierazi ezean (zerbitzariaren ezarpenen eta ikastaroaren mugen baitan)';
$string['configoldpostdays'] = 'Mezuak zenbat egunetatik aurrera hartuko diren irakurritzat';
$string['configreplytouser'] = 'Foroetako mezu baten jakinarazpena posta elektronikoz bidaltzen bada, erabiltzailearen helbide elektronikoa izan behar al du jasotzen dutenek foroan erantzun beharrean zuzenean erantzun ala izateko? Nahiz eta \'bai\' aukeratu, erabiltzaileek beren profilean erabaki dezakete helbide elektronikoa sekretupean mantentzea.';
$string['configrssarticlesdefault'] = 'RSS jarioak gaituta egonez gero, ezarri lehenetsitako artikulu kopurua (eztabaidak edota mezuak).';
$string['configrsstypedefault'] = 'RSS jarioak gaituta egonez gero, lehenetsitako jarduera mota ezartzen du.';
$string['configshortpost'] = 'Luzera honetara iristen ez den edozein mezu (HTML kodea barne hartu gabe) laburtzat hartuko da.';
$string['configsubscriptiontype'] = 'Harpidetza-moduaren ezarpen lehenetsia';
$string['configtrackingtype'] = 'Lehenetsitako ezarpena irakurri gabekoak nabarmentzeko.';
$string['configtrackreadposts'] = 'Aukeratu \'bai\' erabiltzaile bakoitzarentzat irakurria/irakurri gabea jarraitzeko.';
$string['configusermarksread'] = '\'Bai\' aukeratuta eskuz markatu behar du erabiltzaileak mezua irakurrita dagoela. \'Ez\' aukeratuta mezua ikusitakoan irakurritako gisa markatuko da.';
$string['confirmsubscribe'] = 'Ziur al zaude \'{$a}\' forora harpidetu nahi duzula?';
$string['confirmsubscribediscussion'] = 'Ziur al zaude \'{$a->forum}\' foroko \'{$a->discussion}\' eztabaidara harpidetu nahi duzula?';
$string['confirmunsubscribe'] = 'Ziur al zaude \'{$a}\' forotik  harpidetza kendu nahi duzula?';
$string['confirmunsubscribediscussion'] = 'Ziur al zaude \'{$a->forum}\' foroko \'{$a->discussion}\' eztabaidatik harpidetza kendu nahi duzula?';
$string['couldnotadd'] = 'Ezin izan da zure mezua gehitu; errore bat gertatu da nonbait.';
$string['couldnotdeletereplies'] = 'Sentitzen dugu, hori ezin da ezabatu norbaitek dagoeneko erantzun diolako';
$string['couldnotupdate'] = 'Ezin izan da zure mezua eguneratu; errore bat gertatu da nonbait.';
$string['created'] = 'Sortu da';
$string['crontask'] = 'Foroetako mailing eta mantenu lanak';
$string['cutoffdate'] = 'Itxiera-data';
$string['cutoffdate_help'] = 'Gaituz gero, foroak ez du data horren osteko mezurik onartuko.';
$string['cutoffdatereached'] = 'Foro honetan idazteko itxiera-data igaro da eta ondorioz dagoeneko ezin duzu bertan idatzi.';
$string['cutoffdatevalidation'] = 'Itxiera-data ezin da amaiera-data baino lehenagokoa izan.';
$string['delete'] = 'Ezabatu';
$string['deleteddiscussion'] = 'Eztabaidagaia ezabatu da';
$string['deletedpost'] = 'Mezua ezabatu da';
$string['deletedposts'] = 'Mezuak ezabatuta';
$string['deleteduser'] = 'Ezabatutako erabiltzailea';
$string['deletesure'] = 'Ziur zaude mezu hau ezabatu nahi duzula?';
$string['deletesureplural'] = 'Ziur zaude mezu hau eta erantzun guztiak ezabatu nahi dituzula? ({$a} mezu)';
$string['digestmailheader'] = '{$a->sitename} guneko foroetako mezu berrien eguneko laburpen-mezua da hau. Foroetako zure posta elektronikoko ezarpenak editatzeko joan zaitez hona: {$a->userprefs}';
$string['digestmailpost'] = 'Aldatu zure foroetako laburpen-mezuen hobespenak';
$string['digestmailpostlink'] = 'Aldatu zure foroetako laburpen-mezuen hobespenak: {$a}';
$string['digestmailprefs'] = 'zure erabiltzaile-profila';
$string['digestmailsubject'] = '{$a}: foroetako mezuen laburpena';
$string['digestmailtime'] = 'Laburpen-mezuak bidaltzeko ordua';
$string['digestsentusers'] = 'Posta elektroniko bidezko laburpen-mezuak ondo bidali zaizkie {$a} erabiltzaileri.';
$string['disallowsubscribe'] = 'Ezin da harpidetzarik egin';
$string['disallowsubscribeteacher'] = 'Ezin da harpidetzarik egin (irakasleentzat izan ezik)';
$string['disallowsubscription'] = 'Harpidetza';
$string['disallowsubscription_help'] = 'Foro hau bertako eztabaidetara harpidetzea ez baimentzeko konfiguratuta dago.';
$string['discussion'] = 'Eztabaida';
$string['discussionlistsortbycreatedasc'] = 'Ordenatu sorrera-dataren arabera (zaharrenetik berrienera)';
$string['discussionlistsortbycreateddesc'] = 'Ordenatu sorrera-dataren arabera (berrienetik zaharrenera)';
$string['discussionlistsortbydiscussionasc'] = 'Ordenatu eztabaidaren izenaren arabera behetik gora';
$string['discussionlistsortbydiscussiondesc'] = 'Ordenatu eztabaidaren izenaren arabera goitik behera';
$string['discussionlistsortbygroupasc'] = 'Ordenatu taldearen arabera behetik gora';
$string['discussionlistsortbygroupdesc'] = 'Ordenatu taldearen arabera goitik behera';
$string['discussionlistsortbylastpostasc'] = 'Ordenatu azken mezuen sorrera-dataren arabera (zaharrenetik berrienera)';
$string['discussionlistsortbylastpostdesc'] = 'Ordenatu azken mezuen sorrera-dataren arabera (berrienetik zaharrenera)';
$string['discussionlistsortbyrepliesasc'] = 'Ordenatu erantzun kopuruaren arabera (behetik gora)';
$string['discussionlistsortbyrepliesdesc'] = 'Ordenatu erantzun kopuruaren arabera (goitik behera)';
$string['discussionlistsortbystarterasc'] = 'Ordenatu eztabaida sortzailearen izenaren arabera behetik gora';
$string['discussionlistsortbystarterdesc'] = 'Ordenatu eztabaida sortzailearen izenaren arabera goitik behera';
$string['discussionlocked'] = 'Eztabaida hau blokeatu da eta beraz aurrerantzean ezingo duzu bertan erantzun.';
$string['discussionlockingdisabled'] = 'Ez blokeatu eztabaidak';
$string['discussionlockingheader'] = 'Eztabaiden blokeoa';
$string['discussionmoved'] = 'Gai hau hona mugitu da:  {$a}';
$string['discussionmovedpost'] = 'Eztabaida hau <a href="{$a->discusshref}">hona</a> eraman da <a href="{$a->forumhref}">{$a->forumname}</a> forora.';
$string['discussionname'] = 'Eztabaidaren izena';
$string['discussionnownotsubscribed'] = '{$a->name}(r)i EZ zaio \'{$a->forum}\' foroko \'{$a->discussion}\' eztabaidako mezu berrien jakinarazpenik bidaliko.';
$string['discussionnowsubscribed'] = '\'{$a->forum}\' foroko \'{$a->discussion}\' eztabaidako mezu berrien jakinarazpenak bidaliko zaizkizu.';
$string['discussionpin'] = 'Finkatu';
$string['discussionpinned'] = 'Finkatuta';
$string['discussionpinned_help'] = 'Finkatutako eztabaidak foroaren hasieran agertuko dira.';
$string['discussions'] = 'Eztabaidak';
$string['discussionsplit'] = 'Eztabaida erdibitu da';
$string['discussionsstartedby'] = '{$a}(e)k hasitako eztabaidak';
$string['discussionsstartedbyrecent'] = '{$a}(e)k orain gutxi hasitako eztabaidak';
$string['discussionsstartedbyuserincourse'] = '{$a}(e)k orain gutxi hasitako eztabaidak {$a->coursename} ikastaroan';
$string['discussionsstartedincourse'] = '{$a} hasitako eztabaidak';
$string['discussionstartedby'] = '{$a} erabiltzaileak hasitako eztabaida';
$string['discussionsubscribed'] = 'Eztabaida honetara harpidetuta zaude orain.';
$string['discussionsubscribestart'] = 'Bidali niri eztabaida honetako mezu berrien jakinarazpenak';
$string['discussionsubscribestop'] = 'Ez dut eztabaida honetako mezu berrien jakinarazpenik nahi';
$string['discussionsubscription'] = 'Eztabaidaren harpidetza';
$string['discussionsubscription_help'] = 'Eztabaida batera harpidetzean bertako mezu berrien jakinarazpenak jaso nahi dituzula adierazten duzu.';
$string['discussionunpin'] = 'Kendu finkatzea';
$string['discussionunsubscribed'] = 'Eztabaida honetako harpidetza kendu duzu.';
$string['discussthistopic'] = 'Eztabaidatu gai hau';
$string['discusstopicname'] = 'Eztabaidatu gaia: {$a}';
$string['displayend'] = 'Erakusteko amaiera-data';
$string['displayend_help'] = 'Ezarpen honek foroko mezua data jakin batetik aurrera ezkutatu behar den ala ez zehazten du. Kontuan hartu  kudeatzaileek beti ikusiko dituztela.';
$string['displayenddate'] = 'Erakusteko amaiera-data: {$a}.';
$string['displaymode'] = 'Erakusteko modua';
$string['displayperiod'] = 'Erakusteko epea';
$string['displaystart'] = 'Erakusteko hasiera-data';
$string['displaystart_help'] = 'Ezarpen honek foroko mezua data jakin batetik aurrera erakutsi behar den ala ez zehazten du. Kontuan hartu  kudeatzaileek beti ikusiko dituztela.';
$string['displaystartdate'] = 'Erakusteko hasiera-data: {$a}.';
$string['displaywordcount'] = 'Erakutsi hitz-kontagailua';
$string['displaywordcount_help'] = 'Ezarpen honek zehazten du mezu bakoitzaren hitz-kontagailua erakutsiko den ala ez';
$string['duedate'] = 'Amaiera-data';
$string['duedate_help'] = 'Hau foroan idazteko amaiera-data da. Data hau egutegian foroaren amaiera-data gisa erakusten den arren, horren ostean ere erantzunak baimenduko dira. Data zehatz batetik aurrera mezuak idaztea ekiditeko foroaren itxiera-data zehaztu ezazu.';
$string['duedatetodisplayincalendar'] = 'Egutegian erakusteko amaiera-data';
$string['eachuserforum'] = 'Pertsona bakoitzak eztabaida bat bidaltzen du';
$string['edit'] = 'Editatu';
$string['editdiscussion'] = 'Editatu eztabaida';
$string['editdiscussiontopic'] = 'Editatu eztabaidaren gaia';
$string['editedby'] = '{$a->name}(e)k {$a->date} editatu du';
$string['editedpostupdated'] = '{$a}(r)en mezua eguneratu da';
$string['editing'] = 'Editatzen';
$string['emaildigestcompleteshort'] = 'Laburpena - Mezu osoak';
$string['emaildigestdefault'] = 'Lehenetsitakoa ({$a})';
$string['emaildigestoffshort'] = 'Laburpenik ez';
$string['emaildigestsubjectsshort'] = 'Laburpena - Gaiak soilik';
$string['emaildigesttype'] = 'Posta elektroniko bidezko laburpen-mezuen aukerak';
$string['emaildigesttype_help'] = 'Foro bakoitzetik jasoko duzun jakinarazpen mota.

* Lehenetsitakoa - erabiltzailearen profilean ezarritakoa aplikatzen da. Zure profila eguneratzen baduzu, aldaketa hori hemen ere islatuko da;
* Laburpenik ez - foroetako mezu bakoitzeko e-mail bana jasoko duzu;
* Laburpena - mezu osoak - egun bakoitzean foro bakoitzeko mezuen eduki guztiak dituen laburpen-mezu bat jasoko duzu;
* Laburpena - gaiak soilik - egun bakoitzean foro bakoitzeko mezuen izenburuak dituen laburpen-mezu bat jasoko duzu.';
$string['emptymessage'] = 'Zerbait oker dabil zure mezuarekin. Agian hutsik utzi duzu, edo eranskina handiegia da.  Zure aldaketak EZ dira gorde.';
$string['errorcannotlock'] = 'Ez duzu eztabaidak blokeatzeko baimenik.';
$string['errordiscussionnotfound'] = 'Eztabaida ez da aurkitu';
$string['erroremptymessage'] = 'Mezua ezin da hutsik egon';
$string['erroremptysubject'] = 'Mezuaren gaia ezin da hutsik egon';
$string['errorenrolmentrequired'] = 'Ikastaro honetan matrikulatuta egon behar duzu eduki hau ikusteko.';
$string['errorforumnotfound'] = 'Eztabaida honi dagokion foroa ez da aurkitu';
$string['errorwhiledelete'] = 'Errorea gertatu da erregistroa ezabatzean.';
$string['eventassessableuploaded'] = 'Mezua bidali da.';
$string['eventcoursesearched'] = 'Ikastaroa bilatu da';
$string['eventdiscussioncreated'] = 'Eztabaida sortu da';
$string['eventdiscussiondeleted'] = 'Eztabaida ezabatu da';
$string['eventdiscussionlockupdated'] = 'Eztabaida-blokeoa eguneratuta';
$string['eventdiscussionmoved'] = 'Eztabaida mugitu da';
$string['eventdiscussionpinned'] = 'Eztabaida finkatua.';
$string['eventdiscussionsubscriptioncreated'] = 'Eztabaidaren harpidetza sortu da';
$string['eventdiscussionsubscriptiondeleted'] = 'Eztabaidaren harpidetza ezabatu da';
$string['eventdiscussionunpinned'] = 'Eztabaida finkatzea kendu da';
$string['eventdiscussionupdated'] = 'Eztabaida eguneratu da';
$string['eventdiscussionviewed'] = 'Eztabaida ikusi da';
$string['eventforumsubscriptionupdated'] = 'Harpidetza modua eguneratuta';
$string['eventpostcreated'] = 'Mezua sortu da';
$string['eventpostdeleted'] = 'Mezua ezabatu da';
$string['eventpostupdated'] = 'Mezua eguneratu da';
$string['eventreadtrackingdisabled'] = 'Irakurri gabekoak nabarmentzea desgaituta';
$string['eventreadtrackingenabled'] = 'Irakurri gabekoak nabarmentzea gaituta';
$string['eventsubscribersviewed'] = 'Harpidedunak ikusi dira';
$string['eventsubscriptioncreated'] = 'Harpidetza sortu da';
$string['eventsubscriptiondeleted'] = 'Harpidetza ezabatu da';
$string['eventuserreportviewed'] = 'Erabiltzaile-txostena ikusita';
$string['everyonecanchoose'] = 'Edonork aukera dezake harpidetzea';
$string['everyonecannowchoose'] = 'Orain bakoitzak aukeratzen du harpidetu ala ez';
$string['everyoneisnowsubscribed'] = 'Orain denak daude foro honetan harpidetuta';
$string['everyoneissubscribed'] = 'Denak daude foro honetara harpidetuta';
$string['existingsubscribers'] = 'Oraingo harpidedunak';
$string['export'] = 'Esportatu';
$string['exportattachmentname'] = 'Esportatu {$a} eranskina portfoliora';
$string['exportdiscussion'] = 'Esportatu eztabaida osoa portfoliora';
$string['exporthumandates'] = 'Pertsonek irakurtzeko moduko datak';
$string['exporthumandates_help'] = 'Datak pertsonek irakurtzeko moduko formatuan esportatzeko edo timestamp formatuan (zenbaki sekuentzia) esportatuko diren.';
$string['exportoptions'] = 'Esportatu aukerak';
$string['exportstriphtml'] = 'Kendu HTMLa';
$string['exportstriphtml_help'] = 'p edo br motako HTML etiketak foroetako mezuetatik kendu behar diren edo ez.';
$string['favourites'] = 'Nabarmenduta';
$string['favouriteupdated'] = 'Zure nabarmentze-aukera eguneratu da.';
$string['firstpost'] = 'Lehen mezua';
$string['forcedreadtracking'] = 'Baimendu Irakurri gabekoak nabarmentzea behartzea';
$string['forcedreadtracking_desc'] = 'Foroak irakurri gabekoen nabarmentzea behartzea baimentzen du. Honek erabiltzaile batzuen errendimendua jaits dezake, bereziki foro eta mezu askoko ikastaroetan. Desgaituz gero, aurretik Behartu ezarpena zuten foroak Hautazkoa gisa tratatuak izango dira.';
$string['forcesubscribed'] = 'Foro honek denak behartzen ditu harpidetzera.';
$string['forcesubscribed_help'] = 'Foro hau eztabaidetatik baja ematea ez baimentzeko konfiguratu da.';
$string['forum'] = 'Foroa';
$string['forum:addinstance'] = 'Gehitu foro berria';
$string['forum:addnews'] = 'Gehitu albisteak';
$string['forum:addquestion'] = 'Gehitu galdera';
$string['forum:allowforcesubscribe'] = 'Baimendu behartutako harpidetza';
$string['forum:canmailnow'] = 'G eta E foroan mezuak atzerapenik gabe bidali ditzake';
$string['forum:canoverridecutoff'] = 'Idatzi foroetan itxiera-dataren ondoren';
$string['forum:canoverridediscussionlock'] = 'Erantzun blokeatutako eztabaidetan';
$string['forum:canposttomygroups'] = 'Idatzi sarbidea duzun talde guztietan';
$string['forum:cantogglefavourite'] = 'Nabarmendu eztabaidak';
$string['forum:createattachment'] = 'Sortu erantsitako fitxategiak';
$string['forum:deleteanypost'] = 'Ezabatu edozein mezu (edonoiz)';
$string['forum:deleteownpost'] = 'Ezabatu norberaren mezuak (data baino lehen)';
$string['forum:editanypost'] = 'Editatu edozein mezu';
$string['forum:exportdiscussion'] = 'Esportatu eztabaida osoa';
$string['forum:exportforum'] = 'Esportatu foroa';
$string['forum:exportownpost'] = 'Norberaren mezua esportatu';
$string['forum:exportpost'] = 'Esportatu mezua';
$string['forum:grade'] = 'Kalifikatu foroa';
$string['forum:managesubscriptions'] = 'Kudeatu harpidedunak';
$string['forum:movediscussions'] = 'Mugitu eztabaidak';
$string['forum:pindiscussions'] = 'Finkatu eztabaidak';
$string['forum:postprivatereply'] = 'Erantzun mezuei modu pribatuan';
$string['forum:postwithoutthrottling'] = 'Blokeoa eragiteko mezu-kopururik gabe';
$string['forum:rate'] = 'Kalifikatu mezuak';
$string['forum:readprivatereplies'] = 'Ikusi erantzun pribatuak';
$string['forum:replynews'] = 'Erantzun albisteen foroari';
$string['forum:replypost'] = 'Erantzun mezuei';
$string['forum:splitdiscussions'] = 'Bereizi eztabaidak';
$string['forum:startdiscussion'] = 'Hasi beste eztabaida bat';
$string['forum:viewallratings'] = 'Ikusi erabiltzaileek emandako kalifikazio guztiak';
$string['forum:viewanyrating'] = 'Ikusi besteren batek denera jasotako kalifikazioak';
$string['forum:viewdiscussion'] = 'Ikusi eztabaidak';
$string['forum:viewhiddentimedposts'] = 'Ikusi programatutako mezu ezkutuak';
$string['forum:viewqandawithoutposting'] = 'Ikusi beti G eta E mezuak';
$string['forum:viewrating'] = 'Ikusi denera jasotako kalifikazioak';
$string['forum:viewsubscribers'] = 'Ikusi harpidedunak';
$string['forumauthorhidden'] = 'Egilea (ezkutuan)';
$string['forumblockingalmosttoomanyposts'] = 'Gehieneko mezu-kopurutik hurbil zaude. {$a->numposts} bidali dituzu azken {$a->blockperiod} eta gehienez {$a->blockafter} bidal daitezke.';
$string['forumbodydeleted'] = 'Foroko mezu honetako edukiak ezabatuak izan dira eta ez daude eskuragarri.';
$string['forumbodyhidden'] = 'Mezu hau ezkutuan dago une honetan, ziurrenik aurretik eztabaida honetara mezua bidali behar duzulako. Beste aukera bat une honetan mezua ikusteko epetik kanpo egotea izan daiteke.';
$string['forumgrader'] = 'Foroko kalifikatzailea';
$string['forumgradingnavigation'] = 'Foroko kalifikatzailearen nabigazioa';
$string['forumgradingpanel'] = 'Foroko kalifikatzaile-panela';
$string['forumintro'] = 'Deskribapena';
$string['forumname'] = 'Foroaren izena';
$string['forumposts'] = 'Foroetako mezuak';
$string['forums'] = 'Foroak';
$string['forumsubjectdeleted'] = 'Foroko mezu hau ezabatua izan da.';
$string['forumsubjecthidden'] = 'Gaia (ezkutuan)';
$string['forumtracked'] = 'Irakurri gabeko mezuen jarraipena egiten ari da';
$string['forumtrackednot'] = 'Ez da irakurri gabeko mezuen jarraipena egiten ari';
$string['forumtype'] = 'Foro mota';
$string['forumtype_help'] = '5 foro-mota daude:

* Eztabaida bakarra: eztabaidagai bakarra dago eta bertan edozeinek erantzun dezake (ez du funtzionatzen banatutako taldeekin).
* Pertsona bakoitzak eztabaida bat bidaltzen du: pertsona bakoitzak eztabaidagai berri bakar bat bidali dezake eta guztiek erantzun dezakete.
* Galdera eta Erantzunak (G eta E) motako foroa: ikasle bakoitzak irakasleak egindako galderari bere erantzuna bidali behar du beste ikasleen mezuak ikusi ahal izateko.
* Blog formatuan erakutsitako erabilera orokorreko foroa: edozeinek edonoiz eztabaidagai berriak sortu ditzakeen foro irekia. Eztabaidagaiak "Eztabaidatu gai hau" estekarekin agertuko dira orrian
* Erabilera orokorrerako foroa: foro irekia da, eta bertan edozeinek edonoiz eztabaidagai berriak sortu ditzake';
$string['generalforum'] = 'Erabilera orokorrerako foroa';
$string['generalforums'] = 'Foro orokorrak';
$string['grade_forum_header'] = 'Foro osoko kalifikazioa';
$string['grade_forum_name'] = 'Foro osoa';
$string['grade_forum_title'] = 'Kalifikazioa';
$string['grade_rating_name'] = 'Kalifikazioa';
$string['graded'] = 'Kalifikatuta';
$string['gradedby'] = 'Kalifikatzailea:';
$string['gradeforrating'] = 'Puntuaziorako kalifikazioa: {$a->str_long_grade}';
$string['gradeforratinghidden'] = 'Puntuaziorako kalifikazioa ezkutatuta';
$string['gradeforwholeforum'] = 'Fororako kalifikazioa: {$a->str_long_grade}';
$string['gradeforwholeforumhidden'] = 'Fororako kalifikazioa ezkutatuta';
$string['gradeitem:forum'] = 'Foroa';
$string['gradeitemnameforrating'] = '{$a->name}(r)en puntuazioa';
$string['gradeitemnameforwholeforum'] = '{$a->name} foro osoa';
$string['grades:gradesavedfor'] = '{$a->fullname}(r)en kalifikazioa gorde da';
$string['grades:gradesavefailed'] = 'Ezin izan da  {$a->fullname}(r)en kalifikazioa gorde: {$a->error}';
$string['gradeusers'] = 'Kalifikatu erabiltzaileak';
$string['grading'] = 'Kalifikatzen';
$string['gradingstatus'] = 'Kalifikazioaren egoera:';
$string['hiddenforumpost'] = 'Ezkutatutako foro-mezua';
$string['hidegraderpanel'] = 'Ezkutatu kalifikatzaile-panela';
$string['hidepreviousrepliescount'] = 'Ezkutatu aurreko erantzunak  ({$a})';
$string['hideusersearch'] = 'Ezkutatu erabiltzaile-bilaketa';
$string['indexoutoftotal'] = '{$a->index}.a gehieneko {$a->total}(e)tik';
$string['indicator:cognitivedepth'] = 'Gaitasun kognitiboa foroetan';
$string['indicator:cognitivedepth_help'] = 'Adierazle hau ikasleak Foroa motako jardueretan lortutako sakonera kognitiboan oinarrituta dago.';
$string['indicator:cognitivedepthdef'] = 'Gaitasun kognitiboa foroetan';
$string['indicator:cognitivedepthdef_help'] = 'Partaide honek Foroa jarduerak eskaintzen duen gaitasun kognitiboaren ehuneko hau lortu du analisi-tarte honetan (Mailak = Ikusi gabe, Ikusi da, Bidali da, Feedbacka ikusi da, Feedbackari iruzkina egin da, Feedback ikusi ondoren berriz bidali da)';
$string['indicator:cognitivedepthdef_link'] = 'Learning_analytics_indicators#Cognitive_depth';
$string['indicator:socialbreadth'] = 'Gaitasun soziala foroetan';
$string['indicator:socialbreadth_help'] = 'Helburu hau ikasleak Foroa motako jardueretan lortutako zabalera sozialean oinarrituta dago.';
$string['indicator:socialbreadthdef'] = 'Gaitasun soziala foroetan';
$string['indicator:socialbreadthdef_help'] = 'Partaide honek Foroa jarduerak eskaintzen duen gaitasun sozialaren ehuneko hau lortu du analisi-tarte honetan (Mailak = Parte-hartzerik ez, bakarkako parte-hartzea, parte-hartzea besteekin)';
$string['indicator:socialbreadthdef_link'] = 'Learning_analytics_indicators#Social_breadth';
$string['inforum'] = 'Non: {$a}';
$string['inreplyto'] = '{$a}(e)ri erantzunda';
$string['introblog'] = 'Foro honetako mezuak automatikoki ekarri dira erabiltzaileen blogetatik blog sarrera hauek dagoeneko ez daudelako eskuragarri';
$string['intronews'] = 'Albiste orokorrak eta iragarpenak';
$string['introsocial'] = 'Foro ireki bat nahi duzun edozertaz aritzeko';
$string['introteacher'] = 'Soilik irakasleek erabiliko duten ohar eta eztabaida foroa';
$string['invalidaccess'] = 'Orri honetarako sarbidea ez da zuzena izan';
$string['invaliddigestsetting'] = 'Posta elektroniko bidezko laburpen-mezuen ezarpen baliogabea jaso da';
$string['invaliddiscussionid'] = 'Eztabaidaren IDa ez da egokia edo dagoeneko ez da existitzen';
$string['invalidforcesubscribe'] = 'Behartutako harpidetza-modu baliogabea';
$string['invalidforumid'] = 'Foroaren IDa ez da egokia';
$string['invalidparentpostid'] = 'Goragoko mezuaren IDa ez da egokia';
$string['invalidpostid'] = 'Mezuaren ID baliogabea - {$a}';
$string['lastpost'] = 'Azken mezua';
$string['learningforums'] = 'Ikasteko foroak';
$string['lockdiscussion'] = 'Blokeatu eztabaida';
$string['lockdiscussionafter'] = 'Blokeatu eztabaidak jardunik gabeko epe baten ondoren';
$string['lockdiscussionafter_help'] = 'Eztabaidak automatikoki blokeatu daitezke azken erantzunetik denbora-tarte bat igaro ondoren.

Blokeatutako eztabaidetan erantzuteko gaitasuna duten erabiltzaileek eztabaidak desblokeatu ditzakete bertan erantzunez.';
$string['locked'] = 'Blokeatuta';
$string['lockupdated'] = 'Blokeatze-aukera eguneratu da.';
$string['longpost'] = 'Mezu luzea';
$string['mailnow'] = 'Bidali berehala foroko mezuaren jakinarazpenak, editatzeko atzerapen tarterik gabe';
$string['managesubscriptionsoff'] = 'Amaitu harpidetzen kudeaketa';
$string['managesubscriptionson'] = 'Kudeatu harpidedunak';
$string['manydiscussions'] = 'Eztabaidak orriko';
$string['markalldread'] = 'Markatu eztabaida honetako mezu guztiak irakurritzat';
$string['markallread'] = 'Markatu foro honetako mezu guztiak irakurritzat';
$string['markasread'] = 'Markatu irakurritako gisa';
$string['markasreadonnotification'] = 'Foroetako mezuen jakinarazpenak bidaltzean';
$string['markasreadonnotification_help'] = 'Foroetako mezu batez jakinarazten zaizunean, foroko jarraipenerako mezu hori irakurritzat markatu nahi duzun aukera dezakezu.';
$string['markasreadonnotificationno'] = 'Ez markatu mezua irakurritzat';
$string['markasreadonnotificationyes'] = 'Markatu mezua irakurritzat';
$string['markread'] = 'Markatu irakurritzat';
$string['markreadbutton'] = 'Markatu<br/>irakurritzat';
$string['markunread'] = 'Markatu irakurri gabeko gisa';
$string['markunreadbutton'] = 'Markatu irakurri<br />gabeko gisa';
$string['maxattachments'] = 'Gehieneko eranskin-kopurua';
$string['maxattachments_help'] = 'Ezarpen honek foroetako mezu bati gehienez zenbat eranskin gehitu ahal zaizkion zehazten du.';
$string['maxattachmentsize'] = 'Eranskinaren gehieneko tamaina';
$string['maxattachmentsize_help'] = 'Ezarpen honek zehazten du foro batera eranskin gisa bidal daitekeen fitxatategiaren gehieneko tamaina zein den.';
$string['maxtimehaspassed'] = 'Sentitzen dugu, mezu hau({$a}) editatzeko gehieneko denbora amaitu da!';
$string['message'] = 'Mezua';
$string['messageinboundattachmentdisallowed'] = 'Ezin izan da zure erantzuna bidali, erantzunak eranskinen bat zuelako eta foroak ez duelako eranskinak baimentzen.';
$string['messageinboundfilecountexceeded'] = 'Ezin izan da zure erantzuna bidali, foroan baimendutako gehieneko eranskin kopurua ({$a->forum->maxattachments}) baino gehiago zituelako.';
$string['messageinboundfilesizeexceeded'] = 'Ezin izan da zure erantzuna bidali, eranskinen tamaina osoa ({$a->filesize}) foroan baimendutako eranskinen gehieneko tamaina ({$a->maxbytes}) baino handiagoa delako.';
$string['messageinboundforumhidden'] = 'Ezin izan da zure erantzuna bidali, foroa une honetan ez-eskuragarri dagoelako.';
$string['messageinboundnopostforum'] = 'Ezin izan da zure erantzuna bidali, {$a->forum->name} foroan idazteko baimenik ez duzulako.';
$string['messageinboundthresholdhit'] = 'Ezin izan da zure erantzuna bidali. Foro honetara bidalitako mezu-kopuruaren atalasea gainditu duzu.';
$string['messageprovider:digests'] = 'Harpidetutako foroen laburpen-mezuak';
$string['messageprovider:posts'] = 'Harpidetutako foroen mezuak';
$string['missingsearchterms'] = 'Bilaketaren ondoko terminoak mezu honen HTML kodearen etiketetan baino ez dira aurkitu:';
$string['modeflatnewestfirst'] = 'Erakutsi erantzunak era lauan, berrienak lehen';
$string['modeflatoldestfirst'] = 'Erakutsi erantzunak era lauan, zaharrenak lehen';
$string['modenested'] = 'Erakutsi erantzunak hariaren arabera';
$string['modenestedv2'] = 'Erakutsi erantzunak habiaratutako modu esperimentalean';
$string['modethreaded'] = 'Erakutsi erantzunak gaika';
$string['modulename'] = 'Foroa';
$string['modulename_help'] = 'Foroari esker erabiltzaileek eztabaida asinkronoak izan ahal dituzte, hots, denbora epe luzeetan sakabanaturiko eztabaidak izan ditzakete.

Badira zenbait foro-mota aukeran, hala nola foro estandarra (non edonork edozein unetan eztabaida berri bat has dezakeen), ikasle bakoitzak eztabaida bakar bat argitara eman dezakeen foro bat, edo galdera-erantzuna foroa (non ikasleek gai bat argitaratu behar duten beste ikasleen mezuak ikusi ahal izateko). Irakasleek foroetako mezuetan fitxategiak eranstea ahalbidetu dezakete. Erantsitako irudiak foroko mezuan erakusten dira.

Ikasle eta irakasleak foroetako mezuen jakinarazpenak jasotzeko harpidetu daitezke. Irakasleek harpidetza hautazkoa, behartua edo automatikoa ezar dezakete, baita harpidetza guztiz desgaitu ere. Nahi izanez gero, ikasleek denbora epe zehatzetan idatz dezaketen mezu kopurua blokea daiteke; modu honetan gizabanakoak eztabaidetan nagusitzea saihestu daiteke.

Irakasleek foroetako mezuak kalifika ditzakete, baita ikasleek ere (parekoen arteko ebaluazioa). Ebaluazioak batu daitezke behin-betiko ebaluazioa lortzeko, eta azken hau izango da kalifikatzailean gordeko dena.

Foroak erabilera anitz izan ditzake, hala nola

* Ikasleentzako gune sozial gisa, elkar ezagut dezaten.
* Ikastaroko jakinarazpenak egiteko (behartutako harpidetza duen albisteen foro bat erabilita)
* Ikastaroko edukiak edo irakurgaiak eztabaidatzeko.
* Aurrez aurreko saioan planteatutako arazo bati on-line jarraipena emateko
* Irakasleen arteko eztabaidak egiteko (ezkutaturiko foro bat erabiliz)
* Laguntza-zentro gisa, tutore eta ikasleek elkarri aholkuak emateko
* Banaka irakasle-ikasle artean modu pribatuan komunikatzeko (banaturiko taldekako foro bat erabiliz, ikasle bakoitza talde batean sartuta)
* Jarduera gehigarrietarako, ‘brain teasers’ modukoak adibidez, ikasleek hausnartu eta soluzioak proposa ditzaten';
$string['modulename_link'] = 'mod/forum/view';
$string['modulenameplural'] = 'Foroak';
$string['more'] = 'gehiago';
$string['movedmarker'] = '(Mugituta)';
$string['movethisdiscussionlabel'] = 'Mugitu oraingo eztabaida zehaztutako forora';
$string['movethisdiscussionto'] = 'Mugitu eztabaida hau hona:';
$string['mustprovidediscussionorpost'] = 'Esportatzeko eztabaidaren IDa edo mezuaren IDa eman behar duzu.';
$string['myprofileotherdis'] = 'Foro-eztabaidak';
$string['myprofileowndis'] = 'Nire foro-eztabaidak';
$string['myprofileownpost'] = 'Nire foroetako mezuak';
$string['namenews'] = 'Albisteak';
$string['namenews_help'] = 'Albisteen foroa jakinarazpenetarako foro berezia da eta automatikoki sortzen da ikastaro bat sortzen denean. Ikastaro batek albisteen foro bakarra izan ahal du. Soilik irakasleek eta kudeatzaileek idatzi ditzakete albisteak. "Azken albisteak" blokeak foro berezi honetako azken eztabaidak erakusten ditu.';
$string['namesocial'] = 'Foro irekia';
$string['nameteacher'] = 'Irakasleen foroa';
$string['newforumposts'] = 'Foroetako mezu berriak';
$string['nextdiscussiona'] = 'Hurrengo eztabaida: {$a}';
$string['nextuser'] = 'Gorde aldaketak eta joan hurrengo erabiltzailera';
$string['noattachments'] = 'Mezu honek ez du eranskinik';
$string['nodiscussions'] = 'Oraindik ez dago eztabaidagairik foro honetan.';
$string['nodiscussionsstartedby'] = '{$a} erabiltzaileak ez du eztabaidarik hasi';
$string['nodiscussionsstartedbyyou'] = 'Zeuk oraindik ez duzu eztabaidarik hasi';
$string['noguestpost'] = 'Foro honetan soilik autentifikatutako erabiltzaileek idatzi dezakete.';
$string['noguestpost:title'] = 'Hasi saioa jarraitzeko';
$string['noguestsubscribe'] = 'Sentitzen dugu, gonbidatuek ez dute harpidetzeko baimenik.';
$string['noguesttracking'] = 'Sentitzen dugu, gonbidatuek ezin dituzte mezuen jarraipenerako aukerak aldatu.';
$string['nomorepostscontaining'] = 'Ez dago \'{$a}\' duen mezu gehiago';
$string['nonews'] = 'Oraindik ez da albisterik bidali.';
$string['noonecansubscribenow'] = 'Harpisdetzak ez daude baimenduta orain';
$string['nopermissiontosubscribe'] = 'Ez duzu foroko harpidedunak ikusteko baimenik.';
$string['nopermissiontoview'] = 'Ez duzu mezu hau ikusteko baimenik.';
$string['nopostforum'] = 'Ezin duzu mezurik bidali foro honetara.';
$string['noposts'] = 'Mezurik ez';
$string['nopostsmadebyuser'] = '{$a}(e)k ez du ezer bidali';
$string['nopostsmadebyyou'] = 'Ez duzu mezurik idatzi';
$string['noquestions'] = 'Oraindik ez dago galderarik foro honetan.';
$string['nosubscribers'] = 'Oraindik ez da inor harpidetu foro honetara.';
$string['notexists'] = 'Eztabaida dagoeneko ez da existitzen';
$string['notgraded'] = 'Kalifikatu gabe';
$string['nothingnew'] = '{$a}(r)entzat ez da ezer berri';
$string['notingroup'] = 'Talde bateko kidea izan behar duzu foro hau ikusteko.';
$string['notinstalled'] = 'Foroa modulua ez dago instalatuta';
$string['notlocked'] = 'Blokeatu';
$string['notpartofdiscussion'] = 'Mezu hau ez da inongo eztabaidatakoa';
$string['notrackforum'] = 'Ez nabarmendu irakurri gabeko mezuak';
$string['notsubscribed'] = 'Harpidetu';
$string['nousersmatch'] = 'Ez da erabiltzailerik aurkitu emandako irizpideekin';
$string['noviewdiscussionspermission'] = 'Ez duzu foro honetako eztabaidak ikusteko baimenik.';
$string['nowallsubscribed'] = '{$a}(e)ko foro guztietara harpidetuta zaude orain.';
$string['nowallunsubscribed'] = '{$a}(e)-ko foro guztietarako harpidetzak kendu dituzu jada.';
$string['nowgradinguser'] = 'Orain {$a} kalifikatzen';
$string['nownotsubscribed'] = '{$a->name} erabiltzaileak EZ du \'{$a->forum}\' foroko kopiarik jasoko posta elektroniko bidez.';
$string['nownottracking'] = '{$a->name}(e)k irakurri gabekoak ez nabarmentzea erabaki du ondorengo foroan: \'{$a->forum}\'.';
$string['nowsubscribed'] = '\'{$a->forum}\' foroko eztabaida berrien jakinarazpenak bidaliko zaizkizu.';
$string['nowtracking'] = '{$a->name}(e)k irakurri gabekoak nabarmentzea erabaki du ondorengo foroan: \'{$a->forum}\'.';
$string['numberofreplies'] = 'Erantzun kopurua: {$a}';
$string['numposts'] = '{$a} mezu';
$string['olderdiscussions'] = 'Eztabaida zaharragoak';
$string['oldertopics'] = 'Eztabaidagai zaharragoak';
$string['oldpostdays'] = 'Mezu zaharrak irakurritzat markatu';
$string['page-mod-forum-discuss'] = 'Foroaren eztabaida-hariaren orria';
$string['page-mod-forum-view'] = 'Foroaren orri nagusia';
$string['page-mod-forum-x'] = 'Foroaren edozein orri';
$string['parent'] = 'Erakutsi abiapuntua';
$string['parentofthispost'] = 'Mezu honen abiapuntua';
$string['permalink'] = 'Esteka iraunkorra';
$string['permanentlinktoparentpost'] = 'Mezu honen jatorrizko mezuaren esteka iraunkorra';
$string['permanentlinktopost'] = 'Mezu honen esteka iraunkorra';
$string['pindiscussion'] = 'Finkatu eztabaida hau';
$string['pinupdated'] = 'Finkatze-aukera eguneratu da.';
$string['pluginadministration'] = 'Foroaren kudeaketa';
$string['pluginname'] = 'Foroa';
$string['postadded'] = '<p>Zure mezua ondo gehitu da.</p> <p>Aldaketaren bat egin nahi baduzu, {$a} dituzu mezu hau editatzeko.</p>';
$string['postaddedsuccess'] = 'Zure mezua ondo gehitu da.';
$string['postaddedtimeleft'] = 'Aldaketaren bat egin nahi baduzu, {$a} dituzu mezu hau editatzeko.';
$string['postbymailsuccess'] = '"{$a->subject}" gaia duen mezuari emandako erantzuna ondo publikatu da: {$a->discussionurl}';
$string['postbymailsuccess_html'] = '<a href="{$a->discussionurl}">"{$a->subject}"</a> gaia duen mezuari emandako erantzuna ondo publikatu da.';
$string['postbyuser'] = '{$a->user}(r)en {$a->post}';
$string['postincontext'] = 'Ikusi mezu hau bere testuinguruan';
$string['postisprivatereply'] = 'Hau erantzun pribatu bat da. (Irakasleek eta erantzun pribatuak ikusteko baimena duten erabiltzaileek ere ikusi ahal dute.)';
$string['postmailinfo'] = 'Hau {$a} helbidean argitaratutako mezu baten kopia da.';
$string['postmailnow'] = '<p>Mezu hau forora harpidetutako partaide guztiei berehala bidaliko zaie.</p>';
$string['postmailreply'] = 'Erantzuteko, egin klik esteka honetan: {$a}';
$string['postmailsubject'] = '{$a->courseshortname}: {$a->subject}';
$string['posts'] = 'Mezuak';
$string['postsfrom'] = 'Data honen ondorengoko mezuak:';
$string['postsmadebyuser'] = 'Mezuen egilea: {$a}';
$string['postsmadebyuserincourse'] = 'Mezuen egilea {$a->fullname} da ondoko ikastaroan: {$a->coursename}';
$string['postsmadeincourse'] = '{$a} idatzitako mezuak';
$string['poststo'] = 'Data honen aurretiko mezuak:';
$string['posttoforum'] = 'Bidali mezua forora';
$string['posttomygroups'] = 'Idatzi kopia bat talde guztietan';
$string['posttomygroups_help'] = 'Sarbidea duzun talde guztietan mezu honen kopia bat idazten du. Sarbiderik ez duzun taldeetako partaideek ez dute zure mezua ikusiko.';
$string['postupdated'] = 'Zure mezua eguneratu da';
$string['potentialsubscribers'] = 'Balizko harpidedunak';
$string['prevdiscussiona'] = 'Aurreko harpidetza: {$a}';
$string['previoususer'] = 'Gorde aldaketak eta joan aurreko erabiltzailera';
$string['privacy:digesttypenone'] = 'Ez dugu foro honetako hobetsitako laburpen-mezuen inguruko daturik biltzen.';
$string['privacy:digesttypepreference'] = 'Foroetako bidalketak jasotzeko hurrengo laburpen-mota hau aukeratu duzu: "{$a->type}".';
$string['privacy:discussionsubscriptionpreference'] = 'Foro honetako hurrengo elkarrizketa-harpidetzen hobespen hau aukeratu duzu: "{$a->preference}"';
$string['privacy:metadata:core_rating'] = 'Foroak kalifikazioen azpisistema erabiltzen du mezuen kalifikazioa egiteko.';
$string['privacy:metadata:core_tag'] = 'Foroak etiketen azpisistema erabiltzen du mezuen etiketatzea egiteko.';
$string['privacy:metadata:forum_digests'] = 'Foro bakoitzeko laburpen-motaren inguruko informazioa.';
$string['privacy:metadata:forum_digests:forum'] = 'Harpidetutako foroa.';
$string['privacy:metadata:forum_digests:maildigest'] = 'Laburpen-motaren hobespena.';
$string['privacy:metadata:forum_digests:userid'] = 'Laburpen-motaren hobespena duen erabiltzailearen IDa.';
$string['privacy:metadata:forum_discussion_subs'] = 'Foro-elkarrizketa bakoitzeko harpidetzen inguruko informazioa';
$string['privacy:metadata:forum_discussion_subs:discussionid'] = 'Harpidetutako elkarrizketaren IDa.';
$string['privacy:metadata:forum_discussion_subs:preference'] = 'Harpidetzaren hasiera-unea.';
$string['privacy:metadata:forum_discussion_subs:userid'] = 'Elkarrizketa-harpidetza duen erabiltzailearen IDa.';
$string['privacy:metadata:forum_discussions'] = 'Erabiltzaile batek sortutako foroetako elkarrizketa bakoitzaren inguruko informazioa';
$string['privacy:metadata:forum_discussions:assessed'] = '';
$string['privacy:metadata:forum_discussions:name'] = 'Elkarrizketaren izena, egileak aukeratu duen eran.';
$string['privacy:metadata:forum_discussions:timemodified'] = 'Elkarrizketa azkenengoz aldatu zeneko unea.';
$string['privacy:metadata:forum_discussions:userid'] = 'Elkarrizketa sortu zuen erabiltzailearen IDa.';
$string['privacy:metadata:forum_discussions:usermodified'] = 'Elkarrizketa moduren batean azkenengoz aldatu zuen erabiltzailearen IDa.';
$string['privacy:metadata:forum_grades'] = 'Fororako kalifikazioen datuak';
$string['privacy:metadata:forum_grades:forum'] = 'Kalifikatu zen foroa';
$string['privacy:metadata:forum_grades:grade'] = 'Emandako kalifikazioa';
$string['privacy:metadata:forum_grades:userid'] = 'Kalifikatutako erabiltzailea';
$string['privacy:metadata:forum_posts'] = 'Foro bakoitzeko laburpen-motaren hobespenaren inguruko informazioa.';
$string['privacy:metadata:forum_posts:created'] = 'Mezua sortu zeneko unea.';
$string['privacy:metadata:forum_posts:discussion'] = 'Mezua dagoen elkarrizketa.';
$string['privacy:metadata:forum_posts:message'] = 'Foroko mezuaren edukia.';
$string['privacy:metadata:forum_posts:modified'] = 'Mezua azkenengoz aldatu zeneko unea.';
$string['privacy:metadata:forum_posts:parent'] = 'Mezuak erantzun duen jatorrizko mezua.';
$string['privacy:metadata:forum_posts:privatereplyto'] = 'Erantzuna bidali zitzaioneko erabiltzailearen IDa';
$string['privacy:metadata:forum_posts:subject'] = 'Foroko mezuaren gaia.';
$string['privacy:metadata:forum_posts:totalscore'] = 'Foroko mezuaren edukia.';
$string['privacy:metadata:forum_posts:userid'] = 'Foroko mezuaren egilearen erabiltzaile-IDa.';
$string['privacy:metadata:forum_queue'] = 'Laburpenaren bidalketan bidaliko diren mezuen behin behineko biltegia';
$string['privacy:metadata:forum_queue:discussionid'] = 'Foro-elkarrizketaren IDa';
$string['privacy:metadata:forum_queue:postid'] = 'Foroko mezuaren IDa';
$string['privacy:metadata:forum_queue:timemodified'] = 'Jatorrizko mezuaren aldaketa-unea.';
$string['privacy:metadata:forum_queue:userid'] = 'Mezuaren jakinarazpena jaso behar duen erabiltzailea';
$string['privacy:metadata:forum_read'] = 'Erabiltzaileak irakurri dituen mezuen inguruko informazioa.';
$string['privacy:metadata:forum_read:discussionid'] = 'Mezua dagoen elkarrizketa.';
$string['privacy:metadata:forum_read:firstread'] = 'Mezua lehen aldiz irakurri zeneko unea.';
$string['privacy:metadata:forum_read:lastread'] = 'Mezua azkenengoz irakurri zeneko unea.';
$string['privacy:metadata:forum_read:postid'] = 'Irakurritako mezua.';
$string['privacy:metadata:forum_read:userid'] = 'Erregistro honi dagokion erabiltzailearen IDa.';
$string['privacy:metadata:forum_subscriptions'] = 'Erabiltzailearen foro-harpidetzen inguruko informazioa.';
$string['privacy:metadata:forum_subscriptions:forum'] = 'Harpidetutako foroa.';
$string['privacy:metadata:forum_subscriptions:userid'] = 'Foro-harpidetza honi dagokion erabiltzailearen IDa.';
$string['privacy:metadata:forum_track_prefs'] = 'Erabiltzaileak jarraitzea erabaki duen foroetako mezuen inguruko informazioa.';
$string['privacy:metadata:forum_track_prefs:forumid'] = 'Irakurri gabekoak nabarmentzea gaituta duen foroa.';
$string['privacy:metadata:forum_track_prefs:userid'] = 'Foro honetako jarraipen-hobespenari dagokion erabiltzailearen IDa.';
$string['privacy:metadata:preference:autosubscribe'] = 'Mezuei erantzutean elkarrizketara harpidetzea edo ez.';
$string['privacy:metadata:preference:forum_discussionlistsortorder'] = 'Hobetsitako eztabaida-zerrendaren ordenatze-irizpidea';
$string['privacy:metadata:preference:maildigest'] = 'Gune mailako posta elektroniko bidezko laburpen-mezuen aukeraren hobespena';
$string['privacy:metadata:preference:markasreadonnotification'] = 'Jakinarazpenak jasotzean foroetako mezuak irakurritzat markatzea edo ez.';
$string['privacy:metadata:preference:trackforums'] = 'Irakurri gabekoak nabarmentzea gaitzea edo ez.';
$string['privacy:postwasread'] = 'Mezu hau lehen aldiz {$a->firstread}(e)an eta azkenengoz {$a->lastread}(e)an irakurri zen';
$string['privacy:readtrackingdisabled'] = 'Foro honen barruan irakurritako mezuak ez jarraitzea aukeratu duzu.';
$string['privacy:request:delete:discussion:name'] = 'Ezabatu egilearen eskaera dagoenean';
$string['privacy:request:delete:post:message'] = 'Mezu honen edukia ezabatua izan da egilearen eskaeraren ondorioz.';
$string['privacy:request:delete:post:subject'] = 'Ezabatu egilearen eskaera dagoenean';
$string['privacy:subscribedtoforum'] = 'Foro honetara harpidetuta zaude.';
$string['privatereply'] = 'Erantzun modu pribatuan';
$string['privatereply_help'] = 'Modu pribatuan erantzuten duzunean, zure mezua erantzun pribatuak ikusteko baimena duten erabiltzaileek ikusi ahalko dute, esaterako irakasleek.';
$string['processingdigest'] = 'Posta elektroniko bidezko laburpen-mezuak prozesatzen hurrengo erabiltzailearentzat: {$a}';
$string['processingpost'] = '{$a} mezua prozesatzen ari da';
$string['prune'] = 'Bereizi';
$string['prunediscussion'] = 'Bereizi eztabaida';
$string['prunedpost'] = 'Eztabaida berria sortu da mezu hau erabiliz';
$string['pruneheading'] = 'Bereizi eztabaida eta mugitu mezu hau eztabaida berri batera';
$string['qandaforum'] = 'Galdera eta Erantzunak (G eta E) motako foroa';
$string['qandanotify'] = 'Foro hau galdera-erantzun motakoa da. Besteen erantzunak ikusi ahal izateko, aurretik zeure erantzuna bidali behar duzu.';
$string['re'] = 'Er:';
$string['readtherest'] = 'Irakurri eztabaidagai osoa';
$string['removeallforumtags'] = 'Foroko etiketa guztiak';
$string['removefromfavourites'] = 'Ez nabarmendu eztabaida hau';
$string['replies'] = 'Erantzunak';
$string['repliesmany'] = '{$a} erantzun orain arte';
$string['repliesone'] = 'erantzun {$a} orain arte';
$string['reply'] = 'Erantzun';
$string['reply_handler'] = 'Erantzun foroetako mezuei posta elektroniko bidez';
$string['reply_handler_name'] = 'Erantzun foroko mezuei';
$string['replyauthorself'] = '{$a} (zu)';
$string['replyforum'] = 'Erantzuna forora bidali';
$string['replyingtoauthor'] = '{$a}(e)ri erantzuten...';
$string['replyplaceholder'] = 'Idatzi zure erantzuna...';
$string['replypostdiscussion'] = 'Erantzun eztabaidari';
$string['replytopostbyemail'] = 'Mezu honi posta elektroniko bidez erantzun diezaiokezu.';
$string['replytouser'] = 'Erabili helbide elektronikoa erantzunean';
$string['resetdigests'] = 'Erabiltzailekako foroetako laburpen-mezuak jasotzeko moduaren hobespenak';
$string['resetforums'] = 'Ezabatu mezuak hemendik:';
$string['resetforumsall'] = 'Mezu guztiak';
$string['resetsubscriptions'] = 'Foroetako harpidetza guztiak';
$string['resettrackprefs'] = 'Foroetako jarraipenerako hobespen guztiak';
$string['rssarticles'] = 'RSS jario berrien kopurua';
$string['rssarticles_help'] = 'Aukera honek RSS jarioetan agertuko den artikulu-kopurua zehazten du. 5 eta 20 arteko balioak onargarriak izan ohi dira.';
$string['rsssubscriberssdiscussions'] = 'Eztabaiden RSS jarioa';
$string['rsssubscriberssposts'] = 'Mezuen RSS jarioak';
$string['rsstype'] = 'Jarduera honetarako RSS jarioa';
$string['rsstype_help'] = 'Jarduera honetan RSS gaitzeko, aukeratu jarioan gehituko diren eztabaidak edo mezuak.';
$string['rsstypedefault'] = 'RSS jario mota';
$string['search'] = 'Bilatu';
$string['search:activity'] = 'Foroa - jardueraren informazioa';
$string['search:post'] = 'Foroa - mezuak';
$string['searchdatefrom'] = 'Mezuak ondoko dataren ondorengoak izan behar dira';
$string['searchdateto'] = 'Mezuak ondoko dataren aurrekoak izan behar dira';
$string['searchforumintro'] = 'Mesedez, sar itzazu bilatu beharreko terminoak ondoko eremuetako batean edo batzuetan';
$string['searchforums'] = 'Bilatu foroetan';
$string['searchfullwords'] = 'Hitz hauek osorik agertu behar lirateke';
$string['searchnotwords'] = 'Hitz hauek EZ lirateke agertu behar';
$string['searcholderposts'] = 'Bilatu mezu zaharragoetan';
$string['searchphrase'] = 'Mezuan esaldi hau osorik agertu behar litzateke';
$string['searchresults'] = 'Bilaketaren emaitzak';
$string['searchsubject'] = 'Hitz hauek izenburuan agertu behar lirateke';
$string['searchtags'] = 'hurrengo etiketa dauka:';
$string['searchuser'] = 'Egileak izen honekin bat etorri beharko luke';
$string['searchuserid'] = 'Egilearen ID-a Moodlen';
$string['searchusers'] = 'Bilatu erabiltzaileak';
$string['searchwhichforums'] = 'Aukeratu zein forotan bilatu behar den';
$string['searchwords'] = 'Hitz hauek mezuaren edozein lekutan ager daitezke';
$string['seeallposts'] = 'Ikusi erabiltzaile honen mezu guztiak';
$string['sendstudentnotificationsdefault'] = '"Jakinarazi ikasleari" ezarpenaren balio lehenetsia';
$string['sendstudentnotificationsdefault_help'] = 'Zehaztu kalifikazio formularioaren "Jakinarazi ikasleari" laukitxoaren lehenetsitako balioa.';
$string['sendstudentnotificationsno'] = 'Ez';
$string['sendstudentnotificationsyes'] = 'Bai, jakinarazi ikasleari';
$string['settings'] = 'Ezarpenak';
$string['shortpost'] = 'Mezu laburra';
$string['showgraderpanel'] = 'Erakutsi kalifikatzaile-panela';
$string['showingcountoftotaldiscussions'] = 'Eztabaida-zerrenda. {$a->total} eztabaidatik {$a->count} erakusten dira';
$string['showmoreusers'] = 'Erakutsi erabiltzaile gehiago';
$string['showpreviousrepliescount'] = 'Erakutsi aurreko erantzunak  ({$a})';
$string['showsubscribers'] = 'Erakutsi/editatu oraingo harpidedunak';
$string['showusersearch'] = 'Erakutsi erabiltzaile-bilatzailea';
$string['singleforum'] = 'Eztabaida bakarra';
$string['smallmessage'] = '{$a->user}(e)k mezua bidali du hona: {$a->forumname}';
$string['smallmessagedigest'] = 'Foroetako laburpenak {$a} mezu dauzka';
$string['starredonly'] = 'Bilatu nabarmendutako elkarrizketak soilik';
$string['startedby'] = 'Nork hasia';
$string['subject'] = 'Gaia';
$string['subplugintype_forumreport'] = 'Foro-txostena';
$string['subplugintype_forumreport_plural'] = 'Foro-txostenak';
$string['subscribe'] = 'Harpidetu forora';
$string['subscribeall'] = 'Harpidetu denak foro honetara';
$string['subscribed'] = 'Harpidetuta';
$string['subscribediscussion'] = 'Harpidetu eztabaida honetara';
$string['subscribeenrolledonly'] = 'Sentitzen dugu, soilik matrikulatutako erabiltzaileek harpidetu daitezke foroetako mezuen jakinarazpenak jasotzeko.';
$string['subscribenone'] = 'Kendu foro honetako harpidetza guztiak';
$string['subscribers'] = 'Harpidedunak';
$string['subscriberstowithcount'] = '"{$a->name}"(e)ko harpidedunak ({$a->count})';
$string['subscribestart'] = 'Bidali posta elektroniko bidez foro honetako mezu berriak';
$string['subscribestop'] = 'Ez dut foro honetako mezuen jakinarazpenik jaso nahi.';
$string['subscription'] = 'Harpidetza';
$string['subscription_help'] = 'Foro batera harpidetzen bazara, foro horretara bidaltzen diren mezuen jakinarazpena jasoko duzu. Oro har, aukera dezakezu foro batera harpidetu ala ez. Hala ere, irakasle batek foro jakin batera harpidetzera behartzeko modua du, eta orduan partaide guztiek mezuen jakinarazpenak jasoko dituzte.';
$string['subscriptionandtracking'] = 'Harpidetza eta jarraipena';
$string['subscriptionauto'] = 'Harpidetza automatikoa';
$string['subscriptiondisabled'] = 'Harpidetza desgaituta';
$string['subscriptionforced'] = 'Harpidetza behartua';
$string['subscriptionmode'] = 'Harpidetza modua';
$string['subscriptionmode_help'] = 'Partaide bat foro bateko harpideduna denean foro horretako mezuetako jakinarazpenak jasoko ditu. 4 harpidetza modu daude:

* Hautazko harpidetza - partaideek aukeran dute harpidetu ala ez
* Harpidetza behartua - guztiak egongo dira beti harpidetuta eta ezingo dute harpidetza kendu
* Harpidetza automatikoa - hasieran guztiak daude harpidetuta baina edonork edozein unetan harpidetza kendu dezake
* Harpidetza desgaituta - harpidetza ez dago baimenduta';
$string['subscriptionmodeconfirm'] = 'Ziur zaude {$a} harpidetza-modura aldatu nahi duzula?';
$string['subscriptionoptional'] = 'Hautazko harpidetza';
$string['subscriptions'] = 'Harpidetzak';
$string['tagarea_forum_posts'] = 'Foroetako mezuak';
$string['tagsdeleted'] = 'Foroetako etiketak ezabatu dira';
$string['thisforumhasduedate'] = 'Foro honetan idazteko amaiera-data {$a} da.';
$string['thisforumisdue'] = 'Foro honetan idazteko amaiera-data {$a} zen.';
$string['thisforumisthrottled'] = 'Foro honek mezu-kopuru mugatua du denbora-tarte jakin batean. Une honetan honela ezarrita dago:   {$a->blockafter} mezu bidaltzea {$a->blockperiod}(e)ko epean';
$string['timed'] = 'Programatuta';
$string['timeddiscussion'] = 'Programatutako eztabaida';
$string['timedhidden'] = 'Programatutako egoera: Ezkutatuta ikasleei';
$string['timedposts'] = 'Programatutako mezuak';
$string['timedvisible'] = 'Programatutako egoera: Ikusgai erabiltzaile guztientzat';
$string['timestartenderror'] = 'Amaiera-data ezin da izan hasiera-data baino lehenagokoa';
$string['togglediscussionmenu'] = 'Erakutsi/ezkutatu eztabaida-menua';
$string['togglefullscreen'] = 'Aldatu pantaila osora';
$string['togglesettingsdrawer'] = 'Erakutsi/Ezkutatu ezarpenen nabigazio-kutxa';
$string['trackforum'] = 'Nabarmendu irakurri gabeko mezuak';
$string['tracking'] = 'Nabarmentzea';
$string['trackingoff'] = 'Desgaituta';
$string['trackingon'] = 'Behartuta';
$string['trackingoptional'] = 'Hautazkoa';
$string['trackingtype'] = 'Irakurri gabekoen nabarmentzea';
$string['trackingtype_help'] = 'Irakurketaren jarraipenaren bitartez ikastaroko portadan mezu berriak nabarmentzen dira eta modu horretan partaideek irakurri gabeko mezurik duten foroan sartu gabe egiaztatu dezakete.

Hautazkoa zehaztuz gero partaideek foroaren nabarmentzea gaitzea ala ere aukeratu dezakete. (Foroen nabarmentzea erabiltzailearen profilean ere gaituta egon behar du.)

Kudeatzaile batek \'Baimendu Irakurri gabekoak nabarmentzea behartzea\' gaitzen badu, beste aukera bat agertuko da - behartuta. Aukera honek jarraipena beti gaituta egotea ahalbidetzen du, erabiltzailearen hobespenak edozein izanda ere.';
$string['trackreadposts_header'] = 'Foroetako jarraipena';
$string['unlockdiscussion'] = 'Desblokeatu eztabaida hau';
$string['unpindiscussion'] = 'Kendu eztabaida honen finkatzea';
$string['unread'] = 'Irakurri gabe';
$string['unreadpost'] = 'Irakurri gabeko mezua';
$string['unreadposts'] = 'Irakurri gabeko mezuak';
$string['unreadpostsnumber'] = 'Irakurri gabeko {$a} mezu';
$string['unreadpostsone'] = 'Irakurri gabeko mezu 1';
$string['unsubscribe'] = 'Kendu foroko harpidetza';
$string['unsubscribeall'] = 'Kendu foro guztietako harpidetzak';
$string['unsubscribeallconfirm'] = 'Orain {$a->forums} forotan eta {$a->discussions} eztabaidetan zaude harpidetuta. Ziur zaude foro eta eztabaida guztietako harpidetza eta ez gaitu eztabaidetako auto-harpidetza kendu nahi duzula?';
$string['unsubscribeallconfirmdiscussions'] = 'Une honetan {$a->discussions} eztabaidetara harpidetuta zaude. Ziur zaude eztabaida guztietako harpidetza kendu eta eztabaiden harpidetza automatikoa desgaitu nahi dituzula?';
$string['unsubscribeallconfirmforums'] = 'Une honetan {$a->forums} foroetara harpidetuta zaude. Ziur zaude foro guztietako harpidetza kendu eta eztabaiden harpidetza automatikoa kendu nahi dituzula?';
$string['unsubscribealldone'] = 'Foroetako hautazko harpidetza guztiak kendu dira. Behartutako harpidetza duten foroetako jakinarazpenak jasoko dituzu aurrerantzean. Foroetako jakinarazpenak kudeatzeko joan Nire profilaren ezarpenetako Mezularitzara.';
$string['unsubscribeallempty'] = 'Ez zaude inongo forotan harpidetuta. Zerbitzari honen jakinarazpen guztiak desgaitzeko, joan Nire profilaren ezarpenetako Mezularitzari.';
$string['unsubscribed'] = 'Harpidetza kendu da';
$string['unsubscribediscussion'] = 'Kendu eztabaida honetako harpidetza';
$string['unsubscribediscussionlink'] = 'Kendu harpidetza eztabaida honetatik: {$a}';
$string['unsubscribelink'] = 'Kendu harpidetza foro honetatik: {$a}';
$string['unsubscribeshort'] = 'Kendu harpidetza';
$string['useexperimentalui'] = 'Erabili eztabaiden habiaratutako ikuspegi esperimentala';
$string['usermarksread'] = 'Mezuak eskuz irakurritzat markatu';
$string['usernavigation'] = 'Erabiltzaile nabigazioa';
$string['usersforumposts'] = 'Erabiltzailearen foroetako mezuak';
$string['viewalldiscussions'] = 'Ikusi eztabaida guztiak';
$string['viewconversation'] = 'Ikusi eztabaida';
$string['viewgrades'] = 'Ikusi kalifikazioak';
$string['viewparentpost'] = 'Erakutsi abiapuntuko mezua';
$string['viewthediscussion'] = 'Ikusi eztabaida';
$string['warnafter'] = 'Abisua jasotzeko mezu-kopurua';
$string['warnafter_help'] = 'Ikasleek abisua jaso dezakete denbora-tarte baterako ezarritako gehieneko mezu-kopurura hurbiltzen direnean. Ezarpen honek zehazten du zenbat mezuren ondoren jasoko duten abisua. mod/forum:postwithoutthrottling gaitasuna duten erabiltzaileek ez dute mezu-mugarik izango.';
$string['warnformorepost'] = 'Kontuz! Eztabaida bat baino gehiago dago foro honetan - erabili berriena';
$string['yournewquestion'] = 'Zure galdera berria';
$string['yournewtopic'] = 'Zure eztabaidagai berria';
$string['yourreply'] = 'Zure erantzuna';
