<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'auth', language 'sk', version '5.0'.
 *
 * @package     auth
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['actauthhdr'] = 'Dostupné autentifikačné zásuvné moduly';
$string['allowaccountssameemail'] = 'Povoliť účty s rovnakým emailom';
$string['allowaccountssameemail_desc'] = 'Ak je povolené, môže zdieľať rovnakú emailovú adresu viac ako jeden používateľský účet. To môže viesť k problémom s bezpečnosťou alebo ochranou súkromia, napríklad s potvrdzovacím emailom pre zmenu hesla.';
$string['alternatelogin'] = 'Pokiaľ sem vložíte nejaké URL, bude použité ako prihlasovacia stránka k tomuto systému. Táto Vaša stránka by mala obsahovať formulár s vlastnosťou \'action\' nastavenou na <strong>\'{$a}\'</strong>, ktorá vracia pole <strong>username</strong> a <strong>password</strong>.<br />Dbajte na to, aby ste vložili platné URL! V opačnom prípade by ste mohli komukoľvek vrátane seba zamedziť prístup k týmto stránkam.<br />Ak chcete používať štandardnú prihlasovaciu stránku, nechajte toto pole prázdne.';
$string['alternateloginurl'] = 'Alternatívne URL pre prihlásenie';
$string['auth_changepasswordhelp'] = 'Pokyny k zmene hesla';
$string['auth_changepasswordhelp_expl'] = 'Zobraziť pokyny k zmene {$a} hesla. Tento text sa alebo a) zobrazí súčasne s <strong>URL pre zmenu hesla</strong> alebo s internou stránkou Moodle pre zmenu hesla, alebo sa b) zobrazí namiesto <strong>URL pre zmenu hesla</strong> alebo interná stránka Moodle pre zmenu hesla.';
$string['auth_changepasswordurl'] = 'URL pre zmenu hesla';
$string['auth_changepasswordurl_expl'] = 'Zadajte URL, kam majú byť presmerovaní používatelia požadujúci zmenu svojho {$a} hesla. U voľby <strong>Použi štandardnú stránku \'Zmena hesla\'</strong> vyššie vyberte <strong>Nie</strong>.';
$string['auth_changingemailaddress'] = 'Vyžiadali ste si zmenu emailovej adresy z  {$a->oldemail} na {$a->newemail}. Z bezpečnostných dôvodov Vám bude poslaný email na novú adresu pre potvrdenie, že táto patrí Vám. Vaša emailová adresa bude aktualizovaná, keď kliknete na URL odkaz v zaslanej správe. Platnosť potvrdzovacieho odkazu vyprší za 10 minút.';
$string['auth_common_settings'] = 'Bežné nastavenia';
$string['auth_data_mapping'] = 'Mapovanie údajov';
$string['auth_fieldlock'] = 'Zamknúť hodnotu';
$string['auth_fieldlock_expl'] = '<p>Hodnota uzamknutia: Ak je povolená, používatelia nebudú môcť pole upravovať. Túto voľbu použite, ak uchovávate tieto údaje v externom autorizačnom systéme. </p>';
$string['auth_fieldlockfield'] = 'Zamknúť hodnotu ({$a})';
$string['auth_fieldlocks'] = 'Zamknúť políčka používateľov';
$string['auth_fieldlocks_help'] = '<p>Môžete zamknúť údaje v políčkach používateľov. Toto je užitočné najmä na tých stránkach, kde sú údaje používateľov spravované administrátormi ručne, prostredníctvom upravovania ich záznamov alebo ich prenesenia cez voľbu \'Preniesť používateľov\'. Ak zamknete políčka, ktoré sú vyžadované Moodle, uistite sa, že pri vytváraní používateľských účtov poskytnete všetky potrebné údaje. V opačnom prípade budú účty nepoužiteľné.</p><p>Odporúčame zvážiť možnosť nastavenia režimu zamykania na \'Odomknuté, ak prázdne\', aby ste sa vyhli tomuto problému.</p>';
$string['auth_fieldmapping'] = 'Mapovanie údajov ({$a})';
$string['auth_invalidnewemailkey'] = 'Chyba: ak sa snažíte potvrdiť zmenu emailovej adresy, zrejme ste urobili chybu pri kopírovaní URL odkazu, ktorý Vám bol poslaný emailom. Prosím skopírujte adresu správne a skúste znova.';
$string['auth_loginpasswordtoggle'] = 'Prepínač viditeľnosti hesla';
$string['auth_loginpasswordtoggle_desc'] = 'Pridajte ikonu do poľa pre heslo na prihlasovacej obrazovke, ktorá umožňuje používateľom zobraziť alebo skryť zadané heslo.';
$string['auth_loginrecaptcha'] = 'Pre prihlásenie povoliť reCAPTCHA';
$string['auth_loginrecaptcha_desc'] = 'Pridajte na prihlasovaciu stránku prvok vizuálneho/audio potvrdenia. Tým sa zníži riziko neoprávnených pokusov o prihlásenie. Ďalšie informácie nájdete na stránke <a target="_blank" href="https://www.google.com/recaptcha">Google reCAPTCHA</a>.';
$string['auth_multiplehosts'] = 'Tu môžu byť špecifikovaní viacerí hostitelia ALEBO ich adresy (napr. host1.com;host2.com;host3.com alebo napr. xxx.xxx.xxx.xxx;xxx.xxx.xxx.xxx)';
$string['auth_notconfigured'] = 'Metóda overovania {$a} nie je nakonfigurovaná.';
$string['auth_outofnewemailupdateattempts'] = 'Prekročili ste povolený počet pokusov o zmenu svojej emailovej adresy. Vaša požiadavka na zmenu bola zrušená.';
$string['auth_passwordisexpired'] = 'Platnosť Vášho hesla vypršala. Prosím, zmeňte ho teraz.';
$string['auth_passwordwillexpire'] = 'Platnosť Vášho hesla vyprší o {$a} dní. Chcete si zmeniť Vaše heslo teraz?';
$string['auth_remove_delete'] = 'Úplne vymazať interné';
$string['auth_remove_keep'] = 'Uchovať interné';
$string['auth_remove_suspend'] = 'Suspendovať interné';
$string['auth_remove_user'] = 'Spresnite, čo treba robiť s interným používateľom v priebehu hromadnej synchronizácie, keď používateľ bol vymazaný z externej databázy. Automaticky sú obnovení iba suspendovaní používatelia, ktorý sa znovu objavia v externej databáze.';
$string['auth_remove_user_key'] = 'Odstránený externý používateľ';
$string['auth_sync_script'] = 'Synchronizačný skript pre používateľské kontá';
$string['auth_sync_suspended'] = 'Ak je povolené, bude pozastavený atribút použitý k aktualizácii lokálneho používateľského účtu v pozastavenom stave.';
$string['auth_sync_suspended_key'] = 'Synchronizovať lokálne účty v pozastavenom stavu';
$string['auth_updatelocal'] = 'Aktualizovať miestne údaje';
$string['auth_updatelocal_expl'] = '<p><b>Aktualizovať miestne údaje:</b> Ak je táto voľba aktívna, pole bude aktualizované (z externého overovacieho zdroja) zakaždým, keď sa používateľ prihlási, alebo pri synchronizácii používateľov. Polia určené na miestnu aktualizáciu by mali byť uzamknuté.</p>';
$string['auth_updatelocalfield'] = 'Aktualizovať lokálne ({$a})';
$string['auth_updateremote'] = 'Aktualizovať externé údaje';
$string['auth_updateremote_expl'] = '<p><b>Aktualizovať externé údaje:</b> Ak je táto voľba aktívna, externý overovací zdroj bude aktualizovaný zakaždým, keď dôjde k aktualizácii profilu používateľa. Polia určené na miestnu aktualizáciu by nemali byť uzamknuté, aby sa mohli upravovať.</p>';
$string['auth_updateremote_ldap'] = '<p><b>Poznámka:</b> Aktualizácia externých LDAP údajov si vyžaduje nastavenie binddn a bindpw spoluužívateľom s právom úpravy všetkých záznamov o používateľoch. Momentálne systém nepodporuje vlastnosti s viacerými hodnotami a pri aktualizácii sa preto odstránia nadbytočné hodnoty.</p>';
$string['auth_updateremotefield'] = 'Aktualizovať externé ({$a})';
$string['auth_user_create'] = 'Umožniť vytváranie používateľov';
$string['auth_user_creation'] = 'Noví (anonymní) používatelia môžu vytvárať používateľské kontá v externom zdroji a overovať ich cez email. Ak to umožníte, nezabudnite tiež konfigurovať špecifické voľby pre vytváranie používateľských účtov v danom externom zdroji.';
$string['auth_usernameexists'] = 'Zvolené používateľské meno už existuje. Prosím, vyberte si iné.';
$string['auth_usernotexist'] = 'Nemožné aktualizovať neexistujúceho používateľa:{$a}';
$string['authenticationoptions'] = 'Možnosti overovania';
$string['authinstructions'] = 'Ak necháte toto pole prázdne, nebudú zobrazené žiadne pokyny. Tu môžete zadať vlastné prihlasovacie pokyny pre používateľov.';
$string['authloginviaemail'] = 'Povoliť prihlásenie prostredníctvom emailovej adresy';
$string['authloginviaemail_desc'] = 'Povoliť prihlásenie prostredníctvom používateľského mena alebo emailovej adresy (ak je jedinečná).';
$string['auto_add_remote_users'] = 'Pridať vzdialených používateľov automaticky';
$string['cannotmapfield'] = 'Pole "{$a->fieldname}" nie je možné mapovať, pretože jeho krátke meno "{$a->shortname}" je príliš dlhé. Aby bolo mapovanie možné, skráťte krátke meno poľa profilu na  {$a->charlimit} znakov. <a href="{$a->link} "> Upraviť pole profilov používateľov</a>';
$string['changepassword'] = 'URL na zmenu hesla';
$string['changepasswordhelp'] = 'Tu môžete určiť URL stránku pre obnovenie hesla, ktorá bude zaslaná používateľom v emaili. Všimnite si, že toto nastavenie nebude mať žiadny vplyv, ak je URL pre zabudnuté heslo nastavené v spoločných nastaveniach overovania.';
$string['chooseauthmethod'] = 'Vyberte si spôsob overovania používateľov:';
$string['chooseauthmethod_help'] = 'Toto nastavenie určuje spôsob overovania pri prihlasovaní používateľa. Vyberte iba moduly, ktoré sú aktívne. Inak sa používatelia nebudú môcť prihlásiť.  Ak chcete používateľa zablokovať, vyberte "Zákaz prihlásenia".';
$string['createpassword'] = 'Vygenerovať heslo a oznámiť to používateľovi';
$string['createpasswordifneeded'] = 'Vytvoriť heslo, ak je to treba a poslať ho mailom';
$string['emailchangecancel'] = 'Zrušiť zmenu emailu';
$string['emailchangepending'] = 'Zmena mailu bude aktívna potom, ako kliknete na odkaz v maili poslanom na {$a->preference_newemail}.';
$string['emailnowexists'] = 'Nová emailová adresa, na ktorú ste si požiadali zmeniť svoje konto, už je používaná niekým iným. Vaša požiadavka na zmenu bola preto zrušená. Môžete požiadavku opakovať s odlišnou emailovou adresou.';
$string['emailupdate'] = 'Aktualizácia emailovej adresy';
$string['emailupdatemessage'] = 'Dobrý deň {$a->fullname},

Vyžiadali ste si zmenu Vašej emailovej adresy vo Vašom konte na portáli {$a->site}. Prosím kliknite na nasledovný odkaz vo vašom prehliadači na potvrdenie tejto zmeny.

{$a->url}
Platnosť potvrdzovacieho odkazu vyprší za <b>10 minút</b>.

{$a->supportemail}';
$string['emailupdatesuccess'] = 'Emailová adresa používateľa <em>{$a->fullname}</em> bola úspešne aktualizovaná na <em>{$a->email}</em>.';
$string['emailupdatetitle'] = 'Potvrdenie emailovej aktualizácie na portáli {$a->site}';
$string['errormaxconsecutiveidentchars'] = 'Heslá môžu mať maximálne {$a} rovnakých znakov idúcich za sebou.';
$string['errorminpassworddigits'] = 'Heslá musia mať minimálne {$a} číslic.';
$string['errorminpasswordlength'] = 'Heslá musia byť minimálne {$a} znakov dlhé.';
$string['errorminpasswordlower'] = 'Heslá musia mať minimálne {$a} malých písmen.';
$string['errorminpasswordnonalphanum'] = 'Heslá musia mať minimálne {$a} nealfanumerických znakov ako *, -, alebo #.';
$string['errorminpasswordupper'] = 'Heslá musia mať minimálne {$a} veľkých písmen.';
$string['errorpasswordreused'] = 'Toto heslo už bolo použité a nie je dovolené ho použiť znova';
$string['errorpasswordupdate'] = 'Chyba pri zmene hesla, heslo nebolo zmenené';
$string['eventuserloggedin'] = 'Používateľ sa prihlásil';
$string['eventuserloggedinas'] = 'Používateľ sa prihlásil ako iný používateľ';
$string['eventuserloginfailed'] = 'Zlyhalo prihlásenie';
$string['forcechangepassword'] = 'Vyžadovať zmenu hesla';
$string['forcechangepassword_help'] = 'Vyžadovať od používateľov zmenu hesla pri ich ďalšom prihlásení do Moodle.';
$string['forcechangepasswordfirst_help'] = 'Vyžadovať od používateľov zmenu hesla pri ich prvom prihlásení do Moodle.';
$string['forgottenpassword'] = 'Ak sem vložíte URL, bude použitá ako stránka pre získanie zabudnutých hesiel tohto portálu. Sú tým mienené systémy, kde sú heslá spracovávané mimo Moodle. Nechajte prázdne na použitie východzieho systému správy zabudnutých hesiel.';
$string['forgottenpasswordurl'] = 'URL pre zabudnuté heslo';
$string['getrecaptchaapi'] = 'Ak chcete použiť reCAPTCHA, musíte získať kľúč API <a href=\'https://www.google.com/recaptcha/admin\'>https://www.google.com/recaptcha/admin</a>';
$string['guestloginbutton'] = 'Prihlasovacie tlačidlo pre hosťa';
$string['incorrectpleasetryagain'] = 'Nesprávne. Skúste znova.';
$string['infilefield'] = 'Pole je v súbore vyžadované';
$string['informminpassworddigits'] = 'minimálne {$a} číslic';
$string['informminpasswordlength'] = 'minimálne {$a} znakov';
$string['informminpasswordlower'] = 'minimálne {$a} malých písmen';
$string['informminpasswordnonalphanum'] = 'minimálne {$a} špeciálnych znakov ako *, -, alebo #';
$string['informminpasswordreuselimit'] = 'Heslá môžu byť opätovne použité po {$a} zmenách';
$string['informminpasswordupper'] = 'minimálne {$a} veľkých písmen';
$string['informpasswordpolicy'] = 'Heslo musí mať {$a}';
$string['instructions'] = 'Inštrukcie';
$string['internal'] = 'Interný';
$string['limitconcurrentlogins'] = 'Limit súčasných prihlásení';
$string['limitconcurrentlogins_desc'] = 'Ak je pre každého používateľa povolené obmedzenie počtu súbežných prihlásení, je po dosiahnutí obmedzení najstaršia relácia ukončená, Uvedomte si, že používatelia môžu prísť o všetky neuložené práce. Toto nastavení nie je kompatibilné s autentifikáciou Single Sign-On (SSO).';
$string['locked'] = 'Zamknutý/Zamknuté';
$string['md5'] = 'MD5 hash';
$string['nopasswordchange'] = 'Heslo nemôže byť zmenené';
$string['nopasswordchangeforced'] = 'Nemôžete pokračovať bez zmeny hesla, ale stránka pre jeho zmenenie nie je k dispozícii. Kontaktujte prosím svojho Moodle administrátora.';
$string['noprofileedit'] = 'Profil nemôže byť upravovaný';
$string['ntlmsso_attempting'] = 'Pokus o Single Sign On pomocou NTLM...';
$string['ntlmsso_failed'] = 'Auto-login sa nepodaril, skúste normálne prihlasovanie.';
$string['ntlmsso_isdisabled'] = 'NTLM SSO je zakázané.';
$string['passwordhandling'] = 'Zaobchádzanie s poľom hesla';
$string['plaintext'] = 'Čistý text';
$string['pluginnotenabled'] = 'Autentifikačný zásuvný modul \'{$a}\' nie je povolený.';
$string['pluginnotinstalled'] = 'Autentifikačný zásuvný modul  \'{$a}\' nie je nainštalovaný.';
$string['potentialidps'] = 'Prihlásiť sa pomocou Vášho účtu na:';
$string['privacy:metadata:userpref:createpassword'] = 'Označuje, že pre používateľa by malo byť vytvorené heslo';
$string['privacy:metadata:userpref:forcepasswordchange'] = 'Označuje, či má používateľ pri prihlásení zmeniť svoje heslo';
$string['privacy:metadata:userpref:loginfailedcount'] = 'Počet používateľov, ktorým sa nepodarilo prihlásiť';
$string['privacy:metadata:userpref:loginfailedcountsincesuccess'] = 'Počet používateľov, ktorým sa od svojho posledného úspešného prihlásenia nepodarilo prihlásiť';
$string['privacy:metadata:userpref:loginfailedlast'] = 'Dátum, kedy bol zaznamenaný posledný neúspešný pokus o prihlásenie';
$string['privacy:metadata:userpref:loginlockout'] = 'Či je používateľský účet zamknutý pre neúspešné pokusy o prihlásenie a dátum, kedy bol účet zamknutý';
$string['privacy:metadata:userpref:loginlockoutignored'] = 'Označuje, že používateľský účet by nikde nemal byť predmetom zamykania';
$string['privacy:metadata:userpref:loginlockoutsecret'] = 'Ak je zamknuté, heslo, ktoré musí používateľ používať k odomknutiu účtu';
$string['recaptcha'] = 'reCAPTCHA';
$string['recaptcha_help'] = 'CAPTCHA slúži na zabránenie zneužitiu zo strany automatizovaných programov. Postupujte podľa pokynov a overte, že ste osoba. Môže to byť políčko na začiarknutie, znaky zobrazené na obrázku, ktoré musíte zadať, alebo skupina obrázkov, z ktorých si môžete vybrať.

Ak si nie ste istí, o aké obrázky ide, môžete skúsiť získať inú CAPTCHA alebo zvukovú CAPTCHA.';
$string['recaptcha_link'] = 'auth/email';
$string['security_question'] = 'Bezpečnostná otázka';
$string['selfregistration'] = 'Používatelia sa registrujú sami';
$string['selfregistration_help'] = 'Pokiaľ tu vyberiete nejakú autentizačnú metódu (typicky registrácia na základe e-mailu), tak umožníte sa registrovať potenciálnym používateľom. Toto môže viesť k útokom spammerov formou hromadného zakladania fiktívnych účtov, ktoré sú následne používané k publikovaniu nevhodného obsahu vo fórach, blogoch, používateľských profiloch, atď. K zabráneniu týmto rizikám, skúste zakázať túto autentizačnú metódu alebo ju obmedzte nastavením <em>Povolené e-mailové domény</em>';
$string['settingmigrationmismatch'] = 'Pri oprave názvov nastavení zásuvného modulu sa zistil nesúlad hodnôt. Modul autentifikácie "{$a-> plugin}" mal nastavenie "{$a-> setting}" nakonfigurované na "{$a-> legacy}" pod pôvodným menom a aktuálne na "{$a-> current}". Táto hodnota bola nastavená ako platná, ale mali by ste ju skontrolovať a potvrdiť, že ju očakáváte.';
$string['sha1'] = 'SHA - 1 hash';
$string['showguestlogin'] = 'Môžete skryť alebo zobraziť prihlasovacie tlačidlo pre hosťa na prihlasovacej stránke.';
$string['showloginform'] = 'Zobraziť formulár pre ručné prihlásenie';
$string['showloginform_desc'] = 'Ak všetci používatelia na portáli používajú metódu overovania, ako je OAuth 2, ktorá nevyžaduje zadávanie používateľského mena a hesla, môžete skryť formulár ručného prihlásenia. Upozorňujeme, že používatelia s manuálnymi účtami sa nebudú môcť prihlásiť.

Ak skryjete formulár manuálneho prihlásenia a nemôžete sa prihlásiť, môžete ho znovu zobraziť pomocou príkazového riadku php admin/cli/cfg.php --name=showloginform --set=1.';
$string['stdchangepassword'] = 'Použiť štandardnú stránku pre zmenu hesla';
$string['stdchangepassword_expl'] = 'Ak Váš externý overovací systém povoľuje zmeny hesla v prostredí Moodle, prepnite túto voľbu na "Áno". Toto nastavenie potlačí funkciu "URL na zmenu hesla".';
$string['stdchangepassword_explldap'] = 'Poznámka: Ak používate vzdialený LDAP server, odporúčame Vám komunikovať cez šifrované SSL spojenie (ldaps://).';
$string['suspended'] = 'Pozastavený účet';
$string['suspended_help'] = 'Používatelia s pozastaveným účtom sa nemôžu prihlásiť alebo používať webové služby. Všetky odchádzajúce správy sú odstránené.';
$string['testsettings'] = 'Testovať nastavenia';
$string['testsettingsheading'] = 'Testovať nastavenia autentifikácie - {$a}';
$string['unlocked'] = 'Odomknutý/Odomknuté';
$string['unlockedifempty'] = 'Odomknuté, ak prázdne';
$string['update_never'] = 'Nikdy';
$string['update_oncreate'] = 'Pri vytváraní';
$string['update_onlogin'] = 'Pri každom prihlásení';
$string['update_onupdate'] = 'Pri aktualizácii';
$string['user_activatenotsupportusertype'] = 'auth: ldap user_activate() nepodporuje vybraný typ používateľa: {$a}';
$string['user_disablenotsupportusertype'] = 'auth: ldap user_activate() (... ešte ...) nepodporuje vybraný typ používateľa.';
$string['username'] = 'Používateľské meno';
$string['username_help'] = 'Uvedomte si, že pre niektoré overovacie moduly nebude možné zmeniť používateľské meno.';
