<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'editor_tinymce', language 'el', version '5.0'.
 *
 * @package     editor_tinymce
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['advanced:address'] = 'Διεύθυνση';
$string['advanced:anchor_delta_height'] = '';
$string['advanced:anchor_delta_width'] = '';
$string['advanced:anchor_desc'] = 'Εισαγωγή/επεξεργασία αγκύρωσης';
$string['advanced:backcolor_desc'] = 'Επιλογή χρώματος υπόβαθρου';
$string['advanced:block'] = 'Μορφότυπος';
$string['advanced:blockquote'] = 'Μπλοκ παράθεσης';
$string['advanced:blockquote_desc'] = 'Μπλοκ παράθεσης';
$string['advanced:bold_desc'] = 'Έντονα (Ctrl+B)';
$string['advanced:bullist_desc'] = 'Εισαγωγή/διαγραφή λίστας με κουκίδες';
$string['advanced:charmap_delta_height'] = '';
$string['advanced:charmap_delta_width'] = '';
$string['advanced:charmap_desc'] = 'Εισαγωγή ειδικού χαρακτήρα';
$string['advanced:cleanup_desc'] = 'Καθαρισμός μπερδεμένου κώδικα';
$string['advanced:clipboard_msg'] = 'Οι λειτουργίες αντιγραφή/αποκοπή/επικόλληση δεν είναι διαθέσιμες σε Mozilla και Firefox. Θέλετε περισσότερες πληροφορίες για αυτό το ζήτημα;';
$string['advanced:code'] = 'Κώδικας';
$string['advanced:code_desc'] = 'Επεξεργασία HTML κώδικα';
$string['advanced:colorpicker_delta_height'] = '';
$string['advanced:colorpicker_delta_width'] = '';
$string['advanced:copy_desc'] = 'Αντιγραφή';
$string['advanced:custom1_desc'] = 'Η προσαρμοσμένη περιγραφή σας εδώ';
$string['advanced:cut_desc'] = 'Αποκοπή';
$string['advanced:dd'] = 'Περιγραφή ορισμού';
$string['advanced:div'] = 'DIV';
$string['advanced:dt'] = 'Ορισμός';
$string['advanced:font_size'] = 'Μέγεθος Γραμμάτων';
$string['advanced:fontdefault'] = 'Γραμματοσειρά';
$string['advanced:forecolor_desc'] = 'Επιλογή χρώματος κειμένου';
$string['advanced:h1'] = 'Επικεφαλίδα 1';
$string['advanced:h2'] = 'Επικεφαλίδα 2';
$string['advanced:h3'] = 'Επικεφαλίδα 3';
$string['advanced:h4'] = 'Επικεφαλίδα 4';
$string['advanced:h5'] = 'Επικεφαλίδα 5';
$string['advanced:h6'] = 'Επικεφαλίδα 6';
$string['advanced:help_desc'] = 'Βοήθεια';
$string['advanced:help_shortcut'] = 'Πατήστε ALT-F10 για τη γραμμή εργαλείων. Πατήστε ALT-0 για βοήθεια';
$string['advanced:hr_desc'] = 'Εισαγωγή οριζόντιας γραμμής';
$string['advanced:image_delta_height'] = '';
$string['advanced:image_delta_width'] = '';
$string['advanced:image_desc'] = 'Εισαγωγή/επεξεργασία εικόνας';
$string['advanced:image_props_desc'] = 'Ιδιότητες εικόνας';
$string['advanced:indent_desc'] = 'Αύξηση εσοχής';
$string['advanced:italic_desc'] = 'Πλάγια (Ctrl+I)';
$string['advanced:justifycenter_desc'] = 'Στοίχιση κέντρο';
$string['advanced:justifyfull_desc'] = 'Στοίχιση πλήρης';
$string['advanced:justifyleft_desc'] = 'Στοίχιση αριστερά';
$string['advanced:justifyright_desc'] = 'Στοίχιση δεξιά';
$string['advanced:link_delta_height'] = '';
$string['advanced:link_delta_width'] = '';
$string['advanced:link_desc'] = 'Εισαγωγή/επεξεργασία συνδέσμου';
$string['advanced:more_colors'] = 'Περισσότερα χρώματα...';
$string['advanced:newdocument'] = 'Σίγουρα θέλετε να καθαρίσετε όλο το περιεχόμενο;';
$string['advanced:newdocument_desc'] = 'Νέο έγγραφο';
$string['advanced:numlist_desc'] = 'Εισαγωγή/διαγραφή αριθμημένης λίστας';
$string['advanced:outdent_desc'] = 'Ελάττωση εσοχής';
$string['advanced:paragraph'] = 'Παράγραφος';
$string['advanced:paste_desc'] = 'Επικόλληση';
$string['advanced:path'] = 'Μονοπάτι';
$string['advanced:pre'] = 'Pre';
$string['advanced:redo_desc'] = 'Επανάληψη (Ctrl+Y)';
$string['advanced:removeformat_desc'] = 'Αφαίρεση μορφοποίησης';
$string['advanced:rich_text_area'] = 'Περιοχή κειμένου με μορφοποίηση';
$string['advanced:samp'] = 'Δείγμα κώδικα';
$string['advanced:shortcuts_desc'] = 'Βοήθεια προσβασιμότητας';
$string['advanced:striketrough_desc'] = 'Διαγραμμισμένα';
$string['advanced:style_select'] = 'Στυλ';
$string['advanced:sub_desc'] = 'Δείκτης';
$string['advanced:sup_desc'] = 'Εκθέτης';
$string['advanced:toolbar'] = 'Γραμμή εργαλείων';
$string['advanced:toolbar_focus'] = 'Μεταπήδηση στα κουμπιά εργαλείων - Alt+Q,<br />
μεταπήδηση στον επεξεργαστή κειμένου - Alt-Z,<br />
μεταπήδηση στην διαδρομή του στοιχείου - Alt-X.';
$string['advanced:underline_desc'] = 'Υπογραμμισμένα (Ctrl+U)';
$string['advanced:undo_desc'] = 'Αναίρεση (Ctrl+Z)';
$string['advanced:unlink_desc'] = 'Κατάργηση συνδέσμου';
$string['advanced:visualaid_desc'] = 'Εμφάνιση/Απόκρυψη βοηθητικών γραμμών / αόρατων στοιχείων';
$string['advanced_dlg:'] = '';
$string['advanced_dlg:about_author'] = 'Συγγραφέας';
$string['advanced_dlg:about_general'] = 'Σχετικά';
$string['advanced_dlg:about_help'] = 'Βοήθεια';
$string['advanced_dlg:about_license'] = 'Άδεια χρήσης';
$string['advanced_dlg:about_loaded'] = 'Φορτωμένα πρόσθετα';
$string['advanced_dlg:about_plugin'] = 'Σχετικά με το πρόσθετο';
$string['advanced_dlg:about_plugins'] = 'Σχετικά με τα πρόσθετα';
$string['advanced_dlg:about_title'] = 'Σχετικά με το TinyMCE';
$string['advanced_dlg:about_version'] = 'Έκδοση';
$string['advanced_dlg:accessibility_help'] = 'Βοήθεια προσβασιμότητας';
$string['advanced_dlg:accessibility_usage_title'] = 'Γενική χρήση';
$string['advanced_dlg:anchor_invalid'] = 'Παρακαλούμε προσδιορίστε ένα έγκυρο όνομα αγκύρωσης.';
$string['advanced_dlg:anchor_name'] = 'Όνομα αγκύρωσης';
$string['advanced_dlg:anchor_title'] = 'Εισαγωγή/επεξεργασία αγκύρωσης';
$string['advanced_dlg:charmap_title'] = 'Επιλογή ειδικού χαρακτήρα';
$string['advanced_dlg:charmap_usage'] = 'Χρησιμοποιήστε τα αριστερά και δεξιά βελάκια για να πλοηγηθείτε.';
$string['advanced_dlg:code_title'] = 'Επεξεργαστής κώδικα HTML';
$string['advanced_dlg:code_wordwrap'] = 'Αναδίπλωση κειμένου';
$string['advanced_dlg:colorpicker_color'] = 'Χρώμα:';
$string['advanced_dlg:colorpicker_name'] = 'Όνομα:';
$string['advanced_dlg:colorpicker_named_tab'] = 'Ονομαστικά';
$string['advanced_dlg:colorpicker_named_title'] = 'Ονομαστικά χρώματα';
$string['advanced_dlg:colorpicker_palette_tab'] = 'Παλέτα';
$string['advanced_dlg:colorpicker_palette_title'] = 'Χρώματα παλέτας';
$string['advanced_dlg:colorpicker_picker_tab'] = 'Επιλογή';
$string['advanced_dlg:colorpicker_picker_title'] = 'Επιλογή χρώματος';
$string['advanced_dlg:colorpicker_title'] = 'Διαλέξτε χρώμα';
$string['advanced_dlg:image_align'] = 'Στοίχιση';
$string['advanced_dlg:image_align_baseline'] = 'Γραμμή στοίχισης γραμμάτων';
$string['advanced_dlg:image_align_bottom'] = 'Κάτω';
$string['advanced_dlg:image_align_left'] = 'Αριστερά';
$string['advanced_dlg:image_align_middle'] = 'Μέση';
$string['advanced_dlg:image_align_right'] = 'Δεξιά';
$string['advanced_dlg:image_align_textbottom'] = 'Κείμενο κάτω';
$string['advanced_dlg:image_align_texttop'] = 'Κείμενο πάνω';
$string['advanced_dlg:image_align_top'] = 'Πάνω';
$string['advanced_dlg:image_alt'] = 'Περιγραφή εικόνας';
$string['advanced_dlg:image_border'] = 'Περίγραμμα';
$string['advanced_dlg:image_dimensions'] = 'Διαστάσεις';
$string['advanced_dlg:image_hspace'] = 'Απόσταση οριζόντια';
$string['advanced_dlg:image_list'] = 'Λίστα εικόνων';
$string['advanced_dlg:image_src'] = 'Διεύθυνση URL εικόνας';
$string['advanced_dlg:image_title'] = 'Εισαγωγή/επεξεργασία εικόνας';
$string['advanced_dlg:image_vspace'] = 'Απόσταση κάθετη';
$string['advanced_dlg:invalid_color_value'] = 'Μη έγκυρη τιμή χρώματος';
$string['advanced_dlg:link_is_email'] = 'Η διεύθυνση URL που δώσατε μοιάζει με διεύθυνση ηλε.ταχυδρομείου. Θέλετε να προστεθεί το απαιτούμενο mailto: πρόθεμα;';
$string['advanced_dlg:link_is_external'] = 'Η διεύθυνση URL που δώσατε μοιάζει με εξωτερικός σύνδεσμος. Θέλετε να προστεθεί το απαιτούμενο http:// πρόθεμα;';
$string['advanced_dlg:link_list'] = 'Λίστα συνδέσμων';
$string['advanced_dlg:link_target'] = 'Στόχος';
$string['advanced_dlg:link_target_blank'] = 'Άνοιγμα σε νέο παράθυρο';
$string['advanced_dlg:link_target_same'] = 'Άνοιγμα στο ίδιο παράθυρο';
$string['advanced_dlg:link_title'] = 'Εισαγωγή/επεξεργασία συνδέσμου';
$string['advanced_dlg:link_titlefield'] = 'Τίτλος';
$string['advanced_dlg:link_url'] = 'Διεύθυνση URL συνδέσμου';
$string['advhr:advhr_desc'] = 'Εισαγωγή οριζόντιας γραμμής';
$string['advhr:delta_height'] = '';
$string['advhr:delta_width'] = '';
$string['advhr_dlg:normal'] = 'Κανονικά';
$string['advhr_dlg:noshade'] = 'Χωρίς σκιά';
$string['advhr_dlg:size'] = 'Ύψος';
$string['advhr_dlg:width'] = 'Πλάτος';
$string['advhr_dlg:widthunits'] = 'Μονάδες';
$string['advimage:delta_height'] = '';
$string['advimage:delta_width'] = '';
$string['advimage:image_desc'] = 'Εισαγωγή/επεξεργασία εικόνας';
$string['advimage_dlg:align'] = 'Στοίχιση';
$string['advimage_dlg:align_baseline'] = 'Γραμμή στοίχισης γραμμάτων';
$string['advimage_dlg:align_bottom'] = 'Κάτω';
$string['advimage_dlg:align_left'] = 'Αριστερά';
$string['advimage_dlg:align_middle'] = 'Μέση';
$string['advimage_dlg:align_right'] = 'Δεξιά';
$string['advimage_dlg:align_textbottom'] = 'Κείμενο κάτω';
$string['advimage_dlg:align_texttop'] = 'Κείμενο πάνω';
$string['advimage_dlg:align_top'] = 'Πάνω';
$string['advimage_dlg:alt'] = 'Περιγραφή εικόνας';
$string['advimage_dlg:alt_image'] = 'Εναλλακτική εικόνα';
$string['advimage_dlg:border'] = 'Περίγραμμα';
$string['advimage_dlg:classes'] = 'Κλάσεις';
$string['advimage_dlg:constrain_proportions'] = 'Διατήρηση αναλογίας πλ. - ύψους';
$string['advimage_dlg:dialog_title'] = 'Εισαγωγή/επεξεργασία εικόνας';
$string['advimage_dlg:dimensions'] = 'Διαστάσεις';
$string['advimage_dlg:example_img'] = 'Δοκιμαστική εικόνα';
$string['advimage_dlg:general'] = 'Γενικά';
$string['advimage_dlg:height'] = 'Ύψος';
$string['advimage_dlg:hspace'] = 'Απόσταση οριζόντια';
$string['advimage_dlg:id'] = 'Αναγνωριστικό';
$string['advimage_dlg:image_list'] = 'Λίστα εικόνων';
$string['advimage_dlg:langcode'] = 'Κωδικός γλώσσας';
$string['advimage_dlg:langdir'] = 'Κατεύθυνση γλώσσας';
$string['advimage_dlg:list'] = 'Λίστα εικόνων';
$string['advimage_dlg:long_desc'] = 'Σύνδεσμος πλήρους περιγραφής';
$string['advimage_dlg:ltr'] = 'Αριστερά προς δεξιά';
$string['advimage_dlg:map'] = 'Χάρτης εικόνας';
$string['advimage_dlg:misc'] = 'Διάφορα';
$string['advimage_dlg:missing_alt'] = 'Σίγουρα θέλετε να συνεχίσετε χωρίς περιγραφή εικόνας; Χωρίς αυτήν η εικόνα μπορεί να μην είναι προσβάσιμη σε κάποιους χρήστες με προβλήματα, ή σε αυτούς που χρησιμοποιούν περιηγητή κειμένου, ή βλέπουν το Διαδίκτυο με τις εικόνες απενεργοποιημένες.';
$string['advimage_dlg:mouseout'] = 'για απομάκρυνση ποντικιού';
$string['advimage_dlg:mouseover'] = 'για αιώρηση ποντικιού από πάνω';
$string['advimage_dlg:preview'] = 'Προεπισκόπηση';
$string['advimage_dlg:rtl'] = 'Δεξιά προς αριστερά';
$string['advimage_dlg:src'] = 'Διεύθυνση URL εικόνας';
$string['advimage_dlg:style'] = 'Στυλ';
$string['advimage_dlg:swap_image'] = 'Ανταλλαγή εικόνας';
$string['advimage_dlg:tab_advanced'] = 'Για προχωρημένους';
$string['advimage_dlg:tab_appearance'] = 'Εμφάνιση';
$string['advimage_dlg:tab_general'] = 'Γενικά';
$string['advimage_dlg:title'] = 'Τίτλος';
$string['advimage_dlg:vspace'] = 'Απόσταση κάθετη';
$string['advimage_dlg:width'] = 'Πλάτος';
$string['advlink:delta_height'] = '';
$string['advlink:delta_width'] = '';
$string['advlink:link_desc'] = 'Εισαγωγή/επεξεργασία συνδέσμου';
$string['advlink_dlg:accesskey'] = 'Πλήκτρο πρόσβασης';
$string['advlink_dlg:advanced_props'] = 'Προχωρημένες ιδιότητες';
$string['advlink_dlg:advanced_tab'] = 'Για προχωρημένους';
$string['advlink_dlg:anchor_names'] = 'Αγκυρώσεις';
$string['advlink_dlg:classes'] = 'Κλάσεις';
$string['advlink_dlg:encoding'] = 'Κωδικοποίηση χαρακτήρων στόχου';
$string['advlink_dlg:event_props'] = 'Γεγονότα';
$string['advlink_dlg:events_tab'] = 'Γεγονότα';
$string['advlink_dlg:general_props'] = 'Γενικές ιδιότητες';
$string['advlink_dlg:general_tab'] = 'Γενικά';
$string['advlink_dlg:height'] = 'Ύψος';
$string['advlink_dlg:id'] = 'Αναγνωριστικό';
$string['advlink_dlg:is_email'] = 'Η διεύθυνση URL που δώσατε μοιάζει με διεύθυνση ηλε.ταχυδρομείου. Θέλετε να προστεθεί το απαιτούμενο mailto: πρόθεμα;';
$string['advlink_dlg:is_external'] = 'Η διεύθυνση URL που δώσατε μοιάζει με εξωτερικός σύνδεσμος. Θέλετε να προστεθεί το απαιτούμενο http:// πρόθεμα;';
$string['advlink_dlg:langcode'] = 'Κωδικός γλώσσας';
$string['advlink_dlg:langdir'] = 'Κατεύθυνση γλώσσας';
$string['advlink_dlg:link_list'] = 'Λίστα συνδέσμων';
$string['advlink_dlg:list'] = 'Λίστα συνδέσμων';
$string['advlink_dlg:ltr'] = 'Αριστερά προς δεξιά';
$string['advlink_dlg:mime'] = 'Τύπος MIME στόχου';
$string['advlink_dlg:popup'] = 'Αναδυόμενο παράθυρο Javascript';
$string['advlink_dlg:popup_dependent'] = 'Εξαρτώμενο (μόνο για Mozilla/Firefox)';
$string['advlink_dlg:popup_location'] = 'Εμφάνιση γραμμής τοποθεσίας';
$string['advlink_dlg:popup_menubar'] = 'Εμφάνιση μενού';
$string['advlink_dlg:popup_name'] = 'Όνομα παραθύρου';
$string['advlink_dlg:popup_opts'] = 'Επιλογές';
$string['advlink_dlg:popup_position'] = 'Θέση (X/Y)';
$string['advlink_dlg:popup_props'] = 'Ιδιότητες αναδυομένου παραθύρου';
$string['advlink_dlg:popup_resizable'] = 'Να αλλάζουν οι διαστάσεις του παραθύρου';
$string['advlink_dlg:popup_return'] = 'Εισαγωγή «return false»';
$string['advlink_dlg:popup_scrollbars'] = 'Εμφάνιση ράβδων κύλισης';
$string['advlink_dlg:popup_size'] = 'Μέγεθος';
$string['advlink_dlg:popup_statusbar'] = 'Εμφάνιση γραμμής κατάστασης';
$string['advlink_dlg:popup_tab'] = 'Αναδυόμενο παράθυρο';
$string['advlink_dlg:popup_toolbar'] = 'Εμφάνιση γραμμών εργαλείων';
$string['advlink_dlg:popup_url'] = 'Διεύθυνση URL του αναδυόμενου παραθύρου';
$string['advlink_dlg:rel'] = 'Σχέση σελίδας προς στόχο';
$string['advlink_dlg:rev'] = 'Σχέση στόχου προς σελίδα';
$string['advlink_dlg:rtl'] = 'Δεξιά προς αριστερά';
$string['advlink_dlg:style'] = 'Στυλ';
$string['advlink_dlg:tabindex'] = 'Αρίθμηση στοιχείου (Tabindex)';
$string['advlink_dlg:target'] = 'Στόχος';
$string['advlink_dlg:target_blank'] = 'Άνοιγμα σε νέο παράθυρο';
$string['advlink_dlg:target_langcode'] = 'Γλώσσα στόχου';
$string['advlink_dlg:target_name'] = 'Όνομα στόχου';
$string['advlink_dlg:target_parent'] = 'Άνοιγμα στο γονικό παράθυρο/πλαίσιο';
$string['advlink_dlg:target_same'] = 'Άνοιγμα σε αυτό το παράθυρο/πλαίσιο';
$string['advlink_dlg:target_top'] = 'Άνοιγμα στο πιο πάνω frame (αντικαθιστά όλα τα frames)';
$string['advlink_dlg:title'] = 'Εισαγωγή/επεξεργασία συνδέσμου';
$string['advlink_dlg:titlefield'] = 'Τίτλος';
$string['advlink_dlg:url'] = 'Διεύθυνση URL συνδέσμου';
$string['advlink_dlg:width'] = 'Πλάτος';
$string['advlist:circle'] = 'Κύκλος';
$string['advlist:def'] = 'Προεπιλογή';
$string['advlist:disc'] = 'Δίσκος';
$string['advlist:lower_alpha'] = 'Πεζά λατινικά (παλαιότερο)';
$string['advlist:lower_greek'] = 'Πεζά ελληνικά';
$string['advlist:lower_roman'] = 'Πεζά ρωμαϊκά';
$string['advlist:square'] = 'Τετράγωνο';
$string['advlist:types'] = 'Τύποι';
$string['advlist:upper_alpha'] = 'Κεφαλαία λατινικά (παλαιότερο)';
$string['advlist:upper_roman'] = 'Κεφαλαία ρωμαϊκά';
$string['aria:rich_text_area'] = 'Περιοχή κειμένου με μορφοποίηση';
$string['autosave:restore_content'] = 'Επαναφορά του αυτόματα αποθηκευμένου περιεχομένου';
$string['autosave:unload_msg'] = 'Οι αλλαγές που κάνατε θα χαθούν αν φύγετε σε άλλη σελίδα.';
$string['autosave:warning_message'] = 'Εάν επαναφέρετε το αποθηκευμένο περιεχόμενο, θα χάσετε όλο το περιεχόμενο που βρίσκεται στον επεξεργαστή κειμένου. Είστε βέβαιοι ότι θέλετε να επαναφέρετε το αποθηκευμένο περιεχόμενο;';
$string['availablebuttons'] = 'Διαθέσιμα κουμπιά';
$string['colors:000000'] = 'Μαύρο';
$string['colors:000080'] = 'Μπλε μαρέν (ναυτικό)';
$string['colors:0000FF'] = 'Μπλε';
$string['colors:003300'] = 'Σκούρο πράσινο';
$string['colors:003366'] = 'Σκούρο γαλάζιο';
$string['colors:008000'] = 'Πράσινο';
$string['colors:008080'] = 'Μπλε-πράσινο';
$string['colors:00CCFF'] = 'Μπλε ουρανί';
$string['colors:00FF00'] = 'Πρασινο-κίτρινο';
$string['colors:00FFFF'] = 'Μπλε νερού';
$string['colors:333300'] = 'Βαθύ λαδί';
$string['colors:333333'] = 'Πολύ βαθύ γκρι';
$string['colors:333399'] = 'Λουλακί';
$string['colors:3366FF'] = 'Μπλε ρουά';
$string['colors:339966'] = 'Πράσινο θάλασσας';
$string['colors:33CCCC'] = 'Τυρκουάζ';
$string['colors:666699'] = 'Γκριζο-μπλε';
$string['colors:800000'] = 'Καστανέρυθρο';
$string['colors:800080'] = 'Μωβ';
$string['colors:808000'] = 'Λαδί';
$string['colors:808080'] = 'Γκρι';
$string['colors:993300'] = 'Καμένο πορτοκαλί';
$string['colors:993366'] = 'Καφέ';
$string['colors:999999'] = 'Μεσαίο γκρι';
$string['colors:99CC00'] = 'Κιτρινο-πράσινο';
$string['colors:99CCFF'] = 'Φωτεινό ουρανί';
$string['colors:C0C0C0'] = 'Ασημί';
$string['colors:CC99FF'] = 'Δαμασκηνί';
$string['colors:CCFFCC'] = 'Απαλό πράσινο';
$string['colors:CCFFFF'] = 'Απαλό κυανό';
$string['colors:FF0000'] = 'Κόκκινο';
$string['colors:FF00FF'] = 'Ματζέντα (φούξια)';
$string['colors:FF6600'] = 'Πορτοκαλί';
$string['colors:FF9900'] = 'Κεχριμπαρένιο';
$string['colors:FF99CC'] = 'Ροζ';
$string['colors:FFCC00'] = 'Χρυσαφί';
$string['colors:FFCC99'] = 'Ροδακινί';
$string['colors:FFFF00'] = 'Κίτρινο';
$string['colors:FFFF99'] = 'Ανοιχτό κίτρινο';
$string['colors:FFFFFF'] = 'Λευκό';
$string['common:apply'] = 'Εφαρμογή';
$string['common:browse'] = 'Περιήγηση';
$string['common:cancel'] = 'Άκυρο';
$string['common:class_name'] = 'Κλάση';
$string['common:clipboard_msg'] = 'Οι λειτουργίες Αντιγραφή/Αποκοπή/Επικόλληση δεν είναι διαθέσιμες σε Mozilla και Firefox. Θέλετε περισσότερες πληροφορίες για αυτό το ζήτημα;';
$string['common:clipboard_no_support'] = 'Δεν υποστηρίζεται από τον περιηγητή σας. Χρησιμοποιήστε τις συντομεύσεις πληκτρολογίου.';
$string['common:close'] = 'Κλείσιμο';
$string['common:edit_confirm'] = 'Θέλετε να χρησιμοποιήσετε την λειτουργία WYSIWYG ;';
$string['common:insert'] = 'Εισαγωγή';
$string['common:invalid_data'] = 'Σφάλμα: Δόθηκαν μη έγκυρες τιμές, που επισημαίνονται με κόκκινο.';
$string['common:invalid_data_min'] = '{#field} πρέπει να είναι ένας αριθμός μεγαλύτερος από {#min}';
$string['common:invalid_data_number'] = '{#field} πρέπει να είναι ένας αριθμός';
$string['common:invalid_data_size'] = '{#field} πρέπει να είναι ένας αριθμός ή ποσοστό';
$string['common:more_colors'] = 'Περισσότερα χρώματα...';
$string['common:not_set'] = '-- Μη ορισμένο --';
$string['common:popup_blocked'] = 'Λυπούμαστε, αλλά παρατηρήσαμε ότι το πρόγραμμα αποκλεισμού αναδυόμενων παραθύρων (popup-blocker) έχει απενεργοποιήσει ένα παράθυρο απαραίτητο για την εφαρμογή. Πρέπει να το απενεργοποιήσετε για αυτόν τον ιστότοπο για να χρησιμοποιήσετε πλήρως την εφαρμογή.';
$string['common:update'] = 'Ενημέρωση';
$string['common:value'] = '(τιμή)';
$string['contextmenu:align'] = 'Στοίχιση';
$string['contextmenu:center'] = 'Κέντρο';
$string['contextmenu:full'] = 'Πλήρης';
$string['contextmenu:left'] = 'Αριστερά';
$string['contextmenu:right'] = 'Δεξιά';
$string['customconfig'] = 'Προσαρμοσμένες ρυθμίσεις';
$string['customconfig_desc'] = 'Προσαρμοσμένες προχωρημένες ρυθμίσεις του TinyMCE σε μορφότυπο JSON, για παράδειγμα: {"option1": "value2", "option2": "value2"}. Οποιεσδήποτε επιλογές καθορίζονται εδώ παρακάμπτουν τις τυπικές ρυθμίσεις και τις ρυθμίσεις πρόσθετου.';
$string['customtoolbar'] = 'Εργαλειοθήκη επεξεργαστή κειμένου';
$string['customtoolbar_desc'] = 'Κάθε γραμμή περιέχει μια λίστα από ονόματα πλήκτρων χωρισμένα με κόμμα. Χρησιμοποιήστε «wrap» ως διαχωριστικό ομάδας. Άδειες γραμμές αγνοούνται. Δείτε <a href="{$a}" target="_blank">{$a}</a> για τον κατάλογο των προεπιλεγμένων πλήκτρων TinyMCE.<br />Η πρώτη σειρά θα εμφανίζεται πάντα ενώ η ορατότητα της δεύτερης και της τρίτης γραμμής εργαλείων μπορεί να επιλέγεται.';
$string['directionality:ltr_desc'] = 'Κατεύθυνση αριστερά προς δεξιά';
$string['directionality:rtl_desc'] = 'Κατεύθυνση δεξιά προς αριστερά';
$string['emotions:delta_height'] = '';
$string['emotions:delta_width'] = '';
$string['emotions:emotions_desc'] = 'Συναισθήματα';
$string['emotions_dlg:cool'] = 'Άνετος';
$string['emotions_dlg:cry'] = 'Δακρυσμένος';
$string['emotions_dlg:desc'] = 'Συναισθήματα';
$string['emotions_dlg:embarassed'] = 'Αμήχανος';
$string['emotions_dlg:foot_in_mouth'] = 'Κλωτσιά στο στόμα';
$string['emotions_dlg:frown'] = 'Κατσουφιασμένος';
$string['emotions_dlg:innocent'] = 'Αθώος';
$string['emotions_dlg:kiss'] = 'Φιλί';
$string['emotions_dlg:laughing'] = 'Γέλιο';
$string['emotions_dlg:money_mouth'] = 'Λεφτά ως στόμα';
$string['emotions_dlg:sealed'] = 'Σφραγισμένο στόμα';
$string['emotions_dlg:smile'] = 'Χαμόγελο';
$string['emotions_dlg:surprised'] = 'Έκπληκτος';
$string['emotions_dlg:title'] = 'Εισαγωγή συναισθήματος';
$string['emotions_dlg:tongue_out'] = 'Γλώσσα έξω';
$string['emotions_dlg:undecided'] = 'Αναποφάσιστος';
$string['emotions_dlg:usage'] = 'Χρησιμοποιήστε τα αριστερά και δεξιά βελάκια για να πλοηγηθείτε.';
$string['emotions_dlg:wink'] = 'Κλείσιμο ματιού';
$string['emotions_dlg:yell'] = 'Φωνάζω';
$string['fontselectlist'] = 'Διαθέσιμη λίστα γραμματοσειρών';
$string['fullpage:delta_height'] = '';
$string['fullpage:delta_width'] = '';
$string['fullpage:desc'] = 'Ιδιότητες εγγράφου';
$string['fullpage_dlg:active_color'] = 'Ενεργό χρώμα';
$string['fullpage_dlg:add'] = 'Προσθήκη στοιχείου';
$string['fullpage_dlg:add_base'] = 'Στοιχείο βάσης';
$string['fullpage_dlg:add_comment'] = 'Κόμβος σχολίου';
$string['fullpage_dlg:add_link'] = 'Στοιχείο συνδέσμου';
$string['fullpage_dlg:add_meta'] = 'Στοιχείο μετα-πληροφορίας';
$string['fullpage_dlg:add_script'] = 'Στοιχείο Script';
$string['fullpage_dlg:add_style'] = 'Στοιχείο στυλ';
$string['fullpage_dlg:add_title'] = 'Στοιχείο τίτλου';
$string['fullpage_dlg:advanced_props'] = 'Για προχωρημένους';
$string['fullpage_dlg:advanced_tab'] = 'Για προχωρημένους';
$string['fullpage_dlg:appearance_bgprops'] = 'Ιδιότητες υπόβαθρου';
$string['fullpage_dlg:appearance_linkprops'] = 'Χρώματα συνδέσμων';
$string['fullpage_dlg:appearance_marginprops'] = 'Περιθώρια σώματος';
$string['fullpage_dlg:appearance_style'] = 'Ιδιότητες στυλ και αρχείου στυλ';
$string['fullpage_dlg:appearance_tab'] = 'Εμφάνιση';
$string['fullpage_dlg:appearance_textprops'] = 'Ιδιότητες κειμένου';
$string['fullpage_dlg:author'] = 'Συγγραφέας';
$string['fullpage_dlg:base_element'] = 'Στοιχείο βάσης';
$string['fullpage_dlg:bgcolor'] = 'Χρώμα υπόβαθρου';
$string['fullpage_dlg:bgimage'] = 'Εικόνα υπόβαθρου';
$string['fullpage_dlg:bottom_margin'] = 'Κάτω περιθώριο';
$string['fullpage_dlg:charset'] = 'Σετ χαρακτήρων';
$string['fullpage_dlg:comment_element'] = 'Σχόλιο';
$string['fullpage_dlg:content'] = 'Περιεχόμενο';
$string['fullpage_dlg:copyright'] = 'Δικαιώματα πνευματικής ιδιοκτησίας (Copyright)';
$string['fullpage_dlg:defer'] = 'Αναβολή';
$string['fullpage_dlg:doctypes'] = 'Τύπος εγγράφου';
$string['fullpage_dlg:encoding'] = 'Κωδικοποίηση χαρακτήρων';
$string['fullpage_dlg:font_face'] = 'Γραμματοσειρά';
$string['fullpage_dlg:font_size'] = 'Μέγεθος γραμμάτων';
$string['fullpage_dlg:fontface'] = 'Γραμματοσειρά';
$string['fullpage_dlg:fontsize'] = 'Μέγεθος γραμμάτων';
$string['fullpage_dlg:general_props'] = 'Γενικά';
$string['fullpage_dlg:head_elements'] = 'Στοιχεία κεφαλής';
$string['fullpage_dlg:hover_color'] = 'Χρώμα συνδέσμου (Hover)';
$string['fullpage_dlg:href'] = 'HREF';
$string['fullpage_dlg:hreflang'] = 'Γλώσσα HREF';
$string['fullpage_dlg:info'] = 'Πληροφορίες';
$string['fullpage_dlg:langcode'] = 'Κωδικός γλώσσας';
$string['fullpage_dlg:langdir'] = 'Κατεύθυνση γλώσσας';
$string['fullpage_dlg:langprops'] = 'Γλώσσα και κωδικοποίηση';
$string['fullpage_dlg:language'] = 'Γλώσσα';
$string['fullpage_dlg:left_margin'] = 'Αριστερό περιθώριο';
$string['fullpage_dlg:link_color'] = 'Χρώμα συνδέσμου';
$string['fullpage_dlg:link_element'] = 'Στοιχείο συνδέσμου';
$string['fullpage_dlg:ltr'] = 'Αριστερά προς δεξιά';
$string['fullpage_dlg:media'] = 'Πολυμέσα';
$string['fullpage_dlg:meta_description'] = 'Περιγραφή';
$string['fullpage_dlg:meta_element'] = 'Στοιχείο μετα-πληροφορίας';
$string['fullpage_dlg:meta_index_follow'] = 'Ευρετηρίαση και να ακολουθηθούν οι σύνδεσμοι';
$string['fullpage_dlg:meta_index_nofollow'] = 'Ευρετηρίαση και να μην ακολουθηθούν οι σύνδεσμοι';
$string['fullpage_dlg:meta_keywords'] = 'Λέξεις κλειδιά';
$string['fullpage_dlg:meta_noindex_follow'] = 'Χωρίς ευρετηρίαση και να ακολουθηθούν οι σύνδεσμοι';
$string['fullpage_dlg:meta_noindex_nofollow'] = 'Χωρίς ευρετηρίαση και να μην ακολουθηθούν οι σύνδεσμοι';
$string['fullpage_dlg:meta_props'] = 'Μετα-πληροφορίες';
$string['fullpage_dlg:meta_robots'] = 'Ρομπότ';
$string['fullpage_dlg:meta_tab'] = 'Γενικά';
$string['fullpage_dlg:meta_title'] = 'Τίτλος';
$string['fullpage_dlg:movedown'] = 'Μετακίνηση επιλεγμένου στοιχείου κάτω';
$string['fullpage_dlg:moveup'] = 'Μετακίνηση επιλεγμένου στοιχείου πάνω';
$string['fullpage_dlg:name'] = 'Όνομα';
$string['fullpage_dlg:properties'] = 'Ιδιότητες';
$string['fullpage_dlg:rel'] = 'Rel';
$string['fullpage_dlg:remove'] = 'Αφαίρεση επιλεγμένου στοιχείου';
$string['fullpage_dlg:rev'] = 'Rev';
$string['fullpage_dlg:right_margin'] = 'Δεξιό περιθώριο';
$string['fullpage_dlg:rtl'] = 'Δεξιά προς αριστερά';
$string['fullpage_dlg:script_element'] = 'Στοιχείο Script';
$string['fullpage_dlg:src'] = 'Πηγή';
$string['fullpage_dlg:style'] = 'Στυλ';
$string['fullpage_dlg:style_element'] = 'Στοιχείο στυλ';
$string['fullpage_dlg:stylesheet'] = 'Αρχείο στυλ';
$string['fullpage_dlg:target'] = 'Στόχος';
$string['fullpage_dlg:text_color'] = 'Χρώμα κειμένου';
$string['fullpage_dlg:textcolor'] = 'Χρώμα';
$string['fullpage_dlg:title'] = 'Ιδιότητες εγγράφου';
$string['fullpage_dlg:title_element'] = 'Στοιχείο τίτλου';
$string['fullpage_dlg:top_margin'] = 'Πάνω περιθώριο';
$string['fullpage_dlg:type'] = 'Τύπος';
$string['fullpage_dlg:value'] = 'Τιμή';
$string['fullpage_dlg:visited_color'] = 'Χρώμα επισκεφθέντος συνδέσμου (χρησιμοποιημένου)';
$string['fullpage_dlg:xml_pi'] = 'Δήλωση XML';
$string['fullscreen:desc'] = 'Εναλλαγή πλήρους οθόνης';
$string['iespell:download'] = 'Το ieSpell δεν βρέθηκε. Να εγκατασταθεί τώρα;';
$string['iespell:iespell_desc'] = 'Έλεγχος ορθογραφίας';
$string['insertdatetime:date_fmt'] = '%Y-%m-%d';
$string['insertdatetime:day_long'] = 'Κυριακή,Δευτέρα,Τρίτη,Τετάρτη,Πέμπτη,Παρασκευή,Σάββατο,Κυριακή';
$string['insertdatetime:day_short'] = 'Κυ,Δε,Τρ,Τετ,Πέμ,Παρ,Σαβ';
$string['insertdatetime:insertdate_desc'] = 'Εισαγωγή ημέρας';
$string['insertdatetime:inserttime_desc'] = 'Εισαγωγή ώρας';
$string['insertdatetime:months_long'] = 'Ιανουάριος,Φεβρουάριος,Μάρτιος,Απρίλιος,Μάιος,Ιούνιος,Ιούλιος,Αύγουστος,Σεπτέμβριος,Οκτώβριος,Νοέμβριος,Δεκέμβριος';
$string['insertdatetime:months_short'] = 'Ιαν,Φεβ,Μάρ,Απρ,Μάι,Ιύν,Ιύλ,Αύγ,Σεπ,Οκτ,Νοέ,Δεκ';
$string['insertdatetime:time_fmt'] = '%H:%M:%S';
$string['layer:absolute_desc'] = 'Εναλλαγή απόλυτης/σχετικής τοποθέτησης';
$string['layer:backward_desc'] = 'Μετακίνηση στο παρασκήνιο';
$string['layer:content'] = 'Νέο layer...';
$string['layer:forward_desc'] = 'Μετακίνηση στο προσκήνιο';
$string['layer:insertlayer_desc'] = 'Εισαγωγή νέου layer';
$string['media:delta_height'] = '';
$string['media:delta_width'] = '';
$string['media:desc'] = 'Εισαγωγή/επεξεργασία ενσωματωμένων πολυμέσων';
$string['media:edit'] = 'Επεξεργασία ενσωματωμένων πολυμέσων';
$string['media_dlg:advanced'] = 'Για προχωρημένους';
$string['media_dlg:align'] = 'Στοίχιση';
$string['media_dlg:align_bottom'] = 'Κάτω';
$string['media_dlg:align_bottom_left'] = 'Κάτω αριστερά';
$string['media_dlg:align_bottom_right'] = 'Κάτω δεξιά';
$string['media_dlg:align_center'] = 'Κέντρο';
$string['media_dlg:align_left'] = 'Αριστερά';
$string['media_dlg:align_right'] = 'Δεξιά';
$string['media_dlg:align_top'] = 'Πάνω';
$string['media_dlg:align_top_left'] = 'Πάνω αριστερά';
$string['media_dlg:align_top_right'] = 'Πάνω δεξιά';
$string['media_dlg:altsource1'] = 'Εναλλακτική πηγή 1';
$string['media_dlg:altsource2'] = 'Εναλλακτική πηγή 2';
$string['media_dlg:audio'] = 'Ήχος HTML5';
$string['media_dlg:autogotourl'] = 'Αυτόματη μετάβαση στο URL';
$string['media_dlg:autohref'] = 'Auto HREF';
$string['media_dlg:autostart'] = 'Αυτόματη εκκίνηση';
$string['media_dlg:balance'] = 'Ισορροπία';
$string['media_dlg:base'] = 'Βάση';
$string['media_dlg:baseurl'] = 'Βασική διεύθυνση URL';
$string['media_dlg:bgcolor'] = 'Υπόβαθρο';
$string['media_dlg:cache'] = 'Κρυφή μνήμη';
$string['media_dlg:captioningid'] = 'Αναγνωριστικό υπομνηματισμού (λεζάντας)';
$string['media_dlg:center'] = 'Κέντρο';
$string['media_dlg:class_name'] = 'Κλάση';
$string['media_dlg:console'] = 'Κονσόλα';
$string['media_dlg:constrain_proportions'] = 'Διατήρηση αναλογίας πλ. - ύψους';
$string['media_dlg:controller'] = 'Ελεγκτής';
$string['media_dlg:controls'] = 'Χειριστήρια';
$string['media_dlg:correction'] = 'Χωρίς διόρθωση';
$string['media_dlg:currentmarker'] = 'Τρέχον μαρκαδόρος';
$string['media_dlg:currentposition'] = 'Τρέχουσα θέση';
$string['media_dlg:defaultframe'] = 'Προεπιλεγμένο καρέ';
$string['media_dlg:embedded_audio_options'] = 'Επιλογές ενσωματωμένου ήχου';
$string['media_dlg:embeddedaudio'] = 'Ενσωματωμένος ήχος';
$string['media_dlg:enabled'] = 'Ενεργοποιημένο';
$string['media_dlg:enablejavascript'] = 'Ενεργοποίηση JavaScript';
$string['media_dlg:endtime'] = 'Ώρα λήξης';
$string['media_dlg:file'] = 'Αρχείο/URL';
$string['media_dlg:flash'] = 'Λάμψη';
$string['media_dlg:flash_options'] = 'Επιλογές Flash';
$string['media_dlg:flashvars'] = 'Μεταβλητές Flash';
$string['media_dlg:fullscreen'] = 'Πλήρης οθόνη';
$string['media_dlg:general'] = 'Γενικά';
$string['media_dlg:hidden'] = 'Κρυφό';
$string['media_dlg:href'] = 'HREF';
$string['media_dlg:hspace'] = 'Απόσταση οριζόντια';
$string['media_dlg:html5_audio_options'] = 'Επιλογές ήχου';
$string['media_dlg:html5_video_options'] = 'Επιλογές βίντεο HTML5';
$string['media_dlg:id'] = 'Αναγνωριστικό';
$string['media_dlg:iframe'] = 'Εντός πλαισίου ιστού';
$string['media_dlg:imagestatus'] = 'Κατάσταση εικόνας';
$string['media_dlg:invokeurls'] = 'Κλήση URLs';
$string['media_dlg:kioskmode'] = 'Λειτουργία Kiosk';
$string['media_dlg:list'] = 'Λίστα';
$string['media_dlg:liveconnect'] = 'SWLiveConnect';
$string['media_dlg:loop'] = 'Επανάληψη';
$string['media_dlg:maintainaspect'] = 'Διατήρηση αναλογίας διαστάσεων (πλάτος-ύψος)';
$string['media_dlg:menu'] = 'Εμφάνιση μενού';
$string['media_dlg:mute'] = 'Σίγαση';
$string['media_dlg:name'] = 'Όνομα';
$string['media_dlg:nojava'] = 'Χωρίς Java';
$string['media_dlg:numloop'] = 'Πόσες φορές θα παίξει';
$string['media_dlg:play'] = 'Αυτόματο εκκίνηση';
$string['media_dlg:playcount'] = 'Πόσες φορές θα παίξει';
$string['media_dlg:playeveryframe'] = 'Παίξιμο όλων των καρέ';
$string['media_dlg:poster'] = 'Αφίσα';
$string['media_dlg:prefetch'] = 'Προ-εύρεση';
$string['media_dlg:preload'] = 'Προφόρτωση';
$string['media_dlg:preload_auto'] = 'Αφήστε τον περιηγητή του χρήστη να επιλέξει';
$string['media_dlg:preload_metadata'] = 'Προφόρτωση μεταδεδομένων βίντεο';
$string['media_dlg:preload_none'] = 'Χωρίς προφόρτωση';
$string['media_dlg:preview'] = 'Προεπισκόπηση';
$string['media_dlg:progress'] = 'Πρόοδος';
$string['media_dlg:qt_options'] = 'Επιλογές QuickTime';
$string['media_dlg:qt_stream_warn'] = 'Πόροι συνεχούς ροής πολυμέσου RTSP θα πρέπει να προστεθούν στο πεδίο «Πηγή αρχείου QuickTime» κάτω από την καρτέλα «Για προχωρημένους».
Επίσης καλό θα ήταν να προσθέσετε μια απλή (όχι ροής) έκδοση στο πεδίο αυτό.';
$string['media_dlg:qtsrc'] = 'Πηγή αρχείου QuickTime';
$string['media_dlg:qtsrcchokespeed'] = 'Choke speed';
$string['media_dlg:quality'] = 'Ποιότητα';
$string['media_dlg:quicktime'] = 'QuickTime';
$string['media_dlg:rate'] = 'Ρυθμός';
$string['media_dlg:realmedia'] = 'Real Media';
$string['media_dlg:rmp_options'] = 'Επιλογές προγράμματος αναπαραγωγής πολυμέσων Real Media Player';
$string['media_dlg:salign'] = 'SAlign';
$string['media_dlg:scale'] = 'Κλίμακα';
$string['media_dlg:scriptcallbacks'] = 'Επανακλήσεις σεναρίου';
$string['media_dlg:shockwave'] = 'Shockwave';
$string['media_dlg:shockwave_options'] = 'Επιλογές Shockwave';
$string['media_dlg:shuffle'] = 'Τυχαία σειρά';
$string['media_dlg:size'] = 'Διαστάσεις';
$string['media_dlg:sound'] = 'Ήχος';
$string['media_dlg:source'] = 'Πηγή';
$string['media_dlg:starttime'] = 'Ώρα έναρξης';
$string['media_dlg:stretchtofit'] = 'Επέκταση ώστε να χωρέσει';
$string['media_dlg:swstretchhalign'] = 'Οριζόντια-Στοίχιση επέκταση';
$string['media_dlg:swstretchstyle'] = 'Στυλ Επέκτασης';
$string['media_dlg:swstretchvalign'] = 'Κατακόρυφη-Στοίχιση επέκταση';
$string['media_dlg:target'] = 'Στόχος';
$string['media_dlg:targetcache'] = 'Κρυφή μνήμη στόχου';
$string['media_dlg:title'] = 'Εισαγωγή/επεξεργασία ενσωματωμένων πολυμέσων';
$string['media_dlg:type'] = 'Τύπος';
$string['media_dlg:uimode'] = 'Λειτουργία UI';
$string['media_dlg:video'] = 'Βίντεο HTML5';
$string['media_dlg:volume'] = 'Ένταση';
$string['media_dlg:vspace'] = 'Απόσταση κάθετη';
$string['media_dlg:windowlessvideo'] = 'Βίντεο χωρίς παράθυρο';
$string['media_dlg:windowsmedia'] = 'Windows Media';
$string['media_dlg:wmode'] = 'WMode';
$string['media_dlg:wmp_options'] = 'Επιλογές προγράμματος αναπαραγωγής πολυμέσων Windows Media Player';
$string['nonbreaking:nonbreaking_desc'] = 'Εισαγωγή non-breaking κενού χαρακτήρα';
$string['pagebreak:desc'] = 'Εισαγωγή αλλαγής σελίδας κατά την εκτύπωση.';
$string['paste:paste_text_desc'] = 'Επικόλληση ως απλό κείμενο';
$string['paste:paste_word_desc'] = 'Επικόλληση από το Word';
$string['paste:plaintext_mode'] = 'Η επικόλληση είναι τώρα σε κατάσταση απλού κειμένου. Κάντε κλικ ξανά για εναλλαγή σε κανονική κατάσταση επικόλλησης. Μόλις επικολλήσετε κάτι θα επιστρέψετε σε κανονική κατάσταση επικόλλησης.';
$string['paste:plaintext_mode_stick'] = 'Η επικόλληση είναι τώρα σε κατάσταση απλού κειμένου. Κάντε κλικ ξανά για εναλλαγή σε κανονική κατάσταση επικόλλησης.';
$string['paste:selectall_desc'] = 'Επιλογή όλων';
$string['paste_dlg:text_linebreaks'] = 'Να κρατηθούν τα linebreaks';
$string['paste_dlg:text_title'] = 'Χρησιμοποιήστε CTRL+V για να κάνετε επικόλληση του κειμένου στο παράθυρο.';
$string['paste_dlg:word_title'] = 'Χρησιμοποιήστε CTRL+V για να κάνετε επικόλληση του κειμένου στο παράθυρο.';
$string['pluginname'] = 'Επεξεργαστής HTML TinyMCE';
$string['preview:preview_desc'] = 'Προεπισκόπηση';
$string['print:print_desc'] = 'Εκτύπωση';
$string['privacy:metadata'] = 'Το πρόσθετο «Επεξεργαστής HTML TinyMCE» δεν αποθηκεύει κανένα προσωπικό δεδομένο.';
$string['save:cancel_desc'] = 'Ακύρωση όλων των αλλαγών';
$string['save:save_desc'] = 'Αποθήκευση';
$string['searchreplace:delta_height'] = '';
$string['searchreplace:delta_width'] = '';
$string['searchreplace:replace_desc'] = 'Εύρεση/αντικατάσταση';
$string['searchreplace:search_desc'] = 'Εύρεση';
$string['searchreplace_dlg:allreplaced'] = 'Όλες οι εμφανίσεις του ζητούμενου κειμένου αντικαταστάθηκαν.';
$string['searchreplace_dlg:direction'] = 'Κατεύθυνση';
$string['searchreplace_dlg:down'] = 'Κάτω';
$string['searchreplace_dlg:findnext'] = 'Βρες επόμενο';
$string['searchreplace_dlg:findwhat'] = 'Εύρεση του';
$string['searchreplace_dlg:mcase'] = 'Ταίριασμα κεφαλαία/μικρά';
$string['searchreplace_dlg:notfound'] = 'Η αναζήτηση τελείωσε. Δεν ήταν δυνατή η εύρεση του λεκτικού αναζήτησης.';
$string['searchreplace_dlg:replace'] = 'Αντικατάσταση';
$string['searchreplace_dlg:replace_title'] = 'Εύρεση/αντικατάσταση';
$string['searchreplace_dlg:replaceall'] = 'Αντικατ. όλων';
$string['searchreplace_dlg:replacewith'] = 'Αντικατάσταση με';
$string['searchreplace_dlg:search_title'] = 'Εύρεση';
$string['searchreplace_dlg:searchnext_desc'] = 'Εύρεση ξανά';
$string['searchreplace_dlg:up'] = 'Πάνω';
$string['settings'] = 'Γενικές ρυθμίσεις';
$string['simple:bold_desc'] = 'Έντονα (Ctrl+B)';
$string['simple:bullist_desc'] = 'Εισαγωγή/διαγραφή λίστας με κουκίδες';
$string['simple:cleanup_desc'] = 'Καθαρισμός μπερδεμένου κώδικα';
$string['simple:italic_desc'] = 'Πλάγια (Ctrl+I)';
$string['simple:numlist_desc'] = 'Εισαγωγή/διαγραφή αριθμημένης λίστας';
$string['simple:redo_desc'] = 'Επανάληψη (Ctrl+Y)';
$string['simple:striketrough_desc'] = 'Διαγραμμισμένα';
$string['simple:underline_desc'] = 'Υπογραμμισμένα (Ctrl+U)';
$string['simple:undo_desc'] = 'Αναίρεση (Ctrl+Z)';
$string['spellchecker:desc'] = 'Εναλλαγή ορθογραφικού ελέγχου';
$string['spellchecker:ignore_word'] = 'Παράβλεψη λέξης';
$string['spellchecker:ignore_words'] = 'Παράβλεψη όλων';
$string['spellchecker:langs'] = 'Γλώσσες';
$string['spellchecker:learn_word'] = 'Εκμάθηση λέξης';
$string['spellchecker:menu'] = 'Ρυθμίσεις ορθογραφικού ελέγχου';
$string['spellchecker:no_mpell'] = 'Σωστή ορθογραφία.';
$string['spellchecker:no_sug'] = 'Χωρίς προτάσεις';
$string['spellchecker:sug'] = 'Προτάσεις';
$string['spellchecker:wait'] = 'Παρακαλούμε περιμένετε...';
$string['style:delta_height'] = '';
$string['style:delta_width'] = '';
$string['style:desc'] = 'Επεξεργασία στυλ CSS';
$string['style_dlg:apply'] = 'Εφαρμογή';
$string['style_dlg:background'] = 'Υπόβαθρο';
$string['style_dlg:background_attachment'] = 'Συνημμένο';
$string['style_dlg:background_color'] = 'Χρώμα υπόβαθρου';
$string['style_dlg:background_hpos'] = 'Οριζόντια θέση';
$string['style_dlg:background_image'] = 'Εικόνα υπόβαθρου';
$string['style_dlg:background_repeat'] = 'Επανάληψη';
$string['style_dlg:background_tab'] = 'Υπόβαθρο';
$string['style_dlg:background_vpos'] = 'Κατακόρυφη θέση';
$string['style_dlg:block'] = 'Μπλοκ';
$string['style_dlg:block_display'] = 'Εμφάνιση';
$string['style_dlg:block_letterspacing'] = 'Απόσταση χαρακτήρων';
$string['style_dlg:block_tab'] = 'Μπλοκ';
$string['style_dlg:block_text_align'] = 'Στοίχιση κειμένου';
$string['style_dlg:block_text_indent'] = 'Εσοχή κειμένου';
$string['style_dlg:block_vertical_alignment'] = 'Κατακόρυφη στοίχιση';
$string['style_dlg:block_whitespace'] = 'Κενός χώρος';
$string['style_dlg:block_wordspacing'] = 'Απόσταση λέξεων';
$string['style_dlg:border'] = 'Περίγραμμα';
$string['style_dlg:border_tab'] = 'Περίγραμμα';
$string['style_dlg:bottom'] = 'Κάτω';
$string['style_dlg:box'] = 'Κουτί';
$string['style_dlg:box_clear'] = 'Clear';
$string['style_dlg:box_float'] = 'Float';
$string['style_dlg:box_height'] = 'Ύψος';
$string['style_dlg:box_tab'] = 'Κουτί';
$string['style_dlg:box_width'] = 'Πλάτος';
$string['style_dlg:bullet_image'] = 'Εικόνα τελείας';
$string['style_dlg:clip'] = '';
$string['style_dlg:color'] = 'Χρώμα';
$string['style_dlg:height'] = 'Ύψος';
$string['style_dlg:left'] = 'Αριστερά';
$string['style_dlg:list'] = 'Λίστα';
$string['style_dlg:list_tab'] = 'Λίστα';
$string['style_dlg:list_type'] = 'Τύπος';
$string['style_dlg:margin'] = 'Περιθώριο';
$string['style_dlg:overflow'] = 'Υπερχείλιση';
$string['style_dlg:padding'] = 'Γέμισμα';
$string['style_dlg:placement'] = 'Τοποθέτηση';
$string['style_dlg:position'] = 'Θέση';
$string['style_dlg:positioning_tab'] = 'Τοποθέτηση';
$string['style_dlg:positioning_type'] = 'Τύπος';
$string['style_dlg:right'] = 'Δεξιά';
$string['style_dlg:same'] = 'Ίδιο για όλα';
$string['style_dlg:style'] = 'Στυλ';
$string['style_dlg:text'] = 'Κείμενο';
$string['style_dlg:text_blink'] = 'Να αναβοσβήνει';
$string['style_dlg:text_case'] = 'Κεφ./Μικρά';
$string['style_dlg:text_color'] = 'Χρώμα';
$string['style_dlg:text_decoration'] = 'Διακόσμηση';
$string['style_dlg:text_font'] = 'Γραμματοσειρά';
$string['style_dlg:text_lineheight'] = 'Ύψος γραμμής';
$string['style_dlg:text_none'] = 'Καμία';
$string['style_dlg:text_overline'] = 'Υπεργράμμιση';
$string['style_dlg:text_props'] = 'Κείμενο';
$string['style_dlg:text_size'] = 'Μέγεθος γραμμάτων';
$string['style_dlg:text_striketrough'] = 'Διαγράμμιση';
$string['style_dlg:text_style'] = 'Στυλ';
$string['style_dlg:text_tab'] = 'Κείμενο';
$string['style_dlg:text_underline'] = 'Υπογράμμιση';
$string['style_dlg:text_variant'] = 'Παραλλαγή';
$string['style_dlg:text_weight'] = 'Συντελεστής βαρύτητας';
$string['style_dlg:title'] = 'Επεξεργασία στυλ CSS';
$string['style_dlg:toggle_insert_span'] = 'Εισαγωγή εκπετάσματος (span) κατά την επιλογή';
$string['style_dlg:top'] = 'Πάνω';
$string['style_dlg:visibility'] = 'Ορατότητα';
$string['style_dlg:width'] = 'Πλάτος';
$string['style_dlg:zindex'] = 'Z-index (αρίθμηση επικάλυψης σε βάθος)';
$string['subplugintype_tinymce'] = 'Πρόσθετο';
$string['subplugintype_tinymce_plural'] = 'Πρόσθετα';
$string['table:cell'] = 'Κελί';
$string['table:cell_desc'] = 'Ιδιότητες κελιού πίνακα';
$string['table:cellprops_delta_height'] = '';
$string['table:cellprops_delta_width'] = '';
$string['table:col'] = 'Στήλη';
$string['table:col_after_desc'] = 'Εισαγωγή στήλης μετά';
$string['table:col_before_desc'] = 'Εισαγωγή στήλης πριν';
$string['table:copy_row_desc'] = 'Αντιγραφή γραμμής πίνακα';
$string['table:cut_row_desc'] = 'Αποκοπή γραμμής πίνακα';
$string['table:del'] = 'Διαγραφή πίνακα';
$string['table:delete_col_desc'] = 'Διαγραφή στήλης';
$string['table:delete_row_desc'] = 'Διαγραφή γραμμής';
$string['table:desc'] = 'Εισαγωγή/επεξεργασία πίνακα';
$string['table:merge_cells_delta_height'] = '';
$string['table:merge_cells_delta_width'] = '';
$string['table:merge_cells_desc'] = 'Συγχώνευση κελιών πίνακα';
$string['table:paste_row_after_desc'] = 'Επικόλληση γραμμής πίνακα μετά';
$string['table:paste_row_before_desc'] = 'Επικόλληση γραμμής πίνακα πριν';
$string['table:props_desc'] = 'Ιδιότητες πίνακα';
$string['table:row'] = 'Γραμμή';
$string['table:row_after_desc'] = 'Εισαγωγή γραμμής μετά';
$string['table:row_before_desc'] = 'Εισαγωγή γραμμής πριν';
$string['table:row_desc'] = 'Ιδιότητες γραμμής πίνακα';
$string['table:rowprops_delta_height'] = '';
$string['table:rowprops_delta_width'] = '';
$string['table:split_cells_desc'] = 'συγχωνευμένων κελιών πίνακα';
$string['table:table_delta_height'] = '';
$string['table:table_delta_width'] = '';
$string['table_dlg:advanced_props'] = 'Προχωρημένες ιδιότητες';
$string['table_dlg:advanced_tab'] = 'Για προχωρημένους';
$string['table_dlg:align'] = 'Στοίχιση';
$string['table_dlg:align_bottom'] = 'Κάτω';
$string['table_dlg:align_default'] = 'Προεπιλογή';
$string['table_dlg:align_left'] = 'Αριστερά';
$string['table_dlg:align_middle'] = 'Κέντρο';
$string['table_dlg:align_right'] = 'Δεξιά';
$string['table_dlg:align_top'] = 'Πάνω';
$string['table_dlg:bgcolor'] = 'Χρώμα υπόβαθρου';
$string['table_dlg:bgimage'] = 'Εικόνα υπόβαθρου';
$string['table_dlg:border'] = 'Περίγραμμα';
$string['table_dlg:bordercolor'] = 'Χρώμα περιγράμματος';
$string['table_dlg:caption'] = 'Επικεφαλίδα πίνακα';
$string['table_dlg:cell_all'] = 'Ενημέρωση όλων των κελιών του πίνακα';
$string['table_dlg:cell_cell'] = 'Ενημέρωση τρέχοντος κελιού';
$string['table_dlg:cell_col'] = 'Ενημέρωση όλων των κελιών στη στήλη';
$string['table_dlg:cell_limit'] = 'Έχετε ξεπεράσει τον μέγιστο αριθμό κελιών που είναι {$cells}.';
$string['table_dlg:cell_row'] = 'Ενημέρωση όλων των κελιών της γραμμής';
$string['table_dlg:cell_title'] = 'Ιδιότητες κελιού πίνακα';
$string['table_dlg:cell_type'] = 'Τύπος κελιού';
$string['table_dlg:cellpadding'] = 'Εσωτερικό γέμισμα/περιθώριο κελιού';
$string['table_dlg:cellspacing'] = 'Απόσταση κελιών';
$string['table_dlg:col_limit'] = 'Έχετε ξεπεράσει τον μέγιστο αριθμό στηλών που είναι {$cols}.';
$string['table_dlg:colgroup'] = 'Ομάδα στηλών';
$string['table_dlg:cols'] = 'Στήλες';
$string['table_dlg:frame'] = 'Frame';
$string['table_dlg:frame_all'] = 'όλα';
$string['table_dlg:frame_cols'] = 'στήλες';
$string['table_dlg:frame_groups'] = 'ομάδες';
$string['table_dlg:frame_none'] = 'κανένα';
$string['table_dlg:frame_rows'] = 'γραμμές';
$string['table_dlg:general_props'] = 'Γενικές ιδιότητες';
$string['table_dlg:general_tab'] = 'Γενικά';
$string['table_dlg:height'] = 'Ύψος';
$string['table_dlg:id'] = 'Αναγνωριστικό';
$string['table_dlg:langcode'] = 'Κωδικός γλώσσας';
$string['table_dlg:langdir'] = 'Κατεύθυνση γλώσσας';
$string['table_dlg:ltr'] = 'Αριστερά προς δεξιά';
$string['table_dlg:merge_cells_title'] = 'Συγχώνευση κελιών πίνακα';
$string['table_dlg:mime'] = 'Τύπος MIME στόχου';
$string['table_dlg:missing_scope'] = 'Σίγουρα θέλετε να συνεχίσετε χωρίς να έχετε καθορίσει την εμβέλεια του κελιού στην κορυφή αυτού του πίνακα; Χωρίς αυτή, μπορεί να είναι δύσκολο για κάποιους χρήστες με διαφορετικές ικανότητες να καταλάβουν τα περιεχόμενα ή τα δεδομένα του πίνακα.';
$string['table_dlg:row_all'] = 'Ενημέρωση όλων των γραμμών του πίνακα';
$string['table_dlg:row_even'] = 'Ενημέρωση των ζυγών γραμμών του πίνακα';
$string['table_dlg:row_limit'] = 'Έχετε ξεπεράσει τον μέγιστο αριθμό γραμμών που είναι {$rows}.';
$string['table_dlg:row_odd'] = 'Ενημέρωση των μονών γραμμών του πίνακα';
$string['table_dlg:row_row'] = 'Ενημέρωση της τρέχουσας γραμμής';
$string['table_dlg:row_title'] = 'Ιδιότητες γραμμής πίνακα';
$string['table_dlg:rowgroup'] = 'Ομάδα γραμμών';
$string['table_dlg:rows'] = 'Γραμμές';
$string['table_dlg:rowtype'] = 'Τύπος γραμμής';
$string['table_dlg:rtl'] = 'Δεξιά προς αριστερά';
$string['table_dlg:rules'] = 'Κανόνες';
$string['table_dlg:rules_above'] = 'από πάνω';
$string['table_dlg:rules_below'] = 'από κάτω';
$string['table_dlg:rules_border'] = 'περίγραμμα';
$string['table_dlg:rules_box'] = 'κουτί';
$string['table_dlg:rules_hsides'] = 'οριζόντιες πλευρές';
$string['table_dlg:rules_lhs'] = 'αριστερή οριζόντια πλευρά';
$string['table_dlg:rules_rhs'] = 'δεξιά οριζόντια πλευρά';
$string['table_dlg:rules_void'] = 'κενό';
$string['table_dlg:rules_vsides'] = 'κάθετες πλευρές';
$string['table_dlg:scope'] = 'Εμβέλεια';
$string['table_dlg:style'] = 'Στυλ';
$string['table_dlg:summary'] = 'Περίληψη';
$string['table_dlg:tbody'] = 'Σώμα';
$string['table_dlg:td'] = 'Δεδομένα';
$string['table_dlg:tfoot'] = 'Υποσέλιδο';
$string['table_dlg:th'] = 'Επικεφαλίδα';
$string['table_dlg:thead'] = 'Κορυφή';
$string['table_dlg:title'] = 'Εισαγωγή/επεξεργασία πίνακα';
$string['table_dlg:valign'] = 'Κατακόρυφη στοίχιση';
$string['table_dlg:width'] = 'Πλάτος';
$string['template:desc'] = 'Εισαγωγή περιεχομένου για προκαθορισμένο υπόδειγμα';
$string['template_dlg:cdate_format'] = '%Y-%m-%d %H:%M:%S';
$string['template_dlg:day_long'] = 'Κυριακή,Δευτέρα,Τρίτη,Τετάρτη,Πέμπτη,Παρασκευή,Σάββατο,Κυριακή';
$string['template_dlg:day_short'] = 'Κυρ,Δευ,Τρί,Τετ,Πέμ,Παρ,Σαβ,Κυρ';
$string['template_dlg:desc'] = 'Εισαγωγή περιεχομένου για προκαθορισμένο υπόδειγμα';
$string['template_dlg:desc_label'] = 'Περιγραφή';
$string['template_dlg:label'] = 'Υπόδειγμα';
$string['template_dlg:mdate_format'] = '%Y-%m-%d %H:%M:%S';
$string['template_dlg:months_long'] = 'Ιανουάριος,Φεβρουάριος,Μάρτιος,Απρίλιος,Μάιος,Ιούνιος,Ιούλιος,Αύγουστος,Σεπτέμβριος,Οκτώβριος,Νοέμβριος,Δεκέμβριος';
$string['template_dlg:months_short'] = 'Ιαν,Φεβ,Μάρ,Απρ,Μάι,Ιύν,Ιύλ,Αύγ,Σεπ,Οκτ,Νοέ,Δεκ';
$string['template_dlg:preview'] = 'Προεπισκόπηση';
$string['template_dlg:select'] = 'Επιλογή ενός υποδείγματος';
$string['template_dlg:title'] = 'Υποδείγματα';
$string['template_dlg:warning'] = 'Προσοχή : Η ενημέρωση ενός υποδείγματος με ένα άλλο, μπορεί να προκαλέσει απώλεια δεδομένων.';
$string['visualblocks:desc'] = 'Εμφάνιση/απόκρυψη στοιχείων μπλοκ';
$string['visualchars:desc'] = 'Εμφάνιση/απόκρυψη οπτικών χαρακτήρων ελέγχου.';
$string['wordcount:words'] = 'Λέξεις:';
$string['xhtmlxtras:abbr_delta_height'] = '';
$string['xhtmlxtras:abbr_delta_width'] = '';
$string['xhtmlxtras:abbr_desc'] = 'Συντομογραφία';
$string['xhtmlxtras:acronym_delta_height'] = '';
$string['xhtmlxtras:acronym_delta_width'] = '';
$string['xhtmlxtras:acronym_desc'] = 'Ακρωνύμιο';
$string['xhtmlxtras:attribs_delta_height'] = '';
$string['xhtmlxtras:attribs_delta_width'] = '';
$string['xhtmlxtras:attribs_desc'] = 'Εισαγωγή/επεξεργασία χαρακτηριστικών';
$string['xhtmlxtras:cite_delta_height'] = '';
$string['xhtmlxtras:cite_delta_width'] = '';
$string['xhtmlxtras:cite_desc'] = 'Παραπομπή';
$string['xhtmlxtras:del_delta_height'] = '';
$string['xhtmlxtras:del_delta_width'] = '';
$string['xhtmlxtras:del_desc'] = 'Διαγραφή';
$string['xhtmlxtras:ins_delta_height'] = '';
$string['xhtmlxtras:ins_delta_width'] = '';
$string['xhtmlxtras:ins_desc'] = 'Εισαγωγή';
$string['xhtmlxtras_dlg:attrib_tab'] = 'Ιδιότητες';
$string['xhtmlxtras_dlg:attribs_title'] = 'Εισαγωγή/επεξεργασία χαρακτηριστικών';
$string['xhtmlxtras_dlg:attribute_attrib_tab'] = 'Ιδιότητες';
$string['xhtmlxtras_dlg:attribute_events_tab'] = 'Γεγονότα';
$string['xhtmlxtras_dlg:attribute_label_accesskey'] = 'Πλήκτρο πρόσβασης';
$string['xhtmlxtras_dlg:attribute_label_cite'] = 'Παραπομπή/Παράθεση';
$string['xhtmlxtras_dlg:attribute_label_class'] = 'Κλάση';
$string['xhtmlxtras_dlg:attribute_label_datetime'] = 'Ημερομηνία/ώρα';
$string['xhtmlxtras_dlg:attribute_label_id'] = 'Αναγνωριστικό';
$string['xhtmlxtras_dlg:attribute_label_langcode'] = 'Γλώσσα';
$string['xhtmlxtras_dlg:attribute_label_langdir'] = 'Κατεύθυνση κειμένου';
$string['xhtmlxtras_dlg:attribute_label_style'] = 'Στυλ';
$string['xhtmlxtras_dlg:attribute_label_tabindex'] = 'Αρίθμηση στοιχείου (Tabindex)';
$string['xhtmlxtras_dlg:attribute_label_title'] = 'Τίτλος';
$string['xhtmlxtras_dlg:attribute_option_ltr'] = 'Αριστερά προς δεξιά';
$string['xhtmlxtras_dlg:attribute_option_rtl'] = 'Δεξιά προς αριστερά';
$string['xhtmlxtras_dlg:events_tab'] = 'Γεγονότα';
$string['xhtmlxtras_dlg:fieldset_attrib_tab'] = 'Ιδιοχαρακτηριστικά στοιχείου';
$string['xhtmlxtras_dlg:fieldset_events_tab'] = 'Γεγονότα στοιχείου';
$string['xhtmlxtras_dlg:fieldset_general_tab'] = 'Γενικές ρυθμίσεις';
$string['xhtmlxtras_dlg:general_tab'] = 'Γενικά';
$string['xhtmlxtras_dlg:insert_date'] = 'Εισαγωγή τρέχουσας ημέρας/ώρας';
$string['xhtmlxtras_dlg:option_ltr'] = 'Αριστερά προς δεξιά';
$string['xhtmlxtras_dlg:option_rtl'] = 'Δεξιά προς αριστερά';
$string['xhtmlxtras_dlg:remove'] = 'Αφαίρεση';
$string['xhtmlxtras_dlg:title_abbr_element'] = 'Στοιχείο συντομογραφίας';
$string['xhtmlxtras_dlg:title_acronym_element'] = 'Στοιχείο ακρωνυμίου';
$string['xhtmlxtras_dlg:title_cite_element'] = 'Στοιχείο παράθεσης';
$string['xhtmlxtras_dlg:title_del_element'] = 'Στοιχείο διαγραφής';
$string['xhtmlxtras_dlg:title_ins_element'] = 'Στοιχείο εισαγωγής';
