<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'moodle', language 'sr_lt', version '5.0'.
 *
 * @package     moodle
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['abouttobeinstalled'] = 'će upravo biti instalirano';
$string['accept'] = 'Prihvati';
$string['action'] = 'Akcija';
$string['actionchoice'] = 'Šta želite da uradite sa datotekom \'{$a}\'?

&strings=1';
$string['actions'] = 'Akcije';
$string['actionsfor'] = 'Akcija za {$a}';
$string['actionsmenu'] = 'Meni akcija';
$string['active'] = 'Aktivan';
$string['activeusers'] = 'Aktivni korisnici';
$string['activities'] = 'Aktivnosti';
$string['activities_help'] = 'Aktivnosti, kao što su forumi, testovi i viki dokumenti omogućavaju da kursu bude dodat interaktivni sadržaj.';
$string['activity'] = 'Aktivnost';
$string['activityclipboard'] = 'Premeštanje ove aktivnosti: {$a}';
$string['activityheader'] = 'Meni aktivnosti';
$string['activityicon'] = 'Ikonica aktivnosti {$a}';
$string['activityiscurrentlyhidden'] = 'Nažalost, ova aktivnost trenutno nije dostupna';
$string['activitymodule'] = 'Modul aktivnosti';
$string['activitymodules'] = 'Moduli aktivnosti';
$string['activitynotready'] = 'Aktivnost još nije spremna';
$string['activityorresource'] = 'Aktivnost ili resurs';
$string['activityreport'] = 'Izveštaj o aktivnosti';
$string['activityreports'] = 'Izveštaji o aktivnostima';
$string['activityselect'] = 'Izaberite ovu aktivnost kako biste je premestili na drugu mesto';
$string['activitysince'] = 'Aktivnost od {$a}';
$string['activitytypetitle'] = '{$a->activity} - {$a->type}';
$string['activityweighted'] = 'Aktivnost po korisniku';
$string['add'] = 'Dodaj';
$string['addactivity'] = 'Dodaj aktivnost...';
$string['addactivitytosection'] = 'Dodaj aktivnost u sekciju \'{$a}\'';
$string['addadmin'] = 'Dodaj administratora';
$string['addblock'] = 'Dodaj blok';
$string['addcomment'] = 'Dodaj komentar...';
$string['addcondition'] = 'Dodaj uslov';
$string['addcontent'] = 'Dodajte sadržaj';
$string['addcountertousername'] = 'Kreiraj korisnika dodavanjem broja korisničkom imenu';
$string['addcreator'] = 'Dodaj kreatora kursa';
$string['adddots'] = 'Dodaj...';
$string['added'] = 'Dodato {$a}';
$string['addedtogroup'] = 'Dodat(а) grupi {$a}';
$string['addedtogroupnot'] = 'Nije dodat(а) grupi {$a}';
$string['addedtogroupnotenrolled'] = 'Nije dodat(a) grupi "{$a}", jer nije upisan(a) na kurs';
$string['addfilehere'] = 'Spustite datoteke ovde da biste ih dodali na kraj ove sekcije';
$string['addfilesdrop'] = 'Ovde možete prevući i spustiti datoteke kako biste ih postavili ili kliknuti kako biste ih izabrali.';
$string['addinganew'] = 'Nova aktivnost: {$a}';
$string['addingdatatoexisting'] = 'Dodavanje podataka postojećim';
$string['additionalcustomnav'] = 'Dodatna prilagođena navigacija';
$string['additionalnames'] = 'Dodatna imena';
$string['addlinkhere'] = 'Dodaj link ovde';
$string['addnew'] = 'Dodaj nov {$a}';
$string['addnewcategory'] = 'Dodaj novu kategoriju';
$string['addnewcourse'] = 'Dodaj novi kurs';
$string['addnewuser'] = 'Dodaj novog korisnika';
$string['addnousersrecip'] = 'Dodavanje korisnika koji nije pristupio ovome {$a} na listu primalaca';
$string['addpagehere'] = 'Dodaj tekst ovde';
$string['addresource'] = 'Dodaj resurs...';
$string['addresourceoractivity'] = 'Dodaj aktivnost ili resurs';
$string['addresourcetosection'] = 'Dodaj resurs u sekciju \'{$a}\'';
$string['address'] = 'Adresa';
$string['addsections'] = 'Dodaj sekcije';
$string['addstudent'] = 'Dodaj polaznika';
$string['addsubcategory'] = 'Dodaj potkategoriju';
$string['addteacher'] = 'Dodaj predavača';
$string['admin'] = 'Administracija';
$string['adminhelpaddnewuser'] = 'Ručno kreiranje novog korisničkog naloga';
$string['adminhelpassignadmins'] = 'Administratori imaju potpuna ovlašćenja na ovom sajtu';
$string['adminhelpassigncreators'] = 'Kreatori kurseva mogu da kreiraju nove kurseve';
$string['adminhelpassignsiteroles'] = 'Primeni definisane uloge na nivou sajta na određene korisnike';
$string['adminhelpassignstudents'] = 'Idite na kurs i dodajte nove polaznike iz administratorskog menija';
$string['adminhelpauthentication'] = 'Možete koristiti interne korisničke naloge ili eksterne baze podataka';
$string['adminhelpbackup'] = 'Konfigurišite automatsko kreiranje rezervnih kopija i vremenski raspored njihovog izvršavanja';
$string['adminhelpconfiguration'] = 'Konfigurišite kako sajt izgleda i funkcioniše';
$string['adminhelpconfigvariables'] = 'Konfigurišite promenljive koje utiču na opštu funkcionalnost sajta';
$string['adminhelpcourses'] = 'Odredite kurseve i kategorije i upišite polaznike u njih, uredite kurseve na čekanju';
$string['adminhelpeditorsettings'] = 'Definišite osnovna podešavanja HTML editora';
$string['adminhelpedituser'] = 'Pretražite listu korisničkih naloga i uredite bilo koji od njih';
$string['adminhelpenvironment'] = 'Proverite u kojoj meri vaš server ispunjava trenutne i buduće zahteve za uspešnu instalaciju';
$string['adminhelpfailurelogs'] = 'Pregledajte zapise o neuspešnim prijavama na sistem';
$string['adminhelplanguage'] = 'Provera i uređivanje važećeg jezičkog paketa';
$string['adminhelplogs'] = 'Pregledajte zapise o svim aktivnostima na sajtu';
$string['adminhelpmanageblocks'] = 'Upravljanje instaliranim blokovima i njihovim podešavanjima';
$string['adminhelpmanagedatabase'] = 'Direktno pristupite bazi podataka (ali oprezno!)';
$string['adminhelpmanagefilters'] = 'Izbor tekstualnih filtera i njihova podešavanja';
$string['adminhelpmanagemodules'] = 'Upravljanje instaliranim modulima i njihovim podešavanjima';
$string['adminhelpmanageroles'] = 'Kreiranje i definisanje uloga koje se mogu primeniti na korisnike';
$string['adminhelpmymoodle'] = 'Konfigurišite "Moj Moodle" blokove za korisnike';
$string['adminhelpreports'] = 'Izveštaji na nivou sajta';
$string['adminhelpsitefiles'] = 'Služi za objavljivanje opštih datoteka ili postavljanje rezervnih kopija';
$string['adminhelpsitesettings'] = 'Definišite kako izgleda naslovna stranica sajta';
$string['adminhelpstickyblocks'] = 'Konfigurišite fiksne blokove na čitavom sajtu';
$string['adminhelpthemes'] = 'Izaberite kako da izgleda sajt (boje, fontovi i sl.)';
$string['adminhelpuploadusers'] = 'Uvezite nove korisničke naloge iz tekstualne datoteke';
$string['adminhelpusers'] = 'Odredite svoje korisnike i podesite način provere identiteta';
$string['adminhelpxmldbeditor'] = 'Interfejs za uređivanje XMLDB datoteka. Samo za korisnike sa uređivačkim pravima.';
$string['administration'] = 'Administracija';
$string['administrationsite'] = 'Administracija sajta';
$string['administrator'] = 'Administrator';
$string['administratordescription'] = 'Administratori obično mogu da rade šta god žele u okviru sajta, na bilo kom kursu.';
$string['administrators'] = 'Administratori';
$string['administratorsall'] = 'Svi administratori';
$string['administratorsandteachers'] = 'Administratori i predavači';
$string['advanced'] = 'Napredno';
$string['advancedfilter'] = 'Napredno pretraživanje';
$string['advancedsettings'] = 'Napredna podešavanja';
$string['afterresource'] = 'Posle resursa "{$a}"';
$string['aftersection'] = 'Nakon sekcije "{$a}"';
$string['again'] = 'ponovo';
$string['agelocationverification'] = 'Provera starosti i mesta';
$string['ajaxuse'] = 'AJAX i Javascript';
$string['all'] = 'Sve';
$string['allactions'] = 'Sve akcije';
$string['allactivities'] = 'Sve aktivnosti';
$string['allcategories'] = 'Sve kategorije';
$string['allchanges'] = 'Sve promene';
$string['alldays'] = 'Svi dani';
$string['allfiles'] = 'Sve datoteke';
$string['allgroups'] = 'Sve grupe';
$string['alllogs'] = 'Svi zapisi o aktivnostima';
$string['allmods'] = 'Svi {$a}';
$string['allow'] = 'Dozvoliti';
$string['allowinternal'] = 'Dozvoliti i interne načine autorizacije';
$string['allownone'] = 'Ne dozvoliti ništa';
$string['allownot'] = 'Ne dozvoliti';
$string['allowstealthmodules'] = 'Dozvoli nevidljive aktivnosti';
$string['allowstealthmodules_help'] = 'Ako je omogućeno, aktivnosti mogu da budu dostupne ali ne i prikazane u vidljivim sekcijama na stranici kursa. U tom slučaju linkovi ka nevidljivim aktivnostima moraju se postaviti negde drugo unutar kursa (na primer, unutar resursa \'Stranica\'). Nevidljive aktivnosti će i dalje biti navedena u knjizi ocena i drugim izveštajima.';
$string['allparticipants'] = 'Svi učesnici';
$string['allteachers'] = 'Svi predavači';
$string['alphanumerical'] = 'Može jedino da sadrži alfanumeričke znakove (slova i brojeve), crticu (-) ili tačku (.)';
$string['alreadyconfirmed'] = 'Registracija je već potvrđena';
$string['alternatename'] = 'Alternativno ime';
$string['always'] = 'Uvek';
$string['and'] = '{$a->one} i {$a->two}';
$string['answer'] = 'Odgovor';
$string['any'] = 'Bilo koje';
$string['appearance'] = 'Izgled';
$string['apply'] = 'Primeni';
$string['applyfilters'] = 'Primeni filtere';
$string['approve'] = 'Odobri';
$string['areyousure'] = 'Da li ste sigurni?';
$string['areyousuretorestorethis'] = 'Želite li da nastavite?';
$string['areyousuretorestorethisinfo'] = 'Tokom ovog postupka moći ćete odabrati da li želite da dodate ovu datoteku sa rezervnim kopijama već postojećem kursu ili da kreirate potpuno novi kurs.';
$string['asc'] = 'Rastući';
$string['assessment'] = 'Procena';
$string['assignadmins'] = 'Određivanje administratora';
$string['assigncreators'] = 'Određivanje kreatora';
$string['assignedrolecount'] = '{$a->role}: {$a->count}';
$string['assignsiteroles'] = 'Određivanje uloga na nivou sajta';
$string['authenticateduser'] = 'Autorizovani korisnik';
$string['authenticateduserdescription'] = 'Svi trenutno prijavljeni korisnici';
$string['authentication'] = 'Provera identiteta';
$string['authenticationplugins'] = 'Dodaci za proveru identiteta';
$string['autosubscribe'] = 'Automatska prijava na forum';
$string['autosubscribeno'] = 'Ne: ne želim automatsku prijavu na diskusije foruma';
$string['autosubscribeyes'] = 'Da: kad pošaljem poruku, prijavi me na tu diskusiju foruma';
$string['availability'] = 'Dostupnost';
$string['availablecourses'] = 'Dostupni kursevi';
$string['back'] = 'Nazad';
$string['backto'] = 'Povratak na {$a}';
$string['backtocourselisting'] = 'Povratak na listu kurseva';
$string['backtohome'] = 'Povratak na naslovnu stranicu sajta';
$string['backtopageyouwereon'] = 'Povratak na stranicu na kojoj ste bili';
$string['backup'] = 'Kreiranje rezervne kopije';
$string['backupactivehelp'] = 'Izaberite da li treba ili ne treba automatski kreirati rezervne kopije.';
$string['backupadhocpending'] = 'Ad hok zadatak kreiranja rezervne kopije kursa na čekanju';
$string['backupcancelled'] = 'Kreiranje rezervne kopije je otkazano';
$string['backupcoursefileshelp'] = 'Ako je ovo podešavanje omogućeno,  datoteke kursa će biti uključene u automatski kreirane rezervne kopije';
$string['backupdate'] = 'Datum kreiranja rezervne kopije';
$string['backupdatenew'] = '&nbsp; {$a->TAG} sada je {$a->weekday}, {$a->mday} {$a->month} {$a->year}<br />';
$string['backupdateold'] = '{$a->TAG} bio je {$a->weekday}, {$a->mday} {$a->month} {$a->year}';
$string['backupdaterecordtype'] = '<br />{$a->recordtype} - {$a->recordname}<br />';
$string['backupdetails'] = 'Podaci o rezervnoj kopiji';
$string['backuperrorinvaliddestination'] = 'Odredišni direktorijum rezervne kopije ne postoji ili se u njega ne može upisivati.';
$string['backupexecuteathelp'] = 'Izaberite vreme za automatsko kreiranje rezervnih kopija.';
$string['backupfailed'] = 'Neki od vaših kurseva nisu sačuvani.';
$string['backupfilename'] = 'rezervna kopija';
$string['backupfinished'] = 'Kreiranje rezervne kopije je uspešno završeno';
$string['backupfromthissite'] = 'Da li je rezervna kopija kreirana na ovom sajtu?';
$string['backupgradebookhistoryhelp'] = 'Ako je ovo podešavanje omogućeno, onda će istorija knjige ocena biti uključena u automatsku rezervnu kopiju. Imajte u vidu, da istorija ocena ne sme biti onemogućena u podešavanjima servera (disablegradehistory) kako bi ovo moglo da funkcioniše.';
$string['backupincludemoduleshelp'] = 'Odaberite želite li u automatsku proceduru kreiranja rezervnih kopija da uključite i module kursa, sa ili bez korisničkih podataka';
$string['backupincludemoduleuserdatahelp'] = 'Izaberite da li želite da uključite podatke korisnika modula u automatski kreirane rezervne kopije.';
$string['backupinfo'] = 'Kreirajte kopiju ovog kursa, uključujući sav sadržaj i aktivnosti. Možete da upotrebite datoteku rezervne kopije kako biste restaurirali kurs.';
$string['backuplogdetailed'] = 'Detaljni izveštaj o izvršavanju';
$string['backuploglaststatus'] = 'Izveštaj o poslednjem izvršavanju';
$string['backupmissinguserinfoperms'] = 'Napomena: ova rezervna kopija podataka ne sadrži korisničke podatke. Aktivnosti kao što su Vežba i Radionica neće biti uključene u rezervnu kopiju, s obzirom da ovi moduli nisu kompatibilni sa ovim tipom rezervne kopije podataka.';
$string['backupnext'] = 'Sledeća rezervna kopija';
$string['backupnonisowarning'] = 'Upozorenje: ova rezervna kopija je kreirana u verziji Moodle sistema koja nije podržavala Unicode (pre verzije 1.6). Ako ova rezervna kopija sadrži tekstove koji se ne slažu sa ISO-8859-1 može biti OŠTEĆENA ako pokušate da je restaurirate u ovoj Unicode Moodle verziji. Pogledajte <a href="https://docs.moodle.org/en/Backup_FAQ">Backup FAQ</a>za više informacija o tome kako da pravilno uradite oporavak ove rezervne kopije.';
$string['backupnotyetrun'] = 'Automatska rezervna kopije na čekanju';
$string['backuporiginalname'] = 'Naziv rezervne kopije';
$string['backuproleassignments'] = 'Napravi rezervnu kopiju dodele ovih uloga';
$string['backupsavetohelp'] = 'Puna putanja do direktorijuma u kojem želite da sačuvate datoteke sa rezervnim kopijama';
$string['backupsitefileshelp'] = 'Ako je ovo podešavanje omogućeno, onda će datoteke sajta korišćene u kursevima biti uključeni u automatsku rezervnu kopiju.';
$string['backuptakealook'] = 'Molimo pogledajte zapise o kreiranju vaših rezervnih kopija u: {$a}';
$string['backupuserfileshelp'] = 'Odaberite da li bi trebalo da se korisničke datoteke (npr. slike za lične profile korisnika) uključe u automatski kreirane rezervne kopije';
$string['backupversion'] = 'Verzija rezervne kopije';
$string['badges'] = 'Bedževi';
$string['between'] = 'Između';
$string['block'] = 'Blok';
$string['blockconfiga'] = 'Konfigurisanje bloka {$a}';
$string['blockconfigbad'] = 'Ovaj blok nije pravilno implementiran i zato ne možete koristiti konfiguracioni interfejs';
$string['blocks'] = 'Blokovi';
$string['blocks_main'] = 'Gladni blokovi';
$string['blocks_supplementary'] = 'Dodatni blokovi';
$string['blocksaddedit'] = 'Dodaj/Uredi blokove';
$string['blockseditoff'] = 'Isključi uređivanje blokova';
$string['blocksediton'] = 'Uključi uređivanje blokova';
$string['blocksetup'] = 'Podešavanje tabela blokova';
$string['blocksuccess'] = '{$a} tabela je ispravno podešena';
$string['brief'] = 'Ukratko';
$string['bulkactions'] = 'Grupne akcije';
$string['bulkactionselect'] = 'Izbor masovne akcije {$a}';
$string['bulkcancel'] = 'Zatvorite grupno uređivanje';
$string['bulkmovecoursessuccess'] = 'Uspešno je premešteno {$a->courses} kurs(ev)a u {$a->category}';
$string['bulkselection'] = 'Izabrano: {$a}';
$string['bycourseorder'] = 'Poredak po kursevima';
$string['byname'] = 'od {$a}';
$string['bypassed'] = 'Izbegnuto';
$string['cachecontrols'] = 'Kontrola keširanja';
$string['calltofeedback'] = 'Kreatori ovog softvera bi voleli da dobiju povratne informacije od vas.';
$string['calltofeedback_give'] = 'Pošaljite povratne informacije o ovom softveru';
$string['calltofeedback_remind'] = 'Podseti me kasnije';
$string['cancel'] = 'Otkaži';
$string['cancelled'] = 'Otkazano';
$string['categories'] = 'Kategorije kurseva';
$string['categoriesandcourses'] = 'Kategorije kurseva i kursevi';
$string['category'] = 'Kategorija';
$string['categoryadded'] = 'Dodata je kategorija \'{$a}\'';
$string['categorybulkaction'] = 'Grupne akcije za izabrane kategorije';
$string['categorycontents'] = 'Potkategorije i kursevi';
$string['categorycurrentcontents'] = 'Sadržaji kategorije {$a}';
$string['categorydeleted'] = 'Obrisana je kategorija \'{$a}\'';
$string['categoryduplicate'] = 'Kategorija pod nazivom \'{$a}\' već postoji';
$string['categoryheader'] = 'Meni kategorije';
$string['categoryhidden'] = '(sakrivena)';
$string['categorymodifiedcancel'] = 'Kategorija je izmenjena! Molimo Vas da izađete i pokušate ponovo.';
$string['categoryname'] = 'Naziv kategorije';
$string['categorypath'] = 'Putanja kategorije';
$string['categorysubcategoryof'] = '{$a->category} - potkategorija kategorije {$a->parentcategory}';
$string['categoryupdated'] = 'Kategorija \'{$a}\' je ažurirana';
$string['changedpassword'] = 'Lozinka je promenjena';
$string['changepassword'] = 'Promeni lozinku';
$string['changesmade'] = 'Promene su napravljene';
$string['changesmadereallygoaway'] = 'Napravili ste promene. Da li ste sigurni da želite da odete odavde  i izgubiti svoje promene?';
$string['changessaved'] = 'Promene su sačuvane';
$string['check'] = 'Proveri';
$string['checkactual'] = 'Stvarno';
$string['checkall'] = 'Proveri sve';
$string['checkerror'] = 'Greška pri dobijanju rezultata provere \'{$a}\'. Proverite konzolu veb čitača za više informacija.';
$string['checkexpected'] = 'Očekivano';
$string['checkingbackup'] = 'Provera rezervne kopije';
$string['checkingcourse'] = 'Provera kursa';
$string['checkingforbbexport'] = 'Provera BlackBoard izvoza podataka';
$string['checkinginstances'] = 'Provera instanci';
$string['checkingsections'] = 'Provera sekcija';
$string['checklanguage'] = 'Provera jezika';
$string['checkloading'] = 'Preuzimanje rezultata provere \'{$a}\'';
$string['checknone'] = 'Bez provera';
$string['checks'] = 'Provere';
$string['checksok'] = 'Sve provere: \'{$a}\' su OK';
$string['childcoursenotfound'] = 'Podređeni kurs nije pronađen!';
$string['childcourses'] = 'Podređeni kursevi';
$string['choose'] = 'Izaberi';
$string['choosecourse'] = 'Izbor kursa';
$string['choosedots'] = 'Izaberi...';
$string['chooselivelogs'] = 'Ili nadgledajte trenutnu aktivnost';
$string['chooselogs'] = 'Izbor zapisa o aktivnostima koji želite da vidite';
$string['choosereportfilter'] = 'Izbor filtera za izveštaj';
$string['choosetheme'] = 'Izaberite grafičku temu';
$string['chooseuser'] = 'Izbor korisnika';
$string['city'] = 'Mesto';
$string['cleaningtempdata'] = 'Brisanje privremenih podataka';
$string['clear'] = 'Obriši';
$string['clearall'] = 'Obrišite sve';
$string['clearfilterrow'] = 'Ukloni red filtera';
$string['clearfilters'] = 'Ukloni filtere';
$string['clearsearch'] = 'Обриши поље за претрагу';
$string['clickhelpiconformoreinfo'] = '... nastavlja se... Kliknite na ikonicu za pomoć kako biste pročitali ceo članak';
$string['clickhere'] = 'Klikni ovde ...';
$string['clicktohideshow'] = 'Kliknite da biste raširili ili skupili';
$string['closeblockdrawer'] = 'Zatvori fioku sa blokovima';
$string['closebuttontitle'] = 'Zatvori';
$string['closecourseindex'] = 'Zatvori fioku sa indeksom kursa';
$string['closedrawer'] = 'Zatvori fioku';
$string['closewindow'] = 'Zatvori ovaj prozor';
$string['collapse'] = 'Skupi';
$string['collapseall'] = 'Skupi sve';
$string['collapsecategory'] = 'Skupi {$a}';
$string['comebacklater'] = 'Molim vas, vratite se kasnije.';
$string['commentincontext'] = 'Pronađi ovaj komentar u kontekstu';
$string['comments'] = 'Komentari';
$string['commentscount'] = 'Komentari ({$a})';
$string['commentsnotenabled'] = 'Komentarisanje nije omogućeno';
$string['commentsrequirelogin'] = 'Potrebno je da se prijavite na sistem da biste videli komentare.';
$string['comparelanguage'] = 'Uporedite i uredite trenutno odabrani jezik';
$string['complete'] = 'Potpuno';
$string['completed'] = 'Završeno';
$string['completereport'] = 'Potpuni izveštaj';
$string['configuration'] = 'Konfiguracija';
$string['confirm'] = 'Potvrdi';
$string['confirmaccount'] = 'Potvrdite nalog';
$string['confirmcheckfull'] = 'Da li ste apsolutni sigurni da želite da potvrdite {$a}?';
$string['confirmcoursemove'] = 'Da li ste sigurni da želite da premestite kurs ({$a->course}) u ovu kategoriju ({$a->category})?';
$string['confirmdeletesection'] = 'Da li ste apsolutno sigurni da želite da obrišete u potpunosti "{$a}" i sve aktivnosti koje sadrži?';
$string['confirmed'] = 'Vaša registracija je potvrđena';
$string['confirmednot'] = 'Vaša registracija još nije potvrđena. Proverite da li je e-poruka za potvrdu stigla u vaše poštansko sanduče.';
$string['considereddigitalminor'] = 'Previše ste mladi da biste mogli da kreirate nalog na ovom sajtu.';
$string['contactsbyrolelist'] = '{$a->role}: {$a->contacts}';
$string['content'] = 'Sadržaj';
$string['contentbank'] = 'Banka sadržaja';
$string['contentexport_aboutthiscourse'] = 'Rezime kursa';
$string['contentexport_coursesummary'] = 'Ova datoteka je deo sadržaja preuzetog sa <a href="{$a->courselink}">{$a->coursename}</a>.';
$string['contentexport_footersummary'] = 'Ova datoteka je deo sadržaja preuzetog sa <a href="{$a->courselink}">{$a->coursename}</a> by {$a->userfullname} dana {$a->date}.';
$string['contentexport_modulesummary'] = 'Ova stranica je deo sadržaja preuzetog sa <a href="{$a->modulelink}">{$a->modulename}</a> on {$a->date}. Imajte na umu da sadržaj i datoteke koji su veći od {$a->maxfilesize} neće biti preuzeti.';
$string['contentexport_viewfilename'] = 'Pogledajte datoteku {$a}';
$string['context'] = 'Kontekst';
$string['contextlevel'] = 'Nivo konteksta';
$string['contextname'] = 'Naziv konteksta';
$string['contextparent'] = 'Nadređeni';
$string['contexturl'] = 'URL adresa konteksta';
$string['continue'] = 'Nastavi';
$string['continuetocourse'] = 'Kliknite ovde da biste ušli na svoj kurs';
$string['convertingwikitomarkdown'] = 'Pretvaranje wiki formata u Markdown format';
$string['cookiesenabled'] = 'Vaš veb čitač mora imati omogućene kolačiće';
$string['cookiesenabled_help'] = 'Na ovom sajtu se koriste dva kolačića (<i>cookies</i>):

Od suštinskog značaje je kolačić sesije (<i>session cookie</i>), koji se obično zove MoodleSession. Morate da dozvolite upotrebu ovog kolačića u vašem veb čitaču kako biste obezbedili kontinuitet sesije i kako biste sve vreme ostali prijavljeni na sistem dok ste na sajtu. Kada se odjavite sa sistema ili zatvorite veb čitač, ovaj kolačić se uništava (kako u vašem čitaču tako i na serveru).

Drugi kolačić je čisto praktičnog karaktera i obično se naziva MOODLEID. On samo pamti vaše korisničko ime unutar veb čitača. To znači, da će, kada se budete vratili na ovaj sajt, polje za korisničko ime na stranicu za prijavu, automatski biti popunjeno vašim korisničkim imenom. Iz razloga bezbednosti (naročito kada internetu pristupate sa javnog računara) bolje je da odbijete ovaj kolačić - u tom slučaju moraćete da unesete svoje korisničko ime svaki put kada se budete prijavljivali na sistem.';
$string['cookiesenabled_help_html'] = 'Na ovom sajtu se koriste dva kolačića:<br/><br/>

Suštinski je kolačić sesije, koji se obično naziva MoodleSession. Morate dozvoliti ovaj kolačić u vašem veb čitaču  kako bi se obezbedio kontinuitet i kako biste ostali sve prijavljeni dok ste na sajtu. Kada se odjavite ili zatvorite veb čitač, ovaj kolačić se uništava (kako u vašem čitaču tako i na serveru).<br/><br/>

Drugi kolačić postoji samo radi pogodnosti, i obično se naziva MOODLEID ili slično. On samo pamti vaše korisničko ime u veb čitaču. To znači da je polje korisničkog imena na stranici za prijavu već popunjeno za vas, kada se vratite na ovaj sajt. Bezbedno je odbiti ovaj kolačić - samo ćete morati ponovo da unesete svoje korisničko ime, svaki put kada se prijavljujete.';
$string['cookiesenabledonlysession'] = 'Kolačići moraju biti omogućeni u vašem veb čitaču';
$string['cookiesenabledonlysession_help'] = 'Ovaj sajt koristi jedan kolačić sesije, koji se obično zove MoodleSession. Morate da dozvolite upotrebu ovog kolačića u vašem veb čitaču kako biste obezbedili kontinuitet sesije i kako biste ostali sve vreme ostali prijavljeni na sistem dok ste na sajtu. Kada se odjavite sa sistema ili zatvorite veb čitač, ovaj kolačić se uništava (kako u vašem čitaču tako i na serveru).';
$string['cookiesnotenabled'] = 'Nažalost, kolačići trenutno nisu omogućeni u vašem veb čitaču';
$string['cookiesnotice'] = 'Obaveštenje o kolačićima';
$string['copy'] = 'kopiranje';
$string['copyasnoun'] = 'kopiranje';
$string['copycourse'] = 'Kopiranje kursa';
$string['copyingcoursefiles'] = 'Kopiranje datoteka kursa';
$string['copyingsitefiles'] = 'Kopiranje fajlova sa sajta koji su korišćeni u kursu';
$string['copyinguserfiles'] = 'Kopiranje korisničkih datoteka';
$string['copyingzipfile'] = 'Kopiranje zip datoteka';
$string['copyrightnotice'] = 'Napomena o zaštiti autorskih prava';
$string['copytoclipboard'] = 'Kopiraj u klipbord';
$string['coresystem'] = 'Sistem';
$string['cost'] = 'Cena';
$string['costdefault'] = 'Podrazumevana cena';
$string['count_of_total'] = '<strong>{$a->count}</strong> of {$a->total}';
$string['counteditems'] = '{$a->count} {$a->items}';
$string['country'] = 'Država';
$string['course'] = 'Kurs';
$string['courseadministration'] = 'Administracija kursa';
$string['courseapprovedemail'] = 'Kurs koji ste tražili je odobren, <a href="{$a->url}">{$a->name}</a>, i dodeljena vam je uloga: {$a->teacher}.';
$string['courseapprovedemail2'] = 'Kurs koji ste tražili je odobren: <a href="{$a->url}">{$a->name}</a>.';
$string['courseapprovedfailed'] = 'Nije uspelo čuvanje kursa onako kako je odobreno!';
$string['courseapprovedsubject'] = 'Vaš kurs je odobren.';
$string['courseavailable'] = 'Ovaj kurs je dostupan polaznicima';
$string['courseavailablenot'] = 'Ovaj kurs nije dostupan polaznicima';
$string['coursebackup'] = 'Rezervna kopija kursa';
$string['coursebulkaction'] = 'Grupne akcije za izabrane kurseve';
$string['coursecategories'] = 'Kategorije kurseva';
$string['coursecategory'] = 'Kategorija kursa';
$string['coursecategory_help'] = 'Ovo podešavanje određuje kategoriju u kojoj će se kurs pojaviti na spisku kurseva.';
$string['coursecategorydeleted'] = 'Obrisana kategorija {$a}';
$string['coursecatmanagement'] = 'Upravljanje kursevima i kategorijama';
$string['coursecompletion'] = 'Završetak kursa';
$string['coursecompletions'] = 'Završetak kurseva';
$string['coursecreators'] = 'Kreator kursa';
$string['coursecreatorsdescription'] = 'Kreatori kurseva mogu da kreiraju nove kurseve';
$string['coursedeleted'] = 'Obrisan kurs {$a}';
$string['coursedetails'] = 'Podaci o kursevima';
$string['coursedisplay'] = 'Prelom stranice kursa';
$string['coursedisplay_help'] = 'Sekcije kursa mogu biti prikazane sve na jednoj stranici ili podeljene na nekoliko stranica.';
$string['coursedisplay_multi'] = 'Prikaži jednu sekciju po stranici';
$string['coursedisplay_single'] = 'Prikaži sve sekcije na jednoj stranici';
$string['courseduration'] = 'Trajanje kursa';
$string['courseduration_desc'] = 'Trajanje kursa se koristi za izračunavanje podrazumevanog datuma završetka kursa. Datum završetka kursa se koristi kako bi se odredilo da li kurs treba da bude uključen u spisak kurseva korisnika. Takođe, datum završetka mogu da koriste prilagođeni izveštaji. Korisnici i dalje mogu da uđu na kurs nakon datuma njegovog završetka.';
$string['courseenddateenabled'] = 'Datum završetka kursa standardno omogućen';
$string['courseenddateenabled_desc'] = 'Ovo podešavanja određuje da li će datum završetka kursa biti standardno omogućen za nove kurseve i podešen na datum izračunat na osnovu dužine trajanja kursa.';
$string['courseextendednamedisplay'] = '{$a->shortname} {$a->fullname}';
$string['coursefiles'] = 'Nasleđene datoteke kursa';
$string['coursefilesedit'] = 'Uredi nasleđene datoteke kursa';
$string['coursefileswarning'] = 'Datoteke kursa su zastarele';
$string['coursefileswarning_help'] = 'Opcija \'Datoteke kursa\' se ne koristi od verzije Moodle 2.0, Molimo da umesto toga koristite spoljašnje repozitorijume što je više moguće.';
$string['courseformatdata'] = 'Podaci o formatu kursa';
$string['courseformatoptions'] = 'Opcije za formatiranje - {$a}';
$string['courseformats'] = 'Formati kursa';
$string['courseformatudpate'] = 'Ažuriraj format';
$string['coursegrades'] = 'Ocene na kursu';
$string['courseheader'] = 'Meni kursa';
$string['coursehelpcategory'] = 'Postavite kurs na listi kurseva tako da polaznici mogu lakše da ga pronađu.';
$string['coursehelpforce'] = 'Obavezan grupni mod za sve aktivnosti na kursu';
$string['coursehelpformat'] = 'Glavna stranica kursa biće prikazana u ovom formatu.';
$string['coursehelphiddensections'] = 'Kako će skrivene sekcije kursa biti prikazane polaznicima';
$string['coursehelpmaximumupload'] = 'Odredite maksimalnu veličinu datoteke koja se može postaviti u okviru kursa. Ova veličina je ograničena podešavanjem na nivou sajta.';
$string['coursehelpnewsitemsnumber'] = 'Broj najnovijih obaveštenja koji će se pojaviti na početnoj stranici kursa, u bloku "Najnovija obaveštenja". Ako je podešeno na  0, forum sa obaveštenjima neće biti kreiran.';
$string['coursehelpnumberweeks'] = 'Broj sekcija unutar kursa (važi samo za određene formate kursa).';
$string['coursehelpshowgrades'] = 'Omogući prikaz knjige sa ocenama. Ovo ne sprečava da ocene budu prikazane unutar pojedinačnih aktivnosti.';
$string['coursehidden'] = 'Ovaj kurs trenutno nije dostupan polaznicima';
$string['courseinfo'] = 'Informacije o kursu';
$string['courselegacyfiles'] = 'Nasleđene datoteke kursa';
$string['courselegacyfiles_help'] = 'Područje datoteka kursa obezbeđuje izvesnu kompatibilnost sa Moodle 1.9 i starijim verzijama. Sve datoteke u ovom području uvek su dostupne svim učesnicima kursa (nezavisno od toga da li su povezani sa kursom ili ne) i ne postoji način da se sazna gde je bilo koja od ovih datoteka korišćena u Moodleu.

Ako ovo područje koristite da bi ste u njemu čuvali datoteke kursa, možete sebe da izložite brojnim problemima koji se tiču privatnosti i bezbdnosti sistema. Isto tako može doći do gubitka datoteka pri kreiranju rezervnih kopija, uvozu podataka iz jednog u drugi kurs, kao i svaki put kada sadržaj delite ili ponovo koristite. Zbog toga preporučujemo da ne koristite ovo područje, osim ako niste sasvim sigurni da znate šta radite.';
$string['courselegacyfiles_link'] = 'coursefiles2';
$string['courselegacyfilesofcourse'] = 'Nasleđene datoteke kursa: {$a}';
$string['coursenotaccessible'] = 'Kurs ne dozvoljava javni pristup';
$string['courseoverview'] = 'Pregled kurseva';
$string['courseoverviewfiles'] = 'Slika kursa';
$string['courseoverviewfiles_help'] = 'Slika kursa prikazuju se prikazuje na stranici\'Moji kursevi\', kao i na spisku dostupnih kurseva na početnoj stranici. Administrator sajta može omogućiti dodavanje više od jedne datoteke kao i dodatne tipove datoteka. Ako koristite više datoteka one će biti prikazane na spisku dostupnih kurseva na početnoj stranici.';
$string['courseoverviewfilesext'] = 'Ekstenzije slike kursa';
$string['courseoverviewfileslimit'] = 'Ograničenje za sliku kursa';
$string['courseoverviewgraph'] = 'Grafikon pregleda kurseva';
$string['courseprofiles'] = 'Profili kurseva';
$string['coursereasonforrejecting'] = 'Vaši razlozi za odbijanje ovog zahteva';
$string['coursereasonforrejectingemail'] = 'Ovo će biti poslato e-poštom podnosiocu zahteva.';
$string['coursereject'] = 'Odbacite zahtev za pokretanje novog kursa';
$string['courserejected'] = 'Kurs je odbijen i podnosilac zahteva je obavešten o tome.';
$string['courserejectemail'] = 'Žao nam je, ali vaš zahtev za otvaranje kursa je odbijen. Evo obrazloženja takve odluke:

{$a}';
$string['courserejectreason'] = 'Navedite svoje razloge za odbijanje ovog kursa<br />(ovo će biti poslato e-poštom podnosiocu zahteva)';
$string['courserejectsubject'] = 'Vaš kurs je odbijen';
$string['coursereport'] = 'Izveštaj o kursu';
$string['coursereports'] = 'Izveštaji kursa';
$string['courserequest'] = 'Zahtev za pokretanje novog kursa';
$string['courserequestdetails'] = 'Detaljnije informacije o kursu čije pokretanje tražite';
$string['courserequestfailed'] = 'Iz nekog razloga nije moguće sačuvati vaš zahtev za pokretanje kursa';
$string['courserequestintro'] = 'Upotrebite ovaj obrazac kako biste zatražili da bude kreiran novi kurs za vas.<br />Pokušajte da popunite obrazac sa što više informacija, kako biste pomogli<br />administratorima da bolje razumeju vaše razloge zbog kojih želite ovaj kurs.';
$string['courserequestreason'] = 'Razlozi za pokretanje ovog kursa';
$string['courserequestroleerror'] = 'Uloga kreatora u konfiguraciji novih kurseva je neispravna. Pogledajte <a href="{$a}">pravila za korisnike</a>.';
$string['courserequestsuccess'] = 'Zahtev za pokretanje novog kursa je predat.';
$string['courserequestsupport'] = 'Dodatne informacije koje će pomoći administratoru da proceni ovaj zahtev';
$string['courserequestwarning'] = 'Korisnik koji zahteva ovaj kurs biće automatski upisan i biće mu dodeljena uloga {$a}.';
$string['courserestore'] = 'Restauriranje kursa';
$string['coursereuse'] = 'Ponovna upotreba kursa';
$string['coursereusenavigationmenu'] = 'Navigacioni meni za ponovnu upotrebu kursa';
$string['courses'] = 'Kursevi';
$string['coursesectionsummaries'] = 'Rezime sekcija kursa';
$string['coursesectiontitle'] = '{$a->sectionname}: {$a->sectiontitle} | {$a->course}';
$string['coursesectiontitlebulkediting'] = 'Grupno uređivanje {$a->sectionname}: {$a->sectiontitle} | {$a->course}';
$string['coursesectiontitleediting'] = 'Uređivanje {$a->sectionname}: {$a->sectiontitle} | {$a->course}';
$string['coursesettings'] = 'Podrazumevana podešavanja kursa';
$string['coursesmovedout'] = 'Kursevi premešteni iz {$a}';
$string['coursespending'] = 'Kursevi koji čekaju na odobrenje';
$string['coursestart'] = 'Početak kursa';
$string['coursesummary'] = 'Rezime kursa';
$string['coursesummary_help'] = 'Kratak opis vašeg kursa. Sadržaj koji ovde dodate može se pretraživati.';
$string['coursetitle'] = 'Kurs: {$a->course}';
$string['coursetitlebulkediting'] = 'Grupno uređivanje kursa: {$a->course}';
$string['coursetitleediting'] = 'Uređivanje kursa: {$a->course}';
$string['courseupdates'] = 'Ažuriranja kursa';
$string['coursevisibility'] = 'Vidljivost kursa';
$string['coursevisibility_help'] = '* Prikaži: kurs se pojavljuje na spisku kurseva i polaznici mu mogu pristupiti.
* Sakrij: pristup je ograničen na predavače i druge korisnike koji imaju sposobnost da vide skrivene kurseve.';
$string['create'] = 'Kreiraj';
$string['createaccount'] = 'Kreiraj moj novi nalog';
$string['createcategory'] = 'Kreiraj kategoriju';
$string['createfolder'] = 'Kreiranje direktorijuma u {$a}';
$string['createnew'] = 'Kreiraj novi';
$string['createnewcategory'] = 'Kreiraj novu kategoriju';
$string['createnewcourse'] = 'Kreiraj novi kurs';
$string['createnewsubcategory'] = 'Kreiraj novu potkategoriju';
$string['createsubcategoryof'] = 'Kreiraj novu potkategoriju za {$a}';
$string['createuser'] = 'Kreiraj korisnika';
$string['createziparchive'] = 'Kreiranje zip arhive';
$string['creatingblocks'] = 'Kreiranje blokova';
$string['creatingblocksroles'] = 'Kreiranje zadataka i prepisivanja uloga na nivou bloka';
$string['creatingblogsinfo'] = 'Kreiranje informacija o blogovima';
$string['creatingcategoriesandquestions'] = 'Kreiranje kategorija i pitanja';
$string['creatingcoursemodules'] = 'Kreiranje modula kursa';
$string['creatingcourseroles'] = 'Kreiranje zadataka i prepisivanja uloga na nivou kursa';
$string['creatingevents'] = 'Kreiranje događaja';
$string['creatinggradebook'] = 'Kreiranje knjige ocena';
$string['creatinggroupings'] = 'Kreiranje grupisanja';
$string['creatinggroupingsgroups'] = 'Dodavanje grupa u grupisanja';
$string['creatinggroups'] = 'Kreiranje grupa';
$string['creatinglogentries'] = 'Kreiranje stavki izveštaja o aktivnostima';
$string['creatingmessagesinfo'] = 'Kreiranje informacija o porukama';
$string['creatingmodroles'] = 'Kreiranje zadataka i prepisivanja uloga na nivou modula';
$string['creatingnewcourse'] = 'Kreiranje novog kursa';
$string['creatingrolesdefinitions'] = 'Kreiranje definicija uloga';
$string['creatingscales'] = 'Kreiranje skala za ocenjivanje';
$string['creatingsections'] = 'Kreiranje sekcija';
$string['creatingtemporarystructures'] = 'Kreiranje privremenih struktura';
$string['creatinguserroles'] = 'Kreiranje zadataka i prepisivanja uloga na nivou korisnika';
$string['creatingusers'] = 'Kreiranje korisnika';
$string['creatingxmlfile'] = 'Kreiranje XML datoteke';
$string['currency'] = 'Valuta';
$string['currentcourse'] = 'Tekući kurs';
$string['currentcourseadding'] = 'Tekući kurs, dodavanje podataka već postojećima';
$string['currentcoursedeleting'] = 'Tekući kurs, uz prethodno brisanje postojećih podataka';
$string['currentlanguage'] = 'Trenutno važeći jezik';
$string['currentlocaltime'] = 'Vaše trenutno lokalno vreme';
$string['currentpicture'] = 'Trenutna slika';
$string['currentrelease'] = 'Informacija o trenutnoj verziji programa';
$string['currenttheme'] = 'Aktuelna tema';
$string['currentversion'] = 'Trenutna verzija';
$string['databasechecking'] = 'Nadogradnja baze podataka sa verzije {$a->oldversion} na verziju {$a->newversion}';
$string['databaseperformance'] = 'Performanse baze podataka';
$string['databasesetup'] = 'Podešavanje baze podataka';
$string['databasesuccess'] = 'Baza podataka je uspešno nadograđena';
$string['databaseupgradebackups'] = 'Trenutna verzija rezervne kopije je {$a}';
$string['databaseupgradeblocks'] = 'Trenutna verzija blokova je {$a}';
$string['databaseupgradegroups'] = 'Verzija grupe sada je {$a}';
$string['databaseupgradelocal'] = 'Trenutna verzija prilagođavanja lokalne baze podataka je {$a}';
$string['databaseupgrades'] = 'Nadogradnja baze podataka';
$string['dataformats'] = 'Formati podataka';
$string['date'] = 'Datum';
$string['datechanged'] = 'Datum promene';
$string['datemostrecentfirst'] = 'Datum - prvo najnoviji';
$string['datemostrecentlast'] = 'Datum - prvo najstariji';
$string['datetimefilterafter'] = '{$a->title} posle';
$string['datetimefilterbefore'] = '{$a->title} pre';
$string['day'] = 'dan';
$string['days'] = 'dan/a';
$string['decodinginternallinks'] = 'Dekodiranje unutrašnjih linkova';
$string['default'] = 'Podrazumevano';
$string['defaultcategoryname'] = 'Kategorija 1';
$string['defaultcompetencescale'] = 'Osnovna skala kompetencija';
$string['defaultcompetencescaledesc'] = 'Binarna skala koja ukazuje samo da li je neko demonstrirao stručnost ili ne bez detaljnijih informacija.';
$string['defaultcompetencescalenotproficient'] = 'Još nije kompetentan';
$string['defaultcompetencescaleproficient'] = 'Kompetentan';
$string['defaultcoursestudent'] = 'Polaznik';
$string['defaultcoursestudentdescription'] = 'Polaznici u opštem slučaju imaju manje privilegije u okviru kursa.';
$string['defaultcoursestudents'] = 'Polaznici';
$string['defaultcoursesummary'] = 'Napišite kratak i zanimljiv rezime koji objašnjava koje teme pokriva Vaš kurs.';
$string['defaultcourseteacher'] = 'Predavač';
$string['defaultcourseteacherdescription'] = 'Predavači mogu da rade bilo šta u okviru kursa, uključujući promenu aktivnosti i ocenjivanje polaznika.';
$string['defaultcourseteachers'] = 'Predavači';
$string['defaulteditor'] = 'Podrazumevani editor';
$string['defaulthomepageuser'] = 'Početna stranica';
$string['defaulthomepageuser_help'] = 'Na koju stranicu treba da budete preusmereni nakon što se prijavite na sajt?';
$string['delete'] = 'Obriši';
$string['deleteablock'] = 'Obriši blok';
$string['deleteall'] = 'Obriši sve';
$string['deleteallcannotundo'] = 'Obriši sve - ova akcija je nepovratna';
$string['deleteallcomments'] = 'Svi komentari';
$string['deleteallratings'] = 'Sva ocenjivanja';
$string['deletecategory'] = 'Obriši kategoriju: {$a}';
$string['deletecategorycheck'] = 'Jeste li apsolutno sigurni da želite da obrišete kategoriju pod nazivom <b>\'{$a}\'</b>?<br /> Ovo će premestiti sve kurseve koji se nalaze u toj kategoriji u nadređenu kategoriju (ako ista postoji), ili u kategoriju Razno.';
$string['deletecategorycheck2'] = 'Ako obrišete ovu kategoriju, morate izabrati šta uraditi sa kursevima i potkategorijama koje ona sadrži.';
$string['deletecategoryempty'] = 'Ova kategorija je prazna';
$string['deletecheck'] = 'Obriši {$a} ?';
$string['deletecheckfiles'] = 'Jeste li u potpunosti sigurni da želite da obrišete ove datoteke?';
$string['deletecheckfull'] = 'Da li ste sigurni da želite potpuno da obrišete korisnika {$ a}, uključujući podatke kao što su detalji profila, upisi, članstvo u grupama i kohortama i neki podaci o aktivnosti korisnika?';
$string['deletechecktype'] = 'Da li ste sigurni da želite da obrišete ovaj {$a->type}?';
$string['deletechecktypename'] = 'Da li ste sigurni da želite da obrišete {$a->type} "{$a->name}"?';
$string['deletecheckwarning'] = 'Upravo ćete obrisati ove datoteke';
$string['deletecommentbyon'] = 'Obriši komentar koji je poslao/la {$a->user} u {$a->time}';
$string['deletecompletely'] = 'Kompletno brisanje';
$string['deletecourse'] = 'Obriši kurs';
$string['deletecoursecheck'] = 'Jeste li sigurni da želite potpuno da obrišete ovaj kurs i sve podatke koje on sadrži?';
$string['deleted'] = 'Obrisano';
$string['deletedactivity'] = 'Obrisano {$a}';
$string['deletedcourse'] = '{$a} je potpuno obrisan';
$string['deletednot'] = '{$a} se ne može obrisati.';
$string['deletepicture'] = 'Obriši';
$string['deletesection'] = 'Obriši';
$string['deleteselected'] = 'Obriši izabrano';
$string['deleteselectedkey'] = 'Obriši izabrani ključ';
$string['deletingcourse'] = 'Brisanje {$a}';
$string['deletingexistingcoursedata'] = 'Brisanje postojećih podataka kursa';
$string['deletingolddata'] = 'Brisanje starih podataka';
$string['department'] = 'Departman/Odsek';
$string['deprecatedeventname'] = '{$a} (nije više u upotrebi)';
$string['desc'] = 'Opadajuće';
$string['description'] = 'Opis';
$string['deselectall'] = 'Poništi izbor svega';
$string['deselectnos'] = 'Poništi odabir svih "Ne"';
$string['detailedless'] = 'Manje detaljno';
$string['detailedmore'] = 'Detaljnije';
$string['details'] = 'Detaljnije informacije';
$string['digitalminor'] = 'Digitalni maloletnik';
$string['digitalminor_desc'] = 'Zamolite svog roditelja/staratelja da kontaktira:';
$string['directory'] = 'Direktorijum';
$string['disable'] = 'Onemogući';
$string['disabledcomments'] = 'Komentarisanje je onemogućeno';
$string['dismissnotification'] = 'Odbaci ovo obaveštenje';
$string['displayingfirst'] = 'Prikazano je samo prvih(a) {$a->count} {$a->things}';
$string['displayingrecords'] = 'Prikaz {$a} zapisa';
$string['displayingusers'] = 'Prikaz korisnika od {$a->start} do {$a->end}';
$string['displayonpage'] = 'Prikaži na stranici';
$string['dndcourse'] = 'Možete da prevučete i spustiti ovaj kurs kako biste promenili njegovo sortiranje ili ga premestili u drugu kategoriju.';
$string['dndenabled_inbox'] = 'Prevucite i spustite datoteke ovde kako biste ih dodali';
$string['dndnotsupported'] = 'Nije podržano postavljanje prevlačenjem';
$string['dndnotsupported_help'] = 'Vaš čitač ne podržava postavljanje pomoću opcije \'prevuci i spusti\'.<br />Ova funkcionalnost je dostupna u svim novijim verzijama čitača Chrome, Firefox i Safari, kao i u čitaču Internet Explorer od verzije 10.';
$string['dndnotsupported_insentence'] = 'prevlačenje nije podržano';
$string['dnduploadwithoutcontent'] = 'Ovo postavljanje nema nikakav sadržaj';
$string['dndworkingfile'] = 'Prevucite i spustite datoteke na sekciju kursa kako biste ih postavili';
$string['dndworkingfilelink'] = 'Prevucite i spustite datoteke ili linkove na sekciju kursa kako biste ih postavili';
$string['dndworkingfiletext'] = 'Prevucite i spustite datoteke ili tekst na sekciju kursa kako biste ih postavili';
$string['dndworkingfiletextlink'] = 'Prevucite i spustite datoteke, tekst ili linkove na sekciju kursa kako biste ih postavili';
$string['dndworkinglink'] = 'Prevucite i spustite linkove na sekciju kursa kako biste ih postavili';
$string['dndworkingtext'] = 'Prevucite i spustite tekst na sekciju kursa kako biste ga postavili';
$string['dndworkingtextlink'] = 'Prevucite i spustite tekst ili linkove na sekciju kursa kako biste ih postavili';
$string['documentation'] = 'Moodle dokumentacija';
$string['dontsortcategories'] = 'Ne sortiraj kategorije';
$string['dontsortcourses'] = 'Ne sortiraj kurseve';
$string['down'] = 'Dole';
$string['download'] = 'Preuzmi';
$string['downloadall'] = 'Preuzmi sve';
$string['downloadexcel'] = 'Preuzmi u Excel formatu';
$string['downloadfile'] = 'Preuzmi datoteku';
$string['downloadods'] = 'Preuzmi u ODS formatu';
$string['downloadtext'] = 'Preuzmi u tekstualnom formatu';
$string['doyouagree'] = 'Jeste li pročitali navedene uslove i razumeli ih u potpunosti?';
$string['droptoupload'] = 'Spusti ovde datoteke za slanje';
$string['duplicate'] = 'Dupliraj';
$string['duplicatedmodule'] = '{$a} (kopija)';
$string['duplicatedsection'] = '{$a} (kopija)';
$string['edhelpaspellpath'] = 'Da biste koristili proveru pravopisa u editoru, MORATE imati <strong>aspell 0.50</strong> ili noviji instaliran na Vašem serveru, i morate specificirati tačnu putanju za pristup aspell binarnoj datoteci. Na Unix/Linux sistemima, ova putanja je obično <strong>/usr/bin/aspell</strong>, ali može biti i neka druga.';
$string['edhelpbgcolor'] = 'Odredite pozadinsku boju polja za uređivanje.<br />Primer vrednosti koje se mogu zadati su: #ffffff ili white';
$string['edhelpcleanword'] = 'Ovo podešavanje omogućava ili onemogućava filtriranje Word-specifičnog formata.';
$string['edhelpenablespelling'] = 'Uključite ili isključite proveru pravopisa (spell-checking). Ako je provera uključena, <strong>aspell</strong> mora biti instaliran na serveru. Druga vrednost je <strong>podrazumevani rečnik</strong>. Ova vrednost će biti korišćena ako aspell nema rečnik za jezik koji koristi korisnik.';
$string['edhelpfontfamily'] = 'Karakteristika familija fontova je lista naziva grupa fontova srodnih jezika i/ili generičkih naziva grupa srodnih fontova. Imena grupa srodnih jezika moraju biti odvojena zarezom.';
$string['edhelpfontlist'] = 'Odredite fontove koji će se koristiti u padajućem meniju.';
$string['edhelpfontsize'] = 'Podrazumevana veličina veličina fonta. <br />Primeri vrednosti koje se mogu zadati su: medium, large, smaller, larger, 10pt, 11px.';
$string['edit'] = 'Uredi';
$string['edita'] = 'Uredi {$a}';
$string['editcategorysettings'] = 'Uredi podešavanja kategorije';
$string['editcategorythis'] = 'Uredi ovu kategoriju';
$string['editcoursesettings'] = 'Uredi podešavanja kursa';
$string['editfiles'] = 'Uređivanje datoteka';
$string['editgroupprofile'] = 'Uredi opis grupe';
$string['editingteachershort'] = 'Editor';
$string['editlock'] = 'Ova vrednost se ne može promeniti!';
$string['editmode'] = 'Režim uređivanja';
$string['editmyprofile'] = 'Uredi profil';
$string['editorbgcolor'] = 'Boja pozadine';
$string['editorcleanonpaste'] = 'Obriši Word HTML oznake prilikom kopiranja';
$string['editorcommonsettings'] = 'Opšta podešavanja';
$string['editordefaultfont'] = 'Podrazumevani font';
$string['editorenablespelling'] = 'Omogući proveru pravopisa';
$string['editorfontlist'] = 'Spisak fontova';
$string['editorfontsize'] = 'Podrazumevana veličina fonta';
$string['editorpreferences'] = 'Parametri editora teksta';
$string['editorresettodefaults'] = 'Vrati na podrazumevane vrednosti';
$string['editorsettings'] = 'Podešavanja editora';
$string['editorshortcutkeys'] = 'Prečice sa tastature editora';
$string['editsection'] = 'Uredi podešavanja';
$string['editsectionname'] = 'Uredi naziv sekcije';
$string['editsectionsettings'] = 'Uredi podešavanja sekcije';
$string['editsectiontitle'] = 'Uredi sekciju: {$a}';
$string['editsettings'] = 'Uredi podešavanja';
$string['editthisactivity'] = 'Uređivanje ove aktivnosti';
$string['editthiscategory'] = 'Uredi ovu kategoriju';
$string['edittitle'] = 'Uredi naslov';
$string['edittitleinstructions'] = 'Pritisnite taster \'Escape\' za otkazivanje, a taster \'Enter\' kada završite';
$string['edituser'] = 'Uređivanje korisničkih naloga';
$string['edulevel'] = 'Svi događaji';
$string['edulevel_help'] = '* Podučavanje - aktivnosti predavača, npr. ažuriranje resursa
* Učestvovanje - aktivnosti polaznika, npr. postavljanje nove teme na forumu
* Ostalo - aktivnosti korisnika koji nije ni u ulozi predavača ni u ulozi polaznika';
$string['edulevelother'] = 'Drugi';
$string['edulevelparticipating'] = 'Učestvovanje';
$string['edulevelteacher'] = 'Podučavanje/nastava';
$string['email'] = 'Adresa e-pošte';
$string['emailactive'] = 'Adresa e-pošte je aktivirana';
$string['emailagain'] = 'Adresa e-pošte (ponovo)';
$string['emailalreadysent'] = 'Elektronska poruka za resetovanje lozinke je već poslata.
Molimo vas da proverite svoju elektronsku poštu.';
$string['emailcharset'] = 'Skup karaktera korišćen za e-poštu';
$string['emailconfirm'] = 'Potvrdite svoj korisnički nalog';
$string['emailconfirmation'] = 'Poštovana/i {$a->firstname},

Zatraženo je otvaranje korisničkog naloga na sajtu \'{$a->sitename}\' koristeći vašu adresu e-pošte.

Da biste potvrdili svoj novi nalog, molimo vas idite na sledeću veb adresu

{$a->link}

U većini programa za elektronsku poštu, ovo bi trebalo da se pojavi kao plavo obojeni link na koji je potrebno samo kliknuti. Ako ta opcija ne funkcioniše, kopirajte navedenu adresu u adresnu liniju na vrhu prozora vašeg veb čitača.

Ako vam je potrebna pomoć, obratite se administratoru sajta,
{$a->admin}';
$string['emailconfirmationresend'] = 'Pošalji ponovo e-poruku za potvrdu';
$string['emailconfirmationsubject'] = '{$a}: potvrda registracije korisničkog naloga';
$string['emailconfirmsent'] = '<p>Trebalo bi da je poslata e-poruka na vašu adresu <b>{$a}</b></p>
<p>Poruka sadrži jednostavna uputstva o daljem postupku registracije.</p>
<p>Ako i dalje imate problema, kontaktirajte administratora.</p>';
$string['emailconfirmsentfailure'] = 'E-poruka za potvrdu nije poslata';
$string['emailconfirmsentsuccess'] = 'E-poruka za potvrdu uspešno je poslata';
$string['emaildigest'] = 'Način obaveštavanja putem e-poruka';
$string['emaildigest_help'] = 'Ovo je podešavanje određuje kako će kopije poruka sa foruma bit slate na vašu e-adresu.

* Bez skraćivanja - dobijaćete po jednu elektronsku poruku za svaku poruku (post) objavljenu na forumima;
* Sažetak - kompletan pregled svih poruka - dobijaćete jednu elektronsku poruku dnevno sa kompletnim sadržajem svih poruka (postova) objavljenih u toku 24 sata;
* Sažetak - samo teme poruka - dobijaćete jednu elektronsku poruku dnevno koja će sadržati samo teme svih poruka (postova) objavljenih u toku 24 sata (bez sadržaja samih postova).

Ako želite možete odabrati drugačije podešavanje za svaki forum.';
$string['emaildigestcomplete'] = 'Kompletno (jedna e-poruka dnevno sa kompletnim sadržajem svih poruka na forumima)';
$string['emaildigestoff'] = 'Bez skraćivanja (po jedna e-poruka za svaku poruku objavljenu na forumima)';
$string['emaildigestsubjects'] = 'Teme poruka (jedna e-poruka dnevno samo, sa temama poruka objavljenih na forumima)';
$string['emaildisable'] = 'Ova adresa e-pošte nije dostupna';
$string['emaildisableclick'] = 'Kliknite ovde kako biste onemogućili slanja bilo kakve e-poruke na ovu adresu.';
$string['emaildisplay'] = 'Vidljivost adrese e-pošte';
$string['emaildisplay_help'] = 'Sakriveno - samo korisnici sa odgovarajućim ovlašćenjima, kao što su predavači, mogu da vide vašu adresu e-pošte.
Vidljivo svima - svi korisnici na sajtu mogu da vide vašu adresu e-pošte.
Vidljivo učesnicima kursa - samo učesnici kurseva na koje ste upisani mogu da vide vašu adresu e-pošte.';
$string['emaildisplaycourse'] = 'Vidljivo učesnicima kursa';
$string['emaildisplaycoursemembersonly'] = '(Vidljivo ostalim učesnicima kursa)';
$string['emaildisplayeveryone'] = '(Vidljivo svima)';
$string['emaildisplayhide'] = '(Sakriveno od svih osim korisnika sa odgovarajućim ovlašćenjima)';
$string['emaildisplayno'] = 'Sakriveno';
$string['emaildisplayyes'] = 'Vidljivo svima';
$string['emailenable'] = 'Ova adresa e-pošte je dostupna';
$string['emailenableclick'] = 'Kliknite ovde kako biste ponovno omogućili slanja svih e-poruka na ovu adresu';
$string['emailexists'] = 'Ova adresa e-pošte je već registrovana.';
$string['emailexistshintlink'] = 'Obnovi zaboravljeno korisničko ime ili lozinku';
$string['emailexistssignuphint'] = 'Možda ste ranije već kreirali nalog? {$a}';
$string['emailformat'] = 'Format e-pošte';
$string['emailmustbereal'] = 'Napomena: vaša adresa e-pošte mora biti stvarna.';
$string['emailnotallowed'] = 'Elektronske adrese koje pripadaju ovim domenima nisu dozvoljene ({$a})';
$string['emailnotfound'] = 'Adresa e-pošte nije nađena u bazi podataka';
$string['emailonlyallowed'] = 'Ova adrese e-pošte se ne može koristiti. Dozvoljeni domeni e-pošte su: {$a}.';
$string['emailpasswordchangeinfo'] = 'Poštovana/i {$a->firstname},

Neko (verovatno vi) je zatražio novu lozinku za vaš korisnički nalog  \'{$a->username}\' na sajtu \'{$a->sitename}\'.

Da biste promenili svoju lozinku idite na sledeću veb adresu:

{$a->link}

U većini programa za elektronsku poštu, ovo bi trebalo da se pojavi kao plavo obojeni link na koji je potrebno samo kliknuti. Ako ta opcija ne funkcioniše, kopirajte navedenu adresu u adresnu liniju na vrhu prozora vašeg veb čitača.

Ukoliko vam je potrebna tehnička pomoć, molimo vas da kontaktirate administratora,
{$a->admin}';
$string['emailpasswordchangeinfodisabled'] = 'Poštovana/i {$a->firstname},
 
Neko (verovatno Vi) je zatražio novu lozinku za Vaš korisnički nalog na sajtu \'{$a->sitename}\'.
 
Na žalost, Vaš nalog na ovom sajtu je onemogućen, pa lozinka ne može biti resetovana. Molimo, kontaktirajte administratora sajta, {$a->admin}.';
$string['emailpasswordchangeinfofail'] = 'Poštovana/i {$a->firstname},
 
Neko (verovatno Vi) je tražio novu lozinku za Vaš korisnički nalog na sajtu \'{$a->sitename}\'.
 
Na žalost, lozinke se ne mogu resetovati na ovom sajtu. Molimo, kontaktirajte administratora sajta {$a->admin}.';
$string['emailpasswordchangeinfosubject'] = '{$a}: Informacije o promeni lozinke';
$string['emailpasswordconfirmation'] = 'Poštovana/i {$a->firstname},

Neko (verovatno vi) je zatražio novu lozinku za vaš korisnički nalog na sajtu \'{$a->sitename}\'.

Da biste potvrdili zahtev i dobili novu lozinku putem e-pošte, idite na sledeću veb adresu:

{$a->link}

U većini programa za elektronsku poštu, ovo bi trebalo da se pojavi kao plavo obojeni link na koji je potrebno samo kliknuti. Ako ta opcija ne funkcioniše, kopirajte navedenu adresu u adresnu liniju na vrhu prozora vašeg veb čitača.

Ukoliko vam je potrebna tehnička pomoć, molimo vas da kontaktirate administratora,
{$a->admin}';
$string['emailpasswordconfirmationsubject'] = '{$a}: Potvrda promene lozinke';
$string['emailpasswordconfirmmaybesent'] = '<p>Ako ste naveli tačno korisničko ime ili jedinstvenu adresu e-pošte, trebalo bi da vam je poslata elektronska poruka.</p>
<p>Ona sadrži jednostavna uputstva za potvrdu i završetak procesa promene lozinke.
Ako budete i dalje imali poteškoće, molimo kontaktirajte administratora sajta.</p>';
$string['emailpasswordconfirmnoemail'] = '<p>Korisnički nalog koji ste naveli nema zabeleženu elektronsku adresu.</p>
   <p>Molimo vas da kontaktirate administratora.</p>';
$string['emailpasswordconfirmnotsent'] = '<p>Korisnički podaci koje ste naveli se ne odnose ni na jedan postojeći korisnički nalog.</p>
   <p>Molimo vas, proverite informacije koje ste uneli, a zatim pokušajte ponovo.
Ako i dalje imate problema, molimo vas da kontaktirate administratora.</p>';
$string['emailpasswordconfirmsent'] = 'Trebalo bi da je poslata e-poruka na vašu adresu <b>{$a}</b>.
<p>Poruka sadrži jednostavna uputstva za potvrđivanje i završetak ove promene lozinke.
Ako i dalje imate problema, kontaktirajte administratora.';
$string['emailresetconfirmation'] = 'Poštovana/i {$a->firstname},

Zatražena je nova lozinka za vaš korisnički nalog \'{$a->username}\' na sajtu {$a->sitename}.

Kako biste potvrdili ovaj zahtev i podesili novu lozinku za svoj nalog, molimo vas da posetite sledeću veb adresu:
<a href="{$a->link}">{$a->link}</a>

(Ovaj link je aktivan sledećih  {$a->resetminutes} minuta od trenutka kada je zahtev za novom lozinkom prvi put zatražen).

Ako niste zahtevali promenu lozinke, ne morate ništa da preduzimate.

Ako vam je potrebna pomoć, molimo vas obratite se administratoru, {$a->admin}';
$string['emailresetconfirmationsubject'] = '{$a}: Zahtev za promenu lozinke';
$string['emailresetconfirmsent'] = 'Elektronska poruka je poslata na vašu adresu <b>{$a}</b>.
<br />Poruka sadrži jednostavna uputstva kako da potvrditi i završiti promenu lozinke.
Ako i dalje imate problema, molimo vas da kontaktirate administratora sajta.';
$string['emailstop'] = 'Onemogući obaveštenja';
$string['emailtoprivatefiles'] = 'Takođe, možete da pošaljete datoteke, kao priloge, e-poštom, pravo u vaš prostor za privatne datoteke, Jednostavno priložite svoj datoteke uz e-poruku i pošaljite je na {$a}';
$string['emailtoprivatefilesdenied'] = 'Vaš administrator je onemogućio opciju da postavljate sopstvene privatne datoteke.';
$string['emailvia'] = '{$a->name} (preko {$a->siteshortname})';
$string['emojicategoryactivities'] = 'Aktivnosti';
$string['emojicategoryanimalsnature'] = 'Životinje i priroda';
$string['emojicategoryflags'] = 'Indikatori (zastavice)';
$string['emojicategoryfooddrink'] = 'Hrana i piće';
$string['emojicategoryobjects'] = 'Predmeti';
$string['emojicategorypeoplebody'] = 'Ljudi i telo';
$string['emojicategoryrecent'] = 'Skorašnji';
$string['emojicategorysmileysemotion'] = 'Smajliji i emocije';
$string['emojicategorysymbols'] = 'Simboli';
$string['emojicategorytravelplaces'] = 'Putovanja i mesta';
$string['emptycmids'] = 'ID oznake praznih modula kursa';
$string['emptydragdropregion'] = 'prazan region';
$string['emptysectionids'] = 'ID oznake praznih sekcija';
$string['enable'] = 'Omogući';
$string['encryptedcode'] = 'Šifrovani kôd';
$string['enddate'] = 'Datum završetka kursa';
$string['enddate_help'] = 'Datum završetka ne sprečava polaznike da pristupe kursu. On određuje da li se kurs prikazuje na spisku prošlih kurseva na stranici\'Moji kursevi\'.';
$string['enddatewithtaskenabled'] = 'Datum završetka kursa';
$string['enddatewithtaskenabled_help'] = 'Datum kada kurs postaje skriven za studente i kada oni više ne mogu da mu pristupe.';
$string['english'] = 'Engleski';
$string['enrolmentmethods'] = 'Metode upisa';
$string['entercourse'] = 'Kliknite za pristup kursu';
$string['enteremail'] = 'Unesite svoju elektronsku adresu';
$string['enteremailaddress'] = 'Da biste poništili trenutnu lozinku i dobili novu, treba da unesete vašu važeću adresu elektronske pošte, na koju će vam biti poslata nova lozinka.';
$string['enterusername'] = 'Unesite svoje korisničko ime';
$string['entries'] = 'Ulazi';
$string['error'] = 'Greška';
$string['errorcreatingactivity'] = 'Nije moguće kreirati instancu aktivnosti \'{$a}\'';
$string['errorfiletoobig'] = 'Datoteka je bila veća od ograničenja od {$a} bajta (bajtova)';
$string['errornouploadrepo'] = 'Na ovom sajtu ne postoji repozitorijum za postavljanje datoteka koji je omogućen';
$string['errorwhenconfirming'] = 'Vaš korisnički nalog još nije još potvrđen zbog greške koja se dogodila. Ako ste kliknuli na link koji ste dobili u e-poruci, molimo proverite je li linija u kojoj se nalazi navedeni link ispravna (odnosno, je da je nije vaš klijent e-pošte možda formatirao u dva reda, čime je deo linka završio u drugom redu). Postoji mogućnost da ćete morati ručnim kopiranjem i unosom rekonstruisati originalni link.';
$string['eventcommentcreated'] = 'Komentar kreiran';
$string['eventcommentdeleted'] = 'Komentar obrisan';
$string['eventcommentsviewed'] = 'Komentari prikazani';
$string['eventconfiglogcreated'] = 'Konfiguracioni zapis kreiran';
$string['eventcontentviewed'] = 'Sadržaj prikazan';
$string['eventcoursebackupcreated'] = 'Rezervna kopija kursa kreirana';
$string['eventcoursecategorycreated'] = 'Kategorija kreirana';
$string['eventcoursecategorydeleted'] = 'Kategorija obrisana';
$string['eventcoursecategoryupdated'] = 'Kategorija ažurirana';
$string['eventcoursecategoryviewed'] = 'Kategorija prikazana';
$string['eventcoursecontentdeleted'] = 'Sadržaj kursa obrisan';
$string['eventcoursecreated'] = 'Kurs kreiran';
$string['eventcoursedeleted'] = 'Kurs obrisan';
$string['eventcourseended'] = 'Kurs se završio';
$string['eventcourseinformationviewed'] = 'Rezime kursa prikazan';
$string['eventcoursemodulecreated'] = 'Modul kursa kreiran';
$string['eventcoursemoduledeleted'] = 'Modul kursa obrisan';
$string['eventcoursemoduleinstancelistviewed'] = 'Spisak instanci modula kursa prikazan';
$string['eventcoursemoduleupdated'] = 'Modul kursa ažuriran';
$string['eventcoursemoduleviewed'] = 'Modul kursa prikazan';
$string['eventcourseoverviewviewed'] = 'Stranica sa pregledom aktivnosti na kursu prikazana';
$string['eventcourseresetended'] = 'Resetovanje kursa završeno';
$string['eventcourseresetstarted'] = 'Resetovanje kursa pokrenuto';
$string['eventcourserestored'] = 'Kurs restauriran';
$string['eventcoursesectioncreated'] = 'Sekcija kursa kreirana';
$string['eventcoursesectiondeleted'] = 'Obrisana je sekcija kursa';
$string['eventcoursesectionupdated'] = 'Sekcija kursa ažurirana';
$string['eventcoursessearched'] = 'Pretraženi kursevi';
$string['eventcoursestarted'] = 'Kurs je počeo';
$string['eventcourseupdated'] = 'Kurs ažuriran';
$string['eventcourseuserreportviewed'] = 'Izveštaj o korisniku na kursu prikazan';
$string['eventcourseviewed'] = 'Kurs prikazan';
$string['eventdashboardreset'] = 'Vraćanje kontrolnog panela na početna podešavanja';
$string['eventdashboardsreset'] = 'Vraćanje kontrolnih panela na početna podešavanja';
$string['eventdashboardviewed'] = 'Kontrolni panel prikazan';
$string['eventdatabasetextfieldcontentreplaced'] = 'Globalna pretraga i zamena unutar baze podataka';
$string['eventemailfailed'] = 'Pokušaj slanja e-poruke nije uspeo';
$string['eventmycoursesviewed'] = 'Moji kursevi prikazani';
$string['eventname'] = 'Naziv događaja';
$string['eventrecentactivityviewed'] = 'Nedavne aktivnosti prikazane';
$string['eventsearchindexed'] = 'Pretraži indeksirane podatke';
$string['eventsearchresultsviewed'] = 'Rezultati pretrage prikazani';
$string['eventsectionviewed'] = 'Sekcija prikazana';
$string['eventunknownlogged'] = 'Nepoznati događaj';
$string['eventurlblocked'] = 'URL adresa je blokirana';
$string['eventusercreated'] = 'Korisnik kreiran';
$string['eventuserdeleted'] = 'Korisnik obrisan';
$string['eventuserfeedbackgiven'] = 'Kliknuto je na link za povratne informacije';
$string['eventuserfeedbackremind'] = 'Podseti me kasnije da kliknem na link za povratne informacije';
$string['eventuserinfocategorycreated'] = 'Kategorija polja korisničkog profila kreirana';
$string['eventuserinfocategorydeleted'] = 'Kategorija polja korisničkog profila obrisana';
$string['eventuserinfocategoryupdated'] = 'Kategorija polja korisničkog profila ažurirana';
$string['eventuserinfofieldcreated'] = 'Polje korisničkog profila kreirano';
$string['eventuserinfofielddeleted'] = 'Polje korisničkog profila obrisano';
$string['eventuserinfofieldupdated'] = 'Polje korisničkog profila ažurirano';
$string['eventuserlistviewed'] = 'Spisak korisnika prikazan';
$string['eventuserloggedout'] = 'Korisnik se odjavio';
$string['eventuserpasswordpolicyfailed'] = 'Lozinka korisnika nije u skladu sa pravilima za kreiranje lozinke';
$string['eventuserpasswordupdated'] = 'Korisnička lozinka ažurirana';
$string['eventuserprofileviewed'] = 'Korisnički profil prikazan';
$string['eventuserupdated'] = 'Korisnik ažuriran';
$string['everybody'] = 'Svi';
$string['executeat'] = 'Izvršiti u';
$string['existing'] = 'Postojeći';
$string['existingadmins'] = 'Postojeći administratori';
$string['existingcourse'] = 'Postojeći kurs';
$string['existingcourseadding'] = 'Postojeći kurs - dodavanje podataka postojećim';
$string['existingcoursedeleting'] = 'Postojeći kurs - prethodno brisanje kursa';
$string['existingcreators'] = 'Postojeći kreatori kursa';
$string['existingstudents'] = 'Upisani polaznici';
$string['existingteachers'] = 'Postojeći predavači';
$string['expand'] = 'Proširi';
$string['expandall'] = 'Proširi sve';
$string['expandcategory'] = 'Proširi {$a}';
$string['explanation'] = 'Objašnjenje';
$string['explanationdigitalminor'] = 'Ova informacija je neophodna da bi se utvrdilo da li je vaš uzrast iznad neophodnog digitalnog uzrasta u kom pojedinac može samostalno da prihvati odredbe i uslove korišćenja ovog sajta i dâ saglasnost da se podaci o njemu legalno čuvaju i obrađuju.';
$string['extendperiod'] = 'Period produženja';
$string['extendsession'] = 'Produži sesiju';
$string['failedloginattempts'] = '{$a->attempts} neuspešnih prijava na sistem od Vaše poslednje prijave';
$string['failedtaskbody'] = '<p>Zdravo {$a->firstname},</p>
<p>Zadatak <b>{$a->taskname}</b> nije uspeo više puta i zahteva pažnju.</p>
<p><a href="{$a->link}">Pogledaj zadatak</a></p>';
$string['failedtaskcontexturlname'] = 'Izveštaj o statusu';
$string['failedtasksubject'] = 'Neuspešno izvršeni zadatak: {$a}';
$string['favourites'] = 'Označen zvezdicom';
$string['feedback'] = 'Povratne informacije';
$string['file'] = 'Datoteka';
$string['fileexists'] = 'Već postoji datoteka pod nazivom {$a}';
$string['filemissing'] = '{$a} nedostaje';
$string['filereaderror'] = 'Nije moguće pročitati datoteku \'{$a}\'. Molimo proverite da li je stvarno u pitanju datoteka, a ne direktorijum.';
$string['files'] = 'Datoteke';
$string['filesanduploads'] = 'Datoteke i postavljene datoteke';
$string['filesfolders'] = 'Datoteke/Direktorijumi';
$string['fileuploadwithcontent'] = 'Postavljanje datoteka ne treba uključuje parametre sadržaja';
$string['filloutallfields'] = 'Molimo ispunite sva polja u ovom obrascu';
$string['filter'] = 'Filter';
$string['filteroption'] = '{$a->criteria}: {$a->value}';
$string['filterrowlegend'] = 'Filter {$a}';
$string['filters'] = 'Filteri';
$string['filtersetmatchdescription'] = 'Kako treba kombinovati više filtera';
$string['filtertype'] = 'Tip filtera';
$string['findmorecourses'] = 'Pronađite još kurseva...';
$string['first'] = 'Prvi';
$string['firstaccess'] = 'Prvi pristup';
$string['firstname'] = 'Ime';
$string['firstnamephonetic'] = 'Ime - fonetički';
$string['firstpage'] = 'Prva stranica';
$string['firstsiteaccess'] = 'Prvi pristup sajtu';
$string['firsttime'] = 'Da li ste ovde prvi put?';
$string['folder'] = 'Direktorijum';
$string['folderclosed'] = 'Zatvoren direktorijum';
$string['folderopened'] = 'Otvoren direktorijum';
$string['followingoptional'] = 'Sledeća polja su opciona';
$string['followingrequired'] = 'Sledeća polja su obavezna';
$string['for'] = 'Za';
$string['force'] = 'Obavezno';
$string['forcelanguage'] = 'Obavezan jezik';
$string['forceno'] = 'Nije obavezno';
$string['forcepasswordchange'] = 'Primoraj na promenu lozinke';
$string['forcepasswordchange_help'] = 'Ako je ovo polje za potvrdu označeno, od korisnika će se tražiti da promene lozinku kada se naredni put budu prijavili na sistem.';
$string['forcepasswordchangecheckfull'] = 'Da li ste sigurni da želite da primorate na promenu lozinke korisnika {$a}?';
$string['forcepasswordchangenot'] = 'Nije bilo moguće primorati {$a} na promenu lozinke.';
$string['forcepasswordchangenotice'] = 'Morate promeniti svoju lozinku da biste nastavili';
$string['forcepasswordresetfailurenotice'] = 'Vaša trenutna lozinka više nije u skladu sa postojećim pravilima za kreiranje lozinke. Obratite se svom Moodle administratoru za pomoć.
   {$a}';
$string['forcepasswordresetnotice'] = 'Vaša trenutna lozinka više nije u skladu sa postojećim pravilima za kreiranje lozinke. Morate resetovati lozinku za prijavu na sajt.
   {$a}';
$string['forcetheme'] = 'Obavezna grafička tema';
$string['forgotaccount'] = 'Zaboravili ste lozinku?';
$string['forgotten'] = 'Zaboravili ste svoje korisničko ime ili lozinku?';
$string['forgottenduplicate'] = 'Adresu e-pošte deli više korisničkih naloga, molim vas da umesto e-adrese unesete korisničko';
$string['forgotteninvalidurl'] = 'Neispravna URL adresa za promenu lozinke';
$string['format'] = 'Format';
$string['formathtml'] = 'HTML format';
$string['formatmarkdown'] = 'Markdown format';
$string['formatplain'] = 'Tekstualni format';
$string['formattext'] = 'Moodle auto-format';
$string['forumpreferences'] = 'Parametri foruma';
$string['framesetinfo'] = 'Ovaj skup okvira sadrži:';
$string['fromdate'] = 'Od';
$string['fromsender'] = 'Od';
$string['frontpagecategorycombo'] = 'Kombinovani spisak';
$string['frontpagecategorynames'] = 'Spisak kategorija';
$string['frontpagecourselist'] = 'Spisak kurseva';
$string['frontpagecoursesearch'] = 'Polje za pretraživanje kurseva';
$string['frontpagedescription'] = 'Rezime naslovne stranice sajta';
$string['frontpagedescriptionhelp'] = 'Ovaj rezime može biti prikazan na naslovnoj stranici sajta korišćenjem bloka \'Rezime kursa/sajta\'.';
$string['frontpageenrolledcourselist'] = 'Upisani kursevi';
$string['frontpageformat'] = 'Format naslovne stranice';
$string['frontpageformatloggedin'] = 'Format naslovne stranice kada je korisnik prijavljen';
$string['frontpagenews'] = 'Obaveštenja';
$string['frontpagesettings'] = 'Podešavanja naslovne stranice';
$string['fulllistofcourses'] = 'Svi kursevi';
$string['fullname'] = 'Puno ime';
$string['fullnamecourse'] = 'Pun naziv kursa';
$string['fullnamecourse_help'] = 'Pun naziv kursa se prikazuje na stranici \'Moji kursevi\', kao i na spisku dostupnih kurseva na početnoj stranici.';
$string['fullnamedisplay'] = '{$a->firstname} {$a->lastname}';
$string['fullnameuser'] = 'Puno ime korisnika';
$string['fullprofile'] = 'Potpuni profil';
$string['fullsitename'] = 'Pun naziv sajta';
$string['functiondisabled'] = 'Navedena funkcionalnost trenutno nije dostupna';
$string['general'] = 'Opšte';
$string['geolocation'] = 'širina - dužina';
$string['gettheselogs'] = 'Preuzmi ove zapise o aktivnostima';
$string['go'] = 'Dalje';
$string['gobacktosite'] = 'Vratite se na sajt';
$string['gpl'] = 'Autorska prava od 1999 pa nadalje Martin Dugiamas (https://moodle.com)

Ovaj program je besplatan softver; možete vršiti njegovu redistribuciju i/ili menjati ga samo pod uslovima GNU General Public License koju je objavila Free Software Foundation, verzija 2 ili (po vašem izboru) bilo koja novija verzija.

Ovaj program se distribuira u nadi da će biti koristan, ali BEZ IKAKVIH GARANCIJA; čak i bez implicitnih garancija ISPLATIVOSTI ili POGODNOSTI ZA KONKRETNU PRIMENU.

Pogledajte Moodle License stranicu sa informacijama za više detalja: https://moodledev.io/general/license';
$string['gpl3'] = 'Autorska prava od 1999 pa nadalje Martin Dugiamas  (https://moodle.com)

Ovaj program je besplatan softver; možete vršiti njegovu redistribuciju i/ili menjati ga samo pod uslovima GNU General Public License koju je objavila Free Software Foundation, verzija 3 ili (po vašem izboru) bilo koja novija verzija.

Ovaj program se distribuira u nadi da će biti koristan, ali BEZ IKAKVIH GARANCIJA; čak i bez implicitnih garancija ISPLATIVOSTI ili POGODNOSTI ZA KONKRETNU PRIMENU.

Pogledajte Moodle License stranicu sa informacijama za više detalja: https://moodledev.io/general/license';
$string['gpllicense'] = 'GPL licenca';
$string['gradenoun'] = 'Ocena';
$string['grades'] = 'Ocene';
$string['gradeverb'] = 'Ocena';
$string['gravatarenabled'] = '<a href="https://www.gravatar.com/">Gravatar</a> je omogućen za ovaj sajt. Ako sami ne postavite svoju sliku Moodle će pokušati da je umesto vas učita sa Gravatara.';
$string['group'] = 'Grupa';
$string['groupadd'] = 'Dodavanje nove grupe';
$string['groupaddusers'] = 'Dodavanje izabranih polaznika grupi';
$string['groupfor'] = 'za grupu';
$string['groupinfo'] = 'Informacije o izabranoj grupi';
$string['groupinfoedit'] = 'Uređivanje podešavanja grupe';
$string['groupinfomembers'] = 'Informacije o izabranim članovima';
$string['groupinfopeople'] = 'Informacije o izabranim ljudima';
$string['groupmembers'] = 'Članovi grupe';
$string['groupmemberssee'] = 'Prikaz članova grupe';
$string['groupmembersselected'] = 'Članovi izabrane grupe';
$string['groupmode'] = 'Grupni način rada';
$string['groupmodeforce'] = 'Obavezan grupni mod';
$string['groupmy'] = 'Moja grupa';
$string['groupnonmembers'] = 'Polaznici koji nisu u grupi';
$string['groupnotamember'] = 'Žao nam je, niste član te grupe';
$string['grouprandomassign'] = 'Slučajnim odabirom rasporedi sve polaznike u grupe';
$string['groupremove'] = 'Ukloni izabranu grupu';
$string['groupremovemembers'] = 'Ukloni izabrane članove';
$string['groups'] = 'Grupe';
$string['groupsnone'] = 'Nema grupa';
$string['groupsseparate'] = 'Odvojene grupe';
$string['groupsvisible'] = 'Vidljive grupe';
$string['guest'] = 'Gost';
$string['guestdescription'] = 'Gosti imaju minimalne privilegije i obično nigde ne mogu da unesu tekst.';
$string['guestskey'] = 'Dozvoli pristup gostima koji imaju lozinku kursa';
$string['guestsno'] = 'Zabranjen pristup gostima';
$string['guestsnotallowed'] = 'Nažalost, kurs \'{$a}\' ne dozvoljava pristup gostima.';
$string['guestsyes'] = 'Dozvoli pristup gostima bez lozinke kursa';
$string['guestuser'] = 'Korisnik u ulozi gosta';
$string['guestuserinfo'] = 'Ovaj korisnik je poseban koji dozvoljava pristup nekim kursevima samo za čitanje.';
$string['help'] = 'Pomoć';
$string['helpprefix2'] = 'Pomoć za {$a}';
$string['helpwiththis'] = 'Pomoć za ovo';
$string['hiddenassign'] = 'Sakriveni zadaci';
$string['hiddenfromstudents'] = 'Sakriveno od polaznika';
$string['hiddenoncoursepage'] = 'Dostupno ali se ne prikazuje na stranici kursa';
$string['hiddensections'] = 'Sakrivene sekcije';
$string['hiddensections_help'] = 'Skrivene sekcije se polaznicima prikazuju kao nedostupne na stranici kursa, ili su u potpunosti sakrivene.';
$string['hiddensectionscollapsed'] = 'Sakrivene sekcije su prikazane kao nedostupne';
$string['hiddensectionsinvisible'] = 'Sakrivene sekcije su u potpunosti nevidljive';
$string['hiddenwithbrackets'] = '(skriveno)';
$string['hide'] = 'Sakrij';
$string['hideadvancedsettings'] = 'Sakrij napredna podešavanja';
$string['hidecategory'] = 'Sakrij kategoriju?';
$string['hidecategorymany'] = 'Kategorija {$a->category} sadrži sledeći broj kurseva: {$a->coursecount}.
<br/>Ako sakrijete kategoriju, korisnici bez dozvole da vide skrivene kategorije više neće imati pristup kursevima.';
$string['hidecategoryone'] = 'Kategorija {$a->category} sadrži 1 kurs.
<br/>Ako je sakrijete, korisnici bez dozvole da vide skrivene kategorije više neće imati pristup kursu.';
$string['hidechartdata'] = 'Sakrij podatke grafikona';
$string['hidefromstudents'] = 'Sakrij na stranici kursa';
$string['hideoncoursepage'] = 'Učini dostupnim ali ne prikazuj na stranici kursa';
$string['hidepopoverwindow'] = 'Sakrij iskačući prozor sa dodatnim informacijama';
$string['hidesection'] = 'Sakrij sekciju {$a}';
$string['hidesettings'] = 'Sakrij podešavanja';
$string['hideshowblocks'] = 'Sakrij ili prikaži blokove';
$string['highlight'] = 'Istakni';
$string['highlighted'] = 'Istaknuto';
$string['highlightoff'] = 'Ukloni isticanje';
$string['hits'] = 'Posete';
$string['hitsoncourse'] = 'Posete korisnika {$a->username} kursu {$a->coursename}';
$string['hitsoncoursetoday'] = 'Današnje posete korisnika {$a->username} kursu {$a->coursename}';
$string['home'] = 'Početna stranica';
$string['homeheader'] = 'Meni naslovne stranice';
$string['hour'] = 'h';
$string['hours'] = 'sat/a/i';
$string['howtomakethemes'] = 'Kako napraviti nove grafičke teme';
$string['htmleditor'] = 'Koristi HTML editor';
$string['htmleditoravailable'] = 'HTML editor je dostupan';
$string['htmleditordisabled'] = 'Isključili ste upotrebu HTML editora u svom korisničkom profilu';
$string['htmleditordisabledadmin'] = 'Administrator sistema je isključio upotrebu HTML editora na ovom sajtu';
$string['htmleditordisabledbrowser'] = 'HTML editor nije dostupan jer vaš veb čitač nije kompatibilan sa njim';
$string['htmlfilesonly'] = 'Samo HTML datoteke';
$string['htmlformat'] = 'Ulepšani HTML format';
$string['icon'] = 'Ikonica';
$string['idnumber'] = 'ID broj';
$string['idnumbercourse'] = 'ID broj kursa';
$string['idnumbercourse_help'] = 'ID oznaka kursa se koristi samo prilikom povezivanja sa eksternim sistemima. Ako kurs nema oficijelnu ID oznaku, onda ovo polje ostavite prazno.';
$string['idnumbercoursecategory'] = 'ID broj kategorije';
$string['idnumbercoursecategory_help'] = 'ID broj kategorije kursa se koristi samo za poređenje sa eksternim sistemom ID brojeva, i nigde se ne prikazuje na sajtu. Ako kategorija ima zvaničan kodni naziv, on može biti unet, u suprotnom polje može biti ostavljeno prazno.';
$string['idnumbergroup'] = 'ID broj grupe';
$string['idnumbergroup_help'] = 'ID broj grupe se koristi samo prilikom upoređivanja sa eksternim sistemima i ne prikazuje se nigde na sajtu. Ako grupa ima neku oficijelnu šifru, ona može ovde biti upisana, u suprotnom polje može ostati prazno.';
$string['idnumbergrouping'] = 'ID broj grupisanja';
$string['idnumbergrouping_help'] = 'ID broj grupisanja se koristi samo prilikom upoređivanja sa eksternim sistemima i ne prikazuje se nigde na sajtu. Ako grupisanje ima neku oficijelnu šifru, ona može ovde biti upisana, u suprotnom polje može ostati prazno.';
$string['idnumbermod'] = 'ID broj';
$string['idnumbermod_help'] = 'Postavljanje ID broja omogućava identifikaciju aktivnosti ili resursa u svrhe kao što su izračunavanja ocena ili kreiranja prilagođenih izveštaja. U suprotnom polje se može ostaviti prazno.

Za aktivnosti koje se mogu ocenjivati. ID broj se, takođe, može postaviti u dnevniku ocena, iako se može uređivati jedino na stranici za podešavanje aktivnosti.';
$string['idnumbertaken'] = 'Ovaj ID broj je već zauzet';
$string['imagealt'] = 'Opis slike';
$string['import'] = 'Uvoz';
$string['importdata'] = 'Uvoz podataka kursa';
$string['importdataexported'] = 'Izvoz podataka iz izvornog kursa prošao je uspešno. <br /> Sledi uvoz podataka u odredišni kurs';
$string['importdatafinished'] = 'Uvoz podataka je uspešno završen! Nastavite prema svom kursu';
$string['importdatafrom'] = 'Pronađite kurs iz kog želite da uvezete podatke:';
$string['importinfo'] = 'Uvezite stavke iz drugih kurseva, kao što su aktivnosti, blokovi ili događaji iz kalendara. Korisnički podaci neće biti uvezeni.';
$string['inactive'] = 'Neaktivan';
$string['include'] = 'Uključi';
$string['includeallusers'] = 'Uključi sve korisnike';
$string['includecoursefiles'] = 'Uključi datoteke kursa';
$string['includecourseusers'] = 'Uključi polaznike kursa';
$string['included'] = 'Uključeni';
$string['includelogentries'] = 'Uključi stavke izveštaja o aktivnostima';
$string['includemodules'] = 'Uključi module';
$string['includemoduleuserdata'] = 'Uključi podatke korisnika modula';
$string['includeneededusers'] = 'Uključi potrebne korisnike';
$string['includenoneusers'] = 'Bez uključivanja korisnika';
$string['includeroleassignments'] = 'Uključi dodele uloga';
$string['includesitefiles'] = 'Uključi datoteke sajta korišćene u ovom kursu';
$string['includesubcategories'] = 'Uključi potkategorije';
$string['includeuserfiles'] = 'Uključi korisničke datoteke';
$string['increasesections'] = 'Povećaj broj sekcija';
$string['indicator:accessesafterend'] = 'Pristupi kursu nakon datuma završetka';
$string['indicator:accessesafterend_help'] = 'Ovaj indikator pokazuje da li je polaznik pristupao kursu nakon njegovog završetka.';
$string['indicator:accessesbeforestart'] = 'Pristupi kursu pre datuma početka';
$string['indicator:accessesbeforestart_help'] = 'Ovaj indikator pokazuje da je polaznik pristupao kursu pre njegovog početka.';
$string['indicator:activitiesdue'] = 'Aktivnosti koje se uskoro završavaju';
$string['indicator:activitiesdue_help'] = 'Korisnik ima aktivnosti koje se uskoro završavaju';
$string['indicator:anycourseaccess'] = 'Pristup bilo kom kursu';
$string['indicator:anycourseaccess_help'] = 'Ovaj indikator pokazuje pristup bilo kom kursu na koji je korisnik upisan.';
$string['indicator:anywrite'] = 'Bilo koja akcija pisanja';
$string['indicator:anywrite_help'] = 'Ovaj indikator predstavlja bilo koju akciju pisanja (predaje) od strane polaznika.';
$string['indicator:anywriteincourse'] = 'Bilo koja akcija pisanja na kursu';
$string['indicator:anywriteincourse_help'] = 'Ovaj indikator predstavlja bilo koju akciju pisanja (predaje) od strane polaznika unutar bilo koje aktivnosti na kursu.';
$string['indicator:completeduserprofile'] = 'Korisnički profil je popunjen';
$string['indicator:completeduserprofile_help'] = 'Ovaj indikator pokazuje da je polaznik popunio svoj korisnički profil.';
$string['indicator:completeduserprofiledef'] = 'Korisnički profil je popunjen';
$string['indicator:completeduserprofiledef_help'] = 'Korisnik se saglasio sa pravilnikom o korišćenju sajta i popunio je sledeća polja: Institucija, Departman/Odsek, Adresa, Grad, Država, URL adresa.';
$string['indicator:completionenabled'] = 'Praćenje završetka je omogućeno';
$string['indicator:completionenabled_help'] = 'Ovaj indikator pokazuje da je omogućeno praćenje završetka za ovaj kurs.';
$string['indicator:nostudent'] = 'Upisi polaznika';
$string['indicator:nostudent_help'] = 'Ovaj indikator pokazuje dostupnost polaznika na kursu.';
$string['indicator:noteacher'] = 'Dostupnost predavača';
$string['indicator:noteacher_help'] = 'Ovaj indikator pokazuje dostupnost predavača na kursu.';
$string['indicator:potentialcognitive'] = 'Potencijalna kognitivna dubina kursa';
$string['indicator:potentialcognitive_help'] = 'Ovaj indikator se zasniva na potencijalnoj kognitivnoj dubini koju bi polaznik mogao postići svojim učešćem u aktivnostima na kursu.';
$string['indicator:potentialcognitivedef'] = 'Potencijalna kognitivna dubina kursa';
$string['indicator:potentialcognitivedef_help'] = 'Nivo do koga kurs pruža „dubok“ kognitivni angažman, npr. predaja zadatka/rada radi dobijanja povratnih informacija, mogućnost pregleda rada od strane drugih učesnika, kao i mogućnost revizije i ponovnog predavanja rada.';
$string['indicator:potentialcognitivedef_link'] = 'Learning_analytics_indicators#Cognitive_depth';
$string['indicator:potentialsocial'] = 'Potencijalni obim socijalnih interakcija na kursu';
$string['indicator:potentialsocial_help'] = 'Ovaj indikator se zasniva na potencijalnoj socijalnoj širini koju bi polaznik mogao postići svojim učešćem u aktivnostima na kursu.';
$string['indicator:potentialsocialdef'] = 'Potencijalni obim socijalnih interakcija na kursu';
$string['indicator:potentialsocialdef_help'] = 'Nivo do koga kurs pruža „širok“ socijalni angažman, interakciju sa drugim učesnicima, kao i sa zajednicom praktičara izvan samoga kursa.';
$string['indicator:potentialsocialdef_link'] = 'Learning_analytics_indicators#Social_breadth';
$string['indicator:readactions'] = 'Broj akcija čitanja';
$string['indicator:readactions_help'] = 'Ovaj indikator pokazuje bilo koju akciju čitanja (pregleda) od strane polaznika.';
$string['indicator:userforumstracking'] = 'Korisnik prati forume';
$string['indicator:userforumstracking_help'] = 'Ovaj indikator pokazuje da li je polaznik uključio praćenje (ne)pročitanih poruka na forumima.';
$string['info'] = 'Informacija';
$string['inprogress'] = 'U toku';
$string['insertcontentbefore'] = 'Umetnite sadržaj pre \'{$a->activityname}\'';
$string['insertcontentsection'] = 'Umetnite sadržaj u sekciju \'{$a->sectionname}\'';
$string['insertresourceoractivitybefore'] = 'Ubacite aktivnost ili resurs pre \'{$a->activityname}\'';
$string['institution'] = 'Institucija';
$string['instudentview'] = 'u polazničkom pogledu';
$string['interests'] = 'Interesovanja';
$string['interestslist'] = 'Lista interesovanja';
$string['interestslist_help'] = 'Unesite svoja interesovanja, jedno po jedno, . Ona će potom biti prikazana na vašem profilu kao oznake (tagovi).';
$string['invalidemail'] = 'Neispravna adresa elektronske pošte';
$string['invalidlogin'] = 'Pogrešno korisničko ime ili lozinka. Molimo pokušajte ponovo.';
$string['invalidtaskclassname'] = 'Neispravna klasa zadataka {$a}';
$string['invalidtaskid'] = 'Neispravna ID oznaka zadataka';
$string['invalidusername'] = 'Korisničko ime može sadržati samo alfanumeričke znakove (mala slova i brojeve), donju crtu (_), crticu (-), tačku (.) ili simbol (@).';
$string['invalidusernameupload'] = 'Neispravno korisničko ime';
$string['ip_address'] = 'IP adresa';
$string['jump'] = 'Prelaz';
$string['jumpto'] = 'Prelaz na...';
$string['keep'] = 'Zadržite';
$string['labelvalue'] = '{$a->label}: {$a->value}';
$string['langltr'] = 'Smer pisanja s leva na desno';
$string['langrtl'] = 'Smer pisanja s desna na levo';
$string['language'] = 'Jezik';
$string['languagegood'] = 'Ovaj jezički paket je ažuran.';
$string['languageselector'] = 'Birač jezika';
$string['last'] = 'Poslednji';
$string['lastaccess'] = 'Poslednji pristup';
$string['lastcourseaccess'] = 'Poslednji pristup kursu';
$string['lastedited'] = 'Poslednji put uređeno';
$string['lastip'] = 'Poslednja IP adresa';
$string['lastlogin'] = 'Poslednji pristup sistemu';
$string['lastmodified'] = 'Poslednja izmena';
$string['lastname'] = 'Prezime';
$string['lastnamephonetic'] = 'Prezime - fonetički';
$string['lastpage'] = 'Poslednja stranica';
$string['lastsiteaccess'] = 'Poslednji pristup sajtu';
$string['lastyear'] = 'Prošla godina';
$string['latestlanguagepack'] = 'Pogledajte najnovije jezičke pakete na moodle.org';
$string['layouttable'] = 'Raspored u tabeli';
$string['leavetokeep'] = 'Ostavite prazno polje da zadržite trenutnu lozinku';
$string['legacylogginginuse'] = 'Na ovom sajtu je trenutno omogućeno upisivanje u staro skladište zapisa. Upisivanje u to skladište je prevaziđeno. Molimo prebacite se na upis u podržana skladišta zapisa kao što je "standardno" ili "spoljno".';
$string['legacythemeinuse'] = 'Ovaj sajt vam se prikazuje u tzv. kompatibilnom modu zato što je vaš veb čitač zastareo.';
$string['license'] = 'Licenca';
$string['licenses'] = 'Licence';
$string['liketologin'] = 'Želite li sad da pristupite sistemu s pravim korisničim nalogom?';
$string['list'] = 'Spisak';
$string['listfiles'] = 'Spisak datoteka u {$a}';
$string['listofallpeople'] = 'Spisak svih korisnika';
$string['listofcourses'] = 'Spisak kurseva';
$string['loading'] = 'Učitavanje';
$string['loadinghelp'] = 'Učitavanje ...';
$string['local'] = 'Lokalno';
$string['localplugins'] = 'Lokalni dodaci';
$string['localpluginsmanage'] = 'Upravljanje lokalnim dodacima';
$string['location'] = 'Lokacija';
$string['locktimeout'] = 'Операција је истекла док се чекало закључавање.';
$string['log_excel_date_format'] = 'd mmmm yyyy h:mm';
$string['loggedinas'] = 'Prijavljeni ste kao {$a}';
$string['loggedinasguest'] = 'Trenutno pristupate kao gost';
$string['loggedinnot'] = 'Niste prijavljeni.';
$string['login'] = 'Prijava';
$string['login_failure_logs'] = 'Zapisi o neuspešnim prijavama';
$string['loginactivity'] = 'Pregled prijavljivanja na sistem';
$string['loginagain'] = 'Prijavite se ponovo';
$string['loginalready'] = 'Već ste prijavljeni na sistem';
$string['loginas'] = 'Pristup sistemu kao';
$string['loginaspasswordexplain'] = '<p>Morate uneti specijalnu "pristupi sistemu kao" lozinku da biste koristili ovu mogućnost.<br />Ako ne znate tu lozinku, pitajte administratora svog servera.</p>';
$string['loginguest'] = 'Pristupite kao gost';
$string['loginsite'] = 'Prijavite se na sajt';
$string['loginsteps'] = 'Kako biste imali puni pristup ovom sajtu morate kreirati korisnički nalog.';
$string['loginstepsnone'] = '<p>Poštovani budući korisniče!</p>
<p>Za potpuni pristup kursevima morate kreirati korisnički nalog.</p>
<p>Sve što treba da uradite je da smislite korisničko ime i lozinku i unesete ih u za to određena polja u obrascu na ovoj stranici!</p>
<p>Ako je neko pre Vas već odabrao identično korisničko ime, morate odabrati neko drugo i pokušati ponovo.</p>';
$string['loginto'] = 'Prijava na {$a}';
$string['logoof'] = 'Logotip {$a}';
$string['logout'] = 'Odjava';
$string['logoutconfirm'] = 'Da li zaista želite da se odjavite?';
$string['logs'] = 'Zapisi o aktivnostima';
$string['logtoomanycourses'] = '[ <a href="{$a->url}">više</a> ]';
$string['logtoomanyusers'] = '[ <a href="{$a->url}">više</a> ]';
$string['lookback'] = 'Pogledaj unazad';
$string['mailadmins'] = 'Obavestiti administratore';
$string['mailstudents'] = 'Obavestiti polaznike';
$string['mailteachers'] = 'Obavestiti predavače';
$string['maincoursepage'] = 'Glavna stranica kursa';
$string['makeafolder'] = 'Kreiraj direktorijum';
$string['makeavailable'] = 'Učini dostupnim';
$string['makeeditable'] = 'Ako podesite \'{$a}\' da se može urediti procesom Web servera, onda možete menjati ovu datoteku direktno sa ove stranice';
$string['makethismyhome'] = 'Neka ovo bude moja početna stranica';
$string['makeunavailable'] = 'Učini nedostupnim';
$string['manageblocks'] = 'Blokovi';
$string['managecategories'] = 'Upravljanje kategorijama kurseva';
$string['managecategorythis'] = 'Upravljanje ovom kategorijom';
$string['managecombined'] = 'Upravljanje kategorijama kurseva i kursevima';
$string['managecontentbanktypes'] = 'Upravljanje tipovima sadržaja';
$string['managecourses'] = 'Upravljanje kursevima';
$string['managedatabase'] = 'Baza podataka';
$string['managedataformats'] = 'Upravljanje formatima podataka';
$string['manageeditorfiles'] = 'Upravljanje datotekama korišćenim od strane editora';
$string['managefilters'] = 'Filteri';
$string['managemodules'] = 'Moduli';
$string['manageroles'] = 'Uloge i prava pristupa';
$string['markallread'] = 'Označi sve kao pročitano';
$string['match'] = 'Nađi';
$string['matchingsearchandrole'] = 'Sparivanje \'{$a->search}\' i {$a->role}';
$string['matchofthefollowing'] = 'od sledećih:';
$string['maxareabytesreached'] = 'Datoteka (ili ukupna veličina nekoliko datoteka) je veća od mesta koji je preostalo u ovom prostoru.';
$string['maxfilesize'] = 'Maksimalna veličina za nove datoteke {$a}';
$string['maxfilesreached'] = 'Dozvoljeno vam je da uz ovu stavku priložite najviše {$a} datoteku/e/a';
$string['maximumchars'] = 'Maksimalan broj znakova: {$a}';
$string['maximumgrade'] = 'Maksimalna ocena';
$string['maximumgradex'] = 'Najveća ocena: {$a}';
$string['maximumshort'] = 'Maks.';
$string['maximumupload'] = 'Maksimalna veličina datoteka za postavljanje';
$string['maximumupload_help'] = 'Maksimalna veličina datoteke koja je polaznicima dozvoljena za postavljanje na kursu. Pored toga, možete dodatno ograničiti maksimalnu veličinu datoteke za postavljanje za svaku aktivnost, pojedinačno.';
$string['maxlengthreached'] = 'Dostignut je maksimalni broj od {$a} znakova';
$string['maxnumberweeks'] = 'Maksimalan broj sekcija';
$string['maxnumberweeks_desc'] = 'Maksimalna vrednost u padajućem meniju  "Broj sekcija" (važi samo za određene formate kursa).';
$string['maxnumcoursesincombo'] = 'Pretraži <a href="{$a->link}">{$a->numberofcourses} kurseve</a>';
$string['maxsectionslimit'] = 'Nije moguće kreirati novu sekciju pošto bi se time premašio maksimalan broj sekcija koji je dozvoljen za ovaj kurs ({$a}).';
$string['maxsize'] = 'Maks. veličina: {$a}';
$string['maxsizeandareasize'] = 'Maksimalna veličina za nove datoteke: {$a->size}, globalno ograničenje: {$a->areasize}';
$string['maxsizeandattachments'] = 'Maksimalna veličina datoteke: {$a->size}, maksimalan broj datoteka: {$a->attachments}';
$string['maxsizeandattachmentsandareasize'] = 'Maksimalna veličina datoteke: {$a->size}, maksimalan broj datoteka: {$a->attachments}, ukupno ograničenje veličine: {$a->areasize}';
$string['memberincourse'] = 'Učesnici u kursu';
$string['menu'] = 'Meni';
$string['message'] = 'Poruka';
$string['messagebody'] = 'Telo poruke';
$string['messagedselectedusers'] = 'Izabranim polaznicima poslata je poruka, a spisak primalac je resetovan.';
$string['messagedselectedusersfailed'] = 'Nešto nije bilo u redu pri slanju poruke izabranim korisnicima. Neki od njih su ipak možda primili poslatu poruku.';
$string['messageprovider:asyncbackupnotification'] = 'Obaveštenja o asinhronom kreiranju/restauriranju rezervnih kopija';
$string['messageprovider:availableupdate'] = 'Dostupna obaveštenja o ažuriranju';
$string['messageprovider:backup'] = 'Obaveštenja o kreiranju rezervne kopije';
$string['messageprovider:badgecreatornotice'] = 'Obaveštenje o kreatoru bedža';
$string['messageprovider:badgerecipientnotice'] = 'Obaveštenje o primaocu bedža';
$string['messageprovider:competencyplancomment'] = 'Komentar objavljen na planu učenja';
$string['messageprovider:competencyusercompcomment'] = 'Komentar postavljen na kompetencijama';
$string['messageprovider:coursecompleted'] = 'Kurs završen';
$string['messageprovider:coursecontentupdated'] = 'Promene sadržaja kursa';
$string['messageprovider:courserequestapproved'] = 'Obaveštenje o odobrenju zahteva za kreiranje kursa';
$string['messageprovider:courserequested'] = 'Obaveštenje o zahtevu za kreiranje kursa';
$string['messageprovider:courserequestrejected'] = 'Obaveštenje o odbijanju zahteva za kreiranje kursa';
$string['messageprovider:enrolcoursewelcomemessage'] = 'Poruka dobrodošlice za nove upise na kurs';
$string['messageprovider:errors'] = 'Važne greške u vezi sa sajtom';
$string['messageprovider:errors_help'] = 'Ovo su važne greške o kojima administrator mora da bude upoznat';
$string['messageprovider:failedtaskmaxdelay'] = 'Zadatak je dostigao maksimalno vreme odlaganja nakon neuspešnog pokušaja pokretanja';
$string['messageprovider:gradenotifications'] = 'Obaveštenja o oceni';
$string['messageprovider:infected'] = 'Obaveštenja o neuspelim operacijama antivirusnog programa.';
$string['messageprovider:insights'] = 'Uvidi koje su generisali modeli predviđanja';
$string['messageprovider:instantmessage'] = 'Lične poruke između korisnika';
$string['messageprovider:instantmessage_help'] = 'Ova sekcija konfiguriše šta se događa sa porukama koji su vam direktno poslate od strane drugih korisnika na ovom sajtu.';
$string['messageprovider:messagecontactrequests'] = 'Obaveštenje o zahtevima za kontakt';
$string['messageprovider:newlogin'] = 'Obaveštenja o novim prijavama na sajt';
$string['messageprovider:notices'] = 'Obaveštenja o manjim problemima';
$string['messageprovider:notices_help'] = 'Ovo su obaveštenja koja bi mogla da interesuju administratora da ih pogleda.';
$string['messageprovider:reportbuilderschedule'] = 'Rasporedi za kreiranja prilagođenih izveštaja';
$string['messageselect'] = 'Izaberite ovog korisnika kao primaoca poruke';
$string['messageselectadd'] = 'Pošalji poruku';
$string['middlename'] = 'Srednje ime';
$string['migratinggrades'] = 'Migracija ocena';
$string['min'] = 'min';
$string['mins'] = 'min';
$string['minute'] = 'minut';
$string['minutes'] = 'minut/a';
$string['miscellaneous'] = 'Razno';
$string['missingcategory'] = 'Morate odabrati kategoriju';
$string['missingdescription'] = 'Nedostaje opis';
$string['missingemail'] = 'Nedostaje adresa e-pošte';
$string['missingfirstname'] = 'Nedostaje ime';
$string['missingfromdisk'] = 'Nedostaje na disku';
$string['missingfullname'] = 'Nedostaje puno ime';
$string['missinglastname'] = 'Nedostaje prezime';
$string['missingname'] = 'Nedostaje ime';
$string['missingnewpassword'] = 'Nedostaje nova lozinka';
$string['missingpassword'] = 'Nedostaje lozinka';
$string['missingrecaptchachallengefield'] = 'reCAPTCHA pokušaj nije uspeo, probajte ponovo.';
$string['missingreqreason'] = 'Nedostaje razlog';
$string['missingshortname'] = 'Nedostaje skraćeni naziv';
$string['missingshortsitename'] = 'Nedostaje skraćeni naziv sajta';
$string['missingsitedescription'] = 'Nedostaje opis sajta';
$string['missingsitename'] = 'Nedostaje naziv sajta';
$string['missingstrings'] = 'Provera neprevedenih reči ili izraza';
$string['missingstudent'] = 'Morate nešto odabrati';
$string['missingsummary'] = 'Nedostaje rezime';
$string['missingteacher'] = 'Morate nešto odabrati';
$string['missingurl'] = 'Nedostaje URL';
$string['missingusername'] = 'Nedostaje korisničko ime';
$string['moddoesnotsupporttype'] = 'Modul {$a->modname} ne podržava postavljanja tipa {$a->type}';
$string['modhidden'] = 'Dostupnost';
$string['modhidden_help'] = '* Sakrijte na stranici kursa: Nije dostupno polaznicima. Ovaj modul ne može biti prikazan polaznicima.';
$string['modhide'] = 'Sakrij';
$string['modified'] = 'Izmenjeno';
$string['modshow'] = 'Prikaži';
$string['moduleintro'] = 'Opis';
$string['modulesetup'] = 'Podešavanje tabela modula';
$string['modulesuccess'] = '{$a} tabela je ispravno podešeno';
$string['modulesused'] = 'Korišćeni moduli';
$string['modvisible'] = 'Dostupnost';
$string['modvisible_help'] = '* Prikaži na stranici kursa: dostupno polaznicima (uz sva ograničenja pristupa koja se mogu podesiti).
* Sakrij na stranici kursa: nije dostupno polaznicima.';
$string['modvisiblehiddensection'] = 'Dostupnost';
$string['modvisiblehiddensection_help'] = '* Sakrij na stranici kursa: nije dostupno studentima.
* Učini dostupnim, ali ne prikazuj na stranici kursa: dostupno polaznicima ako postavite link. Aktivnosti će se i dalje pojavljivati u knjizi ocena i drugim izveštajima.';
$string['modvisiblewithstealth'] = 'Dostupnost';
$string['modvisiblewithstealth_help'] = '* Prikaži na stranici kursa: dostupno polaznicima (uz sva ograničenja pristupa koja se mogu podesiti).
* Sakrij na stranici kursa: nije dostupno polaznicima.
* Učini dostupnim, ali ne prikazuj na stranici kursa: dostupno polaznicima ako postavite link. Aktivnosti će se i dalje pojavljivati u knjizi ocena i drugim izveštajima.';
$string['month'] = 'Mesec';
$string['months'] = 'Meseci';
$string['moodledocs'] = 'Moodle dokumentacija';
$string['moodledocslink'] = 'Dokumentacija za ovu stranicu';
$string['moodlelogo'] = 'Moodle logo';
$string['moodlenet:cannotconnecttoserver'] = 'Nije moguće povezati se sa MoodleNet serverom';
$string['moodlenet:columnname'] = 'Naziv';
$string['moodlenet:columnsenddate'] = 'Datum slanja';
$string['moodlenet:columnsendstatus'] = 'Status slanja';
$string['moodlenet:columntype'] = 'Tip';
$string['moodlenet:configoauthservice'] = 'Izaberite MoodleNet OAuth 2 servis kako biste omogućili deljenje na tom MoodleNet sajtu. Ako servis još ne postoji, moraćete da ga <a href="{$a}">kreirate</a> it.';
$string['moodlenet:deletedactivity'] = 'Obrisana aktivnost';
$string['moodlenet:deletedcourse'] = 'Obrisan kurs';
$string['moodlenet:eventresourceexported'] = 'Resurs eksportovan';
$string['moodlenet:gotomoodlenet'] = 'Idite na radne verzije na MoodleNet platformi';
$string['moodlenet:issuerisnotauthorized'] = 'MoodleNet izdavač nije autorizovan';
$string['moodlenet:issuerisnotenabled'] = 'MoodleNet izdavač nije omogućen';
$string['moodlenet:issuerisnotset'] = 'MoodleNet izdavač nije podešen u administraciji sajta';
$string['moodlenet:nosharedresources'] = 'U ovom trenutku ne postoje deljeni resursi koji se mogu prikazti.';
$string['moodlenet:outboundsettings'] = 'MoodleNet odlazna podešavanja';
$string['moodlenet:packagingandsending'] = 'Pakovanje vaše datoteke i slanje na MoodleNet...';
$string['moodlenet:sharefailtext'] = 'Došlo je do greške prilikom deljenja vašeg sadržaja na MoodleNet platformi. <br>Pokušajte ponovo kasnije.';
$string['moodlenet:sharefailtextwithsitesupport'] = 'Došlo je do greške prilikom deljenja vašeg sadržaja na MoodleNet platformi. <br>Pokušajte ponovo kasnije ili <a href="{$a}">kontaktirajte podršku sajta</a>.';
$string['moodlenet:sharefailtitle'] = 'Nešto nije u redu';
$string['moodlenet:sharefilesizelimitexceeded'] = 'Veličina resursa koji se deli ({$a->filesize} bajtova) premašuje ograničenje od {$a->filesizelimit} bajtova.';
$string['moodlenet:sharenoticeactivity'] = 'Ova aktivnost je dostupna preko MoodleNet platforme kao resurs.';
$string['moodlenet:sharenoticecourse'] = 'Ovaj kurs je dostupan preko MoodleNet platforme kao resurs.';
$string['moodlenet:sharenoticepartial'] = 'Izabrane aktivnosti se dele na MoodleNet platformi kao resurs.';
$string['moodlenet:sharenoticepartialactivitynumber'] = 'Broj aktivnosti koji će biti uključene u kurs: {$a}.';
$string['moodlenet:shareprogress'] = 'Napredak deljenja na MoodleNet platformi';
$string['moodlenet:shareprogressinfo'] = 'Spisak prikazuje kurseve i aktivnosti koje ste podelili na MoodleNet platformi.<br>Kliknite na naziv resursa kako biste ga videli na MoodleNet platformi.';
$string['moodlenet:sharesuccesstext'] = 'Skoro ste gotovi! Posetite svoje radne verzije na MoodleNet platformi kako biste završili deljenje svog sadržaja.';
$string['moodlenet:sharesuccesstitle'] = 'Sačuvano kao radna verzija na MoodleNet platformi';
$string['moodlenet:sharetomoodlenet'] = 'Podelite na MoodleNet platformi';
$string['moodlenet:sharinglargefile'] = 'Slanje velikih datoteka može potrajati neko vreme.';
$string['moodlenet:sharingstatus'] = 'Deljenje na MoodleNet platformi';
$string['moodlenet:sharingto'] = 'Deljenje na:';
$string['moodlerelease'] = 'Moodle verzija';
$string['moodleservicesandsupport'] = 'Servisi i podrška';
$string['moodleversion'] = 'Moodle verzija';
$string['more'] = 'još';
$string['moreactions'] = 'Više akcija';
$string['morehelp'] = 'Više pomoći';
$string['morehelpaboutmodule'] = 'Dodatna pomoć o aktivnosti {$a}';
$string['moreinfo'] = 'Više informacija';
$string['moreinformation'] = 'Više informacija o ovoj grešci';
$string['moremenu'] = 'Više';
$string['morenavigationlinks'] = 'Više...';
$string['moreprofileinfoneeded'] = 'Molimo recite nam nešto više o sebi';
$string['mostrecently'] = 'najnovije';
$string['move'] = 'Premesti';
$string['movecategoriessuccess'] = 'Uspešno premešteno  {$a->count} kategorija/e u kategoriju \'{$a->to}\'';
$string['movecategoriestotopsuccess'] = 'Uspešno premešteno {$a->count} kategorija/e na najviši nivo';
$string['movecategorycontentto'] = 'Premesti u:';
$string['movecategorysuccess'] = 'Kategorije \'{$a->moved}\' je uspešno premeštena  u kategoriju \'{$a->to}\'';
$string['movecategoryto'] = 'Premesti kategoriju u:';
$string['movecategorytotopsuccess'] = 'Kategorije \'{$a->moved}\' je uspešno premeštena na najviši nivo';
$string['movecontent'] = 'Premesti {$a}';
$string['movecontentafter'] = 'Posle "{$a}"';
$string['movecontentstoanothercategory'] = 'Premesti sadržaj u drugu kategoriju';
$string['movecontenttothetop'] = 'Na vrh spisak';
$string['movecoursemodule'] = 'Premesti aktivnost';
$string['movecoursesection'] = 'Premesti sekciju';
$string['movecourseto'] = 'Premesti kurs u:';
$string['movedown'] = 'Premesti dole';
$string['movefilestohere'] = 'Premesti datoteke ovde';
$string['movefull'] = 'Premesti {$a} na ovu lokaciju';
$string['movehere'] = 'Premesti ovamo';
$string['moveitemdown'] = 'Premesti {$a} nadole';
$string['moveitemup'] = 'Premesti {$a} nagore';
$string['moveleft'] = 'Pomakni ulevo';
$string['moveright'] = 'Pomakni udesno';
$string['movesection'] = 'Premesti sekciju {$a}';
$string['moveselectedcategoriesto'] = 'Premesti izabrane kategorije u';
$string['moveselectedcoursesto'] = 'Premesti izabrane kurseve u...';
$string['movetoanotherfolder'] = 'Premesti u drugi direktorijum';
$string['moveup'] = 'Premesti gore';
$string['multipleitemsfound'] = 'Broj pronađenih stavki: {$a}';
$string['mustchangepassword'] = 'Nova lozinka mora biti različita od trenutne';
$string['mustconfirm'] = 'Morate potvrditi svoj nalog';
$string['mycourses'] = 'Moji kursevi';
$string['myfiles'] = 'Moje privatne datoteke';
$string['myfilesmanage'] = 'Upravljanje mojim privatnim datotekama';
$string['myhome'] = 'Kontrolni panel';
$string['mymoodledashboard'] = 'Moj Moodle kontrolni panel';
$string['myprofile'] = 'Moj profil';
$string['name'] = 'Ime';
$string['namedfiletoolarge'] = 'Datoteka \'{$a->filename}\' je prevelika i ne može biti otpremljena';
$string['nameforlink'] = 'Kako želite da nazovete ovaj link?';
$string['nameforpage'] = 'Naziv';
$string['navigation'] = 'Navigacija';
$string['needed'] = 'Potrebno';
$string['networkdropped'] = 'Otkrili smo da vaša interne veza nije pouzdana ili da je u prekidu.<br />
Molimo vas. imajte na umu da promene ne mogu da budu sačuvane onako kako je to potrebno sve dok se vaša veza ne popravi.';
$string['never'] = 'Nikad';
$string['neverdeletelogs'] = 'Nikada ne briši  zapise o aktivnostima';
$string['new'] = 'Novo';
$string['newaccount'] = 'Novi korisnički nalog';
$string['newactivityname'] = 'Novi naziv za aktivnost {$a}';
$string['newcourse'] = 'Novi kurs';
$string['newloginnotificationbodyfull'] = '<p>Poštovana/i, {$a->userfullname},</p>
<p>Vaš {$a->sitename} nalog je upravo upotrebljen za prijavu sa novog uređaja.</p>
<ul>
<li>Vaš nalog: {$a->username} {$a->useremail}</li>
<li>{$a->logintime}</li>
<li>Uređaj: {$a->logindevice}</li>
<li>IP adresa: {$a->loginip}</li>
</ul>
<p>Ako ste to bili vi, onda ne morate ništa da radite.</p>
<p>Ako ne prepoznajete ovu aktivnost, molim vas da <a href="{$a->changepasswordlink}">promenite svoju lozinku</a>.</p>';
$string['newloginnotificationbodysmall'] = 'Vaš {$a} nalog je upravo upotrebljen za prijavu sa novog uređaja.';
$string['newloginnotificationtitle'] = 'Nova prijava na {$a} sa vašim nalogom';
$string['newpassword'] = 'Nova lozinka';
$string['newpassword_help'] = 'Unesite novu lozinku ili ostavite polje prazno kako biste zadržali tekuću lozinku.';
$string['newpasswordfromlost'] = '<strong>OBAVEŠTENJE:</strong> Vaša <strong>trenutna lozinka</strong> biće vam poslata u <strong>drugoj</strong> od dve poruke poslate u toku postupka za ponovno dobijanje izgubljene lozinke. Proverite da li ste primili zamenu lozinke pre nego što nastavite sa ovim ekranom.';
$string['newpasswordtext'] = 'Poštovana/i {$a->firstname},

Lozinka vašeg naloga na sajtu \'{$a->sitename}\' je resetovana i dodeljena vam je nova privremena lozinka.

Vaši trenutni podaci za pristup sistemu su:
   korisničko ime: {$a->username}
   lozinka: {$a->newpassword}

Molimo vas da posetite ovu stranicu kako biste promenili svoju lozinku:
   {$a->link}

U većini programa za elektronsku poštu, ovo bi trebalo da se pojavi kao plavo obojeni link na koji je potrebno samo kliknuti. Ako ta opcija ne funkcioniše, kopirajte navedenu adresu u adresnu liniju na vrhu prozora vašeg veb čitača.

Pozdrav,
\'{$a->sitename}\' administrator,
{$a->signoff}';
$string['newpicture'] = 'Nova slika';
$string['newpicture_help'] = 'Da biste dodali novu sliku, pronađite i odaberite jednu (u JPG ili PNG formatu) i kliknite na "Ažuriraj profil". Slika će biti isečena u obliku kvadrata a njena veličina smanjena na 100x100 piksela.';
$string['newpictureusernotsetup'] = 'Slika se može dodati na stranicu profila tek kada su sačuvane sve neophodne informacije u profilu korisnika.';
$string['newsectionname'] = 'Novi naziv za sekciju {$a}';
$string['newsitem'] = 'vest';
$string['newsitems'] = 'obaveštenja';
$string['newsitemsnumber'] = 'Broj obaveštenja';
$string['newsitemsnumber_help'] = 'Standardno , svi učesnici kursa su pretplaćeni na forum. Samo predavači i korisnici sa odgovarajućim ovlašćenjima mogu da objavljuju poruke na ovom forumu.

Ako vam forum \'Obaveštenja\' nije potreban, postavite ovo podešavanje na nulu.

Ovo podešavanje određuje koliko će se skorašnjih obaveštenja pojaviti u bloku \'Najnovija obaveštenja\'.';
$string['newuser'] = 'Novi korisnik';
$string['newusernewpasswordsubj'] = 'Novi korisnički nalog';
$string['newusernewpasswordtext'] = 'Poštovana/i {$a->firstname},

Otvoren vam je novi korisnički nalog na sajtu \'{$a->sitename}\'.

     korisničko ime: {$a->username}
     lozinka: {$a->newpassword}

(Moraćete da promenite lozinku kada se prvi put prijavite na sistem)

Da biste počeli da koristite sajt \'{$a->sitename}\', prijavite se na {$a->link}

Ako vam je potrebna pomoć, možete kontaktirati administratora sajta,
{$a->admin}';
$string['newusers'] = 'Novi korisnici';
$string['newwindow'] = 'Novi prozor';
$string['next'] = 'Sledeći';
$string['nextpage'] = 'Sledeća stranica';
$string['nextsection'] = 'Sledeća sekcija';
$string['no'] = 'Ne';
$string['noblockstoaddhere'] = 'Ne postoje blokovi koje možete dodati ovoj stranici.';
$string['nobody'] = 'Niko';
$string['nochange'] = 'Bez promena';
$string['nocomments'] = 'Nema komentara';
$string['nocourses'] = 'Nema kursreva';
$string['nocoursesfound'] = 'Nijedan kurs ne sadrži pojam \'{$a}\'';
$string['nocoursestarttime'] = 'Kurs nema datum početka.';
$string['nocoursesyet'] = 'Nema kurseva u ovoj kategoriji';
$string['nodstpresets'] = 'Administrator sistema nije omogućio podršku za Daylight Savings Time.';
$string['nofilesselected'] = 'Nije izabrana nijedna datoteka za restauriranje.';
$string['nofilesyet'] = 'Unutar ovog kursa još nije postavljena nijedna datoteka';
$string['nofiltersapplied'] = 'Nijedan filter nije primenjen';
$string['nograde'] = 'Nema ocene';
$string['nohelpforactivityorresource'] = 'Trenutno ne postoji pomoć vezana za ovaj resurs ili aktivnost';
$string['noimagesyet'] = 'Unutar ovog kursa još nije postavljena nijedna slika';
$string['noitemsfound'] = 'Nije pronađena nijedna stavka.';
$string['nologsfound'] = 'Nije pronađen nijedan zapis';
$string['nomatchingusers'] = 'Nijedan korisnik se ne poklapa sa \'{$a}\'';
$string['nomorecourses'] = 'Nije pronađeno više kurseva koji se uklapaju sa zadatim kriterijumima';
$string['nomoreidnumber'] = 'Ne koristi se idnumber da bi se izbegle kolizije';
$string['none'] = 'Nijedan';
$string['noneditingteacher'] = 'Predavač bez uređivačkih prava';
$string['noneditingteacherdescription'] = 'Predavači bez uređivačkih prava mogu da predaju na kursevima i ocenjuju polaznike, ali ne mogu da menjaju aktivnosti.';
$string['nonstandard'] = 'Nestandardno';
$string['nopendingcourses'] = 'Nema kurseva koji čekaju na odobrenje';
$string['nopotentialadmins'] = 'Nema potencijalnih administratora';
$string['nopotentialcreators'] = 'Nema potencijalnih kreatora kursa';
$string['nopotentialstudents'] = 'Nema potencijalnih polaznika';
$string['nopotentialteachers'] = 'Nema potencijalnih predavača';
$string['norecentactivity'] = 'Nema nedavnih aktivnosti';
$string['noreplybouncemessage'] = 'Odgovorili ste na adresu elektronske pošte sa koje se poruke samo šalju (no-reply email address). Ako ste pokušavali da odgovorite na poruku sa foruma, molimo da to učinite direktno koristeći {$a} forume.

Sledi sadržaj vaše poruke:';
$string['noreplybouncesubject'] = '{$a} - vraćena e-poruka.';
$string['noreplyname'] = 'Nemojte odgovarati na ovu e-poruku';
$string['noresetrecord'] = 'Ne postoji zapis o ovom zahtevu za promenu lozinke. Molimo vas da pokrenete nov zahtev za promenu lozinke.';
$string['noresults'] = 'Nema rezultata';
$string['noresultsfor'] = 'Nema rezultata za "{$a}"';
$string['normal'] = 'Normalno';
$string['normalfilter'] = 'Normalna pretraga';
$string['nosite'] = 'Nije pronađen kurs na nivou sajta';
$string['nostudentsfound'] = '{$a} - nije pronađeno';
$string['nostudentsingroup'] = 'Još nema polaznika u ovoj grupi';
$string['nostudentsyet'] = 'Na ovom kursu nema upisanih polaznika.';
$string['nosuchemail'] = 'Nema takve adrese e-pošte';
$string['notavailable'] = 'Nije dostupno';
$string['notavailablecourse'] = 'Sekcija {$a} nije dostupna';
$string['noteachersyet'] = 'Još uvek nema predavača na ovom kursu';
$string['noteachingupcomingcourses'] = 'Predstojeći kursevi nemaju predavače ili polaznike';
$string['notenrolled'] = '{$a} nije upisan/a na ovaj kurs.';
$string['notenrolledprofile'] = 'Ovaj profil nije dostupan jer korisnik nije prijavljen za ovaj kurs.';
$string['noteusercannotrolldatesoncontext'] = '<strong>Napomena:</strong> Mogućnost menjanja datuma prilikom obnavljanja ove rezervne kopije je onemogućena jer nemate potrebna ovlašćenja.';
$string['noteuserschangednonetocourse'] = 'Napomena: Kada restaurirate korisničke podatke (u aktivnostima, datotekama ili porukama) morate da restaurirate i korisnike kursa. Ovo podešavanje je promenjeno za vas.';
$string['nothingnew'] = 'Nema skorašnjih aktivnosti';
$string['nothingtodisplay'] = 'Nema ničega za prikaz';
$string['notice'] = 'Napomena';
$string['noticenewerbackup'] = 'Ova datoteka rezervne kopije je napravljena pomoću Moodle verzije {$a->backuprelease} ({$a->backupversion}) i novija je od vaše trenutno instalirane verzije Moodlea {$a->serverrelease} ({$a->serverversion}). Ovo bi moglo da  dovede do određenih nedoslednosti zbog toga što ne može da se garantuje kompatibilnost datoteka rezervnih kopija koje su kreirane pomoću novijih verzija Moodlea.';
$string['notifications'] = 'Obaveštenja';
$string['notifyloginfailuresmessage'] = '{$a->time}, IP: {$a->ip}, Korisnik: {$a->info}, Puno ime korisnika: {$a->name}';
$string['notifyloginfailuresmessageend'] = 'Ove zapise možete videti na {$a}';
$string['notifyloginfailuresmessagestart'] = 'Ovo je spisak grešaka pri pristupu sistemu na {$a} od poslednjeg obaveštenja koje ste primili';
$string['notifyloginfailuressubject'] = '{$a} :: Obaveštenje o greškama pri pristupu sistemu';
$string['notincluded'] = 'Nije uključeno';
$string['notingroup'] = 'Nažalost, morate biti član grupe kako biste videli ovu stranicu.';
$string['notpublic'] = 'Nije javno!';
$string['nousersfound'] = 'Nije pronađen nijedan korisnik';
$string['nousersmatching'] = 'Nije pronađen nijedan korisnik koji se podudara sa \'{$a}\'';
$string['nousersyet'] = 'Još nema korisnika';
$string['novalidcourses'] = 'Nema važećih kurseva koji bi bili prikazani';
$string['now'] = 'sada';
$string['numattempts'] = 'Broj neuspešnih pokušaja pristupa sistemu: {$a}';
$string['numberofcourses'] = 'Broj kurseva';
$string['numberweeks'] = 'Broj sekcija';
$string['numday'] = '{$a} dan';
$string['numdays'] = '{$a} dan(a)';
$string['numhours'] = '{$a} h';
$string['numletters'] = '??? slovo(a)';
$string['numminutes'] = '{$a} min';
$string['nummonth'] = '{$a} mesec';
$string['nummonths'] = '{$a} mesec(a)';
$string['numseconds'] = '{$a} s';
$string['numviews'] = '{$a} pregled(a)';
$string['numweek'] = '{$a} nedelja';
$string['numweeks'] = '{$a} sedmica/e';
$string['numwords'] = '{$a} reč(i)';
$string['numyear'] = '{$a} godina';
$string['numyears'] = '{$a} godina(e)';
$string['ok'] = 'OK';
$string['oldpassword'] = 'Trenutna lozinka';
$string['olduserdirectory'] = 'Ovo je STARI korisnički direktorijum koji više nije potreban. Možete ga slobodno obrisati. Datoteke iz ovog direktorijuma su kopirane u NOVI korisnički direktorijum.';
$string['oneitemfound'] = 'Pronađena je 1 stavka.';
$string['opendrawerblocks'] = 'Otvori fioku sa blokovima';
$string['opendrawerindex'] = 'Otvori fioku sa indeksom kursa';
$string['opensinnewwindow'] = 'Otvara se u novom prozoru';
$string['opensinnewwindowbracketed'] = '(Otvara se u novom prozoru)';
$string['operator_and'] = 'i';
$string['operator_andnot'] = 'i';
$string['operator_or'] = 'ili';
$string['optional'] = 'opciono';
$string['options'] = 'opcije';
$string['order'] = 'Poredak';
$string['originalpath'] = 'Originalna putanja';
$string['orphanedactivitiesinsectionno'] = 'Aktivnosti siročići (sekcija {$a})';
$string['other'] = 'Ostali';
$string['outline'] = 'Kratak pregled';
$string['outlinereport'] = 'Skraćeni izveštaj';
$string['page'] = 'Stranica';
$string['pagea'] = 'Stranica {$a}';
$string['pagedcontentnavigation'] = 'Navigacija numerisanih stranica';
$string['pagedcontentnavigationactiveitem'] = 'Tekuća stranica, stranica {$a}';
$string['pagedcontentnavigationitem'] = 'Idi na stranicu {$a}';
$string['pagedcontentpagingbaritemsperpage'] = 'Broj stavki prikazanih po stranici: {$a}';
$string['pageheaderconfigablock'] = 'Konfigurisanje bloka u {$a->fullname}';
$string['pagepath'] = 'Putanja do stranice';
$string['pageshouldredirect'] = 'Ova stranica bi trebalo da vas automatski preusmeri. Ukoliko se ništa ne događa molimo vas da za nastavak upotrebite donji link.';
$string['parentcategory'] = 'Nadređena kategorija';
$string['parentcoursenotfound'] = 'Nadređeni kurs nije pronađen!';
$string['parentfolder'] = 'Nadređeni direktorijum';
$string['participants'] = 'Učesnici';
$string['participantslist'] = 'Spisak učesnika';
$string['participationratio'] = 'Odnos učešća';
$string['participationreport'] = 'Izveštaj o učešću';
$string['password'] = 'Lozinka';
$string['passwordchanged'] = 'Lozinka je promenjena';
$string['passwordextlink'] = 'Sledeći link Vam je na raspolaganju za oporavak Vaše izgubljene lozinke. Klik na njega će Vas izvesti iz Moodle sistema.';
$string['passwordforgotten'] = 'Zaboravljena lozinka';
$string['passwordforgotteninstructions'] = 'Vaši podaci prvo moraju biti pronađeni u bazi podataka korisnika. Molimo unesite <strong>ili</strong> svoje korisničko ime ili prijavljenu elektronsku adresu u odgovarajuće polje. Nema potrebe da unosite oba podatka.';
$string['passwordforgotteninstructions2'] = 'Za resetovanje vaše lozinke upišite svoje korisničko ime ili elektronsku adresu. Ukoliko ti podaci postoje u bazi podataka, biće vam poslata poruka na elektronsku adresu sa uputstvom kako ponovo da dobijete pristup.';
$string['passwordpolicynomatch'] = 'Vaša trenutna lozinka se više ne podudara sa sa postojećim pravilima za kreiranje lozinke.
   {$a}';
$string['passwordsdiffer'] = 'Lozinke se ne poklapaju';
$string['passwordset'] = 'Vaša lozinka je podešena.';
$string['path'] = 'Putanja';
$string['pathnotexists'] = 'Putanja ne postoji na Vašem serveru!';
$string['pathslasherror'] = 'Putanja se ne može završavati kosom crtom.';
$string['paymentinstant'] = 'Upotrebite dugme ispod kako biste izvršili uplatu i upisali kurs u roku od nekoliko minuta.';
$string['paymentpending'] = '(<small><b><u>{$a}</u></b> na čekanju</small>)';
$string['paymentrequired'] = 'Ovaj kurs zahteva uplatu za upis';
$string['payments'] = 'Uplate';
$string['paymentsorry'] = 'Hvala vam na uplati! Kada, vaša uplata bude obrađena moći ćete da se prijavite na kurs {$a->fullname}. Molimo vas, sačekajte a onda pokušajte ponovo. Ako i dalje budete imali problema, onda obavestite predavača {$a->teacher} ili administratora sajta.';
$string['paymentthanks'] = 'Hvala Vam na Vašoj uplati! Sada ste upisani na kurs {$a}.';
$string['pendingrequests'] = 'Zahtevi na čekanju';
$string['percents'] = '{$a}%';
$string['periodending'] = 'Završetak perioda ({$a})';
$string['perpage'] = 'Po stranici';
$string['perpagea'] = 'Po stranici: {$a}';
$string['personal'] = 'Lično';
$string['personalprofile'] = 'Lični profil';
$string['phone'] = 'Telefon';
$string['phone1'] = 'Telefon';
$string['phone2'] = 'mobilni telefon';
$string['phpinfo'] = 'PHP informacije';
$string['picture'] = 'Slika';
$string['pictureof'] = 'Slika {$a}';
$string['pictureofuser'] = 'Slika korisnika';
$string['placeholdertypeorselect'] = 'Unesi ili izaberi...';
$string['pleaseclose'] = 'Molim Vas zatvorite sada ovaj prozor.';
$string['pleasesearchmore'] = 'Nastavite pretragu';
$string['pleaseusesearch'] = 'Upotrebite pretragu';
$string['plugin'] = 'Dodatak';
$string['pluginarea'] = 'Oblast';
$string['plugincheck'] = 'Provera dodataka';
$string['plugindeletefiles'] = 'Svi podaci povezani sa dodatkom: \'{$a->name}\' su obrisani iz baze podataka. Da biste sprečili automatsku reinstalaciju dodatka,  potrebno je da sada sa servera obrišete ovaj direktorijum: {$a->directory}';
$string['pluginitemid'] = 'ID oznaka stavke';
$string['pluginmissingfromdisk'] = '{$a->name} (nedostaje na disku)';
$string['pluginsetup'] = 'Podešavanje tabele dodataka';
$string['policyaccept'] = 'Razumem i pristajem';
$string['policyagree'] = 'Da bi ste nastavili korišćenje ovog sajta morate se složiti sa pravilima korišćenja. Da li se slažete?';
$string['policyagreement'] = 'Saglasnost sa pravilnikom o korišćenju sajta';
$string['policyagreementclick'] = 'Pravilnik o korišćenju sajta';
$string['popup'] = 'iskačući prozor';
$string['popupwindow'] = 'Otvori datoteku u novom prozoru';
$string['popupwindowname'] = 'Iskačući prozor';
$string['post'] = 'Poruka';
$string['posts'] = 'Poruke';
$string['potentialadmins'] = 'Potencijalni administratori';
$string['potentialcreators'] = 'Potencijalni kreatori kursa';
$string['potentialstudents'] = 'Potencijalni polaznici';
$string['potentialteachers'] = 'Potencijalni predavači';
$string['poweredbymoodle'] = 'Ovaj portal pokreće <a href="https://moodle.com">Moodle</a>';
$string['preferences'] = 'Parametri';
$string['preferredlanguage'] = 'Preferirani jezik';
$string['preferredtheme'] = 'Preferirana grafička tema';
$string['preprocessingbackupfile'] = 'Prethodna obrada datoteke rezervne kopije';
$string['prev'] = 'Prethodno';
$string['preview'] = 'Pregled';
$string['previeworchoose'] = 'Pregledaj ili izaberi grafičku temu';
$string['previewthemename'] = 'Pregled teme \'{$a}\'';
$string['previous'] = 'Prethodni';
$string['previouslyselectedusers'] = 'Prethodno izabrani korisnici se ne poklapaju sa \'{$a}\'';
$string['previouspage'] = 'Prethodna stranica';
$string['previoussection'] = 'Prethodna sekcija';
$string['primaryadminsetup'] = 'Podesi nalog administratora';
$string['privacy:metadata:config_log'] = 'Zapis o izmenama konfiguracije.';
$string['privacy:metadata:config_log:name'] = 'Naziv izmena podešavanja.';
$string['privacy:metadata:config_log:oldvalue'] = 'Prethodna vrednost za ovo podešavanje.';
$string['privacy:metadata:config_log:plugin'] = 'Dodatak je izmenjen.';
$string['privacy:metadata:config_log:timemodified'] = 'Vreme kada je došlo do promene.';
$string['privacy:metadata:config_log:userid'] = 'Korisnik koji je napravio promenu.';
$string['privacy:metadata:config_log:value'] = 'Nova vrednost za ovo podešavanje.';
$string['privacy:metadata:events_queue'] = 'Korisnički događaji koji čekaju da budu obrađeni.';
$string['privacy:metadata:events_queue:eventdata'] = 'Podaci koji se čuvaju u događaju.';
$string['privacy:metadata:events_queue:stackdump'] = 'Sva stanja steka povezana sa ovim događajem.';
$string['privacy:metadata:events_queue:timecreated'] = 'Vreme kada je ovaj događaj kreiran.';
$string['privacy:metadata:events_queue:userid'] = 'Korisnička ID oznaka povezana sa ovim događajem';
$string['privacy:metadata:log'] = 'Kolekcija proteklih događaja';
$string['privacy:metadata:log:action'] = 'Opis akcije';
$string['privacy:metadata:log:cmid'] = 'cmid';
$string['privacy:metadata:log:course'] = 'kurs';
$string['privacy:metadata:log:info'] = 'Dodatne informacije';
$string['privacy:metadata:log:ip'] = 'IP adresa korišćena u vreme događaja';
$string['privacy:metadata:log:module'] = 'modul';
$string['privacy:metadata:log:time'] = 'Vreme kada je akcija izvršena';
$string['privacy:metadata:log:url'] = 'URL adresa vezana za događaj';
$string['privacy:metadata:log:userid'] = 'ID oznaka korisnika koji je izvršio akciju';
$string['privacy:metadata:moodlenet_share_progress'] = 'Detaljnije informacije MoodleNet platforme o napretku deljenja';
$string['privacy:metadata:moodlenet_share_progress:cmid'] = 'Pridružena ID oznaka modula';
$string['privacy:metadata:moodlenet_share_progress:courseid'] = 'Pridružena ID oznaka kursa';
$string['privacy:metadata:moodlenet_share_progress:resourceurl'] = 'Povratna URL adresa koju je poslao MoodleNet nakon uspešnog deljenja';
$string['privacy:metadata:moodlenet_share_progress:status'] = 'Rezultujući status deljenja';
$string['privacy:metadata:moodlenet_share_progress:timecreated'] = 'Vreme kada je deljenje izvršeno';
$string['privacy:metadata:moodlenet_share_progress:type'] = 'Tip deljenja koji je izvršen';
$string['privacy:metadata:moodlenet_share_progress:userid'] = 'Korisnik koji je izvršio deljenje';
$string['privacy:metadata:oauth2_refresh_token'] = 'Osveži token koji se koristi u OAuth 2.0 komunikaciji';
$string['privacy:metadata:oauth2_refresh_token:issuerid'] = 'ID oznaka davaoca identiteta kome token odgovara';
$string['privacy:metadata:oauth2_refresh_token:scopehash'] = 'ID oznaka korisnika kome token odgovara';
$string['privacy:metadata:oauth2_refresh_token:timecreated'] = 'Vreme kada je token kreiran';
$string['privacy:metadata:oauth2_refresh_token:timemodified'] = 'Vreme kada je token ažuriran';
$string['privacy:metadata:oauth2_refresh_token:token'] = 'Token osvežavanja za odgovarajući opseg i korisnika';
$string['privacy:metadata:oauth2_refresh_token:userid'] = 'ID korisnika kojem token odgovara';
$string['privacy:metadata:task_adhoc'] = 'Status ad hok zadataka.';
$string['privacy:metadata:task_adhoc:component'] = 'Komponenta koja poseduje zadatak.';
$string['privacy:metadata:task_adhoc:nextruntime'] = 'Najranije vreme za pokretanje ovog zadatka.';
$string['privacy:metadata:task_adhoc:userid'] = 'Korisnik koji pokreće zadatak.';
$string['privacy:metadata:task_log'] = 'Ispis za zapis';
$string['privacy:metadata:task_log:component'] = 'Komponenta koja poseduje zadatak.';
$string['privacy:metadata:task_log:userid'] = 'Korisnik kom je zadatak pripadao.';
$string['privacy:metadata:upgrade_log'] = 'Zapis o nadogradnji.';
$string['privacy:metadata:upgrade_log:backtrace'] = 'Spisak svih funkcija povezanih sa ovim korakom nadogradnje.';
$string['privacy:metadata:upgrade_log:details'] = 'Dodatne informacije u vezi sa nadogradnjom.';
$string['privacy:metadata:upgrade_log:info'] = 'Glavne informacije za ovaj korak nadogradnje.';
$string['privacy:metadata:upgrade_log:plugin'] = 'Dodatak koji je nadograđen.';
$string['privacy:metadata:upgrade_log:targetversion'] = 'Nova verzija za nadogradnju.';
$string['privacy:metadata:upgrade_log:timemodified'] = 'Vreme kada se nadogradnja odigrala.';
$string['privacy:metadata:upgrade_log:type'] = 'Tip stavke u zapisu.';
$string['privacy:metadata:upgrade_log:userid'] = 'Korisnik koji je pokrenuo nadogradnju';
$string['privacy:metadata:upgrade_log:version'] = 'Stara verzija dodatka';
$string['private_files_handler'] = 'Smestite priloge uz e-poruku u prostor za privatne datoteke korisnika.';
$string['private_files_handler_name'] = 'Pošalji e-poštom u privatne datoteke';
$string['privatefiles'] = 'Privatne datoteke';
$string['privatefilesmanage'] = 'Upravljanje privatnim datotekama';
$string['proceed'] = 'Nastavite';
$string['profile'] = 'Profil';
$string['profilenotshown'] = 'Ovaj opis korisničkog profila neće biti prikazan sve dok se korisnik ne upiše barem na jedan kurs.';
$string['progress'] = 'Napredak';
$string['publicprofile'] = 'Javni profil';
$string['publicsitefileswarning'] = 'Napomena: Datotekama koje su ovde smeštene svi mogu pristupiti.';
$string['publicsitefileswarning2'] = 'Napomena: Datotekam koje su ovde smeštene može da pristupi svako ko zna (ili pogodi) URL. Iz razloga bezbednosti, preporučuje se brisanje datoteka rezervne kopije odmah nakon nakon zavšetka njihovog restauriranja.';
$string['publicsitefileswarning3'] = 'Napomena: Datotekama koje su ovde postavljene može da pristupi svako ko zna (ili može da pogodi) URL.<br /> Iz razloga bezbednosti, datoteke rezervne kopije bi trebalo da budu čuvane samo u zato predviđenom direktorijumu (backupdata).';
$string['question'] = 'Pitanje';
$string['questionsinthequestionbank'] = 'Pitanja u banci pitanja';
$string['queued'] = 'Na čekanju';
$string['quotausage'] = 'Trenutno koristite {$a->used} od maksimalno dozvoljenih {$a->total}.';
$string['readinginfofrombackup'] = 'Učitavanje informacija iz rezervne kopije';
$string['readme'] = 'Pročitaj me';
$string['recentactivity'] = 'Nedavna aktivnost';
$string['recentactivityreport'] = 'Potpuni izveštaj o nedavnim aktivnostima...';
$string['recipientslist'] = 'Spisak primalaca';
$string['recommended'] = 'Preporučeno';
$string['recreatedcategory'] = 'Ponovno kreirana kategorija {$a}';
$string['redirect'] = 'Preusmeri';
$string['reducesections'] = 'Smanji broj sekcija';
$string['refresh'] = 'Osveži';
$string['refreshingevents'] = 'Osvežavanje događaja';
$string['registration'] = 'Moodle registracija.';
$string['registrationcontact'] = 'Javni kontakt';
$string['registrationcontactno'] = 'Ne, ne želim da me kontaktiraju drugi ljudi';
$string['registrationcontactyes'] = 'Da, prikažite obrazac kako bi drugi Moodle korisnici mogli da me kontaktiraju';
$string['registrationemail'] = 'Obaveštenja putem e-pošte';
$string['registrationinfo'] = '<p>Ova strana vam omogućava da registrujete svoj Moodle sajt na moodle.org. Registracija je besplatna.
Glavna korist registracije je u tome što ćete biti dodati na ograničenu mejling listu za primanje važnih obaveštenja, kao što su sigurnosna upozorenja i nova izdanja Moodlea.</p>
<p>Standardno, vaši podaci će se čuvati kao poverljivi, i nikada neće biti prodati ili prosleđeni nekom drugom. Jedini razlog za prikupljanje ovih informacija jeste podrška, kao i pomoći u formiranju statističke slike o celokupnoj Moodle zajednici.</p>
<p>Ako izaberete, možete dozvoliti da ime vašeg sajta, država i URL adrsa budu dodati na javnu listu Moodle sajtova.</p>
<p>Sve nove registracije se ručno proveravaju pre dodavanja na listu.
Kad se jednom nađete na listi, možete ažurirati svoju registraciju (i svoje podatke na javnoj listi) u bilo kom trenutku, tako što ćete ponovo poslati ovaj obrazac.</p>';
$string['registrationinfotitle'] = 'Informacije o registraciji';
$string['registrationsend'] = 'Slanje registracionih informacija na moodle.org';
$string['registrationyes'] = 'Da, obavestite me o novim Moodle izdanjima, bezbednosnim upozorenjima i drugim važnim vestima';
$string['reject'] = 'Odbaci';
$string['rejectdots'] = 'Odbaci';
$string['relativedatesmode'] = 'Režim relativnih datuma';
$string['relativedatesmode_help'] = 'Prikaži datume kursa ili aktivnosti relativno u odnosu na datum početka korisnikovog učešća u kursu.

Taj datum će biti datum početka upisa korisnika, ukoliko nije upisan pre nego što je kurs počeo, u kom slučaju će se za njegov datum početka uzeti datum početka kursa.

UPOZORENJE: Ovo je eksperimentalno podešavanje i moguće je da ga još ne podržavaju sve aktivnosti. Jednom kada se kreira kurs ovo podešavanje kursa više ne može da se menja.';
$string['relativedatesmode_warning'] = '<strong>Upozorenje:</strong> Režim relativnih datuma ne može da se promeni nakon kreiranja kursa.';
$string['reload'] = 'Učitaj ponovo';
$string['remoteappuser'] = 'Udaljeni korisnik {$a}';
$string['remove'] = 'Ukloni';
$string['removeadmin'] = 'Ukloni administratora';
$string['removecreator'] = 'Ukloni kreatora kursa';
$string['removed'] = 'Uklonjeno {$a}';
$string['removestudent'] = 'Ukloni polaznika';
$string['removeteacher'] = 'Ukloni predavača';
$string['rename'] = 'Preimenuj';
$string['renamefileto'] = 'Preimenuj<b>{$a}</b> u';
$string['report'] = 'Izveštaj';
$string['reports'] = 'Izveštaji';
$string['reporttype'] = 'Tip izveštaja';
$string['repositories'] = 'Repozitorijum';
$string['requestcourse'] = 'Zahtevaj kurs';
$string['requestedby'] = 'Zahtevan od strane';
$string['requestedcourses'] = 'Zahtevani kursevi';
$string['requestreason'] = 'Razlog za pokretanje novog kursa';
$string['requests'] = 'Zahtevi';
$string['required'] = 'Obavezno';
$string['requirespayment'] = 'Ovaj kurs zahteva plaćanje za pristup';
$string['resendemail'] = 'Pošalji ponovo e-poruku za potvrdu';
$string['reset'] = 'Resetovanje';
$string['resetcomponent'] = 'Komponenta';
$string['resetcourse'] = 'Resetovanje kursa';
$string['resetcourseconfirm'] = 'Resetujte kurs?';
$string['resetcoursewarning'] = 'Da li ste sigurni da želite da resetujete kurs \'{$a}\'?
<br/><br/>
Ovo će obrisati izabrane podatke i vratiti kurs u prvobitno stanje. Ovu radnju ne možete opozvati.';
$string['resetinfo'] = 'Ova funkcija vam omogućava da obrišete sve korisničke podatke i vratite kurs u prvobitno stanje. Aktivnosti i podešavanja kursa će ostati netaknuti.';
$string['resetinfoselect'] = 'Izaberite podatke koje želite da izbrišete ili resetujete iz kategorija u nastavku:';
$string['resetnotimplemented'] = 'Resetovanje nije podržano';
$string['resetnotimplementedinfo'] = 'Ove aktivnosti se ne mogu resetovati:';
$string['resetrecordexpired'] = 'Link za promenu lozinke koji ste koristi je istekao jer je stariji od {$a} minuta. Molimo vas da ponovo pokrenete zahtev za promenu lozinku.';
$string['resetstartdate'] = 'Resetuj datuma početka';
$string['resetstatus'] = 'Status';
$string['resettable'] = 'Resetuj parametre tabele';
$string['resettask'] = 'Resetuj';
$string['resettodefaults'] = 'Vraćanje na podrazumevane vrednosti';
$string['resortcourses'] = 'Sortiraj kurseve';
$string['resortsubcategoriesby'] = 'Sortiraj potkategorije rastućim redosledom koristeći kao kriterijum {$a}';
$string['resortsubcategoriesbyreverse'] = 'Sortiraj potkategorije opadajućim redosledom koristeći kao kriterijum {$a}';
$string['resource'] = 'Resurs';
$string['resource_type'] = 'Tip resursa';
$string['resourcedisplayauto'] = 'Automatski';
$string['resourcedisplaydownload'] = 'Obavezno preuzimanje';
$string['resourcedisplayembed'] = 'Ugradi (Embed)';
$string['resourcedisplayframe'] = 'U okviru (frame)';
$string['resourcedisplaynew'] = 'Novi prozor';
$string['resourcedisplayopen'] = 'Otvori';
$string['resourcedisplaypopup'] = 'U iskačućem prozoru';
$string['resources'] = 'Resursi';
$string['resources_help'] = 'Resursi omogućavaju dodavanje bilo koje vrste Web sadržaja na Vaš kurs.';
$string['restore'] = 'Restauriranje rezervne kopije';
$string['restorecancelled'] = 'Restauriranje je otkazano';
$string['restorecannotassignroles'] = 'Procedura obnavljanja rezervne kopije podataka mora da dodeli uloge, a Vi nemate ovlašćenje za to';
$string['restorecannotcreateorassignroles'] = 'Procedura obnavljanja rezervne kopije podataka mora da kreira ili dodeli uloge, a Vi nemate ovlašćenje za to';
$string['restorecannotcreateuser'] = 'Procedura obnavljanja rezervne kopije podataka mora da kreira korisnika \'{$a}\', a Vi nemate ovlašćenje za to';
$string['restorecannotoverrideperms'] = 'Procedura obnavljanja rezervne kopije podataka mora da izmeni ovlašćenja, a Vi nemate ovlašćenje za to';
$string['restorecoursenow'] = 'Restaurirajte ovaj kurs sada!';
$string['restoredaccount'] = 'Obnovljeni korisnički nalog';
$string['restoredaccountinfo'] = 'Ovaj korisnički nalog je uvezen sa drugog servera i lozinka je izgubljena. Kako biste zadali novu lozinku pomoću e-pošte, kliknite na "Nastavi"';
$string['restorefinished'] = 'Restauriranje je uspešno završeno';
$string['restoreinfo'] = 'Upotrebite datoteku rezervne kopije kako biste restaurirali prethodnu verziju kursa ili kako biste kreirali novi kurs.';
$string['restoremnethostidmismatch'] = 'Identifikator korisnika \'{$a}\' na MNet domaćinu se ne slaže sa identifikatorom na lokalnom MNet domaćinu.';
$string['restoreto'] = 'Restauriraj u';
$string['restoretositeadding'] = 'Upozorenje! Želite da restaurirate rezervnu kopiju na naslovnu stranicu sajta, tako što ćete postojećem pridodati novi sadržaj!';
$string['restoretositedeleting'] = 'Upozorenje! Želite da restaurirate rezervnu kopiju na naslovnu stranicu sajta, tako što ćete prvo obrisati postojeći sadržaj sa nje!';
$string['restoreuserconflict'] = 'Pokušaj restauriranja korisnika \'{$a}\' iz rzervene kopije podataka će prouzrokovati konflikt';
$string['restoreuserinfofailed'] = 'Proces restauriranja podataka je zaustavljen jer nemate ovlašćenja za restauriranje korisničkih podataka.';
$string['restoreusersprecheck'] = 'Provera korisničkih podataka';
$string['restoreusersprecheckerror'] = 'Uočeni su određeni problemi prilikom provere korisničkih podataka';
$string['restricted'] = 'Ograničeno';
$string['resultsfound'] = 'Pronađeno rezultata: {$a}';
$string['retry'] = 'Pokušaj ponovo';
$string['returningtosite'] = 'Već posedujete korisnički nalog?';
$string['returntooriginaluser'] = 'Vrati se na {$a}';
$string['revert'] = 'Vratite se nazad';
$string['role'] = 'Uloga';
$string['roleassignments'] = 'Dodela uloge';
$string['rolemappings'] = 'Mapiranja uloga';
$string['rolerenaming'] = 'Preimenovanje uloge';
$string['rolerenaming_help'] = 'Promenite prikaz naziva uloga koje se koriste na ovom kursu.';
$string['rolerenaming_success'] = 'Nazivi uloga na kursu ažurirani.';
$string['roles'] = 'Uloge';
$string['rss'] = 'RSS';
$string['rssarticles'] = 'Broj novih RSS članaka';
$string['rsserror'] = 'Greška prilikom čitanja RSS podataka';
$string['rsserrorauth'] = 'RSS link ne sadrži ispravan token za proveru identiteta.';
$string['rsserrorguest'] = 'Ovaj RSS izvor vesti koristi anonimni  (kao gost) pristup podacima, ali gosti ovde nemaju ovlašćenje za  čitanje podataka. Posetite izvornu lokaciju sa koje ovaj izvor vesti dolazi (URL) kao registrovani korisnik i preuzmite odatle novi RSS link.';
$string['rsskeyshelp'] = '<p>Da bi se obezbedila sigurnost i privatnost, URL adresa RSS izvora sadrži specijalni token koji identifikuje korisnika za koga je token kreiran. Ovo će sprečiti druge korisnike da pristupe onim delovima sajta koji im nisu dozvoljeni</p><p>Token se automatski kreira kada prvi put pristupate delu sajta koji proizvodi RSS izvor. Ako mislite da je je vaš token RSS izvora kompromitovan možete zatražiti novi token tako što ćete ovde kliknuti na link \'Resetuj\'. Molimo vas, imajte u vidu da će trenutna URL adresa RSS izvora postati nevažeća.</p>';
$string['rsstype'] = 'RSS servis za ovu aktivnost';
$string['save'] = 'Sačuvaj';
$string['saveandnext'] = 'Sačuvaj i prikaži sledeće';
$string['savechanges'] = 'Sačuvaj promene';
$string['savechangesanddisplay'] = 'Sačuvaj i prikaži';
$string['savechangesandreturn'] = 'Sačuvaj i vrati se';
$string['savechangesandreturntocourse'] = 'Sačuvaj i vrati se na kurs';
$string['savecomment'] = 'Sačuvaj komentar';
$string['savedat'] = 'Sačuvano u:';
$string['savepreferences'] = 'Sačuvaj parametre';
$string['saveto'] = 'Sačuvaj u';
$string['scale'] = 'Skala za ocenjivanje';
$string['scale_help'] = 'Skala pruža način za evaluaciju ili ocenjivanja postignuća u aktivnosti. Definisana je kao uređena lista vrednosti, u rasponu od negativnih do pozitivnih, odvojenih zarezima. Na primer: "Razočaravajuće, Nedovoljno dobro, Prosečno, Dobro, Vrlo dobro, Odlično!"';
$string['scale_link'] = 'grade/scale';
$string['scales'] = 'Skale za ocenjivanje';
$string['scalescustom'] = 'Prilagođene skale za ocenjivanje';
$string['scalescustomcreate'] = 'Dodaj novu skalu za ocenjivanje';
$string['scalescustomno'] = 'Prilagođene skale za ocenjivanje još uvek nisu kreirane';
$string['scalesstandard'] = 'Standardne skale za ocenjivanje';
$string['scalestandard'] = 'Standardna skala';
$string['scalestandard_help'] = 'Standardna skala je dostupna na nivou celog sajta, za sve kurseve.';
$string['scalestandard_link'] = 'grade/scale';
$string['scalestip'] = 'Kako biste kreirali sopstvene, prilagođene skale za ocenjivanje, upotrebite link \'Skale...\' u meniju za administraciju kursa.';
$string['scalestip2'] = 'Da bi ste kreirali prilagođene skale, kliknite na link Ocene u administrativnom meniju kursa, a onda izaberite Uredi Skale';
$string['schedule'] = 'Raspored';
$string['screenshot'] = 'Snimak ekrana';
$string['search'] = 'Pretraga';
$string['search_help'] = 'Za osnovno pretraživanje jedne ili više reči bilo gde u tekstu, samo ih upišite odvojene razmacima. Mogu se pretraživati sve reči duže od 2 znaka.

Za napredno pretraživanje, kliknite na dugme za pretragu bez upisivanja pojmova u polje za pretragu, kako biste pristupili obrascu za napredno pretraživanje.';
$string['searchactivities'] = 'Potraži aktivnosti po nazivu ili opisu';
$string['searchagain'] = 'Ponovna pretraga';
$string['searchbyemail'] = 'Pretražite prema adresi e-pošte';
$string['searchbyusername'] = 'Pretražite po korisničkom imenu';
$string['searchcoursecategories'] = 'Pretraži kategorije';
$string['searchcourses'] = 'Pretraži kurseve';
$string['searchgroups'] = 'Pretražite grupe';
$string['searchitems'] = 'Pretražite stavke';
$string['searchoptions'] = 'Opcije za pretragu';
$string['searchresults'] = 'Rezultati pretrage';
$string['searchusers'] = 'Pretražite korisnike';
$string['sec'] = 'sek';
$string['seconds'] = 'sekund/e';
$string['secondsleft'] = '{$a} sekundi';
$string['secondstotime172800'] = '2 dana';
$string['secondstotime259200'] = '3 dana';
$string['secondstotime345600'] = '4 dana';
$string['secondstotime432000'] = '5 dana';
$string['secondstotime518400'] = '6 dana';
$string['secondstotime604800'] = '1 sedmica';
$string['secondstotime86400'] = '1 dan';
$string['secretalreadyused'] = 'Link za potvrdu promene lozinke je već korišten. Lozinka nije promenjena.';
$string['secs'] = 's';
$string['section'] = 'Sekcija';
$string['sectionactionnotsupported'] = 'Akcija sa sekcijom  "{$a}" nije podržana ovde';
$string['sectionname'] = 'Naziv sekcije';
$string['sectionoutline'] = 'Pregled sekcija';
$string['sections'] = 'Sekcije';
$string['seealsostats'] = 'Pogledajte i statistiku';
$string['selctauser'] = 'Izaberi korisnika';
$string['select'] = 'Izaberi';
$string['selectacategory'] = 'Molimo vas da izaberete kategoriju';
$string['selectacountry'] = 'Izaberi državu';
$string['selectacourse'] = 'Izaberi kurs';
$string['selectacoursesite'] = 'Izaberi kurs  ili sajt';
$string['selectagroup'] = 'Izaberi grupu';
$string['selectall'] = 'Izaberi sve';
$string['selectallusersonpage'] = 'Izaberi sve korisnike na ovoj stranici';
$string['selectalluserswithcount'] = 'Izaberi svih {$a} korisnika';
$string['selectamodule'] = 'Molimo izaberite modul aktivnosti';
$string['selectanaction'] = 'Izaberi akciju';
$string['selectanoptions'] = 'Izaberi opciju';
$string['selectaregion'] = 'Izaberi region';
$string['selectcategorysort'] = 'Koje kategorije želite da sortirate?';
$string['selectcategorysortby'] = 'Izaberite kako želite da sortirate kategorije';
$string['selectcoursesortby'] = 'Izaberite kako želite da sortirate kurseve';
$string['selectdates'] = 'Izaberite datume';
$string['selectdefault'] = 'Izaberi podrazumevano';
$string['selectedcategories'] = 'Izabrane kategorije';
$string['selectedfile'] = 'Izabrana datoteka';
$string['selectednowmove'] = '{$a} datoteka označeno za premeštanje. Sada idite na mesto gde želite da premestite datoteke i kliknite na \'Premesti datoteke ovde\'';
$string['selectfiles'] = 'Izaberi datoteke';
$string['selectfiltertype'] = 'Izaberi';
$string['selectgroupsseparate'] = 'Izaberi odvojene grupe';
$string['selectgroupsvisible'] = 'Izaberi vidljive grupe';
$string['selectitem'] = 'Odaberi \'{$a}\'';
$string['selectmoduletoviewhelp'] = 'Izaberite aktivnost ili resurs kako biste videli pomoćne informacije o njima.

Da biste brzo dodali aktivnost ili resurs kliknite dva puta na naziv odgovarajuće aktivnosti odnosno resursa.';
$string['selectnos'] = 'Izaberite \'Ne\' za sve';
$string['selectperiod'] = 'Izaberi period';
$string['selecttheme'] = 'Izaberite temu';
$string['selectthemename'] = 'Izaberite temu \'{$a}\'';
$string['senddetails'] = 'Pošalji moje lične podatke e-poštom';
$string['sent'] = 'Poslato';
$string['separate'] = 'Odvoji';
$string['separateandconnected'] = 'Odvojeni i povezani načini saznavanja';
$string['separateandconnected1'] = 'Uglavnom odvojeno znanje';
$string['separateandconnected2'] = 'Odvojeno i povezano';
$string['separateandconnected3'] = 'Uglavnom povezano znanje';
$string['separateandconnectedinfo'] = 'Ova skala se zasniva na teoriji odvojenog i povezanog saznavanja. Ova teorija opisuje dva različita načina na koje možemo da učimo o stvarima koje vidimo i čujemo. <ul> <li><strong>Odvojeni način učenja</strong> - polaznici ostaju objektivni što je više moguće bez uključivanja osećanja. U diskusiji sa drugim ljudima, oni vole da brane svoje ideje i stavove, koristeći logiku kako bi pronašli nedostatke u idejama svojih oponenata.</li> <li><strong>Povezani način učenja</strong> - učenici su više osetljivi na druge ljude. Oni imaju razvijenu sposobnost empatije i pokazuju tendenciju da slušaju i postavljaju pitanja dok ne osete da mogu "razumeti stvari iz ugla gledanja svojih sagovornika". Oni uče tako što pokušavaju da dele iskustva koja vode znanju koje pronalaze kod drugih ljudi.</li></ul>';
$string['servererror'] = 'Došlo je do greške u toku komunikacije sa serverom';
$string['serverlocaltime'] = 'Lokalno vreme servera';
$string['sessionforceclean'] = 'Iz razloga bezbednosti, kao mera opreza, korisnički generisane skripte su onemogućene u ovoj sesiji.';
$string['sessiontimeoutsoon'] = 'Vaša sesija će uskoro isteći. Da li želite da produžite tekuću sesiju?';
$string['setcategorytheme'] = 'Podesi grafičku temu kategorije';
$string['setmode'] = 'Podesite režim rada';
$string['setpassword'] = 'Podesi lozinku';
$string['setpasswordinstructions'] = 'Molimo vas, unesite svoju novu lozinku i potom sačuvajte promene.';
$string['settings'] = 'Podešavanja';
$string['share'] = 'Podelite';
$string['shortname'] = 'Skraćeni naziv';
$string['shortnamecollisionwarning'] = '[*] = Ovaj skraćeni naziv već koristi neki drugi kurs, te će morati biti promenjen po odobravanju';
$string['shortnamecourse'] = 'Skraćeni naziv kursa';
$string['shortnamecourse_help'] = 'Skraćeni naziv kursa se pojavljuje na onim mestima gde je prostor ograničen (npr. u navigaciji kursa ili kao deo naslova elektronske poruke). Skraćeni naziv kursa mora biti jedinstven.';
$string['shortnametaken'] = 'Skraćeni naziv se već koristi za neki drugi kurs ({$a})';
$string['shortnameuser'] = 'Skraćeno ime korisnika';
$string['shortsitename'] = 'Skraćeni naziv za sajt (npr. jedna reč)';
$string['show'] = 'Prikaži';
$string['showactions'] = 'Prikaži akcije';
$string['showactivitydates'] = 'Prikaži datume aktivnosti';
$string['showactivitydates_help'] = 'Prikažite datume aktivnosti na stranici kursa.';
$string['showadvancededitor'] = 'Napredno';
$string['showadvancedsettings'] = 'Prikaži napredna podešavanja';
$string['showall'] = 'Prikaži sve {$a}';
$string['showallcourses'] = 'Prikaži sve kurseve';
$string['showblockcourse'] = 'Prikaži spisak kurseva koji sadrže blokove';
$string['showcategory'] = 'Prikaži {$a}';
$string['showchartdata'] = 'Prikaži podatke grafikona';
$string['showcomments'] = 'Prikaži/sakrij komentare';
$string['showcommentsnonjs'] = 'Prikaži komentare';
$string['showdescription'] = 'Prikaži opis na stranici kursa';
$string['showdescription_help'] = 'Ako je ovo podešavanje omogućeno, gornji opis biće prikazan na stranici kursa odmah ispod linka aktivnosti ili resursa.';
$string['showgrades'] = 'Prikaži ocene polaznicima';
$string['showgrades_help'] = 'Dozvolite polaznicima da mogu da vidi spisak svih svojih ocena na kursu.';
$string['showingacourses'] = 'Prikaz svih {$a} kurs(ev)a';
$string['showingxofycourses'] = 'Prikaz kurseva {$a->start} do {$a->end} od ukupno {$a->total} kurs(ev)a';
$string['showless'] = 'Prikaži manje';
$string['showlistofcourses'] = 'Prikaži spisak kurseva';
$string['showmodulecourse'] = 'Prikaži spiska kurseva koji sadrže aktivnosti';
$string['showmore'] = 'Prikaži više';
$string['showoncoursepage'] = 'Prikaži na stranici kursa';
$string['showonly'] = 'Prikaži samo';
$string['showperpage'] = 'Prikaži {$a} po stranici';
$string['showpopovermenu'] = 'Otvori iskačući prozor';
$string['showpopoverwindow'] = 'Prikaži iskačući prozor sa dodatnim informacijama';
$string['showrecent'] = 'Prikaži nedavne aktivnosti';
$string['showreports'] = 'Prikaži izveštaj o aktivnostima';
$string['showreports_help'] = 'Dozvolite polaznicima da vide sopstvene izveštaje o aktivnostima preko njihove stranice profila.';
$string['showsettings'] = 'Prikaži podešavanja';
$string['showtheselogs'] = 'Prikaži ove zapise o aktivnostima';
$string['showthishelpinlanguage'] = 'Prikaži ovu pomoć na jeziku: {$a}';
$string['sidepanel'] = 'Bočni panel';
$string['signoutofotherservices'] = 'Odjavite se sa svih veb aplikacija';
$string['signoutofotherservices_help'] = 'Odjavite se sa svih uređaja i sistema koji koriste veb servise, kao što je mobilna aplikacija. Sesije veb čitača će ostati aktivne.';
$string['since'] = 'Od';
$string['sincelast'] = 'od poslednjeg pristupa sistemu';
$string['site'] = 'Sajt';
$string['sitedefault'] = 'Podrazumevano za sajt';
$string['sitedefaultspecified'] = 'Podrazumevano za sajt ({$a})';
$string['siteerrors'] = 'Greške na sajtu';
$string['sitefiles'] = 'Datoteke sajta';
$string['sitefilesused'] = 'Datoteke sajta korišćeni u ovom kursu';
$string['sitehome'] = 'Naslovna stranica sajta';
$string['sitelegacyfiles'] = 'Izvorne datoteke sajta';
$string['sitelogs'] = 'Zapisi o aktivnostima na sajtu';
$string['sitenews'] = 'Obaveštenja sajta';
$string['sitepages'] = 'Stranice sajta';
$string['sitepartlist'] = 'Nemate odgovarajuće dozvole za pregled spiska učesnika';
$string['sitepartlist0'] = 'Morate biti predavač sajta da bi Vam bilo dozvoljeno da vidite spisak učesnika sajta.';
$string['sitepartlist1'] = 'Morate biti predavač da bi Vam bilo dozvoljeno da vidite spisak učesnika sajta.';
$string['sites'] = 'Sajtovi';
$string['sitesection'] = 'Dodajte prilagođeni sadržaj';
$string['sitesettings'] = 'Podešavanja sajta';
$string['siteteachers'] = 'Predavači sajta';
$string['size'] = 'Veličina';
$string['sizeb'] = 'bajta';
$string['sizegb'] = 'Gb';
$string['sizekb'] = 'Kb';
$string['sizemb'] = 'MB';
$string['sizepb'] = 'PB';
$string['sizetb'] = 'TB';
$string['skipped'] = 'Preskočeno';
$string['skiptocategorylisting'] = 'Pređi na spisak kategorija';
$string['skiptocoursedetails'] = 'Pređi na detaljne informacije o kursu';
$string['skiptocourselisting'] = 'Pređi na spisak kurseva';
$string['someallowguest'] = 'Neki od kurseva mogu dozvoliti pristup gostima (anonimnim korisnicima)';
$string['someerrorswerefound'] = 'Pojedine informacije nedostaju ili su netačne. Pogledajte detalje ispod.';
$string['sort'] = 'Sortiraj';
$string['sortby'] = 'Sortiraj po';
$string['sortbyx'] = 'Sortiraj po {$a} rastućim redosledom';
$string['sortbyxreverse'] = 'Sortiraj po {$a} rastućim redosledom';
$string['sorting'] = 'Sortiranje';
$string['sourcerole'] = 'Izvorna uloga';
$string['specifyname'] = 'Morate navesti ime.';
$string['standard'] = 'Standardno';
$string['starpending'] = '([*] = kurs čeka na odobrenje)';
$string['startdate'] = 'Datum početka kursa';
$string['startdate_help'] = 'Ovaj datim određuje početak prve nedelje za kurs u sedmičnom formatu. To je takođe datum početka evidentiranja aktivnosti na kursu.

Ako resetujete kurs i promenite ovaj datum, svi datumi na kursu će biti pomereni u skladu sa novim datumom poletka.';
$string['startdatewithtaskenabled'] = 'Datum početka kursa';
$string['startdatewithtaskenabled_help'] = 'Datum kada kurs postaje vidljiv za studente. Pre ovoga datuma, oni neće moći da pristupe kursu.

Ovaj datum takođe određuje početak prve sedmice za kurs u sedmičnom formatu i predstavlja datum početka za zapisivanje aktivnosti kursa. Ako resetujete kurs i promenite ovaj datum, svi datumi na kursu će biti pomereni u odnosu na novi datum početka.';
$string['startingfrom'] = 'Počinje';
$string['startsignup'] = 'Kreiraj novi nalog';
$string['state'] = 'Država/Republika';
$string['statistics'] = 'Statistika';
$string['statisticsgraph'] = 'Statistički grafikon';
$string['stats'] = 'Statistika';
$string['statslogins'] = 'Pristupi sistemu';
$string['statsmodedetailed'] = 'Detaljni (korisnički) prikaz';
$string['statsmodegeneral'] = 'Opšti prikaz';
$string['statsnodata'] = 'Nema dostupnih podataka za tu kombinaciju kursa i vremenskog perioda.';
$string['statsnodatauser'] = 'Nema dostupnih podataka za tu kombinaciju kursa, korisnika i vremenskog perioda.';
$string['statsoff'] = 'Statistika trenutno nije omogućeno';
$string['statsreads'] = 'Pregledi';
$string['statsreport1'] = 'Pristupi sistemu';
$string['statsreport10'] = 'Aktivnost korisnika';
$string['statsreport11'] = 'Najaktivniji kursevi';
$string['statsreport12'] = 'Najaktivniji kursevi (ponderisano)';
$string['statsreport13'] = 'Kursevi sa najviše učešća (upisi)';
$string['statsreport14'] = 'Kursevi sa najviše učešća (postovi/pregledi)';
$string['statsreport2'] = 'Prikazi (sve uloge)';
$string['statsreport3'] = 'Poruke (sve uloge)';
$string['statsreport4'] = 'Ukupna aktivnost (sve uloge)';
$string['statsreport5'] = 'Ukupna aktivnost (prikazi i poruke)';
$string['statsreport7'] = 'Polaznička aktivnost (prikazi i poruke)';
$string['statsreport8'] = 'Sve aktivnosti korisnika';
$string['statsreport9'] = 'Pristupi (sajtu/kursu)';
$string['statsreportactivity'] = 'Ukupna aktivnost (sve uloge)';
$string['statsreportactivitybyrole'] = 'Ukupna aktivnost (pregledi i poruke)';
$string['statsreportforuser'] = 'za';
$string['statsreportlogins'] = 'Pristupi sistemu';
$string['statsreportreads'] = 'Prikazi (sve uloge)';
$string['statsreporttype'] = 'Tip izveštaja';
$string['statsreportwrites'] = 'Poruke (sve uloge)';
$string['statsstudentactivity'] = 'Aktivnost polaznika';
$string['statsstudentreads'] = 'Pregledi polaznika';
$string['statsstudentwrites'] = 'Objave polaznika';
$string['statsteacheractivity'] = 'Aktivnost predavača';
$string['statsteacherreads'] = 'Prikazi predavača';
$string['statsteacherwrites'] = 'Poruke predavača';
$string['statstimeperiod'] = 'Vremenski period - trajanje:';
$string['statsuniquelogins'] = 'Različiti pristupi sistemu';
$string['statsuseractivity'] = 'Sve aktivnosti';
$string['statsuserlogins'] = 'Pristupi sistemu';
$string['statsuserreads'] = 'Prikazi';
$string['statsuserwrites'] = 'Poruke';
$string['statswrites'] = 'Poruke';
$string['status'] = 'Status';
$string['statuschecks'] = 'Provere statusa';
$string['statuscritical'] = 'Kritično';
$string['statusdone'] = 'Gotovo';
$string['statuserror'] = 'Greška';
$string['statusinfo'] = 'Info';
$string['statusna'] = 'N/A';
$string['statusok'] = 'OK';
$string['statusunknown'] = 'Nepoznato';
$string['statuswarning'] = 'Upozorenje';
$string['stringsnotset'] = 'Sledeći izrazi nisu definisani u {$a}';
$string['studentnotallowed'] = 'Nažalost, ne možete pristupiti ovom kursu kao \'{$a}\'';
$string['students'] = 'Polaznici';
$string['studentsandteachers'] = 'Polaznici i predavači';
$string['subcategories'] = 'Potkategorije';
$string['subcategory'] = 'Potkategorija';
$string['subcategoryof'] = 'Potkategorija od {$a}';
$string['subject'] = 'Tema';
$string['submit'] = 'Predaj';
$string['subsectionmoveerror'] = 'Nije moguće premestiti ovu podsekciju u drugu podsekciju';
$string['success'] = 'Uspešno';
$string['successduration'] = 'Uspešno ({$a} sek.)';
$string['summary'] = 'Rezime';
$string['suspended'] = 'Suspendovan';
$string['suspendedusers'] = 'Suspendovani korisnici';
$string['switchdevicedefault'] = 'Prelazak na standardnu grafičku temu';
$string['switchdevicerecommended'] = 'Prelazak na preporučenu grafičku temu za vaš uređaj';
$string['switchrolereturn'] = 'Povratak na moju uobičajenu ulogu';
$string['switchroleto'] = 'Promeni ulogu u...';
$string['switchroleto_help'] = 'Izaberite ulogu kako biste videli kako korisnik sa tom ulogom vidi ovaj kurs.

Imajte u vidu da prikaz kursa sa drugom ulogom nije savršen (<a href="https://docs.moodle.org/en/Switch_roles">Pogledajte više informacije</a>)';
$string['tag'] = 'Oznaka';
$string['tagalready'] = 'Oznaka već postoji';
$string['tagmanagement'] = 'Dodaj/obriši oznake...';
$string['tags'] = 'Oznake';
$string['targetrole'] = 'Ciljna uloga';
$string['teacheronly'] = 'samo za {$a}';
$string['teacherroles'] = '{$a} uloge';
$string['teachers'] = 'Predavači';
$string['textcopiedtoclipboard'] = 'Tekst je kopiran u klipbord';
$string['textediting'] = 'Editor teksta';
$string['textediting_help'] = 'Ako je izabran HTML editor (npr. Atto ili TinyMCE) polja za unos teksta će sadržati traku sa alatima pomoću kojih će se sadržaj lako dodavati pritiskom na odgovarajuću dugmad.

Ako je izabrana opcija \'običan tekst\' može se birati format za unos teksta kao što je HTML ili Markdown.

Spisak raspoloživih editora za uređivanje teksta određuje administrator sajta.';
$string['texteditor'] = 'Koristiti standardne veb obrasce';
$string['textellipsis'] = '{$a}...';
$string['textformat'] = 'Običan tekstualni format';
$string['thanks'] = 'Hvala';
$string['theme'] = 'Grafička tema';
$string['themepreviewdescription'] = 'Opis teme {$a}';
$string['themepreviewimage'] = 'Slika za pregled teme {$a}';
$string['themes'] = 'Grafičke teme';
$string['themesaved'] = 'Nova grafička tema je sačuvana';
$string['therearecourses'] = 'Postoji {$a} kurs/a/eva';
$string['thereareno'] = 'Ne postoje {$a} u ovom kurs';
$string['thiscategory'] = 'Ova kategorija';
$string['thiscategorycontains'] = 'Ova kategorija sadrži';
$string['time'] = 'Vreme';
$string['timecreated'] = 'Vreme kreiranja';
$string['timecreatedcourse'] = 'Vreme kreiranja kursa';
$string['timesplitting:deciles'] = 'Poslednja desetina';
$string['timesplitting:deciles_help'] = 'Ovaj interval analize deli kurs na desetine (10 jednakih delova), pri čemu se svako predviđanje zasniva samo na podacima najnovije prethodne desetine.';
$string['timesplitting:decilesaccum'] = 'Sve prethodne desetine';
$string['timesplitting:decilesaccum_help'] = 'Ovaj interval analize deli kurs na desetine (10 jednakih delova), pri čemu se svako predviđanje zasniva na podacima svih prethodnih desetina.';
$string['timesplitting:nosplitting'] = 'Bez vremenskih ograničenja';
$string['timesplitting:nosplitting_help'] = 'Za ovaj model nije definisan interval analize.';
$string['timesplitting:onemonthafterstart'] = 'Mesec dana nakon početka';
$string['timesplitting:onemonthafterstart_help'] = 'Ovaj interval analize generiše predviđanje mesec dana nakon početka koji se može analizirati.';
$string['timesplitting:oneweekafterstart'] = 'Nedelju dana nakon početka';
$string['timesplitting:oneweekafterstart_help'] = 'Ovaj interval analize generiše predviđanje nedelju dana nakon početka koji se može analizirati.';
$string['timesplitting:past3days'] = 'Prošla 3 dana';
$string['timesplitting:past3days_help'] = 'Ovaj interval analize generiše predviđanja svaka 3 dana. Izračunavanja indikatora biće zasnovana protekla 3 dana.';
$string['timesplitting:pastmonth'] = 'Prošlog meseca';
$string['timesplitting:pastmonth_help'] = 'Ovaj interval analize generiše predviđanja svakog meseca. Izračunavanja indikatora biće zasnovana na proteklih mesec dana.';
$string['timesplitting:pastweek'] = 'Prošle nedelje';
$string['timesplitting:pastweek_help'] = 'Ovaj interval analize generiše predviđanja svake nedelje. Izračunavanja indikatora biće zasnovana na protekloj sedmici.';
$string['timesplitting:quarters'] = 'Poslednje tromesečje';
$string['timesplitting:quarters_help'] = 'Ovaj interval analize deli kurs na tromesečja (4 jednaka dela), pri čemu se svako predviđanje zasniva samo na podacima najnovijeg prethodnog tromesečja.';
$string['timesplitting:quartersaccum'] = 'Tromesečja kumulativno';
$string['timesplitting:quartersaccum_help'] = 'Ovaj interval analize deli kurs na tromesečja (4 jednaka dela), pri čemu se svako predviđanje zasniva na podacima svih prethodnih tromesečja.';
$string['timesplitting:singlerange'] = 'Od početka do kraja';
$string['timesplitting:singlerange_help'] = 'Ovaj interval analize posmatra ceo kurs kao jedinstvenu celinu.';
$string['timesplitting:tenpercentafterstart'] = '10% nakon početka';
$string['timesplitting:tenpercentafterstart_help'] = 'Ovaj interval analize generiše predviđanje nakon završetka 10% kursa.';
$string['timesplitting:upcoming3days'] = 'Naredna 3 dana';
$string['timesplitting:upcoming3days_help'] = 'Ovaj interval analize generiše predviđanja svaka 3 dana. Izračunavanja indikatora biće zasnovana naredna 3 dana.';
$string['timesplitting:upcomingfortnight'] = 'Naredne 2 sedmice';
$string['timesplitting:upcomingfortnight_help'] = 'Ovaj interval analize generiše predviđanja svake dve nedelje. Izračunavanja indikatora biće zasnovana na predstojećih petnaest dana.';
$string['timesplitting:upcomingweek'] = 'Naredna sedmica';
$string['timesplitting:upcomingweek_help'] = 'Ovaj interval analize generiše predviđanja svake nedeljnj. Izračunavanja indikatora biće zasnovana na narednoj sedmici.';
$string['timezone'] = 'Vremenska zona';
$string['tocontent'] = 'Odredišna stavka "{$a}"';
$string['tocreatenewaccount'] = 'Preskoči za kreiranje novog korisničkog naloga';
$string['todate'] = 'Do';
$string['today'] = 'Danas';
$string['todaylogs'] = 'Današnji zapisi o aktivnostima';
$string['toeveryone'] = 'svima';
$string['toggleemojipicker'] = 'Uključi/isključi birač emodžija';
$string['togglesearch'] = 'Uključi/isključi polje za pretragu';
$string['toomanybounces'] = 'Sa ove elektronske adrese vratilo se previše poruka. <b>Morate</b> je promeniti da biste nastavili.';
$string['toomanytags'] = '
Ova pretraga je sadržala previše oznaka; neke će biti ignorisane.';
$string['toomanytoshow'] = 'Previše korisnika za prikaz';
$string['toomanyusersmatchsearch'] = 'Previše korisnika ({$a->count}) se poklapa sa\'{$a->search}\'';
$string['toomanyuserstoshow'] = 'Previše korisnika za prikaz ({$a}) to show';
$string['toonly'] = 'samo za {$a}';
$string['top'] = 'Vrh';
$string['topic'] = 'Tema';
$string['toplevelcategory'] = 'Kategorija najvišeg nivoa';
$string['torecipient'] = 'Do';
$string['total'] = 'Ukupno';
$string['totopofsection'] = 'Na početak sekcije "{$a}"';
$string['trackforums'] = 'Praćenje foruma';
$string['trackforumsno'] = 'NE: ne beleži informacije o tome koje sam poruke prethodno pročitao/la';
$string['trackforumsyes'] = 'DA: istakni nove poruke';
$string['trysearching'] = 'Pokušajte sa pretraživanjem.';
$string['turneditingoff'] = 'Isključi uređivanje';
$string['turneditingon'] = 'Uključi uređivanje';
$string['unabletocopytoclipboard'] = 'Nije moguće kopirati tekst u klipbord';
$string['unauthorisedlogin'] = 'Korisnički nalog "{$a}" nije dostupan na ovom sajtu';
$string['undecided'] = 'Neodlučni';
$string['unexistingcmid'] = 'ID oznaka modula kursa nije pronađena';
$string['unexistingsectionid'] = 'ID oznaka sekcije kursa nije pronađena';
$string['unfinished'] = 'Nedovršeno';
$string['unknowncategory'] = 'Nepoznata kategorija';
$string['unknownerror'] = 'Nepoznata greška';
$string['unknownuser'] = 'Nepoznati korisnik';
$string['unlimited'] = 'Neograničeno';
$string['unpacking'] = 'Raspakuje se {$a}';
$string['unsafepassword'] = 'Nesigurna lozinka - probajte nešto kompleksnije';
$string['untilcomplete'] = 'Dok se ne završi';
$string['unusedaccounts'] = 'Korisnički nalozi koji se ne koriste {$a} dana se automatski ispisuju';
$string['unzip'] = 'Raspakuj';
$string['unzippingbackup'] = 'Raspakuje se rezervna kopija';
$string['up'] = 'Gore';
$string['update'] = 'Ažuriraj';
$string['updated'] = 'Ažurirano {$a}';
$string['updatemymoodleoff'] = 'Prestani sa uređivanjem ove stranice';
$string['updatemymoodleon'] = 'Prilagodi ovu stranicu';
$string['updatemyprofile'] = 'Ažuriraj profil';
$string['updatesevery'] = 'Ažuriranje na svakih {$a} sekundi';
$string['updatethis'] = 'Ažuriraj {$a}';
$string['updatethiscourse'] = 'Ažuriraj ovaj kurs';
$string['upload'] = 'Postavi';
$string['uploadafile'] = 'Postavljanje datoteke';
$string['uploadcantwrite'] = 'Neuspešno upisivanje datoteke na disk';
$string['uploadedfile'] = 'Datoteka je uspešno postavljena';
$string['uploadedfileto'] = 'Datoteka {$a->file} je postavljena u direktorijum {$a->directory}';
$string['uploadedfiletoobig'] = 'Nažalost, navedena datoteka je prevelika (ograničenje iznosi {$a} bajta)';
$string['uploadextension'] = 'Postavljanje datoteke prekinuto od strane PHP  ekstenzije';
$string['uploadfailednotrecovering'] = 'Postavljanje Vaših datoteka nije uspelo jer je uočen problem sa jednom od njih, {$a->name}.<br /> Ovde je izveštaj o uočenim problemima:<br />{$a->problem}<br />Nema oporavka.';
$string['uploadfilelog'] = 'Izveštaj o postavljanju datoteke {$a}';
$string['uploadformlimit'] = 'Postavljena datoteka {$a} je premašila ograničenje za maksimalnu veličinu određenu obrascem';
$string['uploadlabel'] = 'Naslov:';
$string['uploadlimitwithsize'] = '{$a->contextname} - ograničenje za postavljanje datoteka ({$a->displaysize})';
$string['uploadnewfile'] = 'Postavi novu datoteku';
$string['uploadnofilefound'] = 'Datoteka nije pronađena - jeste li sigurni da ste izabrali datoteku za postavljanje?';
$string['uploadnotallowed'] = 'Postavljanje nije dozvoljeno';
$string['uploadnotempdir'] = 'Nedostaje privremeni direktorijum';
$string['uploadoldfilesdeleted'] = 'Stare datoteke u Vašem odeljku za postavljanje su obrisane';
$string['uploadpartialfile'] = 'Postavljanje datoteke nije izvršeno u potpunosti';
$string['uploadproblem'] = 'Prilikom postavljanja datoteke \'{$a}\' dogodila se nepoznata greška (možda je navedena datoteka bila prevelika?)';
$string['uploadrenamedchars'] = 'Naziv datoteka je promenjen iz {$a->oldname} u {$a->newname} zato što je sadržao nedozvoljene znakove.';
$string['uploadrenamedcollision'] = 'Naziv datoteka je promenjen iz {$a->oldname} u {$a->newname} zato što je došlo do konflikta sa nazivom neke druge datoteke.';
$string['uploadserverlimit'] = 'Datoteka koja je postavljena je veća od maksimalne veličine dozovoljene ograničenjem ovog servera';
$string['uploadthisfile'] = 'Postavi datoteku';
$string['url'] = 'URL';
$string['used'] = 'Korišćeno';
$string['usedinnplaces'] = 'Koristi se na {$a} mesta';
$string['user'] = 'Korisnik';
$string['useraccount'] = 'Korisnički nalog';
$string['useractivity'] = 'Aktivnost';
$string['userconfirmed'] = 'Potvrđen {$a}';
$string['userdata'] = 'Podaci o korisniku';
$string['userdeleted'] = 'Ovaj korisnički nalog je obrisan';
$string['userdescription'] = 'Opis';
$string['userdescription_help'] = 'Ovdе možete uneti podatke o sebi koji će biti prikazani na stranici vašeg profila i koje će moći da vide drugi korisnici.';
$string['userdetails'] = 'Detalji o korisniku';
$string['userfiles'] = 'Korisničke datoteke';
$string['userlist'] = 'Spisak korisnika';
$string['usermatchedon'] = 'Ovaj korisnik odgovara pretrazi na osnovu sledećeg polja';
$string['usermenu'] = 'Korisnički meni';
$string['usermenugoback'] = 'Vrati se na korisnički meni';
$string['username'] = 'Korisničko ime';
$string['usernameemail'] = 'Korisničko ime ili e-adresa';
$string['usernameemailmatch'] = 'Korisničko ime i adresa e-pošte se ne odnose na istog korisnika';
$string['usernameexists'] = 'Navedeno korisničko ime već postoji, izaberite neko drugo';
$string['usernamelowercase'] = 'Dozvoljena su samo mala slova';
$string['usernamenotfound'] = 'Korisničko ime nije pronađeno u bazi podataka';
$string['usernameoremail'] = 'Unesite ili korisničko ime ili adresu e-pošte';
$string['usernotconfirmed'] = 'Nije se moglo potvrditi {$a}';
$string['userpic'] = 'Slika korisnika';
$string['userpreferences'] = 'Korisnička podešavanja';
$string['users'] = 'Korisnici';
$string['userselectorautoselectunique'] = 'Ako samo jedan korisnik odgovara kriterijumima pretragе neka automatski bude izabran';
$string['userselectorpreserveselected'] = 'Zadrži izabrane korisnike, čak i ako se više ne odgovaraju kriterijumima pretrage';
$string['userselectorsearchanywhere'] = 'bilo gde';
$string['userselectorsearchexactmatchonly'] = 'samo potpuna poklapanja';
$string['userselectorsearchfromstart'] = 'od početka';
$string['userselectorsearchmatching'] = 'Podudaranje:';
$string['usersnew'] = 'Novi korisnici';
$string['usersnoaccesssince'] = 'Neaktivni više od';
$string['userswithfiles'] = 'Korisnici sa datotekama';
$string['useruploadtype'] = 'Tip postavljanja korisnika: {$a}';
$string['userzones'] = 'Korisničke zone';
$string['usetheme'] = 'Upotrebi ovu temu';
$string['usingexistingcourse'] = 'Koristeći postojeći kurs';
$string['validatehtml'] = 'Proverite HTML';
$string['valuealreadyused'] = 'Ova vrednost je već iskorišćena';
$string['version'] = 'Verzija';
$string['view'] = 'Prikaz';
$string['viewallcourses'] = 'Prikaži sve kurseve';
$string['viewallcoursescategories'] = 'Prikaži sve kurseve i kategorije';
$string['viewallresults'] = 'Prikaži sve rezultate ({$a})';
$string['viewallsubcategories'] = 'Pogledaj sve potkategorije';
$string['viewfileinpopup'] = 'Pogledaj datoteku u iskačućem prozoru';
$string['viewing'] = 'Pregled:';
$string['viewmore'] = 'Pogledaj još';
$string['viewprofile'] = 'Pregledaj profil';
$string['views'] = 'Prikazi';
$string['viewsolution'] = 'vidi rešenje';
$string['visible'] = 'Vidljivo';
$string['visible_help'] = 'Ovo podešavanje određuje da li će se kurs pojaviti na popisu kurseva. Za razliku od nastavnika i administratora, korisnicima nije dozvoljen ulazak na kurs.';
$string['visibletostudents'] = 'Vidljivo za {$a}';
$string['warning'] = 'Upozorenje';
$string['warningdeleteresource'] = 'Upozorenje: na {$a} se odnosi resurs. Da li želite da ažurirate taj resurs?';
$string['wcagcheck'] = 'Provera smernica za pristupačnost veb sadržaja (Web Content Accessibility Guidelines - WCAG).';
$string['webpage'] = 'Web stranica';
$string['week'] = 'Sedmica';
$string['weeks'] = 'sedmica/e';
$string['welcomeback'] = 'Zdravo, {$a->firstname}! 👋';
$string['welcometocourse'] = 'Dobro došli na kurs {$a}';
$string['welcometocoursetext'] = 'Dobro došli na kurs {$a->coursename}!

Ukoliko to već niste uradili, trebalo bi da urediti stranicu svog profila, tako da možemo da saznamo nešto više o vama:

<a href="{$a->profileurl}">{$a->profileurl}</a>';
$string['welcometosite'] = 'Dobrodošao/la, {$a->firstname}! 👋';
$string['whatforlink'] = 'Šta želite da uradite sa linkom?';
$string['whatforpage'] = 'Šta želite da uradite sa linkom?';
$string['whatisyourage'] = 'Koliko Vam je godina';
$string['whattocallzip'] = 'Kako želite da nazovete arhiviranu datoteku?';
$string['whattodo'] = 'Šta uraditi';
$string['wheredoyoulive'] = 'U kojoj zemlji živite?';
$string['whyisthisrequired'] = 'Zašto je ovo neophodno?';
$string['windowclosing'] = 'Ovaj prozor bi trebalo da se automatski zatvori. Ako se to nije dogodilo molim vas da ga sada zatvorite.';
$string['withchosenfiles'] = 'Sa izabranim datotekama';
$string['withdisablednote'] = '{$a} (onemogućeno)';
$string['withoutuserdata'] = 'bez korisničkih podataka';
$string['withselectedusers'] = 'Sa izabranim korisnicima...';
$string['withuserdata'] = 's korisničkim podacima';
$string['wontrunfuturescheduledtask'] = 'Neće pokrenuti zadatak koji nije uspeo i koji je planiran da se pokrene u budućnosti';
$string['wordforstudent'] = 'Vaša reč za polaznika';
$string['wordforstudenteg'] = 'npr. polaznik, učesnik, kandidat i sl.';
$string['wordforstudents'] = 'Vaša reč za polaznike';
$string['wordforstudentseg'] = 'npr. polaznici, učesnici, kandidati i sl.';
$string['wordforteacher'] = 'Vaša reč za predavača';
$string['wordforteachereg'] = 'npr. predavač, profesor, moderator i sl.';
$string['wordforteachers'] = 'Vaša reč za predavače';
$string['wordforteacherseg'] = 'npr. predavači, profesori, moderatori i sl.';
$string['writingblogsinfo'] = 'Upisivanje informacija o blogovima';
$string['writingcategoriesandquestions'] = 'Zapisivanje kategorija i pitanja';
$string['writingcoursedata'] = 'Zapisivanje podataka kursa';
$string['writingeventsinfo'] = 'Zapisivanje informacija o događajima';
$string['writinggeneralinfo'] = 'Zapisivanje opštih informacija';
$string['writinggradebookinfo'] = 'Zapisivanje informacija o ocenama';
$string['writinggroupingsgroupsinfo'] = 'Zapisivanje informacija o grupisanjima-grupama';
$string['writinggroupingsinfo'] = 'Zapisivanje informacija o grupacijama';
$string['writinggroupsinfo'] = 'Zapisivanje informacija o grupama';
$string['writingheader'] = 'Zapisivanje zaglavlja';
$string['writingloginfo'] = 'Zapisivanje informacija o zapisima o aktivnostima';
$string['writingmessagesinfo'] = 'Zapisivanje informacija o porukama';
$string['writingmoduleinfo'] = 'Zapisivanje informacija o modulima';
$string['writingscalesinfo'] = 'Zapisivanje informacija o skalama ocenjivanja';
$string['writinguserinfo'] = 'Zapisivanje informacija o korisnicima';
$string['wrongpassword'] = 'Pogrešna lozinka za ovo korisničko ime';
$string['year'] = 'godina';
$string['years'] = 'godina';
$string['yes'] = 'Da';
$string['youareabouttocreatezip'] = 'Upravo ćete započeti kreiranje zip arhive koja sadrži';
$string['youaregoingtorestorefrom'] = 'Upravo ćete započeti restauracioni proces za';
$string['youhaveupcomingactivitiesdue'] = 'Imate predstojeće aktivnosti koje se uskoro završavaju';
$string['youhaveupcomingactivitiesdueinfo'] = 'Poštovani/a {$a},

<br/><br/>Imate predstojeće aktivnosti koje se uskoro završavaju';
$string['youneedtoenrol'] = 'Da biste izvršili ovu akciju morate se upisati na ovaj kurs.';
$string['yourlastlogin'] = 'Vaš poslednji pristup sistemu';
$string['yourself'] = 'sebe';
$string['yourteacher'] = 'Vaš {$a}';
$string['yourwordforx'] = 'Vaša reč za \'{$a}\'';
$string['zippingbackup'] = 'Kreira se arhiva sa rezervnom kopijom';
