<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'aiprovider_openai', language 'no', version '5.0'.
 *
 * @package     aiprovider_openai
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['action:explain_text:endpoint'] = 'API endepunkt';
$string['action:explain_text:model'] = 'KI-modell';
$string['action:explain_text:model_help'] = 'Modellen brukt til å forklare oppgitt tekst.';
$string['action:explain_text:systeminstruction'] = 'Systeminstruksjon';
$string['action:explain_text:systeminstruction_help'] = 'Denne instruksjonen sendes til AI-modellen sammen med brukerens ledetekst. Det anbefales ikke å redigere denne instruksjonen med mindre det er absolutt nødvendig.';
$string['action:generate_image:endpoint'] = 'API endepunkt';
$string['action:generate_image:model'] = 'KI-modell';
$string['action:generate_image:model_desc'] = 'Modellen brukt for å generere bilder fra brukerinput.';
$string['action:generate_image:model_help'] = 'Modellen brukt for å generere bilder fra brukerinput.';
$string['action:generate_text:endpoint'] = 'API endepunkt';
$string['action:generate_text:model'] = 'KI-modell';
$string['action:generate_text:model_desc'] = 'Modellen bruker for å generere tekstresponsen.';
$string['action:generate_text:model_help'] = 'Modellen bruker for å generere tekstresponsen.';
$string['action:generate_text:systeminstruction'] = 'Systeminstruksjon';
$string['action:generate_text:systeminstruction_desc'] = 'Denne instruksjonen sendes til AI-modellen sammen med brukerens ledetekst. Det anbefales ikke å redigere denne instruksjonen med mindre det er absolutt nødvendig.';
$string['action:generate_text:systeminstruction_help'] = 'Denne instruksjonen sendes til AI-modellen sammen med brukerens ledetekst. Det anbefales ikke å redigere denne instruksjonen med mindre det er absolutt nødvendig.';
$string['action:summarise_text:endpoint'] = 'API endepunkt';
$string['action:summarise_text:model'] = 'KI-modell';
$string['action:summarise_text:model_desc'] = 'Modellen brukt for å oppsummere den oppgitte teksten.';
$string['action:summarise_text:model_help'] = 'Modellen brukt for å oppsummere den oppgitte teksten.';
$string['action:summarise_text:systeminstruction'] = 'Systeminstruksjon';
$string['action:summarise_text:systeminstruction_desc'] = 'Denne instruksjonen sendes til AI-modellen sammen med brukerens ledetekst. Det anbefales ikke å redigere denne instruksjonen med mindre det er absolutt nødvendig.';
$string['action:summarise_text:systeminstruction_help'] = 'Denne instruksjonen sendes til AI-modellen sammen med brukerens ledetekst. Det anbefales ikke å redigere denne instruksjonen med mindre det er absolutt nødvendig.';
$string['apikey'] = 'OpenAI API-nøkkel';
$string['apikey_desc'] = 'Få en nøkkel fra <a href="https://platform.openai.com/account/api-keys">OpenAI Platform API keys</a>.';
$string['apikey_help'] = 'Få en nøkkel fra <a href="https://platform.openai.com/account/api-keys">OpenAI Platform API keys</a>.';
$string['custom_model_name'] = 'Eget modellnavn';
$string['enableglobalratelimit'] = 'Angi grense for hele nettstedet';
$string['enableglobalratelimit_desc'] = 'Begrens antall forespørsler som OpenAI API-leverandøren kan motta på tvers av hele nettstedet hver time.';
$string['enableuserratelimit'] = 'Angi brukergrense';
$string['enableuserratelimit_desc'] = 'Begrens antall forespørsler hver bruker kan gjøre til OpenAI API-leverandøren hver time.';
$string['extraparams'] = 'Ekstra paramtere';
$string['extraparams_help'] = 'Ekstra parametere kan konfigureres her. Vi støtter JSON-format. For eksempel:
<pre>
{
    "temperature": 0.5,
    "max_completion_tokens": 100
}
</pre>';
$string['globalratelimit'] = 'Maksimalt antall nettstedsomfattende forespørsler';
$string['globalratelimit_desc'] = 'Antall nettstedsomfattende forespørsler per time';
$string['invalidjson'] = 'Ugyldig JSON string';
$string['orgid'] = 'OpenAI organisasjonsID';
$string['orgid_desc'] = 'Skaff deg en OpenAI-organisasjons-ID fra <a href="https://platform.openai.com/account/org-settings">OpenAI Platform-kontoen din</a>.';
$string['orgid_help'] = 'Hent OpenAI-organisasjons-ID-en din fra <a href="https://platform.openai.com/account/org-settings" target="_blank">OpenAI-kontoen din</a>.';
$string['pluginname'] = 'OpenAI API-tilbyder';
$string['privacy:metadata'] = 'OpenAI API-tilbydermodulen lagrer ikke persondata';
$string['privacy:metadata:aiprovider_openai:externalpurpose'] = 'Denne informasjonen sendes til OpenAI API for at et svar skal kunne genereres. OpenAI-kontoinnstillingene dine kan endre hvordan OpenAI lagrer og beholder disse dataene. Ingen brukerdata sendes eksplisitt til OpenAI eller lagres i Moodle LMS av denne plugin-modulen.';
$string['privacy:metadata:aiprovider_openai:model'] = 'Modellen som ble brukt til å generere svaret.';
$string['privacy:metadata:aiprovider_openai:numberimages'] = 'Når du genererer bilder, angir du antall bilder som brukes i svaret.';
$string['privacy:metadata:aiprovider_openai:prompttext'] = 'Brukeren skrev inn tekstmeldingen som ble brukt til å generere svaret.';
$string['privacy:metadata:aiprovider_openai:responseformat'] = 'Svarformat ved bildegenerering.';
$string['settings'] = 'Innstillinger';
$string['settings_frequency_penalty'] = 'frequency_penalty';
$string['settings_frequency_penalty_help'] = 'Frekvensstraffen justerer hvor ofte ord gjentas. Jo høyere straffen er, desto færre repetisjoner i den genererte teksten.';
$string['settings_help'] = 'Juster innstillingene nedenfor for å tilpasse hvordan forespørsler sendes til OpenAI.';
$string['settings_max_completion_tokens'] = 'max_completion_tokens';
$string['settings_max_completion_tokens_help'] = 'Maks antall tokens brukt i generert tekst';
$string['settings_max_tokens'] = 'max_tokens';
$string['settings_max_tokens_help'] = 'Maks antall tokens brukt i generert tekst';
$string['settings_presence_penalty'] = 'presence_penalty';
$string['settings_presence_penalty_help'] = 'Tilstedeværelsesstraffen oppmuntrer modellen til å bruke nye ord ved å øke sannsynligheten for å velge ord den ikke har brukt før. En høyere verdi gjør den genererte teksten mer mangfoldig, mens en lavere verdi tillater mer repetisjon.';
$string['settings_top_p'] = 'top_p';
$string['settings_top_p_help'] = 'top_p (kjerneutvalg) bestemmer hvor mange mulige ord som skal vurderes. En høy verdi (f.eks. 0,9) betyr at modellen ser på flere ord, noe som gjør den genererte teksten mer mangfoldig.';
$string['userratelimit'] = 'Maks antall forespørsler per bruker';
$string['userratelimit_desc'] = 'Antall tillatte forespørsler per bruker per time';
