<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'role', language 'tr', version '5.0'.
 *
 * @package     role
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['addinganewrole'] = 'Yeni rol ekleniyor';
$string['addrole'] = 'Yeni rol ekle';
$string['advancedoverride'] = 'Gelişmiş, rol geçersiz kılma işlemi';
$string['ai:acceptpolicy'] = 'Yapay zeka politikını kabul et';
$string['ai:fetchanyuserpolicystatus'] = 'Kullanıcıların yapay zeka politikasını kabul etmesini sağlayın';
$string['ai:fetchpolicy'] = 'Kullanıcıların yapay zeka politikasını kabul etmesini sağlayın';
$string['allow'] = 'İzin ver';
$string['allowassign'] = 'Rol atamalarına izin ver';
$string['allowed'] = 'İzin verilmiş';
$string['allowoverride'] = 'Rolü geçersiz kılma izni';
$string['allowroletoassign'] = '{$a->fromrole} rolündekilerin {$a->targetrole} rolünü atamasına izin ver';
$string['allowroletooverride'] = '{$a->fromrole} rolündekilerin {$a->targetrole} rolünü yeniden tanımlamasına izin ver';
$string['allowroletoswitch'] = 'Kullanıcıların {$a->fromrole} rolünden  {$a->targetrole} rolüne geçiş yapabilmesine izin ver';
$string['allowroletoview'] = '{$a->fromrole} rolüne sahip kullanıcıların {$a->targetrol} rolünü görüntülemesine izin ver';
$string['allowswitch'] = 'Rol değişimi izni';
$string['allowview'] = 'Rolün görüntülenmesine izin ver';
$string['allsiteusers'] = 'Tüm site kullanıcıları';
$string['analytics:listinsights'] = 'İçgörüleri listeleme';
$string['analytics:listowninsights'] = 'Kendi içgörülerinizi listeleyin';
$string['analytics:managemodels'] = 'Modelleri yönet';
$string['archetype'] = 'Rol örneği';
$string['archetype_help'] = 'Rol ilk örneği, bir rol varsayılana sıfırlandığında izinleri belirler. Ayrıca, site yükseltildiğinde rol için yeni izinler de belirler.';
$string['archetypecoursecreator'] = 'ARCHETYPE: Kurs oluşturucu';
$string['archetypeeditingteacher'] = 'ÖRNEK: Öğretmen (düzenleniyor)';
$string['archetypefrontpage'] = 'ÖRNEK: Anasayfada yetkilendirilmiş kullanıcı';
$string['archetypeguest'] = 'ÖRNEK: Misafir';
$string['archetypemanager'] = 'ÖRNEK: Yönetici';
$string['archetypestudent'] = 'ÖRNEK: Öğrenci';
$string['archetypeteacher'] = 'ÖRNEK: Öğretmen (düzenlenmiyor)';
$string['archetypeuser'] = 'ÖRNEK: Yetkili kullanıcı';
$string['assignanotherrole'] = 'Başka bir rol ata';
$string['assignedroles'] = 'Atanmış roller';
$string['assignerror'] = '{$a->role} rolünü, {$a->user} kullanıcısına atarken hata oluştu.';
$string['assignglobalroles'] = 'Sistem rollerini ata';
$string['assignmentcontext'] = 'Atanan bağlam';
$string['assignmentoptions'] = 'Atama seçenekleri';
$string['assignrole'] = 'Rol ata';
$string['assignrolenameincontext'] = '{$a->context} bağlamında \'{$a->role}\' rolü ata';
$string['assignroles'] = 'Rolleri ata';
$string['assignroles_help'] = 'Bir bağlamda bir kullanıcıya rol atayarak,
şu anki bağlamda ve bu bağlama ait "daha düşük" bağlamlarda bu rolün içerdiği izinlerin hepsine yetkili kılmış olursunuz. Örnek vermek gerekirse; Bir öğrenciye bir kursta Öğrenci rolünü verdiğinizde bu kurstaki bloklar ve etkinliklerin yanı sıra bu rolün bütün yetkilerine de sahip olacaktır.';
$string['assignroles_link'] = 'admin/roles/assign';
$string['assignrolesin'] = '{$a} rollerini ata';
$string['assignrolesrelativetothisuser'] = 'İlgili rolleri bu kullanıcıya ata';
$string['backtoallroles'] = 'Roller listesine geri gön';
$string['backup:anonymise'] = 'Yedeklemede kullanıcı verisini anonimleştir';
$string['backup:backupactivity'] = 'Yedekleme etkinlikleri';
$string['backup:backupcourse'] = 'Kursları Yedekle';
$string['backup:backupsection'] = 'Yedekleme bölümleri';
$string['backup:backuptargetimport'] = 'Aktarım için yedekle';
$string['backup:configure'] = 'Yedekleme ayarlarını yapılandır';
$string['backup:downloadfile'] = 'Yedekleme alanlarından dosyları indir';
$string['backup:userinfo'] = 'Kullanıcı verisini yedekle';
$string['badges:awardbadge'] = 'Bir kullanıcıya rozet verme';
$string['badges:configurecriteria'] = 'Bir rozet kazanma ölçütlerini ayarla/değiştir';
$string['badges:configuredetails'] = '';
$string['badges:configuremessages'] = 'Rozet mesajlarını yapılandırın';
$string['badges:createbadge'] = 'Rozet Oluştur/kopyala';
$string['badges:deletebadge'] = 'Rozetleri sil';
$string['badges:earnbadge'] = 'Rozet kazan';
$string['badges:manageglobalsettings'] = 'Rozetlerin global ayarlarını yönet';
$string['badges:manageownbadges'] = 'Kendi kazandığınız rozetleri görüntüle ve yönet';
$string['badges:revokebadge'] = 'Rozeti bir kullanıcıdan geri alma';
$string['badges:viewawarded'] = '';
$string['badges:viewbadges'] = 'Kazanmadan uygun rozetleri göster';
$string['badges:viewotherbadges'] = 'Herkese açık rozetleri diğer kullanıcıların profillerinde görüntüleyin';
$string['block:edit'] = 'Blok ayarını değiştir';
$string['block:view'] = 'Bloka bak';
$string['blog:create'] = 'Yeni blog kayıtları oluştur';
$string['blog:manageentries'] = 'Kayıtları düzelt ve yönet';
$string['blog:manageexternal'] = 'Harici blogları düzelt ve yönet';
$string['blog:search'] = 'Blog kayıtlarını ara';
$string['blog:view'] = 'Blog kayıtlarına bak';
$string['blog:viewdrafts'] = 'Taslak blog kayıtlarına bak';
$string['calendar:manageentries'] = 'Bütün takvim kayıtlarını yönet';
$string['calendar:managegroupentries'] = 'Grup takvimi kayıtlarını yönet';
$string['calendar:manageownentries'] = 'Kendisinin takvim kayıtlarını yönet';
$string['capabilities'] = 'Yetkiler';
$string['capability'] = 'Yetki';
$string['category:create'] = 'Kategorileri oluştur';
$string['category:delete'] = 'Kategorileri sil';
$string['category:manage'] = 'Kategorileri yönet';
$string['category:update'] = 'Kategorileri güncelle';
$string['category:viewcourselist'] = 'Kurs kategorisini ve içindeki kursları görüntüle';
$string['category:viewhiddencategories'] = 'Gizli kategorileri gör';
$string['category:visibility'] = 'Gizli kategorileri gör';
$string['checkglobalpermissions'] = 'Sistem izinlerini kontrol et';
$string['checkpermissions'] = 'İzinleri kontrol et';
$string['checkpermissionsin'] = 'İzinleri kontrol et: {$a}';
$string['checksystempermissionsfor'] = '{$a->fullname} için sistem izinlerini kontrol et';
$string['checkuserspermissionshere'] = 'Bu {$a->contextlevel} değerinde {$a->fullname} için izinleri kontrol edin.';
$string['chooseroletoassign'] = 'Lütfen atanacak rolü seçin';
$string['cohort:assign'] = 'Topluluk üyeleri ekleme ve kaldırma';
$string['cohort:configurecustomfields'] = 'Topluluk özel alanlarını yapılandırın';
$string['cohort:manage'] = 'Toplulukları oluştur, sil ve taşı';
$string['cohort:view'] = 'Site çapındaki toplulukları görüntüle';
$string['comment:delete'] = 'Yorumları sil';
$string['comment:post'] = 'Yorum gönder';
$string['comment:view'] = 'Yorumları görüntüle';
$string['competency:competencygrade'] = 'Yetkinlik puanlamasaını ayarla';
$string['competency:competencymanage'] = 'Yetkinlik çerçevelerini yönet';
$string['competency:competencyview'] = 'Yetkinlik çerçevelerini görüntüle';
$string['competency:coursecompetencyconfigure'] = 'Kurs yetkinliği ayarlarını yapılandır';
$string['competency:coursecompetencygradable'] = 'Yetkinlik notlarını çek/getir';
$string['competency:coursecompetencymanage'] = 'Kurs yetkinliklerini yönet';
$string['competency:coursecompetencyview'] = 'Kurs yetkinliklerini görüntüle';
$string['competency:evidencedelete'] = 'Kanıtları sil';
$string['competency:plancomment'] = 'Öğrenme planında yorum yap';
$string['competency:plancommentown'] = 'Kendi öğrenme planına yorum yap';
$string['competency:planmanage'] = 'Öğrenme planlarını yönet';
$string['competency:planmanagedraft'] = 'Taslak öğrenme planlarını yönet';
$string['competency:planmanageown'] = 'Kendi öğrenme planlarını yönet';
$string['competency:planmanageowndraft'] = 'Kendi taslak öğrenme planlarını yönet';
$string['competency:planrequestreview'] = 'Bir öğrenme planının incelenmesini isteyin';
$string['competency:planrequestreviewown'] = 'Kendi öğrenme planının gözden geçirilmesini isteyin';
$string['competency:planreview'] = 'Bir öğrenme planını gözden geçir';
$string['competency:planview'] = 'Tüm öğrenme planlarını görüntüle';
$string['competency:planviewdraft'] = 'Taslak öğrenme planlarını görüntüle';
$string['competency:planviewown'] = 'Kendi öğrenme planlarını görüntüle';
$string['competency:planviewowndraft'] = 'Kendi taslak öğrenme planlarını görüntüle';
$string['competency:templatemanage'] = 'Öğrenme planı şablonlarını yönet';
$string['competency:templateview'] = 'Öğrenme planı şablonlarını görüntüle';
$string['competency:usercompetencycomment'] = 'Kullanıcı yetkinliklerine yorum yap';
$string['competency:usercompetencycommentown'] = 'Kendi kullanıcı yetkinliklerine yorum yap';
$string['competency:usercompetencyrequestreview'] = 'Bir kullanıcı yetkinliklerinin incelenmesini iste';
$string['competency:usercompetencyrequestreviewown'] = 'Kendi kullanıcı yetkinliklerinin incelenmesini iste';
$string['competency:usercompetencyreview'] = 'Bir kullanıcı yetkinliklerini incele';
$string['competency:usercompetencyview'] = 'Kullanıcı yetkinliğini görüntüle';
$string['competency:userevidencemanage'] = 'Önceki öğrenmenin kanıtlarını yönet';
$string['competency:userevidencemanageown'] = 'Kendi önceki öğrenme kanıtlarınızı yönetin';
$string['competency:userevidenceview'] = 'Bir kullanıcının önceki öğrenmesine ilişkin kanıtları görüntüleyin';
$string['confirmaddadmins'] = 'Aşağıdaki kullanıcıları site yöneticileri listesine eklemek istediğinizden emin misiniz?';
$string['confirmremoveadmins'] = 'Aşağıdaki kullanıcıları site yöneticileri listesinden çıkarmak istediğinizden emin misiniz?';
$string['confirmroleprevent'] = '"{$a->context}" bağlamında "{$a->cap}" yeteneği için izin verilen roller listesinden gerçekten <strong>"{$a->role}"</strong> \'nı kaldırmak istiyor musunuz?';
$string['confirmroleunprohibit'] = '"{$a->context}" bağlamında "{$a->cap}" yeteneği için yasaklanmış roller listesinden <strong>"{$a->role}"</strong> \'nı gerçekten kaldırmak istiyor musunuz?';
$string['confirmunassign'] = 'Bu kullanıcıdan bu rolü kaldırmak istediğinize emin misiniz?';
$string['confirmunassignno'] = 'İptal';
$string['confirmunassigntitle'] = 'Rol değişikliğini onayla';
$string['confirmunassignyes'] = 'Kaldır';
$string['contentbank:access'] = 'İçerik bankasına erişin';
$string['contentbank:changelockedcustomfields'] = 'İçerik bankası kilitli özel alanları değiştirme';
$string['contentbank:configurecustomfields'] = 'İçerik bankası için özel alanları yapılandırma';
$string['contentbank:copyanycontent'] = 'İçerik bankasındaki herhangi bir içeriği kopyalayın';
$string['contentbank:copycontent'] = 'İçerik bankasındaki içeriği kopyalayın';
$string['contentbank:deleteanycontent'] = 'İçerik bankasından herhangi bir içeriği silin';
$string['contentbank:deleteowncontent'] = 'İçeriği kendi içerik bankasından silin';
$string['contentbank:downloadcontent'] = 'İçerik bankasından içerik indirme';
$string['contentbank:manageanycontent'] = 'İçerik bankasından herhangi bir içeriği yönetin';
$string['contentbank:manageowncontent'] = 'İçeriği kendi içerik bankasından yönetin';
$string['contentbank:upload'] = 'İçerik bankasına yeni içerik yükleyin';
$string['contentbank:useeditor'] = 'Bir içerik türü düzenleyici kullanarak içerik oluşturun veya düzenleyin';
$string['contentbank:viewunlistedcontent'] = 'Liste dışı içeriği içerik bankasından görüntüle';
$string['context'] = 'Bağlam';
$string['contextrolenotallowed'] = '{$a} rolüne bu bağlamda izin verilmiyor.';
$string['course:activityvisibility'] = 'Etkinlikleri gizle/göster';
$string['course:bulkmessaging'] = 'Birçok kişiye bir mesaj gönder';
$string['course:changecategory'] = 'Kurs kategorisini değiştir';
$string['course:changefullname'] = 'Kurs tam adını değiştir';
$string['course:changeidnumber'] = 'Kurs ID numarasını değiştir';
$string['course:changelockedcustomfields'] = 'Kilitli özel alanları değiştirme';
$string['course:changeshortname'] = 'Kurs kısa adını değiştir';
$string['course:changesummary'] = 'Kurs özetini değiştir';
$string['course:configurecoursecommunication'] = 'Kurs iletişim ayarlarını yapılandırın';
$string['course:configurecustomfields'] = 'Kurs özel alanlarını yapılandırın';
$string['course:configuredownloadcontent'] = 'Kurs içeriğini indirmeyi yapılandırın';
$string['course:create'] = 'Kurs oluştur';
$string['course:creategroupconversations'] = 'Grup görüşmeleri oluşturun';
$string['course:delete'] = 'Kursları sil';
$string['course:downloadcoursecontent'] = 'Kurs içeriğini indir';
$string['course:editcoursewelcomemessage'] = 'Kurs karşılama mesajını düzenleyin';
$string['course:enrolconfig'] = 'Kurslardaki kayıt örneklerini yapılandır';
$string['course:enrolreview'] = 'Kurs kayıtlarını incele';
$string['course:ignoreavailabilityrestrictions'] = 'Uygunluk kısıtlamalarını yoksay';
$string['course:ignorefilesizelimits'] = 'Herhangi bir dosya boyutu sınırlamasından daha büyük dosyaları kullanın';
$string['course:isincompletionreports'] = 'Tamamlanma raporlarında gösterilsin';
$string['course:manageactivities'] = 'Etkinlikleri yönet';
$string['course:managefiles'] = 'Dosyaları yönet';
$string['course:managegrades'] = 'Notları yönet';
$string['course:managegroups'] = 'Grupları yönet';
$string['course:managescales'] = 'Ölçekleri yönet';
$string['course:markcomplete'] = 'Kullanıcıları kurs tamamlamada tamamlandı olarak işaretle';
$string['course:movesections'] = 'Bölümleri taşı';
$string['course:overridecompletion'] = 'Etkinlik tamamlama durumunu geçersiz kıl';
$string['course:recommendactivity'] = 'Etkinlik seçicide etkinlikler önerme';
$string['course:renameroles'] = 'Rolleri yeniden isimlendir';
$string['course:request'] = 'Yeni kurslar iste';
$string['course:reset'] = 'Kursu ilk duruma getir';
$string['course:reviewotherusers'] = 'Diğer kullanıcıları inceleyin';
$string['course:sectionvisibility'] = 'Bölüm gizliliğini değiştir';
$string['course:setcurrentsection'] = 'Şimdiki bölümü ayarla';
$string['course:setforcedlanguage'] = 'Kurs veya etkinlik dilini zorla';
$string['course:tag'] = 'Kurs etiketlerini değiştir';
$string['course:togglecompletion'] = 'Etkinlikleri kendiniz tamamlandı olarak işaretleyin';
$string['course:update'] = 'Kurs ayarlarını güncelle';
$string['course:useremail'] = 'Eposta adreslerini etkinleştir/pasifleştir';
$string['course:view'] = 'Katılımsız kursları görüntüle';
$string['course:viewcoursegrades'] = 'Kursun başarı notlarına bak';
$string['course:viewhiddenactivities'] = 'Gizli etkinliklere bak';
$string['course:viewhiddencourses'] = 'Gizli kurslara bak';
$string['course:viewhiddengroups'] = 'Gizli grupları görüntüle';
$string['course:viewhiddensections'] = 'Gizli bölümlere bak';
$string['course:viewhiddenuserfields'] = 'Gizli kullanıcı alanlarına bak';
$string['course:viewparticipants'] = 'Katılımcılara bak';
$string['course:viewscales'] = 'Ölçeklere bak';
$string['course:viewsuspendedusers'] = 'Askıya alınan kullanıcıları görüntüle';
$string['course:visibility'] = 'Kursları gizle/göster';
$string['createrolebycopying'] = '{$a} kopyalayarak yeni bir rol oluştur';
$string['createthisrole'] = 'Bu rolü oluştur';
$string['currentcontext'] = 'Geçerli bağlam';
$string['currentrole'] = 'Geçerli rol';
$string['customroledescription'] = 'Özel açıklama';
$string['customroledescription_help'] = 'Standart rollerin açıklamaları, özel açıklama yoksa otomatik olarak yerelleştirilir.';
$string['customrolename'] = 'Özel tam adı';
$string['customrolename_help'] = 'Özel adı boş bırakırsanız, standart rol adları otomatik olarak yerelleştirilir. Tüm özel roller için tam bir ad sağlamalısınız.';
$string['defaultrole'] = 'Varsayılan rol';
$string['defaultx'] = 'Varsayılan: {$a}';
$string['defineroles'] = 'Rolleri tanımla';
$string['definitionofrolex'] = '\'{$a}\' rolünün tanımı';
$string['deletecourseoverrides'] = 'Kurstaki tüm rolleri geçersiz kıl';
$string['deletelocalroles'] = 'Tüm yerel rol atamaları';
$string['deleterolesure'] = '<p>"{$a->name} ({$a->shortname})" rolünü silmek istediğinizden emin misiniz?</p><p>Şu anda bu rol {$a->count}\'a atanmıştır. kullanıcı.</p>';
$string['deletexrole'] = '{$a} rolünü sil';
$string['duplicaterole'] = 'Rolü kopyala';
$string['duplicaterolesure'] = '"{$a->name} ({$a->shortname})" rolünü kopyalamak istediğinizden emin misiniz?';
$string['editingrolex'] = '\'{$a}\' düzenleniyor';
$string['editrole'] = 'Rolü düzenle';
$string['editxrole'] = 'Rolü düzenle';
$string['errorbadrolename'] = 'Hatalı rol adı';
$string['errorbadroleshortname'] = 'Yanlış rol kısa adı';
$string['errorexistsrolename'] = 'Rol adı zaten var';
$string['errorexistsroleshortname'] = 'Rol adı zaten var';
$string['errorroleshortnametoolong'] = 'Kısa ad 100 karakteri geçmemelidir';
$string['eventcapabilityassigned'] = 'Atanan yetenek';
$string['eventcapabilityunassigned'] = 'Yetenek atanmadı';
$string['eventroleallowassignupdated'] = 'Rol atamasına izin ver';
$string['eventroleallowoverrideupdated'] = 'Rol geçersiz kılmaya izin ver';
$string['eventroleallowswitchupdated'] = 'Rol değişimine izin ver';
$string['eventroleallowviewupdated'] = 'Rol görünümüne izin ver';
$string['eventroleassigned'] = 'Rol atandı';
$string['eventrolecapabilitiesupdated'] = 'Rol özellikleri güncellendi';
$string['eventrolecreated'] = 'Rol oluşturuldu';
$string['eventroledeleted'] = 'Rol silindi';
$string['eventroleunassigned'] = 'Rol ataması geri alındı';
$string['eventroleupdated'] = 'Rol güncellendi';
$string['existingadmins'] = 'Mevcut site yöneticileri';
$string['existingusers'] = '{$a} mevcut kullanıcı';
$string['explanation'] = 'Açıklama';
$string['export'] = 'Dışa aktar';
$string['extusers'] = 'Mevcut kullanıcılar';
$string['extusersmatching'] = '\'{$a}\' ile eşleşen mevcut kullanıcılar';
$string['filter:manage'] = 'Yerel filtre ayarlarını yönet';
$string['frontpageuser'] = 'Ana sayfadaki kimliği doğrulanmış kullanıcı';
$string['frontpageuserdescription'] = 'Site anasayasındaki kursda oturum açmış tüm kullanıcılar.';
$string['globalrole'] = 'Sistem rolü';
$string['globalroleswarning'] = 'Uyarı: Bu sayfadan atadığınız roller, site ana sayfası ve tüm kurslar dahil olmak üzere tüm sistemdeki kullanıcılar için geçerli olacaktır.';
$string['gotoassignroles'] = '{$a->contextlevel} bağlamında rolleri ata';
$string['gotoassignsystemroles'] = 'Sistem rollerini ata';
$string['grade:edit'] = 'Başarı notlarını düzenle';
$string['grade:export'] = 'Başarı notlarını dışa ver';
$string['grade:hide'] = 'Başarı notlarını veya ögeleri gizle/göster';
$string['grade:import'] = 'Notlarını içe aktar';
$string['grade:lock'] = 'Başarı notlarını veya ögeleri kilitle';
$string['grade:manage'] = 'Başarı notları ögelerini yönet';
$string['grade:managegradingforms'] = 'Gelişmiş puanlama yöntemlerini yönet';
$string['grade:manageletters'] = 'Başarı notları harflerini yönet';
$string['grade:manageoutcomes'] = 'Kazanım değerlendirmelerini yönetme';
$string['grade:managesharedforms'] = 'Gelişmiş puanlama formu şablonlarını yönetin';
$string['grade:override'] = 'Notları geçersiz kıl';
$string['grade:sharegradingforms'] = 'Gelişmiş punlama formunu şablon olarak paylaşın';
$string['grade:unlock'] = 'Başarı notlarının veya ögelerin kilidini aç';
$string['grade:view'] = 'Kendi notuna bak';
$string['grade:viewall'] = 'Diğer kullanıcıların başarı notlarına bak';
$string['grade:viewhidden'] = 'Sahibi için gizli başarı notlarına bak';
$string['group:configurecustomfields'] = 'Grup/gruplama özel alanlarını yapılandırma';
$string['h5p:deploy'] = 'H5P içeriği dağıtın';
$string['h5p:setdisplayoptions'] = 'H5P görüntüleme seçeneklerini ayarlayın';
$string['h5p:updatelibraries'] = 'H5P içerik türlerini yönetin';
$string['highlightedcellsshowdefault'] = 'Aşağıdaki tabloda vurgulanan izinler, yukarıda seçilen rol modelinin varsayılanlarıdır.';
$string['highlightedcellsshowinherit'] = 'Aşağıdaki tabloda vurgulanan hücreler devralınacak izinleri (varsa) göstermektedir. İzin vermek istediğin yeteneklerin yanında, her şeyi Devralınmış olarak bırakmalısın.';
$string['inactiveformorethan'] = '{$a->timeperiod} dır etkin değil';
$string['ingroup'] = '"{$a->group}" grubunda';
$string['inherit'] = 'Devral';
$string['invalidpresetfile'] = 'Geçersiz rol tanımlama dosyası';
$string['legacy:admin'] = 'DEVRALINAN ROL: Yönetici';
$string['legacy:coursecreator'] = 'DEVRALINAN ROL: Kurs oluşturucu';
$string['legacy:editingteacher'] = 'DEVRALINAN ROL: Öğretmen (düzenleyen)';
$string['legacy:guest'] = 'DEVRALINAN ROL: Konuk';
$string['legacy:student'] = 'DEVRALINAN ROL: Öğrenci';
$string['legacy:teacher'] = 'DEVRALINAN ROL: Öğretmen (düzenlemeyen)';
$string['legacy:user'] = 'DEVRALINAN ROL: Yetkili kullanıcı';
$string['legacytype'] = 'Devralınan rol tipi';
$string['listallroles'] = 'Tüm rolleri listele';
$string['localroles'] = 'Yerel olarak atanmış roller';
$string['mainadmin'] = 'Ana yönetici';
$string['mainadminset'] = 'Ana yönetici olarak ayarla';
$string['manageadmins'] = 'Site yöneticilerini yönet';
$string['manager'] = 'Yönetici';
$string['managerdescription'] = 'Yöneticiler kurslara erişebilir ve bunları değiştirebilir, ancak genellikle kurslara katılmazlar.';
$string['manageroles'] = 'Rolleri yönet';
$string['maybeassignedin'] = 'Bu role atanabilir bağlam tipleri';
$string['moodlenet:shareactivity'] = 'Etkinlikleri MoodleNet\'te paylaşın';
$string['moodlenet:sharecourse'] = 'Kursu MoodleNet\'te paylaşma';
$string['morethan'] = '{$a} \'den daha fazla';
$string['multipleroles'] = 'Çoklu roller';
$string['my:configsyspages'] = 'Gösterge tablosu sayfaları için sistem şablonlarını yapılandırma';
$string['my:manageblocks'] = 'Kontrol Panelinden sayfa bloklarını yönetin';
$string['neededroles'] = 'İzinli roller';
$string['nocapabilitiesincontext'] = 'Bu bağlamda yetki yok';
$string['noneinthisx'] = '{$a} bağlamında hiçbir şey yok';
$string['noneinthisxmatching'] = '{$a->contexttype} bağlamında  \'{$a->search}\' ile eşleşen kullanıcı yok';
$string['norole'] = 'Rol yok';
$string['noroleassignments'] = 'Bu kullanıcının bu sitede herhangi bir rol ataması yok.';
$string['noroles'] = 'Rol yok';
$string['notabletoassignroleshere'] = 'Bu bağlamda rollerin atanması bir yönetici tarafından etkinleştirilmedi.';
$string['notabletooverrideroleshere'] = 'Buradaki rollerle ilgili izinleri geçersiz kılamazsınız';
$string['notes:manage'] = 'Notları yönet';
$string['notes:view'] = 'Notlara bak';
$string['notset'] = 'Ayarlanmamış';
$string['novisibleroles'] = 'Rol yok';
$string['overrideanotherrole'] = 'Diğer rolleri yeniden düzenle';
$string['overridecontext'] = 'Bağlamı yeniden düzenle';
$string['overridepermissions'] = 'Eski izinleri geçersiz kıl';
$string['overridepermissions_help'] = 'İzinler geçersiz kılmaları, seçilen özelliklerin belirli bir bağlamda izin verilmesini veya engellenmesini sağlar.';
$string['overridepermissions_link'] = 'admin/roles/override';
$string['overridepermissionsforrole'] = 'Rol için geçersiz kılma izinleri\' {$a->role}\' in {$a->context}';
$string['overridepermissionsin'] = '{$a} içindeki eski izinleri geçersiz kıl';
$string['overrideroles'] = 'Rollerin üstüne yaz';
$string['overriderolesin'] = '{$a} rollerini geçersiz kıl';
$string['overrides'] = 'Eskisini geçersiz kıl';
$string['overridesbycontext'] = 'Geçersiz Kılmalar (bağlam tarafından)';
$string['payment:manageaccounts'] = 'Hesapları yönet';
$string['payment:viewpayments'] = 'Ödemeleri görüntüle';
$string['permission'] = 'İzin';
$string['permission_help'] = 'İzinler yetenek ayarlarıdır. 4 seçenek var:

* Ayarlanmadı
* İzin ver - Yetki için izin verilir
* Önleme - Daha yüksek bir bağlamda izin verilmesine rağmen yetki için izin kaldırılır
* Yasaklamak - İzin tamamen reddedildi ve daha düşük (daha spesifik) bağlamda geçersiz kılınamaz';
$string['permissions'] = 'İzinler';
$string['permissionsforuser'] = '{$a} kullanıcı için izinler';
$string['permissionsincontext'] = '{$a} İçindeki izinler';
$string['portfolio:export'] = 'Portfolyoya çıkart';
$string['potentialusers'] = '{$a} olası kullanıcı';
$string['potusers'] = 'Olası kullanıcılar';
$string['potusersmatching'] = '\'{$a}\' ile eşleşen olası kullanıcılar';
$string['prevent'] = 'Engelle';
$string['privacy:metadata:preference:showadvanced'] = 'Gelişmiş modu değiştir düğmesini kullanın.';
$string['privacy:metadata:role_assignments'] = 'Rol atamaları';
$string['privacy:metadata:role_assignments:component'] = 'Rol atamasından sorumlu eklenti, manuel olarak atandığında boş.';
$string['privacy:metadata:role_assignments:itemid'] = 'Bu rol atamasından sorumlu kayıt/yetkilendirme örneğinin kimliği';
$string['privacy:metadata:role_assignments:modifierid'] = 'Rol atamasını oluşturan veya değiştiren kullanıcının kimliği';
$string['privacy:metadata:role_assignments:roleid'] = 'Rol kimliği';
$string['privacy:metadata:role_assignments:tableexplanation'] = 'Bu tablo, her bağlamda atanan rolleri saklar.';
$string['privacy:metadata:role_assignments:timemodified'] = 'Rol atamasının oluşturulduğu veya değiştirildiği tarih.';
$string['privacy:metadata:role_assignments:userid'] = 'Kullanıcının kimliği';
$string['privacy:metadata:role_capabilities'] = 'Rol yetenekleri';
$string['privacy:metadata:role_capabilities:capability'] = 'Yeteneğin adı.';
$string['privacy:metadata:role_capabilities:modifierid'] = 'Yeteneği oluşturan veya değiştiren kullanıcının kimliği';
$string['privacy:metadata:role_capabilities:permission'] = 'Bir yetenek için izin: devral, izin ver, engelle veya yasakla.';
$string['privacy:metadata:role_capabilities:roleid'] = 'Rol kimliği';
$string['privacy:metadata:role_capabilities:tableexplanation'] = 'Belirli bir bağlamda belirli bir rol için yetenekler ve geçersiz kılma yetenekleri';
$string['privacy:metadata:role_capabilities:timemodified'] = 'Yeteneğin oluşturulduğu veya değiştirildiği tarih.';
$string['privacy:metadata:role_cohortroles'] = 'Topluluk için roller';
$string['prohibit'] = 'Yasakla';
$string['prohibitedroles'] = 'Yasaklanmış';
$string['question:add'] = 'Yeni sorular ekle';
$string['question:commentall'] = 'Tüm sorulara yorum yapın';
$string['question:commentmine'] = 'Kendi sorularınıza yorum yapın';
$string['question:config'] = 'Soru tiplerini yapılandır';
$string['question:editall'] = 'Tüm soruları düzenle';
$string['question:editmine'] = 'Kendi sorularını düzenle';
$string['question:flag'] = 'Soruları uygularken işaretle';
$string['question:managecategory'] = 'Soru kategorilerini düzenle';
$string['question:moveall'] = 'Tüm soruları taşı';
$string['question:movemine'] = 'Kendi sorularını taşı';
$string['question:tagall'] = 'Tüm soruları etiketle';
$string['question:tagmine'] = 'Kendi sorularınızı etiketleyin';
$string['question:useall'] = 'Tüm soruları kullan';
$string['question:usemine'] = 'Kendi sorularını kullan';
$string['question:viewall'] = 'Tüm sorulara bak';
$string['question:viewmine'] = 'Kendi sorularına bak';
$string['rating:rate'] = 'Öğelere değerlendirme ekle';
$string['rating:view'] = 'Aldığınız toplam oyu görüntüleyin';
$string['rating:viewall'] = 'Bireylerin verdiği tüm ham notları görüntüle';
$string['rating:viewany'] = 'Birinin aldığı toplam oyu görüntüle';
$string['reportbuilder:edit'] = 'Kendi özel raporlarınızı düzenleyin';
$string['reportbuilder:editall'] = 'Tüm özel raporları düzenle';
$string['reportbuilder:scheduleviewas'] = 'Raporları diğer kullanıcılar olarak görüntülenecek şekilde planlayın';
$string['reportbuilder:view'] = 'Özel raporları görüntüle';
$string['reportbuilder:viewall'] = 'Tüm özel raporları görüntüleyin';
$string['resetrole'] = 'Sıfırla';
$string['resettingrole'] = '\'{$a}\' rolü sıfırlanıyor';
$string['restore:configure'] = 'Geri yükleme seçeneklerini yapılandır';
$string['restore:createuser'] = 'Geri yükleme üzerinde kullanıcıları oluştur';
$string['restore:restoreactivity'] = 'Etkinlikleri geri yükle';
$string['restore:restorecourse'] = 'Kursları geri yükle';
$string['restore:restoresection'] = 'Bölümleri geri yükle';
$string['restore:restoretargetimport'] = 'İçe aktarma olarak hedeflenen dosyalardan geri yükle';
$string['restore:rolldates'] = 'Geri yükleme sırasında etkinlik yapılandırma tarihlerini kaydetme izni';
$string['restore:uploadfile'] = 'Dosyaları yedekleme alanlarına yükle';
$string['restore:userinfo'] = 'Kullanıcı verisini geri yükle';
$string['restore:viewautomatedfilearea'] = 'Kursları otomatik yedeklemelerden geri yükleme';
$string['risks'] = 'Riskler';
$string['role:assign'] = 'Kullanıcılara rol ata';
$string['role:manage'] = 'Rolleri oluştur ve yönet';
$string['role:override'] = 'Diğerleri için eski izinleri geçersiz kıl';
$string['role:review'] = 'Diğerlerinin izinlerini göster';
$string['role:safeoverride'] = 'Diğerleri için güvenli izinlerin üzerine yaz';
$string['role:switchroles'] = 'Roller arası geçiş yap';
$string['roleallowheader'] = 'Role izin ver:';
$string['roleallowinfo'] = '"{$a->context}" bağlamında izin verilen roller listesine eklenecek bir rol seçin, "{$a->cap}" yeteneği:';
$string['roleassignment'] = 'Rol atamaları';
$string['roleassignments'] = 'Rol atamaları';
$string['roledefinitions'] = 'Rol tanımlamaları';
$string['rolefullname'] = 'Ad';
$string['roleincontext'] = '{$a->role}, {$a->context} içinde';
$string['roleoriginalname'] = 'Özgün adı';
$string['roleprohibitheader'] = 'Rolü yasakla';
$string['roleprohibitinfo'] = '"{$a->context}" bağlamında yasaklanmış roller listesine eklenecek bir rol seçin, "{$a->cap}" yeteneği:';
$string['rolerepreset'] = 'Rol önayarını kullan';
$string['roleresetdefaults'] = 'Varsayılanlar';
$string['roleresetrole'] = 'Rolü ya da örneği kullan';
$string['rolerisks'] = 'Rol riskleri';
$string['roles'] = 'Roller';
$string['roles_help'] = 'Bir rol, belirli bağlamlarda belirli kullanıcılara atayabileceğiniz tüm sistem için tanımlanmış izinler topluluğudur.';
$string['roles_link'] = 'roles';
$string['roleselect'] = 'Rol seç';
$string['rolesforuser'] = '{$a} Kullanıcısı için roller';
$string['roleshortname'] = 'Kısa ad';
$string['roleshortname_help'] = 'Rol kısa adı, yalnızca ASCII alfanümerik karakterlere izin verilen düşük seviyeli bir rol tanımlayıcısıdır.';
$string['roletoassign'] = 'Atanacak rol';
$string['roletooverride'] = 'Tekrar tanımlanacak rol';
$string['safeoverridenotice'] = 'Not: Güvenli izinleri geçersiz kılma iznini vermediğiniz için yüksek riskli yetkiler kilitlenmiştir.';
$string['search:query'] = 'Site çapında arama yapın';
$string['selectanotheruser'] = 'Başka kullanıcı seç';
$string['selectauser'] = 'Bir kullanıcı seç';
$string['selectrole'] = 'Bir rol seçin';
$string['showallroles'] = 'Tüm rolleri göster';
$string['showthisuserspermissions'] = 'Bu kullanıcının izinlerini göster';
$string['site:accessallgroups'] = 'Tüm gruplara eriş';
$string['site:approvecourse'] = 'Kurs oluşturmayı onayla';
$string['site:backup'] = 'Kursları yedekle';
$string['site:config'] = 'Site yapılandırmasını değiştir';
$string['site:configview'] = 'Site yönetimi ağacını (ancak tüm sayfaları değil) görüntüleyin.';
$string['site:deleteanymessage'] = 'Sitedeki tüm iletileri sil';
$string['site:deleteownmessage'] = 'Kullanıcı tarafından gönderilen ve kullanıcı tarafından gönderilen iletileri sil';
$string['site:doanything'] = 'Her şeyi yapmasına izin ver';
$string['site:doclinks'] = 'Site dışı belgelere bağlantıları göster';
$string['site:forcelanguage'] = 'Kurs dilini geçersiz kıl';
$string['site:import'] = 'Bir kursa başka kurslardan içe aktarma yap';
$string['site:maintenanceaccess'] = 'Bakım modundayken siteye erişin';
$string['site:manageallmessaging'] = 'Herhangi bir kullanıcı için kişi ekleme, kaldırma, engelleme ve engellemeyi kaldırma';
$string['site:manageblocks'] = 'Sayfa üzerindeki blokları yönet';
$string['site:managecontextlocks'] = 'Bağlamların dondurulmasını yönetin';
$string['site:messageanyuser'] = 'Herhangi bir kullanıcıya mesaj göndermek için kullanıcı gizlilik tercihlerini atlayın';
$string['site:mnetloginfromremote'] = 'Moodle\'a uzak uygulaması MNet ile giriş yap';
$string['site:mnetlogintoremote'] = 'MNet üzerinden uzaktaki bir uygulamaya dolaşmak';
$string['site:readallmessages'] = 'Sitedeki tüm mesajları oku';
$string['site:restore'] = 'Kursları geri yükle';
$string['site:senderrormessage'] = 'Hata sayfasından destek kullanıcısına bir mesaj gönderin';
$string['site:sendmessage'] = 'Herhangi kullanıcıya mesaj gönder';
$string['site:trustcontent'] = 'Gönderilen içeriğe güven';
$string['site:uploadusers'] = 'Dosyadan yeni kullanıcı yükle';
$string['site:viewanonymousevents'] = 'Anonim olayları raporlarda görüntüle';
$string['site:viewfullnames'] = 'Kullanıcıların tam isimlerini gör';
$string['site:viewparticipants'] = 'Katılımcılara bak';
$string['site:viewreports'] = 'Raporlara bak';
$string['site:viewuseridentity'] = 'Tam kullanıcı kimliğini listelerde gör';
$string['siteadministrators'] = 'Site yöneticileri';
$string['siteadministratorsconfigphp'] = 'Site yöneticilerinin listesi config.php\'de tanımlandığı için değiştirilemez.';
$string['tag:edit'] = 'Varolan etiketleri düzenle';
$string['tag:editblocks'] = 'Etiket sayfalarındaki blokları düzenle';
$string['tag:flag'] = 'Etiketleri uygunsuz olarak işaretle';
$string['tag:manage'] = 'Tüm etiketleri yönet';
$string['thisnewrole'] = 'Bu yeni rol';
$string['thisusersroles'] = 'Bu kullanıcının rol atamaları';
$string['unassignarole'] = 'Rol atama';
$string['unassignconfirm'] = '"{$a->rol}" rolünü "{$a->user}" kullanıcısından atlamayı gerçekten istemiyor musunuz?';
$string['unassignerror'] = '{$a->user} kullanıcısından {$a->role} rol atamasını kaldırırken hata oluştu.';
$string['user:changeownpassword'] = 'Kendi şifresini değiştir';
$string['user:create'] = 'Kullanıcıları oluştur';
$string['user:delete'] = 'Kullanıcıları sil';
$string['user:editmessageprofile'] = 'Kullanıcı mesajlaşma profilini düzenle';
$string['user:editownmessageprofile'] = 'Kendi kullanıcı mesajlaşma profilini düzenle';
$string['user:editownprofile'] = 'Kendi kullanıcı profilini değiştir';
$string['user:editprofile'] = 'Kullanıcı profilini düzenle';
$string['user:ignoreuserquota'] = 'Kullanıcı kotası sınırını yoksay';
$string['user:loginas'] = 'Farklı kullanıcı olarak giriş yap';
$string['user:manageblocks'] = 'Diğer kullanıcıların kullanıcı profilindeki blokları yönet';
$string['user:manageownblocks'] = 'Kendi genel kullanıcı profilinde blokları yönet';
$string['user:manageownfiles'] = 'Dosyaları kendi özel dosya alanlarında yönet';
$string['user:managesyspages'] = 'Herkese açık kullanıcı profilleri için varsayılan sayfa düzenini yapılandır';
$string['user:readuserblogs'] = 'Bütün kullanıcı bloglarını görüntüle';
$string['user:readuserposts'] = 'Bütün kullanıcı mesajlarını görüntüle';
$string['user:update'] = 'Kullanıcı profillerini güncelle';
$string['user:viewalldetails'] = 'Kullanıcı tam bilgisini göster';
$string['user:viewdetails'] = 'Kullanıcı profillerine bak';
$string['user:viewhiddendetails'] = 'Kullanıcıların gizlenmiş bilgilerine bak';
$string['user:viewlastip'] = 'Kullanıcının son IP adresini göster';
$string['user:viewprofilepictures'] = 'Kullanıcı profil resimlerini görüntüleme (oturum açmaya zorlama etkinse)';
$string['user:viewuseractivitiesreport'] = 'Kullanıcı etkinlik raporlarına bak';
$string['user:viewusergrades'] = 'Kullanıcıların başarı notlarına bak';
$string['usersfrom'] = '{$a}\'dan Kullanıcılar';
$string['usersfrommatching'] = '\'{$a->search}\' ile eşleşen {$a->contextname} \'den kullanıcılar';
$string['usersinthisx'] = 'Bu {$a}\'den kullanıcılar';
$string['usersinthisxmatching'] = 'Bu {$a->contexttype} eşleşen \'{$a->search}\' kullanıcılar,';
$string['userswithrole'] = 'Roldeki bütün kullanıcılar';
$string['userswiththisrole'] = 'Rolü olan kullanıcılar';
$string['useshowadvancedtochange'] = 'Değiştirmek için \'Gelişmişi Göster\' i kullanın';
$string['viewingdefinitionofrolex'] = '\'{$a}\' Rolünün tanımı gösteriliyor';
$string['viewrole'] = 'Rol ayrıntılarına bak';
$string['webservice:createmobiletoken'] = 'Mobil erişim için bir web servis dizgeciği oluştur';
$string['webservice:createtoken'] = 'Bir web servis dizgeciği oluştur';
$string['webservice:managealltokens'] = 'Tüm kullanıcıların web hizmeti belirteçlerini yönetme';
$string['whydoesuserhavecap'] = '{$a->fullname}, {$a->context} bağlamında neden {$a->capability} yeteneğine sahip?';
$string['whydoesusernothavecap'] = '{$a->fullname}, {$a->context} bağlamında neden {$a->capability} yeteneğine sahip değil?';
$string['xroleassignments'] = '{$a}\'nın rol atamaları';
$string['xuserswiththerole'] = '"{$a->role}" rolündeki kullanıcılar {$a->number}';
