<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'quiz', language 'hu', version '5.0'.
 *
 * @package     quiz
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['accessnoticesheader'] = 'Előzetesen megtekintheti a tesztet, de ha ez valóságos próbálkozás volna, Ön nem hajthatná végre, mert:';
$string['action'] = 'Művelet';
$string['activityoverview'] = 'Megoldandó tesztjei vannak';
$string['adaptive'] = 'Adaptív mód';
$string['adaptive_help'] = 'Bekapcsolása esetén egy kérdésre a teszt ugyanazon megoldása során több válasz adható. Így ha egy válasz hibásnak minősül, a tanuló azonnal újból próbálkozhat. Ugyanakkor a "Levonások alkalmazása" beállítástól függően minden hibás válasz esetén megtörténik a levonás.';
$string['add'] = 'Hozzáadás';
$string['addaquestion'] = 'új kérdés';
$string['addarandomquestion'] = 'véletlen kérdés';
$string['addarandomquestion_help'] = 'Véletlenszerű kérdés hozzáadásakor a tesztbe beszúrandó kategóriából származó, véletlenszerűen kiválasztott kérdés kerül. Vagyis a tanulók más-más kérdéseket fognak kapni, és ha a teszten több próbálkozás hajtható végre, akkor minden próbálkozás esetén más-más kérdésekkel fog találkozni.';
$string['addarandomquestion_success'] = 'Véletlenszerű kérdések kerültek hozzáadásra';
$string['addarandomselectedquestion'] = 'Véletlen kérdés hozzáadása';
$string['addasection'] = 'új szakasz fejléce';
$string['adddescriptionlabel'] = 'Leírási tétel hozzáadása';
$string['addingquestion'] = 'Kérdés hozzáadása';
$string['addingquestions'] = 'Az oldalon itt kezelheti kérdéseinek adatbázisát. A kérdések kategóriákba vannak rendezve és kurzusán belül bármely tesztben felhasználhatók, sőt, más kurzusokban is, ha úgy dönt, hogy "közzéteszi" őket.

Kérdéskategória kiválasztása vagy létrehozása után kérdéseket hozhat létre vagy szerkeszthet. A kérdések közül bármelyiket kiválaszthatja és hozzáadhatja az oldal másik felén lévő teszthez.';
$string['addmoreoverallfeedbacks'] = 'További {no} visszajelzésmező hozzáadása';
$string['addnewgroupoverride'] = 'Csoportos felülírás hozzáadása';
$string['addnewpagesafterselected'] = 'Új oldalak hozzáadása a kiválasztott kérdések után';
$string['addnewquestionsqbank'] = 'Kérdések hozzáadása a(z)  {$a->catname}: {$a->link} kategóriához';
$string['addnewuseroverride'] = 'Felhasználói felülírás hozzáadása';
$string['addpagebreak'] = 'Oldaltörés beszúrása';
$string['addpagehere'] = 'Oldal hozzáadása ide';
$string['addquestion'] = 'Kérdés hozzáadása';
$string['addquestionfrombankatend'] = 'Hozzáadás a kérdésbankból a végéhez';
$string['addquestionfrombanktopage'] = 'Kérdésbankból {$a} oldalhoz való hozzáadás';
$string['addquestions'] = 'Kérdések hozzáadása';
$string['addquestionstoquiz'] = 'Kérdések hozzáadása ehhez a teszthez';
$string['addrandom'] = '{$a} véletlenszerű kérdés hozzáadása';
$string['addrandom1'] = '<< Hozzáadás';
$string['addrandom2'] = 'véletlenszerű kérdések';
$string['addrandomfromcategory'] = 'Véletlenszerű kérdések hozzáadása ebből a kategóriából:';
$string['addrandomquestion'] = 'Véletlenszerű kérdés hozzáadása';
$string['addrandomquestionatend'] = 'Véletlen kérdés hozzáadás a végéhez';
$string['addrandomquestiontopage'] = '{$a} oldalhoz véletlen kérdés hozzáadása';
$string['addrandomquestiontoquiz'] = 'Véletlenszerű kérdés hozzáadása a(z) {$a} teszthez';
$string['addselectedquestionstoquiz'] = 'A kiválasztott kérdések hozzáadása a teszthez';
$string['addselectedtoquiz'] = 'Kiválasztott hozzáadása a teszthez';
$string['addtoquiz'] = 'Hozzáadás a teszthez';
$string['affectedstudents'] = 'Érintett {$a}';
$string['aftereachquestion'] = 'Az egyes kérdések hozzáadása után';
$string['afternquestions'] = '{$a} kérdés hozzáadása után';
$string['age'] = 'kor';
$string['allattempts'] = 'Minden próbálkozás';
$string['allinone'] = 'Korlátlan';
$string['allowreview'] = 'Ellenőrzés engedélyezése';
$string['alreadysubmitted'] = 'Ezt a próbálkozást már feltehetőleg leadta';
$string['alternativeunits'] = 'Alternatív egységek';
$string['alwaysavailable'] = 'Mindig elérhető';
$string['alwayslatest'] = 'Mindig a legutóbbi';
$string['analysisoptions'] = 'Elemzési lehetőségek';
$string['analysistitle'] = 'Tételelemzési táblázat';
$string['answer'] = 'Válasz';
$string['answered'] = 'Megválaszolva';
$string['answerhowmany'] = 'Egy vagy több válasz?';
$string['answers'] = 'Válaszok';
$string['answersingleno'] = 'Több válasz lehetséges';
$string['answersingleyes'] = 'Csak egy válasz';
$string['answertoolong'] = 'A válasz a {$a} sor után túl hosszú (max. 255 kar.)';
$string['anytags'] = 'Bármely címke';
$string['aon'] = 'AON-forma';
$string['areyousureremoveselected'] = 'Biztosan törli az összes kiválasztott kérdést?';
$string['asshownoneditscreen'] = 'Amint a szerkesztő képernyőn látható.';
$string['attempt'] = '{$a} próbálkozás';
$string['attemptalreadyclosed'] = 'A próbálkozás már véget ért.';
$string['attemptclosed'] = 'A próbálkozás még nincs lezárva';
$string['attemptduration'] = 'Felhasznált idő';
$string['attemptedon'] = 'Próbálkozás ideje';
$string['attempterror'] = 'Most nem próbálkozhat ezzel a teszttel, mert: {$a}';
$string['attempterrorcontentchange'] = 'A teszt előnézete megszűnt. (A teszt szerkesztése közben elkészült előnézetek automatikusan törlődnek.)';
$string['attempterrorcontentchangeforuser'] = 'A teszt kipróbálása megszűnt.';
$string['attempterrorinvalid'] = 'A teszt kipróbálásának érvénytelen azonosítója';
$string['attemptfirst'] = 'Első próbálkozás';
$string['attemptgradeddelay'] = 'Próbálkozás értékelve értesítés késleltetése';
$string['attemptgradeddelay_desc'] = 'Késleltetés alkalmazása a próbálkozás értékeléséről szóló értesítések elküldése előtt, lehetővé téve a tanárnak az értékelés módosítását.';
$string['attemptincomplete'] = 'A próbálkozás ({$a} részéről) még nem fejeződött be.';
$string['attemptlast'] = 'Utolsó próbálkozás';
$string['attemptnumber'] = 'Próbálkozás';
$string['attemptquiz'] = 'A teszt kitöltése';
$string['attemptquiznow'] = 'Teszt megoldása most';
$string['attemptreviewtitle'] = '{$a}: Próbálkozás áttekintése';
$string['attemptreviewtitlepaged'] = '{$a->name}: Próbálkozás áttekintése
({$a->currentpage}. oldal /  {$a->totalpages} oldal)';
$string['attempts'] = 'Próbálkozások';
$string['attempts_help'] = 'Engedélyezett próbálkozások összesen (nem a külön próbálkozások száma!).';
$string['attemptsallowed'] = 'Engedélyezett próbálkozás';
$string['attemptsdeleted'] = 'Teszt próbálkozásai törölve';
$string['attemptselection'] = 'Felhasználónként elemzendő próbálkozások kiválasztása';
$string['attemptsexist'] = 'A teszttel már történt próbálkozás. Több kérdést nem adhat hozzá és nem törölhet.';
$string['attemptsnum'] = 'Próbálkozás: {$a}';
$string['attemptsnumthisgroup'] = 'Próbálkozás: {$a->total} ({$a->group} ebből a csoportból)';
$string['attemptsnumyourgroups'] = 'Próbálkozás: {$a->total} ({$a->group} a csoportjából)';
$string['attemptsonly'] = 'Csak a próbálkozó tanulók megjelenítése';
$string['attemptstate'] = 'Állapot';
$string['attemptstillinprogress'] = 'A próbálkozás még folyamatban van';
$string['attemptsummarytitle'] = '{$a}: Próbálkozás összegzése';
$string['attemptsunlimited'] = 'Korlátlan számú próbálkozás';
$string['attempttitle'] = '{$a}';
$string['attempttitlepaged'] = '{$a->name}: ({$a->currentpage}. oldal / {$a->totalpages} oldal)';
$string['autosaveperiod'] = 'Automatikus mentés késleltetése';
$string['autosaveperiod_desc'] = 'A tanulói válaszok a próbálkozások során automatikusan elmenthetők. A válaszok mentésére egy-egy módosítása után, majd ezen késleltetés elteltével kerül sor. A szervert a rövidebb késleltetés ugyan megterheli, de csökken az esélye annak, hogy a tanulók elveszítik munkájukat. Ha sokkal rövidebbre állítaná a késleltetést, az értéket fokozatosan módosítsa, közben figyelve a terhelés alakulását! Ha túl nagy lesz a terhelés, növelje ismét a késleltetést! A késleltetés 0-ra állítása kikapcsolja az automatikus mentést.';
$string['back'] = 'Vissza a kérdés előzetes megtekintéséhez';
$string['backtocourse'] = 'Vissza a kurzushoz';
$string['backtoquestionlist'] = 'Vissza a kérdések felsorolásához';
$string['backtoquiz'] = 'Vissza a teszt szerkesztéséhez';
$string['banknotfound'] = 'A kérdésbank nem található, próbáljon új keresést';
$string['bestgrade'] = 'Legjobb értékelés';
$string['bothattempts'] = 'Próbálkozó és nem próbálkozó tanulók megjelenítése';
$string['browsersecurity'] = 'A böngésző biztonságossága';
$string['browsersecurity_help'] = 'Ha a "Teljes képernyős előugró ablak némi javascript biztonsággal" van kiválasztva,

* A teszt csak akkor kezdődik, ha a tanuló böngészője bekapcsolt javascripttel rendelkezik
* A teszt teljes képernyős előugró ablakban jelenik meg, amely elfedi az összes többi ablakot, és nincsenek rajta navigációs eszközök
* A tanulók az adott lehetőségek függvényében nem használhatnak olyan funkciókat, mint a másolás és a beillesztés';
$string['cachedef_overrides'] = 'Felhasználó és csoport felülírási adatai';
$string['calculated'] = 'Számításos';
$string['calculatedquestion'] = 'A számításos kérdés {$a} sornál nincs támogatva. A kérdés kimarad.';
$string['cannotcreatepath'] = 'Az útvonal nem hozható létre ({$a})';
$string['cannoteditafterattempts'] = 'Nem adhat hozzá és nem távolíthat el kérdéseket, mert a teszt megoldása folyamatban van. ({$a})';
$string['cannotfindprevattempt'] = 'Nem található a felhasználandó korábbi próbálkozás.';
$string['cannotfindquestionregard'] = 'Nem sikerült a kérdéseket találni az újraértékeléshez.';
$string['cannotinsert'] = 'Nem szúrható be kérdés';
$string['cannotinsertrandomquestion'] = 'Nem sikerült az új véletlenszerű kérdés hozzáadása';
$string['cannotloadquestion'] = 'A kérdés válaszlehetőségeinek betöltése nem sikerült!';
$string['cannotloadtypeinfo'] = 'Nem sikerült betölteni a kérdéstípusra vonatkozó kérdésadatokat';
$string['cannotopen'] = 'Exportálási fájl nem nyitható meg ({$a})';
$string['cannotremoveallsectionslots'] = 'A(z)  \'{$a}\' szakaszfejléc összes kérdését kiválasztotta. Egy szakaszfejléc alá tartozó minden kérdést nem lehet törölni.';
$string['cannotremoveslots'] = 'A kérdéseket nem lehet törölni';
$string['cannotrestore'] = 'A kérdésszakaszok helyreállítása nem sikerült!';
$string['cannotreviewopen'] = 'A próbálkozást nem ellenőrizheti, még nincs lezárva.';
$string['cannotsavelayout'] = 'Az elrendezést nem sikerült elmenteni.';
$string['cannotsavenumberofquestion'] = 'Nem sikerült elmenteni az oldalankénti kérdésszámot.';
$string['cannotsavequestion'] = 'Nem menthető el a kérdéslista';
$string['cannotsetgrade'] = 'Nem sikerült beállítani a teszt új legjobb értékelését.';
$string['cannotsetsumgrades'] = 'A sumgrades elmentése nem sikerült.';
$string['cannotstartgradesmismatch'] = 'A teszt kitöltése nem indítható el. A teszt legjobb értékelése {$a->grade} lenne, de még nincs hozzáadva értékelhető kérdés. Ezt a "Teszt szerkesztése" oldalon javítható.';
$string['cannotstartmissingquestion'] = 'A teszttel nem lehet próbálkozni. A teszt nem létező kérdésdefiníciót tartalmaz.';
$string['cannotstartnoquestions'] = 'A teszt kitöltése nem indítható el. A teszt még nincs összeállítva. Nincs hozzáadva kérdés.';
$string['cannotwrite'] = 'Nem lehet az exportálási állományba írni ({$a})';
$string['canredoquestions'] = 'Próbálkozás során ismétlés engedélyezése';
$string['canredoquestions_desc'] = 'Bekapcsolása esetén adott kérdés befejezésekor megjelenik a \'Másik hasonló kérdéssel való próbálkozás\' gomb. Ezzel a teljes teszt leadása nélkül újból próbálkozhat egy (véletlenszerűen kiválasztott) hasonló kérdéssel, vagy újabb próbálkozást indíthat. Gyakorló tesztek esetén hasznos.

Csak a kérdéseket és a reakciókat (pl. azonnali visszajelzés vagy interaktív többszöri próbálkozással) érinti, amikor a tanuló a próbálkozás leadása nélkül be tud fejezni egy kérdést.';
$string['canredoquestions_help'] = 'Bekapcsolása esetén adott kérdés befejezésekor megjelenik a \'Másik hasonló kérdéssel való próbálkozás\' gomb. Ezzel a teljes teszt leadása nélkül újból próbálkozhat egy (véletlenszerűen kiválasztott) hasonló kérdéssel, vagy újabb próbálkozást indíthat. Gyakorló tesztek esetén hasznos.

Csak a kérdéseket és a reakciókat (pl. azonnali visszajelzés vagy interaktív többszöri próbálkozással) érinti, amikor a tanuló a próbálkozás leadása nélkül be tud fejezni egy kérdést.';
$string['canredoquestionsyes'] = 'Igen, szeretnék egy másik kérdéssel próbálkozni';
$string['caseno'] = 'Nincs jelentősége a kis-/nagybetűnek';
$string['casesensitive'] = 'Kis-/nagybetű különböző';
$string['caseyes'] = 'Igen, a kis- és nagybetűk különbözőek';
$string['categoryadded'] = 'A(z) \'{$a}\' kategória hozzáadva';
$string['categorydeleted'] = 'A(z) \'{$a}\' kategória törlése megtörtént';
$string['categorynoedit'] = 'A(z) \'{$a}\' kategóriához nincs szerkesztési jogosultsága.';
$string['categoryupdated'] = 'A kategória frissítése sikerült';
$string['close'] = 'Ablak bezárása';
$string['closebeforeopen'] = 'A tesztet nem lehetett frissíteni. A befejezés időpontjának korábbi dátumot adott meg, mint a kezdésnek.';
$string['closed'] = 'Lezárva';
$string['closepreview'] = 'Megtekintés bezárása';
$string['closereview'] = 'Ellenőrzés bezárása';
$string['comment'] = 'Megjegyzés';
$string['commentorgrade'] = 'Megjegyzés írása vagy értékelés felülírása';
$string['comments'] = 'Megjegyzések';
$string['completedon'] = 'Befejezés dátuma';
$string['completionattemptsexhausted'] = 'Ponthatár elérése vagy az összes engedélyezett próbálkozás elhasználása.';
$string['completionattemptsexhausted_help'] = 'A tesztet befejezettnek jelöli, amikor a tanuló eléri a próbálkozások maximális számát.';
$string['completiondetail:minattempts'] = 'Próbálkozások végrehajtása: {$a}';
$string['completiondetail:passorexhaust'] = 'Megfelelt értékelés elérése vagy az összes engedélyezett próbálkozás elhasználása.';
$string['completionminattempts'] = 'A próbálkozások minimális száma:';
$string['completionminattemptsdesc'] = 'Előírt próbálkozások minimális száma: {$a}';
$string['completionminattemptserror'] = 'A próbálkozások száma a megengedett próbálkozások számával egyenlő vagy annál kevesebb lehet.';
$string['completionpassorattemptsexhausteddesc'] = 'A tevékenység végrehajtásához a tanulónak el kell érnie a ponthatárt vagy minden lehetséges próbálkozást el kell használnia';
$string['configadaptive'] = 'Ha itt Igent választ, a tanuló több választ adhat egy kérdésre akár ugyanazon próbálkozás során is.';
$string['configattemptsallowed'] = 'A tanulók számára a teszt során megengedett próbálkozások számának korlátozása';
$string['configdecimaldigits'] = 'Az értékelések megjelenítésekor a tizedesvessző után használt számjegyek száma.';
$string['configdecimalplaces'] = 'A teszt értékeléseinek megjelenítésekor a tizedesvessző után használt számjegyek száma.';
$string['configdecimalplacesquestion'] = 'Az egyes kérdések pontszámainak megjelenítése során a tizedesvessző után kijelzendő számjegyek száma';
$string['configdelay1'] = 'Ha késleltetést állít be, a tanulónak az első próbálkozás után eddig kell várnia a teszttel való ismételt próbálkozásig.';
$string['configdelay1st2nd'] = 'Ha késleltetést állít be, a tanulónak az első próbálkozás után ennyi ideig várnia kell a teszttel való ismételt próbálkozásig.';
$string['configdelay2'] = 'Ha késleltetést állít be, a tanulónak eddig kell várnia a harmadik vagy azt követő próbálkozásig.';
$string['configdelaylater'] = 'Ha késleltetést állít be, a tanulónak az előző próbálkozás után ennyi ideig várnia kell a teszttel való harmadik, negyedik... próbálkozásig.';
$string['configeachattemptbuildsonthelast'] = 'Ha több próbálkozásra van lehetőség, akkor az egyes próbálkozások tartalmazzák a korábbi eredményét.';
$string['configgrademethod'] = 'A rendszer melyik módszerrel számítsa ki a tanuló tesztben elért végső értékelését, ha több próbálkozásra van lehetőség.';
$string['configintro'] = 'Az itt megadott értékek lesznek azok az alapértékek, amelyek új teszt létrehozásakor megjelennek a beállítások űrlapján. Azt is megadhatja, hogy melyik tesztbeállítások legyenek haladó szintűek.';
$string['configintroglobal'] = 'Ezek a beállítások szabályozzák a Teszt tevékenység rendszerszintű viselkedését.';
$string['configmaximumgrade'] = 'Az alapértelmezett értékelés, amelyhez a teszt értékelése arányítva lesz.';
$string['confignavmethod'] = 'Kötetlen navigálás közben a kérdések tetszőleges sorrendben megválaszolhatók. Egymás utáni navigálás esetén ezek sorrendje szigorúan megszabott.';
$string['confignewpageevery'] = 'Ha kérdéseket ad a teszthez, az oldaltörések automatikusan az itt megadottak szerint szúródnak be.';
$string['configoutcomesadvanced'] = 'Bekapcsolása esetén a tesztszerkesztő űrlapon az Eredmények a részletes beállítások része';
$string['configpenaltyscheme'] = 'Adaptív módban a hibás válaszokért levonandó büntetés.';
$string['configpopup'] = 'A próbálkozás előugró ablakban jelenjen meg és használja a javascriptet a másolás és beillesztés stb. korlátozására próbálkozások során.';
$string['configrequirepassword'] = 'A tanulóknak ezt a jelszót kell megadni a teszt megoldása előtt.';
$string['configrequiresubnet'] = 'A tanulók csak ezekről a számítógépekről próbálkozhatnak a teszt megoldásával.';
$string['configreviewoptions'] = 'Ezek a beállítások szabályozzák, milyen információkat láthatnak a felhasználók egy próbálkozás ellenőrzése vagy tesztjelentések megtekintése során.';
$string['configshowblocks'] = 'Blokkok megjelenítése a teszten végrehajtott próbálkozások során.';
$string['configshowuserpicture'] = 'Próbálkozások alatt jelenítse meg a felhasználó képét.';
$string['configshufflewithin'] = 'Bekapcsolása esetén az egyes kérdések részei véletlenszerűen keverednek minden egyes próbálkozás előtt, amennyiben ezt a kérdés beállításainál is bekapcsolja.';
$string['configtimelimit'] = 'Percekben megadott alapértelmezett időkorlát a tesztekhez. A 0 azt jelenti, hogy nincs időkorlát.';
$string['configtimelimitsec'] = 'Tesztek alapvető időkorlátja másodpercekben. A 0 az időkorlát hiányát jelenti.';
$string['configurerandomquestion'] = 'Kérdés beállítása';
$string['confirmclose'] = 'A leadás után a válaszait nem módosíthatja.';
$string['confirmremovequestion'] = 'Biztosan törli a(z) {$a} kérdést?';
$string['confirmremovesectionheading'] = 'Biztosan törlendő a(z)  \'{$a}\' szakaszfejléc?';
$string['confirmserverdelete'] = 'Biztosan el akarja távolítani a(z) {$a} szervert a felsorolásból?';
$string['connectionerror'] = 'A hálózati kapcsolat megszűnt (az automatikus mentés nem sikerült).

Jegyezze fel az oldalon megadott esetleges válaszokat, majd próbáljon meg újból kapcsolódni.

Ha sikerül. válaszainak mentése után ez az üzenet eltűnik.';
$string['connectionok'] = 'A hálózati kapcsolat helyreállt. Biztonságosan folytathatja a munkát.';
$string['containercategorycreated'] = 'Ezzel a kategóriával az alábbi okok miatt portálszintre áthelyezett összes eredeti kategória tárolására van lehetőség.';
$string['continueattemptquiz'] = 'Próbálkozás folytatása';
$string['continuepreview'] = 'Utolsó megtekintés folytatása';
$string['copyingfrom'] = 'Másolat készül a(z) \'{$a}\' kérdésről';
$string['copyingquestion'] = 'Kérdés másolása';
$string['correct'] = 'Helyes';
$string['correctanswer'] = 'Helyes válasz';
$string['correctanswerformula'] = 'Helyes válasz képlete';
$string['correctansweris'] = 'A helyes válasz: {$a}';
$string['correctanswerlength'] = 'Szignifikáns számjegyek';
$string['correctanswers'] = 'Helyes válaszok';
$string['correctanswershows'] = 'A helyes válasz látszik';
$string['corrresp'] = 'Helyes válasz';
$string['countdown'] = 'Visszaszámlálás';
$string['countdownfinished'] = 'A teszt véget ér, válaszait most adja le.';
$string['countdowntenminutes'] = 'A teszt 10 percen belül véget ér.';
$string['coursetestmanager'] = 'Kurzusteszt kezelési formája';
$string['createcategoryandaddrandomquestion'] = 'Kategória létrehozása és véletlenszerű kérdés hozzáadása';
$string['createfirst'] = 'Először készítsen néhány kiegészítendő kérdést.';
$string['createmultiple'] = 'Adjon a teszthez néhány véletlen kérdést';
$string['createnewquestion'] = 'Új kérdés létrehozása';
$string['createquestionandadd'] = 'Új kérdés létrehozása és hozzáadása a teszthez.';
$string['currentbank'] = 'Jelenlegi kérdésbank: {$a}';
$string['custom'] = 'Saját forma';
$string['dataitemneed'] = 'Legalább egy adatkészletet meg kell adnia, hogy érvényes kérdést kapjon';
$string['datasetdefinitions'] = '{$a} kategóriához újrahasználható adatkészlet megadása';
$string['datasetnumber'] = 'Szám';
$string['daysavailable'] = 'Hátralévő napok';
$string['decimaldigits'] = 'Tizedesjegyek az értékelésnél';
$string['decimalplaces'] = 'Tizedesjegyek az értékelésnél';
$string['decimalplaces_help'] = 'Itt választhatja ki, hány tizedesjegy jelenjen meg a tizedesvessző után az értékelések megjelenítésekor. Ez a beállítás csak az értékelések megjelenítésér befolyásolja, nem pedig az adatbázisban tárolt vagy a belső számolásoknál használtakat, melyeknél a legnagyobb pontosság használatos.';
$string['decimalplacesquestion'] = 'Tizedesjegyek száma a kérdések pontszámában';
$string['decimalplacesquestion_help'] = 'Az egyes kérdéseknél megjelenített pontszámokban használt tizedesjegyek száma a tizedesvessző után.';
$string['decimalpoints'] = 'Tizedeshelyek';
$string['default'] = 'Alapbeállítás';
$string['defaultgrade'] = 'Alapértelmezett kérdés értékelés';
$string['defaultinfo'] = 'Kérdések alapkategóriája.';
$string['defaultsettings'] = 'Teszt alapértelmezett beállításai';
$string['delay1'] = 'Az első és a második próbálkozás közötti időköz';
$string['delay1st2nd'] = 'Kivárás az 1. és a 2. próbálkozás között.';
$string['delay1st2nd_help'] = '<p>Időköz beállítása esetén a tanulónak az első próbálkozás után a teszt újrapróbálásával várnia kell a megadott ideig.</p>';
$string['delay2'] = 'A későbbi próbálkozások közötti időköz';
$string['delaylater'] = 'Kivárás a későbbi próbálkozások között.';
$string['delaylater_help'] = '<p>Időköz beállítása esetén a tanulónak a második próbálkozás után várnia kell a megadott ideig a teszt harmadik vagy további újrapróbálásaival.</p>';
$string['deleteattemptcheck'] = 'Biztosan törölni akarja az összes próbálkozást?';
$string['deleteselected'] = 'A kiválasztott törlése';
$string['deletingquestionattempts'] = 'Kérdéssel való próbálkozások törlése';
$string['description'] = 'Leírás';
$string['disabled'] = 'Kikapcsolva';
$string['displayoptions'] = 'Kijelzési lehetőségek';
$string['donotuseautosave'] = 'Ne legyen automatikus mentés.';
$string['download'] = 'Az exportált kategóriafájl letöltéséhez kattintson';
$string['downloadextra'] = '(a fájl szerepel a kurzusállományok között is a /backupdata/quiz mappában)';
$string['dragtoafter'] = '{$a} után';
$string['dragtostart'] = 'Elölre';
$string['duplicateresponse'] = 'A leadott munka figyelmen kívül hagyva, mert korábban már adott le ezzel egyenértékű választ.';
$string['eachattemptbuildsonthelast'] = 'Minden próbálkozás az előzőre épül';
$string['eachattemptbuildsonthelast_help'] = '<p>Ha többszöri próbálkozásra van lehetőség és ez a beállítás
<strong>Igen</strong>-re van állítva, akkor minden egyes új próbálkozás  tartalmazni fogja a korábbi próbálkozás eredményét. Ennek eredményeként a teszt több próbálkozással is teljesíthető.</p>

<p>Ha ez a beállítás <strong>Nem</strong>, akkor minden próbálkozás esetén friss teszt jelenik meg.</p>';
$string['edit_slotdisplaynumber_hint'] = 'Kérdésszám szerkesztése (legfeljebb 16 karakter)';
$string['edit_slotdisplaynumber_label'] = '{$a} új értéke';
$string['editcategories'] = 'Kategóriák szerkesztése';
$string['editcategory'] = 'Kategória szerkesztése';
$string['editcatquestions'] = 'Kategóriakérdések szerkesztése';
$string['editingquestion'] = 'Kérdés szerkesztése';
$string['editingquiz'] = 'Teszt szerkesztése';
$string['editingquiz_help'] = 'Teszt létrehozása esetén a fő fogalmak a következők:
* Az egy vagy több oldalon rögzített kérdéseket tartalmazó teszt
* Az összes kérdés másodpéldányát kategóriákba szervezve tároló kérdésbank
* Véletlenszerű kérdések - A tanuló, ill. a tanulók minden tesztmegoldás alkalmával más-más kérdéseket kap(nak)';
$string['editingquiz_link'] = 'mod/quiz/edit';
$string['editingquizx'] = 'Teszt szerkesztése: {$a}';
$string['editmaxmark'] = 'Maximális pont szerkesztése';
$string['editoverride'] = 'Szerkesztés felülírása';
$string['editqcats'] = 'Kérdéskategóriák szerkesztése';
$string['editquestion'] = 'Kérdés szerkesztése';
$string['editquestions'] = 'Kérdések szerkesztése';
$string['editquiz'] = 'Teszt szerkesztése';
$string['editquizquestions'] = 'Tesztkérdések szerkesztése';
$string['emailconfirmautosubmitsmall'] = 'Köszönet a(z) \'{$a->quizname}\'  teszthez leadott válaszokért';
$string['emailconfirmbody'] = 'Tisztelt {$a->username}!  Köszönjük, hogy \'{$a->quizname}\' tesztre \'{$a->coursename}\' kurzus keretében adott válaszait {$a->submissiontime} időpontban leadta.
Ez az e-mail megerősíti, hogy válaszai rendben megérkeztek.
A tesztet itt érheti el: {$a->quizurl}.';
$string['emailconfirmbodyautosubmit'] = 'Üdvözöljük, {$a->username}!

A(z) \'{$a->coursename}\' kurzus \'{$a->quizname}\' tesztjének határideje lejárt.. Válaszait {$a->submissiontime} időpontban automatikusan rögzítettük.

Az üzenettel válaszainak mentését igazoljuk.

A tesztet itt érheti el: {$a->quizurl}.';
$string['emailconfirmsmall'] = 'Köszönjük \'{$a->quizname}\' tesztre leadott válaszát.';
$string['emailconfirmsubject'] = 'Leadás megerősítése: {$a->quizname}';
$string['emailmanualgradedbody'] = 'Üdvözlet, {$a->studentname}!

A(z) \'{$a->coursename}\' kurzusbeli \'{$a->quizname}\' tesztre {$a->attempttimefinish} ideig adott válaszait értékelték.

A \'{$a->quizurl}\' tesztre ellátogatva megtekintheti eredményét és a visszajelzést, valamint átnézheti próbálkozását.';
$string['emailmanualgradedsubject'] = 'A(z) {$a->quizname} tesztpróbálkozását értékelték.';
$string['emailnotifybody'] = 'Tisztelt {$a->username}! {$a->studentname} kitöltötte a(z) \'{$a->coursename}\' kurzus \'{$a->quizname}\' tesztjét ({$a->quizurl}). A próbálkozást megtekintheti itt: {$a->quizreviewurl}.';
$string['emailnotifysmall'] = '{$a->studentname} a {$a->quizname} tesztet befejezte.
Megtekintheti itt: {$a->quizreviewurl}.';
$string['emailnotifysubject'] = '{$a->studentname} kitöltötte a(z) {$a->quizname} tesztet';
$string['emailoverduebody'] = 'Kedves {$a->studentname}, a(z) "{$a->coursename}" kurzusbeli "{$a->quizname}" teszt megoldásával próbálkozott, de nem adta le. Ennek határideje  {$a->attemptduedate} volt. Ha még szeretné leadni, térjen át a(z) {$a->attemptsummaryurl} pontra és kattintson a Leadás gombra. Ezt {$a->attemptgraceend} előtt teheti meg, ellenkező esetben próbálkozását figyelmen kívül hagyjuk.';
$string['emailoverduesmall'] = 'A(z) "{$a->quizname}" teszt megoldásával próbálkozott, de nem adta le. Ha még szeretné leadni, térjen át a(z) {$a->attemptsummaryurl} pontra {$a->attemptgraceend} előtt.';
$string['emailoverduesubject'] = 'Határidőn túli próbálkozás: {$a->quizname}';
$string['empty'] = 'Üres';
$string['enabled'] = 'Bekapcsolva';
$string['endtest'] = 'Próbálkozás vége ...';
$string['erroraccessingreport'] = 'A jelentéshez nem férhet hozzá.';
$string['errorinquestion'] = 'Hiba a kérdésben';
$string['errormissingquestion'] = 'Hiba: a rendszerből hiányzik a(z) {$a} azonosítójú kérdés';
$string['errornotnumbers'] = 'Hiba - a válaszoknak számjegyesnek kell lenni';
$string['errorunexpectedevent'] = 'Váratlan {$a->event} eseménykód fordult elő {$a->questionid} kérdéssel kapcsolatban {$a->attemptid} próbálkozás során.';
$string['essay'] = 'Esszé';
$string['essayquestions'] = 'Kérdések';
$string['eventattemptautosaved'] = 'A teszttel próbálkozás automatikusan mentve';
$string['eventattemptdeleted'] = 'Próbálkozás törölve';
$string['eventattemptmanualgradingcomplete'] = 'Tesztpróbálkozás kézi értékelése kész';
$string['eventattemptpreviewstarted'] = 'Próbálkozás előnézete elindítva';
$string['eventattemptquestionrestarted'] = 'A teszttel próbálkozás kérdése újrakezdve';
$string['eventattemptreviewed'] = 'Próbálkozás felülvizsgálva';
$string['eventattemptsummaryviewed'] = 'Próbálkozás összegzése megtekintve';
$string['eventattemptupdated'] = 'A teszttel próbálkozás frissítve';
$string['eventattemptviewed'] = 'Próbálkozás megtekintve';
$string['eventeditpageviewed'] = 'Tesztszerkesztő oldala megtekintve';
$string['eventoverridecreated'] = 'Tesztfelülírás létrehozva';
$string['eventoverridedeleted'] = 'Tesztfelülírás törölve';
$string['eventoverrideupdated'] = 'Tesztfelülírás frissítve';
$string['eventpagebreakcreated'] = 'Oldaltörés létrehozva';
$string['eventpagebreakdeleted'] = 'Oldaltörés létrehozva';
$string['eventquestionmanuallygraded'] = 'Kérdés kézzel értékelve';
$string['eventquizattemptabandoned'] = 'Próbálkozás abbahagyva';
$string['eventquizattemptgraded'] = 'Tesztpróbálkozás értékelve';
$string['eventquizattemptregraded'] = 'Próbálkozás újraértékelve';
$string['eventquizattemptreopened'] = 'Teszt próbálkozás újranyitva';
$string['eventquizattemptstarted'] = 'Próbálkozás elkezdve';
$string['eventquizattemptsubmitted'] = 'Próbálkozás leadva';
$string['eventquizattempttimelimitexceeded'] = 'Próbálkozási idő túlhaladva';
$string['eventquizgradeitemcreated'] = 'Teszt értékelési tétele létrehozva';
$string['eventquizgradeitemdeleted'] = 'Teszt értékelési tétele törölve';
$string['eventquizgradeitemorderchanged'] = 'Teszt-értékelésitételek sorrendje módosítva';
$string['eventquizgradeitemupdated'] = 'Teszt értékelési tétele frissítve';
$string['eventquizgradeupdated'] = 'Tesztértékelés frissítve';
$string['eventquizrepaginated'] = 'Teszt újrasorszámozva';
$string['eventreportviewed'] = 'Tesztjelentés megtekintve';
$string['eventsectionbreakcreated'] = 'Szakasztörés létrehozva';
$string['eventsectionbreakdeleted'] = 'Szakasztörés törölve';
$string['eventsectionshuffleupdated'] = 'Szakaszsorrend frissítve';
$string['eventsectiontitleupdated'] = 'Szakaszcím frissítve';
$string['eventslotcreated'] = 'Időhely létrehozva';
$string['eventslotdeleted'] = 'Időhely törölve';
$string['eventslotdisplayedquestionnumberupdated'] = '';
$string['eventslotmarkupdated'] = 'Időhely jele frissítve';
$string['eventslotmoved'] = 'Időhely áthelyezve';
$string['eventslotrequirepreviousupdated'] = 'Előző időhely előírása frissítve';
$string['everynquestions'] = 'Minden {$a}. kérdés';
$string['everyquestion'] = 'Minden kérdés';
$string['everythingon'] = 'Minden bekapcsolva';
$string['existingcategory'] = 'Létező kategória';
$string['exportcategory'] = 'exportkategória';
$string['exporterror'] = 'Hiba az exportálás feldolgozása közben';
$string['exportingquestions'] = 'A kérdéseket a rendszer állományba exportálja';
$string['exportname'] = 'Állománynév';
$string['exportquestions'] = 'Kérdések exportálása állományba';
$string['extraattemptrestrictions'] = 'Külön megszorítások a próbálkozásokhoz';
$string['false'] = 'Hamis';
$string['feedback'] = 'Visszajelzés';
$string['feedbackerrorboundaryformat'] = 'A visszajelzés ponthatárai százalékosan vagy számmal adhatók meg. A {$a} határként megadott érték nem kezelhető.';
$string['feedbackerrorboundaryoutofrange'] = 'A visszajelzés ponthatárai 0% és 100% közé eshetnek. A {$a} határként megadott érték nem esik ebbe a tartományba.';
$string['feedbackerrorjunkinboundary'] = 'A visszajelzés ponthatárait kihagyások nélkül kell megadnia.';
$string['feedbackerrorjunkinfeedback'] = 'A visszajelzési mezőket kihagyások nélkül kell kitöltenie.';
$string['feedbackerrororder'] = 'A visszajelzés ponthatárait sorrendben kell megadni a legmagasabbtól lefelé. A(z) {$a} határként megadott érték nem esik ebbe a sorba.';
$string['file'] = 'Állomány';
$string['fileformat'] = 'Állományforma';
$string['fillcorrect'] = 'Helyesként töltendő ki';
$string['filloutnumericalanswer'] = 'Legalább egy lehetséges választ és tűréshatárt adjon meg! Az első egyező válasz határozza meg az értékelést és a visszajelzést. Ha visszajelzést ad meg, de nincs a végén válasz, akkor azt azok a tanulók látják, akiknek a válasza egyik válasszal sem egyezik.';
$string['filloutoneanswer'] = 'Legalább egy lehetséges választ meg kell adnia! Az üresen hagyott válaszok kimaradnak. A \'*\' használható bármely karakter helyettesítőjeként. Az értékelés és a visszajelzés meghatározása az első helyes válasz alapján történik.';
$string['filloutthreequestions'] = 'Legalább három kérdést kell kitöltenie a hozzájuk tartozó válaszokkal együtt. További rossz válaszokat is megadhat, ha üres kérdésre ad választ. Az üresen hagyott kérdéseket és válaszokat tartalmazó bejegyzéseket a rendszer figyelmen kívül hagyja.';
$string['fillouttwochoices'] = 'Legalább két válaszlehetőséget meg kell adnia. Az üresen hagyott válaszlehetőségek kimaradnak.';
$string['finishattemptdots'] = 'Próbálkozás befejezése...';
$string['finishreview'] = 'Ellenőrzés befejezése';
$string['forceregeneration'] = 'újragenerálás előírása';
$string['formatnotfound'] = 'Az importálási/exportálási {$a} forma nem található';
$string['formulaerror'] = 'Képlethiba!';
$string['fractionsaddwrong'] = 'A pozitív értékelések összege nem 100%,<br />hanem {$a}%.<br />Visszatér és kijavítja ezt a kérdést?';
$string['fractionsnomax'] = 'Az egyik válaszlehetőségnek 100%-nak kell lennie,<br />hogy a legjobb érékelés adható legyen a kérdésnél.<br />Visszatér és kijavítja a kérdést?';
$string['fromfile'] = 'forrásállomány:';
$string['functiondisabledbysecuremode'] = 'Ez a funkció jelenleg ki van kapcsolva';
$string['generalfeedback'] = 'Általános visszajelzés';
$string['generalfeedback_help'] = '<p>A kérdéshez kapcsolódó általános szöveget a tanuló a kérdéssel való próbálkozás után látja.
A visszajelzéstől eltérően, amely a kérdésfajtától és a tanuló válaszától függően változik,
az általános szöveget minden tanuló látja.</p>

<p>Az általános szöveg megjelenítését a tesztszerkesztő űrlapon lévő "A tanulók megtekinthetik:" jelölőnégyzetekkel
állíthatja be.</p>
<p>Az általános szöveggel a tanulókat tájékoztathatja arról, hogy a kérdés milyen ismereteket
ellenőriz, illetve uhivatkozásokat adhat meg nekik, melyeken keresztül a kérdésről részletesebben
tájékozódhatnak.</p>';
$string['gobacktoquiz'] = 'Visszalépés';
$string['graceperiod'] = 'Leadás türelmi ideje';
$string['graceperiod_desc'] = 'Ha a lejáratkori teendő beállítása "Türelmi idő engedélyezése, válaszok módosítása nélkül", akkor ez lesz az alapbeállítás szerinti plusz idő.';
$string['graceperiod_help'] = 'Ha a lejáratkori teendő beállítása "Türelmi idő engedélyezése leadáshoz, válaszok módosítása nélkül", akkor ez lesz az engedélyezett  plusz idő.';
$string['graceperiodmin'] = 'Leadás végső türelmi ideje';
$string['graceperiodmin_desc'] = 'Ez egy lehetséges  probléma közvetlenül a teszt végén Egyrészt jó volna, ha a tanulók folytathatnák a munkát egészen az utolsó másodpercig azon időmérő segítségével, amely a lejáratkor automatikusan beküldi a tesztet. Másrészt ekkor a szerver túlterhelt lehet és egy kis időbe telhet, amíg feldolgozza a válaszokat. Ezért a lejárat után ennyi másodpercig még elfogadja a válaszokat. Ugyanakkor a tanuló csalhat és ennyi másodpercig még dolgozhat a teszten. A középutat a szerver teszt közbeni teljesítményének ismeretében határozhatja meg.';
$string['graceperiodtoosmall'] = 'A türelmi idő több mint {$a}.';
$string['gradeall'] = 'Az összes értékelése';
$string['gradeaverage'] = 'Átlag értékelés';
$string['gradeboundary'] = 'Ponthatár';
$string['gradeessays'] = 'Esszék értékelése';
$string['gradehighest'] = 'Legjobb értékelés';
$string['gradeitemdefaultname'] = 'Új értékelési tétel {$a}';
$string['gradeitemdelete'] = '{$a} értékelési tétel törlése';
$string['gradeitemedit'] = '{$a} értékelési tétel nevének szerkesztése';
$string['gradeitemmarkscheme'] = 'Értékelési tételek hozzárendelése';
$string['gradeitemnewname'] = 'Új név {$a} értékelési tételhez';
$string['gradeitemnoneselected'] = '[none]';
$string['gradeitemnoslots'] = 'Ebben a tesztben még nincsenek kérdések. Kérjük, először adjon hozzá kérdéseket, majd térjen vissza ide az értékelési tételek beállításához!';
$string['gradeitems'] = 'Értékelési tételek';
$string['gradeitemsautosetup'] = 'Állítson be egy értékelést minden egyes szekcióhoz';
$string['gradeitemsetup'] = 'Értékelési tételekbeállítása';
$string['gradeitemsremoveall'] = 'Beállítások visszaállítása';
$string['gradeitemsremoveallconfirm'] = 'Visszaállítja az értékelési tételek beállítását?';
$string['gradeitemsremovealltitle'] = 'Értékelési tételek beállításának visszaállítása';
$string['grademethod'] = 'Értékelési módszer';
$string['grademethod_help'] = 'Ha lehetséges többször próbálkozni, az alábbi módszerekkel számítható ki a teszt végső értékelése:

* Az összes próbálkozás közül a legjobb értékelés
* Az összes próbálkozás értékelésének átlaga (számtani közepe)
* Első próbálkozás (a többi kimarad)
* Utolsó próbálkozás (a többi kimarad)';
$string['gradesdeleted'] = 'Teszt értékelései törölve';
$string['gradesofar'] = '{$a->method}: {$a->mygrade} / {$a->quizgrade}.';
$string['gradetopassmustbeset'] = 'Az \'átment\' osztályzat nem lehet nulla, mert a teszt teljesítéséhez \'átment\' osztályzatra van szükség. Állítson be egy nem nulla értéket.';
$string['gradetopassoutof'] = 'Megfelelt értékelés: {$a->grade} a(z) {$a->maxgrade} maximumból';
$string['gradingdetails'] = 'Leadott munka pontjai: {$a->raw}/{$a->max}.';
$string['gradingdetailsadjustment'] = 'Az előző büntetésekkel ez <strong>{$a->cur}/{$a->max}</strong> lesz.';
$string['gradingdetailspenalty'] = 'Erre a leadott munkára {$a} büntetőpontot kapott.';
$string['gradingdetailszeropenalty'] = 'Erre a leadott munkára nem kapott büntetőpontot.';
$string['gradingmethod'] = 'Értékelési módszer: {$a}';
$string['groupoverrides'] = 'Csoport felülírásai';
$string['groupoverridesdeleted'] = 'A csoportfölülírások törölve.';
$string['groupsnone'] = 'Nincs elérhető csoport.';
$string['guestsno'] = 'Vendégek nem tekinthetnek meg és nem oldhatnak meg teszteket';
$string['hidebreaks'] = 'Oldaltörések elrejtése';
$string['hidereordertool'] = 'Az átrendező eszköz elrejtése';
$string['history'] = 'Válaszok előzményei';
$string['howquestionsbehave_desc'] = 'Alapbeállítás a kérdések teszten belüli kezeléséhez.';
$string['imagedisplay'] = 'Megjelenítendő kép';
$string['import_help'] = 'A funkcióval kérdéseket importálhat külső szöveges állományokból.
Ha nem ascii-karaktereket tartalmaznak, az UTF-8 kódolást kell használnia. Különösen a Microsoft Office által előállított állományokkal legyen óvatos, mert ezek gyakran speciális, megfelelő módon kezelhetetlen kódolást használnak.
Az importálási és exportálási formátumok használata választható. Egyéb formátumokat talál a Modulok és a Segédprogramok adatbázisban.';
$string['import_link'] = 'question/import';
$string['importcategory'] = 'kategória importálása';
$string['importerror'] = 'Hiba importálás feldolgozása közben';
$string['importfilearea'] = 'Kurzusfájlok között már szereplő állomány importálása...';
$string['importfileupload'] = 'Importálás fájlfeltöltésből...';
$string['importfromthisfile'] = 'Importálás ebből az állományból';
$string['importingquestions'] = '{$a} kérdés importálása állományból';
$string['importmax10error'] = 'Hiba a kérdésben. Tíznél több választ nem adhat meg.';
$string['importmaxerror'] = 'Hiba a kérdésben. Túl sok a válasz.';
$string['importquestions'] = 'Kérdések importálása állományból';
$string['inactiveoverridehelp'] = '* A felülírás nem működik, mert a felhasználó hozzáférése a tevékenységhez korlátozott. Ennek oka lehet a csoport- vagy szerepfeladatok, illetve egyéb korlátozások, vagy pedig rejtett tevékenység.';
$string['incorrect'] = 'Hibás';
$string['indicator:cognitivedepth'] = 'Kognitív teszt';
$string['indicator:cognitivedepth_help'] = 'Ez a jelző a tanuló által a teszt kapcsán elért kognitív mélységen alapul.';
$string['indicator:cognitivedepthdef'] = 'Kognitív teszt';
$string['indicator:cognitivedepthdef_help'] = 'A résztvevő az elemzési időszak alatt a Teszt tevékenységei során kognitív elfoglaltság terén ezt a százalékot érte el (Szintek - Nincs megtekintés, Megtekintés, Leadás, Visszajelzés megtekintése, Visszajelzéshez kapcsolódó megjegyzés, Újbóli leadás visszajelzés megtekintése után)';
$string['indicator:cognitivedepthdef_link'] = 'Learning_analytics_indicators#Cognitive_depth';
$string['indicator:socialbreadth'] = 'Társas teszt';
$string['indicator:socialbreadth_help'] = 'Ez a jelző a tanuló által a teszt kapcsán elért társas lefedettségen alapul.';
$string['indicator:socialbreadthdef'] = 'Társas teszt';
$string['indicator:socialbreadthdef_help'] = 'A résztvevő az elemzési időszak alatt a Teszt tevékenységei során társas elfoglaltság terén ezt a százalékot érte el (Szintek - Nincs részvétel, Egyedüli részvétel, Másokkal együtt való részvétel)';
$string['indicator:socialbreadthdef_link'] = 'Learning_analytics_indicators#Social_breadth';
$string['indivresp'] = 'Az egyes tételekre leadott válaszok ';
$string['info'] = 'Infó';
$string['infoshort'] = 'i';
$string['initialnumfeedbacks'] = 'Globális visszajelzési mezők kezdeti száma';
$string['initialnumfeedbacks_desc'] = 'Új teszt készítésekor ennyi üres globális visszajelzési négyzetről gondoskodjon. Ha elkészült a teszt, az űrlapon látszik, hány mezőre van szükség a teszt visszajelzéseihez. A beállítás minimális értéke 1.';
$string['inprogress'] = 'Folyamatban';
$string['introduction'] = 'Leírás';
$string['invalidattemptid'] = 'Nincs ilyen próbálkozás-azonosító';
$string['invalidcategory'] = 'Érvénytelen kategória-azonosító';
$string['invalidoverrideid'] = 'Érvénytelen felülírási azonosító';
$string['invalidquestionid'] = 'Érvénytelen kérdés-azonosító';
$string['invalidquizid'] = 'Érvénytelen tesztazonosító';
$string['invalidrandomslot'] = 'Érvénytelen véletlenszerű kérdés-azonosító.';
$string['invalidsource'] = 'A forrás nem érvényes';
$string['invalidsourcetype'] = 'A forrás típusa nem érvényes';
$string['invalidstateid'] = 'Érvénytelen állapotazonosító';
$string['lastanswer'] = 'Utolsó válasza ez volt';
$string['lastautosave'] = 'Utoljára mentve: {$a}';
$string['layout'] = 'Elrendezés';
$string['layoutasshown'] = 'Elrendezés a megjelenítés szerint';
$string['layoutasshownwithpages'] = 'Elrendezés a megjelenítés szerint. <small>(Automatikus új oldal {$a} kérdésenként.)</small>';
$string['layoutshuffledandpaged'] = 'Kérdések véletlenszerű összekeverése oldalanként {$a} kérdéssel.';
$string['layoutshuffledsinglepage'] = 'Kérdések véletlenszerű összekeverése egyetlen oldalon.';
$string['link'] = 'Hivatkozás';
$string['listitems'] = 'Teszt tételeinek felsorolása';
$string['literal'] = 'Szövegkonstans';
$string['loadingquestionsfailed'] = 'A kérdések betöltése nem sikerült: {$a}';
$string['makecopy'] = 'Mentés új kérdésként';
$string['managetypes'] = 'Kérdéstípusok és szerverek kezelése';
$string['manualgradequestion'] = '{$a->quiz} teszt {$a->question} kérdésének értékelése kézzel, {$a->user} felhasználónál';
$string['manualgrading'] = 'Értékelés';
$string['mark'] = 'Leadás';
$string['markall'] = 'Oldal leadása';
$string['marks'] = 'Pontok';
$string['marks_help'] = 'Az egyes kérdések pontszáma, valamint a próbálkozás végső értékelése. A Pontok csak akkor válaszható, ha a Maximális pontszám is ki lett választva.';
$string['match'] = 'Párosító';
$string['matchanswer'] = 'Párosító válasz';
$string['matchanswerno'] = 'Hozzáillő {$a} válasz';
$string['max'] = 'Max.';
$string['maxmark'] = 'Maximális pont';
$string['maxmarks'] = 'Maximális pontszám';
$string['maxmarks_help'] = 'Az egyes kérdésekre adható maximális pontszám.';
$string['messageprovider:attempt_grading_complete'] = 'Értesítés, hogy a próbálkozása értékelve lett.';
$string['messageprovider:attempt_overdue'] = 'Figyelmeztetés, ha a tesztpróbálkozás túllépi a határidőt';
$string['messageprovider:confirmation'] = 'Saját tesztleadásainak megerősítése';
$string['messageprovider:quiz_open_soon'] = 'A teszt hamarosan megnyílik';
$string['messageprovider:submission'] = 'Értesítés tesztleadásokról ';
$string['min'] = 'min.';
$string['minutes'] = 'perc';
$string['missingcategory'] = 'Hiányzó kérdéskategória';
$string['missingcorrectanswer'] = 'A helyes választ meg kell adni';
$string['missingitemtypename'] = 'Hiányzó név';
$string['missingquestion'] = 'A kérdés már nem létezik';
$string['modulename'] = 'Teszt';
$string['modulename_help'] = 'A teszt tevékenységgel a tanár teszteket állíthat össze többféle kérdéstípus felhasználásával, például feleletválasztós, igaz-hamis vagy párosítós kérdésekből.

A tanár engedélyezhet többszöri próbálkozást, mely során a kérdések újra lesznek keverve vagy egy kérdésbankból véletlenszerűen kerülnek kiválasztásra. Megadhat hozzá időkorlátot is.

Az egyes próbálkozások értékelése az esszékérdések kivételével automatikus, az eredmény pedig bekerül az értékelésnaplóba.

A tanár eldöntheti, hogy segítségek, visszajelzések és a jó válaszok megjelenjenek-e a tanulóknak, és ha igen, mikor.

A tesztek használhatók

* Kurzusvizsgához
* Szövegértési feladatokhoz vagy egy-egy téma összegzésénél
* Gyakorló tesztként korábbi vizsgák anyaga alapján
* Azonnali visszajelzéshez, ismeret-ellenőrzéshez
* Önellenőrzéshez';
$string['modulename_link'] = 'mod/quiz/view';
$string['modulenameplural'] = 'Tesztek';
$string['moveselectedonpage'] = 'A kiválasztott kérdések áthelyezése a(z) {$a} oldalra';
$string['multichoice'] = 'Feleletválasztós';
$string['multipleanswers'] = 'Válasszon legalább egy válaszlehetőséget.';
$string['mustbesubmittedby'] = 'A próbálkozást {$a} időpontig le kell adni.';
$string['name'] = 'Név';
$string['navigatenext'] = 'Következő oldal';
$string['navigateprevious'] = 'Előző oldal';
$string['navmethod'] = 'Navigálási mód';
$string['navmethod_free'] = 'Kötetlen';
$string['navmethod_help'] = 'Az egymás utáni navigálás bekapcsolása esetén a tanulónak a tesztkérdéseket egymás után kell megoldani, egy előző oldalra nem térhet vissza, és nem ugorhat át oldalakat,';
$string['navmethod_seq'] = 'Egymás utáni';
$string['navnojswarning'] = 'Vigyázat: a hivatkozásokkal nem menti el válaszait. Használja az oldal alján lévő Következő gombot.';
$string['neverallononepage'] = 'Soha, minden kérdés egy oldalon.';
$string['newattemptfail'] = 'Hiba: a tesztben nem lehetett új próbálkozást indítani';
$string['newcategory'] = 'Új kategória';
$string['newpage'] = 'Új oldal';
$string['newpage_help'] = '<p>Hosszabb tesztek esetén célszerű azt több oldalra széthúzni
az oldalanként jelzendő kérdések számának módosításával.
A kérdések hozzáadása során ennek megfelelően automatikusan
laptörések kerülnek az állományba. Ezeket később a szerkesztő
oldalon kézzel módosíthatja.
</p>';
$string['newpageevery'] = 'Új oldal automatikus megkezdése';
$string['newsectionheading'] = 'Új fejléc';
$string['noanswers'] = 'Nincs kiválasztva válasz!';
$string['noattempts'] = 'A teszt megoldásával még nem próbálkoztak';
$string['noattemptsfound'] = 'Nincs próbálkozás';
$string['noattemptstoshow'] = 'Nincs megmutatható próbálkozás';
$string['nocategory'] = 'Hibás, vagy nincs megadva kategória';
$string['noclose'] = 'Nincs lezárási időpont';
$string['nocommentsyet'] = 'Még nincs megjegyzés.';
$string['noconnection'] = 'Jelenleg nincs olyan webszolgáltatási kapcsolat, amely ezt a kérdést fel tudná dolgozni. Lépjen kapcsolatba a rendszergazdával.';
$string['nodataset'] = 'semmi - ez nem helyettesítő karakter';
$string['nodatasubmitted'] = 'Nem adott le adatokat.';
$string['noessayquestionsfound'] = 'Nem található kézzel értékelt kérdés';
$string['nogradewarning'] = 'A teszt nincs értékelve, ezért nem állítható be értékelésfüggő visszajelzés.';
$string['nomoreattempts'] = 'Több próbálkozás nem lehetséges';
$string['none'] = 'Egy sem';
$string['noopen'] = 'Nincs megnyitási időpont';
$string['nooverridedata'] = 'A teszt beállításai közül legalább egyet felül kell írnia.';
$string['nopossibledatasets'] = 'Nincsenek lehetséges adatkészletek';
$string['noquestionintext'] = 'A kérdés szövegében nincs beépített kérdés';
$string['noquestions'] = 'Nincs még hozzáadva kérdés';
$string['noquestionsfound'] = 'Nincs kérdés';
$string['noquestionsinquiz'] = 'A teszt nem tartalmaz kérdéseket.';
$string['noquestionsnotinuse'] = 'Ez a véletlenszerű kérdés nem használatos, mert üres a kategóriája.';
$string['noquestionsonpage'] = 'Üres oldal';
$string['noresponse'] = 'Nincs válasz';
$string['noreview'] = 'Ezt a tesztet nem ellenőrizheti';
$string['noreviewattempt'] = 'Ezt a próbálkozást nem ellenőrizheti.';
$string['noreviewshort'] = 'Nincs engedélyezve';
$string['noreviewuntil'] = 'Ezt a tesztet {$a}-ig nem ellenőrizheti';
$string['noreviewuntilshort'] = 'Elérhető {$a}';
$string['noscript'] = 'A folytatáshoz be kell kapcsolni a javascriptet.';
$string['notavailabletostudents'] = 'Megjegyzés: Ez a teszt jelenelg nem elérhető a  tanulók számára';
$string['notenoughrandomquestions'] = 'A(z) {$a->category} kérdéskategóriában nincs elég kérdés a(z) {$a->name} ({$a->id}) kérdés létrehozásához.';
$string['notenoughsubquestions'] = 'Kevés alkérdést adott meg!<br />Visszatér és kijavítja ezt a kérdést?';
$string['notifyattemptsgradedtask'] = 'Tesztpróbálkozás értékelve értesítés küldése';
$string['notimedependentitems'] = 'A tesztmodul nem támogatja az időfüggő tételeket. Adjon meg egy időkorlátot az egész tesztre. Másik tételt kíván választani (vagy mégis a jelenlegit használja)?';
$string['notyetgraded'] = 'Még nincs értékelve';
$string['notyetviewed'] = 'Még nem tekintette meg';
$string['notyourattempt'] = 'Ez nem az Ön próbálkozása!';
$string['noview'] = 'Belépett felhasználó nem tekintheti meg ezt a tesztet';
$string['numattempts'] = '{$a->studentnum} {$a->studentstring} összesen {$a->attemptnum} próbálkozást tett';
$string['numberabbr'] = 'sz.';
$string['numerical'] = 'Számjegyes';
$string['numquestionsx'] = 'Kérdés: {$a}';
$string['oneminute'] = '1 perc';
$string['onlyteachersexport'] = 'Csak tanárok exportálhatnak kérdéseket';
$string['onlyteachersimport'] = 'Csak szerkesztési joggal rendelkező tanárok importálhatnak kérdéseket';
$string['onthispage'] = 'Ezen az oldalon';
$string['open'] = 'Nincs megoldva';
$string['openafterclose'] = 'A teszt frissítése nem sikerült. A kezdési idő a lezárási idő után van.';
$string['openclosedatesupdated'] = 'A teszt megnyitási és lezárási időpontjait frissítettük';
$string['optional'] = 'opcionális';
$string['orderandpaging'] = 'Sorrend és oldalszám';
$string['orderandpaging_help'] = 'Az egyes kérdésekkel szemközti 10, 20, 30, ... szám a kérdések sorrendjére utal. A számok későbbi kérdésekhez további hely biztosítása érdekében 10-esével növekednek. Újrarendezésükhöz módosítsa a számokat, majd kattintson a "Kérdések újrarendezése" gombra.

Ha a kérdésekhez oldaltörést kíván beszúrni, jelölje be a kérdések melletti négyzeteket, majd kattintson az "Új oldalak beszúrása a kiválasztott kérdések után" gombra.

Ha a kérdések több oldalra férnek ki, kattintson az "Újratördelés" gombra és válassza ki az oldalankénti kérdések számát..
';
$string['orderingquiz'] = 'Sorrend és oldalszám';
$string['orderingquizx'] = 'Sorrend és oldaltörés: {$a}';
$string['outcomesadvanced'] = 'Az Eredmények a részletes beállítások része';
$string['outof'] = '{$a->grade} a(z) {$a->maxgrade} maximumból';
$string['outofpercent'] = '{$a->grade} a(z) {$a->maxgrade} maximumból ({$a->percent}%)';
$string['outofshort'] = '{$a->grade}/{$a->maxgrade}';
$string['overallfeedback'] = 'Globális visszajelzés';
$string['overallfeedback_help'] = 'A globális visszajelzést a tanuló a teszt megoldását követően látja. További (százalékkal vagy számmal megadott) ponthatárok megadásával a visszajelzés a tanuló által elért értékeléstől függően változhat.';
$string['overdue'] = 'Határidőn túli';
$string['overduehandling'] = 'Amikor az idő letelik';
$string['overduehandling_desc'] = 'Mi történjen alapesetben, ha egy tanuló  nem adja le a tesztet a határidő lejárta előtt?';
$string['overduehandling_help'] = 'Ez a beállítás szabályozza, hogy mi történik, ha a tanuló nem adja le időben próbálkozását. Ha a tanuló a teszttel van elfoglalva, akkor az időmérő automatikusan mindig leadja a próbálkozást, ha viszont már kijelentkezett, akkor ez a beállítás szabályozza, hogy mi történjen.';
$string['overduehandling_link'] = 'mod/quiz/timing';
$string['overduehandlingautoabandon'] = 'A próbálkozásokat a határidő lejárta előtt le kell adni, ellenkező esetben a rendszer figyelmen kívül hagyja őket.';
$string['overduehandlingautosubmit'] = 'A nyitott próbálkozások leadása automatikus';
$string['overduehandlinggraceperiod'] = 'Létezik egy türelmi időszak, amely alatt a nyitott próbálkozások még befejezhetők, de további kérdések megválaszolására nincs mód.';
$string['overduemustbesubmittedby'] = 'A próbálkozás túllépte a határidőt, már le kellett volna adni. Ha értékelést szeretne kapni a tesztre, {$a}-ig mindenképp le kell azt adnia. Ha addig nem teszi, erre a próbálkozásra nem kap értékelést.';
$string['override'] = 'Felülírás';
$string['overridecannotchange'] = 'A felhasználó vagy csoport nem módosítható a felülbírálat létrehozása után.';
$string['overridecannotsetbothgroupanduser'] = 'A csoport és a felhasználó nem állítható be egyszerre.';
$string['overridedeletegroupsure'] = 'Biztosan törli {$a} csoport felülírását?';
$string['overridedeleteusersure'] = 'Biztosan törli {$a} felhasználó felülírását?';
$string['overridegroup'] = 'Csoport felülírása';
$string['overridegroupeventname'] = '{$a->quiz} - {$a->group}';
$string['overrideinvalidattempts'] = 'A próbálkozások értékének nagyobbnak kell lennie nullánál.';
$string['overrideinvalidexistingid'] = 'A felülbírálás nem létezik.';
$string['overrideinvalidgroup'] = 'A megadott csoport nem létezik.';
$string['overrideinvalidquiz'] = 'A beállított teszt azonosító nem létezik.';
$string['overrideinvalidtimelimit'] = 'Az időkorlátnak nullánál nagyobbnak kell lennie.';
$string['overrideinvaliduser'] = 'A megadott felhasználó nem létezik.';
$string['overridemultiplerecordsexist'] = 'Ugyanazon felhasználó/csoport esetében nem lehet többszörösen felülbírálni.';
$string['overridemustsetuserorgroup'] = 'Be kell állítani egy felhasználót vagy csoportot.';
$string['overrides'] = 'Felülírások';
$string['overridesforquiz'] = 'Beállítások felülírása: {$a}';
$string['overridesnoneforgroups'] = 'A teszthez nem készültek csoportbeállítási felülírások.';
$string['overridesnoneforusers'] = 'A teszthez nem készültek felhasználóbeállítási felülírások.';
$string['overridessummary'] = 'Vannak beállítási felülírások ({$a})';
$string['overridessummarygroup'] = 'Csoportok: {$a}';
$string['overridessummarythisgroup'] = 'Vannak beállítási felülírások ({$a}) a csoporthoz';
$string['overridessummaryuser'] = 'Felhasználók: {$a}';
$string['overridessummaryyourgroups'] = 'Vannak beállítási felülírások ({$a}) a csoportjaihoz';
$string['overrideuser'] = 'Felhasználó felülírása';
$string['overrideusereventname'] = '$a->quiz} - Felülírás';
$string['page-mod-quiz-attempt'] = 'Próbálkozás oldala';
$string['page-mod-quiz-edit'] = 'Tesztoldal szerkesztése';
$string['page-mod-quiz-report'] = 'A tesztjelentés tetszőleges oldala';
$string['page-mod-quiz-review'] = 'Próbálkozás oldalának felülvizsgálata';
$string['page-mod-quiz-summary'] = 'Próbálkozás összegzésének oldala';
$string['page-mod-quiz-view'] = 'A teszt tájékoztató oldala';
$string['page-mod-quiz-x'] = 'Bármely tesztmodul oldala';
$string['pageshort'] = 'p';
$string['pagesize'] = 'Oldalméret';
$string['parent'] = 'Szülő- (felettes) kategória';
$string['parentcategory'] = 'Fölső kategória';
$string['parsingquestions'] = 'Importált állomány kérdéseinek feldolgozása.';
$string['partiallycorrect'] = 'Részben helyes';
$string['penalty'] = 'Büntetés';
$string['penaltyscheme'] = 'Büntetőpontok alkalmazása';
$string['penaltyscheme_help'] = '<p>Ha egy teszt adaptív módban működik, akkor a tanuló a rossz válasz után újból
próbálkozhat. Ez esetben a kérdésre adott végleges osztályzatból a rossz válaszokra büntetőpont vonható le. Ennek mennyisége az egyes kérdésekre külön-külön adható meg a kérdés beállítása vagy szerkesztése során.</p>

<p>Ez a beállítás csak adaptív módban bír jelentőséggel.</p>';
$string['percentcorrect'] = 'százalék helyes';
$string['pleaseclose'] = 'Kérését feldolgoztuk. Bezárhatja ezt az ablakot.';
$string['pluginadministration'] = 'Teszt kezelése';
$string['pluginname'] = 'Teszt';
$string['popup'] = 'Teszt megjelenítése &quot;biztonságos&quot; ablakban';
$string['popupblockerwarning'] = 'A dolgozat ezen része biztonságos üzemmódban van, vagyis a tesztet biztonságos ablakban kell megoldania. Kapcsolja ki az előbukkanó ablakok tiltását. Köszönjük.';
$string['popupnotice'] = 'A tanulók a tesztet egy biztonságos ablakban látják';
$string['precreateattempts'] = 'Próbálkozások előzetes létrehozása';
$string['precreateattempts_desc'] = 'A próbálkozások előzetes létrehozása segíti a portálteljesítmény optimalizálását. A beállítás bekapcsolása mellett meg kell még adni az előzetes létrehozás idejét is. Megjegyzés: a beállítás csak olyan teszteknél érvényes, melyeknél adott egy megnyitási időpont.';
$string['precreateattempts_help'] = 'A próbálkozások előzetes létrehozása segíti a portálteljesítmény optimalizálását. A teszt kérdései nem módosíthatók azután, hogy a tesztnél vannak próbálkozások.';
$string['precreateoff'] = 'Ne hozzon létre előzetesen próbálkozásokat';
$string['precreateperiod'] = 'Előzetes próbálkozáslétrehozás ideje';
$string['precreateperiod_desc'] = 'Amennyiben a portálon olyan teszteket használ, melyek egy adott időpontban nyílnak meg, és ezeket sok tanuló kezdi el egyazon időpontban, javíthatja a teljesítmény a próbálkozások előzetes létrehozásával. Állítson be egy időszakot a teszt megnyitása előtt a próbálkozások előkészítéséhez. Érdemes egy rövid időszakot alkalmazni, mert a teszt kérdéseit nem módosíthatjuk, ha már vannak próbálkozások. A próbálkozásokat egy ütemezett feladat hozza létre, mely alapból óránként fut le. Hogy a próbálkozások létrehozása a rendszer egy olyan nyugodt időszakában történjen, mint például a megelőző este, állítsa be az időszakot 12 órára és módosítsa az ütemezett feladatot úgy, hogy annak lefutása a nyugott(abb) időszakban történjen.';
$string['precreatetask'] = 'Próbálkozások előzetes létrehozása';
$string['precreateusedefault'] = 'Rendszerszintű alapértelmezés használata ({$a})';
$string['precreateyes'] = 'Igen, {$a} órával a teszt megnyitása előtt';
$string['preprocesserror'] = 'Hiba történt az előfeldolgozás során!';
$string['preview'] = 'Előzetes megtekintés';
$string['previewquestion'] = 'Kérdés előzetes megtekintése';
$string['previewquiz'] = '{$a} előzetes megtekintése';
$string['previewquiznow'] = 'Teszt előzetes megtekintése most';
$string['previewquizstart'] = 'Teszt előzetes megtekintése';
$string['previous'] = 'Előző állapot';
$string['privacy:metadata:core_question'] = 'A teszttevékenység a core_question alrendszerben tárolja a kérdés használatával összefüggő adatokat.';
$string['privacy:metadata:quiz'] = 'A teszttevékenység tesztjelentéseket használ.';
$string['privacy:metadata:quiz_attempts'] = 'A teszttel való egyes próbálkozások részletei.';
$string['privacy:metadata:quiz_attempts:attempt'] = 'A próbálkozás száma.';
$string['privacy:metadata:quiz_attempts:currentpage'] = 'A felhasználó aktuális tartózkodási oldala.';
$string['privacy:metadata:quiz_attempts:gradednotificationsenttime'] = 'Azon időpont, amikor a felhasználó értesült arról, hogy a próbálkozásának kézi értékelése megtörtént';
$string['privacy:metadata:quiz_attempts:preview'] = 'Ez a teszt előnézete-e.';
$string['privacy:metadata:quiz_attempts:state'] = 'A próbálkozás jelenlegi állapota.';
$string['privacy:metadata:quiz_attempts:sumgrades'] = 'A próbálkozáshoz tartozó értékelések összege.';
$string['privacy:metadata:quiz_attempts:timecheckstate'] = 'Az állapot ellenőrzésének időpontja.';
$string['privacy:metadata:quiz_attempts:timefinish'] = 'A próbálkozás befejezésének az időpontja.';
$string['privacy:metadata:quiz_attempts:timemodified'] = 'A próbálkozás frissítésének az időpontja.';
$string['privacy:metadata:quiz_attempts:timemodifiedoffline'] = 'A próbálkozás offline frissítésének az időpontja.';
$string['privacy:metadata:quiz_attempts:timestart'] = 'A próbálkozás kezdetének az időpontja.';
$string['privacy:metadata:quiz_grades'] = 'A teszt globális értékelésének részletei.';
$string['privacy:metadata:quiz_grades:grade'] = 'A teszt globális értékelése.';
$string['privacy:metadata:quiz_grades:quiz'] = 'Az értékelt teszt.';
$string['privacy:metadata:quiz_grades:timemodified'] = 'Az értékelés módosításának időpontja.';
$string['privacy:metadata:quiz_grades:userid'] = 'Az értékelt felhasználó.';
$string['privacy:metadata:quiz_overrides'] = 'A teszt felülírásának a részletei';
$string['privacy:metadata:quiz_overrides:quiz'] = 'A felülírási adatokat tartalmazó teszt';
$string['privacy:metadata:quiz_overrides:timeclose'] = 'A teszt lezárásának új időpontja.';
$string['privacy:metadata:quiz_overrides:timelimit'] = 'A teszt új időkorlátja.';
$string['privacy:metadata:quiz_overrides:timeopen'] = 'A teszt kezdetének új időpontja.';
$string['privacy:metadata:quiz_overrides:userid'] = 'A felülírt felhasználó';
$string['privacy:metadata:quizaccess'] = 'A teszttevékenység tesztelérési szabályokra támaszkodik.';
$string['publish'] = 'Közzététel';
$string['publishedit'] = 'Engedéllyel kell rendelkeznie a közreadó kurzusban ahhoz, hogy a kategóriában kérdéseket adhasson hozzá és szerkeszthessen';
$string['qbrief'] = 'K. {$a}';
$string['qname'] = 'név';
$string['qti'] = 'IMS QTI forma';
$string['qtypename'] = 'típus, név';
$string['question'] = 'Kérdés';
$string['questionbank'] = 'kérdésbankból';
$string['questionbankmanagement'] = 'Kérdésbank kezelése';
$string['questionbehaviour'] = 'Kérdés viselkedése';
$string['questioncats'] = 'Kérdéskategóriák';
$string['questiondeleted'] = 'A kérdést törölték. Forduljon tanárához.';
$string['questiondependencyadd'] = 'Nincs korlátozva, hogy a(z) {$a->thisq} kérdéssel mikor próbálkozhat • A módosításhoz kattintson';
$string['questiondependencyfree'] = 'Nincs korlát megszabva,';
$string['questiondependencyremove'] = 'A(z) {$a->thisq} kérdéssel az előző {$a->previousq} kérdés befejezéséig nem próbálkozhat • A módosításhoz kattintson';
$string['questiondependsonprevious'] = 'A kérdéssel az előző kérdés befejezéséig nem próbálkozhat.';
$string['questiondraftonly'] = 'A {$a} kérdés piszkozat állapotban van. A tesztben való használatához először lépjen a kérdésbankhoz és ott módosítsa az állapotát készre.';
$string['questiondraftwillnotwork'] = 'Ez a kérdés piszkozat státuszban van, A kérdés használatához módosítsa a státuszát.';
$string['questioninuse'] = 'A(z) \'{$a->questionname}\' jelenleg a {$a->quiznames} között szerepel. A kérdés csak a kategóriák jegyzékéből törlődik, a tesztekből nem.';
$string['questionmissing'] = 'A szakaszból hiányzik egy kérdés';
$string['questionname'] = 'Kérdés neve';
$string['questionnonav'] = '<span class="accesshide"></span>{$a->number}.<span class="accesshide"> {$a->attributes}</span>';
$string['questionnonavinfo'] = '<span class="accesshide"></span>{$a->number}.<span class="accesshide"> {$a->attributes}</span>';
$string['questionnotloaded'] = 'A(z) {$a} kérdés nem töltődött be az adatbázisból';
$string['questionorder'] = 'Kérdések sorrendje';
$string['questionposition'] = '{$a}. kérdés esetén új pozíció';
$string['questions'] = 'Kérdések';
$string['questionsetpreview'] = 'Kérdéskészlet előnézete';
$string['questionsinclhidden'] = 'Kérdések (a rejtettek is)';
$string['questionsinthisquiz'] = 'Kérdések ebben a tesztben';
$string['questionsmatchingfilter'] = 'A(z) {$a} szűrőnek megfelelő kérdések';
$string['questionsperpage'] = 'Oldalankénti max. kérdésszám';
$string['questionsperpageselected'] = 'Az oldalankénti kérdésszám be van állítva, így az oldalakra törés jelenleg rögzített. Ezért az oldaltörés kezelőszervei ki vannak kapcsolva. Módosíthatja itt: {$a}.';
$string['questionsperpagex'] = 'Oldalankénti kérdésszám: {$a}';
$string['questiontext'] = 'Kérdés szövege';
$string['questiontextisempty'] = '[Üres kérdésszöveg]';
$string['questiontype'] = '{$a} típusú kérdés';
$string['questiontypesetupoptions'] = 'Kérdéstípusok beállítási lehetőségei:';
$string['questionversion'] = 'v{$a}';
$string['questionversionlatest'] = 'v{$a} (legutóbbi)';
$string['quiz:addinstance'] = 'Új teszt hozzáadása';
$string['quiz:attempt'] = 'Próbálkozás tesztekkel';
$string['quiz:deleteattempts'] = 'Próbálkozások törlése';
$string['quiz:emailconfirmsubmission'] = 'Leadáskor visszaigazolás';
$string['quiz:emailnotifyattemptgraded'] = 'Értesítés fogadása a próbálkozás értékelésének megtörténtéről';
$string['quiz:emailnotifysubmission'] = 'Próbálkozásról értesítés e-mailben';
$string['quiz:emailwarnoverdue'] = 'Figyelmeztetés küldése, ha a próbálkozás átlépi a határidőt';
$string['quiz:grade'] = 'Tesztek értékelése kézzel';
$string['quiz:ignoretimelimits'] = 'Tesztek időkorlátjának mellőzése';
$string['quiz:manage'] = 'Tesztek kezelése';
$string['quiz:manageoverrides'] = 'Tesztfelülírások kezelése';
$string['quiz:preview'] = 'Tesztek előzetes megtekintése';
$string['quiz:regrade'] = 'Tesztpróbálkozások újraértékelése';
$string['quiz:reopenattempts'] = 'Nem leadott próbálkozások újranyitása';
$string['quiz:reviewmyattempts'] = 'Saját próbálkozások ellenőrzése';
$string['quiz:view'] = 'Tesztadatok megtekintése';
$string['quiz:viewoverrides'] = 'Tesztfelülírások megtekintése';
$string['quiz:viewreports'] = 'Tesztjelentések megtekintése';
$string['quizavailable'] = 'A teszt megoldható eddig: {$a}';
$string['quizclose'] = 'Teszt lezárása';
$string['quizclosed'] = 'Teszt lezárva ekkor: {$a}';
$string['quizcloses'] = 'Teszt véget ér';
$string['quizcloseson'] = 'A teszt véget ér ekkor: {$a}';
$string['quizeventcloses'] = '{$a} lezárul';
$string['quizeventopens'] = '{$a} megnyílik';
$string['quizinvalidquestions'] = 'Ez a teszt érvénytelen típusú kérdéseket tartalmaz. A hiányzó kérdéstípust vagy újra kell telepíteni vagy az érintett kérdéseket el kell távolítani, hogy a teszt használható legyen.';
$string['quizisclosed'] = 'A teszt le van zárva.';
$string['quizisclosedwillopen'] = 'A teszt le van zárva (nyitás: {$a})';
$string['quizisopen'] = 'A teszt nyitva van.';
$string['quizisopenwillclose'] = 'A teszt nyitva van ({$a} bezáródik)';
$string['quiznavigation'] = 'Tesztnavigáció';
$string['quizopen'] = 'Teszt megnyitása';
$string['quizopenclose'] = 'Nyitás és zárás időpontja';
$string['quizopenclose_help'] = 'A tanulók csak a nyitás időpontja után próbálkozhatnak, és a zárás időpontjáig be kell fejezniük próbálkozásukat.';
$string['quizopenclose_link'] = 'mod/quiz/timing';
$string['quizopendatesoonhtml'] = '<p>Kedves {$a->firstname}!</p>
<p>A(z) {$a->coursename} kurzusban levő <strong>{$a->quizname}</strong> teszt hamarosan megnyílik.</p>
<p><strong>Megnyitás: {$a->timeopen}</strong></p>
<p><strong>Lezárás: {$a->timeclose}</strong></p>
<p><a href="{$a->url}">Teszthez lépés</a></p>';
$string['quizopendatesoonsubject'] = '{$a->timeopen}-kor megnyílik a(z) {$a->quizname} teszt';
$string['quizopened'] = 'A teszt elérhető.';
$string['quizopenedon'] = 'A teszt {$a} időponttól volt elérhető';
$string['quizopens'] = 'Teszt elérhető';
$string['quizopenwillclose'] = 'A teszt elérhető, lezárásának időpontja: {$a}';
$string['quizordernotrandom'] = 'A teszt sorrendje nincs összekeverve';
$string['quizorderrandom'] = '* A teszt sorrendje össze van keverve';
$string['quizreport'] = 'Tesztjelentés';
$string['quizsettings'] = 'Teszt beállításai';
$string['quizsetupnavigation'] = 'Tesztbeállítás navigáció';
$string['quiztimer'] = 'Teszt időmérője';
$string['quizwillopen'] = 'A teszt elérhető lesz ekkor: {$a}.';
$string['random'] = 'Véletlenszerű kérdés';
$string['randomcatwithsubcat'] = '{$a} és alkategóriák';
$string['randomcoursecatwithsubcat'] = 'Bármely kategória a(z) {$a} kurzuskategórián belül';
$string['randomcoursewithsubcat'] = 'Bármely kategória ebben a kurzusban';
$string['randomcreate'] = 'Véletlenszerű kérdések létrehozása';
$string['randomediting'] = 'Véletlenszerű kérdés szerkesztése';
$string['randomfaultynosubcat'] = 'Hibás kérdés';
$string['randomfromcategory'] = 'Véletlen kérdés ebből a kategóriából:';
$string['randomfromexistingcategory'] = 'Meglévő kategóriából származó véletlenszerű kérdés';
$string['randomfromunavailabletag'] = '{$a}  (nem elérhető)';
$string['randommodulewithsubcat'] = 'A teszt bármely kategóriája';
$string['randomnosubcat'] = 'Kérdések ebből a kategóriából, de nem ennek alkategóriáiból.';
$string['randomnumber'] = 'Véletlen kérdések száma';
$string['randomqname'] = 'Véletlenszerű kérdés szűrőfeltétel alapján';
$string['randomqnamecat'] = 'Véletlenszerű ({$a->category}) a szűrési feltétel alapján';
$string['randomqnamecattags'] = 'Véletlenszerű ({$a->category}) a címkékkel ellátott szűrőfeltétel alapján: {$a->tags}';
$string['randomqnametags'] = 'Véletlenszerű kérdés szűrőfeltétel alapján a következő címkékkel: {$a}';
$string['randomquestion'] = 'Véletlenszerű kérdés';
$string['randomquestion_help'] = 'Véletlenszerű kérdés révén egy adott kategóriából vagy meghatározott címkével véletlenszerű kérdést szúrhat be egy tevékenységbe.';
$string['randomquestiontags'] = 'Címkék';
$string['randomquestiontags_help'] = 'Kérdéscímkék megadásával tovább szűkítheti a kiválasztási feltételeket.

A "véletlenszerű" kérdések az ezekkel a címkékkel rendelkező kérdések közül kerülnek ki.';
$string['randomquestionusinganewcategory'] = 'Új kategóriából származó véletlenszerű kérdés';
$string['randomsystemwithsubcat'] = 'Bármely rendszerszintű kategória';
$string['randomwithsubcat'] = 'Kérdések ebből a kategóriából és ennek alkategóriáiból.';
$string['readytosend'] = 'A teljes tesztjét értékelésre készül beküldeni. Biztosan folytatni kívánja?';
$string['reattemptquiz'] = 'Újbóli próbálkozás a teszt megoldásával';
$string['recentlyaddedquestion'] = 'Nemrégen hozzáadott kérdés!';
$string['recurse'] = 'Alkategóriák kérdései is benne legyenek';
$string['redoesofthisquestion'] = 'Egyéb itt sorra vett kérdések:  {$a}';
$string['redoquestion'] = 'Próbálkozás egy hasonló kérdéssel';
$string['regrade'] = 'Minden próbálkozás újraértékelése';
$string['regradecomplete'] = 'Minden próbálkozás újraértékelése kész';
$string['regradecount'] = '{$a->attempt} értékelésből {$a->changed} módosult';
$string['regradedisplayexplanation'] = 'Az újraértékelés során módosuló próbálkozások a kérdésellenőrzés ablakához vezető hivatkozásokként jelennek meg';
$string['regradenotallowed'] = 'Nincs jogosultsága a tesztet újraértékeléséhez';
$string['regradingquestion'] = '"{$a}" újraértékelés.';
$string['regradingquiz'] = '"{$a}" teszt újraértékelése';
$string['remove'] = 'Törlés';
$string['removeallgroupoverrides'] = 'Az összes csoportfölülírás törlése';
$string['removeallquizattempts'] = 'Minden próbálkozás törlése';
$string['removealluseroverrides'] = 'Az összes felhasználó-fölülírás törlése';
$string['removeemptypage'] = 'Üres oldal eltávolítása';
$string['removepagebreak'] = 'Oldaltörés törlése';
$string['removeselected'] = 'A kiválasztott törlése';
$string['rename'] = 'Átnevezés';
$string['renderingserverconnectfailed'] = 'A(z) {$a} szerver nem dolgozott fel egy RQP-kérést. Ellenőrizze az URL helyességét.';
$string['reopenattempt'] = 'Újranyitás';
$string['reopenattemptareyousuremessage'] = 'Ez újra megnyitja a {$a->attemptnumber} kísérletet {$a->attemptuser} számára.';
$string['reopenattemptareyousuretitle'] = 'Próbálkozás újranyitása?';
$string['reopenattemptwrongstate'] = 'A(z) {$a->attemptid} próbálkozás nincs megfelelő állapotban ({$a->state}) az újranyitáshoz.';
$string['reopenedattemptwillbeinprogress'] = 'A kísérlet nyitva marad, és folytatható.';
$string['reopenedattemptwillbeinprogressuntil'] = 'A próbálkozás nyitva marad és folytatható mindaddig, míg a teszt le nem zár ekkor: {$a}.';
$string['reopenedattemptwillbesubmitted'] = 'A próbálkozás azonnal értékelésre kerül.';
$string['reorderquestions'] = 'Kérdések átrendezése';
$string['reordertool'] = 'Átrendezési eszköz megjelenítése';
$string['repaginate'] = 'Újraszámozás oldalanként {$a} kérdéssel';
$string['repaginatecommand'] = 'Újratördelés';
$string['repaginatenow'] = 'Újratördelés most';
$string['replace'] = 'Csere';
$string['replacementoptions'] = 'Csere lehetőségei';
$string['report'] = 'Jelentések';
$string['reportanalysis'] = 'Tételelemzés';
$string['reportattemptsfrom'] = 'Próbálkozás szerzője';
$string['reportattemptsthatare'] = 'Próbálkozások jellemzése';
$string['reportdisplayoptions'] = 'Megjelenítési lehetőségek';
$string['reportfullstat'] = 'Részletes statisztika';
$string['reportmulti_percent'] = 'Többszörös százalék';
$string['reportmulti_q_x_student'] = 'Többtanulós lehetőségek';
$string['reportmulti_resp'] = 'Egyedi válaszok';
$string['reportmustselectstate'] = 'Legalább egy állapotot ki kell választania';
$string['reportnotfound'] = 'Ismeretlen jelentés ({$a})';
$string['reportoverview'] = 'Áttekintés';
$string['reportregrade'] = 'Próbálkozások újraértékelése';
$string['reportresponses'] = 'Részletes tanulói válaszok';
$string['reports'] = 'Jelentések';
$string['reportshowonly'] = 'Csak a próbálkozások megjelenítése';
$string['reportshowonlyfinished'] = 'Felhasználónként legfeljebb egy befejezett próbálkozás megjelenítése ({$a})';
$string['reportsimplestat'] = 'Egyszerű statisztika';
$string['reportusersall'] = 'mindenki, aki próbálkozott a teszt megoldásával';
$string['reportuserswith'] = 'beiratkozottak, akik próbálkoztak a teszt megoldásával';
$string['reportuserswithorwithout'] = 'beiratkozottak, akik esetleg próbálkoztak a teszt megoldásával';
$string['reportuserswithout'] = 'beiratkozottak, akik nem próbálkoztak a teszt megoldásával';
$string['reportwhattoinclude'] = 'Mi szerepeljen a jelentésben';
$string['requirepassword'] = 'Jelszó előírása';
$string['requirepassword_help'] = '<p>Ez a mező opcionális.</p>

<p>Ha itt megad egy jelszót, akkor a résztvevőknek ugyanezt a jelszót kell megadniuk ahhoz, hogy
megpróbálkozhassanak a teszttel.</p>';
$string['requiresubnet'] = 'Hálózati cím előírása';
$string['requiresubnet_help'] = '<p>Ez a mező opcionális.</p>

<p>Helyi hálózaton vagy az Interneten egy teszt elérhetőségét konkrét alhálózatokhoz
kötheti oly módon, hogy megad egy vesszőkkel határolt, részleges vagy teljes IP-címet tartalmazó
listát.</p>

<p>Ez különösen ellenőrzött teszt esetén hasznos, ahol biztos akar lenni abban, hogy csakis egy
meghatározott teremben lévők számára legyen hozzáférhető a teszt.</p>

<p>Például: <strong>192.168. , 231.54.211.0/20, 231.3.56.211</strong></p>

<p>Háromféle számot használhat (nincs mód szöveges doménnevek használatára):
<ol>
<li>Teljes IP-címek, például <strong>192.168.10.1</strong>, amelyek egy konkrét számítógépet
(vagy proxy-t) azonosítanak.</li>
<li>Részleges címek, például <strong>192.168</strong>, amely bármely adott számokkal
kezdődő helyet azonosít.</li>
<li>CIDR-jelölés, például <strong>231.54.211.0/20</strong>, mellyel részletesebb alhálózatokat
jelölhet.</li>
</ol>
</p>

<p>A szóközöket a rendszer figyelmen kívül hagyja.</p>';
$string['response'] = 'Tanuló válasza';
$string['responses'] = 'Tanuló válaszai';
$string['results'] = 'Eredmények';
$string['returnattempt'] = 'Vissza a próbálkozáshoz';
$string['reuseifpossible'] = 'korábban eltávolított újbóli használata';
$string['reverttodefaults'] = 'Visszatérés a teszt alapbeállításaihoz';
$string['review'] = 'Értékelés';
$string['reviewafter'] = 'Teszt lezárása után értékelés engedélyezése';
$string['reviewalways'] = 'Bármikori értékelés  engedélyezése';
$string['reviewattempt'] = 'Próbálkozás értékelése';
$string['reviewbefore'] = 'Értékelés engedélyezése, amíg a teszt elérhető';
$string['reviewclosed'] = 'A teszt lezárása után';
$string['reviewduring'] = 'Próbálkozás alatt';
$string['reviewimmediately'] = 'Közvetlenül a próbálkozás után';
$string['reviewnever'] = 'Értékelés sosem lehetséges';
$string['reviewofquestion'] = '{$a->quiz} teszt {$a->question} kérdésének {$a->user} általi ellenőrzése';
$string['reviewopen'] = 'Később, amíg a teszt elérhető';
$string['reviewoptions'] = 'Tanulók értékelhetik';
$string['reviewoptionsheading'] = 'Visszajelzések a tesztírás során';
$string['reviewoptionsheading_help'] = 'Ezek a lehetőségek szabályozzák, milyen adatokat láthatnak a felhasználók egy teszttel való próbálkozás ellenőrzése vagy tesztjelentések megtekintése során.

**Próbálkozás közben** - a beállítás csak egyes esetekben, pl. a \'interaktív többszöri próbálkozás\'  alkalmával jut szerephez, amikor is próbálkozás közben visszajelzésre kerülhet sor.

**Közvetlenül a próbálkozás után** -- azt jelenti, hogy két percen belül attól számítva, hogy a felhasználó a \'Leadás és befejezés\' gombra kattint.

**Később, amíg a teszt elérhető** -- ezt követően, de még a teszt lezárási időpontja előtt.

**A teszt lezárása után** -- azt követően, hogy a teszt lezárult. Ha a teszthez nincs lezárási időpont, akkor ez az állapot sosem következik be.';
$string['reviewoverallfeedback'] = 'Globális visszajelzés';
$string['reviewoverallfeedback_help'] = 'A próbálkozás végén, a tanuló összesített osztályzatától függően megjelenő visszajelzés.';
$string['reviewresponse'] = 'Tanuló válaszának értékelése';
$string['reviewresponsetoq'] = 'Tanuló válaszának értékelése ({$a} kérdés)';
$string['reviewthisattempt'] = 'Ellenőrizze az ezen próbálkozásra adott válaszait.';
$string['rqp'] = 'Távoli kérdés';
$string['rqps'] = 'Távoli kérdések';
$string['sameasoverall'] = 'A globális értékelésekkel megegyezően';
$string['save'] = 'Mentés';
$string['saveandedit'] = 'Változások mentése és kérdések szerkesztése';
$string['saveattemptfailed'] = 'A jelen teszten végrehajtott próbálkozás mentése nem sikerült.';
$string['savedfromdeletedcourse'] = 'A törölt "{$a}" kurzusból elmentve';
$string['savegrades'] = 'Értékelések mentése';
$string['savemanualgradingfailed'] = 'A módosítás nincs mentve. Ellenőrizze az alábbi üzenetet és próbálja újra!';
$string['savemyanswers'] = 'Válaszaim mentése';
$string['savenosubmit'] = 'Mentés leadás nélkül';
$string['saveoverrideandstay'] = 'Mentés és egy másik felülírás megadása';
$string['savequiz'] = 'Az egész teszt mentése';
$string['saving'] = 'Mentés';
$string['savingnewgradeforquestion'] = '{$a} kérdésre adott új értékelés mentése.';
$string['savingnewmaximumgrade'] = 'Új legjobb értékelés mentése.';
$string['score'] = 'Nyers pontszám';
$string['scores'] = 'Pontszámok';
$string['search:activity'] = 'Teszttevékenységek';
$string['searchbyname'] = 'Keresés név alapján...';
$string['sectionheadingedit'] = 'A(z)  \'{$a}\' fejléc szerkesztése';
$string['sectionheadingremove'] = 'A(z)  \'{$a}\' fejléc törlése';
$string['sectionnoname'] = 'Cím nélküli szakasz';
$string['seequestions'] = '(Lásd a kérdéseket)';
$string['select'] = 'Kiválasztás';
$string['selectall'] = 'Az összes kiválasztása';
$string['selectattempt'] = 'Próbálkozás kiválasztása';
$string['selectcategory'] = 'Kategória kiválasztása';
$string['selectedattempts'] = 'Kiválasztott próbálkozások...';
$string['selectmultipleitems'] = 'Több tétel kiválasztása';
$string['selectmultipletoolbar'] = 'Több eszköztár kiválasztása';
$string['selectnone'] = 'Összes kiválasztásának megszüntetése';
$string['selectquestionbank'] = 'Kérdésbank kiválasztása';
$string['selectquestionslot'] = 'Válassza ki a kérdést {$a}';
$string['selectquestiontype'] = '-- Kérdéstípus kiválasztása --';
$string['sendnotificationopendatesoon'] = 'Felhasználó értesítése közelgő tesztmegnyitási időről';
$string['serveradded'] = 'Szerver hozzáadva';
$string['serveridentifier'] = 'Azonosító';
$string['serverinfo'] = 'Szerverinformáció';
$string['servers'] = 'Szerverek';
$string['serverurl'] = 'Szerver webcíme';
$string['shortanswer'] = 'Kiegészítendő';
$string['show'] = 'Mutat';
$string['showall'] = 'Minden kérdés egy oldalon látsszon';
$string['showblocks'] = 'Blokkok megjelenítése a teszten végrehajtott próbálkozások során';
$string['showblocks_help'] = 'Igenre állítás esetén a szokásos blokkok megjelennek a teszten végrehajtott próbálkozások során';
$string['showbreaks'] = 'Oldaltörések látsszanak';
$string['showcategorycontents'] = 'A(z)  {$a->arrow} kategória tartalmának kijelzése';
$string['showcorrectanswer'] = 'Visszajelzésben megjelenjenek a helyes válaszok?';
$string['showdetailedmarks'] = 'Jegy részleteinek megjelenítése';
$string['showeachpage'] = 'Egyszerre egy oldal megjelenítése';
$string['showfeedback'] = 'Válasz után a visszajelzés megjelenjen?';
$string['showinsecurepopup'] = 'A próbálkozásokhoz külön "biztonságos" ablak használata';
$string['showlargeimage'] = 'Nagy kép';
$string['shownoattempts'] = 'Próbálkozás nélküli tanulók megjelenítése';
$string['shownoattemptsonly'] = 'Csak a próbálkozás nélküli tanulók megjelenítése';
$string['shownoimage'] = 'Nincs kép';
$string['showreport'] = 'A jelentés megjelenítése';
$string['showsmallimage'] = 'Kis kép';
$string['showteacherattempts'] = 'Tanári próbálkozások megjelenítése';
$string['showuserpicture'] = 'Felhasználó képének megjelenítése';
$string['showuserpicture_help'] = 'Bekapcsolása esetén próbálkozás közben és az ellenőrző képernyőn látható lesz a tanuló neve és képe. Erre szükség lehet például felügyelet mellett zajló vizsga esetén, mert így könnyebben ellenőrizhető, hogy valóban a felhasználó lépett-e be.';
$string['shuffle'] = 'Összekeverés';
$string['shuffleanswers'] = 'Válaszok összekeverése';
$string['shuffledrandomly'] = 'Véletlenszerű összekeverés';
$string['shufflequestions'] = 'Összekeverés';
$string['shufflequestions_help'] = 'Bekapcsolása esetén a kérdések sorrendje minden próbálkozás alkalmával véletlenszerűen keveredni fog.

Így a tanulók nehezebben működhetnek együtt, de nehezebbé válik egy adott kérdésnek a tanárral való megvitatása is.';
$string['shufflewithin'] = 'Kérdéseken belüli összekeverés';
$string['shufflewithin_help'] = '<p>Az opció bekapcsolása esetén az egyes kérdések részei véletlenszerűen összekeverednek, ha egy tanuló a teszttel próbálkozik, feltéve, hogy az opció a kérdések beállításában is be van kapcsolva.</p>

<p>Ennek az a célja, hogy kissé megnehezítse azt, hogy a tanulók egymástól átmásoljanak megoldásokat.</p>

<p>Az opció csak a több részből felépülő kérdések, például a feleletválasztós és a párosító kérdések esetén használható. Feleletválasztós kérdések esetén a válaszok sorrendje csak akkor keveredik össze, ha ez az opció &quot;Igen&quot;-re van állítva. Párosító kérdéseknél a válaszok mindig összekeverednek. Ez a beállítás a kérdés-válasz párok sorrendjének a felcserélését is érinti.</p>

<p>Ugyanakkor a beállítás nem érinti a véletlenszerű kérdések használatát.</p>';
$string['singleanswer'] = 'Válasszon egy választ.';
$string['sortage'] = 'Rendezés kor szerint';
$string['sortalpha'] = 'Rendezés név szerint';
$string['sortquestionsbyx'] = 'Kérdések rendezése {$a} szerint';
$string['sortsubmit'] = 'Kérdések rendezése';
$string['sorttypealpha'] = 'Rendezés típus, név szerint';
$string['specificapathnotonquestion'] = 'A megadott útvonal nincs a megadott kérdésben';
$string['specificquestionnotonquiz'] = 'A megadott kérdés nincs a megadott tesztben';
$string['startagain'] = 'Újrakezdés';
$string['startattempt'] = 'Próbálkozás indítása';
$string['startedon'] = 'Kezdés ideje';
$string['startnewpreview'] = 'Új előnézet indítása';
$string['stateabandoned'] = 'Sohasem adott le munkát';
$string['statefinished'] = 'Befejezte';
$string['statefinisheddetails'] = 'Leadott: {$a}';
$string['stateinprogress'] = 'Folyamatban';
$string['statenotloaded'] = 'A(z) {$a} kérdés állapota nem töltődött be az adatbázisból';
$string['stateoptions'] = 'Próbálkozás lehetséges állapotai';
$string['stateoverdue'] = 'Határidőn túli';
$string['stateoverduedetails'] = 'Leadanadó eddig: {$a}';
$string['statesubmitted'] = 'Leadva';
$string['status'] = 'Állapot';
$string['stoponerror'] = 'Hiba esetén leállás';
$string['submission_confirmation'] = 'Az összes válasz leadása és a teszt befejezése';
$string['submission_confirmation_unanswered'] = 'Megváloszolatlan kérdések: {$a}';
$string['submitallandfinish'] = 'Az összes leadása és befejezés';
$string['subneterror'] = 'Sajnos a teszt zárolva van és csak egyes helyekről érhető el. Jelenleg számítógépéről nem használhatja a tesztet.';
$string['subnetnotice'] = 'Ez a teszt le van zárva, így csak egyes helyekről érhető el. Számítógépe nem ilyen alhálózaton van. Tanárként a tesztoldalakat egyébként megtekintheti.';
$string['subplugintype_quiz'] = 'Jelentés';
$string['subplugintype_quiz_plural'] = 'Jelentések';
$string['subplugintype_quizaccess'] = 'Hozzáférési szabály';
$string['subplugintype_quizaccess_plural'] = 'Hozzáférési szabályok';
$string['substitutedby'] = 'helyett';
$string['summaryofattempt'] = 'Próbálkozások összegzése';
$string['summaryofattempts'] = 'Korábbi próbálkozásainak összegzése';
$string['summaryofattemptscaption'] = '{$a} próbálkozás összegzése';
$string['temporaryblocked'] = 'Ideiglenesen nem próbálkozhat újra a teszttel.<br /> Újból próbálkozhat ekkor:';
$string['theattempt'] = 'Próbálkozás';
$string['theattempt_help'] = 'A próbálkozást a tanuló ellenőrizheti?';
$string['time'] = 'Idő';
$string['timecompleted'] = 'Kész';
$string['timedelay'] = 'Nem oldhatja meg a tesztet, mert még nem telt el a következő próbálkozásig előírt időköz';
$string['timeleft'] = 'Hátralévő idő';
$string['timelimit'] = 'Időkorlát';
$string['timelimit_help'] = 'Ha megad egy időkorlátot, az megjelenik a teszt kezdő oldalán, a tesztblokkban pedig láthatóvá válik egy visszaszámláló időmérő-';
$string['timelimit_link'] = 'mod/quiz/timing';
$string['timelimitexeeded'] = 'Sajnos a tesztidőt túllépte!';
$string['timestr'] = '%H:%M:%S %y/%m/%d időpontban';
$string['timesup'] = 'Ideje elfogyott';
$string['timing'] = 'Időmérés';
$string['tofile'] = 'állományba';
$string['tolerance'] = 'Tűrés';
$string['toomanyrandom'] = 'A szükséges véletlenszerű kérdések száma nagyobb, mint amennyit ez a kategória még tartalmaz! ({$a})';
$string['top'] = 'Fent';
$string['totalmarks'] = 'Pontok összege';
$string['totalmarksx'] = 'Pontok összege: {$a}.';
$string['totalquestionsinrandomqcategory'] = 'A kategória összes {$a} kérdése.';
$string['true'] = 'Igaz';
$string['truefalse'] = 'Igaz-hamis';
$string['type'] = 'Típus';
$string['unfinished'] = 'nyitva';
$string['ungraded'] = 'Nincs értékelve';
$string['unit'] = 'Egység';
$string['unknowntype'] = 'A kérdéstípust {$a} sornál a rendszer nem támogatja. A kérdést figyelmen kívül hagyja';
$string['updatefilterconditon'] = 'Szűrési feltételek frissítése';
$string['updatefilterconditon_success'] = 'A szűrőfeltéltételek frissítése sikereses volt';
$string['updateoverdueattemptstask'] = 'Határidőn túli tesztpróbálkozások frissítése';
$string['updatequizslotswithrandomxofy'] = 'Teszt frissítése ({$a->done}/{$a->total}) "véletlenszerű" kérdéssel';
$string['updatesettings'] = 'Tesztbeállítások frissítése';
$string['updatingatttemptgrades'] = 'A próbálkozásra adott értékelések frissítése';
$string['updatingfinalgrades'] = 'Végleges értékelések frissítése';
$string['updatingthegradebook'] = 'Értékelésnapló frissítése';
$string['upgradesure'] = '<div>A tesztmodul számottevően átalakítja a teszttáblázatokat, ez a frissítés pedig még nincs kellőképpen leellenőrizve. Továbblépés előtt mindenképpen készítsen biztonsági mentést adatbázisa táblázatairól.</div>';
$string['upgradingquizattempts'] = 'Tesztpróbálkozások frissítése: {$a->done}/{$a->outof} tesztből (tesztazonosító {$a->info})';
$string['upgradingveryoldquizattempts'] = 'Nagyon régi testpróbálkozások frissítése: {$a->done}/{$a->outof}';
$string['url'] = 'URL';
$string['usedcategorymoved'] = 'Ez a kategória portálszintre lett áthelyezve, mert közzétett kategória, melyet egyéb kurzusok továbbra is használnak.';
$string['useroverrides'] = 'Felhasználó felülírásai';
$string['useroverridesdeleted'] = 'A felhasználó-fölülírások törölve';
$string['usersnone'] = 'A tesztet egy tanuló sem éri el';
$string['validate'] = 'Érvényesít';
$string['viewallanswers'] = '{$a} tesztpróbálkozás megtekintése';
$string['viewallreports'] = '{$a} próbálkozás jelentéseinek megtekintése';
$string['viewed'] = 'Megtekintette';
$string['warningmissingtype'] = 'Ez olyan kérdésfajta, amely a Moodle-rendszerében még nincs telepítve. Figyelmeztesse a Moodle rendszergazdáját.';
$string['wheregrade'] = 'Hol van az értékelésem?';
$string['wildcard'] = 'Helyettesítő';
$string['windowclosing'] = 'Az ablak rövidesen bezáródik.';
$string['withsummary'] = 'összegző statisztikával';
$string['wronguse'] = 'Így ezt az oldalt nem használhatja';
$string['xhtml'] = 'XHTML';
$string['youneedtoenrol'] = 'A teszt megoldásához be kell iratkoznia a kurzusba.';
$string['yourfinalgradeis'] = 'Végső értékelése erre a tesztre {$a}';
