<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'aiprovider_ollama', language 'ja', version '5.0'.
 *
 * @package     aiprovider_ollama
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['action:explain_text:model'] = 'テキスト説明モデル';
$string['action:explain_text:model_help'] = '提供されたテキストを説明するために使用されるモデルです。';
$string['action:explain_text:systeminstruction'] = 'システムインストラクション';
$string['action:explain_text:systeminstruction_help'] = 'このインストラクションはユーザのプロンプトとともにAIモデルに送信されます。どうしても必要な場合を除き、このインストラクションの編集は推奨されません。';
$string['action:generate_text:model'] = 'テキスト生成モデル';
$string['action:generate_text:model_help'] = 'テキストレスポンスの生成に使用されるモデルです。';
$string['action:generate_text:systeminstruction'] = 'システムインストラクション';
$string['action:generate_text:systeminstruction_help'] = 'このインストラクションはユーザのプロンプトとともにAIモデルに送信されます。どうしても必要な場合を除き、このインストラクションの編集は推奨されません。';
$string['action:summarise_text:model'] = 'テキスト要約モデル';
$string['action:summarise_text:model_help'] = '提供されたテキストを要約するために使用されるモデルです。';
$string['action:summarise_text:systeminstruction'] = 'システムインストラクション';
$string['action:summarise_text:systeminstruction_help'] = 'このインストラクションはユーザのプロンプトとともにAIモデルに送信されます。どうしても必要な場合を除き、このインストラクションの編集は推奨されません。';
$string['custom_model_name'] = 'カスタムモデル名';
$string['enablebasicauth'] = '基本認証を有効にする';
$string['enablebasicauth_help'] = 'Ollama API プロバイダの基本認証を有効にします。';
$string['endpoint'] = 'APIエンドポイント';
$string['endpoint_help'] = 'Ollama APIサーバのAPIエンドポイントです。';
$string['extraparams'] = '追加パラメータ';
$string['extraparams_help'] = '追加パラメータはここで設定できます。私たちはJSON形式をサポートしています。例えば次のようになります:
<pre>
{
    "temperature": 0.5,
    "max_tokens": 100
}
</pre>';
$string['invalidjson'] = '無効なJSONストリングです。';
$string['password'] = 'パスワード';
$string['password_help'] = '基本認証に使用されるパスワードです。';
$string['pluginname'] = 'Ollama APIプロバイダ';
$string['privacy:metadata'] = 'Ollama APIプロバイダはいかなる個人データも保存しません。';
$string['privacy:metadata:aiprovider_ollama:externalpurpose'] = 'この情報はレスポンスを生成するためにOllama APIに送信されます。あなたのOllamaアカウント設定でOllamaがこのデータをどのように保存および保持するか変更される場合があります。このプラグインでユーザデータが明示的にOllamaに送信されたり、Moodle LMSに保存されることはありません。';
$string['privacy:metadata:aiprovider_ollama:model'] = 'レスポンスの生成に使用されるモデルです。';
$string['privacy:metadata:aiprovider_ollama:prompttext'] = 'レスポンスの生成に使用されるユーザ入力テキストプロンプトです。';
$string['settings'] = '設定';
$string['settings_help'] = 'Ollamaへのリクエスト送信方法をカスタマイズするには以下の設定を調整してください。';
$string['settings_mirostat'] = 'ミロスタット';
$string['settings_mirostat_help'] = 'ミロスタットは当惑度を制御するためのニューラルテキスト解読アルゴリズムです。0=無効, 1=ミロスタット, 2=ミロスタット2.0。(デフォルト: 0)';
$string['settings_seed'] = 'シード';
$string['settings_seed_help'] = '生成に使用する乱数シードを設定します。これを特定の数値に設定した場合、同じプロンプトに対して同じテキストを生成するようになります (デフォルト: 0)。';
$string['settings_temperature'] = '温度';
$string['settings_temperature_help'] = '温度は出力がよりランダムで創造的なものになるか、より予測可能なものになるかに影響します。温度を上げた場合、モデルはより創造的に回答します。(デフォルト: 0.8)';
$string['settings_top_k'] = 'top_k';
$string['settings_top_k_help'] = '無意味なものを生成する確率を減らします。高い値 (例: 100) はより多様な回答を与えます。低い値 (例: 10) はより保守的になります (デフォルト: 40)。';
$string['settings_top_p'] = 'top_p';
$string['settings_top_p_help'] = 'top-kと併用します。高い値 (例: 0.95) はより多様なテキストを生成します。低い値 (例: 0.5) はより焦点を絞った保守的なテキストを生成します (デフォルト: 0.9)。';
$string['username'] = 'ユーザ名';
$string['username_help'] = '基本認証に使用されるユーザ名です。';
