<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'moodle', language 'hu', version '5.0'.
 *
 * @package     moodle
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['abouttobeinstalled'] = 'telepítésre vár';
$string['accept'] = 'Elfogadás';
$string['action'] = 'Művelet';
$string['actionchoice'] = 'Mit kíván tenni ezzel az állománnyal: \'{$a}\'?';
$string['actions'] = 'Műveletek';
$string['actionsfor'] = '{$a} lépései';
$string['actionsmenu'] = 'Lépések menüje';
$string['active'] = 'Aktív';
$string['activeusers'] = 'Aktív felhasználók';
$string['activities'] = 'Tevékenységek';
$string['activities_help'] = 'Például fórumok, tesztek és wikik segítségével interaktív tartalommal bővítheti a kurzust.';
$string['activity'] = 'Tevékenység';
$string['activityclipboard'] = 'A következő tevékenység áthelyezése: {$a}';
$string['activityheader'] = 'Tevékenység menü';
$string['activityicon'] = '{$a} ikon';
$string['activityiscurrentlyhidden'] = 'Ez a tevékenység jelenleg rejtett';
$string['activitymodule'] = 'Tevékenységmodul';
$string['activitymodules'] = 'Tevékenységmodulok';
$string['activitynotready'] = 'A tevékenység még nincs kész';
$string['activityorresource'] = 'Tevékenység vagy tananyag';
$string['activityreport'] = 'Tevékenységhez kapcsolódó jelentés';
$string['activityreports'] = 'Tevékenységhez kapcsolódó  jelentések';
$string['activityselect'] = 'A tevékenység kiválasztása áthelyezésre';
$string['activitysince'] = 'Tevékenység {$a} óta';
$string['activitytypetitle'] = '{$a->activity} - {$a->type}';
$string['activityweighted'] = 'Felhasználónkénti aktivitás';
$string['add'] = 'Hozzáadás';
$string['addactivity'] = 'Tevékenység hozzáadása...';
$string['addactivitytosection'] = 'Tevékenység hozzáadása a(z) {$a} szekcióhoz';
$string['addadmin'] = 'Rendszergazda hozzáadása';
$string['addblock'] = 'Blokk hozzáadása';
$string['addcomment'] = 'Megjegyzés hozzáadása...';
$string['addcondition'] = 'Feltétel hozzáadása';
$string['addcontent'] = 'Tartalom hozzáadása';
$string['addcountertousername'] = 'Felhasználó létrehozása szám felhasználónévhez való hozzáadásával';
$string['addcreator'] = 'Kurzuskészítő hozzáadása';
$string['adddots'] = 'Hozzáadás...';
$string['added'] = '{$a} hozzáadva';
$string['addedtogroup'] = '{$a} csoporthoz hozzáadva';
$string['addedtogroupnot'] = '{$a} csoporthoz nem lett hozzáadva';
$string['addedtogroupnotenrolled'] = '"{$a}" csoporthoz nem lett hozzáadva, mert nem vette fel a kurzust';
$string['addfilehere'] = 'Húzza ide a fájlokat, hogy hozzáadja őket a szekció aljára';
$string['addfilesdrop'] = 'A feltöltéshez húzza ide a fájlokat, vagy kattintson a kiválasztáshoz.';
$string['addinganew'] = 'Új {$a} hozzáadása';
$string['addingdatatoexisting'] = 'Adat hozzáadása meglévőhöz';
$string['additionalcustomnav'] = 'Kiegészítő testre szabott navigáció';
$string['additionalnames'] = 'További nevek';
$string['addlinkhere'] = 'Hivatkozás beszúrása ide';
$string['addnew'] = 'Új {$a} hozzáadása';
$string['addnewcategory'] = 'Új kategória hozzáadása';
$string['addnewcourse'] = 'Új kurzus hozzáadása';
$string['addnewuser'] = 'Új felhasználó';
$string['addnousersrecip'] = '{$a}-t nem megtekintők hozzáadása a címzettekhez';
$string['addpagehere'] = 'Szöveg beszúrása ide';
$string['addresource'] = 'Tananyag hozzáadása...';
$string['addresourceoractivity'] = 'Tevékenység vagy tananyag beszúrása';
$string['addresourcetosection'] = 'Tananyag hozzáadása a(z) \'{$a}\' szekcióhoz';
$string['address'] = 'Cím';
$string['addsections'] = 'Szekciók hozzáadása';
$string['addstudent'] = 'Hallgató hozzáadása';
$string['addsubcategory'] = 'Alkategória hozzáadása';
$string['addteacher'] = 'Oktató hozzáadása';
$string['admin'] = 'Rendszergazda';
$string['adminhelpaddnewuser'] = 'Új felhasználói fiók kézi létrehozása';
$string['adminhelpassignadmins'] = 'A rendszergazdák bármit csinálhatnak és bárhová ellátogathatnak a portálon';
$string['adminhelpassigncreators'] = 'A kurzuskészítők új kurzusokat hozhatnak létre';
$string['adminhelpassignsiteroles'] = 'Meghatározott portálszerepek hozzárendelése adott felhasználókhoz';
$string['adminhelpassignstudents'] = 'Belépés egy kurzusba és tanulók hozzáadása a portálkezelési menüből';
$string['adminhelpauthentication'] = 'Belső felhasználói fiókokat vagy külső adatbázisokat használhat';
$string['adminhelpbackup'] = 'Automatikus biztonsági mentések beállítása és azok ütemezése';
$string['adminhelpconfiguration'] = 'A portál kinézetének és működésének beállítása';
$string['adminhelpconfigvariables'] = 'A portál általános működését befolyásoló változók beállítása';
$string['adminhelpcourses'] = 'Kurzusok és kategóriák meghatározása, személyek ezekhez rendelése, valamint folyamatban lévő kurzusok szerkesztése';
$string['adminhelpeditorsettings'] = 'HTML-szerkesztő alapbeállításainak megadása';
$string['adminhelpedituser'] = 'Felhasználói azonosítók jegyzékének böngészése és bármelyikük szerkesztése';
$string['adminhelpenvironment'] = 'Ellenőrizze, mennyiben felel meg a szervere a jelenlegi és a jövőbeli telepítési követelményeknek';
$string['adminhelpfailurelogs'] = 'Sikertelen belépések naplóinak böngészése';
$string['adminhelplanguage'] = 'A jelenlegi nyelvi csomag ellenőrzéséhez és szerkesztéséhez';
$string['adminhelplogs'] = 'A portál összes tevékenységnaplójának böngészése';
$string['adminhelpmanageblocks'] = 'Telepített blokkok és beállításaik kezelése';
$string['adminhelpmanagedatabase'] = 'Adatbázis közvetlen elérése (csak óvatosan!)';
$string['adminhelpmanagefilters'] = 'Szövegszűrők és kapcsolódó beállítások kiválasztása';
$string['adminhelpmanagemodules'] = 'Telepített modulok és beállításaik kezelése';
$string['adminhelpmanageroles'] = 'Felhasználókhoz hozzárendelhető szerepek létrehozása és meghatározása';
$string['adminhelpmymoodle'] = 'Személyes Moodle-blokkok beállítása felhasználók számára';
$string['adminhelpreports'] = 'Portálszintű jelentések';
$string['adminhelpsitefiles'] = 'Általános állományok közzététele vagy külső biztonsági mentések feltöltése';
$string['adminhelpsitesettings'] = 'A portál kezdőoldalának meghatározása';
$string['adminhelpstickyblocks'] = 'Megmaradó Moodle-szintű blokkok beállítása';
$string['adminhelpthemes'] = 'A portál megjelenésének meghatározása (színek, betűk stb.)';
$string['adminhelpuploadusers'] = 'Új felhasználói azonosítók importálása szöveges állományból';
$string['adminhelpusers'] = 'Felhasználók megadása és hitelesítés beállítása';
$string['adminhelpxmldbeditor'] = 'Interfész XMLDB-állományok szerkesztéséhez. Csak fejlesztők számára.';
$string['administration'] = 'Adminisztráció';
$string['administrationsite'] = 'Portálkezelés';
$string['administrator'] = 'Rendszergazda';
$string['administratordescription'] = 'A rendszergazdák a portálon az összes kurzusban általában bármit tehetnek.';
$string['administrators'] = 'Rendszergazdák';
$string['administratorsall'] = 'Minden rendszergazda';
$string['administratorsandteachers'] = 'Rendszergazdák és tanárok';
$string['advanced'] = 'Részletes';
$string['advancedfilter'] = 'Részletes keresés';
$string['advancedsettings'] = 'Részletes beállítások';
$string['afterresource'] = '"{$a}" tananyag után';
$string['aftersection'] = '"{$a}" szakasz után';
$string['again'] = 'ismét';
$string['agelocationverification'] = 'Életkor és hely ellenőrzése';
$string['ajaxuse'] = 'AJAX és javascript';
$string['all'] = 'Mind';
$string['allactions'] = 'Minden művelet';
$string['allactivities'] = 'Minden tevékenység';
$string['allcategories'] = 'Minden kategória';
$string['allchanges'] = 'Minden módosítás';
$string['alldays'] = 'Minden nap';
$string['allfiles'] = 'Minden állomány';
$string['allgroups'] = 'Minden csoport';
$string['alllogs'] = 'Minden naplóbejegyzés';
$string['allmods'] = 'Minden {$a}';
$string['allow'] = 'Engedélyez';
$string['allowinternal'] = 'Belső metódusok is engedélyezve';
$string['allownone'] = 'Egyet sem engedélyez';
$string['allownot'] = 'Nem engedélyez';
$string['allowstealthmodules'] = 'Rejtett tevékenységek engedélyezése';
$string['allowstealthmodules_help'] = 'Bekapcsolása esetén a tevékenységek elérhetővé tehetők, de nem jelennek meg a kurzusoldal látható részein. Ilyen esetben a rejtett tevékenységhez hivatkozást kell létrehozni valamely egyéb helyről, például az oldal kódjából. A rejtett tevékenységek ettől függetlenül bekerülnek az értékelésnaplóba és más jelentésekbe.';
$string['allparticipants'] = 'Összes résztvevő';
$string['allteachers'] = 'Minden tanár';
$string['alphanumerical'] = 'Csak alfanumerikus karaktereket, kötőjelet (-) vagy pontot (.) tartalmazhat';
$string['alreadyconfirmed'] = 'A regisztrációt már visszaigazolták';
$string['alternatename'] = 'Másik név';
$string['always'] = 'Mindig';
$string['and'] = '{$a->one} és {$a->two}';
$string['answer'] = 'Válasz';
$string['any'] = 'Bármelyik';
$string['appearance'] = 'Megjelenés';
$string['apply'] = 'Alkalmaz';
$string['applyfilters'] = 'Szűrők alkalmazása';
$string['approve'] = 'Jóváhagy';
$string['areyousure'] = 'Biztos?';
$string['areyousuretorestorethis'] = 'Kívánja folytatni?';
$string['areyousuretorestorethisinfo'] = 'Később ezt a biztonsági mentést hozzáadhatja egy meglévő kurzushoz, vagy pedig létrehozhat egy teljesen új kurzust.';
$string['asc'] = 'Növekvő';
$string['assessment'] = 'Értékelés';
$string['assignadmins'] = 'Rendszergazdák hozzárendelése';
$string['assigncreators'] = 'Kurzuskészítők hozzárendelése';
$string['assignedrolecount'] = '{$a->role}: {$a->count}';
$string['assignsiteroles'] = 'Egész portálra érvényes szerepek hozzárendelése';
$string['authenticateduser'] = 'Hitelesített felhasználó';
$string['authenticateduserdescription'] = 'Minden belépett felhasználó.';
$string['authentication'] = 'Hitelesítés';
$string['authenticationplugins'] = 'Hitelesítési segédprogramok';
$string['autosubscribe'] = 'Automatikus feliratkozás a fórumra';
$string['autosubscribeno'] = 'Nem: nem iratkozom fel automatikusan a fórumvitákra';
$string['autosubscribeyes'] = 'Igen: ha hozzászólok, írjon fel arra a fórumvitára';
$string['availability'] = 'Elérhetőség';
$string['availablecourses'] = 'Felvehető kurzusok';
$string['back'] = 'Vissza';
$string['backto'] = 'Vissza ide: {$a}';
$string['backtocourselisting'] = 'Vissza a kurzuslistához';
$string['backtohome'] = 'Vissza a kezdőoldalra';
$string['backtopageyouwereon'] = 'Vissza az előző oldalra';
$string['backup'] = 'Biztonsági mentés';
$string['backupactivehelp'] = 'Adja meg, készüljön-e automatikus biztonsági mentés.';
$string['backupadhocpending'] = 'A kurzusmentési alkalmi feladat függőben';
$string['backupcancelled'] = 'Biztonsági mentés törölve';
$string['backupcoursefileshelp'] = 'Bekapcsolása esetén a kurzus állományai bekerülnek az automatikus biztonsági mentések közé.';
$string['backupdate'] = 'Biztonsági mentés dátuma';
$string['backupdatenew'] = '{$a->TAG} most {$a->year}. {$a->month}, {$a->weekday}, {$a->mday} <br />';
$string['backupdateold'] = '{$a->TAG} {$a->year}. {$a->month} {$a->weekday}, {$a->mday} volt';
$string['backupdaterecordtype'] = '<br />{$a->recordtype} - {$a->recordname}<br />';
$string['backupdetails'] = 'Biztonsági mentés részletei';
$string['backuperrorinvaliddestination'] = 'A biztonsági mentés mappája nem létezik vagy nem írható.';
$string['backupexecuteathelp'] = 'Adja meg, mikor fusson le az automatikus biztonsági mentés.';
$string['backupfailed'] = 'Kurzusai közül néhány mentése nem történt meg.';
$string['backupfilename'] = 'biztonsági mentés';
$string['backupfinished'] = 'A biztonsági mentés sikeresen lezajlott';
$string['backupfromthissite'] = 'A biztonsági mentésre ezen a portálon került sor?';
$string['backupgradebookhistoryhelp'] = 'Bekapcsolása esetén az értékelésnapló előzményei bekerülnek az automatikus biztonsági mentésekbe. Működéséhez szükséges, hogy a szerverbeállításoknál ne legyen kikapcsolva az értékelésnapló előzményei (disablegradehistory) beállítás.';
$string['backupincludemoduleshelp'] = 'Döntse el, hogy a kurzusmodulok - felhasználói adatokkal, vagy azok nélkül - bekerüljenek-e az automatikus biztonsági mentések közé.';
$string['backupincludemoduleuserdatahelp'] = 'Adja meg, szerepeljenek-e a modult használó adatai az automatikus biztonsági mentésekben.';
$string['backupinfo'] = 'Másolat készítése a kurzusról, beleértve minden jelenlegi tartalmat és tevékenységet. A biztonsági mentés segítségével visszaállítható a kurzus.';
$string['backuplogdetailed'] = 'Részletes végrehajtási napló';
$string['backuploglaststatus'] = 'Utolsó végrehajtási napló';
$string['backupmissinguserinfoperms'] = 'Megjegyzés: ez a biztonsági mentés nem tartalmaz felhasználói adatokat. A gyakorlatokkal és a műhelymunkával kapcsolatos tevékenységek kimaradnak a biztonsági mentésből, mivel ezek a modulok nem részei az effajta biztonsági mentésnek.';
$string['backupnext'] = 'Következő biztonsági mentés';
$string['backupnonisowarning'] = 'Figyelem: ez a mentés a Moodle Unicode-ot nem használó (1.6-nál korábbi) verziójával készült. Ha a mentés tartalmaz bármilyen nem ISO-8859-1 szerinti karaktert, az valószínűleg megsérül, ha megpróbálja visszaállítani a Moodle Unicode-ot ismerő verziójában. Nézze meg a(z) <a href="https://docs.moodle.org/en/Backup_FAQ">Backup FAQ</a> oldalt további információért a mentés helyes visszaállításáról.';
$string['backupnotyetrun'] = 'Automatikus biztonsági mentés folyamatban';
$string['backuporiginalname'] = 'Biztonsági mentés neve';
$string['backuproleassignments'] = 'Ezen szerep-hozzárendelések biztonsági mentése';
$string['backupsavetohelp'] = 'A biztonsági mentés állományainak könyvtárához vezető teljes útvonal';
$string['backupsitefileshelp'] = 'Bekapcsolása esetén a kurzusokban használt portálállományokról automatikus biztonsági mentés készül.';
$string['backuptakealook'] = 'Tekintse meg biztonsági naplóit itt: {$a}';
$string['backupuserfileshelp'] = 'Döntse el, hogy a felhasználói állományok (pl. a profilképek) bekerüljenek-e az automatikus biztonsági mentésbe.';
$string['backupversion'] = 'Biztonsági mentés változata';
$string['badges'] = 'Kitűzők';
$string['between'] = 'Között';
$string['block'] = 'Blokk';
$string['blockconfiga'] = '{$a} blokk beállítása';
$string['blockconfigbad'] = 'Ez a blokk nincs megfelelően telepítve, ezért nincs hozzá beállítási interfész.';
$string['blocks'] = 'Blokkok';
$string['blocks_main'] = 'Fő tartalmi blokkok';
$string['blocks_supplementary'] = 'Kiegészítő blokkok';
$string['blocksaddedit'] = 'Blokkok hozzáadása/szerkesztése';
$string['blockseditoff'] = 'Blokkszerkesztés kikapcsolva';
$string['blocksediton'] = 'Blokkszerkesztés bekapcsolva';
$string['blocksetup'] = 'Blokktáblázatok beállítása';
$string['blocksuccess'] = '{$a} táblázatot sikerült megfelelően beállítani';
$string['brief'] = 'Rövid';
$string['bulkactions'] = 'Tömeges intézkedések';
$string['bulkactionselect'] = '{$a} ömlesztett lépés kiválasztása';
$string['bulkcancel'] = 'Tömeges szerkesztés bezárása';
$string['bulkmovecoursessuccess'] = '{$a->courses} kurzus {$a->category} alá sikeresen áthelyezve';
$string['bulkselection'] = '{$a} kiválasztva';
$string['bycourseorder'] = 'A kurzusok sorrendje szerint';
$string['byname'] = '{$a} szerint';
$string['bypassed'] = 'Kihagyva';
$string['cachecontrols'] = 'Vezérlőelemek gyorsítótárba helyezése';
$string['calltofeedback'] = 'A szoftver szerzői a véleményét szeretnék megismerni a szoftverrel kapcsolatosan.';
$string['calltofeedback_give'] = 'Szoftverrel kapcsolatos visszajelzés küldése';
$string['calltofeedback_remind'] = 'Emlékeztessen később';
$string['cancel'] = 'Mégse';
$string['cancelled'] = 'Törölve';
$string['categories'] = 'Kurzuskategóriák';
$string['categoriesandcourses'] = 'Kurzuskategóriák és kurzusok';
$string['category'] = 'Kategória';
$string['categoryadded'] = 'A(z) \'{$a}\' kategória hozzáadva';
$string['categorybulkaction'] = 'Ömlesztett lépések a kiválasztott kategóriákhoz';
$string['categorycontents'] = 'Alkategóriák és kurzusok';
$string['categorycurrentcontents'] = 'A(z) {$a} tartalma';
$string['categorydeleted'] = 'A(z) \'{$a}\' kategória törlése megtörtént';
$string['categoryduplicate'] = '\'{$a}\' nevű kategória már létezik!';
$string['categoryheader'] = 'Kategóriamenü';
$string['categoryhidden'] = '(rejtett)';
$string['categorymodifiedcancel'] = 'A kategória módosult! Törölje és próbálja meg újra.';
$string['categoryname'] = 'Kategória neve';
$string['categorypath'] = 'Kategória útvonala';
$string['categorysubcategoryof'] = '{$a->category} - {$a->parentcategory} alkategóriája';
$string['categoryupdated'] = 'A(z) \'{$a}\' kategória frissítése megtörtént';
$string['changedpassword'] = 'Megváltozott jelszó';
$string['changepassword'] = 'Jelszó módosítása';
$string['changesmade'] = 'Végrehajtott módosítások';
$string['changesmadereallygoaway'] = 'Módosításokat hajtott végre. Biztosan továbblép és nem menti a módosításokat?';
$string['changessaved'] = 'Módosítások elmentve';
$string['check'] = 'Ellenőrzés';
$string['checkactual'] = 'Jelenlegi';
$string['checkall'] = 'Mind ellenőrzése';
$string['checkerror'] = 'Hiba a(z) \'{$a}\' ellenőrzés eredményének lekérdezésekor. Ellenőrizze a böngésző konzolt további részletekért!';
$string['checkexpected'] = 'Elvégzendő';
$string['checkingbackup'] = 'Biztonsági mentés ellenőrzése';
$string['checkingcourse'] = 'Kurzus ellenőrzése';
$string['checkingforbbexport'] = 'BlackBoard exportálásának ellenőrzése';
$string['checkinginstances'] = 'Példányok ellenőrzése';
$string['checkingsections'] = 'Szekciók ellenőrzése';
$string['checklanguage'] = 'Nyelv ellenőrzése';
$string['checkloading'] = 'A(z) \'{$a}\' ellenőrzés eredményének lekérdezése';
$string['checknone'] = 'Egyiket sem ellenőrzi';
$string['checks'] = 'Ellenőrzések';
$string['checksok'] = 'Minden \'{$a}\' ellenőrzés rendben';
$string['childcoursenotfound'] = 'Alkurzus nem található!';
$string['childcourses'] = 'Alkurzusok';
$string['choose'] = 'Választás';
$string['choosecourse'] = 'Válasszon kurzust';
$string['choosedots'] = 'Választás...';
$string['chooselivelogs'] = 'vagy tekintse meg az éppen zajló tevékenységet';
$string['chooselogs'] = 'Válassza ki a megtekintendő naplókat';
$string['choosereportfilter'] = 'Válasszon szűrőt a jelentéshez';
$string['choosetheme'] = 'Válasszon stílust';
$string['chooseuser'] = 'Válasszon felhasználót';
$string['city'] = 'Település';
$string['cleaningtempdata'] = 'Ideiglenes adatok törlése';
$string['clear'] = 'Töröl';
$string['clearall'] = 'Összes törlése';
$string['clearfilterrow'] = 'Szűrősor eltávolítása';
$string['clearfilters'] = 'Szűrők eltávolítása';
$string['clearsearch'] = 'Keresési bemenet törlése';
$string['clickhelpiconformoreinfo'] = '... folytatódik ... A teljes cikk elolvasásához kattintson a súgóikonra.';
$string['clickhere'] = 'Kattintson ide ...';
$string['clicktohideshow'] = 'Kattintson a kibontáshoz vagy a becsukáshoz.';
$string['closeblockdrawer'] = 'Blokkfiók bezárása';
$string['closebuttontitle'] = 'Bezárás';
$string['closecourseindex'] = 'Kurzusmutató  bezárása';
$string['closedrawer'] = 'Fiók bezárása';
$string['closewindow'] = 'Ablak bezárása';
$string['collapse'] = 'Összeejtés';
$string['collapseall'] = 'Az összes becsukása';
$string['collapsecategory'] = '{$a} becsukása';
$string['comebacklater'] = 'Kérem, jöjjön vissza később.';
$string['commentincontext'] = 'A megjegyzés megkeresése környezetében';
$string['comments'] = 'Megjegyzések';
$string['commentscount'] = 'Megjegyzések  ({$a})';
$string['commentsnotenabled'] = 'A Megjegyzések szolgáltatás nincs bekapcsolva';
$string['commentsrequirelogin'] = 'A megjegyzések megtekintéséhez be kell jelentkeznie';
$string['comparelanguage'] = 'Az aktuális nyelv ellenőrzése és szerkesztése';
$string['complete'] = 'Teljes';
$string['completed'] = 'Elkészült';
$string['completereport'] = 'Teljes jelentés';
$string['configuration'] = 'Szerkesztés';
$string['confirm'] = 'Megerősítés';
$string['confirmaccount'] = 'Fiók megerősítése';
$string['confirmcheckfull'] = 'Biztosan megerősíti ezt: {$a}?';
$string['confirmcoursemove'] = 'Biztosan áthelyezi a(z) ({$a->course}) kurzust a(z) ({$a->category}) kategóriába?';
$string['confirmdeletesection'] = 'Biztosan törlendő a(z) "{$a}"? Ezzel a tevékenységek is törlődnek.';
$string['confirmed'] = 'Regisztrációját visszaigazoltuk';
$string['confirmednot'] = 'A regisztráció visszaigazolása még nem történt meg! Nézze meg a levelesládáját!';
$string['considereddigitalminor'] = 'Túl fiatal vagy a portálon fiók létrehozásához.';
$string['contactsbyrolelist'] = '{$a->role}: {$a->contacts}';
$string['content'] = 'Tartalom';
$string['contentbank'] = 'Tartalombank';
$string['contentexport_aboutthiscourse'] = 'Kurzusösszegzés';
$string['contentexport_coursesummary'] = 'Ez az állomány a(z) <a href="{$a->courselink}">{$a->coursename}</a> helyről letöltött tartalom része.';
$string['contentexport_footersummary'] = 'Ez az állomány a(z) <a href="{$a->courselink}">{$a->coursename}</a> helyről {$a->userfullname} által {$a->date} időpontban letöltött tartalom része.';
$string['contentexport_modulesummary'] = 'Ez az állomány a(z) <a href="{$a->modulelink}">{$a->modulename}</a> helyről {$a->date} időpontban letöltött tartalom része. Ne feledje, hogy egyes tartalmak és {$a->maxfilesize} méretűnél nagyobb állományok letöltése elmarad.';
$string['contentexport_viewfilename'] = '{$a} állomány megtekintése';
$string['context'] = 'Kontextus';
$string['contextlevel'] = 'Kontextus szint';
$string['contextname'] = 'Kontextus neve';
$string['contextparent'] = 'Szülő';
$string['contexturl'] = 'Kontextus URL';
$string['continue'] = 'Folytatás';
$string['continuetocourse'] = 'A kurzusba való belépéshez kattintson ide';
$string['convertingwikitomarkdown'] = 'Wiki átalakítása Markdown-formába';
$string['cookiesenabled'] = 'a böngészőjében engedélyeznie kell a sütiket';
$string['cookiesenabled_help'] = 'Ez a portál kétféle sütit használ.

Ezek közül az alapvetően fontos süti az általában MoodleSession néven ismert folyamatrögzítő süti. Ezt a sütit engedélyeznie kell a böngészőben, ha folyamatosan szeretne böngészni. Kilépéskor vagy a böngésző bezárásakor ez a süti megsemmisül (mind a böngészőben, mind a szerveren).

A másik süti kizárólag kényelmi célokat szolgál és rendszerint a MOODLEID vagy ehhez hasonló nevet viseli. Ennek csak annyi a szerepe, hogy emlékezzen a böngészőn belül a felhasználónévre. Ez azt jelenti, hogy ha visszatér erre a weboldalra, a belépési oldalon a felhasználónév már kitöltve jelenik meg. Ha nem kívánja használni, nyugodtan lemondhat róla, ez mindössze azzal jár, hogy minden alkalommal belépéskor újból be kell írnia a nevét.';
$string['cookiesenabled_help_html'] = 'A portál kétféle sütit használ:<br/><br/>

Alapvetően fontos a munkamenethez tartozó MoodleSession elnevezésű süti. A folyamatosság és a bejelentkezés fenntartásához böngészőjében engedélyezze ezt a sütit. Kilépéskor vagy a böngésző bezárásakor a süti (mind a böngészőben, mind a szerveren) törlődik.<br/><br/>

A másik, általában MOODLEID elnevezésű süti kényelmi célokat szolgál: megjegyzi a böngészőben használt felhasználónevét. Vagyis a portálra való visszatérés során a felhasználónév mezője a belépési oldalon kitöltve jelenik meg. A biztonság érdekében célszerű elutasítani a süti használatát, cserében minden belépésnél be kell írnia a felhasználónevét.';
$string['cookiesenabledonlysession'] = 'a böngészőjében engedélyeznie kell a sütiket';
$string['cookiesenabledonlysession_help'] = 'A portál egy általában MoodleSession elnevezésű munkamenet-sütit használ. Böngészőjében engedélyeznie a sütit a folyamatosság és belépésének oldalról oldalra való fenntartása érdekében. Kilépéskor vagy a böngésző bezárásakor a süti (mind a böngészőből, mind a szerverről) törlődik.';
$string['cookiesnotenabled'] = 'Böngészőjében a sütik használata nincs engedélyezve.';
$string['cookiesnotice'] = 'Sütikre vonatkozó tájékoztatás';
$string['copy'] = 'másol';
$string['copyasnoun'] = 'másolat';
$string['copycourse'] = 'Kurzus másolása';
$string['copyingcoursefiles'] = 'Kurzusállományok másolása';
$string['copyingsitefiles'] = 'A kurzusban használt portálállományok másolása';
$string['copyinguserfiles'] = 'Felhasználói állományok másolása';
$string['copyingzipfile'] = 'Tömörített állomány másolása';
$string['copyrightnotice'] = 'Szerzői jogra vonatkozó megjegyzés';
$string['copytoclipboard'] = 'Másolja a vágólapra';
$string['coresystem'] = 'alaprendszer';
$string['cost'] = 'Költség';
$string['costdefault'] = 'Alapköltség';
$string['count_of_total'] = '<strong>{$a->count}</strong>, összesen {$a->total}';
$string['counteditems'] = '{$a->count} {$a->items}';
$string['country'] = 'Ország';
$string['course'] = 'Kurzus';
$string['courseadministration'] = 'Kurzus kezelése';
$string['courseapprovedemail'] = 'Kért <a href="{$a->url}">{$a->name}</a> kurzusát jóváhagyták, Ön pedig {$a->teacher} lett.';
$string['courseapprovedemail2'] = 'Kért <a href="{$a->url}">{$a->name}</a> kurzusát jóváhagyták.';
$string['courseapprovedfailed'] = 'A kurzust mint jóváhagyottat nem sikerült elmenteni!';
$string['courseapprovedsubject'] = 'Kurzusát jóváhagyták.';
$string['courseavailable'] = 'A kurzus tanulók számára elérhető';
$string['courseavailablenot'] = 'A kurzus tanulók számára nem elérhető';
$string['coursebackup'] = 'Kurzus biztonsági mentése';
$string['coursebulkaction'] = 'Ömlesztett lépések a kiválasztott kurzusokhoz';
$string['coursecategories'] = 'Kurzuskategóriák';
$string['coursecategory'] = 'Kurzuskategória';
$string['coursecategory_help'] = '<p>A Moodle-rendszergazda néhány kurzuskategóriát előre elkészíthet.</p>

<p>Például létrehozhat "Természettudományok", "Bölcsészettudományok", "Egészségügy" stb. elnevezésű kategóriákat.</p>

<p>Válassza ki a kurzusának leginkább megfelelőt. Ez a választás határozza majd meg, hogy a
kurzuslistán hol jelenik meg a kurzus. Emellett megkönnyítheti a tanulók számára a kurzus megtalálását. </p>';
$string['coursecategorydeleted'] = 'A(z) {$a} kurzuskategória törölve';
$string['coursecatmanagement'] = 'Kurzusok és kategóriák kezelése';
$string['coursecompletion'] = 'Kurzus teljesítése';
$string['coursecompletions'] = 'Kurzusteljesítések';
$string['coursecreators'] = 'Kurzuskészítő';
$string['coursecreatorsdescription'] = 'A kurzuskészítők új kurzusokat hozhatnak létre.';
$string['coursedeleted'] = 'A(z) {$a} kurzus törölve';
$string['coursedetails'] = 'Kurzusadatok';
$string['coursedisplay'] = 'Kurzus elrendezése';
$string['coursedisplay_help'] = 'A kurzus szekciói mind egy oldalon jeleníthetők meg, vagy több oldalra oszthatók.';
$string['coursedisplay_multi'] = 'Oldalanként egy szekció megjelenítése';
$string['coursedisplay_single'] = 'Az összes szekció megjelenítése egy oldalon';
$string['courseduration'] = 'Kurzus időtartama';
$string['courseduration_desc'] = 'A kurzus időtartama a kurzus befejezésének kiszámításához használatos. A kurzus befejezésének dátuma dönti el, hogy egy kurzus szerepeljen-e egy felhasználó kurzusainak listáján. Egyedi jelentések készítéséhez is felhasználható. A felhasználók a befejezési dátum után is beléphetnek a kurzusba.';
$string['courseenddateenabled'] = 'A kurzus befejezésének dátuma alapesetben bekapcsolva';
$string['courseenddateenabled_desc'] = 'Ez a beállítás határozza meg, hogy a kurzus befejezésének dátuma alapesetben új kurzusok esetén be legyen-e kapcsolva és a kurzus hosszából kiszámított dátumra legyen-e beállítva.';
$string['courseextendednamedisplay'] = '{$a->shortname} {$a->fullname}';
$string['coursefiles'] = 'Korábbi kurzusállományok';
$string['coursefilesedit'] = 'Kurzusállományok szerkesztése';
$string['coursefileswarning'] = 'A Moodle 2.0 óta a kurzusállományok nem használatosak, amennyire lehet, használjon helyettük külső adattárakat.';
$string['coursefileswarning_help'] = 'A Moodle 2.0-tól kezdődően a kurzusállományok elavultnak minősülnek, ha lehet, inkább külső adattárakat használjon.';
$string['courseformatdata'] = 'Kurzusforma adatai';
$string['courseformatoptions'] = 'Formázási lehetőségek {$a} esetén';
$string['courseformats'] = 'Kurzusformák';
$string['courseformatudpate'] = 'Formátum frissítése';
$string['coursegrades'] = 'Kurzus értékelései';
$string['courseheader'] = 'Kurzus menü';
$string['coursehelpcategory'] = 'Helyezze el a kurzust a kurzuslistában, hogy a tanulók könnyebben megtalálhassák.';
$string['coursehelpforce'] = 'A kurzus minden tevékenységéhez kurzuscsoportos mód előírása.';
$string['coursehelpformat'] = 'A kurzus fő oldala ebben a formában jelenik meg.';
$string['coursehelphiddensections'] = 'Hogyan jelennek meg a kurzus rejtett részei a tanulók számára.';
$string['coursehelpmaximumupload'] = 'Adja meg a kurzusba feltölthető maximális fájlméretet az egész portálra érvényes korlátoknak megfelelően.';
$string['coursehelpnewsitemsnumber'] = 'A kurzus honlapján hírdobozban jobbra megjelenő legújabb tételek száma. 0 esetén a hírdoboz meg sem jelenik.';
$string['coursehelpnumberweeks'] = 'A kurzus szekcióinak száma (csak bizonyos kurzusformák esetén)';
$string['coursehelpshowgrades'] = 'Értékelésnapló megjelenítésének engedélyezése. Ettől az egyes tevékenységekben még látszani fognak az értékelések.';
$string['coursehidden'] = 'Ez a kurzus tanulók számára jelenleg nem elérhető';
$string['courseinfo'] = 'Kurzus adatai';
$string['courselegacyfiles'] = 'Kurzusállományok';
$string['courselegacyfiles_help'] = 'A Kurzusállományok területe némi visszamenőleges kompatibilitást biztosít a
Moodle 1.9 és korábbi verziókkal. A területen lévő összes állományt a kurzus minden résztvevője elérheti
(akár hozzájuk kapcsolja, akár nem), és nem deríthető ki, ezeket az állományokat a Moodle éppen hol használja.

Ha ezen a területen kurzusállományokat tárol, különféle titkossági és biztonsági problémának teszi ki magát, emellett
a biztonsági mentésekből és kurzusimportálásokból állományok maradhatnak ki, ha a tartalmat megosztják vagy újból felhasználják. Ezért csak akkor használja ezt a területet, ha biztosan tudja, mit cselekszik.';
$string['courselegacyfiles_link'] = 'coursefiles2';
$string['courselegacyfilesofcourse'] = 'Korábbi kurzusfájlok: {$a}';
$string['coursenotaccessible'] = 'Ez a kurzus nem mindenki számára hozzáférhető';
$string['courseoverview'] = 'Kurzusáttekintés';
$string['courseoverviewfiles'] = 'Kurzuskép';
$string['courseoverviewfiles_help'] = 'A kurzuskép megjelenik a Kurzusaim és az elérhető kurzusok listájában a Kezdőoldalon. Az oldal rendszergazdái engedélyezhetnek további fájltípusokat és több fájl használatát. Ha több fájlt használsz, azok mindegyike megjelenik az elérhető kurzusok listájában a Kezdőoldalon.';
$string['courseoverviewfilesext'] = 'Kurzuskép-állományok kiterjesztései';
$string['courseoverviewfileslimit'] = 'Kurzuskép-állományok korlátja';
$string['courseoverviewgraph'] = 'Kurzusáttekintés grafikonja';
$string['courseprofiles'] = 'Kurzusprofilok';
$string['coursereasonforrejecting'] = 'Indokai a kurzuskérés elutasítására';
$string['coursereasonforrejectingemail'] = 'Ezt a kérelmező e-mailben megkapja';
$string['coursereject'] = 'Kurzuskérés elutasítása';
$string['courserejected'] = 'A kurzus elutasítása megtörtént, a kérelmező értesítést kapott.';
$string['courserejectemail'] = 'Az Ön által kért kurzust elutasítottuk. Ehhez az indoklás a következő: {$a}';
$string['courserejectreason'] = 'Fogalmazza meg a kurzus elutasításának okát (ezt a kérelmező e-mailben megkapja)';
$string['courserejectsubject'] = 'Kurzusát elutasítottuk';
$string['coursereport'] = 'Kurzusjelentés';
$string['coursereports'] = 'Kurzusjelentések';
$string['courserequest'] = 'Kurzuskérés';
$string['courserequestdetails'] = 'A kért kurzus adatai';
$string['courserequestfailed'] = 'Valami miatt kurzuskérését nem sikerült elmenteni';
$string['courserequestintro'] = 'Ezen az űrlapon kérje kurzus létrehozását az Ön számára. Minél több információt adjon meg, hogy a rendszergazda láthassa, miért van szüksége erre a kurzusra.';
$string['courserequestreason'] = 'A kurzus létrehozásának indokai';
$string['courserequestroleerror'] = 'A beállítás az új kurzusokat létrehozók szerepéről érvénytelen. Tekintse át a <a href="{$a}">felhasználási feltételeket</a>!';
$string['courserequestsuccess'] = 'A kurzuskérelem mentése megtörtént.';
$string['courserequestsupport'] = 'A kérés rendszergazda általi értékelését elősegítő információk';
$string['courserequestwarning'] = 'A kurzust igénylő felhasználó beiratkozása "{$a}" szereppel automatikusan megtörténik.';
$string['courserestore'] = 'Kurzus visszaállítása';
$string['coursereuse'] = 'Kurzus újbóli használata';
$string['coursereusenavigationmenu'] = 'Navigációs menü a kurzus újbóli használathoz';
$string['courses'] = 'Kurzusok';
$string['coursesectionsummaries'] = 'Kurzusszekció összesítése';
$string['coursesectiontitle'] = '{$a->sectionname}: {$a->sectiontitle} | {$a->course}';
$string['coursesectiontitlebulkediting'] = 'Tömeges szerkesztés {$a->sectionname}: {$a->sectiontitle} | {$a->course}';
$string['coursesectiontitleediting'] = 'Szerkeszt {$a->sectionname}: {$a->sectiontitle} | {$a->course}';
$string['coursesettings'] = 'A kurzus alapbeállításai';
$string['coursesmovedout'] = 'Kurzusok a(z) {$a} alól eltávolítva';
$string['coursespending'] = 'Jóváhagyandó kurzusok';
$string['coursestart'] = 'A kurzus kezdete';
$string['coursesummary'] = 'Kurzusösszegzés';
$string['coursesummary_help'] = 'A kurzus rövid leírása. Az itt hozzáadott tartalom kereshető.';
$string['coursetitle'] = 'Kurzus: {$a->course}';
$string['coursetitlebulkediting'] = 'Kurzus tömeges szerkesztése: {$a->course}';
$string['coursetitleediting'] = 'Kurzus szerkesztése: {$a->course}';
$string['courseupdates'] = 'Kurzusfrissítések';
$string['coursevisibility'] = 'Kurzus láthatósága';
$string['coursevisibility_help'] = '* Mutat: A kurzus szerepel a kurzusok listájában, és a diákok hozzáférhetnek hozzá.
* Elrejtés: A hozzáférés csak a tanárok és azon felhasználók számára elérhető, akik képesek látni a rejtett kurzusokat.';
$string['create'] = 'Létrehozás';
$string['createaccount'] = 'Új felhasználói azonosítóm létrehozása';
$string['createcategory'] = 'Kategória létrehozása';
$string['createfolder'] = 'Mappa létrehozása itt: {$a}';
$string['createnew'] = 'Új létrehozása';
$string['createnewcategory'] = 'Új kategória létrehozása';
$string['createnewcourse'] = 'Új kurzus létrehozása';
$string['createnewsubcategory'] = 'Új alkategória létrehozása';
$string['createsubcategoryof'] = '{$a} alkategóriájának létrehozása';
$string['createuser'] = 'Felhasználó létrehozása';
$string['createziparchive'] = 'Tömörített archívum létrehozása';
$string['creatingblocks'] = 'Blokkok létrehozása';
$string['creatingblocksroles'] = 'Blokkszintű szerepkijelölések és -felülírások';
$string['creatingblogsinfo'] = 'Bloginformációk létrehozása';
$string['creatingcategoriesandquestions'] = 'Kategóriák és kérdések létrehozása';
$string['creatingcoursemodules'] = 'Kurzusmodulok létrehozása';
$string['creatingcourseroles'] = 'Blokkszintű szerepkijelölések és -felülírások létrehozása';
$string['creatingevents'] = 'Események létrehozása';
$string['creatinggradebook'] = 'Értékelésnapló létrehozása';
$string['creatinggroupings'] = 'Csoportosítások létrehozása';
$string['creatinggroupingsgroups'] = 'Csoportok hozzáadása csoportosításokhoz';
$string['creatinggroups'] = 'Csoportok létrehozása';
$string['creatinglogentries'] = 'Naplóbejegyzések létrehozása';
$string['creatingmessagesinfo'] = 'Üzenetekről szóló információ létrehozása';
$string['creatingmodroles'] = 'Modulszintű szerepkijelölések és -felülírások létrehozása';
$string['creatingnewcourse'] = 'Új kurzus létrehozása';
$string['creatingrolesdefinitions'] = 'Szerep-meghatározások létrehozása';
$string['creatingscales'] = 'Skálák létrehozása';
$string['creatingsections'] = 'Szekciók létrehozása';
$string['creatingtemporarystructures'] = 'Ideiglenes struktúrák létrehozása';
$string['creatinguserroles'] = 'Felhasználói szintű szerepkijelölések és -felülírások létrehozása';
$string['creatingusers'] = 'Felhasználók létrehozása';
$string['creatingxmlfile'] = 'XML-állomány létrehozása';
$string['currency'] = 'Pénznem';
$string['currentcourse'] = 'Ez a kurzus';
$string['currentcourseadding'] = 'Adott kurzus: adatok hozzáadása';
$string['currentcoursedeleting'] = 'Először az adott kurzus törlése';
$string['currentlanguage'] = 'Aktuális nyelv';
$string['currentlocaltime'] = 'az aktuális helyi idő';
$string['currentpicture'] = 'Aktuális kép';
$string['currentrelease'] = 'Aktuális változatra vonatkozó információk';
$string['currenttheme'] = 'Jelenlegi stílus';
$string['currentversion'] = 'Aktuális változat';
$string['databasechecking'] = 'A Moodle-adatbázis frissítése {$a->oldversion} verzióról {$a->newversion} verzióra';
$string['databaseperformance'] = 'Adatbázis teljesítménye';
$string['databasesetup'] = 'Adatbázis létrehozása';
$string['databasesuccess'] = 'Az adatbázis átalakítása sikerült';
$string['databaseupgradebackups'] = 'A biztonsági mentés verziószáma most: {$a}';
$string['databaseupgradeblocks'] = 'A blokkok verziószáma most: {$a}';
$string['databaseupgradegroups'] = 'A jelenlegi csoportverzió most: {$a}';
$string['databaseupgradelocal'] = 'A helyi adatbázis beállítási változata most: {$a}';
$string['databaseupgrades'] = 'Az adatbázis átalakítása';
$string['dataformats'] = 'Adatformátumok';
$string['date'] = 'Dátum';
$string['datechanged'] = 'Módosítás dátuma';
$string['datemostrecentfirst'] = 'Dátum - a legutóbbival kezdve';
$string['datemostrecentlast'] = 'Dátum - a legutóbbival a végén';
$string['datetimefilterafter'] = '{$a->title} után';
$string['datetimefilterbefore'] = '{$a->title} előtt';
$string['day'] = 'nap';
$string['days'] = 'nap';
$string['decodinginternallinks'] = 'Belső kapcsolatok feloldása';
$string['default'] = 'Alapbeállítás';
$string['defaultcategoryname'] = '1. kategória';
$string['defaultcompetencescale'] = 'Készség alapskálája';
$string['defaultcompetencescaledesc'] = 'Bináris értékelő skála, mely csak annyit közöl, valaki rendelkezik-e a bemutatott jártassággal, vagy sem.';
$string['defaultcompetencescalenotproficient'] = 'Még nem jártas';
$string['defaultcompetencescaleproficient'] = 'Jártas';
$string['defaultcoursestudent'] = 'Hallgató';
$string['defaultcoursestudentdescription'] = 'A tanulók egy kurzuson belül általában kevesebb jogosultsággal rendelkeznek.';
$string['defaultcoursestudents'] = 'Tanulók';
$string['defaultcoursesummary'] = 'Írjon tömör és figyelemfelkeltő bekezdést a kurzus tartalmáról';
$string['defaultcourseteacher'] = 'Tanár';
$string['defaultcourseteacherdescription'] = 'A tanárok egy kurzuson belül bármit megtehetnek, beleértve a tevékenységek módosítását és a tanulók értékelését.';
$string['defaultcourseteachers'] = 'Tanárok';
$string['defaulteditor'] = 'Alapbeállítás szerinti szerkesztő';
$string['defaulthomepageuser'] = 'Kezdőoldal';
$string['defaulthomepageuser_help'] = 'Melyik oldalra történjen az átirányítás az oldalra való bejelentkezés után?';
$string['delete'] = 'Törlés';
$string['deleteablock'] = 'Blokk törlése';
$string['deleteall'] = 'Az összes törlése';
$string['deleteallcannotundo'] = 'Az összes törlése - visszaállítás nem lehetséges';
$string['deleteallcomments'] = 'Az összes megjegyzés';
$string['deleteallratings'] = 'Az összes értékelés';
$string['deletecategory'] = 'Kategória törlése: {$a}';
$string['deletecategorycheck'] = 'Teljesen biztos abban, hogy az egész \'{$a}\' kategóriát törölni kívánja? Ezzel minden kurzus a felette lévő kategóriába, ha ilyen nincs, az Egyéb kategóriába kerül.';
$string['deletecategorycheck2'] = 'Ha törli ezt a kategóriát, el kell döntenie, mi legyen a benne lévő kurzusokkal és alkategóriákkal.';
$string['deletecategoryempty'] = 'A kategória üres.';
$string['deletecheck'] = 'A(z) {$a} törlendő?';
$string['deletecheckfiles'] = 'Biztosan törölni szeretné ezeket az állományokat?';
$string['deletecheckfull'] = 'Biztosan törli {$a} felhasználót, az olyan adataival együtt, mint a profiladatok, beiratkozások, csoport és globális csoport tagságok és bizonyos tevékenységi adatok?';
$string['deletechecktype'] = 'Biztosan törlendő: {$a->type}?';
$string['deletechecktypename'] = 'Biztosan törlendő: "{$a->name}" (típusa: {$a->type})?';
$string['deletecheckwarning'] = 'Törölni fogja ezeket az állományokat';
$string['deletecommentbyon'] = '{$a->user} által {$a->time} időpontban beküldött megjegyzés törlése';
$string['deletecompletely'] = 'Teljes törlés';
$string['deletecourse'] = 'Kurzus törlése';
$string['deletecoursecheck'] = 'Biztosan törölni akarja ezt a kurzust adataival együtt?';
$string['deleted'] = 'Törölve';
$string['deletedactivity'] = '{$a} törölve';
$string['deletedcourse'] = '{$a} teljesen törölve';
$string['deletednot'] = '{$a} nem törölhető.';
$string['deletepicture'] = 'Törlés';
$string['deletesection'] = 'Törlés';
$string['deleteselected'] = 'A kiválasztott törlése';
$string['deleteselectedkey'] = 'A kiválasztott kulcs törlése';
$string['deletingcourse'] = 'A(z) {$a} törlése';
$string['deletingexistingcoursedata'] = 'Meglévő kurzusadatok törlése';
$string['deletingolddata'] = 'Korábbi adatok törlése';
$string['department'] = 'Szervezeti egység';
$string['deprecatedeventname'] = '{$a} (már nem használatos)';
$string['desc'] = 'Csökkenő';
$string['description'] = 'Leírás';
$string['deselectall'] = 'Kijelölések megszüntetése';
$string['deselectnos'] = 'Összes \'Nem\' kijelölésének törlése';
$string['detailedless'] = 'Kevésbé részletes';
$string['detailedmore'] = 'Részletesebb';
$string['details'] = 'Részletek';
$string['digitalminor'] = 'Digitálisan kiskorú';
$string['digitalminor_desc'] = 'Fiók létrehozásához szülőd/gondviselőd lépjen kapcsolatba az alábbi személlyel:';
$string['directory'] = 'Könyvtár';
$string['disable'] = 'Kikapcsolás';
$string['disabledcomments'] = 'Megjegyzések kikapcsolva';
$string['dismissnotification'] = 'Értesítés mellőzése';
$string['displayingfirst'] = 'Csak az első {$a->count} {$a->things} jelenik meg';
$string['displayingrecords'] = '{$a} rekord megjelenítése';
$string['displayingusers'] = 'Felhasználók megjelenítése {$a->start} és {$a->end} között';
$string['displayonpage'] = 'Megjelenítés az oldalon';
$string['dndcourse'] = 'Elhúzással módosíthatja a kurzus rendezését, vagy áthelyezheti egy másik kategóriába,';
$string['dndenabled_inbox'] = 'Hozzáadáshoz húzza ide az állományokat.';
$string['dndnotsupported'] = 'A húzáson alapuló feltöltést a rendszer nem támogatja.';
$string['dndnotsupported_help'] = 'A húzáson alapuló feltöltést a böngésző nem támogatja. A húzás a Chrome, a Firefox és a Safari újabb változataiban, valamint az Internet Explorer 10-es verziójától érhető el.';
$string['dndnotsupported_insentence'] = 'A húzáson alapuló feltöltést a rendszer nem támogatja.';
$string['dnduploadwithoutcontent'] = 'A feltöltésben nincs tartalom';
$string['dndworkingfile'] = 'Feltöltéshez húzza az állományokat a kurzusszakaszokra';
$string['dndworkingfilelink'] = 'Feltöltéshez húzza az állományokat vagy a hivatkozásokat a kurzusszakaszokra';
$string['dndworkingfiletext'] = 'Feltöltéshez húzza az állományokat vagy a szöveget a kurzusszakaszokra';
$string['dndworkingfiletextlink'] = 'Feltöltéshez húzza az állományokat, a szöveget vagy a hivatkozásokat a kurzusszakaszokra';
$string['dndworkinglink'] = 'Feltöltéshez húzza a hivatkozásokat a kurzusszakaszokra';
$string['dndworkingtext'] = 'Feltöltéshez húzza a szöveget a kurzusszakaszokra';
$string['dndworkingtextlink'] = 'Feltöltéshez húzza a szöveget vagy a hivatkozásokat a kurzusszakaszokra';
$string['documentation'] = 'A Moodle dokumentációja';
$string['dontsortcategories'] = 'Kategóriarendezés mellőzése';
$string['dontsortcourses'] = 'Kurzusrendezés mellőzése';
$string['down'] = 'Le';
$string['download'] = 'Letöltés';
$string['downloadall'] = 'Az összes letöltése';
$string['downloadexcel'] = 'Letöltés Excel-formátumban';
$string['downloadfile'] = 'Állomány letöltése';
$string['downloadods'] = 'Letöltés ODS-formátumban';
$string['downloadtext'] = 'Letöltés szövegként';
$string['doyouagree'] = 'Az olvasott feltételekkel egyetért?';
$string['droptoupload'] = 'Ide dobja a feltöltendő állományokat.';
$string['duplicate'] = 'Másodpéldány';
$string['duplicatedmodule'] = '{$a} (másolat)';
$string['duplicatedsection'] = '{$a} (másolat)';
$string['edhelpaspellpath'] = 'A szerkesztőn belüli helyesírás-ellenőrzéshez aspell 0.50 vagy későbbi verzióval KELL a szerveren rendelkezni, és meg kell adni az aspell programhoz vezető útvonalat. Unix-/Linux-rendszereken ez általában /usr/bin/aspell, de lehet egyéb.';
$string['edhelpbgcolor'] = 'Szerkesztési terület háttérszínének megadása. Érvényes érték pl.: #ffffff vagy white';
$string['edhelpcleanword'] = 'Ezzel kapcsolható ki vagy be a Word speciális formázásának a szűrése.';
$string['edhelpenablespelling'] = 'Helyesírás-ellenőrzés ki-/bekapcsolása. A második érték az <strong>alapszótár</strong>. A rendszer ezt az értéket használja, ha az aspell nem rendelkezik a felhasználó nyelve szerinti szótárral.';
$string['edhelpfontfamily'] = 'A font-family tulajdonsággal betűkészletcsaládok nevei és/vagy általános betűcsaládnevek adhatók meg. A neveket vesszővel kell egymástól elválasztani.';
$string['edhelpfontlist'] = 'A szerkesztők lenyíló menüjén megjelenő betűkészletek megadása.';
$string['edhelpfontsize'] = 'Az alapmérettel adható meg a betűkészlet mérete. Érvényes érték pl.: medium, large, smaller, larger, 10pt, 11px.';
$string['edit'] = 'Szerkesztés';
$string['edita'] = 'Szerkesztés';
$string['editcategorysettings'] = 'Kategória-beállítások szerkesztése';
$string['editcategorythis'] = 'Ezen kategória szerkesztése';
$string['editcoursesettings'] = 'Kurzusbeállítások szerkesztése';
$string['editfiles'] = 'Állományok szerkesztése';
$string['editgroupprofile'] = 'Csoportleírás szerkesztése';
$string['editingteachershort'] = 'Szerkesztő';
$string['editlock'] = 'Ez az érték nem szerkeszthető!';
$string['editmode'] = 'Szerkesztési üzemmód';
$string['editmyprofile'] = 'Profil szerkesztése';
$string['editorbgcolor'] = 'Háttérszín';
$string['editorcleanonpaste'] = 'A beillesztésre kerülő Word-dokumentum formázásainak eltávolítása';
$string['editorcommonsettings'] = 'Általános beállítások';
$string['editordefaultfont'] = 'Alapértelmezett betűkészlet';
$string['editorenablespelling'] = 'Helyesírás-ellenőrzés bekapcsolása';
$string['editorfontlist'] = 'Betűtípusok felsorolása';
$string['editorfontsize'] = 'Alapértelmezett betűméret';
$string['editorpreferences'] = 'Szerkesztő beállításai';
$string['editorresettodefaults'] = 'Alapértékek visszaállítása';
$string['editorsettings'] = 'A szerkesztő beállításai';
$string['editorshortcutkeys'] = 'A szerkesztő gyorsbillentyűi';
$string['editsection'] = 'Beállítások szerkesztése';
$string['editsectionname'] = 'Szekció címének szerkesztése';
$string['editsectionsettings'] = 'Szekcióbeállítások szerkesztése';
$string['editsectiontitle'] = '{$a} szekció szerkesztése';
$string['editsettings'] = 'Beállítások szerkesztése';
$string['editthisactivity'] = 'Tevékenység szerkesztése';
$string['editthiscategory'] = 'Kategória szerkesztése';
$string['edittitle'] = 'Cím szerkesztése';
$string['edittitleinstructions'] = 'Mégse: Esc, kész: Enter';
$string['edituser'] = 'Felhasználói fiókok szerkesztése';
$string['edulevel'] = 'Minden esemény';
$string['edulevel_help'] = '* Oktatás - tanár műveletei, pl. tananyag frissítése
* Részvétel - tanuló műveletei, pl. üzenetküldés egy fórum számára
* Egyéb - egyéb műveleteket, melyet nem tanár vagy tanuló felhasználó végez';
$string['edulevelother'] = 'Egyéb';
$string['edulevelparticipating'] = 'Részvétel';
$string['edulevelteacher'] = 'Oktatás';
$string['email'] = 'E-mail cím';
$string['emailactive'] = 'E-mail bekapcsolva';
$string['emailagain'] = 'E-mail (ismét)';
$string['emailalreadysent'] = 'Jelszó-visszaállítási e-mail kiküldve. Nézze meg levelesében.';
$string['emailcharset'] = 'E-mail karakterkészlete';
$string['emailconfirm'] = 'Fiókjának megerősítése';
$string['emailconfirmation'] = 'Kedves {$a->firstname}!<br>
<br>
Új fiókot igényeltek a(z) \'{$a->sitename}\' portálon az Ön e-mail címével.<br>
<br>
Új fiókjának megerősítéséhez látogasson el erre a weboldalra:<br>
<br>
{$a->link}<br>
<br>
A legtöbb levelező programokban ez kék hivatkozásként jelenik meg, amelyre csak kattintania kell.<br>
Ha ez nem működik, másolja a címet a böngészőablak tetején lévő címsorba.<br>
<br>
Ha segítségre van szüksége, lépjen kapcsolatba a portál rendszergazdájával:<br>
{$a->admin}';
$string['emailconfirmationresend'] = 'Visszaigazoló e-mail újbóli elküldése';
$string['emailconfirmationsubject'] = '{$a}: fiók megerősítése';
$string['emailconfirmsent'] = 'Egy e-mailt kellett kapnia {$a} címére. A levél a regisztráció kitöltéséhez szükséges egyszerű teendőket tartalmazza. Ha továbbra is nehézségekbe ütközik, lépjen kapcsolatba a portál rendszergazdájával.';
$string['emailconfirmsentfailure'] = 'A visszaigazoló e-mail elküldése nem sikerült';
$string['emailconfirmsentsuccess'] = 'A visszaigazoló e-mail elküldése sikerült';
$string['emaildigest'] = 'Összesített e-mail';
$string['emaildigest_help'] = 'Az egyes fórumok által használt olvasási alapbeállítás

* Ne ömlesztve - fórumüzenetenként egy e-mailt fog kapni.
* Ömlesztve - teljes üzenetek - naponta egy ömlesztett e-mailt fog kapni az összes fórumüzenet tartalmával;
* Ömlesztve - csak a tárgy -
naponta egy ömlesztett e-mailt fog kapni az összes fórumüzenet tárgyával.

Fórumonként más-más beállítást is megadhat.';
$string['emaildigestcomplete'] = 'Teljes (napi e-mail minden hozzászólással)';
$string['emaildigestoff'] = 'Nincs összesítés (a fórum minden hozzászólásáról e-mail)';
$string['emaildigestsubjects'] = 'Témák (napi e-mail csak a témákkal)';
$string['emaildisable'] = 'Ez az e-mail cím ki van kapcsolva.';
$string['emaildisableclick'] = 'Ide kattintva kapcsoljon ki minden erre a címre küldendő e-mailt.';
$string['emaildisplay'] = 'E-mail láthatósága';
$string['emaildisplay_help'] = '* Rejtett – Csak a megfelelő jogosultsággal rendelkező felhasználók, például tanárok láthatják az Ön e-mail címét.
* Mindenki számára látható – A portál minden felhasználója megtekintheti az Ön e-mail címét.
* Látható a kurzus résztvevői számára – Csak azon kurzusok résztvevői láthatják e-mail címét, amelyekre Ön be van iratkozva.';
$string['emaildisplaycourse'] = 'A kurzus résztvevői számára látható';
$string['emaildisplaycoursemembersonly'] = '(Látható a kurzus összes résztvevője számára)';
$string['emaildisplayeveryone'] = '(Mindenki láthatja)';
$string['emaildisplayhide'] = '(Mindenki elől elrejtve, kivéve a megfelelő engedéllyel rendelkező felhasználókat)';
$string['emaildisplayno'] = 'Rejtett';
$string['emaildisplayyes'] = 'Mindenki számára látható';
$string['emailenable'] = 'Ez az e-mail cím be van kapcsolva.';
$string['emailenableclick'] = 'Ide kattintva újból bekapcsolhat minden erre a címre küldendő e-mailt.';
$string['emailexists'] = 'Ez az e-mail cím már regisztrálva van.';
$string['emailexistshintlink'] = 'Elfelejtett felhasználónév vagy jelszó visszakeresése';
$string['emailexistssignuphint'] = 'Lehet, hogy korábban létrehozott egy fiókot?  {$a}';
$string['emailformat'] = 'E-mail formája';
$string['emailmustbereal'] = 'Megjegyzés: az e-mail címnek valódinak kell lennie';
$string['emailnotallowed'] = 'Ezeken a doméneken e-mail-címek nem használhatók ({$a})';
$string['emailnotfound'] = 'Az e-mail cím nem található az adatbázisban';
$string['emailonlyallowed'] = 'Ez az e-mail nem használható. Az engedélyezettek domének: {$a}.';
$string['emailpasswordchangeinfo'] = 'Üdvözöljük, {$a->firstname}!

Valaki (feltehetőleg Ön) egy új jelszó létrehozását igényelte a(z)
\'{$a->sitename}\' portálon lévő \'{$a->username}\' fiókja számára.

Jelszava módosításához látogasson el ide:

{$a->link}.

Általában a levelező programokban ez kék
hivatkozásként jelenik meg, amelyre csak
kattintania kell. Ha ez nem működik, másolja
ki a címet a böngészőablak tetején lévő címsorba.

Ha segítségre van szüksége, forduljon a portál rendszergazdájához:
{$a->admin}';
$string['emailpasswordchangeinfodisabled'] = 'Üdvözöljük, {$a->firstname}!

Valaki (feltehetőleg Ön) egy új jelszó létrehozását igényelte a(z) \'{$a->sitename}\' portálon lévő fiókjához.

Fiókját ezen a portálon kikapcsolták és nem lehet helyreállítani, forduljon a portálon {$a->admin} rendszergazdához.';
$string['emailpasswordchangeinfofail'] = 'Üdvözöljük, {$a->firstname}!

Valaki (feltehetőleg Ön) egy új jelszó létrehozását igényelte a(z) \'{$a->sitename}\' portálon lévő fiókjához.

Jelszavát ezen a portálon nem lehet helyreállítani, forduljon a portálon {$a->admin} rendszergazdához.';
$string['emailpasswordchangeinfosubject'] = '{$a}: jelszómódosítás adatai';
$string['emailpasswordconfirmation'] = 'Üdvözöljük, {$a->firstname}!

Valaki (feltehetőleg Ön) új jelszó létrehozását kérte
a(z) {$a->sitename} portálon lévő azonosítójához.

Ennek megerősítéséhez és a jelszónak az Ön e-mail
címére való elküldéséhez látogasson el erre a weboldalra:

{$a->link}

Általában a levelező programokban ez kék
hivatkozásként jelenik meg, amelyre csak
kattintania kell. Ha ez nem működik, másolja
ki a címet a böngészőablak tetején lévő címsorba.

Ha segítségre van szüksége, lépjen kapcsolatba a portál rendszergazdájával:
{$a->admin}.';
$string['emailpasswordconfirmationsubject'] = '{$a}: jelszómódosítás megerősítése';
$string['emailpasswordconfirmmaybesent'] = 'Ha helyes felhasználónevet vagy címet adott meg, akkor kapnia kellett egy e-mailt.
Benne egyszerű leírást talál ezen jelszómódosítás megerősítésére és végrehajtására vonatkozóan. Ha továbbra is gondja van, forduljon a portál rendszergazdájához.';
$string['emailpasswordconfirmnoemail'] = '<p>A megadott fiókhoz nem tartozik e-mail cím.</p> <p>Forduljon a rendszergazdához.</p>';
$string['emailpasswordconfirmnotsent'] = '<p>A megadott adattal nem azonosítható fiók.</p> <p>Ellenőrizze az adatot ismét, majd próbálja meg újból. Ha továbbra is gondja van, forduljon a rendszergazdához.</p>';
$string['emailpasswordconfirmsent'] = 'Egy e-mailt kellett kapnia {$a} címére. A levél a regisztráció kitöltéséhez szükséges egyszerű teendőket tartalmazza. Ha továbbra is nehézségekbe ütközik, lépjen kapcsolatba a portál rendszergazdájával.';
$string['emailresetconfirmation'] = 'Kedves {$a->firstname}!<br>
<br>
A(z) {$a->sitename} webhelyen található „{$a->username}” fiók jelszavának visszaállítását kérték.<br>
<br>
A kérés megerősítéséhez és fiókjához új jelszó beállításához látogasson el a következő webcímre:<br>
<a href="{$a->link}">{$a->link}</a><br>
<br>
(Ez a link {$a->resetminutes} percig érvényes a visszaállítás első kérésének időpontjától számítva.)<br>
<br>
Ha ezt a jelszó-visszaállítást nem Ön kérte, nincs teendője.<br>
<br>
Ha segítségre van szüksége, forduljon a webhely rendszergazdájához: {$a->admin}';
$string['emailresetconfirmationsubject'] = '{$a}: jelszó-visszaállítási kérelem';
$string['emailresetconfirmsent'] = 'A(z) <b>{$a}</b> címre e-mail üzenetet küldtünk. <br />Benne egyszerű utasításokat talál a jelszómódosításhoz. . Ha továbbra is gondja van, forduljon a rendszergazdához.';
$string['emailstop'] = 'Értesítések kikapcsolása';
$string['emailtoprivatefiles'] = 'E-mailben is elküldheti csatolmányait saját állományainak  {$a} tárhelyére.';
$string['emailtoprivatefilesdenied'] = 'A rendszergazda kikapcsolta a  saját állományainak  tárhelyére való feltöltést.';
$string['emailvia'] = '{$a->name}  ({$a->url} közvetítésével)';
$string['emojicategoryactivities'] = 'Tevékenységek';
$string['emojicategoryanimalsnature'] = 'Állatok és természet';
$string['emojicategoryflags'] = 'Zászlók';
$string['emojicategoryfooddrink'] = 'Ételek és italok';
$string['emojicategoryobjects'] = 'Objektumok';
$string['emojicategorypeoplebody'] = 'Emberek és test';
$string['emojicategoryrecent'] = 'Legutóbbi';
$string['emojicategorysmileysemotion'] = 'Hangulatjelek és érzelmek';
$string['emojicategorysymbols'] = 'Szimbólumok';
$string['emojicategorytravelplaces'] = 'Utazás és helyek';
$string['emptycmids'] = 'Üres kurzusmodul-azonosítók';
$string['emptydragdropregion'] = 'üres régió';
$string['emptysectionids'] = 'Üres szakaszazonosítók';
$string['enable'] = 'Bekapcsolás';
$string['encryptedcode'] = 'Titkosított kód';
$string['enddate'] = 'A kurzus befejezésének dátuma';
$string['enddate_help'] = 'A befejezési dátum nem korlátozza a hallgatók hozzáférését a kurzushoz. Ez határozza meg, hogy egy kurzus melyik szűrési kategóriában jelenik meg a Kurzusaim oldalon (illetve az irányítópulton). Azaz ez alapján dől el, hogy a "Folyamatban lévő", vagy a "Korábbi kurzusok" között lesz látható.';
$string['enddatewithtaskenabled'] = 'A kurzus befejezési dátuma';
$string['enddatewithtaskenabled_help'] = 'Az a dátum, amikor a kurzus rejtett lesz a hallgatók számára, és már nem férhetnek hozzá.';
$string['english'] = 'Angol';
$string['enrolmentmethods'] = 'Beiratkozási módszerek';
$string['entercourse'] = 'Kattintással lépjen be a kurzusba';
$string['enteremail'] = 'Adja meg e-mail címét.';
$string['enteremailaddress'] = 'Jelszavának törléséhez és új jelszavának e-mailben való elküldéséhez írja be az e-mail címét.';
$string['enterusername'] = 'Adja meg felhasználónevét.';
$string['entries'] = 'Bejegyzések';
$string['error'] = 'Hiba';
$string['errorcreatingactivity'] = '\'{$a}\' tevékenység példánya nem hozható létre';
$string['errorfiletoobig'] = '\'{$a}\' bájt korlátot meghaladó méretű állomány';
$string['errornouploadrepo'] = 'A portálon nincs bekapcsolva feltöltési adattár';
$string['errorwhenconfirming'] = 'Még nem kapott megerősítést, mert hiba lépett fel. Ha egy e-mailen keresztül jutott ide, ellenőrizze, hogy az e-mail küldése során a címnek nem csak egy részét adta-e meg. Lehet, hogy a kapcsolat helyreállításához ki kell másolni a címet.';
$string['eventcommentcreated'] = 'Megjegyzés létrehozva';
$string['eventcommentdeleted'] = 'Megjegyzés törölve';
$string['eventcommentsviewed'] = 'Megjegyzés megtekintve';
$string['eventconfiglogcreated'] = 'Konfigurációs napló létrehozva';
$string['eventcontentviewed'] = 'A tartalmat megtekintették';
$string['eventcoursebackupcreated'] = 'A kurzus biztonsági mentése elkészült';
$string['eventcoursecategorycreated'] = 'Kategória létrehozva';
$string['eventcoursecategorydeleted'] = 'Kategória törölve';
$string['eventcoursecategoryupdated'] = 'Kategória létrehozva';
$string['eventcoursecategoryviewed'] = 'Megtekintett kategória';
$string['eventcoursecontentdeleted'] = 'Kurzustartalom törölve';
$string['eventcoursecreated'] = 'Kurzus létrehozva';
$string['eventcoursedeleted'] = 'Kurzus törölve';
$string['eventcourseended'] = 'A kurzus véget ért';
$string['eventcourseinformationviewed'] = 'Megtekintett kurzusösszegzés';
$string['eventcoursemodulecreated'] = 'Kurzusmodul létrehozva';
$string['eventcoursemoduledeleted'] = 'Kurzusmodul törölve';
$string['eventcoursemoduleinstancelistviewed'] = 'Kurzusmodul előfordulási listája megtekintve';
$string['eventcoursemoduleupdated'] = 'Kurzusmodul frissítve';
$string['eventcoursemoduleviewed'] = 'Megtekintett kurzusmodul';
$string['eventcourseoverviewviewed'] = 'A kurzus tevékenységek áttekintő oldal megtekintve';
$string['eventcourseresetended'] = 'A kurzus visszaállítása véget ért.';
$string['eventcourseresetstarted'] = 'A kurzus visszaállítása elkezdődött.';
$string['eventcourserestored'] = 'Kurzus helyreállítva';
$string['eventcoursesectioncreated'] = 'Kurzusszekció létrehozva';
$string['eventcoursesectiondeleted'] = 'Kurzusszekció törölve';
$string['eventcoursesectionupdated'] = 'Kurzusrész frissítve';
$string['eventcoursessearched'] = 'Keresett kurzusok';
$string['eventcoursestarted'] = 'Elindult a kurzus';
$string['eventcourseupdated'] = 'Kurzus frissítve';
$string['eventcourseuserreportviewed'] = 'Kurzusfelhasználói jelentés megtekintve';
$string['eventcourseviewed'] = 'Kurzus megtekintve';
$string['eventdashboardreset'] = 'Irányítópult visszaállítva';
$string['eventdashboardsreset'] = 'Irányítópultok visszaállítva';
$string['eventdashboardviewed'] = 'Irányítópult megtekintve';
$string['eventdatabasetextfieldcontentreplaced'] = 'Globális keresés és csere az adatbázisban';
$string['eventemailfailed'] = 'Az e-mail elküldése nem sikerült.';
$string['eventmycoursesviewed'] = 'Kurzusaim megtekintve';
$string['eventname'] = 'Esemény neve';
$string['eventrecentactivityviewed'] = 'Legutóbbi tevékenység  megtekintve';
$string['eventsearchindexed'] = 'Keresési adatok indexálva';
$string['eventsearchresultsviewed'] = 'Megtekintett keresési eredmények';
$string['eventsectionviewed'] = 'Szekció megtekintve';
$string['eventunknownlogged'] = 'Ismeretlen esemény';
$string['eventurlblocked'] = 'Az URL blokkolva lett';
$string['eventusercreated'] = 'Felhasználó létrehozva';
$string['eventuserdeleted'] = 'Felhasználó törölve';
$string['eventuserfeedbackgiven'] = 'Visszajelzés hivatkozására kattintott';
$string['eventuserfeedbackremind'] = 'Emlékeztessen később hivatkozására kattintott';
$string['eventuserinfocategorycreated'] = 'Felhasználói profilmező kategóriája létrehozva';
$string['eventuserinfocategorydeleted'] = 'Felhasználói profilmező kategóriája törölve';
$string['eventuserinfocategoryupdated'] = 'Felhasználói profilmező kategóriája frissítve';
$string['eventuserinfofieldcreated'] = 'Felhasználói profilmező létrehozva';
$string['eventuserinfofielddeleted'] = 'Felhasználói profilmező törölve';
$string['eventuserinfofieldupdated'] = 'Felhasználói profilmező frissítve';
$string['eventuserlistviewed'] = 'Megtekintett felhasználói lista';
$string['eventuserloggedout'] = 'A felhasználó kilépett';
$string['eventuserpasswordpolicyfailed'] = 'A felhasználói jelszó nem felel meg a jelszószabványnak.';
$string['eventuserpasswordupdated'] = 'Felhasználói jelszó frissítve';
$string['eventuserprofileviewed'] = 'Megtekintett felhasználói profil';
$string['eventuserupdated'] = 'Felhasználó frissítve';
$string['everybody'] = 'Mindenki';
$string['executeat'] = 'Végrehajtási időpont';
$string['existing'] = 'Létező';
$string['existingadmins'] = 'Létező rendszergazdák';
$string['existingcourse'] = 'Létező kurzus';
$string['existingcourseadding'] = 'Létező kurzus, adatok hozzáadása';
$string['existingcoursedeleting'] = 'Létező kurzus, először törlés';
$string['existingcreators'] = 'Létező kurzuskészítők';
$string['existingstudents'] = 'Beiratkozott tanulók';
$string['existingteachers'] = 'Létező tanárok';
$string['expand'] = 'Kinyitás';
$string['expandall'] = 'Az összes kibontása';
$string['expandcategory'] = '{$a} kinyitása';
$string['explanation'] = 'Magyarázat';
$string['explanationdigitalminor'] = 'Az adat annak megállapításához szükséges, hogy ön eléri-e a digitális hozzájárulási korhatárt. Ez az az életkor, melytől egy illető már önállóan jogosult a felhasználási feltételek elfogadására, és hozzájárulhat, hogy az adatait eltárolják és feldolgozzák.';
$string['extendperiod'] = 'Meghosszabbított időszak';
$string['extendsession'] = 'Munkamenet meghosszabbítása';
$string['failedloginattempts'] = '{$a->attempts} sikertelen belépés utolsó belépése óta';
$string['failedtaskbody'] = '<p>Kedves {$a->firstname}!</p>
<p>A <b>{$a->taskname}</b> feladat végrehajtása több alkalommal is sikertelen volt és figyelmet igényel.</p>
<p><a href="{$a->link}">Feladat megtekintése</a></p>';
$string['failedtaskcontexturlname'] = 'Állapot jelentés';
$string['failedtasksubject'] = 'Feladat sikertelen: {$a}';
$string['favourites'] = 'Megjelölt';
$string['feedback'] = 'Visszajelzés';
$string['file'] = 'Állomány';
$string['fileexists'] = 'Már van egy {$a} nevű fájl-';
$string['filemissing'] = '{$a} hiányzik';
$string['filereaderror'] = 'A(z) \'{$a}\' állomány nem olvasható. Ellenőrizze, nem mappa-e.';
$string['files'] = 'Állományok';
$string['filesanduploads'] = 'Állományok és feltöltések';
$string['filesfolders'] = 'Állományok/mappák';
$string['fileuploadwithcontent'] = 'Az állományfeltöltésekben nem szerepelhet tartalomparaméter';
$string['filloutallfields'] = 'Töltsön ki minden mezőt ezen az űrlapon';
$string['filter'] = 'Szűrő';
$string['filteroption'] = '{$a->criteria}: {$a->value}';
$string['filterrowlegend'] = '{$a} szűrő';
$string['filters'] = 'Szűrők';
$string['filtersetmatchdescription'] = 'Hogy kapcsolódjon több szűrő';
$string['filtertype'] = 'Szűrő típusa';
$string['findmorecourses'] = 'További kurzusok keresése...';
$string['first'] = 'Első';
$string['firstaccess'] = 'Első hozzáférés';
$string['firstname'] = 'Keresztnév';
$string['firstnamephonetic'] = 'Keresztnév - fonetikusan';
$string['firstpage'] = 'Első oldal';
$string['firstsiteaccess'] = 'Első belépés a portálra';
$string['firsttime'] = 'Most van itt először?';
$string['folder'] = 'Mappa';
$string['folderclosed'] = 'Bezárt mappa';
$string['folderopened'] = 'Kinyitott mappa';
$string['followingoptional'] = 'A következők kitöltése nem kötelező';
$string['followingrequired'] = 'A következők kitöltése kötelező';
$string['for'] = 'Kinek';
$string['force'] = 'Csoportos részvétel előírása';
$string['forcelanguage'] = 'Nyelv előírása';
$string['forceno'] = 'Ne írja elő';
$string['forcepasswordchange'] = 'Jelszómódosítás előírása';
$string['forcepasswordchange_help'] = 'Bejelölve a felhasználónak jelszót kell majd változtatnia a következő belépésekor.';
$string['forcepasswordchangecheckfull'] = 'Biztosan jelszómódosítást kíván előírni {$a} esetén?';
$string['forcepasswordchangenot'] = '{$a} esetén nem lehetett jelszómódosítást előírni';
$string['forcepasswordchangenotice'] = 'Továbblépéshez módosítsa jelszavát.';
$string['forcepasswordresetfailurenotice'] = 'Jelszava már nem felel meg a beállított jelszószabványnak. Segítségért forduljon Moodle-rendszergazdájához.
 {$a}';
$string['forcepasswordresetnotice'] = 'Jelszava már nem felel meg a jelszószabványnak. Bejelentkezéshez állítsa vissza jelszavát.
 {$a}';
$string['forcetheme'] = 'Stílus előírása';
$string['forgotaccount'] = 'Elfelejtette jelszavát?';
$string['forgotten'] = 'Elfelejtette felhasználónevét vagy jelszavát?';
$string['forgottenduplicate'] = 'Az e-mail cím több felhasználói fiókhoz tartozik, helyette adja meg a felhasználónevet';
$string['forgotteninvalidurl'] = 'Érvénytelen jelszó-visszaállítási URL';
$string['format'] = 'Formátum';
$string['formathtml'] = 'HTML formázás';
$string['formatmarkdown'] = 'Markdown formázás';
$string['formatplain'] = 'Egyszerű szöveges formázás';
$string['formattext'] = 'Moodle automatikus formázás';
$string['forumpreferences'] = 'Fórumbeállítások';
$string['framesetinfo'] = 'Ezen keretkészlet-dokumentum tartalma:';
$string['fromdate'] = 'Mikortól';
$string['fromsender'] = 'Mikortól';
$string['frontpagecategorycombo'] = 'Lenyíló lista';
$string['frontpagecategorynames'] = 'Kategóriák felsorolása';
$string['frontpagecourselist'] = 'Kurzusok felsorolása';
$string['frontpagecoursesearch'] = 'Kurzuskereső mező';
$string['frontpagedescription'] = 'Kezdőoldal összegzése';
$string['frontpagedescriptionhelp'] = 'Ez az összegzés a kurzus/portál összegző blokkja alapján a kezdőoldalon jeleníthető meg.';
$string['frontpageenrolledcourselist'] = 'Felvett kurzusok';
$string['frontpageformat'] = 'Kezdőoldal formája';
$string['frontpageformatloggedin'] = 'Kezdőoldal formája belépéskor';
$string['frontpagenews'] = 'Hírek';
$string['frontpagesettings'] = 'A kezdőoldal beállításai';
$string['fulllistofcourses'] = 'Minden kurzus';
$string['fullname'] = 'Teljes név';
$string['fullnamecourse'] = 'A kurzus teljes címe';
$string['fullnamecourse_help'] = 'A Kurzusaimban és a Kezdőoldalon elérhető kurzusok listájában megjelenő név.';
$string['fullnamedisplay'] = '{$a->lastname} {$a->firstname}';
$string['fullnameuser'] = 'A felhasználó teljes neve';
$string['fullprofile'] = 'Teljes profil';
$string['fullsitename'] = 'A portál teljes neve';
$string['functiondisabled'] = 'Ez a funkció jelenleg ki van kapcsolva';
$string['general'] = 'Általános';
$string['geolocation'] = 'szélesség - hosszúság';
$string['gettheselogs'] = 'Naplók behozása';
$string['go'] = 'Mehet';
$string['gobacktosite'] = 'Vissza a portálhoz.';
$string['gpl'] = 'Copyright (C) 1999-től Martin Dougiamas  (https://moodle.com)

Ez a program ingyenes szoftver: újraterjesztheti és/vagy módosíthatja a Free Software Foundation által kiadott GNU General Public License feltételeinek betartásával, vagy a licenc 2. verziója, vagy (választhatóan) bármely későbbi verziója szerint.

A programot abban a reményben adjuk közre, hogy hasznosnak bizonyul, azonban MINDENNEMŰ GARANCIA VÁLLALÁSA NÉLKÜL; ideértve az ELADHATÓSÁG vagy valamely KONKRÉT CÉLRA VALÓ ALKALMASSÁG szavatolását.

További részletekért tekintse meg a Moodle Licenc információs oldalát: https://moodledev.io/general/license';
$string['gpl3'] = 'Copyright (C) 1999-től Martin Dougiamas  (https://moodle.com)

Ez a program ingyenes szoftver: újraterjesztheti és/vagy módosíthatja a Free Software Foundation által kiadott GNU General Public License feltételeinek betartásával, vagy a licenc 3. verziója, vagy (választhatóan) bármely későbbi verziója szerint.

A programot abban a reményben adjuk közre, hogy hasznosnak bizonyul, azonban MINDENNEMŰ GARANCIA VÁLLALÁSA NÉLKÜL; ideértve az ELADHATÓSÁG vagy valamely KONKRÉT CÉLRA VALÓ ALKALMASSÁG szavatolását.

További részletekért tekintse meg a Moodle Licenc információs oldalát: https://moodledev.io/general/license';
$string['gpllicense'] = 'GPL-licenc';
$string['gradenoun'] = 'Értékelés';
$string['grades'] = 'Értékelések';
$string['gradeverb'] = 'Értékelés';
$string['gravatarenabled'] = 'A <a href="https://www.gravatar.com/">Gravatar</a> a portálon be van kapcsolva. Ha nem tölt föl profilképet, akkor a Moodle megpróbál egyet a Gravatarból feltölteni Önnek.';
$string['group'] = 'Csoport';
$string['groupadd'] = 'Új csoport hozzáadása';
$string['groupaddusers'] = 'A kiválasztott csoport hozzáadása';
$string['groupfor'] = 'csoport számára';
$string['groupinfo'] = 'Információk a kiválasztott csoportról';
$string['groupinfoedit'] = 'Csoportbeállítások szerkesztése';
$string['groupinfomembers'] = 'Információk a kiválasztott tagokról';
$string['groupinfopeople'] = 'Információk a kiválasztott személyekről';
$string['groupmembers'] = 'Csoporttagok';
$string['groupmemberssee'] = 'Csoporttagok megtekintése';
$string['groupmembersselected'] = 'A kiválasztott csoport tagjai';
$string['groupmode'] = 'Csoportos részvétel';
$string['groupmodeforce'] = 'Csoportos részvétel előírása';
$string['groupmy'] = 'Csoportom';
$string['groupnonmembers'] = 'Csoportba nem tartozók';
$string['groupnotamember'] = 'Ön nem tagja annak a csoportnak';
$string['grouprandomassign'] = 'Véletlenszerű hozzárendelés a csoportokhoz';
$string['groupremove'] = 'A kiválasztott csoport eltávolítása';
$string['groupremovemembers'] = 'A kiválasztott tagok eltávolítása';
$string['groups'] = 'Csoportok';
$string['groupsnone'] = 'Nincs csoport';
$string['groupsseparate'] = 'Külön csoportok';
$string['groupsvisible'] = 'Látható csoportok';
$string['guest'] = 'Vendég';
$string['guestdescription'] = 'A vendégek általában kevés jogosultsággal rendelkeznek és nem tudnak sehova szöveget beírni.';
$string['guestskey'] = 'A kóddal rendelkező vendégek beléphetnek';
$string['guestsno'] = 'Vendégek nem léphetnek be';
$string['guestsnotallowed'] = 'A(z) \'{$a}\' nem engedélyezi vendégek belépését.';
$string['guestsyes'] = 'A vendégek beléphetnek kód nélkül';
$string['guestuser'] = 'Vendég felhasználó';
$string['guestuserinfo'] = 'Ez egy speciális felhasználó, akinek csak olvasási joga van egyes kurzusokhoz.';
$string['help'] = 'Súgó';
$string['helpprefix2'] = 'Súgó ehhez: {$a}';
$string['helpwiththis'] = 'Súgó ehhez';
$string['hiddenassign'] = 'Rejtett feladat';
$string['hiddenfromstudents'] = 'Tanulók elől rejtve';
$string['hiddenoncoursepage'] = 'Elérhető,  de a kurzusoldalon nem látható';
$string['hiddensections'] = 'Rejtett részek';
$string['hiddensections_help'] = 'A rejtett szekciók a kurzus oldalán „nem elérhetőként” jeleníthetők meg a hallgatók számára, vagy teljesen elrejthetők.';
$string['hiddensectionscollapsed'] = 'A rejtett részek elérhetetlenként jelennek meg';
$string['hiddensectionsinvisible'] = 'A rejtett részek teljesen láthatatlanok';
$string['hiddenwithbrackets'] = '(rejtett)';
$string['hide'] = 'Elrejtés';
$string['hideadvancedsettings'] = 'Részletes beállítások elrejtése';
$string['hidecategory'] = 'Kategória rejtve?';
$string['hidecategorymany'] = 'A {$a->category} kategóriában {$a->coursecount} darab kurzus található.
<br/>Ha elrejti azt, a rejtett kurzusok megtekintését engedélyező jogosultság nélküli felhasználók elvesztik hozzáférésüket azokhoz a kurzusokhoz.';
$string['hidecategoryone'] = 'A {$a->category} kategóriában 1 darab kurzus található.
<br/>Ha elrejti azt, a rejtett kurzusok megtekintését engedélyező jogosultság nélküli felhasználók elvesztik hozzáférésüket ahhoz a kurzushoz.';
$string['hidechartdata'] = 'Táblázat adatainak elrejtése';
$string['hidefromstudents'] = 'Elrejtés a kurzus oldalán';
$string['hideoncoursepage'] = 'Legyen elérhető, de ne jelenjen meg a kurzusoldalon';
$string['hidepopoverwindow'] = 'Előtűnő ablak elrejtése';
$string['hidesection'] = 'A(z) {$a} szekció elrejtése';
$string['hidesettings'] = 'Beállítások elrejtése';
$string['hideshowblocks'] = 'Blokkok elrejtése vagy megjelenítése';
$string['highlight'] = 'Kiemelés';
$string['highlighted'] = 'Kiemelve';
$string['highlightoff'] = 'Kiemelés törlése';
$string['hits'] = 'Találatok';
$string['hitsoncourse'] = '{$a->username} találatai a(z) {$a->coursename} kurzusban';
$string['hitsoncoursetoday'] = '{$a->username} mai találatai a(z) {$a->coursename} kurzusban';
$string['home'] = 'Kezdőoldal';
$string['homeheader'] = 'Honlapmenü';
$string['hour'] = 'óra';
$string['hours'] = 'óra';
$string['howtomakethemes'] = 'Új stílusok készítése';
$string['htmleditor'] = 'HTML-szerkesztő használata';
$string['htmleditoravailable'] = 'A HTML-szerkesztő elérhető.';
$string['htmleditordisabled'] = 'Felhasználói profiljában kikapcsolta a HTML-szerkesztőt';
$string['htmleditordisabledadmin'] = 'A rendszergazda nem engedélyezte a HTML-szerkesztő használatát ezen a portálon';
$string['htmleditordisabledbrowser'] = 'A HTML-szerkesztő nem elérhető, mert böngészője nem kompatibilis';
$string['htmlfilesonly'] = 'Csak HTML-állományok';
$string['htmlformat'] = 'Szerkesztett HTML-forma';
$string['icon'] = 'Ikon';
$string['idnumber'] = 'Azonosítószám';
$string['idnumbercourse'] = 'A kurzus azonosítója';
$string['idnumbercourse_help'] = 'Csak a kurzus külső rendszerekkel való összekapcsolására szolgál. Ha nem rendelkezik hivatalos kurzusazonosítóval, hagyja üresen.';
$string['idnumbercoursecategory'] = 'Kategória azonosítószáma';
$string['idnumbercoursecategory_help'] = 'Egy kurzuskategória azonosítószáma csak a kategória külső rendszerekhez való illesztésére használatos, és a portálon sehol nem látható. Ha a kategória hivatalos kódnévvel rendelkezik, azt itt megadhatja, ellenkező esetben a mezőt üresen hagyhatja.';
$string['idnumbergroup'] = 'Csoport azonosítószáma';
$string['idnumbergroup_help'] = 'Egy csoport azonosítószáma csak a csoport külső rendszerekkel való összehasonlítására használatos, és nem jelenik meg sehol az oldalon. Ha a csoport hivatalos kódnévvel rendelkezik, itt megadhatja, különben a mező üresen hagyható.';
$string['idnumbergrouping'] = 'Csoport azonosítószáma';
$string['idnumbergrouping_help'] = 'Egy csoport azonosítószáma csak a csoport külső rendszerekkel való összehasonlítására használatos, és nem jelenik meg sehol az oldalon. Ha a csoport hivatalos kódnévvel rendelkezik, itt megadhatja, különben a mező üresen hagyható.';
$string['idnumbermod'] = 'Azonosítószám';
$string['idnumbermod_help'] = 'Azonosítószám beállításával értékelésnél vagy egyedi jelentéseknél azonosíthat egy tevékenységet vagy tananyagot. Egyéb esetben a mező üresen maradhat.

Értékelhető tevékenységek esetén az azonosítószámot beállíthatja az értékelésnaplóban is, bár módosítani azt csak a tevékenység beállítási oldalán lehet.';
$string['idnumbertaken'] = 'Ez az azonosítószám már foglalt';
$string['imagealt'] = 'Kép leírása';
$string['import'] = 'Importálás';
$string['importdata'] = 'Kurzusadatok importálása';
$string['importdataexported'] = 'Forráskurzusa adatainak exportálása sikerült. Folytassa a célkurzusba való importálással.';
$string['importdatafinished'] = 'Az importálás megtörtént! Térjen át kurzusára';
$string['importdatafrom'] = 'Forráskurzus keresése adatimportáláshoz:';
$string['importinfo'] = 'Olyan elemek importálása más kurzusokból, mint például a tevékenységek, blokkok vagy naptáresemények. Felhasználói adatokat nem importál.';
$string['inactive'] = 'Nincs bekapcsolva';
$string['include'] = 'Felvesz';
$string['includeallusers'] = 'Minden felhasználó felvétele';
$string['includecoursefiles'] = 'Kurzusállományok felvétele';
$string['includecourseusers'] = 'Kurzus felhasználóinak felvétele';
$string['included'] = 'Felvéve';
$string['includelogentries'] = 'Naplóbejegyzések felvétele';
$string['includemodules'] = 'Modulok felvétele';
$string['includemoduleuserdata'] = 'Modul felhasználói adatainak hozzáadása';
$string['includeneededusers'] = 'Szükséges felhasználók felvétele';
$string['includenoneusers'] = 'Nem vesz fel felhasználókat';
$string['includeroleassignments'] = 'Szerepek hozzárendelésének felvétele';
$string['includesitefiles'] = 'A kurzusban használt portálállományok felvétele';
$string['includesubcategories'] = 'Alkategóriákkal együtt';
$string['includeuserfiles'] = 'Felhasználói állományok felvétele';
$string['increasesections'] = 'Szekciók számának emelése';
$string['indicator:accessesafterend'] = 'Befejezési időpont utáni kurzushozzáférés';
$string['indicator:accessesafterend_help'] = 'Ez a jelző azt mutatja, hogy a tanuló a kurzus vége után hozzáfért-e a kurzushoz.';
$string['indicator:accessesbeforestart'] = 'Kezdési időpont előtti kurzushozzáférés';
$string['indicator:accessesbeforestart_help'] = 'Ez a jelző azt mutatja, hogy a tanuló a kurzus kezdési időpontja előtt hozzáfért-e a kurzushoz.';
$string['indicator:activitiesdue'] = 'Elvégzendő tevékenységek';
$string['indicator:activitiesdue_help'] = 'A felhasználóra elvégzendő tevékenységek várnak.';
$string['indicator:anycourseaccess'] = 'Bármely belépés a kurzusba';
$string['indicator:anycourseaccess_help'] = 'Ez a jelölő az adott felhasználó által felvett kurzusba való belépését mutatja.';
$string['indicator:anywrite'] = 'Bármiféle írási tevékenység';
$string['indicator:anywrite_help'] = 'Ez a jelző a tanuló írási (leadási) tevékenységét mutatja.';
$string['indicator:anywriteincourse'] = 'Kurzusbeli írásos tevékenység';
$string['indicator:anywriteincourse_help'] = 'Ez jelzi, hogy a tanuló bekapcsolódott-e valamilyen kurzusbeli írásos (leadásos) tevékenységbe.';
$string['indicator:completeduserprofile'] = 'A felhasználói profil kész';
$string['indicator:completeduserprofile_help'] = 'Ez a jelző azt mutatja, hogy a tanuló kitöltötte felhasználói profilját.';
$string['indicator:completeduserprofiledef'] = 'A felhasználói profil elkészült';
$string['indicator:completeduserprofiledef_help'] = 'A portál stratégiájába beleegyezett és a felhasználó az alábbi mezőket kitöltötte: Intézmény, Tanszék, Cím, Helység, Ország, Webcím.';
$string['indicator:completionenabled'] = 'Teljesítés nyomon követése bekapcsolva';
$string['indicator:completionenabled_help'] = 'Ez a jelző azt mutatja, hogy a teljesítés nyomon követése a kurzus esetén be van kapcsolva.';
$string['indicator:nostudent'] = 'Beiratkozott tanulók';
$string['indicator:nostudent_help'] = 'Ez a jelző azt mutatja, hogy a kurzusban vannak tanulók.';
$string['indicator:noteacher'] = 'Vannak tanárok';
$string['indicator:noteacher_help'] = 'Ez a jelző azt mutatja, hogy a kurzusban vannak tanárok.';
$string['indicator:potentialcognitive'] = 'A kurzus potenciális kognitív mélysége';
$string['indicator:potentialcognitive_help'] = 'Ez a jelző azt mutatja, hogy a tanuló a kurzusbeli tevékenységekkel potenciálisan milyen kognitív mélységet érhet el.';
$string['indicator:potentialcognitivedef'] = 'A kurzus lehetséges kognitív mélysége';
$string['indicator:potentialcognitivedef_help'] = 'Annak mértéke, amilyet a kurzus "elmélyült" kognitív elfoglaltság terén kínál, pl. munka leadása visszajelzés céljából, mások számára lehetőség a munka értékelésére, vagy lehetőség a munka felülvizsgálatára és újbóli leadására.';
$string['indicator:potentialcognitivedef_link'] = 'Learning_analytics_indicators#Cognitive_depth';
$string['indicator:potentialsocial'] = 'A kurzus potenciális társas lefedettsége';
$string['indicator:potentialsocial_help'] = 'Ez a jelző azt mutatja, hogy a tanuló a kurzusbeli tevékenységekkel potenciálisan milyen társas lefedettséget érhet el.';
$string['indicator:potentialsocialdef'] = 'A kurzus lehetséges társas mélysége';
$string['indicator:potentialsocialdef_help'] = 'Annak mértéke, amilyet a kurzus "kiterjedt" társas elfoglaltság terén kínál, pl. munka együttműködés más résztvevőkkel vagy lehetőség osztályon kívüli gyakorlat megszerzésére.';
$string['indicator:potentialsocialdef_link'] = 'Learning_analytics_indicators#Social_breadth';
$string['indicator:readactions'] = 'Olvasási tevékenység mennyisége';
$string['indicator:readactions_help'] = 'Ez a jelző a tanuló olvasási (megtekintési) tevékenységét mutatja.';
$string['indicator:userforumstracking'] = 'A felhasználó nyomon követ fórumokat';
$string['indicator:userforumstracking_help'] = 'Ez a jelző azt mutatja, hogy a teljesítés nyomon követése be van-e kapcsolva.';
$string['info'] = 'Információ';
$string['inprogress'] = 'Folyamatban';
$string['insertcontentbefore'] = 'Tartalom áthelyezése \'{$a->activityname}\' elé';
$string['insertcontentsection'] = 'Tartalom beszúrása \'{$a->sectionname}\' szekcióba';
$string['insertresourceoractivitybefore'] = 'Szúrjon be tevékenységet vagy tananyagot a(z) „{$a->activityname}” elé';
$string['institution'] = 'Intézmény';
$string['instudentview'] = 'tanulói nézetben';
$string['interests'] = 'Érdeklődési kör';
$string['interestslist'] = 'Érdeklődési körök felsorolása';
$string['interestslist_help'] = 'Adja meg érdeklődési köreit, melyek a profiloldalán címkékként jelennek meg.';
$string['invalidemail'] = 'Érvénytelen e-mail cím';
$string['invalidlogin'] = 'Érvénytelen belépés, próbálja újra';
$string['invalidtaskclassname'] = 'Érvénytelen feladatosztály: {$a}';
$string['invalidtaskid'] = 'Érvénytelen feladatazonosító';
$string['invalidusername'] = 'A felhasználónévben csak kisbetűk, számok, aláhúzás (_), kötőjel (-), pont (.) és a kukac (@) használható';
$string['invalidusernameupload'] = 'Érvénytelen felhasználónév';
$string['ip_address'] = 'IP-cím';
$string['jump'] = 'Ugrás';
$string['jumpto'] = 'Ugrás...';
$string['keep'] = 'Megtart';
$string['labelvalue'] = '{$a->label}: {$a->value}';
$string['langltr'] = 'Írás iránya balról-jobbra';
$string['langrtl'] = 'Írás iránya jobbról balra';
$string['language'] = 'Nyelv';
$string['languagegood'] = 'Ez a nyelvi csomag friss!';
$string['languageselector'] = 'Nyelvválasztó';
$string['last'] = 'Utolsó';
$string['lastaccess'] = 'Utolsó belépés';
$string['lastcourseaccess'] = 'Utolsó belépés a kurzusba';
$string['lastedited'] = 'Utolsó szerkesztés';
$string['lastip'] = 'Utolsó IP-cím';
$string['lastlogin'] = 'Utolsó belépés';
$string['lastmodified'] = 'Utolsó módosítás';
$string['lastname'] = 'Vezetéknév';
$string['lastnamephonetic'] = 'Vezetéknév - fonetikusan';
$string['lastpage'] = 'Utolsó oldal';
$string['lastsiteaccess'] = 'Utolsó belépés a portálra';
$string['lastyear'] = 'Tavaly';
$string['latestlanguagepack'] = 'A legfrissebb nyelvi csomagért látogasson el a moodle.org portálra';
$string['layouttable'] = 'Elrendezési táblázat';
$string['leavetokeep'] = 'A jelenlegi jelszó megtartásához hagyja üresen';
$string['legacylogginginuse'] = 'A portálon korábbi naplóba írás van bekapcsolva. A mostani naplóba írás nincs támogatva. Írjon támogatott naplóba, amilyen pl. a  "standard" vagy a "külső".';
$string['legacythemeinuse'] = 'A portál kompatibilitási üzemmódban jelenik meg, mert túl régi böngészőt használ.';
$string['license'] = 'Licenc';
$string['licenses'] = 'Licencek';
$string['liketologin'] = 'Szeretne egy teljes felhasználónévvel bejelentkezni?';
$string['list'] = 'Lista';
$string['listfiles'] = '{$a} állományainak listája';
$string['listofallpeople'] = 'Az összes személy felsorolása';
$string['listofcourses'] = 'Kurzuslista';
$string['loading'] = 'Betöltés';
$string['loadinghelp'] = 'Betöltés...';
$string['local'] = 'Helyi';
$string['localplugins'] = 'Helyi segédprogramok';
$string['localpluginsmanage'] = 'Helyi segédprogramok kezelése';
$string['location'] = 'Hely';
$string['locktimeout'] = 'Zárra várás közben a műveleti idő lejárt';
$string['log_excel_date_format'] = 'éééé hhhh n ó:pp';
$string['loggedinas'] = '{$a} néven lépett be';
$string['loggedinasguest'] = 'Jelenleg vendégként van bejelentkezve';
$string['loggedinnot'] = 'Nincs bejelentkezve.';
$string['login'] = 'Belépés';
$string['login_failure_logs'] = 'Sikertelen belépések naplói';
$string['loginactivity'] = 'Bejelentkezés részletei';
$string['loginagain'] = 'Lépjen be újra';
$string['loginalready'] = 'Már belépett';
$string['loginas'] = 'Belépés mint';
$string['loginaspasswordexplain'] = 'Ennek használatához a speciális "belépés mint" jelszót kell megadnia. Ha nem ismeri, forduljon a rendszergazdához.';
$string['loginguest'] = 'Hozzáférés vendégként';
$string['loginsite'] = 'Belépés a portálra';
$string['loginsteps'] = 'Ahhoz, hogy teljesen hozzáférjen a portálhoz, először új fiókot kell létrehoznia.';
$string['loginstepsnone'] = 'Üdvözöljük!
Ahhoz, hogy teljesen hozzáférjen a kurzusokhoz, új fiókot kell létrehoznia.
Csupán egy felhasználónevet és jelszót kell kitalálnia és beírnia az ezen az oldalon lévő űrlapba!
Ha valaki már kiválasztotta a kívánt felhasználónevet, akkor újra kell próbálkoznia egy másik névvel.';
$string['loginto'] = 'Belépés ide: {$a}';
$string['logoof'] = 'a(z} {$a} logója';
$string['logout'] = 'Kilépés';
$string['logoutconfirm'] = 'Biztosan kilép?';
$string['logs'] = 'Naplók';
$string['logtoomanycourses'] = '[ <a href="{$a->url}">tovább</a> ]';
$string['logtoomanyusers'] = '[ <a href="{$a->url}">tovább</a> ]';
$string['lookback'] = 'Visszatekintés';
$string['mailadmins'] = 'Rendszergazdák értesítése';
$string['mailstudents'] = 'Tanulók értesítése';
$string['mailteachers'] = 'Tanárok értesítése';
$string['maincoursepage'] = 'Fő kurzusoldal';
$string['makeafolder'] = 'Mappa létrehozása';
$string['makeavailable'] = 'Elérhető';
$string['makeeditable'] = 'Ha a webszerver (pl. apache) eljárása írhatóvá teszi \'{$a}\'-t , akkor ezt az állományt közvetlenül szerkesztheti erről az oldalról';
$string['makethismyhome'] = 'Ez legyen a honlapom';
$string['makeunavailable'] = 'Nem elérhető';
$string['manageblocks'] = 'Blokkok';
$string['managecategories'] = 'Kurzuskategóriák kezelése';
$string['managecategorythis'] = 'Kategória kezelése';
$string['managecombined'] = 'Kurzuskategóriák és kurzusok kezelése';
$string['managecontentbanktypes'] = 'Tartalomtípusok kezelése';
$string['managecourses'] = 'Kurzusok kezelése';
$string['managedatabase'] = 'Adatbázis';
$string['managedataformats'] = 'Adatformátumok kezelése';
$string['manageeditorfiles'] = 'A szerkesztő által használt állományok kezelése';
$string['managefilters'] = 'Szűrők';
$string['managemodules'] = 'Modulok';
$string['manageroles'] = 'Szerepek és engedélyek';
$string['markallread'] = 'Összes megjelölése olvasottként';
$string['match'] = 'Egyezés';
$string['matchingsearchandrole'] = '\'{$a->search}\' és {$a->role} egyeztetése';
$string['matchofthefollowing'] = 'az alábbiak esetén:';
$string['maxareabytesreached'] = 'Az állomány(ok) mérete nagyobb a területen rendelkezésre álló szabad helynél';
$string['maxfilesize'] = 'Új állományok maximális mérete: {$a}';
$string['maxfilesreached'] = 'Ehhez legfeljebb {$a} állományt csatolhat.';
$string['maximumchars'] = 'Maximum {$a} karakter';
$string['maximumgrade'] = 'Legjobb értékelés';
$string['maximumgradex'] = 'Legjobb értékelés: {$a}';
$string['maximumshort'] = 'Max.';
$string['maximumupload'] = 'Maximális feltöltési méret';
$string['maximumupload_help'] = 'A hallgatók kurzusba feltölthető maximális fájlmérete. Ezen túlmenően az egyes tevékenységek maximális feltöltési méretét tovább korlátozhatja.';
$string['maxlengthreached'] = 'A maximum {$a} karakterlimit elérve.';
$string['maxnumberweeks'] = 'Szekciók maximális száma';
$string['maxnumberweeks_desc'] = 'A szakasz lenyíló menüinek maximális száma (csak bizonyos kurzusformák esetén).';
$string['maxnumcoursesincombo'] = '<a href="{$a->link}">{$a->numberofcourses} kurzus</a> böngészése.';
$string['maxsectionslimit'] = 'Nem hozható létre új szekció, mert túllépné a kurzusban engedélyezett szekciók számát ({$a}).';
$string['maxsize'] = 'max. méret: {$a}';
$string['maxsizeandareasize'] = 'Új állományok maximális mérete: {$a->size}, globális korlát: {$a->areasize}';
$string['maxsizeandattachments'] = 'Állományok maximális mérete: {$a->size}, maximális csatolt állomány: {$a->attachments}';
$string['maxsizeandattachmentsandareasize'] = 'Állományok maximális mérete: {$a->size}, maximum {$a->attachments} melléklet, globális korlát: {$a->areasize}';
$string['memberincourse'] = 'fő a kurzusban';
$string['menu'] = 'Menü';
$string['message'] = 'Üzenet';
$string['messagebody'] = 'Üzenet törzse';
$string['messagedselectedusers'] = 'A kiválasztott felhasználók üzenetet kaptak és a címzettlista visszaállítódott.';
$string['messagedselectedusersfailed'] = 'Hiba történt a kiválasztott felhasználók értesítése közben. Néhányan megkaphatták az e-mailt.';
$string['messageprovider:asyncbackupnotification'] = 'Aszinkron helyreállítás/biztonsági mentés értesítései';
$string['messageprovider:availableupdate'] = 'Elérhető értesítések frissítésekről';
$string['messageprovider:backup'] = 'Biztonsági mentés értesítései';
$string['messageprovider:badgecreatornotice'] = 'Kitűző létrehozójának értesítései';
$string['messageprovider:badgerecipientnotice'] = 'Kitűző átvevőjének értesítései';
$string['messageprovider:competencyplancomment'] = 'Tanulási tervhez fűzött megjegyzés';
$string['messageprovider:competencyusercompcomment'] = 'Készséghez fűzött megjegyzés';
$string['messageprovider:coursecompleted'] = 'Kurzus teljesítve';
$string['messageprovider:coursecontentupdated'] = 'Kurzustartalom változásai';
$string['messageprovider:courserequestapproved'] = 'Értesítés kurzuskérés jóváhagyásáról';
$string['messageprovider:courserequested'] = 'Értesítés kurzuskérésről';
$string['messageprovider:courserequestrejected'] = 'Értesítés kurzuskérés elutasításáról';
$string['messageprovider:enrolcoursewelcomemessage'] = 'Üdvözlő üzenet az új beiratkozóknak';
$string['messageprovider:errors'] = 'A portálon komoly hibák észlelhetők';
$string['messageprovider:errors_help'] = 'Ezek olyan súlyos hibák, amelyekről a rendszergazdának tudnia kell.';
$string['messageprovider:failedtaskmaxdelay'] = 'A feladat elérte a maximális hiba okozta késleltetést';
$string['messageprovider:gradenotifications'] = 'Értékeléssel kapcsolatos értesítések';
$string['messageprovider:infected'] = 'Vírusirtó hibájával kapcsolatos értesítések';
$string['messageprovider:insights'] = 'Jósló modellektől kapott ötletek';
$string['messageprovider:instantmessage'] = 'Felhasználók közötti személyes üzenetek';
$string['messageprovider:instantmessage_help'] = 'Itt adható meg, mi történjen azon üzenetekkel, amelyeket közvetlenül a portál más felhasználóitól kap.';
$string['messageprovider:messagecontactrequests'] = 'A kapcsolatfelvételi kérés jelzésének szövege';
$string['messageprovider:newlogin'] = 'Új belépéshez kapcsolódó értesítések';
$string['messageprovider:notices'] = 'Értesítések kisebb problémákról';
$string['messageprovider:notices_help'] = 'Előfordulhat, hogy ezek az értesítések érdeklik a rendszergazdát.';
$string['messageprovider:reportbuilderschedule'] = 'Egyedi jelentéskészítő ütemezései';
$string['messageselect'] = 'A felhasználó üzenet címzettjeként való kiválasztása';
$string['messageselectadd'] = 'Üzenet küldése';
$string['middlename'] = 'Egyéb vezetéknév';
$string['migratinggrades'] = 'Értékelések átvitele';
$string['min'] = 'p';
$string['mins'] = 'perc';
$string['minute'] = 'perc';
$string['minutes'] = 'perc';
$string['miscellaneous'] = 'Egyéb';
$string['missingcategory'] = 'Kategóriát kell választania';
$string['missingdescription'] = 'Hiányzó leírás';
$string['missingemail'] = 'Hiányzó e-mail cím';
$string['missingfirstname'] = 'Hiányzó keresztnév';
$string['missingfromdisk'] = 'Nincs a lemezen';
$string['missingfullname'] = 'Hiányzó teljes név';
$string['missinglastname'] = 'Hiányzó vezetéknév';
$string['missingname'] = 'Hiányzó név';
$string['missingnewpassword'] = 'Hiányzó új jelszó';
$string['missingpassword'] = 'Hiányzó jelszó';
$string['missingrecaptchachallengefield'] = 'A reCAPTCHA sikertelen, próbálja meg újra.';
$string['missingreqreason'] = 'Hiányzó indok';
$string['missingshortname'] = 'Hiányzó rövid cím';
$string['missingshortsitename'] = 'Nincs rövid név a portálhoz';
$string['missingsitedescription'] = 'Hiányzó portálleírás';
$string['missingsitename'] = 'Hiányzó portálnév';
$string['missingstrings'] = 'Lefordítatlan szövegek keresése';
$string['missingstudent'] = 'Választania kell valamit';
$string['missingsummary'] = 'Hiányzó összegzés';
$string['missingteacher'] = 'Választania kell valamit';
$string['missingurl'] = 'Hiányzó URL';
$string['missingusername'] = 'Hiányzó felhasználónév';
$string['moddoesnotsupporttype'] = 'A(z) {$a->modname} modul nem támogatja {$a->type} típusú állományok feltöltését.';
$string['modhide'] = 'Elrejtés';
$string['modified'] = 'Módosítva';
$string['modshow'] = 'Mutat';
$string['moduleintro'] = 'Leírás';
$string['modulesetup'] = 'Modultáblák létrehozása';
$string['modulesuccess'] = 'A(z) {$a} táblák létrehozása sikerült';
$string['modulesused'] = 'Használatban lévő modulok';
$string['modvisible'] = 'Elérhetőség';
$string['modvisible_help'] = '* Megjelenítés a kurzusoldalon: A hallgatók számára elérhető (az esetlegesen beállított hozzáférési korlátozások függvényében).
* Elrejtés a kurzusoldalon: A hallgatók számára nem elérhető.';
$string['modvisiblehiddensection'] = 'Elérhetőség';
$string['modvisiblehiddensection_help'] = '* Elrejtés a Kurzusoldalon: A hallgatók számára nem elérhető.
* Legyen elérhető, de ne jelenjen meg a Kurzusoldalon: A hallgatók számára elérhető, ha megad egy linket. A tevékenységek továbbra is megjelennek az értékelnaplóban és más jelentésekben.';
$string['modvisiblewithstealth'] = 'Elérhetőség';
$string['modvisiblewithstealth_help'] = '* Megjelenítés a Kurzusoldalon: A hallgatók számára elérhető (az esetlegesen beállított hozzáférési korlátozások függvényében).
* Elrejtés a Kurzusoldalon: A hallgatók számára nem elérhető.
* Legyen elérhető, de ne jelenjen meg a Kurzusoldalon: A hallgatók számára elérhető, ha megad egy linket. A tevékenységek továbbra is megjelennek az értékelésnaplóban és más jelentésekben.';
$string['month'] = 'hónap';
$string['months'] = 'hónap';
$string['moodledocs'] = 'Moodle-dokumentumok';
$string['moodledocslink'] = 'Az oldal dokumentációja';
$string['moodlelogo'] = 'Moodle-logó';
$string['moodlenet:cannotconnecttoserver'] = 'Nem lehet csatlakozni a MoodleNet szerverhez';
$string['moodlenet:columnname'] = 'Név';
$string['moodlenet:columnsenddate'] = 'Küldés dátuma';
$string['moodlenet:columnsendstatus'] = 'Küldés állapota';
$string['moodlenet:columntype'] = 'Típus';
$string['moodlenet:configoauthservice'] = 'Válasszon egy MoodleNet OAuth 2 szolgáltatást, hogy engedélyezze a megosztást az adott MoodleNet webhelyen. Ha a szolgáltatás még nem létezik, <a href="{$a}">létre kell hoznia</a>.';
$string['moodlenet:deletedactivity'] = 'Tevékenység törölve';
$string['moodlenet:deletedcourse'] = 'Törölt kurzus';
$string['moodlenet:eventresourceexported'] = 'Erőforrás exportálva';
$string['moodlenet:gotomoodlenet'] = 'Nyissa meg a MoodleNet piszkozatait';
$string['moodlenet:issuerisnotauthorized'] = 'A MoodleNet kibocsátó nem jogosult';
$string['moodlenet:issuerisnotenabled'] = 'A MoodleNet kibocsátó nincs engedélyezve';
$string['moodlenet:issuerisnotset'] = 'A MoodleNet kibocsátó nincs beállítva a webhely adminisztrációjában';
$string['moodlenet:nosharedresources'] = 'Jelenleg nincsenek megjeleníthető megosztott erőforrások.';
$string['moodlenet:outboundsettings'] = 'MoodleNet kimenő beállítások';
$string['moodlenet:packagingandsending'] = 'A fájl becsomagolása és elküldése a MoodleNetre...';
$string['moodlenet:sharefailtext'] = 'Hiba történt a tartalom MoodleNettel való megosztásában.<br>Kérjük, próbálkozzon újra később.';
$string['moodlenet:sharefailtextwithsitesupport'] = 'Hiba történt a tartalom MoodleNettel való megosztásában.<br>Kérjük, próbálja újra később, vagy <a href="{$a}">forduljon a webhely ügyfélszolgálatához</a>.';
$string['moodlenet:sharefailtitle'] = 'Valami elromlott';
$string['moodlenet:sharefilesizelimitexceeded'] = 'A megosztott erőforrás mérete ({$a->file size} bájt) meghaladja a {$a->filesizelimitt} byte-os korlátot.';
$string['moodlenet:sharenoticeactivity'] = 'Ezt a tevékenységet erőforrásként megosztjuk a MoodleNettel.';
$string['moodlenet:sharenoticecourse'] = 'Ezt a kurzust erőforrásként megosztjuk a MoodleNettel.';
$string['moodlenet:sharenoticepartial'] = 'A kiválasztott tevékenységek megosztásra kerülnek a MoodleNettel, mint erőforrás.';
$string['moodlenet:sharenoticepartialactivitynumber'] = '{$a} tevékenység szerepel a kurzusban.';
$string['moodlenet:shareprogress'] = 'A MoodleNet megosztási folyamata';
$string['moodlenet:shareprogressinfo'] = 'A lista azokat a kurzusokat és tevékenységeket tartalmazza, amelyeket megosztott a MoodleNettel.<br>Kattintson az erőforrás nevére a MoodleNetben való megtekintéséhez.';
$string['moodlenet:sharesuccesstext'] = 'Majdnem kész! A tartalom megosztásának befejezéséhez keresse fel piszkozatait a MoodleNetben.';
$string['moodlenet:sharesuccesstitle'] = 'Mentve a MoodleNet piszkozatok közé';
$string['moodlenet:sharetomoodlenet'] = 'Oszd meg a MoodleNeten';
$string['moodlenet:sharinglargefile'] = 'Nagy fájlok, eltarthat egy ideig.';
$string['moodlenet:sharingstatus'] = 'Megosztás a MoodleNeten';
$string['moodlenet:sharingto'] = 'Megosztás:';
$string['moodlerelease'] = 'Moodle-kiadás';
$string['moodleservicesandsupport'] = 'Szolgáltatások és támogatás';
$string['moodleversion'] = 'Moodle-verzió';
$string['more'] = 'tovább';
$string['moreactions'] = 'További műveletek';
$string['morehelp'] = 'További segítség';
$string['morehelpaboutmodule'] = 'További részletek a(z) {$a} tevékenységgel kapcsolatban';
$string['moreinfo'] = 'További részletek';
$string['moreinformation'] = 'További tájékoztatás erről a hibáról';
$string['moremenu'] = 'Tovább';
$string['morenavigationlinks'] = 'Tovább...';
$string['moreprofileinfoneeded'] = 'Áruljon el többet magáról';
$string['mostrecently'] = 'legutoljára';
$string['move'] = 'Áthelyezés';
$string['movecategoriessuccess'] = '{$a->count} kategória  \'{$a->to}\' kategória alá sikeresen áthelyezve';
$string['movecategoriestotopsuccess'] = '{$a->count} kategória sikeresen áthelyezve a felső szintre';
$string['movecategorycontentto'] = 'Áthelyezés ide';
$string['movecategorysuccess'] = '{$a->moved} kategória  \'{$a->to}\' kategória alá sikeresen áthelyezve';
$string['movecategoryto'] = 'Kategória áthelyezése ide:';
$string['movecategorytotopsuccess'] = '\'{$a->moved}\' kategória sikeresen áthelyezve a felső szintre';
$string['movecontent'] = '{$a} mozgatása';
$string['movecontentafter'] = '"{$a}" után';
$string['movecontentstoanothercategory'] = 'Tartalom áthelyezése egy másik kategóriába';
$string['movecontenttothetop'] = 'A lista tetejére';
$string['movecoursemodule'] = 'Tevékenység áthelyezése';
$string['movecoursesection'] = 'Szekció áthelyezése';
$string['movecourseto'] = 'Kurzus áthelyezése ide:';
$string['movedown'] = 'Lejjebb';
$string['movefilestohere'] = 'Állományok áthelyezése ide';
$string['movefull'] = '{$a} áthelyezése ide';
$string['movehere'] = 'Áthelyezés ide';
$string['moveitemdown'] = '{$a} mozgatása lefelé';
$string['moveitemup'] = '{$a} mozgatása felfelé';
$string['moveleft'] = 'Mozgatás balra';
$string['moveright'] = 'Mozgatás jobbra';
$string['movesection'] = 'A(z) {$a} szekció áthelyezése';
$string['moveselectedcategoriesto'] = 'A kiválasztott kategóriák áthelyezése ide';
$string['moveselectedcoursesto'] = 'A kiválasztott kurzusok áthelyezése ...';
$string['movetoanotherfolder'] = 'Áthelyezés másik mappába';
$string['moveup'] = 'Feljebb';
$string['multipleitemsfound'] = 'Találat elemek száma: {$a}.';
$string['mustchangepassword'] = 'Az új jelszó nem lehet azonos a mostanival.';
$string['mustconfirm'] = 'Meg kell erősítenie a fiókját';
$string['mycourses'] = 'Kurzusaim';
$string['myfiles'] = 'Saját állományaim';
$string['myfilesmanage'] = 'Saját állományaim kezelése';
$string['myhome'] = 'Irányítópult';
$string['mymoodledashboard'] = 'Saját irányítópultom';
$string['myprofile'] = 'Profilom';
$string['name'] = 'Név';
$string['namedfiletoolarge'] = 'A(z) \'{$a->filename}\' állomány túl nagy, nem lehet feltölteni.';
$string['nameforlink'] = 'Mi legyen a hivatkozás neve?';
$string['nameforpage'] = 'Név';
$string['navigation'] = 'Navigáció';
$string['needed'] = 'Szükséges';
$string['networkdropped'] = 'Internetkapcsolata megbízhatatlan vagy megszakadt. Előfordulhat, hogy a módosítások mentése a kapcsolat helyreállításáig nem megfelelően történik majd.';
$string['never'] = 'Soha';
$string['neverdeletelogs'] = 'Soha ne törölje a naplókat';
$string['new'] = 'Új';
$string['newaccount'] = 'Új fiók';
$string['newactivityname'] = 'Új név a(z) {$a} tevékenységhez';
$string['newcourse'] = 'Új kurzus';
$string['newloginnotificationbodyfull'] = '<p>Üdvözöljük, {$a->userfullname}!</p>
<p>{$a->sitename} portálon lévő fiókjába új eszközzel léptek be.</p>
<ul>
<li>Fiókja: {$a->username} {$a->useremail}</li>
<li>{$a->logintime}</li>
<li>Eszköz: {$a->logindevice}</li>
<li>IP: {$a->loginip}</li>
</ul>
<p>Ha Ön lépett be, nincs teendője.</p>
<p>Ha nem ismeri fel a tevékenységet, <a href="{$a->changepasswordlink}">módosítsa jelszavát!</a></p>';
$string['newloginnotificationbodysmall'] = '{$a} fiókjába új eszközzel léptek be';
$string['newloginnotificationtitle'] = '{$a} fiókjába új belépés történt';
$string['newpassword'] = 'Új jelszó';
$string['newpassword_help'] = 'A jelenlegi jelszó megtartásához hagyja üresen.';
$string['newpasswordfromlost'] = '<strong>FIGYELEM:</strong> A <strong>jelenlegi jelszavát</strong> a jelszóvisszanyerés során az elküldendő két e-mail közül a <strong>másodikban<strong/> küldjük el Önnek. A képernyőn való továbblépés előtt ellenőrizze, megkapta-e cserejelszavát.';
$string['newpasswordtext'] = 'Üdvözöljük, {$a->firstname}! Az Ön jelszava a(z) \'{$a->sitename}\' portálon megváltozott és egy új, ideiglenes jelszót kapott. A jelenlegi belépési információi: felhasználónév: {$a->username}, jelszó: {$a->newpassword}. Kérjük, a jelszó megváltoztatásához térjen át erre az oldalra: {$a->link}. Általában a levelező programokban ez kék hivatkozásként jelenik meg, amelyre csak kattintania kell. Ha ez nem működik, másolja ki a címet a böngészőablak tetején lévő címsorba. Üdvözlettel: \'{$a->sitename}\' rendszergazda, {$a->signoff}';
$string['newpicture'] = 'Új kép';
$string['newpicture_help'] = 'Új kép feltöltéséhez válasszon egy JPG vagy PNG formátumban lévő képet, majd kattintson a "Profil frissítése" gombra. A kép négyzet alakú és 100 x 100 képernyőpont méretű lesz.';
$string['newpictureusernotsetup'] = 'Profilkép csak akkor adható hozzá, ha minden szükséges profiladatot elmentett.';
$string['newsectionname'] = 'A(z)  {$a} szakasz új címe\'';
$string['newsitem'] = 'hír';
$string['newsitems'] = 'hírek';
$string['newsitemsnumber'] = 'Hírek száma';
$string['newsitemsnumber_help'] = 'A Közlemények fórumban alapértelmezett kötelező feliratkozás van beállítva. Csak a megfelelő engedéllyel rendelkező tanárok és más felhasználók posztolhatnak benne.

Ha nincs szüksége bejelentési fórumra, állítsa ezt nullára.

Ez a beállítás azt is meghatározza, hogy hány legutóbbi közlemény jelenjen meg a legutóbbi közlemények blokkban.';
$string['newuser'] = 'Új felhasználó';
$string['newusernewpasswordsubj'] = 'Új fiók';
$string['newusernewpasswordtext'] = 'Üdvözöljük, {$a->firstname}!

A(z) \'{$a->sitename}\' portálon egy új felhasználói fiókot kapott.

   Felhasználónév: {$a->username}
   Jelszó: {$a->newpassword}

(Első bejelentkezésekor a jelszót meg kell változtatnia.)

A(z)  \'{$a->sitename}\' használatához jelentkezzen be itt:
   {$a->link}

Ha segítségre van szüksége, forduljon a rendszergazdához:
{$a->signoff}';
$string['newusers'] = 'Új felhasználók';
$string['newwindow'] = 'Új ablak';
$string['next'] = 'Következő';
$string['nextpage'] = 'Következő oldal';
$string['nextsection'] = 'Következő szekció';
$string['no'] = 'Nem';
$string['noblockstoaddhere'] = 'Nincs az oldalhoz hozzáadható blokk.';
$string['nobody'] = 'Senki';
$string['nochange'] = 'Nincs változás';
$string['nocomments'] = 'Nincs megjegyzés.';
$string['nocourses'] = 'Nincs kurzus';
$string['nocoursesfound'] = 'A \'{$a}\' szavakkal nincsenek kurzusok';
$string['nocoursestarttime'] = 'A kurzusnak nincs kezdési időpontja.';
$string['nocoursesyet'] = 'Ebben a kategóriában nincsenek kurzusok';
$string['nodstpresets'] = 'A rendszergazda nem kapcsolta be a nyári időszámítás használatát.';
$string['nofilesselected'] = 'A helyreállításhoz nincs fájl kiválasztva';
$string['nofilesyet'] = 'A kurzusához még nincsenek feltöltve állományok.';
$string['nofiltersapplied'] = 'Nincsenek szűrők';
$string['nograde'] = 'Nincs értékelés';
$string['nohelpforactivityorresource'] = 'A tananyaghoz vagy tevékenységhez nincs súgó';
$string['noimagesyet'] = 'A kurzusához még nincsenek képek feltöltve.';
$string['noitemsfound'] = 'Nem található ilyen elem.';
$string['nologsfound'] = 'Nincsenek naplók';
$string['nomatchingusers'] = 'Nincs {$a} szerint megfelelő felhasználó';
$string['nomorecourses'] = 'Nincs több ennek megfelelő kurzus';
$string['nomoreidnumber'] = 'Nem használ azonosítószámot az ütközések elkerülésére';
$string['none'] = 'Nincs';
$string['noneditingteacher'] = 'Nem szerkesztő tanár';
$string['noneditingteacherdescription'] = 'A nem szerkesztő tanárok taníthatnak a kurzusokban és értékehetnek tanulókat, de a tevékenységeket nem módosíthatják.';
$string['nonstandard'] = 'Nem standard';
$string['nopendingcourses'] = 'Nincs jóváhagyásra váró kurzus';
$string['nopotentialadmins'] = 'Nincs lehetséges rendszergazda';
$string['nopotentialcreators'] = 'Nincs lehetséges kurzuskészítő';
$string['nopotentialstudents'] = 'Nincs lehetséges tanuló';
$string['nopotentialteachers'] = 'Nincs lehetséges tanár';
$string['norecentactivity'] = 'Nincs újabb tevékenység';
$string['noreplybouncemessage'] = 'Választ nem váró e-mail címre válaszolt. Ha fórumra próbált választ küldeni, használja ehelyett a(z) {$a} fórumokat. E-mailjének tartalma:';
$string['noreplybouncesubject'] = '{$a} - visszapattanó e-mail.';
$string['noreplyname'] = 'Ne válaszoljon erre az e-mailre';
$string['noresetrecord'] = 'Nincs adat a visszaállítási kérelemről. Indítson új jelszó-visszaállítási kérelmet.';
$string['noresults'] = 'Nincs eredmény';
$string['noresultsfor'] = 'Nincs találat a következőre: "{$a}"';
$string['normal'] = 'Szokásos';
$string['normalfilter'] = 'Szokásos keresés';
$string['nosite'] = 'Nem található portálszintű kurzus';
$string['nostudentsfound'] = 'Nincs {$a}';
$string['nostudentsingroup'] = 'Ebben a csoportban még nincsenek tanulók';
$string['nostudentsyet'] = 'Ebbe a kurzusba még nem iratkoztak be tanulók';
$string['nosuchemail'] = 'Nincs ilyen e-mail cím';
$string['notavailable'] = 'Nem vehető fel';
$string['notavailablecourse'] = '{$a} nem elérhető';
$string['noteachersyet'] = 'Ehhez a kurzushoz még nincsenek tanárok';
$string['noteachingupcomingcourses'] = 'A soron következő kurzusokhoz nincs tanár vagy tanuló';
$string['notenrolled'] = '{$a} nem vette fel ezt a kurzust.';
$string['notenrolledprofile'] = 'Ez a profil nem elérhető, mert a felhasználó nem vette fel a kurzust.';
$string['noteusercannotrolldatesoncontext'] = '<strong>Megjegyzés:</strong> A biztonsági mentés visszaállításához nem görgethetők a dátumok, mert nincs meg ehhez az engedélye.';
$string['noteuserschangednonetocourse'] = '<strong>Megjegyzés:<strong> a kurzus felhasználói azonosítóit a felhasználói adatok (tevékenységekben, állományokban vagy üzenetekben való) helyreállítása során vissza kell állítani. Ezt a beállítást megváltoztattuk Önnek.';
$string['nothingnew'] = 'Nincs jelenlegi tevékenység.';
$string['nothingtodisplay'] = 'Nincs mit megjeleníteni';
$string['notice'] = 'Tájékoztatás';
$string['noticenewerbackup'] = 'Ez a biztonsági mentés a Moodle {$a->backuprelease} ({$a->backupversion}) verziójával készült, amely újabb a most telepített Moodle {$a->serverrelease} ({$a->serverversion}) szerververziónál. Ezért némi eltérés fordulhat elő, mert a mentett állományok kompatibilitása visszafelé nem garantálható.';
$string['notifications'] = 'Értesítések';
$string['notifyloginfailuresmessage'] = '{$a->time}, IP: {$a->ip}, felhasználó: {$a->info}. Teljes neve: {$a->name}';
$string['notifyloginfailuresmessageend'] = 'Itt tekintheti meg ezeket a naplókat:
{$a}';
$string['notifyloginfailuresmessagestart'] = 'A(z) {$a} sikertelen belépési kísérleteinek felsorolása az Ön utolsó értesítése óta';
$string['notifyloginfailuressubject'] = '{$a} :: értesítés sikertelen belépésekről';
$string['notincluded'] = 'Nincs felvéve';
$string['notingroup'] = 'Az oldal megtekintéséhez egy csoporthoz kell tartoznia.';
$string['notpublic'] = 'Nem nyilvános!';
$string['nousersfound'] = 'Nincs felhasználó';
$string['nousersmatching'] = 'Nincs \'{$a}\' szerint megfelelő felhasználó';
$string['nousersyet'] = 'Még nincsenek felhasználók';
$string['novalidcourses'] = 'Nem jeleníthetők meg érvényes kurzusok';
$string['now'] = 'most';
$string['numattempts'] = '{$a} sikertelen belépés';
$string['numberofcourses'] = 'Kurzusok száma';
$string['numberweeks'] = 'Szekciók száma';
$string['numday'] = '{$a} nap';
$string['numdays'] = '{$a} nap';
$string['numhours'] = '{$a} óra';
$string['numletters'] = '{$a} betű';
$string['numminutes'] = '{$a} perc';
$string['nummonth'] = '{$a} hónap';
$string['nummonths'] = '{$a} hónap';
$string['numseconds'] = '{$a} másodperc';
$string['numviews'] = '{$a} nézet';
$string['numweek'] = '{$a} hét';
$string['numweeks'] = '{$a} hét';
$string['numwords'] = '{$a} szó';
$string['numyear'] = '{$a} év';
$string['numyears'] = '{$a} év';
$string['ok'] = 'Rendben';
$string['oldpassword'] = 'Jelenlegi jelszó';
$string['olduserdirectory'] = 'Ez a régi felhasználói könyvtár, a továbbiakban nincs rá szükség. Nyugodtan kitörölheti. A benne lévő állományok másolata átkerült az ÚJ felhasználói könyvtárba.';
$string['oneitemfound'] = 'Egy talált elem.';
$string['opendrawerblocks'] = 'Blokkfiók nyitása';
$string['opendrawerindex'] = 'Kurzusmutató megnyitása';
$string['opensinnewwindow'] = 'Nyitás új ablakban';
$string['operator_and'] = 'és';
$string['operator_andnot'] = 'és';
$string['operator_or'] = 'vagy';
$string['optional'] = 'opcionális';
$string['options'] = 'lehetőségek';
$string['order'] = 'Sorrend';
$string['originalpath'] = 'Eredeti útvonal';
$string['orphanedactivitiesinsectionno'] = 'Árván maradt tevékenységek ({$a} szakasz)';
$string['other'] = 'Más';
$string['outline'] = 'Vázlat';
$string['outlinereport'] = 'Vázlatos jelentés';
$string['page'] = 'Oldal';
$string['pagea'] = '{$a} oldal';
$string['pagedcontentnavigation'] = 'Oldalszám szerinti navigálás';
$string['pagedcontentnavigationactiveitem'] = 'Aktuális oldal: {$a}. oldal';
$string['pagedcontentnavigationitem'] = 'Áttérés a(z) {$a}. oldalra';
$string['pagedcontentpagingbaritemsperpage'] = '{$a} tétel megjelenítése oldalanként';
$string['pageheaderconfigablock'] = '{$a->fullname} egyik blokkjának a beállítása';
$string['pagepath'] = 'Oldal útvonala';
$string['pageshouldredirect'] = 'Az oldal automatikusan átirányítódik. Ha nem történik semmi, használja az alábbi Tovább gombot.';
$string['parentcategory'] = 'Szülőkategória';
$string['parentcoursenotfound'] = 'A főkurzus nem található!';
$string['parentfolder'] = 'Főkönyvtár';
$string['participants'] = 'Résztvevők';
$string['participantslist'] = 'Résztvevők felsorolása';
$string['participationratio'] = 'Részvételi arány';
$string['participationreport'] = 'Jelentés a részvételről';
$string['password'] = 'Jelszó';
$string['passwordchanged'] = 'A jelszó megváltozott';
$string['passwordextlink'] = 'Elveszett jelszavának visszanyeréséhez az alábbi hivatkozás áll rendelkezésre. Ezzel kilép a Moodle-ból.';
$string['passwordforgotten'] = 'Elfelejtett jelszó';
$string['passwordforgotteninstructions'] = 'Adatainak szerepelni kell a felhasználói adatbázisban. Az adott mezőben adja meg vagy a Moodle-felhasználói nevét, vagy a rögzített e-mail-címét. Mindkettőt nem kell megadnia.';
$string['passwordforgotteninstructions2'] = 'Jelszavának visszaállításához adja meg alább felhasználónevét vagy e-mail címét. Ha szerepel az adatbázisban, e-mailt küldünk az e-mail címére, melyben tájékoztatjuk, hogy léphet be ismét.';
$string['passwordpolicynomatch'] = 'Jelszava már nem felel meg a beállított jelszószabványnak.
 {$a}';
$string['passwordsdiffer'] = 'A jelszavak nem egyeznek';
$string['passwordset'] = 'Jelszava beállítva';
$string['path'] = 'Útvonal';
$string['pathnotexists'] = 'Az útvonal a szerverén nem létezik!';
$string['pathslasherror'] = 'Az elérési út nem végződhet perjellel!';
$string['paymentinstant'] = 'A fizetéshez és a perceken belüli beiratkozáshoz használja az alábbi gombot!';
$string['paymentpending'] = '(<small><b><u>{$a}</u></b> folyamatban</small>)';
$string['paymentrequired'] = 'Ebbe a kurzusba csak fizetés után léphet be';
$string['payments'] = 'Befizetések';
$string['paymentsorry'] = 'Köszönjük a befizetést! Amit a feldolgozás befejeződik, be tud majd lépni a(z) "{$a->fullname}" kurzusba. Kérjük, várjon, és próbálkozzon később! Ha továbbra is gondja támad, értesítse a(z) {$a->teacher}t vagy a portál rendszergazdáját.';
$string['paymentthanks'] = 'Köszönjük a befizetést! Sikerült beiratkoznia erre a kurzusra: {$a}.';
$string['pendingrequests'] = 'Folyamatban lévő kérések';
$string['percents'] = '{$a}%';
$string['periodending'] = 'Időtartam lejár ({$a})';
$string['perpage'] = 'Oldalanként';
$string['perpagea'] = 'Oldalanként: {$a}';
$string['personal'] = 'Személyes';
$string['personalprofile'] = 'Személyes profil';
$string['phone'] = 'Telefon';
$string['phone1'] = 'Telefon';
$string['phone2'] = 'Mobil';
$string['phpinfo'] = 'PHP-vel kapcsolatos infó';
$string['picture'] = 'Kép';
$string['pictureof'] = 'Kép';
$string['pictureofuser'] = 'Felhasználói kép';
$string['placeholdertypeorselect'] = 'Beírás vagy kiválasztás...';
$string['pleaseclose'] = 'Csukja be most az ablakot.';
$string['pleasesearchmore'] = 'Keressen még';
$string['pleaseusesearch'] = 'Használja fel a keresést';
$string['plugin'] = 'Segédprogram';
$string['pluginarea'] = 'Terület';
$string['plugincheck'] = 'Segédprogram ellenőrzése';
$string['plugindeletefiles'] = 'Az adatbázisból törlődött a segédprogramhoz \'{$a->name}\' kapcsolódó összes adat. A segédprogram újratelepülésének megelőzéséhez törölje szerveréről ezt a könyvtárat: {$a->directory}';
$string['pluginitemid'] = 'Tárgy azonosítója';
$string['pluginmissingfromdisk'] = '{$a->name} (Hiányzik a lemezről)';
$string['pluginsetup'] = 'Segédprogram-táblázatok beállítása';
$string['policyaccept'] = 'Megértettem és elfogadom';
$string['policyagree'] = 'A portál használatához el kell fogadnia a feltételeket. Elfogadja őket?';
$string['policyagreement'] = 'A portál használati feltételeiről szóló megállapodás';
$string['policyagreementclick'] = 'Portálhasználati feltételek';
$string['popup'] = 'előbukkanó';
$string['popupwindow'] = 'Állomány megnyitása új ablakban';
$string['popupwindowname'] = 'Előbukkanó ablak';
$string['post'] = 'Hozzászólás';
$string['posts'] = 'Hozzászólások';
$string['potentialadmins'] = 'Lehetséges rendszergazdák';
$string['potentialcreators'] = 'Lehetséges kurzuskészítők';
$string['potentialstudents'] = 'Lehetséges tanulók';
$string['potentialteachers'] = 'Lehetséges tanárok';
$string['poweredbymoodle'] = 'Szolgáltatja a <a href="https://moodle.com">Moodle</a>';
$string['preferences'] = 'Beállítások';
$string['preferredlanguage'] = 'Választott nyelv';
$string['preferredtheme'] = 'Választott stílus';
$string['preprocessingbackupfile'] = 'Biztonsági mentése előfeldolgozása';
$string['prev'] = 'Előző';
$string['preview'] = 'Előzetes megtekintés';
$string['previeworchoose'] = 'Egy stílus megtekintése vagy kiválasztása';
$string['previewthemename'] = '\'{$a}\' sablon előnézete';
$string['previous'] = 'Előző';
$string['previouslyselectedusers'] = 'A korábban kiválasztott felhasználók {$a} szerint nem felelnek meg.';
$string['previouspage'] = 'Előző oldal';
$string['previoussection'] = 'Előző szekció';
$string['primaryadminsetup'] = 'A rendszergazda fiókjának beállítása';
$string['privacy:metadata:config_log'] = 'Beállítási módosítások naplója.';
$string['privacy:metadata:config_log:name'] = 'Beállítási módosítások neve.';
$string['privacy:metadata:config_log:oldvalue'] = 'A beállítás előző értéke.';
$string['privacy:metadata:config_log:plugin'] = 'A módosított segédprogram.';
$string['privacy:metadata:config_log:timemodified'] = 'A módosítás időpontja.';
$string['privacy:metadata:config_log:userid'] = 'A módosítást végrehajtó felhasználó.';
$string['privacy:metadata:config_log:value'] = 'A beállítás új értéke.';
$string['privacy:metadata:events_queue'] = 'A feldolgozásra váró felhasználói események sora.';
$string['privacy:metadata:events_queue:eventdata'] = 'Az eseményben tárolt adatok.';
$string['privacy:metadata:events_queue:stackdump'] = 'Az eseményhez kapcsolódó esetleges veremkivonat.';
$string['privacy:metadata:events_queue:timecreated'] = 'Az esemény létrehozásának időpontja.';
$string['privacy:metadata:events_queue:userid'] = 'Az eseményhez kapcsolódó felhasználói azonosító';
$string['privacy:metadata:log'] = 'Korábbi események gyűjteménye';
$string['privacy:metadata:log:action'] = 'A lépés leírása';
$string['privacy:metadata:log:cmid'] = 'cmid';
$string['privacy:metadata:log:course'] = 'kurzus';
$string['privacy:metadata:log:info'] = 'További adatok';
$string['privacy:metadata:log:ip'] = 'Az esemény időpontjában használt IP-cím';
$string['privacy:metadata:log:module'] = 'modul';
$string['privacy:metadata:log:time'] = 'A lépés ideje';
$string['privacy:metadata:log:url'] = 'Az eseményhez kapcsolódó webcím';
$string['privacy:metadata:log:userid'] = 'A lépést végrehajtó felhasználó azonosítója';
$string['privacy:metadata:moodlenet_share_progress'] = 'MoodleNet megosztás előrehaladás részletei';
$string['privacy:metadata:moodlenet_share_progress:cmid'] = 'A társított kurzusmodul azonosítója';
$string['privacy:metadata:moodlenet_share_progress:courseid'] = 'A társított kurzusazonosító';
$string['privacy:metadata:moodlenet_share_progress:resourceurl'] = 'A sikeres megosztás után kapott URL a MoodleNettől';
$string['privacy:metadata:moodlenet_share_progress:status'] = 'A megosztás eredményeként kapott állapot';
$string['privacy:metadata:moodlenet_share_progress:timecreated'] = 'A megosztás végrehajtásának ideje';
$string['privacy:metadata:moodlenet_share_progress:type'] = 'A végrehajtott megosztás típusa';
$string['privacy:metadata:moodlenet_share_progress:userid'] = 'A megosztást végrehajtó felhasználó';
$string['privacy:metadata:oauth2_refresh_token'] = 'Az OAuth 2.0 kommunikáció során használt token frissítése';
$string['privacy:metadata:oauth2_refresh_token:issuerid'] = 'A tokennek megfelelő kiadó azonosítója';
$string['privacy:metadata:oauth2_refresh_token:scopehash'] = 'A tokennek megfelelő felhasználó azonosítója';
$string['privacy:metadata:oauth2_refresh_token:timecreated'] = 'A token létrehozásának időpontja';
$string['privacy:metadata:oauth2_refresh_token:timemodified'] = 'A token utolsó frissítésének időpontja';
$string['privacy:metadata:oauth2_refresh_token:token'] = 'Az adott hatókörökhöz és felhasználóhoz tartozó frissítési token';
$string['privacy:metadata:oauth2_refresh_token:userid'] = 'A tokennek megfelelő felhasználó azonosítója';
$string['privacy:metadata:task_adhoc'] = 'Alkalmi feladatok állapota.';
$string['privacy:metadata:task_adhoc:component'] = 'A feladattal rendelkező összetevő.';
$string['privacy:metadata:task_adhoc:nextruntime'] = 'A feladat végrehajtásának legkorábbi időpontja.';
$string['privacy:metadata:task_adhoc:userid'] = 'A feladatot ekként végrehajtó felhasználó.';
$string['privacy:metadata:task_log'] = 'Naplózási kimenet';
$string['privacy:metadata:task_log:component'] = 'A feladathoz tartozó összetevő';
$string['privacy:metadata:task_log:userid'] = 'A felhasználó, akihez a feladat tartozott.';
$string['privacy:metadata:upgrade_log'] = 'A frissítési napló.';
$string['privacy:metadata:upgrade_log:backtrace'] = 'A frissítési lépéshez kapcsolódó esetleges előzmény.';
$string['privacy:metadata:upgrade_log:details'] = 'A frissítéshez kapcsolódó külön adatok.';
$string['privacy:metadata:upgrade_log:info'] = 'Ezen frissítési lépés fő adatai.';
$string['privacy:metadata:upgrade_log:plugin'] = 'A frissített segédprogram.';
$string['privacy:metadata:upgrade_log:targetversion'] = 'Az új frissítési verzió.';
$string['privacy:metadata:upgrade_log:timemodified'] = 'A frissítéssel töltött idő.';
$string['privacy:metadata:upgrade_log:type'] = 'A naplóbejegyzés típusa.';
$string['privacy:metadata:upgrade_log:userid'] = 'A frissítést lefuttató felhasználó.';
$string['privacy:metadata:upgrade_log:version'] = 'A segédprogram korábbi verziója.';
$string['private_files_handler'] = 'E-mail csatolmányok tárolása a felhasználó saját állományainak tárhelyén.';
$string['private_files_handler_name'] = 'E-mail küldése a Saját állományokhoz';
$string['privatefiles'] = 'Saját állományaim';
$string['privatefilesmanage'] = 'Saját állományaim kezelése';
$string['proceed'] = 'Tovább';
$string['profile'] = 'Profil';
$string['profilenotshown'] = 'A profilleírás mindaddig nem jelenik meg, amíg az adott személy legalább egy kurzust fel nem vesz.';
$string['progress'] = 'Előrehaladás';
$string['publicprofile'] = 'Nyilvános profil';
$string['publicsitefileswarning'] = 'Megjegyzés: az ide kerülő állományokat bárki elérheti';
$string['publicsitefileswarning2'] = 'Megjegyzés: az ide kerülő állományokat bárki elérheti, aki ismeri (vagy kitalálja) a webcímet. Biztonsági okokból ajánlatos helyreállítás után törölni az összes biztonsági mentést.';
$string['publicsitefileswarning3'] = 'Megjegyzés: Az itteni állományokat bárki elérheti, ha ismeri (vagy kitalálja) a webcímet. <br />A biztonság érdekében a biztonsági mentés állományait kizárólag a biztonságos Biztonsági mentések mappában tárolja.';
$string['question'] = 'Kérdés';
$string['questionsinthequestionbank'] = 'Kérdés a kérdésbankban';
$string['queued'] = 'Várólistán';
$string['quotausage'] = 'Összesen {$a->total} egységből {$a->used}-t használt fel.';
$string['readinginfofrombackup'] = 'Információk kiolvasása biztonsági mentésből';
$string['readme'] = 'OLVASS_EL';
$string['recentactivity'] = 'Utóbbi tevékenység';
$string['recentactivityreport'] = 'Teljes jelentés a legutóbbi tevékenységről...';
$string['recipientslist'] = 'Címzettek felsorolása';
$string['recommended'] = 'Ajánlott';
$string['recreatedcategory'] = '{$a} kategória újból létrehozva';
$string['redirect'] = 'Átirányítás';
$string['reducesections'] = 'Szakaszszám csökkentése';
$string['refresh'] = 'Szerkesztés';
$string['refreshingevents'] = 'Események frissítése';
$string['registration'] = 'Moodle-regisztráció';
$string['registrationcontact'] = 'Általános kapcsolatfelvétel';
$string['registrationcontactno'] = 'Nem akarom, hogy kapcsolatba lépjenek velem';
$string['registrationcontactyes'] = 'Igen, a Moodle többi használója számára adjanak meg űrlapot az elérhetőségemmel.';
$string['registrationemail'] = 'Értesítések e-mailben';
$string['registrationinfo'] = '<p>Ezen az oldalon regisztrálhatja Moodle-portálját a moodle.org címen. A regisztráció ingyenes. A regisztráció fő előnye, hogy felkerül egy alacsony forgalmú levelező listára, amelyben olyan fontos értesítéseket kap, mint pl. a biztonsági figyelmeztetések vagy a Moodle új változatai. </p><p>Alapesetben az Önről szóló információkat nem szolgáltatjuk ki, nem értékesítjük, és senki másnak nem adjuk át. Ezen információk összegyűjtése kizárólag a támogatást és a globális Moodle-közösséggel kapcsolatos statisztika céljait szolgálja.</p><p> Ha úgy dönt, hozzáférhetővé teheti portálja, országa nevét és a webcímet a Moodle-portálok nyilvános jegyzéke számára. Minden új regisztrációt kézzel ellenőrzünk, mielőtt a jegyzékbe felvesszük. Felvétel után viszont lehetősége lesz arra, hogy saját regisztrációját (és a nyilvános jegyzékben szereplő adatait) a jelen űrlap újbóli leadásával bármikor frissítse.</p>';
$string['registrationinfotitle'] = 'Regisztrációs Információk';
$string['registrationsend'] = 'Regisztrációs információk elküldése a moodle.org részére';
$string['registrationyes'] = 'Igen, értesítsenek a fontosabb (pl. biztonsági és változatokra vonatkozó) hírekről';
$string['reject'] = 'Elutasít';
$string['rejectdots'] = 'Elutasít...';
$string['relativedatesmode'] = 'Viszonyított dátummód';
$string['relativedatesmode_help'] = 'Kurzus vagy tevékenységek dátumainak megjelenítése a felhasználó kurzuskezdéséhez viszonyítva.<br />A felhasználó kurzuskezdése a kurzusfelvétel kezdő dátuma, kivéve, ha a kurzus kezdete előtt már beiratkozott, mely esetben a kezdő dátum a kurzus kezdő dátuma lesz.<br/>FIGYELEM: A funkció kísérleti jellegű, előfordulhat, hogy nem minden tevékenység támogatja. A kurzus létrehozása után ez a kurzusbeállítás többé nem módosítható!';
$string['relativedatesmode_warning'] = '<strong>FIGYELEM:</strong> A viszonyított dátummód a kurzus létrehozása után nem módosítható!';
$string['reload'] = 'Újbóli betöltés';
$string['remoteappuser'] = 'Távoli {$a} felhasználó';
$string['remove'] = 'Törlés';
$string['removeadmin'] = 'Rendszergazda törlése';
$string['removecreator'] = 'Kurzuskészítő törlése';
$string['removed'] = '{$a} törölve';
$string['removestudent'] = 'Tanuló törlése';
$string['removeteacher'] = 'Tanár törlése';
$string['rename'] = 'Átnevezés';
$string['renamefileto'] = '{$a} átnevezése a következőre:';
$string['report'] = 'Jelentés';
$string['reports'] = 'Jelentések';
$string['reporttype'] = 'Jelentés típusa';
$string['repositories'] = 'Tárhelyek';
$string['requestcourse'] = 'Kurzus kérelmezése';
$string['requestedby'] = 'Kérelmező';
$string['requestedcourses'] = 'Kérelmezett kurzusok';
$string['requestreason'] = 'Kurzus kérelmezésének oka';
$string['requests'] = 'Kérések';
$string['required'] = 'Kitöltendő';
$string['requirespayment'] = 'A kurzus csak fizetés ellenében érhető el';
$string['resendemail'] = 'Jóváhagyó e-mail újbóli elküldése';
$string['reset'] = 'Visszaállítás';
$string['resetcomponent'] = 'Összetevő';
$string['resetcourse'] = 'Kurzus visszaállítása';
$string['resetcourseconfirm'] = 'Kurzus újraindítása?';
$string['resetcoursewarning'] = 'Biztosan vissza szeretné állítani a(z) \'{$a}\' kurzust? <br/><br/> Ez törli a kiválasztott adatokat, és visszaállítja a kurzust az eredeti állapotába. Ezt a műveletet nem lehet visszavonni.';
$string['resetinfo'] = 'Ezzel a funkcióval minden felhasználói adatot törölhet és visszaállíthatja a kurzust az eredeti állapotába. A kurzus tevékenységei és beállításai nem változnak.';
$string['resetinfoselect'] = 'Válassza ki az alábbi kategóriákból azokat az adatokat, amelyeket törölni vagy visszaállítani szeretne:';
$string['resetnotimplemented'] = 'A visszaállítás nem támogatott';
$string['resetnotimplementedinfo'] = 'Ezek a tevékenységek nem állíthatók vissza:';
$string['resetrecordexpired'] = 'A  jelszó-visszaállítási kérelme {$a} percnél régebbi, ezért lejárt. Indítson új jelszó-visszaállítási kérelmet.';
$string['resetstartdate'] = 'Kezdési idő visszaállítása';
$string['resetstatus'] = 'Állapot';
$string['resettable'] = 'Táblabeállítások visszaállítása';
$string['resettask'] = 'Visszaállítás';
$string['resettodefaults'] = 'Alapbeállítások visszaállítása';
$string['resortcourses'] = 'Kurzusok rendezése';
$string['resortsubcategoriesby'] = 'Alkategóriák rendezése növekvő {$a} szerint';
$string['resortsubcategoriesbyreverse'] = 'Alkategóriák rendezése csökkenő {$a} szerint';
$string['resource'] = 'Tananyag';
$string['resource_type'] = 'Tananyag típus';
$string['resourcedisplayauto'] = 'Automatikus';
$string['resourcedisplaydownload'] = 'Letöltés előírása';
$string['resourcedisplayembed'] = 'Beágyazás';
$string['resourcedisplayframe'] = 'Keretben';
$string['resourcedisplaynew'] = 'Új ablak';
$string['resourcedisplayopen'] = 'Megnyitás';
$string['resourcedisplaypopup'] = 'Előbukkanó ablakban';
$string['resources'] = 'Tananyagok';
$string['resources_help'] = 'A tananyagtípusokkal csaknem mindenféle webes tartalmat beilleszthet a kurzusba.';
$string['restore'] = 'Helyreállítás';
$string['restorecancelled'] = 'A helyreállítás törölve';
$string['restorecannotassignroles'] = 'A helyreállításhoz szerepeket kell hozzárendelni, ám ehhez nincs meg a jogosultsága.';
$string['restorecannotcreateorassignroles'] = 'A helyreállításhoz szerepeket kell létrehozni vagy hozzárendelni, ám ehhez nincs meg a jogosultsága.';
$string['restorecannotcreateuser'] = 'A helyreállításhoz a mentett állományból a(z) \'{$a}\' felhasználót létre kell hozni, Önnek azonban nincs ehhez jogosultsága';
$string['restorecannotoverrideperms'] = 'A helyreállításhoz jogosultságokat kell felülírnia, ám ehhez nincs meg a jogosultsága.';
$string['restorecoursenow'] = 'A kurzus helyreállítása most!';
$string['restoredaccount'] = 'Helyreállít fiók';
$string['restoredaccountinfo'] = 'A fiók másik szerverről került át, a jelszó pedig elveszett. Új jelszó e-mailen keresztüli beállításához kattintson a "Tovább" gombra';
$string['restorefinished'] = 'A helyreállítás sikerült';
$string['restoreinfo'] = 'Használjja a megfelelő fájlt egy korábbi biztonsági mentésből a kurzus verzió visszaállításához vagy egy új kurzus létrehozásához.';
$string['restoremnethostidmismatch'] = '\'{$a}\' felhasználó MNet-hez tartozó gazda-azonosítója nem egyezik a helyivel.';
$string['restoreto'] = 'Helyreállítás helye';
$string['restoretositeadding'] = 'Figyelmeztetés: a portál kezdőoldalát fogja helyreállítani és adatokat hozzáadni!';
$string['restoretositedeleting'] = 'Figyelmeztetés: a portál kezdőoldalát készül helyreállítani és onnan először adatokat fog törölni!';
$string['restoreuserconflict'] = 'Ha a mentett állományból a(z) \'{$a}\' felhasználót megpróbálja helyreállítani, az ütközéshez vezet.';
$string['restoreuserinfofailed'] = 'A helyreállítás leállt, mert Önnek nincs engedélye felhasználói adatok helyreállításához';
$string['restoreusersprecheck'] = 'Felhasználói adatok ellenőrzése';
$string['restoreusersprecheckerror'] = 'Felhasználói adatok ellenőrzése közben gondok merültek föl';
$string['restricted'] = 'Korlátozott';
$string['resultsfound'] = '{$a} találat';
$string['retry'] = 'Újbóli próbálkozás';
$string['returningtosite'] = 'Visszatér erre a portálra?';
$string['returntooriginaluser'] = 'Visszatérés ide: {$a}';
$string['revert'] = 'Visszatérés';
$string['role'] = 'Szerep';
$string['roleassignments'] = 'Szerepek hozzárendelései';
$string['rolemappings'] = 'Szerepek kiosztása';
$string['rolerenaming'] = 'Szerep átnevezése';
$string['rolerenaming_help'] = 'Módosítsa a szerepek megjelenített nevét ebben a kurzusban.';
$string['rolerenaming_success'] = 'A kurzus szerepek nevei frissítve.';
$string['roles'] = 'Szerepek';
$string['rss'] = 'RSS';
$string['rssarticles'] = 'Újabb RSS-hírek száma';
$string['rsserror'] = 'Hiba RSS-adatok olvasása közben';
$string['rsserrorauth'] = 'RSS-hivatkozásában nincs érvényes hitelesítési token';
$string['rsserrorguest'] = 'A hír az adatok eléréséhez vendégjogokat használ, de a vendég nem jogosult az adatok olvasására. Jogosult felhasználóként látogasson el a hír eredeti helyére (URL) és szerezzen be egy új RSS-hivatkozást.';
$string['rsskeyshelp'] = '<p>A biztonság és a titoktartás érdekében az RSS-hírek webcímeiben egy speciális token szerepel, amely azonosítja az érintett felhasználót. Ily módon más felhasználók nem férhetnek hozzá a Moodle olyan területeihez, amelyeket RSS-híreken keresztül nem érhetnek el.</p><p>
Ez a token automatikusan jön létre a Moodle RSS-hírt létrehozó területének első elérésekor. Ha úgy véli, a tokennel valamilyen visszaélés történt, kérhet egy újat, ha rákattint a Reset (Visszaállítás) hivatkozásra. Ne feledje, hogy ez esetben mostani RSS-híreinek webcímei érvénytelenek lesznek.</p>';
$string['rsstype'] = 'RSS-hírek ehhez a tevékenységhez';
$string['save'] = 'Mentés';
$string['saveandnext'] = 'Mentés és a következő megjelenítése';
$string['savechanges'] = 'Módosítások mentése';
$string['savechangesanddisplay'] = 'Módosítások mentése és a változások megtekintése';
$string['savechangesandreturn'] = 'Mentés és visszatérés';
$string['savechangesandreturntocourse'] = 'Módosítások mentése és visszatérés a kurzushoz';
$string['savecomment'] = 'Megjegyzés mentése';
$string['savedat'] = 'Mentés időpontja:';
$string['savepreferences'] = 'Beállítások mentése';
$string['saveto'] = 'Mentés helye';
$string['scale'] = 'Skála';
$string['scale_help'] = 'A skála lehetővé teszi a teljesítmény minősítését vagy értékelését egy tevékenységnél. Magát a skálát egymástól vesszővel elválasztott, negatívtól pozitívig terjedő értékek egy rendezett listája határozza meg. Például: „Csalódást keltő, Nem elég jó, Átlagos, Jó, Nagyon jó, Kiváló!”';
$string['scale_link'] = 'grade/scale';
$string['scales'] = 'Skálák';
$string['scalescustom'] = 'Saját skálák';
$string['scalescustomcreate'] = 'Új skála hozzáadása';
$string['scalescustomno'] = 'Nincsenek még létrehozva saját skálák';
$string['scalesstandard'] = 'Standard skálák';
$string['scalestandard'] = 'Standard skála';
$string['scalestandard_help'] = '<p>A standard skála az egész portálon, minden kurzusban használható skála.</p>';
$string['scalestandard_link'] = 'grade/scale';
$string['scalestip'] = 'Saját skálák használatához a kurzusadminisztrációs menüből válassza ki a \'Skálák ...\' menüpontot.';
$string['scalestip2'] = 'Egyedi skálák létrehozásához kattintson a kurzusadminisztrációs menüben az Értékelések menüpontra, majd válassza a Szerkesztés, Skálák pontot.';
$string['schedule'] = 'Ütemezés';
$string['screenshot'] = 'Képernyőkép';
$string['search'] = 'Keresés';
$string['search_help'] = 'A szövegben való kereséshez írja be a szavakat szóközökkel elválasztva. Minden két karakternél hosszabb szót felhasznál a rendszer.

Részletes kereséshez a részletes keresés űrlapjára áttérhet, ha megnyomja a Keresés gombot, de a keresőnégyzetet üresen hagyja';
$string['searchactivities'] = 'Tevékenységre keresés név vagy leírás alapján';
$string['searchagain'] = 'Keresés ismétlése';
$string['searchbyemail'] = 'Keresés e-mail cím alapján';
$string['searchbyusername'] = 'Keresés felhasználónév alapján';
$string['searchcoursecategories'] = 'Keresés a kategóriák között';
$string['searchcourses'] = 'Kurzusok keresése';
$string['searchgroups'] = 'Csoportok keresése';
$string['searchitems'] = 'Elemek keresése';
$string['searchoptions'] = 'Keresés beállításai';
$string['searchresults'] = 'Keresési eredmények';
$string['searchusers'] = 'Felhasználók keresése';
$string['sec'] = 'mp';
$string['seconds'] = 'másodperc';
$string['secondsleft'] = '{$a}  mp';
$string['secondstotime172800'] = '2 nap';
$string['secondstotime259200'] = '3 nap';
$string['secondstotime345600'] = '4 nap';
$string['secondstotime432000'] = '5 nap';
$string['secondstotime518400'] = '6 nap';
$string['secondstotime604800'] = '1 hét';
$string['secondstotime86400'] = '1 nap';
$string['secretalreadyused'] = 'A módosult jelszó megerősítési hivatkozását már használták, a jelszó nem módosult.';
$string['secs'] = 'mp';
$string['section'] = 'Szekció';
$string['sectionactionnotsupported'] = 'A(z) "{$a}" itt nincs támogatva';
$string['sectionname'] = 'Szekció neve';
$string['sectionoutline'] = 'Szekció vázlat';
$string['sections'] = 'Szekciók';
$string['seealsostats'] = 'Lásd még: statisztika';
$string['selctauser'] = 'Válasszon felhasználót';
$string['select'] = 'Kiválasztás';
$string['selectacategory'] = 'Válasszon kategóriát';
$string['selectacountry'] = 'Válasszon egy országot';
$string['selectacourse'] = 'Válasszon kurzust';
$string['selectacoursesite'] = 'Válasszon kurzust vagy portált';
$string['selectagroup'] = 'Válasszon csoportot';
$string['selectall'] = 'Az összes kiválasztása';
$string['selectallusersonpage'] = 'Az oldalon lévő összes felhasználó kiválasztása';
$string['selectalluserswithcount'] = 'Minden {$a} felhasználó kiválasztása';
$string['selectamodule'] = 'Válasszon tevékenységmodult';
$string['selectanaction'] = 'Válasszon lépést';
$string['selectanoptions'] = 'Válasszon egyet';
$string['selectaregion'] = 'Válasszon egy területet';
$string['selectcategorysort'] = 'Melyik kategóriákat kívánja rendezni?';
$string['selectcategorysortby'] = 'Hogyan kívánja a kategóriákat rendezni?';
$string['selectcoursesortby'] = 'Hogyan kívánja a kurzusokat rendezni?';
$string['selectdates'] = 'Dátumok kiválasztása';
$string['selectdefault'] = 'Alapértelmezett kiválasztása';
$string['selectedcategories'] = 'Kiválasztott kategóriák';
$string['selectedfile'] = 'Kiválasztott állomány';
$string['selectednowmove'] = '{$a} állomány áthelyezésre kiválasztva. Térjen át a célkönyvtárra és nyomja meg az \'Állományok áthelyezése ide\' gombot';
$string['selectfiles'] = 'Válasszon ki állományokat.';
$string['selectfiltertype'] = 'Kiválasztás';
$string['selectgroupsseparate'] = 'Válasszon külön csoportokat';
$string['selectgroupsvisible'] = 'Válassza ki a látható csoportokat';
$string['selectitem'] = '\'{$a}\' kijelölésének törlése';
$string['selectmoduletoviewhelp'] = 'Válasszon ki egy tevékenységet vagy tananyagot a súgója megtekintéséhez.';
$string['selectnos'] = 'Minden \'Nem\' kiválasztása';
$string['selectperiod'] = 'Időszak kiválasztása';
$string['selecttheme'] = 'Stílus kiválasztása';
$string['selectthemename'] = 'A választott sablon \'{$a}\'';
$string['senddetails'] = 'Adataim elküldése e-mailben';
$string['sent'] = 'Küldött';
$string['separate'] = 'Különálló';
$string['separateandconnected'] = 'Különálló és kapcsolt ismeretek';
$string['separateandconnected1'] = 'Főként elkülönült ismeretet tartalmaz';
$string['separateandconnected2'] = 'Elkülönült és kapcsolt ismeretet is tartalmaz';
$string['separateandconnected3'] = 'Főként kapcsolt ismeretet tartalmaz';
$string['separateandconnectedinfo'] = 'A skála az elkülönülő és a kapcsolt tudás elméletén alapszik. Ennek megfelelően az általunk látott és hallott dolgokról kétféleképpen szerezhetünk ismereteket.
<ul><li>Az <strong>elkülönülő tudás</strong> a lehető legobjektívebb marad, az érzelmek kirekesztésével. Másokkal való vita során szereti a mások érvelésében fellelt logikai lyukak kihasználásával megvédeni saját elképzelését.</li><li>A <strong>kapcsolt tudás</strong> fogékonyabb másokra. Empatikus, odafigyel és kérdez, amíg úgy nem érzi, össze tudja kapcsolni véleményét "mások szemszögének a felismerésével". A másokban felfedezett ismerethez vezető tapasztalat megosztásával próbál ismeretekre szert tenni.</li></ul>';
$string['servererror'] = 'Hiba történt a szerverrel való kommunikáció közben';
$string['serverlocaltime'] = 'Szerveridő';
$string['sessionforceclean'] = 'Biztonsági okokból a felhasználói kódok ki vannak iktatva a munkamenetből.';
$string['sessiontimeoutsoon'] = 'Munkamenete hamarosan lejár. Meghosszabbítja?';
$string['setcategorytheme'] = 'Kategóriastílus beállítása';
$string['setmode'] = 'Üzemmód beállítása';
$string['setpassword'] = 'Jelszó beállítása';
$string['setpasswordinstructions'] = 'Alább írja be az új jelszót, majd mentse el a módosításokat.';
$string['settings'] = 'Beállítások';
$string['share'] = 'Ossza meg';
$string['shortname'] = 'Rövid cím';
$string['shortnamecollisionwarning'] = '[*] = Ezt a rövid nevet már használja egy kurzus, ezért jóváhagyásakor meg kell változtatni';
$string['shortnamecourse'] = 'A kurzus rövid címe';
$string['shortnamecourse_help'] = 'A korlátozott helyű területeken megjelenő név. Egyedinek kell lennie.';
$string['shortnametaken'] = 'Ezt a rövid címet már egy másik kurzus használja ({$a})';
$string['shortnameuser'] = 'A felhasználó rövid neve';
$string['shortsitename'] = 'A portál rövid neve (pl. egy szó)';
$string['show'] = 'Mutat';
$string['showactions'] = 'Műveletek megtekintése';
$string['showactivitydates'] = 'Tevékenységek időpontjainak megjelenítése';
$string['showactivitydates_help'] = 'A tevékenység dátumainak megjelenítése a kurzus oldalon.';
$string['showadvancededitor'] = 'Részletes';
$string['showadvancedsettings'] = 'Részletes beállítások megjelenítése';
$string['showall'] = 'Minden {$a} megjelenítése';
$string['showallcourses'] = 'Minden kurzus megjelenítése';
$string['showblockcourse'] = 'Blokkot tartalmazó kurzusok felsorolásának megjelenítése';
$string['showcategory'] = '{$a} megjelenítése';
$string['showchartdata'] = 'Táblaadatok megjelenítése';
$string['showcomments'] = 'Megjegyzések megjelenítése/elrejtése';
$string['showcommentsnonjs'] = 'Megjegyzések megjelenítése';
$string['showdescription'] = 'Leírás megjelenítése a kurzusoldalon';
$string['showdescription_help'] = 'Bekapcsolása esetén a fenti leírás megjelenik a kurzusoldalon a tevékenység / tananyag hivatkozása alatt.';
$string['showgrades'] = 'Értékelésnapló megjelenítése a tanulók számára';
$string['showgrades_help'] = 'Engedélyezze a tanulóknak, hogy megtekintsék az összes értékelésüket a kurzusban';
$string['showingacourses'] = 'Mind a(z)  {$a} kurzus megjelenítése';
$string['showingxofycourses'] = 'Az összesen {$a->total} kurzusból {$a->start} -- {$a->end} kurzus megjelenítése';
$string['showless'] = 'Kevesebb';
$string['showlistofcourses'] = 'Tanfolyamok felsorolásának megjelenítése';
$string['showmodulecourse'] = 'Tevékenységet tartalmazó kurzusok felsorolásának megjelenítése';
$string['showmore'] = 'Több';
$string['showoncoursepage'] = 'Megjelenítés a kurzusoldalon';
$string['showonly'] = 'Csak megjelenítés';
$string['showperpage'] = 'Oldalanként {$a} megjelenítése';
$string['showpopoverwindow'] = 'Előtűnő ablak megjelenítése';
$string['showrecent'] = 'Legutóbbi tevékenység megjelenítése';
$string['showreports'] = 'Tevékenységjelentés megjelenítése';
$string['showreports_help'] = 'Lehetővé teszi a tanulóknak, hogy megtekintsék saját tevékenységi jelentéseiket a profiloldalukon.';
$string['showsettings'] = 'Beállítások megjelenítése';
$string['showtheselogs'] = 'Ezen naplók megjelenítése';
$string['showthishelpinlanguage'] = 'A súgó megjelenítése {$a} nyelven.';
$string['sidepanel'] = 'Oldalpanel';
$string['signoutofotherservices'] = 'Kijelentkezés minden webalkalmazásból';
$string['signoutofotherservices_help'] = 'Kijelentkezés minden olyan eszközről és rendszerből, amelyek a webszolgáltatásokat használják, mint például a mobilalkalmazás. A böngészős munkamenetek aktívak maradnak.';
$string['since'] = 'Mióta';
$string['sincelast'] = 'utolsó belépés óta';
$string['site'] = 'Portál';
$string['sitedefault'] = 'Portál alapbeállítása';
$string['sitedefaultspecified'] = 'Portál alapbeállítása ({$a})';
$string['siteerrors'] = 'Portálhibák';
$string['sitefiles'] = 'Portál állományai';
$string['sitefilesused'] = 'A portál ezen kurzusban használt állományai';
$string['sitehome'] = 'Portál kezdőoldala';
$string['sitelegacyfiles'] = 'Korábbi portálállományok';
$string['sitelogs'] = 'Portálnaplók';
$string['sitenews'] = 'Portálhírek';
$string['sitepages'] = 'Portáloldalak';
$string['sitepartlist'] = 'Nincs engedélye a résztvevők megtekintésére';
$string['sitepartlist0'] = 'A portál résztvevőinek megtekintéséhez a portálon tanárnak kell lennie';
$string['sitepartlist1'] = 'A portál résztvevőinek megtekintéséhez oktatónak kell lennie';
$string['sites'] = 'Portálok';
$string['sitesection'] = 'Egyéni tartalom hozzáadása';
$string['sitesettings'] = 'A portál beállításai';
$string['siteteachers'] = 'A portál tanárai';
$string['size'] = 'Méret';
$string['sizeb'] = 'bájt';
$string['sizegb'] = 'GB';
$string['sizekb'] = 'KB';
$string['sizemb'] = 'MB';
$string['sizepb'] = 'PB';
$string['sizetb'] = 'TB';
$string['skipped'] = 'Kihagyva';
$string['skiptocategorylisting'] = 'Ugrás a kategóriák felsorolásához';
$string['skiptocoursedetails'] = 'Ugrás a részletes kurzusadatokhoz';
$string['skiptocourselisting'] = 'Ugrás a kurzusok felsorolásához';
$string['someallowguest'] = 'Egyes kurzusok megengedhetik vendégek belépését';
$string['someerrorswerefound'] = 'Valamilyen információ hiányzik vagy hibás. A részleteket lásd lentebb.';
$string['sort'] = 'Rendezés';
$string['sortby'] = 'Rendezési szempont';
$string['sortbyx'] = 'Rendezés növekvő {$a} szerint';
$string['sortbyxreverse'] = 'Rendezés csökkenő {$a} szerint';
$string['sorting'] = 'Rendezés';
$string['sourcerole'] = 'Kiinduló szerep';
$string['specifyname'] = 'Nevet kell megadnia.';
$string['standard'] = 'Standard';
$string['starpending'] = '([*] = jóváhagyásra váró kurzus)';
$string['startdate'] = 'A kurzus kezdésének dátuma';
$string['startdate_help'] = 'Ez a dátum határozza meg a heti formátumú kurzus első hetének kezdetét. Ez egyben a kurzustevékenységek naplóinak kezdő dátuma is.

Kurzus visszaállítása és a kurzuskezdési időpont módosítása esetén minden kurzusdátum az új kezdési időpont szerint módosul.';
$string['startdatewithtaskenabled'] = 'A kurzus kezdési dátuma';
$string['startdatewithtaskenabled_help'] = 'Az a dátum, amikor a kurzus láthatóvá válik a hallgatók számára. Ezen időpont előtt nem férhetnek hozzá a kurzushoz.

Ez a dátum határozza meg a heti formátumú kurzus első hetének kezdetét is, és a kurzustevékenységek naplóinak kezdő dátumát. Kurzus visszaállítása és a kurzuskezdési időpont módosítása esetén minden kurzusdátum az új kezdési időpont szerint módosul.';
$string['startingfrom'] = 'Ekkortól';
$string['startsignup'] = 'Új fiók létrehozása';
$string['state'] = 'Állam/tartomány';
$string['statistics'] = 'Statisztika';
$string['statisticsgraph'] = 'Statisztika grafikonja';
$string['stats'] = 'Statisztika';
$string['statslogins'] = 'Belépések';
$string['statsmodedetailed'] = 'Részletes (felhasználói) nézet';
$string['statsmodegeneral'] = 'Általános nézet';
$string['statsnodata'] = 'A kurzus és az időtartam ezen párosításához nincsenek adatok.';
$string['statsnodatauser'] = 'A kurzus, a felhasználó és az időtartam ezen párosításához nincsenek adatok.';
$string['statsoff'] = 'A statisztika nincs bekapcsolva';
$string['statsreads'] = 'Nézetek';
$string['statsreport1'] = 'Belépések';
$string['statsreport10'] = 'Felhasználói tevékenység';
$string['statsreport11'] = 'Legaktívabb kurzusok';
$string['statsreport12'] = 'Legaktívabb kurzusok (súlyozva)';
$string['statsreport13'] = 'Leglátogatottabb kurzusok (beiratkozások)';
$string['statsreport14'] = 'Leglátogatottabb kurzusok (üzenetek/hozzászólások)';
$string['statsreport2'] = 'Nézetek (minden szerep)';
$string['statsreport3'] = 'Hozzászólások (minden szerep)';
$string['statsreport4'] = 'Minden tevékenység (minden szerep)';
$string['statsreport5'] = 'Minden tevékenység (nézetek és hozzászólások)';
$string['statsreport7'] = 'Felhasználói tevékenység (nézetek és hozzászólások)';
$string['statsreport8'] = 'Minden felhasználói tevékenység';
$string['statsreport9'] = 'Belépések (portálkurzus)';
$string['statsreportactivity'] = 'Minden tevékenység (minden szerep)';
$string['statsreportactivitybyrole'] = 'Minden tevékenység (nézetek és hozzászólások)';
$string['statsreportforuser'] = 'kié';
$string['statsreportlogins'] = 'Belépések';
$string['statsreportreads'] = 'Nézetek (minden szerep)';
$string['statsreporttype'] = 'Jelentés típusa';
$string['statsreportwrites'] = 'Hozzászólások (minden szerep)';
$string['statsstudentactivity'] = 'Tanulói tevékenység';
$string['statsstudentreads'] = 'Tanulói nézetek';
$string['statsstudentwrites'] = 'Tanulói hozzászólások';
$string['statsteacheractivity'] = 'Tanári tevékenység';
$string['statsteacherreads'] = 'Tanári nézetek';
$string['statsteacherwrites'] = 'Tanári hozzászólások';
$string['statstimeperiod'] = 'Időszak - utolsó:';
$string['statsuniquelogins'] = 'Egyedi belépések';
$string['statsuseractivity'] = 'Minden tevékenység';
$string['statsuserlogins'] = 'Belépések';
$string['statsuserreads'] = 'Nézetek';
$string['statsuserwrites'] = 'Hozzászólások';
$string['statswrites'] = 'Hozzászólások';
$string['status'] = 'Állapot';
$string['statuschecks'] = 'Állapot ellenőrzés';
$string['statuscritical'] = 'Kritikus';
$string['statusdone'] = 'Kész';
$string['statuserror'] = 'Hiba';
$string['statusinfo'] = 'Infó';
$string['statusna'] = 'Nem alkalmazható';
$string['statusok'] = 'Rendben';
$string['statusunknown'] = 'Ismeretlen';
$string['statuswarning'] = 'Figyelmeztetés';
$string['stringsnotset'] = 'A következő szövegek nincsenek megadva itt: {$a}';
$string['studentnotallowed'] = 'Erre a tanfolyamra nem tud belépni \'{$a}\'-ként';
$string['students'] = 'Tanulók';
$string['studentsandteachers'] = 'Tanulók és tanárok';
$string['subcategories'] = 'Alkategóriák';
$string['subcategory'] = 'Alkategória';
$string['subcategoryof'] = '{$a} alkategóriája';
$string['subject'] = 'Téma';
$string['submit'] = 'Leadás';
$string['subsectionmoveerror'] = 'Ezt az alszekciót nem lehet áthelyezni egy másik alszekcióba.';
$string['success'] = 'Sikerült';
$string['successduration'] = 'Sikerült ({$a} másodperc)';
$string['summary'] = 'Leírás';
$string['suspended'] = 'Felfüggesztett';
$string['suspendedusers'] = 'Felfüggesztett felhasználók';
$string['switchdevicedefault'] = 'Áttérés a standard stílusra';
$string['switchdevicerecommended'] = 'Áttérés az eszközéhez ajánlott  stílusra';
$string['switchrolereturn'] = 'Visszatérés szokásos szerepemhez';
$string['switchroleto'] = 'Szerep átváltása erre...';
$string['switchroleto_help'] = 'Válasszon egy szerepet és nézze meg, miként látja ilyen szerepben valaki a kurzust.

Lehet, hogy a nézet nem lesz tökéletes  (<a href="https://docs.moodle.org/en/Switch_roles">Részletek és alternatívák megtekintése</a>).';
$string['tag'] = 'Címke';
$string['tagalready'] = 'A címke már létezik';
$string['tagmanagement'] = 'Címke hozzáadása/törlése...';
$string['tags'] = 'Címkék';
$string['targetrole'] = 'Célszerep';
$string['teacheronly'] = 'csak {$a} számára';
$string['teacherroles'] = '{$a} szerepei';
$string['teachers'] = 'Tanárok';
$string['textcopiedtoclipboard'] = 'Vágólapra másolt szöveg';
$string['textediting'] = 'Szövegszerkesztő';
$string['textediting_help'] = 'Ha egy HTML-szerkesztő, pl. Atto vagy TinyMCE van kiválasztva, a szöveg beírását eszközsoron lévő gombok segítik.

\'Egyszerű szövegmező\' kiválasztása esetén szövegbevitelhez pl. HTML vagy Markdown szövegformát adhat meg.

Az elérhető szövegszerkesztőket a rendszergazda határozza meg.';
$string['texteditor'] = 'Szokásos internetes űrlapok használata';
$string['textellipsis'] = '{$a}...';
$string['textformat'] = 'Egyszerű szöveges formázás';
$string['thanks'] = 'Köszönjük';
$string['theme'] = 'Stílus';
$string['themepreviewdescription'] = '{$a} sablon leírása';
$string['themepreviewimage'] = '{$a} sablon előnézete';
$string['themes'] = 'Stílusok';
$string['themesaved'] = 'Új stílus elmentve';
$string['therearecourses'] = '{$a} kurzus létezik';
$string['thereareno'] = 'A(z) {$a} nem fordul elő ebben a kurzusban!';
$string['thiscategory'] = 'Ez a kategória';
$string['thiscategorycontains'] = 'A kategória tartalma';
$string['time'] = 'Idő';
$string['timecreated'] = 'Létrehozás időpontja';
$string['timecreatedcourse'] = 'Kurzus létrehozásának ideje';
$string['timesplitting:deciles'] = 'Utolsó tizedrész';
$string['timesplitting:deciles_help'] = 'Ez az időelemzési időszak tíz részre osztja a kurzust, az előrejelzések csak az előző tizedrészen alapulnak.';
$string['timesplitting:decilesaccum'] = 'Összes korábbi tizedrész';
$string['timesplitting:decilesaccum_help'] = 'Ez az elemzési időszak tíz részre osztja a kurzust, az előrejelzések az összes korábbi tizedrészen alapulnak.';
$string['timesplitting:nosplitting'] = 'Nincs időkorlát';
$string['timesplitting:nosplitting_help'] = 'A modellhez nincs megadva elemzési időszak.';
$string['timesplitting:onemonthafterstart'] = 'Kezdés után egy hónappal';
$string['timesplitting:onemonthafterstart_help'] = 'Ez az elemzési időtartam az elemezhető kezdés után 1 hónappal esedékes jóslást állítja elő.';
$string['timesplitting:oneweekafterstart'] = 'Kezdés után egy héttel';
$string['timesplitting:oneweekafterstart_help'] = 'Ez az elemzési időtartam az elemezhető kezdés után 1 héttel esedékes jóslást állítja elő.';
$string['timesplitting:past3days'] = 'Elmúlt 3 nap';
$string['timesplitting:past3days_help'] = 'Ez az elemzési időtartam 3 naponta esedékes jóslást állít elő. A jelölők számítása az elmúlt 3 napon alapul.';
$string['timesplitting:pastmonth'] = 'Elmúlt hónap';
$string['timesplitting:pastmonth_help'] = 'Ez az elemzési időtartam havonként esedékes jóslást állít elő. A jelölők számítása az elmúlt hónapon alapul.';
$string['timesplitting:pastweek'] = 'Múlt hét';
$string['timesplitting:pastweek_help'] = 'Ez az elemzési időtartam hetenként esedékes jóslást állít elő. A jelölők számítása az elmúlt héten alapul.';
$string['timesplitting:quarters'] = 'Utolsó negyedrész';
$string['timesplitting:quarters_help'] = 'Ez az  elemzési időszak négy egyenlő részre osztja a kurzust, az előrejelzések csak az utolsó negyedrészen alapulnak.';
$string['timesplitting:quartersaccum'] = 'Összes korábbi negyedrész';
$string['timesplitting:quartersaccum_help'] = 'Ez az elemzési időszak négy egyenlő részre osztja a kurzust, az előrejelzések az összes előző negyedrészen alapulnak.';
$string['timesplitting:singlerange'] = 'Elejétől végéig';
$string['timesplitting:singlerange_help'] = 'Ez az elemzési időszak az egész kurzust egy egésznek tekinti.';
$string['timesplitting:tenpercentafterstart'] = 'Kezdés utáni 10%';
$string['timesplitting:tenpercentafterstart_help'] = 'Ez az elemzési időtartam a kurzus 10%-ának a befejezésekor esedékes jóslást állít elő.';
$string['timesplitting:upcoming3days'] = 'A következő 3 nap';
$string['timesplitting:upcoming3days_help'] = 'Ez az elemzési időszak 3 naponkénti előrejelzést készít. A jelölők kiszámítása a következő 3 napon alapul.';
$string['timesplitting:upcomingfortnight'] = 'Következő 2 hét';
$string['timesplitting:upcomingfortnight_help'] = 'Ez az elemzési időszak kéthetenkénti előrejelzést készít. A jelölők kiszámítása a következő két héten alapul.';
$string['timesplitting:upcomingweek'] = 'Következő hét';
$string['timesplitting:upcomingweek_help'] = 'Az elemzési időszak hetente gyárt előrejelzéseket. A számítások az elkövetkező héten alapulnak.';
$string['timezone'] = 'Időzóna';
$string['tocontent'] = '" {$a}" elembe';
$string['tocreatenewaccount'] = 'Ugrás új fiók létrehozására';
$string['todate'] = 'Meddig';
$string['today'] = 'Ma';
$string['todaylogs'] = 'Mai naplók';
$string['toeveryone'] = 'mindenkinek';
$string['toggleemojipicker'] = 'Hangulatjel-választó ki-/bekapcsolása';
$string['togglesearch'] = 'Keresési bemeneti adatok váltása';
$string['toomanybounces'] = 'Ez az e-mail cím túl sokszor nem fogadott üzenetet. Folytatáshoz meg kell változtatnia.';
$string['toomanytags'] = 'A keresésben túl sok a címke, néhány közülük kimarad.';
$string['toomanytoshow'] = 'Túl sok a megjelenítendő felhasználó';
$string['toomanyusersmatchsearch'] = 'Túl sok ({$a->count}) felhasználó felel meg \'{$a->search}\' szerint';
$string['toomanyuserstoshow'] = 'Túl sok ({$a}) megjelenítendő felhasználó';
$string['toonly'] = 'csak {$a} részére';
$string['top'] = 'Fent';
$string['topic'] = 'Téma';
$string['toplevelcategory'] = 'Legfölső kategória';
$string['torecipient'] = 'Meddig';
$string['total'] = 'Összesen';
$string['totopofsection'] = '"{$a}" szakasz elejére';
$string['trackforums'] = 'Fórum nyomon követése';
$string['trackforumsno'] = 'Ne tartsa számon a már megtekintett hozzászólásokat';
$string['trackforumsyes'] = 'Az új hozzászólásokat jelölje ki számomra';
$string['trysearching'] = 'Próbálkozzon inkább kereséssel.';
$string['turneditingoff'] = 'Szerkesztés KI';
$string['turneditingon'] = 'Szerkesztés BE';
$string['unabletocopytoclipboard'] = 'A szöveg nem másolható a vágólapra';
$string['unauthorisedlogin'] = 'Ezen a portálon nincs "{$a}" felhasználói fiók';
$string['undecided'] = 'Nincs eldöntve';
$string['unexistingcmid'] = 'Nem található a kurzusmodul azonosítója';
$string['unexistingsectionid'] = 'Nem található a kurzusszakasz azonosítója';
$string['unfinished'] = 'Nincs befejezve';
$string['unknowncategory'] = 'Ismeretlen kategória';
$string['unknownerror'] = 'Ismeretlen hiba';
$string['unknownuser'] = 'Ismeretlen felhasználó';
$string['unlimited'] = 'Korlátlan';
$string['unpacking'] = '{$a} kicsomagolása';
$string['unsafepassword'] = 'Nem biztonságos jelszó - próbálkozzon egy másikkal';
$string['untilcomplete'] = 'Míg el nem készül';
$string['unusedaccounts'] = 'A {$a} napnál hosszabb ideig nem használt fiók tulajdonosa automatikusan kiiratkozik';
$string['unzip'] = 'Kicsomagolás';
$string['unzippingbackup'] = 'Biztonsági mentés kicsomagolása';
$string['up'] = 'Fel';
$string['update'] = 'Frissítés';
$string['updated'] = '{$a} frissítve';
$string['updatemymoodleoff'] = 'Oldal testreszabásának befejezése';
$string['updatemymoodleon'] = 'Oldal testreszabása';
$string['updatemyprofile'] = 'Profil frissítése';
$string['updatesevery'] = 'Frissítés minden {$a} másodpercben';
$string['updatethis'] = '{$a} frissítése';
$string['updatethiscourse'] = 'A kurzus frissítése';
$string['upload'] = 'Feltöltés';
$string['uploadafile'] = 'Egy állomány feltöltése';
$string['uploadcantwrite'] = 'Az állományt nem sikerült lemezre írni.';
$string['uploadedfile'] = 'Az állomány feltöltése sikerült.';
$string['uploadedfileto'] = '{$a->file} feltöltve a(z) {$a->directory} könyvtárba';
$string['uploadedfiletoobig'] = 'Az állomány túl nagy (maximum {$a} bájt lehet)';
$string['uploadextension'] = 'Az állomány feltöltését egy PHP-bővítmény leállította.';
$string['uploadfailednotrecovering'] = 'Az állományok feltöltése nem sikerült, mert gond volt az egyik fájllal: {$a->name}. Erről a következő napló készült:{$a->problem}. Nem lehet helyreállítani.';
$string['uploadfilelog'] = 'A(z) {$a} állomány naplójának feltöltése';
$string['uploadformlimit'] = 'A feltöltött állomány {$a} mérete nagyobb, mint az űrlapon megadott';
$string['uploadlabel'] = 'Cím:';
$string['uploadlimitwithsize'] = '{$a->contextname} feltöltési korlátja({$a->displaysize})';
$string['uploadnewfile'] = 'Új állomány feltöltése';
$string['uploadnofilefound'] = 'Nem található állomány - biztosan kiválasztott egyet feltöltésre?';
$string['uploadnotallowed'] = 'Feltöltés nincs engedélyezve';
$string['uploadnotempdir'] = 'Hiányzik egy ideiglenes mappa.';
$string['uploadoldfilesdeleted'] = 'A régi állomány(ok) törölve lett(ek) feltöltési területéről';
$string['uploadpartialfile'] = 'A(z) {$a} állomány feltöltése csak részben sikerült';
$string['uploadproblem'] = 'Ismeretlen probléma lépett fel a(z) \'{$a}\' állomány feltöltésekor (talán túl nagy a fájl?)';
$string['uploadrenamedchars'] = 'Az állomány neve {$a->oldname} névről {$a->newname} névre változott az érvénytelen karakterek miatt.';
$string['uploadrenamedcollision'] = 'Névütközés miatt az állomány {$a->oldname} helyett {$a->newname} nevet kapott.';
$string['uploadserverlimit'] = 'A feltöltött állomány mérete nagyobb, mint a szerver által megadott';
$string['uploadthisfile'] = 'Állomány feltöltése';
$string['url'] = 'URL';
$string['used'] = 'Használatban';
$string['usedinnplaces'] = '{$a} helyen van használatban';
$string['user'] = 'Felhasználó';
$string['useraccount'] = 'Felhasználói fiók';
$string['useractivity'] = 'Tevékenység';
$string['userconfirmed'] = '{$a} megerősítve';
$string['userdata'] = 'Felhasználói adatok';
$string['userdeleted'] = 'Ez a felhasználó törölve lett';
$string['userdescription'] = 'Leírás';
$string['userdescription_help'] = 'Ebben a négyzetben írhat magáról, ami a profiloldalán látható lesz mások számára.';
$string['userdetails'] = 'Felhasználó adatai';
$string['userfiles'] = 'Felhasználó állományai';
$string['userlist'] = 'Felhasználók felsorolása';
$string['usermatchedon'] = 'Ez a felhasználó megfelel a keresésnek a következő mezőben';
$string['usermenu'] = 'Felhasználói menü';
$string['usermenugoback'] = 'Vissza a felhasználói menühöz';
$string['username'] = 'Felhasználónév';
$string['usernameemail'] = 'Felhasználónév vagy e-mail-cím';
$string['usernameemailmatch'] = 'A felhasználónév és az e-mail cím más-más felhasználóé';
$string['usernameexists'] = 'A felhasználónév már létezik, válasszon másikat';
$string['usernamelowercase'] = 'Csak kisbetűk használhatók';
$string['usernamenotfound'] = 'A felhasználónév nem volt az adatbázisban';
$string['usernameoremail'] = 'Felhasználónevet vagy e-mail címet adjon meg';
$string['usernotconfirmed'] = '{$a} nem volt megerősíthető';
$string['userpic'] = 'Felhasználó képe';
$string['userpreferences'] = 'Felhasználói beállítások';
$string['users'] = 'felhasználó';
$string['userselectorautoselectunique'] = 'Ha csak egy felhasználó felel meg a keresésnek, legyen automatikusan kiválasztva';
$string['userselectorpreserveselected'] = 'A kiválasztott felhasználók megtartása akkor is, ha már nem felelnek meg a keresésnek';
$string['userselectorsearchanywhere'] = 'bárhol';
$string['userselectorsearchexactmatchonly'] = 'csak pontos egyezések';
$string['userselectorsearchfromstart'] = 'az elejétől';
$string['userselectorsearchmatching'] = 'Egyezés:';
$string['usersnew'] = 'Új felhasználók';
$string['usersnoaccesssince'] = 'Hosszabb ideje tétlen, mint';
$string['userswithfiles'] = 'Ezen állományokkal rendelkező felhasználók';
$string['useruploadtype'] = 'Felhasználói feltöltés típusa: {$a}';
$string['userzones'] = 'Felhasználói zónák';
$string['usetheme'] = 'Stílus használata';
$string['usingexistingcourse'] = 'Létező kurzus használata';
$string['validatehtml'] = 'HTML hitelesítése';
$string['valuealreadyused'] = 'Az érték már használatban van.';
$string['version'] = 'Változat';
$string['view'] = 'Megtekintés';
$string['viewallcourses'] = 'Minden kurzus megtekintése';
$string['viewallcoursescategories'] = 'Minden kurzus és kategória megtekintése';
$string['viewallresults'] = 'Az összes eredmény megtekintése ({$a})';
$string['viewallsubcategories'] = 'Az összes alkategória megtekintése';
$string['viewfileinpopup'] = 'Állomány megtekintése előugró ablakban';
$string['viewing'] = 'Megtekintés:';
$string['viewmore'] = 'Továbbiak megtekintése';
$string['viewprofile'] = 'Profil megtekintése';
$string['views'] = 'Nézetek';
$string['viewsolution'] = 'megoldás megtekintése';
$string['visible'] = 'Látható';
$string['visible_help'] = 'Ez a beállítás szabja meg, hogy a kurzus megjelenjen-e a kurzuslistán. A kurzusba
tanárokon és rendszergazdákon kívül más nem léphet be.';
$string['visibletostudents'] = 'Láthatja: {$a}';
$string['warning'] = 'Figyelmeztetés';
$string['warningdeleteresource'] = 'Figyelmeztetés: {$a} kapcsán hivatkozás szerepel az egyik tananyagban. Kívánja frissíteni a tananyagot?';
$string['wcagcheck'] = 'Web Content Accessibility Guidelines (WCAG) [netes tartalom elérhetőségi irányelvei] ellenőrzése';
$string['webpage'] = 'Weboldal';
$string['week'] = 'Hét';
$string['weeks'] = 'hét';
$string['welcomeback'] = 'Üdvözöljük, {$a->firstname}! 👋';
$string['welcometocourse'] = 'Üdvözöljük itt: {$a}';
$string['welcometocoursetext'] = 'Üdvözöljük a(z) {$a->coursename} kurzusban!

Ha még nem tette, állítsa be felhasználói profilját, hogy többet megtudhassunk Önről:

<a href="{$a->profileurl}">{$a->profileurl}</a>';
$string['welcometosite'] = 'Üdvözöljük, {$a->firstname}! 👋';
$string['whatforlink'] = 'Mit kíván tenni a hivatkozással?';
$string['whatforpage'] = 'Mit kíván tenni a hivatkozásssal?';
$string['whatisyourage'] = 'Hány éves?';
$string['whattocallzip'] = 'Mi legyen a tömörített állomány neve?';
$string['whattodo'] = 'Mi a teendő';
$string['wheredoyoulive'] = 'Melyik országban él?';
$string['whyisthisrequired'] = 'Miért van erre szükség?';
$string['windowclosing'] = 'Az ablak automatikusan becsukódik. Ha mégsem, csukja be most.';
$string['withchosenfiles'] = 'A kiválasztott fájlokkal';
$string['withdisablednote'] = '{$a} (kikapcsolva)';
$string['withoutuserdata'] = 'felhasználói adatok nélkül';
$string['withselectedusers'] = 'A kiválasztott felhasználókkal...';
$string['withuserdata'] = 'felhasználói adatokkal';
$string['wontrunfuturescheduledtask'] = 'Ne futtassa a feladatot, amely még nem hibázott és a jövőben van ütemezve.';
$string['wordforstudent'] = 'Az Ön szava a tanulóra';
$string['wordforstudenteg'] = 'pl. tanuló, résztvevő stb.';
$string['wordforstudents'] = 'Az Ön szava a tanulókra';
$string['wordforstudentseg'] = 'pl. tanulók, résztvevők stb.';
$string['wordforteacher'] = 'Az Ön szava a tanárra';
$string['wordforteachereg'] = 'pl. tanár, tutor, mentor stb.';
$string['wordforteachers'] = 'Az Ön szava a tanárokra';
$string['wordforteacherseg'] = 'pl. tanárok, tutorok, mentorok stb.';
$string['writingblogsinfo'] = 'Bloginformációk írása';
$string['writingcategoriesandquestions'] = 'Kategóriák és kérdések írása';
$string['writingcoursedata'] = 'Kurzusadatok írása';
$string['writingeventsinfo'] = 'Eseményinformációk írása';
$string['writinggeneralinfo'] = 'Általános információk írása';
$string['writinggradebookinfo'] = 'Értékelésnapló információinak írása';
$string['writinggroupingsgroupsinfo'] = 'Csoport-csoportosítási információk írása';
$string['writinggroupingsinfo'] = 'Csoportosítási információk írása';
$string['writinggroupsinfo'] = 'Csoportinformációk írása';
$string['writingheader'] = 'Fejléc írása';
$string['writingloginfo'] = 'Naplózási információk írása';
$string['writingmessagesinfo'] = 'Üzenetinformációk írása';
$string['writingmoduleinfo'] = 'Modulinformációk írása';
$string['writingscalesinfo'] = 'Skálainformációk írása';
$string['writinguserinfo'] = 'Felhasználói információk írása';
$string['wrongpassword'] = 'A jelszó hibás ehhez a felhasználónévhez';
$string['year'] = 'év';
$string['years'] = 'év';
$string['yes'] = 'Igen';
$string['youareabouttocreatezip'] = 'Most lát hozzá az alábbi tartalmú állomány tömörítéséhez';
$string['youaregoingtorestorefrom'] = 'Most lát hozzá az alábbi folyamat helyreállításához';
$string['youhaveupcomingactivitiesdue'] = 'Önre  soron következő elvégzendő tevékenységek várnak';
$string['youhaveupcomingactivitiesdueinfo'] = 'Üdvözöljük, {$a}!

<br/><br/>Soron következő esedékes tevékenységei vannak:';
$string['youneedtoenrol'] = 'Ennek végrehajtásához be kell iratkoznia a kurzusba.';
$string['yourlastlogin'] = 'Utolsó belépésének időpontja:';
$string['yourself'] = 'Ön';
$string['yourteacher'] = 'az Ön tanára {$a}';
$string['yourwordforx'] = 'Az Ön szava {$a} esetén';
$string['zippingbackup'] = 'Biztonsági mentés tömörítése';
