<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'theme_boost_magnific', language 'sr_lt', version '4.5'.
 *
 * @package     theme_boost_magnific
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['access_course'] = 'Pristup kursu';
$string['access_course_buy'] = 'Detaljni podaci o kursu';
$string['acctoolbar_access_declaration'] = 'Izjava o pristupačnosti';
$string['acctoolbar_btn_bright'] = 'Svetao kontrast';
$string['acctoolbar_btn_cursor_black'] = 'Veliki crni kursor';
$string['acctoolbar_btn_cursor_white'] = 'Veliki beli kursor';
$string['acctoolbar_btn_font_down'] = 'Smanji veličinu teksta';
$string['acctoolbar_btn_font_readable'] = 'Čitljiv tekst';
$string['acctoolbar_btn_font_up'] = 'Povečaj veličinu teksta';
$string['acctoolbar_btn_images_titles'] = 'Naslovi slika';
$string['acctoolbar_btn_invert'] = 'Obrnuti kontrast';
$string['acctoolbar_btn_monochrome'] = 'Prikaz bez boja';
$string['acctoolbar_btn_open'] = 'Meni za pristupačnost';
$string['acctoolbar_btn_underline_headers'] = 'Podvuci zaglavlja';
$string['acctoolbar_btn_underline_links'] = 'Podvuci linkove';
$string['acctoolbar_btn_zoom_in'] = 'Zumiraj ekran';
$string['acctoolbar_content_block_header'] = 'Isticanje sadržaja';
$string['acctoolbar_contrast_block_header'] = 'Kontrast boja';
$string['acctoolbar_debug_contacts'] = 'Prijavite problem u vezi sa pristupačnošću';
$string['acctoolbar_dyslexic'] = 'Font čitljiv korisnicima sa disleksijom';
$string['acctoolbar_image_without_alt'] = 'Slika bez teksta';
$string['acctoolbar_keyboard_root'] = 'navigacija putem tastature';
$string['acctoolbar_reset_all_settings'] = 'Resetujte podešavanja';
$string['acctoolbar_text_block_header'] = 'Veličina teksta';
$string['acctoolbar_toolbar'] = 'Traka sa alatkama za pristupačnost';
$string['acctoolbar_zoom_block_header'] = 'Uvećajte';
$string['add_block'] = 'Dodaj novi blok';
$string['background_color'] = 'Boja pozadine';
$string['background_color_desc'] = 'Boja pozadine vrha i podnožja stranice!';
$string['background_color_random'] = 'Naumična grafička tema {$a}';
$string['background_course_image'] = 'Podrazumevana pozadinska slika kursa';
$string['background_course_image_desc'] = 'Podešava podrazumevanu pozadinsku sliku za zaglavlje svih kurseva. Ova slika će biti prikazana na vrhu glavne stranice kursa i može biti zamenjena u podešavanjima kursa.';
$string['background_profile_image'] = 'Pozadinska slika profila';
$string['background_profile_image_desc'] = 'Pozadinska slika prikazana na profilu korisnika.';
$string['background_text_color'] = 'Boja teksta';
$string['background_text_color_desc'] = 'Boja teksta na vrhu i u podnožju stranice';
$string['backgroundimage'] = 'Pozadinska slika';
$string['backgroundimage_desc'] = 'Slika koja će biti prikazna kao pozadina sajta.  Pozadinska slika koju ovde postavite će zameniti pozadinsku sliku u vašim datotekama sa predefinisanim podešavanjima teme.';
$string['brandcolor'] = 'Primarna boja interfejsa';
$string['brandcolor_background_menu'] = 'Primenite boju brenda na pozadinu menija';
$string['brandcolor_background_menu_desc'] = 'Ovo podešavanje definiše da li će boja podešena u "Boja brenda" biti primenjena na stavke menija ili na pozadinu menija.<br>Ako se primeni na pozadinu, tekst menija će biti prikazan belom bojom kako bi se obezbedio neophodan kontrast.';
$string['brandcolor_desc'] = 'Podesite boju naglašavanja pomoću gornjeg selektora ili izborom boje iz palete ispod.';
$string['cachedef_course_cache'] = 'Keš podataka kursa';
$string['cachedef_course_module_cache'] = 'Keš modula kursa';
$string['cachedef_css_cache'] = 'CSS keš';
$string['cachedef_darkmode_cache'] = 'Keš tamnog režima';
$string['cachedef_data_cache'] = 'Keš podataka';
$string['cachedef_frontpage_cache'] = 'Keš naslovne stranice';
$string['cachedef_layout_cache'] = 'Keš raspored elemenata stranice';
$string['cachedef_logo_cache'] = 'Keš logotipa';
$string['choosereadme'] = 'Boost Magnific je grafička tema pažljivo kreirana sa namerom da unese vedre boje u Moodle.';
$string['contact_address'] = 'Adresa';
$string['contact_email'] = 'E-adresa';
$string['contact_phone'] = 'Broj telefona';
$string['content_type_default'] = 'Moodle standardno';
$string['content_type_empty'] = '(Bez sadržaja)';
$string['content_type_footer'] = 'Tip sadržaja za podnožje';
$string['content_type_footer_desc'] = 'Izaberite tip sadržaja koji želite da prikažete u podnožju.';
$string['content_type_home'] = 'Tip sadržaja za početnu stranicu';
$string['content_type_home_desc'] = 'Izaberite tip sadržaja koji želite da prikažete na početnoj stranici.';
$string['content_type_html'] = 'Stranica koja se kreira pomoću editora';
$string['continuar'] = 'Nastavite sa učenjem';
$string['countlesson'] = '{$a} lekcija';
$string['countlessons'] = '{$a} lekcije/a';
$string['course_access'] = 'Pristupite kursu';
$string['course_moore'] = 'Više detalja';
$string['course_summary'] = 'Prikaži rezime kursa pre samog kursa';
$string['course_summary_banner'] = 'Prikaži rezime kursa pre samog kursa';
$string['course_summary_banner_desc'] = 'Ako je ova opcija omogućena, rezime kursa će biti prikazan pre glavnog sadržaja kursa na početnoj stranici kursa.';
$string['course_summary_banner_edit'] = 'Uredite sliku banera na ovom kursu';
$string['course_summary_banner_none'] = 'Bez zaglavlja';
$string['course_summary_banner_simple'] = 'Jednostavno zaglavlje sa informacijama';
$string['course_summary_banner_title'] = 'Zaglavlje sa banerom';
$string['course_summary_desc'] = 'Ako je ova opcija omogućena, rezime kursa će biti prikazan pre glavnog sadržaja kursa na početnoj stranici kursa.';
$string['courseindexoptions'] = 'Opcije indeksa kursa';
$string['coursesettings'] = 'Kurs';
$string['customcss'] = 'Prilagođeni CSS';
$string['customcss_desc'] = 'Sva CSS pravila koja dodate u ovo polje za teksta odraziće se na sve stranice, što olakšava prilagođavanje ove teme.';
$string['customfield_category_name'] = 'Prilagođavanje grafičke teme';
$string['customfield_field_image'] = 'Prilagođena slika';
$string['customfield_field_image_desc'] = 'Изаберите слику како бисте прилагодили поље. Слика ће бити заменити глобална подешавања курса.';
$string['customfield_field_name'] = 'Prikaži sliku na vrhu glavne stranice kursa';
$string['customfield_field_name_desc'] = '<p>Ovo polje vam pruža mogućnost da izaberete da li želite da prikažete sliku na vrhu glavne stranice kursa. Kada je omogućeno, slika po vašem izboru biće istaknuta, poboljšavajući na taj način vizuelnu atraktivnost kursa i dajući korisnicima unapređeno iskustvo.</p>';
$string['customfield_picture_missing'] = '<div class="alert alert-warning">Potrebno je da instalirate dodatak <a href="https://moodle.org/plugins/customfield_picture" target="_blank">customfield_picture</a> kako biste podesili pozadinsku sliku.</div>';
$string['custommenuitems'] = 'Prilagođene stavke menija na vrhu stranice';
$string['custommenuitems_desc'] = 'Pored menija na vrhu stranice možete kreirati prilagođeni meni. Osnovni meni treba da počinje u ravni sa ivicom menija, a podmeniju treba da prethodi crtica (-). Broj crtica određuje dubinu tj. poziciju stavke u meniju. Dakle, stavke sa jednom crticom pojavljuju se u podmeniju ispod prethodne stavke najvišeg nivoa, a stavke sa dve crtice se pojavljuju u podmeniju ispod prethodnog podmenija.
Sadržaj svake stavke u meniju treba da se sastoji od najviše tri elementa (<strong>label</strong> | <strong>url</strong> | <strong>tooltip</strong> | <strong>lang</strong>), сваки одвојен знаком "|".
<ul>
<li><strong>label</strong>: Ovo je tekst koji će biti prikazan u okviru stavke u meniju. Morate navesti oznaku za svaku stavku u meniju.</li>
<li><strong>url</strong>: Ovo je URL adresa na koju će korisnik biti preusmeren nakon što klikne na stavku u meniju. Ovo je opciono; ako URL adresa nije navedena stavka u meniju neće biti linkovana.<br>
Ostali atributi kao što je "target" mogu se dodati na kraj URL adrese.</li>
<li><strong>tooltip</strong>: Ako ste naveli URL adresu, takođe možete izabrati da pružite kratak opis linka koji ste kreirali pomoću URL adrese. Ovo je opciono, a ako nije definisano, oznaka (label) će se koristi kao kratak opis stavke u meniju.</li>
<li><strong>lang</strong>: Takođe, možete dodati kôd jezika (ili spisak kôdova razdvojenih zarezima) kao četvrti element reda. Stavka u meniju će biti prikazana samo ako je korisnik izabrao neki od navedenih jezika.</li>
</ul>
U nastavku možete videti primer kako da kreirate prilagođeni meni:
<blockquote><pre>
Courses
-All courses | /course/
-My courses
--Example Course
---Example Course 7 | /course/view.php?id=7
---Example Course 9 | /course/view.php?id=9
--Test Course
---Test Course 2 | /course/view.php?id=2
---Test Course 5 | /course/view.php?id=5
Google
-Google in any language | https://google.com/" target="_blank
-Google in Mexico | https://www.google.com.mx/" target="_blank|Google Label|en
-Google in Portuguese | https://google.com.br/" target="_blank|Google Label|pt,pt_br,pt_br_kids
Support Page | https://support.com/" target="_blank
</pre></blockquote>
For Moodle with support for multiple languages, the <strong>label</strong> value should be formatted as <strong>"langstringname,componentname"</strong>.
<blockquote><pre>
profile,moodle | /user/profile.php
messages,message | /message/index.php
</pre></blockquote>
<a href="https://docs.moodle.org/404/en/Advanced_theme_settings" target="_blank">Više informacija o meniju</a>';
$string['delete_block_confirm'] = 'Da li ste sigurni da želite da obrišete blok?';
$string['delete_block_success'] = 'Blok je uspešno obrisan';
$string['delete_block_title'] = 'Obriši blok';
$string['details-completaram'] = 'Završio/la kurs';
$string['details-emprogresso'] = 'U toku';
$string['details-not-access'] = 'Nikada nije pristupljeno';
$string['details-teachers'] = 'Predavači';
$string['details-users'] = 'Polaznici';
$string['edit_block'] = 'Uredi blok';
$string['editor_link_footer'] = 'Uredite blokove podnožja za {$a} jezik';
$string['editor_link_footer_all'] = 'Uredite blokove podnožja za sve jezike';
$string['editor_link_home'] = 'Uredite početnu stranicu za {$a} jezik';
$string['editor_link_home_all'] = 'Uredite početnu stranicu za sve jezike';
$string['error_invalidscss'] = 'Neispravan SCSS: {$a}';
$string['favicon'] = 'Favikonica';
$string['favicon_desc'] = 'Favikonica se prikazuje pored naslova stranice na kartici veb čitača. Ako prilagođena favikonica nije obezbeđena biće prikazana Moodle favikonica.';
$string['fontfamily'] = 'Fontovi teksta na sajtu';
$string['fontfamily_desc'] = 'Izaberite koji font želite da koristite za tekst na svom Moodle sajtu.';
$string['fontfamily_menus'] = 'Fontovi menija';
$string['fontfamily_menus_desc'] = 'Izaberite koji font želite da koristite za menije na svom Moodle sajtu.';
$string['fontfamily_sitename'] = 'Font za naziv sajta';
$string['fontfamily_sitename_desc'] = 'Font koji će biti primenjen na naziv sajta ako logotip nije obezbeđen.';
$string['fontfamily_title'] = 'Fontovi teksta naslova';
$string['fontfamily_title_desc'] = 'Izaberite koji font želite da koristite za naslove na svom Moodle sajtu.';
$string['fontpreview'] = 'Pregled spiska fontova';
$string['footer_background_color'] = 'Boja pozadine podnožja';
$string['footer_background_color_desc'] = 'Izaberite boju pozadine za podnožje veb stranice. Ostavite prazno kako biste koristili primarnu boju.';
$string['footer_contact_title'] = 'Naslov bloka sa kontakt podacima';
$string['footer_contact_title_default'] = 'Kontaktirajte nas';
$string['footer_contact_title_desc'] = 'Unesite naslov bloka koji će se pojaviti u podnožju sa podacima o kontaktu.';
$string['footer_copywriter'] = 'Kreirano sa ❤️';
$string['footer_description'] = 'Opis';
$string['footer_description_desc'] = 'Opišite svoj Moodle, šta radite, a ove informacije će biti prikazane ispod logotipa u podnožju stranice';
$string['footer_frontpage_blockcourses_instructor'] = 'Pokažite imena predavača';
$string['footer_frontpage_blockcourses_instructor_desc'] = 'Ako je označeno, prikazuje imena predavača na spisku kurseva!';
$string['footer_frontpage_blockcourses_text'] = 'Kratak tekst koji objašnjava blok "{$a}"';
$string['footer_frontpage_blockcourses_text_desc'] = 'Dodajte tekst koji opisuje blok "{$a}"!';
$string['footer_heading'] = 'Blok {$a}';
$string['footer_heading_description_desc'] = '<ul>
  <li><strong>Nijedan blok nije popunjen:</strong> podnožje neće biti prikazano.</li>
  <li><strong> 1 blok popunjen:</strong> sadržaj će biti prikazan kao tekst, bez formatiranja u formi bloka.</li>
  <li><strong>2, 3 ili 4 bloka popunjena:</strong> grafička tema će automatski prilagoditi raspored blokova kako bi oni bili prikazani proporcionalno u skladu sa veličinom ekrana.</li>
</ul>
Popunite samo blokove koji su vam potrebni, grafička tema će se pobrinuti za ostalo.';
$string['footer_heading_description_title'] = 'Grafička tema se automatski prilagođava broju blokova u podnožju:';
$string['footer_html'] = 'HTML bloka podnožja {$a}';
$string['footer_html_desc'] = 'Dodajte prilagođeni HTML kôd koji će biti prikazan u bloku podnožja {$a}.';
$string['footer_links_title'] = 'Naslov bloka sa linkovima';
$string['footer_links_title_default'] = 'Važni linkovi';
$string['footer_show_copywriter'] = 'Prikaži pruku "Kreirano sa ❤️"';
$string['footer_show_copywriter_desc'] = 'Opozovite izbor ako želite da saktijete poruku ”Kreirano sa ❤️”';
$string['footer_social_title'] = 'Naslov bloka sa linkovima društvenih mreža';
$string['footer_social_title_default'] = 'Pratite nas na društvenim mrežama';
$string['footer_social_title_desc'] = 'Unesite naslov bloka koji će se pojaviti u podnožju sa podacima sa vaših društvenih mreža.';
$string['footer_title'] = 'Naslov bloka {$a}';
$string['footer_title_desc'] = 'Podesite naslov koji će se pojaviti iznad HTML sadržaja u bloku podnožja {$a}.';
$string['footerblink'] = 'Linkovi blokova podnožja';
$string['footerblink_desc'] = 'Ovde možete da konfigurišete linkove blokova u podnožju koji će biti prikazani.<br>Svaki red se sastoji od teksta stavke u meniju ili jezičkog ključa ili teksta, kao i URL adrese (opciono), razdvojenih vertikalnim trakama. Na primer:<br><pre>Moodle Support|https://moodle.org/support</pre>';
$string['footerblock_contact'] = 'Blok sa kontakt podacima';
$string['footerblock_copywriter'] = 'Kreirano sa ❤️';
$string['footerblock_description'] = 'Blok sa opisom';
$string['footerblock_links'] = 'Blok sa linkovima';
$string['footerblock_social'] = 'Blok društvenih mreža';
$string['footersettings'] = 'Podešavanja podnožja';
$string['free_name'] = 'Besplatno';
$string['frontpage_about_description'] = 'Opišite šta radite';
$string['frontpage_about_description_desc'] = 'Opišite u najviše 5 redova svrhu vašeg Moodlea';
$string['frontpage_about_enable'] = 'Omogućite blok \'O nama\'';
$string['frontpage_about_enable_desc'] = 'Ako je označeno, blok \'O nama\' će se pojaviti ispod banera!';
$string['frontpage_about_info'] = 'Polje sa podacima {$a}';
$string['frontpage_about_logo'] = 'Ovde će biti prikazan drugačiji logo';
$string['frontpage_about_logo_desc'] = 'Ako je podešen, ovaj logotip će se koristiti umesto logotipa na vrhu stranice.<br>Ako se polje ostavi prazno koristići se standardni logotip na vrhu stranice,';
$string['frontpage_about_number'] = 'Broj';
$string['frontpage_about_number_desc'] = 'Unesite broj za gore navedeno polje sa podacima';
$string['frontpage_about_text'] = 'Naziv polja sa podacima';
$string['frontpage_about_text_1_defalt'] = 'Kursevi';
$string['frontpage_about_text_2_defalt'] = 'Predavači';
$string['frontpage_about_text_3_defalt'] = 'Polaznici';
$string['frontpage_about_text_4_defalt'] = 'Lekcije';
$string['frontpage_about_text_desc'] = 'Unesite naziv podataka koji će biti prikazani na početnoj stranici';
$string['frontpage_about_title'] = 'Naslov bloka \'O nama\'';
$string['frontpage_about_title_default'] = 'Naša globalna zajednica';
$string['frontpage_add_block'] = 'Dodaj novi blok';
$string['frontpage_add_block_title'] = 'Izaberite uzorak bloka koji želite da dodate';
$string['frontpage_change_editor'] = 'Kreirajte početnu stranicu pomoću editora stranice?';
$string['frontpage_enable_editing'] = 'Omogućite uređivanje kako biste dodali stavke na početnu stranicu';
$string['heart'] = 'Ako vam se sviđa ova tema, ne zaboravite da kliknete na ❤️ na stranici za grafičke teme <a href="{$a}" target="_blank">tako što ćete kliknuti ovde</a>';
$string['homesettings'] = 'Podešavanja početne stranice';
$string['imageacceptedtypes'] = 'Dozvoljene su samo datoteke slika sledećih tipova: {$a}';
$string['instructor'] = 'Instruktor';
$string['language_all'] = 'Svi dostupni jezici';
$string['login_backgroundcolor'] = 'Boja pozadine';
$string['login_backgroundcolor_desc'] = 'Izaberite boju pozadine stranice za obnovu izgubljene/zaboravljene lozinke';
$string['login_backgroundfoto'] = 'Pozadinska slika';
$string['login_backgroundfoto_desc'] = 'Izaberite pozadinsku sliku stranice za prijavu, za obnovu izgubljene/zaboravljene lozinke, kao i za kreiranje naloga. Podrazumevana slika je: {$a}';
$string['login_forgot_description'] = 'Tekst sa strane na stranici za zaboravljenu lozinku';
$string['login_forgot_description_desc'] = 'Tekst koji će se pojaviti samo na stranici za zaboravljenu lozinku';
$string['login_login_description'] = 'Tekst sa strane koji će se pojaviti na stranici za prijavu';
$string['login_login_description_desc'] = 'Tekst koji će se pojaviti samo na stranici za prijavu';
$string['login_signup_description'] = 'Tekst sa strane na stranici za kreiranje naloga';
$string['login_signup_description_desc'] = 'Tekst koji će se pojaviti samo na stranici za kreiranje naloga';
$string['login_theme'] = 'Izgled stranice za prijavu';
$string['login_theme_block'] = 'Centralni beli blok sa opcionom pozadinom';
$string['login_theme_desc'] = 'Izaberite kako želite da izgleda stranica za prijavu';
$string['login_theme_image_login'] = 'Pozadinska slika i obrazac za prijavu sa strane';
$string['login_theme_imagetext_login'] = 'Pozadinska slika, tekst preko slike i obrazac za prijavu sa strane';
$string['login_theme_login'] = 'Samo obrazac za prijavu, bez bočne slike';
$string['loginbackgroundimage'] = 'Pozadinska slika stranice za prijavu';
$string['loginbackgroundimage_desc'] = 'Slika koja će biti prikazana kao pozadina na stranici za prijavu.';
$string['loginlogo'] = 'PNG/SVG logo za stranicu za prijavu';
$string['loginlogo_desc'] = 'Postavite logo u PNG ili SVG formatu koji će biti prikazan na stranici za prijavu. Logo treba da bude jasan i reprezentativan za vizuelni identitet vaše institucije odnosno organizacije. Na taj način pružićete korisnicima profesionalan i konzistentan izgleda stranice za prijavu.';
$string['loginsettings'] = 'Podešavanje stranice za prijavu';
$string['logintheme'] = 'Grafička tema stranice za prijavu';
$string['logintheme_aurora'] = 'Aurora';
$string['logintheme_clean-minimal'] = 'Clean Minimal';
$string['logintheme_clean-outline'] = 'Clean Outline';
$string['logintheme_dark-elegante'] = 'Dark Elegante';
$string['logintheme_desc'] = 'Izaberite grafičku temu koja će biti prikazana na stranici za prijavu';
$string['logintheme_selva-canopy'] = 'Forest Canopy';
$string['logo_color'] = 'Logo u boji';
$string['logo_color_desc'] = 'Postavite svoj LOGO u boji ako želite da on bude prikazan pri vrhu stranice. Ovaj logo će biti vidljiv prilikom premotavanja (skrolovanja) stranice, dok će meni biti prikazan na beloj pozadini.';
$string['logo_write'] = 'Logo menija na vrhu stranice prilikom skrolovanja';
$string['logo_write_desc'] = 'Postavite svoj logo ako želite da on bude prikazan pri vrhu stranice. Ovaj logo će biti vidljiv prilikom premotavanja (skrolovanja) stranice, dok će meni biti prikazan na pozadini u boji.';
$string['matricular'] = 'Upišite se';
$string['mycourses_color'] = 'Boja pozadine bloka';
$string['mycourses_color_desc'] = 'Boja pozadine za blok.';
$string['mycourses_icon'] = 'Ikonica';
$string['mycourses_icon_desc'] = 'Reprezentativna ikonica za blok. Veličina ikone treba da bude 48x48 piksela.';
$string['mycourses_info'] = 'Blok {$a}';
$string['mycourses_numblocos'] = 'Broj blokova';
$string['mycourses_numblocos_desc'] = 'Koliko slika želite da ima slajd-šou?';
$string['mycourses_numblocos_nenhum'] = 'Nema blokova na početnoj stranici';
$string['mycourses_title'] = 'Kratki naslov bloka';
$string['mycourses_title_desc'] = 'Kratak i deskriptivan naslov za blok.';
$string['mycourses_url'] = 'Link bloka';
$string['mycourses_url_desc'] = 'URL adresa na koju će korisnik biti preusmeren kada klikne na blok. To može biti eksterni ili interni link unutar platforme.';
$string['pluginname'] = 'Boost Magnific';
$string['preview'] = 'Pregled bloka';
$string['privacy:drawerblockclosed'] = 'Trenutni parametar za fioku sa blokovima je zatvoren.';
$string['privacy:drawerblockopen'] = 'Trenutni parametar za fioku sa blokovima je otvoren.';
$string['privacy:drawerindexclosed'] = 'Trenutni parametar za fioku sa indeksom kursa je zatvoren.';
$string['privacy:drawerindexopen'] = 'Trenutni parametar za fioku sa indeksom kursa je otvoren.';
$string['privacy:metadata'] = 'Grafička tema Boost Magnific ne čuva nikakve lične podatke o bilo kom korisniku.';
$string['privacy:metadata:preference:draweropenblock'] = 'Korisnički parametar za skrivanje ili prikazivanje fioke sa blokovima.';
$string['privacy:metadata:preference:draweropenindex'] = 'Korisnički parametar za skrivanje ili prikazivanje fioke sa indeksom kursa.';
$string['privacy:metadata:preference:draweropennav'] = 'Korisnički parametar za skrivanje ili prikazivanje navigacione fioke sa menijem';
$string['progress_percentage'] = 'Vaš napredak';
$string['quickstart_alert_notadd'] = 'Nije moguće promeniti baner na početnoj stranici nakon što je dodat. Da biste ga izmenili, potrebno je da odete na <a href="{$a}/"> početnu stranicu </a> i obrišite postojeći baner.';
$string['quickstart_alert_notdelete'] = 'Nije moguće ukloniti ovde dodate blokove. Da biste ih obrisali idite na <a href="{$a}/">početnu stranicu </a> i uklonite blokove koje više ne želite.';
$string['quickstart_banner-saved'] = 'Podešavanja su uspešno sačuvana.';
$string['quickstart_course_choose_below'] = 'Ili izaberite baner u nastavku';
$string['quickstart_course_upload_or_choose'] = 'Otpremite sliku ili izaberite željeni tip banera';
$string['quickstart_home_pagebuilder'] = 'Početna stranica sa editorom stranice';
$string['quickstart_home_pagebuilder_desc'] = 'Prilagodljiv interfejs sa sekcijama koje se mogu uređivati.';
$string['quickstart_home_selectsections'] = 'Izaberite željene sekcije:';
$string['quickstart_home_selectstyle'] = 'Izaberite stil početne stranice';
$string['quickstart_home_traditional'] = 'Tradicionalna Moodle početna stranica';
$string['quickstart_home_traditional_desc'] = 'Podrazumevana početna stranica Moodlea sa blokovima i kursevima. Kliknite na dugme ispod kako biste izmenili sistemska podešavanja.';
$string['quickstart_settings_link'] = '<div class="card mb-5">
<div class="card-header">Brzi početak</div>
<div class="card-body"><a href="{$a}">Pristupite vodiču za brzi početak</a> i upotrbite intuitivne opcije kako biste konfigurisali ova i druga podešavanja grafičke teme Degrade.</div>
</div>';
$string['quickstart_title'] = 'Centar za podešavnja teme';
$string['settings_about_heading'] = 'O vašem Moodleu';
$string['settings_accessibility'] = 'Omogućite opcije za pristupačnost';
$string['settings_accessibility_desc'] = 'Omogućava prilagođavanje opcija za unapređenje pristupačnosti platformi, kao što su kontrast, veličina fonta i navigacija uz pomoć tastature.';
$string['settings_accessibility_heading'] = 'Pristupačnost';
$string['settings_course_heading'] = 'Podešavanja kursa';
$string['settings_css_heading'] = 'Fontovi i CSS';
$string['settings_footer_heading'] = 'Blokovi podnožja';
$string['settings_icons_change_icons'] = 'Promenite podrazumevanu ikonicu na spisku kurseva';
$string['settings_icons_color_icon'] = 'Podesite prilagođenu boju za ikonicu.';
$string['settings_icons_color_icon_desc'] = 'Izaberite boju pozadine za ikonicu prikazanu na spisku kurseva. Ostavite prazno kako biste koristili boju podrazumevanu za teme.';
$string['settings_icons_upload_icon'] = 'Postavite prilagođenu ikonicu.';
$string['settings_icons_upload_image'] = 'Blok slika';
$string['settings_icons_upload_image_desc'] = 'Ako je postavljena slika, tema će konvertovati red u kojem se slika nalazi u blok, koristeći tu sliku kao pozadinu. Slika mora imati odnos širine i visine 16:9.';
$string['settings_login_heading'] = 'Stranica za prijavu';
$string['settings_mycourses_heading'] = 'Blokovi na stranici \'Moji kursevi\'';
$string['settings_slideshow_heading'] = 'Slajd-šou';
$string['settings_theme_heading'] = 'Grafička tema';
$string['settings_top_heading'] = 'Meni na vrhu stranice';
$string['showfooter'] = 'Prikaži podnožje';
$string['sitefonts'] = 'Dodatni Google fontovi';
$string['sitefonts_desc'] = 'Umetni @import kôd servisa Google fontovi kao što je prikazano na slici ispod. Nakon što sačuvate, polje "Fontovi sajta" će biti ažurirano, prikazujući ove fontove. Možete dodati više @import kôdova po potrebi.';
$string['slidecaption_desc'] = 'Unesite tekst naslova koji će se koristiti na slajdu';
$string['slideshow_image'] = 'Slika slajda';
$string['slideshow_image_desc'] = 'Slika treba da bude veličine 1250 x 400 piksela.';
$string['slideshow_info'] = 'Slajd {$a}';
$string['slideshow_numslides'] = 'Koliko slika staviti u slajd-šou';
$string['slideshow_numslides_desc'] = 'Koliko slika želite da ima slajd-šou?';
$string['slideshow_numslides_nenhum'] = 'Bez slajdova na početnoj stranici';
$string['slideshow_text'] = 'Kratak opisni tekst za slajd';
$string['slideshow_text_desc'] = 'Ubacite kratak tekst o slajdu.';
$string['slideshow_url'] = 'Link dugmeta na slajdu';
$string['slideshow_url_desc'] = 'Umetnite odredišni link za dugme na slici slajda';
$string['social_facebook'] = 'Ваш Facebook';
$string['social_facebook_desc'] = 'URL adresa Facebook naloga vaše organizacije/institucije';
$string['social_instagram'] = 'Vaš Instagram';
$string['social_instagram_desc'] = 'URL adresa Instagram naloga vaše organizacije/institucije';
$string['social_linkedin'] = 'Vaš Linkedin';
$string['social_linkedin_desc'] = 'URL adresa Linkedin naloga vaše organizacije/institucije';
$string['social_twitter'] = 'Vaš Twitter';
$string['social_twitter_desc'] = 'URL adresa Twitter naloga vaše organizacije/institucije.';
$string['social_youtube'] = 'Vaš Youtube';
$string['social_youtube_desc'] = 'URL adresa Youtube kanala vaše organizacije/institucije';
$string['tableofcontents'] = 'Sadržaj';
$string['theme_boost_magnific_about_editbooton'] = 'Uredite blok \'O nama\'';
$string['theme_boost_magnific_frontpage_bloco'] = 'Blok "{$a}"';
$string['theme_boost_magnific_frontpage_home'] = 'Blokovi na početnoj stranici';
$string['theme_boost_magnific_mycourses_editbooton'] = 'Uredite blokove';
$string['theme_boost_magnific_slideshow_editbooton'] = 'Uredi slajd-šou';
$string['theme_color'] = 'Izbor boja';
$string['theme_color-color_buttons'] = 'Boja dugmadi';
$string['theme_color-color_buttons_desc'] = 'Boja koja se koristi za dugmad, i koja ne samo da doprinosi vizuelnom identitetu već i naglašava interaktivnost.';
$string['theme_color-color_primary'] = 'Primarna boja';
$string['theme_color-color_primary_desc'] = 'Glavna primarna boja teme, koja se obično koristi za isticanje i naglašavanje elemenata.';
$string['theme_color-color_secondary'] = 'Sekundarna boja';
$string['theme_color-color_secondary_desc'] = 'Sekundarna boja koja dopunjuje primarnu boju, i koja se koristi za isticanje sekundarnih elemenata ili za kontrast sa primarnom bojom.';
$string['theme_color_desc'] = 'Izaberite boje Moodle tekstova i dugmadi ili kliknite na liniju ispod:';
$string['theme_color_heading'] = 'Izbor boje orkuženja';
$string['theme_color_sugestion'] = 'Predlog za boje';
$string['theme_color_sugestion_text'] = 'Kliknite na željeni red tj. boju (plava, ljubičasta, crvena...) u nastavku, kako bi odgovarajući skup boja bio primenjen za dole navedene opcije (primarna boja, sekundarna boja, boja dugmadi...)';
$string['theme_login_branco'] = 'Samo obrazac za prijavu na beloj pozadini, bez bočne slike';
$string['top_color_heading'] = 'Boja menija na vrhu stranice prilikom skrolovanja';
$string['top_scroll'] = 'Fiksirajte meni prilikom skrolovanja stranice';
$string['top_scroll_background_color'] = 'Boja pozadine menija na vrhu stranice prilikom premotavanja (skrolovanja)';
$string['top_scroll_background_color_desc'] = 'Podesite boju pozadine menija na vrhu stranice prilikom premotavanja (skrolovanja) stranice.';
$string['top_scroll_desc'] = 'Kada je omogućeno, meni će biti fiksiran za vrh stranice prilikom njenog premotavanja (skrolovanja). Tako će biti omogućen lak pristup opcijama menija.';
$string['top_scroll_fix'] = 'Fiksirajte meni prilikom skrolovanja stranice';
$string['top_scroll_fix_desc'] = 'Kada je omogućeno, meni će biti fiksiran za vrh ekrana dok skrolujete stranicu. Na tja način se obezbeđuje lak pristup opcijama menija.';
$string['top_scroll_text_color'] = 'Boja teksta menija prilikom skrolovanja';
$string['top_scroll_text_color_desc'] = 'Podesite boju teksta menija prilikom premotavanja (skrolovanja) stranice.';
$string['userprofilesettings'] = 'Korisnički profil';
$string['vvveb_footer_contact_title_default'] = 'Kontaktirajte nas';
$string['vvveb_home_access'] = 'Pristupite kursu';
$string['vvveb_home_automatically_catalogo'] = 'Nemojte uređivati. Ovaj blok će biti automatski zamenjen katalogom kurseva.';
$string['vvveb_home_automatically_category'] = 'Nemojte uređivati. Ovaj blok će biti automatski zamenjen kategorijama kurseva.';
$string['vvveb_home_automatically_my_course'] = 'Ne uređujte. Ovaj blok će automatski biti zamenjen kursom na koji je student upisan.';
$string['vvveb_home_automatically_popular'] = 'Nemojte uređivati. Ovaj blok će biti automatski zamenjen najpopularnijim kursevima.';
$string['vvveb_home_catalogo_heading'] = 'Katalog kurseva';
$string['vvveb_home_category_heading'] = 'Kategorije kurseva';
$string['vvveb_home_mycourses_heading'] = 'Moji kursevi';
$string['vvveb_home_popular_course'] = 'Popularni kursevi';
$string['vvveb_home_team_subtitle'] = 'Mi smo grupa profesionalaca posvećenih svom radu';
$string['vvveb_home_team_title'] = 'Upoznajte naš tim';
