<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'bigbluebuttonbn', language 'sk', version '4.5'.
 *
 * @package     bigbluebuttonbn
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['acceptdpa'] = 'Rozumiem a súhlasím so zmluvou o spracovaní údajov';
$string['activityoverview'] = 'Máte nadchádzajúce BigBlueButton stretnutie(a)';
$string['bbbduetimeoverstartingtime'] = 'Čas zatvorenia musí byť neskorší ako čas otvorenia.';
$string['bbbdurationwarning'] = 'Maximálna doba trvania tohto stretnutia je %duration% minúty';
$string['bbbrecordallfromstartwarning'] = 'Toto stretnutie je nahrávané od začiatku';
$string['bbbrecordwarning'] = 'Toto stretnutie môže byť nahrávané';
$string['bigbluebuttonbn'] = 'Edulive';
$string['bigbluebuttonbn:addinstance'] = 'Pridať novú BigBlueButton miestnosť';
$string['bigbluebuttonbn:addinstancewithmeeting'] = 'Vytvorte inštanciu živých relácií';
$string['bigbluebuttonbn:addinstancewithrecording'] = 'Vytvorte inštanciu pomocou nahrávok';
$string['bigbluebuttonbn:deleterecordings'] = 'Odstrániť nahrávky';
$string['bigbluebuttonbn:importrecordings'] = 'Importovať nahrávky';
$string['bigbluebuttonbn:join'] = 'Pripoj sa k BigBlueButton učebni';
$string['bigbluebuttonbn:managerecordings'] = 'Spravovať BigBlueButton nahrávky';
$string['bigbluebuttonbn:protectrecordings'] = 'Chrániť nahrávky';
$string['bigbluebuttonbn:publishrecordings'] = 'Publikovať nahrávky';
$string['bigbluebuttonbn:unprotectrecordings'] = 'Zrušiť ochranu nahrávok';
$string['bigbluebuttonbn:unpublishrecordings'] = 'Zrušiť publikovanie nahrávok';
$string['bigbluebuttonbn:view'] = 'Zobraziť BigBlueButton miestnosť';
$string['bigbluebuttondisablednotification'] = 'Modul aktivity BigBlueButton bol deaktivovaný a žiadne existujúce aktivity kurzu BigBlueButton nie sú momentálne prístupné. Pred opätovným povolením tohto doplnku sa uistite, že ste si prečítali a prijali <a href="{$a}" target="_blank">zmluvu o spracovaní údajov</a> so spoločnosťou Blindside Networks Inc.';
$string['bigbluebuttondisablednotification_subject'] = 'Modul aktivity BigBlueButton je vypnutý.';
$string['cachedef_currentfetch'] = 'Údaje na zoznam všetkých nedávno stiahnutých záznamov.';
$string['cachedef_recordings'] = 'Metadáta záznamu';
$string['cachedef_serverinfo'] = 'Informácie o vzdialenom serveri';
$string['cachedef_validatedurls'] = 'Vyrovnávacia pamäť overených kontrol adries URL';
$string['calendarstarts'] = '{$a} je naplánovaná na';
$string['cannotperformaction'] = 'Na tejto nahrávke nie je možné vykonať akciu {$a}';
$string['completionattendance'] = 'Študent sa musí zúčastniť relácie:';
$string['completionattendance_desc'] = 'Vstúpiť do miestnosti a zostať v nej aspoň {$a} minút.';
$string['completionattendance_event_desc'] = 'Študent vstúpil do učebne a zostal v relácii aspoň {$a} minút';
$string['completionattendancegroup'] = 'Vyžadovať účasť';
$string['completionattendancegroup_help'] = 'Na dokončenie je potrebná účasť (n) minút na stretnutí.';
$string['completionengagement_desc'] = 'Zapojiť sa do aktivít počas stretnutia.';
$string['completionengagementchats'] = 'Chaty';
$string['completionengagementchats_desc'] = 'Zúčastniť sa {$a} četov.';
$string['completionengagementchats_event_desc'] = 'Vyvolané {$a} chatov';
$string['completionengagementemojis'] = 'Emotikony';
$string['completionengagementemojis_desc'] = 'Zmeniť svoje emotikony {$a}-krát.';
$string['completionengagementemojis_event_desc'] = 'Zmenil svoje emotikony {$a}-krát.';
$string['completionengagementgroup'] = 'Vyžadovať účasť';
$string['completionengagementgroup_help'] = 'Na absolvovanie je potrebná aktívna účasť počas relácie.';
$string['completionengagementpollvotes'] = 'Hlasovanie';
$string['completionengagementpollvotes_desc'] = 'Hlasovať v anketách {$a}-krát.';
$string['completionengagementpollvotes_event_desc'] = 'Odpovedal(a) v {$a} hlasoch v ankete';
$string['completionengagementraisehand'] = 'Vyžadovať hlasovania';
$string['completionengagementraisehand_desc'] = 'Hlasovať {$a}krát.';
$string['completionengagementraisehand_event_desc'] = 'Vyvolaných {$a} hlasovaní';
$string['completionengagementtalks'] = 'Diskusia';
$string['completionengagementtalks_desc'] = 'Hovoriť {$a}-krát';
$string['completionengagementtalks_event_desc'] = 'Vyvolaných {$a} rozhovorov';
$string['completionupdatestate'] = 'Stav aktualizácie dokončenia';
$string['completionvalidatestate'] = 'Potvrdiť dokončenie';
$string['completionvalidatestatetriggered'] = 'Bolo spustené overenie dokončenia.';
$string['completionview'] = 'Vyžadovať zobrazenie';
$string['completionview_desc'] = 'Študent si musí miestnosť prezrieť, aby ju dokončil.';
$string['completionview_event_desc'] = 'Prezrel si miestnosť.';
$string['config_default_messages'] = 'Predvolené správy';
$string['config_default_messages_description'] = 'Nastavte predvolené hodnoty správ pre aktivity';
$string['config_disablecam_default'] = 'Vo východiskovom nastavení zakázať webovú kameru';
$string['config_disablecam_default_description'] = 'Ak je povolené, budú webové kamery zakázané.';
$string['config_disablecam_editable'] = 'Zákaz webovej kamery je možné upraviť';
$string['config_disablecam_editable_description'] = 'Vo východiskovom nastavení možno zakázať webovú kameru, ktorú možno upraviť pridaním alebo aktualizáciou inštancie.';
$string['config_disablemic_default'] = 'Vo východiskovom nastavení zakázať mikrofón';
$string['config_disablemic_default_description'] = 'Ak je povolené, mikrofóny budú zakázané.';
$string['config_disablemic_editable'] = 'Zákaz mikrofónu je možné upraviť';
$string['config_disablemic_editable_description'] = 'Vo východiskovom nastavení možno zakázať mikrofón, ale možno upraviť pridaním alebo aktualizáciou inštancie.';
$string['config_disablenote_default'] = 'Vo východiskovom nastavení zakázať zdieľané poznámky';
$string['config_disablenote_default_description'] = 'Ak je povolené, zdieľané poznámky nebudú zakázané.';
$string['config_disablenote_editable'] = 'Zákaz zdieľaných poznámok možno upraviť';
$string['config_disablenote_editable_description'] = 'Vo východiskovom nastavení možno zakázať zdieľané poznámky, ktoré možno upraviť pridaním alebo aktualizáciou inštancie.';
$string['config_disableprivatechat_default'] = 'Vo východiskovom nastavení je zakázaný súkromný chat';
$string['config_disableprivatechat_default_description'] = 'Ak je povolené, súkromný chat bude zakázaný.';
$string['config_disableprivatechat_editable'] = 'Zakázať súkromný chat je možné upraviť';
$string['config_disableprivatechat_editable_description'] = 'Vo východiskovom nastavení možno zakázať súkromný chat, ktorý možno upraviť pridaním alebo aktualizáciou inštancie.';
$string['config_disablepublicchat_default'] = 'Vo východiskovom nastavení zakázať verejný chat';
$string['config_disablepublicchat_default_description'] = 'Ak je povolené, bude verejný chat zakázaný.';
$string['config_disablepublicchat_editable'] = 'Zákaz verejného chatu je možné upraviť';
$string['config_disablepublicchat_editable_description'] = 'Vo východiskovom nastavení možno zakázať verejný chat, ktorý možno upraviť pridaním alebo aktualizáciou inštancie.';
$string['config_dpa_note'] = 'Poznámka: Aby ste splnili svoje povinnosti týkajúce sa ochrany údajov, pred použitím poskytovateľa služieb pre tento doplnok sa musíte uistiť, že ste si prečítali a prijali zmluvu o spracovaní údajov poskytovateľa služieb. Pre predvolenú bezplatnú službu BigBlueButton je to <a href="{$a}" target="_blank">zmluva o spracovaní údajov spoločnosti Blindside Networks</a>. Poraďte sa so svojimi odborníkmi na ochranu osobných údajov.';
$string['config_experimental_features'] = 'Experimentálne funkcie';
$string['config_experimental_features_description'] = 'Konfigurácia experimentálnych funkcií.';
$string['config_extended_capabilities'] = 'Rozšírené možnosti';
$string['config_extended_capabilities_description'] = 'Konfigurácia pre rozšírené možnosti ak ich ponúka server BigBlueButton.';
$string['config_general'] = 'Všeobecné nastavenia';
$string['config_general_description'] = 'Na nastavenie BigBlueButton môžete použiť svoj vlastný server a prihlasovacie údaje BigBlueButton alebo získať prihlasovacie údaje prostredníctvom <a href="https://registration-portal.blindsidenetworks.com/" target="_blank">Registračného portálu Blindside Networks (otvorí sa v novom okne)</a>.';
$string['config_guestaccess_enabled'] = 'Externý prístup pre hostí';
$string['config_guestaccess_enabled_description'] = 'Umožniť používateľom bez účtu na vašom portáli prístup do miestnosti.';
$string['config_hideuserlist_default'] = 'Vo východiskovom nastavení skryť zoznam používateľov';
$string['config_hideuserlist_default_description'] = 'Ak je povolené, zoznam používateľov bude skrytý.';
$string['config_hideuserlist_editable'] = 'Skrytie zoznamu používateľov je možné upraviť';
$string['config_hideuserlist_editable_description'] = 'Vo východiskovom nastavení možno zakázať skrytie zoznamu používateľov, ktoré možno upraviť pridaním alebo aktualizáciou inštancie.';
$string['config_importrecordings'] = 'Import nahrávok';
$string['config_importrecordings_description'] = 'Tieto nastavenia sú špecifické pre funkciu';
$string['config_importrecordings_enabled'] = 'Umožnenie prenosu nahrávok';
$string['config_importrecordings_enabled_description'] = 'Keď je táto a funkcia nahrávania umožnená, je možné do tejto aktivity preniesť nahrávky z rôznych kurzov.';
$string['config_importrecordings_from_deleted_enabled'] = 'Prenesenie nahrávok z vymazaných aktivít je umožnené';
$string['config_importrecordings_from_deleted_enabled_description'] = 'Ak táto a funkcia prenosu nahrávok je umožnená, je možné preniesť nahrávky z aktivít, ktoré už nie sú súčasťou kurzu.';
$string['config_locksettings'] = 'Konfigurácia nastavení uzamknutia';
$string['config_locksettings_description'] = 'Tieto nastavenia povoľujú alebo zakazujú možnosti v používateľskom rozhraní pre nastavenia uzamknutia a tiež definujú predvolené hodnoty pre tieto možnosti.';
$string['config_meetingevents_enabled'] = 'Registrovať živé relácie';
$string['config_meetingevents_enabled_description'] = 'Ak je povolená, živé relácie sa spracujú po skončení relácie. Táto funkcia je potrebná na dokončenie aktivity a bude fungovať iba vtedy, ak server BigBlueButton dokáže spracovať skripty post_events.';
$string['config_muteonstart'] = 'Stlmiť zvuk na začiatku';
$string['config_muteonstart_default'] = 'Stlmiť zvuk od začiatku predvolené';
$string['config_muteonstart_default_description'] = 'Ak je to možné, stretnutie bude mať stlmený zvuk na začiatku.';
$string['config_muteonstart_description'] = 'Tieto nastavenia umožňujú a znemožňujú voľby v UI a taktiež definujú predvolené hodnoty pre tieto voľby.';
$string['config_muteonstart_editable'] = 'Stlmenie zvuku na začiatku môže byť upravené';
$string['config_muteonstart_editable_description'] = 'Stlmiť zvuk na začiatku predvolením môže byť upravené, ak je pridané alebo upravené pripojenie.';
$string['config_participant'] = 'Účastnici';
$string['config_participant_description'] = 'Tieto nastavenia definujú predvolenú rolu pre účastníkov.';
$string['config_participant_moderator_default'] = 'Moderátor';
$string['config_participant_moderator_default_description'] = 'Toto pravidlo je predvolené, ak je pridaná nová miestnosť.';
$string['config_poll_interval'] = 'Interval prieskumu (v sekundách) na obnovenie stavu miestnosti';
$string['config_poll_interval_description'] = 'Interval hlasovania musí byť aspoň 2 sekundy. V prípade potreby môžete znížiť zaťaženie vzdialeného servera zvýšením intervalu.';
$string['config_presentation_default'] = 'Predvolený súbor prezentácie';
$string['config_presentation_default_description'] = 'Súbor môže byť poskytnutý na použitie vo všetkých učebniach.';
$string['config_preuploadpresentation'] = 'Predbežná prezentácia';
$string['config_preuploadpresentation_description'] = 'Tieto nastavenia povoľujú alebo zakazujú možnosti v používateľskom rozhraní a tiež definujú predvolené hodnoty pre tieto možnosti. Táto funkcia funguje iba vtedy, ak je server Moodle dostupný pre BigBlueButton.';
$string['config_preuploadpresentation_editable'] = 'Pred odovzdaním prezentácie je možné upravovať';
$string['config_preuploadpresentation_editable_description'] = 'Funkciu prezentácie pred odovzdaním je možné upravovať v používateľskom rozhraní pri pridávaní alebo aktualizácii miestnosti alebo konferencie.';
$string['config_recording'] = 'Záznam';
$string['config_recording_all_from_start_default'] = 'Spustiť nahrávanie od začiatku';
$string['config_recording_all_from_start_default_description'] = 'Malo by byť pri pridávaní novej miestnosti BigBlueButton štandardne povolené nastavenie „Spustiť nahrávanie od začiatku“?';
$string['config_recording_all_from_start_editable'] = 'Nahrávanie od začiatku môže byť upravované';
$string['config_recording_all_from_start_editable_description'] = 'Mala by byť možnosť „Spustiť nahrávanie od začiatku“ upraviteľná v nastaveniach aktivity BigBlueButton?';
$string['config_recording_default'] = 'Nahrávanie je predvolene povolené';
$string['config_recording_default_description'] = 'Malo by byť pri pridávaní novej miestnosti BigBlueButton štandardne povolené nastavenie „Relácia môže byť zaznamenaná“?';
$string['config_recording_description'] = 'Tieto nastavenia sú špecifické pre danú funkciu';
$string['config_recording_editable'] = 'Relácia môže byť zaznamenaná - je možné upravovať';
$string['config_recording_editable_description'] = 'Mala by byť možnosť „Relácia sa dá zaznamenať“ upraviteľná v nastaveniach aktivity BigBlueButton?';
$string['config_recording_hide_button_default'] = 'Tlačidlo na skrytie nahrávania';
$string['config_recording_hide_button_default_description'] = 'Ak je to zaškrtnuté, tak sa tlačidlo nahrávania skryje';
$string['config_recording_hide_button_editable'] = 'Tlačidlo "skryť nahrávanie" môže byť upravené';
$string['config_recording_hide_button_editable_description'] = 'Má byť možnosť „Skryť tlačidlo nahrávania“ upraviteľná v nastaveniach aktivity BigBlueButton?';
$string['config_recording_protect_editable'] = 'Stav chránených nahrávok je možné upravovať';
$string['config_recording_protect_editable_description'] = 'Ak je začiarknuté, rozhranie obsahuje možnosť ochrany/zrušenia ochrany nahrávok.';
$string['config_recording_refresh_period'] = 'Doba obnovenia záznamu (v sekundách)';
$string['config_recording_refresh_period_description'] = 'Ako často by sa mal server BigBlueButton dotazovať na obnovenie vzdialených informácií pre nahrávku?';
$string['config_recordingready_enabled'] = 'Odoslať oznámenie o dostupnosti záznamu';
$string['config_recordingready_enabled_description'] = 'Ak je povolené, upozornenie sa odošle, keď bude dostupný odkaz na nahrávanie. Táto funkcia vyžaduje, aby bol na serveri BigBlueButton povolený skript post_publish_recording_ready_callback.';
$string['config_recordings'] = 'Zobraziť nahrávky';
$string['config_recordings_asc_sort'] = 'Zoraď nahrávky v vzostupnom poradí.';
$string['config_recordings_asc_sort_description'] = 'Predvolené zoradenie nahrávok je zostupné. Pri kontrole sa zoradia podľa vzostupného poradia.';
$string['config_recordings_deleted_default'] = 'Vloženie nahrávok z vymazaných ativít je umožnené pôvodným nastavením';
$string['config_recordings_deleted_default_description'] = 'Ak je povolené, tabuľka záznamov bude obsahovať záznamy všetkých aktivít, ktoré boli medzitým vymazané.';
$string['config_recordings_deleted_editable'] = 'Funkcia "Vlož nahrávky z vymazaných aktivít" môže byť upravená';
$string['config_recordings_deleted_editable_description'] = 'Predvolená funkcia "Vlož nahrávky z vymazaných" môže byť upravená ak je pridané alebo upravené pripojenie.';
$string['config_recordings_description'] = 'Tieto nastavenia sú funkčne špecifické';
$string['config_recordings_general'] = 'Ukáž nastavenia nahrávania';
$string['config_recordings_general_description'] = 'Tieto nastavenia sa používajú iba keď sa ukazujú nahrávky';
$string['config_recordings_imported_default'] = 'Ukáž iba prenesené adresy umožnené prednadstavením';
$string['config_recordings_imported_default_description'] = 'Ak je to možné, nahrávacia tabuľka bude obsahovať iba prenesené adresy do nahrávania.';
$string['config_recordings_imported_editable'] = 'Funkcia "Ukáž iba prenesené adresy" môže byť upravená';
$string['config_recordings_imported_editable_description'] = 'Nastavenie "Ukáž iba prenesené adresy" môže byť upravené, ak je pridané alebo upravené pripojenie';
$string['config_recordings_preview_default'] = 'Náhľad je umožnený ako predvolená funkcia';
$string['config_recordings_preview_default_description'] = 'Ak je to umožnené, tabuľka obsahuje náhľad prezentácie.';
$string['config_recordings_preview_editable'] = 'Funkcia náhľadu môže byť upravená';
$string['config_recordings_preview_editable_description'] = 'Funkcia náhľadu môže byť upravená ak je pridané alebo upravené pripojenie.';
$string['config_scheduled'] = 'Plánované sedenia';
$string['config_scheduled_description'] = 'Tieto nastavenia definujú predvolené správanie pre plánované relácie.';
$string['config_scheduled_pre_opening'] = 'Prístupné pred časom otvorenia';
$string['config_scheduled_pre_opening_description'] = 'Čas v minútach, počas ktorého je miestnosť otvorená pred plánovaným otváracím časom.';
$string['config_server_url'] = 'URL adresa servera BigBlueButton';
$string['config_server_url_description'] = 'Predvolené prihlasovacie údaje sú pre <a href="https://bigbluebutton.org/free-bigbluebutton-service-for-moodle/" target="_blank">bezplatnú službu BigBlueButton pre Moodle (otvorí sa v novom okne)</a > poskytované spoločnosťou Blindside Networks s nasledujúcimi obmedzeniami:
<ol>
<li>Maximálna dĺžka každej relácie je 60 minút</li>
<li>Maximálny počet súbežných používateľov na reláciu je 25</li>
<li>Platnosť nahrávok vyprší po siedmich (7) dňoch a nie je možné ich stiahnuť</li>
<li>Študentské webové kamery sú viditeľné iba pre moderátora.</li>
</ol>';
$string['config_shared_secret'] = 'Zdieľaný klúč BigBlueButton';
$string['config_shared_secret_description'] = 'Bezpečnostné heslo vášho servera BigBlueButton. Predvolené heslo je pre bezplatnú službu BigBlueButton poskytovanú spoločnosťou Blindside Networks.';
$string['config_uidelegation_enabled'] = 'UI delegovanie je umožnené';
$string['config_uidelegation_enabled_description'] = 'Tieto nastavenia umožňujú alebo znemožňujú UI delegovanie na server BigBlueButton.';
$string['config_userlimit'] = 'Limit používateľov';
$string['config_userlimit_default'] = 'Limit používateľov umožnený prednastavením';
$string['config_userlimit_default_description'] = 'Počet povolených používateľov v relácii vo východiskovom nastavení pri pridaní nových učební. Ak je číslo nastavené na 0, nie je nastavený žiadny limit.';
$string['config_userlimit_description'] = 'Tieto nastavenia umožňujú alebo znemožňujú voľby v UI a taktiež definujú hodnoty týchto volieb.';
$string['config_userlimit_editable'] = 'Funkcia limit používateľov môže byť upravená';
$string['config_userlimit_editable_description'] = 'Predvolený povolený počet používateľov môže byť upravený, ak sa pridá alebo upraví nová miestnosť alebo konferencia.';
$string['config_voicebridge'] = 'Hlasový most';
$string['config_voicebridge_description'] = 'Tieto nastavenia umožňujú alebo znemožňujú voľby v UI a tiež definujú prednadstavené hodnoty pre tieto voľby.';
$string['config_voicebridge_editable'] = 'Konferenčný hlasový most je upravený';
$string['config_voicebridge_editable_description'] = 'Konferenčný hlasový most môže byť nastálo priradený do miestnosti. Potom, čo bol priradený, číslo už nesmie byť použité žiadnou inou miestnosťou alebo konferenciou';
$string['config_waitformoderator'] = 'Čakajte na moderátora';
$string['config_waitformoderator_cache_ttl'] = 'Počkať na moderátora rýchla pamäť TTL (sekundy)';
$string['config_waitformoderator_cache_ttl_description'] = 'Na podporu veľkého náporu klientov pripojenie využíva rýchlu pamäť. Tento parameter definuje obdobie, počas ktorého sa podrží rýchla pamäť, kým sa neodošle ďalšia žiadosť na server BigBlueButton.';
$string['config_waitformoderator_default'] = 'Počkaj na moderátora je sprístupnené v predvoľbe';
$string['config_waitformoderator_default_description'] = 'Čakanie na moderátora je štandardne povolené pri pridávaní nových učební.';
$string['config_waitformoderator_description'] = 'Tieto nastavenia sú špecifické pre funkciu';
$string['config_waitformoderator_editable'] = 'Čakanie na moderátora možno upraviť';
$string['config_waitformoderator_editable_description'] = 'Mala by byť možnosť „Čakať na moderátora“ upraviteľná v nastaveniach aktivity BigBlueButton?';
$string['config_waitformoderator_ping_interval'] = 'Počkaj na moderátora cinknutie (sekundy)';
$string['config_waitformoderator_ping_interval_description'] = 'Ako často by mal byť serveru poslaný ping, aby sa skontrolovalo, či moderátor vstúpil do miestnosti?';
$string['config_warning_bigbluebuttonbn_cfg_deprecated'] = 'BigBlueButton využíva súbor config.php s globálnou premennou, ktorá bola zastaraná. Zmeňte súbor, pretože v budúcich verziách to nebude podporované.';
$string['config_warning_curl_not_installed'] = 'Táto funkcia vyžadue inštaláciu a spustenie CURL rozšírenia pre php. Nastavenie bude sprístupnené iba ak je splnená táto podmienka.';
$string['config_welcome_default'] = 'Predvolená uvítacia správa';
$string['config_welcome_default_description'] = 'Keď účastníci vstúpia do miestnosti, zobrazí sa uvítacia správa. Ak pole zostane prázdne, zobrazí sa správa nastavená na serveri BigBlueButton.';
$string['config_welcome_editable'] = 'Predvolenú uvítaciu správu môžu upravovať učitelia';
$string['config_welcome_editable_description'] = 'Uvítaciu správu je možné upraviť po pridaní alebo aktualizácii inštancie';
$string['enablingbigbluebutton'] = 'Povolenie aktivity BigBlueButton';
$string['enablingbigbluebuttondpainfo'] = 'Aby ste splnili svoje povinnosti týkajúce sa ochrany údajov, pred povolením tohto doplnku sa možno budete musieť uistiť, že ste si prečítali a prijali <a href="{$a}" target="_blank">zmluvu o spracovaní údajov spoločnosti Blindside Networks</a>. Poraďte sa so svojimi odborníkmi na ochranu osobných údajov.';
$string['end_session_confirm'] = 'Naozaj chcete ukončiť reláciu?';
$string['end_session_confirm_title'] = 'Naozaj ukončiť reláciu?';
$string['end_session_notification'] = 'Relácia bola ukončená.';
$string['ends_at'] = 'Končí';
$string['event_activity_created'] = 'Aktivita vytvorená';
$string['event_activity_deleted'] = 'Aktivita vymazaná';
$string['event_activity_updated'] = 'Aktivita aktualizovaná';
$string['event_live_session'] = 'Schôdza naživo';
$string['event_meeting_created'] = 'Schôdza vytvorená';
$string['event_meeting_ended'] = 'Schôdza nútene ukončená';
$string['event_meeting_joined'] = 'Schôdza pripojená';
$string['event_meeting_left'] = 'Schôdza prebehla';
$string['event_recording_deleted'] = 'Nahrávka vymazaná';
$string['event_recording_edited'] = 'Nahrávka upravená';
$string['event_recording_imported'] = 'Nahrávka importovaná';
$string['event_recording_protected'] = 'Nahrávka chránená';
$string['event_recording_published'] = 'Nahrávka zverejnená';
$string['event_recording_unprotected'] = 'Nahrávka nechránená';
$string['event_recording_unpublished'] = 'Nahrávka nezverejnená';
$string['event_recording_viewed'] = 'Nahrávka zobrazená';
$string['event_unknown'] = 'Neznáma udalosť';
$string['general_error_cannot_create_meeting'] = 'Reláciu nie je možné vytvoriť.';
$string['general_error_cannot_get_recordings'] = 'Nie je možné získať nahrávky.';
$string['general_error_no_answer'] = 'Prázdna odpoveď. Skontrolujte adresu URL servera BigBlueButton. A skontrolujte, či je server BigBlueButton spustený.';
$string['general_error_not_allowed_to_create_instances'] = 'Používateľovi nie je dovolené vytvárať akýkoľvek typ inštancie.';
$string['general_error_not_found'] = 'Nie je možné nájsť aktivitu BigBlueButton s ID {$a}.';
$string['general_error_unable_connect'] = 'Nedá sa pripojiť. Skontrolujte adresu URL servera BigBlueButton A skontrolujte, či je server BigBlueButton spustený.
Podrobnosti: {$a}';
$string['guest_invitation_full_message'] = 'Dobrý deň,
<p>Ste pozvaní na reláciu BigBlueButton <strong>{$a->name}</strong> v kurze {$a->course_fullname}.</p>
<p>Odkaz: {$a->guestjoinurl}<br/>
<p>Heslo: {$a->heslo hosťa}</p>
<p>Ak potrebujete pomoc, kontaktujte {$a->sender}.</p>';
$string['guest_invitation_small_message'] = 'Dobrý deň,

Pozývame vás na reláciu BigBlueButton {$a->name} v kurze {$a->course_fullname}.

Odkaz: {$a->guestjoinurl}
Heslo: {$a->heslo hosťa}

Ak potrebujete pomoc, kontaktujte {$a->sender}.';
$string['guest_invitation_subject'] = 'Pozvánka: {$a->name} stretnutie v {$a->course_fullname}';
$string['guestaccess_activitynotfound'] = 'Aktivita nebola nájdená';
$string['guestaccess_add'] = 'Pridať hostí';
$string['guestaccess_add_no_id'] = 'Nebolo poskytnuté ID inštancie BigBlueButton.';
$string['guestaccess_copy_password'] = 'Skopírovať heslo';
$string['guestaccess_emails'] = 'Maily hostí';
$string['guestaccess_emails_help'] = 'Zoznam e-mailových adries oddelených čiarkami.';
$string['guestaccess_emails_invalidemail'] = 'Neplatný e-mail: {$a}';
$string['guestaccess_feature_disabled'] = 'Prístup pre hostí je zakázaný.';
$string['guestaccess_invite_failure'] = 'Chyba {$a->errors} pri pozývaní {$a->emails}.';
$string['guestaccess_invite_success'] = 'Pozvánka bude odoslaná na {$a->emails}.';
$string['guestaccess_join_meeting'] = 'Pripojiť sa k schôdzi';
$string['guestaccess_meeting_invalid_password'] = 'Nesprávne heslo.';
$string['guestaccess_meeting_not_started'] = 'Stretnutie sa ešte nezačalo. Prosím vráťte sa neskôr.';
$string['guestaccess_meeting_password'] = 'Heslo stretnutia';
$string['guestaccess_password'] = 'Heslo';
$string['guestaccess_title'] = 'Pridať hostí k tomuto stretnutiu';
$string['guestaccess_username'] = 'Používateľské meno hosťa';
$string['index_confirm_end'] = 'Prajete si ukončiť reláciu?';
$string['index_disabled'] = 'zablokované';
$string['index_enabled'] = 'povolené';
$string['index_ending'] = 'Ukončujem reláciu ... prosím čakajte';
$string['index_error_bbtn'] = 'BigBlueButton ID {$a} je nesprávny';
$string['index_error_checksum'] = 'Chyba kontrolného účtu. Skontrolujte, či ste použili správne heslo.';
$string['index_error_forciblyended'] = 'Znemožnené pripojenie k relácii, pretože bola ručne ukončená.';
$string['index_error_noinstances'] = 'Neexistujú žiadne príklady miestností BigBlueButton';
$string['index_error_unable_display'] = 'Nie je možné zobraziť relácie. Skontrolujte adresu URL servera BigBlueButton. A skontrolujte, či je server BigBlueButton spustený.';
$string['index_heading'] = 'Učebne BigBlueButton';
$string['index_heading_actions'] = 'Akcie';
$string['index_heading_group'] = 'Skupina';
$string['index_heading_moderator'] = 'Moderátori';
$string['index_heading_name'] = 'Miestnosť';
$string['index_heading_recording'] = 'Nahrávanie';
$string['index_heading_users'] = 'Používatelia';
$string['index_heading_viewer'] = 'Poslucháči';
$string['indicator:cognitivedepth'] = 'BigBlueButton kognitivny';
$string['indicator:cognitivedepth_help'] = 'Tento indikátor je založený na hĺbke vzdelania získaného študentom v aktivite BigBlueButton.';
$string['indicator:socialbreadth'] = 'BigBlueButton sociálny';
$string['indicator:socialbreadth_help'] = 'Tento ukazovateľ je založený na študentom získanom sociálnom šírení v aktivitách BigBlueButton.';
$string['instance_type_default'] = 'Miestnosť s nahrávkami';
$string['instance_type_recording_only'] = 'Iba nahrávky';
$string['instance_type_room_only'] = 'Iba učebňa';
$string['instanceprofilewithoutrecordings'] = 'Tento profil inštancie nemôže zobraziť nahrávky';
$string['messageprovider:instance_updated'] = 'Relace BigBlueButton bola aktualizovaná';
$string['messageprovider:recording_ready'] = 'Nahrávka BigBlueButton je k dispozícii';
$string['minute'] = 'minúta';
$string['minutes'] = 'minúty';
$string['mod_form_block_general'] = 'Všeobecné';
$string['mod_form_block_guestaccess'] = 'Hosťovský prístup';
$string['mod_form_block_participants'] = 'Účastníci';
$string['mod_form_block_presentation'] = 'Súbor prezentácie';
$string['mod_form_block_presentation_default'] = 'Pôvodný súbor prezentácie';
$string['mod_form_block_record'] = 'Nastavenia nahrávky';
$string['mod_form_block_recordings'] = 'Zobraziť záznam';
$string['mod_form_block_room'] = 'Nastavenia miestnosti';
$string['mod_form_block_schedule'] = 'Načasovanie relácie';
$string['mod_form_field_closingtime'] = 'Zavrieť';
$string['mod_form_field_conference_name'] = 'Názov relácie';
$string['mod_form_field_disablecam'] = 'Zakázať webové kamery';
$string['mod_form_field_disablemic'] = 'Zakázať mikrofóny';
$string['mod_form_field_disablenote'] = 'Zakázať zdieľané poznámky';
$string['mod_form_field_disableprivatechat'] = 'Zakázať súkromný chat';
$string['mod_form_field_disablepublicchat'] = 'Zakázať verejný chat';
$string['mod_form_field_duration'] = 'Trvanie';
$string['mod_form_field_duration_help'] = 'Nastavenie trvania schôdzky umožní maximálny čas trvania schôdzky pred ukončením nahrávania';
$string['mod_form_field_guestallowed'] = 'Povoliť hosťovský prístup';
$string['mod_form_field_hideuserlist'] = 'Skryť zoznam používateľov';
$string['mod_form_field_instanceprofiles'] = 'Typ inštancie';
$string['mod_form_field_instanceprofiles_help'] = 'Ak sa má relácia nahrávať, vyberte „Miestnosť s nahrávkami“, inak „Iba miestnosť“. Po zaznamenaní relácie, ak už nebudú žiadne ďalšie relácie, vyberte „Len nahrávky“.';
$string['mod_form_field_intro'] = 'Opis';
$string['mod_form_field_intro_help'] = 'Krátky opis miestnosti';
$string['mod_form_field_mustapproveuser'] = 'Pripájajúcich sa hostí musí povoliť moderátor';
$string['mod_form_field_muteonstart'] = 'Stlmiť na začiatku';
$string['mod_form_field_name'] = 'Názov učebne';
$string['mod_form_field_nosettings'] = 'Žiadne nastavenia nemôžu byť upravené';
$string['mod_form_field_openingtime'] = 'Otvoriť';
$string['mod_form_field_participant_add'] = 'Pridať účastníka';
$string['mod_form_field_participant_bbb_role_moderator'] = 'Moderátor';
$string['mod_form_field_participant_bbb_role_viewer'] = 'Poslucháč';
$string['mod_form_field_participant_list'] = 'Účastníci';
$string['mod_form_field_participant_list_action_add'] = 'Pridať';
$string['mod_form_field_participant_list_action_remove'] = 'Odstrániť';
$string['mod_form_field_participant_list_text_as'] = 'pripojiť sa k relácii ako';
$string['mod_form_field_participant_list_type_all'] = 'Všetci zapísaní používatelia';
$string['mod_form_field_participant_list_type_owner'] = 'Majiteľ';
$string['mod_form_field_participant_list_type_role'] = 'Rola';
$string['mod_form_field_participant_list_type_user'] = 'Používateľ';
$string['mod_form_field_record'] = 'Relácia môže byť nahrávaná';
$string['mod_form_field_recordallfromstart'] = 'Nahrať všetko od začiatku';
$string['mod_form_field_recordhidebutton'] = 'Skryť tlačidlo nahrávania';
$string['mod_form_field_recordings_deleted'] = 'Zahrnúť nahrávky z odstránených aktivít';
$string['mod_form_field_recordings_html'] = 'Ukázať tabuľku v jednoduchom html';
$string['mod_form_field_recordings_imported'] = 'Ukázať iba prenesené odkazy';
$string['mod_form_field_recordings_preview'] = 'Ukázať náhľad nahrávky';
$string['mod_form_field_room_name'] = 'Názov miestnosti';
$string['mod_form_field_userlimit'] = 'Limit používateľov';
$string['mod_form_field_userlimit_help'] = 'Maximálny limit používateľov povolených pre reláciu. Ak je limit nastavený ako 0, počet používateľov nebude limitovaný.';
$string['mod_form_field_voicebridge'] = 'Hlasový most [####]';
$string['mod_form_field_voicebridge_format_error'] = 'Chyba formátu. Mali by ste zadať číslo medzi 1 a 9999.';
$string['mod_form_field_voicebridge_help'] = 'Číslo medzi 1 a 9999, ktoré účastníci zadajú, aby sa pripojili k hlasovej relácii pri použití telefonického pripojenia. Ak je hodnota 0, číslo statického hlasového mostíka sa bude ignorovať a BigBlueButton vygeneruje náhodné číslo. Pred štyrmi napísanými číslicami bude predpona číslo 7.';
$string['mod_form_field_voicebridge_notunique_error'] = 'Neplatné číslo. Toto číslo sa už používa pre inú miestnosť.';
$string['mod_form_field_wait'] = 'Počkať na moderátora';
$string['mod_form_field_wait_help'] = 'Účastníci musia čakať na vstup, pokiaľ nevojde moderátor stretnutia?';
$string['mod_form_field_welcome'] = 'Uvítacia správa';
$string['mod_form_field_welcome_default'] = 'Vítajte na %%CONFNAME%%';
$string['mod_form_field_welcome_help'] = 'Keď účastníci vstúpia do miestnosti, zobrazí sa uvítacia správa. Ak pole zostane prázdne, zobrazí sa predvolená správa nastavená v administrácii stránky.';
$string['mod_form_locksettings'] = 'Nastavenie zámky';
$string['modulename'] = 'BigBlueButton';
$string['modulename_help'] = 'BigBlueButton je open-source webový konferenčný systém určený na online vzdelávanie, ktorý podporuje zdieľanie zvuku, videa, chatu, snímok, zdieľanie obrazovky v reálnom čase, tabuľu pre viacerých používateľov, oddelené miestnosti, hlasovanie a emotikony.

Pomocou BigBlueButton môžete vytvoriť miestnosť pre stretnutia, ako sú živé online kurzy, virtuálne pracovné hodiny alebo skupinová spolupráca so vzdialenými študentmi. Reláciu je možné nahrať na neskoršie prehrávanie.';
$string['modulename_link'] = 'BigBlueButton/prehľad';
$string['modulenameplural'] = 'BigBlueButton';
$string['new_bigblubuttonbn_activities'] = 'Aktivita BigBlueButton';
$string['nosuchinstance'] = 'Žiadna taká inštancia {$a->entity} s ID: {$a->id}';
$string['notification_instance_created_intro'] = 'Učebňa <a href="{$a->link}">{$a->name}</a> BigBlueButton bola vytvorená.';
$string['notification_instance_created_small'] = 'Bola vytvorená nová učebňa BigBlueButton s názvom {$a->name}';
$string['notification_instance_created_subject'] = 'Bola vytvorená nová učebňa BigBlueButton';
$string['notification_instance_description'] = 'Opis';
$string['notification_instance_end_date'] = 'Dátum ukončenia';
$string['notification_instance_name'] = 'Nadpis';
$string['notification_instance_start_date'] = 'Dátum začiatku';
$string['notification_instance_updated_intro'] = 'Učebňa <a href="{$a->link}">{$a->name}</a> BigBlueButton bola aktualizovaná.';
$string['notification_instance_updated_small'] = 'Relácia BigBlueButton {$a->name} bola aktualizovaná';
$string['notification_instance_updated_subject'] = 'Vaša učebňa  BigBlueButton bola aktualizovaná';
$string['notification_recording_ready_html'] = 'Teraz je k dispozícii záznam z relácie v učebni BigBlueButton <b><a href="{$a->link}">{$a->name}</a></b>.';
$string['notification_recording_ready_plain'] = 'Teraz je k dispozícii záznam z relácie v učebni BigBlueButton {$a->name}. Pre prístup k odkazu  prejdite na {$a->link}.';
$string['notification_recording_ready_small'] = 'Pre učebňu BigBlueButton {$a->name} je k dispozícii záznam.';
$string['notification_recording_ready_subject'] = 'Nahrávka k dispozícii';
$string['pluginadministration'] = 'BigBlueButton správa';
$string['pluginname'] = 'BigBlueButton';
$string['privacy:metadata:bigbluebutton'] = 'Pre spustenie a pripojenie sa na schôdzku BigBlueButton je potrebné vymeniť si dáta užívateľa so serverom.';
$string['privacy:metadata:bigbluebutton:fullname'] = 'Celé meno používateľa pripájajúceho sa na sever BigBlueButton.';
$string['privacy:metadata:bigbluebutton:userid'] = 'ID používateľa na pripojenie sa k serveru BigBlueButton.';
$string['privacy:metadata:bigbluebuttonbn'] = 'Konfigurácia relácie BigBlueButton';
$string['privacy:metadata:bigbluebuttonbn:participants'] = 'Zoznam pravidiel, ktoré definujú rolu, ktorú budú mať používatelia v relácii BigBlueButton. ID používateľa môže byť uložené, pretože oprávnenie možno udeliť pre rolu alebo používateľa.';
$string['privacy:metadata:bigbluebuttonbn_logs'] = 'Uchováva udalosti spustené po prihlásení.';
$string['privacy:metadata:bigbluebuttonbn_logs:log'] = 'Typ udalosti spustenej používateľom.';
$string['privacy:metadata:bigbluebuttonbn_logs:meetingid'] = 'ID stretnutia, pre ktoré získal používateľ prístup.';
$string['privacy:metadata:bigbluebuttonbn_logs:meta'] = 'Ďalšie informácie týkajúce sa relácie alebo záznamu.';
$string['privacy:metadata:bigbluebuttonbn_logs:timecreated'] = 'Čas, kedy bol protokol vytvorený.';
$string['privacy:metadata:bigbluebuttonbn_logs:userid'] = 'ID používateľa, ktorý spustil udalosť.';
$string['privacy:metadata:bigbluebuttonbn_recordings'] = 'Uložiť metadáta o nahrávkach.';
$string['privacy:metadata:bigbluebuttonbn_recordings:userid'] = 'ID používateľa používateľa, ktorý naposledy zmenil nahrávku.';
$string['recordings_from_deleted_activities'] = 'Záznamy z odstránených aktivít';
$string['recordingurlnotfound'] = 'Adresa URL záznamu je neplatná.';
$string['removedevents'] = 'Vymazané udalosti';
$string['removedlogs'] = 'Vymazané vlastné prihlásenia';
$string['removedrecordings'] = 'Vymazané nahrávky';
$string['removedtags'] = 'Vymazané štítky';
$string['report_join_info'] = '{$a} stretnutí';
$string['report_play_recording_info'] = 'Prehraté nahrávky: {$a}';
$string['report_room_view'] = 'prezerané';
$string['resetevents'] = 'Vymazať udalosti';
$string['resetlogs'] = 'Vymaž vlastné protokoly';
$string['resetlogs_help'] = 'Odstranenie protokolov spôsobí stratu výberu nahrávok.';
$string['resetrecordings'] = 'Vymazať nahrávky';
$string['resetrecordings_help'] = 'Vymazaním nahrávok sa stanú nedostupnými odkiaľkoľvek. Táto akcia sa nedá vrátiť späť!';
$string['resettags'] = 'Vymaž štítky';
$string['search:activity'] = 'BigBlueButton - informácie o aktivitách';
$string['search:tags'] = 'BigBlueButton - informácie o štítkoch';
$string['sendnotification'] = 'Odoslať upozornenie';
$string['settings'] = 'Nastavenie BigBlueButton';
$string['started_at'] = 'Začalo';
$string['starts_at'] = 'Začína';
$string['taskname:check_pending_recordings'] = 'Načítať čakajúce nahrávky';
$string['userlimitreached'] = 'Dosiahol sa počet povolených používateľov v relácii.';
$string['view_conference_action_end'] = 'Ukončiť reláciu';
$string['view_conference_action_join'] = 'Pridať sa k relácii';
$string['view_error_action_not_completed'] = 'Aktivita nemohla byť dokončená';
$string['view_error_bigbluebutton'] = 'BigBlueButton odpovedal s chybami. {$a}';
$string['view_error_create'] = 'BigBlueButton server odovedal s odkazom na chybu, učebňu nebolo možné vytvoriť.';
$string['view_error_current_state_not_found'] = 'Súčasný stav nebol nájdený. Je možné, že nahrávka bola odstránená alebo BigBlueButton server nie je kompatibilný s vykonávanou aktivitou.';
$string['view_error_import_no_courses'] = 'Neexistujú žiadne kurzy na vyhľadávanie nahrávok.';
$string['view_error_import_no_recordings'] = 'V tomto kurze nie sú žiadne nahrávky na import.';
$string['view_error_invalid_session'] = 'Relácia sa skončila. Vráťte sa na hlavnú stránku aktivity.';
$string['view_error_max_concurrent'] = 'Dosiahli ste povolený počet súbežných relácií.';
$string['view_error_meeting_not_running'] = 'Niečo sa pokazilo, relácia neprebieha.';
$string['view_error_no_group'] = 'Neboli nakonfigurované žiadne skupiny. Prosím, založte skupiny pred tým, ako sa pokúsite pripojiť k relácii.';
$string['view_error_no_group_student'] = 'Neboli ste pridaný do skupiny. Prosím kontaktujte svojho učiteľa.';
$string['view_error_no_group_teacher'] = 'Zatiaľ neboli nakonfigurované žiadne skupiny. Prosím, vytvorte skupinu.';
$string['view_error_unable_join'] = 'Nedá sa pripojiť k stretnutiu. Prosím, skontrolujte url serveru BigBlueButton  A skontrolujte, či server BigBlueButton  pracuje.';
$string['view_error_unable_join_student'] = 'Nedá sa pripojiť k BigBlueButton serveru.';
$string['view_error_unable_join_teacher'] = 'Nedá sa pripojiť k serveru BigBlueButton. Prosím, kontaktujte administrátora.';
$string['view_error_url_missing_parameters'] = 'V tomto URL chýbajú parametre';
$string['view_error_userlimit_reached'] = 'Počet povolených užívateľov stretnutia dosiahol maximum.';
$string['view_groups_nogroups_warning'] = 'Miestnosť bola konfigurovaná na používanie skupinami, ale kurz ešte nemá zadefinované skupiny.';
$string['view_groups_notenrolled_warning'] = 'Miestnosť bola nakonfigurovaná na používanie pre skupiny, ale Vy nie ste zapísaný v žiadnej z nich.';
$string['view_groups_selection'] = 'Vyberte skupinu, ku ktorej sa chcete pridať a potvrďte aktivitu';
$string['view_groups_selection_join'] = 'Pripojiť';
$string['view_groups_selection_warning'] = 'Pre každú skupinu existuje učebňa a vy máte prístup do viac ako jednej. Uistite sa, že ste si vybrali tú správnu.';
$string['view_login_moderator'] = 'Prihlásenie sa ako moderátor ...';
$string['view_login_viewer'] = 'Prihlásenie sa ako divák ...';
$string['view_message_and'] = 'a';
$string['view_message_conference_has_ended'] = 'Táto relácia skončila';
$string['view_message_conference_in_progress'] = 'Táto relácia práve prebieha.';
$string['view_message_conference_not_started'] = 'Táto relácia sa ešte nezačala.';
$string['view_message_conference_room_ready'] = 'Táto učebňa je pripravená. Môžete sa pridať k relácii.';
$string['view_message_conference_wait_for_moderator'] = 'Čakanie na pripojenie moderátora.';
$string['view_message_cron_disabled'] = 'Zoznam nahrávok nemusí byť aktuálny. Kontaktujte správcu portálu s nasledujúcimi informáciami: {$a}';
$string['view_message_finished'] = 'Táto aktivita skončila.';
$string['view_message_has_joined'] = 'sa pripojil';
$string['view_message_have_joined'] = 'sa pripojili';
$string['view_message_hour'] = 'hodina';
$string['view_message_hours'] = 'hodín';
$string['view_message_importrecordings_disabled'] = 'Funkcia pre prenos odkazov na nahrávky je na tomto serveri zakázaná.';
$string['view_message_minute'] = 'minúta';
$string['view_message_minutes'] = 'minút';
$string['view_message_moderator'] = 'Moderátor';
$string['view_message_moderators'] = 'Moderátori';
$string['view_message_norecordings'] = 'Nie sú dostupné žiadne nahrávky.';
$string['view_message_notavailableyet'] = 'Táto relácia nie je zatiaľ dostupná.';
$string['view_message_recordings_disabled'] = 'Nahrávky na tomto serveri boli deaktivované. Aktivity BigBlueButton typu "Iba nahrávky" nemôžu byť používané.';
$string['view_message_room_closed'] = 'Táto učebňa je zatvorená.';
$string['view_message_room_open'] = 'Táto učebňa je otvorená.';
$string['view_message_room_ready'] = 'Táto učebňa je pripravená.';
$string['view_message_session_for'] = 'relácia pre';
$string['view_message_session_has_user'] = 'Na stretnutí je';
$string['view_message_session_has_users'] = 'Na stretnutí sú';
$string['view_message_session_no_users'] = 'V tomto stretnutí nie sú pripojení žiadni používatelia';
$string['view_message_session_running_for'] = 'Táto relácia už prebieha';
$string['view_message_session_started_at'] = 'Táto relácia začala o';
$string['view_message_tab_close'] = 'Táto karta/okno sa musí zavrieť manuálne';
$string['view_message_times'] = 'krát';
$string['view_message_user'] = 'Používateľ';
$string['view_message_users'] = 'Používatelia';
$string['view_message_viewer'] = 'Divák';
$string['view_message_viewers'] = 'Diváci';
$string['view_mobile_message_groups_not_supported'] = 'Táto inštancia je schopná pracovať so skupinami, ale mobilná aplikácia ju nepodporuje. Prosím, otvorte desktop, ak chcete využiť skupinovú podporu.';
$string['view_mobile_message_reload_page_creation_time_meeting'] = 'Prekročili ste 45 sekúnd na tejto stránke, prosím, obnovte stránku na správne pripojenie k relácii.';
$string['view_noguests'] = 'BigBlueButton učebna nie je otvorená pre hostí.';
$string['view_nojoin'] = 'Nemáte rolu, ktorá sa môže pripojiť k tejto relácii.';
$string['view_recording'] = 'nahrávanie';
$string['view_recording_actionbar'] = 'Panel nástrojov';
$string['view_recording_activity'] = 'Aktivita';
$string['view_recording_button_import'] = 'Prenes nahraté odkazy';
$string['view_recording_button_return'] = 'Späť';
$string['view_recording_course'] = 'Kurz';
$string['view_recording_date'] = 'Dátum';
$string['view_recording_delete_confirmation'] = 'Naozaj chcete odstrániť {$a}?';
$string['view_recording_delete_confirmation_warning_p'] = 'Táto nahrávka má priradených {$a} odkazov, ktoré boli importované do rôznych kurzov alebo aktivít. Ak sa nahrávka vymaže, odstránia sa aj tieto odkazy.';
$string['view_recording_delete_confirmation_warning_s'] = 'K tejto nahrávke je priradený odkaz {$a}, ktorý bol importovaný do iného kurzu alebo aktivity. Ak je nahrávka smazána, bude tiež odkaz odstránený';
$string['view_recording_description'] = 'Opis';
$string['view_recording_description_edithint'] = 'K identifikácii nahrávky môže byť pridaný opis.';
$string['view_recording_description_editlabel'] = 'Upraviť opis';
$string['view_recording_duration'] = 'Trvanie';
$string['view_recording_duration_min'] = 'min';
$string['view_recording_format_errror_unreachable'] = 'URL pre formát tejto nahrávky je nedostupné.';
$string['view_recording_format_notes'] = 'Poznámky';
$string['view_recording_format_podcast'] = 'Podcast';
$string['view_recording_format_presentation'] = 'Prezentácia';
$string['view_recording_format_screenshare'] = 'Zdieľanie obrazovky';
$string['view_recording_format_statistics'] = 'Štatistiky';
$string['view_recording_format_video'] = 'Video';
$string['view_recording_import_confirmation'] = 'Naozaj chcete importovať túto nahrávku?';
$string['view_recording_length'] = 'Dĺžka';
$string['view_recording_link'] = 'prenesený odkaz';
$string['view_recording_link_warning'] = 'Toto je odkaz poukazujúci na nahrávku, ktorá bola vytvorená na inom kurze alebo aktivite.';
$string['view_recording_list_action_delete'] = 'Vymazanie';
$string['view_recording_list_action_edit'] = 'Upravené';
$string['view_recording_list_action_play'] = 'Hrať';
$string['view_recording_list_action_process'] = 'Spracovanie';
$string['view_recording_list_action_protect'] = 'Ochrana';
$string['view_recording_list_action_publish'] = 'Zverejnenie';
$string['view_recording_list_action_unprotect'] = 'Nechránené';
$string['view_recording_list_action_unpublish'] = 'Nezverejnenie';
$string['view_recording_list_action_update'] = 'Upravené';
$string['view_recording_list_actionbar'] = 'Panel nástrojov';
$string['view_recording_list_actionbar_delete'] = 'Vymazať';
$string['view_recording_list_actionbar_edit'] = 'Upraviť';
$string['view_recording_list_actionbar_hide'] = 'Skryť';
$string['view_recording_list_actionbar_import'] = 'Importovať';
$string['view_recording_list_actionbar_protect'] = 'Urobiť to súkromným';
$string['view_recording_list_actionbar_publish'] = 'Zverejniť';
$string['view_recording_list_actionbar_show'] = 'Ukázať';
$string['view_recording_list_actionbar_unprotect'] = 'Zverejniť';
$string['view_recording_list_actionbar_unpublish'] = 'Nezverejniť';
$string['view_recording_list_activity'] = 'Aktivita';
$string['view_recording_list_course'] = 'Kurz';
$string['view_recording_list_date'] = 'Dátum';
$string['view_recording_list_description'] = 'Opis';
$string['view_recording_list_duration'] = 'Trvanie';
$string['view_recording_list_recording'] = 'Nahrávanie';
$string['view_recording_meeting'] = 'Schôdzka';
$string['view_recording_modal_button'] = 'Použiť';
$string['view_recording_modal_title'] = 'Nastaviť hodnoty pre nahrávanie';
$string['view_recording_name'] = 'Názov';
$string['view_recording_name_edithint'] = 'Možno pridať názov, ktorý pomôže identifikovať nahrávku.';
$string['view_recording_name_editlabel'] = 'Upraviť názov';
$string['view_recording_playback'] = 'Prehrávanie';
$string['view_recording_preview'] = 'Náhľad';
$string['view_recording_preview_help'] = 'Prejdite myškou po obrázku, aby ste ho videli v plnej veľkosti';
$string['view_recording_protect_confirmation'] = 'Naozaj chcete chrániť {$a}?';
$string['view_recording_protect_confirmation_warning_p'] = 'Táto nahrávka má priradených {$a} odkazov, ktoré boli importované do rôznych kurzov alebo aktivít. Ak je nahrávka chránená, ovplyvní to aj importované odkazy.';
$string['view_recording_protect_confirmation_warning_s'] = 'K tejto nahrávke je priradený odkaz {$a}, ktorý bol importovaný do iného kurzu alebo aktivity. Ak je nahrávka chránená, ovplyvní to aj importované odkazy.';
$string['view_recording_publish_confirmation'] = 'Naozaj chcete zverejniť {$a}?';
$string['view_recording_publish_confirmation_warning_p'] = 'Táto nahrávka má priradených {$a} odkazov, ktoré boli importované do rôznych kurzov alebo aktivít. V prípade zverejnenia nahrávky budú zverejnené aj tieto odkazy.';
$string['view_recording_publish_confirmation_warning_s'] = 'K tejto nahrávke je priradený odkaz {$a}, ktorý bol importovaný do iného kurzu alebo aktivity. V prípade zverejnenia nahrávky bude zverejnený aj tento odkaz.';
$string['view_recording_publish_link_deleted'] = 'Tento odkaz nemôže byť znovu zverejnený, pretože originálna nahrávka neexistuje na súčasnom serveri BigBlueButton. Odkaz by mal byť odstránený.';
$string['view_recording_publish_link_not_published'] = 'Tento odkaz nemôže byť znovu zverejnený, pretože originálna nahrávka je nezverejnená.';
$string['view_recording_recording'] = 'Nahrávka';
$string['view_recording_select_course'] = 'Najprv vyberte kurz v rozbaľovacej ponuke';
$string['view_recording_tags'] = 'Štítky';
$string['view_recording_unprotect_confirmation'] = 'Naozaj chcete zrušiť ochranu {$a}?';
$string['view_recording_unprotect_confirmation_warning_p'] = 'Táto nahrávka má priradených {$a} odkazov, ktoré boli importované do rôznych kurzov alebo aktivít. Ak nahrávka nie je chránená, ovplyvní to aj importované odkazy.';
$string['view_recording_unprotect_confirmation_warning_s'] = 'K tejto nahrávke je priradený odkaz {$a}, ktorý bol importovaný do iného kurzu alebo aktivity. Ak nahrávka nie je chránená, ovplyvní to aj importované odkazy.';
$string['view_recording_unprotect_link_deleted'] = 'Tento odkaz nemôže byť nechránený, pretože originálna nahrávka na súčasnom serveri BigBlueButton neexistuje. Odkaz by mal byť odstránený.';
$string['view_recording_unprotect_link_not_unprotected'] = 'Tento odkaz nemôže byť nechránený, pretože originál nahrávky chránený je.';
$string['view_recording_unpublish_confirmation'] = 'Naozaj to chcete nezverejniť {$a}?';
$string['view_recording_unpublish_confirmation_warning_p'] = 'Táto nahrávka sa viaže na odkaz {$a} ktorý bol prenesený v iných kurzoch alebo aktivitách. Ak nie je nahrávka zverejnená, tieto odkazy tiež nebudú zverejnené.';
$string['view_recording_unpublish_confirmation_warning_s'] = 'Táto nahrávka sa viaže na odkaz {$a} ktorý bol prenesený v inom kurze alebo aktivite. Ak nahrávka nie je zverejnená, tento odkaz rovnako nebude zverejnený.';
$string['view_recording_yui_first'] = 'Prvý';
$string['view_recording_yui_go'] = 'Ísť';
$string['view_recording_yui_last'] = 'Posledný';
$string['view_recording_yui_next'] = 'Ďalší';
$string['view_recording_yui_page'] = 'Stránka';
$string['view_recording_yui_prev'] = 'Predošlý';
$string['view_recording_yui_rows'] = 'Riadky';
$string['view_recording_yui_show_all'] = 'Ukáž všetky';
$string['view_room'] = 'Zobraziť miestnoť';
$string['view_section_title_presentation'] = 'Súbor prezentácií';
$string['view_section_title_recordings'] = 'Nahrávky';
$string['view_warning_default_server'] = 'Tento portál používa <a href="https://bigbluebutton.org/free-bigbluebutton-service-for-moodle/" target="_blank">bezplatnú službu BigBlueButton pre Moodle (otvorí sa v novom okne)</a> poskytuje Blindside Networks s nasledujúcimi obmedzeniami:
<ol>
<li>Maximálna dĺžka každej relácie je 60 minút</li>
<li>Maximálny počet súbežných používateľov na reláciu je 25</li>
<li>Platnosť nahrávok vyprší po siedmich (7) dňoch a nie je možné ich stiahnuť</li>
<li>Študentské webové kamery sú viditeľné iba pre moderátora.</li>
</ol>';
$string['waitformoderator'] = 'Čaká sa na pripojenie moderátora.';
