<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'feedback', language 'ro', version '4.5'.
 *
 * @package     feedback
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['add_item'] = 'Adaugă o întrebare';
$string['add_pagebreak'] = 'Adaugă o pagină nouă';
$string['adjustment'] = 'Ajustare';
$string['after_submit'] = 'După ce a fost trimis';
$string['allowfullanonymous'] = 'Permiteți răspuns complet anonimu';
$string['analysis'] = 'Analiză';
$string['anonymous'] = 'Anonim';
$string['anonymous_edit'] = 'Reține numele utilizatorilor';
$string['anonymous_entries'] = 'Postări anonime';
$string['anonymous_user'] = 'Utilizator anonim';
$string['answerquestions'] = 'Răspunde la întrebare';
$string['append_new_items'] = 'Adaugă elemente noi';
$string['autonumbering'] = 'Numerotare automată a întrebărilor';
$string['autonumbering_help'] = 'Activează sau dezactivează numere generate automat pentru fiecare întrebare';
$string['average'] = 'Medie';
$string['bold'] = 'Îngroșat';
$string['calendarend'] = 'Obiectul {$a} se închide';
$string['calendarstart'] = '{$a} se deschide';
$string['cannotaccess'] = 'Poți accesa feedback-ul doar de la un curs';
$string['cannotcreatepagebreak'] = 'O pagină nouă nu poate fi adăugată la început, și doar o singură pagină nouă poate fi adăugată la sfârșit.';
$string['cannotsavetempl'] = 'Nu este permisă salvarea șabloanelor';
$string['captcha'] = 'Captcha';
$string['captchanotset'] = 'Captcha nu a fost trimisă';
$string['check'] = 'Alegere multiplă - răspunsuri multiple';
$string['check_values'] = 'Răspunsuri posibile';
$string['checkbox'] = 'Alegere multiplă - răspunsuri multiple permise (casete de selectare)';
$string['choosefile'] = 'Alege un fișier';
$string['chosen_feedback_response'] = 'Răspuns de feedback ales';
$string['closebeforeopen'] = 'Ai specificat o dată de încheiere înainte de data de începere.';
$string['complete_the_form'] = 'Răspunde la întrebări';
$string['completed'] = 'Completat';
$string['completed_feedbacks'] = 'Răspunsuri trimise';
$string['completedon'] = 'Completat în {$a}';
$string['completiondetail:submit'] = 'Trimite feedback';
$string['completionsubmit'] = 'Trimite feedback';
$string['configallowfullanonymous'] = 'Dacă este setat „da”, vizitatorii pot completa o activitate de tip feedback de pe prima pagină să se autentifice.';
$string['confirmdeleteentry'] = 'Sunteți sigur(ă) că doriți să ștergeți această postare?';
$string['confirmdeleteitem'] = 'Sunteți sigur(ă) că doriți să ștergeți acest element ?';
$string['confirmdeletetemplate'] = 'Sunteți sigur(ă) că doriți să ștergeți acest șablon?';
$string['confirmusetemplate'] = 'Sunteți sigur(ă) că doriți să utilizați acest șablon?';
$string['continue_the_form'] = 'Continuați să răspundeți la întrebări';
$string['count_of_nums'] = 'Numărul de numere';
$string['courseid'] = 'ID-ul cursului';
$string['creating_templates'] = 'Salvați aceste întrebări sub formă de șablon nou';
$string['delete_entry'] = 'Șterge postarea';
$string['delete_item'] = 'Șterge întrebarea';
$string['delete_old_items'] = 'Șterge elementele vechi';
$string['delete_pagebreak'] = 'Ștergeți întreruperea de pagină';
$string['delete_template'] = 'Șterge șablonul';
$string['delete_templates'] = 'Șterge șablonul...';
$string['depending'] = 'Dependențe';
$string['depending_help'] = 'Este posibil să se afișeze un element (întrebare) din formular în funcție de valoarea unui alt element. <br />
<strong> Iată un exemplu. </strong> <br />
<ul>
<li> Mai întâi, creați un element de care va depinde un alt element. </li>
<li> Apoi, adăugați o pagină. </li>
<li> Apoi adăugați elementele în funcție de valoarea elementului creat anterior. Alegeți elementul din lista etichetată „Element de dependință” și scrieți valoarea necesară în caseta de text etichetată „Valoare de dependență”. </li>
</ul>
<strong> Structura elementelor ar trebui să arate astfel. </strong>
<ol>
<li> Elementul Q: Aveți o mașină? R: da / nu </li>
<li> Întrerupere de pagină </li>
<li> Elementul Q: Ce culoare are mașina dvs.? <br />
(acest element depinde de elementul 1 cu valoare = da) </li>
<li> Elementul Q: De ce nu aveți o mașină? <br />
(acest element depinde de elementul 1 cu valoare = nu) </li>
<li> ... alte elemente </li>
</ol>';
$string['dependitem'] = 'Element de dependință';
$string['dependvalue'] = 'Valoare dependință';
$string['description'] = 'Descriere';
$string['do_not_analyse_empty_submits'] = 'Nu analizați trimiterile de răspunsuri necompletate';
$string['downloadresponseas'] = 'Descarcă toate răspunsurile sub formă de:';
$string['drop_feedback'] = 'Elimină din acest curs';
$string['dropdown'] = 'Alegere multiplă - răspuns unic permis (meniu derulant)';
$string['dropdown_values'] = 'Răspunsuri';
$string['dropdownlist'] = 'Alegere multiplă - răspuns unic (meniu derulant)';
$string['dropdownrated'] = 'Meniu derulant (evaluat)';
$string['edit_item'] = 'Editează întrebarea';
$string['edit_items'] = 'Editează întrebările';
$string['email_notification'] = 'Activați notificarea trimiterilor';
$string['email_notification_help'] = 'Dacă este activat, profesorii vor primi notificări despre trimiterile de feedback.';
$string['emailteachermail'] = '{$a->username} a finalizat activitatea de feedback: „{$a->feedback}”

O puteți vizualiza aici:

{$a->url}';
$string['emailteachermailhtml'] = '<p> {$a->username} a finalizat activitatea de feedback: <i> \'{$a->feedback}\' </i>. </p>
<p> Este <a href="{$a->url} "> disponibil pe site </a>. </p>';
$string['entries_saved'] = 'Răspunsurile dumneavoastră au fost salvate. Vă mulțumim.';
$string['eventresponsedeleted'] = 'Răspuns șters';
$string['eventresponsesubmitted'] = 'Răspunsul a fost trimis';
$string['export_questions'] = 'Exportă întrebările';
$string['export_to_excel'] = 'Exportă în Excel';
$string['feedback:addinstance'] = 'Adaugă un nou feedback';
$string['feedback:complete'] = 'Completează un feedback';
$string['feedback:createprivatetemplate'] = 'Creează șablon privat';
$string['feedback:createpublictemplate'] = 'Creează un șablon public';
$string['feedback:deletesubmissions'] = 'Ștergeți trimiterile finalizate';
$string['feedback:deletetemplate'] = 'Șterge șablonul';
$string['feedback:edititems'] = 'Editează elementele';
$string['feedback:mapcourse'] = 'Alocați cursurile la feedback-ul global';
$string['feedback:receivemail'] = 'Primiți o notificare prin e-mail';
$string['feedback:view'] = 'Vezi un feedback';
$string['feedback:viewanalysepage'] = 'Vizualizați pagina de analiză după trimitere';
$string['feedback:viewreports'] = 'Vezi rapoartele';
$string['feedback_is_not_for_anonymous'] = 'Feedback-ul nu este anonim';
$string['feedback_is_not_open'] = 'Feedback-ul nu este disponibil';
$string['feedbackclose'] = 'Permiteți răspunsuri la';
$string['feedbackcompleted'] = '{$a->username} completat {$a->feedbackname}';
$string['feedbackopen'] = 'Permite răspunsuri de la';
$string['feedbackupdated'] = 'Feedback actualizat.';
$string['file'] = 'Fișier';
$string['filter_by_course'] = 'Filtrați după curs';
$string['handling_error'] = 'A apărut o eroare la gestionarea acțiunilor modulului de feedback';
$string['hide_no_select_option'] = 'Ascundeți opțiunea „Neselectat”';
$string['horizontal'] = 'Orizontal';
$string['import_questions'] = 'Importă întrebări';
$string['import_successfully'] = 'Import reușit';
$string['importfromthisfile'] = 'Importă din acest fișier';
$string['includeuserinrecipientslist'] = 'Includeți {$a} în lista de destinatari';
$string['indicator:cognitivedepth'] = 'Informații cognitive despre activitatea feedback';
$string['indicator:cognitivedepth_help'] = 'Acest indicator se bazează pe profunzimea cognitivă atinsă de cursant într-o activitate de feedback.';
$string['indicator:cognitivedepthdef'] = 'Informații cognitive despre activitatea feedback';
$string['indicator:cognitivedepthdef_help'] = 'Participantul a atins acest procent din angajamentul cognitiv oferit de activitățile de feedback în timpul acestui interval de analiză (niveluri = Fără vizualizare, Vizualizare, Trimitere)';
$string['indicator:cognitivedepthdef_link'] = 'Learning_analytics_indicators#Cognitive_depth';
$string['indicator:socialbreadth'] = 'Informații sociale despre activitatea feedback';
$string['indicator:socialbreadth_help'] = 'Acest indicator se bazează pe angajamentul social la care a ajuns cursantul într-o activitate de feedback.';
$string['indicator:socialbreadthdef'] = 'Informații sociale despre activitatea feedback';
$string['indicator:socialbreadthdef_help'] = 'Participantul a atins acest procent din angajamentul social oferit de activitățile de feedback în timpul acestui interval de analiză (Nivele = Fără participare, Participant singur, Participant cu alții)';
$string['indicator:socialbreadthdef_link'] = 'Learning_analytics_indicators#Social_breadth';
$string['info'] = 'Informații';
$string['infotype'] = 'Tip de informație';
$string['insufficient_responses'] = 'Răspunsuri insuficiente';
$string['insufficient_responses_for_this_group'] = 'Nu există răspunsuri suficiente pentru acest grup';
$string['insufficient_responses_help'] = 'Pentru ca feedback-ul să fie anonim, trebuie să existe cel puțin 2 răspunsuri.';
$string['item_label'] = 'Etichetă';
$string['item_name'] = 'Întrebare';
$string['label'] = 'Zonă text și media';
$string['labelcontents'] = 'Conținuturi';
$string['mapcourse'] = 'Alocați feedback-ul la cursuri';
$string['mapcourse_help'] = 'În mod implicit, formularele de feedback create pe pagina dvs. de pornire sunt disponibile pe  tot site-ul și vor apărea în toate cursurile care folosesc blocul de feedback. Puteţi insista ca formularul de feedback să apară, făcându-l un bloc permanent sau puteți limita numărul de cursuri în care un formular de feedback va apărea, prin atribuirea acestuia la cursuri specifice.';
$string['mapcourseinfo'] = 'Acesta este un feedback la nivel de site care este disponibil pentru toate cursurile folosind blocul de feedback. Cu toate acestea, puteți limita cursurile la care va apărea prin alocarea acestora. Căutați cursul și asociați-l la acest feedback.';
$string['mapcoursenone'] = 'Nu există cursuri mapate. Feedback-ul este disponibil pentru toate cursurile';
$string['mapcourses'] = 'Alocați feedback-ul la cursuri';
$string['mappedcourses'] = 'Cursuri mapate';
$string['mappingchanged'] = 'Maparea cursurilor a fost schimbată';
$string['maximal'] = 'Maxim';
$string['messageprovider:message'] = 'Reminder de feedback';
$string['messageprovider:submission'] = 'Notificări de feedback';
$string['minimal'] = 'Minim';
$string['mode'] = 'Mod';
$string['modulename'] = 'Feedback';
$string['modulename_help'] = 'Activitatea de feedback îi permite unui profesor să creeze un sondaj personalizat pentru a colecta feedback de la participanți folosind o varietate de tipuri de întrebări, inclusiv cu alegere multiplă, da/nu sau introducere text.

Răspunsurile de feedback pot fi anonime, dacă se dorește, iar rezultatele pot fi afișate tuturor participanților sau limitate numai la profesori. Orice activități de feedback de pe pagina de pornire a site-ului pot fi finalizate și de utilizatorii neconectați.

Pot fi utilizate activități de feedback

* Pentru evaluările cursurilor, contribuind la îmbunătățirea conținutului pentru participanții ulterioare
* Pentru a permite participanților să se înscrie la module de curs, evenimente etc.
* Pentru sondaje ale invitaților despre alegerile cursurilor, politicile școlii etc.
* Pentru sondaje anti-bullying în care elevii pot raporta incidente în mod anonim';
$string['modulename_link'] = 'mod/feedback/view';
$string['modulenameplural'] = 'Feedback';
$string['move_item'] = 'Mută această întrebare';
$string['multichoice'] = 'Opțiune multiplă';
$string['multichoice_values'] = 'Valori cu alegere multiplă';
$string['multichoiceoption'] = '<span class="weight">({$a->weight}) </span>{$a->name}';
$string['multichoicerated'] = 'Alegere multiplă (evaluat)';
$string['multichoicetype'] = 'Tip cu alegere multiplă';
$string['multiplesubmit'] = 'Permiteți mai multe trimiteri';
$string['multiplesubmit_help'] = 'Dacă este setat Da:

* Pentru sondaje anonime: participanții pot trimite răspunsuri nelimitate și toate răspunsurile vor fi înregistrate.
* Pentru sondaje non-anonime: participanții pot trimite răspunsuri nelimitate, dar doar cel mai recent răspuns al lor va fi înregistrat.';
$string['name'] = 'Nume';
$string['name_required'] = 'Numele cerut';
$string['nameandlabelformat'] = '({$a->label}) {$a->name}';
$string['next_page'] = 'Următoarea pagină';
$string['no_handler'] = 'Nu există un handler de acțiune pentru';
$string['no_itemlabel'] = 'Fără etichetă';
$string['no_itemname'] = 'Fără nume';
$string['no_items_available_yet'] = 'Nu s-au pus încă întrebări';
$string['no_templates_available_yet'] = 'Necompletat încă';
$string['non_anonymous'] = 'Numele utilizatorului va fi înregistrat și afișat cu răspunsuri';
$string['non_anonymous_entries'] = 'Intrări non-anonime ({$a})';
$string['non_respondents_students'] = 'Studenți care nu au răspuns ({$a})';
$string['not_completed_yet'] = 'Nu este completat încă';
$string['not_selected'] = 'Nu este selectat';
$string['not_started'] = 'Nu a început';
$string['numberoutofrange'] = 'Număr în afara intervalului';
$string['numeric'] = 'Răspuns numeric';
$string['numeric_range_from'] = 'Variază de la';
$string['numeric_range_to'] = 'Variază până la';
$string['of'] = 'din';
$string['oldvaluespreserved'] = 'Toate întrebările vechi și valorile atribuite vor fi păstrate';
$string['oldvalueswillbedeleted'] = 'Întrebările actuale și toate răspunsurile vor fi șterse.';
$string['only_one_captcha_allowed'] = 'Un singur captcha este permis într-un feedback';
$string['openafterclose'] = 'Ați specificat o dată de deschidere după data de închidere';
$string['overview'] = 'Privire de ansamblu';
$string['page'] = 'Pagină';
$string['page-mod-feedback-x'] = 'Orice pagină a modulului de feedback';
$string['page_after_submit'] = 'Mesaj de finalizare';
$string['pagebreak'] = 'Sfârșit de pagină';
$string['pluginadministration'] = 'Administrare feedback';
$string['pluginname'] = 'Feedback';
$string['position'] = 'Poziție';
$string['previewquestions'] = 'Previzualizare întrebări';
$string['previous_page'] = 'Pagina precedentă';
$string['privacy:metadata:completed'] = 'O înregistrare a trimiterilor la feedback';
$string['privacy:metadata:completed:anonymousresponse'] = 'Dacă trimiterea trebuie utilizată anonim.';
$string['privacy:metadata:completed:timemodified'] = 'Ora la care a fost modificată ultima dată trimiterea.';
$string['privacy:metadata:completed:userid'] = 'Identificatorul utilizatorului care a finalizat activitatea de feedback.';
$string['privacy:metadata:completedtmp'] = 'O înregistrare a trimiterilor care sunt încă în curs.';
$string['privacy:metadata:value'] = 'O înregistrare a răspunsului la o întrebare.';
$string['privacy:metadata:value:value'] = 'Răspunsul ales.';
$string['privacy:metadata:valuetmp'] = 'O înregistrare a răspunsului la o întrebare într-o prezentare în curs.';
$string['public'] = 'Public';
$string['question'] = 'Întrebare';
$string['questionandsubmission'] = 'Setări pentru întrebări și trimiteri';
$string['questions'] = 'Întrebări';
$string['questionslimited'] = 'Se afișează doar {$a} primele întrebări, se afișează răspunsuri individuale sau se descarcă datele din tabel pentru a vedea toate.';
$string['radio'] = 'Alegere multiplă - răspuns unic';
$string['radio_values'] = 'Răspunsuri';
$string['ready_feedbacks'] = 'Feedback-uri gata';
$string['required'] = 'Necesar';
$string['resetting_data'] = 'Răspunsuri';
$string['resetting_delete'] = 'Șterge răspunsurile';
$string['resetting_feedbacks'] = 'Resetarea feedback-urilor';
$string['response_nr'] = 'Numărul răspunsuluii';
$string['responses'] = 'Răspunsuri';
$string['responsetime'] = 'Timpul de răspunsuri';
$string['save_as_new_item'] = 'Salvează sub forma unei întrebări noi';
$string['save_as_new_template'] = 'Salvează sub formă de șablon nou';
$string['save_entries'] = 'Trimiteți răspunsurile';
$string['save_item'] = 'Salvează întrebarea';
$string['saving_failed'] = 'Nu s-a salvat';
$string['search:activity'] = 'Feedback - informații privind activitatea';
$string['search_course'] = 'Caută curs';
$string['searchcourses'] = 'Caută cursuri';
$string['searchcourses_help'] = 'Căutaţi codul sau numele de curs(-uri) pe care doriţi să îl asociați cu acest feedback.';
$string['selected_dump'] = 'Indicii selectați ai variabilei $SESSION sunt aruncați mai jos:';
$string['send'] = 'Trimis';
$string['send_message'] = 'Trimite notificare';
$string['show_all'] = 'Afișează tot';
$string['show_analysepage_after_submit'] = 'Afișează pagina de analiză';
$string['show_entries'] = 'Afișează răspunsuri';
$string['show_entry'] = 'Afișează răspuns';
$string['show_nonrespondents'] = 'Afișați non-respondenții';
$string['site_after_submit'] = 'Site după trimitere';
$string['sort_by_course'] = 'Sortați după curs';
$string['started'] = 'Început';
$string['startedon'] = 'Început în {$a}';
$string['subject'] = 'Subiect';
$string['switch_item_to_not_required'] = 'Setați ca nefiind obligatoriu';
$string['switch_item_to_required'] = 'Setați ca obligatoriu';
$string['template'] = 'Șablon';
$string['template_deleted'] = 'Șablon șters';
$string['template_saved'] = 'Șabloane salvate';
$string['templates'] = 'Șabloane';
$string['textarea'] = 'Răspuns text mai lung';
$string['textarea_height'] = 'Numărul de linii';
$string['textarea_width'] = 'Lăţime';
$string['textfield'] = 'Răspuns scurt';
$string['textfield_maxlength'] = 'Numărul maxim de caractere acceptate';
$string['textfield_size'] = 'Lățimea câmpului de text';
$string['there_are_no_settings_for_recaptcha'] = 'Nu există setări pentru captcha';
$string['this_feedback_is_already_submitted'] = 'Ați completat deja această activitate.';
$string['typemissing'] = 'Valoarea „tip” lipsește';
$string['update_item'] = 'Salvați modificările la întrebare';
$string['url_for_continue'] = 'Link către următoarea activitate';
$string['url_for_continue_help'] = 'După trimiterea feedback-ului, este afișat un buton de continuare, care leagă pagina de curs. Alternativ, se poate conecta la următoarea activitate dacă URL-ul activității este introdus aici.';
$string['use_one_line_for_each_value'] = 'Folosiți o linie pentru fiecare răspuns!';
$string['use_this_template'] = 'Utilizează acest șablon';
$string['using_templates'] = 'Utilizează un șablon';
$string['vertical'] = 'Vertical';
$string['whatfor'] = 'Ce doriți să faceți?';
