<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'auth_shibboleth', language 'no', version '4.5'.
 *
 * @package     auth_shibboleth
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['auth_shib_auth_logo'] = 'Logo for autentiseringsmetoden';
$string['auth_shib_auth_logo_description'] = 'Legg til en logo som vil være kjent for Shibboleth-brukerne dine. Dette kan være logoen for Shibboleth-føderasjonen, f.eks. <tt>SWITCHaai Login</tt> or <tt>InCommon Login</tt> eller lignende.';
$string['auth_shib_auth_method'] = 'Navn på autentiseringsmetode';
$string['auth_shib_auth_method_description'] = 'Benytt et mer forståelig navn for Shibboleth autentisering. Dette kan f.eks. være navnet på organisasjonen din. Eks: <tt>Skolen login</tt> eller <tt>Bedriften as Login</tt> eller lignende.';
$string['auth_shib_changepasswordurl'] = 'URL for passordskifte';
$string['auth_shib_contact_administrator'] = 'I tilfelle du ikke er assosiert med den gitte organisasjonen og du trenger tilgang til et kurs på denne serveren, kan du kontakte <a href="mailto:{$a}">Moodle Administrator</a>.';
$string['auth_shib_convert_data'] = 'DatamodifikasjonsAPI';
$string['auth_shib_convert_data_description'] = 'Du kan bruke dette APIet for å endre dataene som tilbys av Shibboleth ytterligere. Les <a href="{$a}"> README </a> for ytterligere instruksjoner.';
$string['auth_shib_convert_data_filepath_warning'] = 'Du kan ikke bruke en fil som er plassert på gjeldende portals datamappe ($CFG->dataroot) som data modifikasjons-API.';
$string['auth_shib_convert_data_warning'] = 'Filen eksisterer ikke eller ikke lesbar for webserverprosessen';
$string['auth_shib_idp_list'] = 'Identitetstilbydere';
$string['auth_shib_idp_list_description'] = 'Provide a list of Identity Provider entityIDs to let the user choose from on the login page.<br>On each line there must be a comma-separated tuple for entityID of the IdP (see the Shibboleth metadata file) and Name of IdP as it shall be displayed in the drow-down list.<br>As an optional third parameter you can add the location of a Shibboleth session initiator that shall be used in case your Moodle installation is part of a multi federation setup.';
$string['auth_shib_instructions'] = 'Bruk <a href="{$a}">Shibboleth login</a> for å få tilgang via Shibbolet, hvis institusjonen din støtter dette<br />Hvis ikke bruk den vanlige innloggingen her.';
$string['auth_shib_instructions_help'] = 'Her kan du legge din egen instruks for brukere hvordan å bruke Shibboleth. Den vil vises på login siden i instruksdelen. Instruksjonen må inkludere en lenke til "<b>{$a}</b>" som brukere klikker hvis de vil logge inn.';
$string['auth_shib_instructions_key'] = 'Innloggingsinstruksjoner';
$string['auth_shib_integrated_wayf'] = 'Endre WAYF-tjenesten';
$string['auth_shib_integrated_wayf_description'] = 'Hvis aktivert vil Moodle bruke sin egen WAYF-tjeneste i stedet for den som er satt opp for Shibboleth. Moodle vil vise en listemeny på denne alternative login-siden hvor brukeren kan velge sin Identitetstilbyder.';
$string['auth_shib_logout_return_url'] = 'Alternativ URL ved utlogging';
$string['auth_shib_logout_return_url_description'] = 'Viser den URL-en Shibboleth-brukere skal sendes til etter utlogging.<br />Dersom tom, vil brukere bli sendt til den siden som er satt som ellers er standard for Moodle.';
$string['auth_shib_logout_url'] = 'Shibboleth tjenesten-URL ved utlogging';
$string['auth_shib_logout_url_description'] = 'Tilby URL-en til Shibboleth tjenesten som håndterer utlogging. Dette er vanligvis <tt>/Shibboleth.sso/Logout</tt>';
$string['auth_shib_no_organizations_warning'] = 'Hvis du vil bruke den integrerte WAYF tjenesten, må du velge en kommaseparert liste av tilbyderes entityIDer, navn og eventuelt en sesjonsinitiator.';
$string['auth_shib_only'] = 'Bare Shibboleth';
$string['auth_shib_only_description'] = 'Kryss av denne hvis Shibbolethautentisering SKAL gjennomføres.';
$string['auth_shib_username_description'] = 'Navn på variabelen for webserver Shibboleth variabelen som skal brukes som Moodle brukernavn';
$string['auth_shibboleth_errormsg'] = 'Vær vennlig og velg organisasjonen du tilhører!';
$string['auth_shibboleth_login'] = 'Shibboleth Login';
$string['auth_shibboleth_login_long'] = 'Log inn via Shibboleth';
$string['auth_shibboleth_manual_login'] = 'Manuell pålogging';
$string['auth_shibboleth_select_member'] = 'Jeg er medlem av ...';
$string['auth_shibboleth_select_organization'] = 'For Shibbolethautentisering, vær vennlig å velge din organisasjon fra nedtrekkslisten:';
$string['auth_shibbolethdescription'] = 'Ved å bruke denne metoden opprettes og autentiseres brukere ved å bruke Shibboleth. For oppsettsdetaljer, se <a href="{$a}"> Shibboleth README </a>.';
$string['pluginname'] = 'Shibboleth';
$string['privacy:metadata'] = 'Autentiseringsmodulen "Shibboleth" lagrer ikke noen persondata.';
$string['shib_invalid_account_error'] = 'Det ser ut til at du er autentisert for Shibboleth, men Moodle har ingen gyldig brukerkonto for brukernavnet ditt. Brukerkontoen din kan være utkoblet, eller så finnes den ikke.';
$string['shib_no_attributes_error'] = 'Det ser ut som du er godkjent av Shibboleth men Moodle fikk ingen brukerdata. Vær vennlig å sjekk at identitetstilbyderen din leverer nødvendige variabler ({$a}) til Moodletilbyderen eller gi beskjed til systemansvarlige.';
$string['shib_not_all_attributes_error'] = 'Moodle trenger Shibbolethinformasjon som ikke finnes for deg. Informasjonen er: {$a}<br/>Vær vennlig å kontakte webmasteren på dene serveren eller identitetstilbyderen din.';
$string['shib_not_set_up_error'] = 'Shibboleth-godkjenning ser ikke ut til å være riktig konfigurert fordi det ikke er noen Shibboleth-miljøvariabler for denne siden. Vennligst ta kontakt med <a href="{$a}"> README </a> for videre instruksjoner om hvordan du setter opp Shibboleth autentisering eller ta kontakt med webmaster for denne Moodle-installasjonen.';
