<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'factor_sms', language 'nl', version '4.5'.
 *
 * @package     factor_sms
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['action:manage'] = 'Beheer je mobiele telefoonnummer';
$string['action:revoke'] = 'Mobiel telefoonnummer verwijderen';
$string['addnumber'] = 'Mobiel nummer';
$string['clientnotfound'] = 'AWS-serviceclient niet gevonden. Client moet een volledig gekwalificeerde klassenaam zijn, b.v. \\Aws\\S3\\S3Client.';
$string['editphonenumber'] = 'Telefoonnummer bewerken';
$string['editphonenumberinfo'] = 'Als je de code niet hebt ontvangen of het verkeerde nummer hebt ingevoerd, bewerk dan het nummer en probeer het opnieuw.';
$string['error:emptyverification'] = 'Lege code. Probeer het nog eens.';
$string['error:wrongphonenumber'] = 'Het door jou opgegeven telefoonnummer heeft geen geldig formaat.';
$string['error:wrongverification'] = 'Verkeerde code. Probeer het nog eens.';
$string['errorawsconection'] = 'Fout bij verbinden met AWS-server: {$a}';
$string['errorsmssent'] = 'Fout bij het verzenden van een sms-bericht met uw verificatiecode.';
$string['event:smssent'] = 'SMS-bericht verzonden.';
$string['event:smssentdescription'] = 'De gebruiker met ID {$a->userid} heeft via sms een verificatiecode ontvangen. Informatie: {$a->debuginfo}';
$string['info'] = 'Laat een verificatiecode naar jouw telefoonnummer sturen.';
$string['logindesc'] = 'Sms-bericht met een 6-cijferige code verzonden naar mobiel nummer {$a}';
$string['loginoption'] = 'Laat een code naar je mobiele telefoon sturen';
$string['loginskip'] = 'Ik heb geen code ontvangen';
$string['loginsubmit'] = 'Doorgaan';
$string['logintitle'] = 'Voer de verificatiecode in die naar je mobiele telefoon is verzonden';
$string['managefactor'] = 'Beheer SMS';
$string['managefactorbutton'] = 'Beheer';
$string['manageinfo'] = 'Je gebruikt nu \'{$a}\' om te authenticeren.';
$string['notification:smsgatewaymigration'] = 'SMS-instellingen zijn verplaatst';
$string['notification:smsgatewaymigrationinfo'] = 'Er is een nieuw SMS subsysteem aanwezig voor het beheren en configureren van alle SMS-gerelateerde functies. Je bestaande SMS-configuraties zijn gemigreerd naar de pagina  <a href="{$a}">SMS gateways</a>.';
$string['phonehelp'] = 'Voer je mobiele nummer in (inclusief landcode) om een verificatiecode te ontvangen.';
$string['pluginname'] = 'Sms-mobiele telefoon';
$string['privacy:metadata'] = 'De plug-in SMS mobiele telefoonfactor slaat geen persoonlijke gegevens op.';
$string['revokefactorconfirmation'] = 'Verwijder \'{$a}\' \'SMS\'?';
$string['settings:aws'] = 'AWS SNS';
$string['settings:aws:key'] = 'Sleutel';
$string['settings:aws:key_help'] = 'Amazon API-sleutelreferentie.';
$string['settings:aws:region'] = 'Regio';
$string['settings:aws:region_help'] = 'Amazon API-gatewayregio.';
$string['settings:aws:secret'] = 'Geheim';
$string['settings:aws:secret_help'] = 'Geheime Amazon API-referentie.';
$string['settings:aws:usecredchain'] = 'Vind AWS-referenties met behulp van de standaardreferentieproviderketen';
$string['settings:countrycode'] = 'Landnummercode';
$string['settings:countrycode_help'] = 'De belcode zonder de voorafgaande + als standaard als gebruikers geen internationaal nummer met een + voorvoegsel invoeren.

Zie deze link voor een lijst met belcodes: {$a}';
$string['settings:duration'] = 'Geldigheidsduur';
$string['settings:duration_help'] = 'De periode dat de code geldig is.';
$string['settings:gateway'] = 'SMS-gateway';
$string['settings:gateway_help'] = 'De sms-provider waarmee je berichten wil verzenden.';
$string['settings:setupdesc'] = 'Om een SMS-authenticatiefactor te kunnen gebruiken, moet je eerst een  <a href="{$a}">SMS gateway</a> opzetten.';
$string['settings:smsgateway'] = 'SMS-gateway';
$string['settings:smsgateway_help'] = 'Selecteer een gateway uit de lijst, of <a href="{$a}">maak een nieuwe gateway</a>.';
$string['setupfactor'] = 'SMS-installatie';
$string['setupfactorbutton'] = 'Instellen';
$string['setupsubmitcode'] = 'Opslaan';
$string['setupsubmitphone'] = 'Code verzenden';
$string['smsstring'] = '{$a->code} is uw eenmalige beveiligingscode voor {$a->fullname}.

@{$a->url} #{$a->code}';
$string['summarycondition'] = 'Met behulp van een eenmalige sms-beveiligingscode';
