<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'ai', language 'es_mx', version '4.5'.
 *
 * @package     ai
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['acceptai'] = 'Aceptar y continuar';
$string['action'] = 'Acción';
$string['action_generate_image'] = 'Generar imagen';
$string['action_generate_image_desc'] = 'Genera una imagen basada en un prompt de texto.';
$string['action_generate_text'] = 'Generar texto';
$string['action_generate_text_desc'] = 'Generar texto basado en un prompt de texto';
$string['action_generate_text_instruction'] = 'Recibirás una entrada de texto del usuario. Tu tarea es generar texto en función de su solicitud. Sigue estas instrucciones importantes:
1. Devuelve el resumen solo en texto sin formato.
2. No incluyas ningún formato Markdown, saludos ni lugares comunes.';
$string['action_summarise_text'] = 'Resumir texto';
$string['action_summarise_text_desc'] = 'Resumir el contenido de  texto en una página de curso.';
$string['action_summarise_text_instruction'] = 'Recibirás una entrada de texto del usuario. Tu tarea es resumir el texto proporcionado. Sigue estas pautas:
1. Condensa: acorta los pasajes largos en puntos clave.
2. Simplifica: haz que la información compleja sea más fácil de entender, especialmente para los estudiantes.

Instrucciones importantes:
1. Devuelve el resumen solo en texto sin formato.
2. No incluyas ningún formato Markdown, saludos ni lugares comunes.
3. Concéntrate en la claridad, la concisión y la accesibilidad.

Asegúrate de que el resumen sea fácil de leer y transmita de manera eficaz los puntos principales del texto original.';
$string['action_translate_text'] = 'Traducir texto';
$string['action_translate_text_desc'] = 'Traducir texto proporcionado de un idioma a otro';
$string['actionsettingprovider'] = 'configuraciones de acción {$a}';
$string['actionsettingprovider_desc'] = 'Estas configuraciones controlan cómo el {$a->providername} realiza la acción {$a->actionname}.';
$string['ai'] = 'IA';
$string['aiplacements'] = 'Ubicaciones de IA';
$string['aiproviders'] = 'Proveedores de IA';
$string['aiusagepolicy'] = 'Política de uso de IA';
$string['availableplacements'] = 'Elegir donde están disponibles las acciones de IA';
$string['availableplacements_desc'] = 'Las ubicaciones definen cómo y dónde las acciones de IA pueden ser usadas en su sitio. Usted puede elegir cuáles acciones están disponibles en cada ubicación mediante las configuraciones.';
$string['availableproviders'] = 'Gestionar los proveedores de IA conectados a su LMS';
$string['availableproviders_desc'] = 'Los proveedores de IA añaden funcionalidad a su sitio mediante \'acciones\' como resumir texto o generación de imágenes.<br/>
Usted puede gestionar las acciones para cada proveedor en sus configuraciones.';
$string['contentwatermark'] = 'Generado por IA';
$string['declineaipolicy'] = 'Declinar';
$string['manageaiplacements'] = 'Gestionar ubicaciones de IA';
$string['manageaiproviders'] = 'Gestionar proveedores de IA';
$string['noproviders'] = 'Esta acción no está disponible. No hay <a href="{$a}">proveedores de IA</a> configurados para esta acción';
$string['placement'] = 'Colocación';
$string['placementactionsettings'] = 'Acciones';
$string['placementactionsettings_desc'] = 'Las acciones de IA disponibles para esta colocación.';
$string['placementsettings'] = 'Configuraciones específicas de ubicación';
$string['placementsettings_desc'] = 'Estas configuraciones controlan cómo se conecta la ubicación de IA al servicio de IA y las operaciones relacionadas.';
$string['privacy:metadata:ai_action_generate_image'] = 'Una tabla que almacena las solicitudes de generación de imagen hechas por usuarios.';
$string['privacy:metadata:ai_action_generate_image:aspectratio'] = 'La proporción  de aspecto de las imágenes generadas.';
$string['privacy:metadata:ai_action_generate_image:numberimages'] = 'El número de imágenes generadas.';
$string['privacy:metadata:ai_action_generate_image:prompt'] = 'El prompt para la solicitud de generación de imagen.';
$string['privacy:metadata:ai_action_generate_image:quality'] = 'La calidad de las imágenes generadas.';
$string['privacy:metadata:ai_action_generate_image:revisedprompt'] = 'El prompt revisado de las imágenes generadas.';
$string['privacy:metadata:ai_action_generate_image:sourceurl'] = 'La URL de origen de las imágenes generadas.';
$string['privacy:metadata:ai_action_generate_image:style'] = 'El estilo de las imágenes generadas.';
$string['privacy:metadata:ai_action_generate_text'] = 'Una tabla que almacena las solicitudes de generación de texto hechas por usuarios.';
$string['privacy:metadata:ai_action_generate_text:completiontoken'] = 'Los tokens de finalización usados para generar el texto.';
$string['privacy:metadata:ai_action_generate_text:fingerprint'] = 'El hash único que representa el estado/versión del modelo y el contenido.';
$string['privacy:metadata:ai_action_generate_text:generatedcontent'] = 'El texto actual generado por el modelo de IA basado en el prompt ingresado.';
$string['privacy:metadata:ai_action_generate_text:prompt'] = 'El prompt para la solicitud de generación de texto.';
$string['privacy:metadata:ai_action_generate_text:prompttokens'] = 'Los tokens del prompt usados para generar el texto.';
$string['privacy:metadata:ai_action_generate_text:responseid'] = 'La ID de la respuesta';
$string['privacy:metadata:ai_action_register'] = 'Una tabla que almacena las solicitudes de acción hechas por usuarios.';
$string['privacy:metadata:ai_action_register:actionid'] = 'La ID de la solicitud de acción.';
$string['privacy:metadata:ai_action_register:actionname'] = 'El nombre de acción de la solicitud.';
$string['privacy:metadata:ai_action_register:provider'] = 'El nombre del proveedor que manejó la solicitud.';
$string['privacy:metadata:ai_action_register:success'] = 'El estado de la solicitud de acción.';
$string['privacy:metadata:ai_action_register:timecompleted'] = 'La hora de finalización de la solicitud.';
$string['privacy:metadata:ai_action_register:timecreated'] = 'La hora de creación de la solicitud.';
$string['privacy:metadata:ai_action_register:userid'] = 'La ID del usuario que hizo la solicitud.';
$string['privacy:metadata:ai_action_summarise_text'] = 'Una tabla que resume las solicitudes de texto hechas por usuarios.';
$string['privacy:metadata:ai_action_summarise_text:completiontoken'] = 'Los tokens de finalización usados para resumir el texto.';
$string['privacy:metadata:ai_action_summarise_text:fingerprint'] = 'El hash único que representa el estado/versión del modelo y el contenido.';
$string['privacy:metadata:ai_action_summarise_text:generatedcontent'] = 'El texto real generado por el modelo de IA basado en el prompt de entrada.';
$string['privacy:metadata:ai_action_summarise_text:prompt'] = 'El prompt para la solicitud para resumir texto.';
$string['privacy:metadata:ai_action_summarise_text:prompttokens'] = 'Los tokens del prompt usados para resumir el texto.';
$string['privacy:metadata:ai_action_summarise_text:responseid'] = 'La ID de la respuesta';
$string['privacy:metadata:ai_policy_register'] = 'Una tabla que almacena el estado de la aceptación de la política de IA para cada usuario.';
$string['privacy:metadata:ai_policy_register:contextid'] = 'La ID del contexto cuyos datos fueron guardados.';
$string['privacy:metadata:ai_policy_register:timeaccepted'] = 'La hora de cuando el usuario aceptó la política de IA.';
$string['privacy:metadata:ai_policy_register:userid'] = 'La ID del usuario cuyos datos fueron guardados.';
$string['provider'] = 'Proveedor';
$string['provideractionsettings'] = 'Acciones';
$string['provideractionsettings_desc'] = 'Elegir y configurar las acciones que el {$a} puede realizar en su sitio.';
$string['providers'] = 'Proveedores';
$string['providersettings'] = 'Configuraciones';
$string['userpolicy'] = '<h4><strong>¡Bienvenido a la nueva función de IA!</strong></h4>
<p>Esta función de inteligencia artificial (IA) se basa únicamente en Modelos de Lenguaje Grandes (Large Language Models = LLM) externos para mejorar su experiencia de aprendizaje y enseñanza. Antes de comenzar a utilizar estos servicios de IA, por favor lea esta política de uso.
</p>
<h4><strong>Precisión del contenido generado por IA</strong></h4>
<p>La IA puede proporcionar sugerencias e información útiles, pero su precisión puede variar. Usted siempre debe comprobar la información proporcionada para asegurarse de que sea precisa, completa y adecuada para su situación específica.</p>
<h4><strong>Cómo se procesan sus datos</strong></h4>
<p>Esta función de IA es proporcionada por LLM externos de terceros. Si usted usa esta función, cualquier información o dato personal que comparta se manejará de acuerdo con la política de privacidad deesos LLMss. Le recomendamos que revise la política de privacidad del LLM para comprender cómo se manejarán sus datos personales.
Además, es posible que se mantenga un registro de sus interacciones con las funciones de IA dentro de este sitio.</p>
<p>Si tiene preguntas acerca de cómo son procesados sus datos, por favor consulte con sus profesores o la organización educativa.</p>
<p>Al continuar, usted reconoce que comprende y que está de acuerdo con esta política.</p>';
