<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'attendance', language 'hu', version '4.5'.
 *
 * @package     attendance
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['Aacronym'] = 'H';
$string['Afull'] = 'Hiányzik';
$string['Eacronym'] = 'I';
$string['Efull'] = 'Igazoltan távol';
$string['Lacronym'] = 'K';
$string['Lfull'] = 'Késett';
$string['Pacronym'] = 'R';
$string['Pfull'] = 'Jelen van';
$string['absenteereport'] = 'Jelentés a hiányzókról';
$string['acronym'] = 'Rövidítés';
$string['add'] = 'Hozzáadás';
$string['addedrecip'] = '{$a} új címzett hozzáadva';
$string['addedrecips'] = '{$a} új címzett hozzáadva';
$string['addmultiplesessions'] = 'Több időablak hozzáadása';
$string['addsession'] = 'Időablak hozzáadása';
$string['adduser'] = 'Felhasználó hozzáadása';
$string['addwarning'] = 'Figyelmeztetés hozzáadása';
$string['all'] = 'Összes';
$string['allcourses'] = 'Összes kurzus';
$string['allowupdatestatus'] = 'Lehetővé teszi a tanulók számára a saját jelenlétük frissítését';
$string['allowupdatestatus_desc'] = 'Ha bejelöli ezt a lehetőséget, a tanulók frissíthetik a jelenlétüket, miután már ők maguk rögzítették azt.';
$string['allowupdatestatus_help'] = 'Ha bejelöli ezt a lehetőséget, a tanulók frissíthetik a jelenlétüket, miután már ők maguk rögzítették azt.';
$string['allpast'] = 'Összes korábbi';
$string['allsessions'] = 'Minden időablak';
$string['attendance:addinstance'] = 'Új részvételi tevékenység hozzáadása';
$string['attendance:canbelisted'] = 'Megjelenik a névsorban';
$string['attendance:changeattendances'] = 'Részvételi adatok módosítása';
$string['attendance:changepreferences'] = 'Beállítások módosítása';
$string['attendance:export'] = 'Jelentések exportálása';
$string['attendance:manageattendances'] = 'Részvétel kezelése';
$string['attendance:managetemporaryusers'] = 'Ideiglenes felhasználók kezelése';
$string['attendance:takeattendances'] = 'Részvétel rögzítése';
$string['attendance:view'] = 'Részvétel megtekintése';
$string['attendance:viewreports'] = 'Jelentések megtekintése';
$string['attendance:viewsummaryreports'] = 'Kurzusösszegző jelentések megtekintése';
$string['attendance:warningemails'] = 'Hiányzó tanulók is feliratkozhatnak e-mailekre';
$string['attendance_already_submitted'] = 'Nem módosíthat már rögzített jelenlétet.';
$string['attendance_no_status'] = 'Nem volt érvényes státusz - lehet, hogy túl későn rögzíti a jelenlétet.';
$string['attendancedata'] = 'Jelenléti adat';
$string['attendancegrade'] = 'Részvétel értékelése';
$string['attendancenotset'] = 'Részvétel megadása kötelező';
$string['attendancenotstarted'] = 'Ezen a kurzuson még nem kezdődött el a részvétel';
$string['attendancepercent'] = 'Részvételi százalék';
$string['attendancereport'] = 'Részvételi jelentés';
$string['attendanceslogged'] = 'Jelenlét naplózva';
$string['attendancestaken'] = 'Jelenlét rögzítve';
$string['attendancesuccess'] = 'A részvétel sikeresen rögzítve';
$string['attendanceupdated'] = 'A részvétel sikeresen frissítve';
$string['attendanceuserreport'] = 'Jelentés';
$string['attforblockdirstillexists'] = 'A régi mod/attforblock könyvtár még létezik - a frissítés futtatása előtt törölje a könyvtárat a szerverről.';
$string['attrecords'] = 'Részvételi feljegyzések';
$string['autoassignstatus'] = 'A lehetséges legmagasabb osztályzat automatikus kiválasztása';
$string['autoassignstatus_help'] = 'Ha ezt választja, a tanulók automatikusan a legjobb értékelést kapják.';
$string['automark'] = 'Automatikus jelölés';
$string['automark_help'] = 'Lehetővé teszi az automatikus jelölést.
"Igen" esetén a tanulók jelölése automatikusan a kurzushoz való első hozzáférésük alapján.
"Időablak végén jelöletlen" esetén minden olyan tanuló, aki nem jelölte jelenlétét, jelöletlen státuszba kerül.';
$string['automarkall'] = 'Igen';
$string['automarkclose'] = 'Időablak végén jelöletlen';
$string['automarktask'] = 'Automatikus jelölést igénylő részvételi időablakok ellenőrzése';
$string['autorecorded'] = 'rendszer által automatikusan rögzítve';
$string['availabilityalways'] = 'Mindig';
$string['availabilityno'] = 'Nem';
$string['availablebeforesession'] = 'Elérhető az időablak kezdete előtt';
$string['averageattendance'] = 'Átlagos részvétel';
$string['averageattendancegraded'] = 'Átlagos jelenlét';
$string['backtoparticipants'] = 'Vissza a résztvevők listájához';
$string['below'] = '{$a}% alatt';
$string['calclose'] = 'Zárt';
$string['calendarevent'] = 'Naptári esemény létrehozása a munkamenethez';
$string['calendarevent_help'] = 'Ha engedélyezve van, naptári esemény jön létre ehhez a munkamenethez. Ha letiltja, akkor a munkamenet minden létező naptári eseményét törli.';
$string['caleventcreated'] = 'Naptári esemény sikeresen létrehozva';
$string['caleventdeleted'] = 'Naptári esemény sikeresen törölve';
$string['calmonths'] = 'január,február,március,április,május,június,július,augusztus,szeptember,október,november,december';
$string['calshow'] = 'Válasszon dátumot';
$string['calweekdays'] = 'vas,hét,ked,sze,csü,pén,szom';
$string['cannottakeforgroup'] = '"{$a}" csoport esetén nem rögzíthet részvételt';
$string['cantaddstatus'] = 'Új státusz hozzáadásakor rövidítést és leírást kell megadni.';
$string['categoryreport'] = 'Kurzuskategória jelentése';
$string['changeattendance'] = 'Részvétel megváltoztatása';
$string['changeduration'] = 'Időtartam megváltoztatása';
$string['changesession'] = 'Időablak megváltoztatása';
$string['checkweekdays'] = 'Válassza ki a hét azon napjait, amelyek az időablak kiválasztott időtartamába esnek!';
$string['closed'] = 'Ez a munkamenet jelenleg nem használható önálló bejelöléssel';
$string['column'] = 'oszlop';
$string['columnmap'] = 'Oszlopok illesztése';
$string['columns'] = 'oszlop';
$string['commonsession'] = 'Minden tanuló';
$string['commonsessions'] = 'Minden tanuló';
$string['confirm'] = 'Jóváhagyás';
$string['confirmcolumnmappings'] = 'Erősítse meg az oszlop leképezését';
$string['confirmdeletehiddensessions'] = 'Biztosan töröl ({$a->date} kezdetű kurzus elé ütemezett {$a->count} időablakot?';
$string['confirmdeleteuser'] = 'Biztosan törli \'{$a->fullname}\' ({$a->email}) felhasználót? Minden részvételi adata végleg törlődik.';
$string['copyfrom'] = 'Részvételi adatok másolása innen:';
$string['countofselected'] = 'Kiválasztottak száma:';
$string['course'] = 'Kurzus';
$string['coursemessage'] = 'Üzenet a kurzus felhasználóinak';
$string['courseshortname'] = 'A kurzus rövid neve';
$string['coursesummary'] = 'Kurzusösszegző jelentés';
$string['createmultiplesessions'] = 'Több időablak készítése';
$string['createmultiplesessions_help'] = 'Ez a funkció lehetővé teszi több időablak készítését egy egyszerű lépéssel.
Az időablakok az alap időablak időpontjában kezdődnek, és az "ismételje eddig" időpontjáig folytatódnak.

  * <strong>Ismétlés napja</strong>: Válassza ki a hét azon napjait, amikor óra lesz (pl. hétfő/szerda/péntek).
  * <strong>Ismétlés gyakorisága</strong>: Itt a gyakoriságot lehet beállítani. Ha hetente lesz óra, válassza az 1-et; ha minden második héten, válassza a 2-t stb.
  * <strong>Ismétlés vége</strong>: Válassza ki az utolsó óra napját (az utolsó napot, amelyen részvételt kíván rögzíteni).';
$string['createonesession'] = 'Egy időablak készítése a kurzushoz';
$string['csvdelimiter'] = 'CSV-elválasztó';
$string['currentlyselectedusers'] = 'Jelenleg kiválasztott felhasználók';
$string['date'] = 'Dátum';
$string['days'] = 'nap';
$string['defaultdisplaymode'] = 'Megjelenítés alapbeállítással';
$string['defaults'] = 'Alapbeállítások';
$string['defaultsessionsettings'] = 'Alapértelmezett időablak-beállítások';
$string['defaultsessionsettings_help'] = 'Ezek a beállítások határozzák meg az alapértelmezéseket minden új időablakhoz';
$string['defaultsettings'] = 'Alapértelmezett részvétel-beállítások';
$string['defaultsettings_help'] = 'Ezek a beállítások határozzák meg az alapértelmezéseket minden új részvételhez';
$string['defaultstatus'] = 'Alapértelmezett státuszok';
$string['defaultsubnet'] = 'Alapértelmezett hálózati cím';
$string['defaultsubnet_help'] = 'A részvétel rögzítése korlátozható konkrét alhálózatokra  részleges vagy teljes IP-címek megadásával (vesszővel elválasztott listában). Ez az alapértelmezett érték új időablakok létrehozásakor.';
$string['defaultview'] = 'Alapértelmezett nézet belépéskor';
$string['defaultview_desc'] = 'Ez a tanárok alapértelmezett nézete első belépéskor.';
$string['defaultwarnings'] = 'Alapértelmezett figyelmeztetések';
$string['defaultwarningsettings'] = 'Alapértelmezett figyelmeztetések beállításai';
$string['defaultwarningsettings_help'] = 'Ezek a beállítások határozzák meg az alapértelmezett értékeket új figyelmeztetéseknél';
$string['delete'] = 'Törlés';
$string['deletecheckfull'] = 'Biztos benne, hogy teljesen törli a(z) {$a} fájlt, beleértve az összes felhasználói adatot?';
$string['deletedgroup'] = 'Az időablakhoz társított csoport törölve lett';
$string['deletehiddensessions'] = 'Minden rejtett időablak törlése';
$string['deletelogs'] = 'Részvételi adat törlése';
$string['deleteselected'] = 'Kijelölt törlése';
$string['deletesession'] = 'Időablak törlése';
$string['deletesessions'] = 'Minden időablak törlése';
$string['deleteuser'] = 'Felhasználó törlése';
$string['deletewarningconfirm'] = 'Biztosan törli ezt a figyelmeztetést?';
$string['deletingsession'] = 'A kurzus időablakának törlése';
$string['deletingstatus'] = 'A kurzus állapotának törlése';
$string['description'] = 'Leírás';
$string['display'] = 'Megjelenítés';
$string['displaymode'] = 'Megjelenítési mód';
$string['donotusepaging'] = 'Ne használjon lapszámozást';
$string['downloadexcel'] = 'Letöltés Excel formátumban';
$string['downloadooo'] = 'Letöltés OpenOffice formátumban';
$string['downloadtext'] = 'Letöltés txt formátumban';
$string['duration'] = 'Időtartam';
$string['editsession'] = 'Időablak szerkesztése';
$string['edituser'] = 'Felhasználó szerkesztése';
$string['emailcontent'] = 'E-mail tartalma';
$string['emailcontent_default'] = 'Kedves %userfirstname%,

A részvétele itt: %coursename% %attendancename% %warningpercent% alá csökkent, jelenleg így áll: %percent%, reméljük, nincs semmi gond!

A jobb eredmény érdekében javítania kell a részvételi arányán, kérjük, vegye fel velünk a kapcsolatot, ha további segítségre van szüksége!';
$string['emailcontent_help'] = 'Amikor egy tanuló figyelmeztetést kap, ennek a mezőnek a tartalmát kapja meg e-mailben. Az alábbi helyettesítő elemek használhatók:
<ul>
<li>%coursename%</li>
<li>%userfirstname%</li>
<li>%userlastname%</li>
<li>%userid%</li>
<li>%warningpercent%</li>
<li>%attendancename%</li>
<li>%cmid%</li>
<li>%numtakensessions%</li>
<li>%points%</li>
<li>%maxpoints%</li>
<li>%percent%</li>
</ul>';
$string['emailsubject'] = 'E-mail tárgya';
$string['emailsubject_default'] = 'Részvételi figyelmeztetés';
$string['emailsubject_help'] = 'Amikor egy tanuló figyelmeztetést kap, ennek a mezőnek a tartalma lesz az e-mail tárgya.';
$string['emailuser'] = 'E-mail tanulónak';
$string['emailuser_help'] = 'Ha be van jelölve, figyelmeztetést kap a tanuló';
$string['emptyacronym'] = 'Üres rövidítések nem engedélyezettek. Az állapot frissítésére nem kerül sor.';
$string['emptydescription'] = 'Üres leírások nem engedélyezettek. Az állapot frissítésére nem kerül sor.';
$string['enablecalendar'] = 'Naptári események létrehozása';
$string['enablecalendar_desc'] = 'Bekapcsolása esetén naptári esemény jön létre minden részvételi időablakhoz. Módosítása után futtassa le a naptár-visszaállítási jelentést';
$string['enablewarnings'] = 'Figyelmeztetések bekapcsolása';
$string['enablewarnings_desc'] = 'Lehetővé teszi e-mail értesítések küldését a felhasználóknak, ha részvételük a küszöbérték alá esik.  <br/><strong>FIGYELEM: Ez egy új, átfogóan nem tesztelt funkció. Csak saját felelősségére használja, és ha úgy látja, jól működik, adjon visszajelzést a Moodle fórumain!</strong>';
$string['encoding'] = 'Kódolás';
$string['endofperiod'] = 'Időszak vége';
$string['endtime'] = 'Időablak vége';
$string['enrolmentend'] = 'Felhasználók beiratkozásának vége: {$a}';
$string['enrolmentstart'] = 'Felhasználók beiratkozásának kezdete: {$a}';
$string['enrolmentsuspended'] = 'Beiratkozás felfüggesztve';
$string['enterpassword'] = 'Jelszó megadása';
$string['error:coursehasnoattendance'] = 'A(z) {$a} rövid nevű kurzusban nincsenek jelenléti tevékenységek.';
$string['error:coursenotfound'] = 'A(z) {$a} rövid névvel rendelkező kurzus nem található.';
$string['error:qrcode'] = 'A QR-kód használatához engedélyezze a tanulóknak saját jelenlétük rögzítését! Lépés kihagyva.';
$string['error:sessioncourseinvalid'] = 'Érvénytelen kurzusmunkamenet!  Lépés kihagyva.';
$string['error:sessiondateinvalid'] = 'Egy munkamenet dátuma érvénytelen! Lépés kihagyva.';
$string['error:sessionendinvalid'] = 'Egy munkamenet befejezési ideje érvénytelen! Lépés kihagyva.';
$string['error:sessionstartinvalid'] = 'Egy munkamenet kezdési ideje érvénytelen! Lépés kihagyva.';
$string['errorgroupsnotselected'] = 'Egy vagy több csoport kiválasztása';
$string['errorinaddingsession'] = 'Hiba az időablak hozzáadása közben';
$string['erroringeneratingsessions'] = 'Hiba az időablakok előállítása közben';
$string['eventdurationupdated'] = 'Időablak tartama frissítve';
$string['eventreportviewed'] = 'Részvételi jelentés megtekintve';
$string['eventscreated'] = 'Naptári események létrehozva';
$string['eventsdeleted'] = 'Naptári események törölve';
$string['eventsessionadded'] = 'Időablak hozzáadva';
$string['eventsessiondeleted'] = 'Időablak törölve';
$string['eventsessionipshared'] = 'A jelenlét önálló bejelölése IP-ütközést eredményez';
$string['eventsessionsimported'] = 'Munkamenetek importálva';
$string['eventsessionupdated'] = 'Időablak frissítve';
$string['eventstatusadded'] = 'Állapot hozzáadva';
$string['eventstatusupdated'] = 'Állapot frissítve';
$string['eventtaken'] = 'Jelenlét rögzítve';
$string['eventtakenbystudent'] = 'Jelenlét tanuló által rögzítve';
$string['export'] = 'Exportálás';
$string['extrarestrictions'] = 'További korlátozások';
$string['formattexttype'] = 'Formázás';
$string['from'] = 'innen:';
$string['gradebookexplanation'] = 'Értékelés az értékelésnaplóban';
$string['gradebookexplanation_help'] = 'A Részvétel modul megjeleníti a jelenlegi részvétel értékelését, mely az eddig elért és maximálisan elérhető pontokon alapul. Nem tartalmazza a jövőbeli tanórákat. Az értékelésnaplóban a részvétel értékelése az aktuális részvételi százalék és a kurzus teljes időtartama alatt elérhető pontok alapján alakul ki. Ezért a Részvétel modulban és a naplóban feltüntetett értékelések eltérhetnek, de százalékosan megegyeznek.

Például, ha eddig 10-ből 8 pontot ért el (80%-os részvétel), és a kurzuson való teljes részvétel 50 pontot ér, a Részvétel modul 8/10-et, a napló 40/50-et fog megjeleníteni. Ugyan még nem kapott ténylegesen 40 pontot, de az a pont járna jelenlegi 80%-os részvétele alapján. A Részvétel modulban elért pontok sosem csökkennek, mivel csak az addigi részvételen alapulnak; viszont a naplóban feltüntetett részvételi pont csökkenhet vagy növekedhet a későbbi részvétel függvényében, mivel az az egész kurzusra vonatkozó részvételen alapszik.';
$string['graded'] = 'Értékelt munkamenetek';
$string['gridcolumns'] = 'Oszloprácsok';
$string['group'] = 'Csoport';
$string['groups'] = 'Csoportok';
$string['groupsession'] = 'Tanulócsoport';
$string['hiddensessions'] = 'Rejtett időablakok';
$string['hiddensessions_help'] = 'A munkamenetek rejtettek, ha a kurzus kezdő időpontja elé vannak ütemezve.

Így törlés helyett elrejtheti a régi munkameneteket. Az értékelésnaplóban csak a látható munkamenetek jelennek meg.';
$string['hiddensessionsdeleted'] = 'Minden rejtett időablak törölve lett';
$string['hideextrauserdetails'] = 'További felhasználói adatok elrejtése';
$string['hidensessiondetails'] = 'Időablak részleteinek elrejtése';
$string['identifyby'] = 'Tanuló azonosítása ez alapján:';
$string['import'] = 'Importálás';
$string['importfile'] = 'Fájl importálása';
$string['importfile_help'] = 'Fájl importálása';
$string['importsessions'] = 'Munkamenetek importálása';
$string['includeabsentee'] = 'Munkamenet figyelembevétele a hiányzásról szóló jelentés kiszámításába';
$string['includeabsentee_help'] = 'Ha be van jelölve, ezt a munkamenetet figyelembe veszik a hiányzásról szóló jelentés kiszámításába.';
$string['includeall'] = 'Összes időablak kiválasztása';
$string['includenottaken'] = 'A fel nem vett időablakokat is beleértve';
$string['includeqrcode'] = 'QR-kóddal együtt';
$string['includeremarks'] = 'Észrevételeket beleértve';
$string['incorrectpassword'] = 'Helytelen jelszót adott meg, ezért részvételét nem rögzítettük. Adja meg a helyes jelszót!';
$string['incorrectpasswordshort'] = 'Helytelen jelszó, a jelenlét nem lett rögzítve.';
$string['indetail'] = 'Részletek...';
$string['indicator:cognitivedepthdef_link'] = 'Learning_analytics_indicators#Cognitive_depth';
$string['indicator:socialbreadthdef_link'] = 'Learning_analytics_indicators#Social_breadth';
$string['invalidaction'] = 'Válasszon ki egy lépést';
$string['invalidemails'] = 'Létező felhasználói fiókok címét kell megadnia, nem található: {$a}';
$string['invalidimportfile'] = 'A fájl formátuma érvénytelen.';
$string['invalidsessionenddate'] = 'Ez az időpont nem lehet korábbi, mint az időablaké';
$string['invalidsessionendtime'] = 'A befejezés időpontja nem előzheti meg a kezdés időpontját';
$string['invalidstatus'] = 'Érvénytelen státuszt választott, kérjük, próbálja újra!';
$string['iptimemissing'] = 'Érvénytelen perc az IP-cím megadásához';
$string['jumpto'] = 'Ugrás ide:';
$string['keepsearching'] = 'Keresés folytatása';
$string['maxpossible'] = 'Maximálisan elérhető';
$string['maxpossible_help'] = 'Azt a maximális pontszámot mutatja, amelyet az egyes felhasználók a (korábbi és elkövetkező) még nem teljesített időablakokban elérhetnek.
    <ul>
    <li><strong>Pontok</strong>: az összes időablakban maximálisan elérhető pontszám.</li>
    <li><strong>Százalék</strong>: az összes időablakban maximálisan elérhető százalék.</li>
    </ul>';
$string['maxpossiblepercentage'] = 'Maximálisan elérhető százalék';
$string['maxpossiblepoints'] = 'Maximálisan elérhető pontszám';
$string['maxwarn'] = 'E-mail figyelmeztetések maximális száma';
$string['maxwarn_help'] = 'Egy figyelmeztetés kiküldésének maximális száma (időablakonként csak egy)';
$string['mergeuser'] = 'Felhasználó egyesítése';
$string['mobilesessionto'] = 'Jövőbeli időablakok mutatása';
$string['mobilesettings'] = 'Mobil app beállításai';
$string['modulename'] = 'Részvétel';
$string['modulename_help'] = 'A részvételi modul lehetővé teszi a tanár számára, hogy rögzítse az órai jelenlétet, a tanulók pedig megtekinthetik saját jelenléti ívüket.

A tanár több időablakot hozhat létre, és a részvételt a következőképp jelölheti: "Jelen van", "Hiányzik", "Késett", "Felmentve", vagy igénye szerint módosíthatja azokat.

A jelentések szólhatnak az egész osztályról vagy akár az egyes tanulókról is.';
$string['modulenameplural'] = 'Részvétel';
$string['months'] = 'Hónap';
$string['moreattendance'] = 'Az oldalhoz tartozó jelenlét sikeresen rögzítve';
$string['moveleft'] = 'Mozgatás balra';
$string['moveright'] = 'Mozgatás jobbra';
$string['multisessionexpanded'] = 'Több időablak kibontása';
$string['multisessionexpanded_desc'] = 'Új időablakok létrehozásakor a "Több időablak" beállítás alapértelmezetten kibontva jelenjen meg.';
$string['mustselectusers'] = 'Az exportáláshoz felhasználókat kell kiválasztani';
$string['name'] = 'Név';
$string['newdate'] = 'Új időpont';
$string['newduration'] = 'Új időtartam';
$string['newstatusset'] = 'Új állapotok';
$string['noabsentstatusset'] = 'A használt állapotkészletben nincs bejelölés nélkül használható állapot.';
$string['noattendanceusers'] = 'Nem lehet adatokat exportálni, mert a kurzust egy tanuló sem vette fel.';
$string['noattforuser'] = 'Nincsenek a felhasználóhoz tartozó részvételi adatok';
$string['noautomark'] = 'Kikapcsolva';
$string['nodescription'] = 'Hagyományos időablak';
$string['noeventstoreset'] = 'Nincsenek frissítendő naptári események';
$string['nogroups'] = 'Nem lehetséges csoportos időablakok hozzáadása. Nincsenek csoportok a kurzusban.';
$string['noguest'] = 'Vendégek a jelenlétet nem tekinthetik meg.';
$string['noofdaysabsent'] = 'Hiányzási napok száma';
$string['noofdaysexcused'] = 'Igazolt hiányzási napok száma';
$string['noofdayslate'] = 'Késések száma';
$string['noofdayspresent'] = 'Jelenléti napok száma';
$string['nosessiondayselected'] = 'Nincs időablakhoz tartozó nap kiválasztva';
$string['nosessionexists'] = 'Nem tartozik időablak ehhez a kurzushoz';
$string['nosessionsselected'] = 'Nincs időablak kiválasztva';
$string['notfound'] = 'Nem található részvételi aktivitás ezen a kurzuson!';
$string['notifytask'] = 'Figyelmeztetések küldése felhasználóknak';
$string['notmember'] = 'nem&nbsp;tag';
$string['notset'] = 'nincs beállítva';
$string['noupgradefromthisversion'] = 'A Részvétel modul nem tud verziót frissíteni az attforblock telepített verziójáról. Törölje vagy frissítse az attforblock-ot, mielőtt telepíti az új részvétel modult!';
$string['numsessions'] = 'Időablakok száma';
$string['olddate'] = 'Korábbi időpont';
$string['onlyselectedusers'] = 'Meghatározott felhasználók exportálása';
$string['overallsessions'] = 'Összes időablakban';
$string['overallsessions_help'] = 'Statisztikát ad minden időablakra
    <ul>
    <li><strong>Időablakok</strong>: összes időablak száma.</li>
    <li><strong>Pontok</strong>: kapott pontok a teljesített időablakok alapján.</li>
    <li><strong>Százalék</strong>: az összes időablakban maximálisan megszerezhető pontokból elért pontok százaléka.</li>
    </ul>';
$string['oversessionstaken'] = 'Teljesített időablakokban';
$string['oversessionstaken_help'] = 'Statisztikát ad a teljesített időablakokra:
    <ul>
    <li><strong>Időablakok</strong>: összes teljesített időablak száma.</li>
    <li><strong>Pontok</strong>: kapott pontok a teljesített időablakok alapján.</li>
    <li><strong>Százalék</strong>: a teljesített időablakokban maximálisan megszerezhető pontokból elért pontok százaléka.</li>
    </ul>';
$string['participant'] = 'Résztvevő';
$string['password'] = 'Jelszó';
$string['passwordgrp'] = 'Tanulói jelszó';
$string['passwordgrp_help'] = 'Ha be van kapcsolva, a tanulóknak be kell írniuk a jelszót, mielőtt rögzítik saját részvételüket. Ha üres, nincs szükség jelszóra.';
$string['passwordrequired'] = 'Meg kell adnia az időablak jelszavát a részvétel rögzítéséhez';
$string['percentage'] = 'Százalék';
$string['percentageallsessions'] = 'Az összes időablak százaléka';
$string['percentagesessionscompleted'] = 'Teljesített időablakok százaléka';
$string['pluginadministration'] = 'Részvétel adminisztrálása';
$string['pluginname'] = 'Részvétel';
$string['points'] = 'Pontok';
$string['pointsallsessions'] = 'Az összes időablak pontjai';
$string['pointssessionscompleted'] = 'A teljesített időablakok pontjai';
$string['preferences_desc'] = 'A státuszváltoztatások befolyásolják a meglévő részvételeket és az értékelést.';
$string['preventsharederror'] = 'Az önálló bejelölés valamelyik munkamenetben le van tiltva, mert az eszközt egy másik tanuló jelenlétének a rögzítésére használták.';
$string['preventsharedip'] = 'Tanulók közötti IP-cím megosztásának megakadályozása';
$string['preventsharedip_help'] = 'Tanulók megakadályozása ugyanazon (IP-címmel azonosított) eszköz más tanulók jelenlétének rögzítésére való használatában.';
$string['preventsharediptime'] = 'Az IP-cím újbóli igénybevételéig hátralévő idő (perc)';
$string['preventsharediptime_help'] = 'IP-cím munkameneten belüli jelenlét rögzítésére való újbóli felhasználásának engedélyezése ezen időt követően.';
$string['preview'] = 'Állomány előnézete';
$string['previewhtml'] = 'HTML formátum előnézete';
$string['priorto'] = 'Az időablak időpontja megelőzi a kurzus ({$a}) kezdési időpontját, így az időablak rejtett (nem elérhető) lesz. Bármikor megváltoztathatja a kurzus kezdési időpontját, ha korábbi időablakokhoz szeretne hozzáférni. <br><br>Módosítsa az időablak időpontját vagy a megerősítéshez kattintson ismét az "Időablak hozzáadása" gombra!';
$string['privacy:metadata:attendancelog'] = 'Felhasználói jelenléti napló rögzítve.';
$string['privacy:metadata:attendancesessions'] = 'Rögzített jelenléttel nyilvántartott munkamenetek.';
$string['privacy:metadata:attendancewarningdone'] = 'A felhasználók figyelmeztetéseinek naplója a jelenléti nyilvántartásukról.';
$string['privacy:metadata:duration'] = 'A munkamenet időtartama másodpercben';
$string['privacy:metadata:groupid'] = 'A munkamenethez társított csoportazonosító.';
$string['privacy:metadata:ipaddress'] = 'A jelenlét rögzítésére használt IP-cím.';
$string['privacy:metadata:lasttaken'] = 'A munkameneti jelenlét rögzítésének utolsó időbélyegzője.';
$string['privacy:metadata:lasttakenby'] = 'Az ebben a munkamenetben jelenlévőként utolsónak rögzített felhasználó felhasználói azonosítója';
$string['privacy:metadata:notifyid'] = 'A figyelmeztetéshez kapcsolódó jelenléti munkamenet azonosítója.';
$string['privacy:metadata:remarks'] = 'Megjegyzések a felhasználó jelenlétéhez.';
$string['privacy:metadata:sessdate'] = 'A munkamenet kezdetének időbélyegzője.';
$string['privacy:metadata:sessionid'] = 'Jelenléti munkamenet azonosítója.';
$string['privacy:metadata:statusid'] = 'A tanuló jelenléti állapotának azonosítója.';
$string['privacy:metadata:statusset'] = 'Az állapotkészlethez tartozó állapot-azonosító.';
$string['privacy:metadata:studentid'] = 'Rögzített jelenlétű tanuló azonosítója.';
$string['privacy:metadata:takenby'] = 'A tanuló jelenlétét rögzítő felhasználó felhasználói azonosítója.';
$string['privacy:metadata:timemodified'] = 'A munkamenet utolsó módosításának időbélyegzője';
$string['privacy:metadata:timesent'] = 'A figyelmeztetés elküldésének időbélyegzője.';
$string['privacy:metadata:timetaken'] = 'A tanulói jelenlét rögzítésének időbélyegzője.';
$string['privacy:metadata:userid'] = 'A figyelmeztetés címzettjének felhasználói azonosítója.';
$string['processingfile'] = 'Fájl feldolgozása';
$string['qr_cookie_error'] = 'Lejárt QR kód';
$string['qrcode'] = 'QR-kód';
$string['qrcodeheader'] = 'A QR kód beolvasásával rögzítheti a jelenlétét';
$string['qrcodevalidafter'] = 'másodperc';
$string['qrcodevalidbefore'] = 'A QR kód érvényes:';
$string['randompassword'] = 'Véletlenszerű jelszó';
$string['remark'] = 'Észrevétel ide: {$a}';
$string['remarks'] = 'Észrevételek';
$string['repeatasfollows'] = 'Ismételje meg a fenti időablakot az alábbiak szerint';
$string['repeatevery'] = 'Ismétlés gyakorisága';
$string['repeaton'] = 'Ismétlés napja';
$string['repeatuntil'] = 'Ismétlés vége';
$string['report'] = 'Jelentés';
$string['reportsessiondate'] = 'Dátum';
$string['reportsessionduration'] = 'Időtartam';
$string['required'] = '*Kötelezően kitöltendő';
$string['requiredentries'] = 'Az ideiglenes adatok felülírják a résztvevők részvételi adatait';
$string['requiredentry'] = 'Ideiglenes felhasználó-egyesítés súgója';
$string['requiredentry_help'] = '<p align="center"><b>Részvétel</b></p>
<p align="left"><strong>Fiókok egyesítése</strong></p>
<p align="left">
<table border="2" cellpadding="4">
<tr>
<th>Moodle felhasználó</th>
<th>Ideiglenes felhasználó</th>
<th>Lépés</th>
</tr>
<tr>
<td>Részvételi adat</td>
<td>Részvételi adat</td>
<td>Az ideiglenes felhasználó felül fogja írni a Moodle felhasználót</td>
</tr>
<tr>
<td>Nincs részvételi adat</td>
<td>Részvételi adat</td>
<td>Az ideiglenes felhasználó részvételi adata átkerül a Moodle felhasználóhoz</td>
</tr>
<tr>
<td>Részvételi adat</td>
<td>Nincs részvételi adat</td>
<td>Ideiglenes felhasználó törölve lesz</td>
</tr>
<tr>
<td>Nincs részvételi adat</td>
<td>Nincs részvételi adat</td>
<td>Ideiglenes felhasználó törölve lesz</td>
</tr>
</table>

</p>
<p align="left"><strong>Az ideiglenes felhasználó egyesítés esetén mindig törlődik.</strong></p>';
$string['requiresubnet'] = 'Hálózati cím megadása szükséges';
$string['requiresubnet_help'] = 'A részvétel rögzítése korlátozható konkrét alhálózatokra részleges vagy teljes IP-címek megadásával (vesszővel elválasztott listában).';
$string['resetcaledarcreate'] = 'A naptári események engedélyezve lettek, de néhány meglévő időablaknak nincsenek eseményei. Szeretne létrehozni naptári eseményeket minden meglévő időablakhoz?';
$string['resetcaledardelete'] = 'A naptári eseményeket kikapcsolták, de néhány meglévő időablaknak vannak még törlendő eseményei. Törli az összes meglévő eseményt?';
$string['resetcalendar'] = 'Naptár visszaállítása';
$string['resetdescription'] = 'Ne felejtse, hogy a részvételi adatok törlése információt töröl az adatbázisból! El is tudja rejteni a régi időablakokat, ha megváltoztatja a kurzus kezdő időpontját.';
$string['resetstatuses'] = 'Eredeti állapotok visszaállítása';
$string['restoredefaults'] = 'Alapértelmezések visszaállítása';
$string['resultsperpage'] = 'Eredmények oldalanként';
$string['resultsperpage_desc'] = 'Egy oldalon megjelenített tanulók száma';
$string['rotateqrcode'] = 'Ugró QR kód';
$string['save'] = 'Részvétel mentése';
$string['saveandshownext'] = 'Mentés és ugrás a következő oldalra';
$string['search:activity'] = 'Részvétel - tevékenységadatok';
$string['session'] = 'Időablak';
$string['session_help'] = 'Időablak';
$string['sessionadded'] = 'Időablak sikeresen hozzáadva';
$string['sessionalreadyexists'] = 'Már létezik időablak ebben az időpontban';
$string['sessiondate'] = 'Időpont';
$string['sessiondays'] = 'Időablak napjai';
$string['sessiondeleted'] = 'Időablak sikeresen törölve';
$string['sessiondescription'] = 'Időablak leírása';
$string['sessionduplicate'] = 'A kurzushoz párhuzamos munkamenet létezik: {$a->course} jelenlévő: {$a->activity}';
$string['sessionexist'] = 'Időablak hozzáadása sikertelen (már létezik)!';
$string['sessiongenerated'] = 'Egy időablak sikeresen létrehozva';
$string['sessions'] = 'Időablak';
$string['sessionsallcourses'] = 'Összes kurzus';
$string['sessionsbyactivity'] = 'Jelenléti ív példány';
$string['sessionsbycourse'] = 'Kurzus';
$string['sessionsbydate'] = 'Hét';
$string['sessionscompleted'] = 'Teljesített időablakok';
$string['sessionsgenerated'] = '{$a} időablak sikeresen létrehozva';
$string['sessionsids'] = 'Időablakok azonosítója:';
$string['sessionsnotfound'] = 'Nincs időablak a kiválasztott intervallumban';
$string['sessionstartdate'] = 'Időablak kezdetének időpontja';
$string['sessionstotal'] = 'Összes időablak száma';
$string['sessiontype'] = 'Típus';
$string['sessiontype_help'] = 'Hozzáadhat időablakot minden tanulóhoz vagy egy tanulócsoporthoz. A különféle típusok hozzáadása a csoportos tevékenység módjától függ.

* A "Nincs csoport" módban csak az összes tanuló számára hozhat létre időablakot.
* A "Külön csoportok" módban csak tanulócsoportnak hozhat létre időablakot.
* A "Látható csoportok" módban mindkét fajta időablakot létrehozhatja.';
$string['sessiontypeshort'] = 'Típus';
$string['sessionunknowngroup'] = 'A munkamenet ismeretlen csoportokat határoz meg: {$a}';
$string['sessionupdated'] = 'Időablak sikeresen frissítve';
$string['set_by_student'] = 'Egyénileg rögzítve';
$string['setallstatuses'] = 'Állapot beállítása minden felhasználónak';
$string['setallstatusesto'] = 'Állapot beállítása minden felhasználónak erre: «{$a}»';
$string['setperiod'] = 'Percben megadott idő az IP-cím kiadásáig';
$string['settings'] = 'Beállítások';
$string['setunmarked'] = 'Automatikus beállítás, ha nincs jelölve';
$string['setunmarked_help'] = 'Ha az időablakban be van kapcsolva, ezt állítsa be, ha a tanuló nem jelölte részvételét.';
$string['showdefaults'] = 'Alapbeállítások mutatása';
$string['showduration'] = 'Időtartam mutatása';
$string['showextrauserdetails'] = 'További felhasználói adatok megjelenítése';
$string['showqrcode'] = 'QR-kód megjelenítése';
$string['showsessiondescriptiononreport'] = 'A munkamenet leírásának megjelenítése a jelentésben';
$string['showsessiondescriptiononreport_desc'] = 'A munkamenet leírásának megjelenítése a jelenléti jelentésben.';
$string['showsessiondetails'] = 'Mutassa az időablak részleteit';
$string['somedisabledstatus'] = '(Néhány lehetőség törlődött az időablak kezdetekor)';
$string['sortedgrid'] = 'Rendezett rács';
$string['sortedlist'] = 'Rendezett lista';
$string['startofperiod'] = 'Időtartam kezdete';
$string['starttime'] = 'Kezdési idő';
$string['status'] = 'Állapot';
$string['statusdeleted'] = 'Állapot törölve';
$string['statuses'] = 'Állapotok';
$string['statusset'] = 'Állapot beállítva erre: {$a}';
$string['statussetsettings'] = 'Státusz beállítva';
$string['strftimedm'] = '%m%d.';
$string['strftimedmy'] = '%Y%m%d.';
$string['strftimedmyhm'] = '%Y%m%d. %H.%M';
$string['strftimedmyw'] = '%y%m.%d. (%a)';
$string['strftimeh'] = '%I%p';
$string['strftimehm'] = '%H:%M';
$string['strftimeshortdate'] = '%Y%m.%d.';
$string['studentid'] = 'Tanulói azonosító';
$string['studentmarked'] = 'Munkamenetben való jelenléte rögzítve.';
$string['studentmarking'] = 'Tanulói rögzítés';
$string['studentpassword'] = 'Tanulói jelszó';
$string['studentrecordingexpanded'] = 'Tanulói rögzítés kibontva';
$string['studentrecordingexpanded_desc'] = 'A "Tanulói rögzítés" beállítás új időablakok létrehozásakor alapértelmezetten kibontva jelenik meg.';
$string['studentscanmark'] = 'Saját jelenléti adatok rögzítésének engedélyezése';
$string['studentscanmark_desc'] = 'Ha be van jelölve, a tanárok engedélyezhetik a tanulóknak saját részvételük bejelölését.';
$string['studentscanmark_help'] = 'Ha be van jelölve, a tanulók módosíthatják saját jelenléti állapotukat.';
$string['studentscanmarksessiontime'] = 'A tanulók az időablak során rögzítik részvételüket';
$string['studentscanmarksessiontime_desc'] = 'Ha be van jelölve, a tanulók csak az időablak során rögzíthetik részvételüket.';
$string['studentscanmarksessiontimeend'] = 'Időablak vége (perc)';
$string['studentscanmarksessiontimeend_desc'] = 'Ha az időablaknak nincs végpontja, ennyi percük lesz a tanulóknak részvételük rögzítésére.';
$string['submitattendance'] = 'Jelenlét leadása';
$string['subnet'] = 'Alhálózat';
$string['subnetactivitylevel'] = 'Alhálózat beállításának engedélyezése tevékenységszinten';
$string['subnetactivitylevel_desc'] = 'Ha engedélyezett, a tanárok az alapértelmezett alhálózatot tevékenységszinten új részvétel létrehozásakor felülírhatják. Különben a rendszer a portál alapbeállítását használja.';
$string['subnetwrong'] = 'A részvételt csak bizonyos helyekről lehet rögzíteni, ez a gép nincs az engedélyezett helyek listáján.';
$string['summary'] = 'Összegzés';
$string['tablerenamefailed'] = 'Régi attforblock tábla átnevezése sikertelen jelenlétre';
$string['tactions'] = 'Lépés';
$string['takeattendance'] = 'Jelenlét rögzítése';
$string['takensessions'] = 'Teljesített időablakok';
$string['tcreated'] = 'Létrehozva';
$string['tempaddform'] = 'Ideiglenes felhasználó hozzáadása';
$string['tempexists'] = 'Már létezik ideiglenes felhasználó ezzel az e-mail címmel.';
$string['temptable'] = 'Ideiglenes felhasználók listája';
$string['tempuser'] = 'Ideiglenes felhasználó';
$string['tempusermerge'] = 'Ideiglenes felhasználó egyesítése';
$string['tempusers'] = 'Ideiglenes felhasználók';
$string['tempusersedit'] = 'Ideiglenes felhasználó szerkesztése';
$string['tempuserslist'] = 'Ideiglenes felhasználók';
$string['thirdpartyemails'] = 'Más felhasználók értesítése';
$string['thirdpartyemails_help'] = 'Egyéb értesítendő felhasználók listája (szükséges hozzá a mod/attendance:viewreports jogosultság)';
$string['thirdpartyemailsubject'] = 'Részvételi figyelmeztetés';
$string['thirdpartyemailtext'] = '{$a->firstname} {$a->lastname} részvétele itt: {$a->coursename} {$a->aname} alacsonyabb, mint {$a->warningpercent} ({$a->percent})';
$string['thirdpartyemailtextfooter'] = 'Azért kapja ezt, mert a kurzus tanára hozzáadta az Ön e-mail címét a címzettek listájához';
$string['thiscourse'] = 'Ezen kurzus';
$string['time'] = 'Idő';
$string['timeahead'] = 'Nem hozható létre több egy évnél hosszabb időablak, módosítsa a kezdési és a befejezési időpontokat!';
$string['to'] = 'eddig:';
$string['triggered'] = 'Először figyelmeztetve';
$string['tuseremail'] = 'E-mail';
$string['tusername'] = 'Teljes név';
$string['ungraded'] = 'Nem értékelt mukamenetek';
$string['unknowngroup'] = 'Ismeretlen csoport';
$string['update'] = 'Frissítés';
$string['usedefaultsubnet'] = 'Alapértelmezés használata';
$string['usemessageform'] = 'vagy küldjön üzenetet a kiválasztott hallgatóknak az alábbi űrlapon';
$string['userexists'] = 'Már van létező felhasználó ezzel az e-mail címmel';
$string['users'] = 'Exportálandó felhasználók';
$string['usestatusset'] = 'Beállított állapot';
$string['variable'] = 'változó';
$string['variablesupdated'] = 'Változók sikeresen frissítve';
$string['versionforprinting'] = 'nyomtatandó verzió';
$string['viewmode'] = 'Nézet mód';
$string['warnafter'] = 'Teljesített időablakok száma a figyelmeztetés előtt';
$string['warnafter_help'] = 'Csak akkor kerül sor figyelmeztetések küldésére, ha a felhasználó legalább ennyi időablakot teljesít.';
$string['warningdeleted'] = 'Figyelmeztetés törölve';
$string['warningdesc'] = 'Ezek a figyelmeztetések automatikusan hozzáadódnak minden új részvételi tevékenységhez. Ha egy időben egynél több figyelmeztetés esedékes, csak az alacsonyabb figyelmeztetési küszöbbel rendelkező kiküldésére kerül sor.';
$string['warningdesc_course'] = 'Az itt megadott figyelmeztetési küszöbök befolyásolják a hiányzók jelentését, valamint lehetővé teszi tanulók és külső személyek értesítését. Ha egy időben egynél több figyelmeztetés esedékes, csak az alacsonyabb küszöbbel rendelkező kiküldésére kerül sor.';
$string['warningfailed'] = 'Nem hozhat létre olyan figyelmeztetést, amely az időablakok azonos százalékát és számát használja.';
$string['warningpercent'] = 'Figyelmeztetés, ha a százalék ez alá esik:';
$string['warningpercent_help'] = 'Figyelmeztetés lesz esedékes, ha a globális százalék ezen szám alá esik.';
$string['warnings'] = 'Figyelmeztetések beállítva';
$string['warningthreshold'] = 'Figyelmeztetési küszöb';
$string['warningupdated'] = 'Frissített figyelmeztetések';
$string['week'] = 'hét';
$string['weeks'] = 'hét';
$string['youcantdo'] = 'Nem tehet semmit';
