<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'ai', language 'da', version '4.5'.
 *
 * @package     ai
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['acceptai'] = 'Accepter og fortsæt';
$string['action'] = 'Handling';
$string['action_generate_image'] = 'Generer billede';
$string['action_generate_image_desc'] = 'Genererer et billede baseret på en tekstprompt.';
$string['action_generate_text'] = 'Generer tekst';
$string['action_generate_text_desc'] = 'Genererer tekst baseret på en tekstprompt.';
$string['action_generate_text_instruction'] = 'Du vil modtage en tekstinput fra brugeren. Din opgave er at generere tekst baseret på deres anmodning. Følg disse vigtige instruktioner:
    1. Returner resuméet kun i almindelig tekst.
    2. Inkludér ikke markdown-formatering, hilsener eller høflighedsfraser.';
$string['action_summarise_text'] = 'Opsummér tekst';
$string['action_summarise_text_desc'] = 'Opsummerer tekstindholdet på en kursusside.';
$string['action_summarise_text_instruction'] = 'Du vil modtage en tekstinput fra brugeren. Din opgave er at opsummere den angivne tekst. Følg disse retningslinjer:
    1. Forkort: Forkort lange afsnit til nøglepunkter.
    2. Forenkle: Gør kompleks information lettere at forstå, især for elever.

Vigtige instruktioner:
    1. Returner resuméet kun i almindelig tekst.
    2. Inkludér ikke markdown-formatering, hilsener eller høflighedsfraser.
    3. Fokuser på klarhed, kortfattethed og tilgængelighed.

Sørg for, at resuméet er let at læse og effektivt formidler hovedpunkterne i den originale tekst.';
$string['action_translate_text'] = 'Oversæt tekst';
$string['action_translate_text_desc'] = 'Oversætter den angivne tekst fra et sprog til et andet.';
$string['actionsettingprovider'] = '{$a} handlingsindstillinger';
$string['actionsettingprovider_desc'] = 'Disse indstillinger styrer, hvordan {$a->providername} udfører handlingen {$a->actionname}.';
$string['ai'] = 'AI';
$string['aiplacements'] = 'AI placeringer';
$string['aiproviders'] = 'AI udbydere';
$string['aiusagepolicy'] = 'AI brugspolitik';
$string['availableplacements'] = 'Vælg hvor AI-handlinger er tilgængelige';
$string['availableplacements_desc'] = 'Placeringer definerer, hvordan og hvor AI-handlinger kan bruges på din side. Du kan vælge, hvilke handlinger der er tilgængelige i hver placering gennem indstillingerne.';
$string['availableproviders'] = 'Administrer de AI-udbydere, der er forbundet til dit LMS';
$string['availableproviders_desc'] = 'AI-udbydere tilføjer AI-funktionalitet til din side gennem "handlinger" som tekstopsummering eller billedgenerering.

Du kan administrere handlingerne for hver udbyder i deres indstillinger.';
$string['contentwatermark'] = 'Genereret af AI';
$string['declineaipolicy'] = 'Afvis';
$string['manageaiplacements'] = 'Administrer AI-placeringer';
$string['manageaiproviders'] = 'Administrer AI-udbydere';
$string['noproviders'] = 'Denne handling er ikke tilgængelig. Ingen <a href="{$a}">AI-udbydere</a> er konfigureret til denne handling.';
$string['placement'] = 'Placering';
$string['placementactionsettings'] = 'Handlinger';
$string['placementactionsettings_desc'] = 'De AI-handlinger, der er tilgængelige for denne placering.';
$string['placementsettings'] = 'Placerings specifikke indstillinger';
$string['placementsettings_desc'] = 'Disse indstillinger styrer, hvordan denne AI-placering forbindes til AI-tjenesten, samt relaterede operationer.';
$string['privacy:metadata:ai_action_generate_image'] = 'En tabel, der gemmer billedgenereringsforespørgsler lavet af brugere.';
$string['privacy:metadata:ai_action_generate_image:aspectratio'] = 'Formatforholdet på de genererede billeder.';
$string['privacy:metadata:ai_action_generate_image:numberimages'] = 'Antallet af genererede billeder.';
$string['privacy:metadata:ai_action_generate_image:prompt'] = 'Tekstprompten for billedgenereringsforespørgslen.';
$string['privacy:metadata:ai_action_generate_image:quality'] = 'Kvaliteten af de genererede billeder.';
$string['privacy:metadata:ai_action_generate_image:revisedprompt'] = 'Den reviderede prompt af de genererede billeder.';
$string['privacy:metadata:ai_action_generate_image:sourceurl'] = 'Kilde-URL\'en for de genererede billeder.';
$string['privacy:metadata:ai_action_generate_image:style'] = 'Stilen på de genererede billeder.';
$string['privacy:metadata:ai_action_generate_text'] = 'En tabel, der gemmer tekstgenereringsforespørgsler lavet af brugere.';
$string['privacy:metadata:ai_action_generate_text:completiontoken'] = 'Afslutningstokener brugt til at generere teksten.';
$string['privacy:metadata:ai_action_generate_text:fingerprint'] = 'Den unikke hash, der repræsenterer tilstanden/versionen af modellen og indholdet.';
$string['privacy:metadata:ai_action_generate_text:generatedcontent'] = 'Den faktiske tekst genereret af AI-modellen baseret på inputprompten.';
$string['privacy:metadata:ai_action_generate_text:prompt'] = 'Tekstprompten for tekstgenereringsforespørgslen.';
$string['privacy:metadata:ai_action_generate_text:prompttokens'] = 'Prompttokener brugt til at generere teksten.';
$string['privacy:metadata:ai_action_generate_text:responseid'] = 'ID\'et for svaret.';
$string['privacy:metadata:ai_action_register'] = 'En tabel, der gemmer handlingsforespørgsler lavet af brugere.';
$string['privacy:metadata:ai_action_register:actionid'] = 'ID\'et for handlingsforespørgslen.';
$string['privacy:metadata:ai_action_register:actionname'] = 'Navnet på handlingsforespørgslen.';
$string['privacy:metadata:ai_action_register:provider'] = 'Navnet på udbyderen, der håndterede forespørgslen.';
$string['privacy:metadata:ai_action_register:success'] = 'Tilstanden af handlingsforespørgslen.';
$string['privacy:metadata:ai_action_register:timecompleted'] = 'Afslutningstidspunktet for forespørgslen.';
$string['privacy:metadata:ai_action_register:timecreated'] = 'Oprettelsestidspunktet for forespørgslen.';
$string['privacy:metadata:ai_action_register:userid'] = 'ID\'et på brugeren, der lavede forespørgslen.';
$string['privacy:metadata:ai_action_summarise_text'] = 'En tabel, der gemmer opsummeringstekstforespørgsler lavet af brugere.';
$string['privacy:metadata:ai_action_summarise_text:completiontoken'] = 'Afslutningstokener brugt til at opsummere teksten.';
$string['privacy:metadata:ai_action_summarise_text:fingerprint'] = 'Den unikke hash, der repræsenterer tilstanden/versionen af modellen og indholdet.';
$string['privacy:metadata:ai_action_summarise_text:generatedcontent'] = 'Den faktiske tekst genereret af AI-modellen baseret på inputprompten.';
$string['privacy:metadata:ai_action_summarise_text:prompt'] = 'Tekstprompten for opsummeringstekstforespørgslen.';
$string['privacy:metadata:ai_action_summarise_text:prompttokens'] = 'Prompttokener brugt til at opsummere teksten.';
$string['privacy:metadata:ai_action_summarise_text:responseid'] = 'ID\'et for svaret.';
$string['privacy:metadata:ai_policy_register'] = 'En tabel, der gemmer status for AI-politikaccept for hver bruger.';
$string['privacy:metadata:ai_policy_register:contextid'] = 'ID\'et på konteksten, hvis data blev gemt.';
$string['privacy:metadata:ai_policy_register:timeaccepted'] = 'Tidspunktet, hvor brugeren accepterede AI-politikken.';
$string['privacy:metadata:ai_policy_register:userid'] = 'ID\'et på brugeren, hvis data blev gemt.';
$string['provider'] = 'Udbyder';
$string['provideractionsettings'] = 'Handlinger';
$string['provideractionsettings_desc'] = 'Vælg og konfigurer de handlinger, som {$a} kan udføre på din side.';
$string['providers'] = 'Udbydere';
$string['providersettings'] = 'Indstillinger';
$string['userpolicy'] = '<h4><strong>Velkommen til den nye AI-funktion!</strong></h4>
<p>Denne kunstige intelligens (AI) funktion baserer sig udelukkende på eksterne store sproglige modeller (LLM) for at forbedre din lærings- og undervisningsoplevelse. Før du begynder at bruge disse AI-tjenester, bedes du læse denne brugspolitik.</p>
<h4><strong>Nøjagtighed af AI-genereret indhold</strong></h4>
<p>AI kan give nyttige forslag og information, men nøjagtigheden kan variere. Du bør altid dobbelt-tjekke den givne information for at sikre, at den er korrekt, komplet og egnet til din specifikke situation.</p>
<h4><strong>Sådan behandles dine data</strong></h4>
<p>Denne AI-funktion bruger eksterne store sproglige modeller (LLM). Hvis du bruger denne funktion, vil enhver information eller persondata, du deler, blive behandlet i overensstemmelse med privatlivspolitikken for disse LLM\'er. Vi anbefaler, at du læser deres privatlivspolitik for at forstå, hvordan de vil håndtere dine data. Derudover kan en registrering af dine interaktioner med AI-funktionerne blive gemt på denne side.</p>
<p>Hvis du har spørgsmål om, hvordan dine data behandles, bedes du kontakte dine lærere eller læreorganisation.</p>
<p>Ved at fortsætte anerkender du, at du forstår og accepterer denne politik.</p>';
