<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'aiprovider_openai', language 'it', version '4.5'.
 *
 * @package     aiprovider_openai
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['action:generate_image:endpoint'] = 'Endpoint API';
$string['action:generate_image:model'] = 'Modello IA';
$string['action:generate_image:model_desc'] = 'Modello utilizzato per generare immagini a partire dai prompt degli utenti.';
$string['action:generate_text:endpoint'] = 'Endpoint API';
$string['action:generate_text:model'] = 'Modello IA';
$string['action:generate_text:model_desc'] = 'Il modello utilizzato per generare la risposta testuale.';
$string['action:generate_text:systeminstruction'] = 'Istruzioni di sistema';
$string['action:generate_text:systeminstruction_desc'] = 'Queste istruzioni verranno inviate al modello IA assieme al prompt dell\'utente. Non è consigliabile modificare queste istruzioni, a meno che non sia assolutamente necessario.';
$string['action:summarise_text:endpoint'] = 'Endpoint API';
$string['action:summarise_text:model'] = 'Modello IA';
$string['action:summarise_text:model_desc'] = 'Il modello utilizzato per riassumere il testo fornito.';
$string['action:summarise_text:systeminstruction'] = 'Istruzioni di sistema';
$string['action:summarise_text:systeminstruction_desc'] = 'Queste istruzioni verranno inviate al modello IA assieme al prompt dell\'utente. Non è consigliabile modificare queste istruzioni, a meno che non sia assolutamente necessario.';
$string['apikey'] = 'Chiave API OpenAI';
$string['apikey_desc'] = 'Per ottenere una chiave: <a href="https://platform.openai.com/account/api-keys">OpenAI Platform API keys</a>.';
$string['enableglobalratelimit'] = 'Limitazione globale delle richieste';
$string['enableglobalratelimit_desc'] = 'Limita il numero di richieste all\'ora che il provider dell\'API OpenAI può ricevere globalmente dal sito.';
$string['enableuserratelimit'] = 'Limitazione utente delle richieste';
$string['enableuserratelimit_desc'] = 'Limita il numero di richieste all\'ora che ogni utente può effettuare al provider dell\'API OpenAI.';
$string['globalratelimit'] = 'Massimo numero di richieste globali';
$string['globalratelimit_desc'] = 'Il numero di richieste all\'ora consentite globalmente.';
$string['orgid'] = 'ID organizzazione OpenAI';
$string['orgid_desc'] = 'Ottieni l\'ID OpenAI  della tua organizzazione dal tuo <a href="https://platform.openai.com/account/org-settings">OpenAI Platform account</a>.';
$string['pluginname'] = 'Provider API OpenAI';
$string['privacy:metadata'] = 'Il plugin provider API OpenAI non memorizza dati personali.';
$string['privacy:metadata:aiprovider_openai:externalpurpose'] = 'Queste informazioni vengono inviate all\'API di OpenAI per generare una risposta. Le impostazioni dell\'account OpenAI potrebbero modificare il modo in cui OpenAI archivia e conserva questi dati. Nessun dato utente viene inviato esplicitamente a OpenAI o archiviato in Moodle LMS da questo plugin.';
$string['privacy:metadata:aiprovider_openai:model'] = 'Modello utilizzato per generare la risposta.';
$string['privacy:metadata:aiprovider_openai:numberimages'] = 'Numero di immagini utilizzate nella risposta durante la generazione di immagini.';
$string['privacy:metadata:aiprovider_openai:prompttext'] = 'prompt di testo inserito dall\'utente ed utilizzato per generare la risposta.';
$string['privacy:metadata:aiprovider_openai:responseformat'] = 'Formato della risposta. Quando si generano immagini.';
$string['userratelimit'] = 'Massimo numero di richieste utente';
$string['userratelimit_desc'] = 'Il numero di richieste all\'ora consentite a ciascun utente.';
