<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'quiz', language 'sl', version '4.5'.
 *
 * @package     quiz
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['accessnoticesheader'] = 'Ta kviz si lahko ogledate, če bi pa to bil pravi poskus, bi bili blokirani, ker:';
$string['action'] = 'Ukaz';
$string['activityoverview'] = 'Imate kvize, ki jih je še treba rešiti';
$string['adaptive'] = 'Prilagodljiv način';
$string['adaptive_help'] = 'Če to omogočimo, je v enem poskusu kviza možnih več odgovorov. Na primer, če je odgovor zaznamovan kot napačen, bo udeleženec lahko takoj poskusil znova. Ampak upoštevajoč nastavitve "Upoštevaj odbitke", bo odbitek običajno odštet za vsak napačen poskus.';
$string['add'] = 'Dodaj';
$string['addaquestion'] = 'novo vprašanje';
$string['addarandomquestion'] = 'naključno vprašanje';
$string['addarandomquestion_help'] = 'Ko dodamo naključno vprašanje, je rezultat naključno izbrano vprašanje iz kategorije, ki jo vstavljamo v kviz. To pomeni, da bodo različni udeleženci verjetno dobili različna vprašanja. Če kviz omogoča več poskusov, je mogoče, da bo vsak poskus vseboval novo selekcijo vprašanj.';
$string['addarandomselectedquestion'] = 'Dodaj naključno izbrano vprašanje...';
$string['addasection'] = 'nov naslov odseka';
$string['adddescriptionlabel'] = 'Dodaj opisni element';
$string['addingquestion'] = 'Dodajanje vprašanja';
$string['addingquestions'] = '<p>Na tem delu strani upravljate vašo podatkovno zbirko vprašanj. Vprašanja so shranjena v kategorijah, da jih lažje ohranite organizirane in jih lahko uporabite v poljubnem kvizu v vašem predmetu ali celo pri drugih predmetih, če se odločite in jih \'objavite\'. </p><p>Ko izberete ali ustvarite kategorijo vprašanj, lahko ustvarite ali uredite vprašanja. Izberete in vašemu kvizu dodate lahko katerokoli izmed teh vprašanj na drugi strani te strani.</p>';
$string['addmoreoverallfeedbacks'] = '{ne} Dodaj več polj z odzivi';
$string['addnewgroupoverride'] = 'Dodaj preglasitev skupine';
$string['addnewpagesafterselected'] = 'Dodaj nove strani po izbranih vprašanjih';
$string['addnewquestionsqbank'] = 'Dodaj vprašanja v kategorijo {$a->catname}: {$a->link}';
$string['addnewuseroverride'] = 'Dodaj preglasitev uporabnika';
$string['addpagebreak'] = 'Dodaj prelom strani';
$string['addpagehere'] = 'Tukaj dodaj stran';
$string['addquestion'] = 'Dodaj vprašanje';
$string['addquestionfrombankatend'] = 'Na koncu dodaj iz zbirke vprašanj';
$string['addquestionfrombanktopage'] = 'Na koncu dodaj iz zbirke vprašanj {$a}';
$string['addquestions'] = 'Dodaj vprašanja';
$string['addquestionstoquiz'] = 'Dodaj vprašanja trenutnemu kvizu';
$string['addrandom'] = 'Dodaj {$a} naključna vprašanja';
$string['addrandom1'] = '<<Dodaj';
$string['addrandom2'] = 'naključna vprašanja';
$string['addrandomfromcategory'] = 'Dodaj naključna vprašanja iz kategorije:';
$string['addrandomquestion'] = 'Dodaj naključno vprašanje';
$string['addrandomquestionatend'] = 'Na koncu dodaj naključno vprašanje';
$string['addrandomquestiontopage'] = 'Na stran dodaj naključno vprašanje {$a}';
$string['addrandomquestiontoquiz'] = 'Dodaj naključno vprašanje v kviz {$a}';
$string['addselectedquestionstoquiz'] = 'Kvizu dodaj izbrano vprašanje';
$string['addselectedtoquiz'] = 'Dodaj izbrano v kviz';
$string['addtoquiz'] = 'Dodajte v kviz';
$string['affectedstudents'] = 'Prizadetih {$a}';
$string['aftereachquestion'] = 'Po dodajanju vsakega vprašanja';
$string['afternquestions'] = 'Po dodajanju {$a} vprašanj';
$string['age'] = 'starost';
$string['allattempts'] = 'Vsi poskusi';
$string['allinone'] = 'Neomejeno';
$string['allowreview'] = 'Dovoli pregled';
$string['alreadysubmitted'] = 'Verjetno ste že oddali ta poskus';
$string['alternativeunits'] = 'Alternativne enote';
$string['alwaysavailable'] = 'Vedno na voljo';
$string['analysisoptions'] = 'Možnosti analize';
$string['analysistitle'] = 'Tabela analize elementov';
$string['answer'] = 'Odgovor';
$string['answered'] = 'Odgovorjeno';
$string['answerhowmany'] = 'Eden ali več odgovorov?';
$string['answers'] = 'Odgovori';
$string['answersingleno'] = 'Dovoljenih je več odgovorov';
$string['answersingleyes'] = 'Samo en odgovor';
$string['answertoolong'] = 'Odgovor predolg po vrstici {$a} (največ 255 znakov)';
$string['anytags'] = 'Katerekoli oznake';
$string['aon'] = 'AON oblika';
$string['areyousureremoveselected'] = 'Ste prepričani, da želite izbrisati vsa označena vprašanja?';
$string['asshownoneditscreen'] = 'Kot je prikazano na urejevalni strani';
$string['attempt'] = 'Poskus {$a}';
$string['attemptalreadyclosed'] = 'Ta poskus je že bil zaključen.';
$string['attemptclosed'] = 'Poskus še ni zaprt';
$string['attemptduration'] = 'Porabljeni čas';
$string['attemptedon'] = 'Poskus dne';
$string['attempterror'] = 'Trenutno vam ni dovoljeno opravljati tega kviza zaradi: {$a}';
$string['attempterrorcontentchange'] = 'Predogled kviza ne obstaja več. (Ko kviz urejate, bodo vsi predogledi "v teku" samodejno izbrisani.)';
$string['attempterrorcontentchangeforuser'] = 'Ta poskus ne obstaja več.';
$string['attempterrorinvalid'] = 'Neveljaven ID poskusa kviza';
$string['attemptfirst'] = 'Prvi poskus';
$string['attemptincomplete'] = 'Ta poskus (od {$a}) še ni zaključen.';
$string['attemptlast'] = 'Zadnji poskus';
$string['attemptnumber'] = 'Poskus';
$string['attemptquiz'] = 'Poskusite kviz';
$string['attemptquiznow'] = 'Poskusite kviz zdaj';
$string['attemptreviewtitle'] = '{$a}: Pregled poskusa';
$string['attemptreviewtitlepaged'] = '{$a->name}: Pregled poskusa (page {$a->currentpage} o {$a->totalpages})';
$string['attempts'] = 'Poskusi';
$string['attempts_help'] = 'Skupno število dovoljenih poskusov (ne število dodatnih poskusov).';
$string['attemptsallowed'] = 'Dovoljeni poskusi';
$string['attemptsdeleted'] = 'Poskusi kviza so bili izbrisani';
$string['attemptselection'] = 'Izberite poskuse uporabnikov, ki jih naj analiziram:';
$string['attemptsexist'] = 'Ne morete več dodati ali odstraniti vprašanj.';
$string['attemptsnum'] = 'Poskusi: {$a}';
$string['attemptsnumthisgroup'] = 'Poskusi: {$a->total} ({$a->group} iz te skupine)';
$string['attemptsnumyourgroups'] = 'Poskusi: {$a->total} ({$a->group} iz vaših skupin)';
$string['attemptsonly'] = 'Pokaži samo udeležence, ki so reševali kviz';
$string['attemptstate'] = 'Stanje';
$string['attemptstillinprogress'] = 'Poskus še vedno v teku';
$string['attemptsummarytitle'] = '{$a}: Povzetek poskusa';
$string['attemptsunlimited'] = 'Neomejeno število poskusov';
$string['attempttitle'] = '{$a}';
$string['attempttitlepaged'] = '{$a->name} (page {$a->currentpage} o {$a->totalpages})';
$string['autosaveperiod'] = 'Zamik samodejnega shranjevanja';
$string['autosaveperiod_desc'] = 'Odgovori udeležencev se lahko med reševanjem kviza samodejno shranjujejo, kar obremenjuje strežnik, zmanjšuje pa možnost, da se udeležencem izgubijo odgovori. Če želite skrajšati zamik, postopoma spreminjajte vrednost in nadzorujte obremenitev strežnika. Če je obremenitve previsoka, ponovno podaljšajte zamik. Nastavitev zamika na 0 izklopi samodejno shranjevanje.';
$string['back'] = 'Nazaj na predogled vprašanja';
$string['backtocourse'] = 'Nazaj na predmet';
$string['backtoquestionlist'] = 'Nazaj na seznam vprašanj';
$string['backtoquiz'] = 'Nazaj v urejanje kviza';
$string['bestgrade'] = 'Najboljša ocena';
$string['bothattempts'] = 'Pokaži udeležence s in brez poskusov';
$string['browsersecurity'] = 'Zaščita spletnega brskalnika';
$string['browsersecurity_help'] = 'Če je označeno "Celotni zaslon s pojavnim elementom z zaščito JavaScript",

* Kviz se bo zagnal samo, če imajo udeleženci spletni brskalnik z vključenim JavaScript-om
* Kviz se prikaže v celozaslonskem pojavnem oknu, ki zakrije vsa ostala okna in nima navigacijskih kontrol
* Kolikor je mogoče je udeležencem preprečeno uporabljanje funkcij, kot na primer kopiraj in prilepi';
$string['calculated'] = 'Izračunani';
$string['calculatedquestion'] = 'Izračunan tip vprašanja ni podprt v vrstici {$a}. Vprašanje bo prezrto';
$string['cannotcreatepath'] = 'Poti ni možno ustvariti ({$a})';
$string['cannoteditafterattempts'] = 'Ne morete dodati ali odstraniti vprašanj, saj ima kviz že opravljene poskuse. ({$a})';
$string['cannotfindprevattempt'] = 'Ni možno najti prejšnjega poskusa, na katerem bi gradili.';
$string['cannotfindquestionregard'] = 'Napaka pri pridobivanju vprašanj za ponovno ocenjevanje!';
$string['cannotinsert'] = 'Ni možno vstaviti vprašanja';
$string['cannotinsertrandomquestion'] = 'Ni možno vstaviti novega naključnega vprašanja!';
$string['cannotloadquestion'] = 'Ni mogoče naložiti možnosti vprašanja';
$string['cannotloadtypeinfo'] = 'Ne morem naložiti informacije vprašanja za določen tip';
$string['cannotopen'] = 'Ni možno odpreti izvozne datoteke ({$a})';
$string['cannotremoveallsectionslots'] = 'Izbrali ste vsa vprašanja pod \'{$a}‘ naslovom oddelka. Ni dovoljeno odstraniti vsa vprašanja pod naslovom oddelka.';
$string['cannotremoveslots'] = 'Ni možno odstraniti vprašanja';
$string['cannotrestore'] = 'Ni možno obnoviti seje vprašanj';
$string['cannotreviewopen'] = 'Tega poskusa ne morete pregledati, ker je še odprt.';
$string['cannotsavelayout'] = 'Ni možno shraniti postavitve';
$string['cannotsavenumberofquestion'] = 'Ni mogoče shraniti izbranega števila vprašanj na stran';
$string['cannotsavequestion'] = 'Ni možno shraniti seznama vprašanj';
$string['cannotsetgrade'] = 'Ni možno nastaviti nove najvišje ocene kviza';
$string['cannotsetsumgrades'] = 'Določitev seštevka ocen je spodletela';
$string['cannotstartgradesmismatch'] = 'Ni možno začeti tega kviza. Ta kviz je namenjen ocenjevanju {$a->grade}, toda nobeno vprašanje kviza nima možnosti ocenjevanja. To lahko popravite na strani "Uredi kviz".';
$string['cannotstartmissingquestion'] = 'Ni možno začeti kviza. Kviz vsebuje vprašanje, ki ne obstaja.';
$string['cannotstartnoquestions'] = 'Ni možno začeti poskusa kviza. Kviz še ni dodelan. Kviz ne vsebuje nobenega vprašanja.';
$string['cannotwrite'] = 'Ni mogoče pisati v izvozno datoteko ({$a})';
$string['canredoquestions'] = 'Dovoli ponoven poskus znotraj poskusa';
$string['canredoquestions_desc'] = 'Omogočite lahko gumb za ponovni poskus, ki ga bodo udeleženci lahko uporabili po zaključenem poskusu odgovora na določeno vprašanje. To jim omogoči poskus odgovora na drugo verzijo istega vprašanja ne da bi morali oddati celoten poskus rešitve kviza in začeti novega. Ta možnost je najbolj uporabna pri kvizih za vajo.

 Ta nastavitev vpliva samo na vprašanja (ne pa, na primer, opisna vprašanja) in vedenja (na primer Takojšnji odziv ali Interaktivno z več poskusi), kjer študent lahko konca vprašanje preden poskus odda.';
$string['canredoquestions_help'] = 'Omogočite lahko gumb za ponovni poskus, ki ga bodo udeleženci lahko uporabili po zaključenem poskusu odgovora na določeno vprašanje. To jim omogoči poskus odgovora na drugo verzijo istega vprašanja ne da bi morali oddati celoten poskus rešitve kviza in začeti novega. Ta možnost je najbolj uporabna pri kvizih za vajo.

 Ta nastavitev vpliva samo na vprašanja (ne pa, na primer, opisna vprašanja) in vedenja (na primer Takojšnji odziv ali Interaktivno z več poskusi), kjer študent lahko konca vprašanje preden poskus odda.';
$string['canredoquestionsyes'] = 'Udeleženci lahko ponovno poskusijo z drugo verzijo kateregakoli zaključenega vprašanja';
$string['caseno'] = 'Ne, ne ločuj med velikimi in malimi črkami';
$string['casesensitive'] = 'Občutljivost na velike/male črke';
$string['caseyes'] = 'Da, ločuj med velikimi in malimi črkami';
$string['categoryadded'] = 'Kategorija \'{$a}\' je bila dodana';
$string['categorydeleted'] = 'Kategorija \'{$a}\' je bila izbrisana';
$string['categorynoedit'] = 'Nimate pravic urejanja v kategoriji \'{$a}\'.';
$string['categoryupdated'] = 'Kategorija je bila uspešno posodobljena';
$string['close'] = 'Zapri okno';
$string['closebeforeopen'] = 'Posodobitev kviza ni uspela. Določen datum konca ste določili pred datumom začetka.';
$string['closed'] = 'Zaprto';
$string['closepreview'] = 'Zapri predogled';
$string['closereview'] = 'Zapri pregled';
$string['comment'] = 'Komentar';
$string['commentorgrade'] = 'Komentirajte ali preglasite oceno';
$string['comments'] = 'Komentarji';
$string['completedon'] = 'Zaključeno dne';
$string['completionattemptsexhausted'] = 'Ali pa vsi prosti zaključeni poskusi';
$string['completionattemptsexhausted_help'] = 'Označi kviz kot zaključen, ko udeleženec porabi največje število poskusov.';
$string['completiondetail:minattempts'] = 'Opravljeni poskusi: {$a}';
$string['completiondetail:passorexhaust'] = 'Dosezite pozitivno oceno ali opravite vse razpoložljive poskuse';
$string['completionminattempts'] = 'Najmanjše število poskusov:';
$string['completionminattemptserror'] = 'Najmanjše število poskusov mora biti manjše ali enako številu dovoljenih poskusov.';
$string['completionminattemptsgroup'] = 'Število potrebnih poskusov';
$string['configadaptive'] = 'Če za to nastavitev izberete Da, bodo udeleženci lahko dali več odgovorov na vprašanje, celo v istem poskusu kviza.';
$string['configattemptsallowed'] = 'Omejitev števila poskusov, ki so dovoljeni udeležencem.';
$string['configdecimaldigits'] = 'Privzeto število decimalk, ki bodo prikazane po decimalni vejici pri prikazu ocen.';
$string['configdecimalplaces'] = 'Število decimalk, ki bodo prikazane po decimalni piki, pri prikazu ocen kviza.';
$string['configdecimalplacesquestion'] = 'Število decimalk, ki bodo prikazane po decimalni piki, pri prikazu ocen za posamezna vprašanja.';
$string['configdelay1'] = 'Če določite časovni zamik, mora udeleženec počakati preden lahko ponovno rešuje kviz po prvem poskusu.';
$string['configdelay1st2nd'] = 'Če tukaj nastavite časovni zamik, udeleženci ne bodo mogli začeti drugega poskusa, dokler ne preteče toliko časa od konca njihovega prvega poskusa.';
$string['configdelay2'] = 'Če določite časovni zamik, mora udeleženec počakati, preden lahko ponovno poskusi rešiti kviz.';
$string['configdelaylater'] = 'Če tukaj nastavite časovni zamik, udeleženci ne bodo mogli začeti tretjega, četrtega, ... poskusa dokler ne preteče toliko časa od konca njihovega prejšnjega poskusa.';
$string['configeachattemptbuildsonthelast'] = 'Če je dovoljenih več poskusov, potem vsak nov poskus vsebuje rezultate od prejšnjega poskusa.';
$string['configgrademethod'] = 'Ko je dovoljenih več poskusov, tukaj določite metodo, na podlagi katere bo izračunana končna ocena udeleženca pri kvizu.';
$string['configintro'] = 'Vrednosti, ki jih tukaj nastavite, definirajo privzete vrednosti, ki so uporabljene v nastavitvenem obrazcu, ko ustvarite nov kviz. Sami lahko nastavite, katere nastavitve kviza so napredne.';
$string['configmaximumgrade'] = 'Privzeta ocena po kateri je narejena lestvica ocen kviza.';
$string['confignavmethod'] = 'Ko je izbrana metoda "prosto", lahko udeleženec odgovarja na vprašanja v poljubnem vrstnem redu, tako da uporablja navigacijo naprej in nazaj. Pri "zaporedni" metodi je treba na vprašanja odgovarjati točno in po določenem zaporedju.';
$string['confignewpageevery'] = 'Pri dodajanju vprašanj v kviz se avtomatsko ustvarijo prelomnice strani upoštevajoče nastavitvi, ki jo tukaj izberete.';
$string['configoutcomesadvanced'] = 'Če omogočite to možnost, bodo rezultati kviza pri urejanju obravnavani kot napredne nastavitve.';
$string['configpenaltyscheme'] = 'Odbitek za vsak napačen odgovor v prilagodljivostnem načinu.';
$string['configpopup'] = 'Vsili reševanje kviza v pojavnem oknu in uporabi JavaScript trike za omejitev funkcij kopiraj in prilepi itd. med reševanjem kviza.';
$string['configrequirepassword'] = 'Udeleženci morajo, preden poskusijo kviz, vnesti to geslo.';
$string['configrequiresubnet'] = 'Udeleženci lahko poskusijo kviz samo na teh računalnikih.';
$string['configreviewoptions'] = 'Te nastavitve kontrolirajo informacije, ki jih lahko vidijo uporabniki, ko pregledujejo rezultate ali poročila kviza.';
$string['configshowblocks'] = 'Prikaži bloke med reševanjem kviza.';
$string['configshowuserpicture'] = 'Med reševanjem prikaži na zaslonu uporabnikovo sliko.';
$string['configshufflewithin'] = 'Če omogočite to možnost, bodo deli, ki sestavljajo individualna vprašanja, naključno premešani vsakokrat, ko udeleženec začne kviz. V nastavitvah vprašanj mora biti tudi ta nastavitev vključena.';
$string['configtimelimit'] = 'Privzeta časovna omejitev kvizov v sekundah. 0 pomeni, da ni časovne omejitve.';
$string['configtimelimitsec'] = 'Privzeta časovna omejitev kvizov v sekundah. 0 pomeni, da ni časovne omejitve.';
$string['configurerandomquestion'] = 'Konfiguriraj vprašanje';
$string['confirmclose'] = 'Po oddaji ne boste več mogli spremeniti vaših odgovorov za ta poskus.';
$string['confirmremovequestion'] = 'Ste prepričani, da želite odstraniti to vprašanje {$a}?';
$string['confirmremovesectionheading'] = 'Ste prepričani, da želite izbrisati naslov odseka "{$a}"?';
$string['confirmserverdelete'] = 'Ste prepričani, da želite iz seznama odstraniti strežnik <b>{$a}</b>?';
$string['connectionerror'] = 'Ni omrežne povezave. (Samodejno shranjevanje ni uspelo.)

 Zapomnite si vse odgovore na tej strani v zadnjih minutah, nato se poskusite ponovno povezati.

 Ko se povezava ponovno vzpostavi, se bi morali vaši odgovoriti shraniti, to sporočilo pa bo izginilo.';
$string['connectionok'] = 'Omrežna povezava je obnovljena. Sedaj lahko varno nadaljujete.';
$string['containercategorycreated'] = 'Ta kategorija je bila ustvarjena za hranjenje vseh originalnih kategorij, ki so se premaknile na raven spletnega mesta zaradi spodaj navedenih vzrokov.';
$string['continueattemptquiz'] = 'Nadaljujte z vašim poskusom';
$string['continuepreview'] = 'Nadaljujte z zadnjim predogledm';
$string['copyingfrom'] = 'Ustvarjanje kopije vprašanja \'{$a}\'';
$string['copyingquestion'] = 'Kopiranje vprašanja';
$string['correct'] = 'Pravilno';
$string['correctanswer'] = 'Pravilni odgovor';
$string['correctanswerformula'] = 'Pravilna formula odgovora';
$string['correctansweris'] = 'Pravilni odgovor: {$a}';
$string['correctanswerlength'] = 'Pomembna dejstva';
$string['correctanswers'] = 'Pravilni odgovori';
$string['correctanswershows'] = 'Pravilni odgovor prikazan';
$string['corrresp'] = 'Pravilni odgovor';
$string['countdown'] = 'Odštevanje';
$string['countdownfinished'] = 'Kviz se zaključuje, svoje odgovore morate zdaj oddati.';
$string['countdowntenminutes'] = 'Kviz se bo zaključil čez deset minut.';
$string['coursetestmanager'] = 'Format Upravitelj poskusa predmeta';
$string['createcategoryandaddrandomquestion'] = 'Ustvarite kategorijo in dodajte naključno vprašanje';
$string['createfirst'] = 'Najprej morate ustvariti nekaj vprašanj s kratkimi odgovori.';
$string['createmultiple'] = 'Dodaj nekaj naključnih vprašanj v kviz';
$string['createnewquestion'] = 'Ustvari novo vprašanje';
$string['createquestionandadd'] = 'Ustvarite novo vprašanje in ga dodajte v kviz.';
$string['custom'] = 'Format po meri';
$string['dataitemneed'] = 'Dodati morate vsaj en nabor podatkovnih elementov, da dobite veljavno vprašanje';
$string['datasetdefinitions'] = 'Ponovno uporabne definicije podatkovnih nizov za kategorijo {$a}';
$string['datasetnumber'] = 'Številka';
$string['daysavailable'] = 'Dnevi na voljo';
$string['decimaldigits'] = 'Decimalna števila v ocenah';
$string['decimalplaces'] = 'Decimalna mesta v ocenah';
$string['decimalplaces_help'] = 'Z uporabo te nastavitve lahko izberete, koliko decimalnih mest naj bo prikazanih za decimalno vejico. Ta nastavitev vpliva samo na prikaz ocen. Ne vpliva na notranje izračune in zaokroževanje ocen. Ti so izvedeni točno.';
$string['decimalplacesquestion'] = 'Decimalna mesta v ocenah vprašanj';
$string['decimalplacesquestion_help'] = 'Ta nastavitev določa število decimalk po decimalni vejici pri prikazu ocen za posamezna vprašanja.';
$string['decimalpoints'] = 'Decimalna mesta';
$string['default'] = 'Privzeto';
$string['defaultgrade'] = 'Privzeta ocena vprašanja';
$string['defaultinfo'] = 'Privzeta kategorija za vprašanja.';
$string['delay1'] = 'Časovna zakasnitev med prvim in drugim poskusom';
$string['delay1st2nd'] = 'Prisiljen zamik med prvim in drugim poskusom';
$string['delay1st2nd_help'] = 'Če nastavite časovno zakasnitev, bo moral udeleženec počakati nekaj časa, preden bo lahko ponovno reševal kviz.';
$string['delay2'] = 'Časovni zamik med naslednjimi poskusi';
$string['delaylater'] = 'Vsiljen zamik med kasnejšimi poskusi';
$string['delaylater_help'] = 'Če nastavite časovno zakasnitev, bo moral udeleženec počakati toliko časa, preden bo lahko opravljal svoj tretji ali poznejši poskus.';
$string['deleteattemptcheck'] = 'Ali ste zares prepričani, da želite izbrisati vse te poskuse?';
$string['deleteselected'] = 'Izbriši izbrano';
$string['deletingquestionattempts'] = 'Brisanje poskusov odgovarjanja na vprašanje';
$string['description'] = 'Opis';
$string['disabled'] = 'Onemogočeno';
$string['displayoptions'] = 'Možnosti prikaza';
$string['donotuseautosave'] = 'Ne uporabljaj samodejnega shranjevanja';
$string['download'] = 'Kliknite za prenos izvožene datoteke kategorije';
$string['downloadextra'] = '(datoteka je shranjena tudi med datotekami predmeta v mapi /varnostno kopiranje podatkov/kviz)';
$string['dragtoafter'] = 'Po {$a}';
$string['dragtostart'] = 'Na začetek';
$string['duplicateresponse'] = 'Prispevek je bil prezrt, ker ste enakovreden odgovor že oddali.';
$string['eachattemptbuildsonthelast'] = 'Vsak poskus temelji na prejšnjem';
$string['eachattemptbuildsonthelast_help'] = 'Če je dovoljenih več poskusov in je ta nastavitev omogočena, potem vsak nov poskus vsebuje rezultate prejšnjih poskusov. To omogoča dokončanje kviza z več poskusi.';
$string['editcategories'] = 'Uredi kategorije';
$string['editcategory'] = 'Uredi kategorijo';
$string['editcatquestions'] = 'Uredi vprašanja kategorije';
$string['editingquestion'] = 'Urejanje vprašanja';
$string['editingquiz'] = 'Urejanje kviza';
$string['editingquiz_help'] = 'Glavni koncepti pri ustvarjanju kviza so:

* Kviz vsebuje vprašanja na eni ali več straneh
* Zbirka vprašanj, v katero se shranjujejo kopije vseh vprašanj, organiziranih v kategorije
* Naključna vprašanja – Udeleženec dobi drugačna vprašanja vsakič, ko poskusi rešiti kviz. Različni udeleženci lahko dobijo različna vprašanja';
$string['editingquiz_link'] = 'način/kviz/urejanje';
$string['editingquizx'] = 'Urejanje kviza: {$a}';
$string['editmaxmark'] = 'Uredi najvišjo oceno';
$string['editoverride'] = 'Uredi preglasitev';
$string['editqcats'] = 'Uredi kategorije vprašanj';
$string['editquestion'] = 'Uredi vprašanje';
$string['editquestions'] = 'Uredi vprašanja';
$string['editquiz'] = 'Uredi kviz';
$string['editquizquestions'] = 'Uredi vprašanja';
$string['emailconfirmautosubmitsmall'] = 'Hvala vam za oddajo vaših odgovorov na \'{$a->quizname}\'';
$string['emailconfirmbody'] = 'Dragi/-a {$a->username},

 Zahvaljujemo se vam za oddani kviz
\'{$a->quizname}‘
 pri predmetu \'{$a->coursename}‘
 dne {$a->submissiontime}.

 To sporočilo potrjuje, da so bili vaši odgovori varno prejeti.

 Do kviza lahko dostopate na {$a->quizurl}.';
$string['emailconfirmsmall'] = 'Hvala za oddajo odgovorov v \'{$a->quizname}\'';
$string['emailconfirmsubject'] = 'Potrditev opravljanja kviza: {$a->quizname}';
$string['emailmanualgradedbody'] = 'Pozdravljeni {$a->studentname},

Vaši odgovori v \'{$a->quizname}\' v predmetu \'{$a->coursename}\' dne {$a->attempttimefinish} so bili ocenjeni..

Za ogled ocene in povratne informacije obiščite \'{$a->quizurl}\' in so oglejte vaš poskus.';
$string['emailnotifybody'] = 'Dragi/-a {$a->username},

{$a->studentname} je opravil/-a kviz
\'{$a->quizname}\' ({$a->quizurl})
 pri predmetu \'{$a->coursename}\'

Ta poskus lahko pregledate na {$a->quizreviewurl}.';
$string['emailnotifysmall'] = '{$a->studentname} je opravil/a {$a->quizname}. Glej {$a->quizreviewurl}';
$string['emailnotifysubject'] = '{$a->studentname} je opravil kviz {$a->quizname}';
$string['emailoverduebody'] = 'Dragi/-a {$a->studentname},

 začeli ste reševati kviz \'{$a->quizname}‘
 pri predmetu \'{$a->coursename}\', vendar niste oddali odgovorov. To morate storiti do {$a->attemptduedate}.

 Če želite dokončati ta kviz, pojdite na {$a->attemptsummaryurl} in kliknite gumb za oddajo. To morate storiti do {$a->attemptgraceend}, sicer se vam poskus ne bo štel.';
$string['emailoverduesmall'] = 'Niste oddali odgovorov kviza {$a->quizname}. Pojdite na {$a->attemptsummaryurl} pred {$a->attemptgraceend}, če jih želite oddati.';
$string['emailoverduesubject'] = 'Čas za reševanje kviza {$a->quizname} je potekel';
$string['empty'] = 'Prazno';
$string['enabled'] = 'Omogočeno';
$string['endtest'] = 'Končaj poskus...';
$string['erroraccessingreport'] = 'Ne morete dostopati do tega poročila';
$string['errorinquestion'] = 'Napaka v vprašanju';
$string['errormissingquestion'] = 'Napaka: Sistem ne najde vprašanja z identifikacijo {$a}';
$string['errornotnumbers'] = 'Napaka - odgovori morajo biti številski';
$string['errorunexpectedevent'] = 'Nepričakovana koda dogodka {$a->event} ugotovljena za vprašanje {$a->questionid} pri poskusu {$a->attemptid}.';
$string['essay'] = 'Opisna';
$string['essayquestions'] = 'Vprašanja';
$string['eventattemptdeleted'] = 'Izbrisali ste poskus kviza';
$string['eventattemptpreviewstarted'] = 'Začeli ste pregled poskusa kviza';
$string['eventattemptreviewed'] = 'Pregledali ste poskus kviza';
$string['eventattemptsummaryviewed'] = 'Ogledali ste si povzetek poskusa kviza';
$string['eventattemptviewed'] = 'Ogledali ste si poskus kviza';
$string['eventeditpageviewed'] = 'Ogledali ste si urejanje strani kviza';
$string['eventoverridecreated'] = 'Ustvarili ste preglasitev kviza';
$string['eventoverridedeleted'] = 'Izbrisali ste preglasitev kviza';
$string['eventoverrideupdated'] = 'Izbrisali ste preglasitev kviza';
$string['eventquestionmanuallygraded'] = 'Vprašanje je bilo ročno ocenjeno';
$string['eventquizattemptabandoned'] = 'Opustili ste poskus kviza';
$string['eventquizattemptregraded'] = 'Vaš poskus je bil ponovno ocenjen';
$string['eventquizattemptstarted'] = 'Začeli ste poskus kviza';
$string['eventquizattemptsubmitted'] = 'Poskus kviza je oddan';
$string['eventquizattempttimelimitexceeded'] = 'Čas za reševanje kviza je potekel';
$string['eventreportviewed'] = 'Ogledali ste si poročilo o kvizu';
$string['everynquestions'] = 'Vsakih {$a} vprašanj';
$string['everyquestion'] = 'Vsako vprašanje';
$string['everythingon'] = 'Vse o';
$string['existingcategory'] = 'Obstoječa kategorija';
$string['exportcategory'] = 'izvozi kategorijo';
$string['exporterror'] = 'Prišlo je do napake pri izvozu datoteke';
$string['exportingquestions'] = 'Vprašanja se izvažajo v datoteko';
$string['exportname'] = 'Ime datoteke';
$string['exportquestions'] = 'Izvozi vprašanja v datoteko';
$string['extraattemptrestrictions'] = 'Dodatne omejitve pri številu poskusov';
$string['false'] = 'Ne drži';
$string['feedback'] = 'Pripombe';
$string['feedbackerrorboundaryformat'] = 'Meja za odziv na oceno mora biti določena z odstotkom ali s številko. Vrednost vnesena v mejo {$a} ni bila prepoznana.';
$string['feedbackerrorboundaryoutofrange'] = 'Meje za odziv na oceno morajo biti med 0 % in 100 &. Vnesena vrednost {$a}, ne ustreza določenemu obsegu.';
$string['feedbackerrorjunkinboundary'] = 'Polja za mejo za odziv na oceno morate izpolniti brez praznin.';
$string['feedbackerrorjunkinfeedback'] = 'Polja za odziv morate izpolniti brez praznin.';
$string['feedbackerrororder'] = 'Meje za odziv na oceno morajo biti v vrstnem redu od najvišje do najnižje. Vrednost, ki ste jo vnesli v mejo {$a}, ni v zaporedju.';
$string['file'] = 'Datoteka';
$string['fileformat'] = 'Format datoteke';
$string['fillcorrect'] = 'Pravilno izpolni';
$string['filloutnumericalanswer'] = 'Vnesite vsaj en možen odgovor in odstopanje. Prvi ujemajoči odgovor bo uporabljen za določanje ocen in odziva. Če boste na koncu vnesli odziv brez odgovora, bo le-ta prikazan udeležencem, katerih rešitev se ne bo ujemala s katerimkoli drugim odgovorom.';
$string['filloutoneanswer'] = 'Podati morate vsaj en možen odgovor. Prazni odgovori ne bodo uporabljeni. \'*\' lahko uporabite kot nadomestni znak za ujemanje s katerimkoli znakom. Prvi ujemajoči odgovor bo uporabljen za določanje ocene in odziva.';
$string['filloutthreequestions'] = 'Podati morate vsaj tri vprašanja in ujemajoče odgovore. Podate lahko tudi več napačnih odgovorov s tem, da vpišete odgovor s praznim vprašanjem. Vnosi, pri katerih sta tako vprašanje kot odgovor prazna, se ne bodo upoštevali.';
$string['fillouttwochoices'] = 'Izpolniti morate vsaj dve izbiri. Prazne izbire ne bodo uporabljene.';
$string['finishattemptdots'] = 'Končaj poskus...';
$string['finishreview'] = 'Zaključi pregled';
$string['forceregeneration'] = 'vsili obnovitev';
$string['formatnotfound'] = 'Uvoznega/izvoznega formata {$a} ni bilo mogoče najti';
$string['formulaerror'] = 'Napake v formuli!';
$string['fractionsaddwrong'] = 'Pozitivne ocene, ki ste jih izbrali, skupaj ne sestavljajo 100 %.<br />Namesto tega sestavljajo {$a} %.<br />Se želite vrniti in popraviti to vprašanje?';
$string['fractionsnomax'] = 'Eden izmed odgovorov mora biti 100 %, da bo <br />možno dobiti polno oceno za to vprašanje.<br />Se želite vrniti in popraviti to vprašanje?';
$string['fromfile'] = 'iz datoteke:';
$string['functiondisabledbysecuremode'] = 'Ta funkcionalnost je trenutno onemogočena';
$string['generalfeedback'] = 'Splošni odziv';
$string['generalfeedback_help'] = 'Splošen odziv je besedilo, ki se udeležencu prikaže za tem, ko odgovori na vprašanje. Za razliko od navadnega odziva, ki je odvisen od vrste vprašanja in odgovora udeleženca, se vsem udeležencem prikaže isto besedilo splošnega odziva.';
$string['gobacktoquiz'] = 'Nazaj';
$string['graceperiod'] = 'Podaljšani čas za oddajo';
$string['graceperiod_desc'] = 'Ko se kviz zapre in je nastavljena nastavitev \'Dovoli podaljšani čas za dokončanje kviza, a ne dovoli spreminjanja odgovorov\', lahko določimo količino dodatnega časa.';
$string['graceperiod_help'] = 'Ko se kviz zapre in je nastavljena nastavitev \'Dovoli podaljšani čas za dokončanje kviza, a ne dovoli spreminjanja odgovorov\', je to količina dodatnega časa.';
$string['graceperiodmin'] = 'Zadnji dovoljen čas za oddajo';
$string['graceperiodmin_desc'] = 'Na koncu kviza obstaja potencialna težava. Po eni strani želimo udeležencu dovoliti reševanje do zadnje sekunde z nastavitvijo avtomatske oddaje ko se čas izteče, po drugi strani pa je lahko v tistem trenutki strežnik preobremenjen in potrebuje več časa da obdela odzive. Zatorej sprejmemo odzive za to obdobje dodatnih sekund po zaprtju kviza zaradi možnih težav s strežnikom. Vendar lahko študent goljufa in uporabi dodatne sekunde za reševanje kviza. Za pravo nastavitev se je treba odločiti na podlagi podatkov o odzivnosti in sposobnosti strežnika.';
$string['graceperiodtoosmall'] = 'Podaljšani čas mora biti večji kot {$a}.';
$string['grade'] = 'Ocena';
$string['gradeall'] = 'Oceni vse';
$string['gradeaverage'] = 'Povprečna ocena';
$string['gradeboundary'] = 'Meja ocene';
$string['gradeessays'] = 'Oceni eseje';
$string['gradehighest'] = 'Najvišja ocena';
$string['gradeitems'] = 'Elementi ocene';
$string['grademethod'] = 'Način ocenjevanja';
$string['grademethod_help'] = 'Ko je dovoljenih več poskusov, obstajajo različni načini uporabe ocen za izračun končne ocene udeleženca za kviz:

* Najvišja ocena
* Povprečna ocena vseh poskusov
* Prvi poskus (vsi drugi so prezrti)
* Zadnji poskus (vsi drugi so prezrti)';
$string['gradesdeleted'] = 'Ocene kviza so bile izbrisane';
$string['gradesofar'] = '{$a->method}: {$a->mygrade} / {$a->quizgrade}.';
$string['gradetopassmustbeset'] = 'Ocena za opravljen kviz ne more biti nič, ker ima ta nabor metod zaključevanja, ki zahteva pozitivno oceno. Prosimo, nastavite vrednost višjo od nič.';
$string['gradetopassoutof'] = 'Ocena za uspešno opravljanje: {$a->grade} od {$a->maxgrade}';
$string['gradingdetails'] = 'Točke za ta prispevek: {$a->raw}/{$a->max}.';
$string['gradingdetailsadjustment'] = 'S prejšnjimi odbitki to znese <strong>{$a->cur}/{$a->max}</strong>.';
$string['gradingdetailspenalty'] = 'Prispevek zahteva kazen za {$a}.';
$string['gradingdetailszeropenalty'] = 'Za ta prispevek ni odbitka.';
$string['gradingmethod'] = 'Način ocenjevanja: {$a}';
$string['groupoverrides'] = 'Preglasitve skupine';
$string['groupoverridesdeleted'] = 'Preglasitve skupine so izbrisane';
$string['groupsnone'] = 'Ne morete dostopati do skupin.';
$string['guestsno'] = 'Gosti ne morejo videti ali poskusiti kvizov';
$string['hidebreaks'] = 'Skrij prelome strani';
$string['hidereordertool'] = 'Skrij orodje za preureditev';
$string['history'] = 'Zgodovina odgovorov:';
$string['howquestionsbehave_desc'] = 'Privzeta nastavitev vprašanj v kvizu.';
$string['imagedisplay'] = 'Slika za prikaz';
$string['import_help'] = 'Ta funkcija vam omogoča uvoz vprašanj iz zunanjih datotek.

 Če vaša datoteka vsebuje ne-acsii znake, potem mora uporabljati UTF-8 kodiranje. Bodite posebno previdni z datotekami ustvarjenimi od Microsoft Office aplikacij, saj te pogosto uporabljajo posebno kodiranje ki ne bo pravilno delovalo.

 Formati za Uvoz in Izvoz so dodani viri. Ostali neobvezni formati do lahko na voljo v Modulski ali Vtični podatkovni bazi.';
$string['import_link'] = 'vprašanje/uvoz';
$string['importcategory'] = 'uvozi kategorijo';
$string['importerror'] = 'Prišlo je do napake med uvozom';
$string['importfilearea'] = 'Uvoz iz datoteke, ki je že med datotekami predmeta...';
$string['importfileupload'] = 'Uvozi iz že naložene datoteke...';
$string['importfromthisfile'] = 'Uvozi iz te datoteke';
$string['importingquestions'] = 'Uvažanje {$a} vprašanj iz datoteke';
$string['importmax10error'] = 'V vprašanju je napaka. Ne morete imeti več kot deset odgovorov';
$string['importmaxerror'] = 'V vprašanju je napaka. Odgovorov je preveč.';
$string['importquestions'] = 'Uvozi vprašanja iz datoteke';
$string['inactiveoverridehelp'] = '* Ta preglasitev je neaktivna, saj je uporabniku omejen dostop do dejavnosti. Morda ne pripada pravi skupini ali nima določene prave vloge, lahko pa je dostop omejen drugje, ali pa je dejavnost skrita.';
$string['incorrect'] = 'Nepravilno';
$string['indicator:cognitivedepth'] = 'Kviz kognitivno';
$string['indicator:cognitivedepth_help'] = 'Indikator temelji na oceni kognitivne globine, ki jo je udeleženec dosegel v dejavnosti Kviz.';
$string['indicator:cognitivedepthdef'] = 'Kviz kognitivno';
$string['indicator:cognitivedepthdef_help'] = 'Udeleženec je v tem intervalu analize dosegel ta odstotek kognitivne angažiranosti, ki jo ponujajo aktivnosti Kviza tekom intervala te analize (Ravni= Brez ogleda, Ogled, Oddaja, Ogled povratnih informacij, Komentiranje povratnih informacij, Ponovna oddaja po ogledu povratnih informacij)';
$string['indicator:cognitivedepthdef_link'] = 'Learning_analytics_indicators#Cognitive_depth';
$string['indicator:socialbreadth'] = 'Kviz družbeno';
$string['indicator:socialbreadth_help'] = 'Indikator temelji na oceni družbene širine, ki jo je udeleženec dosegel v dejavnosti Kviz.';
$string['indicator:socialbreadthdef'] = 'Kviz družbeno';
$string['indicator:socialbreadthdef_help'] = 'Udeleženec je dosegel ta odstotek socialnega udejstvovanja, ki ga ponuja dejavnost Kviz med izbranim intervalom analize (nivoji = brez sodelovanja, sodelovanje, sodelovanje z drugimi)';
$string['indicator:socialbreadthdef_link'] = 'Learning_analytics_indicators#Social_breadth';
$string['indivresp'] = 'Odgovori posameznikov pri vsakem elementu';
$string['info'] = 'Informacije';
$string['infoshort'] = 'i';
$string['initialnumfeedbacks'] = 'Začetno število splošnega odziva';
$string['initialnumfeedbacks_desc'] = 'Pri ustvarjanju novega kviza podajte to število praznih polj za splošen odziv. Ko je kviz ustvarjen, oblika pokaze število polj, zahtevanih za število odzivov v kvizu. Nastavitev mora biti najmanj 1.';
$string['inprogress'] = 'Se izvaja';
$string['introduction'] = 'Opis';
$string['invalidattemptid'] = 'ID poskusa ne obstaja';
$string['invalidcategory'] = 'Kategorija ID je neveljavna';
$string['invalidoverrideid'] = 'Neveljaven ID preglasitve';
$string['invalidquestionid'] = 'Neveljavno vprašanje ID';
$string['invalidquizid'] = 'Neveljavni ID kviza';
$string['invalidrandomslot'] = 'Nepravilno polje za id naključnega vprašanja.';
$string['invalidsource'] = 'Vir ni sprejet kot veljaven.';
$string['invalidsourcetype'] = 'Neveljaven izvirni tip.';
$string['invalidstateid'] = 'Neveljavno stanje ID';
$string['lastanswer'] = 'Vaš zadnji odgovor je bil';
$string['layout'] = 'Postavitev';
$string['layoutasshown'] = 'Postavitev strani kot je prikazana.';
$string['layoutasshownwithpages'] = 'Postavitev strani kot je prikazana. <small>(Samodejna nova stran vsakih {$a} vprašanj.)</small>';
$string['layoutshuffledandpaged'] = 'Vprašanja so naključno premešana s/z {$a} vprašanji na stran.';
$string['layoutshuffledsinglepage'] = 'Vprašanja so naključno premešana vsa na eni strani.';
$string['link'] = 'Povezava';
$string['listitems'] = 'Seznam elementov v kvizu';
$string['literal'] = 'Vrednost';
$string['loadingquestionsfailed'] = 'Nalaganje vprašanja ni bilo uspešno: {$a}';
$string['makecopy'] = 'Shrani kot novo vprašanje';
$string['managetypes'] = 'Upravljanje tipov vprašanj in strežnikov';
$string['manualgradequestion'] = 'Ročno oceni vprašanje {$a->question} in {$a->quiz} od {$a->user}';
$string['manualgrading'] = 'Ocenjevanje';
$string['mark'] = 'Oddaj';
$string['markall'] = 'Oddaj stran';
$string['marks'] = 'Ocene';
$string['marks_help'] = 'Številčne točke za vsako vprašanje in skupni rezultat poskusov.';
$string['match'] = 'Ujemanje';
$string['matchanswer'] = 'Ujemajoč odgovor';
$string['matchanswerno'] = 'Ustrezen odgovor {$a}';
$string['max'] = 'Maks';
$string['maxmark'] = 'Najvišja ocena';
$string['messageprovider:attempt_overdue'] = 'Opozorilo, da je čas reševanja kviza potekel';
$string['messageprovider:confirmation'] = 'Potrditev vaših oddaj kviza';
$string['messageprovider:quiz_open_soon'] = 'Kviz bo odprt kmalu';
$string['messageprovider:submission'] = 'Obvestila o oddajah kviza';
$string['min'] = 'Min';
$string['minutes'] = 'Minute';
$string['missingcorrectanswer'] = 'Pravilni odgovor mora biti naveden';
$string['missingitemtypename'] = 'Manjka ime';
$string['missingquestion'] = 'Kot kaže vprašanje ne obstaja';
$string['modulename'] = 'Kviz';
$string['modulename_help'] = 'Kviz omogoča izvajalcu ustvarjanje kvizov, ki vključujejo vprašanja različnih tipov: izbirni, drži/ne drži, ujemanje in ostale vrste vprašanj. Izvajalec lahko dovoli več poskusov kviza s premešanimi vprašanji ali pa naključno izbranimi iz zbirke vprašanj. Nastavi lahko časovno omejitev.

 Vsak poskus je avtomatsko označen (razen opisnih vprašanj), ocena pa se vpiše v redovalnico.

 Učitelj lahko izbere, ali se bodo prikazali namigi, odzivi in pravilni odgovori in kdaj.

Kvizi so lahko uporabljeni

* Kot izpiti
* Kot mini kvizi za bralne naloge ali na koncu neke teme
* Kot priprava na kviz z uporabo vprašanj iz prejšnjih izpitov
* Za takojšen odziv na rezultat
* Za samoocenjevanje';
$string['modulename_link'] = 'mod/kviz/pogled';
$string['modulenameplural'] = 'Kvizi';
$string['moveselectedonpage'] = 'Premakni izbrana vprašanja na stran: {$a}';
$string['multichoice'] = 'Izbirni tip vprašanja';
$string['multipleanswers'] = 'Izberite vsaj en odgovor.';
$string['mustbesubmittedby'] = 'Rešitve morate oddati do {$a}.';
$string['name'] = 'Ime';
$string['navigatenext'] = 'Naslednja stran';
$string['navigateprevious'] = 'Prejšnja stran';
$string['navmethod'] = 'Način za navigacijo';
$string['navmethod_free'] = 'Prosto';
$string['navmethod_help'] = 'Ko je izbrana "zaporedna" metoda navigacije, mora udeleženec napredovati skozi kviz po vrsti in se ne more vrniti na stran vprašanj nazaj ali preskočiti naprej.';
$string['navmethod_seq'] = 'Zaporedno';
$string['navnojswarning'] = 'Opozorilo: te povezave ne bodo shranile vaših odgovorov. Uporabite gumb za naprej na dnu strani.';
$string['neverallononepage'] = 'Nikoli, vsa vprašanja na eni strani';
$string['newattemptfail'] = 'Napaka: Ni bilo možno začeti novega poskusa v kvizu';
$string['newcategory'] = 'Nova kategorija';
$string['newpage'] = 'Nova stran';
$string['newpage_help'] = 'Za daljše kvize je smiselno raztegniti kviz na več strani z omejitvijo števila vprašanj na stran. Ob dodajanju vprašanj v kviz bodo samodejno vstavljeni prelomi strani glede na to nastavitev. Pozneje boste lahko tudi ročno premikali prelom strani na strani za urejanje.';
$string['newpageevery'] = 'Samodejno začni novo stran';
$string['newsectionheading'] = 'Nov naslov';
$string['noanswers'] = 'Ni izbranega odgovora!';
$string['noattempts'] = 'Za ta kviz še ni bil opravljen noben poskus';
$string['noattemptsfound'] = 'Poskusov ni mogoče najti.';
$string['noattemptstoshow'] = 'Ni poskusov za prikaz';
$string['nocategory'] = 'Napačna ali nedoločena kategorija';
$string['noclose'] = 'Ni datuma zaključka';
$string['nocommentsyet'] = 'Trenutno brez komentarjev.';
$string['noconnection'] = 'Trenutno ni povezave do spletnih storitev, ki bi lahko rešile to vprašanje. Obrnite se na skrbnika.';
$string['nodataset'] = 'nič - to ni nadomestni znak';
$string['nodatasubmitted'] = 'Oddali niste nobenih podatkov.';
$string['noessayquestionsfound'] = 'Ročno ocenjenih vprašanj ni bilo mogoče najti';
$string['nogradewarning'] = 'Ne morete nastaviti splošnih odzivov, ki se razlikujejo po ocenah, saj kviz še ni ocenjen.';
$string['nomoreattempts'] = 'Ni več dovoljenih poskusov';
$string['none'] = 'Brez';
$string['noopen'] = 'Ni datuma začetka';
$string['nooverridedata'] = 'Preglasiti morate vsaj eno nastavitev kviza.';
$string['nopossibledatasets'] = 'Ni možnih podatkovnih nizov';
$string['noquestionintext'] = 'Besedilo vprašanja ne vsebuje ugnezdenih vprašanj';
$string['noquestions'] = 'Nobeno vprašanje še ni dodano';
$string['noquestionsfound'] = 'Nobeno vprašanje ni bilo najdeno';
$string['noquestionsinquiz'] = 'V tem kvizu ni vprašanj.';
$string['noquestionsnotinuse'] = 'Naključno vprašanje ni v uporabi, ker je njegova kategorija prazna.';
$string['noquestionsonpage'] = 'Prazna stran';
$string['noresponse'] = 'Ni odgovora';
$string['noreview'] = 'Nimate dovoljenja za pregled tega kviza';
$string['noreviewattempt'] = 'Nimate dovoljenja za pregled tega poskusa.';
$string['noreviewshort'] = 'Ni dovoljeno';
$string['noreviewuntil'] = 'Nimate dovoljenja za pregled tega kviza do {$a}';
$string['noreviewuntilshort'] = 'Na voljo {$a}:';
$string['noscript'] = 'Za nadaljevanje morate omogočiti JavaScript!';
$string['notavailabletostudents'] = 'Opomba: Ta kviz trenutno ni na voljo vašim udeležencem';
$string['notenoughrandomquestions'] = 'V kategoriji {$a->category} ni dovolj vprašanj, da bi ustvarili vprašanje {$a->name} ({$a->id}).';
$string['notenoughsubquestions'] = 'Ni bilo določenih dovolj podvprašanj! <br />Se želite vrniti in popraviti to vprašanje?';
$string['notimedependentitems'] = 'Časovno odvisni elementi trenutno niso podprti v modulu kviza. Kot rešitev lahko uporabite nastavitev časovne omejitve za cel kviz. Želite izbrati drug element (ali kljub temu uporabiti trenuten element)?';
$string['notyetgraded'] = 'Neocenjeno';
$string['notyetviewed'] = 'Še nepregledano';
$string['notyourattempt'] = 'To ni vaš poskus!';
$string['noview'] = 'Prijavljenemu uporabniku ni dovoljen ogled tega kviza';
$string['numattempts'] = '{$a->studentnum} udeležencev ({$a->studentstring}) je opravilo {$a->attemptnum} poskusov';
$string['numberabbr'] = '#';
$string['numerical'] = 'Številčno';
$string['numquestionsx'] = 'Vprašanja: {$a}';
$string['oneminute'] = '1 minuta';
$string['onlyteachersexport'] = 'Samo učitelji lahko izvozijo vprašanja';
$string['onlyteachersimport'] = 'Samo učitelji s pravicami urejanja lahko uvozijo vprašanja';
$string['onthispage'] = 'Ta stran';
$string['open'] = 'Neodgovorjeno';
$string['openafterclose'] = 'Kviza ni bilo mogoče posodobiti. Izbrali ste datum začetka, ki je poznejši od datuma zaključka.';
$string['openclosedatesupdated'] = 'Datum začetka in konca kviza sta bila posodobljena';
$string['optional'] = 'neobvezno';
$string['orderandpaging'] = 'Vrstni red in strani';
$string['orderandpaging_help'] = 'Številke 10, 20, 30, ... na nasprotni strani vsakega vprašanja določajo vrstni red vprašanj. Številke se povečujejo v korakih po 10, da pustijo prostor za vstavitev dodatnih vprašanj. Za zamenjavo vrstnega reda vprašanj, zamenjajte številke in kliknite gumb "Reorder questions".

Če želite dodati prelom strani po določenih vprašanjih, obkljukajte potrditveno polje zraven vprašanj in kliknite gumb "Dodaj nove strani po izbranih vprašanjih".

Za razvrstitev vprašanj preko več strani, kliknite gumb "Ponovno oštevilči" in izberite želeno število vprašanj na stran.';
$string['orderingquiz'] = 'Vrstni red in strani';
$string['orderingquizx'] = 'Vrstni red in strani: {$a}';
$string['outcomesadvanced'] = 'Izidi so napredne nastavitve';
$string['outof'] = '{$a->grade} od največ {$a->maxgrade}';
$string['outofpercent'] = '{$a->grade} od možno največ {$a->maxgrade} ({$a->percent}%)';
$string['outofshort'] = '{$a->grade}/{$a->maxgrade}';
$string['overallfeedback'] = 'Končne pripombe';
$string['overallfeedback_help'] = 'Končne pripombe so besedilo, ki se udeležencu prikaže po opravljenem poskusu kviza. Prikazano besedilo je lahko odvisno od ocene udeleženca, ki jo je pridobil za poskus.';
$string['overdue'] = 'Poteklo';
$string['overduehandling'] = 'Ko poteče čas reševanja';
$string['overduehandling_desc'] = 'Privzeto dejanje, če udeleženec ne odda kviza pred iztekom časa.';
$string['overduehandling_help'] = 'Ta nastavitev določa, kaj se zgodi, če udeleženec ne odda rezultatov kviza do izteka časa. Če udeleženec še rešuje kviz, bo števec časa samodejno oddal njegove rešitve, če pa je odjavljen, ta nastavitev določa, kaj naj se zgodi.';
$string['overduehandling_link'] = 'način/kviz/čas';
$string['overduehandlingautoabandon'] = 'Poskus mora biti oddan preden poteče čas reševanja, sicer se ne štejejo';
$string['overduehandlingautosubmit'] = 'Odprti poskusi se samodejno zaključijo in oddajo';
$string['overduehandlinggraceperiod'] = 'Dovoli podaljšani čas za dokončanje kviza, a ne dovoli spreminjanja odgovorov';
$string['overduemustbesubmittedby'] = 'Poskus je potekel in odgovore bi že morali oddati. Če želite, da bo kviz ocenjen, ga morate oddati do {$a}, sicer se poskus ne bo upošteval.';
$string['override'] = 'Preglasi';
$string['overridedeletegroupsure'] = 'Ali ste prepričani, da želite izbrisati preglasitev skupine {$a}?';
$string['overridedeleteusersure'] = 'Ali ste prepričani, da želite izbrisati preglasitev za uporabnika {$a}?';
$string['overridegroup'] = 'Preglasi skupino';
$string['overridegroupeventname'] = '{$a->quiz} - {$a->group}';
$string['overrides'] = 'Preglasitve';
$string['overrideuser'] = 'Preglasi uporabnika';
$string['overrideusereventname'] = '{$a->quiz} - Preglasi';
$string['page-mod-quiz-attempt'] = 'Stran poskusa kviza';
$string['page-mod-quiz-edit'] = 'Uredi stran kviza';
$string['page-mod-quiz-report'] = 'Stran za vsa poročila kvizov';
$string['page-mod-quiz-review'] = 'Preglej stran za poskus kviza';
$string['page-mod-quiz-summary'] = 'Stran za povzetek poskusa';
$string['page-mod-quiz-view'] = 'Stran informacij o kvizu';
$string['page-mod-quiz-x'] = 'Katerakoli stran modula kviza';
$string['pageshort'] = 'P';
$string['pagesize'] = 'Velikost strani';
$string['parent'] = 'Nadrejeni';
$string['parentcategory'] = 'Nadrejena kategorija';
$string['parsingquestions'] = 'Razčlenjevanje vprašanj iz uvozne datoteke.';
$string['partiallycorrect'] = 'Delno pravilno';
$string['penalty'] = 'Odbitek';
$string['penaltyscheme'] = 'Uveljavi odbitke';
$string['penaltyscheme_help'] = 'Omogočite lahko odbitek od končne ocene za napačen odgovor. Višina odbitka je določena v nastavitvah za vprašanja. Velja samo, če je omogočen način prilagajanja.';
$string['percentcorrect'] = 'Odstotek pravilnih odgovorov';
$string['pleaseclose'] = 'Vaša zahteva je pregledana. Zdaj lahko zaprete to okno';
$string['pluginadministration'] = 'Skrbništvo kviza';
$string['pluginname'] = 'Kviz';
$string['popup'] = 'Pokaži kviz v "varnem" oknu';
$string['popupblockerwarning'] = 'Te del kviza se izvaja v varnem načinu, kar pomeni, da morate kviz reševati v varnem oknu. Prosimo, omogočite pojavna okna. Hvala.';
$string['popupnotice'] = 'Udeleženci bodo videli ta kviz v varnem oknu';
$string['preprocesserror'] = 'Med predobdelavo je prišlo do napake!';
$string['preview'] = 'Predogled';
$string['previewquestion'] = 'Predogled vprašanja';
$string['previewquiz'] = 'Predogled {$a}';
$string['previewquiznow'] = 'Pojdi na predogled kviza';
$string['previewquizstart'] = 'Predogled kviza';
$string['previous'] = 'Prejšnje stanje';
$string['privacy:metadata:core_question'] = 'Ta dejavnost shrani informacije o uporabi vprašanj v "core_question subsystem".';
$string['privacy:metadata:quiz'] = 'Ta dejavnost uporabi poročila kvizov.';
$string['privacy:metadata:quiz_attempts'] = 'Podrobnosti o vsakem poskusu v kvizu.';
$string['privacy:metadata:quiz_attempts:attempt'] = 'Število poskusa.';
$string['privacy:metadata:quiz_attempts:currentpage'] = 'Trenutna stran uporabnika.';
$string['privacy:metadata:quiz_attempts:preview'] = 'Ali je to predogled kviza.';
$string['privacy:metadata:quiz_attempts:state'] = 'Trenutno stanje poskusa.';
$string['privacy:metadata:quiz_attempts:sumgrades'] = 'Seštevek ocen v poskusu.';
$string['privacy:metadata:quiz_attempts:timecheckstate'] = 'Čas pregleda stanja.';
$string['privacy:metadata:quiz_attempts:timefinish'] = 'Čas zaključitve poskusa.';
$string['privacy:metadata:quiz_attempts:timemodified'] = 'Čas posodobitve poskusa.';
$string['privacy:metadata:quiz_attempts:timemodifiedoffline'] = 'Čas posodobitve poskusa v nepovezanem načinu.';
$string['privacy:metadata:quiz_attempts:timestart'] = 'Čas začetka poskusa.';
$string['privacy:metadata:quiz_grades'] = 'Podrobnosti o končni oceni za kviza.';
$string['privacy:metadata:quiz_grades:grade'] = 'Končna ocena kviza.';
$string['privacy:metadata:quiz_grades:quiz'] = 'Ocenjen kviz.';
$string['privacy:metadata:quiz_grades:timemodified'] = 'Čas spremembe ocene.';
$string['privacy:metadata:quiz_grades:userid'] = 'Uporabnik, ki je bil ocenjen.';
$string['privacy:metadata:quiz_overrides'] = 'Podrobnosti o preglasitvah za ta kviz';
$string['privacy:metadata:quiz_overrides:quiz'] = 'Kviz z informacijami o preglasitvi';
$string['privacy:metadata:quiz_overrides:timeclose'] = 'Novi čas zaključka kviza.';
$string['privacy:metadata:quiz_overrides:timelimit'] = 'Nova časovna omejitev kviza.';
$string['privacy:metadata:quiz_overrides:timeopen'] = 'Novi čas začetka kviza.';
$string['privacy:metadata:quiz_overrides:userid'] = 'Preglasitev uporabnika';
$string['privacy:metadata:quizaccess'] = 'Ta dejavnost uporabi pravila dostopa do kvizov.';
$string['publish'] = 'Objavi';
$string['publishedit'] = 'Imeti morate dovoljenje v objavljenem predmetu za dodajanje ali urejanje vprašanj te kategorije';
$string['qbrief'] = 'Vprašanje {$a}';
$string['qname'] = 'ime';
$string['qti'] = 'Format IMS QTI';
$string['qtypename'] = 'vrsta, ime';
$string['question'] = 'Vprašanje';
$string['questionbank'] = 'iz zbirke vprašanj';
$string['questionbankmanagement'] = 'Upravljanje zbirke vprašanj';
$string['questionbehaviour'] = 'Vedenje vprašanja';
$string['questioncats'] = 'Kategorije vprašanj';
$string['questiondeleted'] = 'To vprašanje je bilo izbrisano. Prosimo, obrnite se na vašega učitelja';
$string['questiondependencyadd'] = 'Ni omejitev glede časa reševanja vprašanja {$a->thisq} • Kliknite za spremembo';
$string['questiondependencyfree'] = 'Ni omejitev za to vprašanje';
$string['questiondependencyremove'] = 'Vprašanja {$a->thisq} ne morete začeti reševati dokler ne zaključite prejšnjega vprašanja {$a->previousq} • Kliknite za spremembo';
$string['questiondependsonprevious'] = 'Vprašanja ne morete začeti reševati dokler ne zaključite prejšnjega vprašanja.';
$string['questioninuse'] = 'Vprašanje \'{$a->questionname}\' se trenutno uporablja v: <br />{$a->quiznames}<br />Vprašanje ne bo izbrisano iz teh kvizov, temveč le iz seznama kategorije.';
$string['questionmissing'] = 'Vprašanje za to srečanje manjka';
$string['questionname'] = 'Ime vprašanja';
$string['questionnonav'] = '<span class="accesshide">Vprašanje </span>{$a->number}<span class="accesshide"> {$a->attributes}</span>';
$string['questionnonavinfo'] = '<span class="accesshide">Informacija </span>{$a->number}<span class="accesshide"> {$a->attributes}</span>';
$string['questionnotloaded'] = 'Vprašanje {$a} ni bilo naloženo iz zbirke podatkov';
$string['questionorder'] = 'Vrstni red vprašanj';
$string['questionposition'] = 'Nov vrstni red vprašanj {$a}';
$string['questions'] = 'Vprašanja';
$string['questionsetpreview'] = 'Predogled nabora vprašanj';
$string['questionsinclhidden'] = 'Vprašanja (vključno s skritimi)';
$string['questionsinthisquiz'] = 'Vprašanja v tem kvizu';
$string['questionsmatchingfilter'] = 'Vprašanja, ki s ujemajo s tem filtrom: {$a}';
$string['questionsperpage'] = 'Št. vprašanj na stran';
$string['questionsperpageselected'] = 'Nastavili ste število vprašanj na stran, tako da so strani trenutno urejene. Upravljanje s stranmi je bilo tako onemogočeno. To lahko spremenite v {$a}.';
$string['questionsperpagex'] = 'Št. vprašanj na stran: {$a}';
$string['questiontext'] = 'Besedilo vprašanja';
$string['questiontextisempty'] = '[Prazno besedilo vprašanja]';
$string['questiontype'] = 'Tip vprašanja {$a}';
$string['questiontypesetupoptions'] = 'Možnosti nastavitev za tipe vprašanj:';
$string['quiz:addinstance'] = 'Dodajte nov kviz';
$string['quiz:attempt'] = 'Poskus reševanja kvizov';
$string['quiz:deleteattempts'] = 'Brisanje poskusov kviza';
$string['quiz:emailconfirmsubmission'] = 'Prejmi obvestilo ob oddaji';
$string['quiz:emailnotifysubmission'] = 'Prejmi obvestilo, ko je poskus oddan';
$string['quiz:emailwarnoverdue'] = 'Prejmi obvestilo, ko je poskus potekel in ga je treba oddati.';
$string['quiz:grade'] = 'Ročno ocenjevanje kvizov';
$string['quiz:ignoretimelimits'] = 'Ignoriranje časovne omejitve kviza';
$string['quiz:manage'] = 'Upravljanje kvizov';
$string['quiz:manageoverrides'] = 'Upravljanje preglasitev kviza';
$string['quiz:preview'] = 'Predogled kvizov';
$string['quiz:regrade'] = 'Ponovno oceni poskuse kviza';
$string['quiz:reviewmyattempts'] = 'Pregled lastnih rešitev';
$string['quiz:view'] = 'Ogled informacij o kvizu';
$string['quiz:viewreports'] = 'Ogled poročil kviza';
$string['quizavailable'] = 'Kviz je na voljo do: {$a}';
$string['quizclose'] = 'Zapri kviz';
$string['quizclosed'] = 'Kviz zaprt dne {$a}';
$string['quizcloses'] = 'Kviz se zapre';
$string['quizcloseson'] = 'Kviz se bo zaprl ob {$a}.';
$string['quizeventcloses'] = '{$a} se zapre';
$string['quizeventopens'] = '{$a} se odpre';
$string['quizisclosed'] = 'Ta kviz je zaprt';
$string['quizisclosedwillopen'] = 'Kviz je zaprt. Odpre se ob {$a}';
$string['quizisopen'] = 'Ta kviz je odprt';
$string['quizisopenwillclose'] = 'Kviz je odprt. Zapre se ob {$a}';
$string['quiznavigation'] = 'Navigacija po kvizu';
$string['quizopen'] = 'Odpri kviz';
$string['quizopenclose'] = 'Datumi odprtja in zaprtja';
$string['quizopenclose_help'] = 'Udeleženci lahko začnejo z reševanjem po odprtju kviza in morajo zaključiti reševanje pred zaprtjem.';
$string['quizopenclose_link'] = 'način/kviz/čas';
$string['quizopened'] = 'Ta kviz je odprt.';
$string['quizopenedon'] = 'Ta kviz se je odprl ob {$a}';
$string['quizopens'] = 'Kviz se odpre';
$string['quizopenwillclose'] = 'Ta kviz je odprt, zaprl se bo {$a} ob';
$string['quizordernotrandom'] = 'Vrstni red kviza ni naključen';
$string['quizorderrandom'] = '* Vrstni red kviza je naključen';
$string['quizreport'] = 'Poročilo o kvizu';
$string['quizsettings'] = 'Nastavitve kviza';
$string['quiztimer'] = 'Merjenje časa kviza';
$string['quizwillopen'] = 'Ta kviz se bo odprl {$a}';
$string['random'] = 'Naključno vprašanje';
$string['randomcreate'] = 'Ustvari naključna vprašanja';
$string['randomediting'] = 'Urejanje naključnega vprašanja';
$string['randomfromcategory'] = 'Naključno vprašanje iz kategorije:';
$string['randomfromexistingcategory'] = 'Naključno vprašanje iz obstoječe kategorije';
$string['randomfromunavailabletag'] = '{$a} (ni na voljo)';
$string['randomnosubcat'] = 'Vprašanja samo iz te kategorije, ne iz njenih podkategorij.';
$string['randomnumber'] = 'Število naključnih vprašanj';
$string['randomquestion'] = 'Naključno vprašanje';
$string['randomquestion_help'] = 'Naključno vprašanje je način za vstavljanje naključno izbranega vprašanja iz določene kategorije ali oznake v dejavnost.';
$string['randomquestiontags'] = 'Oznake';
$string['randomquestiontags_help'] = 'Kriterije za izbiro lahko bolj omejite z določitvijo oznak za vprašanja.

 "Naključna" vprašanja bodo izbrana iz vprašanj, ki imajo vse te oznake.';
$string['randomquestionusinganewcategory'] = 'Naključno vprašanje z uporabo nove kategorije';
$string['randomwithsubcat'] = 'Vprašanja iz te kategorije in njenih podkategorij.';
$string['readytosend'] = 'Poslali boste svoj kviz v ocenjevanje. Ali ste prepričani, da želite nadaljevati?';
$string['reattemptquiz'] = 'Ponovno reši kviz';
$string['recentlyaddedquestion'] = 'Nedavno dodano vprašanje!';
$string['recurse'] = 'Vključi tudi vprašanja iz podkategorij';
$string['redoesofthisquestion'] = 'Druga vprašanja, ki ste jih poskusili tukaj: {$a}';
$string['redoquestion'] = 'Poskusi s še enim vprašanjem, kot je ta';
$string['regrade'] = 'Ponovno oceni vse poskuse';
$string['regradecomplete'] = 'Vsi poskusi so bili ponovno ocenjeni';
$string['regradecount'] = '{$a->changed} od {$a->attempt} ocen je bilo spremenjenih';
$string['regradedisplayexplanation'] = 'Poskusi, ki se spremenijo med ponovnim ocenjevanjem, so prikazani kot povezave na okno pregleda vprašanja';
$string['regradenotallowed'] = 'Nimate dovoljenja za ponovno ocenjevanje tega kviza';
$string['regradingquestion'] = 'Ponovno ocenjevanje "{$a}".';
$string['regradingquiz'] = 'Ponovno ocenjevanje kviza "{$a}"';
$string['remove'] = 'Odstrani';
$string['removeallgroupoverrides'] = 'Izbriši vse preglasitve skupine';
$string['removeallquizattempts'] = 'Izbriši vse poskuse kviza';
$string['removealluseroverrides'] = 'Izbriši vse preglasitve uporabnika';
$string['removeemptypage'] = 'Odstrani prazno stran';
$string['removepagebreak'] = 'Odstrani prelom strani';
$string['removeselected'] = 'Odstrani izbrano';
$string['rename'] = 'Preimenuj';
$string['renderingserverconnectfailed'] = 'Strežnik {$a} ni uspel obdelati zahteve RQP. Preverite, če je URL pravilen.';
$string['reorderquestions'] = 'Zamenjaj vrstni red vprašanj';
$string['reordertool'] = 'Pokaži orodje za spreminjanje vrstnega reda';
$string['repaginate'] = 'Preštevilči strani po {$a} vprašanj na stran';
$string['repaginatecommand'] = 'Ponovni oštevilči';
$string['repaginatenow'] = 'Ponovno oštevilči zdaj';
$string['replace'] = 'Zamenjaj';
$string['replacementoptions'] = 'Možnosti zamenjave';
$string['report'] = 'Poročila';
$string['reportanalysis'] = 'Analiza elementa';
$string['reportattemptsfrom'] = 'Poskusi od';
$string['reportattemptsthatare'] = 'Poskusi, ki so';
$string['reportdisplayoptions'] = 'Možnosti prikaza';
$string['reportfullstat'] = 'Podrobna statistika';
$string['reportmulti_percent'] = 'Večkratni odstotki';
$string['reportmulti_q_x_student'] = 'Večkratne izbire udeležencev';
$string['reportmulti_resp'] = 'Posamezni odgovori';
$string['reportmustselectstate'] = 'Izbrati morate vsaj eno stanje.';
$string['reportnotfound'] = 'Poročilo ni znano ({$a})';
$string['reportoverview'] = 'Pregled';
$string['reportregrade'] = 'Ponovno oceni poskuse';
$string['reportresponses'] = 'Podrobni odgovori';
$string['reports'] = 'Poročila';
$string['reportshowonly'] = 'Prikaži le poskuse';
$string['reportshowonlyfinished'] = 'Pokaži največ en končan poskus na udeleženca ({$a})';
$string['reportsimplestat'] = 'Preprosta statistika';
$string['reportusersall'] = 'vsi uporabniki, ki so rešili kviz';
$string['reportuserswith'] = 'vpisanih uporabnikov, ki so rešili kviz';
$string['reportuserswithorwithout'] = 'vpisanih uporabnikov, ki so že ali še niso reševali kviza';
$string['reportuserswithout'] = 'vpisanih uporabnikov, ki še niso reševali kviza';
$string['reportwhattoinclude'] = 'Kaj naj bo vključeno v poročilo';
$string['requirepassword'] = 'Zahtevaj geslo';
$string['requirepassword_help'] = 'Če tu določite geslo, bodo udeleženci morali vnesti to geslo, preden bodo smeli poskusiti odgovarjati na kviz.';
$string['requiresubnet'] = 'Zahtevaj omrežni naslov';
$string['requiresubnet_help'] = 'Dostop do kviza lahko omejite za določene dele omrežja v lokalnem omrežju ali internetu z navedbo z vejicami ločenega seznama delnih ali celotnih IP naslovov. To je še posebej uporabno za zaščito kviza, če želite, da bi recimo do kviza dostopale samo osebe iz določene lokacije.';
$string['response'] = 'Odgovor';
$string['responses'] = 'Odgovori';
$string['results'] = 'Rezultati';
$string['returnattempt'] = 'Nazaj na poskus';
$string['reuseifpossible'] = 'ponovno uporabi predhodno odstranjene';
$string['reverttodefaults'] = 'Vrni se na privzete nastavitve kviza';
$string['review'] = 'Pregled';
$string['reviewafter'] = 'Dovoli pregled po zaprtju kviza';
$string['reviewalways'] = 'Dovoli pregled kadarkoli';
$string['reviewattempt'] = 'Preglej poskus';
$string['reviewbefore'] = 'Dovoli pregled, dokler je kviz odprt';
$string['reviewclosed'] = 'Po zaprtju kviza';
$string['reviewduring'] = 'Med poskusom';
$string['reviewimmediately'] = 'Takoj po poskusu';
$string['reviewnever'] = 'Nikoli ne dovoli pregleda';
$string['reviewofquestion'] = 'Pregled vprašanja {$a->question} v {$a->quiz} uporabnika {$a->user}';
$string['reviewopen'] = 'Pozneje, dokler je kviz še odprt';
$string['reviewoptions'] = 'Udeleženci lahko pregledujejo';
$string['reviewoptionsheading'] = 'Možnosti pregledovanja';
$string['reviewoptionsheading_help'] = 'Te nastavitve določajo, katere informacije lahko udeleženci vidijo, ko pregledujejo poskus ali poročila kviza.

**Med poskusom** so nastavitve relevantne samo za par vedenj, kot so "Interaktivno z več poskusi", ki lahko odziv pokaze med poskusom.

**Takoj po koncu poskusa** so nastavitve veljavne dveh minuti za tem, ko uporabnik zaključi poskus s klikom na \'Oddaj vse in zaključi‘.

** Pozneje, dokler je kviz še odprt** so nastavitve veljavne po tem in do takrat, ko se kviz zapre.

** Po zaprtju kviza** so nastavitve veljavne po datumu zaprtja kviza. Če kviz nima določen datum zaprtja, se to stanje nikoli ne doseže.';
$string['reviewoverallfeedback'] = 'Končne pripombe';
$string['reviewoverallfeedback_help'] = 'Odziv po koncu reševanja glede na skupno oceno udeleženca.';
$string['reviewresponse'] = 'Preglej odgovor';
$string['reviewresponsetoq'] = 'Preglej odgovor (vprašanja {$a})';
$string['reviewthisattempt'] = 'Pregled odgovorov za ta poskus';
$string['rqp'] = 'Oddaljeno vprašanje';
$string['rqps'] = 'Oddaljena vprašanja';
$string['sameasoverall'] = 'Enako kot pri splošnih ocenah';
$string['save'] = 'Shrani';
$string['saveandedit'] = 'Shrani spremembe in uredi vprašanja';
$string['saveattemptfailed'] = 'Shranjevanje trenutnega poskusa kviza ni uspelo.';
$string['savedfromdeletedcourse'] = 'Shranjeno iz izbrisanega predmeta "{$a}"';
$string['savegrades'] = 'Shrani ocene';
$string['savemyanswers'] = 'Shrani moje odgovore';
$string['savenosubmit'] = 'Shrani brez oddaje';
$string['saveoverrideandstay'] = 'Shrani in vnesi novo preglasitev';
$string['savequiz'] = 'Shrani cel kviz';
$string['saving'] = 'Shranjujem';
$string['savingnewgradeforquestion'] = 'Shranjujem novo oceno za vprašanje z ID {$a}.';
$string['savingnewmaximumgrade'] = 'Shranjujem novo najvišjo oceno.';
$string['score'] = 'Čisto število točk';
$string['scores'] = 'Rezultati';
$string['search:activity'] = 'Kviz - informacije o dejavnosti';
$string['sectionheadingedit'] = 'Uredi naslov \'{$a}\'';
$string['sectionheadingremove'] = 'Odstrani naslov \'{$a}\'';
$string['seequestions'] = '(Glej vprašanja)';
$string['select'] = 'Izberi';
$string['selectall'] = 'Izberi vse';
$string['selectattempt'] = 'Izberi poskus';
$string['selectcategory'] = 'Izberi kategorijo';
$string['selectedattempts'] = 'Izbrani poskusi...';
$string['selectmultipleitems'] = 'Izberi več elementov';
$string['selectmultipletoolbar'] = 'Izberi več orodnih vrstic';
$string['selectnone'] = 'Počisti izbor';
$string['selectquestiontype'] = '-- Izberi tip vprašanja --';
$string['serveradded'] = 'Dodan strežnik';
$string['serveridentifier'] = 'Identifikator';
$string['serverinfo'] = 'Informacije o strežniku';
$string['servers'] = 'Strežniki';
$string['serverurl'] = 'URL strežnika';
$string['shortanswer'] = 'Kratek odgovor';
$string['show'] = 'Pokaži';
$string['showall'] = 'Pokaži vsa vprašanja na eni strani';
$string['showblocks'] = 'Pokaži bloke med poskusi kviza';
$string['showblocks_help'] = 'Če je nastavljeno na Da, bodo normalni bloki prikazani med poskusi kviza';
$string['showbreaks'] = 'Pokaži prelome strani';
$string['showcategorycontents'] = 'Prikaži vsebine kategorije {$a->arrow}';
$string['showcorrectanswer'] = 'Pokaži pravilne odgovore v odzivih?';
$string['showdetailedmarks'] = 'Prikaži podrobnosti ocene';
$string['showeachpage'] = 'Prikaži eno stran na enkrat';
$string['showfeedback'] = 'Pokaži odziv po odgovoru?';
$string['showinsecurepopup'] = 'Za poskuse uporabi \'varno\' pojavno okno';
$string['showlargeimage'] = 'Velika slika';
$string['shownoattempts'] = 'Pokaži udeležence brez poskusov';
$string['shownoattemptsonly'] = 'Pokaži samo udeležence brez poskusov';
$string['shownoimage'] = 'Ni slike';
$string['showreport'] = 'Prikaži poročilo';
$string['showsmallimage'] = 'Majhna slika';
$string['showteacherattempts'] = 'Pokaži poskuse učitelja';
$string['showuserpicture'] = 'Prikaži sliko uporabnika';
$string['showuserpicture_help'] = 'Če je omogočeno, bosta uporabnikovo ime in slika prikazana med reševanjem kviza in na strani za pregledovanje. To olajša nadzor identitete udeležencev med nadzorovanim izpitom.';
$string['shuffle'] = 'Premešaj';
$string['shuffleanswers'] = 'Premešaj odgovore';
$string['shuffledrandomly'] = 'Naključno premešano';
$string['shufflequestions'] = 'Premešaj';
$string['shufflequestions_help'] = 'Če je omogočeno, se bo pri vsakem poskusu kviza premešal vrstni red vprašanj v tem odseku v drugačen naključen vrstni red.

To lahko udeležencem oteži deljenje odgovorov, oteži pa tudi posvet glede določnega vprašanja.';
$string['shufflewithin'] = 'Premešaj med vprašanji';
$string['shufflewithin_help'] = 'Če omogočite to možnost, bodo deli, ki sestavljajo posamezna vprašanja, naključno premešani vsakič, ko bo udeleženec začel reševati kviz, seveda ob pogoju, da je to omogočeno tudi v nastavitvah vprašanja. To velja samo za vprašanja, ki prikazujejo več delov, kot sta vprašanje z večimi odgovori in vprašanje ujemanja.';
$string['singleanswer'] = 'Izberite en odgovor.';
$string['sortage'] = 'Razvrsti po starosti';
$string['sortalpha'] = 'Razvrsti po imenu';
$string['sortquestionsbyx'] = 'Razvrsti vprašanja po: {$a}';
$string['sortsubmit'] = 'Razvrsti vprašanja';
$string['sorttypealpha'] = 'Razvrsti po vrsti, imenu';
$string['specificapathnotonquestion'] = 'Mesto datoteke pri določenem vprašanju ni določeno';
$string['specificquestionnotonquiz'] = 'Določenega vprašanja na pri določenem kvizu';
$string['startagain'] = 'Začni znova';
$string['startattempt'] = 'Začni s poskusom';
$string['startedon'] = 'Začeto';
$string['startnewpreview'] = 'Začni nov predogled';
$string['stateabandoned'] = 'Nikoli oddano';
$string['statefinished'] = 'Končano';
$string['statefinisheddetails'] = 'Oddano {$a}';
$string['stateinprogress'] = 'Se izvaja';
$string['statenotloaded'] = 'Stanje za vprašanje {$a} ni bilo naloženo iz baze podatkov';
$string['stateoverdue'] = 'Poteklo';
$string['stateoverduedetails'] = 'Morate oddati do {$a}';
$string['status'] = 'Stanje';
$string['stoponerror'] = 'Ustavi se ob napaki';
$string['submission_confirmation'] = 'Oddaj vse odgovore in zaključi?';
$string['submitallandfinish'] = 'Oddaj vse in zaključi';
$string['subneterror'] = 'Oprostite, ta kviz je bil zaklenjen in je dostopen samo iz določenih lokacij. Trenutno vaš računalnik ni eden izmed tistih, ki smejo uporabljati ta kviz.';
$string['subnetnotice'] = 'Ta kviz je bil zaklenjen in je dostopen samo iz določenih lokacij. Vaš računalnik ni v dovoljenem omrežju. Kot učitelj imate vseeno dostop do pregledovanja.';
$string['subplugintype_quiz'] = 'Poročilo';
$string['subplugintype_quiz_plural'] = 'Poročila';
$string['subplugintype_quizaccess'] = 'Pravilo dostopa';
$string['subplugintype_quizaccess_plural'] = 'Pravila dostopa';
$string['substitutedby'] = 'bodo nadomeščena z';
$string['summaryofattempt'] = 'Povzetek poskusa';
$string['summaryofattempts'] = 'Vaši poskusi';
$string['temporaryblocked'] = 'Trenutno ne smete ponoviti poskusa.<br />Ponovno boste lahko poskusili:';
$string['theattempt'] = 'Poskus';
$string['theattempt_help'] = 'Ali lahko udeleženec sploh pregleda svoj poskus.';
$string['time'] = 'Čas';
$string['timecompleted'] = 'Zaključeno';
$string['timedelay'] = 'Ne smete poskusiti kviza, ker še ni potekla časovna omejitev od prejšnjega poskusa';
$string['timeleft'] = 'Preostali čas';
$string['timelimit'] = 'Časovna omejitev';
$string['timelimit_help'] = 'Če je omogočeno, je časovna omejitev prikazana na začetni strani, v navigacijskem stolpcu pa je prikazan odštevalnik.';
$string['timelimit_link'] = 'način/kviz/čas';
$string['timelimitexeeded'] = 'Prekoračena časovna omejitev kviza!';
$string['timestr'] = '%H:%M:%S dne %d/%m/%y';
$string['timesup'] = 'Čas je potekel!';
$string['timetaken'] = 'Porabljeni čas';
$string['timing'] = 'Časovne nastavitve';
$string['tofile'] = 'v datoteko';
$string['tolerance'] = 'Dovoljeno odstopanje';
$string['toomanyrandom'] = 'Število zahtevanih naključnih vprašanj je večje od števila vprašanj, ki so še na voljo v tej kategoriji!';
$string['top'] = 'Vrh';
$string['totalmarksx'] = 'Skupno število točk: {$a}';
$string['totalquestionsinrandomqcategory'] = 'Skupno {$a} vprašanj v kategoriji.';
$string['true'] = 'Drži';
$string['truefalse'] = 'Drži/Ne drži';
$string['type'] = 'Tip';
$string['unfinished'] = 'odpri';
$string['ungraded'] = 'Neocenjeno';
$string['unit'] = 'Enota';
$string['unknowntype'] = 'Tip vprašanja ni podprt v vrstici {$a}. Vprašanje bo prezrto';
$string['updateoverdueattemptstask'] = 'Posodabljanje poteklih poskusov kviza';
$string['updatequizslotswithrandomxofy'] = 'Posodabljanje kviznih polj s podatki o "naključnih" vprašanjih ({$a->done}/{$a->total})';
$string['updatesettings'] = 'Posodobi nastavitve kviza';
$string['updatingatttemptgrades'] = 'Posodabljam ocene poskusa.';
$string['updatingfinalgrades'] = 'Posodabljam končne ocene.';
$string['updatingthegradebook'] = 'Posodabljam redovalnico.';
$string['upgradesure'] = '<div>Še posebej bo modul kviza izvedel izčrpne spremembe v tabelah kviza in ta posodobitev še ni bila uspešno preizkušena. Močno vam priporočamo ustvarjanje varnostne kopije tabel podatkovne zbirke pred nadaljevanjem.</div>';
$string['upgradingquizattempts'] = 'Posodabljam poskuse kviza: kviz {$a->done}/{$a->outof} (ID kviza {$a->info})';
$string['upgradingveryoldquizattempts'] = 'Posodabljam stare poskuse kviza: {$a->done}/{$a->outof}';
$string['url'] = 'URL';
$string['usedcategorymoved'] = 'Ta kategorija je bila ohranjena in premaknjena na raven spletnega mesta, ker je objavljena kategorija, ki jo še vedno uporabljajo drugi predmeti.';
$string['useroverrides'] = 'Preglasitve uporabnika';
$string['useroverridesdeleted'] = 'Preglasitve uporabnika so izbrisane';
$string['usersnone'] = 'Do tega kviza nima dostopa noben udeleženec';
$string['validate'] = 'Potrdi';
$string['viewallanswers'] = 'Prikaz {$a} poskusov kviza';
$string['viewallreports'] = 'Ogled poročil za toliko poskusov: {$a}';
$string['viewed'] = 'Ogledani';
$string['warningmissingtype'] = '<b>To je tip vprašanj, ki v vaš Moodle še ni nameščen.<br />Opozorite vašega skrbnika Moodla.</b>';
$string['wheregrade'] = 'Kje je moja ocena?';
$string['wildcard'] = 'Nadomestni znak';
$string['windowclosing'] = 'To okno bo v kratkem zaprto.';
$string['withsummary'] = 's povzetkom statistike';
$string['wronguse'] = 'Te strani ne morete uporabiti tako';
$string['xhtml'] = 'Format XHTML';
$string['youneedtoenrol'] = 'Pred opravljanjem tega kviza se morate vključiti v ta predmet';
$string['yourfinalgradeis'] = 'Vaša končna ocena za ta kviz je {$a}.';
