<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'question', language 'sl', version '4.5'.
 *
 * @package     question
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['action'] = 'Ukaz';
$string['addanotherhint'] = 'Dodaj namig';
$string['addcategory'] = 'Dodaj kategorijo';
$string['addmorechoiceblanks'] = 'Prazno za {no} možnosti';
$string['adminreport'] = 'Poročajte o morebitnih težavah v podatkovni bazi vprašanj.';
$string['advancedsearchoptions'] = 'Možnosti iskanja';
$string['alltries'] = 'Vsi poskusi';
$string['answer'] = 'Odgovor';
$string['answers'] = 'Odgovori';
$string['answersaved'] = 'Odgovor shranjen';
$string['attemptfinished'] = 'Poskus končan';
$string['attemptfinishedsubmitting'] = 'Poskus oddaje zaključen: {$a}';
$string['attemptoptions'] = 'Možnosti poskusa';
$string['availableq'] = 'Na voljo?';
$string['badbase'] = 'Neveljavno pred **: {$a}**';
$string['behaviour'] = 'Vedenje';
$string['behaviourbeingused'] = 'Obnašanje, ki je v uporabi: {$a}';
$string['broken'] = 'To je "prekinjena povezava", saj kaže na neobstoječo datoteko.';
$string['byandon'] = 'uporabnika <em>{$a->user}</em>, ob <em>{$a->time}</em>';
$string['cannotcopybackup'] = 'Ni mogoče kopirati varnostne kopije datoteke';
$string['cannotcreate'] = 'Ni mogoče ustvariti novega vnosa v tabeli question_attempts';
$string['cannotcreatepath'] = 'Ni mogoče ustvariti poti: {$a}';
$string['cannotdeletebehaviourinuse'] = 'Ne morete izbrisati vedenja \'{$a}\'. Uporablja se pri poskusih odgovora na vprašanje.';
$string['cannotdeletecate'] = 'Ne morete izbrisati te kategorije, ker je privzeta za ta kontekst.';
$string['cannotdeleteneededbehaviour'] = 'Ni mogoče izbrisati vedenja \'{$a}\', saj se druga nameščena vedenja nanj nanašajo.';
$string['cannotdeleteqtypeinuse'] = 'Tipa vprašanj \'{$a}\' ne morete izbrisati, saj so vprašanja tega tipa v zbirki vprašanj.';
$string['cannotdeleteqtypeneeded'] = 'Tipa vprašanj \'{$a}\' ne morete izbrisati, saj se drugi nameščeni tipi vprašanj nanj nanašajo.';
$string['cannotdeletetopcat'] = 'Zgornjih kategorij ni mogoče izbrisati.';
$string['cannotedittopcat'] = 'Zgornjih kategorij ni mogoče urediti.';
$string['cannotenable'] = 'Ni mogoče neposredno ustvariti tipa vprašanja {$a}.';
$string['cannotenablebehaviour'] = 'Vedenja vprašanja {$a} se ne more neposredno uporabljati. Namenjeno je samo za notranjo uporabo.';
$string['cannotfindcate'] = 'Ni mogoče najti zapisa kategorije';
$string['cannotfindquestionfile'] = 'Ni mogoče najti stisnjene podatkovne datoteke z vprašanji';
$string['cannotgetdsfordependent'] = 'Ni mogoče dobiti izbranega podatkovnega niza za vprašanje, ki je od niza odvisno! (vprašanje: {$a->id}, element podatkovnega niza: {$a->item})';
$string['cannotgetdsforquestion'] = 'Ni mogoče dobiti izbranega podatkovnega niza za izračunano vprašanje! (vprašanje: {$a})';
$string['cannothidequestion'] = 'Ni mogoče skriti vprašanja';
$string['cannotimportformat'] = 'Oprostite, uvoz tega formata še ni podprt!';
$string['cannotinsertquestion'] = 'Ni mogoče vstaviti novega vprašanja!';
$string['cannotinsertquestioncatecontext'] = 'Ni mogoče vstaviti nove kategorije vprašanj {$a->cat} neveljaven contextid {$a->ctx}';
$string['cannotloadquestion'] = 'Ni mogoče naložiti vprašanja';
$string['cannotmovequestion'] = 'Tega skripta ne morete uporabiti za premik vprašanj, ki povezujejo datoteke iz različnih mest.';
$string['cannotopenforwriting'] = 'Ni mogoče odpreti za pisanje: {$a}';
$string['cannotpreview'] = 'Ne morete si ogledati teh vprašanj!';
$string['cannotread'] = 'Ni mogoče prebrati uvozne datoteke (ali pa je datoteka prazna)';
$string['cannotretrieveqcat'] = 'Ni mogoče obnoviti kategorije vprašanja';
$string['cannotunhidequestion'] = 'Ni uspelo razkriti vprašanja.';
$string['cannotunzip'] = 'Ni mogoče razširiti datoteke.';
$string['cannotwriteto'] = 'Ni mogoče zapisati izvoženih vprašanj v {$a}';
$string['categories'] = 'Kategorije';
$string['category'] = 'Kategorija';
$string['categorycurrent'] = 'Trenutna kategorija';
$string['categorycurrentuse'] = 'Uporabi to kategorijo';
$string['categorydoesnotexist'] = 'Ta kategorija ne obstaja';
$string['categoryinfo'] = 'Informacije o kategoriji';
$string['categorymove'] = 'Kategorija \'{$a->name}\' vsebuje {$a->count} vprašanj (nekatera so lahko stara, skrita ali se še uporabljajo v obstoječih kvizih). Izberite drugo kategorijo, v katero naj se premaknejo.';
$string['categorymoveto'] = 'Shrani v kategorijo';
$string['categorynamecantbeblank'] = 'Ime kategorije ne sme biti prazno.';
$string['categorynamewithcount'] = '{$a->name} ({$a->questioncount})';
$string['categorynamewithidnumber'] = '{$a->name} [{$a->idnumber}]';
$string['categorynamewithidnumberandcount'] = '{$a->name} [{$a->idnumber}] ({$a->questioncount})';
$string['changeoptions'] = 'Spremeni možnosti';
$string['changepublishstatuscat'] = '<a href="{$a->caturl}">Kategoriji "{$a->name}"</a> v predmetu "{$a->coursename}" bo spremenjen status skupne rabe iz <strong>{$a->changefrom} v {$a->changeto}</strong>.';
$string['check'] = 'Preveri';
$string['chooseqtypetoadd'] = 'Izberite tip vprašanja, ki ga želite dodati';
$string['clearwrongparts'] = 'Počisti nepravilne odgovore';
$string['clickflag'] = 'Vprašanje z zastavico';
$string['clicktoflag'] = 'To vprašanje označite z zastavico za prihodnje potrebe';
$string['clicktounflag'] = 'Odstrani zastavico';
$string['clickunflag'] = 'Odstrani zastavico';
$string['closepreview'] = 'Zapri predogled';
$string['combinedfeedback'] = 'Kombiniran odziv';
$string['comment'] = 'Komentar';
$string['commented'] = 'Komentirano: {$a}';
$string['commentormark'] = 'Komentiraj ali preglasi oceno';
$string['comments'] = 'Komentarji';
$string['commentx'] = 'Komentar: {$a}';
$string['complete'] = 'Zaključeno';
$string['contexterror'] = 'Ne bi smeli priti sem, če ne premikate kategorije v drugi kontekst.';
$string['copy'] = 'Kopiraj iz {$a} in spremeni povezave.';
$string['correct'] = 'Pravilno';
$string['correctfeedback'] = 'Za vsak pravilni odgovor';
$string['correctfeedbackdefault'] = 'Vaš odgovor je pravilen.';
$string['created'] = 'Ustvarjeno';
$string['createdby'] = 'Ustvaril';
$string['createdmodifiedheader'] = 'Ustvarjeno/Zadnjič shranjeno';
$string['createnewquestion'] = 'Ustvari novo vprašanje ...';
$string['cwrqpfs'] = 'Naključna izbira vprašanj iz podkategorij.';
$string['cwrqpfsinfo'] = '<p>Med posodobitvijo v Moodle 1.9 bodo kategorije vprašanj razdejene v
različne kontekste. Nekaterim kategorijam vprašanj in vprašanjem na spletnem mestu se bo spremenil
status skupne rabe. To je potrebno v redkih primerih, ko je eno ali več \'naključnih\' vprašanj v kvizu izbiranih iz
kategorij z različnim statusom skupne rabe (kot na tem spletnem mestu). To se zgodi, ko je \'naključno\' vprašanje izbirano
iz podkategorij, kjer ima ena ali več podkategorij drugačen status skupne rabe kot nadrejena kategorija, v kateri je bilo
naključno vprašanje ustvarjeno.</p>
<p>Pri posodobitvi v Moodle 1.9 bo naslednjim kategorijam vprašanj, v katerih \'naključna\' vprašanja iz nadrejenih kategorij izbirajo vprašanja,
spremenjen status skupne rabe v enak status, kot ga ima kategorija z \'naključnim\'
vprašanjem. Naslednjim kategorijam se bo spremenil status skupne rabe.
Zadevna vprašanja bodo še naprej delovala v obstoječih kvizih, dokler ne bodo iz teh kvizov odstranjena.</p>';
$string['cwrqpfsnoprob'] = 'Nobena kategorija vprašanj na vašem spletnem mestu ni bila prizadeta zaradi težave z \'Naključno izbiro vprašanj iz podkategorij\'.';
$string['decimalplacesingrades'] = 'Decimalna mesta v ocenah';
$string['defaultfor'] = 'Privzeto za {$a}';
$string['defaultinfofor'] = 'Privzeta kategorija za vprašanja v skupni rabi v kontekstu \'{$a}\'.';
$string['defaultmark'] = 'Privzeta ocena';
$string['defaultmarkmustbepositive'] = 'Privzeta ocena mora biti pozitivna.';
$string['deletecoursecategorywithquestions'] = 'Zbirka vprašanj vsebuje vprašanja, ki so povezana s to kategorijo predmeta. Če nadaljujete, bodo izbrisana. Morda jih najprej premaknite z uporabo vmesnika zbirke vprašanj.';
$string['deletequestioncheck'] = 'To bo izbrisalo sledeče vprašanje in vse njene različice:<br /><br />{$a}';
$string['deletequestionscheck'] = 'To bo izbrisalo sledeča vprašanja in vse njihove različice:<br /><br />{$a}';
$string['deletingbehaviour'] = 'Izbris vedenja vprašanja \'{$a}\'';
$string['deletingqtype'] = 'Brisanje vprašanja tipa \'{$a}\'';
$string['didnotmatchanyanswer'] = '[Se ne ujema z nobenim odgovorom]';
$string['disabled'] = 'Onemogočeno';
$string['displayoptions'] = 'Možnosti prikaza';
$string['disterror'] = 'Distribucija {$a} je povzročila težave';
$string['donothing'] = 'Ne kopiraj ali premikaj datotek in ne spreminjaj povezav.';
$string['editcategories'] = 'Uredi kategorije';
$string['editcategories_help'] = '<p>Namesto tega, da imate vsa vprašanja v enem dolgem seznamu, jih lahko razvrstite v kategorije in podkategorije.

Vsaka kategorija ima kontekst, ki določa, kje so lahko vprašanja v kategoriji uporabljena:n
\\*Kontekst dejavnosti - Vprašanja so na voljo samo v modulih dejavnosti
* Kontekst predmeta - Vprašanja so na voljo v vseh modulih dejavnosti in predmetov v kategoriji predmeta
* Kontekst sistema - Vprašanja so na voljo v vseh predmetih in dejavnistih na spletni strani
\\Kategorije se uporabljajo tudi za naključna vprašanja, saj so vprašanja izbrana iz določene kategorije.';
$string['editcategories_link'] = 'vprašanje/kategorija';
$string['editcategory'] = 'Uredi kategorijo';
$string['editingcategory'] = 'Urejanje kategorije';
$string['editingquestion'] = 'Urejanje vprašanja';
$string['editquestion'] = 'Uredi vprašanje';
$string['editquestions'] = 'Uredi vprašanja';
$string['editthiscategory'] = 'Uredi to kategorijo';
$string['emptyxml'] = 'Neznana napaka - prazen imsmanifest.xml';
$string['enabled'] = 'Omogočeno';
$string['erroraccessingcontext'] = 'Ni mogoče dostopati do konteksta';
$string['errordeletingquestionsfromcategory'] = 'Napaka pri brisanju vprašanj iz kategorije {$a}.';
$string['errorduringpost'] = 'Med postobdelavo je prišlo do napake!';
$string['errorduringpre'] = 'Med predobdelavo je prišlo do napake!';
$string['errorduringproc'] = 'Med obdelavo je prišlo do napake!';
$string['errorduringregrade'] = 'Ni mogoče ponovno oceniti vprašanja {$a->qid}, prehod v stanje {$a->stateid}.
';
$string['errorfilecannotbecopied'] = 'Napaka: ni mogoče kopirati datoteke {$a}.';
$string['errorfilecannotbemoved'] = 'Napaka: ni mogoče premakniti datoteke {$a}.';
$string['errorfileschanged'] = 'Napaka: datoteke, na katere so povezana vprašanja, so se od prikaza obrazca spremenile.';
$string['erroritemappearsmorethanoncewithdifferentweight'] = 'Vprašanje ({$a}) se pojavi več kot enkrat z različno težo v različnih pozicijah v testu. To trenutno ni podprto v statističnem poročilu in lahko povzroči, da postane statistika tega vprašanja neverodostojna.';
$string['errormanualgradeoutofrange'] = 'Ocena {$a->grade} ni med 0 in {$a->maxgrade} pri vprašanju {$a->name}. Rezultat in komentar nista bila shranjena.';
$string['errormovingquestions'] = 'Napaka pri premikanju vprašanj z identifikacijsko številko {$a}.';
$string['errorpostprocess'] = 'Med postobdelavo je prišlo do napake!';
$string['errorpreprocess'] = 'Med predobdelavo je prišlo do napake!';
$string['errorprocess'] = 'Med obdelavo je prišlo do napake!';
$string['errorprocessingresponses'] = 'Prišlo je do napake med obdelavo odgovorov ({$a}). Za vrnitev na prejšnjo stran kliknite na Nadaljuj in poskusite ponovno.';
$string['errorsavingcomment'] = 'Napaka pri shranjevanju komentarja na vprašanje {$a->name} v podatkovno bazo.';
$string['errorsavingflags'] = 'Napaka pri shranjevanju statusa zastavice.';
$string['errorupdatingattempt'] = 'Napaka pri poskusu posodobitve {$a->id} v podatkovni bazi.';
$string['eventquestioncategorycreated'] = 'Kategorija vprašanj je ustvarjena';
$string['eventquestioncategorydeleted'] = 'Kategorija vprašanj izbrisana';
$string['eventquestioncategorymoved'] = 'Kategorija vprašanj premaknjena';
$string['eventquestioncategoryupdated'] = 'Kategorija vprašanj posodobljena';
$string['eventquestioncategoryviewed'] = 'Kategorija vprašanj ogledana';
$string['eventquestioncreated'] = 'Vprašanje ustvarjeno';
$string['eventquestiondeleted'] = 'Vprašanje je izbrisano';
$string['eventquestionmoved'] = 'Vprašanje premaknjeno';
$string['eventquestionsexported'] = 'Vprašanja izvožena';
$string['eventquestionsimported'] = 'Vprašanja uvožena';
$string['eventquestionupdated'] = 'Vprašanje posodobljeno';
$string['eventquestionviewed'] = 'Vprašanje je ogledano';
$string['export'] = 'Izvozi';
$string['exportasxml'] = 'Izvozi kot Moodle XML';
$string['exportcategory'] = 'Izvozi kategorijo';
$string['exportcategory_help'] = 'Nastavitve določijo kategorijo, iz katere bodo vzeta vprašanja za izvoz.

Nekateri formati za uvoz (formata GIFT in XML) omogočajo možnost vključitve kategorije v zapisano datoteko, kar omogoča (po želji), da se kategorije poustvarijo pri uvozu. Če je to potrebno, morate odkljukati primerne kvadratke.';
$string['exporterror'] = 'Prišlo je do napak med izvažanjem!';
$string['exportfilename'] = 'vprašanja';
$string['exportnameformat'] = '%Y%m%d-%H%M';
$string['exportonequestion'] = 'Prenesi to vprašanje v Moodle XML formatu';
$string['exportquestions'] = 'Izvozi vprašanja v datoteko';
$string['exportquestions_help'] = 'Ta funkcija vam omogoča izvoz celotne kategorije vprašanj (in vseh njenih podkategorij) v datoteko z besedilom. Vedite, da se ob izvozu vprašanj nekatere informacije lahko izgubijo, odvisno od izbranih formatov datotek.';
$string['exportquestions_link'] = 'vprašanje/izvoz';
$string['feedback'] = 'Pripombe';
$string['filecantmovefrom'] = 'Datotek z vprašanji ni mogoče premakniti, ker nimate dovoljenja za odstranitev datotek, od koder želite premakniti vprašanja.';
$string['filecantmoveto'] = 'Datotek z vprašanji ni mogoče premakniti ali kopirati, ker nimate dovoljenja za dodajanje datotek, kamor želite premakniti vprašanja.';
$string['fileformat'] = 'Format datoteke';
$string['filesareacourse'] = 'mesto za datoteke predmeta';
$string['filesareasite'] = 'mesto za datoteke spletnega mesta';
$string['filestomove'] = 'Premakni/Kopiraj datoteke v {$a}?';
$string['fillincorrect'] = 'Vnesi pravilne odgovore';
$string['filterbytags'] = 'Filtriraj po oznakah ...';
$string['firsttry'] = 'Prvi poskus';
$string['flagged'] = 'Označeno z zastavico';
$string['flagthisquestion'] = 'Označi to vprašanje z zastavico';
$string['formquestionnotinids'] = 'Obrazec je vseboval vprašanje, ki ga ni v questionids';
$string['fractionsnomax'] = 'Eden izmed odgovorov bi moral imeti 100% rezultat, da se lahko pri tem vprašanju doseže vse točke.';
$string['generalfeedback'] = 'Splošni odziv';
$string['generalfeedback_help'] = 'Splošni odziv se udeležencu prikaže, ko zaključi z vprašanjem. Za razliko od specifičnega odziva, ki je odvisen od tipa vprašanja in odgovora udeleženca, je vsem udeležencem prikazan enak splošni odziv.

Splošni odziv lahko uporabite za to, da udeležencem podate podroben odgovor in morda tudi povezavo do dodatnega gradiva, ki ga lahko uporabijo, če niso razumeli vprašanja.';
$string['getcategoryfromfile'] = 'Odpri kategorijo iz datoteke';
$string['getcontextfromfile'] = 'Odpri kontekst iz datoteke';
$string['hintn'] = 'Namig {no}';
$string['hintnoptions'] = 'Možnosti namiga {no}';
$string['hinttext'] = 'Besedilo namiga';
$string['howquestionsbehave'] = 'Kako se vprašanja vedejo';
$string['howquestionsbehave_help'] = 'Udeležencem lahko omogočite raznovrstne interakcije z vprašanji v kvizu. Nastavite lahko, na primer, da udeleženci vnesejo odgovor na vsako vprašanje posebej in nato oddajo celoten kviz, preden dobijo oceno ali odziv. To bi bil način \'Zakasnjen odziv\'.

Lahko pa nastavite, da udeleženci med poskusom oddajo odgovor na vsako vprašanje posebej in dobijo takojšnji odziv. V primeru, da odgovor ni pravilen, lahko ponovno poskusijo za manj točk. To bi bil način \'Interaktivno z več poskusi\'.

To sta dva, običajno najbolj uporabljena načina interakcij.';
$string['howquestionsbehave_link'] = 'vprašanje/vedenje';
$string['idnumber'] = 'Številka ID';
$string['idnumber_help'] = 'Če uporabite ID številko, mora biti ta v vsaki kategoriji vprašanj drugačna. Tako lahko še na en način prepoznamo vprašanje. To je včasih koristno, po navadi pa lahko to pustimo prazno.';
$string['ignorebroken'] = 'Prezri prekinjene povezave';
$string['import'] = 'Uvozi';
$string['importcategory'] = 'Uvozi kategorijo';
$string['importcategory_help'] = 'Nastavitve določijo kategorijo, v katero bodo dodana uvožena vprašanja.

Nekateri formati za uvoz (formata GIFT in XML) omogočajo možnost določitve kategorije v datoteko za uvoz. Če želite vključiti te podatke in ne označene kategorije, morate odkljukati potrebne kvadratke. V primeru, da so v datoteki za uvoz določene kategorije, ki še ne obstajajo, bodo pri uvozu ustvarjene.';
$string['importerror'] = 'Prišlo je do napake med uvozom';
$string['importerrorquestion'] = 'Napaka pri uvažanju vprašanja';
$string['importfromcoursefiles'] = '... ali izberite datoteko predmeta za uvoz.';
$string['importfromupload'] = 'Izberite datoteko za nalaganje ...';
$string['importingquestions'] = 'Uvažanje {$a} vprašanj iz datoteke';
$string['importparseerror'] = 'Napaka(e) najdene pri razčlenjevanju uvožene datoteke. Uvoženih ni bilo nobenih vprašanj. Za uvoz katerihkoli dobrih vprašanj poskusite znova nastaviti \'Ustavi se na napaki\' na \'Ne\'';
$string['importquestions'] = 'Uvozi vprašanja iz datoteke';
$string['importquestions_help'] = 'Ta funkcija omogoča uvoz vprašanj različnih formatov preko besedilne datoteke. Datoteka mora uporabljati kodiranje UTF-8.';
$string['importquestions_link'] = 'vprašanje/uvoz';
$string['importwrongfiletype'] = 'Tip datoteke, ki ste ga označili ({$a->actualtype}) se ne ujema s pričakovanim tipom tega uvoznega formata ({$a->expectedtype}).';
$string['impossiblechar'] = 'Neizvedljiv znak {$a} je zaznan kot znak oklepaja';
$string['includesubcategories'] = 'Prikaži tudi vprašanja iz podkategorij';
$string['incorrect'] = 'Nepravilno';
$string['incorrectfeedback'] = 'Za vsak nepravilni odgovor';
$string['incorrectfeedbackdefault'] = 'Vaš odgovor je nepravilen.';
$string['information'] = 'Informacije';
$string['invalidanswer'] = 'Nepopoln odgovor';
$string['invalidarg'] = 'Ni veljavnih argumentov ali nepravilna konfiguracija strežnika';
$string['invalidcategoryidforparent'] = 'Neveljaven ID kategorije za nadrejeno!';
$string['invalidcategoryidtomove'] = 'Neveljaven ID kategorije za premik!';
$string['invalidconfirm'] = 'Potrditveni niz je nepravilen';
$string['invalidcontextinhasanyquestions'] = 'Neveljaven kontekst posredovan v question_context_has_any_questions.';
$string['invalidgrade'] = 'Ocene ({$a}) se ne ujemajo z možnostmi ocen - vprašanje je preskočeno.';
$string['invalidpenalty'] = 'Neveljaven odbitek';
$string['invalidwizardpage'] = 'Neveljavna ali nedoločena stran čarovnika!';
$string['lastmodifiedby'] = 'Zadnja sprememba od';
$string['lasttry'] = 'Zadnji poskus';
$string['linkedfiledoesntexist'] = 'Povezana datoteka {$a} ne obstaja';
$string['makechildof'] = 'Naredi podrejeno za \'{$a}\'';
$string['makecopy'] = 'Naredi kopijo';
$string['maketoplevelitem'] = 'Premakni v najvišjo raven';
$string['manualgradeinvalidformat'] = 'To ni pravilna številka.';
$string['manualgradeoutofrange'] = 'Ta ocena je izven veljavnega obsega.';
$string['manuallygraded'] = 'Ročno točkovano {$a->mark} s komentarjem: {$a->comment}';
$string['mark'] = 'Točka';
$string['markedoutof'] = 'Točk od';
$string['markedoutofmax'] = 'Točkovano od {$a}';
$string['markoutofmax'] = 'Točk {$a->mark} od {$a->max}';
$string['marks'] = 'Ocene';
$string['matchgrades'] = 'Uredi ocene, da se bodo ujemale';
$string['matchgrades_help'] = '<p>Uvožene ocene se morajo ujemati z enim izmed določenih seznamom veljavnih ocen - 100, 90, 80, 75, 70, 66.666, 60, 50, 40, 33.333, 30, 25, 20, 16.666, 14.2857, 12.5, 11.111, 10, 5, 0 (dovoljene so tudi negativne vrednosti). Sicer imate dve možnosti:

* Napaka, če ocene ni na seznamu - Če vprašanje vsebuje ocene, ki jih ni na seznamu, se prikaže napaka in to vprašanje ne bo uvoženo
* Najbližja ocena, če je ni na seznamu - Če je najdena ocena, katere vrednost se ne ujema z nobeno vrednostjo na seznamu, se ocena spremeni na najbližjo ujemajočo vrednost iz seznama';
$string['matchgradeserror'] = 'Napaka, če ocena ni navedena';
$string['matchgradesnearest'] = 'Najbližja ocena, če je ni na seznamu';
$string['missingcourseorcmid'] = 'Potrebno je podati courseid ali cmid za print_question.';
$string['missingcourseorcmidtolink'] = 'Potrebno je podati courseid ali cmid za get_question_edit_link.';
$string['missingimportantcode'] = 'Pri temu tipu vprašanja manjka pomembna koda: {$a}.';
$string['missingoption'] = 'Pri zaključnem vprašanju {$a} manjkajo možnosti izbire';
$string['modified'] = 'Nazadnje shranil/a';
$string['move'] = 'Premakni iz {$a} in spremeni povezave.';
$string['movecategory'] = 'Premakni kategorijo';
$string['movedquestionsandcategories'] = 'Vprašanja in kategorije vprašanj so bile premaknjene iz {$a->oldplace} v {$a->newplace}.';
$string['movelinksonly'] = 'Spremeni samo ciljno mesto povezav in ne premikaj ali kopiraj datotek.';
$string['moveq'] = 'Premakni vprašanja';
$string['moveqtoanothercontext'] = 'Premakni vprašanje v drug kontekst.';
$string['moveto'] = 'Premakni na';
$string['movingcategory'] = 'Premikanje kategorije';
$string['movingcategoryandfiles'] = 'Ste prepričani, da želite premakniti kategorijo {$a->name} in vse podrejene kategorije v kontekst za "{$a->contextto}"?<br /> Zaznanih je bilo {$a->urlcount} datotek, na katere so povezana vprašanja v {$a->fromareaname}. Jih želite kopirati ali premakniti v {$a->toareaname}?';
$string['movingcategorynofiles'] = 'Ste prepričani, da želite premakniti kategorijo "{$a->name}" in vse podrejene kategorije v kontekst za "{$a->contextto}"?';
$string['movingquestions'] = 'Premikanje vprašanj in datotek';
$string['movingquestionsandfiles'] = 'Ste prepričani, da želite premakniti vprašanja {$a->questions} v kontekst za <strong>"{$a->tocontext}"</strong>?<br /> Zaznanih je bilo <strong>{$a->urlcount} datotek</strong>, na katere so povezana ta vprašanja v {$a->fromareaname}. Jih želite kopirati ali premakniti v {$a->toareaname}?';
$string['movingquestionsnofiles'] = 'Ste prepričani, da želite premakniti vprašanja {$a->questions} v kontekst za <strong>"{$a->tocontext}"</strong>?<br /> <strong>Ni datotek</strong>, ki bi imele povezavo iz teh vprašanj v {$a->fromareaname}.';
$string['needtochoosecat'] = 'Za premik tega vprašanja izberite kategorijo ali kliknite Prekliči.';
$string['nocate'] = 'Kategorija {$a} ne obstaja!';
$string['nopermissionadd'] = 'Nimate dovoljenja za dodajanje vprašanj na tem mestu.';
$string['noprobs'] = 'V podatkovni bazi vprašanj ni najdenih težav.';
$string['noquestions'] = 'Ni mogoče najti vprašanj za izvoz. Izbrati morate kategorijo za izvoz, ki vsebuje vprašanja.';
$string['noquestionsinfile'] = 'V uvozni datoteki ni vprašanj';
$string['noresponse'] = '[Ni odgovora]';
$string['notagfiltersapplied'] = 'Ni nastavljenih filtrov označb';
$string['notanswered'] = 'Neodgovorjeno';
$string['notchanged'] = 'Nespremenjeno od zadnjega poskusa';
$string['notenoughanswers'] = 'Ta tip vprašanja zahteva vsaj {$a} odgovorov';
$string['notenoughdatatoeditaquestion'] = 'Določen ni bil niti ID vprašanja, niti ID kategorije ali tip vprašanja.';
$string['notenoughdatatomovequestions'] = 'Podati morate ID-je vprašanj za vprašanja, ki jih želite premakniti.';
$string['notgraded'] = 'Neocenjeno';
$string['notshown'] = 'Neprikazano';
$string['notyetanswered'] = 'Ni še odgovora';
$string['notyourpreview'] = 'Ta predogled vam ne pripada';
$string['novirtualquestiontype'] = 'Ni navideznega tipa vprašanj za tip vprašanja {$a}';
$string['numqas'] = 'Št. poskusov odgovora na vprašanje';
$string['numquestions'] = 'Št. vprašanj';
$string['numquestionsandhidden'] = '{$a->numquestions} (+{$a->numhidden} skrito +{$a->numdraft} osnutek)';
$string['options'] = 'Možnosti';
$string['page-question-category'] = 'Stran kategorije vprašanja';
$string['page-question-edit'] = 'Stran za urejanje vprašanj';
$string['page-question-export'] = 'Stran izvoza vprašanj';
$string['page-question-import'] = 'Stran uvoza vprašanj';
$string['page-question-x'] = 'Katera koli stran vprašanj';
$string['parent'] = 'Nadrejeni';
$string['parentcategory'] = 'Nadrejena kategorija';
$string['parentcategory_help'] = 'V kategorijo za starše bo uvrščen element, ki ga urejate. \'Vrh\' pomeni, da kategorija ni del nobene druge kategorije. Konteksti v kategoriji so izpisani s krepko pisavo. Vsak kontekst mora vsebovati vsaj eno kategorijo.';
$string['parentcategory_link'] = 'vprašanje/kategorija';
$string['parenthesisinproperclose'] = 'Oklepaj pred ** je nepravilno zaprt v {$a}**';
$string['parenthesisinproperstart'] = 'Oklepaj pred ** je nepravilno odprt v {$a}**';
$string['parsingquestions'] = 'Razčlenjevanje vprašanj iz uvozne datoteke.';
$string['partiallycorrect'] = 'Delno pravilno';
$string['partiallycorrectfeedback'] = 'Za vsak delno pravilen odgovor';
$string['partiallycorrectfeedbackdefault'] = 'Vaš odgovor je delno pravilen.';
$string['penaltyfactor'] = 'Količnik odbitka';
$string['penaltyfactor_help'] = 'Ta nastavitev določa, kolikšen delež doseženega rezultata se odšteje za vsak napačen odgovor. To velja samo v primeru, če kviz poteka v prilagodljivem načinu.

Količnik odbitka mora biti število med 0 in 1. Količnik odbitka 1 pomeni, da mora udeleženec pravilno odgovoriti na vprašanje v prvem poskusu, če želi prejeti kreditne točke. Količnik odbitka 0 pomeni, da lahko udeleženec poskuša poljubnokrat in še vedno prejme vse točke.';
$string['penaltyforeachincorrecttry'] = 'Odbitek za vsak nepravilni poskus';
$string['penaltyforeachincorrecttry_help'] = 'Če zaganjate vaša vprašanja z uporabo \'Interaktivnevnega z več poskusi\' ali \'Prilagoditvenega načina\' vedenja, da bi imel uporabnik imel na voljo več poskusov da pravilno odgovori na vprašanje, ta možnost kontrolira koliko so kaznovani za vsak nepravilni poskus.

Kazen je delež celotne ocene vprašanja, tako da če je vprašanje vredno tri točke in je kazen 0.3333333, dobi udeleženec oceno 3, če odgovori na vprašanje pravilno v prvem poskusu. Če pravilno odgovori na vprašanje v drugem poskusu dobi 2 in 1, če pravilno odgovori v tretjem poskusu. Pri nekaterih večdelnih vprašanjih se ta ocenjevalna logika uporablja pri vsakem delu vprašanja. Podrobnosti so odvisne od tipa vprašanja in so lahko zapletene, toda princip je kar se da pošteno študente nagraditi za znanje, ki so ga pokazali.';
$string['permissionedit'] = 'Uredi to vprašanje';
$string['permissionmove'] = 'Premaknite to vprašanje';
$string['permissionsaveasnew'] = 'Shrani kot novo vprašanje';
$string['permissionto'] = 'Dovoljenje imate za:';
$string['previewquestion'] = 'Predogled vprašanja: {$a}';
$string['privacy:metadata:database:question'] = 'Podrobnosti o določenem vprašanju.';
$string['privacy:metadata:database:question:createdby'] = 'Oseba, ki je ustvarila to vprašanje.';
$string['privacy:metadata:database:question:generalfeedback'] = 'Splošni odziv za to vprašanje.';
$string['privacy:metadata:database:question:modifiedby'] = 'Oseba, ki je zadnja posodobila vprašanje.';
$string['privacy:metadata:database:question:name'] = 'Ime vprašanja.';
$string['privacy:metadata:database:question:questiontext'] = 'Besedilo vprašanja.';
$string['privacy:metadata:database:question:timecreated'] = 'Datum in čas nastanka vprašanja.';
$string['privacy:metadata:database:question:timemodified'] = 'Datum in čas posodobitve vprašanja.';
$string['privacy:metadata:database:question_attempt_step_data'] = 'Koraki za poskuse vprašanj imajo lahko dodatne podatke, ki so značilne za ta korak. Podatki so shranjeni v tabeli step_data.';
$string['privacy:metadata:database:question_attempt_step_data:name'] = 'Ime podatka.';
$string['privacy:metadata:database:question_attempt_step_data:value'] = 'Vrednost podatka.';
$string['privacy:metadata:database:question_attempt_steps'] = 'Vsak poskus vprašanja ima določeno številko korakov, da pokaže različne faze od začetka do konca do označevanja. Ta tabela shranjuje informacije za vsakega od teh korakov.';
$string['privacy:metadata:database:question_attempt_steps:fraction'] = 'Ocena, ki je bila dodeljena za poskus odgovora na to vprašanje, je do 1.';
$string['privacy:metadata:database:question_attempt_steps:state'] = 'Stanje tega koraka poskusa vprašanja ob koncu prehodnega koraka.';
$string['privacy:metadata:database:question_attempt_steps:timecreated'] = 'Datum in čas začetka tega prehodnega koraka.';
$string['privacy:metadata:database:question_attempt_steps:userid'] = 'ID uporabnika, ki je opravil ta prehodni korak.';
$string['privacy:metadata:database:question_attempts'] = 'Informacija o poskusu pri določenem vprašanju.';
$string['privacy:metadata:database:question_attempts:flagged'] = 'Oznaka, da je uporabnik označil to vprašanje med poskusom.';
$string['privacy:metadata:database:question_attempts:responsesummary'] = 'Povzetek odgovora na vprašanje.';
$string['privacy:metadata:database:question_attempts:timemodified'] = 'Čas, ko je bil poskus vprašanja posodobljen.';
$string['privacy:metadata:link:qbehaviour'] = 'Podsistem vprašanj uporablja vtičnik Vedenje vprašanj.';
$string['privacy:metadata:link:qformat'] = 'Podsistem vprašanj uporablja vtičnik Format vprašanj za uvažanje in izvažanje vprašanj različnih formatov.';
$string['privacy:metadata:link:qtype'] = 'Podsistem vprašanj vzajemno deluje z vtičnikom Tip vprašanj, ki vsebuje različne tipe vprašanj.';
$string['published'] = 'v skupni rabi';
$string['qtypeveryshort'] = 'T';
$string['questionaffected'] = '<a href="{$a->qurl}">Vprašanje "{$a->name}" ({$a->qtype})</a> je v tej kategoriji vprašanj, vendar je prav tako v uporabi v <a href="{$a->qurl}">kvizu "{$a->quizname}"</a> v drugem predmetu "{$a->coursename}".';
$string['questionbank'] = 'Zbirka vprašanj';
$string['questionbehaviouradminsetting'] = 'Nastavitve vedenja vprašanja';
$string['questionbehavioursdisabled'] = 'Vedenja vprašanj, ki bodo onemogočena';
$string['questionbehavioursdisabledexplained'] = 'Vnesite z vejico ločen seznam vedenj, ki jih ne želite prikazati v spustnem meniju.';
$string['questionbehavioursorder'] = 'Vrstni red vedenj vprašanj';
$string['questionbehavioursorderexplained'] = 'Vnesite z vejico ločen seznam vedenj v takem vrstnem redu, kot želite, da so prikazana v spustnem meniju.';
$string['questioncategories'] = 'Kategorije vprašanj';
$string['questioncategory'] = 'Kategorija vprašanj';
$string['questioncatsfor'] = 'Kategorije vprašanj za \'{$a}\'';
$string['questiondoesnotexist'] = 'Vprašanje ne obstaja';
$string['questionformtagheader'] = '{$a} Oznake';
$string['questionidmismatch'] = 'ID-ji vprašanj se ne ujemajo';
$string['questionname'] = 'Ime vprašanja';
$string['questionnamecopy'] = '{$a} (kopija)';
$string['questionno'] = 'Vprašanje {$a}';
$string['questionpreviewdefaults'] = 'Privzete nastavitve za predogled vprašanj';
$string['questionpreviewdefaults_desc'] = 'Privzete nastavitve se uporabijo za uporabnikov prvi predlogled vprašanja iz zbirke vprašanj. Ko si uporabnik ogleda vprašanje, se njegove osebne nastavitve shranijo kot uporabniške nastavitve.';
$string['questions'] = 'Vprašanja';
$string['questionsaveerror'] = 'Prišlo je do napak med shranjevanjem vprašanja - ({$a})';
$string['questionsinuse'] = '(* Vprašanja, označena z zvezdico, ni mogoče izbrisati, ker so že v uporabi. Namesto tega bodo v zbirki vprašanj skrita, razen če možnost \'Prikaži skrita vprašanja\' nastavite na \'Da\'.)';
$string['questionsmovedto'] = 'Vprašanja, ki so še v uporabi, so premaknjena v "{$a}" v nadrejeni kategoriji predmeta.';
$string['questionsrescuedfrom'] = 'Vprašanja so shranjena iz konteksta {$a}.';
$string['questionsrescuedfrominfo'] = 'Ta vprašanja (nekatera so lahko skrita) so bila shranjena ob izbrisu konteksta {$a}, ker jih nekateri kvizi ali druge dejavnosti še uporabljajo.';
$string['questiontags'] = 'Oznaka vprašanja';
$string['questiontext'] = 'Besedilo vprašanja';
$string['questiontype'] = 'Tip vprašanja';
$string['questionuse'] = 'Pri tej dejavnosti uporabi vprašanje';
$string['questionvariant'] = 'Različica vprašanja';
$string['questionx'] = 'Vprašanje {$a}';
$string['requiresgrading'] = 'Zahteva ocenjevanje';
$string['responsehistory'] = 'Zgodovina odgovorov';
$string['restart'] = 'Začni znova';
$string['restartwiththeseoptions'] = 'Shrani možnosti predogleda in začni znova';
$string['restoremultipletopcats'] = 'Datoteka varnostne kopije vsebuje več kot eno kategorijo najvišjega nivoja vprašanj za kontekst {$a}.';
$string['reviewresponse'] = 'Preglej odgovor';
$string['rightanswer'] = 'Pravilni odgovor';
$string['rightanswer_help'] = 'Samodejno ustvarjen povzetek pravilnega odgovora. Ta je lahko pomanjkljiv, zato morda raje pojasnite pravilno rešitev v splošnem odzivu na vprašanje in to možnost izključite.';
$string['save'] = 'Shrani';
$string['savechangesandcontinueediting'] = 'Shrani spremembe in nadaljuj z urejanjem';
$string['saved'] = 'Shranjeno: {$a}';
$string['saveflags'] = 'Shrani stanje zastavic';
$string['selectacategory'] = 'Izberite kategorijo:';
$string['selectaqtypefordescription'] = 'Izberite tip vprašanja za ogled opisa.';
$string['selectcategoryabove'] = 'Izberite kategorijo zgoraj';
$string['selectquestionsforbulk'] = 'Izberite vprašanja za dejanja na množici udeležencev';
$string['settingsformultipletries'] = 'Večkratni poskusi';
$string['shareincontext'] = 'Daj v skupno rabo v kontekstu za {$a}';
$string['showhidden'] = 'Prikaži skrita vprašanja';
$string['showmarkandmax'] = 'Prikaži točke in število vseh možnih točk';
$string['showmaxmarkonly'] = 'Prikaži samo število vseh možnih točk';
$string['shown'] = 'Prikazano';
$string['shownumpartscorrect'] = 'Prikaži število pravilnih odgovorov';
$string['shownumpartscorrectwhenfinished'] = 'Prikaži število pravilnih odgovorov po koncu vprašanja';
$string['showquestiontext'] = 'Prikaži besedilo vprašanja na seznamu vprašanj';
$string['specificfeedback'] = 'Specifičen odziv';
$string['specificfeedback_help'] = 'Odziv, ki je odvisen od odgovora udeleženca.';
$string['started'] = 'Začeto';
$string['state'] = 'Stanje';
$string['step'] = 'Korak';
$string['steps'] = 'Koraki';
$string['stoponerror'] = 'Ustavi se ob napaki';
$string['stoponerror_help'] = 'Ta nastavitev določa, ali se proces uvoza ustavi, ko se pojavi napaka, s čimer se nobeno vprašanje ne uvozi, ali pa se prezrejo vprašanja, ki vsebujejo napake, in se veljavna vprašanja uvozijo.';
$string['submissionoutofsequence'] = 'Dostop izven sekvence. Ne klikajte na gumb za nazaj, ko odgovarjate na vprašanja kviza.';
$string['submissionoutofsequencefriendlymessage'] = 'Vnesli ste podatke izven normalne sekvence. To se lahko zgodi pri uporabi brskalnikovega gumba Nazaj ali Naprej. Gumbov ne uporabljajte med testom. To se lahko zgodi tudi, če kliknete na nekaj, medtem ko se stran nalaga. Za nadaljevanje kliknite <strong>Nadaljuj</strong>.';
$string['submit'] = 'Oddaj';
$string['submitandfinish'] = 'Oddaj in končaj';
$string['submitted'] = 'Oddaj: {$a}';
$string['tagarea_question'] = 'Vprašanja';
$string['technicalinfo'] = 'Tehnične informacije';
$string['technicalinfo_help'] = 'Te tehnične informacije so najbrž koristne le za razvijalce, ki se ukvarjajo z novimi tipi vprašanj. Lahko pomaga tudi pri reševanju težav z vprašanji.';
$string['technicalinfomaxfraction'] = 'Največji ulomek: {$a}';
$string['technicalinfominfraction'] = 'Najmanjši ulomek: {$a}';
$string['technicalinfoquestionsummary'] = 'Povzetek vprašanja: {$a}';
$string['technicalinforesponsesummary'] = 'Povzetek odgovorov: {$a}';
$string['technicalinforightsummary'] = 'Povzetek pravilnega odgovora: {$a}';
$string['technicalinfostate'] = 'Stanje vprašanja: {$a}';
$string['technicalinfovariant'] = 'Različica vprašanja: {$a}';
$string['tofilecategory'] = 'Zapiši kategorijo v datoteko';
$string['tofilecontext'] = 'Zapiši kontekst v datoteko';
$string['topfor'] = 'Vrh za {$a}';
$string['uninstallbehaviour'] = 'Odstrani to vedenje vprašanja.';
$string['uninstallqtype'] = 'Odstrani ta tip vprašanja.';
$string['unknown'] = 'Neznano';
$string['unknownbehaviour'] = 'Neznano vedenje: {$a}.';
$string['unknownorunhandledtype'] = 'Neznan ali neobravnavan tip vprašanja: {$a}';
$string['unknownquestion'] = 'Neznano vprašanje: {$a}.';
$string['unknownquestioncatregory'] = 'Neznana kategorija vprašanja: {$a}.';
$string['unknownquestiontype'] = 'Neznan tip vprašanja: {$a}.';
$string['unknowntolerance'] = 'Neznan tip odstopanja {$a}';
$string['unpublished'] = 'ni v skupni rabi';
$string['unusedcategorydeleted'] = 'Ta kategorija je bila izbrisana, ker po brisanju predmeta njena vprašanja niso bila več uporabljana.';
$string['updatedisplayoptions'] = 'Posodobi možnosti prikaza';
$string['upgradeproblemcategoryloop'] = 'Zaznana je težava pri posodabljanju kategorij vprašanj. V drevesu kategorije obstaja zanka. ID-ji zadevnih kategorij so {$a}.';
$string['upgradeproblemcouldnotupdatecategory'] = 'Ni mogoče posodobiti kategorije vprašanj {$a->name} ({$a->id}).';
$string['upgradeproblemunknowncategory'] = 'Zaznana je težava pri nadgradnji kategorij vprašanj. Kategorija {$a->id} se nanaša na nadrejeno kategorijo {$a->parent}, ki ne obstaja. Nadrejena kategorija je spremenjena za odpravo te težave.';
$string['whethercorrect'] = 'Če je pravilno';
$string['whethercorrect_help'] = 'To vključuje besedilni opis Pravilno, Delno pravilno ali Napačno kot tudi barvno označevanje besedila z enakim sporočilom.';
$string['whichtries'] = 'Kateri poskusi';
$string['withselected'] = 'Z označenimi';
$string['wrongprefix'] = 'Napačno oblikovan naziv {$a}';
$string['xoutofmax'] = '{$a->mark} od {$a->max}';
$string['yougotnright'] = 'Pravilno ste izbrali {$a->num}.';
$string['youmustselectaqtype'] = 'Izberite tip vprašanja.';
$string['yourfileshoulddownload'] = 'Vaša izvozna datoteka se bo začela kmalu prenašati. Če se to ne zgodi, <a href="{$a}">kliknite tukaj</a>.';
