<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'tool_dynamic_cohorts', language 'pt_br', version '4.5'.
 *
 * @package     tool_dynamic_cohorts
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['add_rule'] = 'Adicionar nova regra';
$string['addcondition'] = 'Adicionar uma condição';
$string['addrule'] = 'Adicionar nova regra';
$string['after'] = 'Depois';
$string['any'] = 'Qualquer';
$string['before'] = 'Antes';
$string['broken'] = 'Quebrado';
$string['brokenruleswarning'] = 'Existem algumas regras quebradas que exigem sua atenção. <br /> Para corrigir uma regra quebrada, você deve remover todas as condições quebradas. <br />Às vezes, uma regra quebra quando a correspondência de usuários falha no SQL. Nesse caso, todas as condições estão corretas, mas a regra é marcada como quebrada. Você deve verificar os logs do Moodle para o evento "Falha na correspondência de usuários" e erros de SQL relacionados. <br />Observe que, em qualquer caso, você precisa salvar a regra novamente para marcá-la como intacta.';
$string['bulkprocessing'] = 'Processamento em lote';
$string['bulkprocessing_help'] = 'Se esta opção estiver habilitada, os usuários serão adicionados e removidos do coorte em massa. Isso melhorará significativamente o desempenho do processamento. No entanto, usar esta opção suprimirá eventos de acionamento quando usuários forem adicionados ou removidos do coorte.';
$string['cachedef_conditionrecords'] = 'Condições para uma regra';
$string['cachedef_matchingusers'] = 'Usuários correspondentes a uma regra';
$string['cachedef_rulesconditions'] = 'Regras com uma condição específica';
$string['cannotenablebrokenrule'] = 'Uma regra inválida não pode ser ativada';
$string['cf_include_missing_data'] = 'Incluir coortes com dados ausentes.';
$string['cf_include_missing_data_help'] = 'Os coortes podem ainda não ter um conjunto de dados de campo personalizado. Esta opção inclui esses coortes no resultado final.';
$string['cf_includingmissingdatadesc'] = '(incluindo coortes com dados ausentes)';
$string['cohort'] = 'Coorte';
$string['cohortid'] = 'Coorte';
$string['cohortid_help'] = 'Um coorte para gerenciar como parte desta regra. Apenas coortes que não são gerenciadas por outros plugins são exibidas nesta lista.';
$string['cohortswith'] = 'Coorte(s) com o campo';
$string['completed:add'] = 'A regra foi adicionada';
$string['completed:delete'] = 'A regra foi excluída';
$string['completed:disable'] = 'A regra foi desabilitada';
$string['completed:enable'] = 'A regra foi habilitada';
$string['completed:update'] = 'A regra foi atualizada';
$string['completiondate'] = 'Data de conclusão';
$string['completionisdisabled'] = 'Conclusão está desativada para o curso configurado';
$string['condition'] = 'Condição';
$string['condition:auth_method'] = 'Método de autenticação';
$string['condition:cohort_field'] = 'Campo da coorte';
$string['condition:cohort_field_description'] = 'Usuários que {$a->operator} coortes com o campo \'{$a->field}\' {$a->fieldoperator} {$a->fieldvalue}';
$string['condition:cohort_membership'] = 'Associação à coorte';
$string['condition:cohort_membership_broken_description'] = 'Condição inválida. Usando a mesma coorte que a regra informada está configurada para gerenciar.';
$string['condition:cohort_membership_description'] = 'Usuários que {$a->operator} {$a->cohorts}';
$string['condition:course_completed'] = 'Curso concluído';
$string['condition:course_completed_description'] = 'Usuários que concluíram o curso “{$a->course}” {$a->operator} {$a->timecompleted}';
$string['condition:course_not_completed'] = 'Curso não concluído';
$string['condition:course_not_completed_description'] = 'Usuários que não concluíram o curso “{$a->course}”';
$string['condition:profile_field_description'] = 'Usuários com {$a->field} {$a->fieldoperator} {$a->fieldvalue}';
$string['condition:user_created'] = 'Data de criação do usuário';
$string['condition:user_custom_profile'] = 'Campo de perfil personalizado do usuário';
$string['condition:user_enrolment'] = 'Inscrição do usuário';
$string['condition:user_enrolment_description'] = 'Usuários que {$a->operator} no curso “{$a->coursename}” (id {$a->courseid}) com o papel “{$a->role}” usando o método de inscrição “{$a->enrolmethod}”';
$string['condition:user_last_login'] = 'Último acesso do usuário';
$string['condition:user_profile'] = 'Campo de perfil padrão do usuário';
$string['condition:user_profile_interests'] = 'Interesses do usuário';
$string['condition:user_profile_interests_description'] = 'Usuários com interesses contendo as seguintes tags {$a}';
$string['condition:user_profile_interests_description_not'] = 'Usuários com interesses que não contenham as seguintes tags {$a}';
$string['condition:user_role'] = 'Papel do usuário';
$string['condition:user_role_description_category'] = 'Usuários que {$a->operator} “{$a->role}” na categoria {$a->categoryname} (id {$a->categoryid})';
$string['condition:user_role_description_course'] = 'Usuários que {$a->operator} “{$a->role}” no curso {$a->coursename} (id {$a->courseid})';
$string['condition:user_role_description_system'] = 'Usuários que {$a->operator} “{$a->role}” no contexto do sistema';
$string['conditionchnagesnotapplied'] = 'As alterações de condição não são aplicadas até que você salve o formulário da regra';
$string['conditionformtitle'] = 'Condição da regra';
$string['conditions'] = 'Condições';
$string['conditionsformtitle'] = 'Condições da regra';
$string['conditionstext'] = '{$a->conditions} (operador lógico {$a->operator})';
$string['delete_confirm'] = 'Tem certeza de que deseja excluir a regra?';
$string['delete_confirm_condition'] = 'Tem certeza de que deseja excluir esta condição?';
$string['delete_rule'] = 'Excluir regra';
$string['description'] = 'Descrição';
$string['description_help'] = 'Uma breve descrição desta regra';
$string['disable_confirm'] = 'Tem certeza de que deseja desabilitar a regra?';
$string['disabled'] = 'Desabilitado';
$string['donothaverole'] = 'não tem papel';
$string['dynamic_cohorts:manage'] = 'Gerenciar regras';
$string['edit_rule'] = 'Editar regra';
$string['enable_confirm'] = 'Tem certeza de que deseja habilitar a regra?';
$string['enabled'] = 'Habilitado';
$string['enrolled'] = 'Inscrito';
$string['enrolmethod'] = 'Método de inscrição';
$string['event:conditioncreated'] = 'Condição criada';
$string['event:conditiondeleted'] = 'Condição excluída';
$string['event:conditionupdated'] = 'Condição atualizada';
$string['event:matchingfailed'] = 'Falha na correspondência de usuários';
$string['event:rulecreated'] = 'Regra criada';
$string['event:ruledeleted'] = 'Regra excluída';
$string['event:ruleupdated'] = 'Regra atualizada';
$string['ever'] = 'Sempre';
$string['everloggedin'] = 'Usuários que acessaram pelo menos uma vez';
$string['haverole'] = 'tem papel';
$string['include_missing_data'] = 'Incluir usuários com dados ausentes.';
$string['include_missing_data_help'] = 'Alguns usuários podem ainda não ter um dado definido no campo personalizado. Esta opção inclui esses usuários no resultado final.';
$string['includechildren'] = 'incluindo descendentes (categorias e cursos)';
$string['includeusersmissingdata'] = 'incluir usuários com dados ausentes';
$string['includingmissingdatadesc'] = '(incluindo usuários com dados ausentes)';
$string['inlast'] = 'No último';
$string['inlastloggedin'] = 'Usuários que acessaram nos últimos {$a}';
$string['inthefuture'] = 'está no futuro';
$string['inthepast'] = 'está no passado';
$string['invalidfieldvalue'] = 'Valor de campo inválido';
$string['isafter'] = 'é após';
$string['isbefore'] = 'é antes de';
$string['ismemberof'] = 'são membros de';
$string['isnotempty'] = 'não está vazio';
$string['isnotmemberof'] = 'não são membros de';
$string['loggedintime'] = 'Usuários que acessaram {$a->operator} {$a->time}';
$string['logical_operator'] = 'Operador lógico';
$string['logical_operator_help'] = 'Um operador lógico a ser aplicado às condições desta regra. O operador "E" significa que um usuário precisa atender a todas as condições para ser adicionado a um grupo. "OU" significa que um usuário precisa atender a qualquer uma das condições para ser adicionado a um coorte.';
$string['managecohorts'] = 'Gerenciar coortes';
$string['managerules'] = 'Gerenciar regras';
$string['matchingusers'] = 'Usuários correspondentes';
$string['missingcourse'] = 'Curso ausente';
$string['missingcoursecat'] = 'Categoria de curso ausente';
$string['missingenrolmentmethod'] = 'Método de inscrição ausente {$a}';
$string['missingrole'] = 'Papel ausente';
$string['name'] = 'Nome da regra';
$string['name_help'] = 'Um nome legível para esta regra.';
$string['never'] = 'Nunca';
$string['neverloggedin'] = 'Usuários que nunca acessaram';
$string['notenrolled'] = 'Não inscrito';
$string['operator'] = 'Operador';
$string['or'] = 'OU';
$string['pleaseselectcohort'] = 'Selecione uma coorte';
$string['pleaseselectfield'] = 'Selecione um campo';
$string['pluginname'] = 'Coortes dinâmicas';
$string['privacy:metadata:tool_dynamic_cohorts'] = 'Informações sobre regras criadas ou atualizadas por um usuário';
$string['privacy:metadata:tool_dynamic_cohorts:name'] = 'Nome da regra';
$string['privacy:metadata:tool_dynamic_cohorts:usermodified'] = 'O ID do usuário que criou ou atualizou uma regra';
$string['privacy:metadata:tool_dynamic_cohorts_c'] = 'Informações sobre condições criadas ou atualizadas por um usuário';
$string['privacy:metadata:tool_dynamic_cohorts_c:ruleid'] = 'ID da regra';
$string['privacy:metadata:tool_dynamic_cohorts_c:usermodified'] = 'O ID do usuário que criou ou atualizou uma condição';
$string['processrulestask'] = 'Processar regras de coortes dinâmicas';
$string['profilefield'] = 'Campo de perfil';
$string['realtime'] = 'Processamento em tempo real';
$string['realtime_help'] = 'Se ativado, a regra será processada de forma síncrona como parte do evento (se as condições suportarem disparo no evento). Use com cautela ao ativar, pois o processamento de regras de longa duração bloqueará a interface do usuário.';
$string['realtimedisabledglobally'] = 'Processamento em tempo real desativado globalmente';
$string['rule_entity'] = 'Regra de coorte dinâmica';
$string['rule_entity.bulkprocessing'] = 'Processamento em lote';
$string['rule_entity.description'] = 'Descrição';
$string['rule_entity.id'] = 'ID';
$string['rule_entity.name'] = 'Nome';
$string['rule_entity.realtime'] = 'Processamento em tempo real';
$string['rule_entity.status'] = 'Status';
$string['ruledeleted'] = 'A regra foi excluída';
$string['ruledisabled'] = 'A regra foi desabilitada';
$string['ruledisabledpleasereview'] = 'Regras recém-criadas ou atualizadas ficam desativadas por padrão. Revise a regra abaixo e ative-a quando estiver pronta.';
$string['ruleenabled'] = 'A regra foi ativada';
$string['settings:realtime'] = 'Processamento em tempo real';
$string['settings:realtime_desc'] = 'Quando ativado, regras com condições que suportam disparo no evento serão processadas de forma síncrona como parte do evento. Use com cautela ao ativar, pois o processamento de regras de longa duração bloqueará a interface do usuário.';
$string['settings:releasemembers'] = 'Liberar membros';
$string['settings:releasemembers_desc'] = 'Se ativado, todos os membros serão removidos de uma coorte quando ela deixar de ser gerenciada pelo plugin (por exemplo, uma regra é excluída ou a coorte de uma regra é alterada).  Observe: nenhum evento cohort_member_removed será disparado quando os membros forem liberados de uma coorte. Caso contrário, a regra será processada via cron.';
$string['usercreated'] = 'Usuário foi criado';
$string['usercreatedin'] = 'Usuários que foram criados nos últimos {$a}';
$string['usercreatedtime'] = 'Usuários que foram criados {$a->operator} {$a->time}';
$string['userlastlogin'] = 'Último acesso do usuário';
$string['usersforrule'] = 'Usuários que correspondem à regra “{$a->rule}” para a coorte “{$a->cohort}”';
