<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'vpl', language 'sr_cr', version '4.5'.
 *
 * @package     vpl
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['VPL_COMPILATIONFAILED'] = 'Компилација или припрема извршавања није успела';
$string['about'] = 'О додатку';
$string['acceptcertificates'] = 'Прихвати самопотписане сертификате';
$string['acceptcertificates_description'] = 'Ако извршни сервери не користе самопотписане сертификате искључите ову опцију';
$string['acceptcertificatesnote'] = '<p>Користите шифровану конекцију.<p/>
<p>Да бисте користили шифровану конекцију са извршним серверима неопходно је да прихватите њене сертификате.</p>
<p>Ако имате проблема са овим процесом, можете покушати да користите http (нешифровану) конекцију или други читач.</p>
<p>Молимо кликните на следеће линкове (сервер #) и прихватите понуђене сертификате.</p>';
$string['addfile'] = 'Додај датотеку';
$string['advanced'] = 'Напредни';
$string['allfiles'] = 'Све датотеке';
$string['allsubmissions'] = 'Сви предати радови';
$string['always_use_ws'] = 'Увек користите нешифровани (ws) websocket протокол';
$string['always_use_wss'] = 'Увек користите шифровани (wss) websocket протокол';
$string['anyfile'] = 'Било која датотека';
$string['attemptnumber'] = 'Покушај број {$a}';
$string['automaticevaluation'] = 'Аутоматска евалуација';
$string['automaticgrading'] = 'Аутоматско оцењивање';
$string['averageperiods'] = 'Просечни периоди {$a}';
$string['averagetime'] = 'Просечно време {$a}';
$string['basedon'] = 'Базирано на';
$string['basic'] = 'Основни';
$string['browserupdate'] = 'Молимо ажурирајте свој читач на последњу верзију<br />или користите други који подржава Websocket.';
$string['calculate'] = 'Израчунај';
$string['changesNotSaved'] = 'Измене нису сачуване';
$string['check_jail_servers'] = 'Провери извршне сервере';
$string['check_jail_servers_help'] = '<p>Ова страница проверава и приказује статус извршних сервера коришћених за ову активност.</p>';
$string['closed'] = 'Затворено';
$string['comments'] = 'Коментари';
$string['compilation'] = 'Компајлирање';
$string['connected'] = 'повезан';
$string['connecting'] = 'повезује се';
$string['connection_closed'] = 'конекција је затворена';
$string['connection_fail'] = 'повезивање није успело';
$string['console'] = 'Конзола';
$string['copy'] = 'Копирај';
$string['create_new_file'] = 'Креирај нову датотеку';
$string['currentstatus'] = 'Тренутни статус';
$string['cut'] = 'Исеци';
$string['datesubmitted'] = 'Датум кад је предато';
$string['debug'] = 'Исправи грешке';
$string['debugging'] = 'Исправљање грешака';
$string['defaultexefilesize'] = 'Максимална подразумевана величина извршне датотеке';
$string['defaultexememory'] = 'Максимална подразумевана искоришћена меморија';
$string['defaultexeprocesses'] = 'Максимални подразумевани број процеса';
$string['defaultexetime'] = 'Максимално подразумевано време извршавања';
$string['defaultfilesize'] = 'Подразумевана максимална величина учитаних датотека';
$string['defaultresourcelimits'] = 'Подразумевана ограничења ресурса за извршавање';
$string['delete'] = 'Обриши';
$string['delete_file_fq'] = 'Брисање датотеке \'{$a}\'?';
$string['delete_file_q'] = 'Брисање датотеке?';
$string['deleteallsubmissions'] = 'Обриши све предате радове';
$string['depends_on_https'] = 'Користи ws или wss у зависности од тога да ли се користи http или https';
$string['description'] = 'Опис';
$string['diff'] = 'разлике';
$string['discard_submission_period'] = 'Одбаци период предаје';
$string['discard_submission_period_description'] = 'За сваког полазника и задатак систем покушава да одбаци предате радове. Систем чува последњи предат рад и бар један рад за сваки период';
$string['download'] = 'Преузми';
$string['downloadallsubmissions'] = 'Преузми све предате радове';
$string['duedate'] = 'Рок за израду';
$string['edit'] = 'Уреди';
$string['editing'] = 'Уређивање';
$string['evaluate'] = 'Евалуирај';
$string['evaluateonsubmission'] = 'Евалуирај само након предаје';
$string['evaluating'] = 'Евалуира се';
$string['evaluation'] = 'Евалуација';
$string['examples'] = 'Примери';
$string['execution'] = 'Извршавање';
$string['executionfiles'] = 'Извршне датотеке';
$string['executionfiles_help'] = '<h2>Увод</h2>
<p>Овде постављате датотеке које су потребне за припрему извршавања, откривања грешака или оцењивања предатог рада. Ово обухвата скрипт датотеке, датотеке за тестирање и датотеке са подацима.</p>
<h2>Подразумевани скрипт за извршавање или откривање грешака</h2>
<p>Ако не поставите скрипт датотеку за извршавање предатих радова или откривање грешака, систем ће препознати који језик користите (на основу екстензија датотека) и користити предефинисани скрипт.
<h2>Аутоматска евалуација</h2>
<p>Обухвата функционалности које омогућавају евалуацију предатих радова полазника.
Ова могућност дозвољава да се изврши програм полазника и проверава резултате његовог рада за задате улазне податке.
Да бисте подесили случајеве за евалуацију морате попунити датотеку "vpl_evaluate.cases".
<p>Датотека "vpl_evaluate.cases" је следећег формата:
<ul>
<li> "<strong>case </strong>= Опис случаја": Опционо. Подесите на почетку дефиниције случаја за евалуацију.</li>
<li> "<strong>input </strong>= текст": Може бити у више линија. Завршава се наредном инструкцијом.</li>
<li> "<strong>output </strong>= текст": Може бити у више линија. Завршава се наредном инструкцијом. Случај може имати више различитих тачних излаза. Постоје три типа излаза: бројеви, текст и тачан текст:
<ul>
<li> <strong>бројеви</strong>: Дефинисан као низ бројева (целих и реалних). На излазу се проверавају само бројне вредности, остатак текста се игнорише. Реалне вредности се проверавају са одређеним степеном толерације.</li>
<li> <strong>текст</strong>: Дефинисан као текст без наводника. Проверавају се само речи а остали карактери се игноришу, при чему се упоређивање ради уз игнорисање разлике између великих и малих слова.</li>
<li> <strong>тачан текст</strong>: Дефинисан као текст под наводницима. При тестирању излаза тражи се потпуно поклапање са датим текстом.</li>
</ul>
</li>
<li> "<strong>grade reduction</strong> = [вредност|проценат%]" : Подразумевано грешка у предатом коду смањује оцену полазника (у старту постављену на максималну могућу вредност) за (опсег оцена/број случајева) али помоћу ове инструкције можете изменити вредност, односно проценат тој умањења.</li>
</ul>
</p>
<h2>Општа употреба</h2>
<p>Нова датотека може бити додата писањем његов назива у оквир  "<b>Додај датотеку</b>" и потом кликом на дугме са натписом "<b>Додај датотеку</b>".</p>
<p>Постојећа датотека се може поставити коришћењем опције "<b>Постави датотеку</b>".<p>Све додате или постављене датотеке се могу уређивати, и све оне, осим три скрипт датотеке наведене испод, могу да се преименују или бришу.</p>
<h2>Ручно покретање, извршавање или евалуација</h2>
<p>Три скрипт датотеке за припрему сваке од наведених акција могу бити подешене. Те датотеке треба да имају предефинисане називе: <b>vpl_run.sh</b> (извршавање), <b>vpl_debug.sh</b>  (тражење грешака) и <b>vpl_evaluate.sh</b> (оцењивање).</p>
<p>Извршавање било ког од тих скриптова би требало да генерише датотеку под називом <b>vpl_execution</b>. Та датотека мора бити бинарна извршна или скрипт датотека која почиње са "#!/bin/sh ". Неуспех у генерисању те датотеке отежава извршавање одабране акције.</p>
<p>Ако је активност коју подешавате базирана на некој другој активности, датотеке базне активности се аутоматски додају.
Садржаји датотека vpl_run.sh, vpl_debug.sh и vpl_evaluate.sh се надовезују са најугњежденијег до текућег нивоа.</P>
<p>Коначно, датотека <b>vpl_environment.sh</b> се аутоматски додаје.
Та скрипт датотека садржи информације о предаји радова.
Информације пристижу као варијабле окружења: </p>
<ul> <li> LANG:  коришћени језик. </li>
<li> LC_ALL: иста вредност као за LANG. </li>
<li> VPL_MAXTIME: максимално време извршавања у секундама. </li>
<li> VPL_FILEBASEURL: URL за приступ датотекама курса. </li>
<li> VPL_SUBFILE#:  сваки назив датотеке коју преда полазник. # Креће се у опсегу од 0 до броја предатих датотека. </Li>
<li> VPL_SUBFILES: листа свих предатих датотека. </li>
<li> VPL_VARIATION + id: где је id редослед варијације који почиње од 0 а вредност је вредност варијације. </li>
</ul>
Ако је захтевана акција евалуација додају се и следеће варијабле.
<ul>
	<li>VPL_MAXTIME: максимално време извршавања у секундама.</li>
	<li>VPL_MAXMEMORY: максимална количина меморије која се може користити</li>
	<li>VPL_MAXFILESIZE: максимална величина датотеке која се може креирати, у бајтовима.</li>
	<li>VPL_MAXPROCESSES: максимални број процеса који се могу паралелно покретати.</li>
	<Li>VPL_FILEBASEURL: URL до датотека курса.</Li>
	<li>VPL_GRADEMIN: Минимална оцена за ову активност</li>
	<li>VPL_GRADEMAX: Максимална оцена за ову активност</li>
</ul>
<h2>Резултат оцењивања</h2>
<p>Излаз евалуације се обрађује да би се извукли, уколико је то могуће учинити, коментари и предложена оцена на бази урађене процене тачности решења.
Коментари се могу подесити на два начина: линијом коментара дефинисаном редом који почиње са \'Comment :=>>\' или блок коментарима који почињу редом који садржи  само \'<|--\' а завршавају се редом који садржи само \'--|>\'. Оцена се узима из последње линије која почиње са \'Grade :=>>\'.
</p>';
$string['executionoptions'] = 'Опције за извршавање';
$string['executionoptions_help'] = '<p>Бројне опције за извршавање се подешавају на овој страници</p>
<ul>
<li><b>Базирано на</b>: поставља друге инстанце овог додатка из којих се увозе неке функционалности:
<ul><li>Извршне датотеке (надовезивање предефинисаних скрипт датотека)</li>
<li>Ограничења ресурса за извршавање.</li>
<li>Варијације, које се надовезују да би се генерисале мултиваријације.</li>
<li>Максимална дужина сваке датотеке која ће се постављати са радом.</li>
</ul>
</li>
<li><b>Извршавање</b>, <b>Откривање грешака</b> and <b>Евалуација</b>: мора бити постављено на \'Да\' ако се одговарајућа акција може извршити током уређивања рада. То утиче искључиво на полазнике, док корисници са могућношћу оцењивања увек могу да изврше те акције.</li>
<li><b>Евалуација само након предаје рада</b>: предат рад се аутоматски оцењује кад се постави.</li>
<li><b>Аутоматско оцењивање</b>: ако резултат евалуације укључује кодове оцена, они се користе да се аутоматски постави оцена.</li>
</ul>';
$string['file'] = 'Датотека';
$string['fileNotChanged'] = 'Датотека није измењена';
$string['file_name'] = 'Назив датотеке';
$string['fileadded'] = 'Датотека \'{$a}\' је додата';
$string['filedeleted'] = 'Датотека \'{$a}\' је обрисана';
$string['filenotadded'] = 'Датотека није додата';
$string['filenotdeleted'] = 'Датотека \'{$a}\' НИЈЕ обрисана';
$string['filenotrenamed'] = 'Датотека \'{$a}\' НИЈЕ преименована';
$string['filerenamed'] = 'Датотека \'{$a->from}\' је преименована у \'{$a->to}\'';
$string['filesChangedNotSaved'] = 'Датотеке су измењене али нису сачуване';
$string['filesNotChanged'] = 'Датотеке нису измењене';
$string['filestoscan'] = 'Датотеке за преглед';
$string['fileupdated'] = 'Датотека \'{$a}\' је ажурирана';
$string['find'] = 'Нађи';
$string['find_replace'] = 'Нађи/Замени';
$string['fulldescription'] = 'Пун опис';
$string['fulldescription_help'] = '<p>Овде морате написати пун опис активности.</p>
<p>Ако ништа овде не напишете, уместо тога се приказује кратак опис.</p>
<p>Ако желите да користите аутоматску евалуацију, интерфејси за задатке морају бити детаљни и недвосмислени.</p>';
$string['fullscreen'] = 'Преко целог екрана';
$string['getjails'] = 'Прибави извршне сервере';
$string['gradeandnext'] = 'Оцени и пређи на следећи';
$string['graded'] = 'Оцењено';
$string['gradedbyuser'] = 'Оценио корисник';
$string['gradedon'] = 'Оцењено на дан';
$string['gradedonby'] = 'Оцењено на дан {$a->date} од стране корисника под именом {$a->gradername}';
$string['gradenotremoved'] = 'Оцена НИЈЕ уклоњена. Проверите подешавања активности у дневнику оцена.';
$string['gradenotsaved'] = 'Оцена НИЈЕ сачувана. Проверите подешавања активности у дневнику оцена.';
$string['gradeoptions'] = 'Опције оцене';
$string['grader'] = 'Оцењивач';
$string['gradercomments'] = 'Извештај о оцењивању';
$string['graderemoved'] = 'Оцена је уклоњена';
$string['groupwork'] = 'Групни рад';
$string['inconsistentgroup'] = 'Нисте члан само једне групе (0 o >1)';
$string['incorrect_file_name'] = 'Погрешно име датотеке';
$string['individualwork'] = 'Индивидуални рад';
$string['instanceselection'] = 'VPL одабир';
$string['isexample'] = 'Ова активност представља пример';
$string['jail_servers'] = 'Списак извршних сервера';
$string['jail_servers_config'] = 'Подешавање извршних сервера';
$string['jail_servers_description'] = 'Напишите по један ред за сваки сервер';
$string['joinedfiles'] = 'Спојене одабране датотеке';
$string['keepfiles'] = 'Датотеке које треба задржати при извршавању';
$string['keepfiles_help'] = '<p>Из безбедносних разлога, датотеке додате као as &quot;Извршне датотеке&quot; се бришу пре извршавања датотеке vpl_execution.</p>
Ако је било која од тих датотека потребна током извршавања (на пример да би се користили тестни подаци), то мора бити овде назначено.';
$string['lasterror'] = 'Информације о последњој грешци';
$string['lasterrordate'] = 'Датум последње грешке';
$string['listofcomments'] = 'Листа коментара';
$string['listsimilarity'] = 'Листа пронађених сличности';
$string['listwatermarks'] = 'Листа водених жигова';
$string['local_jail_servers'] = 'Локални извршни сервери';
$string['local_jail_servers_help'] = '<p>Овде можете подесити локалне извршне сервере додате за ову активност и оне које су базиране на њој.</p>
<p>Унесите пун URL сервера у сваком реду. Можете користити празне редове и коментаре који почињу са "#".</p>
<p>Ова активност ће као листу извршних сервера користити: скупове сервера наведене овде, листу сервера унету у активност на којој је базирана, као и листу заједничких извршних сервера. Ако желите да спречите да ова активност и из ње изведене активности користе друге сервере, морате додати ред који ће садржати "end_of_jails" на крају листе сервера.
</p>';
$string['manualgrading'] = 'Ручно оцењивање';
$string['maxexefilesize'] = 'Максимална величина извршне датотеке';
$string['maxexememory'] = 'Максимална искоришћена меморија';
$string['maxexeprocesses'] = 'Максимални број процеса';
$string['maxexetime'] = 'Максимално време извршавања';
$string['maxfiles'] = 'Максимални број датотека';
$string['maxfilesexceeded'] = 'Прекорачен је максимални број датотека';
$string['maxfilesize'] = 'Максимална величина датотеке';
$string['maxfilesizeexceeded'] = 'Прекорачена је максимална величина датотеке';
$string['maximumperiod'] = 'Максимални период {$a}';
$string['maxresourcelimits'] = 'Максимална ограничења ресурса за извршавање';
$string['maxsimilarityoutput'] = 'Максимални излаз по сличности';
$string['menucheck_jail_servers'] = 'Провери извршне сервере';
$string['menuexecutionfiles'] = 'Извршне датотеке';
$string['menuexecutionoptions'] = 'Опције';
$string['menukeepfiles'] = 'Датотеке које треба задржати';
$string['menulocal_jail_servers'] = 'Локални извршни сервери';
$string['menuresourcelimits'] = 'Ограничења ресурса';
$string['minsimlevel'] = 'Минимални ниво сличности за приказ';
$string['moduleconfigtitle'] = 'Подешавање модула ВПЛ';
$string['modulename'] = 'Виртуелна програмерска лабораторија';
$string['modulename_help'] = '<p>Виртуелна програмерска лабораторија (ВПЛ) је активност која управља програмерским задацима и који корисницима омогућава:
</p>

<ul>
<li>Омогућавање уређивања кода програма у читачу коришћењем аплета</li>
<li>Интерактивно покретање програма у читачу</li>
<li>Извршавање тест случајева ради контроле квалитета програма</li>
<li>Поређење предатих радова ради утврђивања степена сличности</li>
<li>Подешавање ограничења при уређивању и блокирање могућности уметања текста копираног из других извора.</li>
</ul>
<p><b>Основна дефиниција активности Виртуелна програмерска лабораторија</b></p>
<p>Да би се приступило осталим опцијама <b>прво се мора сачувати</b> основна дефиниција активности.</p>
<p>Ограничења за процес предаје радова се могу подесити на панелу <b>Ограничења предаје радова</b> panel:</p>
<ul>
<li>Максимални број датотека за предају. Можете поставити називе датотека на картици "захтеване датотеке".</li>
<li>Предаја радова могућа само путем ограниченог едитора кода. Ако активирате ову опцију неће бити дозвољено постављање датотека ни уметање текста копираног из других извора.</li>
<li>Максимална величина датотеке за постављање.</li>
<li>Лозинка за приступ и предају активности.
Ако поставите лозинку систем ће је тражити од корисника при приступу активности.</li>
<li>Мреже са којих је дозвољена предаја радова.</li>
</ul>
<p>На овој страници се могу подесити и друге уобичајене опције, као што су скале за оцењивање или параметри везани за групни рад.</p>';
$string['modulename_link'] = 'mod/vpl/view';
$string['modulenameplural'] = 'Виртуелне програмерске лабораторије';
$string['new'] = 'Ново';
$string['new_file_name'] = 'Нови назив датотеке';
$string['next'] = 'Следећи';
$string['nojailavailable'] = 'Нема расположивих извршних сервера';
$string['noright'] = 'Немате право приступа';
$string['nosubmission'] = 'Нема расположивих предатих радова';
$string['notexecuted'] = 'Није извршено';
$string['notgraded'] = 'Није оцењено';
$string['notsaved'] = 'Није сачувано';
$string['novpls'] = 'Нема дефинисаних програмерских лабораторија';
$string['nowatermark'] = 'Број сопствених водених жигова: {$a}';
$string['nsubmissions'] = 'Број предатих радова: {$a}';
$string['numcluster'] = 'Кластер {$a}';
$string['open'] = 'Отворено';
$string['opnotallowfromclient'] = 'Акција није дозвољена са ове машине';
$string['options'] = 'Опције';
$string['optionsnotsaved'] = 'Опције нису сачуване';
$string['optionssaved'] = 'Опције су сачуване';
$string['origin'] = 'Порекло';
$string['othersources'] = 'Други извори за додавање у преглед';
$string['outofmemory'] = 'Сва меморија је заузета';
$string['paste'] = 'Налепи';
$string['pluginadministration'] = 'ВПЛ администрација';
$string['pluginname'] = 'Виртуелна програмерска лабораторија';
$string['previoussubmissionslist'] = 'Списак раније предатих радова';
$string['proposedgrade'] = 'Предложена оцена: {$a}';
$string['proxy'] = 'Посредник (proxy)';
$string['proxy_description'] = 'Посредник (proxy) од Moodle сервера до извршних сервера';
$string['redo'] = 'Уради поново';
$string['regularscreen'] = 'Обичан екран';
$string['removegrade'] = 'Уклони оцену';
$string['rename'] = 'Преименуј';
$string['rename_file'] = 'Преименуј датотеку';
$string['replace_find'] = 'Замени/Нађи';
$string['requestedfiles'] = 'Захтеване датотеке';
$string['requestedfiles_help'] = '<p>Овде постављате називе и почетне садржаје захтеваних датотека до максималног броја датотека одређеног у основном опису активности.</p>
<p>Ако не поставите имена за све датотеке, оне које остану неименоване сматраће се опционим и моћи ће да имају било који назив.</p>
<p>Можете додати и садржај захтеваним датотекама тако да он буде на располагању при првом отварању тих датотека у едитору, наравно ако не постоји претходно предат рад.</p>';
$string['requirednet'] = 'Дозвољена је предаја радова са мреже';
$string['requiredpassword'] = 'Лозинка је обавезна';
$string['resetfiles'] = 'Врати датотеке на почетно стање';
$string['resetvpl'] = 'Врати {$a} на почетно стање';
$string['resourcelimits'] = 'Ограничења ресурса';
$string['resourcelimits_help'] = '<p>Можете поставити ограничења за време извршавања, коришћење меморије, величину извршних датотека и број процеса који ће се истовремено извршавати.</p>
<p>Та ограничења се користе кад се извршавају скрипт датотеке vpl_run.sh, vpl_debug.sh и vpl_evaluate.sh и датотека vpl_execution коју оне креирају.</p>
<p>Ако је ова активност базирана на другим активностима на ова ограничења  могу утицати она постављена у базној активности и њеним прецима или у општим подешавањима модула.</p>';
$string['restrictededitor'] = 'Онемогући постављање екстерних датотека, уметање и превлачење екстерног садржаја';
$string['retrieve'] = 'Преузми резултате';
$string['run'] = 'Изврши';
$string['running'] = 'Извршава се';
$string['save'] = 'Сачувај';
$string['savecontinue'] = 'Сачувај и настави';
$string['saved'] = 'Сачувано';
$string['savedfile'] = 'Датотека \'{$a}\' је сачувана';
$string['saveoptions'] = 'опције за чување';
$string['saving'] = 'Снима се';
$string['scanactivity'] = 'Активност';
$string['scandirectory'] = 'Директоријум';
$string['scanningdir'] = 'Скенира се директоријум...';
$string['scanoptions'] = 'Опције за скенирање';
$string['scanother'] = 'Скенирај сличности у додатим изворним кодовима';
$string['scanzipfile'] = 'Zip датотека';
$string['select_all'] = 'Одабери све';
$string['server'] = 'Сервер';
$string['serverexecutionerror'] = 'Серверска грешка при извршавању';
$string['shortdescription'] = 'Кратак опис';
$string['similarity'] = 'Сличност';
$string['similarto'] = 'Слично као';
$string['startdate'] = 'Доступно од';
$string['submission'] = 'Предат рад';
$string['submissionperiod'] = 'Период за предају радова';
$string['submissionrestrictions'] = 'Ограничења при предаји радова';
$string['submissions'] = 'Предати радови';
$string['submissionselection'] = 'Одабир предатог рада';
$string['submissionslist'] = 'Списак предатих радова';
$string['submissionview'] = 'Приказ предатог рада';
$string['submittedby'] = 'Рад је предао/ла {$a}';
$string['submittedon'] = 'Датум предаје:';
$string['submittedonp'] = 'Датум предаје: {$a}';
$string['sureresetfiles'] = 'Да ли желите да изгубите све што сте урадили и вратите датотеке на њихово почетно стање?';
$string['test'] = 'Активност теста';
$string['testcases'] = 'Тест случајеви';
$string['testcases_help'] = '<p>Ова функционалност омогућава покретање студентског програма и проверава његов излаз за дати улаз.  Да бисте подесили тест случајеве морате попунити датотеку "vpl_evaluate.cases".</p>
<p>Датотека "vpl_evaluate.cases" је следећег формата:
<ul>
<li> "<strong>case </strong>= Опис случаја": Опционо. Подесите почетак дефиниције тест случаја.</li>
<li> "<strong>input </strong>= текст": Може заузимати више линија. Завршава се са другом инструкцијом.</li>
<li> "<strong>output </strong>= текст": Може заузимати више линија. Завршава се са другом инструкцијом. Случај може имати више тачних излаза. Постоје три типа излаза: број, текст и тачан текст:
<ul>
<li> <strong>број</strong>: дефинише се као низ бројева (целих или реалних). Само бројне вредности на излазу се проверавају, остатак текста се игнорише. За реалне вредности толерише се ситно одступање.</li>
<li> <strong>текст</strong>: дефинише се као текст без наводника. Само речи се проверавају док се остатак карактера игнорише. При поређењу се не прави разлика између малих и великих слова.</li>
<li> <strong>тачан текст</strong>: дефинише се као текст под наводницима. При тестирању излаза тражи се тачно поклапање.</li>
</ul>
</li>
<li> "<strong>редукција оцене</strong> = [вредност|проценат%]" : Подразумевано грешка умањује оцену полазника (почиње од максималне оцене) за (опсег оцена /број случајева) али овом инструкцијом можете да промените вредност или проценат редукције.</li>
</ul>';
$string['timelimited'] = 'Ограничено време';
$string['timeout'] = 'Прекорачење времена';
$string['timeunlimited'] = 'Неограничено време';
$string['totalnumberoferrors'] = 'Грешке';
$string['undo'] = 'Поништи';
$string['unexpected_file_name'] = 'Нетачан назив датотеке: очекиван је \'{$a->expected}\' а нађен \'{$a->found}\'';
$string['unzipping'] = 'Распакује се...';
$string['uploadfile'] = 'Постави датотеку';
$string['usevariations'] = 'Користи варијације';
$string['variation_options'] = 'Опције варијације';
$string['variations'] = 'Варијације';
$string['variations_help'] = '<p>За активност се може дефинисати скуп варијација. Те варијације се насумичним одабиром додељују студентима.</p>
<p>Овде можете назначити да ова активност има варијације, ставити наслов за скуп варијација и додати жељене варијације.</p>
<p>Свака варијација има идентификациони код и опис. Идентификациони код користи датотека <b>vpl_enviroment.sh</b> да проследи варијацију додељену сваком студенту скрипт датотекама. Опис, форматиран у HTML-у, се приказује студентима којима је додељена одговарајућа варијација.</p>';
$string['variations_unused'] = 'Ова активност има варијације, али су оне онемогућене';
$string['variationtitle'] = 'Наслов варијације';
$string['varidentification'] = 'Идентификација';
$string['visiblegrade'] = 'Видљиво';
$string['vpl'] = 'Виртуелна програмерска лабораторија';
$string['vpl:addinstance'] = 'Додај нове vpl инстанце';
$string['vpl:grade'] = 'Оцени VPL задатак';
$string['vpl:manage'] = 'Управљај VPL задатком';
$string['vpl:setjails'] = 'Подеси извршне сервере за конкретну VPL инстанцу';
$string['vpl:similarity'] = 'Потражи сличне VPL задатке';
$string['vpl:submit'] = 'Предај VPL задатак';
$string['vpl:view'] = 'Погледај пун опис VPL задатка';
$string['vpl_debug.sh'] = 'Скрипт припрема отклањање грешака';
$string['vpl_evaluate.cases'] = 'Тест случајеви за евалуацију';
$string['vpl_evaluate.sh'] = 'Скрипт припрема евалуацију';
$string['vpl_run.sh'] = 'Скрипт припрема извршавање';
$string['websocket_protocol'] = 'WebSocket протокол';
$string['websocket_protocol_description'] = 'Тип WebSocket протокола (ws:// или wss://) који користи читач да би се повезао да извршним серверима.';
$string['workingperiods'] = 'Периоди рада';
$string['worktype'] = 'Тип рада';
