<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'qtype_ordering', language 'uk', version '4.5'.
 *
 * @package     qtype_ordering
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['absoluteposition'] = 'Абсолютна позиція';
$string['addmultipleanswers'] = 'Додати {$a} елементів';
$string['addsingleanswer'] = 'Додати один елемент';
$string['allornothing'] = 'Все або нічого';
$string['answer'] = 'Текст елементу';
$string['correctorder'] = 'Правильний порядок для цих елементів такий:';
$string['defaultanswerformat'] = 'Стандартний формат відповіді';
$string['defaultquestionname'] = 'Перетягніть наступні елементи в правильному порядку.';
$string['duplicatesnotallowed'] = 'Дублювання елементів для перетягування, заборонено. Рядок "{$a->text}" вже використано в {$a->item}.';
$string['editingordering'] = 'Редагування питання на впорядкування';
$string['gradedetails'] = 'Деталі оцінки';
$string['gradingtype'] = 'Тип оцінювання';
$string['gradingtype_help'] = 'Виберіть тип розрахунку оцінки.

**Все або нічого**
: Якщо всі елементи знаходяться в правильному положенні, нараховуються повний бал. В іншому випадку оцінка нуль.

**Абсолютна позиція**
: Елемент вважається правильним, якщо він знаходиться в тій самій позиції, що й правильна відповідь. Найвища можлива оцінка за запитання **така ж, як** кількість елементів, показаних студенту.

**Відносно правильної позиції**
: Елемент вважається правильним, якщо він знаходиться в тій самій позиції, що й правильна відповідь. Правильні елементи отримують бал, що дорівнює кількості показаних елементів мінус один. Неправильні елементи отримують бал, що дорівнює кількості показаних елементів мінус один і мінус відстань елемента від його правильного положення. Таким чином, якщо студенту показано ***n*** елементів, кількість балів, доступних для кожного елемента, дорівнює ***(n - 1)***, а найвища оцінка, доступна для запитання, дорівнює *** n x (n - 1)***, що дорівнює ***(n² - n)***.

**Відносно наступного елемента (за винятком останнього)**
: Елемент вважається правильним, якщо за ним стоїть той самий елемент, що й у правильній відповіді. Елемент на останній позиції не враховується. Таким чином, найвищий можливий бал для запитання **на один менше** кількості елементів, показаних студенту.

**Відносно наступного елемента (включно з останнім)**
: Елемент вважається правильним, якщо за ним стоїть той самий елемент, що й у правильній відповіді. Сюди входить останній елемент, після якого не може бути жодного елемента. Таким чином, найвища можлива оцінка для запитання **така ж, як** кількість елементів, показаних студенту.

**Відносно як попереднього, так і наступного елементів**
: Елемент вважається правильним, якщо і попередній, і наступний елементи збігаються з правильними відповідями. Перший елемент не повинен мати попереднього елемента, а останній елемент не повинен мати наступного. Таким чином, існує два можливих варіанти балів для кожного елемента, а найвищий можливий бал за запитання дорівнює **подвоєнню** кількості елементів, показаних студенту.

**Відносно ВСІХ попередніх і наступних елементів**
:  Елемент вважається правильним, якщо йому передують усі ті самі елементи, що й у правильній відповіді, а за ним усі ті самі елементи, що й у правильній відповіді. Порядок попередніх елементів не має значення, як і порядок наступних елементів. Таким чином, якщо студенту показано ***n*** елементів, кількість балів, доступних для кожного елементу, дорівнює ***(n - 1)***, а найвища оцінка, доступна для запитання, дорівнює *** n x (n - 1)***, що дорівнює ***(n² - n)***.

**Найдовша впорядкована підмножина**
: Оцінка — це кількість елементів у найдовшій упорядкованій підмножині елементів. Найвища можлива оцінка дорівнює кількості показаних елементів. Підмножина повинна містити принаймні два елементи. Підмножини не обов’язково починаються з першого елемента (але вони можуть), і вони не повинні бути суміжними (але вони можуть бути). Якщо є кілька підмножин однакової довжини, елементи в підмножині, яка знайдена першою під час пошуку зліва направо, показуватимуться як правильні. Інші елементи будуть позначені як неправильні.

**Найдовша безперервна підмножина**
: Оцінка — це кількість елементів у найдовшій безперервній підмножині елементів. Найвища можлива оцінка дорівнює кількості показаних елементів. Підмножина повинна містити принаймні два елементи. Підмножини не обов’язково починаються з першого елемента (але можуть), і вони ПОВИННІ БУТИ СУМІЖНИМИ. Якщо є кілька підмножин однакової довжини, елементи в підмножині, яка знайдена першою під час пошуку зліва направо, показуватимуться як правильні. Інші елементи будуть позначені як неправильні.';
$string['horizontal'] = 'Горизонтально';
$string['layouttype'] = 'Розташування елементів';
$string['layouttype_help'] = 'Виберіть, показувати елементи вертикально чи горизонтально.';
$string['longestcontiguoussubset'] = 'Найдовша безперервна підмножина';
$string['longestorderedsubset'] = 'Найдовша впорядкована підмножина';
$string['noresponsedetails'] = 'На жаль, деталі відповіді на це запитання недоступні.';
$string['noscore'] = 'Без оцінки';
$string['notenoughanswers'] = 'Питання на впорядкування повинно мати більше ніж {$a} відповіді';
$string['numberingstyle'] = 'Пронумерувати елементи?';
$string['numberingstyle_desc'] = 'Типовий стиль нумерації.';
$string['numberingstyle_help'] = 'Виберіть стиль нумерації для елементів перетягування у цьому питанні.';
$string['numberingstylenone'] = 'Без нумерації';
$string['pluginname'] = 'Впорядкування';
$string['pluginname_help'] = 'Кілька елементів показуються в перемішаному порядку. Елементи можна перетягувати в значущий порядок.';
$string['pluginname_link'] = 'question/type/ordering';
$string['pluginnameadding'] = 'Додавання питання на впорядкування';
$string['pluginnameediting'] = 'Редагування питання на впорядкування';
$string['pluginnamesummary'] = 'Розмістіть перемішані елементи в правильному порядку.';
$string['positionx'] = 'Позиція {$a}';
$string['relativeallpreviousandnext'] = 'Відносно ВСІХ попередніх і наступних елементів';
$string['relativenextexcludelast'] = 'Відносно наступного елемента (за винятком останнього)';
$string['relativenextincludelast'] = 'Відносно наступного елемента (включно з останнім)';
$string['relativeonepreviousandnext'] = 'Відносно як попереднього, так і наступного елементів';
$string['relativetocorrect'] = 'Відносно правильного положення';
$string['removeeditor'] = 'Прибрати редактор HTML';
$string['removeitem'] = 'Видалити елемент перетягування';
$string['scoredetails'] = 'Ось бали для кожного елементу в цій відповіді:';
$string['selectall'] = 'Вибрати усі елементи';
$string['selectcontiguous'] = 'Вибрати безперервну підмножину елементів';
$string['selectcount'] = 'Розмір підмножини';
$string['selectcount_help'] = 'Кількість елементів, які показуватимуться, коли запитання з’явиться в тесті.';
$string['selectrandom'] = 'Вибрати випадкову підмножину елементів';
$string['selecttype'] = 'Тип вибору елементів';
$string['selecttype_help'] = 'Виберіть, чи показувати всі елементи чи їх підмножину.';
$string['showgrading'] = 'Деталі оцінювання';
$string['showgrading_help'] = 'Виберіть, чи показувати чи приховувати деталі підрахунку балів, коли студент переглядає відповідь на це запитання.';
$string['vertical'] = 'Вертикально';
