<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'auth_ldap', language 'lo', version '4.5'.
 *
 * @package     auth_ldap
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['auth_ldap_ad_create_req'] = 'ບໍ່ສາມາດສ້າງບັນຊີໃໝ່ໃນ ບັນຊີລາຍການທີ່ເປີດໃຊ້ ໄດ້. ໃຫ້ແນ່ໃຈວ່າທ່ານຕອບສະໜອງຄວາມຕ້ອງການທັງໝົດສໍາລັບການນີ້ເຮັດວຽກ (ການເຊື່ອມຕໍ່ LDAPS, ຜູກມັດຜູ້ໃຊ້ທີ່ມີສິດທິພຽງພໍ, ແລະອື່ນໆ.)';
$string['auth_ldap_attrcreators'] = 'ລາຍຊື່ກຸ່ມ ຫຼື ບໍລິບົດທີ່ສະມາຊິກໄດ້ຮັບອະນຸຍາດໃຫ້ສ້າງຄຸນສົມບັດ. ແຍກຫຼາຍກຸ່ມດ້ວຍ \';\'. ປົກກະຕິແລ້ວບາງສິ່ງບາງຢ່າງເຊັ່ນ \'cn=teachers,ou=staff,o=myorg\'';
$string['auth_ldap_attrcreators_key'] = 'ຜູ້ສ້າງຄຸນລັກສະນະ';
$string['auth_ldap_auth_user_create_key'] = 'ສ້າງຜູ້ໃຊ້ພາຍນອກ';
$string['auth_ldap_bind_dn'] = 'ຖ້າທ່ານຕ້ອງການໃຊ້ ການຜູກມັດຜູ້ໃຊ້ ເພື່ອຊອກຫາຜູ້ໃຊ້, ໃຫ້ລະບຸມັນຢູ່ທີ່ນີ້. ບາງສິ່ງບາງຢ່າງເຊັ່ນ \'cn=ldapuser,ou=public,o=org\'';
$string['auth_ldap_bind_dn_key'] = 'ຊື່ທີ່ໂດດເດັ່ນ';
$string['auth_ldap_bind_pw'] = 'ລະຫັດຜ່ານເພື່ອຜູກມັດລູກຄ້າ';
$string['auth_ldap_bind_pw_key'] = 'ລະຫັດຜ່ານ';
$string['auth_ldap_bind_settings'] = 'ການຕັ້ງຄ່າການຜູກມັດ';
$string['auth_ldap_changepasswordurl_key'] = 'ການປ່ຽນລະຫັດຜ່ານ URL';
$string['auth_ldap_contexts'] = 'ບັນຊີລາຍຊື່ຂອງສະພາບການທີ່ຜູ້ໃຊ້ຕັ້ງຢູ່. ແຍກບໍລິບົດທີ່ແຕກຕ່າງກັນດ້ວຍ \';\'. ຕົວຢ່າງ: \'ou=users, o=org; ou=others, o=org\'';
$string['auth_ldap_contexts_key'] = 'ບໍລິບົດ';
$string['auth_ldap_create_context'] = 'ຖ້າທ່ານເປີດໃຊ້ງານການສ້າງຜູ້ໃຊ້ດ້ວຍການຢືນຢັນອີເມລ໌, ໃຫ້ລະບຸບໍລິບົດທີ່ຜູ້ໃຊ້ຖືກສ້າງຂຶ້ນ. ບໍລິບົດນີ້ຄວນຈະແຕກຕ່າງຈາກຜູ້ໃຊ້ອື່ນ ເພື່ອປ້ອງກັນບັນຫາຄວາມປອດໄພ. ທ່ານບໍ່ຈຳເປັນຕ້ອງເພີ່ມບໍລິບົດນີ້ໃສ່ ldap_context-variable, Moodle ຈະຊອກຫາຜູ້ໃຊ້ຈາກບໍລິບົດນີ້ໂດຍອັດຕະໂນມັດ.<br /><b>ໝາຍເຫດ!</b> ທ່ານຕ້ອງແກ້ໄຂວິທີການ user_create() ໃນ ໄຟລ໌ auth/ ldap/auth.php ເພື່ອເຮັດໃຫ້ການສ້າງຜູ້ໃຊ້ເຮັດວຽກ';
$string['auth_ldap_create_context_key'] = 'ບໍລິບົດສຳລັບຜູ້ໃຊ້';
$string['auth_ldap_create_error'] = 'ຜິດພາດໃນການສ້າງຜູ້ໃຊ້ໃນ LDAP.';
$string['auth_ldap_expiration_desc'] = 'ເລືອກ \'{$a->no}\' ເພື່ອປິດການກວດສອບລະຫັດຜ່ານທີ່ໝົດອາຍຸ ຫຼື \'{$a->ldapserver}\' ເພື່ອອ່ານເວລາໝົດອາຍຸລະຫັດຜ່ານໂດຍກົງຈາກເຊີເວີ LDAP.';
$string['auth_ldap_expiration_key'] = 'ໝົດອາຍຸ';
$string['auth_ldap_expiration_warning_desc'] = 'ຈໍານວນມື້ກ່ອນທີ່ຈະອອກຄໍາເຕືອນການໝົດອາຍຸລະຫັດຜ່ານ.';
$string['auth_ldap_expiration_warning_key'] = 'ການເຕືອນໝົດອາຍຸ';
$string['auth_ldap_expireattr_desc'] = 'ທາງເລືອກ: ລົບລ້າງຄຸນສົມບັດ LDAP ທີ່ເກັບຮັກສາເວລາໝົດອາຍຸຂອງລະຫັດຜ່ານ.';
$string['auth_ldap_expireattr_key'] = 'ຄຸນສົມບັດໝົດອາຍຸ';
$string['auth_ldap_graceattr_desc'] = 'ທາງເລືອກ: ລົບລ້າງຄຸນສົມບັດການເຂົ້າສູ່ລະບົບແບບຍົກເວັ້ນ';
$string['auth_ldap_gracelogin_key'] = 'ຄຸນສົມບັດການເຂົ້າສູ່ລະບົບແບບຍົກເວັ້ນ';
$string['auth_ldap_gracelogins_desc'] = 'ເປີດໃຊ້ການຮອງຮັບການເຂົ້າສູ່ລະບົບແບບຍົກເວັ້ນຂອງ LDAP. ຫຼັງຈາກລະຫັດຜ່ານໝົດອາຍຸ, ຜູ້ໃຊ້ສາມາດເຂົ້າສູ່ລະບົບໄດ້ຈົນກ່ວາການເຂົ້າສູ່ລະບົບແບບຍົກເວັ້ນແມ່ນ 0. ການເປີດໃຊ້ງານການຕັ້ງຄ່ານີ້ ຈະສະແດງຂໍ້ຄວາມການເຂົ້າສູ່ລະບົບແບບຍົກເວັ້ນ ຖ້າຫາກວ່າລະຫັດຜ່ານໝົດອາຍຸ.';
$string['auth_ldap_gracelogins_key'] = 'ການເຂົ້າສູ່ລະບົບແບບຍົກເວັ້ນ';
$string['auth_ldap_groupecreators'] = 'ລາຍຊື່ກຸ່ມ ຫຼື ບໍລິບົດທີ່ສະມາຊິກໄດ້ຮັບອະນຸຍາດໃຫ້ສ້າງກຸ່ມ. ແຍກຫຼາຍກຸ່ມດ້ວຍ \';\'. ປົກກະຕິແລ້ວບາງສິ່ງບາງຢ່າງເຊັ່ນ \'cn=teachers,ou=staff,o=myorg\'';
$string['auth_ldap_groupecreators_key'] = 'ກຸ່ມຜູ້ສ້າງ';
$string['auth_ldap_host_url'] = 'ລະບຸເຈົ້າພາບ LDAP ໃນຮູບແບບ URL ເຊັ່ນ \'ldap://ldap.myorg.com/\' ຫຼື \'ldaps://ldap.myorg.com/\'. ແຍກຫຼາຍເຊີເວີດ້ວຍ \';\' ໄດ້ຮັບການສະໜັບສະໜູນຄວາມລົ້ມເຫຼວ.';
$string['auth_ldap_host_url_key'] = 'ເຈົ້າພາບ URL';
$string['auth_ldap_ldap_encoding'] = 'ການເຂົ້າລະຫັດທີ່ໃຊ້ໂດຍເຊີບເວີ LDAP, ສ່ວນຫຼາຍອາດຈະເປັນ utf-8. ຖ້າ LDAP v2 ຖືກເລືອກ, ບັນຊີລາຍການທີ່ເປີດໃຊ້ ໃຊ້ການເຂົ້າລະຫັດການຕັ້ງຄ່າຂອງມັນ, ເຊັ່ນ cp1252 ຫຼື cp1250.';
$string['auth_ldap_ldap_encoding_key'] = 'ການເຂົ້າລະຫັດ LDAP';
$string['auth_ldap_login_settings'] = 'ການຕັ້ງຄ່າການເຂົ້າສູ່ລະບົບ';
$string['auth_ldap_memberattribute'] = 'ທາງເລືອກ: ລົບລ້າງຄຸນສົມບັດສະມາຊິກຜູ້ໃຊ້, ເມື່ອຜູ້ໃຊ້ເປັນຂອງກຸ່ມ. ປົກກະຕິແລ້ວ \'ສະມາຊິກ\'';
$string['auth_ldap_memberattribute_isdn'] = 'ລົບລ້າງການຈັດການຄ່າຄຸນສົມບັດຂອງສະມາຊິກ';
$string['auth_ldap_memberattribute_isdn_key'] = 'ຄຸນສົມບັດສະມາຊິກໃຊ້ dn';
$string['auth_ldap_memberattribute_key'] = 'ຄຸນສົມບັດສະມາຊິກ';
$string['auth_ldap_no_mbstring'] = 'ທ່ານຕ້ອງການສ່ວນຂະຫຍາຍ mbstring ເພື່ອສ້າງຜູ້ໃຊ້ໃນ ບັນຊີລາຍການທີ່ເປີດໃຊ້.';
$string['auth_ldap_noconnect'] = 'ຊຸດ LDAP-module ບໍ່ສາມາດເຊື່ອມຕໍ່ກັບເຊີບເວີໄດ້: {$a}';
$string['auth_ldap_noconnect_all'] = 'ຊຸດ LDAP-module ບໍ່ສາມາດເຊື່ອມຕໍ່ກັບເຊີບເວີໃດໜຶ່ງ: {$a}';
$string['auth_ldap_noextension'] = 'ໂມດູນ PHP LDAP ເບິ່ງຄືວ່າບໍ່ມີຢູ່. ກະລຸນາກວດສອບວ່າ ມັນຖືກຕິດຕັ້ງ ແລະ ເປີດໃຊ້ງານຫາກທ່ານຕ້ອງການໃຊ້ປລັກອິນການກວດສອບຄວາມຖືກຕ້ອງນີ້.';
$string['auth_ldap_objectclass'] = 'ທາງເລືອກ: ລົບລ້າງ objectClass ທີ່ໃຊ້ເພື່ອຕັ້ງຊື່/ຄົ້ນຫາຜູ້ໃຊ້ໃນ ldap_user_type. ປົກກະຕິແລ້ວທ່ານບໍ່ຈໍາເປັນຕ້ອງປ່ຽນອັນນີ້.';
$string['auth_ldap_objectclass_key'] = 'ປະເພດວັດຖຸ';
$string['auth_ldap_opt_deref'] = 'ກໍານົດວິທີການປະຕິບັດນາມແຝງໃນລະຫວ່າງການຄົ້ນຫາ. ເລືອກໜຶ່ງໃນຄ່າຕໍ່ໄປນີ້: "ບໍ່" (LDAP_DEREF_NEVER) ຫຼື "ແມ່ນ" (LDAP_DEREF_ALWAYS)';
$string['auth_ldap_opt_deref_key'] = 'ການອ້າງອີງນາມແຝງ';
$string['auth_ldap_passtype'] = 'ລະບຸຮູບແບບຂອງລະຫັດຜ່ານໃໝ່ ຫຼື ມີການປ່ຽນແປງໃນເຊີບເວີ LDAP.';
$string['auth_ldap_passtype_key'] = 'ຮູບແບບລະຫັດຜ່ານ';
$string['auth_ldap_passwdexpire_settings'] = 'ການຕັ້ງຄ່າໝົດອາຍຸລະຫັດຜ່ານ LDAP';
$string['auth_ldap_preventpassindb'] = 'ເລືອກ ແມ່ນ ເພື່ອປ້ອງກັນລະຫັດຜ່ານຈາກການເກັບຮັກສາໃນ DB ຂອງ Moodle.';
$string['auth_ldap_preventpassindb_key'] = 'ປ້ອງກັນການແຄັດລະຫັດຜ່ານ';
$string['auth_ldap_rolecontext'] = '{$a->localname} ບໍລິບົດ';
$string['auth_ldap_rolecontext_help'] = 'ບໍລິບົດ LDAP ໃຊ້ເພື່ອເລືອກສຳລັບການສ້າງແຜນທີ່ <i>{$a->localname</i>. ແຍກຫຼາຍກຸ່ມດ້ວຍ \';\'. ປົກກະຕິແລ້ວບາງສິ່ງບາງຢ່າງເຊັ່ນ "cn={$a->shortname},ou=first-ou-with-role-groups,o=myorg; cn={$a->shortname},ou=second-ou-with -role-groups,o=myorg".';
$string['auth_ldap_search_sub'] = 'ຊອກຫາຜູ້ໃຊ້ຈາກບໍລິບົດຍ່ອຍ';
$string['auth_ldap_search_sub_key'] = 'ຊອກຫາບໍລິບົດຍ່ອຍ';
$string['auth_ldap_server_settings'] = 'ການຕັ້ງຄ່າເຊີເວີ LDAP';
$string['auth_ldap_suspended_attribute'] = 'ທາງເລືອກ: ເມື່ອໃຫ້ຄຸນລັກສະນະນີ້ ຈະຖືກໃຊ້ເພື່ອ ເປີດໃຊ້/ໂຈະ ບັນຊີຜູ້ໃຊ້ທີ່ສ້າງຂຶ້ນໃນເຄື່ອງ.';
$string['auth_ldap_suspended_attribute_key'] = 'ຄຸນສົມບັດຖືກລະງັບ';
$string['auth_ldap_unsupportedusertype'] = 'auth: ldap user_create() ບໍ່ຮອງຮັບປະເພດຜູ້ໃຊ້ທີ່ເລືອກ: {$a}';
$string['auth_ldap_update_userinfo'] = 'ປັບປຸງຂໍ້ມູນຜູ້ໃຊ້ (ຊື່, ນາມສະກຸນ, ທີ່ຢູ່..) ຈາກ LDAP ເປັນ Moodle. ລະບຸການຕັ້ງຄ່າ "ແຜນທີ່ຂໍ້ມູນ" ຕາມທີ່ທ່ານຕ້ອງການ.';
$string['auth_ldap_user_attribute'] = 'ທາງເລືອກ: ລົບລ້າງຄຸນສົມບັດທີ່ໃຊ້ເພື່ອຊື່/ຄົ້ນຫາຜູ້ໃຊ້. ປົກກະຕິແລ້ວ \'cn\'.';
$string['auth_ldap_user_attribute_key'] = 'ຄຸນສົມບັດຜູ້ໃຊ້';
$string['auth_ldap_user_exists'] = 'ຊື່ຜູ້ໃຊ້ LDAP ມີຢູ່ແລ້ວ';
$string['auth_ldap_user_settings'] = 'ການຕັ້ງຄ່າການຊອກຫາຜູ້ໃຊ້';
$string['auth_ldap_user_type'] = 'ເລືອກວິທີທີ່ຜູ້ໃຊ້ຖືກເກັບໄວ້ໃນ LDAP. ການຕັ້ງຄ່ານີ້ຍັງລະບຸວ່າ ການເຂົ້າສູ່ລະບົບຫມົດອາຍຸ, ການເຂົ້າສູ່ລະບົບແບບຍົກເວັ້ນ ແລະ ການສ້າງຜູ້ໃຊ້ຈະເຮັດວຽກ.';
$string['auth_ldap_user_type_key'] = 'ປະເພດຜູ້ໃຊ້';
$string['auth_ldap_usertypeundefined'] = 'config.user_type ບໍ່ໄດ້ກຳນົດ ຫຼື ຟັງຊັນ ldap_expirationtime2unix ບໍ່ຮອງຮັບປະເພດທີ່ເລືອກ!';
$string['auth_ldap_usertypeundefined2'] = 'config.user_type ບໍ່ໄດ້ກຳນົດ ຫຼື ຟັງຊັນ ldap_unixi2expirationtime ບໍ່ຮອງຮັບປະເພດທີ່ເລືອກ!';
$string['auth_ldap_version'] = 'ສະບັບຂອງລະບຽບການ LDAP ເຊີບເວີຂອງທ່ານກໍາລັງໃຊ້.';
$string['auth_ldap_version_key'] = 'ສະບັບ';
$string['auth_ldapdescription'] = 'ວິທີການນີ້ສະໜອງການພິສູດຢືນຢັນຕໍ່ກັບເຊີເວີ LDAP ພາຍນອກ. ຖ້າຊື່ຜູ້ໃຊ້ ແລະ ລະຫັດຜ່ານທີ່ຖືກຕ້ອງ, Moodle ຈະສ້າງຂໍ້ມູນຜູ້ໃຊ້ໃໝ່ໃນຖານຂໍ້ມູນຂອງມັນ. ປລັກອິນນີ້ສາມາດອ່ານຄຸນລັກສະນະຂອງຜູ້ໃຊ້ຈາກ LDAP ແລະ ຕື່ມຂໍ້ມູນໃສ່ຊ່ອງຂໍ້ມູນທີ່ຕ້ອງການໃນ Moodle. ສໍາລັບການເຂົ້າສູ່ລະບົບດັ່ງຕໍ່ໄປນີ້ ພຽງແຕ່ຊື່ຜູ້ໃຊ້ແລະ ລະຫັດຜ່ານໄດ້ຖືກກວດສອບ.';
$string['auth_ldapextrafields'] = 'ຊ່ອງຂໍ້ມູນເຫຼົ່ານີ້ແມ່ນທາງເລືອກ. ທ່ານສາມາດເລືອກທີ່ຈະຕື່ມຂໍ້ມູນໃສ່ລ່ວງໜ້າບາງຊ່ອງຂໍ້ມູນຜູ້ໃຊ້ Moodle ກັບຂໍ້ມູນຈາກ <b>ຊ່ອງໃສ່ການ LDAP</b> ທີ່ທ່ານລະບຸໄວ້ທີ່ນີ້. <p>ຖ້າທ່ານປ່ອຍໃຫ້ຊ່ອງຂໍ້ມູນເຫຼົ່ານີ້ຫວ່າງເປົ່າ, ບໍ່ມີຫຍັງຈະຖືກໂອນຈາກ LDAP ແລະ ຄ່າເລີ່ມຕົ້ນຂອງ Moodle ຈະຖືກໃຊ້ແທນ.</p><p>ໃນກໍລະນີໃດກໍ່ຕາມ, ຜູ້ໃຊ້ຈະສາມາດແກ້ໄຂຊ່ອງຂໍ້ມູນເຫຼົ່ານີ້ທັງໝົດໄດ້ຫຼັງຈາກພວກເຂົາເຂົ້າສູ່ລະບົບ.</p>';
$string['auth_ldapnotinstalled'] = 'ບໍ່ສາມາດໃຊ້ການກວດສອບຄວາມຖືກຕ້ອງ LDAP ໄດ້. ໂມດູນ PHP LDAP ບໍ່ໄດ້ຖືກຕິດຕັ້ງ.';
$string['auth_ntlmsso'] = 'NTLM SSO';
$string['auth_ntlmsso_enabled'] = 'ຕັ້ງເປັນແມ່ນເພື່ອພະຍາຍາມເຂົ້າສູ່ລະບົບດຽວກັບໂດເມນ NTLM. ໃຫ້ສັງເກດວ່າສິ່ງນີ້ຕ້ອງການການຕິດຕັ້ງເພີ່ມເຕີມໃນເຊີບເວີເພື່ອເຮັດວຽກ. ສໍາລັບລາຍລະອຽດເພີ່ມເຕີມ, ເບິ່ງເອກະສານ <a href="https://docs.moodle.org/en/NTLM_authentication">NTLM authentication</a>.';
$string['auth_ntlmsso_enabled_key'] = 'ເປີດໃຊ້ງານ';
$string['auth_ntlmsso_ie_fastpath'] = 'ຕັ້ງໃຫ້ເປີດໃຊ້ເສັ້ນທາງໄວ NTLM SSO (ຂ້າມຂັ້ນຕອນທີ່ແນ່ນອນຖ້າຕົວທ່ອງເວັບຂອງລູກຄ້າແມ່ນ MS Internet Explorer).';
$string['auth_ntlmsso_ie_fastpath_attempt'] = 'ພະຍາຍາມ NTLM ກັບຕົວທ່ອງເວັບທັງໝົດ';
$string['auth_ntlmsso_ie_fastpath_key'] = 'ເສັ້ນທາງວ່ອງໄວ MS IE ບໍ?';
$string['auth_ntlmsso_ie_fastpath_yesattempt'] = 'ແມ່ນ, ພະຍາຍາມ NTLM ກັບຕົວທ່ອງເວັບອື່ນໆ';
$string['auth_ntlmsso_ie_fastpath_yesform'] = 'ແມ່ນ, ຕົວທ່ອງເວັບອື່ນໆທັງໝົດນຳໃຊ້ຮູບແບບການເຂົ້າສູ່ລະບົບມາດຕະຖານ';
$string['auth_ntlmsso_maybeinvalidformat'] = 'ບໍ່ສາມາດແຍກຊື່ຜູ້ໃຊ້ອອກຈາກສ່ວນຫົວ REMOTE_USER ໄດ້. ຮູບແບບທີ່ຖືກຕັ້ງຄ່າຖືກຕ້ອງບໍ?';
$string['auth_ntlmsso_missing_username'] = 'ທ່ານຕ້ອງລະບຸຢ່າງໜ້ອຍ %username% ໃນຮູບແບບຊື່ຜູ້ໃຊ້ທາງໄກ';
$string['auth_ntlmsso_remoteuserformat'] = 'ຖ້າທ່ານໄດ້ເລືອກ \'NTLM\' ໃນ \'ປະເພດການກວດສອບຄວາມຖືກຕ້ອງ\', ທ່ານສາມາດລະບຸຮູບແບບຊື່ຜູ້ໃຊ້ທາງໄກໄດ້ທີ່ນີ້. ຖ້າທ່ານປ່ອຍໃຫ້ສິ່ງນີ້ຫວ່າງເປົ່າ, ຮູບແບບ DOMAIN\\username ມາດຕະຖານຈະຖືກໃຊ້. ທ່ານສາມາດໃຊ້ຕົວຍຶດ <b>%domain%</b> ທາງເລືອກ ເພື່ອລະບຸບ່ອນທີ່ຊື່ໂດເມນປະກົດຂຶ້ນ, ແລະ ຕົວຍຶດ <b>%username%</b> ທີ່ບັງຄັບເພື່ອລະບຸບ່ອນທີ່ຊື່ຜູ້ໃຊ້ປະກົດຂຶ້ນ. <br /><br />ບາງຮູບແບບທີ່ໃຊ້ກັນຢ່າງກວ້າງຂວາງແມ່ນ <tt>%domain%\\%username%</tt> (MS Windows ຄ່າເລີ່ມຕົ້ນ), <tt>%domain%/%username%</tt>, <tt >%domain%+%username%</tt> ແລະ ພຽງແຕ່ <tt>%username%</tt> (ຖ້າບໍ່ມີສ່ວນຂອງໂດເມນ).';
$string['auth_ntlmsso_remoteuserformat_key'] = 'ຮູບແບບຊື່ຜູ້ໃຊ້ທາງໄກ';
$string['auth_ntlmsso_subnet'] = 'ຖ້າຕັ້ງ, ມັນຈະພະຍາຍາມ SSO ກັບລູກຄ້າໃນເຄືອຂ່າຍຍ່ອຍນີ້ເທົ່ານັ້ນ. ຮູບແບບ: xxx.xxx.xxx.xxx/bitmask. ແຍກຫຼາຍເຄືອຂ່າຍຍ່ອຍດ້ວຍ \',\' (ເຄື່ອງໝາຍຈຸດ).';
$string['auth_ntlmsso_subnet_key'] = 'ເຄືອຂ່າຍຍ່ອຍ';
$string['auth_ntlmsso_type'] = 'ວິທີການກວດສອບຄວາມຖືກຕ້ອງທີ່ກໍານົດຄ່າຢູ່ໃນເຊີເວີເວັບ ເພື່ອພິສູດຢືນຢັນຜູ້ໃຊ້ (ຖ້າສົງໃສ, ເລືອກ NTLM)';
$string['auth_ntlmsso_type_key'] = 'ປະເພດການກວດສອບຄວາມຖືກຕ້ອງ';
$string['cannotmaprole'] = 'ບົດບາດ "{$a->rolename}" ບໍ່ສາມາດຕັ້ງແຜນທີ່ໄດ້ ເພາະວ່າຊື່ສັ້ນຂອງມັນ "{$a->shortname}" ຍາວເກີນໄປ ແລະ/ຫຼື ມີຂີດໝາຍ. ເພື່ອອະນຸຍາດໃຫ້ມັນຖືກສ້າງແຜນທີ່, ຊື່ສັ້ນຈະຕ້ອງຖືກຫຼຸດລົງເປັນສູງສຸດ {$a->charlimit} ຕົວອັກສອນ ແລະ ຖືກຍັບຍັ້ງອອກ. <a href="{$a->link}">ແກ້ໄຂໜ້າທີ່</a>';
$string['connectingldap'] = 'ກຳລັງເຊື່ອມຕໍ່ໄປຫາເຊີເວີ LDAP...';
$string['connectingldapsuccess'] = 'ການເຊື່ອມຕໍ່ໄປຫາເຊີເວີ LDAP ສຳເລັດ';
$string['creatingtemptable'] = 'ກຳລັງສ້າຕາຕະລາງຊ່ວຄາວ {$a}';
$string['diag_contextnotfound'] = 'ບໍລິບົດ {$a} ບໍ່ມີ ຫຼື ບໍ່ສາມາດອ່ານໄດ້ໂດຍການຜູກມັດ DN.';
$string['diag_emptycontext'] = 'ພົບບໍລິບົດຫວ່າງເປົ່າ.';
$string['diag_genericerror'] = 'LDAP {$a->code} ອ່ານຜິດພາດ {$a->subject}: {$a->message}.';
$string['diag_rolegroupnotfound'] = 'ກຸ່ມ {$a->group} ສຳລັບໜ້າທີ່ {$a->localname} ບໍ່ມີຢູ່ ຫຼື ບໍ່ສາມາດອ່ານໄດ້ໂດຍການຜູກມັດ DN.';
$string['diag_toooldversion'] = 'ມັນເປັນໄປໄດ້ບໍ່ຫຼາຍທີ່ເຊີບເວີ LDAP ທີ່ທັນສະໄໝໃຊ້ລະບຽບການ LDAPv2. ການຕັ້ງຄ່າທີ່ບໍ່ຖືກຕ້ອງ ສາມາດເຮັດໃຫ້ຄ່າເສຍຫາຍໃນຊ່ອງຂໍ້ມູນຜູ້ໃຊ້. ກວດເບິ່ງກັບຜູ້ເບິ່ງແຍງລະບົບ LDAP ຂອງທ່ານ.';
$string['didntfindexpiretime'] = 'password_expire() ບໍ່ພົບເວລາໝົດອາຍຸ.';
$string['didntgetusersfromldap'] = 'ບໍ່ໄດ້ຮັບຜູ້ໃຊ້ໃດໆຈາກ LDAP -- ຜິດພາດ ບໍ? -- ທີ່ມີຢູ່';
$string['gotcountrecordsfromldap'] = 'ມີ {$a} ບັນທຶກຈາກ LDAP';
$string['invalidusererrors'] = 'ຄຳເຕືອນ: ຂ້າມການສ້າງບັນຊີຜູ້ໃຊ້ {$a}.';
$string['invaliduserexception'] = 'ຜິດພາດ: ບໍ່ສາມາດສ້າງບັນຊີຜູ້ໃຊ້ໃໝ່ໄດ້. ລາຍລະອຽດ ແລະ ເຫດຜົນ:
{$a}
ຂ້າມຜູ້ໃຊ້ນີ້.';
$string['ldapnotconfigured'] = 'url ເຈົ້າພາບ LDAP ບໍ່ໄດ້ຖືກຕັ້ງຄ່າໃນປັດຈຸບັນ';
$string['morethanoneuser'] = 'ພົບບັນທຶກຜູ້ໃຊ້ຫຼາຍກວ່າໜຶ່ງໃນ LDAP. ໃຊ້ພຽງແຕ່ອັນທໍາອິດ.';
$string['needbcmath'] = 'ທ່ານຕ້ອງການສ່ວນຂະຫຍາຍ BCMath ເພື່ອໃຊ້ການກວດສອບລະຫັດຜ່ານທີ່ໝົດອາຍຸດ້ວຍ
 ບັນຊີລາຍການທີ່ເປີດໃຊ້.';
$string['needmbstring'] = 'ທ່ານຕ້ອງການສ່ວນຂະຫຍາຍ mbstring ເພື່ອປ່ຽນລະຫັດຜ່ານໃນ ບັນຊີລາຍການທີ່ເປີດໃຊ້';
$string['nodnforusername'] = 'ຜິດພາດໃນ user_update_password(). ບໍ່ມີ DN ສໍາລັບ: {$a->username}';
$string['noemail'] = 'ພະຍາຍາມສົ່ງອີເມລຫາທ່ານແຕ່ບໍ່ສຳເລັດ!';
$string['notcalledfromserver'] = 'ບໍ່ຄວນຖືກເອີ້ນຈາກເຊີເວີເວັບ!';
$string['noupdatestobedone'] = 'ບໍ່ມີການປັບປຸງທີ່ສຳເລັດ';
$string['nouserentriestoremove'] = 'ບໍ່ມີລາຍການຜູ້ໃຊ້ທີ່ຈະເອົາອອກ';
$string['nouserentriestorevive'] = 'ບໍ່ມີລາຍການຜູ້ໃຊ້ທີ່ຈະໄດ້ແກ້ໄຂ';
$string['nouserstobeadded'] = 'ບໍ່ມີລາຍການຜູ້ໃຊ້ທີ່ຈະໄດ້ເພີ່ມ';
$string['ntlmsso_attempting'] = 'ກຳລັງພະຍາຍາມລົງນາມດຽວຜ່ານ NTLM...';
$string['ntlmsso_failed'] = 'ເຂົ້າສູ່ລະບົບອັດຕະໂນມັດລົ້ມເຫຼວ, ລອງໃຊ້ໜ້າເຂົ້າສູ່ລະບົບປົກກະຕິ...';
$string['ntlmsso_isdisabled'] = 'NTLM SSO ແມ່ນປິດໃຊ້ງານ';
$string['ntlmsso_unknowntype'] = 'ປະເພດ ntlmsso ທີ່ບໍ່ຮູ້ຈັກ!';
$string['pagedresultsnotsupp'] = 'ບໍ່ຮອງຮັບຜົນການຊອກຫາໜ້າ LDAP (ບໍ່ວ່າເວີຊັນ PHP ຂອງທ່ານຂາດການຮອງຮັບ, ທ່ານໄດ້ກຳນົດຄ່າ Moodle ໃຫ້ໃຊ້ລະບຽບການ LDAP ສະບັບ 2 ຫຼື Moodle ບໍ່ສາມາດຕິດຕໍ່ເຊີບເວີ LDAP ເພື່ອເບິ່ງວ່າມີໜ້າທີ່ຮອງຮັບຫຼືບໍ່).';
$string['pagesize'] = 'ໃຫ້ແນ່ໃຈວ່າຄ່ານີ້ນ້ອຍກວ່າຜົນຂອງເຊີບເວີ LDAP ຂອງເຈົ້າກໍານົດຂະໜາດຈໍາກັດ (ຈໍານວນສູງສຸດຂອງລາຍການທີ່ສາມາດສົ່ງຄືນໄດ້ໃນຄໍາຖາມດຽວ)';
$string['pagesize_key'] = 'ຂະໜາດໜ້າ';
$string['pluginname'] = 'ເຊີເວີ LDAP';
$string['pluginnotenabled'] = 'ປລັກອິນບໍ່ໄດ້ເປີດໃຊ້ງານ!';
$string['privacy:metadata'] = 'ປລັກອິນການກວດສອບຄວາມຖືກຕ້ອງຂອງເຊີບເວີ LDAP ບໍ່ໄດ້ເກັບຮັກສາຂໍ້ມູນສ່ວນຕົວໃດໆ.';
$string['renamingnotallowed'] = 'ການປ່ຽນຊື່ໃໝ່ຜູ້ໃຊ້ບໍ່ອະນຸຍາດໃນ LDAP';
$string['rootdseerror'] = 'ເກີດຄວາມຜິດພາດໃນການສອບຖາມ rootDSE ສໍາລັບ ບັນຊີລາຍການທີ່ເປີດໃຊ້';
$string['start_tls'] = 'ໃຊ້ບໍລິການ LDAP ປົກກະຕິ (ພອດ 389) ດ້ວຍການເຂົ້າລະຫັດ TLS';
$string['start_tls_key'] = 'ນຳໃຊ້ TLS';
$string['syncroles'] = 'ໜ້າທີ່ລະບົບປະສານຈາກ LDAP';
$string['synctask'] = 'ວຽກການຊິ້ງຜູ້ໃຊ້ LDAP';
$string['systemrolemapping'] = 'ການສ້າງແຜນທີ່ໜ້າທີ່ລະບົບ';
$string['updatepasserror'] = 'ຜິດພາດໃນ user_update_password(). ລະຫັດຜິດພາດ: {$a->errno}; ສະຕຣິງຜິດພາດ: {$a->errstring}';
$string['updatepasserrorexpire'] = 'ຜິດພາດໃນ user_update_password() ເມື່ອອ່ານລະຫັດຜ່ານເວລາໝົດອາຍຸ. ລະຫັດຜິດພາດ: {$a->errno}; ສະຕຣິງຜິດພາດ: {$a->errstring}';
$string['updatepasserrorexpiregrace'] = 'ຜິດພາດໃນ user_update_password() ເມື່ອແກ້ໄຂເວລາໝົດອາຍຸ ແລະ/ຫຼື ການເຂົ້າສູ່ລະບົບແບບຍົກເວັ້ນ. ລະຫັດຜິດພາດ: {$a->errno}; ສະຕຣິງຜິດພາດ: {$a->errstring}';
$string['updateremfail'] = 'ເກີດຄວາມຜິດພາດໃນການປັບປຸງບັນທຶກ LDAP. ລະຫັດຂໍ້ຜິດພາດ: {$a->errno}; ສະຕຣິງຜິດພາດ: {$a->errstring}<br/>Key ({$a->key}) - ຄ່າ moodle ເກົ່າ: \'{$a->ouvalue}\' ຄ່າໃໝ່: \'{$a->nuvalue}\'';
$string['updateremfailamb'] = 'ລົ້ມເຫຼວໃນການອັບເດດ LDAP ດ້ວຍຊ່ອງຂໍ້ມູນທີ່ບໍ່ຊັດເຈນ {$a->key}; ມູນຄ່າອາລົມເກົ່າ: \'{$a->ouvalue}\', ຄ່າໃໝ່: \'{$a->nuvalue}\'';
$string['updateusernotfound'] = 'ບໍ່ສາມາດຊອກຫາຜູ້ໃຊ້ໃນຂະນະທີ່ປັບປຸງພາຍນອກ. ລາຍລະອຽດປະຕິບັດຕາມ: ພື້ນຖານການຄົ້ນຫາ: \'{$a->userdn}\'; ຕົວກັ່ນຕອງຄົ້ນຫາ: \'(objectClass=*)\'; ຄຸນລັກສະນະການຄົ້ນຫາ: {$a->attribs}';
$string['user_activatenotsupportusertype'] = 'auth: ldap user_disable() ບໍ່ຮອງຮັບ usertype ທີ່ເລືອກ: {$a}';
$string['user_disablenotsupportusertype'] = 'auth: ldap user_disable() ບໍ່ຮອງຮັບ usertype ທີ່ເລືອກ: {$a}';
$string['useracctctrlerror'] = 'ເກີດຄວາມຜິດພາດໃນການຮັບເອົາ userAccountControl ສໍາລັບ {$a}';
$string['userentriestoadd'] = 'ລາຍຊື່ຜູ້ໃຊ້ທີ່ຈະເພີ່ມ: {$a}';
$string['userentriestoremove'] = 'ລາຍຊື່ຜູ້ໃຊ້ທີ່ຈະເອົາອອກ: {$a}';
$string['userentriestorevive'] = 'ລາຍຊື່ຜູ້ໃຊ້ທີ່ຈະເບິ່ງ: {$a}';
$string['userentriestoupdate'] = 'ລາຍຊື່ຜູ້ໃຊ້ທີ່ຈະປັບປຸງ: {$a}';
$string['usernotfound'] = 'ບໍ່ພົບຜູ້ໃຊ້ໃນ LDAP';
