<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'local_moodlemobileapp', language 'ar', version '4.5'.
 *
 * @package     local_moodlemobileapp
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['addon.block_myoverview.browseallcourses'] = 'استعراض كل المقررات';
$string['addon.block_myoverview.nocoursesenrolled'] = 'لستَ منضمًا إلى أي مقرر بعد.';
$string['addon.block_myoverview.nocoursesenrolleddescription'] = 'استعرض كل المقررات المتاحة أدناه وابدأ بالتعلم.';
$string['addon.block_myoverview.noresult'] = 'بحثك لم يُطابق أي مساق.';
$string['addon.block_myoverview.noresultdescription'] = 'حاول تعديل المرشحات أو استعرض كل المقررات أدناه.';
$string['addon.blog.errorloadentries'] = 'خطأ عند تحميل مدخلات المدونة.';
$string['addon.blog.showonlyyourentries'] = 'إظهار مدخلاتك فقط';
$string['addon.calendar.calendarevent'] = 'حَدَث التقويم';
$string['addon.calendar.calendarevents'] = 'أحداث التقويم';
$string['addon.calendar.calendarreminders'] = 'تذكيرات التقويم';
$string['addon.calendar.currentmonth'] = 'الشهر الحالي';
$string['addon.calendar.defaultnotificationtime'] = 'الوقت الافتراضي للإشعار';
$string['addon.calendar.errorloadevent'] = 'خطأ عند تحميل الحدث.';
$string['addon.calendar.errorloadevents'] = 'خطأ عند تحميل الأحداث.';
$string['addon.calendar.monthlyview'] = 'المعاينة الشهرية';
$string['addon.calendar.noevents'] = 'لا توجد أي أحداث';
$string['addon.calendar.reminders'] = 'التذكيرات';
$string['addon.calendar.setnewreminder'] = 'ضع تذكيراً جديداً';
$string['addon.competency.errornocompetenciesfound'] = 'لا توجد أي كفاءات';
$string['addon.competency.nocompetencies'] = 'لا توجد أي كفاءات';
$string['addon.coursecompletion.complete'] = 'مكتمل';
$string['addon.coursecompletion.couldnotloadreport'] = 'لا يمكن تحميل تقرير إكمال المساق، الرجاء المحاولة في وقت آخر';
$string['addon.enrol_self.confirmselfenrol'] = 'هل أنت متأكد من رغبتك في الانضمام إلى هذا المساق؟';
$string['addon.enrol_self.errorselfenrol'] = 'وقع خطأ ما عند الانضمام الذاتي';
$string['addon.messageoutput_airnotifier.processorsettingsdesc'] = 'تهيئة الأجهزة';
$string['addon.messageoutput_airnotifier.pushdisabledwarning'] = 'المستخدمون لا يتلقون أي إشعارات من هذا الموقع في جوالاتهم. قم بتمكين إشعارات الجوال من صفحة إعدادات الإشعارات.';
$string['addon.messages.contactlistempty'] = 'قائمة عناوين الاتصال فارغة';
$string['addon.messages.contactname'] = 'اسم عنوان الاتصال';
$string['addon.messages.deletemessage'] = 'حذف الرسالة';
$string['addon.messages.deletemessageconfirmation'] = 'هل أنت متأكد من رغبتك في حذف هذه الرسالة؟ سيتم حذفها فقط من ماضي رسائلك وسبقى مرئية من جهة المستخدم الذي أرسلها أو تلقاها.';
$string['addon.messages.errordeletemessage'] = 'خطأ عند حذف الرسالة.';
$string['addon.messages.errorwhileretrievingcontacts'] = 'خطأ عند استرجاع عناوين الاتصال من المخدم.';
$string['addon.messages.errorwhileretrievingdiscussions'] = 'خطأ عند استرجاع المناقشات من المخدم.';
$string['addon.messages.errorwhileretrievingmessages'] = 'خطأ عند استرجاع الرسائل من المخدم.';
$string['addon.messages.errorwhileretrievingusers'] = 'خطأ عند استرجاع المستخدمين من المخدم.';
$string['addon.messages.messagenotsent'] = 'لم يتم إرسال الرسالة. ترجى المحاولة لاحقًا.';
$string['addon.messages.newmessages'] = 'الرسائل الجديدة';
$string['addon.messages.nousersfound'] = 'لا يوجد مستخدمون';
$string['addon.messages.showdeletemessages'] = 'إظهار حذف الرسائل';
$string['addon.messages.type_blocked'] = 'محظور';
$string['addon.messages.type_offline'] = 'غير متصل';
$string['addon.messages.type_online'] = 'متصل';
$string['addon.messages.type_search'] = 'نتائج البحث';
$string['addon.messages.type_strangers'] = 'رسائل أخرى';
$string['addon.messages.useentertosenddescdesktop'] = 'عند تعطيله، يمكنك استعمال Ctrl+Enter لإرسال الرسالة.';
$string['addon.messages.useentertosenddescmac'] = 'عند تعطيله، يمكنك استعمال Cmd+Enter لإرسال الرسالة.';
$string['addon.messages.warningconversationmessagenotsent'] = 'تعذر إرسال الرسالة/الرسائل إلى المحادثة {{conversation}}. {{error}}';
$string['addon.messages.warningmessagenotsent'] = 'تعذر إرسال الرسالة/الرسائل إلى المستخدم {{user}}. {{error}}';
$string['addon.mod_assign.acceptsubmissionstatement'] = 'يرجى قبول بيان التسليم.';
$string['addon.mod_assign.allowsubmissionsanddescriptionfromdatesummary'] = 'تفاصيل الواجب ونموذج التسليم سيكونان متاحين من <strong>{{$a}}</strong>';
$string['addon.mod_assign.allowsubmissionsfromdatesummary'] = 'الواجب سيقبل التسليم من <strong>{{$a}}</strong>';
$string['addon.mod_assign.cannoteditduetostatementsubmission'] = 'لا يمكنك إضافة التسليم في التطبيق أو تحريره لأن بيان التسليم تعذر استرجاعه من الموقع.';
$string['addon.mod_assign.cannotgradefromapp'] = 'بعض طرق منح التقديرات غير مدعومة حتى الآن من قبل التطبيق ولا يمكن تعديلها.';
$string['addon.mod_assign.cannotsubmitduetostatementsubmission'] = 'لا يمكنك إجراء التسليم من التطبيق لأن بيان التسليم تعذر استرجاعه من الموقع.';
$string['addon.mod_assign.duedateno'] = 'لا تاريخ استيجاب';
$string['addon.mod_assign.erroreditpluginsnotsupported'] = 'لا يمكنك إضافة التسليم أو تحريره من التطبيق لأن بعض الإضافات لا تزال غير مدعومة لأغراض التحرير.';
$string['addon.mod_assign.errorshowinginformation'] = 'لا يمكن عرض معلومات التسليم.';
$string['addon.mod_assign.feedbacknotsupported'] = 'هذه الإفادة غير مدعومة من قبل التطبيق وقد لا تحتوي على كل المعلومات.';
$string['addon.mod_assign.gradenotsynced'] = 'الدرجة غير مُزامَنة';
$string['addon.mod_assign.notallparticipantsareshown'] = 'المشاركون الذين لم يقدموا التسليم غير ظاهرين.';
$string['addon.mod_assign.numberofdraftsubmissionscountdescription'] = 'هناك {{count}} من المسودات.';
$string['addon.mod_assign.numberofparticipantscountdescription'] = 'هناك {{count}} من المشاركين.';
$string['addon.mod_assign.numberofsubmissionsneedgradingcountdescription'] = 'هناك {{count}} من التسليمات التي بحاجة إلى تقييم.';
$string['addon.mod_assign.numberofsubmittedassignmentscountdescription'] = 'هناك {{count}} من الواجبات المسلَّمة.';
$string['addon.mod_assign.numberofteamscountdescription'] = 'هناك {{count}} من الفِرق.';
$string['addon.mod_assign.submissionnotsupported'] = 'هذا التسليم غير مدعوم من قبل التطبيق وقد لا يحتوي على كل المعلومات.';
$string['addon.mod_assign.syncblockedusercomponent'] = 'علامة المستخدم';
$string['addon.mod_assign.warningsubmissiongrademodified'] = 'علامة التسليم قد تم تعديلها في الموقع.';
$string['addon.mod_assign.warningsubmissionmodified'] = 'تسليم المستخدم قد تم تعديله في الموقع.';
$string['addon.mod_chat.confirmloss'] = 'هل أنت متأكد؟ يمكن فقدان ماضي المحادثة.';
$string['addon.mod_chat.errorwhileconnecting'] = 'خطأ عند الاتصال بالدردشة.';
$string['addon.mod_chat.errorwhilegettingchatdata'] = 'خطأ عند الحصول على معلومات الدردشة.';
$string['addon.mod_chat.errorwhilegettingchatusers'] = 'خطأ عند الحصول على مستخدمي الدردشة.';
$string['addon.mod_chat.errorwhileretrievingmessages'] = 'خطأ عند استرجاع الرسائل من المخدم.';
$string['addon.mod_chat.errorwhilesendingmessage'] = 'خطأ عند إرسال الرسالة.';
$string['addon.mod_chat.mustbeonlinetosendmessages'] = 'ينبغي أن تكون متصلاً بالإنترنت لإرسال الرسائل.';
$string['addon.mod_chat.nosessionsfound'] = 'لم يتم العثور على أي جلسات';
$string['addon.mod_chat.showincompletesessions'] = 'إظهار الجلسات غير المكتملة';
$string['addon.mod_choice.errorgetchoice'] = 'خطأ عند جلب بيانات الاختيار.';
$string['addon.mod_choice.responsesresultgraphdescription'] = '{{number}}% من المستخدمين إختاروا الخيار: {{text}}.';
$string['addon.mod_choice.resultsnotsynced'] = 'استجابتك الأخيرة تنبغي مزامنتها قبل تضمينها في النتائج.';
$string['addon.mod_data.edittagsnotsupported'] = 'عذراً، تحرير الوسوم غير مدعوم من قبل التطبيق.';
$string['addon.mod_data.errorapproving'] = 'خطأ عند الموافقة على المصطلح أو إلغاء الموافقة عليه.';
$string['addon.mod_data.errordeleting'] = 'خطأ عند حذف المصطلح.';
$string['addon.mod_data.gettinglocation'] = 'جلب الموضع';
$string['addon.mod_data.locationnotenabled'] = 'الموضع غير مُمَكَّن';
$string['addon.mod_data.locationpermissiondenied'] = 'قد تم رفض منح الصلاحية للوصول إلى موضعك.';
$string['addon.mod_data.mylocation'] = 'موضعي';
$string['addon.mod_data.searchbytagsnotsupported'] = 'عذراً، البحث في الوسوم غير مدعوم من قبل التطبيق.';
$string['addon.mod_feedback.captchaofflinewarning'] = 'لا يمكن إكمال الإفادة مع استعمال CAPTCHA بدون الاتصال بالإنترنت، أو لم تتم تهيئته أو أن المخدم مُطفأ.';
$string['addon.mod_feedback.completedfeedbackscountdescription'] = 'هناك {{count}} من الإجابات المسلَّمة.';
$string['addon.mod_feedback.feedback_submitted_offline'] = 'قد تم حفظ هذه الإفادة لتسليمها لاحقاً.';
$string['addon.mod_feedback.questionscountdescription'] = 'هناك {{count}} من الأسئلة.';
$string['addon.mod_folder.emptyfilelist'] = 'لا توجد أي ملفات لإظهارها.';
$string['addon.mod_forum.errorgetforum'] = 'خطأ عند جلب بيانات المنتدى.';
$string['addon.mod_forum.errorgetgroups'] = 'خطأ عند جلب إعدادات المجموعة.';
$string['addon.mod_forum.errorloadingsortingorder'] = 'المنتدى غير متاح بترتيب الفرز هذا';
$string['addon.mod_forum.errorloadingsortingorderdetails'] = 'حاول تغيير ترتيب الفرز أو الاتصال بالإنترنت لمعاينة هذا المنتدى.';
$string['addon.mod_forum.errorposttoallgroups'] = 'تعذر إنشاء مناقشة جديدة في كل المجموعات.';
$string['addon.mod_forum.forumnodiscussionsyet'] = 'لا توجد مناقشات بعد في هذا المنتدى.';
$string['addon.mod_forum.group'] = 'المجموعة';
$string['addon.mod_forum.numdiscussions'] = '{{numdiscussions}} من المناقشات';
$string['addon.mod_forum.numreplies'] = '{{numreplies}} من الردود';
$string['addon.mod_forum.postingroup'] = 'النشر في مجموعة "{{groupname}}".';
$string['addon.mod_forum.refreshposts'] = 'تنشيط المنشورات';
$string['addon.mod_glossary.browsemode'] = 'استعراض المصطلحات';
$string['addon.mod_glossary.byalphabet'] = 'أبجدياً';
$string['addon.mod_glossary.byauthor'] = 'التجميع حسب المؤلف';
$string['addon.mod_glossary.bycategory'] = 'التجميع حسب التصنيف';
$string['addon.mod_glossary.bynewestfirst'] = 'الأحدث أولاً';
$string['addon.mod_glossary.byrecentlyupdated'] = 'تم تحديثه مؤخرًا';
$string['addon.mod_glossary.bysearch'] = 'بحث';
$string['addon.mod_glossary.cannoteditentry'] = 'لا يمكن تحرير المصطلح';
$string['addon.mod_glossary.entriestobesynced'] = 'المصطلحات المزمعة مزامنتها';
$string['addon.mod_glossary.entrypendingapproval'] = 'هذا المصطلح ينتظر الموافقة.';
$string['addon.mod_glossary.errordeleting'] = 'وقع خطأ عند حذف الإدخال.';
$string['addon.mod_glossary.errorloadingentries'] = 'وقع خطأ عند تحميل المصطلحات.';
$string['addon.mod_glossary.errorloadingentry'] = 'وقع خطأ عند تحميل المصطلح.';
$string['addon.mod_glossary.errorloadingglossary'] = 'وقع خطأ عند تحميل قاموس المصطلحات.';
$string['addon.mod_glossary.noentriesfound'] = 'لم يتم العثور على أي مصطلحات.';
$string['addon.mod_glossary.searchquery'] = 'عبارة البحث';
$string['addon.mod_h5pactivity.downloadh5pfile'] = 'تنزيل ملف H5P';
$string['addon.mod_h5pactivity.errorgetactivity'] = 'خطأ عند جلب بيانات نشاط H5P.';
$string['addon.mod_h5pactivity.filestatenotdownloaded'] = 'رزمة H5P غير منزلة. عليك تنزيلها لتتمكن من استعمالها.';
$string['addon.mod_h5pactivity.filestateoutdated'] = 'لقد تم تعديل رزمة H5P منذ آخر تنزيل لها. عليك تنزيلها مجدداً لتتمكن من استعمالها.';
$string['addon.mod_h5pactivity.numberofattempts'] = '{{$a}} من المحاولات';
$string['addon.mod_h5pactivity.offlinedisabledwarning'] = 'ينبغي أن تكون متصلاً بالإنترنت لمعاينة رزمة H5P .';
$string['addon.mod_h5pactivity.viewattempt'] = 'معاينة المحاولة {{$a}}';
$string['addon.mod_imscp.showmoduledescription'] = 'إظهار الوصف';
$string['addon.mod_lesson.errorprefetchrandombranch'] = 'هذا الدرس يحتوي على قفزة عشوائية إلى صفحة محتوى. لا يمكن محاولته من التطبيق حتى يتم الشروع به من مستعرض الويب.';
$string['addon.mod_lesson.errorreviewretakenotlast'] = 'لم يعد بالإمكان مراجعة هذه المحاولة لأن محاولة أخرى قد تم إنهاؤها.';
$string['addon.mod_lesson.finishretakeoffline'] = 'تم إنهاء هذه المحاولة بدون الاتصال بالإنترنت.';
$string['addon.mod_lesson.retakefinishedinsync'] = 'تمت مزامنة محاولة جرت بدون الاتصال. هل ترغب بمراجعتها؟';
$string['addon.mod_lesson.retakelabelfull'] = '{{retake}}: {{grade}} {{timestart}} ({{duration}})';
$string['addon.mod_lesson.retakelabelshort'] = '{{retake}}: {{grade}} {{timestart}}';
$string['addon.mod_lesson.warningretakefinished'] = 'تم إنهاء المحاولة في الموقع.';
$string['addon.mod_lti.errorgetlti'] = 'خطأ عند جلب بيانات الوحدة.';
$string['addon.mod_lti.errorinvalidlaunchurl'] = 'عنوان رابط الإطلاق غير صحيح.';
$string['addon.mod_lti.launchactivity'] = 'إطلاق النشاط';
$string['addon.mod_page.errorwhileloadingthepage'] = 'خطأ عند تحميل محتوى الصفحة.';
$string['addon.mod_quiz.canattemptbutnotsubmit'] = 'يمكنك محاولة هذا الاختبار في التطبيق، ولكن ستضطر إلى تسليمها عبر المستعرض للأسباب الآتية:';
$string['addon.mod_quiz.cannotsubmitquizdueto'] = 'محاولة هذا الاختبار لا يمكن تسليمها للأسباب الآتية:';
$string['addon.mod_quiz.confirmcontinueoffline'] = 'لم تتم مزامنة هذه المحاولة منذ {{$a}}. إذا قمت بإكمال هذه المحاولة من جهاز آخر منذ ذلك الحين، فقد تخسر بياناتك.';
$string['addon.mod_quiz.confirmleavequizonerror'] = 'وقع خطأ عند حفظ الإجابات. هل أنت متأكد من رغبتك في ترك الاختبار؟';
$string['addon.mod_quiz.errorbehaviournotsupported'] = 'لا يمكن محاولة هذا الاختبار من التطبيق لأن سلوك الأسئلة غير مدعوم من قبل التطبيق:';
$string['addon.mod_quiz.errordownloading'] = 'خطأ عن تنزيل البيانات المطلوبة.';
$string['addon.mod_quiz.errorgetattempt'] = 'خطأ عند جلب بيانات المحاولة.';
$string['addon.mod_quiz.errorgetquestions'] = 'خطأ عند جلب الأسئلة.';
$string['addon.mod_quiz.errorgetquiz'] = 'خطأ عند الحصول على بيانات الاختبار.';
$string['addon.mod_quiz.errorparsequestions'] = 'وقع خطأ عند قراءة الأسئلة. لطفاً، حاول هذا الاختبار في مستعرض الويب.';
$string['addon.mod_quiz.errorquestionsnotsupported'] = 'لا يمكن محاولة هذا الاختبار من التطبيق لأنه يضم فقط أسئلة غير مدعومة في التطبيق:';
$string['addon.mod_quiz.errorrulesnotsupported'] = 'لا يمكن محاولة هذا الاختبار من التطبيق لأن فيه قواعد وصول غير مدعومة من قبل التطبيق:';
$string['addon.mod_quiz.errorsaveattempt'] = 'وقع خطأ عند حفظ بيانات المحاولة.';
$string['addon.mod_quiz.finishedofflinenotice'] = 'محاولتك قد تم تسليمها وحفظها. ستُرسل إلى الموقع عندما تتصل بالإنترنت مرة أخرى.';
$string['addon.mod_quiz.finishnotsynced'] = 'منتهٍ ولكنه غير مُزامَن';
$string['addon.mod_quiz.opentoc'] = 'فتح التنقل المنبثق';
$string['addon.mod_quiz.warningattemptfinished'] = 'تم إهمال المحاولة التي جرت بدون الاتصال بالإنترنت نظراً لإكمالها عبر الموقع مباشرة أو لأنه لم يتم العثور عليها.';
$string['addon.mod_quiz.warningdatadiscarded'] = 'بعض المحاولات التي جرت بدون الاتصال بالإنترنت تم إهمالها نظراً لتعديل الأسئلة عبر الموقع مباشرة.';
$string['addon.mod_quiz.warningdatadiscardedfromfinished'] = 'المحاولة لم يتم إنهاؤها بسبب إهمال بعض الأسئلة التي كانت بدون الاتصال بالإنترنت. لطفاً، راجع إجاباتك ثم أعد تسليم المحاولة.';
$string['addon.mod_quiz.warningquestionsnotsupported'] = 'هذا الاختبار يحتوي على أسئلة غير مدعومة من قبل التطبيق:';
$string['addon.mod_resource.errorwhileloadingthecontent'] = 'خطأ عند تحميل المحتوى.';
$string['addon.mod_resource.openthefile'] = 'فتح';
$string['addon.mod_resource.resourcestatusoutdated'] = 'لقد تغير الملف منذ فتحك الأخير له.';
$string['addon.mod_resource.resourcestatusoutdatedconfirm'] = 'هناك نسخة أحدث من هذا الملف. لمشاهدتها، يرجى توصيل جهازك بالإنترنت.';
$string['addon.mod_scorm.cannotcalculategrade'] = 'لا يمكن حساب الدرجة.';
$string['addon.mod_scorm.dataattemptshown'] = 'هذه البيانات تعود للمحاولة المرقمة {{number}}.';
$string['addon.mod_scorm.errorcreateofflineattempt'] = 'وقع خطأ عند إنشاء محاولة جديدة بدون الاتصال. يرجى المحاولة مجدداً.';
$string['addon.mod_scorm.errordownloadscorm'] = 'خطأ عند تنزيل السكورم: "{{name}}"';
$string['addon.mod_scorm.errorgetscorm'] = 'خطأ عند جلب بيانات سكورم.';
$string['addon.mod_scorm.errorinvalidversion'] = 'عذراً، التطبيق يدعم سكورم، الإصدار 1.2 فقط.';
$string['addon.mod_scorm.errornotdownloadable'] = 'تم تعطيل تنزيل حزم سكورم من قبل مدرستك، شركتك، مؤسستك أو مزود الخدمات التعليمية لديك.';
$string['addon.mod_scorm.errornovalidsco'] = 'حزمة سكورم هذه لا تحتوي على مكون محتوى قابل للمشاركة مرئي ليتم تحميله.';
$string['addon.mod_scorm.errorpackagefile'] = 'عذراً، التطبيق يدعم فقط رزم ZIP.';
$string['addon.mod_scorm.errorsyncscorm'] = 'وقع خطأ عند المزامنة. ترجى المحاولة مجدداً.';
$string['addon.mod_scorm.offlineattemptnote'] = 'هذه المحاولة تحوي بيانات لم تتم مزامنتها بعد.';
$string['addon.mod_scorm.offlineattemptovermax'] = 'لا يمكن إرسال هذه المحاولة لأنك تجاوزت العدد الأقصى من المحاولات.';
$string['addon.mod_scorm.scormstatusnotdownloaded'] = 'لم يتم تنزيل حزمة سكورم هذه. سيتم تنزيلها تلقائياً عندما تفتحها.';
$string['addon.mod_scorm.scormstatusoutdated'] = 'تم تحديث حزمة سكورم هذه منذ آخر تنزيل لها. سيتم تنزيلها تلقائياً عندما تفتحها.';
$string['addon.mod_scorm.warningofflinedatadeleted'] = 'تم التخلص من بعض البيانات التي بدون الاتصال للمحاولة {{number}} لعدم إمكانية إحتسابها كمحاولة جديدة.';
$string['addon.mod_scorm.warningsynconlineincomplete'] = 'تعذرت مزامنة بعض المحاولات مع الموقع لأن آخر محاولة مع الاتصال غير منتهية حتى الآن. لطفاً، أنهِ المحاولة ذات الاتصال بالإنترنت أولاً.';
$string['addon.mod_survey.cannotsubmitsurvey'] = 'عذراً، وقع خطأ عند تسليم استبيانك. ترجى المحاولة مجدداً.';
$string['addon.mod_survey.errorgetsurvey'] = 'خطأ عند جلب بيانات الاستبيان.';
$string['addon.mod_survey.results'] = 'النتائج';
$string['addon.mod_url.accessurl'] = 'الوصول إلى الرابط';
$string['addon.mod_url.pointingtourl'] = 'عنوان الرابط الذي يشير إليه المورد.';
$string['addon.mod_wiki.errorloadingpage'] = 'وقع خطأ عند تحميل الصفحة.';
$string['addon.mod_wiki.errornowikiavailable'] = 'لا يوجد أي محتوى في هذا الويكي بعد.';
$string['addon.mod_wiki.gowikihome'] = 'إذهب إلى الصفحة الأولى في الويكي';
$string['addon.mod_wiki.subwiki'] = 'ويكي فرعي';
$string['addon.mod_wiki.titleshouldnotbeempty'] = 'العنوان ينبغي أن لا يكون فارغاً';
$string['addon.mod_wiki.viewpage'] = 'معاينة الصفحة';
$string['addon.mod_wiki.wikipage'] = 'صفحة الويكي';
$string['addon.mod_workshop.assessmentstrategynotsupported'] = 'استراتيجية التقييم {{$a}} غير مدعومة';
$string['addon.mod_workshop.submissionrequiredtitle'] = 'عليك إدخال العنوان.';
$string['addon.mod_workshop.warningassessmentmodified'] = 'تم تعديل التسليم في الموقع.';
$string['addon.mod_workshop.warningsubmissionmodified'] = 'تم تعديل التقييم في الموقع.';
$string['addon.notes.warningnotenotsent'] = 'تعذرت إضافة الملاحظات أو حذفها. {{error}}';
$string['addon.notifications.allownotifications'] = 'السماح بالإشعارات';
$string['addon.notifications.errorgetnotifications'] = 'خطأ عند جلب الإشعارات.';
$string['addon.notifications.notifications'] = 'الإشعارات';
$string['addon.notifications.playsound'] = 'تشغيل الصوت';
$string['addon.notifications.therearentnotificationsyet'] = 'لا توجد إشعارات.';
$string['addon.notifications.typeofnotification'] = 'نوع الإشعار';
$string['addon.privatefiles.couldnotloadfiles'] = 'تعذر تحميل قائمة الملفات.';
$string['addon.privatefiles.emptyfilelist'] = 'ليس هناك ملفات لإظهارها.';
$string['addon.privatefiles.erroruploadnotworking'] = 'للأسف، ليس بالإمكان حاليًا رفع الملفات إلى موقعك.';
$string['addon.storagemanager.confirmdeleteallsitedata'] = 'أتريد حذف كل البيانات المنزلة من الموقع؟';
$string['addon.storagemanager.confirmdeletecourses'] = 'أتريد حذف البيانات المنزلة من كل المقررات؟';
$string['addon.storagemanager.confirmdeletedatafrom'] = 'أتريد حذف البيانات المنزلة من \'{{name}}\'؟';
$string['addon.storagemanager.coursedownloads'] = 'تنزيلات المساق';
$string['addon.storagemanager.courseinfo'] = 'تنزيل محتوى المساق ليعمل عندك بدون الاتصال بالإنترنت. ستتم مزامنة نشاطاتك تلقائيًا بمجرد عودة جهازك إلى الاتصال.';
$string['addon.storagemanager.deleteallsitedata'] = 'حذف كل البيانات المنزلة من الموقع';
$string['addon.storagemanager.deleteallsitedatainfo'] = 'هذا سيؤدي إلى حذف كل البيانات المنزلة من \'{{name}}\'، بما في ذلك كل المقررات المنزلة والبيانات التي تسمح لك بالعمل عليه بدون الاتصال بالإنترنت.';
$string['addon.storagemanager.deletecourses'] = 'تفريف كل بيانات المقررات الدراسية';
$string['addon.storagemanager.deletedata'] = 'حذف البيانات المنزلة';
$string['addon.storagemanager.deletedatafrom'] = 'حذف البيانات المنزلة من \'{{name}}\'؟';
$string['addon.storagemanager.downloaddatafrom'] = 'تنزيل {{name}}';
$string['addon.storagemanager.downloadedcourses'] = 'المقررات المنزلة';
$string['addon.storagemanager.downloads'] = 'التنزيلات';
$string['addon.storagemanager.errordeletedownloadeddata'] = 'خطأ عند حذف البيانات المنزلة.';
$string['addon.storagemanager.managedownloads'] = 'إدارة التنزيلات';
$string['addon.storagemanager.totaldownloads'] = 'إجمالي التنزيلات';
$string['addon.storagemanager.totalspaceusage'] = 'إجمالي المساحة المستعملة';
$string['addon.tinymce.enabletinymceeditor'] = 'استعمال محرر النصوص TinyMCE';
$string['addon.tinymce.enabletinymceeditordescription'] = 'محرر نصوص متقدم ذي ميزات تنسيق إضافية.';
$string['addon.tinymce.license'] = 'مؤسسة Moodle Pty Ltd قد مُنحت رخصة تجارية من TinyMCE متوافقة مع رخصة Apache 2.0.';
$string['appstoredescription'] = 'ملحوظة: تطبيق نظام مودل الرسمي هذا سيعمل فقط مع مواقع نظم التعلم الإلكتروني مودل التي تم إعدادها للسماح بذلك. إذا صادفتك أي مشاكل في الاتصال، من فضلك تواصل مع مشرفك لموقع مودل.

إذا كان موقع مودل الخاص بك قد تمت تهيئته بشكل صحيح، ستتمكن من استعمال هذا التطبيق في:

- تصفح محتوى مقرراتك الدراسية حتى لو كنت غير متصل بالإنترنت
- استلام إشعارات فورية للرسائل والأحداث الأخرى
- العثور بسرعة على زملائك في المقررات الدراسية والتواصل معهم
- رفع الصور والملفات الصوتية والفيديوية وأي ملفات أخرى من جهازك الجوال
- معاينة تقديراتك في المقررات الدراسية
- وأكثر!

من فضلك راجع https://docs.moodle.org/en/Mobile_app للإطلاع على آخر المعلومات الخاصة بالتطبيق.

نحن نُقدِّر حقاً أي تعقيبات جيدة بشأن الأداء حالياً، وملاحظاتك بشأن ما تريد لهذا التطبيق أن يقوم به أيضاً!

يتطلب التطبيق الحصول على الصلاحيات الآتية:
تسجيل الصوت - لتسجيل الأصوات ورفعها إلى مودل
قراءة وتعديل محتويات بطاقة الخزن الدائم لجهاز جوالك - يتم تنزيل المحتوى إلى بطاقة الخزن الدائم ليتسنى لك مشاهدتها بدون الاتصال بالإنترنت
الوصول إلى الشبكة - لتتمكن من الاتصال بموقع مودل الخاص بك والتحقق من هذا الاتصال لاتخاذ القرار بشأن الانتقال إلى نمط التشغيل بدون الاتصال
التشغيل عند البدء - لتتلقى الإشعارات محلياً حتى وإن كان التطبيق شغالاً في الخلفية
منع الجهاز من الخمول - لتتلقى دفعات الإشعارات في أي وقت';
$string['assets.mimetypes.application/vnd.apple.keynote'] = 'العرض التقديمي لـ Apple Keynote';
$string['assets.mimetypes.application/vnd.apple.numbers'] = 'جدول Apple Numbers';
$string['assets.mimetypes.application/vnd.apple.pages'] = 'مستند Apple Pages';
$string['assets.mimetypes.application/vnd.google-apps.audio'] = 'صوت Google Drive';
$string['assets.mimetypes.application/vnd.google-apps.document'] = 'مستندات Google';
$string['assets.mimetypes.application/vnd.google-apps.drawing'] = 'رسم Google';
$string['assets.mimetypes.application/vnd.google-apps.file'] = 'ملف Google Drive';
$string['assets.mimetypes.application/vnd.google-apps.folder'] = 'مجلد Google Drive';
$string['assets.mimetypes.application/vnd.google-apps.form'] = 'نماذج Google';
$string['assets.mimetypes.application/vnd.google-apps.fusiontable'] = 'جداول Google Fusion';
$string['assets.mimetypes.application/vnd.google-apps.presentation'] = 'شرائح Google';
$string['assets.mimetypes.application/vnd.google-apps.script'] = 'نصوص تطبيقات Google';
$string['assets.mimetypes.application/vnd.google-apps.site'] = 'مواقع Google';
$string['assets.mimetypes.application/vnd.google-apps.spreadsheet'] = 'أوراق جداول Google';
$string['assets.mimetypes.application/vnd.google-apps.video'] = 'فيديو Google Drive';
$string['core.ajaxendpointnotfound'] = 'تعذر العثور على النقطة الطرفية لـ AJAX. يمكن أن يحدث ذلك إذا كان موقع مودل قديم جدًا أو فيه ما يعوق الوصول إلى تلك النقطة. تطبيق مودل يدعم فقط أنظمة مودل ذات الإصدار {{$a}} وما بعده.';
$string['core.browser'] = 'المستعرض';
$string['core.calculating'] = 'يجري الاحتساب';
$string['core.cannotconnect'] = 'لا يمكن الاتصال بالموقع';
$string['core.cannotdownloadfiles'] = 'تم تعطيل تنزيل الملفات من قبل مدرستك، شركتك، مؤسستك أو مزود الخدمات التعليمية لديك.';
$string['core.cannotinstallapk'] = 'يتعذر تنصيب ملفات .apk';
$string['core.cannotinstallapkinfo'] = 'لدواعي الأمان، لا يمكنك تنصيب تطبيقات مجهولة في جهازك من هذا التطبيق. إذا كنت لا تزال راغبًا بمتابعة التنصيب، ستحتاج إلى فتحه من المستعرض.';
$string['core.cannotlogoutpageblocks'] = 'يرجى حفظ تغييراتك أو التخلي عنها قبل المتابعة.';
$string['core.cannotopeninapp'] = 'قد لا يعمل هذا الملف كما هو متوقع في هذا الجهاز. هل ترغب بفتحه على أي حال؟';
$string['core.cannotopeninappdownload'] = 'قد لا يعمل هذا الملف كما هو متوقع في هذا الجهاز. هل ترغب بتنزيله على أي حال؟';
$string['core.captureaudio'] = 'تسجيل الصوت';
$string['core.capturedimage'] = 'الصورة الملتقطة.';
$string['core.captureimage'] = 'إلتقاط الصورة';
$string['core.capturevideo'] = 'تسجيل الفيديو';
$string['core.certificaterror'] = 'لا يمكن لجهازك التوثق من شهادة مصادقة هذا الموقع: {{details}}';
$string['core.clearsearch'] = 'إخلاء البحث';
$string['core.clearstoreddata'] = 'إخلاء المخزون {{$a}}';
$string['core.clicktoseefull'] = 'أنقر لمشاهدة المحتويات الكاملة.';
$string['core.comments.commentsnotworking'] = 'لا يمكن جلب التعليقات';
$string['core.comments.warningcommentsnotsent'] = 'تعذرت مزامنة التعليقات. {{error}}';
$string['core.confirmcanceledit'] = 'هل أنت متأكد من رغبتك في مغادرة هذه الصفحة؟ سيتم فقدان كل التغييرات.';
$string['core.confirmleavepagedescription'] = 'التغييرات غير المحفوظة ستضيع.';
$string['core.confirmleavepagetitle'] = 'أتريد مغادرة الصفحة؟';
$string['core.confirmleaveunknownchanges'] = 'هل أنت متأكد من رغبتك في مغادرة هذه الصفحة؟ إن كانت لديك تغييرات غير محفوظة سيتم فقدانها.';
$string['core.confirmloss'] = 'هل أنت متأكد؟ سيتم فقدان كل التغييرات.';
$string['core.confirmopeninbrowser'] = 'هل ترغب بفتحها من مستعرض الويب؟';
$string['core.confirmremoveselectedfile'] = 'هذا من شأنه حذف \'{{filename}}\' نهائيًا. لا يمكنك التراجع عن ذلك.';
$string['core.confirmremoveselectedfiles'] = 'هذا من شأنه حذف الملفات المحددة نهائيًا. لا يمكنك التراجع عن ذلك.';
$string['core.connectandtryagain'] = 'يرجى الاتصال بالإنترنت ثم المحاولة مجددًا.';
$string['core.connectionlost'] = 'فقدنا الاتصال بالموقع';
$string['core.contactsupport'] = 'الاتصال بالدعم';
$string['core.contactverb'] = 'جهة الاتصال';
$string['core.contenteditingsynced'] = 'المحتوى الذي تقوم بتحريره قد تمت مزامته.';
$string['core.contentlinks.chooseaccount'] = 'إختر الحساب';
$string['core.contentlinks.chooseaccounttoopenlink'] = 'إختر حساباً لتفتح به الرابط.';
$string['core.contentlinks.confirmurlothersite'] = 'الرابط يعود لموقع آخر. هل تريد فتحه؟';
$string['core.contentlinks.errornoactions'] = 'تعذر العثور على إجراء لاتخاذه مع هذا الرابط.';
$string['core.contentlinks.errornosites'] = 'تعذر العثور على أي موقع لمعالجة هذا الرابط.';
$string['core.contentlinks.errorredirectothersite'] = 'عنوان رابط إعادة التوجيه لا يمكنه الإشارة إلى موقع مختلف.';
$string['core.copiedtoclipboard'] = 'تم نسخ النص إلى الحافظة';
$string['core.copytoclipboard'] = 'إنسخ إلى الحافظة';
$string['core.course.activitydisabled'] = 'قامت مؤسستك بتعطيل هذا النشاط في تطبيق الجوال.';
$string['core.course.activitynotavailableoffline'] = 'هذا النشاط غير متاح بدون اتصال.';
$string['core.course.activitynotyetviewableremoteaddon'] = 'قامت مؤسستك بتنصيب ملحق ليس مدعوماً بعد.';
$string['core.course.activityrequiresconnection'] = 'هذا النشاط متاح فقط مع وجود الاتصال بالإنترنت. إذا كان جهازك غير متصل، لن تتمكن من الوصول إليه.';
$string['core.course.allsections'] = 'كل المقاطع';
$string['core.course.aria:sectionprogress'] = 'تقدم القسم:';
$string['core.course.availablespace'] = 'لديك حالياً ما يقارب {{available}} من المساحة الخالية.';
$string['core.course.cannotdeletewhiledownloading'] = 'لا يمكن حذف الملفات خلال تنزيل النشاط. لطفاً، إنتظر ريثما يكتمل التنزيل.';
$string['core.course.changesofflinemaybelost'] = 'أي تغييرات أجريتها لهذا النشاط عندما لم تكن متصلاً قد لا تكون محفوظة.<br><br> أوصل جهازك بالإنترنت لتفادي فقدان ما أجريته.';
$string['core.course.confirmdownload'] = 'أنت على وشك تنزيل {{size}}.{{availableSpace}} هل أنت متأكد من رغبتك في المتابعة؟';
$string['core.course.confirmdownloadunknownsize'] = 'لم يكن بالإمكان حساب حجم التنزيل. {{availableSpace}} هل أنت متأكد من رغبتك في المتابعة؟';
$string['core.course.confirmdownloadzerosize'] = 'أنت على وشك الشروع بالتنزيل. {{availableSpace}} هل أنت متأكد من رغبتك في المتابعة؟';
$string['core.course.confirmlimiteddownload'] = 'أنت غير متصل حالياً بالشبكة اللاسلكية.';
$string['core.course.confirmpartialdownloadsize'] = 'أنت على وشك تنزيل ما حجمه <strong>على الأقل</strong> {{size}}.{{availableSpace}}. هل أنت متأكد من رغبتك في المتابعة؟';
$string['core.course.couldnotloadsectioncontent'] = 'تعذر تحميل محتوى القسم. ترجى المحاولة مرة أخرى لاحقاً.';
$string['core.course.couldnotloadsections'] = 'تعذر تحميل الأقسام، ترجى المحاولة مرة أخرى لاحقاَ';
$string['core.course.downloadcoursesprogressdescription'] = 'تنزيل المقررات: تم تنزيل {{count}} من أصل {{total}}.';
$string['core.course.downloadsectionprogressdescription'] = 'تنزيل المقاطع: تم تنزيل {{count}} من أصل {{total}}.';
$string['core.course.errordownloadingcourse'] = 'خطأ عند تنزيل المساق.';
$string['core.course.errordownloadingsection'] = 'خطأ عند تنزيل القسم.';
$string['core.course.errorgetmodule'] = 'خطأ عند جلب بيانات النشاط.';
$string['core.course.insufficientavailablequota'] = 'تعذر على جهازك تخصيص مساحة لخزن هذا التنزيل. قد يكون محتفظاً بالمساحة من أجل تحديثات النظام أو التطبيقات. يرجى إخلاء بعض من مساحة الخزن أولاً.';
$string['core.course.insufficientavailablespace'] = 'أنت على وشك تنزيل ما حجمه {{size}}. هذا من شأنه أن يترك جهازك بمساحة لا تكفيه للعمل بشكل إعتيادي. يرجى إخلاء بعض من مساحة الخزن أولاً.';
$string['core.course.lastaccessedactivity'] = 'آخر نشاط تم الوصول إليه';
$string['core.course.manualcompletionnotsynced'] = 'الإكمال اليدوي غير مُزامَن.';
$string['core.course.modulenotfound'] = 'النشاط أو المورد غير موجود. يرجى التأكد من كونك متصلاً بالإنترنت وأنه ما يزال متاحًا.';
$string['core.course.nextactivity'] = 'النشاط التالي';
$string['core.course.nextactivitynotfound'] = 'النشاط التالي غير موجود. من المحتمل أنه محذوف أو تم إخفاؤه.';
$string['core.course.nocontentavailable'] = 'لا يتوفر أي محتوى حالياً.';
$string['core.course.previousactivity'] = 'النشاط السابق';
$string['core.course.previousactivitynotfound'] = 'النشاط السابق غير موجود. من المحتمل أنه محذوف أو تم إخفاؤه.';
$string['core.course.refreshcourse'] = 'تنشيط المساق';
$string['core.course.useactivityonbrowser'] = 'لا زال بإمكانك استعماله عبر مستعرض الويب في جهازك.';
$string['core.course.warningmanualcompletionmodified'] = 'لقد تم في الموقع تعديل الإكمال اليدوي لنشاط ما.';
$string['core.course.warningofflinemanualcompletiondeleted'] = 'بعض تأشيرات الإكمال اليدوي للمساق \'{{name}}\' قد تم حذفها. {{error}}';
$string['core.coursenogroups'] = 'لستَ عضواً في أي مجموعة لهذا المساق.';
$string['core.courses.browserenrolinstructions'] = 'سنأخذك إلى المستعرض في جهازك. بمجرد إكمالك لانضمامك، يرجى العودة إلى هذا التطبيق.';
$string['core.courses.cannotretrievemorecategories'] = 'لا يمكن جلب التصنيفات ذات المستوى الأعمق من {{$a}}.';
$string['core.courses.completeenrolmentbrowser'] = 'أكمل الانضمام من المستعرض';
$string['core.courses.downloadcourses'] = 'تنزيل المقررات الدراسية';
$string['core.courses.enrolme'] = 'ضُمني';
$string['core.courses.errorloadcategories'] = 'وقع خطأ عند تحميل التصنيفات.';
$string['core.courses.errorloadcourses'] = 'وقع خطأ عند تحميل المقررات.';
$string['core.courses.errorloadplugins'] = 'تعذر تحميل الإضافات المطلوبة من قبل هذا المساق بشكل صحيح. يرجى إعادة تحميل التطبيق للمحاولة مجدداً.';
$string['core.courses.errorsearching'] = 'وقع خطأ عند البحث.';
$string['core.courses.filtermycourses'] = 'ترشيح مقرراتي';
$string['core.courses.notenrollable'] = 'لا يمكنك الانضمام إلى هذا المساق.';
$string['core.courses.otherenrolments'] = 'الانضمامات الأخرى';
$string['core.courses.password'] = 'مفتاح الانضمام';
$string['core.courses.refreshcourses'] = 'تنشيط المقررات';
$string['core.courses.searchcoursesadvice'] = 'يمكنك استعمال زر البحث عن المقررات للعثور على المقررات التي تسمح بدخول الضيوف أو الانضمام إلى المقررات التي تسمح لك بدخولها.';
$string['core.courses.showonlyenrolled'] = 'إظهار مقرراتي فقط';
$string['core.courses.totalcoursesearchresults'] = 'إجمالي المقررات: {{$a}}';
$string['core.currentdevice'] = 'الجهاز الحالي';
$string['core.datastoredoffline'] = 'تم خزن البيانات في الجهاز لتعذر إرسالها. سيتم إرسالها تلقائياً لاحقاً.';
$string['core.deletedoffline'] = 'محذوف بدون الاتصال';
$string['core.deleting'] = 'يجري الحذف';
$string['core.desktop'] = 'سطح المكتب';
$string['core.dfdaymonthyear'] = 'MM-DD-YYYY';
$string['core.dfdayweekmonth'] = 'ddd, D MMM';
$string['core.dffulldate'] = 'dddd, D MMMM YYYY h[:]mm A';
$string['core.dflastweekdate'] = 'ddd';
$string['core.dfmediumdate'] = 'LLL';
$string['core.dftimedate'] = 'h[:]mm A';
$string['core.discard'] = 'تجاهل';
$string['core.dismiss'] = 'صرف النظر';
$string['core.dontshowagain'] = 'لا تُظهر ذلك مجددًا.';
$string['core.downloaded'] = 'مُنَزَّل';
$string['core.downloading'] = 'يجري التنزيل';
$string['core.editor.hidetoolbar'] = 'إخفاء شريط الأدوات';
$string['core.editor.toggle'] = 'تبديل المحرر';
$string['core.emptysplit'] = 'هذه الصفحة ستظهر فارغة إذا كانت اللوحة اليسرى خالية أو قيد التحميل.';
$string['core.endingtime'] = 'وقت الانتهاء: {{$a}}';
$string['core.errorchangecompletion'] = 'وقع خطأ عند تغيير حالة الإكمال. ترجى المحاولة مجدداً.';
$string['core.errorcode'] = 'رمز الخطأ: {{errorCode}}';
$string['core.errordeletefile'] = 'وقع خطأ عند حذف الملف. ترجى المحاولة مجدداً.';
$string['core.errordetailshide'] = 'إخفاء تفاصيل الخطأ';
$string['core.errordetailsshow'] = 'إظهار تفاصيل الخطأ';
$string['core.errordownloading'] = 'خطأ عند تنزيل الملف.';
$string['core.errordownloadingsomefiles'] = 'وقع خطأ عند تنزيل الملفات. بعض الملفات قد تكون مفقودة.';
$string['core.errorfileexistssamename'] = 'ملف بهذا الاسم موجود مسبقاً.';
$string['core.errorinvalidform'] = 'يرجى التحقق من أن كل الحقول المطلوبة مملوءة وأن بياناتها مُدخلة بالشكل الصحيح.';
$string['core.errorinvalidresponse'] = 'تم تلقي استجابة غير متوقعة لخدمة الويب {{method}}.';
$string['core.errorloadingcontent'] = 'خطأ عند تحميل المحتوى.';
$string['core.errorofflinedisabled'] = 'التصفح بدون الاتصال بالإنترنت مُعطل في موقعك. عليك الاتصال بالإنترنت لاستعمال التطبيق.';
$string['core.erroropenfiledownloading'] = 'خطأ عند فتح الملف: عليك انتظار إكتمال التنزيل.';
$string['core.erroropenfilenoapp'] = 'وقع خطأ عند فتح الملف: لم يتم العثور على أي تطبيق يفتح هذا النوع من الملفات.';
$string['core.erroropenfilenoextension'] = 'وقع خطأ عند فتح الملف: الملف لا يحتوي على امتداد.';
$string['core.erroropenpopup'] = 'هذا النشاط يحاول فتح نافذة منبثقة. هذا غير مدعوم في التطبيق.';
$string['core.errorrenamefile'] = 'وقع خطأ عند إعادة تسمية الملف: ترجى المحاولة مجدداً.';
$string['core.errorsitesupport'] = 'إذا تكررت المشكلة، تواصل مع الدعم الفني للموقع.';
$string['core.errorsomedatanotdownloaded'] = 'إذا قمت بتنزيل هذا النشاط، يرجى ملاحظة أن بعض البيانات لا يتم تنزيلها خلال هذه عملية لأسباب تتعلق بالأداء وأسلوب التعامل مع البيانات.';
$string['core.errorsomethingwrong'] = 'وقع خطب ما. رجاءً حاول مجددًا.';
$string['core.errorsync'] = 'وقع خطأ عند المزامنة. ترجى المحاولة مجدداً';
$string['core.errorsyncblocked'] = 'لا يمكن مزامنة {{$a}} هذا الآن بسبب عملية لا تزال جارية. ترجى المحاولة لاحقاً. إذا تمادت المشكلة، حاول إعادة تشغيل التطبيق.';
$string['core.errorurlschemeinvalidscheme'] = 'من المفترض استعمال عنوان الرابط هذا في تطبيق آخر: {{$a}}.';
$string['core.errorurlschemeinvalidsite'] = 'لا يمكن فتح رابط الموقع هذا في هذا التطبيق.';
$string['core.exactalarmsturnedoff'] = 'الإشعارات المباشرة مُطفأة';
$string['core.exactalarmsturnedoffmessage'] = 'لكي لا تفوتك أي تنبيهات هامة، قم بتشغيل \'التنبيهات والتذكيرات\' في إعدادات جهازك.';
$string['core.filedeletedsuccessfully'] = 'لقد حذفت \'{{filename}}\' بنجاح';
$string['core.filenameexist'] = 'اسم الملف موجود مسبقاً: {{$a}}';
$string['core.fileuploader.audio'] = 'الصوت';
$string['core.fileuploader.camera'] = 'الكاميرا';
$string['core.fileuploader.confirmuploadfile'] = 'أنت على وشك رفع ما حجمه {{size}}. هل أنت متأكد من رغبتك في المتابعة؟';
$string['core.fileuploader.confirmuploadunknownsize'] = 'لم يكن ممكناً حساب حجم ما مطلوب رفعه. هل أنت متأكد من رغبتك في المتابعة؟';
$string['core.fileuploader.discardrecording'] = 'التخلي عن التسجيل';
$string['core.fileuploader.errorcapturingaudio'] = 'خطأ في التقاط الصوت.';
$string['core.fileuploader.errorcapturingimage'] = 'خطأ في التقاط الصورة.';
$string['core.fileuploader.errorcapturingvideo'] = 'خطأ في التقاط الفيديو.';
$string['core.fileuploader.errorgettingimagealbum'] = 'خطأ عند جلب الصورة من الألبوم.';
$string['core.fileuploader.errormustbeonlinetoupload'] = 'عليك أن تكون متصلًا بالإنترنت لترفع الملفات.';
$string['core.fileuploader.errornoapp'] = 'ليس لديك تطبيق منصب لتنفيذ هذا الإجراء.';
$string['core.fileuploader.errorreadingfile'] = 'خطأ في قراءة الملف.';
$string['core.fileuploader.errorwhileuploading'] = 'وقع خطأ في أثناء رفع الملف.';
$string['core.fileuploader.file'] = 'الملف';
$string['core.fileuploader.fileuploaded'] = 'تم رفع الملف بنجاح.';
$string['core.fileuploader.maxbytesfile'] = 'الملف {{$a.file}} كبير الحجم. أقصى حجم يمكنك رفعه هو {{$a.size}}.';
$string['core.fileuploader.microphonepermissiondenied'] = 'تم رفض الوصول إلى اللاقطة.';
$string['core.fileuploader.microphonepermissionrestricted'] = 'الوصول إلى اللاقطة مقيد.';
$string['core.fileuploader.pauserecording'] = 'إيقاف التسجيل';
$string['core.fileuploader.photoalbums'] = 'ألبومات الصور';
$string['core.fileuploader.readingfile'] = 'تجري قراءة الملف';
$string['core.fileuploader.readingfileperc'] = 'قراءة الملف: {{$a}}%';
$string['core.fileuploader.resumerecording'] = 'استئناف التسجيل';
$string['core.fileuploader.selectafile'] = 'إختر الملف';
$string['core.fileuploader.startrecordinginstructions'] = 'أنقر لبدء التسجيل';
$string['core.fileuploader.uploadafile'] = 'إرفع الملف';
$string['core.fileuploader.uploading'] = 'يجري الرفع';
$string['core.fileuploader.uploadingperc'] = 'جارٍ الرفع: {{$a}}%';
$string['core.fileuploader.video'] = 'الفيديو';
$string['core.fullnameandsitename'] = '{{fullname}} ({{sitename}})';
$string['core.goto'] = 'الذهاب إلى {{$a}}';
$string['core.h5p.errorgetemail'] = 'خطأ عند الحصول على البريد الالكتروني للمستخدم. يرجى التحقق من اتصالك ثم المحاولة مجدداً.';
$string['core.h5p.offlinedisabled'] = 'الموقع لا يسمح بتنزيل حزم H5P.';
$string['core.h5p.play'] = 'تشغيل H5P';
$string['core.hasdatatosync'] = '{{$a}} هذا لديه بيانات بدون الاتصال تُفترض مزامنتها.';
$string['core.howtoobtaincoordinates'] = 'يمكنك الحصول على إحداثياتك عبر استعمال تطبيق GPS أو <a href="{{url}}">تطبيق خرائط</a>.';
$string['core.humanreadablesize'] = '{{size}} {{unit}}';
$string['core.iframehelp'] = 'هل هذا المحتوى عاطل؟';
$string['core.image'] = 'الصورة';
$string['core.imageviewer'] = 'معاين الصور';
$string['core.ioscookieshelp'] = 'قد يتطلب المحتوى المضمن تمكين ملفات تعريف الارتباط ليعمل. يرجى الذهاب إلى إعدادات تطبيقات iOS، ثم تمكين \'السماح بالتعقب عبر المواقع\' ثم حاول مجددًا.';
$string['core.lastdownloaded'] = 'آخر تنزيل';
$string['core.lastsync'] = 'آخر مزامنة';
$string['core.leave'] = 'مغادرة';
$string['core.loadmore'] = 'تحميل المزيد';
$string['core.locationnolongeravailable'] = 'العثور على موقعك لم يعد متاحًا. {{howToObtain}}';
$string['core.login.authenticating'] = 'تجري المصادقة';
$string['core.login.changepasswordbutton'] = 'تغيير كلمة المرور';
$string['core.login.changepasswordhelp'] = 'إن كانت لديك صعوبات في تغيير كلمة مرورك، يرجى المحاولة لاحقًا أو الاتصال بمدرستك، جامعتك، شركتك أو مجهز الخدمات التعليمية لديك.';
$string['core.login.changepasswordreconnectinstructions'] = 'إن لم تنجح في تغيير كلمة مرورك، فسيُطلب منك تغييرها مجددًا.';
$string['core.login.changepasswordsupportsubject'] = 'أحتاج إلى مساعدة لتغيير كلمة مروري';
$string['core.login.confirmdeletesite'] = 'هل أنت متأكد من رغبتك في إزالة الحساب من {{sitename}}؟';
$string['core.login.connect'] = 'الاتصال!';
$string['core.login.connecttomoodle'] = 'الاتصال مع مودل';
$string['core.login.connecttomoodleapp'] = 'أنت تحاول الاتصال مع موقع عادي لمودل. يرجى تنزيل تطبيق مودل الرسمي للوصول إلى هذا الموقع.';
$string['core.login.connecttoworkplaceapp'] = 'أنت تحاول الاتصال مع نظام مودل لموقع العمل. يرجى تنزيل تطبيق مودل لموقع العمل للوصول إلى هذا الموقع.';
$string['core.login.credentialsdescription'] = 'يرجى إعطاء اسم المستخدم وكلمة المرور لتسجيل الدخول.';
$string['core.login.credentialshelp'] = 'إن كانت لديك صعوبات في تسجيل دخولك، يرجى المحاولة لاحقًا أو الاتصال بمدرستك، جامعتك، شركتك أو مجهز الخدمات التعليمية لديك.';
$string['core.login.credentialssupportsubject'] = 'أحتاج إلى مساعدة لتسجيل الدخول';
$string['core.login.emailconfirmsentnoemail'] = '<p>رسالة بريد الكتروني ينبغي أن تكون قد أرسلت إلى عنوانك.</p><p>هي تتضمن معلومات بسيطة لإكمال عملية تسجيلك.</p>';
$string['core.login.emailnotmatch'] = 'عنوانا البريد الالكتروني ليسا متطابقين';
$string['core.login.erroraccesscontrolalloworigin'] = 'لقد تم رفض طلب cross-origin الذي تحاول تنفيذه. يرجى التحقق من  https://moodledev.io/general/app/development/setup/app-in-browser';
$string['core.login.errordeletesite'] = 'وقع خطأ عند حذف هذا الحساب. لطفاً، حاول مجدداً.';
$string['core.login.errorexampleurl'] = 'عنوان الرابط https://campus.example.edu هو مجرد مثال، وليس عنواناً لموقع حقيقي. <strong>لطفاً، استعمل عنوان موقع مدرستك أو منظمتك.</strong>';
$string['core.login.errorqrnoscheme'] = 'عنوان الرابط هذا ليس عنوان صحيح لتسجيل الدخول.';
$string['core.login.errorupdatesite'] = 'وقع خطأ عند تحديث ترميز الموقع.';
$string['core.login.exceededloginattempts'] = 'أتحتاج إلى مساعدة لتسجيل الدخول؟ حاول {{recoverPassword}} أو تواصل مع الدعم الفني لموقعك.';
$string['core.login.exceededloginattemptsrecoverpassword'] = 'استعادة كلمة مرورك';
$string['core.login.exceededloginattemptssupportsubject'] = 'لا يمكنني تسجيل الدخول';
$string['core.login.exceededloginattemptswithoutpassword'] = 'أتحتاج إلى مساعدة لتسجيل الدخول؟ حاول التواصل مع الدعم الفني لموقعك.';
$string['core.login.exceededloginattemptswithoutsupport'] = 'أتحتاج إلى مساعدة لتسجيل الدخول؟ حاول {{recoverPassword}}.';
$string['core.login.exceededpasswordresetattempts'] = 'يبدو أن لديك صعوبات في الوصول إلى حسابك. يمكنك الاتصال بمدرستك، جامعتك، شركتك أو مجهز الخدمات التعليمية لديك أو المحاولة لاحقًا.';
$string['core.login.exceededpasswordresetattemptssupportsubject'] = 'لا يمكنني إعادة تعيين كلمة مروري';
$string['core.login.faqcannotfindmysiteanswer'] = 'إذا حاولت البحث عن الموقع باستعمال عنوان رابطه ولا تزال غير قادر على العثور عليه، يرجى التواصل مع الشخص الذي يتولى رعاية مودل في مدرستك أو مؤسستك التعليمية.';
$string['core.login.faqcannotfindmysitequestion'] = 'لا يمكنني العثور على موقعي من عنوان رابطه.';
$string['core.login.faqcantloginanswer'] = '<p>بمجرد اتصالك بموقعك، ينبغي أن تكون قادرًا على تسجيل الدخول مستعملاً اسم المستخدم وكلمة المرور.</p><br><p>إذا نسيت اسم المستخدم أو كلمة المرور، حدد الخيار <strong>أنسيت كلمة المرور؟</strong>. إذا ما زلت تواجه صعوبات في تسجيل الدخول أو لا تشاهد أي خيارات لاستعادة اسم المستخدم أو كلمة المرور الخاصين بك، يرجى التواصل مع الشخص الذي يتولى رعاية مودل في مدرستك أو مؤسستك التعليمية.</p>';
$string['core.login.faqcantloginquestion'] = 'لا يمكنني تسجيل الدخول.';
$string['core.login.faqmore'] = 'راجع <a href="https://docs.moodle.org/en/Moodle_app_FAQ#toc" target="_blank">أسئلتنا كثيرة التكرار</a> لمزيد من الإجابات.';
$string['core.login.faqsetupsiteanswer'] = 'قم بزيارة {{$link}} لمعرفة الخيارات المختلفة عندك لإنشاء موقع مودل الخاص بك.';
$string['core.login.faqsetupsitelinktitle'] = 'إبدأ';
$string['core.login.faqsetupsitequestion'] = 'أريد إعداد موقع مودل الخاص بي.';
$string['core.login.faqtestappanswer'] = 'لاختبار التطبيق في موقع تجريبي لمودل، أدخل "معلم" أو "طالب" في حقل <strong>موقعك</strong> ثم انقر على <strong>الاتصال بموقعك</strong>.';
$string['core.login.faqtestappquestion'] = 'هل يمكنني اختبار التطبيق في موقع تجريبي؟';
$string['core.login.faqwhatisurlanswer'] = '<p>إذا لم تتمكن من العثور على موقعك من الاسم، حاول البحث حسب عنوان رابط الموقع (أو ما يسمى عنوان الويب) بدلاً من الاسم.</p><p>للعثور على عنوان موقعك:</p><ol><li>إفتح مستعرض الويب واذهب إلى صفحة تسجيل الدخول في موقع مودل العائد لك.</li><li>في أعلى الصفحة، عند شريط العناوين ستجد عنوان رابط موقعك. مثلاً "campus.example.edu".<br>{{$image}}</li><li>إنسخ العنوان (لا تنسخ كلمة /login وما بعدها)، إلصقها في <strong>موقعك</strong> في تطبيق مودل ثم انقر <strong>الاتصال بموقعك</strong></li><li>يمكنك الآن تسجيل الدخول إلى موقعك باستعمال اسم المستخدم وكلمة المرور.</li></ol><p>إذا حاولت البحث عن الموقع باستعمال عنوان رابطه وما زلت لا تجده، يرجى التواصل مع الشخص الذي يتولى رعاية مودل في مدرستك أو مؤسستك التعليمية.</p>';
$string['core.login.faqwhatisurlquestion'] = 'كيف يمكنني العثور على عنوان رابط موقعي؟';
$string['core.login.faqwhereisqrcode'] = 'أين يمكنني العثور على ترميز QR؟';
$string['core.login.faqwhereisqrcodeanswer'] = '<p>إن كانت مدرستك أو مؤسستك التعليمية قد مكَّنته، ستجد ترميز QR في الموقع عند نهاية صفحة ملفك الشخصي.</p>{{$image}}';
$string['core.login.findyoursite'] = 'إبحث عن موقعك';
$string['core.login.invalidaccount'] = 'يرجى مراجعة تفاصيل تسجيل الدخول الخاصة بك ثم المحاولة مجددًا.';
$string['core.login.invalidmoodleversion'] = 'إصدار موقع مودل هذا قديم جدًا. تطبيق مودل يدعم فقط مواقع مودل التي تستعمل {{$a}} أو أحدث.';
$string['core.login.invalidsite'] = 'رابط عنوان الموقع غير صالح.';
$string['core.login.invalidtime'] = 'الوقت غير صحيح';
$string['core.login.invalidvaluemax'] = 'القيمة العظمى هي {{$a}}';
$string['core.login.invalidvaluemin'] = 'القيمة الصغرى هي {{$a}}';
$string['core.login.loginbutton'] = 'تسجيل الدخول';
$string['core.login.mobileservicesnotenabled'] = 'خدمات الجوال غير مُمَكَّنة في الموقع.';
$string['core.login.morewaystologin'] = 'طرق أخرى لتسجيل الدخول';
$string['core.login.notloggedin'] = 'عليك تسجيل دخولك.';
$string['core.login.onboardingcreatemanagecourses'] = 'إنشاء وإدارة مساقاتك';
$string['core.login.onboardingenrolmanagestudents'] = 'ضم طلبتك وإدارتهم';
$string['core.login.onboardinggetstarted'] = 'إبدأ مع مودل';
$string['core.login.onboardingialreadyhaveasite'] = 'عندي مسبقاً موقع مودل';
$string['core.login.onboardingimalearner'] = 'أنا متعلم';
$string['core.login.onboardingimaneducator'] = 'أنا معلم';
$string['core.login.onboardingineedasite'] = 'أنا بحاجة إلى موقع مودل';
$string['core.login.onboardingprovidefeedback'] = 'توفير إفادة موقوتة';
$string['core.login.onboardingtoconnect'] = 'للاتصال مع تطبيق مودل ينبغي أن يكون لديك موقع لمودل';
$string['core.login.onboardingwelcome'] = 'مرحباً بك في تطبيق مودل!';
$string['core.login.or'] = 'أو';
$string['core.login.passwordrequired'] = 'كلمة المرور مطلوبة';
$string['core.login.policyacceptmandatory'] = 'إنني أفهم سياسة الموقع الإجبارية وأوافق عليها';
$string['core.login.recaptchachallengeimage'] = 'صورة اختبار reCAPTCHA';
$string['core.login.recaptchaexpired'] = 'انتهت مهلة التحقق. أجب على سؤال الأمان مجدداً.';
$string['core.login.recaptchaincorrect'] = 'إجابة سؤال الأمان غير صحيحة.';
$string['core.login.reconnect'] = 'إعادة الاتصال';
$string['core.login.reconnecthelp'] = 'إذا كانت لديك مشاكل في إعادة الاتصال، حاول لاحقًا أو اتصل بمدرستك، شركتك، مؤسستك أو مزود الخدمات التعليمية لديك.';
$string['core.login.reconnectsupportsubject'] = 'أحتاج إلى مساعدة لإعادة الاتصال';
$string['core.login.reconnecttosite'] = 'إعادة الاتصال بالموقع';
$string['core.login.removeaccount'] = 'إزالة الحساب';
$string['core.login.searchby'] = 'البحث حسب:';
$string['core.login.selectsite'] = 'لطفاً، حدد حسابك';
$string['core.login.signupplugindisabled'] = '{{$a}} غير مُمَكَّن.';
$string['core.login.signuprequiredfieldnotsupported'] = 'نموذج التسجيل يحتوي على حقل مخصص إجباري غير مدعوم في التطبيق. يرجى إنشاء حسابك باستعمال مستعرض الويب.';
$string['core.login.siteaddress'] = 'موقعك';
$string['core.login.siteaddressplaceholder'] = 'https://campus.example.edu';
$string['core.login.sitebadgedescription'] = 'هناك {{count}} من الإشعارات غير المقروءة.';
$string['core.login.sitehasredirect'] = 'موقعك يحتوي على إعادة توجيه تستعمل بروتوكول HTTP واحدة على الأقل. يتعذر على التطبيق متابعة إعادات التوجيه، وقد تكون هذه هي المشكلة التي تمنع التطبيق من الاتصال بموقعك.';
$string['core.login.siteinmaintenance'] = 'موقعك هو في وضع الصيانة';
$string['core.login.sitenotallowed'] = 'لم يعد هذا الموقع متاحًا';
$string['core.login.sitepolicynotagreederror'] = 'لم تتم الموافقة على سياسة الموقع.';
$string['core.login.siteurl'] = 'رابط الموقع';
$string['core.login.siteurlrequired'] = 'رابط الموقع مطلوب.. مثل <i>https://campus.example.edu</i>';
$string['core.login.stillcantconnect'] = 'أما زلت غير قادر على الاتصال؟';
$string['core.login.toggleremove'] = 'تحرير قائمة الحسابات';
$string['core.login.unsupportedsite'] = 'لا يمكن الوصول إلى الموقع من خلال التطبيق';
$string['core.login.unsupportedsitemessage'] = 'الموقع {{site}} لا يمكن الوصول إله من خلال هذا التطبيق.<br><br>لا يزال يإمكانك الوصول إليه من خلال متصفح الويب.';
$string['core.login.usernamerequired'] = 'اسم المستخدم مطلوب';
$string['core.login.visitchangepassword'] = 'هل ترغب بزيارة الموقع لتغيير كلمة المرور؟';
$string['core.login.webservicesnotenabled'] = 'خدمات الويب غير مُمَكَّنة في الموقع.';
$string['core.login.youcanstillconnectwithcredentials'] = 'لا زال بإمكانك الاتصال بالموقع عبر إدخال اسم المستخدم وكلمة المرور.';
$string['core.login.yourenteredsite'] = 'اتصل بموقعك';
$string['core.lostconnection'] = 'جلستك انتهت صلاحيتها. يرجى معاودة تسجيل الدخول للمتابعة.';
$string['core.mainmenu.switchaccount'] = 'تبديل الحساب';
$string['core.mainmenu.usermenutourdescription'] = 'المكان الذي منه تتحقق من درجاتك، تُغير تفضيلاتك أو تبدل ما بين حساباتك.';
$string['core.mainmenu.usermenutourtitle'] = 'استكشف مساحتك الشخصية';
$string['core.needhelp'] = 'أتحتاج إلى المساعدة؟';
$string['core.needinternettoaccessit'] = 'تحتاج إلى الاتصال بالإنترنت للوصول إليه.';
$string['core.networkerroriframemsg'] = 'هذا المحتوى غير متاح بدون الاتصال. يرجى الاتصال بالإنترنت ثم المحاولة مجدداً.';
$string['core.networkerrormsg'] = 'هناك مشكلة عند الاتصال بالموقع. يرجى التأكد من اتصالك ثم حاول مجددًا.';
$string['core.nooptionavailable'] = 'لا يتوفر أي خيار';
$string['core.nopasswordchangeforced'] = 'لا يمكنك المتابعة بدون تغيير كلمة مرورك.';
$string['core.nopermissionerror'] = 'عذراً، ولكنك لا تمتلك حاليًا الصلاحيات للقيام بذلك.';
$string['core.notapplicable'] = 'غير متاح';
$string['core.notavailablecontentinapp'] = 'هذا المحتوى ليس متاحًا في التطبيق، ولكن بإمكانه فتحه في مستعرض الويب باستعمال الزر الآتي.';
$string['core.notavailableoffline'] = 'هذا المحتوى ليس متاحًا بدون الاتصال. يرجى الاتصال بالإنترنت ثم المحاولة مجددًا.';
$string['core.notdownloadable'] = 'غير قابل للتنزيل';
$string['core.notnow'] = 'ليس الآن';
$string['core.notsent'] = 'غير مرسَل';
$string['core.nummore'] = '{{$a}} أخرى';
$string['core.openfile'] = 'إفتح الملف';
$string['core.openfilewithextension'] = 'فتح ملف {{extension}}';
$string['core.openfullimage'] = 'أنقر هنا لعرض الصورة بحجمها الكامل';
$string['core.openinbrowser'] = 'إفتحه بالمتصفح';
$string['core.openinbrowserdescription'] = 'سيجري أخذك إلى متصفح الويب';
$string['core.openmodinbrowser'] = 'إفتح {{$a}} بالمتصفح';
$string['core.opensecurityquestion'] = 'فتح سؤال الأمان';
$string['core.opensettings'] = 'فتح الإعدادات';
$string['core.openwith'] = 'الفتح باستعمال...';
$string['core.percentagenumber'] = '{{$a}}%';
$string['core.play'] = 'تشغيل';
$string['core.policy.havereadandagreepolicy'] = 'لقد قرأت {{policyname}} ووافقت عليها';
$string['core.policy.nopoliciesyet'] = 'لا سياسات أو اتفاقيات بعد.';
$string['core.policy.policyacceptmandatory'] = 'إنني أفهم سياسات الموقع الإجبارية وأوافق عليها';
$string['core.policy.sitepolicynotagreederror'] = 'ساسة الموقع لم تتم الموافقة عليها';
$string['core.policy.viewpolicy'] = 'معاينة السياسة {{policyname}}.';
$string['core.pulltorefresh'] = 'إسحب للتحديث';
$string['core.qrscanner'] = 'ماسح QR';
$string['core.question.cannotdeterminestatus'] = 'يتعذر تقرير الحالة';
$string['core.question.errorattachmentsnotsupportedinsite'] = 'موقعك لا يدعم إرفاق الملفات بالإجابات بعد.';
$string['core.question.errorembeddedfilesnotsupportedinsite'] = 'موقعك لا يدعم تحرير الملفات المضمنة بعد.';
$string['core.question.errorquestionnotsupported'] = 'نوع الأسئلة هذا غير مدعوم من قبل التطبيق: {{$a}}.';
$string['core.question.howtodraganddrop'] = 'أنقر للتحديد ثم أنقر للإفلات.';
$string['core.question.questionmessage'] = 'السؤال {{$a}}: {{$b}}';
$string['core.redirectingtosite'] = 'ستتم إعادة توجيهك إلى الموقع.';
$string['core.reminders.atthetime'] = 'عند وقت الحدث';
$string['core.reminders.custom'] = 'مخصص...';
$string['core.reminders.customreminder'] = 'تذكير مخصص';
$string['core.reminders.delete'] = 'حذف التذكير';
$string['core.reminders.reminderset'] = 'التذكير تم ضبطه عند {{$a}}';
$string['core.reminders.reminderunset'] = 'التذكير تم حذفه';
$string['core.reminders.setareminder'] = 'ضبط التذكير';
$string['core.reminders.setareminderfor'] = 'ضبط التذكير لـ "{{title}}" ({{label}})';
$string['core.reminders.setreminder'] = 'ضبط التذكير';
$string['core.reminders.timebefore'] = 'قبل {{value}} {{units}}';
$string['core.reminders.value'] = 'القيمة';
$string['core.removedownloadeddata'] = 'إزالة البيانات المنزلة';
$string['core.removefiles'] = 'إزالة الملفات {{$a}}';
$string['core.reportbuilder.filtersapplied'] = 'قد تكون هناك مرشحات مطبقة لهذه المعاينة، <a href="{{$a}}">إفتح هذا التقرير بمستعرض الويب عندك.</a>';
$string['core.reportbuilder.hidecolumns'] = 'إخفاء الأعمدة';
$string['core.reportbuilder.showcolumns'] = 'إظهار الأعمدة';
$string['core.requireduserdatamissing'] = 'يفتقر هذا المستخدم إلى بعض البيانات المطلوبة في ملفه الشخصي. يرجى إدخال البيانات في موقعك ثم المحاولة مجدداً.<br>{{$a}}';
$string['core.resume'] = 'استئناف';
$string['core.retry'] = 'إعادة المحاولة';
$string['core.scanqr'] = 'إمسح ترميز QR';
$string['core.scrollbackward'] = 'الانتقال للخلف';
$string['core.scrollforward'] = 'الانتقال للأمام';
$string['core.search.allcategories'] = 'كل التصنيفات';
$string['core.search.empty'] = 'عن ماذا تبحث؟';
$string['core.search.filtercategories'] = 'تصفية النتائج حسب';
$string['core.search.filtercourses'] = 'إبحث في';
$string['core.search.noresults'] = 'لا نتائج لـ "{{$a}}"';
$string['core.search.noresultshelp'] = 'تحقق من الأخطاء الإملائية أو حاول استعمال كلمات مفتاحية أخرى';
$string['core.search.resultby'] = 'حسب {{$a}}';
$string['core.searching'] = 'يجري البحث';
$string['core.serverconnection'] = 'وقع خطأ عند الاتصال بالمخدم: {{details}}';
$string['core.settings.about'] = 'عن';
$string['core.settings.appsettings'] = 'إعدادات التطبيق';
$string['core.settings.appversion'] = 'إصدار التطبيق';
$string['core.settings.cannotsyncloggedout'] = 'تتعذر المزامنة مع هذا الموقع لأنك سجلت خروجك منه. ترجى المحاولة مجدداً عندما تكون داخلاً فيه.';
$string['core.settings.cannotsyncoffline'] = 'فشلت المزامنة لأن جهازك غير متصل بالإنترنت.';
$string['core.settings.cannotsyncwithoutwifi'] = 'أنت غير متصل حالياً بالشبكة اللاسلكية. حاول الاتصال بالشبكة اللاسلكية أو أطفئ خاصية توفير البيانات في إعدادات التطبيق.';
$string['core.settings.changelanguage'] = 'التبديل إلى {{$a}}';
$string['core.settings.changelanguagealert'] = 'تبديل اللغة سيُعيد تشغيل التطبيق.';
$string['core.settings.colorscheme'] = 'نظام الألوان';
$string['core.settings.colorscheme-dark'] = 'غامق';
$string['core.settings.colorscheme-light'] = 'فاتح';
$string['core.settings.colorscheme-system'] = 'إفتراضي النظام';
$string['core.settings.colorscheme-system-notice'] = 'الوضع الافتراضي للنظام سيعتمد على ما يقدمه جهازك من دعم.';
$string['core.settings.compilationinfo'] = 'معلومات التجميع';
$string['core.settings.connecttosync'] = 'جهازك غير متصل بالإنترنت. حاول توصيله لمزامنة المواقع.';
$string['core.settings.connectwifitosync'] = 'حاول الاتصال بشبكة لا سلكية أو قم بتعطيل توفير البيانات لمزامنة المواقع.';
$string['core.settings.copyinfo'] = 'إنسخ معلومات الجهاز إلى الحافظة';
$string['core.settings.cordovadevicemodel'] = 'طراز جهاز كوردوفا';
$string['core.settings.cordovadeviceosversion'] = 'إصدار نظام تشغيل جهاز كوردوفا';
$string['core.settings.cordovadeviceplatform'] = 'منصة جهاز كوردوفا';
$string['core.settings.cordovadeviceuuid'] = 'المُعرَّف العام الفريد لجهاز كوردوفا';
$string['core.settings.cordovaversion'] = 'إصدار كوردوفا';
$string['core.settings.debugdisplaydescription'] = 'عند تمكينه، بلاغات الأخطاء ستعرض المزيد من البيانات عنه إن أمكن.';
$string['core.settings.developeroptions'] = 'خيارات المطور';
$string['core.settings.deviceinfo'] = 'معلومات الجهاز';
$string['core.settings.deviceos'] = 'نظام تشغيل الجهاز';
$string['core.settings.displayformat'] = 'تنسيق العرض';
$string['core.settings.enableanalytics'] = 'تمكين التحليلات';
$string['core.settings.enableanalyticsdescription'] = 'عند تمكينه، سيقوم التطبيق بجمع بيانات الاستعمال غير المشخصنة.';
$string['core.settings.enabledownloadsection'] = 'تمكين تنزيل المقاطع';
$string['core.settings.enablepinchtozoom'] = 'تمكين القبض للتكبير';
$string['core.settings.enablerichtexteditor'] = 'تمكين محرر النصوص';
$string['core.settings.enablerichtexteditordescription'] = 'عند تمكينه، سيكون محرر النصوص متاحاً عند إدخال المحتوى.';
$string['core.settings.encryptedpushsupported'] = 'دفع الإشعارات المشفرة مدعوم';
$string['core.settings.entriesincache'] = '{{$a}} من الإدخالات في الخبء';
$string['core.settings.estimatedfreespace'] = 'المساحة الفارغة المُقدَّرة';
$string['core.settings.filesystemroot'] = 'جذر نظام الملفات';
$string['core.settings.fontsize'] = 'حجم النص';
$string['core.settings.forcedsetting'] = 'هذا الإعداد مفروض من قبل إعدادات موقعك.';
$string['core.settings.helpusimprove'] = 'ساعدنا في تحسين هذا التطبيق';
$string['core.settings.ioscookies'] = 'السماح بالتعقب عبر المواقع';
$string['core.settings.ioscookiesdescription'] = 'قد يتطلب المحتوى المضمن من الموقع تمكين ملفات تعريف الارتباط عبر المواقع ليعمل. لتمكينها، يرجى الذهاب إلى إعدادات تطبيقات iOS، ثم تمكين \'السماح بالتعقب عبر المواقع\'.';
$string['core.settings.legaldisclaimer'] = 'إخلاء المسؤولية القانونية';
$string['core.settings.localnotifavailable'] = 'توجد إشعارات محلية';
$string['core.settings.locationhref'] = 'عنوان رابط معاينة الويب';
$string['core.settings.logintosync'] = 'سجل دخولك للمزامنة';
$string['core.settings.navigatorlanguage'] = 'لغة التنقل';
$string['core.settings.navigatoruseragent'] = 'وكيل المستخدم للتنقل';
$string['core.settings.networkstatus'] = 'حالة الاتصال بالإنترنت';
$string['core.settings.opensourcelicenses'] = 'فتح رُخَص المصدر';
$string['core.settings.privacypolicy'] = 'سياسة الخصوصية';
$string['core.settings.publisher'] = 'الناشر';
$string['core.settings.pushid'] = 'مُعرَّف دفق الإشعارات';
$string['core.settings.reportinbackground'] = 'أبلغ عن الأخطاء تلقائياً';
$string['core.settings.screen'] = 'معلومات الشاشة';
$string['core.settings.showdownloadoptions'] = 'إظهار خيارات التنزيل';
$string['core.settings.siteinfo'] = 'معلومات الموقع';
$string['core.settings.sitesynccompleted'] = 'المزامنة مع الموقع إكتملت';
$string['core.settings.sitesyncfailed'] = 'فشلت المزامنة مع الموقع';
$string['core.settings.spaceusage'] = 'المساحة المستعملة';
$string['core.settings.syncdatasaver'] = 'توفير البيانات: قم بالمزامنة فقط عند الاتصال مع الشبكة اللاسلكية';
$string['core.settings.synchronization'] = 'المزامنة';
$string['core.settings.synchronizenow'] = 'زامن الآن';
$string['core.settings.synchronizenowhelp'] = 'عملية مزامنة الموقع سترسل كل التغييرات التي قيد الانتظار وكل النشاطات التي جرت بدون الاتصال والمخزونة في الجهاز مع مزامنة بعض البيانات الأخرى مثل الرسائل والإشعارات.';
$string['core.settings.syncsettings'] = 'إعدادات المزامنة';
$string['core.settings.wificonnection'] = 'إتصال الشبكة اللاسلكية';
$string['core.settings.youradev'] = 'أنت الآن واحد من المطورين';
$string['core.sharedfiles.chooseaccountstorefile'] = 'إختر حساباً لخزن الملف فيه.';
$string['core.sharedfiles.chooseactionrepeatedfile'] = 'هناك ملف بنفس التسمية. هل ترغب باستبدال الملف الموجود أم إعادة تسميته إلى "{{$a}}"?';
$string['core.sharedfiles.errorreceivefilenosites'] = 'ليست هناك مواقع مخزنة. لطفاً، أضف موقعاً قبل مشاركة الملفات مع التطبيق.';
$string['core.sharedfiles.nosharedfiles'] = 'لا توجد ملفات مشتركة مخزونة في هذا الموقع.';
$string['core.sharedfiles.nosharedfilestoupload'] = 'ليست لديك ملفات لرفعها هنا. إن كنت ترغب برفع ملف من تطبيق آخر، حدد موضعه ثم انقر زر \'إفتحه في\'.';
$string['core.sharedfiles.rename'] = 'إعادة التسمية';
$string['core.sharedfiles.replace'] = 'استبدال';
$string['core.sharedfiles.sharedfiles'] = 'الملفات المشتركة';
$string['core.sharedfiles.successstorefile'] = 'تم خزن الملف بنجاح. إختر الملف الذي تريد رفعه إلى ملفاتك الخاصة أو استعماله في نشاط ما.';
$string['core.sitenotfoundhelp'] = 'لم نعثر على الموقع الذي أدخلته. رجاءً تحقق فيما إذا كانت لديك أخطاء في إملائه أو حاول لاحقًا. إذا بقيت تشاهد هذه الرسالة، تواصل مع مدرستك، جامعتك، شركتك أو مزود الخدمات التعليمية لديك.';
$string['core.siteunavailablehelp'] = 'الموقع "{{site}}" غير متاح حاليًا. ترجى المحاولة لاحقًا أو التواصل مع مدرستك، جامعتك، شركتك أو مزود الخدمات التعليمية لديك.';
$string['core.sizetb'] = 'تيرا بايت';
$string['core.sorry'] = 'عذراً..';
$string['core.start'] = 'البدء';
$string['core.startingtime'] = 'وقت البدء: {{$a}}';
$string['core.storingfiles'] = 'يجري خزن الملفات';
$string['core.submittedoffline'] = 'مسلمة (بدون الاتصال)';
$string['core.swipenavigationtourdescription'] = 'إسحب يمينًا ويسارًا للتنقل.';
$string['core.tablet'] = 'الجهاز اللوحي';
$string['core.tag.errorareanotsupported'] = 'منطقة الوسوم هذه غير مدعومة من قبل التطبيق.';
$string['core.tag.tagareabadgedescription'] = 'هناك {{count}} من العناصر.';
$string['core.tag.warningareasnotsupported'] = 'بعض مناطق الوسوم غير معروضة لأنها غير مدعومة من قبل التطبيق.';
$string['core.thereisdatatosync'] = 'هناك {{$a}} بلا اتصال مطلوبة مزامنتها.';
$string['core.toggledelete'] = 'تبديل أزرار الحذف';
$string['core.tryagain'] = 'حاول مجدداً';
$string['core.turnon'] = 'تشغيل';
$string['core.turnonexactalarms'] = 'تشغيل التنبيهات المباشرة';
$string['core.turnonnotifications'] = 'تشغيل الإشعارات';
$string['core.turnonnotificationsmessage'] = 'هل ترغب بتلقي إشعارات بشأن النشاطات والواجبات؟';
$string['core.twoparagraphs'] = '{{p1}}<br><br>{{p2}}';
$string['core.uhoh'] = 'عجباً!';
$string['core.unexpectederror'] = 'خطأ غير متوقع. الرجاء الإغلاق وإعادة فتح التطبيق للمحاولة مرة أخرى';
$string['core.unicodenotsupported'] = 'بعض الرموز التعبيرية غير مدعومة في هذا الموقع. ستتم إزالة هذا النوع من الحروف عند إرسال الرسالة.';
$string['core.unicodenotsupportedcleanerror'] = 'تم العثور على نصوص فارغة عند تنظيف حروف يونيكود.';
$string['core.unknown'] = 'غير معروف';
$string['core.unzipping'] = 'يجري فك الضغط';
$string['core.updaterequired'] = 'يتطلب تحديث التطبيق';
$string['core.updaterequireddesc'] = 'لطفاً، قم بتحديث التطبيق إلى الإصدار {{$a}}';
$string['core.user.completeprofile'] = 'أكمل الملف الشخصي';
$string['core.user.completeprofilehelp'] = 'إذا كانت لديك مشاكل في إكمال ملفك الشخصي، حاول لاحقًا أو تواصل مع مدرستك، جامعتك، شركتك أو مزود الخدمات التعليمية لديك.';
$string['core.user.completeprofilenotice'] = 'قبل المتابعة، رجاءً إملأ الحقول المطلوبة في ملفك الشخصي.';
$string['core.user.completeprofilereconnectinstructions'] = 'إذا لم تُكمل ملفك الشخصي بشكل صحيح، ستتم مطالبتك بإكماله مرة أخرى.';
$string['core.user.completeprofilesupportsubject'] = 'أحتاج إلى مساعدة لإكمال ملفي الشخصي';
$string['core.user.completeyourprofile'] = 'أكمل ملفك الشخصي';
$string['core.user.contact'] = 'جهة اتصال';
$string['core.user.detailsnotavailable'] = 'تفاصيل هذا المستخدم غير متاحة لك.';
$string['core.user.errorloaduser'] = 'خطأ عند تحميل المستخدم.';
$string['core.user.sendemail'] = 'البريد الالكتروني';
$string['core.user.support'] = 'جهة اتصال الدعم الفني';
$string['core.user.supportsubject'] = '[App] {{subject}}';
$string['core.user.userwithid'] = 'المستخدم ذو المُعرَّف {{id}}';
$string['core.usernologin'] = 'تم سحب التفويض من هذا الحساب';
$string['core.viewcode'] = 'معاينة الترميز';
$string['core.vieweditor'] = 'معاينة المحرر';
$string['core.viewembeddedcontent'] = 'معاينة المحتوى المضمن';
$string['core.viewer.decreasetextsize'] = 'إنقاص حجم النص';
$string['core.viewer.enterreadingmode'] = 'الدخول إلى وضع القراءة';
$string['core.viewer.exitreadingmode'] = 'الخروج من وضع القراءة';
$string['core.viewer.increasetextsize'] = 'زيادة حجم النص';
$string['core.viewer.openreadingmodesettings'] = 'فتح إعدادات وضع القراءة';
$string['core.viewer.readingthemeauto'] = 'مضاهاة التطبيق';
$string['core.viewer.readingthemedark'] = 'داكن';
$string['core.viewer.readingthemehcm'] = 'تباين عال';
$string['core.viewer.readingthemelight'] = 'فاتح';
$string['core.viewer.readingthemesepia'] = 'بني داكن';
$string['core.wanttochangesite'] = 'أتريد تبديل الموقع أو تسجيل الخروج؟';
$string['core.warningofflinedatadeleted'] = 'لقد تم تجاهل التغييرات بدون الاتصال لـ {{component}} \'{{name}}\'. {{error}}';
$string['core.warningofflinedatadeletedreason'] = 'تعديلات أحدث في هذا النشاط قد تمت من جهاز آخر.';
$string['core.warnopeninbrowser'] = '<p>إنك بصدد ترك التطبيق لفتح الرابط الآتي في مستعرض الويب لجهازك. هل ترغب بالمتابعة؟</p>
<p><b>{{url}}</b></p>';
$string['core.whyisthishappening'] = 'لماذا يحدث هذا؟';
$string['core.wsfunctionnotavailable'] = 'وظيفة خدمة الويب غير متاحة.';
$string['core.youreoffline'] = 'جهازك غير متصل';
$string['core.youreonline'] = 'جازك عاد متصلاً';
$string['core.zoomin'] = 'تقريب';
$string['core.zoomout'] = 'تبعيد';
$string['freemium.biometriclogin'] = 'تسجيل الدخول بايومتريًا';
$string['freemium.biometriclogindescription'] = 'ضع إصبعك في قارئ بصمة الإصبع.';
$string['freemium.biometricloginenablefaceid'] = 'تمكين مُعرَّف الوجه';
$string['freemium.biometricloginenablefingerprint'] = 'تمكين بصمة الإصبع';
$string['freemium.biometricloginenabletouchid'] = 'تمكين مُعرَّف اللمس';
$string['freemium.biometricloginloginwithfaceid'] = 'تسجيل الدخول بمُعرَّف الوجه';
$string['freemium.biometricloginloginwithfingerprint'] = 'تسجيل الدخول ببصمة الإصبع';
$string['freemium.biometricloginloginwithtouchid'] = 'تسجيل الدخول بمُعرَّف اللمس';
$string['freemium.biometricloginskip'] = 'التخطي الآن';
$string['freemium.biometricloginsuccessfullyenabled'] = '{{ biometricMethod }} تم تمكينها.';
$string['freemium.biometricloginturnoff'] = 'يمكنك تشغيل هذه الميزة أو تعطيلها في أي وقت من الإعدادات.';
$string['freemium.biometriclogintypefaceid'] = 'مُعرَّف الوجه';
$string['freemium.biometriclogintypefingerprint'] = 'بصمة الإصبع';
$string['freemium.biometriclogintypetouchid'] = 'مُعرَّف البصمة';
$string['freemium.biometricloginwithfingerorface'] = 'استعمل تسجيل الدخول البايومتري عبر بصمة الإصبع أو الوجه.';
$string['freemium.change'] = 'تغيير';
$string['freemium.coursesbatchdownloaddisabled'] = 'تنزيل المقررات بالجملة غير مُمَكَّن في هذا الموقع.';
$string['freemium.coursesdownloadlimitreached'] = 'تنزيل المساقات بلغ حده الأقصى! يمكنك فقط تنزيل {{limit}} من المقررات. تواصل مع مشرفك لزيادة هذا العدد أو أزل بعض المقررات المُنزلة من جهازك.';
$string['freemium.downloadmainapplicationrequired'] = 'يمكنك الاتصال بهذا الموقع حصرًا باستعمال التطبيق المخصص.';
$string['freemium.downloadmainapplicationsuggestion'] = 'الموقع الذي تحاول الاتصال به يمتلك تطبيقًا مخصصًا قد ترغب بتجربته.';
$string['freemium.feature_biometriclogin'] = 'الدخول البايومتري';
$string['freemium.feature_coursesdownload'] = 'المقررات المُنزلة';
$string['freemium.feature_multimediapushnotifications'] = 'دفع إشعارات متعددات الوسائط';
$string['freemium.feature_pushnotificationsdevices'] = 'أجهزة دفق الإشعارات';
$string['freemium.feature_qrlogin'] = 'التفويض باستعمال رمز الاستجابة السريعة';
$string['freemium.feature_remotethemes'] = 'القوالب البعيدة';
$string['freemium.feature_sitelogo'] = 'شعار الموقع';
$string['freemium.notallowed'] = 'غير مسموح';
$string['freemium.nottoday'] = 'ليس اليوم';
$string['freemium.qrlogindisabled'] = 'التفويض باستعمال رمز الاستجابة السريعة غير مُمَكَّن في الموقع:<br><br>{{url}}';
$string['freemium.qrloginexpiredkey'] = 'رمز الاستجابة السريعة انتهت صلاحيته. يرجى تنشيط الصفحة ذات رمز الاستجابة السريعة لمسح الرمز مجددًا.';
$string['freemium.qrloginipmismatch'] = 'الجهاز الذي تستعمله لغرض الاتصال لا يبدو أنه ضمن نفس الشبكة التي فيها الجهاز العارض لرمز الاستجابة السريعة. يرجى التأكد من أن الجهازين كليهما متصلان مع نفس الشبكة (أي نفس الشبكة اللاسلكية).<br><br>إذا تكرر هذا الخطأ، تواصل رجاءً مع مشرف موقعك.';
$string['freemium.ratetheapp'] = 'هل تستمتع بتطبيقنا؟';
$string['freemium.ratetheapp_feedbackko'] = 'أخبرنا بما سار على نحو خاطئ';
$string['freemium.ratetheapp_feedbackmessage'] = 'إفادتك ستكون مجردة من هويتك';
$string['freemium.ratetheapp_feedbackok'] = 'إرسال الإفادة';
$string['freemium.ratetheapp_feedbackplaceholder'] = 'أكتب شيئًا هنا';
$string['freemium.ratetheapp_feedbacksent'] = 'شكرًا! إفادتك أُرسلت بنجاح.';
$string['freemium.ratetheapp_sendtostore'] = 'أتعطينا من وقتك برهة لتقييم تطبيقنا؟ هذا سيساعدنا في تحسينه.';
$string['freemium.remindmelater'] = 'ذكِّرني لاحقًا';
$string['freemium.settingsoptionsfacial'] = 'تمكين تسجيل الدخول بالوجه';
$string['freemium.settingsoptionsfingerprint'] = 'تمكين تسجيل الدخول ببصمة الإصبع';
$string['freemium.subscription'] = 'الاشتراك بالموقع';
$string['freemium.subscriptiondetails'] = 'تفاصيل الاشتراك';
$string['freemium.subscriptionfeature_exceeded_customlanguagestrings'] = '{{ overflowCount }} من جُمل اللغة المخصصة قد تم تجاهلها';
$string['freemium.subscriptionfeature_exceeded_custommenuitems'] = '{{ overflowCount }} من عناصر القائمة المخصصة قد تم تجاهلها';
$string['freemium.subscriptionfeature_exceeded_disabledfeatures'] = '{{ overflowCount }} من الميزات المُعطلة لا زالت مُمَكَّنة';
$string['freemium.subscriptionfeature_exceeded_remotethemes'] = 'لم يتم تطبيق قالبك المخصص';
$string['freemium.subscriptionfeature_exceeded_sitelogo'] = 'لم يتم تطبيق شعار موقعك';
$string['freemium.subscriptionfeature_limited'] = 'محدد إلى {{ limit }}';
$string['freemium.subscriptionfeature_unlimited'] = 'غير محدد';
$string['freemium.subscriptionplan'] = 'خطة الاشتراك';
$string['freemium.subscriptionplan_expired'] = 'منتهِ الصلاحية';
$string['freemium.subscriptionplan_free'] = 'مجانًا';
$string['freemium.subscriptionplan_upgrade'] = 'قم بترقية خطتك';
$string['freemium.subscriptionplan_validuntil'] = 'صالح حتى {{ date }}';
$string['freemium.subscriptionplandescription'] = 'خطط الاشتراك تحدد القيود المطبقة على هذا الموقع.';
$string['freemium.subscriptionplanlearnmore'] = 'معرفة المزيد';
$string['freemium.upsell_renewexpired'] = 'انتهت صلاحية اشتراكك';
$string['freemium.upsell_renewexpiring'] = 'ستنتهي صلاحية اشتراكك في غضون {{ days }} من الأيام';
$string['freemium.upsell_renewtitle'] = 'تجديد إشتراكك';
$string['freemium.upsell_upgradefreeaccept'] = 'ترقية';
$string['freemium.upsell_upgradefreemessage'] = 'حاليًا أنت تستعمل الخطة المجانية. قم بالترقية لتمكين مزايا أكثر.';
$string['freemium.upsell_upgradefreepostpone'] = 'لاحقًا';
$string['freemium.upsell_upgradefreetitle'] = 'ترقية خطتك';
$string['pluginname'] = 'جُمل لغة جوال مودل';
$string['privacy_metadata'] = 'هذا الملحق لا يخزن بيانات أي مستخدم.';
$string['workplace.teams.isoverdue'] = 'لديها عناصر مستوجبة أو منتهية الصلاحية';
