<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'backup', language 'lt', version '4.5'.
 *
 * @package     backup
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['asyncbackupcomplete'] = 'Atsarginės kopijos kūrimo procesas baigtas';
$string['asyncbackupcompletebutton'] = 'Tęsti';
$string['asyncbackupcompletedetail'] = 'Atsarginės kopijos kūrimo procesas sėkmingai baigtas. <br/> Atsarginę kopiją galite pasiekti <a href="{$a}">atkūrimo puslapyje.</a>';
$string['asyncbackuperror'] = 'Atsarginės kopijos kūrimo procesas nepavyko';
$string['asyncbackuperrordetail'] = 'Atsarginės kopijos kūrimo procesas nepavyko. Prašome susisiekti su sistemos administratoriumi.';
$string['asyncbackuppending'] = 'Atsarginės kopijos procesas laukiamas';
$string['asyncbackupprocessing'] = 'Vyksta atsarginis kopijavimas';
$string['asyncbadexecution'] = 'Netinkamas atsarginės kopijos valdiklio vykdymas. Tai yra {$a} ir turėtų būti 2.';
$string['asynccheckprogress'] = 'Galite bet kada patikrinti eigą <a href="{$a}">atkūrimo puslapyje</a>.';
$string['asyncemailenable'] = 'Įjungti pranešimus';
$string['asyncemailenabledetail'] = 'Jei įjungta, naudotojai gaus pranešimą, kai bus baigtas asinchroninis atsarginis kopijavimas arba atkūrimas.';
$string['asyncgeneralsettings'] = 'Asinchroninis atsarginis kopijavimas / atkūrimas';
$string['asyncmessagebody'] = 'Pranešimas';
$string['asyncmessagebodydefault'] = 'Jūsų {operation} (ID: {backupid}) sėkmingai baigta. Ją galite pasiekti čia: <a href="{link}">{link}</a>.';
$string['asyncmessagebodydetail'] = 'Pranešimas, siunčiamas užbaigus asinchroninę atsarginę kopiją arba atkūrimą.';
$string['asyncmessagesubject'] = 'Tema';
$string['asyncmessagesubjectdefault'] = 'Moodle {operation} sėkmingai baigta';
$string['asyncmessagesubjectdetail'] = 'Pranešimo tema';
$string['asyncnowait'] = 'Jums nereikia čia laukti, nes procesas tęsis fone.';
$string['asyncprocesspending'] = 'Procesas vykdomas';
$string['asyncrestorecomplete'] = 'Atkūrimo procesas baigtas';
$string['asyncrestorecompletebutton'] = 'Tęsti';
$string['asyncrestorecompletedetail'] = 'Atkūrimo procesas sėkmingai baigtas. Spustelėję tęsti pateksite į <a href="{$a}">atkurto elemento kursą</a>.';
$string['asyncrestoreerror'] = 'Atkūrimo procesas nepavyko';
$string['asyncrestoreerrordetail'] = 'Atkūrimo procesas nepavyko. Prašome susisiekti su sistemos administratoriumi.';
$string['asyncrestoreinprogress'] = 'Atkuriama';
$string['asyncrestoreinprogress_help'] = 'Čia rodomi vykdomi asinchroniniai kurso atkūrimai.';
$string['asyncrestorepending'] = 'Atkūrimo procesas dar nebaigtas';
$string['asyncrestoreprocessing'] = 'Vyksta atkūrimas';
$string['asyncreturn'] = 'Grįžti į kursą';
$string['autoactivedescription'] = 'Pasirinkite, ar reikia automatiškai kurti atsargines kopijas. Jei pasirinktas neautomatinis konfigūravimas, atsargines kopijas automatiškai bus galima kurti tik naudojant automatinio atsarginių kopijų kūrimo CLI scenarijų. Tai galima padaryti neautomatiniu būdu komandų eilutėje arba naudojant „Cron“.';
$string['autoactivedisabled'] = 'Išjungta';
$string['autoactiveenabled'] = 'Įjungta';
$string['autoactivemanual'] = 'Neautomatinis';
$string['automatedbackupschedule'] = 'Grafikas';
$string['automatedbackupschedulehelp'] = 'Pasirinkite, kuriomis savaitės dienomis automatiškai kurti atsargines kopijas.';
$string['automatedbackupsinactive'] = 'Svetainės administratorius neįjungė automatinių atsarginių kopijų';
$string['automatedbackupstatus'] = 'Automatinio atsarginių kopijų kūrimo būsena';
$string['automateddeletedays'] = 'Trinti atsargines kopijas senesnes nei';
$string['automatedmaxkept'] = 'Laikomų atsarginių kopijų didžiausias skaičius';
$string['automatedmaxkepthelp'] = 'Tai nurodo didžiausią laikomų kiekviename kurse paskutinių automatinių atsarginių kopijų skaičių. Senesnės atsarginės kopijos bus automatiškai ištrintos.';
$string['automatedminkept'] = 'Laikomų atsarginių kopijų mažiausias skaičius';
$string['automatedminkepthelp'] = 'Jei ištrinamos senesnės nei tam tikras dienų skaičius atsarginės kopijos, gali atsitikti taip, kad neaktyvus kursas baigsis be atsarginės kopijos. Norint to išvengti, reikia nurodyti minimalų atsarginių kopijų skaičių.';
$string['automatedsettings'] = 'Automatinio atsarginių kopijų kūrimo parametrai';
$string['automatedsetup'] = 'Automatinio atsarginių kopijų kūrimo sąranka';
$string['automatedstorage'] = 'Automatiškai sukurtų atsarginių kopijų saugykla';
$string['automatedstoragehelp'] = 'Pasirinkite vietą, kurioje norite saugoti automatiškai sukurtas atsargines kopijas.';
$string['backupactivity'] = 'Kurti atsarginę veiklos kopiją: {$a}';
$string['backupautoactivitiesdescription'] = 'Nustato numatytuosius veiklos įtraukimo į atsarginę kopiją nustatymus. Kad šiukšliadėžė veiktų, šis nustatymas turi būti įjungtas.';
$string['backupcourse'] = 'Kurti atsarginę kurso kopiją: {$a}';
$string['backupcoursedetails'] = 'Išsami kurso informacija';
$string['backupcoursesection'] = '{$a} dalis';
$string['backupcoursesections'] = 'Kurso dalys';
$string['backupdate'] = 'Sukūrimo data';
$string['backupdetails'] = 'Išsami atsarginės kopijos informacija';
$string['backupdetailsnonstandardinfo'] = 'Pasirinktas failas nėra standartinės Moodle atsarginės kopijos failas. Atkūrimo procesas pabandys konvertuoti atsarginę kopiją į standartinį formatą ir atkurti ją.';
$string['backupfile'] = 'Atsarginės kopijos failas';
$string['backupformat'] = 'Formatas';
$string['backupformatimscc1'] = 'IMS Common Cartridge 1.0';
$string['backupformatimscc11'] = 'IMS Common Cartridge 1.1';
$string['backupformatmoodle1'] = '„Moodle 1“';
$string['backupformatmoodle2'] = '„Moodle 2“';
$string['backupformatunknown'] = 'Nežinomas formatas';
$string['backuplog'] = 'techninė informacija ir įspėjimai';
$string['backupmode'] = 'Režimas';
$string['backupmode10'] = 'Bendra';
$string['backupmode20'] = 'Importuoti';
$string['backupmode30'] = 'Koncentratorius';
$string['backupmode40'] = 'Tas pats puslapis';
$string['backupmode50'] = 'Automatizuotas';
$string['backupmode60'] = 'Konvertuotas';
$string['backupmode70'] = 'Asinchroninis';
$string['backupsection'] = 'Kurti atsarginę kursų dalies kopiją: {$a}';
$string['backupsettings'] = 'Atsarginės kopijos parametrai';
$string['backupsitedetails'] = 'Išsami svetainės informacija';
$string['backupstage16action'] = 'Tęsti';
$string['backupstage1action'] = 'Pirmyn';
$string['backupstage2action'] = 'Pirmyn';
$string['backupstage4action'] = 'Kurti atsarginę kopiją';
$string['backupstage8action'] = 'Tęsti';
$string['backupthenrestore'] = 'Atsarginės kopijos kūrimas baigtas. Pradėkite atkurti.';
$string['backuptype'] = 'Tipas';
$string['backuptypeactivity'] = 'Veikla';
$string['backuptypecourse'] = 'Kursas';
$string['backuptypesection'] = 'Skyrius';
$string['backupversion'] = 'Atsarginės kopijos versija';
$string['cannotfindassignablerole'] = '{$a} vaidmens atsarginės kopijos faile negalima susieti su jokiais vaidmenimis, kuriuos galite priskirti.';
$string['choosefilefromactivitybackup'] = 'Veiklos atsarginės kopijos sritis';
$string['choosefilefromactivitybackup_help'] = 'Šios veiklos atsarginės kopijos failai.';
$string['choosefilefromautomatedbackup'] = 'Automatinės atsarginės kopijos';
$string['choosefilefromautomatedbackup_help'] = 'Automatiškai sukuriamos atsarginės kopijos.';
$string['choosefilefromcoursebackup'] = 'Kursų atsarginės kopijos sritis';
$string['choosefilefromcoursebackup_help'] = 'Šio kurso atsarginių kopijų failai.';
$string['choosefilefromuserbackup'] = 'Naudotojo asmeninė atsarginės kopijos sritis';
$string['choosefilefromuserbackup_help'] = 'Privačios visų kursų atsarginės kopijos su anonimine naudotojo informacija.';
$string['config_keep_groups_and_groupings'] = 'Pagal numatytuosius nustatymus palikti esamas grupes ir grupavimus.';
$string['config_keep_roles_and_enrolments'] = 'Pagal numatytuosius nustatymus palikti dabartinius vaidmenis ir registracijas.';
$string['config_overwrite_conf'] = 'Leisti naudotojui keisti dabartinę kurso konfigūraciją';
$string['config_overwrite_course_fullname'] = 'Pagal numatytuosius nustatymus perrašyti visą kurso pavadinimą į kurso pavadinimą iš atsarginės kopijos failo. Tam reikia pažymėti "Perrašyti kurso konfigūraciją" ir dabartinis naudotojas turi turėti galimybę pakeisti visą kurso pavadinimą (moodle/course:changefullname)';
$string['config_overwrite_course_shortname'] = 'Pagal numatytuosius nustatymus perrašyti trumpąjį kurso pavadinimą pavadinimu iš atsarginės kopijos failo. Tam reikia pažymėti "Perrašyti kurso konfigūraciją" ir dabartinis naudotojas turi turėti galimybę pakeisti trumpąjį kurso pavadinimą (moodle/course:changeshortname)';
$string['config_overwrite_course_startdate'] = 'Pagal numatytuosius nustatymus perrašyti kurso pradžios datą į tą, kuri yra atsarginės kopijos faile. Tam reikia pažymėti "Perrašyti kurso konfigūraciją", o dabartinis naudotojas turi turėti galimybę atkurti kurso datas (moodle/restore:rolldates)';
$string['configgeneralactivities'] = 'Nustato numatytąją veiklų įtraukimo į atsarginę kopiją reikšmę.';
$string['configgeneralanonymize'] = 'Jei įjungta, visos informacijos susiejimas su naudotojais bus padarytas anoniminiu pagal numatytuosius nustatymus.';
$string['configgeneralbadges'] = 'Nustato numatytąją blokų įtraukimo į atsarginę kopiją reikšmę.';
$string['configgeneralblocks'] = 'Nustato numatytąją blokų įtraukimo į atsarginę kopiją reikšmę.';
$string['configgeneralcalendarevents'] = 'Nustato numatytąją kalendoriaus įvykių įtraukimo į atsarginę kopiją reikšmę.';
$string['configgeneralcomments'] = 'Nustato numatytąją komentarų įtraukimo į atsarginę kopiją reikšmę.';
$string['configgeneralcompetencies'] = 'Nustato numatytąją kompetencijų įtraukimo į atsarginę kopiją reikšmę.';
$string['configgeneralcontentbankcontent'] = 'Nustato numatytąjį turinio banko turinio įtraukimo į atsarginę kopiją vertę.';
$string['configgeneralfiles'] = 'Nustato numatytąjį failų įtraukimą į atsarginę kopiją. Atkreipkite dėmesį: išjungus šį nustatymą bus sukurta atsarginė kopija, kurioje bus tik nuorodos į failus. Tai nėra problema, jei atsarginė kopija bus atkurta toje pačioje svetainėje, o failai nebuvo ištrinti pagal nustatymą „Išvalyti šiukšliadėžės failus“ (filescleanupperiod).';
$string['configgeneralfilters'] = 'Nustato numatytąją filtrų įtraukimo į atsarginę kopiją reikšmę.';
$string['configgeneralgroups'] = 'Nustato numatytąją grupių ir grupavimo įtraukimo į atsarginę kopiją reikšmę.';
$string['configgeneralhistories'] = 'Nustato numatytąją naudotojo retrospektyvos įtraukimo į atsarginę kopiją reikšmę.';
$string['configgenerallogs'] = 'Jei įjungta, žurnalai bus įtraukti į atsargines kopijas pagal numatytuosius nustatymus.';
$string['configgeneralpermissions'] = 'Jei įjungta, vaidmens leidimai bus importuoti. Tai gali nepaisyti esamų užsiregistravusių naudotojų leidimų.';
$string['configgeneralquestionbank'] = 'Jei šis parametras įjungtas, klausimų bankas bus įtrauktas į kopijas automatiškai. SVARBU: Išjungus šį parametrą jis išjungs tam tikrų veiklų, tokių kaip testas, įtraukimą į kopijas.';
$string['configgeneralroleassignments'] = 'Jei įjungta, pagal numatytuosius nustatymus bus sukurta ir vaidmenų priskyrimų atsarginė kopija.';
$string['configgeneralusers'] = 'Nustato numatytąjį naudotojų įtraukimo į atsargines kopijas nustatymą.';
$string['configgeneraluserscompletion'] = 'Jei įjungta, naudotojų kurso baigimo informacija bus įtraukta į atsargines kopijas pagal numatytuosius nustatymus.';
$string['configgeneralxapistate'] = 'Nustato numatytąją naudotojo būsenos įtraukimo į turinį, pvz., H5P veiklą atsarginėje kopijoje, nuostatą.';
$string['configlegacyfiles'] = 'Nustato numatytuosius nustatymus, kaip įtraukti senų kursų failus į atsarginę kopiją. Senieji kursų failai yra iš ankstesnių 2.0 Moodle versijų.';
$string['configloglifetime'] = 'Šis parametras nurodo laiką, kurį bus laikomos log įrašų kopijos. Log įrašai, kurie yra senesni nei nurodytas laikas, yra ištrinami automatiškai. Rekomenduojama laikyti šį parametrą mažą, nes log įrašų kiekis gali būti milžiniškas.';
$string['configrestoreactivities'] = 'Nustato numatytąją veiklų atkūrimo reikšmę.';
$string['configrestorebadges'] = 'Nustato numatytąją pasiekimų atkūrimo reikšmę.';
$string['configrestoreblocks'] = 'Nustato numatytąją blokų atkūrimo reikšmę.';
$string['configrestorecalendarevents'] = 'Nustato numatytąją kalendoriaus įvykių atkūrimo reikšmę.';
$string['configrestorecomments'] = 'Nustato numatytąją komentarų atkūrimo reikšmę.';
$string['configrestorecompetencies'] = 'Nustato numatytąją kompetencijų atkūrimo reikšmę.';
$string['configrestorecontentbankcontent'] = 'Nustato numatytuosius turinio banko turinio atkūrimo nustatymus.';
$string['configrestorecustomfield'] = 'Nustato numatytuosius pasirinktinių laukų atkūrimo nustatymus.';
$string['configrestoreenrolments'] = 'Nustato numatytąją įregistravimo metodų atkūrimo reikšmę.';
$string['configrestorefilters'] = 'Nustato numatytąją filtrų atkūrimo reikšmę.';
$string['configrestoregroups'] = 'Nustato numatytąją grupių ir grupavimų, jei yra įtraukta į atsarginę kopiją, atkūrimo reikšmę.';
$string['configrestorehistories'] = 'Nustato numatytąją naudotojų retrospektyvos, jei yra įtraukta į atsarginę kopiją, atkūrimo reikšmę.';
$string['configrestorelogs'] = 'Jei įjungta, žurnalai bus atkurti pagal numatytuosius nustatymus, jei jie buvo įtraukti į atsarginę kopiją.';
$string['configrestorepermissions'] = 'Jei įjungta, vaidmens leidimai bus atkurti. Tai gali nepaisyti esamų užsiregistravusių vartotojų leidimų.';
$string['configrestoreroleassignments'] = 'Jei įgalinta pagal numatytuosius nustatymus, vaidmenų priskyrimai bus atstatyti, jei jie buvo įtraukti į atsarginę kopiją.';
$string['configrestoreusers'] = 'Nustato numatytąją naudotojų įtraukimo, jei jie buvo įtraukti į atsarginę kopiją, atkūrimo reikšmę.';
$string['configrestoreuserscompletion'] = 'Jei įjungta, naudotojų kurso baigimo informacija bus atkurta pagal nutylėjimą, jei buvo įtraukta į atsarginę kopiją.';
$string['configrestorexapistate'] = 'Nustatoma numatytoji naudotojo būsenos atkūrimo numatytoji reikšmė turinyje, pvz., H5P veikloje.';
$string['confirmcancel'] = 'Atšaukti atsarginių kopijų kūrimą';
$string['confirmcancelimport'] = 'Atšaukti įkėlimą';
$string['confirmcancelno'] = 'Neatšaukti';
$string['confirmcancelquestion'] = 'Ar tikrai norite atšaukti? Visa įvesta informacija bus prarasta.';
$string['confirmcancelrestore'] = 'Atšaukti atkūrimą';
$string['confirmcancelyes'] = 'Atšaukti atsarginį kopijavimą';
$string['confirmnewcoursecontinue'] = 'Naujo kurso įspėjimas';
$string['confirmnewcoursecontinuequestion'] = 'Laikinas (paslėptas) kursas bus sukurtas pagal kurso atkūrimo procesą. Atšaukti restauraciją spausite atšaukti. Neišjunkite naršyklės kol restauruojama.';
$string['copiesinprogress'] = 'Šio kurso kopijos yra vykdomos. <a href="////a//"> Peržiūrėkite vykdomas kopijas. </a>';
$string['copycoursedesc'] = 'Sukurkite šio kurso kopiją bet kurioje kurso kategorijoje.';
$string['copycourseheading'] = 'Kopijuoti kursą';
$string['copycoursetitle'] = 'Kopijuoti kursą: {$a}';
$string['copydest'] = 'Tikslas';
$string['copyfieldnotfound'] = 'Reikalingi lauko duomenys nerasti laukui (-ams): {$a}';
$string['copyformfail'] = 'AJAX nepavyko pateikti kurso kopijos formos.';
$string['copyingcourse'] = 'Kurso kopijavimas vyksta';
$string['copyingcourseshortname'] = 'kopijuojama';
$string['copyop'] = 'Dabartinė operacija';
$string['copyprogressheading'] = 'Vyksta kurso kopijavimas';
$string['copyprogressheading_help'] = 'Šioje lentelėje rodoma visų jūsų nebaigtų kursų kopijų būsena.';
$string['copyprogresstitle'] = 'Kurso kopijavimo eiga';
$string['copyreturn'] = 'Kopijuoti ir grįžti';
$string['copysource'] = 'Šaltinis';
$string['copyview'] = 'Kopijuoti ir peržiūrėti';
$string['coursecategory'] = 'Kategorija, į kurią bus atkurtas kursas';
$string['courseid'] = 'Pradinis ID';
$string['coursesettings'] = 'Kursų parametrai';
$string['coursetitle'] = 'Pavadinimas';
$string['currentstage1'] = 'Pradiniai parametrai';
$string['currentstage16'] = 'Užbaigti';
$string['currentstage2'] = 'Schemos parametrai';
$string['currentstage4'] = 'Patvirtinimas ir peržiūra';
$string['currentstage8'] = 'Kurti atsarginę kopiją';
$string['enableasyncbackup'] = 'Įgalinti asinchronines atsargines kopijas';
$string['enableasyncbackup_help'] = 'Jei įjungta, atsarginės kopijos kūrimo ir atkūrimo operacijos bus atliekamos asinchroniškai. Taip užtikrinama geresnė naudotojo patirtis, todėl naudotojai gali atlikti kitas operacijas, kol atliekama atsarginė kopija arba atkuriama. Tai neturi įtakos importui ir eksportui.';
$string['enterasearch'] = 'Įvesti iešką';
$string['error_block_for_module_not_found'] = 'Pirmas vienišas bloko įvykis (id: {$a->bid}) kurso moduliui (id: {$a->mid})  rastas. Šiam blokui nebus daroma atsarginė kopija';
$string['error_course_module_not_found'] = 'Vienišas kurso modulis (id: {$a}) rastas. Šis modulis nebus įtrauktas į atsarginę kopiją.';
$string['errorcopyingbackupfile'] = 'Nepavyko nukopijuoti atsarginės kopijos failo į laikiną aplanką prieš atkūrimą.';
$string['errorfilenamemustbezip'] = 'Įvestas failo vardas turi būti ZIP failas, o jo plėtinys turi būti .mbz';
$string['errorfilenamerequired'] = 'Turite įvesti galiojantį šios atsarginės kopijos failo vardą';
$string['errorfilenametoolong'] = 'Failo pavadinimas turi būti ne ilgesnis nei 255 simboliai.';
$string['errorinvalidformat'] = 'Klaidingas atsarginės kopijos formatas.';
$string['errorinvalidformatinfo'] = 'Pasirinktas failas nėra galiojanti Moodle atsarginė kopija ir negali būti atkurta.';
$string['errorminbackup20version'] = 'Šis atsarginės kopijos failas sukurtas naudojant vieną „Moodle“ atsarginės kopijos diegimo versiją ({&a->backup}). Būtinas minimumas yra {$S->min}. Atkurti negalima.';
$string['errorrestorefrontpagebackup'] = 'Pirmojo svetainės puslapio atsargines kopijas galima atkurti tik pirmajame puslapyje';
$string['executionsuccess'] = 'Atsarginės kopijos failas sėkmingai sukurtas.';
$string['extractingbackupfileto'] = 'Išskleidžiamas atsarginės kopijos failas: {$ a}';
$string['failed'] = 'Atsarginis kopijavimas nepavyko';
$string['filealiasesrestorefailures'] = 'Slapyvardžių atkūrimo nesėkmės';
$string['filealiasesrestorefailures_help'] = 'Slapyvardžiai yra simbolinės nuorodos į kitus failus, įskaitant tuos, kurie saugomi išorinėse saugyklose. Kai kuriais atvejais Moodle negali jų atkurti – pavyzdžiui, atkuriant atsarginę kopiją kitoje svetainėje arba kai nurodyto failo nėra.

Daugiau informacijos ir tikrąją nesėkmės priežastį rasite atkūrimo žurnalo faile.';
$string['filealiasesrestorefailures_link'] = 'restore/filealiases';
$string['filealiasesrestorefailuresinfo'] = 'Kai kurių į atsarginės kopijos failą įtrauktų slapyvardžių atkurti nepavyko. Šiame sąraše yra numatoma jų vieta ir šaltinio failas, į kurį jie nurodė pirminėje svetainėje.';
$string['filename'] = 'Failo pavadinimas';
$string['filereferencesincluded'] = 'Išorinio turinio failo nuorodos įtrauktos į atsarginės kopijos failą. Jos neveiks, jei atsarginė kopija bus atkurta kitoje svetainėje.';
$string['filereferencesnotsamesite'] = 'Atsarginės kopijos failas yra iš kitos svetainės, todėl failo nuorodos negali būti atkurtos.';
$string['filereferencessamesite'] = 'Atsarginės kopijos failas  yra iš tos pačios svetainės, todėl failo nuorodos gali būti atkurtos.';
$string['generalactivities'] = 'Įtraukti veiklas ir išteklius';
$string['generalanonymize'] = 'Informaciją padaryti anonimine';
$string['generalbackdefaults'] = 'Bendrosios atsarginės versijos numatytosios reikšmės';
$string['generalbadges'] = 'Įtraukti pasiekimus';
$string['generalblocks'] = 'Įtraukti blokus';
$string['generalcalendarevents'] = 'Įtraukti kalendoriaus įvykius';
$string['generalcomments'] = 'Įtraukti komentarus';
$string['generalcompetencies'] = 'Įtraukti kompetencijas';
$string['generalcontentbankcontent'] = 'Įtraukti turinio banko turinį';
$string['generalcustomfield'] = 'Įtraukti pasirinktinius laukus';
$string['generalenrolments'] = 'Įtraukti įregistravimo metodus';
$string['generalfiles'] = 'Įtraukti failus';
$string['generalfilters'] = 'Įtraukti filtrus';
$string['generalgradehistories'] = 'Įtraukti retrospektyvas';
$string['generalgroups'] = 'Įtraukti grupes ir grupavimus';
$string['generalhistories'] = 'Įtraukti istorijas';
$string['generallegacyfiles'] = 'Įtraukti senus kursų failus';
$string['generallogs'] = 'Įtraukti žurnalus';
$string['generalpermissions'] = 'Įtraukti leidimo nepaisymą';
$string['generalquestionbank'] = 'Įtraukti klausimų banką';
$string['generalrestoredefaults'] = 'Bendrosios atkūrimo numatytosios reikšmės';
$string['generalrestoresettings'] = 'Bendrieji atkūrimo nustatymai';
$string['generalroleassignments'] = 'Įtraukti vaidmenų priskyrimus';
$string['generalsettings'] = 'Bendri atsarginių kopijų nustatymai';
$string['generalusers'] = 'Įtraukti naudotojus';
$string['generaluserscompletion'] = 'Įtraukti naudotojo kurso baigimo informaciją';
$string['generalxapistate'] = 'Įtraukti naudotojo būseną į turinį, pvz., H5P veiklas';
$string['hidetypes'] = 'Slėpti tipo parinktis';
$string['importbackupstage16action'] = 'Tęsti';
$string['importbackupstage1action'] = 'Pirmyn';
$string['importbackupstage2action'] = 'Pirmyn';
$string['importbackupstage4action'] = 'Importuoti';
$string['importbackupstage8action'] = 'Tęsti';
$string['importcurrentstage0'] = 'Kursų pasirinkimas';
$string['importcurrentstage1'] = 'Pradiniai parametrai';
$string['importcurrentstage16'] = 'Užbaigti';
$string['importcurrentstage2'] = 'Schemos parametrai';
$string['importcurrentstage4'] = 'Patvirtinimas ir peržiūra';
$string['importcurrentstage8'] = 'Importuoti';
$string['importfile'] = 'Įkelti atsarginę kopiją';
$string['importfromccmidtocourse'] = 'Importuoti iš cmid:{$a->srccmid} į kursą:{$a->dstcourseid}';
$string['importfromcoursetocourse'] = 'Importuoti iš course:{$a->srccourseid} į course:{$a->dstcourseid}';
$string['importgeneralduplicateadminallowed'] = 'Leisti administratoriaus konfliktų sprendimą';
$string['importgeneralduplicateadminallowed_desc'] = 'Jei svetainėje yra paskyra, kurios naudotojo vardas yra „admin“, bandymas atkurti atsarginės kopijos failą, kuriame yra paskyra naudotojo vardu „admin“, gali sukelti konfliktą. Jei šis nustatymas įgalintas, konfliktas bus išspręstas pakeitus naudotojo vardą atsarginės kopijos faile į „admin_xyz“.';
$string['importgeneralmaxresults'] = 'Maksimalus kursų skaičius sąraše skirtame importavimui.';
$string['importgeneralmaxresults_desc'] = 'Šis parametras kontroliuoja kursų skaičių rodomą pirmame importavimo proceso žingsnyje.';
$string['importgeneralsettings'] = 'Bendrosios importavimo numatytosios reikšmės';
$string['importrootsettings'] = 'Importuoti nustatymus';
$string['importsettings'] = 'Bendrieji importavimo nustatymai';
$string['importsuccess'] = 'Importavimas baigtas. Spragtelėkite Tęsti, kad sugrįžtumėte į kursą.';
$string['includeactivities'] = 'Įterpti:';
$string['includeditems'] = 'Įterpti elementai:';
$string['includefilereferences'] = 'Failų nuorodos į išorininį turinį';
$string['includesection'] = '{$a} dalis';
$string['includeuserinfo'] = 'Naudotojo duomenys';
$string['includeuserinfo_instance'] = 'Įtraukti {$a} naudotojo duomenis';
$string['inprogress'] = 'Vyksta atsarginis kopijavimas';
$string['jumptofinalstep'] = 'Pereiti prie paskutinio žingsnio';
$string['keep'] = 'Laikoma';
$string['keptroles'] = 'Įtraukti vaidmenų registracijas';
$string['keptroles_help'] = 'Naudotojai, turintys pasirinktus vaidmenis, bus įregistruoti į naują kursą. Jokie naudotojo duomenys nebus kopijuojami, nebent įjungta parinktis „Įtraukti naudotojo duomenis“.';
$string['locked'] = 'Užrakinta';
$string['lockedbyconfig'] = 'Šis parametras užrakintas pagal numatytuosius atsarginės kopijos kūrimo parametrus';
$string['lockedbyhierarchy'] = 'Užrakino priklausomybės';
$string['lockedbypermission'] = 'Neturite pakankamai teisių pakeisti šio parametro';
$string['loglifetime'] = 'Laikyti žurnalus';
$string['managefiles'] = 'Tvarkyti atsarginių kopijų failus';
$string['managefiles_activity'] = 'Tvarkyti veiklos atsargines kopijas';
$string['managefiles_automated'] = 'Tvarkyti automatines atsargines kopijas';
$string['managefiles_backup'] = 'Tvarkyti asmenines atsargines kopijas';
$string['managefiles_course'] = 'Tvarkyti kurso atsargines kopijas';
$string['mergerestoredefaults'] = 'Atkurti numatytąsias reikšmes, kai suliejama į kitą kursą';
$string['missingfilesinpool'] = 'Kai kurių failų negalima išsaugoti atsarginės kopijos metu, todėl jų nebus galima atkurti.';
$string['module'] = 'Modulis';
$string['moodleversion'] = '„Moodle“ versija';
$string['morecoursesearchresults'] = 'Daugiau nei {$a} kursų rasta, rodomi pirmi {$a} rezultatai';
$string['moreresults'] = 'Per daug rezultatų, konkrečiau apibrėžkite iešką.';
$string['nomatchingcourses'] = 'Nėra rodytinų kursų';
$string['norestoreoptions'] = 'Nėra kategorijų arba esamų kursų, į kuriuos galėtumėte sugrįžti.';
$string['originalwwwroot'] = 'Atsarginės kopijos URL';
$string['overwrite'] = 'Keisti';
$string['pendingasyncdeletedetail'] = 'Šio kurso asinchroninė atsarginė kopija laukiama. <br/> Kursų negalima ištrinti, kol nebus baigta kurti atsarginė kopija.';
$string['pendingasyncdetail'] = 'Asinchroninės atsarginės kopijos leidžia naudotojui vienu metu turėti tik vieną laukiančią atsarginę išteklių kopiją. <br/> Kelių to paties šaltinio asinchroninių atsarginių kopijų negalima įrašyti į eilę, nes greičiausiai bus sukurtos kelios atsarginės kopijos su tuo pačiu turiniu.';
$string['pendingasyncedit'] = 'Laukiama šio kurso atsarginė kopija arba kopija. Neredaguokite kurso, kol jis nebus baigtas.';
$string['pendingasyncerror'] = 'Laukiama atsarginės šio šaltinio kopijos';
$string['preparingdata'] = 'Duomenys ruošiami';
$string['preparingui'] = 'Ruošiamasi rodyti puslapį';
$string['previousstage'] = 'Ankstesnis';
$string['privacy:metadata:backup:detailsofarchive'] = 'Šiame archyve gali būti įvairių su kursu susijusių naudotojų duomenų, pvz., įvertinimų, naudotojų registracijų ir veiklos duomenų.';
$string['privacy:metadata:backup:externalpurpose'] = 'Šio archyvo tikslas – saugoti su kursu susijusią informaciją, kuri ateityje gali būti atkurta.';
$string['privacy:metadata:backup_controllers'] = 'Atsarginių operacijų sąrašas';
$string['privacy:metadata:backup_controllers:itemid'] = 'Kurso ID';
$string['privacy:metadata:backup_controllers:operation'] = 'Operacija, kuri buvo atlikta, pvz. atkurti.';
$string['privacy:metadata:backup_controllers:timecreated'] = 'Laikas, kai buvo sukurtas veiksmas';
$string['privacy:metadata:backup_controllers:timemodified'] = 'Laikas, kai veiksmas buvo pakeistas';
$string['privacy:metadata:backup_controllers:type'] = 'Eksploatuojamo elemento tipas, pvz. veikla.';
$string['qcategory2coursefallback'] = 'Klausimų kategorija {$a->name}, pradžioje buvusi atsarginės kopijos failo sistemos arba nuotolinių mokymų temų kontekste, atkūrus bus sukurta kursų kontekste';
$string['qcategorycannotberestored'] = 'Atkuriant klausimo kategorijos {$a->name} negalima sukurti';
$string['question2coursefallback'] = 'Klausimų kategorija {$a->name}, pradžioje buvusi atsarginės kopijos failo sistemos arba nuotolinių mokymų temų kontekste, atkūrus bus sukurta kursų kontekste';
$string['questioncannotberestored'] = 'Atkuriant klausimų {$a->name} negalima sukurti';
$string['recyclebin_desc'] = 'Atminkite, kad šie nustatymai taip pat bus naudojami šiukšliadėžei.';
$string['replacerestoredefaults'] = 'Atkurti numatytąsias reikšmes, kai atkuriant kursą ištrinamas turinys';
$string['restoreactivity'] = 'Atkurti veiklą';
$string['restorecourse'] = 'Atkurti kursą';
$string['restorecoursesettings'] = 'Kursų parametrai';
$string['restoredcourseid'] = 'Atkurto kurso ID: {$a}';
$string['restoreexecutionsuccess'] = 'Kursas buvo sėkmingai atkurtas.';
$string['restorefileweremissing'] = 'Kai kurie failai negali būti atkurti, nes jų trūksta atsarginėje kopijoje.';
$string['restorenewcoursefullname'] = 'Naujas kursų pavadinimas';
$string['restorenewcourseshortname'] = 'Naujas kursų trumpasis pavadinimas';
$string['restorenewcoursestartdate'] = 'Nauja pradžios data';
$string['restorenofilesbackuparea'] = 'Atsarginių kopijų failų dar nėra.';
$string['restorenofilesbackuparea_activity'] = 'Atsarginių šios veiklos kopijų failų dar nėra.';
$string['restorenofilesbackuparea_automated'] = 'Dar nėra automatinių atsarginių kopijų failų.';
$string['restorenofilesbackuparea_backup'] = 'Dar neturite privačių atsarginių kopijų failų.';
$string['restorenofilesbackuparea_course'] = 'Šio kurso atsarginių kopijų failų dar nėra.';
$string['restorerolemappings'] = 'Atkurti vaidmenų atvaizdavimus';
$string['restorerootsettings'] = 'Atkurti parametrus';
$string['restoresection'] = 'Atkurti dalį';
$string['restorestage1'] = 'Patvirtinti';
$string['restorestage16'] = 'Peržiūrėti';
$string['restorestage16action'] = 'Atkurti';
$string['restorestage1action'] = 'Pirmyn';
$string['restorestage2'] = 'Paskirtis';
$string['restorestage2action'] = 'Pirmyn';
$string['restorestage32'] = 'Apdoroti';
$string['restorestage32action'] = 'Tęsti';
$string['restorestage4'] = 'Parametrai';
$string['restorestage4action'] = 'Pirmyn';
$string['restorestage64'] = 'Užbaigti';
$string['restorestage64action'] = 'Tęsti';
$string['restorestage8'] = 'Schema';
$string['restorestage8action'] = 'Pirmyn';
$string['restoretarget'] = 'Atkurti tikslą';
$string['restoretocourse'] = 'Atkurti kursus:';
$string['restoretocurrentcourse'] = 'Atkurti į šį kursą';
$string['restoretocurrentcourseadding'] = 'Sulieti kurso atsarginę kopiją su šiuo kursu';
$string['restoretocurrentcoursedeleting'] = 'Naikinti šio kurso turinį, tada atkurti';
$string['restoretoexistingcourse'] = 'Atkurti į esamą kursą';
$string['restoretoexistingcourseadding'] = 'Sulieti kurso atsarginę kopiją su esamu kursu';
$string['restoretoexistingcoursedeleting'] = 'Naikinti esamų kursų turinį, tada atkurti';
$string['restoretonewcourse'] = 'Atkurti kaip naują kursą';
$string['restoringcourse'] = 'Vykdomas kursų atkūrimas';
$string['restoringcourseshortname'] = 'atkuriama';
$string['rootenrolmanual'] = 'Atkurti kaip rankiniu būdu užsiregistravusius';
$string['rootsettingactivities'] = 'Įtraukti veiklas ir išteklius';
$string['rootsettinganonymize'] = 'Naudotojo informaciją padaryti anonimiška';
$string['rootsettingbadges'] = 'Įtraukti pasiekimus';
$string['rootsettingblocks'] = 'Įtraukti blokus';
$string['rootsettingcalendarevents'] = 'Įtraukti kalendoriaus įvykius';
$string['rootsettingcomments'] = 'Įtraukti komentarus';
$string['rootsettingcompetencies'] = 'Įtraukti kompetencijas';
$string['rootsettingcontentbankcontent'] = 'Įtraukti turinio banko turinį';
$string['rootsettingcustomfield'] = 'Įtraukti pasirinktinius laukus';
$string['rootsettingenrolments'] = 'Įtraukti įregistravimo metodus';
$string['rootsettingenrolments_always'] = 'Taip, visada';
$string['rootsettingenrolments_never'] = 'Ne, atkurti naudotojus kaip įregistruotus rankiniu metodu';
$string['rootsettingenrolments_withusers'] = 'Taip, bet tik tuo atveju, jei naudotojai yra įtraukti';
$string['rootsettingfiles'] = 'Įtraukti failus';
$string['rootsettingfilters'] = 'Įtraukti filtrus';
$string['rootsettinggradehistories'] = 'Įtraukti įvertinimų retrospektyvą';
$string['rootsettinggroups'] = 'Įtraukti grupes ir grupavimus';
$string['rootsettingimscc1'] = 'Konvertuoti į IMS Common Cartridge 1.0';
$string['rootsettingimscc11'] = 'Konvertuoti į IMS Common Cartridge 1.1';
$string['rootsettinglegacyfiles'] = 'Įtraukti senus kursų failus';
$string['rootsettinglogs'] = 'Įtraukti kursų žurnalus';
$string['rootsettingpermissions'] = 'Įtraukti leidimo nepaisymą';
$string['rootsettingquestionbank'] = 'Įtraukti klausimų banką';
$string['rootsettingroleassignments'] = 'Įtraukti naudotojo vaidmenų priskyrimus';
$string['rootsettings'] = 'Atsarginės kopijos parametrai';
$string['rootsettingusers'] = 'Įtraukti įregistruotus naudotojus';
$string['rootsettinguserscompletion'] = 'Įtraukti išsamią naudotojo kurso baigimo informaciją';
$string['rootsettingxapistate'] = 'Įtraukti naudotojo būseną į turinį, pvz., H5P veiklas';
$string['samesitenotification'] = 'Ši atsarginė kopija buvo sukurta naudojant tik nuorodas į failus, o ne pačius failus. Atkūrimas veiks tik šioje svetainėje.';
$string['section_prefix'] = 'Dalis {$a}:';
$string['sectionactivities'] = 'Veiklos';
$string['sectioninc'] = 'Įtraukta į atsarginę kopiją (nėra naudotojo informacijos)';
$string['sectionincanduser'] = 'Įtraukta į atsarginę kopiją kartu su naudotojo informacija';
$string['selectacategory'] = 'Pasirinkti kategoriją';
$string['selectacourse'] = 'Pasirinkti kursą';
$string['setting_course_fullname'] = 'Kursų pavadinimas';
$string['setting_course_shortname'] = 'Trumpasis kurso pavadinimas';
$string['setting_course_startdate'] = 'Kurso pradžios data';
$string['setting_keep_groups_and_groupings'] = 'Palikti dabartines grupes ir grupavimus';
$string['setting_keep_roles_and_enrolments'] = 'Palikti dabartinius vaidmenis ir registracijas';
$string['setting_overwrite_conf'] = 'Keisti kurso konfigūraciją';
$string['setting_overwrite_course_fullname'] = 'Keisti visą kurso pavadinimą';
$string['setting_overwrite_course_shortname'] = 'Keisti trumpąjį kurso pavadinimą';
$string['setting_overwrite_course_startdate'] = 'Keisti kurso pradžios datą';
$string['showtypes'] = 'Rodyti tipo parinktis';
$string['sitecourseformatwarning'] = 'Tai yra svetainės pirmo puslapio atsarginė kopija. Ją galima atkurti tik svetainės pirmame puslapyje.';
$string['skiphidden'] = 'Praleisti paslėptus kursus';
$string['skiphiddenhelp'] = 'Pasirinkite ar praleisti paslėptus kursus';
$string['skipmodifdays'] = 'Praleisti kursus, kurie nepakeisti nuo';
$string['skipmodifdayshelp'] = 'Pasirinkite ar praleisti kursus, kurie nebuvo keisti nuo tam tikro skaičiaus dienų';
$string['skipmodifprev'] = 'Praleisti kursus, kurie nepakeisti nuo praeitos atsarginės kopijos';
$string['skipmodifprevhelp'] = 'Pasirinkite ar praleisti kursus, kurie nebuvo keisti nuo paskutinio atsarginės kopijos sukūrimo. Tam reikia, kad būtų įjungtas žurnalo vedimas.';
$string['status'] = 'Būsena';
$string['storagecourseandexternal'] = 'Kursų atsarginės kopijos failo sritis ir nurodytas katalogas';
$string['storagecourseonly'] = 'Kursų atsarginės kopijos failo sritis';
$string['storageexternalonly'] = 'Nurodytas automatinių atsarginių kopijų katalogas';
$string['subsectioncontent'] = 'Poskyrio turinys';
$string['successful'] = 'Atsarginė kopija sėkminga';
$string['successfulcopy'] = 'Kopijavimas pavyko';
$string['successfulrestore'] = 'Atkūrimas sėkmingas';
$string['timetaken'] = 'Trukmė';
$string['title'] = 'Pavadinimas';
$string['totalcategorysearchresults'] = 'Visos kategorijos: {$a}';
$string['totalcoursesearchresults'] = 'Visi kursai: {$a}';
$string['undefinedrolemapping'] = '„{$a}“ archetipo vaidmenų sudarymas neapibrėžtas.';
$string['unnamedsection'] = 'Nepavadinta dalis';
$string['userdata'] = 'Įtraukti naudotojo duomenis';
$string['userdata_help'] = 'Jei įjungta, duomenys, tokie kaip forumo įrašai, užduočių pateikimas ir tt, bus nukopijuoti į naują kursą visiems naudotojams, kurių vaidmuo pasirinktas skiltyje „Įtraukti vaidmenų registracijas“.';
$string['userinfo'] = 'Naudotojo info';
