<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'assign', language 'hu', version '4.5'.
 *
 * @package     assign
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['activityattachments'] = 'Feladattal kapcsolatos tevékenység csatolmányai';
$string['activitydate:submissionsdue'] = 'Esedékes:';
$string['activitydate:submissionsopen'] = 'Megnyitás:';
$string['activitydate:submissionsopened'] = 'Nyitva:';
$string['activityeditor'] = 'Tevékenység utasításai';
$string['activityeditor_help'] = 'A tanuló által a feladattal kapcsolatban végrehajtandó lépések. Csak a leadási oldalon jelennek meg, ahol a tanuló szerkeszti és leadja a feladatot.';
$string['activityoverview'] = 'Aktuális feladatai vannak';
$string['addattempt'] = 'Újabb próbálkozás engedélyezése';
$string['addnewattempt'] = 'Új próbálkozás hozzáadása';
$string['addnewattempt_help'] = 'Új üres leadást szúr be munkálkodáshoz';
$string['addnewattemptfromprevious'] = 'Új próbálkozás hozzáadása az előző leadás alapján';
$string['addnewattemptfromprevious_help'] = 'Az előző leadás tartalmát átmásolja új leadáson való munkálkodáshoz';
$string['addnewgroupoverride'] = 'Csoportos felülírás hozzáadása';
$string['addnewuseroverride'] = 'Felhasználói felülírás hozzáadása';
$string['addsubmission'] = 'Állomány feltöltése';
$string['addsubmission_help'] = 'Még nem adott le munkát.';
$string['allocatedmarker'] = 'Hozzárendelt értékelő';
$string['allocatedmarker_help'] = 'A leadott munkához rendelt értékelő.';
$string['allowsubmissions'] = 'Felhasználó számára további leadás engedélyezése az adott feladat esetén';
$string['allowsubmissionsfromdate'] = 'Leadások engedélyezése ekkortól';
$string['allowsubmissionsfromdate_help'] = 'Bekapcsolása esetén a tanulók ezen időpont előtt nem adhatnak le munkát. Ellenkező esetben azonnal beküldhetnek munkákat.';
$string['allowsubmissionsshort'] = 'Leadott munka módosításának engedélyezése';
$string['alwaysshowdescription'] = 'A leírás mindig jelenjen meg.';
$string['alwaysshowdescription_help'] = 'Kikapcsolása esetén a fenti feladatleírás a tanulók számára csak a \'Leadások engedélyezése ekkortól\' alatt megadott időponttól lesz látható.';
$string['applytoteam'] = 'Értékelések és visszajelzés az egész csoportra kiterjesztve';
$string['assign:addinstance'] = 'Új feladat hozzáadása';
$string['assign:editothersubmission'] = 'Másik tanuló leadott munkájának szerkesztése';
$string['assign:exportownsubmission'] = 'Saját leadás exportálása';
$string['assign:grade'] = 'Feladat értékelése';
$string['assign:grantextension'] = 'Határidő-hosszabbítás';
$string['assign:manageallocations'] = 'A leadott munkához rendelt értékelők kezelése';
$string['assign:managegrades'] = 'Értékelések ellenőrzése és közzététele';
$string['assign:manageoverrides'] = 'Hozzárendelési felülírások kezelése';
$string['assign:receivegradernotifications'] = 'Értékelői leadásokról szóló értesítések fogadása';
$string['assign:releasegrades'] = 'Értékelések közzététele';
$string['assign:revealidentities'] = 'Tanuló kilétének felfedése';
$string['assign:reviewgrades'] = 'Értékelések ellenőrzése';
$string['assign:showhiddengrader'] = 'Rejtett értékelő kilétének megtekintése';
$string['assign:submit'] = 'Feladat leadása';
$string['assign:view'] = 'Feladat megtekintése';
$string['assign:viewblinddetails'] = 'Tanulók kilétének megtekintése névtelen leadott munka bekapcsolása esetén';
$string['assign:viewgrades'] = 'Értékelések megtekintése';
$string['assign:viewownsubmissionsummary'] = 'Saját leadott munkák összegzésének megtekintése';
$string['assignfeedback'] = 'Visszajelzés segédprogramja';
$string['assignfeedbackpluginname'] = 'Visszajelzés segédprogramja';
$string['assignmentduedigesthtml'] = '<p>Kedves {$a->firstname}!</p>
<p>Az alábbi feladatok teljesítési határideje <strong>{$a->duedate}</strong>.</p>
{$a->digest}';
$string['assignmentduedigestitem'] = 'A {$a->coursename} kurzusban lévő <strong>{$a->assignmentname}</strong><br/>
<strong>határideje: {$a->duetime}</strong><br/>
<a href="{$a->url}" aria-label="{$a->assignmentname} megnyitása">Tevékenységhez lépés</a>';
$string['assignmentduedigestsubject'] = '7 napon belül beadandó feladataid vannak';
$string['assignmentduesoonhtml'] = '<p>Kedves {$a->firstname}!</p>
<p>A {$a->coursename} kurzusban lévő <strong>{$a->assignmentname}</strong> határideje közeleg.</p>
<p><strong>Határidő: {$a->duedate}</strong></p>
<p><a href="{$a->url}">Tevékenységhez lépés</a></p>';
$string['assignmentduesoonsubject'] = 'Határidő {$a->duedate}: {$a->assignmentname}';
$string['assignmentisdue'] = 'A feladat teljesítendő';
$string['assignmentmail'] = '{$a->grader} visszajelzést küldött a(z) \'{$a->assignment}\' feladathoz leadott munkájára, melyet a leadott munkához mellékelve talál meg: {$a->url}.';
$string['assignmentmailhtml'] = '{$a->grader} visszajelzést küldött a(z) \'<i>{$a->assignment}</i>\'<br /><br />  feladathoz leadott munkájára, melyet a <a href="{$a->url}">leadott munkához</a> mellékelve talál meg.';
$string['assignmentmailsmall'] = '{$a->grader} visszajelzést küldött a(z) \'{$a->assignment}\' feladathoz leadott munkájára, melyet a leadott munkához mellékelve talál meg.';
$string['assignmentname'] = 'Feladat neve';
$string['assignmentoverduehtml'] = '<p>Kedves {$a->firstname}!</p>
<p>A {$a->coursename} kurzusban lévő <strong>{$a->assignmentname}</strong> teljesítési határideje <strong>{$a->duedate}</strong> volt.</p>
<p>Még van lehetőség a feladat leadására {$a->cutoffsnippet}, de az kései leadásként lesz megjelölve.</p>
<p><a href="{$a->url}">Tevékenységhez lépés</a></p>';
$string['assignmentoverduehtmlcutoffsnippet'] = '<strong>{$a->cutoffdate}-ig</strong>';
$string['assignmentoverduesubject'] = 'Határidőn túl: {$a->assignmentname}';
$string['assignmentplugins'] = 'Feladat segédprogramjai';
$string['assignmentsperpage'] = 'Oldalankénti feladatszám';
$string['assignsubmission'] = 'Leadási segédprogram';
$string['assignsubmissionpluginname'] = 'Leadási segédprogram';
$string['assigntimeleft'] = 'Hátralévő idő';
$string['attemptheading'] = '{$a->attemptnumber}. próbálkozás: {$a->submissionsummary}';
$string['attempthistory'] = 'Előző próbálkozások';
$string['attemptnumber'] = 'Próbálkozás száma';
$string['attemptreopenmethod'] = 'További próbálkozások engedése';
$string['attemptreopenmethod_automatic'] = 'Automatikusan';
$string['attemptreopenmethod_automatic_help'] = 'Minden próbálkozás után a következő automatikusan biztosított, amint az értékelés megtörtént.';
$string['attemptreopenmethod_help'] = 'Ez a beállítás szabályozza, hogy a tanulók miként próbálkozhatnak újból a feladat leadásával. Az értékelés és a visszajelzés minden próbálkozásnál mentésre kerül és megtekinthető az oktató és a tanuló által is. A lehetőségek:

* Kézileg - Minden próbálkozás után további próbálkozás engedélyezhető a Leadott munkák vagy az Értékelő oldalon keresztül.
* Automatikusan - Minden próbálkozás után a következő automatikusan biztosított, amint az értékelés megtörtént.
* Automatikusan a teljesítésig - Minden próbálkozás után a következő automatikusan biztosított, amint az értékelés megtörtént, mindaddig, amíg a tanuló nem éri el a ponthatárt.';
$string['attemptreopenmethod_manual'] = 'Kézileg';
$string['attemptreopenmethod_manual_help'] = 'Minden kísérlet után a következőt a Beküldések oldalon vagy az Értékelő oldalon engedélyezheti.';
$string['attemptreopenmethod_none'] = 'Soha';
$string['attemptreopenmethod_untilpass'] = 'Automatikusan a teljesítésig';
$string['attemptreopenmethod_untilpass_help'] = 'Minden kísérlet után a következő automatikusan engedélyezve lesz, amíg a tanuló el nem éri ponthatárt.';
$string['attemptsettings'] = 'Próbálkozás beállításai';
$string['availability'] = 'Elérhetőség';
$string['back'] = 'Vissza';
$string['backtoassignment'] = 'Vissza a feladathoz';
$string['batchoperationaddattempt'] = 'További próbálkozás engedése';
$string['batchoperationconfirmaddattempt'] = 'Új próbálkozás engedélyezése a kijelölt leadások esetén?';
$string['batchoperationconfirmdownloadselected'] = 'Letölti a kijelölt leadott munkákat?';
$string['batchoperationconfirmgrantextension'] = 'Meghosszabbítás minden kiválasztott leadott munka esetén?';
$string['batchoperationconfirmlock'] = 'Zárolja az összes kiválasztott leadott munkát?';
$string['batchoperationconfirmremovesubmission'] = 'Törli a kiválasztott leadott munkákat?';
$string['batchoperationconfirmreverttodraft'] = 'A kiválasztott leadott munkákat visszaállítja piszkozattá?';
$string['batchoperationconfirmsetmarkingallocation'] = 'Minden kiválasztott leadott munkához legyen értékelő hozzárendelve?';
$string['batchoperationconfirmsetmarkingworkflowstate'] = 'Minden kiválasztott leadott munkához legyen értékelési folyamat állapota beállítva?';
$string['batchoperationconfirmunlock'] = 'Feloldja az összes kiválasztott leadott munkát?';
$string['batchoperationdownloadselected'] = 'Letöltés';
$string['batchoperationgrantextension'] = 'Meghosszabbít';
$string['batchoperationlock'] = 'Zárolás';
$string['batchoperationreverttodraft'] = 'Visszaállítás piszkozattá';
$string['batchoperationsdescription'] = 'A kiválasztottal...';
$string['batchoperationunlock'] = 'Feloldás';
$string['batchsetallocatedmarker'] = 'Hozzárendelt értékelő beállítása {$a} kiválasztott felhasználóhoz';
$string['batchsetmarkingworkflowstateforusers'] = 'Értékelési folyamat állapotának  beállítása {$a} kiválasztott felhasználóhoz';
$string['beginassignment'] = 'Feladat elkezdése';
$string['blindmarking'] = 'Névtelen leadott munkák';
$string['blindmarking_help'] = 'Névtelen leadott munkák esetén az értékelők elől rejtve marad a tanulók kiléte. Ha a feladattal kapcsolatos leadott munka vagy értékelés elkészül, a névtelenül leadott munkák beállításai nem módosíthatók.';
$string['blindmarkingenabledwarning'] = 'Névtelenül leadott munkák a tevékenységnél engedélyezve.';
$string['cachedef_overrides'] = 'Felhasználói és csoportos felülírás adatai';
$string['calendardue'] = '{$a} esedékes';
$string['calendargradingdue'] = '{$a} értékelése esedékes';
$string['caneditsubmission'] = 'A leadandó munkát szerkesztheti és leadhatja az időkorlát túllépése után is, de az késedelmes jelölést fog kapni.';
$string['changefilters'] = 'Szűrőcsere';
$string['changeuser'] = 'Felhasználócsere';
$string['choosegradingaction'] = 'Értékelési művelet';
$string['choosemarker'] = 'Választ';
$string['chooseoperation'] = 'Művelet kiválasztása';
$string['clickexpandreviewpanel'] = 'Kattintson az ellenőrző panel megnöveléséhez';
$string['collapsegradepanel'] = 'Értékelőpanel becsukása';
$string['collapsereviewpanel'] = 'Ellenőrzés paneljének becsukása';
$string['comment'] = 'Megjegyzés';
$string['completiondetail:submit'] = 'Leadandó munka készítése';
$string['completionsubmit'] = 'Munka leadása';
$string['configshowrecentsubmissions'] = 'A tevékenységekről szóló utóbbi jelentésekben bárki megtekintheti a leadott munkákkal kapcsolatos értesítéseket.';
$string['confirmbatchgradingoperation'] = 'Biztosan végrehajt {$a->operation} műveletet {$a->count} tanuló esetén?';
$string['confirmstart'] = 'A leadandó munka időkorlátja {$a}. Kezdéskor az időmérő elindítja a visszaszámlálást, amit nem lehet szüneteltetni.';
$string['confirmsubmission'] = 'Biztosan leadja munkáját értékelésre? További módosításokra nem lesz lehetősége.';
$string['confirmsubmissionheading'] = 'Leadás megerősítése';
$string['conversionexception'] = 'A feladat átalakítása nem sikerült. A kivétel oka: {$a}.';
$string['couldnotconvertgrade'] = 'A feladatra adott értékelés átalakítása {$a} felhasználó esetén nem sikerült.';
$string['couldnotconvertsubmission'] = 'A feladathoz leadott munka átalakítása {$a} felhasználó esetén nem sikerült.';
$string['couldnotcreatecoursemodule'] = 'A kurzusmodul létrehozása  nem sikerült.';
$string['couldnotcreatenewassignmentinstance'] = 'Az új feladatpéldány létrehozása  nem sikerült.';
$string['couldnotfindassignmenttoupgrade'] = 'Nincs meg a frissítendő régi feladat.';
$string['crontask'] = 'A feladat modul háttérben futó feldolgozója';
$string['currentassigngrade'] = 'Aktuális értékelés a feladatnál';
$string['currentattempt'] = 'Ez a(z)  {$a}. próbálkozás';
$string['currentattemptof'] = 'Ez a lehetséges {$a->maxattempts}  közül a(z) {$a->attemptnumber}.  próbálkozás';
$string['currentgrade'] = 'Aktuális értékelés az értékelésnaplóban';
$string['cutoffdate'] = 'Lezárás időpontja';
$string['cutoffdate_help'] = 'Beállítása esetén a feladathoz meghosszabbítás hiányában nem adhatók le munkák ezen időpontot követően. Enélkül bármikor leadhatók a munkák.';
$string['cutoffdatecolon'] = 'Lezárás időpontja:  {$a}';
$string['cutoffdatefromdatevalidation'] = 'A Lezárás időpontja nem lehet korábbi, mint a leadások engedélyezésének kezdő időpontja';
$string['cutoffdatevalidation'] = 'A lezárás időpontja nem lehet korábbi, mint a leadási határidő.';
$string['defaultgradescale'] = 'Értékelési skála';
$string['defaultlayout'] = 'Alapelrendezés visszaállítása';
$string['defaultsettings'] = 'Feladat alapbeállításai';
$string['defaultsettings_help'] = 'Ezek a beállítások lesznek érvényesek az összes új feladat esetén.';
$string['defaultteam'] = 'Alapcsoport';
$string['deleteallsubmissions'] = 'Összes leadott munka';
$string['description'] = 'Leírás';
$string['disabled'] = 'Kikapcsolva';
$string['downloadall'] = 'Az összes leadott munka letöltése';
$string['downloadasfolders'] = 'Leadott munkák letöltése mappákban';
$string['downloadasfolders_help'] = 'A feladathoz kapcsolódó leadott munkák letölthetők mappákban. Minden leadott munka külön mappába kerül, a mappaszerkezet és az állománynevek nem változnak.';
$string['downloadselectedsubmissions'] = 'A kijelölt leadott munkák letöltése';
$string['duedate'] = 'Határidő';
$string['duedate_help'] = 'A feladat teljesítése ekkor esedékes. Ezen időpont után is adhatók le munkák, de ezek késedelmes megjelölést kapnak. A leadás adott időpont utáni megakadályozásához állítson be végső időpontot.';
$string['duedateaftersubmissionvalidation'] = 'A határidő dátuma csak a leadás engedélyezésének dátuma utáni dátum lehet.';
$string['duedatecolon'] = 'Leadás időpontja:  {$a}';
$string['duedatereached'] = 'A feladat teljesítésének határideje lejárt.';
$string['duedatevalidation'] = 'A leadási határidő nem lehet korábbi, mint a leadások engedélyezésének a kezdete.';
$string['duplicateoverride'] = 'Ismétlődő felülírás';
$string['editaction'] = 'Lépések...';
$string['editattemptfeedback'] = '{$a}. számú próbálkozáshoz tartozó értékelés és visszajelzés szerkesztése.';
$string['editingpreviousfeedbackwarning'] = 'Egy korábbi próbálkozáshoz tartozó visszajelzést szerkeszt. Ez a(z) {$a->totalattempts} próbálkozás közül a(z) {$a->attemptnumber}.';
$string['editingstatus'] = 'Szerkesztés állapota';
$string['editonline'] = 'Online szerkesztés';
$string['editoverride'] = 'Felülírás szerkesztése';
$string['editsubmission'] = 'Leadott munkám szerkesztése';
$string['editsubmission_help'] = 'Leadott munkáját még módosíthatja';
$string['editsubmissionother'] = '{$a} leadott munkájának szerkesztése';
$string['enabled'] = 'Bekapcsolva';
$string['enabletimelimit'] = 'Időméréses feladatok bekapcsolása';
$string['enabletimelimit_help'] = 'Bekapcsolása esetén a feladatok beállítási oldalán időkorlátot állíthat be.';
$string['errorgradechangessaveddetail'] = 'Az értékelés és a visszajelzés módosításai nem lettek elmentve.';
$string['errornosubmissions'] = 'Nincs letölthető leadott munka';
$string['errorquickgradingvsadvancedgrading'] = 'Az értékelések mentésére nem került sor, mert a feladathoz részletes értékelés kapcsolódik.';
$string['errorrecordmodified'] = 'Az értékelések mentésére nem került sor, mert valaki egy vagy több rekordot az oldal betöltése után módosított.';
$string['eventallsubmissionsdownloaded'] = 'Minden leadott munka letöltése folyamatban';
$string['eventassessablesubmitted'] = 'Leadtak egy munkát.';
$string['eventbatchsetmarkerallocationviewed'] = 'Ömlesztett jelzőkiosztás megtekintve';
$string['eventbatchsetworkflowstateviewed'] = 'Ömlesztett munkafolyamat állapota megtekintve';
$string['eventextensiongranted'] = 'Hosszabbítást kapott.';
$string['eventfeedbackupdated'] = 'Visszajelzés frissítve';
$string['eventfeedbackviewed'] = 'Visszajelzés megtekintve';
$string['eventgradingformviewed'] = 'Értékelés űrlap megtekintve';
$string['eventgradingtableviewed'] = 'Értékelés táblázat megtekintve';
$string['eventidentitiesrevealed'] = 'Azonosságok felfedve.';
$string['eventmarkerupdated'] = 'Kijelölt értékelő frissítve.';
$string['eventoverridecreated'] = 'Hozzárendelési felülírás létrehozva';
$string['eventoverridedeleted'] = 'Hozzárendelési felülírás törölve';
$string['eventoverrideupdated'] = 'Hozzárendelési felülírás frissítve';
$string['eventremovesubmissionformviewed'] = 'A leadott munka törlésének megerősítése megtekintve.';
$string['eventrevealidentitiesconfirmationpageviewed'] = 'Azonosítást megerősítő oldal megtekintve';
$string['eventstatementaccepted'] = 'A felhasználó a leadott munka nyilatkozatát elfogadta.';
$string['eventsubmissionconfirmationformviewed'] = 'Leadást megerősítő űrlap megtekintve';
$string['eventsubmissioncreated'] = 'Leadott munka létrehozva';
$string['eventsubmissionduplicated'] = 'A felhasználó leadott munkájáról másolatot készített.';
$string['eventsubmissionformviewed'] = 'Leadási űrlap megtekintve';
$string['eventsubmissiongraded'] = 'A leadott munka értékelése megtörtént.';
$string['eventsubmissionlocked'] = 'A leadott munkákat egy felhasználó számára zároltuk.';
$string['eventsubmissionremoved'] = 'A beadott munka eltávolítva.';
$string['eventsubmissionstatusupdated'] = 'A leadott munka állapota frissítve.';
$string['eventsubmissionstatusviewed'] = 'Leadás állapota megtekintve';
$string['eventsubmissionunlocked'] = 'A leadott munkákat egy felhasználó számára feloldottuk.';
$string['eventsubmissionupdated'] = 'A felhasználó elmentett egy leadott munkát.';
$string['eventsubmissionviewed'] = 'Leadott munka megtekintve';
$string['eventworkflowstateupdated'] = 'A munkafolyamat állapota frissítve.';
$string['expandreviewpanel'] = 'Ellenőrzés paneljének megnövelése';
$string['extensionduedate'] = 'Meghosszabbított határidő';
$string['extensionduedatecurrent'] = 'A jelenlegi meghosszabbított határidő';
$string['extensionnotafterduedate'] = 'A meghosszabbítás lejárata az esedékesség utáni időpont lehet';
$string['extensionnotafterfromdate'] = 'A meghosszabbítás lejárata nem lehet korábbi időpont, mint a leadások kezdeti időpontja';
$string['feedback'] = 'Visszajelzés';
$string['feedbackavailableanonhtml'] = 'Új visszajelzés érkezett \'<i>{$a->assignment}</i>\' leadott munkája kapcsán.<br /><br />
Megtekintheti a <a href="{$a->url}">leadott munkához</a> csatolva.';
$string['feedbackavailableanonsmall'] = 'Új visszajelzés a(z) {$a->assignment} munkához';
$string['feedbackavailableanontext'] = 'Új visszajelzés érkezett \'<i>{$a->assignment}</i>\' leadott munkája kapcsán.<br /><br /> Megtekintheti a leadott munkához csatolva:

{$a->url}';
$string['feedbackavailablehtml'] = '{$a->username} visszajelzést küldött a(z) \'<i>{$a->assignment}</i>\' feladathoz leadott munkájára.<br /><br /> Megtekintheti a(z) <a href="{$a->url}">leadott munka</a> mellett.';
$string['feedbackavailablesmall'] = '{$a->username} visszajelzést küldött a(z) \'{$a->assignment}\' feladathoz';
$string['feedbackavailabletext'] = '{$a->username} visszajelzést küldött a(z) \'{$a->assignment}\' feladathoz leadott munkájára.

Megtekintheti a leadott munka mellett: {$a->url}.';
$string['feedbackplugin'] = 'Visszajelzés segédprogramja';
$string['feedbackpluginforgradebook'] = 'Visszajelzés segédprogramja, mely megjegyzéseket továbbít az értékelésnaplóba';
$string['feedbackpluginforgradebook_help'] = 'Csak egy feladathoz kapcsolódó visszajelzést kezelő segédprogram küldhet visszajelzést az értékelésnaplóba.';
$string['feedbackplugins'] = 'Visszajelzés segédprogramjai';
$string['feedbacksettings'] = 'Visszajelzés beállításai';
$string['feedbacktypes'] = 'Visszajelzési típusok';
$string['filesubmissions'] = 'Állományok leadása';
$string['filter'] = 'Szűrő';
$string['filterall'] = 'Mindenki';
$string['filterdraft'] = 'Vázlat';
$string['filtergrantedextension'] = 'Határidő-hosszabbítást kapott';
$string['filternone'] = 'Nincs szűrő';
$string['filternotsubmitted'] = 'Nincs leadva';
$string['filterrequiregrading'] = 'Értékelésre vár';
$string['filtersubmitted'] = 'Leadva';
$string['fixrescalednullgrades'] = 'A feladat hibás értékeléseket tartalmaz, ezeket <a href="{$a->link}">automatikusan kijavíthatja</a>. Emiatt a kurzusösszesítés módosulhat.';
$string['fixrescalednullgradesconfirm'] = 'Biztosan javítja a hibás értékeléseket? Minden érintett értékelés törlődik. Emiatt a kurzusösszesítés módosulhat.';
$string['fixrescalednullgradesdone'] = 'Értékelések kijavítva.';
$string['gradeabovemaximum'] = 'Az értékelés legfeljebb {$a} lehet.';
$string['gradebelowzero'] = 'Az értékelés csak nulla vagy annál nagyobb lehet.';
$string['gradebreakdown'] = 'Értékelés felbontása';
$string['gradecanbechanged'] = 'Az értékelés módosítható';
$string['gradechangessaveddetail'] = 'Az értékelés és a visszajelzés változásait a rendszer elmentette.';
$string['graded'] = 'Értékelve';
$string['gradedby'] = 'Értékelte';
$string['gradedfollowupsubmit'] = 'Értékelve - újra leadott munka';
$string['gradedon'] = 'Értékelés időpontja';
$string['gradeitem:submissions'] = 'Leadott munkák';
$string['gradelocked'] = 'Ez az értékelés zárolva van vagy felülírták az értékelésnaplóban';
$string['gradeoutof'] = 'Értékelés (max {$a})';
$string['gradeoutofhelp'] = 'Értékelés';
$string['gradeoutofhelp_help'] = 'Itt adhatja meg értékelését a tanuló leadott munkájára. Használhat tizedeseket is.';
$string['gradersubmissionupdatedhtml'] = '{$a->username} {$a->timeupdated}  időpontban frissítette a(z) <i>\'{$a->assignment}\'</i><br /><br /> feladathoz leadott munkáját.<br></br>Elérhető a(z) <a href="{$a->url}"> weboldalon</a>.';
$string['gradersubmissionupdatedsmall'] = '{$a->username} frissítette a(z) \'{$a->assignment}\' feladathoz leadott munkáját.';
$string['gradersubmissionupdatedtext'] = '{$a->username} {$a->timeupdated}  időpontban frissítette a(z) {$a->assignment}  feladathoz leadott munkáját. Itt érhető el: {$a->url}';
$string['gradestudent'] = 'Tanuló értékelése: (id={$a->id}, fullname={$a->fullname}).';
$string['gradeuser'] = 'Értékelés {$a}';
$string['grading'] = 'Értékelés';
$string['gradingchangessaved'] = 'Az értékelés módosításának mentése megtörtént.';
$string['gradingduedate'] = 'Figyelmeztessen az értékelésre eddig:';
$string['gradingduedate_help'] = 'Az az időpont, amikorra a leadott munkák értékelését be kell fejezni. Ez az időpont a tanárok irányítópultos értesítésének a beállításában vesz részt.';
$string['gradingdueduedatevalidation'] = 'Az értékelési emlékeztető határideje nem lehet korábbi, mint az esedékesség dátuma.';
$string['gradingduefromdatevalidation'] = 'Az értékelési emlékeztető határideje nem lehet korábbi, mint a leadott munkák engedélyezésének kezdő dátuma.';
$string['gradingmethodpreview'] = 'Értékelési kritériumok';
$string['gradingoptions'] = 'Lehetőségek';
$string['gradingstatus'] = 'Értékelés állapota';
$string['gradingstudent'] = 'Tanuló értékelése';
$string['gradingsummary'] = 'Értékelési összesítő';
$string['grantextension'] = 'Határidő-hosszabbítás';
$string['grantextensionforusers'] = 'Határidő-hosszabbítás {$a} fő számára';
$string['groupoverrides'] = 'Csoportos felülírások';
$string['groupoverridesdeleted'] = 'Csoportos felülírások törölve';
$string['groupsnone'] = 'Nincs elérhető csoport.';
$string['groupsubmissionsettings'] = 'Csoportos leadás beállításai';
$string['hiddenuser'] = 'Résztvevő';
$string['hidegrader'] = 'Rejtett értékelő kilétének elrejtése a tanulók elől';
$string['hidegrader_help'] = 'Bekapcsolása esetén elrejti a leadott munkát értékelő kilétét, így a tanulók nem látják, ki értékelte a munkájukat.

A beállításnak nincs hatása az értékelés oldalon lévő megjegyzések négyzetére.';
$string['hideshow'] = 'Elrejt/Mutat';
$string['inactiveoverridehelp'] = '* A felülírás nem működik, mert a felhasználó hozzáférése a tevékenységhez korlátozott. Ennek oka lehet a csoport- vagy szerepfeladatok, illetve egyéb korlátozások, vagy pedig rejtett tevékenység.';
$string['includesuspendedparticipants'] = 'Felfüggesztett résztvevőket is beleértve';
$string['indicator:cognitivedepth'] = 'Kognitív feladat';
$string['indicator:cognitivedepth_help'] = 'Ez a jelző a tanuló által a feladat során elért kognitív mélységen alapul.';
$string['indicator:cognitivedepthdef'] = 'Kognitív feladat';
$string['indicator:cognitivedepthdef_help'] = 'A résztvevő a feladathoz kapcsolódó tevékenységek között szereplő kognitív elfoglaltság ezen százalékát érte el az elemzési időszak alatt  (Szintek = Nincs megtekintés, Megtekintés, Leadás, Visszajelzés megtekintése, Visszajelzéshez kapcsolódó megjegyzés, Visszajelzés megtekintése utáni újbóli leadás)';
$string['indicator:cognitivedepthdef_link'] = 'Learning_analytics_indicators#Cognitive_depth';
$string['indicator:socialbreadth'] = 'Társas feladat';
$string['indicator:socialbreadth_help'] = 'Ez a jelző a tanuló által a feladat során elért társas látókörön alapul.';
$string['indicator:socialbreadthdef'] = 'Társas feladat';
$string['indicator:socialbreadthdef_help'] = 'A résztvevő a feladathoz kapcsolódó tevékenységek között szereplő társas elfoglaltság ezen százalékát érte el az elemzési időszak alatt (Szintek = Nincs részvétel, Egyedüli részvétel, Másokkal közös részvétel)';
$string['indicator:socialbreadthdef_link'] = 'Learning_analytics_indicators#Social_breadth';
$string['instructionfiles'] = 'Utasítások';
$string['introattachments'] = 'Kiegészítő állományok';
$string['introattachments_help'] = 'Kiegészítő állományokat, pl. válaszsablonokat adhat hozzá a feladatban való használatra.';
$string['invalidfloatforgrade'] = 'Az adott értékelés nem értelmezhető: {$a}';
$string['invalidgradeforscale'] = 'Az adott értékelés nem érvényes erre a jelenlegi skálánál';
$string['invalidoverrideid'] = 'Érvénytelen felülírás-azonosító';
$string['lastmodifiedgrade'] = 'Utolsó módosítás (értékelés)';
$string['lastmodifiedsubmission'] = 'Utolsó módosítás (leadott munka)';
$string['latesubmissions'] = 'Későn leadott munkák';
$string['latesubmissionsaccepted'] = 'Csak {$a} időpontig engedélyezett';
$string['loading'] = 'Töltés...';
$string['locksubmissionforstudent'] = '(id={$a->id}, fullname={$a->fullname}) tanuló részéről további leadások megakadályozása';
$string['locksubmissions'] = 'Leadások zárolása';
$string['manageassignfeedbackplugins'] = 'Feladatra adott visszajelzések segédprogramjainak kezelése';
$string['manageassignsubmissionplugins'] = 'Feladathoz leadott munkák segédprogramjainak kezelése';
$string['marker'] = 'Értékelő';
$string['markerfilter'] = 'Értékelők szűrője';
$string['markerfilternomarker'] = 'Nincs jelölő';
$string['markingallocation'] = 'Értékelő-hozzárendelés használata';
$string['markingallocation_help'] = 'Bekapcsolása esetén értékelőket rendelhet az egyes tanulókhoz.';
$string['markingworkflow'] = 'Értékelési folyamat használata';
$string['markingworkflow_help'] = 'Bekapcsolása esetén a jegyek közzététel előtt több folyamaton mennek keresztül. Így a több értékelési kör révén a jegyeket minden tanuló egyszerre kaphatja meg.';
$string['markingworkflowstate'] = 'Értékelési folyamat állapota';
$string['markingworkflowstate_help'] = 'A választható folyamatállapotokat a feladathoz rendelt jogosultságai határozzák meg:

* Nincs értékelve - az értékelő még nem látott hozzá
* Értékelés alatt - az értékelő már hozzálátott, de még nem készült el vele
* Értékelés kész - az értékelő már befejezte, de még visszatérhet ellenőrizni/javítani
* Ellenőrzés alatt - az értékelés a minőség-ellenőrzésért felelős tanárhoz került
* Közzétételre kész - a felelős tanár elégedett az értékeléssel, de még várhat a közzététellel
* Közzétéve - a tanuló hozzáférhet az értékeléshez/visszajelzéshez';
$string['markingworkflowstateinmarking'] = 'Értékelés alatt';
$string['markingworkflowstateinreview'] = 'Ellenőrzés alatt';
$string['markingworkflowstatenotmarked'] = 'Nincs értékelve';
$string['markingworkflowstatereadyforrelease'] = 'Közzétételre kész';
$string['markingworkflowstatereadyforreview'] = 'Az értékelés véget ért.';
$string['markingworkflowstatereleased'] = 'Közzétéve';
$string['maxattempts'] = 'Engedélyezett próbálkozások száma';
$string['maxattempts_help'] = 'A tanuló általi leadási próbálkozások maximális száma. Ezt követően a leadott munkát nem lehet újból megnyitni.';
$string['maxgrade'] = 'Maximális értékelés';
$string['maxperpage'] = 'Maximális feladat oldalanként';
$string['maxperpage_help'] = 'Az feladatértékelő oldalon megjeleníthető feladatok maximálisan száma. Hasznos az időkiesés elkerülésére sok résztvevővel rendelkező kurzusok esetén.';
$string['messageprovider:assign_due_digest'] = 'Értesítés 7 napon belül esedékes feladatokról';
$string['messageprovider:assign_due_soon'] = 'Értesítés hamarosan esedékes feladatról';
$string['messageprovider:assign_notification'] = 'Feladattal kapcsolatos értesítések';
$string['messageprovider:assign_overdue'] = 'Értesítés a feladat határidejének a lejártáról';
$string['modulename'] = 'Feladat';
$string['modulename_help'] = 'A Feladat tevékenységmodul révén a tanár kiadhatja a feladatokat, begyűjtheti munkákat, értékelést adhat és visszajelzést küldhet.

A tanuló bármilyen digitális tartalmat (állományt) leadhat, például dokumentumot, táblázatokat, képet, hang- vagy videoállományt. Ezzel együtt, vagy ehelyett, a feladat előírhatja, hogy a tanulók közvetlenül a szöveges szerkesztőben adjanak választ. A feladat használható a "valóságban" elkészítendő, offline feladatokhoz való figyelmeztetéshez is, melyhez nem tartozik digitális tartalom (például művészeti feladatok). A tanulók munkájukat egyénileg vagy egy csoport tagjaként adhatják le.

Ellenőrzés során a tanár szöveges visszajelzést adhat és fájlokat tölthet fel, például a javításokkal ellátott munkát, megjegyzéseket tartalmazó dokumentumokat vagy rögzített szóbeli értékelést. Az értékelés történhet számszerű vagy egyéni értékelési skálával, vagy olyan részletes értékelési módszerrel, mint a rubrikák. A végleges értékelés az értékelésnaplóba kerül.';
$string['modulename_link'] = 'mod/assignment/view';
$string['modulenameplural'] = 'Feladatok';
$string['moreusers'] = 'további {$a} ...';
$string['multipleteams'] = 'Több csoportnak is tagja';
$string['multipleteams_desc'] = 'A feladat csoportos leadott munkát ír elő. Ön egynél több csoport tagja. Leadáshoz csak egy csoportnak lehet a tagja. Csoporttagságának módosításáért forduljon tanárához.';
$string['multipleteamsgrader'] = 'Több csoportnak is tagja, így nem adhat le munkát.';
$string['newsubmissions'] = 'Feladatok leadva';
$string['nextuser'] = 'Következő felhasználó';
$string['noattempt'] = 'Nincs próbálkozás';
$string['noclose'] = 'Nincs lezárási időpont';
$string['nofiles'] = 'Nincs állomány.';
$string['nofilters'] = 'Nincs szűrő';
$string['nograde'] = 'Nincs értékelés.';
$string['nogroupoverrides'] = 'Jelenleg nincs csoportfelülírás.';
$string['nomoresubmissionsaccepted'] = 'Csak a halasztást kapók számára engedélyezett';
$string['none'] = 'Egy sem';
$string['noonlinesubmissions'] = 'Ehhez a feladathoz semmit nem kell neten keresztül leadnia.';
$string['noopen'] = 'Nincs nyitási időpont';
$string['nooverridedata'] = 'Legalább egy feladatbeállítást fölül kell írnia.';
$string['nosavebutnext'] = 'Következő';
$string['nosubmission'] = 'A feladathoz nem érkezett leadott munka.';
$string['nosubmissionyet'] = 'Még nem készültek el leadandó munkák.';
$string['noteam'] = 'Ön egyik csoportnak sem tagja';
$string['noteam_desc'] = 'A feladat csoportos leadott munkát ír elő. Ön nem tagja egy csoportnak sem, így nem hozhat létre leadott munkát. Csoport felvételéért forduljon tanárához.';
$string['noteamgrader'] = 'Ön egyik csoportnak sem tagja, így nem adhat le munkát.';
$string['notgraded'] = 'Nincs értékelve';
$string['notgradedyet'] = 'Még nincs érétkelve';
$string['notifications'] = 'Értesítések';
$string['nouseroverrides'] = 'Jelenleg nincs felhasználófelülírás.';
$string['nousers'] = 'Nincs felhasználó';
$string['nousersselected'] = 'Nincs kiválasztva felhasználó';
$string['numberofdraftsubmissions'] = 'Piszkozatok';
$string['numberofparticipants'] = 'Résztvevők';
$string['numberofsubmissionsneedgrading'] = 'Értékelésre vár';
$string['numberofsubmissionsneedgradinglabel'] = 'Értékelésre vár: {$a}';
$string['numberofsubmittedassignments'] = 'Leadva';
$string['numberofteams'] = 'Csoportok';
$string['offline'] = 'Nincs szükség neten keresztüli leadásra';
$string['open'] = 'Nyitva';
$string['outlinegrade'] = 'Érétkelés: {$a}';
$string['outof'] = '{$a->current} / {$a->total}';
$string['overdue'] = 'A feladat határidőn túli: {$a}</font>';
$string['override'] = 'Felülírás';
$string['overridedeletegroupsure'] = 'Biztosan törli a(z) {$a} csoport felülírását?';
$string['overridedeleteusersure'] = 'Biztosan törli a(z) {$a} felhasználó felülírását?';
$string['overridegroup'] = 'Csoport felülírása';
$string['overridegroupeventname'] = '{$a->assign} - {$a->group}';
$string['overrides'] = 'Felülírások';
$string['overrideuser'] = 'Felhasználó felülírása';
$string['overrideusereventname'] = '{$a->assign} - felülírás';
$string['page-mod-assign-view'] = 'Feladatmodul fő és leadási oldala';
$string['page-mod-assign-x'] = 'Feladatmodul tetszőleges oldala';
$string['paramtimeremaining'] = '{$a} van hátra';
$string['participant'] = 'Résztvevő';
$string['pluginadministration'] = 'Feladat kezelése';
$string['pluginname'] = 'Feladat';
$string['preventsubmissionnotingroup'] = 'Csoport számára leadás előírása';
$string['preventsubmissionnotingroup_help'] = 'Bekapcsolása esetén csak csoporttagok adhatnak le munkát.';
$string['preventsubmissions'] = 'Tanuló számára a feladathoz további munkák leadásának megakadályozása';
$string['preventsubmissionsshort'] = 'Leadott munkák módosításának megakadályozása';
$string['previous'] = 'Előző';
$string['previoususer'] = 'Előző felhasználó';
$string['privacy:attemptpath'] = '{$a}. próbálkozás';
$string['privacy:blindmarkingidentifier'] = 'Névtelenül leadott munkákhoz használt azonosító';
$string['privacy:gradepath'] = 'értékelés';
$string['privacy:metadata:assigndownloadasfolders'] = 'Felhasználói beállítás több leadott munka mappákba való letöltése esetén';
$string['privacy:metadata:assignfeedbackpluginsummary'] = 'Feladathoz kapcsolódó visszajelzés adatai.';
$string['privacy:metadata:assignfilter'] = 'Szűrési lehetőségek, mint pl. \'Leadva\', \'Nincs leadva\', \'Értékelésre vár\' és \'Halasztott\'';
$string['privacy:metadata:assigngrades'] = 'A feladathoz kapcsolódó felhasználói értékeléseket tárolja';
$string['privacy:metadata:assignmarkerfilter'] = 'Hozzárendelési összegzés szűrése a hozzárendelt osztályozó alapján.';
$string['privacy:metadata:assignmentid'] = 'Feladat azonosítója';
$string['privacy:metadata:assignmessageexplanation'] = 'Az üzeneteket az üzenetküldő rendszer továbbítja a tanulókhoz.';
$string['privacy:metadata:assignoverrides'] = 'A feladathoz kapcsolódó felülírás adatait tárolja';
$string['privacy:metadata:assignperpage'] = 'Oldalanként megjelenítendő feladatok száma.';
$string['privacy:metadata:assignquickgrading'] = 'Gyors értékelés használatának beállítása.';
$string['privacy:metadata:assignsubmissiondetail'] = 'Felhasználói leadott munka adatait tárolja';
$string['privacy:metadata:assignsubmissionpluginsummary'] = 'Feladathoz kapcsolódó leadott munka adatai.';
$string['privacy:metadata:assignuserflags'] = 'Felhasználói metaadatokat, pl. meghosszabbítás időpontjait tárolja';
$string['privacy:metadata:assignusermapping'] = 'Névtelenül leadott munkákhoz használt társítás';
$string['privacy:metadata:assignworkflowfilter'] = 'Különféle munkafolyamatok szerinti szűrés.';
$string['privacy:metadata:grade'] = 'Feladat leadott munkájának számszerű értékelése. Megadható skálával/részletes osztályzattal stb., de mindig visszaalakul lebegőpontos számmá.';
$string['privacy:metadata:grader'] = 'Az értékelő személy felhasználói azonosítója.';
$string['privacy:metadata:groupid'] = 'Azon csoport azonosítója, amelynek a felhasználói a tagja.';
$string['privacy:metadata:latest'] = 'Nagyban egyszerűsíti a kizárólag az utolsó próbálkozásra vonatkozó lekérdezéseket.';
$string['privacy:metadata:mailed'] = 'A felhasználói levél sorra került már?';
$string['privacy:metadata:timecreated'] = 'Létrehozás időpontja';
$string['privacy:metadata:timestarted'] = 'Időmérés elkezdődött';
$string['privacy:metadata:userid'] = 'A felhasználó azonosítója';
$string['privacy:studentpath'] = 'diákok beadott munkái';
$string['privacy:submissionpath'] = 'leadott munka';
$string['quickgrading'] = 'Gyors értékelés';
$string['quickgrading_help'] = 'Gyors értékelés esetén az értékeléseket (és eredményeket) közvetlenül a leadott munka táblázatában rögzítheti. Gyors értékelés nem alkalmazható részletes értékeléssel együtt, használata több értékelő esetén nem ajánlott.';
$string['quickgradingchangessaved'] = 'Az értékelés változásainak mentése megtörtént.';
$string['quickgradingresult'] = 'Gyors értékelés';
$string['recordid'] = 'Azonosító';
$string['relativedatessubmissiontimeleft'] = 'Minden egyes tanulóra kiszámítva';
$string['removeallgroupoverrides'] = 'Minden csoportfelülírás';
$string['removealluseroverrides'] = 'Minden felhasználói felülírás';
$string['removesubmission'] = 'A leadott munka törlése';
$string['removesubmissionconfirm'] = 'Biztosan törli a leadott munkát?';
$string['removesubmissionconfirmforstudent'] = 'Biztosan törli {$a} tanuló leadott munkáját?';
$string['removesubmissionconfirmwithtimelimit'] = 'Biztosan törölni szeretné a beküldött anyagot? Felhívjuk figyelmét, hogy ez nem állítja vissza a határidőt.';
$string['removesubmissionforstudent'] = '(id={$a->id}, fullname={$a->fullname}) tanuló leadott munkájának törlése.';
$string['reopenuntilpassincompatiblewithblindmarking'] = 'Nyissa meg újra, amíg a teljesítési feltétel nem egyezik a névtelenül leadott munkákkal, mert az értékelések csak akkor kerülnek a naplóba, amikor a tanulók kilétére fény derül.';
$string['requireallteammemberssubmit'] = 'Minden csoporttag adjon le munkát';
$string['requireallteammemberssubmit_help'] = 'Bekapcsolása esetén minden csoporttagnak kattintania kell a Leadás gombra. Kikapcsolt állapotban a csoportszintű leadás bármely csoporttag Leadás gombra való kattintásával megtörténik.';
$string['requiresubmissionstatement'] = 'A leadási nyilatkozat tanulók általi elfogadásának előírása';
$string['requiresubmissionstatement_help'] = 'A leadási nyilatkozat tanulók általi elfogadásának előírása a feladat minden leadott munkájához.';
$string['revealidentities'] = 'Tanuló kilétének felfedése';
$string['revealidentitiesconfirm'] = 'Biztosan felfedi a tanulók kilétét ennél a feladatnál? A művelet nem vonható vissza, az értékelések pedig bekerülnek az értékelésnaplóba.';
$string['reverttodefaults'] = 'Visszatérés a feladat alapértékeihez';
$string['reverttodraft'] = 'Leadott munka visszaállítása piszkozattá';
$string['reverttodraftforgroup'] = 'A {$a} csoport beadott munkájának a visszaállítása piszkozatként.';
$string['reverttodraftforstudent'] = 'Leadott munka visszaállítása piszkozattá (id={$a->id}, fullname={$a->fullname}) tanuló számára.';
$string['reverttodraftshort'] = 'Leadott munka visszaállítása piszkozattá';
$string['reviewed'] = 'Ellenőrizve';
$string['save'] = 'Mentés';
$string['saveallquickgradingchanges'] = 'Az összes gyorsértékelési változás mentése';
$string['saveandcontinue'] = 'Mentés és folytatás';
$string['savechanges'] = 'Módosítások mentése';
$string['savegradingresult'] = 'Értékelés';
$string['savenext'] = 'Mentés és a következő megjelenítése';
$string['saveoverrideandstay'] = 'Mentés és áttérés egy másik felülíráshoz';
$string['savingchanges'] = 'Módosítások mentése...';
$string['scale'] = 'Skála';
$string['search:activity'] = 'Feladathoz kapcsolódó tevékenységek adatai';
$string['selectedusers'] = 'Kiválasztott felhasználók';
$string['selectlink'] = 'Választás';
$string['selectuser'] = 'Választás: {$a}';
$string['sendlatenotifications'] = 'Értékelők értesítése kései leadásokról';
$string['sendlatenotifications_help'] = 'Bekapcsolása esetén az értékelők (rendszerint a tanárok) értesítést kapnak, ha egy tanuló későn adta le a feladatát. Az üzenetküldés módja beállítható.';
$string['sendnotificationduedatesoon'] = 'Értesítse a felhasználót a közeledő beadási határidőről';
$string['sendnotificationduedigest'] = 'Értesítse a felhasználót a 7 napon belül esedékes feladatról';
$string['sendnotificationoverdue'] = 'Értesítse a felhasználót a lejárt feladatról';
$string['sendnotifications'] = 'Leadott munkákról értesítés küldése az értékelőknek';
$string['sendnotifications_help'] = 'Bekapcsolása esetén az értékelésben közreműködők (általában a tanárok) üzenetet kapnak, ha a tanuló (korán, időben vagy megkésve) ad le egy munkát. Az üzenetküldő módszereket testre szabhatja.';
$string['sendstudentnotifications'] = 'Tanuló értesítése';
$string['sendstudentnotifications_help'] = 'Bejelölése esetén a tanulók a frissített értékelésről vagy visszajelzésről üzenetet kapnak. Ha a feladat során az értékelési folyamat be van kapcsolva, vagy az értékelések rejtve vannak az értékelő jelentésben, az értesítések küldésére csak az értékelés közzétételekor kerül sor.';
$string['sendstudentnotificationsdefault'] = 'A "Tanuló értesítése" alapbeállítása';
$string['sendstudentnotificationsdefault_help'] = 'Egyes tanulók értékelése közben be legyen jelölve alapból a "Tanuló értesítése"?';
$string['sendsubmissionreceipts'] = 'Leadott munkáról elismervény küldése a tanulóknak';
$string['sendsubmissionreceipts_help'] = 'Ezzel kapcsolja be a leadott munkáról szóló elismervény küldését a tanulóknak, akik minden sikeres leadást követően kapnak  egy értesítést.';
$string['setmarkerallocationforlog'] = 'Értékelő hozzárendelése: (id={$a->id}, név={$a->fullname}, értékelő={$a->marker}).';
$string['setmarkingallocation'] = 'Hozzárendelt értékelő beállítása';
$string['setmarkingworkflowstate'] = 'Értékelési folyamat állapotának beállítása';
$string['setmarkingworkflowstateforlog'] = 'Értékelési folyamat állapotának beállítása : (id={$a->id}, név={$a->fullname}, állapot={$a->state}).';
$string['settings'] = 'Feladat beállításai';
$string['showrecentsubmissions'] = 'Legutóbbi leadott munkák megjelenítése';
$string['status'] = 'Állapot';
$string['studentnotificationworkflowstateerror'] = 'A tanulók értesítéséhez a munkamenetet \'Szabad\' állapottal kell megjelölni.';
$string['submission'] = 'Leadott munka';
$string['submissionattachments'] = 'Állományok megjelenítése csak a leadás során.';
$string['submissionattachments_help'] = 'Bekapcsolása esetén az állományok csak a leadási képernyőn jelennek meg. Ellenkező esetben az állományok mind feladat nézetben, mind a leadási képernyőkön megjelennek.';
$string['submissioncopiedhtml'] = 'Másolatot készített \'<i>{$a->assignment}</i>\' leadott munkájáról.<br /><br /> <a href="{$a->url}">Leadott munkájának</a> állapotát megtekintheti.';
$string['submissioncopiedsmall'] = 'Másolatot készített előző {$a->assignment} leadott munkájából.';
$string['submissioncopiedtext'] = 'Másolatot készített előző \'{$a->assignment}\' leadott munkájából.

Leadott munkájának állapotát megtekintheti: {$a->url}.';
$string['submissiondrafts'] = 'Tanulók számára a Leadás gombra kattintás előírása';
$string['submissiondrafts_help'] = 'Megjelenjen egy leadás gomb a tanulóknak, mellyel jelezhetik, hogy végeztek a leadandó munkával, így az kész az értékelésre?';
$string['submissioneditable'] = 'A tanuló a leadandót szerkesztheti.';
$string['submissionempty'] = 'Nem volt leadás';
$string['submissionlog'] = 'Tanuló: {$a->fullname}, állapot: {$a->status}';
$string['submissionmodified'] = 'Leadott adatai vannak. Lépjen ki az oldalról és próbálja meg újra.';
$string['submissionmodifiedgroup'] = 'A leadott munkát másvalaki módosította. Lépjen ki az oldalról és próbálja meg újra.';
$string['submissionnotcopiedinvalidstatus'] = 'Leadott munkájáról nem készült másolat, mert újbóli megnyitása után szerkesztésre került sor.';
$string['submissionnoteditable'] = 'A tanuló a leadandót nem szerkesztheti.';
$string['submissionnotready'] = 'A feladathoz leadandó munka még nincs kész.';
$string['submissionplugins'] = 'Leadás segédprogramjai';
$string['submissionreceipthtml'] = 'A(z) \'<i>{$a->assignment}</i>\' feladathoz megoldást adott le.<br /><br /> Állapotát megtekintheti a <a href="{$a->url}">leadott munka</a> alatt.';
$string['submissionreceiptotherhtml'] = 'A(z) \'<i>{$a->assignment}</i>\' feladathoz megoldást adott le.<br /><br />
 Állapotát megtekintheti a <a href="{$a->url}">leadott munka</a> alatt.';
$string['submissionreceiptothersmall'] = 'A(z) \'<i>{$a->assignment}</i>\' feladathoz megoldást adott le.';
$string['submissionreceiptothertext'] = 'A(z) \'<i>{$a->assignment}</i>\' feladathoz megoldást adott le.

 Állapotát megtekintheti itt:
{$a->url}';
$string['submissionreceipts'] = 'Leadási értesítő küldése';
$string['submissionreceiptsmall'] = 'A(z) \'<i>{$a->assignment}</i>\' feladathoz megoldást adott le.';
$string['submissionreceipttext'] = 'A(z) \'<i>{$a->assignment}</i>\' feladathoz megoldást adott le.

Állapotát megtekintheti itt: {$a->url}';
$string['submissionsclosed'] = 'Leadás lezárva';
$string['submissionsettings'] = 'Leadás beállításai';
$string['submissionslocked'] = 'A feladathoz nem lehet munkát leadni.';
$string['submissionslockedshort'] = 'A leadott munka nem módosítható.';
$string['submissionstatement'] = 'Leadási nyilatkozat';
$string['submissionstatement_help'] = 'A feladat leadásához minden tanuló által megerősítendő nyilatkozat.';
$string['submissionstatementacceptedlog'] = 'A leadási nyilatkozatot {$a} elfogadta.';
$string['submissionstatementdefault'] = 'A leadott munka saját munkám, kivéve azokat a részeket, ahol elismerem mások munkájának a felhasználását.';
$string['submissionstatementteamsubmission'] = 'Csoportos leadási nyilatkozat';
$string['submissionstatementteamsubmission_help'] = 'Csoportként való feladatleadáshoz minden tanuló által megerősítendő nyilatkozat.';
$string['submissionstatementteamsubmissionallsubmit'] = 'Csoportos leadási nyilatkozat minden csoporttag feladatleadása esetén';
$string['submissionstatementteamsubmissionallsubmit_help'] = 'Csoporttagként való feladatleadáshoz minden tanuló által megerősítendő nyilatkozat.';
$string['submissionstatementteamsubmissionallsubmitdefault'] = 'A leadott munka csoporttagként leadott munkám, kivéve azokat a részeket, ahol elismerem mások munkájának a felhasználását.';
$string['submissionstatementteamsubmissiondefault'] = 'A leadott munka a csoportom munkája, kivéve azokat a részeket, ahol elismerjük mások munkájának a felhasználását.';
$string['submissionstatus'] = 'Leadás állapota';
$string['submissionstatus_'] = 'Nincs leadott munka';
$string['submissionstatus_draft'] = 'Piszkozat (nincs leadva)';
$string['submissionstatus_marked'] = 'Értékelve';
$string['submissionstatus_new'] = 'Nincs leadott munka';
$string['submissionstatus_reopened'] = 'Újból megnyitva';
$string['submissionstatus_submitted'] = 'Értékelésre leadva';
$string['submissionstatusheading'] = 'Leadás állapota';
$string['submissionsummary'] = '{$a->status}. Utolsó módosítás időpontja {$a->timemodified}';
$string['submissionteam'] = 'Csoport';
$string['submissiontypes'] = 'Leadási típusok';
$string['submitaction'] = 'Leadás';
$string['submitassignment'] = 'Feladat leadása';
$string['submitassignment_help'] = 'A feladat leadás után nem módosítható.';
$string['submitforgrading'] = 'Leadás értékelésre';
$string['submitted'] = 'Leadva';
$string['submittedearly'] = 'Feladat {$a} idővel korábban leadva';
$string['submittedlate'] = 'Feladat {$a} idővel később leadva';
$string['submittedlateshort'] = '{$a} kései';
$string['submittedovertime'] = 'A feladatot {$a} idővel a korláton túl nyújtották be.';
$string['submittedundertime'] = 'A feladatot {$a} idővel a korláton belül nyújtották be.';
$string['subpagetitle'] = '{$a->contextname} - {$a->subpage}';
$string['subplugintype_assignfeedback'] = 'Visszajelzés segédprogramja';
$string['subplugintype_assignfeedback_plural'] = 'Visszajelzés segédprogramjai';
$string['subplugintype_assignsubmission'] = 'Leadás segédprogramja';
$string['subplugintype_assignsubmission_plural'] = 'Leadás segédprogramja';
$string['teamname'] = 'Csoport: {$a}';
$string['teamsubmission'] = 'Csoportos leadás';
$string['teamsubmission_help'] = 'Bekapcsolása esetén a tanulók alapbeállítás vagy egyedi csoportosítás szerinti csoportokba kerülnek. A csoportos leadást a csoporttagok készítik el, akik látják egymás módosításait.';
$string['teamsubmissiongroupingid'] = 'Csoportosítás';
$string['teamsubmissiongroupingid_help'] = 'A feladat ezt a csoportosítást veszi figyelembe. Ha nincs beállítva, az alapkészletet használja.';
$string['textinstructions'] = 'Feladat utasításai';
$string['timelimit'] = 'Időkorlát';
$string['timelimit_help'] = 'Bekapcsolása esetén a feladat közben megjelenik az oldalon beállított időkorlát és a visszaszámláló.';
$string['timelimitnotenabled'] = 'A feladatnak nincs időkorlátja.';
$string['timelimitpassed'] = 'Az  időkorlátot túllépte';
$string['timemodified'] = 'Utolsó módosítás';
$string['timeremaining'] = 'Hátralévő idő';
$string['timeremainingcolon'] = 'Hátralévő idő: {$a}';
$string['togglezoom'] = 'Terület nagyítása';
$string['ungroupedusers'] = 'A „Csoport számára leadás előírása” be van kapcsolva, de egyes felhasználók nincsenek csoporthoz - vagy több csoporthoz vannak - hozzárendelve, így nem adhatnak le munkát.';
$string['ungroupedusersoptional'] = 'Be van kapcsolva a csoportos tanulói leadás, egyes felhasználók azonban vagy nem csoporttagok, vagy egynél több csoport tagjai. Ezek a tanulók az Alapcsoport tagjaiként fogják leadni munkájukat!';
$string['unlimitedattempts'] = 'Korlátlan';
$string['unlimitedattemptsallowed'] = 'Korlátlan számú próbálkozás lehetséges';
$string['unlimitedpages'] = 'Korlátlan';
$string['unlocksubmissionforstudent'] = '(id={$a->id}, fullname={$a->fullname}) tanuló részére leadások engedélyezése.';
$string['unlocksubmissions'] = 'Leadások feloldása';
$string['unsavedchanges'] = 'Nem mentett módosítások';
$string['unsavedchangesquestion'] = 'Az értékelés vagy a visszajelzés nem mentett módosításokat tartalmaz. Menti ezeket a módosításokat és folytatja?';
$string['updategrade'] = 'Értékelés frissítése';
$string['updatetable'] = 'Táblázat mentése és frissítése';
$string['upgradenotimplemented'] = '({$a->type} {$a->subtype}) segédprogram esetén a verziófrissítés nem történt meg.';
$string['userassignmentdefaults'] = 'Felhasználói feladat alapadatai';
$string['userextensiondate'] = 'Halasztás engedélyezve eddig: {$a}';
$string['usergrade'] = 'Felhasználó értékelése';
$string['useridlistnotcached'] = 'Az értékelés módosításának mentése NEM történt meg, mivel nem lehetett megállapítani, kinek a leadott munkájáról van szó.';
$string['useroverrides'] = 'Felhasználói felülírások';
$string['useroverridesdeleted'] = 'Felhasználói felülírások törölve';
$string['usersnone'] = 'A hozzárendeléshez egy tanuló sem fér hozzá.';
$string['usersubmissioncannotberemoved'] = '{$a} leadott munkája nem távolítható el.';
$string['userswhoneedtosubmit'] = 'Leadásra kötelezett tanulók: {$a}';
$string['validmarkingworkflowstates'] = 'Értékelési folyamat érvényes állapotai';
$string['viewadifferentattempt'] = 'Másik próbálkozás megtekintése';
$string['viewbatchmarkingallocation'] = 'Értékelők ömlesztett hozzárendelésének megtekintése';
$string['viewbatchsetmarkingworkflowstate'] = 'Értékelési folyamatállapot ömlesztett megtekintése';
$string['viewfeedback'] = 'Visszajelzés megtekintése';
$string['viewfeedbackforuser'] = '{$a} felhasználó visszajelzésének megtekintése';
$string['viewfull'] = 'Teljes megtekintés';
$string['viewfullgradingpage'] = 'Visszajelzéshez nyissa meg a teljes értékelés oldalt.';
$string['viewgradebook'] = 'Értékelésnapló megtekintése';
$string['viewgrader'] = 'Értékelő megtekintése';
$string['viewgrading'] = 'Minden leadott munka megtekintése';
$string['viewgradingformforstudent'] = '(id={$a->id}, fullname={$a->fullname}) tanuló értékelő oldalának megtekintése.';
$string['viewownsubmissionform'] = 'Saját feladatleadó oldal megtekintése';
$string['viewownsubmissionstatus'] = 'Saját leadott munka állapotát mutató oldal megtekintése';
$string['viewrevealidentitiesconfirm'] = 'Tanulók kilétének felfedését megerősítő oldal megtekintése';
$string['viewsubmission'] = 'Leadott munka megtekintése';
$string['viewsubmissionforuser'] = '{$a} leadott munkájának megtekintése';
$string['viewsubmissiongradingtable'] = 'Leadott munka értékelő táblázatának megtekintése.';
$string['viewsummary'] = 'Összegzés megtekintése';
$string['workflowfilter'] = 'Folyamatszűrő';
$string['xofy'] = '{$a->y} / {$a->x}';
