<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'tool_usertours', language 'da', version '4.5'.
 *
 * @package     tool_usertours
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['above'] = 'Over';
$string['actions'] = 'Handlinger';
$string['appliesto'] = 'Gælder for';
$string['backdrop'] = 'Vis med baggrund';
$string['backdrop_help'] = 'Du kan bruge en baggrund til at fremhæve den del af siden du peger på.

Bemærk: Baggrunde er ikke kompatible med alle dele af siden såsom f.eks. navigationslinjen.';
$string['below'] = 'Under';
$string['block'] = 'Blok';
$string['block_named'] = 'Blokken "{$a}"';
$string['cachedef_stepdata'] = 'Liste over stop på rundvisningen';
$string['cachedef_tourdata'] = 'Liste over aktiverede rundvisninger som hentes på alle sider.';
$string['confirmstepremovalquestion'] = 'Er du sikker på at du vil fjerne dette stop?';
$string['confirmstepremovaltitle'] = 'Bekræft fjernelse';
$string['confirmtourremovalquestion'] = 'Er du sikker på at du vil fjerne denne tur?';
$string['confirmtourremovaltitle'] = 'Bekræft sletning af tur.';
$string['content'] = 'Indhold';
$string['content_heading'] = 'Indhold';
$string['content_help'] = 'Indhold der beskriver stop på turen, kan tilføjes i uformateret tekst evt. omkranset af flersprogs-tags (til brug for flersprogs-filteret).';
$string['content_type'] = 'Indholdstype.';
$string['content_type_help'] = '* Manuel - indhold indtastes ved hjælp af en teksteditor
* Sprogstreng-ID - i formatet strengidentifikator,komponent (uden mellemrum efter kommaet)';
$string['content_type_langstring'] = 'Sprogstreng-ID.';
$string['content_type_manual'] = 'Manual';
$string['cssselector'] = 'CSS-selektor';
$string['defaultvalue'] = 'Standard ({$a})';
$string['delay'] = 'Forsinkelse før dette stop vises';
$string['delay_help'] = 'Du kan eventuelt tilføje en forsinkelse før næste stop vises. Forsinkelsen skrives i millisekunder.';
$string['description'] = 'Beskrivelse';
$string['description_help'] = 'Beskrivelsen af en tur kan tilføjes som almindelig tekst, indkapslet i multilang-tags (til brug med flersprogede indholdsfiltre), hvis det er nødvendigt.

Alternativt kan et sprogstreng-ID indtastes i formatet identifikator,komponent (uden parenteser eller mellemrum efter kommaet).';
$string['displaystepnumbers'] = 'Vis trinnumre.';
$string['displaystepnumbers_help'] = 'Om der skal vises et trin nummer tælling f.eks. 1/4, 2/4 osv. for at angive længden af brugerturen.';
$string['done'] = 'Gjort';
$string['duplicatetour'] = 'Kopier turen';
$string['duplicatetour_name'] = '{$a} (copy)';
$string['editstep'] = 'Redigerer "{$a}"';
$string['enabled'] = 'Aktiveret';
$string['endonesteptour'] = 'Forstået';
$string['endtour'] = 'Afslut rundturen!';
$string['endtourlabel'] = 'Etiketten for "Afslut tur"-knappen.';
$string['endtourlabel_help'] = 'Du kan valgfrit angive en tilpasset etikette for "Afslut tur"-knappen. Standardetiketten er \'Got it\' for en-trins ture og \'End tour\' for flere-trins ture.

Alternativt kan et sprogstreng-ID indtastes i formatet identifikator,komponent (uden parenteser eller mellemrum efter kommaet).';
$string['event_step_shown'] = 'Stop vist';
$string['event_tour_ended'] = 'Rundvisningen endte';
$string['event_tour_reset'] = 'Rundtur nulstillet';
$string['event_tour_started'] = 'Rundtur startet';
$string['exporttour'] = 'Eksporter rundturen';
$string['filter_accessdate'] = 'Adgangsdato';
$string['filter_accessdate_enabled'] = 'Aktiver filter for adgangsdato';
$string['filter_accessdate_enabled_help'] = 'Vis kun turen til nye brugere eller brugere der er tilgået siden for nylig.';
$string['filter_category'] = 'Kategori';
$string['filter_category_help'] = 'Vis turen på en side associeret med et kursus i den valgte kategori.';
$string['filter_course'] = 'Kurser';
$string['filter_course_help'] = 'Vis turen på en side associeret med det valgte kursus.';
$string['filter_courseformat'] = 'Kursusformat';
$string['filter_courseformat_help'] = 'Vis turen på en side associeret med et kursus i det valgte kursusformat.';
$string['filter_cssselector'] = 'CSS selector';
$string['filter_cssselector_help'] = 'Vis kun turen, når den angivne CSS-selector findes på siden.';
$string['filter_date_account_creation'] = 'Dato for oprettelse af brugerkonto inden for';
$string['filter_date_first_login'] = 'Brugerens første adgangsdato inden for';
$string['filter_date_last_login'] = 'Brugerens sidste adgangsdato inden for';
$string['filter_header'] = 'Rundtursfiltre';
$string['filter_help'] = 'Vælg under hvilke omstændigheder rundturen vises. Alle filtre skal matche før en rundtur vises.';
$string['filter_role'] = 'Rolle';
$string['filter_role_help'] = 'En rundtur kan begrænses til brugere med de valgte roller der hvor rundturen foregår. Begrænsning af en rundtur gennem betjeningspanelet til brugere med rollen studerende, vil ikke virke hvis brugere har denne rolle på et kursus (som det generelt er tilfældet). En rundtur i betjeningspanel kan kun begrænses til brugere med en systemrolle.';
$string['filter_theme'] = 'Layoutskabelon';
$string['filter_theme_help'] = 'Vis rundturen hvis brugeren bruger en af de valgte layoutskabeloner.';
$string['importtour'] = 'Importer rundtur';
$string['invalid_lang_id'] = 'Ugyldigt sprogstreng-ID.';
$string['left'] = 'Venstre';
$string['modifyshippedtourwarning'] = 'Dette er en rundvisning der er kommet som en del af Moodle. Eventuelle ændringer kan blive overskrevet ved næste opdatering.';
$string['moodle_language_identifier'] = 'Sprogstreng-ID.';
$string['movestepdown'] = 'Ryk ned';
$string['movestepup'] = 'Ryk op';
$string['movetourdown'] = 'Ryk ned';
$string['movetourup'] = 'Ryk op';
$string['name'] = 'Navn';
$string['name_help'] = 'Navnet på en tur kan tilføjes som almindelig tekst, indkapslet i multilang-tags (til brug med flersprogede indholdsfiltre), hvis det er nødvendigt.

Alternativt kan et sprogstreng-ID indtastes i formatet identifikator,komponent (uden parenteser eller mellemrum efter kommaet).';
$string['newstep'] = 'Nyt stop';
$string['newtour'] = 'Opret en ny rundtur';
$string['next'] = 'Næste';
$string['nextstep'] = 'Næste';
$string['nextstep_sequence'] = 'Næste ({$a->position}/{$a->total})';
$string['options_heading'] = 'Indstillingsmuligheder';
$string['orphan'] = 'Vis hvis målet ikke findes';
$string['orphan_help'] = 'Vis dette stop selv om målet ikke er med på siden.';
$string['pathmatch'] = 'Føj til URL der matcher';
$string['pathmatch_help'] = 'Rundvisninger vises på alle sider hvis URL matcher denne værdi.

Du kan bruge % som jokertegn. For eksempel:

* /my/% - matcher betjeningspanelet
* /course/view.php?id=2 - matcher et specifikt kursus
* /mod/forum/view.php% - matcher et forums liste over indlæg
* /user/profile.php% - matcher brugerprofilsiden

Hvis du vil have en rundvisning på webstedets forside, kan du bruge denne værdi: "FRONTPAGE"';
$string['pausetour'] = 'Pause';
$string['placement'] = 'Placering';
$string['placement_help'] = 'Et stop kan placeres over, under eller til højre eller venstre for målet. Det anbefales at vælge over, da det passer bedst til mobilvisning.

Hvis ikke det passer på den valgte placering, vil det automatisk blive placeret anderledes.';
$string['pluginname'] = 'Rundture';
$string['privacy:metadata:preference:completed'] = 'Hvornår en bruger sidst gennemførte en rundvisning';
$string['privacy:metadata:preference:requested'] = 'Hvornår en bruger sidst efterspurgte en rundvisning';
$string['privacy:request:preference:completed'] = 'Du markerede sidst rundvisningen "{$a->name}" som gennemført {$a->time}';
$string['privacy:request:preference:requested'] = 'Du efterspurgte sidst rundvisningen "{$a->name}" {$a->time}';
$string['reflex'] = 'Fortsæt ved klik';
$string['reflex_help'] = 'Fortsæt til det næste stop når der klikkes på målet.';
$string['resettouronpage'] = 'Nulstil rundturen på denne side';
$string['resumetour'] = 'Resumé';
$string['right'] = 'Højre';
$string['select_block'] = 'Vælg en blok';
$string['selector_defaulttitle'] = 'Angiv en beskrivende titel';
$string['selectordisplayname'] = 'En CSS-selektor der matcher "{$a}"';
$string['selecttype'] = 'Vælg type stop';
$string['sharedtourslink'] = 'Arkiv med rundture';
$string['showtoureachtime'] = 'hver gang et filter matcher';
$string['showtouruntilcomplete'] = 'indtil det er blevet lukket';
$string['showtourwhen'] = 'Vis tur';
$string['skip'] = 'Spring over';
$string['skip_tour'] = 'Spring turen over.';
$string['target'] = 'Mål';
$string['target_block'] = 'Blok';
$string['target_heading'] = 'Mål på dette stop';
$string['target_selector'] = 'Selektor';
$string['target_selector_targetvalue'] = 'CSS-selektorer';
$string['target_selector_targetvalue_help'] = 'En CSS-selektor kan bruges til at pege på så godt som ethvert element på siden. Selektorer kan nemt findes med udviklerværktøjet i din webbrowser.';
$string['target_unattached'] = 'Vis midt på siden';
$string['targettype'] = 'Måltype';
$string['targettype_help'] = 'Hvert stop er forbundet med en del af siden - målet. Måltyper er:

* Blok - til visning af et trin ved en specificeret blok
* CSS-selector - til præcis definition af emnets areal ved brug af css
* Vis midt på siden - til et trin der ikke skal forbindes med en enkelt del af siden';
$string['title'] = 'Titel';
$string['title_help'] = 'Titlen på et stop kan tilføjes som uformateret tekst - eventuelt omkranset af flersprogstags (til brug med flersprogsfilteret).

Alternativt kan en sprogstrengs-id bruges i formatet identifikator,komponent (uden parenteser eller mellemrum efter kommaet).';
$string['tour1_content_addingblocks'] = 'Faktisk bør du tænke dig grundigt om inden du føjer blokke til dine sider. Blokke vises ikke i Moodles Mobil-app, så som tommelfingerregel er det bedre at sikre sig at siden fungerer uden nogen blokke.';
$string['tour1_content_blockregion'] = 'Der er et blok-område mere her. Vi anbefaler helt at fjerne Navigation- og Administrations-blokken, da funktionaliteten findes andre steder i Boost-layoutet.';
$string['tour1_content_customisation'] = 'Tilpas dit sites udseende og forside via indstillingerne i menuen i hjørnet af dette sidehoved. Prøv at aktivere redigeringtilstand nu.';
$string['tour1_content_end'] = 'Her slutter din rundvisning. Den vil ikke blive vist igen med mindre du nulstiller den via linket i sidefoden. Som administrator kan du også selv oprette rundvisninger som denne!';
$string['tour1_content_navigation'] = 'Hovednavigationen finder du nu i denne navigationsskuffe. Et klik på ikonet her åbner eller lukker den. Indholdet afhænger af hvor på webstedet du befinder dig.';
$string['tour1_content_welcome'] = 'Velkommen til Boost-layoutet. Hvis systemet er opgraderet fra en tidligere version, vil du opleve at nogle ting har fået nyt udseende.';
$string['tour1_title_addingblocks'] = 'Tilføj blokke';
$string['tour1_title_blockregion'] = 'Blokområde';
$string['tour1_title_customisation'] = 'Tilpasning';
$string['tour1_title_end'] = 'Slut på rundtur';
$string['tour1_title_navigation'] = 'Navigation';
$string['tour1_title_welcome'] = 'Velkommen';
$string['tour2_content_addblock'] = 'Hvis du aktiverer redigering, kan du tilføje blokke via navigationskuffen. Overvej dog nøje hvilke blokke du placerer på dine sider. Blokke vises ikke i Moodles Mobil-app, så for at give den bedste brugeroplevelse bør du sikre dig, at kurset kan fungere uden blokke.';
$string['tour2_content_addingblocks'] = 'Du kan tilføje blokke ved at trykke på denne knap. Overvej dog nøje hvilke blokke du placerer på dine sider. Blokke vises ikke i Moodles Mobil-app, så for at give den bedste brugeroplevelse bør du sikre dig, at kurset kan fungere uden blokke.';
$string['tour2_content_customisation'] = 'Hvis du vil ændre kursusindstillinger, så klik på indstillingsmenuen i hjørnet af dette sidehoved. Du finder en tilsvarende indstillingsmenu på forsiden til alle aktiviteter. Prøv at aktivere redigeringtilstand nu.';
$string['tour2_content_end'] = 'Hermed ender din rundvisning. Den vil ikke blive vist igen med mindre du nulstiller den via linket i sidefoden.

Administrator kan om ønsket oprette flere rundvisninger.';
$string['tour2_content_navigation'] = 'Navigationen er nu placeret i denne "skuffe". Brug knappen øverst til at vise elle skjule den. Du kan se at der er links til sektioner på dit kursus.';
$string['tour2_content_opendrawer'] = 'Prøv at åbne skuffen nu.';
$string['tour2_content_participants'] = 'Vis deltagere her. Her kan du også tilføje eller fjerne studerende.';
$string['tour2_content_welcome'] = 'Velkommen til Boost-layoutet. Hvis webstedet er opgraderet fra en tidligere version, vil du opleve at nogle ting har fået nyt udseende her på kursussiden.';
$string['tour2_title_addblock'] = 'Tilføj en blok';
$string['tour2_title_addingblocks'] = 'Tilføj blokke';
$string['tour2_title_customisation'] = 'Tilpasning';
$string['tour2_title_end'] = 'Slut på rundtur';
$string['tour2_title_navigation'] = 'Navigation';
$string['tour2_title_opendrawer'] = 'Åbn navigationen';
$string['tour2_title_participants'] = 'Kursusdeltagere';
$string['tour2_title_welcome'] = 'Velkommen';
$string['tour3_content_dashboard'] = 'Dit nye betjeningspanel har flere muligheder for at få nem adgang til det der er vigtigst for dig.';
$string['tour3_content_displayoptions'] = 'Kurser kan sorteres efter det fulde navn, korte navn eller seneste adgang. Du kan også vælge at få vist kurser på en liste med beskrivelser eller med brikker som i standardvisningen.';
$string['tour3_content_overview'] = 'Blokken "Kursusoversigt" viser alle de kurser du deltager på.

Du kan vælge at vise aktuelle kurser, tidligere eller fremtidige kurser eller favoritkurser markeret med en stjerne.';
$string['tour3_content_recentcourses'] = 'Blokken "Senest besøgte kurser" viser hvilke kurser du sidst har besøgt, og giver dig mulighed for hurtigt springe ind i dem igen.';
$string['tour3_content_starring'] = 'Du kan fremhæve et kursus med en stjerne, eller skjule det hvis det ikke længere er vigtigt for dig.

Disse indstillinger vedrører kun dig selv.

Du kan også vælge at få vist kurser på en liste, med beskrivelser eller med brikker som i standardvisningen.';
$string['tour3_content_timeline'] = 'Tidslinjeblokken viser vigtige kommende begivenheder.

Du kan vælge at få vist aktiviteter i den kommende uge, måned eller længere ud i fremtiden.

Du kan også få vist aktiviteter der forventes allerede at være gennemførte.';
$string['tour3_title_dashboard'] = 'Dit betjeningspanel';
$string['tour3_title_displayoptions'] = 'Visningsmuligheder';
$string['tour3_title_overview'] = 'Kursusoversigt';
$string['tour3_title_recentcourses'] = 'Senest besøgte kurser';
$string['tour3_title_starring'] = 'Stjernemarker og skjul kurser';
$string['tour3_title_timeline'] = 'Tidslinjeblok';
$string['tour4_content_groupconvo'] = 'Er du med i en gruppe med gruppebeskeder aktiveret, vil du se gruppens beskeder her.

Kursusgrupper kan kommunikere internt i et privat område.';
$string['tour4_content_icon'] = 'Du har adgang til dine beskeder fra alle sider via dette ikon.

Har du nye, ikke læste beskeder, vil antallet vises her også.

Klik på ikonet for at åbne beskedskuffen og fortsætte rundvisningen.';
$string['tour4_content_messaging'] = 'Det nye interface til beskeder giver mulighed for interne gruppebeskeder på et kursus og bedre kontrol med hvem der kan sende beskeder til dig.';
$string['tour4_content_settings'] = 'Du har adgang til dine beskedindstillinger via tandhjulet. Med en ny privatlivsindstilling kan du begrænse hvem der kan skrive til dig.';
$string['tour4_content_starred'] = 'Du kan vælge at fremhæve udvalgte samtaler med en stjerne så de bliver nemmere at finde.';
$string['tour4_title_groupconvo'] = 'Gruppebeskeder';
$string['tour4_title_icon'] = 'Beskeder';
$string['tour4_title_messaging'] = 'Nyt interface til beskeder';
$string['tour4_title_settings'] = 'Beskedindstillinger';
$string['tour4_title_starred'] = 'Stjernemarkeret';
$string['tour_activityinfo_activity_student_content'] = 'Aktivitetsdatoer og hvad du skal gøre for at gennemføre aktiviteten vises på aktivitetssiden.';
$string['tour_activityinfo_activity_student_title'] = 'Ny: Aktivitetsinformation.';
$string['tour_activityinfo_activity_teacher_content'] = 'Aktivitetsdatoer og afslutningsbetingelser vises nu for de studerende på hver aktivitetsside (og valgfrit på kursussiden).

For aktiviteter der kræver at eleverne manuelt markerer en aktivitet som afsluttet, vises en knap "Marker som afsluttet" på aktivitetssiden.';
$string['tour_activityinfo_activity_teacher_title'] = 'Ny: Aktivitetsinformation.';
$string['tour_activityinfo_course_student_content'] = 'Aktivitetsdatoer og/eller hvad du skal gøre for at gennemføre aktiviteten, vises på kursussiden.';
$string['tour_activityinfo_course_student_title'] = 'Ny: Aktivitetsinformation.';
$string['tour_activityinfo_course_teacher_content'] = 'De nye kursusindstillinger "Vis betingelser for afslutning" og "Vis aktivitetsdatoer" giver dig mulighed for at vælge, om betingelserne for afslutning af aktiviteter (hvis de er angivet) og/eller datoer skal vises for de studerende på kursussiden.';
$string['tour_activityinfo_course_teacher_title'] = 'Ny: Aktivitetsinformation.';
$string['tour_final_step_content'] = 'Det var det. Du kan gentage rundvisningen hvis du nulstiller den via linket i sidefoden.';
$string['tour_final_step_title'] = 'Slut på rundvisningen.';
$string['tour_gradebook_action_content'] = '<div class="text-center">@@PIXICON::tour/tour_grader_report_action_menu::tool_usertours@@</div>Sortér kolonner og vælg, hvilke der skal vises. I redigeringstilstand kan du bruge denne genvej til at få adgang til hyppige opgaver relateret til visning og redigering af karakterelementer.';
$string['tour_gradebook_action_title'] = 'Hurtige links til handlinger.';
$string['tour_gradebook_filter_content'] = '<div class="text-center">@@PIXICON::tour/tour_grader_report_initials::tool_usertours@@</div>Filtrer studerende efter initialer af deres for- eller efternavn.';
$string['tour_gradebook_filter_title'] = 'Filtrer efter navn.';
$string['tour_gradebook_search_content'] = '<div class="text-center">@@PIXICON::tour/tour_grader_report_search::tool_usertours@@</div>Brug søgefeltet til hurtigt at finde specifikke studerende.';
$string['tour_gradebook_search_title'] = 'Find studerende nemt.';
$string['tour_gradebook_tour_description'] = 'Søge- og navigationsfunktioner i karakterbogsbedømmelsesrapporten.';
$string['tour_gradebook_tour_name'] = 'Karakterbogsbedømmelsesrapport.';
$string['tour_navigation_course_announcements_teacher_content'] = '@@PIXICON::tour/tour_course_admin_3::tool_usertours@@<br>Post vigtig nyheder her.';
$string['tour_navigation_course_announcements_teacher_title'] = 'Noget, du vil fortælle alle?';
$string['tour_navigation_course_edit_teacher_content'] = '@@PIXICON::tour/tour_course_admin_1::tool_usertours@@<br>Tilføj nyt indhold eller rediger eksisterende indhold.';
$string['tour_navigation_course_edit_teacher_title'] = 'Aktivér redigeringstilstand.';
$string['tour_navigation_course_index_student_content'] = '@@PIXICON::tour/tour_course_student::tool_usertours@@<br>Gennemse aktiviteter og følg din fremgang.';
$string['tour_navigation_course_index_student_title'] = 'Find vej';
$string['tour_navigation_course_index_teacher_content'] = '@@PIXICON::tour/tour_course_admin_2::tool_usertours@@<br>Træk og slip aktiviteter for at omarrangere kursusindholdet.';
$string['tour_navigation_course_index_teacher_title'] = 'Kursusoversigt';
$string['tour_navigation_course_student_tour_des'] = 'Hvor du kan gennemse aktiviteter i et kursus.';
$string['tour_navigation_course_student_tour_name'] = 'Kursusoversigt';
$string['tour_navigation_course_teacher_tour_des'] = 'Redigeringstilstand, træk og slip af aktiviteter og opslag af meddelelser i et kursus.';
$string['tour_navigation_course_teacher_tour_name'] = 'Kursusredigering.';
$string['tour_navigation_dashboard_content'] = '@@PIXICON::tour/tour_dashboard::tool_usertours@@<br>Dette sidepanel kan indeholde flere funktioner.';
$string['tour_navigation_dashboard_title'] = 'Udvid for at udforske';
$string['tour_navigation_dashboard_tour_des'] = 'Hvor blokke kan findes.';
$string['tour_navigation_dashboard_tour_name'] = 'Blok-skuffe';
$string['tour_navigation_mycourses_content'] = '@@PIXICON::tour/tour_mycourses::tool_usertours@@<br>Tilføj, kopier, slet og skjul kurser fra denne menu.';
$string['tour_navigation_mycourses_endtourlabel'] = 'Jeg forstår';
$string['tour_navigation_mycourses_title'] = 'Kurser og kategorier';
$string['tour_navigation_mycourses_tour_des'] = 'Kursusadministrationsmuligheder på siden "Mine kurser".';
$string['tour_navigation_mycourses_tour_name'] = 'Kursusadministration.';
$string['tour_resetforall'] = 'Rundturens status er nulstillet. Den vil blive vist til alle brugere igen.';
$string['tourconfig'] = 'Rundtursfil til import';
$string['tourisenabled'] = 'Rundtur aktiveret';
$string['tourlist_explanation'] = 'Du kan oprette alle de rundvisninger du vil - og aktivere dem til forskellige dele af Moodle. Der kan dog kun oprettes en rundvisning pr. side.';
$string['tours'] = 'Ture';
$string['usertours'] = 'Rundture';
$string['usertours:managetours'] = 'Opret, rediger og fjern rundture';
$string['viewtour_edit'] = 'Du kan <a href="{$a->editlink}">redigere rundtursindstillingerne</a> og <a href="{$a->resetlink}">gennemtvinge at rundturen vises </a> til alle brugere igen.';
$string['viewtour_info'] = 'Dette er rundvisningen "{$a->tourname}". Den bruges på stien "{$a->path}".';
