<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'local_learning_analytics', language 'da', version '4.5'.
 *
 * @package     local_learning_analytics
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['admin_customfield_category'] = 'Omnavngiv kategorien';
$string['admin_customfield_category_hint'] = 'klik på blyantikonet ved siden af kategorien for at omdøbe';
$string['admin_customfield_info'] = 'Du kan selv ændre navnet på muligheden i kursusindstillingerne ved at omdøbe dem på følgende sider:';
$string['admin_customfield_no_manual_delete'] = 'Slet ikke kategorien eller muligheden. Du kan kun omdøbe dem. Hvis du ønsker at fjerne muligheden, skal du ændre statussen ovenfor i stedet.';
$string['admin_customfield_option'] = 'Omdøb muligheden';
$string['admin_customfield_option_hint'] = 'du må kun ændre navnet og beskrivelsesteksten';
$string['customfield_category_description'] = 'Denne kategori blev automatisk oprettet af Learning Analytics-pluginet (local_learning_analytics). Du bør ikke slette dette manuelt.';
$string['customfield_category_name'] = 'Learning analytics';
$string['customfield_field_description'] = 'Aktivering tilføjer linket "Brugsstatistik" til din kursusnavigation.';
$string['customfield_field_name'] = 'Aktiver brugstatistik';
$string['dataprivacy_threshold_description'] = 'Denne værdi bestemmer, hvor mange "data points" et datasæt skal indeholde, før dataene vises.';
$string['general_settings'] = 'Generelle indstillinger';
$string['help_faq'] = 'Ofte stillede spørgsmål (FAQ)';
$string['help_faq_data_storage_answer'] = 'De præsenterede data stammer fra to datakilder.
Begge kilder er gemt i den interne Moodle-database.
Den første datakilde er den interne Moodle-database, såsom antallet af studerende i kurset (venstre boks i instrumentbrættet).
Nogle af disse datasæt kan ses på andre Moodle-sider og visualiseres blot anderledes på disse sider.
Den anden datakilde er data, der indsamles specifikt til præsentation på siden for brugestatistikker.
Alle data indsamlet til dette formål opbevares anonymt og kan ikke spores tilbage til individuelle brugere.
Specifikt gemmes følgende data med hver request i Moodle:';
$string['help_faq_data_storage_answer_list'] = 'Type af handling (f.eks. "Ressource set")
Tidspunkt (præcist til sekundet)
Tilhørende kursus, hvor handlingen fandt sted
Tilhørende kontekst (f.eks. den ressource, der blev set)
Operativsystem og browser (f.eks. "Windows 10" og "Firefox"), detaljerede versioner af browser eller operativsystem gemmes ikke';
$string['help_faq_data_storage_question'] = 'Hvilke data opbevares og vises af tjenesten?';
$string['help_faq_datapoints_answer'] = 'De viste tal angiver antallet af hits/adgang. Disse kan variere meget afhængigt af materialetype.
For eksempel registreres kun ét hit, når en PDF downloades.
Men i tilfælde af en test, hvor spørgsmålene er fordelt over flere sider, vil der også blive registreret flere hits i løbet af en enkelt testkørsel.';
$string['help_faq_datapoints_question'] = 'Hvorfor er antallet af hits så forskelligt for forskellige typer materialer?';
$string['help_faq_developer_answer'] = 'Læringsanalyse-tjenesten er udviklet af Center for Undervisning og Læringstjenester ved RWTH Aachen Universitet.
Udviklingen er Open Source. Derfor kan du selv kontrollere de anvendte algoritmer. På de følgende sider kan du få adgang til yderligere information:';
$string['help_faq_developer_question'] = 'Hvem udvikler tjenesten, og hvor kan jeg få yderligere information?';
$string['help_faq_personal_data_answer'] = 'Af hensyn til databeskyttelse indsamler Learning Analytics-tjenesten ikke personlige data. Derfor indeholder de fleste af de viste statistikker (f.eks. de mest anvendte aktiviteter) kun information om, hvor ofte en ressource blev tilgået, men ikke hvor mange deltagere der har tilgået den.
En undtagelse hertil er statistikkerne om deltagere og quizzer/afleveringer, som også viser interne Moodle-data.';
$string['help_faq_personal_data_question'] = 'Hvorfor vises der ingen personlige statistikker, såsom klik pr. bruger?';
$string['help_faq_privacy_threshold_answer'] = 'Af hensyn til databeskyttelse vises aggregerede data kun, hvis der er mindst {$a} datapunkter til stede.';
$string['help_faq_privacy_threshold_question'] = 'Hvorfor vises nogle værdier som "< {$a}"?';
$string['help_faq_visibility_answer'] = 'For at sikre maksimal gennemsigtighed kan de viste data ses af kursusudbyderne såvel som af deltagerne i kurset.';
$string['help_faq_visibility_question'] = 'Hvem kan få adgang til brugsstatistikkerne?';
$string['help_faq_week_start_answer'] = 'Visualiseringen i dashboardet afhænger af indstillingen "Kursusstartdato" i kursusindstillingerne. Hvis den angivne dato der ikke svarer til den faktiske start af forelæsningen, vil visningen i dashboardet heller ikke være korrekt.
Lederen af dette kursus kan rette indstillingen i kursusindstillingerne (under Generelt / Kursusstartdato).';
$string['help_faq_week_start_question'] = 'Hvorfor svarer den første uge i dashboardgrafen ikke til den faktiske start af forelæsningen?';
$string['help_take_tour'] = 'Tag den interaktive rundtur';
$string['help_text'] = 'Siden "Brugsstatistik" i Learning Analytics-tjenesten viser dig de vigtigste målinger for dit kursus.

De viste statistikker er live og viser data, der er indsamlet af tjenesten samt data fra Moodle-kurset selv. Alle data indsamlet af Learning Analytics-tjenesten indsamles fuldstændig anonymt og kan ikke spores tilbage til brugere.';
$string['help_title'] = 'Hjælp';
$string['hits'] = 'Besøg';
$string['learners'] = 'Lærere';
$string['learning_analytics'] = 'Learning analytics';
$string['learning_analytics:view_statistics'] = 'Adgangsbrugsstatistikker i kurser';
$string['navigation_position_beforekey_description'] = 'Giver mulighed for at specificere, hvor i kursusnavigationen linket til siden tilføjes. Som standard tilføjes linket før den første "sektion" node. Eksempelværdi: <code>grades</code> for at blive vist før linket til karakterer. Du kan finde nøglen til en node i navigationen ved at bruge udviklerværktøjerne. Højreklik på et link i navigationen, tryk på <em>Inspicer</em> og tjek attributten <code>data-key</code> for det tilsvarende <code>a</code> element.';
$string['navigationlink'] = 'Brugsstatistikker';
$string['pluginname'] = 'Learning analytics';
$string['privacy:metadata'] = 'Dette plugin gemmer ikke nogen personlige data.';
$string['sessions'] = 'Sessioner';
$string['setting_course_ids_description'] = 'Brug denne mulighed, når du vælger den anden mulighed ovenfor for at beslutte, for hvilke kurser brugergrænsefladen skal aktiveres.';
$string['setting_dashboard_boxes'] = 'Bestemmer hvilke bokse der vises på dashboardet, i hvilken rækkefølge og hvor store bokse der er. Specifikationen er i formatet <code>reportname:width</code>, adskilt af kommaer. En linje har en maksimal bredde på 12, hvorefter den brydes. Eksempel: <code>learners:8,activities:4</code> viser to bokse på dashboardet, hvor den første er meget bredere end den anden. I de fleste tilfælde skal værdien kun ændres, hvis andre subplugins er installeret.';
$string['setting_status_course_customfield'] = 'Tilføj mulighed i kursusindstillingerne, så lærere kan aktivere det selv';
$string['setting_status_description'] = 'Denne værdi angiver, om brugergrænsefladen skal aktiveres, og om et link skal vises i navigationen. Som standard er linket og siden synlige, hvis logning er aktiveret for kurset. Du kan bruge denne mulighed, hvis du ønsker at aktivere logning i alle kurser, men kun ønsker at aktivere brugergrænsefladen på specifikke kurser.';
$string['setting_status_option_disable'] = 'Skjul navigationslinket og deaktiver siden for alle kurser';
$string['setting_status_option_hidelink'] = 'Skjul navigationslinket, men hold siden aktiveret for alle kurser (kun hvis du kender linket, kan du få adgang til siden)';
$string['setting_status_option_show_always'] = 'Vis navigationslink for alle kurser, selvom logning er deaktiveret for kurset (aktiver kun dette, hvis du allerede har logget data før)';
$string['setting_status_option_show_courseids'] = 'Vis navigationslink hvis kurset er angivet nedenfor via course_ids';
$string['setting_status_option_show_if_enabled'] = 'Vis navigationslink hvis logning er aktiveret for kurset';
$string['setting_student_enrols_groupby_description'] = 'Denne mulighed definerer, hvilke kurser der sammenlægges på siden \'Tidligere/Parallelt kursus\', og hvilken værdi der bruges til at vise navnene.';
$string['setting_student_rolenames_description'] = 'Hvis rolle(rne) for studerende/bruger i et kursus ikke er <code>student</code>, kan du angive det tilsvarende rollenavn. Hvis der er flere roller, som studerende har, skal du bruge et enkelt komma. Eksempel: <code>student,customrole</code>';
$string['show_full_list'] = 'Udvid liste';
$string['subplugintype_lalog'] = 'L.A. Log';
$string['subplugintype_lalog_plural'] = 'L.A. Logs';
$string['subplugintype_lareport'] = 'L.A. Rapport';
$string['subplugintype_lareport_plural'] = 'L.A. Rapportering';
$string['tour_activities'] = 'Den sidste visning viser de tre mest anvendte aktiviteter i de sidste 7 dage.

Ved at klikke på linket kan du se detaljer om kursusaktiviteterne.';
$string['tour_box_hits'] = 'Denne indikator viser antallet af handlinger inden for de sidste 7 dage. Nedenfor kan du se ændringerne over de foregående 7 dage.

Ved at klikke på linket kan du åbne et varmekort, som visualiserer antallet af handlinger over hele semesteret.';
$string['tour_box_learners'] = 'Den første indikator viser det samlede antal deltagere. Under det store tal vises ændringen fra den foregående uge.';
$string['tour_box_learnerslink'] = 'Klik på linket for at se flere oplysninger om deltagerne.';
$string['tour_box_quiz_assign'] = 'Dette viser antallet af quizforsøg og aflevering af opgaver i de sidste 7 dage. Nedenfor vises ændringen fra de foregående 7 dage igen.

Ved at klikke på linket kan du se detaljer om quizzerne og opgaverne i kurset.';
$string['tour_dashboard_boxes'] = 'I bunden vises vigtige nøgletal for kurset.

Derudover indeholder hver boks et link, hvorigennem der er yderligere information tilgængelig.';
$string['tour_dashboard_graph'] = 'Grafen viser antallet af alle handlinger i den respektive uge.

Hvis det er et løbende kursus, er begyndelsen af den aktuelle uge markeret med en stiplet linje. Tal for den aktuelle uge vises ikke.';
$string['tour_more_information'] = 'Den interaktive rundvisning er nu afsluttet. Vi håber, at vi kunne give dig et godt overblik over funktionerne.<br><br>Flere svar på ofte stillede spørgsmål kan findes på hjælpesiden.';
$string['tour_title'] = 'Learning analytics';
