<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'questionnaire', language 'af', version '4.5'.
 *
 * @package     questionnaire
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['action'] = 'Aksie';
$string['activityoverview'] = 'Jy het vraelyste wat voltooi moet word';
$string['additionalinfo'] = 'Addisionele inligting';
$string['additionalinfo_help'] = 'Teks om boaan die eerste bladsy van hierdie vraelyste te vertoon (d.w.s. instruksies, agtergrondinligting, ensovoorts).';
$string['addnewquestion'] = '{$a} vraag word bygevoeg';
$string['addnewsection'] = '\'n Nuwe afdeling word bygevoeg';
$string['addquestion'] = 'Vraag ... word bygevoeg';
$string['addquestions'] = 'Vrae word bygevoeg';
$string['addquestiontosection'] = 'Vraag word by afdeling gevoeg';
$string['addselqtype'] = 'Gekose vraagtipe word bygevoeg';
$string['alignment'] = 'Instelling van Radioknoppies';
$string['alignment_help'] = 'Instelling van keuseknoppies: vertikaal (verstek) of horisontaal.';
$string['alignment_link'] = 'mod/questionnaire/questions#Radio_Buttons';
$string['all'] = 'Alle';
$string['allnameddegrees'] = 'Benoemde grade';
$string['allnameddegrees_help'] = 'Spesifiseer watter teks om te vertoon vir koerswaardes in stede van die getal. Laat blanko om nie te gebruik nie.';
$string['alreadyfilled'] = 'Jy het reeds hierdie vraelys vir ons ingevul {$a}. Dankie!';
$string['andaveragevalues'] = 'en gemiddelde waardes';
$string['anonymous'] = 'Anoniem';
$string['answer'] = 'Antwoord';
$string['answergiven'] = 'Hierdie antwoord is gegee';
$string['answernotgiven'] = 'Hierdie antwoord is nie gegee nie';
$string['answerquestions'] = 'Beantwoord die vrae ...';
$string['answers'] = 'Antwoorde';
$string['attempted'] = 'Hierdie vraag word ingedien.';
$string['attemptstillinprogress'] = 'In proses. Geberg op:';
$string['autonumbering'] = 'Outonommering';
$string['autonumbering_help'] = 'Outomatiese nommering van vrae en bladsye. Jy mag outomatiese nommering wil versper
 vir vraelyste met kondisionele vertakking.';
$string['autonumberno'] = 'Moet nie vrae of bladsye nommer nie';
$string['autonumberpages'] = 'Outonommer bladsye';
$string['autonumberpagesandquestions'] = 'Outonommer bladsye en vrae';
$string['autonumberquestions'] = 'Outonommer vrae';
$string['average'] = 'Gemiddeld';
$string['averageposition'] = 'Gemiddelde posisie';
$string['averagerank'] = 'Gemiddelde rang';
$string['averagesrow'] = 'Gemiddelde (waar van toepassing):';
$string['bodytext'] = 'Teksliggaam';
$string['boxesnbexact'] = 'presies {$a} boks(e).';
$string['boxesnbmax'] = '\'n maksimum van {$a} boks(e).';
$string['boxesnbmin'] = '\'n minimum van {$a} boks(e).';
$string['boxesnbreq'] = 'Vir hierdie vraag moet jy regmerk';
$string['by'] = 'deur';
$string['cannotviewpublicresponses'] = 'Jy kan nie antwoorde op hierdie publieke vraelys besigtig nie.';
$string['chart:bipolar'] = 'Bipolêre stawe';
$string['chart:hbar'] = 'Horisontale stawe';
$string['chart:radar'] = 'Radar';
$string['chart:rose'] = 'Roos';
$string['chart:type'] = 'Kaarttipe';
$string['chart:type_help'] = 'Kies die Kaarttipe wat jy vir hierdie terugvoer wil gebruik';
$string['chart:vprogress'] = 'Vertikale Vorderingstaaf';
$string['checkallradiobuttons'] = 'Merk asseblief <strong>{$a}</strong> radioknoppies!';
$string['checkboxes'] = 'Merkbokse';
$string['checkboxes_help'] = 'Voer een opsie per lyn in vir die gebruiker om een of meer antwoorde uit te kies.';
$string['checkboxes_link'] = 'mod/questionnaire/questions#Check_Boxes';
$string['checkbreaksadded'] = 'Nuwe Bladsybreuk(e) by posisie(s) ingevoeg:';
$string['checkbreaksok'] = 'Al die vereiste Bladsybreuke is teenwoordig!';
$string['checkbreaksremoved'] = '{$a} ekstra Bladsybreuk(e) is verwyder.';
$string['checknotstarted'] = 'Kies nie begin';
$string['checkstarted'] = 'Kies begin';
$string['clicktoswitch'] = '(kliek om te skakel)';
$string['closebeforeopen'] = 'Jy het \'n sluitingsdatum voor die aanvangsdatum gekies.';
$string['closed'] = 'Die vraelys is op {$a} gesluit. Dankie.';
$string['closedate'] = 'Laat antwoorde toe tot';
$string['closeson'] = 'Vraelys sluit op {$a}';
$string['completionsubmit'] = 'Student moet hierdie vraelys indien om dit te voltooi';
$string['condition'] = 'Voorwaarde';
$string['confalts'] = '- OF - <br />Bevestigingsbladsy';
$string['configemailreporting'] = 'Laat verslae per e-pos toe';
$string['configemailreportinglong'] = 'Ontsper opsies vir sommige verslae om direk na gespesifiseerde e-posadresse gestuur te word.';
$string['configmaxsections'] = 'Maksimum terugvoerafdelings';
$string['configusergraph'] = 'Vertoon kaarte vir "Persoonlikheidstoets"-terugvoer';
$string['configusergraphlong'] = 'Gebruik die <a href="http://www.rgraph.net/">Rgraph</a> biblioteek om "Persoonlikheidstoets"-terugvoerkaarte te vertoon.';
$string['confirmdelallresp'] = 'Is jy seker jy wil AL die antwoorde in hierdie vraelys uitwis?';
$string['confirmdelchildren'] = 'As jy hierdie vraag uitwis, sal die afstammelingvraag/-vrae daarvan ook uitgewis word:';
$string['confirmdeletesection'] = 'Is jy seker jy wil terugvoerafdeling "{$a}" uitwis?';
$string['confirmdelgroupresp'] = 'Is jy seker jy wil AL die antwoorde van {$a} uitwis?';
$string['confirmdelquestion'] = 'Is jy seker jy wil die vraag by posisie {$a} uitwis?';
$string['confirmdelquestionresps'] = 'Dit sal ook die {$a} antwoord(e) wat reeds op daardie vraag gegee is, uitwis.';
$string['confirmdelresp'] = 'Is jy seker jy wil die antwoord by &nbsp;{$a}&nbsp; uitwis?';
$string['confirmremovequestion'] = 'Is jy seker jy wil vraag "{$a->qname}" uit afdeling "{$a->sname}" verwyder?';
$string['confpage'] = 'Opskrifteks';
$string['confpage_help'] = 'Opskrif (in vetdruk) en teksliggaam vir die "Bevestiging" bladsy vertoon nadat \'n gebruiker hierdie vraelys voltooi. (URL, indien teenwoordig, neem voorkeur bo bevestigingsteks.) As jy hierdie veld leeg laat, sal \'n verstek boodskap vertoon word met die voltooiing van die vraelys (Dankie dat u hierdie Vraelys voltooi het).';
$string['confpagedesc'] = 'Opskrif (in vetdruk) en teksliggaam vir die &quot;Bevestiging&quot; bladsy vertoon nadat \'n gebruiker hierdie vraelys voltooi het. (URL, indien teenwoordig, neem voorkeur bo bevestigingsteks.)';
$string['contentoptions'] = 'Inhoudopsies';
$string['couldnotcreatenewsurvey'] = 'Kon nie \'n nuwe opname skep nie!';
$string['couldnotdelresp'] = 'Kon nie antwoord uitwis nie';
$string['createcontent'] = 'Definieer Nuwe Inhoud';
$string['createcontent_help'] = 'Kies een van die radioknoppie-opsies. \'Skep nuwe\' is die verstek.';
$string['createcontent_link'] = 'mod/questionnaire/mod#Content_Options';
$string['createnew'] = 'Skep nuwe';
$string['crontask'] = 'Vraelys-skoonmaakwerk';
$string['date'] = 'Datum';
$string['date_help'] = 'Gebruik hierdie vraagtipe as jy verwag dat die antwoord \'n korrek geformatteerde datum sal wees.';
$string['date_link'] = 'mod/questionnaire/questions#Date';
$string['dateformatting'] = 'Gebruik die jaar-maand-dag-formaat, bv. vir 4 Maart 1945: &nbsp; <strong>1945-03-04</strong>';
$string['deleteallresponses'] = 'Wis ALLE Antwoorde uit';
$string['deletecurrentquestion'] = 'Wis vraag {$a} uit';
$string['deletedallgroupresp'] = 'Wis ALLE Antwoorde in groep {$a} uit';
$string['deletedallresp'] = 'Vraelysantwoorde is uitgewis';
$string['deletedisabled'] = 'Hierdie item kan nie uitgewis word nie';
$string['deletedresp'] = 'Uitgewisde Antwoord';
$string['deleteresp'] = 'Wis hierdie antwoord uit';
$string['deletesection'] = 'Wis hierdie afdeling uit';
$string['deletingresp'] = 'Antwoord word Uitgewis';
$string['dependencies'] = 'Afhanklikhede';
$string['dependquestion'] = 'Moedervraag';
$string['dependquestion_help'] = 'Jy kan \'n moedervraag en keuse-opsie vir hierdie vraag kies. \'n Nasaatvraag sal slegs aan die student vertoon word
                as die moedervraag en moederkeuse voorheen gekies is.';
$string['dependquestion_link'] = 'mod/questionnaire/questions#Parent_Question';
$string['didnotrespondtoquestion'] = 'Het nie op vraag reageer nie';
$string['directwarnings'] = 'Direkte afhanklikhede op hierdie vraag sal verwyder word. Dit sal die volgende affekteer:';
$string['displaymethod'] = 'Vertoonmetode nie vir vraag gedefinieer nie.';
$string['download'] = 'Laai af';
$string['downloadpdf'] = 'Laai PDF af';
$string['downloadtextformat'] = 'Laai af';
$string['downloadtextformat_help'] = 'Hierdie funksie laat jou toe om al die antwoorde van \'n vraelys op \'n kiesbare, ondersteunde dokumentformaat te berg.
 Jy kan kies om ekstra data-items in die uitvoer in te sluit, asook kies om outomaties die dokument na gekose gebruikers te stuur.';
$string['downloadtextformat_link'] = 'mod/questionnaire/report#Download_in_text_format';
$string['downloadtypes'] = 'Verslagtipe';
$string['dropdown'] = 'Aftrekboks';
$string['dropdown_help'] = 'Daar is nie werklik enige voordeel om die Aftrekboks eerder as die Radioknoppies te gebruik nie, behalwe moontlik vir \'n langerige lys opsies om skermspasie te spaar.';
$string['dropdown_link'] = 'mod/questionnaire/questions#Dropdown_Box';
$string['edit'] = 'Wysig';
$string['editingfeedback'] = 'Terugvoerverstellings word gewysig';
$string['editingquestionnaire'] = 'Vraelysverstellings word gewysig';
$string['editquestion'] = '{$a} vraag word gewysig';
$string['email'] = 'E-pos';
$string['emailextra'] = 'Stuur aflaai na e-posse';
$string['emailextra_help'] = 'Sal die afgelaaide dokument na die gelyste e-posadresse, wat met kommas geskei is, stuur. Let daarop dat GEEN sekuriteit- of privaatheidskontrolering gedoen word nie.
 \'allowemailreporting\' moet in moduleverstellings ontsper wees om hiertoe toegang te hê.';
$string['emailroles'] = 'Stuur aflaai na rolle';
$string['emailroles_help'] = 'Sal die afgelaaide dokument na alle rolle met "mod/questionnaire:submissionnotification" vermoë via e-pos stuur.
 \'allowemailreporting\' moet in moduleverstellings ontsper wees om hiertoe toegang te hê.';
$string['emailsend'] = 'Stuur verslae';
$string['emailsnotspecified'] = 'Geen e-pos(se) is gespesifiseer nie.';
$string['emailssent'] = 'Afgelaaide dokumente is na gespesifiseerde e-pos(se) gestuur.';
$string['errnewname'] = 'Jammer, naam word reeds gebruik. Kies \'n ander naam.';
$string['erroropening'] = 'Fout met die opening van vraelys.';
$string['errortable'] = 'Fout stelseltabel is korrup.';
$string['essaybox'] = 'Opstelboks';
$string['essaybox_help'] = 'Hierdie vraag sal \'n eenvoudige teksboks met x Teksareakolomme (of areabreedte) en y Teksarearye (aantal tekslyne) vertoon.

As jy beide x en y op hul verstek waarde van 0 los (of as jy dit na 0 stel), sal moodle se HTML-wysiger vertoon word
 met standaard hoogte en breedte (indien beskikbaar in die kursus/gebruikerkonteks & gebruikerprofiel).';
$string['event_all_responses_deleted'] = 'Alle antwoorde uitgewis';
$string['event_all_responses_saved_as_text'] = 'Alle Antwoorde as teks geberg';
$string['event_all_responses_viewed'] = 'Alle Antwoordverslae is besigtig';
$string['event_individual_responses_viewed'] = 'Individuele Antwoordverslag is besigtig';
$string['event_non_respondents_viewed'] = 'Nierespondente is besigtig';
$string['event_previewed'] = 'Vraelys is vooraf besigtig';
$string['event_question_created'] = 'Vraag is geskep';
$string['event_question_deleted'] = 'Vraag is uitgewis';
$string['event_response_deleted'] = 'Individuele Antwoord is uitgewis';
$string['event_resumed'] = 'Poging is hervat';
$string['event_saved'] = 'Antwoorde is geberg';
$string['event_submitted'] = 'Antwoorde is ingedien';
$string['feedback'] = 'Terugvoer';
$string['feedback_help'] = 'Terugvoerhulp';
$string['feedback_link'] = 'mod/questionnaire/personality_test#Editing_Questionnaire_Feedback_Messages';
$string['feedbackaddmorefeedbacks'] = 'Voeg {$a} meer terugvoervelde in';
$string['feedbackbysection'] = 'Afdelings Terugvoer';
$string['feedbackdefaultlabel'] = '[Nuwe afdeling]';
$string['feedbackeditingglobal'] = 'Vraelys Globale Terugvoer word gewysig';
$string['feedbackeditingmessages'] = 'Vraelys Terugvoerboodskappe word gewysig';
$string['feedbackeditingsections'] = 'Vraelys Terugvoerafdelings word gewysig';
$string['feedbackeditmessages'] = 'Berg Afdelingverstellings en wysig Terugvoerboodskappe';
$string['feedbackeditsections'] = 'Berg verstellings en wysig Terugvoerafdelings';
$string['feedbackerrorboundaryformat'] = 'Terugvoerpuntgrense moet óf \'n persentasie, óf \'n getal wees. Die waarde wat jy in grens {$a} ingevoer het, word nie herken nie.';
$string['feedbackerrorboundaryoutofrange'] = 'Terugvoerpuntgrense moet tussen 0% en 100% wees. Die waarde wat jy in grens {$a} ingevoer het, is buite grense.';
$string['feedbackerrorjunkinboundary'] = 'Jy moet die terugvoerpunt-grensbokse invul sonder om enige oop plekke te laat.';
$string['feedbackerrorjunkinfeedback'] = 'Jy moet die terugvoerbokse invul sonder om enige oop plekke te laat.';
$string['feedbackerrororder'] = 'Terugvoerpuntgrense moet in volgorde wees, met die hoogste eerste. Die waarde wat jy in grens {$a} ingevoer het, is buite volgorde.';
$string['feedbackglobal'] = 'Globale Terugvoer';
$string['feedbackglobalheading'] = 'Globale Terugvoeropskrif';
$string['feedbackglobalmessages'] = 'Globale Terugvoerboodskappe';
$string['feedbackhdr'] = 'Terugvoer';
$string['feedbackheading'] = 'Terugvoeropskrif';
$string['feedbackheading_help'] = 'In die terugvoeropskrifveld kan jy 2 veranderlikes gebruik: $scorepercent and $oppositescorepercent.';
$string['feedbackmessages'] = '{$a} afdelingboodskappe';
$string['feedbacknextsection'] = 'Nuwe afdeling {$a}';
$string['feedbacknone'] = 'Geen Terugvoerboodskappe nie';
$string['feedbacknotes'] = 'Terugvoernotas';
$string['feedbacknotes_help'] = 'Teks wat hier ingevoer word sal aan die respondente aan die einde van hul Terugvoerverslag vertoon word';
$string['feedbackoptions'] = 'Terugvoeropsies';
$string['feedbackoptions_help'] = 'Terugvoeropsies is beskikbaar as jou vraelys die volgende vraagtipes en vraagverstellings bevat:
Radioknoppies; Aftrekboks; Ja/Nee; of Tempo (normaal of Osgood-skaal). Daardie vrae moet as Vereis gestel word, hul Vraagnaamveld mag NIE leeg wees nie en Moontlike antwoordkeuses moet \'n waarde bevat.';
$string['feedbackoptions_link'] = 'mod/questionnaire/personality_test';
$string['feedbackremovequestionfromsection'] = 'Hierdie vraag is deel van terugvoerafdeling [{$a}]';
$string['feedbackremovesection'] = 'Deur hierdie vraag te verwyder sal die terugvoerafdeling [{$a}] heeltemal verwyder word';
$string['feedbackreport'] = 'Terugvoerverslag';
$string['feedbackscore'] = 'Terugvoerpunt';
$string['feedbackscoreboundary'] = 'Terugvoerpuntgrens';
$string['feedbackscores'] = 'Vertoon Punte';
$string['feedbackscores_help'] = 'Vertoon die tabel van terugvoerpunte';
$string['feedbacksection'] = 'Afdeling';
$string['feedbacksectionheading'] = '{$a} afdelingopskrif';
$string['feedbacksectionheadingmissing'] = 'Jy moet \'n Opskrif vir hierdie Terugvoerafdeling invoer!';
$string['feedbacksectionheadingtext'] = 'Opskrif';
$string['feedbacksectionlabel'] = 'Etiket';
$string['feedbacksectionlabel_help'] = 'Hierdie etiket sal in die kaarte/diagramme gebruik word. Hou dit asseblief so kort as moontlik!';
$string['feedbacksectionquestions'] = '{$a} afdelingvrae';
$string['feedbacksections'] = 'Terugvoerafdelings';
$string['feedbacksectionsselect'] = 'Afdelings';
$string['feedbacksectionsselect_help'] = 'Plaas jou vrae in daardie Afdelings';
$string['feedbacksectionsselect_link'] = 'mod/questionnaire/personality_test#Editing_Questionnaire_Feedback_Sections_2';
$string['feedbacksettingssaved'] = 'Terugvoerverstellings is geberg';
$string['feedbacktype'] = 'Terugvoertipe';
$string['field'] = 'Vraag {$a}';
$string['fieldlength'] = 'Toevoerbokslengte';
$string['fieldlength_help'] = 'Vir die **Teksboks** vraagtipe, voer die **Toevoerbokslengte** en die **Maksimum Tekslengte** van teks wat deur die
respondent ingevoer moet word, in.

Verstek waardes is 20 karakters vir die Toevoerboksbreedte en 25 karakters vir die maksimum lengte van ingevoerde teks.';
$string['finished'] = 'Jy het al die vrae in hierdie vraelys beantwoord!';
$string['firstrespondent'] = 'Eerste Respondent';
$string['formateditor'] = 'HTML-wysiger';
$string['formatplain'] = 'Skoonteks';
$string['grade'] = 'Indieningspunt';
$string['gradesdeleted'] = 'Vraelyspunte is uitgewis';
$string['headingtext'] = 'Opskrifteks';
$string['horizontal'] = 'Horisontaal';
$string['id'] = 'ID';
$string['includechoicecodes'] = 'Sluit keusekodes in';
$string['includechoicetext'] = 'Sluit keuseteks in';
$string['includeincomplete'] = 'Sluit onvolledige antwoorde in';
$string['includerankaverages'] = 'Sluit gemiddeldes van rangvrae in';
$string['incorrectcourseid'] = 'Kursus-ID is verkeerd';
$string['incorrectmodule'] = 'Kursusmodule-ID was verkeerd';
$string['incorrectquestionnaire'] = 'Vraelys is verkeerd';
$string['indirectwarnings'] = 'Hierdie lys toon die indirek afhanklike vrae en oorblywende afhanklikhede vir direk afhanklike vrae:';
$string['invalidresponse'] = 'Ongeldige antwoord gespesifiseer.';
$string['invalidresponserecord'] = 'Ongeldige antwoordrekord gespesifiseer.';
$string['invalidsectionid'] = 'Ongeldige terugvoerafdeling gespesifiseer.';
$string['invalidsurveyid'] = 'Ongeldige vraelys-ID.';
$string['kindofratescale'] = 'Tipe beoordelingskaal';
$string['kindofratescale_help'] = 'Regskliek op die Meer Hulp-skakel hieronder.';
$string['kindofratescale_link'] = 'mod/questionnaire/questions#Type_of_rate_scale';
$string['lastrespondent'] = 'Laaste Respondent';
$string['length'] = 'Lengte';
$string['managequestions'] = 'Bestuur vrae';
$string['managequestions_help'] = 'In die Bestuur vrae-afdeling van die Wysig Vrae-bladsy kan jy \'n aantal operasies op \'n Vraelys se vrae uitvoer.';
$string['managequestions_link'] = 'mod/questionnaire/questions#Manage_questions';
$string['mandatory'] = 'Verpligtend - Al hierdie afhanklikhede moet vervul word.';
$string['maxdigitsallowed'] = 'Maks. syfers toegelaat';
$string['maxdigitsallowed_help'] = 'Gebruik **Maks. syfers toegelaat** om \'n beperking in te stel op die aantal karakters wat vir \'n Numeriese vraag ingevoer word. Let daarop dat die
desimaalpunt ook as een karakter gereken word!';
$string['maxdigitsallowed_link'] = 'mod/questionnaire/questions#Numeric';
$string['maxforcedresponses'] = 'Maks. geforseerde antwoorde';
$string['maxforcedresponses_help'] = 'Gebruik hierdie parameters om respondent te forseer om \'n minimum van **Min.** bokse en \'n maksimum van **Maks.** merkbokse te merk. Om
\'n presiese aantal merkbokse om te merk, te forseer, stel **Min.** en **Maks.** op dieselfde waarde. As slegs \'n min. of maks. waarde vereis word, laat die ander waarde net op sy verstek **0** waarde. As jy **Min.** of **Maks.** op ander waardes as hul verstek **0** waarde stel, sal \'n waarskuwingsboodskap vertoon word indien die respondent nie aan jou vereistes voldoen nie. Klaarblyklik behoort jy enige vereistes duidelik aan die respondent te stel, hetsy in die algemene instruksies van jou Vraelys, of in die teks van relevante vrae.';
$string['maxtextlength'] = 'Maks. tekslengte';
$string['maxtextlength_help'] = 'Vir die Teksboks-vraagtipe, voer die Toevoerbokslengte en die Maksimum tekslengte van die teks in wat deur die respondent ingevoer moet word.
Verstek waardes is 20 karakters vir die Toevoerboksbreedte en 25 karaktes vir die maksimum lengte van teks wat ingevoer word.';
$string['messageprovider:message'] = 'Herinner aan vraelys';
$string['messageprovider:notification'] = 'Indiening van vraelys';
$string['minforcedresponses'] = 'Min. geforseerde antwoorde';
$string['minforcedresponses_help'] = 'Gebruik hierdie parameters om respondent te forseer om \'n minimum van **Min** bokse en \'n maksimum van **Maks.** merkbokse te merk. Om
\'n presiese aantal merkbokse te forseer om gemerk te word, stel **Min.** en **Maks.** op dieselfde waarde. As slegs \'n min. of maks. waarde vereis word, los net die ander waarde op sy verstek **0** waarde. As jy **Min.** of **Maks.** op ander waardes as hul verstek **0** waarde stel, sal \'n waarskuwingsboodskap vertoon word as die respondent nie aan jou vereistes voldoen nie. Natuurlik behoort jy enige vereistes aan die respondent duidelik te maak, hetsy in die algemene instruksies van jou Vraelys of in die teks van relevante vrae.';
$string['misconfigured'] = 'Kursus is verkeerd opgestel';
$string['missingname'] = 'Vraag {$a} kan nie in hierdie terugvoerafdeling gebruik word nie, omdat dit nie oor \'n naam beskik nie.';
$string['missingnameandrequired'] = 'Vraag {$a} kan nie in hierdie terugvoerafdeling gebruik word nie, omdat dit nie oor \'n naam beskik nie en nie vereis word nie.';
$string['missingquestion'] = 'Antwoord asseblief vereiste vraag';
$string['missingquestions'] = 'Antwoorde asseblief vereiste vrae:';
$string['missingrequired'] = 'Vraag {$a} kan nie in hierdie terugvoerafdeling gebruik word nie, omdat dit nie vereis word nie.';
$string['modulename'] = 'Vraelys';
$string['modulename_help'] = 'Die Vraelys-module laat jou toe om opnames met \'n verskeidenheid vraagtipes te maak, met die doel om data van gebruikers in te vorder.';
$string['modulename_link'] = 'mod/questionnaire/view';
$string['modulenameplural'] = 'Vraelyste';
$string['movedisabled'] = 'Hierdie item kan nie geskuif word nie';
$string['myresponses'] = 'Al jou antwoorde';
$string['myresponsetitle'] = 'Jou {$a} antwoorde';
$string['myresults'] = 'Jou Uitslae';
$string['name'] = 'Naam';
$string['navigate'] = 'Laat vertakkingsvrae toe';
$string['navigate_help'] = 'Ontsper Ja/Nee- en Radioknoppies-vrae om Afstammelingvrae afhanklik van hul keuses in jou vraelys te hê.';
$string['navigate_link'] = 'mod/questionnaire/conditional_branching';
$string['navigatetosection'] = 'Gaan na terugvoerafdeling';
$string['next'] = 'Volgende';
$string['nextpage'] = 'Volgende Bladsy';
$string['nlines'] = '{$a} lyne';
$string['noanswer'] = 'Geen antwoord';
$string['noattempts'] = 'Geen pogings is aangewend vir hierdie vraelys nie';
$string['nodata'] = 'Geen data is gepos nie.';
$string['noduplicates'] = 'Geen duplikaat keuses';
$string['noduplicateschoiceserror'] = 'Jy moet minstens 2 Moontlike antwoorde vir die "Geen duplikaat keuses"-opsie invoer!';
$string['non_respondents'] = 'Gebruikers wat nog nie hul antwoorde op hierdie vraelys ingedien het nie.';
$string['noneinuse'] = 'Hierdie vraelys bevat geen vrae nie.';
$string['nopublicsurveys'] = 'Geen publieke vraelyste nie.';
$string['noresponsedata'] = 'Geen antwoorde vir hierdie vraag nie.';
$string['noresponses'] = 'Geen antwoorde';
$string['normal'] = 'Normaal';
$string['not_started'] = 'nie begin nie';
$string['notanumber'] = '<strong>{$a}</strong> is nie \'n aanvaarde getalformaat nie.';
$string['notapplicable'] = 'N/A';
$string['notapplicablecolumn'] = 'N/A-kolom';
$string['notavail'] = 'Hierdie vraelys is nie meer beskikbaar nie. Versoek jou onderwyser om dit uit te wis.';
$string['noteligible'] = 'Jy is nie gekies om hierdie vraelys te voltooi nie.';
$string['notemplatesurveys'] = 'Geen templaatvraelyste nie.';
$string['notenoughscaleitems'] = 'Jy moet \'n minimum waarde van 2 skaalitems invoer!';
$string['notificationfull'] = 'Volledige indiening';
$string['notifications'] = 'Stuur indieningkennisgewings';
$string['notifications_help'] = 'Stel rolle met die "mod/vraelys:indieningkenniskewing" vermoë in kennis wanneer \'n indiening gemaak word.';
$string['notifications_link'] = 'mod/questionnaire/mod#Submission_Notifications';
$string['notificationsimple'] = 'Slegs kennisgewing';
$string['notopen'] = 'Hierdie vraelys sal nie voor {$a} open nie.';
$string['notrequired'] = 'Antwoord nie vereis nie.';
$string['notset'] = 'Nie gestel';
$string['nousersselected'] = 'Geen gebruikers is gekies nie';
$string['num'] = '#';
$string['numattemptsmade'] = '{$a} pogings is op hierdie vraelys gemaak';
$string['numberfloat'] = 'Die getal wat jy ingevoer het <strong>{$a->number}</strong> is geherformatteer/afgerond met <strong>{$a->precision}</strong> desimale plek(ke).';
$string['numberofdecimaldigits'] = 'Aantal desimale syfers';
$string['numberofdecimaldigits_help'] = 'Gebruik **Aantal desimale syfers** om die formaat van die gemiddelde waarde wat getel en op die Vraelysverslagbladsy vertoon word, te spesifiseer.';
$string['numberofdecimaldigits_link'] = 'mod/questionnaire/questions#Numeric';
$string['numberscaleitems'] = 'Aantal skaalitems';
$string['numberscaleitems_help'] = 'Aantal skaalitems is die *aantal items* wat in jou beoordelingskaal gebruik sal word. Jy sou normaalweg \'n waarde van 3 tot 5 gebruik. Verstek waarde: **5**.';
$string['numeric'] = 'Numeries';
$string['numeric_help'] = 'Gebruik hierdie vraagtipe as jy verwag dat die antwoord \'n korrek geformatteerde getal moet wees.';
$string['of'] = 'van';
$string['openafterclose'] = 'Jy het \'n aanvangsdatum ná die sluitingsdatum gekies.';
$string['opendate'] = 'Laat antwoorde toe vanaf';
$string['option'] = 'opsie {$a}';
$string['optional'] = 'Opsioneel - Minstens een van hierdie afhanklikhede moet vervul word.';
$string['optionalname'] = 'Vraagnaam';
$string['optionalname_help'] = 'Die Vraagnaam word slegs gebruik as jy antwoorde na CSV/Excel-formaat uitvoer. As jy nooit na CSV uitvoer nie, hoef jy geensins oor Vraagname bekommerd te wees nie. As jy beplan om gereeld jou vraelysdata na CSV uit te voer, het jy \'n keuse tussen twee opsies vir vraagbenaming.';
$string['optionalname_link'] = 'mod/questionnaire/questions#Question_Name';
$string['or'] = '- OF -';
$string['order_ascending'] = 'Stygende volgorde';
$string['order_default'] = 'Besigtig Verstek volgorde';
$string['order_descending'] = 'Dalende volgorde';
$string['orderresponses'] = 'Orden Antwoorde';
$string['orderresponses_help'] = 'Wanneer Alle Antwoorde vertoon word, kan jy die keuses volgens aantal antwoorde (die Gemiddeld-kolom) vir die volgende 4 vraagtipes sorteer.

* enkelkeuses-radioknoppie
* enkelkeuses-aftreklys
* meervoudige keuses (merkbokse)
* beoordelingvrae (Likert-skale ingesluit).

Wanneer jy op die Alle Antwoorde-bladsy aankom, word alle antwoorde by verstek in die volgorde waarin die skepper van die vraelys die vraagkeuses ingevoer het, gesorteer.
Jy kan kies om dit in stygende of dalende volgorde te sorteer.';
$string['orderresponses_link'] = 'mod/questionnaire/report#Order_Responses';
$string['osgood'] = 'Osgood';
$string['other'] = 'Ander:';
$string['otherempty'] = 'As jy hierdie keuse merk, moet jy teks in die teksboks invoer!';
$string['overviewnumresplog'] = 'antwoorde';
$string['overviewnumresplog1'] = 'antwoord';
$string['overviewnumrespvw'] = 'antwoorde';
$string['overviewnumrespvw1'] = 'antwoord';
$string['owner'] = 'Eienaar';
$string['page'] = 'Bladsy';
$string['pageof'] = 'Bladsy {$a->page} van {$a->totpages}';
$string['parent'] = 'Moeder';
$string['participant'] = 'Deelnemer';
$string['pleasecomplete'] = 'Voltooi asseblief hierdie keuse.';
$string['pluginadministration'] = 'Vraelysadministrasie';
$string['pluginname'] = 'Vraelys';
$string['position'] = 'posisie';
$string['possibleanswers'] = 'Moontlike antwoorde';
$string['posteddata'] = 'Bereikte bladsy met geposde data:';
$string['preview_label'] = 'Voorskou';
$string['preview_questionnaire'] = 'Vraelysvoorskou';
$string['previewing'] = 'Vraelys word vooraf besigtig';
$string['previous'] = 'Vorige';
$string['previouspage'] = 'Vorige Bladsy';
$string['print'] = 'Druk hierdie Antwoord';
$string['printblank'] = 'Druk Blanko';
$string['printblanktooltip'] = 'Open drukkervriendelike venster met leë Vraelys';
$string['printtooltip'] = 'Open drukkervriendelike venster met huidige Antwoord';
$string['privacy:metadata:questionnaire_resp_multiple'] = '\'n Meervoudigekeusevraag-antwoord.';
$string['privacy:metadata:questionnaire_resp_multiple:choice_id'] = 'Die ID van \'n keuserekord vir hierdie antwoord.';
$string['privacy:metadata:questionnaire_resp_multiple:question_id'] = 'Die ID van die vraagrekord vir hierdie antwoord.';
$string['privacy:metadata:questionnaire_resp_multiple:response_id'] = 'Die ID van die antwoordrekord vir hierdie antwoord.';
$string['privacy:metadata:questionnaire_resp_single'] = '\'n Enkelkeusevraag-antwoord.';
$string['privacy:metadata:questionnaire_resp_single:choice_id'] = 'Die ID van die keuserekord vir hierdie antwoord.';
$string['privacy:metadata:questionnaire_resp_single:question_id'] = 'Die ID van die vraagrekord vir hierdie antwoord.';
$string['privacy:metadata:questionnaire_resp_single:response_id'] = 'Die ID van die antwoordrekord vir hierdie antwoord.';
$string['privacy:metadata:questionnaire_response'] = '\'n Antwoord is in proses of word ingedien';
$string['privacy:metadata:questionnaire_response:complete'] = 'Die antwoordvoltooiingstatus.';
$string['privacy:metadata:questionnaire_response:grade'] = 'Die punt vir hierdie antwoord.';
$string['privacy:metadata:questionnaire_response:questionnaireid'] = 'Die ID van die vraelysrekord vir hierdie antwoord.';
$string['privacy:metadata:questionnaire_response:submitted'] = 'Die tydstempel vir die mees onlangse berging van hierdie antwoord.';
$string['privacy:metadata:questionnaire_response:userid'] = 'Die ID van die gebruiker van hierdie antwoord.';
$string['privacy:metadata:questionnaire_response_bool'] = '\'n Boolse (ja/nee) vraagrespons.';
$string['privacy:metadata:questionnaire_response_bool:choice_id'] = 'Die spesifieke boolse antwoord.';
$string['privacy:metadata:questionnaire_response_bool:question_id'] = 'Die ID van die vraagrekord vir hierdie antwoord.';
$string['privacy:metadata:questionnaire_response_bool:response_id'] = 'Die ID van die antwoordrekord vir hierdie antwoord.';
$string['privacy:metadata:questionnaire_response_date'] = '\'n Datumvraag-antwoord.';
$string['privacy:metadata:questionnaire_response_date:question_id'] = 'Die ID van die vraagrekord vir hierdie antwoord.';
$string['privacy:metadata:questionnaire_response_date:response'] = 'Die spesifieke datum-antwoord.';
$string['privacy:metadata:questionnaire_response_date:response_id'] = 'Die ID van die antwoordrekord vir hierdie antwoord.';
$string['privacy:metadata:questionnaire_response_other'] = '\'n \'Ander\' keuseteks-antwoord.';
$string['privacy:metadata:questionnaire_response_other:choice_id'] = 'Die ID van die keuserekord vir hierdie antwoord.';
$string['privacy:metadata:questionnaire_response_other:question_id'] = 'Die ID van die vraagrekord vir hierdie antwoord.';
$string['privacy:metadata:questionnaire_response_other:response'] = 'Die spesifieke teksantwoord.';
$string['privacy:metadata:questionnaire_response_other:response_id'] = 'Die ID van die antwoordrekord vir hierdie antwoord.';
$string['privacy:metadata:questionnaire_response_rank'] = '\'n Rangeervraag-antwoord.';
$string['privacy:metadata:questionnaire_response_rank:choice_id'] = 'Die ID van die keuserekord vir hierdie antwoord.';
$string['privacy:metadata:questionnaire_response_rank:question_id'] = 'Die ID van die vraagrekord vir hierdie antwoord.';
$string['privacy:metadata:questionnaire_response_rank:rankvalue'] = 'Die spesifieke rangeer-antwoord.';
$string['privacy:metadata:questionnaire_response_rank:response_id'] = 'Die ID van die antwoordrekord vir hierdie antwoord.';
$string['privacy:metadata:questionnaire_response_text'] = '\'n Teksvraag-antwoord.';
$string['privacy:metadata:questionnaire_response_text:question_id'] = 'Die ID van die vraagrekord vir hierdie antwoord.';
$string['privacy:metadata:questionnaire_response_text:response'] = 'Die spesifieke teksantwoord.';
$string['privacy:metadata:questionnaire_response_text:response_id'] = 'Die ID van die antwoordrekord vir hierdie antwoord.';
$string['private'] = 'Privaat';
$string['progressbar'] = 'Vertoon vorderingsbalk';
$string['progressbar_info'] = 'Vraelys {$a} voltooi.';
$string['progresshelp'] = 'Vorderingsbalk';
$string['progresshelp_help'] = 'Gaan na die volgende bladsy om die vorderingsbalk vol te maak';
$string['public'] = 'Publiek';
$string['publiccopy'] = 'Kopieer:';
$string['publicoriginal'] = 'Oorspronklik:';
$string['qtype'] = 'Soort';
$string['qtype_help'] = 'Kies of gebruikers toegelaat sal word om eenmalig, daagliks, weekliks, maandeliks of \'n onbeperkte (veelvuldig) aantal kere te antwoord.';
$string['qtypedaily'] = 'antwoord daagliks';
$string['qtypemonthly'] = 'antwoord maandeliks';
$string['qtypeonce'] = 'antwoord eenmalig';
$string['qtypeunlimited'] = 'antwoord veelvuldig';
$string['qtypeweekly'] = 'antwoord weekliks';
$string['questionnaire:addinstance'] = 'Voeg \'n nuwe vraelys by';
$string['questionnaire:copysurveys'] = 'Kopieer templaat- en private vraelyste';
$string['questionnaire:createpublic'] = 'Skep publieke vraelyste';
$string['questionnaire:createtemplates'] = 'Skep templaatvraelyste';
$string['questionnaire:deleteresponses'] = 'Wis enige antwoord uit';
$string['questionnaire:downloadresponses'] = 'Laai antwoorde in \'n CSV-dokument af';
$string['questionnaire:editquestions'] = 'Skep en wysig vraelysvrae';
$string['questionnaire:manage'] = 'Skep en wysig vraelyste';
$string['questionnaire:message'] = 'Stuur boodskap na nie-respondente';
$string['questionnaire:preview'] = 'Besigtig vraelyste vooruit';
$string['questionnaire:printblank'] = 'Druk blanko vraelys';
$string['questionnaire:readallresponseanytime'] = 'Lees alle antwoorde te eniger tyd';
$string['questionnaire:readallresponses'] = 'Lees antwoordopsommings, onderhewig aan oop tye';
$string['questionnaire:readownresponses'] = 'Lees eie antwoorde';
$string['questionnaire:submissionnotification'] = 'Ontvang kennisgewing vir elke indiening';
$string['questionnaire:submit'] = 'Voltooi en dien \'n vraelys in';
$string['questionnaire:view'] = 'Besigtig \'n vraelys';
$string['questionnaire:viewsingleresponse'] = 'Besigtig volledige individuele antwoorde';
$string['questionnaireadministration'] = 'Vraelysadministrasie';
$string['questionnairecloses'] = 'Vraelys Sluit';
$string['questionnaireopens'] = 'Vraelys Open';
$string['questionnairereport'] = 'Vraelysverslag';
$string['questionnum'] = 'Vraag #';
$string['questions'] = 'Vrae';
$string['questionsinsection'] = 'Vrae in hierdie afdeling:';
$string['questiontypes'] = 'Vraagtipes';
$string['questiontypes_help'] = 'Sien die Moodle-dokumentasie hieronder';
$string['questiontypes_link'] = 'mod/questionnaire/questions#Question_Types';
$string['radiobuttons'] = 'Radioknoppies';
$string['radiobuttons_help'] = 'In hierdie vraagtipe moet die respondent een van die keuses wat aangebied word, kies.';
$string['radiobuttons_link'] = 'mod/questionnaire/questions#Radio_Buttons';
$string['rank'] = 'Rangeer';
$string['ratescale'] = 'Beoordeel (skaal 1 ... 5)';
$string['ratescale_help'] = 'Sien die Moodle-dokumentasie hieronder';
$string['ratescale_link'] = 'mod/questionnaire/questions#Rate_.28scale_1..5.29';
$string['realm'] = 'Vraelystipe';
$string['realm_help'] = '* **Daar is drie tipes vraelyste:**
 * Privaat - behoort slegs aan die kursus waarin dit gedefinieer is.
 * Templaat - kan gekopieer en gewysig word.
 * Publiek - kan deur kursusse gedeel word.';
$string['realm_link'] = 'mod/questionnaire/qsettings#Questionnaire_Type';
$string['redirecturl'] = 'Die URL waarheen \'n gebruiker aangestuur word nadat hierdie vraelys voltooi is.';
$string['remove'] = 'Wis uit';
$string['removeallquestionnaireattempts'] = 'Wis alle vraelysantwoorde uit';
$string['removenotinuse'] = 'Hierdie vraelys het vantevore op \'n Publieke vraelys, wat uitgewis is, berus.
Dit kan nie meer gebruik word nie en behoort uitgewis te word.';
$string['required'] = 'Antwoord word vereis';
$string['required_help'] = 'As jy **Ja** kies, sal \'n antwoord op hierdie vraag vereis word, d.w.s.
die respondent sal nie die vraelys kan indien
voordat hierdie vraag beantwoord is nie.';
$string['required_link'] = 'mod/questionnaire/questions#Response_Required';
$string['requiredparameter'] = '\'n Vereiste parameter het ontbreek.';
$string['reset'] = 'Herstel';
$string['respeligiblerepl'] = '(vervang deur roloorheersings)';
$string['respondent'] = 'Respondent';
$string['respondenteligibleall'] = 'alle';
$string['respondenteligiblestudents'] = 'slegs studente';
$string['respondenteligibleteachers'] = 'slegs onderwysers';
$string['respondents'] = 'Respondente';
$string['respondenttype'] = 'Respondenttipe';
$string['respondenttype_help'] = 'Jy kan jou gebruiker se volle name met elke antwoord vertoon deur hierdie op "vollenaam" te stel.
Jy kan jou gebruikers se identiteite van die antwoorde versteek deur hierdie op "anoniem" te stel.';
$string['respondenttype_link'] = 'mod/questionnaire/mod#Respondent_Type';
$string['respondenttypeanonymous'] = 'anoniem';
$string['respondenttypefullname'] = 'vollenaam';
$string['response'] = 'Antwoord';
$string['responsefieldlines'] = 'Toevoerbokstipe';
$string['responseformat'] = 'Antwoordformaat';
$string['responseoptions'] = 'Antwoordopsies';
$string['responses'] = 'Antwoorde';
$string['responseview'] = 'Studente kan ALLE antwoorde besigtig';
$string['responseview_help'] = 'Jy kan spesifiseer wie die antwoorde van alle respondente op ingediende vraelyste kan sien (algemene statistiektabelle).';
$string['responseview_link'] = 'mod/questionnaire/mod#Response_viewing';
$string['responseviewstudentsalways'] = 'Altyd';
$string['responseviewstudentsnever'] = 'Nooit';
$string['responseviewstudentswhenanswered'] = 'Nadat die vraelys beantwoord is';
$string['responseviewstudentswhenclosed'] = 'Nadat die vraelys gesluit is';
$string['restrictedtoteacher'] = 'Hierdie funksies word beperk tot slegs redigerende onderwysers!';
$string['resume'] = 'Berg/Hervat antwoorde';
$string['resume_help'] = 'Deur hierdie opsie te stel word gebruikers toegelaat om hul antwoorde op \'n vraelys te berg voordat hulle dit indien.
 Gebruikers kan die vraelys onvoltooid laat en op \'n latere stadium van die bergingspunt af hervat.';
$string['resume_link'] = 'mod/questionnaire/mod#Save/Resume_answers';
$string['resumesurvey'] = 'Hervat vraelys';
$string['return'] = 'Keer terug';
$string['save'] = 'Berg';
$string['saveasnew'] = 'Berg as Nuwe Vraag';
$string['savedbutnotsubmitted'] = 'Hierdie vraelys is geberg maar nog nie ingedien nie.';
$string['savedprogress'] = 'Jou vordering is geberg. Jy kan te eniger tyd terugkeer om hierdie vraelys te voltooi.';
$string['saveeditedquestion'] = 'Berg vraag {$a}';
$string['savesettings'] = 'Berg verstellings';
$string['search:activity'] = 'Vraelys - aktiwiteitinligting';
$string['search:question'] = 'Vraelys - vrae';
$string['section'] = 'Beskrywing';
$string['sectionbreak'] = '----- Bladsybreuk -----';
$string['sectionbreak_help'] = '----- Bladsybreuk -----';
$string['sectionsnotset'] = 'Jy moet minstens EEN vraag per afdeling kies!<br />Afdeling(s) nie gekies nie: {$a}';
$string['sectiontext'] = 'Etiket';
$string['sectiontext_help'] = 'Hierdie is nie \'n vraag nie, maar \'n (kort) teks wat vertoon sal word om \'n reeks vrae bekend te stel.';
$string['selecttheme'] = 'Kies \'n tema (css) om saam met hierdie vraelys te gebruik.';
$string['send'] = 'Stuur';
$string['send_message'] = 'Stuur boodskap na gekose gebruikers';
$string['send_message_to'] = 'Stuur boodskap na:';
$string['sendemail'] = 'Stuur e-pos';
$string['sendemail_help'] = 'Stuur \'n kopie van elke indiening na die gespesifiseerde adres of adresse.
Jy kan meer as een adres verskaf deur dit met kommas te skei.
Laat blanko vir geen e-posrugsteun nie. \'allowemailreporting\' moet in moduleverstellings ontsper wees om hiertoe toegang te hê.';
$string['set'] = 'stel';
$string['settings'] = 'Verstellings';
$string['settingssaved'] = 'Verstellings is geberg';
$string['show_nonrespondents'] = 'Nierespondente';
$string['started'] = 'is begin';
$string['strfdate'] = '%d/%m/%Y';
$string['strfdateformatcsv'] = 'd/m/Y H:i:s';
$string['strictdateformatting'] = 'Voer die datum in deur die datumkieser hieronder te gebruik, of deur die \'JJJJ-MM-DD\'-formaat te gebruik.';
$string['subject'] = 'Onderwerp';
$string['submissionnotificationhtmlanon'] = 'Daar is \'n nuwe <a href="{$a->submissionurl}">indiening</a> op die "{$a->name}" vraelys.';
$string['submissionnotificationhtmluser'] = '<a href="{$a->profileurl}">{$a->username}</a> het \'n nuwe <a href="{$a->submissionurl}">indiening</a> op die "{$a->name}" vraelys in die kursus "{$a->coursename}".';
$string['submissionnotificationsubject'] = 'Nuwe vraelysindiening';
$string['submissionnotificationtextanon'] = 'Daar is \'n nuwe indiening ({$a->submissionurl}) op die "{$a->name}" vraelys.';
$string['submissionnotificationtextuser'] = '{$a->username} ({$a->profileurl}) het \'n nuwe indiening ({$a->submissionurl}) op die "{$a->name}" vraelys in die kursus "{$a->coursename}".';
$string['submitoptions'] = 'Indieningsopsies';
$string['submitpreview'] = 'Dien voorskou in';
$string['submitpreviewcorrect'] = 'Hierdie indiening sou as korrek ingevul aanvaar word.';
$string['submitsurvey'] = 'Dien vraelys in';
$string['submitted'] = 'Ingedien op:';
$string['subtitle'] = 'Byskrif';
$string['subtitle_help'] = 'Byskrif van hierdie vraelys. Verskyn onder die titel op slegs die eerste bladsy.';
$string['summary'] = 'Opsomming';
$string['summaryreportattached'] = 'Vraelysopsommingsverslag is aangeheg';
$string['surveynotexists'] = 'vraelys bestaan nie.';
$string['surveyowner'] = 'Jy moet \'n eienaar van die vraelys wees om hierdie operasie uit te voer.';
$string['surveyresponse'] = 'Antwoord uit vraelys';
$string['template'] = 'Templaat';
$string['templatenotviewable'] = 'Templaatvraelyste kan nie besigtig word nie.';
$string['text'] = 'Vraagteks';
$string['textareacolumns'] = 'Teksarea-kolomme';
$string['textareacolumns_help'] = 'Hierdie vraag sal \'n teksboks vertoon met **x** *Teksarea-kolomme* (of area *breedte*) en **y** *Teksarea-rye* (aantal teks
*lyne*).
As jy beide x en y op hul verstek **0** waarde los (of as jy dit na **0** stel), sal die HTML-wysiger met standaard hoogte en breedte vertoon word (indien beskikbaar in die kursus-/gebruikerkonteks &amp; gebruikerprofiel).';
$string['textarearows'] = 'Teksarea-rye';
$string['textbox'] = 'Teksboks';
$string['textbox_help'] = 'Voer die Toevoerbokslengte en Maksimum tekslengte van teks wat deur die respondent ingevoer moet word, vir die Teksboks-vraagtipe in.
Verstek waardes is 20 karakters vir die Toevoerboks se breedte en 25 karakters vir die maksimum lengte van teks wat ingevoer kan word.';
$string['textdownloadoptions'] = 'Opsies vir CSV-aflaai';
$string['thank_head'] = 'Dankie dat jy hierdie Vraelys voltooi het.';
$string['theme'] = 'Tema';
$string['thismonth'] = 'hierdie maand';
$string['thisresponse'] = 'Hierdie antwoord';
$string['thisweek'] = 'hierdie week';
$string['thousands'] = 'Moet nie van duisendskeiers gebruik maak nie.';
$string['title'] = 'Titel';
$string['title_help'] = 'Titel van hierdie vraelys wat boaan elke bladsy vertoon sal word. By verstek word Titel gestel volgens die Vraelys se Naam, maar jy kan dit na jou voorkeur wysig.';
$string['today'] = 'vandag';
$string['total'] = 'Totaal';
$string['totalofnumbers'] = 'Totale getalle ingevoer';
$string['totalresponses'] = 'Totale antwoorde op hierdie vraag';
$string['type'] = 'Vraagtipe';
$string['undefinedquestiontype'] = 'Ongedefinieerde vraagtipe!';
$string['unknown'] = 'Onbekend';
$string['unknownaction'] = 'Onbekende vraelysaksie gespesifiseer ...';
$string['url'] = 'Bevesting-URL';
$string['url_help'] = 'Die URL waarheen \'n gebruiker herlei word nadat hierdie vraelys voltooi word.';
$string['useprivate'] = 'Kopieer bestaande';
$string['usepublic'] = 'Gebruik publiek';
$string['usetemplate'] = 'Gebruik templaat';
$string['vertical'] = 'Vertikaal';
$string['view'] = 'Besigtig';
$string['viewallresponses'] = 'Besigtig alle Antwoorde';
$string['viewallresponses_help'] = 'As die vraelys op **Groepmodus**: *Sigbare groepe* gestel is, of op *Aparte groepe* gestel is en die huidige gebruiker
die *moodle/site:accessallgroups* vermoë het (in die huidige konteks) en groepe is in die huidige kursus gedefinieer,
 het die gebruiker toegang tot \'n aftreklys van groepe. Hierdie aftreklys stel die gebruiker in staat om die vraelysantwoorde volgens groepe te "filtreer".
 As die verstelling **Groepmodus**: *Aparte groepe* is, sal gebruikers wat nie oor die *moodle/site:accessallgroups* vermoë beskik nie
 (gewoonlik studente, nieredigerende onderwysers, ens.) slegs die antwoorde van die groep(e) waaraan hulle behoort, kan besigtig.';
$string['viewallresponses_link'] = 'Viewing_Questionnaire_responses#Group_filtering';
$string['viewbyresponse'] = 'Lys antwoorde';
$string['viewindividualresponse'] = 'Individuele antwoorde';
$string['viewindividualresponse_help'] = 'Kliek op die respondente se name in die lys hieronder om hul individuele antwoorde te besigtig.';
$string['viewresponses'] = 'Alle antwoorde ({$a})';
$string['viewyourresponses'] = 'Jou antwoorde- besigtig {$a}';
$string['warning'] = 'Waarskuwing, \'n fout het voorgekom.';
$string['wronganswers'] = 'Daar is iets fout met jou antwoorde (sien hieronder)';
$string['wrongdateformat'] = 'Die datum ingevoer: <strong>{$a}</strong> stem nie ooreen met die formaat wat in die voorbeeld getoon is nie.';
$string['wrongdaterange'] = 'FOUT! Die jaar moet binne die grense van 1902 tot 2037 gestel wees.';
$string['wrongformat'] = 'Daar is iets fout met jou antwoord op vraag:&nbsp;';
$string['wrongformats'] = 'Daar is iets fout met jou antwoord op vrae:&nbsp;';
$string['yesno'] = 'Ja/Nee';
$string['yesno_help'] = 'Eenvoudige Ja/Nee-vraag';
$string['yourresponse'] = 'Jou antwoord';
$string['yourresponses'] = 'Jou antwoorde';
