<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'theme_essential', language 'uk', version '4.4'.
 *
 * @package     theme_essential
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['above'] = 'Вище';
$string['advert_alttext'] = 'Рекламний банер Тематичного Дизайну Рівня 1';
$string['advert_heading'] = 'Тематичний Дизайн Рівня 1';
$string['advert_tagline'] = 'Хочете знати, як налаштувати теми, але не маєте базису розробника, досвіду з php та досвіду роботи з темами Moodle, тоді для вас є "MoodleBites Theme Design Level 1"! Це дасть вам неабиякий поштовх до розробки тем Moodle і забезпечить гарне підґрунтя, якщо ви хочете досягти подальшого прогресу. Будь-ласка, натисніть тут, щоб отримати додаткову інформацію.';
$string['aftercontent'] = 'Після контенту';
$string['alert1'] = 'Перше повідомлення';
$string['alert2'] = 'Друге повідомлення';
$string['alert3'] = 'Третє повідомлення';
$string['alert_edit'] = 'Редагувати повідомлення';
$string['alert_general'] = 'Анонс';
$string['alert_info'] = 'Інформація';
$string['alert_warning'] = 'Попередження';
$string['alertinfodesc'] = 'Введіть налаштування для повідомлення.';
$string['alertsdesc'] = 'Це буде показувати певне повідомлення (або кілька відразу) в трьох різних стилях на Головній сторінці вашого Moodle. Не забувайтеся відключати ці повідомлення, коли вони вже стають не актуальними.';
$string['alertsheading'] = 'Повідомлення користувачів';
$string['alertsheadingsub'] = 'Показувати важливі повідомлення для ваши користувачів на Головній сторінці';
$string['alerttext'] = 'Текст повідомлення';
$string['alerttextdesc'] = 'Який текст ви бажаєте показувати в повідомленні.';
$string['alerttitle'] = 'Заголовок';
$string['alerttitledesc'] = 'Головна назва/ заголовок для вашого повідомлення.';
$string['alerttype'] = 'Рівень';
$string['alerttypedesc'] = 'Встановіть відповідний рівень повідомлення, для  найкращого інформування своїх користувачів.';
$string['allclasses'] = 'Всі класи';
$string['allcourses'] = 'Всі курси';
$string['allmodules'] = 'Всі модулі';
$string['allunits'] = 'Всі завдання';
$string['alternativecolors'] = 'Альтернативні кольори {$a}';
$string['alternativethemecolor'] = 'Альтернативний колір теми {$a}';
$string['alternativethemecolordesc'] = 'Який колір в темі буде використовуватися в альтернативній кольоровій схемі {$a}';
$string['alternativethemecolorname'] = 'Назву альтернативної кольорової схеми {$a}';
$string['alternativethemecolornamedesc'] = 'Задайте зрозуміле ім\'я для цього набору кольорів альтернативної теми';
$string['alternativethemecolors'] = 'Альтернативні кольорові схеми';
$string['alternativethemecolorsdesc'] = 'Визначає альтернативні кольорові схеми теми, які може вибрати користувач.';
$string['alternativethemedefaultbuttonbackgroundcolour'] = 'Типовий колір для тла кнопки {$a}';
$string['alternativethemedefaultbuttonbackgroundcolourdesc'] = 'Встановіть типовий колір тла для всіх кнопок {$a}.';
$string['alternativethemedefaultbuttonbackgroundhovercolour'] = 'Типовий колір для тла кнопки при наведенні {$a}';
$string['alternativethemedefaultbuttonbackgroundhovercolourdesc'] = 'Встановіть типовий колір тла при наведенні для всіх кнопок {$a}.';
$string['alternativethemedefaultbuttontextcolour'] = 'Типовий колір тексту кнопки {$a}';
$string['alternativethemedefaultbuttontextcolourdesc'] = 'Встановіть типовий колір тексту для всіх кнопок {$a}.';
$string['alternativethemedefaultbuttontexthovercolour'] = 'Типовий колір тексту кнопки при наведенні {$a}';
$string['alternativethemedefaultbuttontexthovercolourdesc'] = 'Встановіть типовий колір тексту при наведенні для всіх кнопок {$a}.';
$string['alternativethemefooterblockbackgroundcolour'] = 'Колір тла для підвалин сайту для альтернативної кольорової схеми {$a}';
$string['alternativethemefooterblockbackgroundcolourdesc'] = 'Встановіть колір тла для підвалин сайту для альтернативної кольорової схеми {$a}.';
$string['alternativethemefooterblockhovercolour'] = 'Колір гіперпосилання при наведенні в підвалинах сайту для альтернативної кольорової схеми {$a}';
$string['alternativethemefooterblockhovercolourdesc'] = 'Встановіть колір тексту гіперпосилання в підвалинах сайту при наведенні на нього курсору для альтернативної кольорової схеми {$a}.';
$string['alternativethemefooterblocktextcolour'] = 'Колір тексту в підвалинах сайту для альтернативної кольорової схеми {$a}';
$string['alternativethemefooterblocktextcolourdesc'] = 'Встановіть колір тексту в підвалинах сайту для альтернативної кольорової схеми {$a}.';
$string['alternativethemefooterblockurlcolour'] = 'Колір гіперпосилання в підвалинах сайту для альтернативної кольорової схеми {$a}';
$string['alternativethemefooterblockurlcolourdesc'] = 'Встановіть колір тексту гіперпосилання в підвалинах сайту для альтернативної кольорової схеми {$a}.';
$string['alternativethemefootercolor'] = 'Колір тла для підвалин сайту для альтернативної кольорової схеми {$a}';
$string['alternativethemefootercolordesc'] = 'Встановіть колір тла для підвалин сайту для альтернативної кольорової схеми {$a}.';
$string['alternativethemefooterheadingcolor'] = 'Колір заголовків для підвалин сайту для альтернативної кольорової схеми {$a}';
$string['alternativethemefooterheadingcolordesc'] = 'Встановіть колір заголовків для підвалин сайту для альтернативної кольорової схеми {$a}.';
$string['alternativethemefooterhovercolor'] = 'Колір гіперпосилання при наведенні в підвалинах сайту для альтернативної кольорової схеми {$a}';
$string['alternativethemefooterhovercolordesc'] = 'Встановіть колір тексту гіперпосилання при наведенні курсору в підвалинах сайту для альтернативної кольорової схеми {$a}.';
$string['alternativethemefootersepcolor'] = 'Колір роздільника в підвалинах сайту для альтернативної кольорової схеми {$a}';
$string['alternativethemefootersepcolordesc'] = 'Роздільники - лінії, які використовуються для розділення вмісту. Встановіть колір роздільника для альтернативної кольорової схеми {$a}.';
$string['alternativethemefootertextcolor'] = 'Колір тексту в підвалинах сайту для альтернативної кольорової схеми {$a}';
$string['alternativethemefootertextcolordesc'] = 'Встановіть колір для тексту в підвалинах сайту для альтернативної кольорової схеми {$a}.';
$string['alternativethemefooterurlcolor'] = 'Колір гіперпосилання в підвалинах сайту для альтернативної кольорової схеми {$a}';
$string['alternativethemefooterurlcolordesc'] = 'Встановіть колір гіперпосилання в підвалинах сайту для альтернативної кольорової схеми {$a}.';
$string['alternativethemehovercolor'] = 'Альтернативний колір при наведенні {$a}';
$string['alternativethemehovercolordesc'] = 'Який колір посилання повинен бути при наведенні на нього курсору в альтернативній кольоровій схемі {$a}.';
$string['alternativethemeiconcolor'] = 'Колір альтернативного значка {$a}';
$string['alternativethemeiconcolordesc'] = 'Встановіть альтернативний {$a} колір для всіх значків.';
$string['alternativethememycoursesorderenrolbackcolour'] = 'Альтернативний колір фону для не відвіданих користувачем курсів, в які він записаний {$a}';
$string['alternativethememycoursesorderenrolbackcolourdesc'] = 'Встановіть альтернативний колір фону для не відвіданих користувачем курсів, в які він записаний {$a}. Параметр  «mycoursesorder» при цьому встановлюється в «Останні відвіданні...».';
$string['alternativethemename'] = 'Назва кольорової схеми';
$string['alternativethemenamedesc'] = 'Вкажіть назву для альтернативної кольорової схеми';
$string['alternativethemenavcolor'] = 'Колір тексту Навігаційноїпанелі  {$a}';
$string['alternativethemenavcolordesc'] = 'Встановіть альтернативний {$a} колір тексту для Навігаційнї панелі.';
$string['alternativethemeslidebuttoncolor'] = 'Альтернативний колір кнопки слайду {$a}';
$string['alternativethemeslidebuttoncolordesc'] = 'Колір кнопки навігації на слайді для альтернативної схеми кольорів {$a}.';
$string['alternativethemeslidebuttonhovercolor'] = 'Альтернативний колір кнопки слайду при наведенні {$a}';
$string['alternativethemeslidebuttonhovercolordesc'] = 'Колір кнопки навігації на слайді при наведенні курсора на кнопку для альтернативної схеми кольорів {$a}.';
$string['alternativethemeslidecaptionbackgroundcolor'] = 'Альтернативний колір фону підпису слайду {$a}';
$string['alternativethemeslidecaptionbackgroundcolordesc'] = 'Колір фону підпису слайду для альтернативної схеми кольорів {$a}. Не використовується при виборі варіанта «Збоку» для підпису слайду.';
$string['alternativethemeslidecaptiontextcolor'] = 'Альтернативний колір тексту підпису слайду {$a}';
$string['alternativethemeslidecaptiontextcolordesc'] = 'Колір тексту підпису слайду для альтернативної схеми кольорів {$a}. Не використовується при виборі варіанта «Збоку» для підпису слайду.';
$string['alternativethemeslidecolors'] = 'Альтернативні кольори слайду';
$string['alternativethemeslidecolorsdesc'] = 'Визначає альтернативні кольори слайду, які користувач може вибрати.';
$string['alternativethemestripebackgroundcolour'] = 'Альтернативний колір фону для рядків {$a}';
$string['alternativethemestripebackgroundcolourdesc'] = 'Встановіть альтернативний колір фону для рядків в таблицях {$a}';
$string['alternativethemestripetextcolour'] = 'Альтернативний колір тексту для рядків {$a}';
$string['alternativethemestripetextcolourdesc'] = 'Встановіть альтернативний колір тексту для рядків в таблицях {$a}';
$string['alternativethemetextcolor'] = 'Альтернативний колір тексту {$a}';
$string['alternativethemetextcolordesc'] = 'Встановіть альтернативний колір для тексту в схемі {$a}.';
$string['alternativethemeurlcolor'] = 'Альтернативний колір посилання  {$a}';
$string['alternativethemeurlcolordesc'] = 'Встановіть альтернативний колір для  посилання в схемі {$a}.';
$string['alwaysdisplay'] = 'Завжди показувати';
$string['android'] = 'Android (Google Play)';
$string['androiddesc'] = 'Вкажіть URL до вашого мобільного застосунку на Google Play Store. Якщо ви не маєте такого застосунку, то можливо згодиться посилання на офіційний Moodle Mobile app. (https://play.google.com/store/apps/details?id=com.moodle.moodlemobile)';
$string['asconfigintlower'] = '{$a->value} є менше ніж вказане мінімальне обмеження {$a->lower}';
$string['asconfigintnan'] = '{$a->value} не є числом';
$string['asconfigintupper'] = '{$a->value} є більше ніж вказане максимальне обмеження {$a->lower}';
$string['backtotop'] = 'Нагору';
$string['badgepreferences'] = 'Налаштування відзнак';
$string['beforecontent'] = 'До контенту';
$string['breadcrumbsimple'] = 'Простий';
$string['breadcrumbstyle'] = 'Ієрархічний стиль';
$string['breadcrumbstyled'] = 'Фантазійний';
$string['breadcrumbstyledesc'] = 'Тут ви можете змінити стиль ієрархічної навігації.';
$string['breadcrumbstylednocollapse'] = 'Фантазійний без згортання';
$string['breadcrumbthin'] = 'Тонкий';
$string['cachesused'] = 'Використані кеші';
$string['categoryctidesc'] = 'Увімкнений параметр дозволяє Вам встановлювати зображення для кожної категорії.';
$string['categoryctiheading'] = 'Зображення заголовків для категорій курсів';
$string['categoryctiheadingcategory'] = 'Зображення заголовків для категорій курсів: {$a->category}';
$string['categoryctiheadingcs'] = 'Налаштування зображень заголовків для категорій курсів';
$string['categoryctiheadingsub'] = 'Використовувати зображення для відображення своїх категорій в курсі';
$string['categoryctiheight'] = 'Висота зображення заголовка для категорії курсу «{$a->category}»';
$string['categoryctiheightdesc'] = 'Висота зображення для заголовка курсу в категорії «{$a->category}» від {$a->lower} до {$a->upper} пікселів.  Не додавайте «px» до висоти, вводьте тільки число.';
$string['categoryctiinfo'] = 'Налаштування категорії «{$a->category}»';
$string['categoryctiinfodesc'] = 'Налаштування зображення заголовка для категорії курсів: {$a->category}.';
$string['categoryctimage'] = 'Файл зображення заголовка для категорії курсів «{$a->category}»';
$string['categoryctimagedesc'] = 'Файл зображення для заголовка курсу в категорії «{$a->category}».';
$string['categoryctimageurl'] = 'URL зображення заголовка для категорії курсів «{$a->category}»';
$string['categoryctimageurldesc'] = 'URL зображення заголовка курсу в категорії «{$a->category}». Якщо завантажений файл, він перевизначає це налаштування.';
$string['categoryctitextbackgroundcolour'] = 'Колір фону тексту заголовка для категорії курсів «{$a->category}»';
$string['categoryctitextbackgroundcolourdesc'] = 'Колір фону тексту для заголовка курсу в категорії «{$a->category}».';
$string['categoryctitextbackgroundopacity'] = 'Непрозорість фону тексту заголовка для категорії курсів «{$a->category}»';
$string['categoryctitextbackgroundopacitydesc'] = 'Непрозорість фону тексту для заголовка курсу в категорії «{$a->category}».';
$string['categoryctitextcolour'] = 'Колір тексту заголовка для категорії курсів «{$a->category}»';
$string['categoryctitextcolourdesc'] = 'Колір тексту для заголовка курсу в категорії «{$a->category}».';
$string['categoryiconcategory'] = 'Зображення для категорії: {$a->category}.';
$string['categoryicondesc'] = 'Якщо це включено, то вам буде дозволено встановлювати власні зображення для категорій курсів.';
$string['categoryiconheading'] = 'Зображення категорій';
$string['categoryiconheadingsub'] = 'Використовуйте зображення для представлення ваших категорій';
$string['categoryiconinfo'] = 'Встановлює спеціальні зображення для категорій';
$string['categoryiconinfodesc'] = 'Вкажіть назву зображення, яку ви хочете використовувати. Список можливих <a href="http://fortawesome.github.io/Font-Awesome/cheatsheet/" target="_new">тут</a>. Просто введіть слово після "fa-".';
$string['categoryimagecategory'] = 'Картинка для категорії: {$a->category}.';
$string['categoryincoursebreadcrumbfeature'] = 'Категорії в Навігаційнійному меню';
$string['categoryincoursebreadcrumbfeaturedesc'] = 'Показувати посилання на категорії в ієрархічній навігації в курсі.';
$string['choosereadme'] = '<div class="clearfix">
<div class="well">
<h2>Essential</h2>
<p><img class="img-polaroid" src="essential/pix/screenshot.jpg" /></p>
</div>
<div class="well">
<h3>Про Essential</h3>
<p>Essential базується на темі Bootstrap, яка була створена для Moodle 2.5, за допомогою:<br>
Bas Brands, Stuart Lamour, Mark Aberdour, Paul Hibbitts, Mary Evans.</p> <h3>Розробники теми</h3>
<p>Головний автор: Julian Ridden<br>
Роботу перехопили в липні 2014:<br>
Gareth J. Barnard<br>
David Bezemer<br>
Роботу з 9 жовтня 2014 перебрали на себе:<br>
Gareth J. Barnard<br>
</p>
<h3>Підтримка</h3>
<p>Ця тема надається вам безкоштовно, та якщо ви хочете висловити свою подяку за використання цієї теми, будь ласка, підтримайте по:
<h4>PayPal</h4>
<p>Можете сконтактуватися через <a href="http://moodle.org/user/profile.php?id=442195" target="_blank">\'Moodle profile\'</a> для отримання додаткової інформації, оскільки я як приватна осіба не в змозі виставляти кнопки \'пожертвування\' / \'купити мене зараз ".</p>
<h4>Flattr</h4>
<a href="https://flattr.com/profile/gjb2048" target="_blank"> Клацніть тут для пожертви. </a> <br>
Пожертви можуть дозволити мені надати вам кращі функції за менший час.</p>
<h3>Спонсори</h3>
<p>Дякуємо за спонсорські пожертви від:</p>
<ul>
<li>Mihai Bojonca, TCM International Institute.</li>
<li>Guido Hornig, actXcellence <a href="//actxcellence.de" target="_blank">actxcellence.de</a></li>
<li>Delvon Forrester, Esparanza co uk</li>
<li>iZone</li>
<li>Anis Jradah</li>
<li>Ute Hlasek, <a href="//hlasek-it.de/moodle" target="_blank">hlasek-it.de/moodle</a></li>
</ul>
<h3>Essential для Moodle 3.3 люб\'язно проспонсорували:</h3>
<ul>
<li>ClassroomRevolution, LLC -- Moodle Partner</li>
<li>Daniel Méthot - e-learning-facile.com/formations/</li>
<li>Floyd Saner, Learning Contexts, LLC</li>
<li>Gemma Lesterhuis</li>
<li>Mihai Bojonca, TCM International Institute</li>
</ul>
<h3>Налаштування</h3>
<p>Якщо вам подобається ця тема і ви хотіли б, щоб я розширював її, переносив функціональність на іншу тему, будував нову тему з нуля або створив відгалуження, тоді я пропоную конкурентні тарифи. Будь ласка, зв\'яжіться зі мною через "http://moodle.org/user/profile.php?id=442195", щоб обговорити ваші вимоги.</p>
</div>
</div>';
$string['colordesc'] = 'Тут ви можете знайти різноманітні налаштування для зміни кольорів цієї теми.';
$string['colorheading'] = 'Колір';
$string['colorheadingsub'] = 'Встановити кольори дл явикористання в цій темі.';
$string['configtitle'] = 'Essential';
$string['contactinfo'] = 'Контактна інформація';
$string['contactinfodesc'] = 'Вкажіть свою контактну інформацію';
$string['copyright'] = 'Авторські права';
$string['copyrightdesc'] = 'Назва вашої організації';
$string['coursecategorysettingstitle'] = 'Налаштування категорії курсу';
$string['coursecontentsearch'] = 'Пошук в контексті курсу';
$string['coursecontentsearchdesc'] = 'Включає пошук по контексту курсу на "Інформаційній панелі". Працює тільки, якщо Essential не в \'$CFG->themedir\'.';
$string['coursegrades'] = 'Оцінки цього курсу';
$string['courselistteachericon'] = 'Знак для викладача у списку курсів';
$string['courselistteachericondesc'] = 'Введіть назву значка, який ви бажаєте використати, або залиште поле порожнім, щоб прибрати значок. Список доступних значків <a href="http://fortawesome.github.io/Font-Awesome/cheatsheet/" target="_new">тут</a>.  Просто введіть те, що знаходиться за "fa-", наприклад, "star".';
$string['coursesettingstitle'] = 'Налаштування курсу';
$string['coursetitleposition'] = 'Позиція заголовку курсу';
$string['coursetitlepositiondesc'] = 'Виберіть між "Вище" та "В межах". Де "Вище" - це над бічними блоками, згори сторінки та регіону змісту курсу, а також "В межах" - це в межах регіону змісту курсу, як це було до того, як цей параметр був введений.';
$string['ctioverride'] = 'Перевизначати зображення категорій в курсі';
$string['ctioverridedesc'] = 'Якщо ви хочете перевизначити зображення заголовка категорії курсу, коли це дозволено налаштуванням «enablecategorycti», відредагуйте опис курсу в налаштуваннях курсу та додайте зображення. Потім відредагуйте в режимі HTML, прибравши навколишні теги «p» і тег «br», потім приберіть атрибути «style», «width» и «height» і всі класи, додані текстовим редактором до тегу «img».  Після цього додайте клас «categorycti». Щоб встановити висоту (px), колір тексту заголовка, що міститься в ній, колір фону і його непрозорість, використовуйте атрибути «ctih», «ctit», «ctib» і «ctio» відповідно, наприклад:<br/><br/>&lt;img src=&quot;https://mymoodleinstall.me/pluginfile.php/493/course/section/237/myimage.jpg&quot; alt=&quot;Зображення,що замінює&quot; class=&quot;categorycti&quot; ctih=&quot;250&quot; ctit=&quot;#afafaf&quot; ctib=&quot;#222222&quot; ctio=&quot;0.5&quot;&gt;<br/><br/>Це зображення не буде відображатись в самому описі, коли ви будете переглядати список курсів.';
$string['ctioverrideheight'] = 'Типова перевизначена висота зображення для заголовка курсу.';
$string['ctioverrideheightdesc'] = 'Типова перевизначена висота зображення для заголовка курсу в межах від {$a->ower} до {$a->upper} пікселів.  Не додавайте «px» до висоти, вводьте тільки число.';
$string['ctioverridetextbackgroundcolour'] = 'Типовий перевизначений колір фону тексту для заголовка курсу';
$string['ctioverridetextbackgroundcolourdesc'] = 'Типовий перевизначений колір фону тексту для заголовка курсу.';
$string['ctioverridetextbackgroundopacity'] = 'Типова перевизначена непрозорість фону тексту для заголовка курсу.';
$string['ctioverridetextbackgroundopacitydesc'] = 'Типова перевизначена непрозорість фону тексту для заголовка курсу.';
$string['ctioverridetextcolour'] = 'Типовий перевизначений колір тексту для заголовка курсу';
$string['ctioverridetextcolourdesc'] = 'Типовий перевизначений колір тексту для заголовка курсу.';
$string['customcss'] = 'Користувацький CSS';
$string['customcssdesc'] = 'Будь-які додані тут првила CSS будуть враховуватися на всіх сторінках сайту. що полегшує налаштування цієї теми.';
$string['customscrollbars'] = 'Спеціальна полоса прокрутки';
$string['customscrollbarsdesc'] = 'Використовує спеціальну полосу прокрутки. Це замінить стандартну полосу прокрутки браузера.';
$string['dbqueries'] = 'Читання/запис БД';
$string['dbtime'] = 'Час запитів БД';
$string['defaultcategoryicon'] = 'Типові зображення для категорій';
$string['defaultcategoryicondesc'] = 'Вкажіть зображення, яке буде використовуватися для категорій як типове';
$string['defaultcategoryimage'] = 'Типове зображення категорії';
$string['defaultcategoryimagedesc'] = 'Встановлює типове зображення для категорії. Буде замінено картинкою при визначенні.';
$string['defaultcolors'] = 'Типові кольори';
$string['displayafterlogin'] = 'Показувати лише після входу';
$string['displaybeforelogin'] = 'Показувати лише перед входом';
$string['displayeditingmenu'] = 'Показати кнопку редагування';
$string['displayeditingmenudesc'] = 'Показує кнопку з тією ж функціональністю як і типова кнопка редагування торінки.';
$string['displayhiddenmycourses'] = 'Показати приховані курси';
$string['displayhiddenmycoursesdesc'] = 'Показує приховані курси в спеціальному меню для користувачів, які мають право бачити приховані курси.';
$string['displaymycourses'] = 'Показувати свої курси';
$string['displaymycoursesdesc'] = 'Показує в Додатковому Меню курси, на яких користувачі зареєстровані';
$string['dontdisplay'] = 'Не показувати';
$string['dropdownmenumaxheight'] = 'Максимальна висота випадаючого меню';
$string['dropdownmenumaxheightdesc'] = 'Максимальна висота випадаючого меню при включеній прокрутці. В межах від {$a->lower} до {$a->upper} пікселів.';
$string['dropdownmenuscroll'] = 'Прокрутка у випадаючому меню';
$string['dropdownmenuscrolldesc'] = 'Визначає наявність прокрутки у випадаючому меню при обмеженні його висоти.';
$string['editingmenu'] = 'Перемикач редагування сторінки';
$string['editingmenudesc'] = 'Показує кнопку перемикання сторінки вв режим редагування, якщо користувачу дозволено редагувати сторінку. Це така ж функціональність як і у звичайної кнопки редагування сторінки.';
$string['enablealert'] = 'Включити повідомлення';
$string['enablealertdesc'] = 'Включити чи виключити повідомлення';
$string['enablealternativethemecolors'] = 'Включити альтернативну кольорову схему {$a}';
$string['enablealternativethemecolorsdesc'] = 'Якщо включено, то користувач може вибрати альтернативну кольорову схему {$a}.';
$string['enablecategorycti'] = 'Увімкнути відображення заголовків категорій курсів';
$string['enablecategoryctics'] = 'Увімкнути сторінки налаштування категорій для зображень заголовків категорій курсів.';
$string['enablecategorycticsdesc'] = 'При включеному параметрі кожна категорія верхнього рівня отримає свою власну сторінку налаштування.';
$string['enablecategoryctidesc'] = 'При включеному параметрі Ви зможете вибрати зображення заголовків для категорій курсів після натискання на кнопку «Зберегти зміни».';
$string['enablecategoryicon'] = 'Включити картинки категорій';
$string['enablecategoryicondesc'] = 'Якщо включено, то ви зможете вибрати картинки для категорій після натискання "Зберегти зміни".';
$string['enablecustomcategoryicon'] = 'Включити спеціальні картинки категорій';
$string['enablecustomcategoryicondesc'] = 'Якщо включено, то нижче цього розділу ви знайдете ви побачите всі категорії з параметром нлаштування поряд з назвою. Натисніть "Зберегти зміни" після включення або виключення цього параметра.';
$string['extperfinfoheading'] = 'Розширена інформація продуктивності';
$string['facebook'] = 'Facebook';
$string['facebookdesc'] = 'Введіть адресу своєї сторінки у Facebook (наприклад, https://www.facebook.com/mycollege)';
$string['facebookurl'] = 'Facebook URL';
$string['favicon'] = 'Спеціальний значок сайту (favicon)';
$string['favicondesc'] = 'Завантажте власний значок для сайту. Це повинен бути файл типу .ico.';
$string['featuredesc'] = 'Тут ви знайдете різні налаштування для зміни функціональності цієї теми.';
$string['featureheading'] = 'Функціональність';
$string['featureheadingsub'] = 'Встановіть функціональність цієї теми';
$string['findcoursecontent'] = 'Контент курсу:';
$string['fitvids'] = 'Використовувати FitVids';
$string['fitvidsdesc'] = 'Включіть FitVids (fitvidsjs.com). щоб вбудоване відео підлаштовувалося під ширину вікна браузера, стало податливим (responsive). Якщо FitVids включено і ви бажаєте, щоб він не використовувався для конкретного відео. додайте \'class="fitvidsignore"\' до теги \'iframe\' в HTML-режимі редактора. Наприклад: \'iframe class="fitvidsignore" width="420" height="315" src="//www.youtube.com/embed/enmEmym85xc" frameborder="0" allowfullscreen=""></iframe\'.';
$string['fixedwidthnarrow'] = 'Фіксована ширина - Вузька';
$string['fixedwidthnormal'] = 'Фіксована ширина - Нормально';
$string['fixedwidthwide'] = 'Фіксована ширина - Широка';
$string['flatnavigation'] = 'Увімкнути пласку навігаційну панель.';
$string['flatnavigationdesc'] = 'Якщо включено, пласка Навігаційна панель буде використана замість блоків навігації та налаштувань.';
$string['flickr'] = 'Flickr';
$string['flickrdesc'] = 'Вкажіть адресу своєї сторінки у Flickr (наприклад, http://www.flickr.com/photos/mycollege)';
$string['flickrurl'] = 'Flickr URL';
$string['floatingsubmitbuttons'] = 'Плаваючі кнопки відправки';
$string['floatingsubmitbuttonsdesc'] = 'Є "плаваючі" зони, які містить кнопки, які використовуються при відправці форми. Це допомагає зменшити прокручування на деяких сторінках. Не використовується при зарахуванні на курс або на форумі.';
$string['fontcharacterset'] = 'Додатковий набір символів для шрифтів Google';
$string['fontcharactersetcyrillic'] = 'Кирилиця (Cyrillic)';
$string['fontcharactersetcyrillicext'] = 'Розширена кирилиця (Cyrillic Extended)';
$string['fontcharactersetdesc'] = 'Виберіть додаткові набори символів для різних мов. Використання кількох наборів символів може пригальмувати завантаження веб-сторінки, тому вибирайте лише ті набори символів, які дійсно необхідні сторінці.';
$string['fontcharactersetgreek'] = 'Грецький (Greek)';
$string['fontcharactersetgreekext'] = 'Грецький розширений (Greek Extended)';
$string['fontcharactersetlatinext'] = 'Латиниця розширена (Latin Extended)';
$string['fontcharactersetvietnamese'] = 'В’єтнамський (Vietnamese)';
$string['fontfileeotbody'] = 'Файл EOT-шрифта для основного тексту';
$string['fontfileeotheading'] = 'Файл EOT-шрифта для заголовків';
$string['fontfileotfbody'] = 'Файл OTF-шрифта для основного тексту';
$string['fontfileotfheading'] = 'Файл OTF-шрифта для заголовків';
$string['fontfiles'] = 'Файли шрифтів';
$string['fontfilesdesc'] = 'Завантажте сюди свої файли шрифтів (підтримуються лише файли формату ttf)';
$string['fontfilesvgbody'] = 'Файл SVG-шрифта для основного тексту';
$string['fontfilesvgheading'] = 'Файл SVG-шрифта для заголовків';
$string['fontfilettfbody'] = 'Файл TTF-шрифта для основного тексту';
$string['fontfilettfheading'] = 'Файл TTF-шрифта для заголовків';
$string['fontfilewoffbody'] = 'Файл WOFF-шрифта для основного тексту';
$string['fontfilewoffheading'] = 'Файл WOFF-шрифта для заголовків';
$string['fontfilewofftwobody'] = 'Файл WOFF2-шрифта для основного тексту';
$string['fontfilewofftwoheading'] = 'Файл WOFF2-шрифта для заголовків';
$string['fontheadingdesc'] = 'Виберіть та вкажіть шрифти, які ви бажаєте використовувати в своєму середовищі Moodle.';
$string['fontheadingsub'] = 'Налаштування шрифтів';
$string['fontnamebody'] = 'Шрифт тексту';
$string['fontnamebodydesc'] = 'Вкажіть точну назву шрифта, який використовуватиметься для решти тексту.';
$string['fontnameheading'] = 'Шрифт заголовку';
$string['fontnameheadingdesc'] = 'Вкажіть точну назву шрифта, який використовуватиметься для всіх заголовків.';
$string['fontselect'] = 'Вибір шрифта';
$string['fontselectdesc'] = 'Виберіть шрифт зі списку доступних. Натисніть "Зберегти", щоб побачити налаштування для вибраного вами варіанту.';
$string['fontsettings'] = 'Шрифт';
$string['fonttypecustom'] = 'Спеціальний шрифт';
$string['fonttypegoogle'] = 'Веб-шрифти Google';
$string['fonttypeuser'] = 'Шрифти користувача';
$string['footerblockbackgroundcolour'] = 'Колір тла для підвалин сайту';
$string['footerblockbackgroundcolourdesc'] = 'Встановлює колір тла для блоку підвалин сайту.';
$string['footerblockhovercolour'] = 'Колір гіперпосилання при наведенні для підвалин сайту';
$string['footerblockhovercolourdesc'] = 'Встановлює колір тексту гіперпосилання при наведенні курсору для блоку підвалин сайту.';
$string['footerblocktextcolour'] = 'Колір тексту для підвалин сайту';
$string['footerblocktextcolourdesc'] = 'Встановлює колір тексту для блоку підвалин сайту.';
$string['footerblockurlcolour'] = 'Колір гіперпосилання для підвалин сайту';
$string['footerblockurlcolourdesc'] = 'Встановлює колір тексту гіперпосилання для блоку підвалин сайту.';
$string['footercolor'] = 'Колір тала підвалин';
$string['footercolordesc'] = 'Задайте колір тала підвалин';
$string['footercolors'] = 'Кольори підвалин';
$string['footercolorsdesc'] = 'Змініть кольори підвалин сторінок';
$string['footerheading'] = 'Підвалини';
$string['footerheadingcolor'] = 'Колір заголовку підвалин';
$string['footerheadingcolordesc'] = 'Задайте колір заголовків для блоків у підвалинах';
$string['footerhovercolor'] = 'Колір посилання при наведенні у підвалинах';
$string['footerhovercolordesc'] = 'Задайте колір посилання при наведенні у підвалинах.';
$string['footersepcolor'] = 'Колір роздільника у підвалинах';
$string['footersepcolordesc'] = 'Роздільники та лінії використовуються для розподілу контенту. Можете тут задати їх колір.';
$string['footertextcolor'] = 'Колір тексту в підвалинах';
$string['footertextcolordesc'] = 'Задайте колір для тексту в підвалинах сторінок.';
$string['footerurlcolor'] = 'Колір посилання у підвалинах';
$string['footerurlcolordesc'] = 'Встановіть колір для тексту посилань у підвалинах сторінок.';
$string['footnote'] = 'Зноска';
$string['footnotedesc'] = 'Все, що ви додасте в цьому полі буде показуватися в підвалинах кожної сторінки вашого сайту.';
$string['fppagetopblocks'] = 'Включити додатковий  регіон для блоків "Верх сторінки"';
$string['fppagetopblocksdesc'] = 'Якщо цей параметр увімкнено, він відображатиме додаткове розташування блоків біля бічних блоків та над областью вмісту. Примітка: кількість блоків на рядок залежить від параметра "fppagetopblocksperrow".';
$string['fppagetopblocksperrow'] = 'Кількість блоків у рядку';
$string['fppagetopblocksperrowdesc'] = 'Встановлює, скільки блоків можна розташувати у рядку "Верх сторінки" на головній сторінці. Значення може бути від {$a->lower} до {$a->upper}.';
$string['frontcontent'] = 'Включити область контенту на головній сторінці';
$string['frontcontentarea'] = 'Містиме області контенту головної сторінки';
$string['frontcontentareadesc'] = 'Все, що ви введете у це поле, буде відображатися на всю ширину сторінки між слайд-шою та рекламними блоками.';
$string['frontcontentdesc'] = 'Якщо цей параметр включено, то користувацька область контенту буде додана між слайд-шою та рекламними блоками.';
$string['frontcontentheading'] = 'Область контенту головної сторінки';
$string['frontpageblocks'] = 'Вирівнювання блоків головної сторінки';
$string['frontpageblocksdesc'] = 'Тут можна визначити, як будуть вирівнюватися стандартні блоки Moodle на головній сторінці: ліворуч чи праворуч.';
$string['frontpageblocksheading'] = 'Блоки головної сторінки';
$string['frontpageheading'] = 'Головна сторінка';
$string['frontpageheadingdesc'] = 'Налаштуйте, які додаткові елементи Ви хочете показувати на головній сторінці.';
$string['frontpagehomeblocksperrow'] = 'Блоків на рядок';
$string['frontpagehomeblocksperrowdesc'] = 'Встановлює, скільки блоків можна розташувати по центру головної сторінки. Значення може бути від {$a->lower} до {$a->upper}.';
$string['frontpagemiddleblocks'] = 'Включити додаткові блоки по центру головної сторінки';
$string['frontpagemiddleblocksdesc'] = 'Якщо цей параметр включено, то три додаткових блоки будуть показуватися відразу під рекламними блоками.';
$string['frontpagesettingstitle'] = 'Налаштування головної сторінки';
$string['fullname'] = 'Повна назва сайту';
$string['fullnamesummary'] = 'Повна назва сайту та опис';
$string['generalheadingdesc'] = 'Налаштуйте тут глобальні параметри для теми. Тут ви знайдете налаштування для макета та візуального представлення.';
$string['generalheadingsub'] = 'Загальні налаштування';
$string['genericsettings'] = 'Загальне';
$string['googleplus'] = 'Google+';
$string['googleplusdesc'] = 'Введіть адресу свого профіля на Google+. (Наприклад, https://plus.google.com/+mycollege)';
$string['googleplusurl'] = 'Google+ URL';
$string['gotobottom'] = 'Перейти в кінець сторінки';
$string['haveheaderblock'] = 'Область блоків заголовку';
$string['haveheaderblockdesc'] = 'Це регіон головного блоку відразу під навігаційним меню.';
$string['headerbackground'] = 'Картинка тла заголовку';
$string['headerbackgrounddesc'] = 'Завантажте вашу власну картинку тла.';
$string['headerbackgroundstyle'] = 'Стиль тла заголовку';
$string['headerbackgroundstyledesc'] = 'Виберіть стиль для тла заголовку.';
$string['headerblocksperrow'] = 'Блоків на рядок';
$string['headerblocksperrowdesc'] = 'Встановлює, скільки блоків можна розташувати в області Заголовку. Значення може бути від {$a->lower} до {$a->upper}.';
$string['headerheading'] = 'Заголовки';
$string['headertextcolor'] = 'Колір тексту заголовку';
$string['headertextcolordesc'] = 'Вкажіть колір тексту заголовку.';
$string['headertitle'] = 'Назви заголовків';
$string['headertitledesc'] = 'Налаштуйте тут текст для виводу у заголовку сайту. Зауважте: Текстова назва у заголовку буде використовуватися лише при відсутності картинки з логотипом.';
$string['helplink'] = 'Посилання допомоги';
$string['helplinkdesc'] = 'Якщо ви вибрали "URL-адресу", вкажіть вище повну URL-адресу свого сайту допомоги (повинен містити http:// або https://). Якщо ви вибрали "E-mail адресу", то вкажіть свою адресу ел.пошти.';
$string['helplinktype'] = 'Включити в меню посилання на допомогу';
$string['helplinktypedesc'] = 'Виберіть, чи хочете ви включити в меню користувача можливість отримання допомоги. Ви можете задати URL-адресу, яка буде відкрита в новому вікні, або вказати адресу електронної пошти.';
$string['hidedefaulteditingbutton'] = 'Приховати стандартну кнопку редагування сторінки';
$string['hidedefaulteditingbuttondesc'] = 'Приховує стандартну кнопку редагування сторінки на всіх сторінках. Це налаштування дає ефект тільки, якщо включено "Показувати кнопку редагування".';
$string['hideonphone'] = 'Приховати слайд-шою на мобільних';
$string['hideonphonedesc'] = 'Виберіть, якщо хочете відключити слайд-шою на мобільних.';
$string['hideontablet'] = 'Приховати слайд-шою на планшетах';
$string['hideontabletdesc'] = 'Виберіть, якщо хочете відключити слайд-шою на планшетах.';
$string['icon'] = 'значок';
$string['image'] = 'зображення';
$string['included'] = 'Включені файли';
$string['instagram'] = 'Instagram';
$string['instagramdesc'] = 'Вкажіть адресу своєї сторінки в Instagram. (наприклад, http://instagram.com/mycollege)';
$string['instagramurl'] = 'Instagram URL';
$string['ios'] = 'iPhone/iPad (App Store)';
$string['iosdesc'] = 'Вкажіть адресу свого мобільного застосунку в магазині App Store. Якщо ви не маєте свого застосунку, ви можете ввести в це поле посилання на офіційний мобільний застосунок (https://itunes.apple.com/en/app/moodle-mobile/id633359593).';
$string['iosicon'] = 'Піктограмки для домашньої сторінки для iOS';
$string['iosicondesc'] = 'Тема задає типовий значок для домашніх екранів iOS та android. При потребі ви можете завантажити власні значки.';
$string['iosurl'] = 'iPhone/iPad (App Store) URL';
$string['ipadicon'] = 'Значок iPad (не Retina)';
$string['ipadicondesc'] = 'Значок повинен бути у вигляді PNG-файлу розміром 72px на 72px.';
$string['ipadretinaicon'] = 'Значок для iPad (Retina)';
$string['ipadretinaicondesc'] = 'Значок повинен бути у вигляді PNG-файлу розміром 144px на 144px.';
$string['iphoneicon'] = 'Значок для iPhone/iPod Touch (не Retina)';
$string['iphoneicondesc'] = 'Значок повинен бути у вигляді PNG-файлу розміром 57px на 57px.';
$string['iphoneretinaicon'] = 'Значок для iPhone/iPod Touch (Retina)';
$string['iphoneretinaicondesc'] = 'Значок повинен бути у вигляді PNG-файлу розміром 144px на 144px.';
$string['layout'] = 'Використовувати стандартний вигляд курсу';
$string['layoutdesc'] = 'Ця тема створена для розміщення обох колонок блоків з одного боку. Якщо ви більш полюбляєте стандартну розкладку Moodle, то можете включити цей параметр та повернутися до звичного старого виду в три колонки.';
$string['left'] = 'Ліворуч';
$string['linkedin'] = 'LinkedIn';
$string['linkedindesc'] = 'Вкажіть адресу свого профіля в LinkedIn. (наприклад, https://www.linkedin.com/company/mycollege)';
$string['linkedinurl'] = 'LinkedIn URL';
$string['loadtime'] = 'Час завантаження';
$string['loggedinas'] = 'зайшов як';
$string['loggedinfrom'] = 'Зайшов з';
$string['loginbackground'] = 'Картинка тла сторінки входу';
$string['loginbackgrounddesc'] = 'Завантажте свою власну картинку тла для сторінки входу. Виберіть стиль зображення нижче.';
$string['loginbackgroundopacity'] = 'Прозорість блоку входу на сторінці входу при встановленому забраженні на тлі';
$string['loginbackgroundopacitydesc'] = 'Прозорість блоку входу на сторінці входу при встановленому забраженні на тлі';
$string['loginbackgroundstyle'] = 'Стиль тла входу';
$string['loginbackgroundstyledesc'] = 'Вкажіть стиль для завантаженого файлу.';
$string['logo'] = 'Логотип';
$string['logodesc'] = 'Завантажте свій логотип, якщо ви хочете додати його в заголовок сайту. <br> Зображення повинно бути висотою 65px та будь-якої підходящої ширини. <br>При цьому завантажений логотип замінить стандартний значок та назву сайту.';
$string['logodesktopwidth'] = 'Ширина логотипу для декстопного ПК';
$string['logodimerror'] = 'Неправильно.  Будь ласка, вкажіть «px» чи «em» одразу після значення і не вказуйте нічого до цього значення.';
$string['logomobilewidth'] = 'Ширина логотипу для мобільного пристрою';
$string['marketing1'] = 'Перший рекламний блок';
$string['marketing2'] = 'Другий рекламний блок';
$string['marketing3'] = 'Третій рекламний блок';
$string['marketingbuttontext'] = 'Текст посилання';
$string['marketingbuttontextdesc'] = 'Текст на кнопці';
$string['marketingbuttonurl'] = 'URL-адреса посилання';
$string['marketingbuttonurldesc'] = 'URL-адреса, на яку перейде користувач, натиснувши кнопку рекламного блоку.';
$string['marketingcontent'] = 'Контекст';
$string['marketingcontentdesc'] = 'Контент, що буде показуватися у вікні рекламного блоку. Воно повинно бути коротким та привабливим.';
$string['marketingdesc'] = 'Ця тема дає можливість включити три "рекламних" або "маркетингових" блока, розташованих під слайд-шоу. Це дозволить вам легко подавати основну інформацію для користувачів та дати їм прямі посиланняна потрібний контент.';
$string['marketingheading'] = 'Рекламні блоки';
$string['marketingheadingsub'] = 'Три блоки на головній сторінці для додавання інформації та посилань';
$string['marketingheight'] = 'Висота зображення в рекламних блоках';
$string['marketingheightdesc'] = 'Якщо ви хочете показувати зображення в рекламних блоках, то тут можна вказати їх висоту.';
$string['marketingicon'] = 'Значок';
$string['marketingicondesc'] = 'Назва значка, який вихочете використовувати. Список значків <a href="http://fortawesome.github.io/Font-Awesome/cheatsheet/" target="_new">тут</a>. Просто вкажіть те, що після "fa-", нарпиклад, "star".';
$string['marketingimage'] = 'Картинка';
$string['marketingimagedesc'] = 'Дає можливість показувати зображення над текстом в рекламному блоці';
$string['marketingimageheight'] = 'Висота картинок в рекламних блоках (px)';
$string['marketingimageheightdesc'] = 'Якщо ви хочете показувати картинки в рекламних блоках, ви можете визначити їх висоту в px тут.';
$string['marketinginfodesc'] = 'Введіть налаштування свого рекламного блоку.';
$string['marketingtitle'] = 'Назва';
$string['marketingtitledesc'] = 'Введіть назву цього рекламного блоку';
$string['marketingurltarget'] = 'Де відкривати';
$string['marketingurltargetdesc'] = 'Виберіть, як посилання буде відкриватися';
$string['marketingurltargetnew'] = 'Нова сторінка';
$string['marketingurltargetparent'] = 'Батьківський фрейм';
$string['marketingurltargetself'] = 'Поточна сторінка';
$string['memused'] = 'Використана пам’ять';
$string['messagesmi'] = 'Повідомлення';
$string['mobileappsdesc'] = 'Ви маєте веб-застосунок в магазинах App Store або Google Play Store? Вкажіть тут посилання на ці застосунки, щоб користувачі змогли отримати до них доступ онлайн.';
$string['mobileappsheading'] = 'Мобільні застосунки';
$string['mobileappsheadingsub'] = 'Посилання на ваш застосунок для студентів, які використовують мобільні пристрої';
$string['modulesettingstitle'] = 'Налаштування модуля';
$string['myclasses'] = 'Мої класи';
$string['mycourses'] = 'Мої курси';
$string['mycoursescatsubmenu'] = 'Підменю категорії та курсу';
$string['mycoursesinfo'] = 'Меню курсів користувача';
$string['mycoursesinfodesc'] = 'Показувати користувачу динамічний список курсів, на яких він зареєстрований.';
$string['mycoursesmax'] = 'Максимально курсів';
$string['mycoursesmaxdesc'] = 'Укажіть, скільки курсів слід показати між {$a->lower} та {$a->upper}, де "{$a->lower}" показує все.';
$string['mycoursesorder'] = 'Порядок курсів';
$string['mycoursesorderdesc'] = 'Вкажіть, як повинні бути відсортовані курси. Порядок сортування курсів може бути вказаний в налаштуванні навігації «navsortmycoursessort».';
$string['mycoursesorderenrolbackcolour'] = 'Колір тла для не відвіданих користувачем курсів, в які він записаний';
$string['mycoursesorderenrolbackcolourdesc'] = 'Колір тла для не відвіданих користувачем курсів, в які він записаний. Параметр  «mycoursesorder» при цьому встановлюється в «Останні відвідані...».';
$string['mycoursesorderid'] = 'Код курсу';
$string['mycoursesorderidasc'] = 'За зростанням';
$string['mycoursesorderiddes'] = 'За спаданням';
$string['mycoursesorderidorder'] = 'Порядок Кодів курсів';
$string['mycoursesorderidorderdesc'] = 'Порядок кодів курсів, коли «Код курсу» вказаний в якості параметра «Порядок сортування курсів».';
$string['mycoursesorderlast'] = 'Час останнього входу чи час запису на курс, якщо вхід не був виконаний.';
$string['mycoursesordersort'] = 'Порядок сортування курсів';
$string['mycoursetitle'] = 'Термінологія';
$string['mycoursetitledesc'] = 'Змініть термінологію для посилання "Мої курси" у випадаючому меню';
$string['mygrades'] = 'Всі оцінки';
$string['mylatestclasses'] = 'Мої останні уроки';
$string['mylatestcourses'] = 'Мої останні курси';
$string['mylatestmodules'] = 'Мої останні модулі';
$string['mylatestunits'] = 'Мої останні завдання';
$string['mymodules'] = 'Мої модулі';
$string['myunits'] = 'Мої завдання';
$string['navbarabove'] = 'Навігаційна панель над верхнім колонтитулом';
$string['navbarbelow'] = 'Навігаційна панель під верхнім колонтитулом';
$string['navbartitle'] = 'Заголовок навігаційної панелі';
$string['navbartitledesc'] = 'Налаштуйте тут заголовок для виводу в навігаційну панель.';
$string['nextsection'] = 'Наступна секція';
$string['nobreadcrumb'] = 'Приховати';
$string['noenrolments'] = 'Ви не зараховані на жоден курс';
$string['noslidetitle'] = 'Немає назви для слайду {$a->slide}';
$string['notitle'] = 'Без заголовку';
$string['numberofcoursesandsubcatcourses'] = 'Кількість курсів - підкатегорія курсів';
$string['numberofslides'] = 'Число слайдів';
$string['numberofslides_desc'] = 'Число слайдів у слайд шоу.';
$string['oldnavbar'] = 'Використовувати старе розташування  навігаційної панелі';
$string['oldnavbardesc'] = 'Включіть цей параметр для використання старого розташування навігаційної панелі.';
$string['pagebackground'] = 'Зображення тла для сторінки';
$string['pagebackgrounddesc'] = 'Завантажте своє зображеня тла для сторінки. Нижче виберіть стиль зображення.';
$string['pagebackgroundstyle'] = 'Стиль тла сторінки';
$string['pagebackgroundstyledesc'] = 'Виберіть стиль для завантаженого зображення.';
$string['pagebottomblocksperrow'] = 'Блоків на рядок';
$string['pagebottomblocksperrowdesc'] = 'Встановлює кількість блоків на рядок між {$a->lower} та {$a->upper} для сторінок з "Блоками низу сторінки". Наразі це сторінки: Керування, Керування курсом, редагування Оцінювання та Тестів.';
$string['pagewidth'] = 'Вказати ширину сторінки';
$string['pagewidthdesc'] = 'Виберіть зі списку доступні варіанти ширини свого сайту';
$string['paypal_click'] = 'Профіль у Moodle';
$string['paypal_desc'] = '{$a->url}\' для отримання деталей, оскільки я як приватна особа і за правилами PayPal не можу розміщувати кнопки \'пожертви\'/\'купи мене зараз\', або';
$string['peakmem'] = 'Пікова пам’ять';
$string['perf_max'] = 'Детально';
$string['perf_min'] = 'Мінімально';
$string['perfinfo'] = 'Режим інформації продуктивності';
$string['perfinfodesc'] = 'Багатьом сайтам не потрібна детальна інформація продуктивності. Особливо, коли вони переклядаються користувачами. При включеному параметрі показується скорочена мінімальна форма з базовою інформацією про завантаження сторінки.';
$string['perfinfoheading'] = 'Інформація продуктивності';
$string['pinterest'] = 'Pinterest';
$string['pinterestdesc'] = 'Введіть адресу своєї сторінки в Pinterest. (Наприкалад, http://pinterest.com/mycollege/mypinboard)';
$string['pinteresturl'] = 'Pinterest URL';
$string['pluginname'] = 'Essential';
$string['previoussection'] = 'Попередня секція';
$string['profilebarcustomtitle'] = 'Заголовок користувацького блоку профіля';
$string['profilebarcustomtitledesc'] = 'Задайте назву для користувацького блоку профіля.';
$string['properties'] = 'Параметри';
$string['propertiesdesc'] = 'Список параметрів.';
$string['propertiesexport'] = 'Експортувати параметри як рядок JSON';
$string['propertiesproperty'] = 'Параметр';
$string['propertiesreturn'] = 'Повернутися';
$string['propertiessub'] = 'Параметри';
$string['propertiesvalue'] = 'Значення';
$string['putpropertiesadded'] = 'Додано:';
$string['putpropertieschanged'] = 'Змінено:';
$string['putpropertiesdesc'] = 'Вставте рядок JSON та натисніть кнопку "Зберегти зміни". Увага! Не перевіряє значення параметрів і не виконує «Очищення всього кешу».';
$string['putpropertiesfrom'] = 'з';
$string['putpropertiesignorecti'] = 'Ігнорувати всі налаштування картинок заголовків курсів.';
$string['putpropertiesignored'] = 'Прогноровано:';
$string['putpropertiesname'] = 'Встановіть властивості - Експериментально!';
$string['putpropertiesreportfiles'] = 'Не забудьте завантажити наступні файли до їх налаштувань:';
$string['putpropertiessettingsreport'] = 'Параметри звіту:';
$string['putpropertiesunchanged'] = 'Без змін:';
$string['putpropertyproperties'] = 'Параметри';
$string['putpropertyreport'] = 'Звіт:';
$string['putpropertyversion'] = 'версія:';
$string['readme_click'] = 'клацніть для читання README.txt';
$string['readme_desc'] = 'Будь ласка, {$a->url}, що містить детальну інформацію про тему Essential.';
$string['readme_title'] = 'Інформація про Essential';
$string['readmore'] = 'Детальніше';
$string['region-footer-left'] = 'Підвалини (зліва)';
$string['region-footer-middle'] = 'Підвалини (посередині)';
$string['region-footer-right'] = 'Підвалини (справа)';
$string['region-header'] = 'Заголовок';
$string['region-hidden-dock'] = 'Приховати від користувачів';
$string['region-home'] = 'Домівка';
$string['region-page-top'] = 'Верх сторінки';
$string['region-side-post'] = 'Праворуч';
$string['region-side-pre'] = 'Зліва';
$string['returntosection'] = 'Повернутися до: {$a->section}';
$string['returntosectionfeature'] = 'Повернутися до секції';
$string['returntosectionfeaturedesc'] = 'Дозволяє швидко повернутися до секції з середини модулів курсу.';
$string['returntosectiontextlimitfeature'] = 'Обмеження на кількість літер';
$string['returntosectiontextlimitfeaturedesc'] = 'Встановлює обмеження на кількість літер в написі на кнопці повернення до секції в межах від {$a->lower} і до {$a->upper} символів.';
$string['right'] = 'Праворуч';
$string['serverload'] = 'Завантаження сервера';
$string['sessionsize'] = 'Розмір сесії';
$string['shortname'] = 'Коротка назва сайту';
$string['shortnamesummary'] = 'Коротка назва та опис сайту';
$string['siteicon'] = 'Значок сайту';
$string['siteicondesc'] = 'Ваш сайт не має логотипу? Введіть назву значка, який ви бажаєте використовувати. Список значків <a href="http://fortawesome.github.io/Font-Awesome/cheatsheet/" target="_new">тут</a>.  Просто введіть те, що після "fa-".';
$string['skype'] = 'Обліковий запис Skype';
$string['skypedesc'] = 'Введіть ім’я користувача Skype своєї організації (наприклад, my.college)';
$string['skypeuri'] = 'Skype Account URI';
$string['slidebuttoncolor'] = 'Колір кнопки слайду';
$string['slidebuttoncolordesc'] = 'Колір кнопки навігації на слайді.';
$string['slidebuttonhovercolor'] = 'Колір кнопки навігації на слайді при наведенні';
$string['slidebuttonhovercolordesc'] = 'Колір кнопки навігації на слайді при наведенні на неї курсора';
$string['slidecaption'] = 'Підпис слайду';
$string['slidecaptionbackgroundcolor'] = 'Колір тла підпису слайду';
$string['slidecaptionbackgroundcolordesc'] = 'Який повинен бути колір тла для підписів слайдів. Не застосовується для опції "Поруч".';
$string['slidecaptionbelow'] = 'Підпис слайду під зображенням';
$string['slidecaptionbelowdesc'] = 'Якщо під зображенням повинен бути підпис слайду';
$string['slidecaptionbeside'] = 'Поруч';
$string['slidecaptioncentred'] = 'Вирівнювати підпис слайду по центру';
$string['slidecaptioncentreddesc'] = 'Якщо підпис лайду повинен бути вирівняний по центру';
$string['slidecaptiondesc'] = 'Введіть текст підпису для використання на слайді';
$string['slidecaptionontop'] = 'Згори';
$string['slidecaptionoptions'] = 'Налаштування підпису слайду';
$string['slidecaptionoptionsdesc'] = 'Де повинні показуватися підписи відносно зображення.';
$string['slidecaptiontextcolor'] = 'Колір тексту підпису слайду';
$string['slidecaptiontextcolordesc'] = 'Який повинен бути колір тексту для підписів слайдів. Не застосовується для опції "Поруч".';
$string['slidecaptionunderneath'] = 'Знизу';
$string['slidecolor'] = 'Колір тексту слайду';
$string['slidecolordesc'] = 'Який колір тексту підпису слайду';
$string['slideimage'] = 'Зображення слайду';
$string['slideimagedesc'] = 'Краще використовувати зображенняз прозорістю';
$string['slideinterval'] = 'Інтервал між слайдами';
$string['slideintervaldesc'] = 'Інтервал між зміною слайдів у мілісекундах.';
$string['slideno'] = 'Слайд {$a->slide}';
$string['slidenodesc'] = 'Вкажіть налаштування для слайду {$a->slide}.';
$string['slideshowdesc'] = 'За допомогою цих налаштувань створюється динамічне слайд-шоу , яке може складатися максимум з 16 слайдів, призначених для просування важливих елементів вашого сайту. Слайд-шоу може змінювати свої розміри: висота зображення задається виходячи з розміру екрану. Рекомендується - 300px. Ширина задається як 100%, тому фактична висота буде менша, якщо ширина більше, ніж розмір екрану. На екранах меншого розміру висота динамічно зменшується без використання додаткових зображень. Використовуються розміри: ширина екрану < 767px = висота 165px, ширина між 768px та 979px = висота 225px і ширина > 980px = висота 300px. Якщо зображення для слайду не вибрано, то буде використано зображення default_slide з каталогу pix.';
$string['slideshowheading'] = 'Слайд-шоу';
$string['slideshowheadingsub'] = 'Динамічне слайд-шоу на головній сторінці';
$string['slidetitle'] = 'Заголовок слайду';
$string['slidetitledesc'] = 'Введіть заголовок для слайду';
$string['slideurl'] = 'Посилання слайду';
$string['slideurldesc'] = 'Введіть посилання, на яке вказує зображення слайду';
$string['slideurltarget'] = 'Де відкривати';
$string['slideurltargetdesc'] = 'Виберіть, як посилання повинно бути відкрите';
$string['slideurltargetnew'] = 'Нова сторінка';
$string['slideurltargetparent'] = 'Батьківський фрейм';
$string['slideurltargetself'] = 'Поточна сторінка';
$string['socialdesc'] = 'Задайте прямі посилання на основні соціальні мережі, де ви просуваєте сівй бренд. Вони будуть показуватися у верхньому колонтитулі кожної сторінки';
$string['socialheading'] = 'Соціальні мережі';
$string['socialheadingsub'] = 'Запрошуйте своїх користувачів у соціальні мережі';
$string['socialnetworks'] = 'Долучайтесь до нас';
$string['sponsor_desc'] = 'Можна підтримати проект через PayPal звернувшись до мене через ’';
$string['sponsor_desc2'] = 'підтримати подальший розвиток Essential або просто виразити вдячність.';
$string['sponsor_title'] = 'Підтримати Essential';
$string['styleguide'] = 'Керівництво стилем';
$string['themecolor'] = 'Колір теми';
$string['themecolordesc'] = 'Основнийколір теми. Це змінить колір багатьох компонентів, для створення бажаного кольору на вашому сайті Moodle';
$string['themecolors'] = 'Кольори теми';
$string['themedefaultbuttonbackgroundcolour'] = 'Типовий колір тла кнопки';
$string['themedefaultbuttonbackgroundcolourdesc'] = 'Встановлює типовий колір тла для всіх кнопок.';
$string['themedefaultbuttonbackgroundhovercolour'] = 'Типовий колір тла кнопки при наведенні';
$string['themedefaultbuttonbackgroundhovercolourdesc'] = 'Встановлює типовий колір тла для всіх кнопок при наведенні.';
$string['themedefaultbuttontextcolour'] = 'Типовий колір тексту кнопки';
$string['themedefaultbuttontextcolourdesc'] = 'Встановлює типовий колір тексту для всіх кнопок.';
$string['themedefaultbuttontexthovercolour'] = 'Типовий колір тексту кнопки при наведенні';
$string['themedefaultbuttontexthovercolourdesc'] = 'Встановлює типовий колір тексту для всіх кнопок при наведенні.';
$string['themehovercolor'] = 'Колір посилання при наведенні';
$string['themehovercolordesc'] = 'Якого кольору повинні бути елементи теми при наведенні на них курсора. Цей колір використовується для посилань, меню тощо.';
$string['themeiconcolor'] = 'Колір значка';
$string['themeiconcolordesc'] = 'Вкажіть колір для всіх значків';
$string['themenavcolor'] = 'Колір навігації';
$string['themenavcolordesc'] = 'Встановіть колір для навігації. Буде використовуватися навігаційною панеллю та стилем "Фантазійний" ієрархічної навігації.';
$string['themequizsubmitbackgroundcolour'] = 'Колір тла кнопки "Відправити все і закінчити"';
$string['themequizsubmitbackgroundcolourdesc'] = 'Встановлює колір тла кнопки "Відправити все і закінчити" в кінці тесту.';
$string['themequizsubmitbackgroundhovercolour'] = 'Колір тла кнопки "Відправити все і закінчити" при наведенні';
$string['themequizsubmitbackgroundhovercolourdesc'] = 'Встановлює колір тла кнопки "Відправити все і закінчити" в кінці тесту при наведенні на неї покажчика миші.';
$string['themequizsubmittextcolour'] = 'Колір тексту кнопки "Відправити все і закінчити"';
$string['themequizsubmittextcolourdesc'] = 'Встановлює колір тексту кнопки "Відправити все і закінчити" в кінці тесту.';
$string['themequizsubmittexthovercolour'] = 'Колір тексту кнопки "Відправити все і закінчити" принаведенні';
$string['themequizsubmittexthovercolourdesc'] = 'Встановлює колір тексту кнопки "Відправити все і закінчити" в кінці тесту при наведенні на неї покажчика миші.';
$string['themestripebackgroundcolour'] = 'Колір тла для смуг';
$string['themestripebackgroundcolourdesc'] = 'Встановіть колір тла для смуг в таблицях.';
$string['themestripetextcolour'] = 'Колір тексту для смуг';
$string['themestripetextcolourdesc'] = 'Встановіть колір тексту для смуг в таблицях.';
$string['themestripeurlcolour'] = 'Колір посилань в смугах';
$string['themestripeurlcolourdesc'] = 'Встановіть колір посилань в смугах таблиць.';
$string['themetextcolor'] = 'Колір тексту';
$string['themetextcolordesc'] = 'Вкажіть колір для тексту.';
$string['themeurlcolor'] = 'Колір посилання';
$string['themeurlcolordesc'] = 'Вкажіть колір для тексту посилання';
$string['thiscourse'] = 'Цей курс';
$string['togglemarketing'] = 'Показувати рекламні блоки';
$string['togglemarketingdesc'] = 'Виберіть, чи показувати рекламні блоки на сайті.';
$string['toggleslideshow'] = 'Показувати слайд-шоу';
$string['toggleslideshowdesc'] = 'Виберіть, чи показувати слайд-шоу на сайті.';
$string['twitter'] = 'Twitter';
$string['twitterdesc'] = 'Введіть адресу своєї стрічки у Twitter (наприклад, https://www.twitter.com/mycollege)';
$string['twitterurl'] = 'Twitter URL';
$string['userimageborderradius'] = 'Радіус рамки картинки користувача';
$string['userimageborderradiusdesc'] = 'Визначає радіус рамки (в межах від {$a->lowerі до and {$a->upper} пікселів) для картинки користувача, яка показується в заголовку деяких сторінок, які використовують налаштування \'usermenuuserimageborderradius\'.';
$string['usermenu'] = 'Меню користувача';
$string['usermenudesc'] = 'Меню для користувача.';
$string['usermenuuserimageborderradius'] = 'Радіус рамки картинки користувача в меню';
$string['usermenuuserimageborderradiusdesc'] = 'Визначає радіус рамки (в межах від {$a->lowerі до and {$a->upper} пікселів) для картинки користувача в меню користувача.';
$string['usersettingstitle'] = 'Налаштування користувача';
$string['usesiteicon'] = 'Використовувати значок сайта';
$string['usesiteicondesc'] = 'Використовувати значок сайта, якщо немає логотипа.';
$string['variablewidth'] = 'Змінна ширина';
$string['versionalerttext1'] = 'Тема не призначена для Moodle версії.';
$string['versionalerttext2'] = 'Можуть виникнути несподівані проблеми, будь ласка, отримати правильну версію теми для вашої версії Moodle.';
$string['versionalerttitle'] = 'Попередження про версію:';
$string['visibleadminonly'] = 'Блоки розміщені в області нижче, доступні лише адміністраторам';
$string['vk'] = 'VKontakte';
$string['vkdesc'] = 'Введіть адресу своєї сторінки ВКонтакте (наприклад, http://www.vk.com/mycollege) (не рекомендується)';
$string['vkurl'] = 'VKontakte URL';
$string['website'] = 'Сайт університету';
$string['websitedesc'] = 'Введіть адресу свого сайту (наприклад, http://www.univer.edu.ua)';
$string['websiteurl'] = 'URL Вебсайту';
$string['windows'] = 'Windows (для ПК)';
$string['windowsdesc'] = 'Введіть адресу свого мобільного застосунку у Windows Store. Якщо ви не маєте свого застосунку, то ви можете ввести в це поле посилання на офіційний мобільний застосунок Moodle (http://apps.microsoft.com/windows/en-us/app/9df51338-015c-41b7-8a85-db2fdfb870bc)';
$string['windowsurl'] = 'Windows Desktop URL';
$string['winphone'] = 'Windows (для мобільних)';
$string['winphonedesc'] = 'Введіть адресу свого мобільного застосунку у Google Play Store. Якщо ви не маєте свого застосунку, то ви можете ввести в це поле посилання на офіційний мобільний застосунок Moodle  (http://www.windowsphone.com/en-us/store/app/moodlemobile/d0732b88-3c6d-4127-8f24-3fca2452a4dc)';
$string['winphoneurl'] = 'Windows Mobile URL';
$string['within'] = 'Всередині';
$string['youtube'] = 'YouTube';
$string['youtubedesc'] = 'Введіть адресу свого каналу в YouTube. (наприклад, https://www.youtube.com/user/mycollege)';
$string['youtubeurl'] = 'YouTube URL';
