<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'bigbluebuttonbn', language 'sv', version '4.4'.
 *
 * @package     bigbluebuttonbn
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['acceptdpa'] = 'Jag förstår och accepterar databehandlingsavtalet';
$string['activityoverview'] = 'Du har kommande BigBlueButton-sessioner';
$string['bbbduetimeoverstartingtime'] = 'Sluttiden för den här aktiviteten måste inträffa efter starttiden.';
$string['bbbdurationwarning'] = 'Den längsta varaktigheten för den här sessioner är %duration% minuter.';
$string['bbbrecordallfromstartwarning'] = 'Den här sessionen spelas in från start.';
$string['bbbrecordwarning'] = 'Den här sessionen kan komma att spelas in.';
$string['bigbluebuttonbn'] = 'BigBlueButton';
$string['bigbluebuttonbn:addinstance'] = 'Nytt BigBlueButton-rum';
$string['bigbluebuttonbn:addinstancewithmeeting'] = 'Skapa instans av live-sessioner';
$string['bigbluebuttonbn:addinstancewithrecording'] = 'Skapa instans med inspelningsmöjligheter';
$string['bigbluebuttonbn:deleterecordings'] = 'Ta bort inspelningar';
$string['bigbluebuttonbn:importrecordings'] = 'Importera inspelningar';
$string['bigbluebuttonbn:join'] = 'Anslut till ett BigBlueButton-rum';
$string['bigbluebuttonbn:managerecordings'] = 'Hantera inspelningar';
$string['bigbluebuttonbn:protectrecordings'] = 'Skydda inspelningar';
$string['bigbluebuttonbn:publishrecordings'] = 'Publicera inspelningar';
$string['bigbluebuttonbn:unprotectrecordings'] = 'Ta bort skydd';
$string['bigbluebuttonbn:unpublishrecordings'] = 'Avpublicera inspelningar';
$string['bigbluebuttonbn:view'] = 'Visa BigBlueButton-rum';
$string['bigbluebuttonbn:viewallrecordingformats'] = 'Visa alla inspelningsformat';
$string['bigbluebuttondisablednotification'] = 'Aktivitetsmodulen BigBlueButton har inaktiverats och befintliga BigBlueButton-kursaktiviteter är för närvarande inte tillgängliga. Innan du återaktiverar denna pluginmodul, se till att du har läst och accepterat <a href="{$a}" target="_blank">databehandlingsavtalet</a> med Blindside Networks Inc.';
$string['bigbluebuttondisablednotification_subject'] = 'BBB-aktivitetsmodul inaktiverad.';
$string['cachedef_currentfetch'] = 'Data för att lista senaste inspelning';
$string['cachedef_recordings'] = 'Inspelningsmetadata';
$string['cachedef_serverinfo'] = 'Information om fjärrserver';
$string['cachedef_validatedurls'] = 'Cachade URL-kontroller';
$string['calendarstarts'] = '{$a} är schemalagt till';
$string['cannotperformaction'] = 'Kan inte utföra åtgärden {$a} för denna inspelning';
$string['completionattendance'] = 'Studenten måste närvara vid sessionen i minst:';
$string['completionattendance_desc'] = 'Studenten måste delta i mötet och vara kvar i sessionen i minst {$a} minuter';
$string['completionattendance_event_desc'] = 'Deltagaren har deltagit i mötet eller stannat kvar i sessionen i minst {$a} minuter';
$string['completionattendancegroup'] = 'Kräv närvaro';
$string['completionattendancegroup_help'] = 'Deltagande i mötet i (n) minuter krävs för slutförande.';
$string['completionengagement_desc'] = 'Studenten måste delta i aktiviteter under mötet';
$string['completionengagementchats'] = 'Chattar';
$string['completionengagementchats_desc'] = 'Deltagaren måste delta i {$a} chattar för att slutföra den.';
$string['completionengagementchats_event_desc'] = 'Har initierat {$a} chatthändelser';
$string['completionengagementemojis'] = 'Emojis';
$string['completionengagementemojis_desc'] = 'Deltagaren måste skicka {$a} emojis i omröstningar för att slutföra.';
$string['completionengagementemojis_event_desc'] = 'Har initierat {$a} emojis';
$string['completionengagementgroup'] = 'Kräv deltagande';
$string['completionengagementgroup_help'] = 'Aktivt deltagande under sessionen krävs för slutförande.';
$string['completionengagementpollvotes'] = 'Omröstningar';
$string['completionengagementpollvotes_desc'] = 'Deltagare måste rösta {$a} gånger i omröstningar för att slutföra.';
$string['completionengagementpollvotes_event_desc'] = 'Har genomfört {$a} omröstningar';
$string['completionengagementraisehand'] = 'Kräv handuppräckning';
$string['completionengagementraisehand_desc'] = 'Deltagaren måste räcka upp handen {$a} gånger för att slutföra.';
$string['completionengagementraisehand_event_desc'] = 'Har gjort {$a} handuppräckningar';
$string['completionengagementtalks'] = 'Tala';
$string['completionengagementtalks_desc'] = 'Deltagaren måste prata {$a} gånger för att slutföra';
$string['completionengagementtalks_event_desc'] = 'Har talat {$a} gånger';
$string['completionupdatestate'] = 'Uppdateringstillstånd för slutförande';
$string['completionvalidatestate'] = 'Validera slutförande';
$string['completionvalidatestatetriggered'] = 'Validering av slutförande har utlösts.';
$string['completionview'] = 'Kräv visning';
$string['completionview_desc'] = 'Deltagaren måste visa rummet för att slutföra.';
$string['completionview_event_desc'] = 'Har visat rummet.';
$string['config_default_messages'] = 'Standardmeddelanden';
$string['config_default_messages_description'] = 'Ange standardvärden för meddelanden för aktiviteter';
$string['config_disablecam_default'] = 'Inaktiverad kamera är som standard aktiverat';
$string['config_disablecam_default_description'] = 'Om markerad kommer webbkameror vara inaktiverade';
$string['config_disablecam_editable'] = 'Inaktivera kamera kan redigeras';
$string['config_disablecam_editable_description'] = 'Inaktivera kamera som standard kan redigeras när instansen läggs till eller uppdateras.';
$string['config_disablemic_default'] = 'Inaktivera mikrofon aktiverad som standard';
$string['config_disablemic_default_description'] = 'Om aktiverad kommer mikrofonerna vara inaktiverade';
$string['config_disablemic_editable'] = 'Inaktivera mikrofon kan redigeras';
$string['config_disablemic_editable_description'] = 'Inaktivera mikrofon som standard kan redigeras när instansen läggs till eller uppdateras.';
$string['config_disablenote_default'] = 'Inaktivera delade anteckningar aktiverat som standard';
$string['config_disablenote_default_description'] = 'Om aktiverat är delade anteckningar inaktiverat.';
$string['config_disablenote_editable'] = 'Inaktivera delade anteckningar kan redigeras';
$string['config_disablenote_editable_description'] = 'Inaktivera delade anteckningar som standard kan redigeras när instansen läggs till eller uppdateras.';
$string['config_disableprivatechat_default'] = 'Inaktivera privat chatt aktiverat som standard';
$string['config_disableprivatechat_default_description'] = 'Om aktiverat kommer privata chattar vara inaktiverade.';
$string['config_disableprivatechat_editable'] = 'Inaktivera privat chatt kan redigeras';
$string['config_disableprivatechat_editable_description'] = 'Inaktivera privat chatt som standard kan redigeras när instansen läggs till eller uppdateras.';
$string['config_disablepublicchat_default'] = 'Inaktivera publik chatt aktiverat som standard';
$string['config_disablepublicchat_default_description'] = 'Om aktiverat kommer publika chattar vara inaktiverade.';
$string['config_disablepublicchat_editable'] = 'Inaktivera publik chatt kan redigeras';
$string['config_disablepublicchat_editable_description'] = 'Inaktivera publik chatt som standard kan redigeras när instansen läggs till eller uppdateras.';
$string['config_dpa_note'] = 'För att uppfylla dina dataskyddsskyldigheter kan du, innan du använder en tjänsteleverantör för denna pluginmodul, behöva se till att du har läst och accepterat tjänsteleverantörens databehandlingsavtal.
För den kostnadsfria standard BigBlueButton-tjänsten som tillhandahålls av Blindside Networks Inc., läs och godkänn följande <a href="{$a}" target="_blank">databehandlingsavtal</a>.<br/>
Rådgör med dina egna sekretessrådgivare för ytterligare information.';
$string['config_experimental_features'] = 'Experimentella funktioner';
$string['config_experimental_features_description'] = 'Konfiguration för experimentella funktioner.';
$string['config_extended_capabilities'] = 'Utökade funktioner';
$string['config_extended_capabilities_description'] = 'Inställningar för utökade funktioner när BBB-servern erbjuder detta.';
$string['config_general'] = 'Allmänna inställningar';
$string['config_general_description'] = 'För att ställa in BigBlueButton kan du antingen använda din egen BigBlueButton-server och dina inloggningsuppgifter, eller skaffa inloggningsuppgifter via <a href="https://registration-portal.blindsidenetworks.com/" target="_blank">Blindside Networks Registration Portal (öppnas i ett nytt fönster)</a>.';
$string['config_guestaccess_enabled'] = 'Gäståtkomst';
$string['config_guestaccess_enabled_description'] = 'Ge användare utan konto på denna webbplats åtkomst till rummet.';
$string['config_hideuserlist_default'] = 'Dölj användarlista aktiverat som standard';
$string['config_hideuserlist_default_description'] = 'Om aktiverat kommer deltagarlistan för sessionen vara dold.';
$string['config_hideuserlist_editable'] = 'Dölj användarlista kan redigeras';
$string['config_hideuserlist_editable_description'] = 'Dölj användarlista som standard kan redigeras när instansen läggs till eller uppdateras.';
$string['config_importrecordings'] = 'Importera inspelningar';
$string['config_importrecordings_description'] = 'Dessa inställningar är funktionsspecifika.';
$string['config_importrecordings_enabled'] = 'Import av inspelningar är aktiverat';
$string['config_importrecordings_enabled_description'] = 'När detta och inspelningsfunktionen är aktiverad är det möjligt att importera inspelningar från olika kurser till en aktivitet.';
$string['config_importrecordings_from_deleted_enabled'] = 'Importera inspelningar från borttagna aktiviteter aktiverat';
$string['config_importrecordings_from_deleted_enabled_description'] = 'När detta och funktionen importera inspelning är aktiverad är det möjligt att importera inspelningar från aktiviteter som inte längre finns i kursen.';
$string['config_locksettings'] = 'Konfiguration av låsningsinställningar';
$string['config_locksettings_description'] = 'De här inställningarna aktiverar eller inaktiverar alternativ för låsningsalternativen i användargränssnittet och definierar även standardvärden för dessa alternativ.';
$string['config_meetingevents_enabled'] = 'Registrera livehändelser';
$string['config_meetingevents_enabled_description'] = 'Aktivera pluginmodulen för att acceptera och bearbeta livehändelser efter sessionens slut. (Den måste vara aktiverad för "Aktivitetsslutförande" och fungerar bara om BigBlueButton-servern kan bearbeta <code>post_events</code>-skript)';
$string['config_muteonstart'] = 'Konfiguration av "Tystat läge vid start"-funktionen';
$string['config_muteonstart_default'] = 'Tystat läge vid start aktiverat som standard';
$string['config_muteonstart_default_description'] = 'Om aktiverat är sessionen satt i tystat läge vid start.';
$string['config_muteonstart_description'] = 'De här inställningarna aktiverar eller inaktiverar alternativ i användargränssnittet och definierar även standardvärden för dessa alternativ.';
$string['config_muteonstart_editable'] = 'Tystat läge vid start kan redigeras';
$string['config_muteonstart_editable_description'] = 'Tystat läge vid start som standard kan redigeras när instansen läggs till eller uppdateras.';
$string['config_participant'] = 'Deltagarkonfiguration';
$string['config_participant_description'] = 'De här inställningarna anger standardrollen för konferensdeltagare.';
$string['config_participant_moderator_default'] = 'Moderator som standard';
$string['config_participant_moderator_default_description'] = 'Denna regel används som standard när ett nytt rum läggs till.';
$string['config_presentation_default'] = 'Standardfil för funktionen "Förhandsuppladdning av presentation"';
$string['config_presentation_default_description'] = 'Med den här inställningen kan du välja en fil som ska användas som standard i alla BBB-instanser om "Förhandsuppladdning av presentation" är aktiverat.';
$string['config_preuploadpresentation'] = 'Inställningar för funktionen <em>"Förhandsuppladdning av presentation"</em>';
$string['config_preuploadpresentation_description'] = 'Dessa inställningar aktiverar eller inaktiverar alternativ i användargränssnittet och definierar även standardvärden för dessa alternativ. Funktionen fungerar bara om Moodle-servern är tillgänglig för BigBlueButton.';
$string['config_preuploadpresentation_editable'] = 'Uppladdning i förväg av presentation redigerbar';
$string['config_preuploadpresentation_editable_description'] = 'Funktionen att kunna ladda upp presentationer i förväg går att redigera i användargränssnittet när rummet eller konferensen läggs till eller redigeras.';
$string['config_recording'] = 'Inspelning';
$string['config_recording_all_from_start_default'] = 'Spela in från start';
$string['config_recording_all_from_start_default_description'] = 'Om markerat spelas mötet in från start';
$string['config_recording_all_from_start_editable'] = 'Spela in från start kan redigeras';
$string['config_recording_all_from_start_editable_description'] = 'Om aktiverat inkluderar användargränssnittet ett alternativ för att aktivera och inaktivera "Spela in allt från start"-funktionen</em>.';
$string['config_recording_default'] = 'Inspelningsfunktion aktiverad som standard';
$string['config_recording_default_description'] = 'Om aktiverat kommer sessioner skapade i BigBlueButton erbjuda inspelningsfunktioner.';
$string['config_recording_description'] = 'Dessa inställningar är funktionsspecifika';
$string['config_recording_editable'] = 'Inspelningsfunktion kan redigeras';
$string['config_recording_editable_description'] = 'Om aktiverat kommer användargränssnittet inkludera ett alternativ för att aktivera eller inaktivera inspelningsfunktionen.';
$string['config_recording_hide_button_default'] = 'Dölj inspelningsknapp';
$string['config_recording_hide_button_default_description'] = 'Om markerat kommer inspelningsknappen vara dold';
$string['config_recording_hide_button_editable'] = 'Dölj inspelningsknapp kan redigeras';
$string['config_recording_hide_button_editable_description'] = 'Om markerad inkluderar användargränssnittet ett alternativ för att aktivera och inaktivera inspelningsknappen.';
$string['config_recording_protect_editable'] = 'Skyddade inspelningars status kan redigeras';
$string['config_recording_protect_editable_description'] = 'Om markerad innehåller gränssnittet alternativ för att aktivera/inaktivera skyddet för inspelningar.';
$string['config_recording_refresh_period'] = 'Uppdateringsintervall vid inspelning (i sekunder)';
$string['config_recording_refresh_period_description'] = 'För att undvika att fråga Bigbluebutton-servern för ofta cachelagrar vi information för inspelning. Detta är uppdateringsintervallet i sekunder och avgör hur ofta vi kan/ska uppdatera fjärrinformation för en viss inspelning. Standardvärdet är 300s (5 minuter).';
$string['config_recordingready_enabled'] = 'Meddela när en inspelning är klar';
$string['config_recordingready_enabled_description'] = 'Aktivera pluginmodulen för att skicka meddelanden när inspelningen är klar. (Det fungerar bara om skriptet <code>post_publish_recording_ready_callback</code> är aktiverat på BigBlueButton-servern)';
$string['config_recordings'] = 'Inställningar för "Visa inspelningar"-funktionen';
$string['config_recordings_asc_sort'] = 'Sortera inspelningarna stigande';
$string['config_recordings_asc_sort_description'] = 'Som standard visas inspelningarna i fallande ordning. Om markerat visas de i stigande ordning.';
$string['config_recordings_deleted_default'] = 'Inkludera inspelningar från borttagna aktiviteter aktiverat som standard';
$string['config_recordings_deleted_default_description'] = 'Om aktiverat kommer tabellen med inspelningar inkludera inspelningar som hör till borttagna aktiviteter, om sådana finns.';
$string['config_recordings_deleted_editable'] = 'Egenskaperna för att inkludera inspelningar från borttagna aktiviteter kan redigeras';
$string['config_recordings_deleted_editable_description'] = 'Inkludera inspelningar från borttagna aktiviteter som standard kan redigeras när instansen läggs till eller uppdateras.';
$string['config_recordings_description'] = 'De här inställningarna är funktionsspecifika';
$string['config_recordings_general'] = 'Visa inspelningsinställningar';
$string['config_recordings_general_description'] = 'De här inställningarna används enbart då inspelningar visas';
$string['config_recordings_imported_default'] = 'Visa endast importerade länkar aktiverat som standard';
$string['config_recordings_imported_default_description'] = 'Om aktiverat inkluderar inspelningstabellen enbart länkarna till inspelningarna.';
$string['config_recordings_imported_editable'] = 'Visa endast importerade länkar kan redigeras';
$string['config_recordings_imported_editable_description'] = 'Visa endast importerade länkar kan som standard redigeras när instansen läggs till eller uppdateras.';
$string['config_recordings_preview_default'] = 'Förhandsgranskning är aktiverat som standard';
$string['config_recordings_preview_default_description'] = 'Om aktiverat inkluderar tabellen en förhandsgranskning av presentationen.';
$string['config_recordings_preview_editable'] = 'Förhandsgranskningsfunktionen kan redigeras';
$string['config_recordings_preview_editable_description'] = 'Förhandsgranskningsfunktionen kan redigeras när instansen läggs till eller uppdateras.';
$string['config_scheduled'] = 'Inställningar för <em>"Schemalagda sessioner"</em>';
$string['config_scheduled_description'] = 'De här inställningarna definierar vissa aspekter av standardbeteendet för schemalagda sessioner.';
$string['config_scheduled_pre_opening'] = 'Tillgänglig innan öppningstiden (minuter)';
$string['config_scheduled_pre_opening_description'] = 'Tid i minuter som sessionen i förväg är tillgänglig i relation till öppningstiden för sessionen.';
$string['config_server_url'] = 'BigBlueButton server-URL';
$string['config_server_url_description'] = 'Standardautentiseringsuppgifterna gäller för en <a href="https://bigbluebutton.org/free-bigbluebutton-service-for-moodle/" target="_blank">gratis BigBlueButton-tjänst för Moodle (öppnas i nytt fönster)</a> som tillhandahålls av Blindside Networks med följande begränsningar:
<ol>
<li>Den maximala längden för varje session är 60 minuter</li>
<li>Det maximala antalet samtidiga användare per session är 25</li>
<li>Inspelningar upphör att gälla efter sju (7) dagar och kan inte laddas ned</li>
<li>Deltagares webbkameror är bara synliga för moderatorn.</li>
</ol>';
$string['config_shared_secret'] = 'Delad hemlighet för BigBlueButton';
$string['config_shared_secret_description'] = 'Säkerhetssaltning för din BigBlueButton-server. (Den här saltningen är för en BBB-server som tillhandahålls av Blindside Networks som du kan använda för testning.)';
$string['config_uidelegation_enabled'] = 'UI-delegering är aktiverad';
$string['config_uidelegation_enabled_description'] = 'Dessa inställningar aktiverar eller inaktiverar UI-delegeringen till BigBlueButton-servern.';
$string['config_userlimit'] = 'Inställningar för funktionen "Användarbegränsningar"';
$string['config_userlimit_default'] = 'Användarbegränsning aktiverat som standard';
$string['config_userlimit_default_description'] = 'Standardantalet användare som tillåts för en session när ett nytt rum eller konferens läggs till. 0 = obegränsat antal.';
$string['config_userlimit_description'] = 'Dessa inställningar aktiverar eller inaktiverar alternativ i användargränssnittet och anger även standardvärdena för dessa alternativ.';
$string['config_userlimit_editable'] = 'Funktionen användarbegränsningar kan redigeras';
$string['config_userlimit_editable_description'] = 'Användargränsvärdet kan som standard redigeras när rummet eller konferensen läggs till eller uppdateras.';
$string['config_voicebridge'] = 'Konfiguration av funktionen "Röstbrygga"';
$string['config_voicebridge_description'] = 'Dessa inställningar aktiverar eller inaktiverar alternativ i användargränssnittet och definierar även standardvärden för dessa alternativ.';
$string['config_voicebridge_editable'] = 'Konferensröstbrygga kan redigeras';
$string['config_voicebridge_editable_description'] = 'Konferensröstbryggenummer kan tilldelas permanent till en rumskonferens. När numret tilldelas kan det inte användas av något annat rum eller konferens';
$string['config_waitformoderator'] = 'Konfiguration för funktionen "Vänta på moderator"';
$string['config_waitformoderator_cache_ttl'] = 'Vänta på moderator cache-TTL (sekunder)';
$string['config_waitformoderator_cache_ttl_description'] = 'För att stödja en stor mängd klienter använder denna pluginmodul en cache. Den här parametern definierar den tid cachen ska behållas innan nästa begäran skickas till BigBlueButton-servern.';
$string['config_waitformoderator_default'] = 'Vänta på moderator aktiverat som standard';
$string['config_waitformoderator_default_description'] = 'Funktionen Vänta på moderator aktiveras som standard när ett nytt rum eller en ny konferens läggs till.';
$string['config_waitformoderator_description'] = 'Dessa inställningar är funktionsspecifika';
$string['config_waitformoderator_editable'] = 'Vänta på moderator kan redigeras';
$string['config_waitformoderator_editable_description'] = 'Vänta på moderatorvärde som standard kan redigeras när rummet eller konferensen läggs till eller uppdateras.';
$string['config_waitformoderator_ping_interval'] = 'Vänta på moderator-ping (sekunder)';
$string['config_waitformoderator_ping_interval_description'] = 'När funktionen Vänta på moderator är aktiverad pingar klienten efter sessionens status var [nummer] sekund. Den här parametern definierar intervallet för begäranden som görs till Moodle-servern';
$string['config_warning_bigbluebuttonbn_cfg_deprecated'] = 'BigBlueButton använder config.php med en global variabel som inte längre stöds. Konvertera filen eftersom den inte stöds i framtida versioner';
$string['config_warning_curl_not_installed'] = 'Den här funktionen kräver CURL-tillägget för php installerat och aktiverat. Inställningarna är endast tillgängliga om det här villkoret är uppfyllt.';
$string['config_welcome_default'] = 'Standardmeddelande för välkomstmeddelande';
$string['config_welcome_default_description'] = 'Ersätter standardmeddelandet som har upprättats för BigBlueButton-servern. Meddelandet kan innehålla nyckelord (%%CONFNAME%%, %%DIALNUM%%, %%CONFNUM%%) som kommer att ersättas automatiskt, och även html-taggar som <b>...</b> eller <i></i>';
$string['config_welcome_editable'] = 'Standardvälkomstmeddelandet är redigerbart för lärare';
$string['config_welcome_editable_description'] = 'Välkomstmeddelande kan redigeras när instanser läggs till eller uppdateras';
$string['enablingbigbluebutton'] = 'Aktiverar BBB-aktiviteten';
$string['enablingbigbluebuttondpainfo'] = 'För att uppfylla dina dataskyddsförpliktelser måste du, innan du aktiverar denna pluginmodul, bekräfta att du har läst och accepterat <a href = "{$a}" target = "_blank">Blindside Networks databehandlingsavtal</a>. Rådgör med dina egna sekretessexperter för råd.';
$string['end_session_confirm'] = 'Vill du avsluta den virtuella klassrumssessionen?';
$string['end_session_confirm_title'] = 'Vill du verkligen avsluta sessionen?';
$string['end_session_notification'] = 'Sessionen har nu stängts.';
$string['ends_at'] = 'Slutar';
$string['event_activity_created'] = 'Aktivitet skapad';
$string['event_activity_deleted'] = 'Aktivitet borttagen';
$string['event_activity_updated'] = 'Aktivitet uppdaterad';
$string['event_live_session'] = 'Livehändelse';
$string['event_meeting_created'] = 'Möte skapat';
$string['event_meeting_ended'] = 'Mötet tvingades avsluta';
$string['event_meeting_joined'] = 'Möte anslutet';
$string['event_meeting_left'] = 'Möte lämnat';
$string['event_recording_deleted'] = 'Inspelning borttagen';
$string['event_recording_edited'] = 'Inspelning redigerad';
$string['event_recording_imported'] = 'Inspelningar importerade';
$string['event_recording_protected'] = 'Skyddad inspelning';
$string['event_recording_published'] = 'Inspelning publicerad';
$string['event_recording_unprotected'] = 'Inspelning oskyddad';
$string['event_recording_unpublished'] = 'Inspelning avpublicerad';
$string['event_recording_viewed'] = 'Inspelning visad';
$string['event_unknown'] = 'Okänd händelse';
$string['general_error_cannot_create_meeting'] = 'Kan inte skapa möte';
$string['general_error_cannot_get_recordings'] = 'Kan inte hämta inspelningar';
$string['general_error_no_answer'] = 'Tomt svar. Kontrollera webbadressen till BigBlueButton-servern OCH kontrollera om BigBlueButton-servern körs.';
$string['general_error_not_allowed_to_create_instances'] = 'Användaren är inte behörig att skapa instanser';
$string['general_error_not_found'] = 'Posten hittades inte: {$a}';
$string['general_error_unable_connect'] = 'Det går inte att ansluta. Kontrollera webbadressen till BigBlueButton-servern OCH kontrollera om BigBlueButton-servern körs.
Detaljer : {$a}';
$string['index_confirm_end'] = 'Vill du avsluta den virtuella klassen?';
$string['index_disabled'] = 'inaktiverad';
$string['index_enabled'] = 'Aktiverad';
$string['index_ending'] = 'Avslutar det virtuella klassrummet. Vänta…';
$string['index_error_bbtn'] = 'BigBlueButton-ID {$a} är inte korrekt';
$string['index_error_checksum'] = 'Ett checksummefel inträffade. Säkerställ att du angav korrekt hemlighet.';
$string['index_error_forciblyended'] = 'Kan inte ansluta till det här mötet eftersom det har avslutats manuellt.';
$string['index_error_noinstances'] = 'Det finns inga instanser av bigbluebuttonbn';
$string['index_error_unable_display'] = 'Det gick inte att visa mötena. Kontrollera webbadressen till BigBlueButton-servern OCH kontrollera om BigBlueButton-servern körs.';
$string['index_heading'] = 'BigBlueButton-rum';
$string['index_heading_actions'] = 'Åtgärder';
$string['index_heading_group'] = 'Grupp';
$string['index_heading_moderator'] = 'Moderatorer';
$string['index_heading_name'] = 'Rum';
$string['index_heading_recording'] = 'Inspelning';
$string['index_heading_users'] = 'Användare';
$string['index_heading_viewer'] = 'Tittare';
$string['indicator:cognitivedepth'] = 'BigBlueButton kognitiv';
$string['indicator:cognitivedepth_help'] = 'Denna indikator baseras på det kognitiva djup som uppnåtts av studenten i en BigBlueButtonBN-aktivitet.';
$string['indicator:socialbreadth'] = 'BigBlueButton social';
$string['indicator:socialbreadth_help'] = 'Denna indikator baseras på den sociala bredd som uppnåtts av studenten i en BigBlueButton-aktivitet.';
$string['instance_type_default'] = 'Rum/aktivitet med inspelningar';
$string['instance_type_recording_only'] = 'Enbart inspelningar';
$string['instance_type_room_only'] = 'Enbart rum/aktivitet';
$string['instanceprofilewithoutrecordings'] = 'Instansprofilen kan inte visa inspelningar';
$string['messageprovider:instance_updated'] = 'BigBlueButton-mötet uppdaterat';
$string['messageprovider:recording_ready'] = 'BigBlueButton-inspelning klar att visas';
$string['minute'] = 'minut';
$string['minutes'] = 'minuter';
$string['mod_form_block_general'] = 'Allmänna inställningar';
$string['mod_form_block_participants'] = 'Tilldelad roll vid livehändelsen';
$string['mod_form_block_presentation'] = 'Presentationsinnehåll';
$string['mod_form_block_presentation_default'] = 'Standardinnehåll för presentation';
$string['mod_form_block_record'] = 'Inspelningsinställningar';
$string['mod_form_block_recordings'] = 'Inspelningsvy';
$string['mod_form_block_room'] = 'Aktivitets- och rumsinställningar';
$string['mod_form_block_schedule'] = 'Sessionsschema';
$string['mod_form_field_closingtime'] = 'Anslut stängdes';
$string['mod_form_field_conference_name'] = 'Konferensnamn';
$string['mod_form_field_disablecam'] = 'Inaktivera webbkameror';
$string['mod_form_field_disablemic'] = 'Inaktivera mikrofoner';
$string['mod_form_field_disablenote'] = 'Inaktivera delade anteckningar';
$string['mod_form_field_disableprivatechat'] = 'Inaktivera privat chatt';
$string['mod_form_field_disablepublicchat'] = 'Inaktivera publik chatt';
$string['mod_form_field_duration'] = 'Längd';
$string['mod_form_field_duration_help'] = 'Om du anger varaktigheten för ett möte fastställs den maximala tiden för ett möte att hållas vid liv innan inspelningen avslutas';
$string['mod_form_field_hideuserlist'] = 'Dölj användarlista';
$string['mod_form_field_instanceprofiles'] = 'Instanstyp';
$string['mod_form_field_instanceprofiles_help'] = 'Välj typ för den här BigBlueButton-instansen.';
$string['mod_form_field_intro'] = 'Beskrivning';
$string['mod_form_field_intro_help'] = 'En kort beskrivning av rummet eller konferensen.';
$string['mod_form_field_muteonstart'] = 'Tyst vid start';
$string['mod_form_field_name'] = 'Namn';
$string['mod_form_field_nosettings'] = 'Inga inställningar kan redigeras';
$string['mod_form_field_openingtime'] = 'Öppna';
$string['mod_form_field_participant_add'] = 'Lägg till tilldelning';
$string['mod_form_field_participant_bbb_role_moderator'] = 'Moderator';
$string['mod_form_field_participant_bbb_role_viewer'] = 'Åskådare';
$string['mod_form_field_participant_list'] = 'Tilldelningslista';
$string['mod_form_field_participant_list_action_add'] = 'Lägg till';
$string['mod_form_field_participant_list_action_remove'] = 'Ta bort';
$string['mod_form_field_participant_list_text_as'] = 'anslut till sessionen som';
$string['mod_form_field_participant_list_type_all'] = 'Alla registrerade användare';
$string['mod_form_field_participant_list_type_owner'] = 'Ägare';
$string['mod_form_field_participant_list_type_role'] = 'Roll';
$string['mod_form_field_participant_list_type_user'] = 'Användare';
$string['mod_form_field_record'] = 'Sessioner kan spelas in';
$string['mod_form_field_recordallfromstart'] = 'Spela in allt från start';
$string['mod_form_field_recordhidebutton'] = 'Dölj inspelningsknappen';
$string['mod_form_field_recordings_deleted'] = 'Inkludera inspelningar från borttagna aktiviteter';
$string['mod_form_field_recordings_html'] = 'Visa tabellen i ren HTML';
$string['mod_form_field_recordings_imported'] = 'Visa enbart importerade länkar';
$string['mod_form_field_recordings_preview'] = 'Visa förhandsgranskning av inspelning';
$string['mod_form_field_room_name'] = 'Namn';
$string['mod_form_field_userlimit'] = 'Deltagargräns';
$string['mod_form_field_userlimit_help'] = 'Maximal gräns för användare som tillåts i ett möte. Om gränsen är inställd på 0 kommer antalet användare att vara obegränsat.';
$string['mod_form_field_voicebridge'] = 'Röstbrygga [####]';
$string['mod_form_field_voicebridge_format_error'] = 'Formateringsfel. Du måste ange ett tal mellan 1 och 9999.';
$string['mod_form_field_voicebridge_help'] = 'Röstkonferensnummer som deltagarna anger för att delta i röstkonferensen när de använder uppringning. Ett tal mellan 1 och 9999 måste anges. Om värdet är 0 ignoreras det statiska röstbryggenumret och ett slumpmässigt nummer genereras av BigBlueButton. Ett nummer 7 kommer att föregå de fyra siffror som skrivs';
$string['mod_form_field_voicebridge_notunique_error'] = 'Inte ett unikt värde. Detta nummer används av ett annat rum eller en annat möte.';
$string['mod_form_field_wait'] = 'Vänta på moderator';
$string['mod_form_field_wait_help'] = 'Behöver deltagarna vänta på moderator innan de släpps in i rummet?';
$string['mod_form_field_welcome'] = 'Välkomstmeddelande';
$string['mod_form_field_welcome_default'] = 'Välkommen till %%CONFNAME%%.';
$string['mod_form_field_welcome_help'] = 'Välkomstmeddelandet visas när deltagarna kommer in i rummet. Om fältet lämnas tomt visas ett standardmeddelande som konfigurerats i webbplatsadministrationen.';
$string['mod_form_locksettings'] = 'Lås inställningar';
$string['modulename'] = 'BigBlueButton';
$string['modulename_help'] = 'BigBlueButton är ett webbkonferenssystem baserat på öppen källkod som är utformat för onlineinlärning. Systemet stöder realtidsdelning av ljud, video, chatt, bilder, skärmdelning, en whiteboard för flera användare, breakout-rum, omröstningar och emojis.

Med BigBlueButton kan du skapa ett rum för sessioner så som live online-klasser, virtuella kontorstider eller gruppsamarbeten med externa studenter. Sessionen kan spelas in för senare uppspelning.';
$string['modulename_link'] = 'BigBlueButton/view';
$string['modulenameplural'] = 'BigBlueButton';
$string['new_bigblubuttonbn_activities'] = 'BigBlueButton-aktivitet';
$string['nosuchinstance'] = 'Ingen sådan instans {$a->entity} med id: {$a->id}';
$string['notification_instance_created_intro'] = 'Aktiviteten <a href="{$a->link}">{$a->name}</a> BigBlueButton har skapats.';
$string['notification_instance_created_small'] = 'Ett nytt BigBlueButton-möte med namnet {$a->name} skapades';
$string['notification_instance_created_subject'] = 'En ny BigBlueButton-mötesaktivitet har skapats';
$string['notification_instance_description'] = 'Beskrivning';
$string['notification_instance_end_date'] = 'Slutdatum';
$string['notification_instance_name'] = 'Titel';
$string['notification_instance_start_date'] = 'Startdatum';
$string['notification_instance_updated_intro'] = 'Aktiviteten <a href="{$a->link}">{$a->name}</a> BigBlueButton har uppdaterats.';
$string['notification_instance_updated_small'] = 'BigBlueButton-mötet {$a->} uppdaterades';
$string['notification_instance_updated_subject'] = 'Din BigBlueButton-mötesaktivitet har uppdaterats';
$string['notification_recording_ready_html'] = 'En inspelning är nu tillgänglig för ett möte nyligen i <b><a href="{$a->link}">{$a->name}</a></b>.';
$string['notification_recording_ready_plain'] = 'En inspelning är nu tillgänglig för ett möte nyligen i {$a->name}. Se {$a->link} för att visa mötet.';
$string['notification_recording_ready_small'] = 'En ny inspelning är tillgänglig för {$a->name}';
$string['notification_recording_ready_subject'] = 'Inspelning klar';
$string['pluginadministration'] = 'Administrera BigBlueButton';
$string['pluginname'] = 'BigBlueButton';
$string['privacy:metadata:bigbluebutton'] = 'För att skapa och gå med i BigBlueButton-sessioner måste användardata utbytas med servern.';
$string['privacy:metadata:bigbluebutton:fullname'] = 'Fullständigt namn på användaren som kommer åt BigBlueButton-servern.';
$string['privacy:metadata:bigbluebutton:userid'] = 'Användar-ID för användaren som kommer åt BigBlueButton-servern.';
$string['privacy:metadata:bigbluebuttonbn'] = 'Lagrar konfigurationen för rummet eller aktiviteten som definierar funktionerna och det allmänna beteendet för BigBlueButton-sessionen.';
$string['privacy:metadata:bigbluebuttonbn:participants'] = 'En lista över regler som definierar vilken roll användarna ska ha i live-mötet. Ett användar-ID kan lagras och behörigheter kan beviljas per roll eller användare.';
$string['privacy:metadata:bigbluebuttonbn_logs'] = 'Lagrar händelser som utlöses när du använder pluginmodulen.';
$string['privacy:metadata:bigbluebuttonbn_logs:log'] = 'Den typ av händelse som utlöses av användaren.';
$string['privacy:metadata:bigbluebuttonbn_logs:meetingid'] = 'Mötes-ID:t som användaren hade åtkomst till.';
$string['privacy:metadata:bigbluebuttonbn_logs:meta'] = 'Kan innehålla extra information relaterad till mötet eller inspelningen som berördes av händelsen.';
$string['privacy:metadata:bigbluebuttonbn_logs:timecreated'] = 'Den tidpunkt då loggen skapades.';
$string['privacy:metadata:bigbluebuttonbn_logs:userid'] = 'Användar-ID för den användare som utlöste händelsen.';
$string['privacy:metadata:bigbluebuttonbn_recordings'] = 'Lagrar metadata för inspelningar.';
$string['privacy:metadata:bigbluebuttonbn_recordings:userid'] = 'Användar-ID för den användare som senast ändrade en inspelning.';
$string['recordings_from_deleted_activities'] = 'Inspelningar från borttagna aktiviteter';
$string['recordingurlnotfound'] = 'Inspelnings-URL:en är ogiltig.';
$string['removedevents'] = 'Borttagna händelser';
$string['removedlogs'] = 'Ta bort anpassade loggar';
$string['removedrecordings'] = 'Tog bort inspelningarna';
$string['removedtags'] = 'Tog bort etiketterna';
$string['report_join_info'] = 'Har anslutit till rummet {$a} gånger.';
$string['report_play_recording_info'] = 'Has visat en inspelning {$a} gånger.';
$string['report_room_view'] = 'Har visat rummet';
$string['resetevents'] = 'Ta bort händelser';
$string['resetlogs'] = 'Ta bort anpassade loggar';
$string['resetlogs_help'] = 'Om du tar bort loggarna försvinner referenser till inspelningar';
$string['resetrecordings'] = 'Ta bort inspelningar';
$string['resetrecordings_help'] = 'Om du tar bort inspelningarna blir de otillgängliga överallt och detta kan inte ångras';
$string['resettags'] = 'Ta bort etiketter';
$string['search:activity'] = 'BigBlueButton - aktivitetsinformation';
$string['search:tags'] = 'BigBlueButton - etikettinformation';
$string['sendnotification'] = 'Skicka notis';
$string['settings'] = 'BigBlueButton-inställningar';
$string['started_at'] = 'Startade';
$string['starts_at'] = 'Startar';
$string['taskname:check_pending_recordings'] = 'Hämta väntande inspelningar';
$string['userlimitreached'] = 'Gränsen för antalet användare som tillåts i ett möte har uppnåtts.';
$string['view_conference_action_end'] = 'Avsluta session';
$string['view_conference_action_join'] = 'Anslut till session';
$string['view_error_action_not_completed'] = 'Åtgärden kunde inte slutföras';
$string['view_error_bigbluebutton'] = 'BigBlueButton rapporterade fel. {$a}';
$string['view_error_create'] = 'BigBlueButton-servern svarade med ett felmeddelande. Mötet kunde inte skapas.';
$string['view_error_current_state_not_found'] = 'Det gick inte att hitta aktuellt tillstånd. Inspelningen kan ha tagits bort eller så är BigBlueButton-servern inte kompatibel med den utförda åtgärden.';
$string['view_error_import_no_courses'] = 'Inga kurser att söka upp för inspelningar';
$string['view_error_import_no_recordings'] = 'Det finns inga inspelningar att importera för denna kurs';
$string['view_error_invalid_session'] = 'Den här sessionen har löpt ut. Gå tillbaka till aktivitetens huvudsida.';
$string['view_error_max_concurrent'] = 'Gränsen för antalet samtidiga möten har uppnåtts.';
$string['view_error_meeting_not_running'] = 'Något verkar ha gått fel - mötet är inte igång';
$string['view_error_no_group'] = 'Inga grupper har konfigurerats ännu. Vänligen konfigurera grupper innan du försöker ansluta till mötet.';
$string['view_error_no_group_student'] = 'Du har inte registrerats i den här gruppen. Vänligen kontakta din lärare eller administratör.';
$string['view_error_no_group_teacher'] = 'Inga grupper har konfigurerats ännu. Vänligen konfigurera grupper eller kontakta administratören.';
$string['view_error_unable_join'] = 'Det går inte att ansluta till mötet. Kontrollera webbadressen till BigBlueButton-servern OCH kontrollera om BigBlueButton-servern körs.';
$string['view_error_unable_join_student'] = 'Det gick inte att ansluta till BigBlueButton-servern. Kontakta läraren eller administratören.';
$string['view_error_unable_join_teacher'] = 'Det gick inte att ansluta till BigBlueButton-servern. Kontakta administratören.';
$string['view_error_url_missing_parameters'] = 'Det saknas parametrar i URL:en';
$string['view_error_userlimit_reached'] = 'Gränsen för antalet användare i ett möte har uppnåtts.';
$string['view_groups_nogroups_warning'] = 'Rummet har konfigurerats för att använda grupper men det finns inga grupper definierade i kursen.';
$string['view_groups_notenrolled_warning'] = 'Rummet har konfigurerats för att använda grupper men du är inte medlem i någon av dem.';
$string['view_groups_selection'] = 'Välj den grupp du vill ansluta till och bekräfta åtgärden';
$string['view_groups_selection_join'] = 'Anslut';
$string['view_groups_selection_warning'] = 'Det finns ett konferensrum för varje grupp och du har tillgång till mer än en. Var noga med att välja rätt.';
$string['view_login_moderator'] = 'Loggar in som moderator…';
$string['view_login_viewer'] = 'Loggar in som tittare…';
$string['view_message_and'] = 'och';
$string['view_message_conference_has_ended'] = 'Denna konferens är avslutad.';
$string['view_message_conference_in_progress'] = 'Denna konferens pågår';
$string['view_message_conference_not_started'] = 'Denna konferens har inte börjat ännu.';
$string['view_message_conference_room_ready'] = 'Mötesrummet är klart. Du kan ansluta till sessionen nu.';
$string['view_message_conference_wait_for_moderator'] = 'Väntar på att en moderator ska ansluta.';
$string['view_message_finished'] = 'Denna aktivitet är slut.';
$string['view_message_has_joined'] = 'har anslutit';
$string['view_message_have_joined'] = 'har anslutit';
$string['view_message_hour'] = 'timme';
$string['view_message_hours'] = 'timmar';
$string['view_message_importrecordings_disabled'] = 'Funktionen för att importera inspelningslänkar är inaktiverad på denna server.';
$string['view_message_minute'] = 'minute';
$string['view_message_minutes'] = 'minuter';
$string['view_message_moderator'] = 'moderator';
$string['view_message_moderators'] = 'moderatorer';
$string['view_message_norecordings'] = 'Det finns inga inspelningar att visa';
$string['view_message_notavailableyet'] = 'Den här sessionen är inte tillgänglig ännu.';
$string['view_message_recordings_disabled'] = 'Inspelningar har inaktiverats på den här servern. BigBlueButton-instanser enbart för inspelningar kan inte användas.';
$string['view_message_room_closed'] = 'Detta rum är stängt.';
$string['view_message_room_open'] = 'Detta rum är öppet.';
$string['view_message_room_ready'] = 'Detta rum är klart.';
$string['view_message_session_for'] = 'sessionen för';
$string['view_message_session_has_user'] = 'Det finns';
$string['view_message_session_has_users'] = 'Det finns';
$string['view_message_session_no_users'] = 'Det finns inga användare i denna session';
$string['view_message_session_running_for'] = 'Denna session har pågått i';
$string['view_message_session_started_at'] = 'Denna session började';
$string['view_message_tab_close'] = 'Detta fönster/flik måste stängas manuellt';
$string['view_message_times'] = 'gånger';
$string['view_message_user'] = 'användare';
$string['view_message_users'] = 'användare';
$string['view_message_viewer'] = 'tittare';
$string['view_message_viewers'] = 'tittare';
$string['view_mobile_message_groups_not_supported'] = 'Den här instansen är i inställd för att använda grupper, men mobilappen har inte stöd för detta. Öppna på skrivbordet om du vill använda gruppstödet.';
$string['view_mobile_message_reload_page_creation_time_meeting'] = 'Du har överskridit de 45 sekunderna på den här sidan, ladda om sidan för att ansluta korrekt till mötet.';
$string['view_noguests'] = 'BigBlueButton är inte öppen för gäster';
$string['view_nojoin'] = 'Du är inte behörig att ansluta till denna session.';
$string['view_recording'] = 'inspelning';
$string['view_recording_actionbar'] = 'Verktygsrad';
$string['view_recording_activity'] = 'Aktivitet';
$string['view_recording_button_import'] = 'Importera inspelningslänkar';
$string['view_recording_button_return'] = 'Tillbaka';
$string['view_recording_course'] = 'Kurs';
$string['view_recording_date'] = 'Datum';
$string['view_recording_delete_confirmation'] = 'Är du säker på att du vill ta bort denna {$a}?';
$string['view_recording_delete_confirmation_warning_p'] = 'Den här inspelningen har {$a} länkar associerade som importerades i olika kurser eller aktiviteter. Om inspelningen tas bort kommer dessa länkar också att tas bort';
$string['view_recording_delete_confirmation_warning_s'] = 'Den här inspelningen har {$a} länkar associerade som importerades i en annan kurs eller aktivitet. Om inspelningen tas bort kommer den länken också att tas bort';
$string['view_recording_description'] = 'Beskrivning';
$string['view_recording_description_edithint'] = 'Redigera beskrivningen. Det gör det lättare att hitta inspelningen senare';
$string['view_recording_description_editlabel'] = 'Redigera beskrivning';
$string['view_recording_duration'] = 'Varaktighet';
$string['view_recording_duration_min'] = 'min';
$string['view_recording_format_errror_unreachable'] = 'URL:en för detta inspelningsformat kan inte nås.';
$string['view_recording_format_notes'] = 'Anteckningar';
$string['view_recording_format_podcast'] = 'Podcast';
$string['view_recording_format_presentation'] = 'Presentation';
$string['view_recording_format_screenshare'] = 'Skärmdelning';
$string['view_recording_format_statistics'] = 'Statistik';
$string['view_recording_format_video'] = 'Video';
$string['view_recording_import_confirmation'] = 'Är du säker på att du vill importera den här inspelningen?';
$string['view_recording_length'] = 'Längd';
$string['view_recording_link_warning'] = 'Detta är en länk som pekar på en inspelning som skapades i en annan kurs eller aktivitet';
$string['view_recording_list_action_delete'] = 'Tar bort';
$string['view_recording_list_action_edit'] = 'Uppdaterar';
$string['view_recording_list_action_play'] = 'Spela';
$string['view_recording_list_action_process'] = 'Bearbetar';
$string['view_recording_list_action_protect'] = 'Skyddar';
$string['view_recording_list_action_publish'] = 'Publicerar';
$string['view_recording_list_action_unprotect'] = 'Tar bort skydd';
$string['view_recording_list_action_unpublish'] = 'Avpublicerar';
$string['view_recording_list_action_update'] = 'Uppdaterar';
$string['view_recording_list_actionbar'] = 'Verktygsrad';
$string['view_recording_list_actionbar_delete'] = 'Ta bort';
$string['view_recording_list_actionbar_edit'] = 'Redigera';
$string['view_recording_list_actionbar_hide'] = 'Dölj';
$string['view_recording_list_actionbar_import'] = 'Importera';
$string['view_recording_list_actionbar_protect'] = 'Gör privat';
$string['view_recording_list_actionbar_publish'] = 'Publicera';
$string['view_recording_list_actionbar_show'] = 'Visa';
$string['view_recording_list_actionbar_unprotect'] = 'Gör publik';
$string['view_recording_list_actionbar_unpublish'] = 'Avpublicera';
$string['view_recording_list_activity'] = 'Aktivitet';
$string['view_recording_list_course'] = 'Kurs';
$string['view_recording_list_date'] = 'Datum';
$string['view_recording_list_description'] = 'Beskrivning';
$string['view_recording_list_duration'] = 'Längd';
$string['view_recording_list_recording'] = 'Inspelning';
$string['view_recording_meeting'] = 'Möte';
$string['view_recording_modal_button'] = 'Använd';
$string['view_recording_modal_title'] = 'Ange värden för inspelningen';
$string['view_recording_name'] = 'Namn';
$string['view_recording_name_edithint'] = 'Redigera namnet. Det gör det lättare att hitta inspelningen senare';
$string['view_recording_name_editlabel'] = 'Redigera namn';
$string['view_recording_playback'] = 'Uppspelning';
$string['view_recording_preview'] = 'Förhandsgranska';
$string['view_recording_preview_help'] = 'Håll musen över bilden för att se hela';
$string['view_recording_protect_confirmation'] = 'Är du säker på att du vill skydda den här {$a}?';
$string['view_recording_protect_confirmation_warning_p'] = 'Den här inspelningen har {$a} länkar associerade som importerades i olika kurser eller aktiviteter. Om inspelningen är skyddad kommer detta även att påverka de importerade länkarna';
$string['view_recording_protect_confirmation_warning_s'] = 'Den här inspelningen har {$a} länkar associerade som importerades i en annan kurs eller aktivitet. Om inspelningen är skyddad kommer detta även att påverka de importerade länkarna';
$string['view_recording_publish_confirmation'] = 'Är du säker på att du vill publicera den här {$a}?';
$string['view_recording_publish_confirmation_warning_p'] = 'Den här inspelningen har {$a} länkar associerade som importerades i olika kurser eller aktiviteter. Om inspelningen publiceras kommer dessa länkar också att publiceras';
$string['view_recording_publish_confirmation_warning_s'] = 'Den här inspelningen har {$a} länkar associerade som importerades i en annan kurs eller aktivitet. Om inspelningen publiceras kommer den länken också att publiceras';
$string['view_recording_publish_link_deleted'] = 'Den här länken kan inte publiceras igen eftersom den faktiska inspelningen inte finns på den aktuella BigBlueButton-servern. Länken måste tas bort.';
$string['view_recording_publish_link_not_published'] = 'Den här länken kan inte publiceras igen eftersom den faktiska inspelningen är opublicerad';
$string['view_recording_recording'] = 'Inspelning';
$string['view_recording_select_course'] = 'Välj först en kurs i nedrullningsmenyn';
$string['view_recording_tags'] = 'Etiketter';
$string['view_recording_unprotect_confirmation'] = 'Är du säker på att du vill ta bort skyddet för den här {$a}?';
$string['view_recording_unprotect_confirmation_warning_p'] = 'Den här inspelningen har {$a} associerade länkar som importerades i andra kurser eller aktiviteter. Om skyddet tas bort från dessa inspelningar påverkas även länkarna.';
$string['view_recording_unprotect_confirmation_warning_s'] = 'Den här inspelningen har {$a} associerade länkar som importerades i en annan kurs eller aktivitet. Om skyddet tas bort från inspelningen påverkas även länkarna.';
$string['view_recording_unprotect_link_deleted'] = 'Skyddet för den här länken kan inte tas bort eftersom den faktiska inspelningen inte finns på den aktuella BigBlueButton-servern. Länken ska tas bort.';
$string['view_recording_unprotect_link_not_unprotected'] = 'Skyddet för den här länken kan inte tas bort eftersom den faktiska inspelningen är skyddad';
$string['view_recording_unpublish_confirmation'] = 'Är du säker på att du vill avpublicera den här {$a}?';
$string['view_recording_unpublish_confirmation_warning_p'] = 'Den här inspelningen har {$a} associerade länkar som importerades i andra kurser eller aktiviteter. Om inspelningen avpubliceras kommer dessa länkar också att avpubliceras';
$string['view_recording_unpublish_confirmation_warning_s'] = 'Den här inspelningen har {$a} associerade länkar som importerades i en annan kurs eller aktivitet. Om inspelningen avpubliceras kommer dessa länkar också att avpubliceras';
$string['view_recording_yui_first'] = 'Första';
$string['view_recording_yui_go'] = 'Kör';
$string['view_recording_yui_last'] = 'Sista';
$string['view_recording_yui_next'] = 'Nästa';
$string['view_recording_yui_page'] = 'Sida';
$string['view_recording_yui_prev'] = 'Föregående';
$string['view_recording_yui_rows'] = 'Rader';
$string['view_recording_yui_show_all'] = 'Visa alla';
$string['view_room'] = 'Visa rum';
$string['view_section_title_presentation'] = 'Presentationsfil';
$string['view_section_title_recordings'] = 'Inspelningar';
$string['view_warning_default_server'] = 'Den här webbplatsen använder en <a href="https://bigbluebutton.org/free-bigbluebutton-service-for-moodle/" target="_blank">gratis BigBlueButton-tjänst för Moodle (öppnas i nytt fönster)</a> som tillhandahålls av Blindside Networks med begränsningar enligt följande:
<ol>
<li>Den maximala längden för varje session är 60 minuter</li>
<li>Det maximala antalet samtidiga användare per session är 25</li>
<li>Inspelningarna upphör att gälla efter sju (7) dagar och kan inte laddas ned</li>
<li>Deltagarnas kameror är bara synliga för moderatorn.</li>
</ol>';
$string['waitformoderator'] = 'Väntar på att en moderator ska ansluta.';
