<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'tool_catalogue', language 'no', version '4.4'.
 *
 * @package     tool_catalogue
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['aboutthiscourse'] = 'Om dette kurset';
$string['aboutthisprogram'] = 'Om dette programmet';
$string['all'] = 'Alle';
$string['allavailablecourses'] = 'Alle tilgjengelige kurs';
$string['allowhtmltags'] = 'Tillat HTML-tagger';
$string['aria:courseactions'] = 'Kurshandlinger';
$string['cachedef_filters'] = 'Søkeresultater og filtre for Kurskatalog';
$string['catalogue'] = 'Kurskatalog';
$string['catalogue:config'] = 'Konfigurer kurskatalog';
$string['catalogueisdisabled'] = 'Kurskatalog er deaktivert';
$string['cataloguesettings'] = 'Mine innstillinger for programmer og kurskatalog';
$string['categories'] = 'Kategorier';
$string['categoriesdepthlimit'] = 'Maks antall nivå kategorier';
$string['categoriesdepthlimit_desc'] = 'Maks antall kategorinivåer i kategorivelgeren. Kurs på nivåer lengre ned vil fortsatt vises i søkeresultatene.';
$string['categorieslimit'] = 'Maks antall kategorier på samme nivå';
$string['categorieslimit_desc'] = 'Maks antall kategorier på samme nivå i kategorivelgeren. Kategorier vil vises i samme rekkefølge som i kursoversikten. Hvis det er flere kategorier på samme nivå, vil ikke kategoriene vises i velgeren, men alle kurs vil fortsatt vises i søkeresultatene.';
$string['certifications'] = 'Sertifiseringer';
$string['certificationstatuscertified'] = 'Sertifiseringen \'<strong>{$a->name}</strong>\' er fullført';
$string['certificationstatuscertifiedwithdate'] = 'Sertifiseringen \'<strong>{$a->name}</strong>\' er fullført. Den utløper \'<strong>{$a->date}</strong>\'';
$string['certificationstatusexpired'] = 'Sertifiseringen \'<strong>{$a->name}</strong>\' utløp  {$a->date}';
$string['certificationstatusopen'] = 'Sertifiseringen \'<strong>{$a->name}</strong>\' har ingen forfallsdato';
$string['certificationstatusopenwithdate'] = 'Fullfør dette programmet \'<strong>{$a->date}</strong>\' innen  for å fullføre sertifiseringen \'<strong>{$a->name}</strong>\'';
$string['certificationstatusoverdue'] = 'Sertifiseringen \'<strong>{$a->name}</strong>\' forfalt \'<strong>{$a->date}</strong>\'';
$string['clearall'] = 'Tøm alle';
$string['complete'] = 'Fullført';
$string['completeatleast'] = 'Fullfør minst {$a}';
$string['coursecoverhelp'] = 'Dette kurset er en del av \'{$a}\'-programmet';
$string['coursecoverhelpmultiprogram'] = 'Dette kurset er en del av noen programmer';
$string['coursecoverhelptext'] = '<ul><li>Dette er bare ett kurs i større programmer</li><li>Nye kurs kan bli tilgjengelig etter å ha fullført dette</li></ul>';
$string['coursedisplayduelimit'] = 'Vis dager igjen for kurs';
$string['coursefiles'] = 'Kursfiler';
$string['courseimage_help'] = 'Kursbildet.';
$string['coursenotavailable'] = 'Kurs ikke tilgjengelig';
$string['courses'] = 'Kurs';
$string['coursesperpage_frontpage'] = 'Antall kurs pr side, forsiden';
$string['coursesperpage_frontpage_desc'] = 'Antall kurs som skal vises på forsiden når Vis en liste over kurs er valgt i Forsideinnstillingene';
$string['coursesperpage_main'] = 'Antall kurs pr side, hovedside i kurskatalogen';
$string['coursesperpage_main_desc'] = 'Antall kurs som skal vises på kurskatalogens hovedside før en kategori velges eller søk gjøres og før noen filter velges.';
$string['coursesperpage_search'] = 'Antall kurs pr side i søkeresultater';
$string['coursesperpage_search_desc'] = 'Antall kurs som vises i søkeresultater eller hvis en kategori er valgt.';
$string['dates'] = 'Datoer';
$string['daysleft'] = '{$a} dager igjen';
$string['defaultsortorder'] = 'Standard sortering';
$string['display'] = 'Vis';
$string['displaycourseinfomodal'] = 'Vis kursinfo-modalen';
$string['displayfieldlabel'] = 'Vis feltnavn';
$string['displayfields_desc'] = 'Vennligst velg alle felt som skal vises som filtre og sett dem i riktig rekkefølge. Ikke alle typer egendefinerte felt kan brukes som filter.<br>Endringer i tabellen over lagres automatisk.';
$string['displayfields_list'] = 'Felt som skal vises i listen (detaljert) visning av kursskatalogen.';
$string['displayfields_tiles'] = 'Felt som skal vises i kortvisning (kompakt) av kursskatalogen.';
$string['displayfieldscard_desc'] = 'Vennligst velg alle felt som skal vises på kurskortet og sett dem i riktig rekkefølge.<br>Endringer i tabellen over lagres automatisk.';
$string['displayforeverybody'] = 'Vis til alle';
$string['displayfornotadmin'] = 'Vis kun for brukere som ikke har admintilganger';
$string['displayforstudentsandguests'] = 'Vis kun til gjester og studenter.';
$string['displaynever'] = 'Aldri vis';
$string['displayprogramcoverpage'] = 'Vis programforside';
$string['displaysummaryasis'] = 'Vis som den er';
$string['displaysummarynohtml'] = 'Vis som HTML';
$string['displaysummarynone'] = 'Ikke vis';
$string['dontshowagain'] = 'Ikke vis denne meldingen igjen';
$string['duedate'] = 'Sorter etter konklusjonsdato';
$string['duedateinfo'] = 'Forfall om 1 dag';
$string['duedateinfodays'] = 'Forfall om {$a} dager';
$string['duedatex'] = '<strong>Forfallsdato</strong> {$a}';
$string['editlabel'] = 'Endre tag';
$string['enablelearningcatalogue'] = 'Aktiver kurskatalogen';
$string['enablelearningcatalogue_desc'] = 'Aktiver denne innstillingen for å gi alle brukere tilgang til kurskatalogen i hovedmenyen. Dette gir dem mulighet til å finne, filtrere og melde seg på kurs. Kurskatalogen vil erstatte standard kursside for alle brukere.
<br><br>For flere detaljer, henvis til <a href="{$a}">dokumentasjonsside</a>.';
$string['enddate'] = 'Sluttdato';
$string['enddatex'] = '<strong>Sluttdato:</strong> {$a}';
$string['errornopermissionviewcoursecover'] = 'Ingen tilgang til å se kursforsiden';
$string['errornopermissionviewprogram'] = 'Ingen tilgang til å se programmet';
$string['featuredcustomfield'] = 'Anbefalt egendefinert felt';
$string['featuredcustomfield_desc'] = 'Dersom det valgte egendefinert feltet er avkrysset, vil kurset vises som anbefalt i kurskatalogen.';
$string['featuredlearning'] = 'Anbefalte kurs';
$string['featuredlearningsectionsummary'] = 'Anbefalt seksjon beskrivelse';
$string['featuredlearningsectionsummary_desc'] = 'Denne teksten vil vises sammen med anbefalte kurs i denne seksjonen på hovedsiden til kurskatalogen.';
$string['featuredlearningsectiontitle'] = 'Anbefalt seksjon overskrift';
$string['featuredlearningsectiontitle_default'] = 'Anbefalt';
$string['featuredlearningsectiontitle_desc'] = 'Overskriv tittelen til Anbefalte kurs i kurskatalogen. Hvis tom benyttes standard tekst.';
$string['fieldlabel'] = 'Feltnavn';
$string['fieldonlyvisibleincatalogue'] = 'Dette feltet har begrenset synlighet på kursinformasjons- og påmeldingssidene, men det kan fortsatt gjøres tilgjengelig i kurskatalogen. Hvis aktivert her, vil feltet være synlig for alle.';
$string['filterfields'] = 'Felt som skal vises i kurskatalogfilteret';
$string['hiddenfromlearners'] = 'Skjult for kursdeltakere';
$string['htmltagsall'] = 'Tillat alle HTML-koder';
$string['htmltagsnone'] = 'Fjern alle HTML-tagger';
$string['htmltagssafe'] = 'Bare sikre HTML-tagger';
$string['incomplete'] = 'Ikke fullført';
$string['information'] = 'Informasjon';
$string['iunderstand'] = 'Jeg forstår';
$string['lastaccess'] = 'Sorter etter sist åpnet';
$string['learningcataloguesettings'] = 'Innstillinger for kurskatalog';
$string['moreinfo'] = 'Mer informasjon';
$string['mycourses'] = 'Mine kurs';
$string['name'] = 'Sortér etter navn';
$string['noresultsfor'] = 'Ingen resultater for \'{$a}\'';
$string['notavailableuntil'] = 'Ikke tilgjengelig før \'{$a}\' er fullført';
$string['notnow'] = 'Ikke nå';
$string['notset'] = 'Ikke satt';
$string['overdue'] = 'Forfalt';
$string['pagealastpage'] = 'Side {$a}, siste side';
$string['pageamorepagesahead'] = 'Side {$a}, flere sider igjen';
$string['pagination'] = 'Sidevisning';
$string['pluginname'] = 'Kurskatalog';
$string['privacy:metadata:preference:tool_catalogue_collapse_recently_accessed_courses'] = 'Om du vil skjule delen "Nylig åpnede kurs".';
$string['privacy:metadata:preference:tool_catalogue_hide_program_cover_help'] = 'Om du skal vise programomslagshjelp';
$string['privacy:metadata:preference:tool_catalogue_my_courses_filter'] = 'Om programmene/kursene skal filtreres etter alle/kurs/programmer/fullførte/ufullstendige';
$string['privacy:metadata:preference:tool_catalogue_my_courses_sort'] = 'Om man skal sortere programmene/kursene etter navn/termin/siste tilgang';
$string['privacy:metadata:showprogramcoverhelp'] = 'Om du skal vise programomslagshjelp';
$string['privacy:request:preference:set'] = 'Verdien for innstillingen \'{$a->name}\' var \'{$a->value}\'';
$string['proceedtocourse'] = 'Fortsett til kursinnhold';
$string['proceedtoprogram'] = 'Fortsett til programinnhold';
$string['program'] = 'Program';
$string['programdisplayduelimit'] = 'Vis dager igjen til programmet forfaller';
$string['programdisplayduelimit_desc'] = 'Antall dager som brukere vil se en liten påminnelse fra (Forfaller om X dager) ved siden av programnavnet. For eksempel, hvis satt til 14, vil påminnelsen være synlig i løpet av de 14 dagene før programmet når forfallsdatoen. Sett til 0 for å deaktivere denne funksjonaliteten.';
$string['programempty'] = 'Det er ingen kurs i dette programmet';
$string['programhelptext'] = '<ul><li>Programmer kan inneholde forskjellige kurs</li><li>Fullfør kursene for å fullføre programmet</li></ul>';
$string['programhelptitle'] = 'Hva er et program?';
$string['programimage_help'] = 'Programbildet';
$string['programlink'] = 'Se "{$a}" detaljer';
$string['programlinksingle'] = 'Se programdetaljer';
$string['programs'] = 'Programmer';
$string['programstructure'] = 'Programstruktur';
$string['progress'] = '{$a} % fullført';
$string['progresscompleted'] = '{$a->completed} av {$a->total} fullført';
$string['recentlyaccessedcourses'] = 'Nylig tilgang til kurs';
$string['reg_wpcatalogueashome'] = 'Katalog er aktivert og lagt til portalens hjemmeside ({$a})';
$string['reg_wpcatalogueenabled'] = 'Katalog er aktivert ({$a})';
$string['reg_wpcataloguepublic'] = 'Katalog er aktivert og tilgjengelig for gjester ({$a})';
$string['reindextaskname'] = 'Regelmessig reindeksering av kurs for katalogen';
$string['resultsfor'] = '{$a->count} resultater for \'{$a->keywords}\'';
$string['safehtmltags'] = 'Sikre HTML-koder i sammendrag og tekstfelt';
$string['safehtmltags_desc'] = 'Liste over HTML-taggene som bør beholdes når du viser kurssammendrag eller tilpassede kursfelt i kurskatalogen. Alle andre tagger vil bli fjernet for å sikre at kursoppsummeringer ikke bryter utformingen av katalogen.<br>Merk at HTML-tagger for kursoppsummeringer kanskje ikke fungerer godt sammen med "Truncate"-innstillingen.';
$string['searchfields'] = 'Felt for å søke etter nøkkelord';
$string['searchfields_desc'] = 'Vennligst velg alle kursfelt der søkeordet skal søkes etter og ordne dem i prioritert rekkefølge.<br>Endringer i tabellen ovenfor lagres automatisk.';
$string['searchmethod'] = 'Kurssøkemetode';
$string['searchmethod_desc'] = 'Velg en metode som skal brukes for emnesøk. Noen metoder kan kreve regelmessig re-indeksering og/eller ekstra konfigurasjon.';
$string['searchmethod_extended'] = 'Utvidet søk';
$string['searchmethod_simple'] = 'Enkelt søk';
$string['searchplaceholder'] = 'Søk etter kurs eller programmer';
$string['selectenrolmentmethod'] = 'Velg en påmeldingsmetode';
$string['showcataloguecoursecategory'] = 'Vis kurskategori i kurskort';
$string['showcataloguecoursecategory_desc'] = 'Kurskategorien vil være synlig på hvert kurskort som finnes i ‘Dashbord’, ‘Mine kurs’ og noen blokker.';
$string['showcoursedates'] = 'Vis kursdatoer i kursmodal';
$string['showcoursedates_desc'] = 'Kursdatoene vil være synlige i kursmodalen og i fanen kursinformasjon.';
$string['showfeaturedsection'] = 'Vis anbefalt seksjon i kurskatalogen';
$string['showfeaturedsection_desc'] = 'Hvis aktivert vil anbefalte kurs vises i en egen seksjon øverst på kurskatalogens hovedside';
$string['showmore'] = 'Vis {$a} flere ...';
$string['startdate'] = 'Startdato';
$string['startdatex'] = '<strong>Startdato:</strong> {$a}';
$string['todo'] = 'Å gjøre:';
$string['trainers'] = 'Instruktører';
$string['truncatesummary'] = 'Kutt i kursoppsummering';
$string['truncatesummary_desc'] = 'Maksimalt antall tegn som skal vises i kurssammendraget når det vises. Sett til 0 for ikke å avkorte på serversiden. Sammendraget kan fortsatt forkortes med CSS-stiler som vises.<br>Denne innstillingen kontrollerer teksten som sendes fra serveren til nettleseren. Du kan også velge å avkorte individuelle felt direkte i nettleseren ved å bruke tilpasset CSS.';
$string['trydifferentskeyword'] = 'Prøv å bruke andre søkeord eller filterkonfigurasjon';
$string['xcourses'] = '{$a} kurs';
