<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'appointment', language 'no', version '4.4'.
 *
 * @package     appointment
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['addingappointment'] = 'Legger til avtale';
$string['addingappointments'] = 'Legger til avtaler';
$string['addremoveattendees'] = 'Legg til / fjern deltakere';
$string['addsession'] = 'Legg til økt';
$string['addtimeframe'] = 'Legg til tidsramme';
$string['advanced'] = 'Avansert';
$string['allowcancellations'] = 'Tillat avbestilling';
$string['allowcancellations_help'] = 'Hvis det er merket av, vil deltakere kunne avbryte påmeldingene sine';
$string['allowcancellationsdefault'] = 'Tillat å avbestille - som standard';
$string['allowcancellationsdefault_help'] = 'Hvis avkrysset, vil standardinnstillingen, når du oppretter nye økter for denne aktiviteten, være å tillate avbestillinger';
$string['allowwaitlist'] = 'Tillat venteliste';
$string['allowwaitlist_help'] = 'Når "Tillat venteliste" er krysset av, vil elevene kunne registrere seg på en avtale selv om den allerede er full. <br />Når en elev melder seg på en økt som allerede er full, vil de motta en e-post med beskjed om at de har blitt lagt til på venteliste og vil bli varslet om økten blir tilgjengelig.';
$string['alreadysignedup'] = 'Du har allerede registrert deg for denne avtalen.';
$string['appointment'] = 'Avtale';
$string['appointment:addattendees'] = 'Legg deltakere til en avtalesesjon';
$string['appointment:addinstance'] = 'Legg til instans';
$string['appointment:configurecancellation'] = 'Tillat konfigurering av påmeldingsavbestillinger, når du legger til / redigerer en avtaleaktivitet.';
$string['appointment:editsessions'] = 'Legg til, redigere, kopiere og slette avtaleøkter';
$string['appointment:managecustomfields'] = 'Administrer egendefinerte felt for avtaler.';
$string['appointment:overbook'] = 'Registrer deg på hele økter som ikke har venteliste aktivert.';
$string['appointment:removeattendees'] = 'Fjern deltakerne fra en avtaleøkt';
$string['appointment:signup'] = 'Registrer deg for en økt';
$string['appointment:takeattendance'] = 'Delta';
$string['appointment:view'] = 'Se avtaleaktiviteter og økter';
$string['appointment:viewattendees'] = 'Vis deltakerliste og deltagere';
$string['appointment:viewcancellations'] = 'Vis kanselleringer';
$string['appointmentactivity'] = 'Aktiviteten Avtale';
$string['appointmentcustomfields'] = 'Tilpassede felt for avtale';
$string['appointmentname'] = 'Avtalenavn';
$string['appointments'] = 'Avtaler';
$string['appointmentsession'] = 'Avtaleøkt';
$string['appointmentsessiondates'] = 'Avtale sesjonsdatoer';
$string['appointmentsessions'] = 'Avtaleøkter';
$string['appointmentsettings'] = 'Avtaleinnstillinger';
$string['approvalreqd'] = 'Godkjenning kreves';
$string['approvalreqd_help'] = 'Når "Godkjenning kreves" er avmerket, trenger en elev godkjenning fra lederen sin for å få lov til å delta på en avtaleøkt.';
$string['approve'] = 'Godkjenn';
$string['attendance'] = 'Deltakelse';
$string['attendanceinstructions'] = 'Velg brukere som deltok på økten:';
$string['attendedsession'] = 'Deltatt på økt';
$string['attendees'] = 'Deltakere';
$string['attendeestablesummary'] = 'Folk som planlegger eller har deltatt på denne økten.';
$string['availableplaceholders'] = 'Tilgjengelige plassholdere';
$string['availableseats'] = '{$a} plasser ledige';
$string['book'] = 'Reserver';
$string['bookedat'] = '<strong>Reservert:</strong> {$a}';
$string['bookedvscapacity'] = 'Reservert / Max antall plasser';
$string['bookingcancelled'] = 'Din reservasjon er kansellert.';
$string['bookingcompleted'] = 'Din reservasjon er fullført.';
$string['bookingfull'] = 'Fullt';
$string['bookingopen'] = 'Åpen';
$string['break'] = 'Pausetid';
$string['break_help'] = 'Denne innstillingen bestemmer ventetiden mellom hver avtale. 0 betyr at det ikke blir satt noen ventetid.';
$string['calendareventdescriptionbooking'] = 'Du er reservert for denne <a href="{$a}"> avtaleøkten </a>.';
$string['calendareventdescriptionsession'] = 'Du har opprettet denne <a href="{$a}"> avtaleøkten </a>.';
$string['calendaroptions'] = 'Kalenderalternativer';
$string['cancel'] = 'Avbryt';
$string['cancelbooking'] = 'Avbryt reservering';
$string['cancellationinstrmngr'] = '# Merknad til leder';
$string['cancellationinstrmngr_help'] = 'Når ** Send varsel til leder ** er merket av, sendes teksten i ** Merknad for leder ** -feltet til en elevs leder med beskjed om at de har kansellert en avtalebestilling.';
$string['cancellationmessage'] = 'Avbestillingsmelding';
$string['cancellationmessage_help'] = 'Denne meldingen blir sendt ut når brukere avbryter bookingen for en økt.';
$string['cancellations'] = 'Kanselleringer';
$string['cancellationstablesummary'] = 'Liste over personer som har kansellert påmeldte økter.';
$string['cancelreason'] = 'Årsaken til kansellering';
$string['cannotapproveatcapacity'] = 'Du kan ikke godkjenne flere deltagere ettersom denne økten er full.';
$string['cannotsignupsessioninprogress'] = 'Du kan ikke registrere deg, denne økten pågår';
$string['cannotsignupsessionover'] = 'Du kan ikke registrere deg, denne økten er over.';
$string['capacity'] = 'Kapasitet';
$string['capacity_help'] = '** Kapasitet ** er antall ledige plasser i en økt.

Når en avtaler øker kapasiteten, vises ikke sesjonsdetaljene på kurssiden. Detaljene vises gråtonet på siden "Se alle økter", og eleven kan ikke registrere seg på økten.&nbsp;';
$string['closed'] = 'Stengt';
$string['completionattended'] = 'Reserver et tidspunkt og delta';
$string['completionattended_help'] = 'Hvis aktiver vil aktiviteten fullføres dersom deltakeren er registreres med fremmøte';
$string['completionbooked'] = 'Deltaker må reservere et tidspunkt for å fullføre aktiviteten';
$string['completionbooked_help'] = 'Hvis den er aktivert, vil aktiviteten anses som fullført hvis elevstatusen er "Reservert", "Fullt deltatt" eller "Delvis deltatt". Dersom eleven har kansellert, står på venteliste, eller vedkommendes oppmøte er merket som «Ikke tilstede», vil ikke aktiviteten anses som fullført.';
$string['completiondetail:attended'] = 'Delta på en avtale';
$string['completiondetail:booked'] = 'Reserver en avtale';
$string['confirmationinstrmngr'] = '# Merknad til leder';
$string['confirmationinstrmngr_help'] = 'Når "Send varsel til leder" er krysset av, blir teksten i "Varsel for leder" -feltet sendt til en leder med beskjed om at en medarbeider har meldt seg på en avtaleøkt.';
$string['confirmationmessage'] = 'Bekreftelsesmelding';
$string['confirmationmessage_help'] = 'Denne meldingen blir sendt ut når brukere melder seg på en økt.';
$string['confirmcancelbooking'] = 'Bekreft kansellering';
$string['courseresetsessions'] = 'Fjern alle avtaler';
$string['courseresetsignups'] = 'Fjern alle reservasjoner';
$string['crontask'] = 'Vedlikeholdsjobb for Avtaler';
$string['currentstatus'] = 'Gjeldende status';
$string['customisednotifications'] = 'Egendefinerte meldinger';
$string['date'] = 'Dato';
$string['decidelater'] = 'Bestem senere';
$string['decline'] = 'Avslå';
$string['delete'] = 'Slett';
$string['deleteappointmentconfirm'] = 'Er du helt sikker på at du vil slette denne avtalen og alle påmeldinger?';
$string['deletesession'] = 'Slett økt';
$string['deletetimeframe'] = 'Slett tidsrammen';
$string['details'] = 'Detaljer';
$string['duplicate'] = 'Duplisér';
$string['duplicateappointment'] = 'Duplisér avtale';
$string['editingappointment'] = 'Endrer avtale';
$string['email:message'] = 'Melding';
$string['email:subject'] = 'Emne';
$string['emailmanager'] = 'Send varsel til leder';
$string['emailmanagercancellation'] = '# Send varsel til leder';
$string['emailmanagercancellation_help'] = 'Når "Send varsel til leder" er krysset av, vil det bli sendt en e-post til elevens leder som ber dem om at avbestillingen er kansellert.';
$string['emailmanagerconfirmation'] = '# Send varsel til leder';
$string['emailmanagerconfirmation_help'] = 'Når "Send varsel til leder" er krysset av, vil en bekreftelses-e-post bli sendt til elevens leder når eleven melder seg på en avtaleøkt.';
$string['emailmanagerreminder'] = '# Send varsel til leder';
$string['emailmanagerreminder_help'] = 'Når "Send varsel til leder" er krysset av, blir en påminnelsesmelding sendt til elevens leder noen dager før startdatoen for avtalsøkten.';
$string['empty'] = 'Tom';
$string['endtime'] = 'Slutt-tid';
$string['entitiysession'] = 'Økt';
$string['error:cancellationsnotallowed'] = 'Du har ikke lov til å kansellere denne registreringen.';
$string['error:canttakeattendanceforunstartedsession'] = 'Kan ikke delta på en økt som ennå ikke har startet.';
$string['error:eventoccurred'] = 'Du kan ikke avbryte en begivenhet som allerede har skjedd.';
$string['error:invaliduserid'] = 'Ugyldig bruker-ID';
$string['error:manageremailaddressmissing'] = 'Du er for øyeblikket ikke tilordnet en leder i systemet. Kontakt nettstedets administrator.';
$string['error:sessionstartafterend'] = 'Starttid for økten er etter sluttdatoen';
$string['errorcannoteditsessions'] = 'Du har ikke tillatelse til å redigere økter';
$string['errorcannotviewappointment'] = 'Du har ikke tillatelse til å se denne avtalen';
$string['errorcannotviewattendees'] = 'Du har ikke tillatelse til å se deltakere';
$string['eventaddsession'] = 'Økten lagt til';
$string['eventapproverequests'] = 'Forespørselsgodkjenninger for økten';
$string['eventattendancetaken'] = 'Øktoppmøte tatt';
$string['eventattendeesviewed'] = 'Møtedeltakere sett';
$string['eventcancelbooking'] = 'Økten avbryter bestillingen';
$string['eventcourseappointmentviewed'] = 'Forekomster av kursavtalen sett';
$string['eventcoursemoduleviewed'] = 'Avtalemodulforekomst sett';
$string['eventdeletesession'] = 'Økt slettet';
$string['eventsignup'] = 'Øktpåmelding';
$string['eventupdatesession'] = 'Økten oppdatert';
$string['full'] = 'Datoen er fullt okkupert';
$string['fullfilter'] = 'Fullt';
$string['fullybooked'] = 'Ingen ledige plasser';
$string['goback'] = 'Tilbake';
$string['icalendarheading'] = 'iCalendar vedlegg';
$string['joinwaitlist'] = 'Bli med på venteliste';
$string['location'] = 'Plassering';
$string['managecustomfields'] = 'Administrer tilpassede felt';
$string['modulename'] = 'Avtalereservering';
$string['modulename_link'] = 'Appointments';
$string['modulenameplural'] = 'Avtaler';
$string['multipleappointments'] = 'Multiple avtaler';
$string['noremindersneedtobesent'] = 'Ingen påminnelser trenger å bli sent.';
$string['nosignedupusers'] = 'Ingen brukere har registrert seg for denne økten.';
$string['notset'] = 'Ikke satt';
$string['notsignedup'] = 'Du er ikke registrert på denne økten.';
$string['partiallyfull'] = 'Delvis full';
$string['placeholder:alldates'] = '[alldates]';
$string['placeholder:appointmentname'] = '[appointmentname]';
$string['placeholder:attendeeslink'] = '[attendeeslink]';
$string['placeholder:details'] = '[details]';
$string['placeholder:finishtime'] = '[finishtime]';
$string['placeholder:firstname'] = '[firstname]';
$string['placeholder:lastname'] = '[lastname]';
$string['placeholder:reminderperiod'] = '[reminderperiod]';
$string['placeholder:sessiondate'] = '[sessiondate]';
$string['placeholder:starttime'] = '[starttime]';
$string['placeholdersdesc'] = 'Plassholdere';
$string['placeholdersdesc_help'] = 'Plassholdere lar deg legge til et dynamisk innhold, f.eks. Plassholderen [fornavn] vil bli erstattet med et brukerfornavn i varselet som leveres til brukeren.';
$string['pluginadministration'] = 'Avtaleadministrasjon';
$string['pluginname'] = 'Avtale';
$string['potentialattendees'] = 'Mulige deltakere';
$string['privacy:metadata:appointment_signups'] = 'Brukerpåmeldinger til avtaleøkter';
$string['privacy:metadata:appointment_signups:id'] = 'IDen til påmeldingen';
$string['privacy:metadata:appointment_signups:mailedreminder'] = 'Tidspunkten en påminnelse sist ble sendt';
$string['privacy:metadata:appointment_signups:sessionid'] = 'SesjonsID-en';
$string['privacy:metadata:appointment_signups_status'] = 'Status for en brukerpåmelding til en økt';
$string['privacy:metadata:appointment_signups_status:grade'] = 'Karakteren tildelt for å delta på økten';
$string['privacy:metadata:appointment_signups_status:note'] = 'Lagrer årsaken til en avbrutt økt';
$string['privacy:metadata:appointment_signups_status:signupid'] = 'IDen til påmeldingen';
$string['privacy:metadata:appointment_signups_status:statuscode'] = 'Status for påmeldingen f.eks. Kansellert, avslått, deltatt fullt ut';
$string['privacy:metadata:appointment_signups_status:timecreated'] = 'Tidspunktet for når påmeldingen ble gjort';
$string['privacy:metadata:userid'] = 'IDen til brukeren som fikk tilgang til avtaleaktiviteten';
$string['remindermessage'] = 'Påminnelsestekst';
$string['remindermessage_help'] = 'Denne meldingen er sendt ut et par dager før en økts startdato.';
$string['reminderperiod'] = 'Dager før melding blir sendt';
$string['reminderperiod_help'] = 'Påminnelsen vil bli sendt så mange dager før starten av økten.';
$string['requestmessage'] = 'Be om melding';
$string['requestmessage_help'] = 'Når ** Godkjenning kreves ** er aktivert, er delen ** Forespørsel ** tilgjengelig.

Delen ** Forespørsel ** viser meldingene som er sendt til eleven og deres leder angående godkjenningsprosessen for at eleven skal delta på økten.

** Emne: ** er emnelinjen som vises i e-postmeldingene til forespørsel om godkjenning som sendes til lederen og eleven.

** Melding: ** er e-postteksten som er sendt til eleven som ber dem om at deres forespørsel om å delta på økten er sendt til lederen deres for godkjenning.

** Varsel for leder: ** er e-postteksten sendt til elevens leder som ber om godkjenning for å delta på økten.';
$string['requeststablesummary'] = 'Brukere som ba om å delta på denne økten.';
$string['room'] = 'Rom';
$string['saveattendance'] = 'Lagre deltakelse';
$string['search:activity'] = 'Avtaleaktiviteter';
$string['seatsavailable'] = 'Ledige plasser';
$string['seatsbooked'] = 'Reserverte plasser';
$string['sessionavailability'] = 'Økt tilgjengelighet';
$string['sessiondatetime'] = 'Dato/Tid for økten';
$string['sessiondescription'] = 'Beskrivelse';
$string['sessionduration'] = 'Varighet';
$string['sessionfinished'] = 'Ferdig';
$string['sessionfinishtime'] = 'Øktens slutt-tid';
$string['sessioninprogress'] = 'Økten pågår';
$string['sessionisfull'] = 'Denne økten er nå full. Du må velge en annen tid eller snakke med instruktøren.';
$string['sessionnotstarted'] = 'Ikke startet';
$string['sessionrequiresmanagerapproval'] = 'Denne økten krever godkjenning av lederen';
$string['sessions'] = 'Økter';
$string['sessionsdetailstablesummary'] = 'Full beskrivelse av gjeldende økt.';
$string['sessionstartdate'] = 'Øktens startdato';
$string['sessionstartdateandtime'] = '{$a->startdate}, {$a->starttime} - {$a->endtime} (time zone: {$a->timezone})';
$string['sessionstartdateandtimewithouttimezone'] = '{$a->startdate}, {$a->starttime} - {$a->endtime}';
$string['sessionstartfinishdateandtime'] = '{$a->startdate} - {$a->enddate}, {$a->starttime} - {$a->endtime} (tidssone: {$a->timezone})';
$string['sessionstartfinishdateandtimewithouttimezone'] = '{$a->startdate} - {$a->enddate}, {$a->starttime} - {$a->endtime}';
$string['sessionstarttime'] = 'Økten starter';
$string['sessionstatus'] = 'Sesjonsstatus';
$string['setting:defaultcancellationmessagedefault'] = 'Dette er til orientering: Din avtaleregistrering er nå kansellert: <br><br>
***RESERVASJON KANSELLERT*** <br><br>
Deltaker:   [firstname] [lastname] <br>
Avtale:   [appointmentname] <br><br>
Dato(er): <br>
[alldates] <br><br>
Sted:   [session:location]<br>
Hvor:   [session:venue]<br>
Rom:   [session:room]';
$string['setting:defaultcancellationsubjectdefault'] = 'Kansellering av avtalereservasjon';
$string['setting:defaultconfirmationmessagedefault'] = 'Dette for å bekrefte at du nå er booket til følgende avtale:
<br><br>
Deltaker:   [firstname] [lastname]<br>
Avtale:   [appointmentname]<br><br>

Dato(er):<br>
[alldates]<br><br>

Sted:   [session:location]<br>
Hvor:   [session:venue]<br>
Rom:   [session:room]<br><br>

***Vennligst kom ti minutter før avtalen starter***<br><br>

Å planlegge eller avbestille reservasjonen din:<br>
For å gjøre om reservasjonen din må du først avbryte denne bestillingen og deretter bestille en ny økt. <br>
For å avbryte bestillingen din, gå tilbake til reservasjonssiden og velg deretter Avbryt.<br><br>

[details]<br><br>

Du vil motta en påminnelse [reminderperiod] virkedager før denne avtalen.<br><br>';
$string['setting:defaultconfirmationsubjectdefault'] = 'Avtalebekreftelse: [appointmentname], [starttime]-[finishtime], [sessiondate]';
$string['setting:defaultremindermessagedefault'] = 'Dette er en påminnelse om at du er påmeldt følgende avtale:
<br><br>
Deltaker:   [firstname] [lastname]<br>
Avtale:   [appointmentname]<br><br>

Dato(er):<br>
[alldates]<br><br>

Sted:   [session:location]<br>
Hvor:   [session:venue]<br>
Rom:   [session:room]<br><br>

*** Vennligst kom ca 10 minutter før avtalen starter***<br><br>

For å endre eller kansellere bestillingen<br>
For å endre eller kansellere bestillingen må fu først kansellere denne avtalen og deretter reservere deg på en ny. <br>
For å kansellere går du til avtale-siden og velger "Avbryt".<br><br>

[details]';
$string['setting:defaultremindersubjectdefault'] = 'Avtalebooking påminnelse:  [appointmentname], [starttime]-[finishtime], [sessiondate]';
$string['setting:defaultrequestmessagedefault'] = 'Din forespørsel om å bestille på følgende avtale er sendt til lederen din:

Deltaker:   [firstname] [lastname]
Avtale:   [appointmentname]

Dato(er):
[alldates]

Sted:   [session:location]
Hvor:   [session:venue]
Rom:   [session:room]';
$string['setting:defaultrequestsubjectdefault'] = 'Avtalebooking forespørsel: [appointmentname], [starttime]-[finishtime]';
$string['setting:defaultupdatemessagedefault'] = 'Dette er for å informere deg om at avtalen du har bestilt eller ble med på venteliste, har endret seg:<br><br>
Deltaker: [fornavn] [etternavn]<br>
Avtale: [avtalenavn]<br><br>
Dato(er):<br>
[alldates]<br><br>
Sted: [session:location]<br>
Sted: [session:venue]<br>
Rom: [session:room]<br><br>
***Vær oppmerksom på at dette ikke er en bekreftelse på avtalebestilling***<br><br>
For å kansellere din bestilling eller plass på venteliste, gå tilbake til avtalesiden og velg "Avbryt".<br><br>
[detaljer]<br><br>';
$string['setting:defaultupdatesubjectdefault'] = 'Avtaleoppdatering: [appointmentname], [starttime]-[finishtime], [sessiondate]';
$string['setting:defaultwaitlistedmessagedefault'] = 'Dette er for å informere om at du er lagt til i ventelisten for:<br><br>
Avtale:   [appointmentname]<br>
Sted:  [session:location]<br>
Deltaker:   [firstname] [lastname]<br><br>

*** Vær oppmerksom på at dette ikke er en bestillingsbekreftelse ***<br><br>

Ved venteliste har du registrert din interesse for denne avtalen og vil bli kontaktet direkte når økter blir tilgjengelige.<br><br>

For å fjerne deg selv fra denne ventelisten, vennligst gå tilbake til denne avtalen og klikk Avbryt. <br><br>
Vær oppmerksom på at det ikke er noen bekreftelses-e-post for fjerning av venteliste.';
$string['setting:defaultwaitlistedsubjectdefault'] = 'Ventelisteinformasjon for [appointmentname]';
$string['setting:oneemailperday'] = 'Send separat e-post for hver dag i hendelser som strekker seg over flere dager';
$string['setting:oneemailperday_caption'] = 'Egne melding for hver dag';
$string['settings'] = 'Innstillinger';
$string['shortname'] = '# Kort navn';
$string['shortname_help'] = '** Kort navn ** er beskrivelsen av økten som vises i kalenderen når ** Vis i kalenderen ** er aktivert.';
$string['showoncalendar'] = 'Visningsinnstillinger for kalender';
$string['showoncalendar_help'] = 'Når ** Portal ** er valgt, vil avtaleaktivitetsøktene vises i portalkalenderen som et globalt arrangement. Alle portalbrukere vil kunne se disse øktene.

Når ** Kurs ** er valgt, vil alle avtaleaktivitetsøktene vises i kurskalenderen og som Kursbegivenhet på stedskalenderkalenderen og synlige for alle brukere som er registrert i kurset.

Når ** Ingen ** er valgt, vil avtaleaktivitetsøkter bare vises som brukerhendelser i en bekreftet deltakers kalender, forutsatt at alternativet ** Vis i brukerens kalender ** er valgt.';
$string['sign-ups'] = 'Registreringer';
$string['signupforthissession'] = 'Registrer deg på denne avtale-økten';
$string['split'] = 'Automatisk deling';
$string['split_help'] = 'Denne innstillingen definerer varigheten til hver økt opprettet innen tidsrammen. Hvis du setter den til 0, deaktiveres alternativet.';
$string['status'] = 'Status';
$string['status_approved'] = 'Godkjent';
$string['status_booked'] = 'Reservert';
$string['status_declined'] = 'Avslått';
$string['status_fully_attended'] = 'Full deltakelse';
$string['status_no_show'] = 'Ikke møtt';
$string['status_partially_attended'] = 'Delvis deltakelse';
$string['status_requested'] = 'Forespurt';
$string['status_user_cancelled'] = 'Bruker avbrutt';
$string['status_waitlisted'] = 'Satt på venteliste';
$string['suppressemail'] = 'Undertrykk e-postvarsling';
$string['suppressemail_help'] = 'Bruk dette alternativet hvis du vil legge til / fjerne brukere fra en avtaleøkt. Når dette alternativet er slått på, blir den vanlige e-postbekreftelse ikke sendt til de valgte brukerne.';
$string['takeattendance'] = 'Registrer fremmøte';
$string['thirdpartyemailaddress'] = 'Tredjeparts e-postadresse(r)';
$string['thirdpartyemailaddress_help'] = '** Tredjeparts e-postadresse (r) ** er et valgfritt felt som brukes til å spesifisere e-postadressen til en tredjepart (for eksempel en ekstern instruktør) som deretter vil motta bekreftelsesmeldinger når en bruker registrerer seg for en økt.
Når du skriver inn ** flere e-postadresser **, skiller du hver adresse med komma. For eksempel: bob@example.com, joe@example.com';
$string['thirdpartywaitlist'] = 'Gi beskjed til tredjepart om ventelistede økter';
$string['thirdpartywaitlist_help'] = 'Når ** Varsle tredjepart om ventelistede økter ** er valgt, vil tredjepart (e) bli varslet når en elev registrerer seg for en ventelist økt. Når

** Varsle tredjepart om ventelistede økter ** er ikke aktivert Tredjeparts (e) vil bare bli varslet når en bruker registrerer seg (eller avbryter) for en planlagt økt.';
$string['timecancelled'] = 'Tid kansellert';
$string['timeframes'] = 'Tidsrammer';
$string['timerequested'] = 'Tid forespurt';
$string['timesignedup'] = 'Tid registrert';
$string['timestart'] = 'Starttidspunkt';
$string['unapprovedrequests'] = 'Ikke-godkjente forespørsler';
$string['unknowndate'] = '(ukjent dato)';
$string['unknowntime'] = '(ukjent tid)';
$string['updatemessage'] = 'Oppdater melding';
$string['updatemessage_help'] = 'Denne meldingen sendes ut hver gang sesjonen endres.';
$string['usercalentry'] = 'Vis oppføring i brukerens kalender';
$string['usercancelledon'] = 'Bruker avbestilte {$a}';
$string['usernotsignedup'] = 'Status: Ikke registrert';
$string['usersignedup'] = 'Status: Registert';
$string['usersignedupon'] = 'Bruker registrerte seg {$a}';
$string['venue'] = 'Sted';
$string['waitlistedat'] = '<strong>Satt på venteliste:</strong> {$a}';
$string['waitlistedmessage'] = 'Ventelistemelding';
$string['waitlistedmessage_help'] = 'Denne meldingen sendes ut hver gang en bruker setter seg på ventelsiten.';
