<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'workshop', language 'mn', version '4.4'.
 *
 * @package     workshop
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['activitydate:assessmentsclose'] = 'Үнэлгээ хаах:';
$string['activitydate:assessmentsclosed'] = 'Үнэлгээ хаагдсан хугацаа:';
$string['activitydate:assessmentsopen'] = 'Үнэлгээ нээх:';
$string['activitydate:assessmentsopened'] = 'Үнэлгээ нээгдсэн хугацаа:';
$string['activitydate:submissionsclose'] = 'Материал хүлээн авахыг хаах:';
$string['activitydate:submissionsclosed'] = 'Материал хүлээн авч дууссан хугацаа:';
$string['activitydate:submissionsopen'] = 'Материал хүлээн авч эхлэх:';
$string['activitydate:submissionsopened'] = 'Материал хүлээн авч эхэлсэн хугацаа:';
$string['aggregategrades'] = 'Дүнг дахин тооцоолох';
$string['aggregation'] = 'Дүнгийн нэгтгэл';
$string['allocate'] = 'Материалуудыг хуваарилах';
$string['allocatedetails'] = 'хүлээгдэж буй: {$a->expected}<br />ирүүлсэн: {$a->submitted}<br />хуваарилах: {$a->allocate}';
$string['allocation'] = 'Илгээсэн материалын хуваарилалт';
$string['allocationconfigured'] = 'Хуваарилалтыг тохируулсан';
$string['allocationdone'] = 'Хуваарилж дууссан';
$string['allocationerror'] = 'Хуваарилалтын алдаа';
$string['allowedfiletypesforoverallfeedback'] = 'Зөвлөмж файлын зөвшөөрөгдсөн төрөл';
$string['allowedfiletypesforoverallfeedback_help'] = 'Зөвлөмжид хавсаргаж болох файлын төрлүүдийг дараах мөрөнд жагсааснаар хязгаарлаж болно. Хэрэв талбар хоосон бол бүх төрлийн файлыг зөвшөөрнө.';
$string['allowedfiletypesforoverallfeedback_link'] = 'admin/tool/filetypes/index';
$string['allowedfiletypesforsubmission'] = 'Хавсаргах файлын зөвшөөрөгдсөн төрөл';
$string['allowedfiletypesforsubmission_help'] = 'Хавсаргаж болох файлын төрлүүдийг дараах мөрөнд жагсааснаар хязгаарлаж болно. Хэрэв талбар хоосон бол бүх төрлийн файлыг зөвшөөрнө.';
$string['allowedfiletypesforsubmission_link'] = 'admin/tool/filetypes/index';
$string['allsubmissions'] = 'Илгээсэн бүх  ({$a}) материалууд';
$string['alreadygraded'] = 'Аль хэдийн үнэлсэн';
$string['areaconclusion'] = 'Дүгнэлт бичвэр';
$string['areainstructauthors'] = 'Илгээх заавар';
$string['areainstructreviewers'] = 'Үнэлгээ хийх заавар';
$string['areaoverallfeedbackattachment'] = 'Ерөнхий зөвлөмжийн хавсралт';
$string['areaoverallfeedbackcontent'] = 'Ерөнхий зөвлөмжийн бичвэр';
$string['areasubmissionattachment'] = 'Илгээх хавсралтууд';
$string['areasubmissioncontent'] = 'Илгээх бичвэр';
$string['assess'] = 'Үнэлгээ хийх';
$string['assessedexample'] = 'Үнэлгээ өгсөн жишиг даалгавар';
$string['assessedsubmission'] = 'Үнэлгээ өгсөн ажил';
$string['assessingexample'] = 'Жишээ даалгаврыг үнэлж байна';
$string['assessingsubmission'] = 'Илгээсэн материалд үнэлгээ хийж байна';
$string['assessment'] = 'Үнэлгээ';
$string['assessmentby'] = '<a href="{$a->url}">{$a->name}</a>-аар';
$string['assessmentbyfullname'] = '{$a}-ийн үнэлгээ';
$string['assessmentbyyourself'] = 'Таны үнэлгээ';
$string['assessmentdeleted'] = 'Үнэлгээг чөлөөлсөн байна';
$string['assessmentend'] = 'Үнэлгээний эцсийн хугацаа';
$string['assessmentendbeforestart'] = 'Үнэлгээний огноо нээгдэхээс өмнө үнэлгээний эцсийн хугацааг заах боломжгүй';
$string['assessmentenddatetime'] = 'Үнэлгээний эцсийн хугацаа: {$a->daydatetime} ({$a->distanceday})';
$string['assessmentendevent'] = '{$a} үнэлгээний эцсийн хугацаа';
$string['assessmentform'] = 'Үнэлгээний маягт';
$string['assessmentofsubmission'] = '<a href="{$a->submissionurl}">{$a->submissiontitle}</a>-н <a href="{$a->assessmenturl}">Үнэлгээ</a>';
$string['assessmentreference'] = 'Жишиг үнэлгээ';
$string['assessmentreferenceconflict'] = 'Таны жишиг үнэлгээ өгсөн жишээ даалгаврыг үнэлэх боломжгүй.';
$string['assessmentreferenceneeded'] = 'Та жишиг үнэлгээ оруулахын тулд жишээ даалгаврыг үнэлэх хэрэгтэй. Үргэлжлүүлэх товч дарж даалгаврыг үнэлнэ үү.';
$string['assessments'] = 'Үнэлгээ';
$string['assessmentsettings'] = 'Үнэлгээний тохиргоо';
$string['assessmentstart'] = '-аас эхлэсэн үнэлгээнд хамаарна';
$string['assessmentstartdatetime'] = '{$a->daydatetime} ({$a->distanceday})-аас эхлэсэн үнэлгээнд хамаарна';
$string['assessmentstartevent'] = '{$a} (үнэлгээнд зориулж нээгдэнэ)';
$string['assessmentweight'] = 'Үнэлгээний жин';
$string['assignedassessments'] = 'Даалгасан ажлуудыг үнэлэх';
$string['assignedassessmentsnone'] = 'Танд даалгасан үнэлэх ажил байхгүй байна';
$string['backtoeditform'] = 'Засварлах маягт руу буцах';
$string['byfullname'] = '<a href="{$a->url}">{$a->name}</a>-аар';
$string['byfullnamewithoutlink'] = '{$a}-аар';
$string['calculategradinggrades'] = 'Үнэлгээний дүнг тооцоолох';
$string['calculategradinggradesdetails'] = 'хүлээгдэж буй: {$a->expected}<br />тооцоолсон: {$a->calculated}';
$string['calculatesubmissiongrades'] = 'Илгээсэн материалын дүнг тооцоолох';
$string['calculatesubmissiongradesdetails'] = 'хүлээгдэж буй: {$a->expected}<br />тооцоолсон: {$a->calculated}';
$string['chooseuser'] = 'Хэрэглэгч сонгох...';
$string['clearaggregatedgrades'] = 'Нэгтгэсэн бүх дүнг арилгах';
$string['clearaggregatedgrades_help'] = 'Илгээсэн материалын нэгтгэсэн дүн болон үнэлгээний дүнг шинэчилнэ. Та Үнэлгээний үе шатанд эдгээр дүнг эхнээс нь дахин тооцоолох боломжтой.';
$string['clearaggregatedgradesconfirm'] = 'Та илгээсэн материалын тооцоолсон дүн болон үнэлгээний дүнгүүдийг арилгахдаа итгэлтэй байна уу?';
$string['clearassessments'] = 'Үнэлгээг арилгах';
$string['clearassessments_help'] = 'Илгээсэн материалын тооцоолсон дүн болон үнэлгээний дүнг шинэчилнэ. Үнэлгээний маягтуудыг хэрхэн бөглсөн мэдээлэл хэвээр үлдэх боловч бүх хянагч нар үнэлгээний маягтыг дахин нээж, өгөгдсөн дүнг дахин хадгалж байж авна.';
$string['clearassessmentsconfirm'] = 'Та бүх үнэлгээний дүнг арилгахдаа итгэлтэй байна уу? Та өөр дээрээ мэдээлэл авах боломжгүй болно, хянагч  нар тараасан материалыг дахин үнэлэх хэрэгтэй болно.';
$string['conclusion'] = 'Дүгнэлт';
$string['conclusion_help'] = 'Үйл ажиллагааны эцэст оролцогчдод дүгнэлт бичвэр харагдана.';
$string['configexamplesmode'] = 'Семинарын туршилт үнэлгээний өгөгдмөл горим';
$string['configgrade'] = 'Семинарын материалд өгөх онооны дээд хэмжээ';
$string['configgradedecimals'] = 'Дүн харуулах үеийн аравтын бутархайн орны цифрийн өгөгдмөл тоо';
$string['configgradinggrade'] = 'Семинарын үнэлгээнд өгөх онооны дээд хэмжээ';
$string['configmaxbytes'] = 'Сайт дээрх бүх семинарт үзүүлэх файлын үндсэн хамгийн их хэмжээ (курсын хязгаар болон бусад дотоод тохиргооны нөхцөлд)';
$string['configstrategy'] = 'Семинарыг дүгнэх өгөгдмөл стратеги';
$string['createsubmission'] = 'Материал нэмэх';
$string['crontask'] = 'Семинар модульд зориулсан суурь боловсруулалт';
$string['daysago'] = '{$a} өдрийн өмнө';
$string['daysleft'] = '{$a} өдөр үлдсэн';
$string['daystoday'] = 'өнөөдөр';
$string['daystomorrow'] = 'маргааш';
$string['daysyesterday'] = 'өчигдөр';
$string['deadlinesignored'] = 'Цагийн хязгаар танд нөлөөлөхгүй';
$string['deletesubmission'] = 'Материал устгах';
$string['editassessmentform'] = 'Үнэлгээний маягтыг засварлах';
$string['editassessmentformstrategy'] = '({$a}) үнэлгээний маягтыг засварлах';
$string['editingassessmentform'] = 'Үнэлгээний маягтыг засварлах';
$string['editingsubmission'] = 'Илгээсэн материалыг засварлаж байна';
$string['editsubmission'] = 'Илгээсэн материалыг засварлах';
$string['err_multiplesubmissions'] = 'Энэ маягтыг засварлахад, илгээсэн материалын өөр хувилбар хадгалагдсан байна. Нэг хэрэглэгч олон материал илгээх боломжгүй.';
$string['err_removegrademappings'] = 'Ашиглагдаагүй дүнгийн зураглалуудыг устгах боломжгүй байна';
$string['evaluategradeswait'] = 'Үнэлгээг дүгнэж дүнг тооцоолох хүртэл хүлээнэ үү';
$string['evaluation'] = 'Үнэлгээ гаргаж байна';
$string['evaluationmethod'] = 'Үнэлгээг дүгнэх арга';
$string['evaluationmethod_help'] = 'Үнэлгээ гаргах аргаар үнэлгээний дүнг хэрхэн тооцоолохыг тодорхойлно. Та гарсан дүнд сэтгэл хангалуун биш бол өөр тохиргоогоор дүнгүүдийг дахин давтан тооцоолж болно.';
$string['evaluationsettings'] = 'Үнэлгээг дүгнэх тохиргоо';
$string['eventassessableuploaded'] = 'Илгээсэн материалыг байршуулсан байна.';
$string['eventassessmentevaluated'] = 'Үнэлгээг дүгнэсэн';
$string['eventassessmentevaluationsreset'] = 'Үнэлгээний дүнг';
$string['eventassessmentreevaluated'] = 'Үнэлгээг дахин үнэлсэн';
$string['eventphaseautomaticallyswitched'] = 'Автоматаар үе шат шилжсэн';
$string['eventphaseswitched'] = 'Үе шат шилжсэн';
$string['eventsubmissionassessed'] = 'Илгээсэн материалд үнэлгээ хийсэн';
$string['eventsubmissionassessmentsreset'] = 'Илгээсэн материалын үнэлгээг арилгасан';
$string['eventsubmissioncreated'] = 'Илгээх материал үүсгэсэн';
$string['eventsubmissiondeleted'] = 'Илгээсэн материал устсан';
$string['eventsubmissionreassessed'] = 'Илгээсэн материалд дахин үнэлгээ хийсэн';
$string['eventsubmissionupdated'] = 'Илгээсэн материалыг шинэчилсэн';
$string['eventsubmissionviewed'] = 'Илгээсэн материалыг үзсэн';
$string['example'] = 'Жишээ материал';
$string['exampleadd'] = 'Жишээ материал нэмэх';
$string['exampleassess'] = 'Жишээ материалыг үнэлэх';
$string['exampleassessments'] = 'Үнэлэх жишээ материал';
$string['exampleassesstask'] = 'Жишээнүүдийг үнэлэх';
$string['exampleassesstaskdetails'] = 'хүлээгдэж буй: {$a->expected}<br />үнэлсэн: {$a->assessed}';
$string['examplecomparing'] = 'Жишээ материалын үнэлгээг харьцуулж байна';
$string['exampledelete'] = 'Жишээг устгах';
$string['exampledeleteconfirm'] = 'Та дараах жишээ материалыг устгахдаа итгэлтэй байна уу? \'Үргэлжлүүлэх\' товчийг дарж материалыг устгана.';
$string['exampleedit'] = 'Жишээг засварлах';
$string['exampleediting'] = 'Жишээг засварлаж байна';
$string['exampleneedassessed'] = 'Та эхлээд бүх жишээ материалыг үнэлэх хэрэгтэй';
$string['exampleneedsubmission'] = 'Та эхлээд өөрийн ажлаа илгээгээд бүх жишээ материалыг үнэлэх хэрэгтэй';
$string['examplesbeforeassessment'] = 'Өөрийн материалыг илгээсний дараа жишээ материал гарч ирэх бөгөөд чацуутны үнэлгээ хийгдэхийн өмнө үнэлсэн байх ёстой';
$string['examplesbeforesubmission'] = 'Өөрийн материалаа илгээхийн өмнө жишээнүүдийг үнэлэх ёстой';
$string['examplesmode'] = 'Жишээ үнэлгээний горим';
$string['examplesubmissions'] = 'Жишээ материалууд';
$string['examplesvoluntary'] = 'Жишээ материалыг үнэлэх эсэх нь сайн дурын үндсэн дээр хийгдэнэ';
$string['exportsubmission'] = 'Энэ хуудсыг экспортлох';
$string['feedbackauthor'] = 'Зохиогчид зориулсан зөвлөмж';
$string['feedbackauthorattachment'] = 'Хавсралт';
$string['feedbackby'] = 'Зөвлөмж өгсөн {$a}';
$string['feedbackreviewer'] = 'Хянагчид өгөх зөвлөмж';
$string['feedbacksettings'] = 'Зөвлөмж';
$string['formataggregatedgrade'] = '{$a->grade}';
$string['formataggregatedgradeover'] = '<del>{$a->grade}</del><br /><ins>{$a->over}</ins>';
$string['formatpeergrade'] = '<span class="grade">{$a->grade}</span> <span class="gradinggrade">({$a->gradinggrade})</span>';
$string['formatpeergradeover'] = '<span class="grade">{$a->grade}</span> <span class="gradinggrade">(<del>{$a->gradinggrade}</del> / <ins>{$a->gradinggradeover}</ins>)</span>';
$string['formatpeergradeoverweighted'] = '<span class="grade">{$a->grade}</span> <span class="gradinggrade">(<del>{$a->gradinggrade}</del> / <ins>{$a->gradinggradeover}</ins>)</span> @ <span class="weight">{$a->weight}</span>';
$string['formatpeergradeweighted'] = '<span class="grade">{$a->grade}</span> <span class="gradinggrade">({$a->gradinggrade})</span> @ <span class="weight">{$a->weight}</span>';
$string['givengrades'] = 'Өгсөн дүн';
$string['grade_grading_name'] = 'Үнэлгээ';
$string['grade_submission_name'] = 'Материал';
$string['gradecalculated'] = 'Илгээсэн материалын тооцоолсон дүн';
$string['gradedecimals'] = 'Дүнгийн аравтын бутархайн орон';
$string['gradegivento'] = '&gt;';
$string['gradeinfo'] = 'Дүн: {$a->max}-аас {$a->received}';
$string['gradeitemassessment'] = '{$a->workshopname} (assessment)';
$string['gradeitemsubmission'] = '{$a->workshopname} (submission)';
$string['gradeover'] = 'Илгээсэн материалын дүнг дахин өгөх';
$string['gradereceivedfrom'] = '&lt;';
$string['gradesreport'] = 'Семинар ажлын дүнгийн тайлан';
$string['gradetopassgrading'] = 'Үнэлгээний тэнцэх оноо';
$string['gradetopasssubmission'] = 'Материалын тэнцэх оноо';
$string['gradinggrade'] = 'Үнэлгээний оноо';
$string['gradinggrade_help'] = 'Энэ тохиргоо нь илгээсэн материалд өгч болох хамгийн их оноог тодорхойлно.';
$string['gradinggradecalculated'] = 'Үнэлгээний тооцоолсон дүн';
$string['gradinggradeof'] = 'Үнэлгээний дүн ({$a})';
$string['gradinggradeover'] = 'Үнэлгээний дүнг дахин өгөх';
$string['gradingsettings'] = 'Дүгнэх тохиргоо';
$string['groupnoallowed'] = 'Танд энэ семинар ажлын аль ч бүлэгт нэвтрэх эрх олгогдоогүй байна';
$string['iamsure'] = 'Тийм, би итгэлтэй байна';
$string['indicator:cognitivedepth'] = 'Танин мэдэхүйн семинар';
$string['indicator:cognitivedepth_help'] = 'Энэ үзүүлэлт нь Семинар үйл ажиллагаанд оролцож буй суралцагчдын хүрсэн танин мэдэхүйн түвшинд үндэслэнэ.';
$string['indicator:cognitivedepthdef'] = 'Танин мэдэхүйн семинар';
$string['indicator:cognitivedepthdef_help'] = 'Оролцогч нь энэхүү шинжилгээний интервалын хугацаанд Семинар үйл ажиллагаанаас санал болгож буй танин мэдэхүйн оролцооны энэ хувь хэмжээнд хүрсэн байна (Түвшин = Харах боломжгүй, Харах, Илгээх, Зөвлөмж харах, Зөвлөмжийн талаар сэтгэгдэл бичих, Зөвлөмжийг үзсэний дараа дахин илгээх)';
$string['indicator:cognitivedepthdef_link'] = 'Learning_analytics_indicators#Cognitive_depth';
$string['indicator:socialbreadth'] = 'Нийгмийн семинар';
$string['indicator:socialbreadth_help'] = 'Энэ үзүүлэлт нь Семинар үйл ажиллагаанд оролцож буй суралцагчдын хүрсэн нийгмийн оролцооны түвшинд үндэслэнэ.';
$string['indicator:socialbreadthdef'] = 'Нийгмийн семинар';
$string['indicator:socialbreadthdef_help'] = 'Оролцогч нь энэхүү шинжилгээний интервалын хугацаанд Семинар үйл ажиллагаанаас санал болгож буй нийгмийн оролцооны энэ хувь хэмжээнд хүрсэн байна (Түвшин = оролцоогүй, ганцаараа оролцогч, бусадтай хамтран оролцогч)';
$string['indicator:socialbreadthdef_link'] = 'Learning_analytics_indicators#Social_breadth';
$string['info'] = 'Мэдээлэл';
$string['instructauthors'] = 'Материал илгээх заавар';
$string['instructreviewers'] = 'Үнэлгээ хийх заавар';
$string['introduction'] = 'Тодорхойлолт';
$string['latesubmissions'] = 'Хоцорсон материал';
$string['latesubmissions_desc'] = 'Эцсийн хугацааны дараа өгсөн материалыг зөвшөөрнө';
$string['latesubmissions_help'] = 'Хэрэв идэвхжүүлсэн бол зохиогч нь өөрийн ажлыг материал илгээх сүүлийн хугацааны дараа эсвэл үнэлгээний үе шатын үеэр илгээж болно. Хугацаанаас хоцорч илгээсэн материалыг засварлах боломжгүй байх юм.';
$string['latesubmissionsallowed'] = 'Хугацаа хоцорч илгээхийг зөвшөөрнө';
$string['maxbytes'] = 'Илгээх материалын хавсралт файлын хамгийн их хэмжээ';
$string['modulename'] = 'Семинар';
$string['modulename_help'] = 'Семинар үйл ажиллагааны модуль нь суралцагчдын ажлыг цуглуулах, хянах болон чацуутны үнэлгээ хийх боломжтой олгодог.

Суралцагч нь бичвэр баримт эсвэл хүснэгт зэрэг дижитал агуулгыг (файлууд) оруулж болох ба бичвэр засварлагч ашиглан талбарт нь шууд бичвэрээ бичиж илгээж болно.

Илгээсэн материалуудыг багшийн тодорхойлсон олон-шалгуурт үнэлгээний маягт ашиглан дүгнэнэ. Чацуутны үнэлгээ хэрхэн хийх болон үнэлгээний маягтыг ойлгохын тулд суралцагч багшийн оруулсан жишээ материал болон жишиг үнэлгээний зааврыг ашиглан туршилт хийж болно. Суралцагчдад нэг эсвэл түүнээс олон материалд үнэлгээ хийх боломж олгож болно. Хэрэв шаардлагатай бол материал илгээгч болон үнэлгээ өгөгчийн нэрийг нууцалж болно.

Семинар үйл ажиллагаанаас суралцагч хоёр дүн авах боломжтой - Өөрсдийн илгээсэн материалын дүн болон чацуутны үнэлгээ хийсэн дүн. Хоёр дүн хоёул дүнгийн дэвтэрт бичигдэнэ.';
$string['modulename_link'] = 'mod/workshop/view';
$string['modulenameplural'] = 'Семинар';
$string['myassessments'] = 'Миний үнэлгээ';
$string['mysubmission'] = 'Миний илгээсэн материал';
$string['nattachments'] = 'Хавсаргах ажлын хамгийн их тоо';
$string['noexamples'] = 'Энэ семинарт жишээ материал алга';
$string['noexamplesformready'] = 'Та жишээ материал оруулахаас өмнө үнэлгээний маягтыг тодорхойлох ёстой';
$string['nogradeyet'] = 'Одоогоор дүн байхгүй байна';
$string['nosubmissionfound'] = 'Энэ хэрэглэгчийн илгээсэн ямар нэг материал олдсонгүй';
$string['nosubmissions'] = 'Энэ семинарт хараахан материал ирээгүй байна';
$string['nosubmissiontype'] = 'Дор хаяж нэг материалын төрөл байх ёстой';
$string['notassessed'] = 'Үнэлгээ хийгдээгүй байна';
$string['nothingfound'] = 'Дэлгэцэнд харуулах зүйл алга байна';
$string['nothingtoreview'] = 'Хянах материал алга';
$string['notoverridden'] = 'Өөрчлөгдсөнгүй';
$string['noworkshops'] = 'Энэ хичээлд семинар алга байна';
$string['noyoursubmission'] = 'Та даалгавраа хараахан илгээгээгүй байна';
$string['nullgrade'] = '-';
$string['overallfeedback'] = 'Ерөнхий зөвлөмж';
$string['overallfeedbackfiles'] = 'Ерөнхий зөвлөмжид хамгийн ихдээ хавсаргаж болох файлын тоо';
$string['overallfeedbackmaxbytes'] = 'Ерөнхий зөвлөмжид хавсаргаж болох файлын хамгийн их хэмжээ';
$string['overallfeedbackmode'] = 'Ерөнхий зөвлөмжийн горим';
$string['overallfeedbackmode_0'] = 'Идэвхгүй';
$string['overallfeedbackmode_1'] = 'Идэвхтэй ба сонголтоор';
$string['overallfeedbackmode_2'] = 'Идэвхтэй ба шаардана';
$string['overallfeedbackmode_help'] = 'Хэрэв идэвхжүүлсэн бол, бичвэр талбар нь үнэлгээний маягтын доор харагдана. Шүүмжлэгч нь илгээсэн материалд ерөнхий үнэлгээ тавих эсвэл үнэлгээний нэмэлт тайлбарыг оруулж болно.';
$string['page-mod-workshop-x'] = 'Семинар модулын дурын хуудас';
$string['participant'] = 'Оролцогч';
$string['participantrevierof'] = 'Энэ оролцогчийн шүүмжилсэн нь';
$string['participantreviewedby'] = 'Оролцогчид шүүмж өгсөн';
$string['phaseassessment'] = 'Үнэлгээний шат';
$string['phaseclosed'] = 'Хаагдсан';
$string['phaseevaluation'] = 'Үнэлгээг дүгнэх үе шат';
$string['phasesetup'] = 'Тохиргооны үе шат';
$string['phasesoverlap'] = 'Материал хүлээн авах үе шат болон үнэлгээний үе шат хоёр давхцах ёсгүй';
$string['phasesubmission'] = 'Материал хүлээн авах үе шат';
$string['pluginadministration'] = 'Семинарын зохицуулалт';
$string['pluginname'] = 'Семинар';
$string['prepareexamples'] = 'Жишээ материал бэлтгэх';
$string['previewassessmentform'] = 'Урьдчилан харах';
$string['privacy:metadata:aggregatedgradinggrade'] = 'Тухайн семинар үйл ажиллагаанд хэрэглэгчийн хийсэн бүх үнэлгээний нэгтгэсэн үнэлгээ';
$string['privacy:metadata:assessmentgrade'] = 'Энэ үнэлгээнээс санал болгосон материалын нэгтгэсэн үнэлгээ';
$string['privacy:metadata:assessmentgradinggrade'] = 'Энэ үнэлгээг хийсэн дүн';
$string['privacy:metadata:assessmentgradinggradeover'] = 'Энэ үнэлгээг хийсэн дүнгийн гараар өөрчилсөн утга';
$string['privacy:metadata:assessmentid'] = 'Үнэлгээний ID';
$string['privacy:metadata:authorid'] = 'Материал илгээсэн зохиогчийн ID';
$string['privacy:metadata:dimensiongrade'] = 'Өгсөн үнэлгээний хэмжүүр дэх үнэлгээ';
$string['privacy:metadata:dimensionid'] = 'Үнэлгээний хэмжүүрийн ID';
$string['privacy:metadata:example'] = 'Энэ бичлэг нь жишээ материалыг илэрхийлж байгаа эсэх';
$string['privacy:metadata:feedbackauthor'] = 'Зохиогчид өгөх зөвлөмж';
$string['privacy:metadata:feedbackauthorformat'] = 'Зохиогчид өгөх зөвлөмж бичвэрийн загвар';
$string['privacy:metadata:feedbackreviewer'] = 'Үнэлгээ оруулсан хэрэглэгчид өгөх зөвлөмж';
$string['privacy:metadata:feedbackreviewerformat'] = 'Үнэлгээ оруулсан хэрэглэгчид өгөх зөвлөмж бичвэрийн загвар';
$string['privacy:metadata:late'] = 'Материал нь хугацаа хоцорч илгээгдсэн эсэх';
$string['privacy:metadata:peercomment'] = 'Үнэлгээ оруулсан хэрэглэгчийн өгсөн дүнд тайлбар бичих';
$string['privacy:metadata:peercommentformat'] = 'Өгсөн дүнгийн талаарх тайлбар бичвэрийн загвар';
$string['privacy:metadata:preference:perpage'] = 'Хэрэглэгчдэд нэг хуудсанд харуулах материалын тоо';
$string['privacy:metadata:preference:viewlet-allexamples-collapsed'] = 'Жишээ материалын харагдах хэлбэрийн хураасан/дэлгэрэнгүй төлөв';
$string['privacy:metadata:preference:viewlet-allsubmissions-collapsed'] = 'Семинарын материалын тайлангийн харагдах хэлбэрийн хураасан/дэлгэрэнгүй төлөв';
$string['privacy:metadata:preference:viewlet-assessmentform-collapsed'] = 'Үнэлгээний маягтын харагдах хэлбэрийн хураасан/дэлгэрэнгүй төлөв';
$string['privacy:metadata:preference:viewlet-assignedassessments-collapsed'] = 'Үнэлүүлэхээр илгээсэн материалын харагдах хэлбэрийн хураасан/дэлгэрэнгүй төлөв';
$string['privacy:metadata:preference:viewlet-cleargrades-collapsed'] = 'Семинар хэрэгслийн харагдах хэлбэрийн хураасан/дэлгэрэнгүй төлөв';
$string['privacy:metadata:preference:viewlet-conclusion-collapsed'] = 'Дүгнэлтийн харагдах хэлбэрийн хураасан/дэлгэрэнгүй төлөв';
$string['privacy:metadata:preference:viewlet-examples-collapsed'] = 'Үнэлэх жишээ материалын харагдах хэлбэрийн хураасан/дэлгэрэнгүй төлөв';
$string['privacy:metadata:preference:viewlet-examplesfail-collapsed'] = 'Үнэлэх жишээ материалын харагдах хэлбэрийн хураасан/дэлгэрэнгүй төлөв';
$string['privacy:metadata:preference:viewlet-gradereport-collapsed'] = 'Семинарын дүнгийн тайлангийн харагдах хэлбэрийн хураасан/дэлгэрэнгүй төлөв';
$string['privacy:metadata:preference:viewlet-instructauthors-collapsed'] = 'Материал илгээх зааврын харагдах хэлбэрийн хураасан/дэлгэрэнгүй төлөв';
$string['privacy:metadata:preference:viewlet-instructreviewers-collapsed'] = 'Үнэлгээ хийх зааврын харагдах хэлбэрийн хураасан/дэлгэрэнгүй төлөв';
$string['privacy:metadata:preference:viewlet-intro-collapsed'] = 'Танилцуулгын харагдах хэлбэрийн хураасан/дэлгэрэнгүй төлөв';
$string['privacy:metadata:preference:viewlet-overallfeedback-collapsed'] = 'Ерөнхий зөвлөмжийн харагдах хэлбэрийн хураасан/дэлгэрэнгүй төлөв';
$string['privacy:metadata:preference:viewlet-ownsubmission-collapsed'] = 'Таны илгээсэн материалын харагдах хэлбэрийн хураасан/дэлгэрэнгүй төлөв';
$string['privacy:metadata:preference:viewlet-publicsubmissions-collapsed'] = 'Нийтэлсэн материалын харагдах хэлбэрийн хураасан/дэлгэрэнгүй төлөв';
$string['privacy:metadata:preference:viewlet-yourgrades-collapsed'] = 'Таны дүнгийн харагдах хэлбэрийн хураасан/дэлгэрэнгүй төлөв';
$string['privacy:metadata:published'] = 'Семинар хаагдахад бүх оролцогчдод илгээсэн материалыг нийтэлж харуулах эсэх';
$string['privacy:metadata:reviewerid'] = 'Үнэлгээ оруулсан хэрэглэгчийн ID';
$string['privacy:metadata:strategy'] = 'Бичлэгийн утгыг тайлбарлах үнэлгээний стратегийн дэд нэмэлт хэрэгслийн нэр';
$string['privacy:metadata:submissioncontent'] = 'Илгээсэн материалын агуулга';
$string['privacy:metadata:submissioncontentformat'] = 'Илгээсэн материалын агуулгын бичвэрийн загвар';
$string['privacy:metadata:submissiongrade'] = '0..100 интервалаас аравтын бутархай хэлбэрээр бичигдсэн материалын нэгдсэн үнэлгээ';
$string['privacy:metadata:submissiongradeover'] = 'Нэгдсэн үнэлгээний гараар өөрчилсөн утга';
$string['privacy:metadata:submissionid'] = 'Илгээсэн материалын ID';
$string['privacy:metadata:submissiontitle'] = 'Илгээсэн материалын гарчиг';
$string['privacy:metadata:subsystem:corefiles'] = 'Семинар модуль нь бичвэр материалд эмбэд хийгдсэн / хавсаргасан файлуудыг хадгалдаг';
$string['privacy:metadata:subsystem:coreplagiarism'] = 'Семинар модуль нь зохиолын хулгайн гэмт хэргээс урьдчилан сэргийлэх системийг дэмждэг';
$string['privacy:metadata:timeaggregated'] = 'Нэгдсэн дүнг сүүлд тооцоолсон хугацаа';
$string['privacy:metadata:timecreated'] = 'Өгөгдлийн санд бичлэг үүссэн хугацаа';
$string['privacy:metadata:timemodified'] = 'Өгөгдлийн санд сүүлд бичлэг өөрчлөгдсөн хугацаа';
$string['privacy:metadata:userid'] = 'Нэгдсэн дүн нь тооцогдсон хэрэглэгчийн ID';
$string['privacy:metadata:weight'] = 'Үнэлгээний жин';
$string['privacy:metadata:workshopaggregations'] = 'Үнэлгээний нэгдсэн дүнг агуулдаг';
$string['privacy:metadata:workshopassessments'] = 'Семинар модулийн материалд хуваарилагдсан үнэлгээний талаарх мэдээллийг агуулдаг';
$string['privacy:metadata:workshopgrades'] = 'Үнэлгээний маягтыг үнэлгээ, тайлбараар хэрхэн бөглөсөн талаарх мэдээллийг агуулдаг';
$string['privacy:metadata:workshopid'] = 'Семинар үйл ажиллагааны ID';
$string['privacy:metadata:workshopsubmissions'] = 'Семинар модулийн материалуудын талаарх мэдээллийг агуулдаг';
$string['privacy:request:delete:content'] = 'Агуулга (хэрэглэгчийн хүсэлтээр эсвэл хугацаа нь дуусаад) устсан байна';
$string['privacy:request:delete:title'] = '[Устсан]';
$string['publishedsubmissions'] = 'Нийтэлсэн материалууд';
$string['publishsubmission'] = 'Материал нийтлэх';
$string['publishsubmission_help'] = 'Нийтэлсэн материал нь семинар хаагдсан үед бусдад нээлттэй байна.';
$string['reassess'] = 'Дахин үнэлгээ хийх';
$string['receivedgrades'] = 'Хүлээн авсан дүн';
$string['recentassessments'] = 'Семинарын үнэлгээ:';
$string['recentsubmissions'] = 'Семинарт илгээсэн материалууд:';
$string['resetassessments'] = 'Бүх үнэлгээг устгах';
$string['resetassessments_help'] = 'Та илгээсэн материалд нөлөөлөхгүйгээр зөвхөн хуваарилагдсан үнэлгээг устгахаар сонгож болно. Хэрэв илгээсэн материалыг устгахаар бол тэдгээрийн үнэлгээ шууд устах бөгөөд энэ сонголтыг үл тоомсорлох болно. Үүнд мөн жишээ материалууд багтсан болохыг анхаарна уу.';
$string['resetphase'] = 'Тохиргооны үе шат руу шилжих';
$string['resetphase_help'] = 'Хэрэв идэвхжүүлсэн бол, бүх семинар тохиргооны эхний шатанд орно.';
$string['resetsubmissions'] = 'Ирсэн бүх материалыг устгах';
$string['resetsubmissions_help'] = 'Ирсэн бүх материалууд болон тэдгээрийн үнэлгээ устана. Жишээ материалд хамаарахгүй.';
$string['saveandclose'] = 'Хадгалаад, хаах';
$string['saveandcontinue'] = 'Хадгалаад, үргэлжлүүлэн засварлах';
$string['saveandpreview'] = 'Хадгалаад, урьдчилан харах';
$string['saveandshownext'] = 'Хадгалаад, дараахийг харуулах';
$string['search:activity'] = 'Семинар - үйл ажиллагааны мэдээлэл';
$string['selfassessmentdisabled'] = 'Өөрийн үнэлгээг идэвхгүй болгосон';
$string['showingperpage'] = 'Нэг хуудсанд {$a} ажил харуулна';
$string['showingperpagechange'] = 'Өөрчлөх ...';
$string['someuserswosubmission'] = 'Материалаа илгээгээгүй дор хаяж нэг хүн байна.';
$string['sortasc'] = 'Өсөх дарааллаар эрэмбэлэх';
$string['sortdesc'] = 'Буурах дарааллаар эрэмбэлэх';
$string['strategy'] = 'Үнэлгээний стратеги';
$string['strategy_help'] = 'Үнэлгээний стратеги нь илгээсэн материалуудыг үнэлэх арга болон ашигласан үнэлгээний маягтыг тодорхойлно. Уг стратеги 4 сонголттой:

* Хуримтлагдсан үнэлгээ - Тодорхой төлөвтэй холбоотой тайлбар болон үнэлгээ өгнө
* Тайлбар - Тодорхой төлөвтэй холбоотой тайлбар өгөх боловч үнэлгээ өгөхгүй
* Алдааны тоо - Тодорхой мэдэгдлээр тайлбар болон тийм/үгүй гэсэн үнэлгээ өгнө
* Рубрик - Тодорхой шалгуураар түвшний үнэлгээ өгнө';
$string['strategyhaschanged'] = 'Засвар оруулахаар маягтыг нээснээс хойш семинарт үнэлгээ хийх стратеги өөрчлөгдсөн байна.';
$string['submission'] = 'Материал';
$string['submissionattachment'] = 'Хавсралт';
$string['submissionby'] = '{$a}-н илгээсэн материал';
$string['submissioncontent'] = 'Илгээсэн материалын агуулга';
$string['submissiondeleteconfirm'] = 'Та дараах материалыг устгахдаа итгэлтэй байна уу?';
$string['submissiondeleteconfirmassess'] = 'Та дараах материалыг устгахдаа итгэлтэй байна уу? Энэ нь мөн материалтай холбоотой {$a->count} үнэлгээг устгахаас гадна хянагчийн үнэлгээнд нөлөөлж болзошгүйг анхаарна уу.';
$string['submissionend'] = 'Материал хүлээн авах эцсийн хугацаа';
$string['submissionendbeforestart'] = 'Материал хүлээн авч эхлэх огнооноос өмнө материал хүлээн авах сүүлийн хугацааг тохируулах боломжгүй';
$string['submissionenddatetime'] = 'Материал хүлээн авах эцсийн хугацаа: {$a->daydatetime} ({$a->distanceday})';
$string['submissionendevent'] = '{$a} материал хүлээн авах эцсийн хугацаа';
$string['submissionendswitch'] = 'Материал хүлээн авах эцсийн хугацаа дуусмагц дараагийн үе шат руу шилжих';
$string['submissionendswitch_help'] = 'Хэрэв материал хүлээн авах эцсийн хугацааг тодорхойлсон ба энэ тохиргоог сонгосон бол материал хүлээн авах эцсийн хугацаа дуусмагц семинар автоматаар үнэлгээний шатруу шилжинэ.

Та энэ тохиргоог сонгох бол урьдчилан тохируулсан хуваарилалтын аргыг танд санал болгож байна. Материалууд хуваарилагдаагүй тохиолдолд семинар үнэлгээний шатанд байгаа ч үнэлгээ хийх боломжгүй байдаг.';
$string['submissiongrade'] = 'Илгээсэн материалд өгөх үнэлгээ';
$string['submissiongrade_help'] = 'Энэ нь суралцагчдын илгээсэн материалд өгч болох дээд оноо юм.';
$string['submissiongradeof'] = '({$a}-ийн) материалд өгсөн дүн';
$string['submissionlastmodified'] = 'Сүүлд өөрчилсөн';
$string['submissionrequiredcontent'] = 'Та бичвэр оруулах эсвэл файл нэмэх хэрэгтэй.';
$string['submissionrequiredfile'] = 'Та файл нэмэх эсвэл бичвэр оруулах хэрэгтэй.';
$string['submissionsallocation'] = 'Материалын хуваарилалт';
$string['submissionsettings'] = 'Материалын тохиргоо';
$string['submissionsreport'] = 'Семинарт илгээсэн материалын тайлан';
$string['submissionstart'] = 'Хүлээж авахыг нээх';
$string['submissionstartdatetime'] = '{$a->daydatetime} ({$a->distanceday}) -с нээгдэх илгээсэн материалуудад нээлттэй';
$string['submissionstartevent'] = '{$a} илгээсэн материалуудад нээлттэй';
$string['submissiontitle'] = 'Гарчиг';
$string['submissiontypedisabled'] = 'Энэ төрлийн файлыг хүлээн авах боломжгүй.';
$string['submissiontypefileavailable'] = 'Файл хавсаргах<span class="accesshide"> боломжтой</span>';
$string['submissiontypefilerequired'] = '<span class="accesshide">Файл хавсаргахыг</span>Шаардана';
$string['submissiontypes'] = 'Материалын төрөл';
$string['submissiontypetextavailable'] = 'Онлайн бичвэр илгээх<span class="accesshide"> боломжтой</span>';
$string['submissiontypetextrequired'] = '<span class="accesshide">Онлайн бичвэр илгээхийг</span>Шаардана';
$string['submittednotsubmitted'] = 'Илгээсэн ({$a->submitted}) / илгээгээгүй({$a->notsubmitted})';
$string['subplugintype_workshopallocation'] = 'Материал хуваарилах арга';
$string['subplugintype_workshopallocation_plural'] = 'Материал хуваарилах аргууд';
$string['subplugintype_workshopeval'] = 'Үнэлгээг дүгнэх арга';
$string['subplugintype_workshopeval_plural'] = 'Үнэлгээг дүгнэх аргууд';
$string['subplugintype_workshopform'] = 'Үнэлгээний стратеги';
$string['subplugintype_workshopform_plural'] = 'Үнэлгээний стратегиуд';
$string['switchingphase'] = 'Үе шат шилжүүлж байна';
$string['switchphase'] = 'Үе шат шилжүүлэх';
$string['switchphase10'] = 'Тохиргооны үе шат руу шилжих';
$string['switchphase10info'] = 'Та семинарыг <strong>Тохиргооны үе шат</strong> руу шилжүүлэх гэж байна. Энэ үе шатанд, хэрэглэгчид илгээсэн материалаа эсвэл үнэлгээгээ өөрчлөх боломжгүй. Багш нар энэ үе шатыг ашиглан семинарын тохиргоог өөрчлөх, үнэлгээний стратегийг шинэчлэх эсвэл үнэлгээний маягтуудыг сайжруулж болно.';
$string['switchphase20'] = 'Материал хүлээн авах үе шат руу шилжүүлэх';
$string['switchphase20info'] = 'Та семинарыг <strong>Материал хүлээн авах үе шат</strong> руу шилжүүлэх гэж байна. Энэ үе шатанд, суралцагчид (хэрэв тохируулсан бол, материал хүлээн авах хугацаанд багтаж) материалуудаа илгээж болно . Багш суралцагчдын илгээсэн материалыг чацуутны үнэлгээ хийлгэхээр хуваарилж болно.';
$string['switchphase30'] = 'Үнэлгээний үе шат руу шилжүүлэх';
$string['switchphase30auto'] = '{$a->daydatetime} ({$a->distanceday})-с хойш семинар автоматаар үнэлгээний шат үе руу шилжинэ';
$string['switchphase30info'] = 'Та семинарыг <strong>Үнэлгээний үе шат</strong> руу шилжүүлэх гэж байна. Энэ үе шатанд, шүүмжлэгч (хэрэв тохируулсан бол, материалд хандах хугацаанд багтаж) өөрт хуваарилагдсан материалуудад үнэлгээ хийж болно.';
$string['switchphase40'] = 'Дүгнэх үе шат руу шилжүүлэх';
$string['switchphase40info'] = 'Та семинарыг <strong>:Дүгнэх үе шат</strong> руу шилжүүлэх гэж байна. Энэ үе шатанд, хэрэглэгч илгээсэн материалаа эсвэл үнэлгээгээ өөрчлөх боломжгүй. Багш эцсийн дүнг тооцоолох хэрэгсэл ашиглан дүгнэж болох ба шүүмжлэгчдэд зориулсан зөвлөмж өгөх боломжтой.';
$string['switchphase50'] = 'Семинарыг хаах';
$string['switchphase50info'] = 'Та семинарыг хаах гэж байна. Ингэснээр тооцоологдсон дүнгүүд дүнгийн дэвтэрт гарч ирнэ. Суралцагчид илгээсэн материалаа болон материалд өгсөн үнэлгээг үзэх боломжтой.';
$string['switchphaseauto'] = 'Үе шат шилжүүлэх процессийг төлөвлөсөн';
$string['switchphasenext'] = 'Дараагийн үе шат руу шилжүүлэх';
$string['taskassesspeers'] = 'Чацуутны үнэлгээ хийх';
$string['taskassesspeersdetails'] = 'нийт: {$a->total}<br />шийдээгүй: {$a->todo}';
$string['taskassessself'] = 'Өөрийн үнэлгээ хийх';
$string['taskconclusion'] = 'Үйл ажиллагааны дүгнэлт өгөх';
$string['taskdone'] = 'Хийж гүйцэтгэсэн ажил';
$string['taskfail'] = 'Гүйцэтгэж чадаагүй ажил';
$string['taskinfo'] = 'Гүйцэтгэх ажлын мэдээлэл';
$string['taskinstructauthors'] = 'Материал илгээх заавар өгөх';
$string['taskinstructreviewers'] = 'Үнэлгээ хийх заавар өгөх';
$string['taskintro'] = 'Семинарын тайлбарыг тохируулах';
$string['tasksubmit'] = 'Өөрийн ажлаа илгээх';
$string['tasktodo'] = 'Хийх ажил';
$string['toolbox'] = 'Семинарын хэрэгслүүд';
$string['undersetup'] = 'Семинарт одоо тохиргоо хийгдэж байна. Дараагийн үе шатанд шилжих хүртэл хүлээнэ үү.';
$string['useexamples'] = 'Жишээ ашиглах';
$string['useexamples_desc'] = 'Үнэлэх дадлага хийхэд зориулсан жишээ материал оруулсан';
$string['useexamples_help'] = 'Хэрэв идэвхжүүлсэн бол, хэрэглэгч нэг эсвэл түүнээс олон жишээ материалд үнэлгээ хийж болох ба үнэлгээгээ жишиг үнэлгээтэй харьцуулж болно. Энэ ажлын дүнг семинар үнэлсэн дүнд тооцохгүй болно.';
$string['usepeerassessment'] = 'Чацуутны үнэлгээг ашиглах';
$string['usepeerassessment_desc'] = 'Суралцагч бусдын ажлыг үнэлж болно';
$string['usepeerassessment_help'] = 'Идэвхжүүлсэн тохиолдолд хэрэглэгч бусдын илгээсэн материалд үнэлгээ хийж болно. Ингэснээр өөрийн илгээсэн материалын дүнгээс гадна үнэлгээ хийсэн дүн авах болно.';
$string['userdatecreated'] = '<span>{$a}</span> хугацаанд илгээсэн';
$string['userdatemodified'] = '<span>{$a}</span> хугацаанд өөрчилсөн';
$string['userplan'] = 'Семинар төлөвлөгч';
$string['userplan_help'] = 'Семинар төлөвлөгч нь үйл ажиллагааны бүх үе шатыг харуулах ба үе шат бүрд хийгдэх ажлуудын жагсаалтыг мөн харуулна. Одоо идэвхтэй байгаа үе шат нь тод байх бөгөөд хийж гүйцэтгэсэн ажлуудын урд тэмдэгтэй (зөв тэмдэг) байна.';
$string['userplanaccessibilityskip'] = 'Хийх ажил руу алгасах';
$string['userplanaccessibilitytitle'] = '{$a} үе шаттай семинарын хугацааны хуваарь';
$string['userplancurrentphase'] = 'Идэвхтэй үе шат';
$string['useselfassessment'] = 'Өөрийн үнэлгээ ашиглах';
$string['useselfassessment_desc'] = 'Суралцагчид өөрсдийн ажилд үнэлгээ өгч болно';
$string['useselfassessment_help'] = 'Идэвхжүүлсэн тохиолдолд, багш чацуутны үнэлгээ ашиглахын тулд ирсэн материалуудыг хуваарилах үед, суралцагчийн өөрийнх нь илгээсэн материал үнэлгээ хийгдэхээр өөрт нь хуваарилагдаж болно. Ингэснээр суралцагч илгээсэн материалын дүнгээс гадна өөртөө үнэлгээ хийсэн дүнг мөн авна.';
$string['viewworkshopsummary'] = 'Семинарын тойм харах';
$string['weightinfo'] = 'Жин: {$a}';
$string['withoutsubmission'] = 'Материал илгээгээгүй шүүмжлэгч';
$string['workshop:addinstance'] = 'Шинэ семинар нэмэх';
$string['workshop:allocate'] = 'Шүүмжлүүлэхээр материал хуваарилах';
$string['workshop:deletesubmissions'] = 'Материалыг устгах';
$string['workshop:editdimensions'] = 'Үнэлгээний маягтуудыг засварлах';
$string['workshop:exportsubmissions'] = 'Материалыг экспортлох';
$string['workshop:ignoredeadlines'] = 'Цагийн хязгаарыг хэрэгсэхгүй байх';
$string['workshop:manageexamples'] = 'Жишээ материалыг удирдах';
$string['workshop:overridegrades'] = 'Тооцоолсон дүнг дахин өөрчлөх';
$string['workshop:peerassess'] = 'Чацуутнаа үнэлэх';
$string['workshop:publishsubmissions'] = 'Материал нийтлэх';
$string['workshop:submit'] = 'Илгээх';
$string['workshop:switchphase'] = 'Үе шат шилжүүлэх';
$string['workshop:view'] = 'Семинар харах';
$string['workshop:viewallassessments'] = 'Бүх үнэлгээг харах';
$string['workshop:viewallsubmissions'] = 'Ирсэн бүх материалыг харах';
$string['workshop:viewauthornames'] = 'Илгээгчийн нэрийг харах';
$string['workshop:viewauthorpublished'] = 'Нийтэлсэн материалын илгээгчийн нэрийг харах';
$string['workshop:viewpublishedsubmissions'] = 'Нийтэлсэн материалуудыг үзэх';
$string['workshop:viewreviewernames'] = 'Шүүмжлэгчийн нэрийг харах';
$string['workshopname'] = 'Семинарын нэр';
$string['yourassessmentfor'] = '{$a}- д өгөх таны үнэлгээ';
$string['yourgrades'] = 'Таны дүнгүүд';
$string['yoursubmission'] = 'Таны илгээсэн материал';
$string['yoursubmissionwithassessments'] = 'Таны илгээсэн материал үнэлгээний хамт';
