<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'assign', language 'ja', version '4.4'.
 *
 * @package     assign
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['activityattachments'] = '課題活動添付';
$string['activitydate:submissionsdue'] = '期限:';
$string['activitydate:submissionsopen'] = '開始予定:';
$string['activitydate:submissionsopened'] = '開始:';
$string['activityeditor'] = '活動インストラクション';
$string['activityeditor_help'] = 'あなたがこの課題で学生に完了してもらいたいアクションです。これは学生が課題を編集および提出するための提出ページにのみ表示されます。';
$string['activityoverview'] = 'あなたには注意が必要な課題があります。';
$string['addattempt'] = '別の提出を許可する';
$string['addnewattempt'] = '新しい提出を追加する';
$string['addnewattempt_help'] = 'ここではあなたの作業のために空の提出を作成します。';
$string['addnewattemptfromprevious'] = '前回の提出をもとに新しい提出を追加する';
$string['addnewattemptfromprevious_help'] = 'ここではあなたの作業のために前回提出のコンテンツを新しい提出にコピーします。';
$string['addnewgroupoverride'] = 'グループオーバーライドを追加する';
$string['addnewuseroverride'] = 'ユーザオーバーライドを追加する';
$string['addsubmission'] = '提出をアップロード・入力する';
$string['addsubmission_help'] = 'あなたはまだ提出していません。';
$string['allocatedmarker'] = '割り当て採点者';
$string['allocatedmarker_help'] = 'この提出に割り当てられた採点者です。';
$string['allowsubmissions'] = 'この課題にユーザが継続して提出できるようにします。';
$string['allowsubmissionsfromdate'] = '開始日時';
$string['allowsubmissionsfromdate_help'] = 'この設定を有効にした場合、学生はこの日時以前に提出することはできません。無効にした場合、学生は今すぐ提出を開始することができます。';
$string['allowsubmissionsshort'] = '提出の変更を許可する';
$string['alwaysshowdescription'] = '常に説明を表示する';
$string['alwaysshowdescription_help'] = 'この設定を無効にした場合、上記の課題説明は「開始日時」以降のみ学生に表示されます。';
$string['applytoteam'] = 'グループ全体に評定およびフィードバックを提供する';
$string['assign:addinstance'] = '新しい課題を追加する';
$string['assign:editothersubmission'] = '他の学生提出を編集する';
$string['assign:exportownsubmission'] = '自分の提出をエクスポートする';
$string['assign:grade'] = '課題を評定する';
$string['assign:grantextension'] = '延長を許可する';
$string['assign:manageallocations'] = '提出に割り当てられた採点者を管理する';
$string['assign:managegrades'] = '評定をレビューおよびリリースする';
$string['assign:manageoverrides'] = '課題オーバーライドを管理する';
$string['assign:receivegradernotifications'] = '評定者提出通知を受信する';
$string['assign:releasegrades'] = '評点をリリースする';
$string['assign:revealidentities'] = '学生の個人情報を公開する';
$string['assign:reviewgrades'] = '評定をレビューする';
$string['assign:showhiddengrader'] = '非表示評定者のIDを表示する';
$string['assign:submit'] = '課題を提出する';
$string['assign:view'] = '課題を表示する';
$string['assign:viewblinddetails'] = '匿名送信が有効にされた場合、学生の個人情報を表示する';
$string['assign:viewgrades'] = '評定を表示する';
$string['assign:viewownsubmissionsummary'] = '自分の提出概要を表示する';
$string['assignfeedback'] = 'フィードバックプラグイン';
$string['assignfeedbackpluginname'] = 'フィードバックプラグイン';
$string['assignmentisdue'] = '課題の提出期限が到来しました。';
$string['assignmentmail'] = 'あなたの「 {$a->assignment} 」への提出課題に関して {$a->grader} がフィードバックを投稿しました。

あなたの提出課題に追加されたフィードバックをご覧ください:

    {$a->url}';
$string['assignmentmailhtml'] = '<p>あなたの「 {$a->assignment} 」への提出課題に関して {$a->grader} がフィードバックを投稿しました。</p>
<p>あなたの<a href="{$a->url}">提出課題</a>に追加されたフィードバックをご覧ください。</p>';
$string['assignmentmailsmall'] = 'あなたの「 {$a->assignment} 」への提出課題に関して {$a->grader} がフィードバックを投稿しました。あなたの提出課題に追加されたフィードバックをご覧ください。';
$string['assignmentname'] = '課題名';
$string['assignmentplugins'] = '課題プラグイン';
$string['assignmentsperpage'] = '1ページあたりの課題数';
$string['assignsubmission'] = '提出プラグイン';
$string['assignsubmissionpluginname'] = '提出プラグイン';
$string['assigntimeleft'] = '残り時間';
$string['attemptheading'] = '提出 {$a->attemptnumber}: {$a->submissionsummary}';
$string['attempthistory'] = '前回の提出';
$string['attemptnumber'] = '提出回数';
$string['attemptreopenmethod'] = '追加提出';
$string['attemptreopenmethod_help'] = 'この設定では学生が課題を追加提出できるかどうか決定します。それぞれの提出において評点およびフィードバックは保存され教師および学生が閲覧できます。利用可能なオプションは以下のとおりです:

* なし - 1回の提出のみ。
* 手動 - 教師が追加提出を許可できます。
* 合格するまで自動 - この課題に設定された評定表内の合格点に達するまで追加提出が自動的に許可されます。';
$string['attemptreopenmethod_manual'] = '手動';
$string['attemptreopenmethod_none'] = 'なし';
$string['attemptreopenmethod_untilpass'] = '合格するまで自動';
$string['attemptsettings'] = '提出設定';
$string['availability'] = '利用';
$string['back'] = '戻る';
$string['backtoassignment'] = '課題に戻る';
$string['batchoperationconfirmaddattempt'] = '選択した提出に関して別の提出を許可しますか?';
$string['batchoperationconfirmdownloadselected'] = '選択した提出をダウンロードしますか?';
$string['batchoperationconfirmgrantextension'] = '選択されたすべての提出に関して延長を許可しますか?';
$string['batchoperationconfirmlock'] = '選択された提出すべてをロックしますか?';
$string['batchoperationconfirmremovesubmission'] = '選択した提出を削除しますか?';
$string['batchoperationconfirmreverttodraft'] = '選択された提出を下書きに戻しますか?';
$string['batchoperationconfirmsetmarkingallocation'] = '選択された提出すべてに採点割り当てを設定しますか?';
$string['batchoperationconfirmsetmarkingworkflowstate'] = '選択された提出すべてに採点ワークフロー状態を設定しますか?';
$string['batchoperationconfirmunlock'] = '選択された提出すべてをロック解除しますか?';
$string['batchoperationlock'] = '提出をロックする';
$string['batchoperationreverttodraft'] = '提出を下書きに戻す';
$string['batchoperationsdescription'] = '選択した行に対して ...';
$string['batchoperationunlock'] = '提出をロック解除する';
$string['batchsetallocatedmarker'] = '選択された {$a} 名のユーザに割り当て採点者を設定します。';
$string['batchsetmarkingworkflowstateforusers'] = '選択された {$a} 名のユーザに採点ワークフロー状態を設定します。';
$string['beginassignment'] = '課題を開始する';
$string['blindmarking'] = '匿名送信';
$string['blindmarking_help'] = '匿名送信は採点者に学生の個人情報を隠します。この課題に関して提出または評定された場合、ブラインド評定設定がロックされます。';
$string['blindmarkingenabledwarning'] = 'この活動では匿名送信が有効にされています。評定アクションメニューから学生認識情報が開示されるまで評定は追加されません。';
$string['cachedef_overrides'] = 'ユーザおよびグループオーバーライド情報';
$string['calendardue'] = '「{$a}」の提出期限';
$string['calendargradingdue'] = '「{$a}」の評定期限が近づいています';
$string['caneditsubmission'] = 'あなたは制限時間後でも提出および提出の編集は可能ですが、遅延扱いとされます。';
$string['changefilters'] = 'フィルタを変更する';
$string['changeuser'] = 'ユーザを変更する';
$string['choosegradingaction'] = '評定操作';
$string['choosemarker'] = '選択 ...';
$string['chooseoperation'] = '処理を選択する';
$string['clickexpandreviewpanel'] = 'レビューパネルを展開するにはクリックしてください。';
$string['collapsegradepanel'] = '評定パネルを折りたたむ';
$string['collapsereviewpanel'] = 'レビューパネルを折りたたむ';
$string['comment'] = 'コメント';
$string['completiondetail:submit'] = '提出する';
$string['completionsubmit'] = '提出する';
$string['configshowrecentsubmissions'] = 'すべてのユーザが提出の通知を「最近の活動」レポートで閲覧できます。';
$string['confirmbatchgradingoperation'] = '本当に {$a->count} 名の学生に {$a->operation} してもよろしいですか?';
$string['confirmstart'] = 'あなたにはこの課題の完了に {$a} あります。あなたが開始した場合、タイマーがカウントダウンを開始して一時停止はできません。';
$string['confirmsubmission'] = '本当にあなたの作業を評定のために提出してもよろしいですか? これ以上、あなたは変更できないようになります。';
$string['confirmsubmissionheading'] = '提出を確認する';
$string['conversionexception'] = '課題をコンバートできませんでした。除外: {$a}.';
$string['couldnotconvertgrade'] = 'ユーザ {$a} の課題評点をコンバートできませんでした。';
$string['couldnotconvertsubmission'] = 'ユーザ {$a} の提出課題をコンバートできませんでした。';
$string['couldnotcreatecoursemodule'] = 'コースモジュールを作成できませんでした。';
$string['couldnotcreatenewassignmentinstance'] = '新しい課題インスタンスを作成できませんでした。';
$string['couldnotfindassignmenttoupgrade'] = 'アップグレードするための古い課題インスタンスを見つけることができませんでした。';
$string['crontask'] = '課題モジュールのバックグラウンド処理';
$string['currentassigngrade'] = '課題の現在の評定';
$string['currentattempt'] = 'これは {$a} 回目の提出です。';
$string['currentattemptof'] = 'これは {$a->attemptnumber} 回目の提出です ( {$a->maxattempts} 回の提出が許可されています)。';
$string['currentgrade'] = '評定表内の現在の評定';
$string['cutoffdate'] = '遮断日時';
$string['cutoffdate_help'] = '設定した場合、この日時以後、延長なしでは提出を受け付けません。設定しない場合、提出は常に受け付けられます。';
$string['cutoffdatecolon'] = '遮断日時: {$a}';
$string['cutoffdatefromdatevalidation'] = '遮断日時を開始日時の前に設定することはできません。';
$string['cutoffdatevalidation'] = '遮断日時を終了日時の前に設定することはできません。';
$string['defaultlayout'] = 'デフォルトレイアウトをリストアする';
$string['defaultsettings'] = 'デフォルト課題設定';
$string['defaultsettings_help'] = 'これらの設定は新しい課題すべてのデフォルトを設定します。';
$string['defaultteam'] = 'デフォルトグループ';
$string['deleteallsubmissions'] = 'すべての提出を削除する';
$string['description'] = '説明';
$string['disabled'] = '無効';
$string['downloadall'] = 'すべての提出をダウンロードする';
$string['downloadasfolders'] = '提出をフォルダに入れてダウンロードする';
$string['downloadasfolders_help'] = '提出課題をフォルダに入れてダウンロードすることができます。それぞれの提出は別々のフォルダに入れられサブフォルダの構造すべては保持されます。また、ファイルはリネームされません。';
$string['downloadselectedsubmissions'] = '選択した提出をダウンロードする';
$string['duedate'] = '終了日時';
$string['duedate_help'] = 'これは課題の提出期限です。この日時以降の提出はまだ許可されますが、この日時以後に提出された課題は提出遅延としてマークされます。特定日時以降の提出を避けるには課題遮断日時を設定してください。';
$string['duedateaftersubmissionvalidation'] = '終了日時は開始日時以降にしてください。';
$string['duedatecolon'] = '終了日時: {$a}';
$string['duedatereached'] = 'この課題の提出期限を過ぎました。';
$string['duedatevalidation'] = '終了日を開始日時の前に設定することはできません。';
$string['duplicateoverride'] = 'オーバーライドを複製する';
$string['editaction'] = '操作 ...';
$string['editattemptfeedback'] = '提出番号 {$a} の評点およびフィードバックを編集します。';
$string['editingpreviousfeedbackwarning'] = 'あなたは前回の提出のフィードバックを編集しています。これは {$a->attemptnumber} / {$a->totalattempts} の提出です。';
$string['editingstatus'] = '編集ステータス';
$string['editonline'] = 'オンラインで編集する';
$string['editoverride'] = 'オーバーライドを編集する';
$string['editsubmission'] = '提出を編集する';
$string['editsubmission_help'] = 'あなたはまだ提出に変更を加えることができます。';
$string['editsubmissionother'] = '{$a} の提出を編集する';
$string['enabled'] = '有効';
$string['enabletimelimit'] = '時間制限ありの課題を有効にする';
$string['enabletimelimit_help'] = 'この設定を有効にした場合、あなたは課題設定ページで制限時間を設定できます。';
$string['errorgradechangessaveddetail'] = '評定およびフィードバックの変更の保存に失敗しました。';
$string['errornosubmissions'] = 'ダウンロード可能な提出はありません。';
$string['errorquickgradingvsadvancedgrading'] = '現在、この課題は高度な評定を使用しているため、評点は保存されませんでした。';
$string['errorrecordmodified'] = 'あなたがページを表示した後、他のユーザが1つまたはそれ以上のレコードを修正したため、評点は保存されませんでした。';
$string['eventallsubmissionsdownloaded'] = 'すべての提出がダウンロードされました。';
$string['eventassessablesubmitted'] = '課題が提出されました。';
$string['eventbatchsetmarkerallocationviewed'] = '採点者割り当てページのバッチ設定が閲覧されました。';
$string['eventbatchsetworkflowstateviewed'] = 'ワークフロー状態ページのバッチ設定が閲覧されました。';
$string['eventextensiongranted'] = '延長が許可されました。';
$string['eventfeedbackupdated'] = 'フィードバックが更新されました。';
$string['eventfeedbackviewed'] = 'フィードバックが閲覧されました。';
$string['eventgradingformviewed'] = '評定フォームが閲覧されました。';
$string['eventgradingtableviewed'] = '評定表が閲覧されました。';
$string['eventidentitiesrevealed'] = 'IDが公開されました。';
$string['eventmarkerupdated'] = '割り当て済み採点者が更新されました。';
$string['eventoverridecreated'] = '課題オーバーライドが作成されました。';
$string['eventoverridedeleted'] = '課題オーバーライドが削除されました。';
$string['eventoverrideupdated'] = '課題オーバーライドが更新されました。';
$string['eventremovesubmissionformviewed'] = '提出削除確認が表示されました。';
$string['eventrevealidentitiesconfirmationpageviewed'] = 'ID公開確認ページが閲覧されました。';
$string['eventstatementaccepted'] = 'ユーザが提出同意書に同意しました。';
$string['eventsubmissionconfirmationformviewed'] = '提出確認フォームが閲覧されました。';
$string['eventsubmissioncreated'] = '提出が作成されました。';
$string['eventsubmissionduplicated'] = 'ユーザの提出が重複しました。';
$string['eventsubmissionformviewed'] = '提出フォームが閲覧されました。';
$string['eventsubmissiongraded'] = '提出が評定されました。';
$string['eventsubmissionlocked'] = 'ユーザの提出がロックされました。';
$string['eventsubmissionremoved'] = '提出が削除されました。';
$string['eventsubmissionstatusupdated'] = '提出ステータスが更新されました。';
$string['eventsubmissionstatusviewed'] = '提出ステータスが閲覧されました。';
$string['eventsubmissionunlocked'] = 'ユーザの提出がロック解除されました。';
$string['eventsubmissionupdated'] = '提出が更新されました。';
$string['eventsubmissionviewed'] = '提出が閲覧されました。';
$string['eventworkflowstateupdated'] = 'ワークフロー状態が更新されました。';
$string['expandreviewpanel'] = 'レビューパネルを展開する';
$string['extensionduedate'] = '延長提出期限';
$string['extensionduedatecurrent'] = '現在の延長期限';
$string['extensionduedatenone'] = 'なし';
$string['extensionnotafterduedate'] = '延長日時は終了日時の後にする必要があります。';
$string['extensionnotafterfromdate'] = '延長日時は開始日時の後にする必要があります。';
$string['feedback'] = 'フィードバック';
$string['feedbackavailableanonhtml'] = 'あなたの課題提出「 {$a->assignment} 」に新しいフィードバックがあります。<br /><br />
あなたの<a href="{$a->url}">課題提出</a>の添付として閲覧することができます。';
$string['feedbackavailableanonsmall'] = '課題 {$a->assignment} の新しいフィードバック';
$string['feedbackavailableanontext'] = 'あなたの課題提出「 {$a->assignment} 」に新しいフィードバックがあります。

あなたの課題提出の添付として閲覧することができます:

{$a->url}';
$string['feedbackavailablehtml'] = 'あなたの「 {$a->assignment} 」への提出課題に {$a->username} がフィードバックを投稿しました。
<br />
<br />
あなたの<a href="{$a->url}">提出課題</a>に追加されたフィードバックを確認できます。';
$string['feedbackavailablesmall'] = '課題「 {$a->assignment} 」のフィードバックが{$a->username} により投稿されました。';
$string['feedbackavailabletext'] = 'あなたの「 {$a->assignment} 」への提出課題に {$a->username} がフィードバックを投稿しました。

あなたの提出課題に追加されたフィードバックを確認できます:

    {$a->url}';
$string['feedbackplugin'] = 'フィードバックプラグイン';
$string['feedbackpluginforgradebook'] = '評定表にコメントを転送するためのフィードバックプラグインです。';
$string['feedbackpluginforgradebook_help'] = '1つの課題フィードバックプラグインのみ、評定表にフィードバックをプッシュすることができます。';
$string['feedbackplugins'] = 'フィードバックプラグイン';
$string['feedbacksettings'] = 'フィードバック設定';
$string['feedbacktypes'] = 'フィードバックタイプ';
$string['filesubmissions'] = 'ファイル提出';
$string['filter'] = 'フィルタ';
$string['filterdraft'] = '下書き';
$string['filtergrantedextension'] = '延長許可';
$string['filternone'] = 'フィルタなし';
$string['filternotsubmitted'] = '未提出';
$string['filterrequiregrading'] = '要評定';
$string['filtersubmitted'] = '提出';
$string['fixrescalednullgrades'] = 'この課題には正しくない評点が含まれています。あなたは<a href="{$a->link}">これらの評点を自動的に修正することができます</a>。これはコース合計に影響する場合があります。';
$string['fixrescalednullgradesconfirm'] = '本当に正しくない評点を修正してもよろしいですか? すべての影響する評定は削除されます。これはコース合計に影響する場合があります。';
$string['fixrescalednullgradesdone'] = '評点を修正しました。';
$string['gradeabovemaximum'] = '評点は {$a} 以下にする必要があります。';
$string['gradebelowzero'] = '評点はゼロまたはゼロより大きな値にする必要があります。';
$string['gradebreakdown'] = '評定内訳';
$string['gradecanbechanged'] = '評点変更可';
$string['gradechangessaveddetail'] = '評定およびフィードバックの変更が保存されました。';
$string['graded'] = '評定済み';
$string['gradedby'] = '評定者';
$string['gradedfollowupsubmit'] = '評定済み - 提出受信済み';
$string['gradedon'] = '評定日時';
$string['gradeitem:submissions'] = '提出';
$string['gradelocked'] = 'この評点はロックされているか評定表内で上書きされています。';
$string['gradeoutof'] = '{$a} 点中の評点';
$string['gradeoutofhelp'] = '評定';
$string['gradeoutofhelp_help'] = 'ここで学生の提出に関する評点を入力してください。あなたは小数点を含むことができます。';
$string['gradersubmissionupdatedhtml'] = '{$a->username} が「 {$a->assignment} 」の提出課題を更新しました (更新日時: {$a->timeupdated} )。<br /><br />
<a href="{$a->url}">ウェブサイトで確認できます</a>。';
$string['gradersubmissionupdatedsmall'] = '{$a->username} が課題「 {$a->assignment} 」への提出を更新しました。';
$string['gradersubmissionupdatedtext'] = '{$a->username} が「 {$a->assignment} 」の提出課題を更新しました (更新日時: {$a->timeupdated} )。

以下で確認できます:

{$a->url}';
$string['gradestudent'] = '学生を評定する: (id={$a->id}, フルネーム={$a->fullname})';
$string['gradeuser'] = '{$a} を評定する';
$string['grading'] = '評定';
$string['gradingchangessaved'] = '評定の変更が保存されました。';
$string['gradingduedate'] = '次の日時まで私に評定を思い出させる';
$string['gradingduedate_help'] = '提出の評定が完了する予定日です。この日付はダッシュボードでの教師への通知を優先するために使用されます。';
$string['gradingdueduedatevalidation'] = '私に評定を思い出させる日は提出期限よりも前にすることができません。';
$string['gradingduefromdatevalidation'] = '私に評定を思い出させる日は提出許可開始日よりも前にすることができません。';
$string['gradingmethodpreview'] = '評定クライテリア';
$string['gradingoptions'] = 'オプション';
$string['gradingstatus'] = '評定ステータス';
$string['gradingstudent'] = '学生評定';
$string['gradingsummary'] = '評定概要';
$string['grantextension'] = '延長を許可する';
$string['grantextensionforusers'] = '{$a} 名の学生に対して延長を許可する';
$string['groupoverrides'] = 'グループオーバーライド';
$string['groupoverridesdeleted'] = 'グループオーバーライドが削除されました。';
$string['groupsnone'] = 'あなたがアクセスできるグループはありません。';
$string['groupsubmissionsettings'] = 'グループ提出設定';
$string['hiddenuser'] = '参加者';
$string['hidegrader'] = '学生から評定者IDを隠す';
$string['hidegrader_help'] = 'この設定を有効にした場合、提出課題を評定するユーザのIDは表示されません。そのため、学生は誰が自分の作業を評定したのか確認できません。

この設定は評定ページのコメントボックスには適用されないことに留意してください。';
$string['hideshow'] = '非表示/表示';
$string['inactiveoverridehelp'] = '* ユーザの活動へのアクセスが制限されているため、このオーオバーライドは有効ではありません。グループ、ロール割り当て、他のアクセス制限または活動が非表示にされている可能性があります。';
$string['indicator:cognitivedepth'] = '課題認知的';
$string['indicator:cognitivedepth_help'] = 'この指標は課題活動で学生が到達した認識深度に基づきます。';
$string['indicator:cognitivedepthdef'] = '課題認知的';
$string['indicator:cognitivedepthdef_help'] = 'この分析間隔中、参加者が課題活動から提供された認知的関与のこのパーセンテージに到達しました (レベル = 閲覧なし, 閲覧, 送信, フィードバックの閲覧, フィードバックへのコメント, フィードバック閲覧後の再送信)。';
$string['indicator:cognitivedepthdef_link'] = 'Learning_analytics_indicators#Cognitive_depth';
$string['indicator:socialbreadth'] = '課題社会的';
$string['indicator:socialbreadth_help'] = 'この指標は課題活動で学生が到達した社会的広がりに基づきます。';
$string['indicator:socialbreadthdef'] = '課題社会的';
$string['indicator:socialbreadthdef_help'] = 'この分析間隔中、参加者が課題活動から提供された社会的関与のこのパーセンテージに到達しました (レベル = 参加なし, 個人で参加, 他の人と参加)。';
$string['indicator:socialbreadthdef_link'] = 'Learning_analytics_indicators#Social_breadth';
$string['instructionfiles'] = 'インストラクションファイル';
$string['introattachments'] = '追加ファイル';
$string['introattachments_help'] = '解答テンプレート等、課題で使用する追加ファイルを追加できます。';
$string['invalidfloatforgrade'] = '提供された評点を理解できませんでした: {$a}';
$string['invalidgradeforscale'] = '提供された評点は現在の評価尺度に有効ではありません。';
$string['invalidoverrideid'] = '無効なオーバーライドIDです。';
$string['lastmodifiedgrade'] = '最終更新日時 (評定)';
$string['lastmodifiedsubmission'] = '最終更新日時 (提出)';
$string['latesubmissions'] = '提出期限後の提出';
$string['latesubmissionsaccepted'] = '{$a} まで許可されます。';
$string['loading'] = '読み込み中 ...';
$string['locksubmissionforstudent'] = '学生によるこれ以上の提出を禁止する: (id={$a->id}, フルネーム={$a->fullname})';
$string['locksubmissions'] = '提出をロックする';
$string['manageassignfeedbackplugins'] = '課題フィードバックプラグイン管理';
$string['manageassignsubmissionplugins'] = '課題提出プラグイン管理';
$string['marker'] = '採点者';
$string['markerfilter'] = '採点者フィルタ';
$string['markerfilternomarker'] = '採点者なし';
$string['markingallocation'] = '採点割り当てを使用する';
$string['markingallocation_help'] = 'この設定および採点ワークフローを有効にした場合、個別の学生に採点者を割り当てきるようになります。';
$string['markinganonymous'] = '匿名で採点しながら評定を一部公開できるようにする';
$string['markinganonymous_help'] = '匿名提出および採点ワークフローとともに有効にした場合、匿名で採点しながら評定の一部を公開できるようになります。';
$string['markingworkflow'] = '採点ワークフローを使用する';
$string['markingworkflow_help'] = 'この設定を有効にした場合、評点は学生にリリースされる前にワークフローステージに入ります。これで採点者が一連の評点を同じタイミングですべての学生にリリースすることができます。';
$string['markingworkflowstate'] = '採点ワークフローステータス';
$string['markingworkflowstate_help'] = '使用可能なワークフローステータスは以下を含みます (あなたのパーミッションに依存します):

* 未採点 - まだ採点者は開始していません。
* 採点中 - 採点者は開始しましたが、まだ完了していません。
* 採点完了 - 採点者は完了していますが、チェックおよび訂正が必要です。
* レビュー中 - 採点は教師によるクオリティチェック中です。
* リリース準備完了 - 担当教師は採点に満足した場合でも、学生が評点にアクセスできるようにする前に待機できます。
* リリース - 学生は評点およびフィードバックにアクセスすることができます。';
$string['markingworkflowstateinmarking'] = '採点中';
$string['markingworkflowstateinreview'] = 'レビュー中';
$string['markingworkflowstatenotmarked'] = '未採点';
$string['markingworkflowstatereadyforrelease'] = 'リリース準備完了';
$string['markingworkflowstatereadyforreview'] = '採点完了';
$string['markingworkflowstatereleased'] = 'リリース済み';
$string['maxattempts'] = '最大提出回数';
$string['maxattempts_help'] = '学生が試みることのできる最大提出回数です。この提出回数に達した場合、提出を再度開くことができないようになります。';
$string['maxgrade'] = '最大評点';
$string['maxperpage'] = '1ページあたりの最大課題数';
$string['maxperpage_help'] = '評定者が課題評定ページに表示できる最大課題数です。この設定は非常に多くの受講登録のいるコースのタイムアウトを防ぐことに有用です。';
$string['messageprovider:assign_notification'] = '課題通知';
$string['modulename'] = '課題';
$string['modulename_help'] = '課題活動モジュールにおいて、教師はタスクの伝達、作業の収集、評点およびフィードバックを提供することができます。

学生はワープロ文書、スプレッドシート、イメージ、オーディオまたはビデオクリップのようなデジタルコンテンツ (ファイル) を提出することができます。代わりに、または加えて、テキストエディタに文章を直接入力するよう学生に求めることができます。美術作品のようなオフラインで完了させる必要がある「実世界」の課題を学生に思い出させるために使用することもできます。この場合、デジタルコンテンツを必要としません。学生は個人またはグループのメンバとして課題を提出することができます。

課題をレビューする場合、教師は評定した学生の提出物、コメントを付けたドキュメント、口頭のオーディオフィードバックのようにフィードバックコメントを残したり、ファイルをアップロードすることができます。課題は数字またはカスタム評価尺度、ルーブリックのような高度な評定方法を使って評定することができます。最終評点は評定表に記録されます。';
$string['modulename_link'] = 'mod/assignment/view';
$string['modulenameplural'] = '課題';
$string['moreusers'] = 'さらに {$a} 名 ...';
$string['multipleteams'] = '2つ以上のグループのメンバ';
$string['multipleteams_desc'] = 'グループで課題を提出する必要があります。あなたは2つ以上のグループのメンバです。提出できるためにはあなたは1つのみのグループのメンバである必要があります。あなたのグループメンバシップを変更するには教師にご連絡ください。';
$string['multipleteamsgrader'] = '2つ以上のグループのメンバのため、提出することはできません。';
$string['newsubmissions'] = '課題が提出されました';
$string['nextuser'] = '次のユーザ';
$string['noattempt'] = '未提出';
$string['noclose'] = '終了日なし';
$string['nofiles'] = 'ファイルなし';
$string['nofilters'] = 'フィルタなし';
$string['nograde'] = '評点なし';
$string['nogroupoverrides'] = '現在、グループオーバーライドはありません。';
$string['nomoresubmissionsaccepted'] = '延長を許可された参加者のみ許可されます。';
$string['none'] = 'なし';
$string['noonlinesubmissions'] = 'この課題においてあなたがオンラインで提出するものはありません。';
$string['noopen'] = '開始日なし';
$string['nooverridedata'] = 'あなたは少なくとも1つの課題設定をオーバーライドする必要があります。';
$string['nosavebutnext'] = '次へ';
$string['nosubmission'] = 'この課題に関して提出されているものはありません。';
$string['nosubmissionyet'] = 'まだ提出されていません。';
$string['noteam'] = 'どのグループのメンバでもない';
$string['noteam_desc'] = 'この課題はグループで提出する必要があります。あなたはどのグループにも属していないため提出を作成できません。グループに追加されるにはあなたの先生にご連絡ください。';
$string['noteamgrader'] = 'どのグループのメンバでもないため提出することはできません。';
$string['notgraded'] = '未評定';
$string['notgradedyet'] = '未評定';
$string['notifications'] = '通知';
$string['nouseroverrides'] = '現在、ユーザオーバーライドはありません。';
$string['nousers'] = 'ユーザなし';
$string['nousersselected'] = 'ユーザ未選択';
$string['numberofdraftsubmissions'] = '下書き';
$string['numberofparticipants'] = '参加者';
$string['numberofsubmissionsneedgrading'] = '要評定';
$string['numberofsubmissionsneedgradinglabel'] = '要評定: {$a}';
$string['numberofsubmittedassignments'] = '提出';
$string['numberofteams'] = 'グループ';
$string['offline'] = 'オンライン提出不要';
$string['open'] = 'オープン';
$string['opensubmissionexists'] = '課題提出受け付けはすでに存在します。';
$string['outlinegrade'] = '評点: {$a}';
$string['outof'] = '{$a->current} / {$a->total}';
$string['overdue'] = '課題は次の時間を超過しています: {$a}';
$string['override'] = 'オーバーライド';
$string['overridedeletegroupsure'] = '本当にグループ {$a} のオーバーライドを削除してもよろしいですか?';
$string['overridedeleteusersure'] = '本当にユーザ {$a} のオーバーライドを削除してもよろしいですか?';
$string['overridegroup'] = 'グループをオーバーライドする';
$string['overridegroupeventname'] = '{$a->assign} - {$a->group}';
$string['overrides'] = 'オーバーライド';
$string['overrideuser'] = 'ユーザをオーバーライドする';
$string['overrideusereventname'] = '{$a->assign} - オーバーライド';
$string['page-mod-assign-view'] = '課題モジュールメインおよび提出ページ';
$string['page-mod-assign-x'] = 'すべての課題モジュールページ';
$string['paramtimeremaining'] = '残り {$a}';
$string['participant'] = '参加者';
$string['pluginadministration'] = '課題管理';
$string['pluginname'] = '課題';
$string['preventsubmissionnotingroup'] = '提出にグループを必要とする';
$string['preventsubmissionnotingroup_help'] = 'この設定を有効にした場合、グループのメンバではないユーザは提出することはできません。';
$string['preventsubmissions'] = 'この課題にユーザがさらに提出することを防ぎます。';
$string['preventsubmissionsshort'] = '提出の変更を禁止する';
$string['previous'] = '前へ';
$string['previoususer'] = '前のユーザ';
$string['privacy:attemptpath'] = '提出 {$a}';
$string['privacy:blindmarkingidentifier'] = '匿名送信に使用されるIDです。';
$string['privacy:gradepath'] = '評定です。';
$string['privacy:metadata:assigndownloadasfolders'] = '複数ファイル提出をフォルダでダウンロードできるかどうか指定するユーザプレファレンスです。';
$string['privacy:metadata:assignfeedbackpluginsummary'] = '課題のフィードバックデータです。';
$string['privacy:metadata:assignfilter'] = '「提出済み」「未提出」「要評定」「延長許可」のようなフィルタオプションです。';
$string['privacy:metadata:assigngrades'] = '課題のユーザ評点を保存します。';
$string['privacy:metadata:assignmarkerfilter'] = '割り当て採点者による課題概要をフィルタします。';
$string['privacy:metadata:assignmentid'] = '課題IDです。';
$string['privacy:metadata:assignmessageexplanation'] = 'メッセージングシステム経由で学生にメッセージが送信されます。';
$string['privacy:metadata:assignoverrides'] = '課題のオーバーライド情報を保存します。';
$string['privacy:metadata:assignperpage'] = '1ページあたりに表示される課題数です。';
$string['privacy:metadata:assignquickgrading'] = 'クイック評定を使用するかどうか指定するユーザプレファレンスです。';
$string['privacy:metadata:assignsubmissiondetail'] = 'ユーザ提出情報を保存します。';
$string['privacy:metadata:assignsubmissionpluginsummary'] = '課題の提出データです。';
$string['privacy:metadata:assignuserflags'] = '延長日時のようなユーザメタデータを保存します。';
$string['privacy:metadata:assignusermapping'] = '匿名送信のマッピングです。';
$string['privacy:metadata:assignworkflowfilter'] = '異なるワークフローステージによりフィルタです。';
$string['privacy:metadata:grade'] = 'この課題の数字評定です。尺度/高度な評定フォームで指定することができますが常に浮動小数点に変換されます。';
$string['privacy:metadata:grader'] = '評定者のユーザIDです。';
$string['privacy:metadata:groupid'] = 'ユーザがメンバであるグループのIDです。';
$string['privacy:metadata:latest'] = '最新提出のみの情報を知るための非常にシンプルなクエリです。';
$string['privacy:metadata:mailed'] = 'このユーザにメール送信されたかどうか示します。';
$string['privacy:metadata:timecreated'] = '作成日時です。';
$string['privacy:metadata:timestarted'] = '開始時間';
$string['privacy:metadata:userid'] = 'ユーザのIDです。';
$string['privacy:studentpath'] = '学生提出です。';
$string['privacy:submissionpath'] = '提出です。';
$string['quickgrading'] = 'クイック評定';
$string['quickgrading_help'] = 'クイック評定において、あなたは提出テーブル内に直接評点 (およびアウトカム) を入力することができます。クイック評定には高度な評定との互換性がありません。複数の採点者がいる場合、お勧めできません。';
$string['quickgradingchangessaved'] = '評定の変更が保存されました。';
$string['quickgradingresult'] = 'クイック評定';
$string['recordid'] = 'ID';
$string['relativedatessubmissiontimeleft'] = 'それぞれの学生に対する計算';
$string['removeallgroupoverrides'] = 'すべてのグループオーバーライドを削除する';
$string['removealluseroverrides'] = 'すべてのユーザオーバーライドを削除する';
$string['removesubmission'] = '提出を削除する';
$string['removesubmissionconfirm'] = '本当にあなたの提出を削除してもよろしいですか?';
$string['removesubmissionconfirmforstudent'] = '本当に {$a} の提出を削除してもよろしいですか?';
$string['removesubmissionconfirmforstudentwithtimelimit'] = '本当に {$a} の提出を削除してもよろしいですか? 提出削除では学生の制限時間はリセットされないことに留意してください。あなたは制限時間ユーザオーバーライドの追加により、さらに多くの時間を付与できます。';
$string['removesubmissionconfirmwithtimelimit'] = '本当にあなたの提出を削除してもよろしいですか? 提出削除ではあなたの制限時間はリセットされないことに留意してください。';
$string['removesubmissionforstudent'] = '学生の提出を削除する: (id={$a->id} / フルネーム={$a->fullname})';
$string['reopenuntilpassincompatiblewithblindmarking'] = '学生の個人情報が公開されるまで評定表に評点がリリースされないため、「合格するまで自動」オプションは匿名送信とは互換性がありません。';
$string['requireallteammemberssubmit'] = 'グループメンバすべての提出を必要とする';
$string['requireallteammemberssubmit_help'] = 'この設定は提出設定の「学生に提出ボタンのクリックを求める」と同時に使用する必要があります。

この設定が有効にされた場合、グループ提出を提出とみなすにはグループメンバ全員が提出ボタンをクリックする必要があります。無効の場合、どのグループメンバでも提出ボタンをクリックできます。';
$string['requiresubmissionstatement'] = '学生に提出同意書の同意を求める';
$string['requiresubmissionstatement_help'] = 'この課題提出すべてにおいて学生に提出同意書の同意を求めます。';
$string['revealidentities'] = '学生の個人情報を公開する';
$string['revealidentitiesconfirm'] = 'この課題に関して本当に学生の個人情報を公開してもよろしいですか? この処理を元に戻すことはできません。学生の個人情報が公開された場合、評定表に評点がリリースされます。';
$string['reverttodefaults'] = '課題デフォルトに戻す';
$string['reverttodraft'] = '提出を下書きステータスに戻す';
$string['reverttodraftforgroup'] = 'グループ {$a} のための提出を下書きに戻します。';
$string['reverttodraftforstudent'] = '学生の提出を下書きに戻す: (id={$a->id}, フルネーム={$a->fullname})';
$string['reverttodraftshort'] = '提出を下書きに戻す';
$string['reviewed'] = 'レビュー済み';
$string['save'] = '保存';
$string['saveallquickgradingchanges'] = 'すべてのクイック評定の変更を保存する';
$string['saveandcontinue'] = '保存して続ける';
$string['savechanges'] = 'この状態で提出する';
$string['savegradingresult'] = '評定';
$string['savenext'] = '保存して次を表示する';
$string['saveoverrideandstay'] = '保存して別のオーバーライドを入力する';
$string['savingchanges'] = '変更の保存 ...';
$string['scale'] = '評価尺度';
$string['search:activity'] = '課題 - 活動情報';
$string['selectedusers'] = '選択済みユーザ';
$string['selectlink'] = '選択 ...';
$string['selectuser'] = '{$a} を選択する';
$string['sendlatenotifications'] = '提出期限後の提出に関して評定者に通知する';
$string['sendlatenotifications_help'] = 'この設定を有効にした場合、学生が課題提出に遅れた時点で評定者 (通常は教師)  にメッセージが送信されます。メッセージ送信方法を設定することができます。';
$string['sendnotifications'] = '評定者に提出を通知する';
$string['sendnotifications_help'] = 'この設定を有効にした場合、学生が課題を早く、時間どおりまたは遅く提出した時点で評定者 (通常教師) にメッセージが送信されます。メッセージ送信方法を設定することができます。';
$string['sendstudentnotifications'] = '学生に通知する';
$string['sendstudentnotifications_help'] = '更新された評点またはフィードバックに関する通知を送信する場合、このチェックボックスをチェックしてください。課題が採点ワークフローを使用している場合、または評点が評定者レポートで隠されている場合、評点が公開されるまで通知は送信されません。';
$string['sendstudentnotificationsdefault'] = '「学生に通知する」のデフォルト設定';
$string['sendstudentnotificationsdefault_help'] = 'それぞれの学生を評定する場合、「学生に通知する」チェックボックスをデフォルトでチェックしますか?';
$string['sendsubmissionreceipts'] = '学生に提出受領書を送信する';
$string['sendsubmissionreceipts_help'] = 'この設定では学生への提出受領書を有効にします。正常に課題が提出された場合、学生は毎回通知を受信します。';
$string['setmarkerallocationforlog'] = '採点者割り当てを設定する: (id={$a->id}, フルネーム={$a->fullname}, 採点者={$a->marker})';
$string['setmarkingallocation'] = '割り当て採点者を設定する';
$string['setmarkingworkflowstate'] = '採点ワークフロー状態を設定する';
$string['setmarkingworkflowstateforlog'] = '採点ワークフロー状態を設定する: (id={$a->id}, フルネーム={$a->fullname}, 状態={$a->state})';
$string['settings'] = '課題設定';
$string['showrecentsubmissions'] = '最近の課題提出を表示する';
$string['status'] = 'ステータス';
$string['studentnotificationworkflowstateerror'] = '学生に通知するにはワークフロー状態を「リリース済み」にする必要があります。';
$string['submission'] = '提出課題';
$string['submissionattachments'] = '提出中のみファイルを表示します。';
$string['submissionattachments_help'] = '提出ページにのみファイルを表示する場合、チェックボックスをチェックしてください。そうでない場合、課題ページおよび提出ページの両方にファイルが表示されます。';
$string['submissioncopiedhtml'] = '<p>あなたは「 {$a->assignment} 」の前回の課題提出をコピーしました。</p>
<p>あなたの<a href="{$a->url}">課題提出</a>に関するステータスを確認できます。</p>';
$string['submissioncopiedsmall'] = 'あなたは「 {$a->assignment} 」の前回の課題提出をコピーしました。';
$string['submissioncopiedtext'] = 'あなたは「 {$a->assignment} 」の前回の課題提出をコピーしました。

あなたの課題提出に関するステータスは以下で確認できます:

{$a->url}';
$string['submissiondrafts'] = '学生に提出ボタンのクリックを求める';
$string['submissiondrafts_help'] = '提出課題の修正を終えて評定準備ができたことを示すために学生に対して提出ボタンを設置すべきですか?';
$string['submissioneditable'] = '学生はこの提出を編集できます。';
$string['submissionempty'] = '提出された課題はありません。';
$string['submissionlog'] = '学生: {$a->fullname} / ステータス: {$a->status}';
$string['submissionmodified'] = 'あなたには既存の提出データがあります。このページを離れて再度お試しください。';
$string['submissionmodifiedgroup'] = '提出が誰かに修正されました。このページを離れて再度お試しください。';
$string['submissionnotcopiedinvalidstatus'] = '再オープン後に編集されたため、提出はコピーされませんでした。';
$string['submissionnoteditable'] = '学生はこの提出を編集できません。';
$string['submissionnotopen'] = 'この課題は提出を受け付けていません。';
$string['submissionnotready'] = 'この課題はまだ提出することができません:';
$string['submissionplugins'] = '提出プラグイン';
$string['submissionreceipthtml'] = '<p>あなたは課題「 {$a->assignment} 」への提出を送信しました。</p>
<p>あなたの<a href="{$a->url}">提出課題</a>のステータスをご覧ください。</p>';
$string['submissionreceiptotherhtml'] = 'あなたの「 {$a->assignment} 」の課題提出が送信されました。<br /><br />あなたの<a href="{$a->url}">課題提出</a>ステータスを確認できます。';
$string['submissionreceiptothersmall'] = 'あなたの「 {$a->assignment} 」の課題提出が送信されました。';
$string['submissionreceiptothertext'] = 'あなたの「 {$a->assignment} 」の課題提出が送信されました。

あなたの課題提出ステータスを確認できます:

{$a->url}';
$string['submissionreceipts'] = '提出受領書を送信する';
$string['submissionreceiptsmall'] = 'あなたは課題「 {$a->assignment} 」への提出を送信しました。';
$string['submissionreceipttext'] = 'あなたは課題「 {$a->assignment} 」への提出を送信しました。

あなたの課題提出ステータスを確認できます:

     {$a->url}';
$string['submissionsclosed'] = '提出は終了しています。';
$string['submissionsettings'] = '提出設定';
$string['submissionslocked'] = 'この課題は提出を受け付けていません。';
$string['submissionslockedshort'] = '提出変更不許可';
$string['submissionstatement'] = '提出同意書';
$string['submissionstatement_help'] = '学生が課題提出に同意する必要のある同意書です。';
$string['submissionstatementacceptedlog'] = 'ユーザ {$a} により同意された提出同意書';
$string['submissionstatementdefault'] = '他の人の作業結果であると私が認めたものを除き、この提出は私自身の作業結果です。';
$string['submissionstatementrequired'] = 'あなたは提出前にこの声明に同意する必要があります。';
$string['submissionstatementteamsubmission'] = 'グループ提出同意書';
$string['submissionstatementteamsubmission_help'] = '学生がグループの作業結果を提出する場合に同意が必要な同意書です。';
$string['submissionstatementteamsubmissionallsubmit'] = 'すべてのグループメンバの提出に関するグループ提出同意書';
$string['submissionstatementteamsubmissionallsubmit_help'] = '学生がグループメンバとして作業結果を提出する場合に同意が必要な同意書です。';
$string['submissionstatementteamsubmissionallsubmitdefault'] = '他の人の作業結果であると私が認めたものを除き、この提出はグループメンバとしての私自身の作業結果です。';
$string['submissionstatementteamsubmissiondefault'] = '他の人の作業結果であると私が認めたものを除き、この提出は私のグループの作業結果です。';
$string['submissionstatus'] = '提出ステータス';
$string['submissionstatus_'] = '提出なし';
$string['submissionstatus_draft'] = '下書き (未提出)';
$string['submissionstatus_marked'] = '評定済み';
$string['submissionstatus_new'] = '提出なし';
$string['submissionstatus_reopened'] = '再オープン';
$string['submissionstatus_submitted'] = '評定のために提出済み';
$string['submissionstatusheading'] = '提出ステータス';
$string['submissionsummary'] = '{$a->status} - 最終更新日時: {$a->timemodified}';
$string['submissionteam'] = 'グループ';
$string['submissiontypes'] = '提出タイプ';
$string['submitaction'] = '提出';
$string['submitassignment'] = '課題を提出する';
$string['submitassignment_help'] = 'この課題を提出した時点であなたはこれ以上変更できないようになります。';
$string['submitforgrading'] = '評定のために送信する';
$string['submitted'] = '提出';
$string['submittedearly'] = '課題は {$a} 早く提出されました。';
$string['submittedlate'] = '課題は {$a} 遅く提出されました。';
$string['submittedlateshort'] = '{$a} 遅く提出';
$string['submittedovertime'] = '課題は制限時間を {$a} 越えて提出されました。';
$string['submittedundertime'] = '課題は制限時間内に {$a} で提出されました。';
$string['subpagetitle'] = '{$a->contextname} - {$a->subpage}';
$string['subplugintype_assignfeedback'] = 'フィードバックプラグイン';
$string['subplugintype_assignfeedback_plural'] = 'フィードバックプラグイン';
$string['subplugintype_assignsubmission'] = '提出プラグイン';
$string['subplugintype_assignsubmission_plural'] = '提出プラグイン';
$string['teamname'] = 'チーム: {$a}';
$string['teamsubmission'] = '学生がグループで提出する';
$string['teamsubmission_help'] = 'この設定を有効にした場合、学生はグループのデフォルト設定またはカスタムグルーピングに基づきチームに分けられます。グループ提出はグループメンバに共有されます。すべてのグループメンバはそれぞれ提出の変更を閲覧することができます。';
$string['teamsubmissiongroupingid'] = '学生グループのグルーピング';
$string['teamsubmissiongroupingid_help'] = 'これは課題が学生グループのグループを探すために使用されるグルーピングです。設定されない場合、一連のデフォルトのグループが使用されます。';
$string['textinstructions'] = '課題インストラクション';
$string['timelimit'] = '制限時間';
$string['timelimit_help'] = 'この設定を有効にした場合、課題ページに制限時間が表示されます。同時に課題中にカウントダウンタイマーが表示されます。';
$string['timelimitnotenabled'] = 'この課題では時間制限は有効にされていません。';
$string['timelimitpassed'] = '制限時間を終了しました。';
$string['timemodified'] = '最終更新日時';
$string['timeremaining'] = '残り時間';
$string['timeremainingcolon'] = '残り時間: {$a}';
$string['togglezoom'] = '範囲のズームイン/ズームアウト';
$string['ungroupedusers'] = '設定「提出にグループを必要とする」が有効にされているため、そして何名かのユーザがグループのメンバではないため、または2つ以上のグループメンバであるため、提出することはできません。';
$string['ungroupedusersoptional'] = '設定「学生がグループで提出する」が有効にされていますが、何名かのユーザはグループに属していないか、2つ以上のグループに属しています。これらの学生が「デフォルトグループ」のメンバとして提出することをご了承ください。';
$string['unlimitedattempts'] = '無制限';
$string['unlimitedattemptsallowed'] = '無制限の提出が許可されました。';
$string['unlimitedpages'] = '無制限';
$string['unlocksubmissionforstudent'] = '学生の提出を許可する: (id={$a->id}, フルネーム={$a->fullname})';
$string['unlocksubmissions'] = '提出をロック解除する';
$string['unsavedchanges'] = '未保存の変更';
$string['unsavedchangesquestion'] = '未保存の評定またはフィードバックの変更があります。変更を保存して続けますか?';
$string['updategrade'] = '評点を更新する';
$string['updatetable'] = '保存してテーブルを更新する';
$string['upgradenotimplemented'] = 'プラグイン ({$a->type} {$a->subtype}) にはアップグレードは実装されていません。';
$string['userassignmentdefaults'] = 'ユーザ課題デフォルト';
$string['userextensiondate'] = '次の日時まで延長が許可されました: {$a}';
$string['usergrade'] = 'ユーザガイド';
$string['useridlistnotcached'] = 'どの提出に対するものか決定できなかったため、評定の変更は保存されませんでした。';
$string['useroverrides'] = 'ユーザオーバーライド';
$string['useroverridesdeleted'] = 'ユーザオーバーライドが削除されました。';
$string['usersnone'] = 'この課題にアクセスできる学生はいません。';
$string['usersubmissioncannotberemoved'] = '{$a} の提出は削除できません。';
$string['userswhoneedtosubmit'] = '提出が必要なユーザ: {$a}';
$string['validmarkingworkflowstates'] = '有効な採点ワークフローステータス';
$string['viewadifferentattempt'] = '異なる提出を表示する';
$string['viewbatchmarkingallocation'] = '採点割り当てページのバッチ設定を表示します。';
$string['viewbatchsetmarkingworkflowstate'] = '採点ワークフローステータスページのバッチ設定を表示します。';
$string['viewfeedback'] = 'フィードバックを表示する';
$string['viewfeedbackforuser'] = 'ユーザのフィードバックを表示する: {$a}';
$string['viewfull'] = '詳細表示';
$string['viewfullgradingpage'] = 'フィードバックを提供するためにフル評定ページを開きました。';
$string['viewgradebook'] = '評定表を表示する';
$string['viewgrading'] = 'すべての提出を表示する';
$string['viewgradingformforstudent'] = '学生の評定ページを閲覧しました: (id={$a->id}, fullname={$a->fullname})。';
$string['viewownsubmissionform'] = '自分の提出課題ページを閲覧しました。';
$string['viewownsubmissionstatus'] = '自分の提出ステータスページを閲覧しました。';
$string['viewrevealidentitiesconfirm'] = '学生の個人情報公開確認ページを表示します。';
$string['viewsubmission'] = '提出を表示する';
$string['viewsubmissionforuser'] = 'ユーザの提出を表示する: {$a}';
$string['viewsubmissiongradingtable'] = '提出に関する評定表を閲覧しました。';
$string['viewsummary'] = '概要表示';
$string['workflowfilter'] = 'ワークフローフィルタ';
$string['xofy'] = '{$a->x} / {$a->y}';
