<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'theme_snap', language 'fr', version '4.4'.
 *
 * @package     theme_snap
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['aboutcourse'] = 'À propos de ce cours';
$string['accesscalendarstring'] = 'Calendrier';
$string['accessforumstringdis'] = 'Options d’affichage';
$string['accessforumstringmov'] = 'Options de déplacement';
$string['accessglobalsearchstring'] = 'Recherche';
$string['action:changeassetvisibility'] = 'modifier la visibilité de la ressource';
$string['action:changesectionvisibility'] = 'modifier la visibilité de la section';
$string['action:duplicateasset'] = 'dupliquer la ressource';
$string['action:highlightsectionvisibility'] = 'mettre en surbrillance la visibilité de la section';
$string['action:sectiontoc'] = 'obtenir la table des matières de la section';
$string['activity'] = 'Activité';
$string['activityrestriction'] = 'Restriction d’activité';
$string['addanewsection'] = 'Créer une nouvelle section';
$string['addresourceoractivity'] = 'Créer une nouvelle activité d’apprentissage';
$string['admineventwarning'] = 'Voir les événements de tous les cours';
$string['advancedbrandingheading'] = 'Image de marque avancée';
$string['ago'] = 'il y a';
$string['alternativelogin'] = 'Afficher les options de connexion alternatives seulement';
$string['alternativeloginfirst'] = 'Afficher les options de connexion alternatives en premier';
$string['alternativeloginoptions'] = 'Options de connexion alternatives';
$string['answered'] = 'Répondu(e)';
$string['appendices'] = 'Outils';
$string['arialabelnewsarticle'] = 'article de presse';
$string['assigndraft'] = 'Le brouillon nécessite votre confirmation';
$string['assignreopened'] = 'Ré-ouvrir';
$string['at'] = 'à';
$string['attempted'] = 'Tenté';
$string['basics'] = 'Fondamentaux';
$string['bothlogin'] = 'Afficher toutes les options de connexion';
$string['brandingheading'] = 'Image de marque';
$string['browse'] = 'Naviguer';
$string['browseallcourses'] = 'Naviguer parmi tous les cours';
$string['cachedef_activity_deadlines'] = 'Mémoire cache pour les délais d’activité d’un utilisateur.';
$string['cachedef_course_card_bg_image'] = 'Mise en cache de l’image d’arrière-plan du cours.';
$string['cachedef_course_card_teacher_avatar'] = 'Mise en cache des avatars des enseignants.';
$string['cachedef_course_card_teacher_avatar_index'] = 'Index de mise en cache des avatars des enseignants.';
$string['cachedef_course_completion_progress'] = 'Ceci est utilisé pour mettre en cache les données d’achèvement par cours / utilisateur.';
$string['cachedef_course_completion_progress_ts'] = 'Ceci est utilisé pour pouvoir invalider les caches au niveau de la session si les paramètres d’achèvement d’un cours ou d’un module changent.';
$string['cachedef_generalstaticappcache'] = 'Niveau de cache général statique Snap de l’application';
$string['cachedef_profile_based_branding'] = 'Mise en cache de la personnalisation basée sur le profil.';
$string['cachedef_webservicedefinitions'] = 'Mise en cache des définitions de service Web générées automatiquement.';
$string['card'] = 'Carte';
$string['category_color'] = 'Couleur de catégorie';
$string['category_color_description'] = 'Couleur de la catégorie de cours. Le cours « Enfant » hérite de la configuration du cours « Parent » le plus proche.';
$string['category_color_palette'] = 'Palette de couleurs';
$string['category_color_palette_description'] = 'Consulter la valeur hexadécimale correspondante pour la couleur donnée. Elle n’affectera pas n’importe quelle configuration, c’est juste un exemple pour aider les utilisateurs à construire la valeur de configuration.';
$string['categoryedit'] = 'Modifier la catégorie';
$string['catinvalidratio'] = 'Les catégories de couleurs suivantes ne sont pas conformes à la
<a href="https://www.w3.org/TR/WCAG20-TECHS/G18.html" target="_blank">Valeur minimale du ratio WCAG 2.0 4.5:1</a> :
Sur la couleur de fond du site (blanc) : "{$a->white}". Face à la couleur de fond de la barre de navigation : "{$a->custombar}". Face à la couleur d’arrière-plan du bouton Mes cours : "{$a->customnav}"';
$string['changecoverimage'] = 'Changer l’image de couverture';
$string['changefullname'] = 'Changer le nom du site';
$string['chapters'] = 'Chapitres';
$string['choosereadme'] = '<div class="clearfix"><div class="theme_screenshot"><h2>Snap</h2><img class=img-polaroid src="snap/pix/screenshot.jpg" /></div></ div>';
$string['classic_template'] = 'Gabarit classique';
$string['close'] = 'Fermer';
$string['comingsoon'] = 'À venir !';
$string['conditional'] = 'Conditionnel';
$string['contents'] = 'Contenu';
$string['contributed'] = 'Contribué';
$string['courseactionslabel'] = 'actions';
$string['courseactivitieslabel'] = 'Activités de la section';
$string['coursecontacts'] = 'Contacts du cours';
$string['coursedisplay'] = 'Affichage du cours';
$string['coursefixydefaulttext'] = 'Vous n’avez actuellement accès à aucun cours. Les cours auquel vous aurez accès seront affichés ici.';
$string['coursefootertoggle'] = 'Pied de page du cours';
$string['coursefootertoggledesc'] = 'Le pied de page du cours affiche des informations utiles aux utilisateurs sur la page du cours tels que les contacts, la description du cours et les activités récentes du cours.';
$string['courseformatnotification'] = 'Le format de cours actuel n’est pas entièrement pris en charge par le thème Snap. Pour une expérience optimale, Open LMS recommande d’utiliser les formats de cours Sujets ou Hebdomadaire avec le thème Snap. Le format du cours peut être modifié dans les <a href="{$a}">paramètres du cours</a>.';
$string['coursegrade'] = 'Note du cours';
$string['coursenavigation'] = 'Navigation du cours';
$string['coursepartialrender'] = 'Activer le chargement lent pour les sessions de cours';
$string['coursepartialrenderdesc'] = 'Si cette option est activée, les sections de cours se chargent à la demande lorsqu’elles sont sélectionnées par un utilisateur. Cela aide les cours avec de grandes quantités de contenu à se charger plus rapidement.';
$string['courses'] = 'Cours';
$string['coursesummaryfilesunsuitable'] = 'Veuillez vider vos fichiers de résumé de cours avant d’essayer de modifier l’image de couverture';
$string['coursetools'] = 'Tableau de bord des cours';
$string['covercarousel'] = 'Carrousel de présentation';
$string['covercarouseldescription'] = '<p>Le carrousel est un ensemble de bannières rotatives, ou un diaporama, qui s’affiche sur la page d’accueil de votre site au lieu de l’image de présentation.</p>
<p>Ajouter jusqu’à 3 images, un titre pour chaque diapositive et un sous-titre facultatif. Les images de 1 200 x 600 pixels fonctionnent mieux.</p>';
$string['covercarousellabel'] = 'Carrousel';
$string['covercarouselon'] = 'Utiliser un carrousel de présentation';
$string['covercarouselpausebutton'] = 'Mettre en pause les diapositives à rotation automatique pour le carrousel.';
$string['covercarouselplaybutton'] = 'Reprendre les diapositives à rotation automatique pour le carrousel.';
$string['covercarouselsronly'] = 'Il s’agit d’un carrousel avec des diapositives à rotation automatique. Activer l’un des boutons pour désactiver la rotation. Utiliser les boutons Suivant et Précédent pour naviguer ou passer à une diapositive à l’aide des points de diapositive.';
$string['coverdisplay'] = 'Affichage de la présentation';
$string['coverimage'] = 'Image de présentation';
$string['covervideo'] = 'Vidéo de présentation';
$string['createsection'] = 'Créer une section';
$string['current'] = 'Courant';
$string['customcss'] = 'CSS personnalisé';
$string['customcssdesc'] = 'Ne pas oublier qu’avec un grand pouvoir vient une grande responsabilité. Tout problème causé par le CSS ajouté ici est de votre responsabilité de le résoudre. Le support Open LMS ne résout pas les problèmes et ne fournit aucune aide concernant le contenu lié aux CSS.';
$string['customisecustommenu'] = 'Modifier la couleur du texte du menu personnalisé';
$string['customisenavbar'] = 'Modifier les couleurs de la barre de navigation';
$string['customisenavbutton'] = 'Modifier les couleurs du bouton Mes cours';
$string['custommenutext'] = 'Couleur du texte du menu personnalisé';
$string['customtopbar'] = 'Barre de navigation';
$string['deadlines'] = 'Délais';
$string['deadlinestoggle'] = 'Délais';
$string['deadlinestoggledesc'] = 'Montrer aux utilisateurs les dates limites des activités à venir des cours inscrits.';
$string['debugerrors'] = 'Erreurs de débogage';
$string['defaultintrosummary'] = 'Bienvenue dans votre nouveau cours {$a}.
<br />Commencez par décrire votre cours en utilisant du texte, des images, de l’audio et des vidéos.';
$string['defaultsummary'] = 'Utilisez cette zone pour décrire le sujet - avec du texte, des images, de l’audio et des vidéos.';
$string['deleteassetconfirm'] = 'Supprimer {$a}';
$string['deletesectionconfirm'] = 'Supprimer la section';
$string['deletingasset'] = 'Suppression de {$a}';
$string['deletingassetname'] = 'Suppression de {$a->type} "{$a->name}"';
$string['deletingsection'] = 'Suppression de la section « {$a} »';
$string['disabled'] = 'Désactivé';
$string['displaydescription'] = 'Description de l’affichage';
$string['displaydescriptionhelp'] = 'Sélectionner pour afficher d’abord une description des activités de ressource dans une nouvelle page. Les étudiants accéderont au contenu à partir de la description.';
$string['draft'] = 'Non publié aux étudiants';
$string['dropzonelabel'] = 'Déposer les fichiers à joindre ou <span class="fake-link">parcourir</span>';
$string['due'] = 'Dû {$a}';
$string['edit'] = 'Modifier « {$a} »';
$string['editcoursecontent'] = 'Modifier les blocs';
$string['editcoursesettings'] = 'Paramètres du cours';
$string['editcoursetopic'] = 'Modifier la section';
$string['editcustomfooter'] = 'Modifier le pied de page';
$string['editcustommenu'] = 'Modifier le menu personnalisé';
$string['editmodetiles'] = 'Modifier le contenu';
$string['enabledlogin'] = 'Options de connexion affichées';
$string['enabledlogindesc'] = 'Sélectionner les options de connexion qui doivent être affichées.';
$string['enabledloginorder'] = 'Ordre des options de connexion';
$string['enabledloginorderdesc'] = 'Sélectionner l’option de connexion à afficher en premier.';
$string['enrolme'] = 'M’inscrire';
$string['error'] = 'Erreur';
$string['error:categorycolorinvalidjson'] = 'Format JSON incorrect pour les catégories de cours';
$string['error:categorycolorinvalidvalue'] = 'L’ID d’enregistrement ou la valeur de couleur pour la catégorie « {$a} » n’est pas valide';
$string['error:categorynotfound'] = 'L’enregistrement de catégorie avec l’identifiant « {$a} » n’a pas été trouvé';
$string['error:coverimageexceedsmaxbytes'] = 'L’image de couverture dépasse la taille de fichier maximale autorisée au niveau du site ({$a})';
$string['error:coverimageresolutionlow'] = 'Pour une meilleure qualité, nous recommandons une image plus grande d’au moins 1024px de largeur.';
$string['error:duplicatedcategoryids'] = 'Format JSON incorrect, certains identifiants sont dupliqués';
$string['error:failedtochangeassetvisibility'] = 'Impossible de masquer / afficher l’élément';
$string['error:failedtochangesectionvisibility'] = 'Impossible de masquer / afficher la section';
$string['error:failedtodeleteasset'] = 'Impossible de supprimer la ressource';
$string['error:failedtoduplicateasset'] = 'Impossible de dupliquer';
$string['error:failedtohighlightsection'] = 'Impossible de mettre en surbrillance la section';
$string['error:failedtotoc'] = 'Impossible d’obtenir la table des matières.';
$string['errorgettingfeed'] = 'Une erreur s’est produite lors de la récupération des éléments de flux.';
$string['extension'] = 'Extension {$a}';
$string['facebook'] = 'Facebook';
$string['facebookdesc'] = 'L’URL de votre page Facebook.';
$string['favicon'] = 'Favicon';
$string['favicondesc'] = 'Les favicons apparaissent dans la barre d’adresse de votre navigateur Web, dans les signets et les raccourcis mobiles d’un utilisateur.';
$string['favorite'] = 'Favori {$a}';
$string['favorited'] = 'Favoris {$a}';
$string['feature_spot_background_color'] = 'Couleur de l’arrière plan';
$string['feature_spot_description_color'] = 'Couleur du texte descriptif';
$string['feature_spot_description_color_lower'] = 'couleur du texte descriptif';
$string['feature_spot_title_color'] = 'Couleur du texte du titre';
$string['feature_spot_title_color_lower'] = 'couleur du texte du titre';
$string['featuredcourseeight'] = 'Cours vedette 8';
$string['featuredcoursefive'] = 'Cours vedette 5';
$string['featuredcoursefour'] = 'Cours vedette 4';
$string['featuredcourseone'] = 'Cours vedette 1';
$string['featuredcourses'] = 'Cours vedettes';
$string['featuredcoursesbrowseall'] = 'Parcourir tous les cours';
$string['featuredcoursesbrowsealldesc'] = 'Ajouter un lien Parcourir tous les cours';
$string['featuredcoursesedit'] = 'Modifier les cours en vedette';
$string['featuredcourseseven'] = 'Cours vedette 7';
$string['featuredcoursesheading'] = 'Titre des cours en vedette';
$string['featuredcourseshelp'] = 'Mettez en surbrillance jusqu’à 8 cours en vedette sur la page d’accueil de votre site. Tapez l’ID du cours pour mettre en avant un cours.';
$string['featuredcoursesix'] = 'Cours vedette 6';
$string['featuredcoursethree'] = 'Cours vedette 3';
$string['featuredcoursetwo'] = 'Cours vedette 2';
$string['featureoneimage'] = 'Image vedette 1';
$string['featureonetext'] = 'Contenu vedette 1';
$string['featureonetitle'] = 'Titre vedette 1';
$string['featureonetitlecb'] = 'Ouvrir dans une nouvelle fenêtre le cours vedette 1';
$string['featureonetitlelink'] = 'Lien du titre vedette 1';
$string['featurespots'] = 'Spots vedettes';
$string['featurespotsedit'] = 'Modifier les spots vedettes';
$string['featurespotsheading'] = 'Titre des spots vedettes';
$string['featurespotshelp'] = '<p>Ajoutez jusqu’à 3 spots vedettes sur la page d’accueil de votre site pour mettre en évidence les principaux avantages pour les utilisateurs actuels et potentiels.</p>
<p>Vous pouvez ajouter une image, un titre et une description du contenu à chaque cours vedette. Pour voir le cours vedette sur la page d’accueil, vous devez entrer un titre. Les sections image et description du contenu sont facultatives.</p>
<p>La taille d’image recommandée est un carré qui ne dépasse pas 200 x 200 px.</p>';
$string['featurethreeimage'] = 'Image vedette 3';
$string['featurethreetext'] = 'Contenu vedette 3';
$string['featurethreetitle'] = 'Titre vedette 3';
$string['featurethreetitlecb'] = 'Ouvrir dans une nouvelle fenêtre le cours vedette 3';
$string['featurethreetitlelink'] = 'Lien du titre vedette 3';
$string['featuretitlecbdesc'] = 'Si activé, le lien ajouté au spot sélectionné sera ouvert dans une nouvelle fenêtre';
$string['featuretitlelinkdesc'] = 'Saisir l’URL à laquelle vous souhaitez lier ce spot. Vous pouvez ajouter des liens externes ou internes à l’intérieur de votre site. Pour ajouter un lien interne, veuillez le copier à partir de l’URL du site, y compris /. Par exemple, pour avoir un lien vers un cours, ce serait "/course/view.php?id=160". Pour ajouter un lien externe, commencez le lien par https://';
$string['featuretwoimage'] = 'Image vedette 2';
$string['featuretwotext'] = 'Contenu vedette 2';
$string['featuretwotitle'] = 'Titre vedette 2';
$string['featuretwotitlecb'] = 'Ouvrir dans une nouvelle fenêtre le cours vedette 2';
$string['featuretwotitlelink'] = 'Lien du titre vedette 2';
$string['feedbackavailable'] = 'Feedback disponible';
$string['feedbacktoggle'] = 'Feedback et notation';
$string['feedbacktoggledesc'] = 'Montrer aux apprenants leurs commentaires les plus récents et aux enseignants les soumissions les plus récentes qui doivent être notées.';
$string['footnote'] = 'Pied de page du site';
$string['footnotedesc'] = 'Votre pied de page s’affiche sur l’ensemble du site. C’est le meilleur endroit pour mettre des liens vers l’aide, le support et tout autre site de votre organisation que vous souhaitez partager avec les apprenants et les enseignants. Par exemple, la bibliothèque ou une adresse e-mail.';
$string['forcepwdwarningpersonalmenu'] = 'Vous devez <a href="{$a}">changer votre mot de passe</a> avant d’utiliser le menu personnel.';
$string['forumauthor'] = 'Auteur';
$string['forumlastpost'] = 'Dernier commentaire';
$string['forumpicturegroup'] = 'Groupe';
$string['forumposts'] = 'Commentaires du forum';
$string['forumpoststoggle'] = 'Commentaires du forum';
$string['forumpoststoggledesc'] = 'Montrer aux utilisateurs les 10 messages de forum les plus récents de leurs cours';
$string['forumreplies'] = 'Réponses';
$string['forumtopic'] = 'Sujet';
$string['fullname'] = 'Nom du site';
$string['fullnamedesc'] = 'Le nom de votre site.';
$string['gotocalendarsnap'] = 'aller au calendrier du site.';
$string['graderadviseuserreport'] = 'Le « rapport d’évaluation » ne fonctionne pas bien sur les appareils mobiles. Le « rapport d’utilisateur » est recommandé à la place';
$string['grading'] = 'Notation';
$string['headingfont'] = 'Police de titre';
$string['headingfont_desc'] = 'Cette police sans empattement est utilisée dans les titres (éléments h1 - h6) de votre site. Si vous incluez une police Web personnalisée, n’oubliez pas de l’ajouter au code HTML supplémentaire de Moodle. Si vous souhaitez modifier les polices d’autres éléments, veuillez utiliser l’option CSS personnalisé, pour des exemples sur la façon de procéder, veuillez consulter ceci <a href="https://help.openlms.net/en/administrator/manage-a-site/snap-font-family-with-custom-css/" target="_blank">documentation</a>.';
$string['help'] = 'Aide';
$string['helpguide'] = 'Manuel d’aide';
$string['helpwithlogin'] = 'Aide à la connexion';
$string['helpwithloginandguest'] = 'Aide à la connexion / accès invité';
$string['hideandshowactioncb'] = 'Masquer et afficher l’action de la case à cocher de l’activité';
$string['highlightedsection'] = 'Surligné';
$string['home'] = 'accueil';
$string['hvpcustomcss'] = 'CSS H5P personnalisé';
$string['hvpcustomcssdesc'] = 'CSS personnalisé pour le module H5P (moodle.org/plugins/mod_hvp) s’il est installé.';
$string['image'] = 'image';
$string['imageinvalidratio'] = 'Cette image pourrait rencontrer des problèmes de contraste en raison de la non-conformité avec la valeur minimale du rapport WCAG 2.0 de 4,5:1. Valeur moyenne des pixels : « {$a} »';
$string['imageinvalidratiocategory'] = 'Cette image pourrait rencontrer des problèmes de contraste avec la couleur du thème en raison du non-respect de la valeur minimale du rapport WCAG 2.0 4,5:1. Valeur moyenne des pixels : « {$a} »';
$string['images'] = 'Images';
$string['instagram'] = 'Instagram';
$string['instagramdesc'] = 'L’URL de votre compte instagram.';
$string['introduction'] = 'Introduction';
$string['invalidratio'] = 'Cette combinaison de couleurs n’est pas conforme à la
<a href="https://www.w3.org/TR/WCAG20-TECHS/G18.html" target="_blank">Valeur minimale du ratio WCAG 2.0 4,5:1</a>. Valeur : "{$a}"';
$string['jsontext'] = 'Texte JSON';
$string['jsontextdescription'] = 'La zone de texte valide le JSON donné, donc seules les catégories existantes sont autorisées,
seules les valeurs numériques en tant qu’enregistrements d’ID (enregistrements de catégorie) sont valides et seules les valeurs hexadécimales sont acceptées en tant que couleurs.
Voici un exemple :<br>
{"1":"#FAAFFF",<br>
"45":"#AFF",<br>
"65":"#FFF228",<br>
"12":"#CC0084",<br>
"56":"#CC0087",<br>
"89":"#CCF084"}';
$string['knowledgebase'] = 'Ouvrir la base de connaissances LMS';
$string['lazyload_mod_page'] = 'Activer le chargement différé par défaut pour les ressources de page';
$string['lazyload_mod_page_description'] = 'S’il est activé, ce paramètre réduit considérablement les temps de chargement des pages de cours pour les cours comportant de nombreuses pages.';
$string['leftnav'] = 'Table des matières';
$string['leftnavdesc'] = 'Sélectionner où afficher la table des matières. La liste donne plus de place au contenu et fonctionne bien pour les cours avec de nombreux sujets.';
$string['linkedin'] = 'LinkedIn';
$string['linkedindesc'] = 'L’URL LinkedIn de votre organisation.';
$string['list'] = 'Liste';
$string['loading'] = 'Chargement…';
$string['loadingfeed'] = 'Chargement… cela peut prendre du temps';
$string['loggedinasguest'] = 'Vous êtes connecté en tant qu’invité';
$string['loggedoutfailmsg'] = 'Vous devez être connecté à {$a}.';
$string['loggedoutmsg'] = 'Vous êtes actuellement déconnecté. Si vous souhaitez continuer à utiliser ce site, veuillez vous reconnecter.';
$string['loggedoutmsgtitle'] = 'Vous êtes déconnecté';
$string['loginbgimg'] = 'Image d’arrière-plan de connexion';
$string['loginbgimgdesc'] = 'Sélectionner les images qui apparaîtront en arrière-plan de la page de connexion. Pour avoir une meilleure expérience avec les images affichées, veuillez télécharger des fichiers avec un format d’image de 16:9 (résolution de 720p ou dimensions de 1280x720 pixels). Les images téléchargées doivent avoir les mêmes dimensions pour une visualisation correcte.';
$string['loginbgimgheading'] = 'Modèle de page de connexion';
$string['loginbgimgheadingdesc'] = 'Snap permet de basculer entre différents modèles à afficher sur la page de connexion. Veuillez choisir entre différentes options dans le menu déroulant ci-dessous.';
$string['loginform'] = 'Connexion';
$string['loginpagetemplate'] = 'Sélectionner le modèle de page de connexion à utiliser';
$string['loginsetting'] = 'Page de connexion';
$string['logo'] = 'Logo';
$string['logodesc'] = 'Votre logo est affiché dans l’en-tête sur l’ensemble du site.';
$string['menu'] = 'Mes cours';
$string['messageread'] = 'Message lu';
$string['messages'] = 'Messages';
$string['messagestoggle'] = 'Messages';
$string['messagestoggledesc'] = 'Montrer aux utilisateurs leurs messages les plus récents reçus au cours des 12 dernières semaines.';
$string['moodlelogin'] = 'Afficher uniquement la connexion Moodle';
$string['moodleloginfirst'] = 'Afficher d’abord la connexion Moodle';
$string['more'] = 'Plus';
$string['morenews'] = 'Plus d’informations';
$string['moreoptionslabel'] = 'Plus d’options';
$string['move'] = 'Déplacer « {$a} »';
$string['movefailed'] = 'Le déplacement a échoué pour « {$a} »';
$string['movehere'] = 'Déplacer ici';
$string['movesection'] = 'Déplacer la section';
$string['moving'] = 'Déplacement de « {$a} »';
$string['movingcount'] = 'Déplacement des objets {$a}';
$string['movingdropsectionhelp'] = 'Placer la section « {$a->moving} » avant la section « {$a->before} »';
$string['movingstartedhelp'] = 'Naviguer jusqu’à l’endroit où placer la section « {$a} »';
$string['multimediacard'] = 'Les fichiers multimédia ne seront pas affichés dans les vues de carte d’activité pour le thème Snap. Ceci sera appliqué dans la page d’accueil et les pages de cours uniquement pour les petites fiches d’activités et de ressources.';
$string['navbarbg'] = 'Couleur de l’arrière plan';
$string['navbarbuttoncolor'] = 'Couleur de l’arrière plan';
$string['navbarbuttonlink'] = 'Couleur du texte';
$string['navbarlink'] = 'Couleur du texte';
$string['nextsection'] = 'Section suivante';
$string['nodeadlines'] = 'Vous n’avez pas d’échéance à venir.';
$string['noforumposts'] = 'Vous n’avez pas de message pertinent sur le forum.';
$string['nograded'] = 'Vous n’avez pas de commentaire récent.';
$string['nograding'] = 'Vous n’avez aucune proposition à noter.';
$string['nomessages'] = 'Vous n’avez aucun message';
$string['notanswered'] = 'Non répondu';
$string['notattempted'] = 'Non tenté';
$string['notcontributed'] = 'Pas de contribution';
$string['notpublished'] = 'Non publié pour les étudiants';
$string['notsubmitted'] = 'Pas déposé';
$string['overdue'] = 'En retard';
$string['pausegraphicsanim'] = 'Pause de l’animation GIF.';
$string['pbb'] = 'Image de marque basée sur le profil';
$string['pbb_description'] = 'En activant la <strong>marque basée sur le profil</strong>, vous pourrez personnaliser l’expérience de marque pour un groupe spécifique d’utilisateurs en fonction du champ de profil utilisateur choisi.
<ul><li>La valeur du champ utilisateur sera <em>slugifiée</em> ; convertir tous les caractères en minuscules et les séparer par un tiret (-)</li>
<li>La chaîne <code>snap-pbb-</code> sera préfixée</li>
<li>Cette classe sera ajoutée à la balise HTML <code>body</code></li></ul>
Par exemple, la valeur du champ utilisateur <em>Blueberry Extravaganza</em> sera modifiée en <code>snap-pbb-blueberry-extravaganza</code><br /><br />
Cette fonctionnalité est utilisée conjointement avec le CSS personnalisé, vous devrez ajouter des sélecteurs CSS en utilisant les nouvelles classes dans la section <a class="snap-settings-tab-link" href="#themesnapbranding">Bases</a> .';
$string['pbb_enable'] = 'Activer la personnalisation basée sur le profil';
$string['pbb_enable_description'] = 'Ajoute uniquement la classe à la balise body si elle est active.';
$string['pbb_field'] = 'Champ utilisateur à utiliser';
$string['pbb_field_description'] = 'La valeur de ce champ sera modifiée et utilisée comme nom de classe CSS précédé de <code>snap-pbb-</code>.';
$string['personalmenu'] = 'Menu personnel';
$string['personalmenufeatures'] = 'Fonctionnalités du menu personnel';
$string['pluginname'] = 'Snap';
$string['poster'] = 'Image de présentation';
$string['posterdesc'] = 'Une grande image d’en-tête pour la page d’accueil de votre site. Les images de paysage (1200 x 600 pixels) ou plus fonctionnent mieux.';
$string['poweredbyrunby'] = 'Construit avec <a href="https://{$a->subdomain}.openlms.net/" target="_blank" rel="noopener">Open LMS</a>,
    un produit basé sur <a href="https://moodle.com/" target="_blank" rel="noopener">Moodle</a>.<br>
    Copyright © {$a->year} Open LMS, tous droits réservés.';
$string['previoussection'] = 'Section précédente';
$string['privacy:metadata:theme_snap_course_favorites'] = 'Enregistre les cours favoris des utilisateurs pour Snap';
$string['privacy:metadata:theme_snap_course_favorites:courseid'] = 'L’ID de cours du cours que l’utilisateur a mis en favori';
$string['privacy:metadata:theme_snap_course_favorites:timefavorited'] = 'L’horodatage du moment où l’utilisateur a mis le cours en favori';
$string['privacy:metadata:theme_snap_course_favorites:userid'] = 'L’ID utilisateur de l’utilisateur qui a ajouté le cours à ses favoris';
$string['problemsfound'] = 'Problèmes trouvés';
$string['progress'] = 'Progrès';
$string['quizattemptswarn'] = 'Exclut les tentatives des utilisateurs suspendus';
$string['quizfeedback'] = 'Commentaire';
$string['readmore'] = 'Lire la suite&nbsp;»';
$string['recentactivity'] = 'Activité récente';
$string['recentfeedback'] = 'Commentaire';
$string['refreshdeadlinestask'] = 'Actualiser les données mises en cache des échéances. Cela devrait être exécuté avant que tous les utilisateurs ne se connectent.';
$string['refreshdeadlinestaskoff'] = 'N’a pas cherché de données à remplir. Veuillez activer le paramètre « Actualiser les échéances à l’aide d’une tâche planifiée » dans les paramètres du menu Personnel de Snap pour permettre à cette tâche de remplir les données mises en cache des échéances.';
$string['region-main'] = 'Principal';
$string['region-side-main-box'] = 'Principal';
$string['region-side-post'] = 'Droite';
$string['region-side-pre'] = 'Gauche';
$string['region-side-top'] = 'En haut';
$string['released'] = 'Publié : {$a}';
$string['reopened'] = 'Rouvert';
$string['resetdeadlinesquerycounttask'] = 'Réinitialiser le nombre de requêtes de délais';
$string['resourcedisplay'] = 'Affichage des ressources';
$string['resourcedisplayhelp'] = 'Sélectionner la façon dont les pièces jointes et les liens apparaissent dans votre cours. Le thème Snap ne prend pas en charge les fichiers multimédias dans la description des petites cartes d’activités et de ressources.';
$string['resumegraphicsanim'] = 'Reprendre l’animation GIF.';
$string['retryfeed'] = 'Ce flux est actuellement indisponible, veuillez revenir plus tard. Flux : {$a}';
$string['search'] = 'Contenu de la recherche';
$string['showallsectionsdisabled'] = 'En raison de son langage de conception, « Afficher toutes les sections sur une page » n’est pas disponible dans Snap.';
$string['showappearancedisabled'] = 'Le langage de conception de Snap empêche les modifications des paramètres « Apparence ».';
$string['sitedescription'] = 'Description du site';
$string['socialmedia'] = 'Réseaux sociaux';
$string['spotinvalidratio'] = 'La couleur de fond n’est pas conforme à la
<a href="https://www.w3.org/TR/WCAG20-TECHS/G18.html" target="_blank">Valeur minimale du ratio WCAG 2.0 4,5:1</a>.
Valeur actuelle par rapport à {$a->name} : {$a->value}.';
$string['stylish_template'] = 'Modèle élégant';
$string['submitted'] = 'Soumis';
$string['subtitle'] = 'Sous-titre';
$string['subtitle_desc'] = 'Décrire brièvement votre site pour les utilisateurs.';
$string['summarylabel'] = 'Résumé de la section';
$string['themecolor'] = 'Couleur du site';
$string['themecolordesc'] = 'Les couleurs vives fonctionnent mieux et donneront à votre site une touche moderne.';
$string['tilesformatcoursehomealttext'] = 'Accueil du cours';
$string['title'] = 'Titre';
$string['togglenavigation'] = 'Basculer la navigation';
$string['top'] = 'En haut';
$string['topbarbgcolor'] = 'Couleur de la barre de navigation';
$string['topbarbuttoncolor'] = 'Arrière-plan de Mes cours';
$string['topbarlinkcolor'] = 'Lien de la barre de navigation et couleur des icônes';
$string['topicactions'] = 'Actions du sujet';
$string['totop'] = 'Aller en haut';
$string['unenrolme'] = 'Me désinscrire';
$string['unread'] = 'non lu';
$string['unsupportedcoverimagetype'] = 'Type d’image de présentation non pris en charge ({$a})';
$string['validratio'] = 'Cette combinaison de couleurs est conforme à la valeur de ratio minimum WCAG 2.0 4.5:1';
$string['viewcalendar'] = 'Afficher mon calendrier';
$string['viewcourse'] = 'Afficher le cours';
$string['viewforumposts'] = 'Afficher mes messages sur le forum';
$string['viewmessaging'] = 'Afficher mes messages';
$string['viewmore'] = 'Afficher plus';
$string['viewmyfeedback'] = 'Afficher mes commentaires';
$string['vieworiginalimage'] = 'Afficher l’image d’origine';
$string['viewyourprofile'] = 'Afficher votre profil';
$string['visibility'] = 'Visibilité';
$string['xofyanswered'] = '{$a->completed} sur {$a->participants} ont répondu';
$string['xofyattempted'] = '{$a->completed} sur {$a->participants} ont effectué une tentative';
$string['xofycontributed'] = '{$a->completed} sur {$a->participants} ont contribué';
$string['xofysubmitted'] = '{$a->terminé} sur {$a->participants} ont rendu quelque chose';
$string['xungraded'] = '{$a} Non noté';
$string['youtube'] = 'YouTube';
$string['youtubedesc'] = 'L’URL de votre chaîne YouTube.';
