<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'theme_degrade', language 'el', version '4.4'.
 *
 * @package     theme_degrade
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['background_color'] = 'Χρώμα φόντου';
$string['background_color_default'] = 'Προεπιλεγμένο Θέμα {$a}';
$string['background_color_desc'] = 'Χρώμα φόντου για το πάνω και το κάτω μέρος!';
$string['background_text_color'] = 'Χρώμα Κειμένου';
$string['background_text_color_desc'] = 'Χρώμα Κειμένου για το πάνω και το κάτω μέρος!';
$string['choosereadme'] = 'Το Degrade είναι ένα θέμα που έχει δημιουργηθεί με φροντίδα για να προσφέρει χαρούμενα χρώματα στο Moodle.';
$string['contact_address'] = 'Διεύθυνση';
$string['contact_email'] = 'Email';
$string['contact_phone'] = 'Αριθμός τηλεφώνου';
$string['content_pagefonts'] = 'Επιπλέον Γραμματοσειρές Google';
$string['content_pagefonts_desc'] = 'Προσθέστε εδώ τον σύνδεσμο @import από την Google για επιπλέον γραμματοσειρές.<br>Μπορείτε να προσθέσετε πολλούς εισαγωγείς.<br><a href="https://fonts.google.com/selection/embed" target="google">Κωδικός Ενσωμάτωσης</a><br><img src="{$a}" style="max-width: 100%;width: 420px;">';
$string['content_type_default'] = 'Προεπιλογή Moodle';
$string['content_type_empty'] = '(Χωρίς περιεχόμενο)';
$string['content_type_footer'] = 'Τύπος περιεχομένου για το υποσέλιδο';
$string['content_type_footer_desc'] = 'Επιλέξτε τον τύπο περιεχομένου που θέλετε να εμφανίσετε στο υποσέλιδο.';
$string['content_type_home'] = 'Τύπος περιεχομένου για την αρχική σελίδα';
$string['content_type_home_desc'] = 'Επιλέξτε τον τύπο περιεχομένου που θέλετε να εμφανίσετε στην αρχική σελίδα.';
$string['content_type_html'] = 'Σελίδα που θα δημιουργηθεί με τον επεξεργαστή';
$string['continuar'] = 'Συνεχίστε να μελετάτε';
$string['countlesson'] = 'Μάθημα {$a}';
$string['countlessons'] = 'Μαθήματα {$a}';
$string['course_access'] = 'Πρόσβαση στο μάθημα';
$string['course_moore'] = 'Περισσότερες λεπτομέρειες';
$string['customcss_desc'] = 'Οποιοι κανόνες CSS προσθέσετε σε αυτήν την περιοχή κειμένου θα εφαρμοστούν σε όλες τις σελίδες, διευκολύνοντας την προσαρμογή του θέματος.';
$string['custommenuitems'] = 'Προσαρμοσμένα Στοιχεία Κορυφαίου Μενού';
$string['custommenuitems_desc'] = 'Μπορείτε να δημιουργήσετε ένα προσαρμοσμένο μενού δίπλα στα κορυφαία μενού. Το κύριο μενού θα πρέπει να ξεκινάει ευθυγραμμισμένο με την άκρη και τα υπομενού να προηγούνται από μια παύλα (-). Ο αριθμός των παυλών καθορίζει το βάθος του στοιχείου. Έτσι, τα στοιχεία με μία παύλα εμφανίζονται σε ένα υπομενού κάτω από το προηγούμενο στοιχείο κορυφαίου επιπέδου, και τα στοιχεία με δύο παύλες εμφανίζονται σε ένα υπομενού κάτω από το προηγούμενο υπομενού.
Το περιεχόμενο κάθε στοιχείου μενού πρέπει να αποτελείται από έως τρία στοιχεία (<strong>ετικέτα</strong> | <strong>διεύθυνση URL</strong> | <strong>υποσημείωση</strong> | <strong>γλώσσα</strong>), το καθένα διαχωρισμένο με τον χαρακτήρα "|".
<ul>
<li><strong>ετικέτα</strong>: Αυτό είναι το κείμενο που θα εμφανίζεται μέσα στο στοιχείο μενού. Πρέπει να καθορίσετε μια ετικέτα για κάθε στοιχείο μενού.</li>
<li><strong>διεύθυνση URL</strong>: Αυτή είναι η διεύθυνση URL στην οποία θα μεταφερθεί ο χρήστης όταν κάνει κλικ στο στοιχείο του μενού. Αυτό είναι προαιρετικό; εάν δεν παρέχεται, το στοιχείο δεν θα συνδεθεί με πουθενά.<br>
Άλλα χαρακτηριστικά όπως το "στόχος" μπορούν να προστεθούν στο τέλος της διεύθυνσης URL.</li>
<li><strong>υποσημείωση</strong>: Εάν παρέχετε μια διεύθυνση URL, μπορείτε επίσης να επιλέξετε να παρέχετε μια υποσημείωση για το σύνδεσμο που δημιουργείται με τη διεύθυνση URL. Αυτό είναι προαιρετικό και, εάν δεν οριστεί, η ετικέτα χρησιμοποιείται ως υποσημείωση για το στοιχείο μενού.</li>
<li><strong>γλώσσα</strong>: Μπορείτε να προσθέσετε έναν κωδικό γλώσσας (ή μια λίστα κωδικών διαχωρισμένων με κόμμα) ως τέταρτο στοιχείο της γραμμής. Η γραμμή θα εμφανίζεται μόνο εάν ο χρήστης έχει επιλέξει τη συγκεκριμένη γλώσσα (ες).</li>
</ul>
Παρακάτω είναι ένα παράδειγμα του τρόπου δημιουργίας ενός προσαρμοσμένου μενού:
<blockquote><pre>
Μαθήματα
-Όλα τα μαθήματα | /course/
-Τα μαθήματά μου
--Παράδειγμα Μαθήματος
---Παράδειγμα Μαθήματος 7 | /course/view.php?id=7
---Παράδειγμα Μαθήματος 9 | /course/view.php?id=9
--Μάθημα Δοκιμής
---Μάθημα Δοκιμής 2 | /course/view.php?id=2
---Μάθημα Δοκιμής 5 | /course/view.php?id=5
Google
-Google σε οποιαδήποτε γλώσσα | https://google.com/" target="_blank
-Google στο Μεξικό | https://www.google.com.mx/" target="_blank|Ετικέτα Google|en
-Google στα Πορτογαλικά | https://google.com.br/" target="_blank|Ετικέτα Google|pt,pt_br,pt_br_kids
Σελίδα Υποστήριξης | https://support.com/" target="_blank
</pre></blockquote>
Για το Moodle με υποστήριξη πολλών γλωσσών, η τιμή <strong>ετικέτα</strong> θα πρέπει να διαμορφώνεται ως <strong>"langstringname,componentname"</strong>.
<blockquote><pre>
προφίλ,moodle | /user/profile.php
μηνύματα,μήνυμα | /message/index.php
</pre></blockquote>
<a href="https://docs.moodle.org/404/en/Advanced_theme_settings" target="_blank">Περισσότερες πληροφορίες μενού</a>';
$string['editor_link_footer'] = 'Επεξεργαστείτε το μπλοκ υποσέλιδου για τη γλώσσα {$a}';
$string['editor_link_footer_all'] = 'Επεξεργαστείτε το μπλοκ υποσέλιδου για όλες τις γλώσσες';
$string['editor_link_home'] = 'Επεξεργαστείτε την αρχική σελίδα για τη γλώσσα {$a}';
$string['editor_link_home_all'] = 'Επεξεργαστείτε την αρχική σελίδα για όλες τις γλώσσες';
$string['favicon'] = 'Αγαπ.εικονίδιο';
$string['favicon_desc'] = 'Το favicon εμφανίζεται δίπλα στον τίτλο της σελίδας στην καρτέλα του προγράμματος περιήγησης. Ένα favicon Moodle εμφανίζεται εάν δεν παρέχεται προσαρμοσμένο favicon.';
$string['fontfamily'] = 'Γραμματοσειρές Κειμένου Ιστοσελίδας';
$string['fontfamily_desc'] = 'Επιλέξτε ποια γραμματοσειρά θέλετε να χρησιμοποιήσετε για το κείμενο στον ιστότοπό σας Moodle.';
$string['fontfamily_menus'] = 'Γραμματοσειρές Μενού';
$string['fontfamily_menus_desc'] = 'Επιλέξτε ποια γραμματοσειρά θέλετε να χρησιμοποιήσετε για τα μενού στον ιστότοπό σας Moodle.';
$string['fontfamily_sitename'] = 'Γραμματοσειρά για το όνομα του ιστότοπου';
$string['fontfamily_sitename_desc'] = 'Η γραμματοσειρά που θα εφαρμοστεί στο όνομα του ιστότοπου εάν δεν παρέχεται λογότυπο.';
$string['fontfamily_title'] = 'Γραμματοσειρές Κειμένων Τίτλων';
$string['fontfamily_title_desc'] = 'Επιλέξτε ποια γραμματοσειρά θέλετε να χρησιμοποιήσετε για τους τίτλους στον ιστότοπό σας Moodle.';
$string['footer_contact_title'] = 'Τίτλος μπλοκ Επικοινωνίας';
$string['footer_contact_title_default'] = 'Επικοινωνήστε μαζί μας';
$string['footer_contact_title_desc'] = 'Εισάγετε τον τίτλο του μπλοκ που θα εμφανίζεται στο υποσέλιδο με τα στοιχεία επικοινωνίας.';
$string['footer_description'] = 'Περιγραφή';
$string['footer_description_desc'] = 'Περιγράψτε το Moodle σας, τι κάνετε, και αυτές οι πληροφορίες θα εμφανίζονται κάτω από το λογότυπο στο υποσέλιδο του Moodle';
$string['footer_frontpage_blockcourses_instructor'] = 'Εμφάνιση ονόματος καθηγητή';
$string['footer_frontpage_blockcourses_instructor_desc'] = 'Αν επιλεγεί, εμφανίζονται τα ονόματα των καθηγητών στη λίστα μαθημάτων!';
$string['footer_frontpage_blockcourses_text'] = 'Σύντομο κείμενο που εξηγεί το μπλοκ "{$a}"';
$string['footer_frontpage_blockcourses_text_desc'] = 'Προσθέστε ένα κείμενο που μιλά για το "{$a}"!';
$string['footer_links_title'] = 'Τίτλος Μπλοκ Συνδέσμων';
$string['footer_links_title_default'] = 'Σημαντικοί Σύνδεσμοι';
$string['footer_show_copywriter'] = 'Εμφάνιση Φτιαγμένο με ❤️';
$string['footer_show_copywriter_desc'] = 'Αποεπιλέξτε αν θέλετε να κρύψετε το "Φτιαγμένο με ❤️"';
$string['footer_social_title'] = 'Τίτλος Μπλοκ Κοινωνικών Συνδέσμων';
$string['footer_social_title_default'] = 'Ακολουθήστε μας στα κοινωνικά δίκτυα';
$string['footer_social_title_desc'] = 'Εισάγετε τον τίτλο του μπλοκ που θα εμφανίζεται στο υποσέλιδο με τα δεδομένα των κοινωνικών σας δικτύων.';
$string['footerblink'] = 'Σύνδεσμοι Μπλοκ Υποσέλιδου';
$string['footerblink_desc'] = 'Μπορείτε να ρυθμίσετε τους Συνδέσμους Μπλοκ Υποσέλιδου εδώ για να εμφανιστούν από τα θέματα.<br>Κάθε γραμμή αποτελείται από κάποιο κείμενο μενού ή κλειδί γλώσσας ή κείμενο, έναν σύνδεσμο URL (προαιρετικό), διαχωρισμένο με κάθετους παύλους. Για παράδειγμα:<br><pre>Μονάδα Υποστήριξης Moodle|https://moodle.org/support</pre>';
$string['footerblock_contact'] = 'Μπλοκ Επαφής';
$string['footerblock_copywriter'] = 'Φτιαγμένο με ❤️';
$string['footerblock_description'] = 'Μπλοκ Περιγραφής';
$string['footerblock_links'] = 'Μπλοκ Συνδέσμων';
$string['footerblock_social'] = 'Μπλοκ Κοινωνικών Συνδέσμων';
$string['free_name'] = 'Δωρεάν';
$string['frontpage_about_description'] = 'Περιγράψτε τι κάνετε';
$string['frontpage_about_description_desc'] = 'Περιγράψτε σε μέγιστο 5 γραμμές τον σκοπό του Moodle σας';
$string['frontpage_about_enable'] = 'Ενεργοποίηση Μπλοκ Σχετικά';
$string['frontpage_about_enable_desc'] = 'Αν επιλεγεί, το Μπλοκ Σχετικά θα εμφανίζεται κάτω από το Μπάνερ!';
$string['frontpage_about_info'] = 'Κουτί δεδομένων {$a}';
$string['frontpage_about_logo_desc'] = 'Αν οριστεί, αυτό το λογότυπο θα χρησιμοποιηθεί εδώ αντί για το Κύριο λογότυπο.<br>
Το κενό χρησιμοποιεί το Κύριο Λογότυπο!';
$string['frontpage_about_number_desc'] = 'Εισάγετε την ποσότητα των πληροφοριών που αναφέρθηκαν παραπάνω';
$string['frontpage_about_text'] = 'Όνομα δεδομένων';
$string['frontpage_about_text_2_defalt'] = 'Δάσκαλοι';
$string['frontpage_about_text_3_defalt'] = 'Σπουδαστές';
$string['frontpage_about_title_default'] = 'Η Παγκόσμια Κοινότητά μας';
$string['heart'] = 'Αν σας αρέσει αυτό το θέμα, μην ξεχάσετε να κάνετε κλικ ❤️ στη σελίδα θεμάτων <a href="{$a}" target="_blank">κάνοντας κλικ εδώ</a>';
$string['login_backgroundcolor_desc'] = 'Επιλέξτε το χρώμα φόντου για τη σελίδα ανάκτησης κωδικού';
$string['login_forgot_description_desc'] = 'Κείμενο που θα εμφανίζεται μόνο στην οθόνη Αλλαγής Κωδικού';
$string['login_signup_description'] = 'Κείμενο στην πλευρά της Οθόνης Δημιουργίας Λογαριασμού';
$string['logo_write'] = 'Λογότυπο κεντρικού μενού κατά την κύλιση';
$string['logo_write_desc'] = 'Φορτώστε το λογότυπό σας αν επιθυμείτε να το συμπεριλάβετε στην κορυφή. Αυτό το λογότυπο θα εμφανίζεται όταν η κύλιση παραμένει στην κορυφή, και το μενού θα εμφανίζεται σε έναν χρωματισμένο φόντο.';
$string['settings_theme_heading'] = 'Θέμα';
$string['vvveb_home_access'] = 'Πρόσβαση στο μάθημα';
$string['vvveb_home_automatically_my_course'] = 'Μην τροποποιείτε. Αυτός ο τομέας θα αντικατασταθεί αυτόματα με τα μαθήματα στα οποία ο μαθητής είναι εγγεγραμμένος.';
$string['vvveb_home_mycourses_heading'] = 'Τα Μαθήματά Μου';
$string['vvveb_home_popular_course'] = 'Δημοφιλείς Μαθήματα';
$string['vvveb_home_team_subtitle'] = 'Είμαστε μια ομάδα επαγγελματιών αφοσιωμένων στη δουλειά τους';
$string['vvveb_home_team_title'] = 'Γνωρίστε την Ομάδα μας';
