<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'url', language 'da', version '4.4'.
 *
 * @package     url
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['allowvariables'] = 'Tillad URL-variabler.';
$string['allowvariables_desc'] = 'Tillad variabler at blive tilføjet til URL\'er. Variabler gør det muligt at overføre intern information, såsom brugerens navn, som en del af URL\'en. Vær opmærksom på potentielle privatlivsrisici ved brug af denne funktion.';
$string['chooseavariable'] = 'Vælg en variabel...';
$string['clicktoopen'] = 'Klik på {$a} for at åbne materialet.';
$string['configdisplayoptions'] = 'Vælg alle muligheder, der skal være tilgængelige, de eksisterende indstillinger ændres ikke. Hold CTRL-tasten nede for at vælge flere felter.';
$string['configframesize'] = 'Når en webside eller en uploadet fil vises i en frame (ramme), angiver denne værdi højden på den øverste frame (som indeholder navigationen).';
$string['configrolesinparams'] = 'Bør tilpassede rollenavne (fra kursusindstillingerne) være tilgængelige som variabler for URL-parametre?';
$string['configsecretphrase'] = 'Denne hemmelige kode bruges til at fremstille krypteret kode, der kan sendes til nogle servere som en parameter. Den krypterede kode er produceret af en md5-værdi på den nuværende brugers IP-adresse sammenkædet med din hemmelige kode, dvs. kode = md5 (IP.secretphrase). Bemærk at dette ikke er pålideligt, fordi IP-adresser kan ændres og ofte deles af forskellige computere.';
$string['contentheader'] = 'Indhold';
$string['createurl'] = 'Opret en URL';
$string['displayoptions'] = 'Tilgængelige visningsmuligheder';
$string['displayselect'] = 'Vis';
$string['displayselect_help'] = 'Denne indstilling styrer - sammen med URL\'ens filtype og hvorvidt browseren tillader indlejring - hvordan URL\'en vises. Mulighederne kan være:

* Automatisk - Den bedste visning af filtypen vælges automatisk
* Indlejret - Filen vises på siden under navigationslinjen sammen med filbeskrivelsen og eventuelle blokke
* Tvungen download - Brugeren skal gemme filen
* Åben - Filen alene vises i browservinduet
* I pop op - Filen vises i et nyt browservindue uden menuer eller adresselinje
* I frame - Filen vises i en "frame" under navigationslinjen og filbeskrivelsen
* Nyt vindue - Filen vises i et nyt browservindue med menuer og adresselinje';
$string['displayselectexplain'] = 'Vælg visningstype - ikke alle typer egner sig til alle URL\'er.';
$string['externalurl'] = 'Ekstern URL';
$string['framesize'] = '"<abbr title="html-kode for ramme">Frame</abbr>"-højde';
$string['indicator:cognitivedepth'] = 'URL-kognitiv.';
$string['indicator:cognitivedepth_help'] = 'Denne indikator er baseret på den kognitive dybde, som studenten har nået i en URL-ressource.';
$string['indicator:cognitivedepthdef'] = 'URL-kognitiv.';
$string['indicator:cognitivedepthdef_help'] = 'Deltageren har nået denne procentdel af den kognitive engagement, der tilbydes af URL-ressourcerne i løbet af dette analyseinterval (Niveauer = Ingen visning, Visning).';
$string['indicator:cognitivedepthdef_link'] = 'Learning_analytics_indicators#Cognitive_depth';
$string['indicator:socialbreadth'] = 'URL-social';
$string['indicator:socialbreadth_help'] = 'Denne indikator er baseret på den sociale bredde, som studenten har nået i en URL-ressource.';
$string['indicator:socialbreadthdef'] = 'URL-social';
$string['indicator:socialbreadthdef_help'] = 'Deltageren har nået denne procentdel af den sociale engagement, der tilbydes af URL-ressourcerne i løbet af dette analyseinterval (Niveauer = Ingen deltagelse, Kun deltager).';
$string['indicator:socialbreadthdef_link'] = 'Learning_analytics_indicators#Social_breadth';
$string['invalidstoredurl'] = 'Kan ikke vise dette materiale, URL\'en er ugyldig.';
$string['invalidurl'] = 'Den angivne URL er ugyldig';
$string['modulename'] = 'URL';
$string['modulename_help'] = 'Med URL-modulet kan en lærer lægge et link som materiale på kurset. Der kan linkes til alt hvad der er frit tilgængeligt online såsom f.eks dokumenter eller grafikfiler, en URL behøver ikke at være adressen på et websted. En URL til en bestemt hjemmeside kan kopieres og indsættes eller en lærer kan bruge filhåndteringen og vælge et link fra et filarkiv såsom Flickr, YouTube eller Wikimedia (afhængig af hvilke arkiver der er tilgængelige fra Moodle).

Der er forskellige visningsmuligheder for en URL, såsom indlejret eller åbning i nyt vindue, og der er avancerede muligheder for at videregive information såsom den studerendes navn til URL\'en hvis det er nødvendigt.

Bemærk at URL\'er også kan tilføjes enhver anden materiale- eller aktivitetsside via teksteditoren.';
$string['modulename_link'] = 'mod/url/view';
$string['modulenameplural'] = 'URL\'er';
$string['name'] = 'Navn';
$string['name_help'] = 'Dette vil fungere som link-teksten for URL\'en.

Indtast en meningsfuld tekst, der kort beskriver URL\'ens formål.

Undgå at bruge ordet "link". Dette vil hjælpe brugere af skærmlæsere, da skærmlæsere annoncerer links (f.eks. "Moodle.org, link"), så det er ikke nødvendigt at inkludere ordet "link" i navnefeltet.';
$string['page-mod-url-x'] = 'Enhver URL-modulside';
$string['parameterinfo'] = '&amp;parameter=variabel';
$string['parametersheader'] = 'URL-variable';
$string['parametersheader_help'] = 'Dette afsnit giver dig mulighed for at sende interne oplysninger som en del af URL\'en. Dette er praktisk, hvis URL\'en er en interaktiv webside, der kræver parametre, og du f.eks. ønsker at videregive navnet på den aktuelle bruger. Indtast navnet på URL-parameteren i tekstfeltet og vælg derefter den tilsvarende webstedsvariabel.';
$string['pluginadministration'] = 'Administration af URL-modul';
$string['pluginname'] = 'URL';
$string['popupheight'] = 'Pop op-højde (i pixel)';
$string['popupheightexplain'] = 'Standardhøjde på pop op\'er';
$string['popupwidth'] = 'Pop op-bredde (i pixel)';
$string['popupwidthexplain'] = 'Standardbredde på pop op\'er';
$string['printintro'] = 'Vis URL-beskrivelse';
$string['printintroexplain'] = 'Vis URL-beskrivelse under indholdet? Nogle visningstyper viser måske ikke beskrivelsen selvom den er aktiveret.';
$string['privacy:metadata'] = 'Plugin\'et URL gemmer ingen personlige data.';
$string['rolesinparams'] = 'Rollenavne som URL-variable';
$string['search:activity'] = 'URL';
$string['serverurl'] = 'Server-URL';
$string['url:addinstance'] = 'Tilføj en ny URL-materiale';
$string['url:view'] = 'Vis URL';
